var tiny = null;

/**
* Create a TinyUrl from the current url
*/
function tinyurl_create_load(){
	window.removeEventListener("load", tinyurl_create_load, true);
	
	if(window.arguments.length > 0 && tiny == null){
		tiny = window.arguments[0];
		
		document.getElementById("cancel-btn").focus();
		
		var loaded = {
			done : function(oTiny){
				try{
					// Set values
					document.getElementById("tinyurl-label").appendChild(document.createTextNode(oTiny.tiny));
					document.getElementById("loading-steps").selectedIndex = 1;
					document.getElementById("cancel-btn").setAttribute("default", false);
					document.getElementById("close1-btn").setAttribute("default", true);
					document.getElementById("close1-btn").focus();
					
					// Copy text
					var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
					clipboard.copyString(oTiny.tiny);
					
					// Auto-hide the window
					var oPrefs 	= Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");				
					if(oPrefs.prefHasUserValue("tinyurl.confirmation.hide") && oPrefs.getBoolPref("tinyurl.confirmation.hide")){
						self.close();
					}
					else{
						window.focus();
					}
				}catch(e){ }
			},
			
			error : function(oTiny){
				document.getElementById("loading-steps").selectedIndex = 2;
				document.getElementById("close2-btn").setAttribute("default", true);
				document.getElementById("close2-btn").focus();
			}
		}
		
		tiny.shrink(loaded);
	}
}

/**
* Cancel url shrinking
*/
function tinyrl_create_cancel(){
	try{
		tiny.abort();
	}catch(e){ }
	self.close();
}

/**
* Open save dialog
*/
function tinyurl_create_openSave(){
	try{
		if(tinyurl_saved_add(tiny.tiny, tiny.original, tiny.title) == true){
			self.close();
		}
	}catch(e){
		alert(e);
	}
}

/**
* Goto the url
*/
function tinyurl_create_goto(){
	if(tiny.tiny == null){
		alert("An error occurred");
	}

	if(opener){
		opener.gBrowser.selectedTab = opener.gBrowser.addTab(tiny.tiny);
	}
	else{
		window.open(tiny.tiny);
	}
	
	self.close();
}