
var oLongUrlField 	= null;
var oTabBox		 	= null;
var oSavedTree	 	= null;
var oSavedTreeItems	= null;
var tinyurl_loaded = false;

function tinyurl_overlayInit(){
	try{
		var oContext = document.getElementById("contentAreaContextMenu");
			oContext.setAttribute("onpopupshowing", "tinyurl_contextShowing(event); "+ oContext.getAttribute("onpopupshowing"));
	} catch(err) { alert(err); }

	// Update all links with preview title attribute
	if(gBrowser && !tinyurl_loaded){

		gBrowser.addEventListener("load", function(){
			var tiny = new TinyUrl();
			var doc = gBrowser.selectedBrowser.contentDocument;
			var anchors = doc.getElementsByTagName("a");
			for(var i = 0; i < anchors.length; i++){
				if(anchors[i].href.indexOf("http://tinyurl.com/") == 0){
					tiny.addPreview(anchors[i]);
				}
			}
		}, true);

		tinyurl_loaded = true;
	}
}

/**
* Load TinyUrl dialog
*/
function tinyurl_load(){
	oLongUrlField 	= document.getElementById("longurl-field");
	oTabBox			= document.getElementById("tinyurl-tabs");
	oSavedTree		= document.getElementById("saved-tree");
	oSavedTreeItems	= document.getElementById("saved-items");

	// Cancel button
	document.getElementById('tinyurlDialog').getButton('cancel').setAttribute("label", "Close");

	// Is RDF Present
	tinyurl_saved_rdfCreate();

	// Load Saved Data
	tinyurl_saved_read();

	// Preload Field
	if(opener.gBrowser && opener.gBrowser.currentURI){
		oLongUrlField.value = opener.gBrowser.currentURI.spec;
	}

	// Goto Save Tab
	if(window.arguments.length > 0 && window.arguments[0] == "saved"){
		oTabBox.selectedTab		= document.getElementById("tinyurl-saved-tab");
		oTabBox.selectedPanel	= document.getElementById("tinyurl-saved-tabpanel");
	}
}

/**
* Create TinyUrl from current page
*/
function tinyurl_createFromCurrent(){
	var tiny = new TinyUrl(gBrowser.currentURI.spec, window._content.document.title);
	window.openDialog('chrome://tinyurl/content/create.xul','TinyUrlCreate','chrome, centerscreen, resizable', tiny);
}

/**
* Creat new Tiny Url from dialog
*/
function tinyurl_createNew(){
	try{

		// If not in main tab
		if(oTabBox.selectedTab.id != "tinyurl-create-tab"){
			return;
		}

		// Validate
		if(oLongUrlField == null || oLongUrlField.value == ""){
			alert("You have not entered a long url");
			return;
		}

		document.getElementById("tinyurl-field").value = "Loading...";

		// Title
		var sTitle = "";
		if(opener && oLongUrlField.value == opener.gBrowser.currentURI.spec){
			sTitle = opener.window._content.document.title;
		}

		// Get TinyUrl
		var tiny = new TinyUrl(oLongUrlField.value, sTitle);

		// Output
		var loaded = {
			done : function(oTiny){
				if(oTiny.tiny != null){
					document.getElementById("tinyurl-field").value = oTiny.tiny;
					document.getElementById("copy-button").disabled = false;
					document.getElementById("save-button").setAttribute("oncommand", "tinyurl_saved_add('"+ oTiny.tiny +"', '"+ oTiny.original +"');");
					document.getElementById("save-button").disabled = false;
					document.getElementById('tinyurlDialogMain').style.cursor = "default";
				}
			},

			error : function(oTiny){
				document.getElementById("tinyurl-field").value = "";
				alert("An error occurred.\nIs your internet connection available?");
			}
		}

		tiny.shrink(loaded);

	}catch(err){ alert("Error 120\nAn unknown error occurred\n"+ err); }
}

/**
* Create TinyUrl from anchor on page
*/
function tinyurl_createFromAnchor(){
	if(gContextMenu != null && (gContextMenu.getLinkURL || gContextMenu.linkURL)){
		var url = (gContextMenu.getLinkURL) ? gContextMenu.getLinkURL() : gContextMenu.linkURL
		var tiny = new TinyUrl(url, null);

		window.openDialog('chrome://tinyurl/content/create.xul','TinyUrlCreate','chrome, centerscreen, resizable', tiny);
	}
}

//Send text to tinyurl_copyText()
function tinyurl_copy(){
	try{
		var oField = document.getElementById("tinyurl-field");

		if(oField == null || oField.value == ""){
			return;
		}

		//Copy
	  	tinyurl_copyText(oField.value);

	}catch(err){ alert("Error 140\nCouldn't copy to clipboard"); }
}

// Comand from key stroke
function tinyurl_copy_command(){
	if(oTabBox.selectedTab.id == "tinyurl-create-tab"){
		tinyurl_copy();
	}
	else if(oTabBox.selectedTab.id == "tinyurl-saved-tab"){
		tinyurl_saved_copy();
	}
}

//Copies str to clipboard
function tinyurl_copyText(str){
	try{
		//Copy
		var oClipboard 	= Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
	  		oClipboard.copyString(str);

	}catch(err){ throw err }
}

// Context Showing
function tinyurl_contextShowing(event){
	try{
		if(document.popupNode.nodeName.toUpperCase() == "A"){
			document.getElementById("tinyurl-context-link-menu").setAttribute("collapsed", false);
		}
		else {
			document.getElementById("tinyurl-context-link-menu").setAttribute("collapsed", true);
		}
	} catch(e) {}
}

//Opens http://tinyurl.com
function tinyurl_gotoTinyUrl(){
	opener.focus();
	self.focus();

	if(opener.gBrowser.addTab)
		opener.gBrowser.selectedTab = opener.gBrowser.addTab("http://tinyurl.com");
	else
		window.open("http://tinyurl.com");
}



/**
* @constructor
*/
function TinyUrl(url, title){

	/**
	* Original url
	* @type string
	*/
	this.original = url;

	/**
	* Shunken url
	* @type string
	*/
	this.tiny = null;

	/**
	* Title of the page from the original url.
	* Used for when the user selects to save the tiny url.
	* @type string
	*/
	this.title = title;

	/**
	* @type XMLHttpRequest
	*/
	this.request = null;


	/**
	* Make the long url tiny
	*/
	this.shrink = function(callback){

		// No need to shrink
		if(this.tiny != null){
			return;
		}

		// Abort current request
		if(this.request != null){
			this.request.abort();
		}

		// Encode URL (can't use encodeURIComponent, because TinyUrl.com will choke)
		var url = this.original;
       	url = url.replace(/\+/g, "%2B");
		url = url.replace(/\?/g, '%3F');
		url = url.replace(/&/g, '%26');
		url = url.replace(/=/g, '%3D');

		// Setup Request
		this.request	= new XMLHttpRequest();
		this.request.open("GET", "http://tinyurl.com/api-create.php?url="+ url, true);
		this.request.setRequestHeader("User-Agent", navigator.userAgent);
		this.request.setRequestHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,video/x-mng,image/png,image/jpeg,image/gif;q=0.2,*/*;q=0.1");
		this.request.setRequestHeader("Accept-Language", navigator.language);
		this.request.setRequestHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
		this.request.setRequestHeader("Referer", "http://tinyurl.com/");
		this.request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

		var obj = this;

		// Handle request
		this.request.onload = {
			handleEvent : function(e){

				// If already aborted
				if(obj.request == null){
					return;
				}

				//Parse Response
				obj.tiny = null;
				var url = obj.request.responseText;
				if(url.length < 200){ // must have returned more than the URL if more than 200
					obj.tiny = url;
				}

				// Notify callback function
				if(obj.tiny == null){
					callback.error(obj);
				}
				else{
					callback.done(obj);
				}
			}
		};

		// Handle Error
		this.request.onerror = {
			handleEvent : function(e){
				callback.error(obj);
			}
		}

       	// Start Request
       	this.request.send("");
	}

	/**
	* Abort TinyUrl shrink request
	*/
	this.abort = function(){
		try{
			this.request.abort();
		}catch(e){  }
	}

	/**
	* Add a the full URL to an link with a TinyURL
	* @param {Anchor} anchor The anchor tag with a TinyURL
	*/
	this.addPreview = function(anchor){

		// Find where it redirects to
		try{

			// Setup request objects
			var io = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
			var uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
			uri.spec = anchor.href;
			var request = io.newChannelFromURI(uri).QueryInterface(Components.interfaces.nsIHttpChannel);

			request.redirectionLimit = 0;
			request.requestMethod = "HEAD";

			// Start request and find redirect location
			request.asyncOpen({
				onStartRequest : function(request, context){ },
				onStopRequest : function(request, context, statusCode){
					var location = request.getResponseHeader("Location");
					anchor.setAttribute("title", location);
				},
				onDataAvailable : function(request, context, inputStream, offset, count){}
			}, null);

		} catch(e){
			e = e;
		}


	}
}
