#ifndef __RCCTL_DEBUG_H__
#define __RCCTL_DEBUG_H__

extern int debug;

/* print debug message if specified level is greater enough */
#define debug(level, fmt, ...)                                         \
    do {                                                                \
        if(debug >= level) {                                            \
            fprintf(stderr, "%s: %s():%4d:  " fmt, __FILE__, __FUNCTION__, (int) __LINE__, ## __VA_ARGS__); \
        }                                                               \
    } while(0);

#define message(level, fmt, ...)                                         \
    do {                                                                \
        if(debug >= level) {                                            \
            fprintf(stderr, fmt, ## __VA_ARGS__); \
        }                                                               \
    } while(0);

#endif
