/* rcctl.c ---------------------------------------------
   $Id: rcctl.c,v 1.1 2002/12/21 01:13:28 tosy Exp $

   v0.10  97.08.15  初期版(コミケット52)
   v0.11  97.08.27  通信タイミング修正
   v0.12  97.09.12  U-kara-2サポート
   v0.12a 97.09.15  返り値設定
   v0.12b 97.09.20  Bug fix (JOY:[SP])
   v0.20  97.10.01  FreeBSD版
   v0.20a 97.10.18  Bug fix (X2k:[SP],[ST])
   v0.21  97.12.10  ALISA-3シーケンス修正
   v0.30  97.12.13  コード変換部(cdcnv.c)分離
   v0.40  02.12.16  USB版対応
   v0.50  11.01.06  libhidを使ってlinux用に書き直し (yaz)
   【cdcnv.c の履歴も参照のこと】
   ------------------------------------------------------*/

#include <stdio.h>
#include <hid.h>
#include <libusb.h>
#include "debug.h"

#ifndef S_VERS
#define S_VERS "0.50"
#endif

/* globals */
HIDInterface *hidif;
int debug = 0;

/* prototypes */
int cdcnv(int buf[], char *mak, char *cod);
extern char *cverrstr[];

int init_usb(void)
{
    hid_return ret;

    /* vendor id and product id of okecon */
    HIDInterfaceMatcher matcher = { 0x0bfe, 0x2022, NULL, NULL, 0 };

    /* see include/debug.h for possible values */
    hid_set_debug(debug);
    hid_set_debug_stream(stderr);
    /* passed directly to libusb */
    hid_set_usb_debug(0);

    ret = hid_init();
    if (ret != HID_RET_SUCCESS) {
        message(0, "hid_init failed with return code %d\n", ret);
        return 1;
    }

    hidif = hid_new_HIDInterface();
    if (hidif == 0) {
        fprintf(stderr, "hid_new_HIDInterface() failed, out of memory?\n");
        return 1;
    }

    ret = hid_force_open(hidif, 0, &matcher, 3);
    if (ret != HID_RET_SUCCESS) {
        message(0, "hid_force_open failed with return code %d\n", ret);
        return 1;
    }

    return 0;
} /* end of init_usb() */


int fin_usb()
{
    hid_return ret;

    ret = hid_close(hidif);
    if (ret != HID_RET_SUCCESS) {
        message(0, "hid_close failed with return code %d\n", ret);
        return 1;
    }

    hid_delete_HIDInterface(&hidif);

    ret = hid_cleanup();
    if (ret != HID_RET_SUCCESS) {
        message(0, "hid_cleanup failed with return code %d\n", ret);
        return 1;
    }

    return 0;
}

void usage(char *cmd)
{
    printf("'Oke-Con' controller, version " S_VERS ".\n");
    printf("Copyright (C) 1997-2002 by Tosy / W341IG.\n");
    printf("Adapted to linux by yaz / honeyplanet development.\n");
    printf("usage: %s <options> <vender> <song number>\n", cmd);
    printf("options: -d <debug level> specify debug message level\n");
    printf("         -h show this help\n");
    exit(0);
}


int main(int argc, char **argv)
{
    int i, u, buf[16];
    unsigned char sbuf[8];
    hid_return ret;
    int opt;

    if(argc < 3) {
        usage(argv[0]);
    }

    while ((opt=getopt(argc, argv, "d:h")) != -1) {
        switch (opt) {
        case 'd':
            debug = atoi(optarg);
            break;
        case 'h':
        default:
            usage(argv[0]);
            break;
        }
    }
    argc -= optind;
    argv += optind;

    if ((u = cdcnv(buf, *argv, *(argv+1))) < 0) {
        fprintf(stderr, "%s: %s\n", *argv, cverrstr[~u]);
        return 1;
    }
    debug(2, "cdcnv %d\n", u);
    debug(1, "Initializing....\n");

    if (init_usb())
        return 255;

    debug(1, "done.\n");

    debug(1, "");
    for(i=0; i<u; i++ ) {
        message(1, "%02x ", buf[i]);
    }
    message(1, "\n");

	const int PATH_IN[1] = { 0xffa10004 };

    /* u is the total length of the packet to send */
    debug(1,"");
    for(i=1; i<u; i++ ) {
        sbuf[(i-1)%8] = buf[i] & 0x00ff;
        message(1, "%02x ", sbuf[(i-1)%8]);
        if ((i == 8)||(i == (u-1))) {
            ret = hid_set_output_report(hidif, PATH_IN, 2, (char *)sbuf, 8);
            message(1, "**WRITE** ");
            if (ret != HID_RET_SUCCESS) {
                message(0, "hid_set_output_report failed with return code %d\n", ret);
            }
        }
    }
    message(1, "\n");

    if(fin_usb())
        return 255;

    return 0;
}
