/* tssplitter_lite.c -- split TS stream.

   Copyright 2009 querulous
   Copyright 2010 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <fcntl.h>
#include <sys/stat.h>
#include "decoder.h"
#include "recpt1.h"
#include "tssplitter_lite.h"

/* prototypes */
static char** AnalyzeSid(char* sid);
static int ReadTs( unsigned char** pat, unsigned char* pids, char** sid_list, unsigned char* pmt_pids, ARIB_STD_B25_BUFFER *sbuf, int* pmt_remain, int* pmt_counter);
static int AnalyzePat(unsigned char* buf, unsigned char** pat, unsigned char* pids, char** sid_list, unsigned char* pmt_pids, int* pmt_remain);
static int RecreatePat(unsigned char* buf, unsigned char** pat, unsigned char* pids, int *pos);
static int AnalyzePmt(unsigned char* buf, unsigned char* pids);
static int GetCrc32(unsigned char* data, int len);
static int GetPid(unsigned char* data);

/**
 * ӥID
 */
static char** AnalyzeSid(
	char* sid)						// [in]		ӥID(޶ڤƥ)
{
	int i = 0;
	char** sid_list = NULL;
	char* p;
	int CommaNum = 0;

	/* sid ϼηΰƤ */
	/* ̵ */
	/* SID[0] */
	/* SID[0],SID[1],...,SID[N-1],SID[N] */

	/*ޤο*/
	p = sid;
	while(*p != '\0')
	{
		if( *p == C_CHAR_COMMA ){
			CommaNum++;
		}
		p++;
	}

	/* sid_listοϥޤο+2(NULLߤ᤹뤫) */
	sid_list = malloc(sizeof(char*)*(CommaNum+2));
	if ( sid_list == NULL )
	{
		fprintf(stderr, "AnalyzeSid() malloc error.\n");
		return NULL;
	}

	/* sidǤ */
	p = sid;
	if ( strlen(p) == 0 )
	{
		sid_list[0] = NULL;
		return sid_list;
	}

	/* ̵ */
	if ( CommaNum == 0 )
	{
		sid_list[0] = sid;
		sid_list[1] = NULL;
		return sid_list;
	}

	/* ޶ڤʣ */
	i=0;
	p = sid;
	/* ʸüã뤫޿ã齪λ */
	while((*p != '\0') || i < CommaNum)
	{
		/* ߤν֤sid_list[i]˥å */
		/* Υߥ󥰤 p 
		 * sidƬ
		 * [,]μʸ
		 * 줫ǤΤ p  sid_list[i] Ƥ褤
		 */
		sid_list[i] = p;
		i++;

		/* ǽ˸[,]NULLʸִ */
		p = strchr(p, C_CHAR_COMMA);
		if ( p == NULL )
		{
			/* ޤĤʤϺǸνоݤʤΤǽλ */
			break;
		}
		*p = '\0';
		/* ֤NULLִʸμΰ֤ꤹ */
		p++;
	}

	/* Ǹsid_list[n]NULLݥ󥿤ǻߤ */
	sid_list[i] = NULL;

	i=0;
	while( sid_list[i] != NULL )
	{
		i++;
	}
#if 0
	for(i=0; sid_list[i] != NULL; i++)
	{
		printf("sid_list[%d]=[%s].\n",i, sid_list[i]);
	}
#endif
	return sid_list;
}

/**
 * 
 */
splitter* split_startup(
	char *sid		// [in]		ӥID(ǻꤷʸ)
)
{
	splitter* sp;
	sp = malloc(sizeof(splitter));
	if ( sp == NULL )
	{
		fprintf(stderr, "split_startup malloc error.\n");
		return NULL;
	}
	memset(sp->pids, 0, sizeof(sp->pids));
	memset(sp->pmt_pids, 0, sizeof(sp->pmt_pids));

	sp->sid_list	= NULL;
	sp->pat			= NULL;
	sp->sid_list	= AnalyzeSid(sid);
	if ( sp->sid_list == NULL )
	{
		free(sp);
		return NULL;
	}
	sp->pat_count	= 0xFF;
	sp->pmt_remain = -1;
	sp->pmt_counter = 0;

	return sp;
}

/**
 * ȤPIDꤵ
 */
int split_select(
	splitter *sp,						// [in/out]		splitter¤
	ARIB_STD_B25_BUFFER *sbuf			// [in]			TS
)
{
	int result;
	// TS
	result = ReadTs(&(sp->pat), sp->pids, sp->sid_list, sp->pmt_pids, sbuf, &(sp->pmt_remain), &(sp->pmt_counter));

	return result;
}

/**
 * λ
 */
void split_shutdown(
	splitter* sp
)
{
	if ( sp != NULL ) {
		if ( sp->pat != NULL )
		{
			free(sp->pat);
			sp->pat = NULL;
		}
		if ( sp->sid_list != NULL )
		{
			free(sp->sid_list);
			sp->sid_list = NULL;
		}
		free(sp);
		sp = NULL;
	}
}

/**
 * TS Ͻ
 *
 * оݤΥֹͥΤߤ PAT κƹۤȽо PID ФԤ
 */
static int ReadTs(
	unsigned char** pat,				// [out]	PAT ʺƹ۸
	unsigned char* pids,				// [out]	о PID 
	char** sid_list,					// [in]		оݥӥ ID Υꥹ
	unsigned char* pmt_pids,			// [in]		оPIDPMT PID
	ARIB_STD_B25_BUFFER *sbuf,			// [in]		pt1_drvTS
	int* pmt_remain,						// [in]		PMTȤ٤
	int* pmt_counter					// [out]	PMTȤ
)
{
	int length = sbuf->size;
	int pid;
	int result = TSS_ERROR;
	int index;

	index = 0;
	while (((length - index - LENGTH_PACKET)) > 0)
	{
		pid = GetPid(((unsigned char*)sbuf->data)+index+1);
		// PAT
		if (0x0000 == pid)
		{
			result = AnalyzePat(((unsigned char*)sbuf->data)+index, pat, pids, sid_list, pmt_pids, pmt_remain);
			if (TSS_SUCCESS != result)
			{
				/* ̤δؿmalloc errorȯ */
				return result;
			}
		}

		// PMT
		/* Ĥpmt_pidǤˤϡpmt˽񤫤Ƥ
		 * Ĥ٤PCR/AUDIO/VIDEO PID */
		if (pmt_pids[pid] == 1)
		{
//			fprintf(stderr, "\npmt_pid=%d\n", pid);
			/* ˤPMT˰٤ʤ褦ˤƤ */
			AnalyzePmt(((unsigned char*)sbuf->data)+index, pids);
			pmt_pids[pid]++;
			*pmt_counter += 1;
		}
		/* Ͽ褹ƤPMTˤĤơˤPCR/AUDIO/VIDEOPID
		 *  */
		/* pmt_counter  pmt_remain פ˾ */
		if ((*pmt_counter == *pmt_remain)) {
			result = TSS_SUCCESS;
			break;
		}
		else {
			result = TSS_ERROR;
		}
		index += LENGTH_PACKET;
	}

	return(result);
}

/**
 * TS ʬΥ
 */
int split_ts(
	splitter *splitter,					// [in]		splitterѥ᡼
	ARIB_STD_B25_BUFFER *sbuf,			// [in]		TS
	splitbuf_t *dbuf							// [out]	TS
)
{
	int pid;
	unsigned char *sptr, *dptr;
	int s_offset = 0;
	int d_offset = 0;

	/*  */
	dbuf->size = 0;
	if (sbuf->size < 0) {
		return TSS_ERROR;
	}

	sptr = sbuf->data;
	dptr = dbuf->buffer;

	while(sbuf->size > s_offset) {
		pid = GetPid(sptr + s_offset + 1);
        switch(pid) {

		// PAT
		case 0x0000:
			// 󥫥󥿥ȥå
			if(0xFF == splitter->pat_count) {
				splitter->pat_count = splitter->pat[3];
			}
			else {
				splitter->pat_count = (splitter->pat_count + 1) % 16;
			}
			splitter->pat[3] = splitter->pat_count;

			memcpy(dptr + d_offset, splitter->pat, LENGTH_PACKET);
			d_offset += LENGTH_PACKET;
			dbuf->size += LENGTH_PACKET;
			break;
		default:
			/* pids[pid]  1 ϻĤѥåȤʤΤǽ񤭹 */
			if(1 == splitter->pids[pid]) {
				memcpy(dptr + d_offset, sptr + s_offset, LENGTH_PACKET);
				d_offset += LENGTH_PACKET;
				dbuf->size += LENGTH_PACKET;
			}
			break;
		} /* switch */

		s_offset += LENGTH_PACKET;
	}

	return(TSS_SUCCESS);
}

/**
 * PAT Ͻ
 *
 * PAT Ϥоݥͥ뤬ޤޤƤ뤫åԤPAT ƹۤ
 */
static int AnalyzePat(
	unsigned char* buf,					// [in]		ɤ߹Хåե
	unsigned char** pat,				// [out]	PAT ʺƹ۸
	unsigned char* pids,				// [out]	о PID 
	char** sid_list,					// [in]		оݥӥ ID Υꥹ
	unsigned char* pmt_pids,			// [out]	ӥ ID б PMT  PID
	int* pmt_remain
)						// [out]	ȤPMTο
{
	int pos[MAX_PID];
	int service_id;
	int i, j=0, k;
	int size = 0;
	int pid;
	int result = TSS_SUCCESS;
	char **p;
	int sid_found;
	int avail_sids[MAX_SERVICES];

	if(*pat == NULL) {
		/*  */
		*pmt_remain = 0;
		memset(pos, 0, sizeof(pos));
		size = buf[7];

		// оݥͥȽ
		/* size + 8 = ѥåĹ */
		/* ǽ 4 ХȤCRCʤΤФ */
		for(i = 17; i < (size + 8) - 4; i = i + 4) {

			sid_found = 0;
			service_id = (buf[i] << 8) + buf[i + 1];
			avail_sids[j] = service_id;
			p = sid_list;

			while(*p) {
				if(service_id == atoi(*p)) {
					/* Ͽо = ȤоݤȤϤʤΤʤΤǡŪ˲⤷ʤ */
					/* Ͽоݤ pmt_pids  1 Ȥ */
					/* Ͽоݤ pmt  pids  1 Ȥ */
					pid = GetPid(&buf[i + 2]);
					*(pmt_pids+pid) = 1;
					*(pids+pid) = 1;
					pos[pid] = i;
					sid_found = 1;
					*pmt_remain += 1;
//					fprintf(stderr, "sid=%d pid=%d\n", service_id, pid);
					break;
				}
				else if(strstr(*p, "all")) {
					/* allˤ¸ */
					pid = GetPid(&buf[i + 2]);
					*(pmt_pids+pid) = 1;
					*(pids+pid) = 1;
					pos[pid] = i;
					sid_found = 1;
					*pmt_remain += 1;
//					fprintf(stderr, "sid=%d pid=%d\n", service_id, pid);
					break;
				}

				p++;
			} /* while */

			j++;
		}

		/* print SIDs */
		fprintf(stderr, "Available sid = ");
		for(k=0; k<j; k++)
			fprintf(stderr, "%d ", avail_sids[k]);
		fprintf(stderr, "\n");

		fprintf(stderr, "Chosen sid    = ");
		p = sid_list;
		while(*p != NULL) {
			fprintf(stderr, "%s ", *p);
			p++;
		}
		fprintf(stderr, "\n");

		// PAT ƹ
		result = RecreatePat(buf, pat, pids, pos);
#if 0
		int tc;
		for(tc=0; tc<188; tc++)
			fprintf(stderr, "%02x ", *(*pat+tc));
#endif
	}

	return(result);
}

/**
 * PAT ƹ۽
 *
 * PMT оݥͥʳΥͥPAT ƹۤ
 */
static int RecreatePat(
	unsigned char* buf,					// [in]		ɤ߹Хåե
	unsigned char** pat,				// [out]	PAT ʺƹ۸
	unsigned char* pids,				// [out]	о PID 
	int *pos)							// [in]		о PMT ΥХåեΰ
{
	unsigned char y[LENGTH_CRC_DATA];
	int crc;
	int i;
	int j;
	int pos_i;
	int pid_num = 0;

	// CRC ׻ΤΥǡ
	{
		// ͥˤäѤʤʬ
		for (i = 0; i < LENGTH_PAT_HEADER; i++)
		{
			y[i] = buf[i + 5];
		}
		// ͥˤäѤʬ
		for (i = 0; i < MAX_PID; i++)
		{
			if(pos[i] != 0)
			{
				/* buf[pos_i]  y ˥ԡ(ФPIDο) */
				pos_i = pos[i];
				for (j = 0; j < 4; j++)
				{
					y[LENGTH_PAT_HEADER + ((4*pid_num) + j)] = buf[pos_i + j];
				}
				pid_num++;
			}
		}
	}
	/* ѥåȥ׻ */
	y[2] = pid_num * 4 + 0x0d;
	// CRC ׻
	crc = GetCrc32(y, LENGTH_PAT_HEADER + pid_num*4);

	// PAT ƹ
	*pat = (unsigned char*)malloc(LENGTH_PACKET);
	if ( *pat == NULL )
	{
		fprintf(stderr, "RecreatePat() malloc error.\n");
		return(TSS_NULL);
	}
	memset(*pat, 0xFF, LENGTH_PACKET);
	for (i = 0; i < 5; i++)
	{
		(*pat)[i] = buf[i];
	}
	for (i = 0; i < LENGTH_PAT_HEADER + pid_num*4; i++)
	{
		(*pat)[i + 5] = y[i];
	}
	(*pat)[5 + LENGTH_PAT_HEADER + pid_num*4] = (crc >> 24) & 0xFF;
	(*pat)[6 + LENGTH_PAT_HEADER + pid_num*4] = (crc >> 16) & 0xFF;
	(*pat)[7 + LENGTH_PAT_HEADER + pid_num*4] = (crc >>  8) & 0xFF;
	(*pat)[8 + LENGTH_PAT_HEADER + pid_num*4] = (crc      ) & 0xFF;
	return(TSS_SUCCESS);
}

/**
 * PMT Ͻ
 *
 * PMT Ϥ¸оݤ PID ꤹ
 */
static int AnalyzePmt(
	unsigned char* buf,					// [in]		ɤ߹Хåե
	unsigned char* pids)				// [out]	о PID 
{
	unsigned char Nall;
	unsigned char N;
	int pcr;
	int epid;

	Nall = ((buf[6] & 0x0F) << 4) + buf[7];

	// PCR
	pcr = GetPid(&buf[13]);
	pids[pcr] = 1;
//    fprintf(stderr, "pcr_pid:%5d", pcr);

	N = ((buf[15] & 0x0F) << 4) + buf[16] + 16 + 1;

	// ES PID
	while (N < Nall + 8 - 4)
	{
		// ȥ꡼̤ 0x0Dtype DˤϽоݳ
		if (0x0D != buf[N])
		{
			epid = GetPid(&buf[N + 1]);

			pids[epid] = 1;
//			fprintf(stderr, "%10d", epid);
		}
		N += 4 + (((buf[N + 3]) & 0x0F) << 4) + buf[N + 4] + 1;
	}

	return TSS_SUCCESS;
}

/**
 * CRC ׻
 */
static int GetCrc32(
	unsigned char* data,				// [in]		CRC ׻оݥǡ
	int len)							// [in]		CRC ׻оݥǡĹ
{
	int crc;
	int i, j;
	int c;
	int bit;

	crc = 0xFFFFFFFF;
	for (i = 0; i < len; i++)
	{
		char x;
		x = data[i];

		for (j = 0; j < 8; j++)
		{

			bit = (x >> (7 - j)) & 0x1;

			c = 0;
			if (crc & 0x80000000)
			{
				c = 1;
			}

			crc = crc << 1;

			if (c ^ bit)
			{
				crc ^= 0x04C11DB7;
			}

			crc &= 0xFFFFFFFF;
		}
	}

	return crc;
}

/**
 * PID 
 */
static int GetPid(
	unsigned char* data)				// [in]		оݥǡΥݥ
{
	return ((data[0] & 0x1F) << 8) + data[1];
}
