#!/bin/bash
# channelscan_pt1.sh -- Scan channel info by TS.
#
#   Copyright 2012 Naoya OYAMA <naoya.oyama@gmail.com>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

TMP="/var/tmp"
ISDBT_Time="16"
BS_Time="60"
CS_Time="60"

ISDBT_Info=~/.recpt1_ISDB
BS_Info=~/.recpt1_BS
CS_Info=~/.recpt1_CS

for i in ${ISDBT_Info} ${BS_Info} ${CS_Info}; do
	test -e "${i}" && rm -f "${i}"
done

echo "Start ISDB-T scan."
for i in `seq 13 62` ; do
	TSFILE="${TMP}/$i.ts"
	XMLFILE="${TMP}/$i.xml"
	recpt1 $i ${ISDBT_Time} "${TSFILE}" >/dev/null 2>&1
	epgdump $i "${TSFILE}" "${XMLFILE}"
	if [ -e "${XMLFILE}" ] ;  then
		epgdump_xml_parse.pl "${XMLFILE}" >> ${ISDBT_Info} 2>/dev/null
		rm -f "${TSFILE}" "${XMLFILE}"
	else
		rm -f "${TSFILE}"
	fi
done

echo "start BS scan."
TSFILE="${TMP}/BS.ts"
XMLFILE="${TMP}/BS.xml"
recpt1 101 ${BS_Time} "${TSFILE}" >/dev/null 2>&1
epgdump /BS "${TSFILE}" "${XMLFILE}"
if [ -e "${XMLFILE}" ] ;  then
	epgdump_xml_parse.pl "${XMLFILE}" > ${BS_Info} 2>/dev/null
	rm -f "${TSFILE}" "${XMLFILE}"
else
	rm -f "${TSFILE}"
fi

echo "start CS scan."
for i in `seq 1 12` ; do
	i=$((i*2));
	TSFILE="${TMP}/CS.ts"
	XMLFILE="${TMP}/CS.xml"
	recpt1 CS$i ${CS_Time} "${TSFILE}" > /dev/null 2>&1
	epgdump /CS "${TSFILE}" "${XMLFILE}"
	if [ -e "${XMLFILE}" ] ;  then
		epgdump_xml_parse.pl "${XMLFILE}" >> ${CS_Info} 2>/dev/null
		rm -f "${TSFILE}" "${XMLFILE}"
	else
		rm -f "${TSFILE}"
	fi
done
if [ -e ${CS_Info} ] ; then
	sort -n ${CS_Info} | uniq > ${CS_Info}.tmp
	mv -f ${CS_Info}.tmp ${CS_Info}
fi

test -e ~/.recpt1-channels && mv ~/.recpt1-channels ~/.recpt1-channels_`date +%Y%m%d%H%M%S`
if [ -e ${ISDB_Info} ] ; then
echo ---------------------ISDB-T------------------------ >  ~/.recpt1-channels
echo SID,channel,name                                    >> ~/.recpt1-channels
cat ${ISDBT_Info}                                        >> ~/.recpt1-channels
fi
if [ -e ${BS_Info} ] ; then
echo -----------------------BS-------------------------- >> ~/.recpt1-channels
echo SID,channel,name                                    >> ~/.recpt1-channels
cat ${BS_Info}                                           >> ~/.recpt1-channels
fi
if [ -e ${CS_Info} ] ; then
echo -----------------------CS-------------------------- >> ~/.recpt1-channels
echo SID,channel,name                                    >> ~/.recpt1-channels
cat ${CS_Info}                                           >> ~/.recpt1-channels
fi
