/* pt1_common.h  -- This file is part of recpt1.

   Copyright 2012 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifndef _RECPT1_COMMON_H_
#define _RECPT1_COMMON_H_

#include "pt1_dev.h"
#include "recpt1.h"

/* ipc message size */
#define MSGSZ     255
#define ISDB_T_NODE_LIMIT 24        // 32:ARIB limit 24:program maximum
#define ISDB_T_SLOT_LIMIT 8
#define MAX_RETRY (2)

typedef struct pt1_msgbuf {
    long    mtype;
    char    mtext[MSGSZ];
} pt1_message_buf;

//prototaype
int tune(char *channel, thread_data *tdata, char *device);
int close_tuner(thread_data *tdata);
void show_channels(void);
ISDB_T_FREQ_CONV_TABLE *searchrecoff(char *channel);
void calc_cn(int fd, int type, boolean use_bell);
int tune(char *channel, thread_data *tdata, char *device);
int close_tuner(thread_data *tdata);
uint16_t get_device_id_by_name(char *device_name);

#endif
