/* pt1_common.c  -- This file is part of recpt1.

   Copyright 2012 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <pt1_ioctl.h>
#include "recpt1.h"
#include "pt1_dev.h"
#include "pt1_common.h"

// Ѵơ֥(ISDB-T)
// ºݤioctl()ԤͤʬREADME򻲾Ȥλ
// BS/CSͤӥåֹ
// http://www5e.biglobe.ne.jp/~kazu_f/digital-sat/index.html
//

ISDB_T_FREQ_CONV_TABLE    isdb_t_conv_table[] = {
    {   0, CHTYPE_SATELLITE, 0, "151"},  /* 151chBSī */
    {   0, CHTYPE_SATELLITE, 1, "161"},  /* 161chBS-TBS */
    {   1, CHTYPE_SATELLITE, 0, "191"},  /* 191chWOWOW prime */
    {   1, CHTYPE_SATELLITE, 1, "171"},  /* 171chBSѥ */
    {   2, CHTYPE_SATELLITE, 0, "192"},  /* 192chWOWOW饤 */
    {   2, CHTYPE_SATELLITE, 1, "193"},  /* 193chWOWOWͥ */
    {   3, CHTYPE_SATELLITE, 0, "201"},  /* 201chͥ2 */
    {   3, CHTYPE_SATELLITE, 0, "202"},  /* 202chͥ3 */
    {   3, CHTYPE_SATELLITE, 1, "236"},  /* 236chBS˥ޥå */
    {   3, CHTYPE_SATELLITE, 2, "256"},  /* 256chǥˡͥ */
    {   4, CHTYPE_SATELLITE, 0, "211"},  /* 211chBS11ǥ */
    {   4, CHTYPE_SATELLITE, 1, "200"},  /* 200chͥ1 */
    {   4, CHTYPE_SATELLITE, 2, "222"},  /* 222chTwellV */
    {   5, CHTYPE_SATELLITE, 0, "238"},  /* 238chFOX bs238 */
    {   5, CHTYPE_SATELLITE, 1, "241"},  /* 241chBSѡ */
    {   5, CHTYPE_SATELLITE, 2, "231"},  /* 231chإƥ1 */
    {   5, CHTYPE_SATELLITE, 2, "232"},  /* 232chإƥ2 */
    {   5, CHTYPE_SATELLITE, 2, "233"},  /* 233chإƥ3 */
    {   5, CHTYPE_SATELLITE, 2, "531"},  /* 531chإ饸 */
    {   6, CHTYPE_SATELLITE, 0, "141"},  /* 141chBSƥ */
    {   6, CHTYPE_SATELLITE, 1, "181"},  /* 181chBSե */
    {   7, CHTYPE_SATELLITE, 0, "101"},  /* 101chNHK-BS1 */
    {   7, CHTYPE_SATELLITE, 0, "102"},  /* 102chNHK-BS1׻ */
    {   7, CHTYPE_SATELLITE, 1, "103"},  /* 103chNHK-BSץߥ*/
    {   7, CHTYPE_SATELLITE, 1, "910"},  /* 910ch˥塼(WNI)*/
    {   8, CHTYPE_SATELLITE, 2, "291"},  /* 291chNHKƥӥ*/
    {   8, CHTYPE_SATELLITE, 2, "292"},  /* 292chNHKƥӥ*/
    {   8, CHTYPE_SATELLITE, 1, "294"},  /* 294chܥƥ */
    {   8, CHTYPE_SATELLITE, 1, "295"},  /* 295chƥī */
    {   8, CHTYPE_SATELLITE, 1, "296"},  /* 296chTBSƥ */
    {   8, CHTYPE_SATELLITE, 1, "297"},  /* 297chƥ */
    {   8, CHTYPE_SATELLITE, 2, "298"},  /* 298chեƥ */
    {   9, CHTYPE_SATELLITE, 0, "234"},  /* 234ch꡼ͥ */
    {   9, CHTYPE_SATELLITE, 1, "242"},  /* 242chJ SPORTS 1 */
    {   9, CHTYPE_SATELLITE, 2, "243"},  /* 243chJ SPORTS 2 */
    {  10, CHTYPE_SATELLITE, 0, "252"},  /* 252chIMAGICA BS */
    {  10, CHTYPE_SATELLITE, 1, "244"},  /* 244chJ SPORTS 3 */
    {  10, CHTYPE_SATELLITE, 2, "245"},  /* 245chJ SPORTS 4 */
    {  11, CHTYPE_SATELLITE, 0, "251"},  /* 251chBSӥ */
    {  11, CHTYPE_SATELLITE, 1, "255"},  /* 255chܱǲͥ */
    {  11, CHTYPE_SATELLITE, 2, "258"},  /* 258chD-Life */
    {  12, CHTYPE_SATELLITE, 0, "CS2"},  /* ND2
                                          * 237chͥ ץ饹
                                          * 239chܱǲͥHD
                                          * 306chեƥNEXT */
    {  13, CHTYPE_SATELLITE, 0, "CS4"},  /* ND4
                                          * 100che2ץ
                                          * 256chJ sports ESPN
                                          * 312chFOX
                                          * 322chڡTV
                                          * 331chȥͥåȥ
                                          * 294chۡɥޥͥ
                                          * 334chȥ󡦥ǥˡ */
    {  14, CHTYPE_SATELLITE, 0, "CS6"},  /* ND6
                                          * 221chǥͥ
                                          * 222ch
                                          * 223chͥNECO
                                          * 224chβͥե롦ޥ
                                          * 292chͥ
                                          * 238chͥ 饷å
                                          * 310chѡɥTV
                                          * 311chAXN
                                          * 250chAsports */
    {  15, CHTYPE_SATELLITE, 0, "CS8"},  /* ND8
                                          * 055chå ͥ
                                          * 335chåơHD */
    {  16, CHTYPE_SATELLITE, 0, "CS10"}, /* ND10
                                          * 228chͥ
                                          * 800chHD800
                                          * 801ch801
                                          * 802ch802 */
    {  17, CHTYPE_SATELLITE, 0, "CS12"}, /* ND12
                                          * 260chաͥ
                                          * 303chƥīͥ
                                          * 323chMTV 324chͤβTVߥ塼å
                                          * 352chī˥塼
                                          * 353chBBCɥ˥塼
                                          * 354chCNNj
                                          * 110chƥݡ */
    {  18, CHTYPE_SATELLITE, 0, "CS14"}, /* ND14
                                          * 251chJ sports 1
                                          * 252chJ sports 2
                                          * 253chJ sports Plus
                                          * 254chGAORA */
    {  19, CHTYPE_SATELLITE, 0, "CS16"}, /* ND16
                                          * 305chͥ
                                          * 333ch˥᥷X(AT-X)
                                          * 342chҥȥ꡼ͥ
                                          * 290chTAKARAZUKA SKYSTAGE
                                          * 803ch803
                                          * 804ch804 */
    {  20, CHTYPE_SATELLITE, 0, "CS18"}, /* ND18
                                          * 240chࡼӡץ饹HD
                                          * 262chեͥåȥ
                                          * 314chLaLa HDHV */
    {  21, CHTYPE_SATELLITE, 0, "CS20"}, /* ND20
                                          * 258chեƥONE
                                          * 302chեƥTWO
                                          * 332ch˥ޥå
                                          * 340chǥХ꡼ͥ
                                          * 341ch˥ޥץͥå */
    {  22, CHTYPE_SATELLITE, 0, "CS22"}, /* ND22
                                          * 160chC-TBS륫ͥ
                                          * 161chQVC
                                          * 185chץ饤365.TV
                                          * 293chեߥ꡼
                                          * 301chTBSͥ
                                          * 304chǥˡͥ
                                          * 325chMUSIC ON! TV
                                          * 351chTBS˥塼С
                                          * 343chʥʥ른եåͥ */
    {  23, CHTYPE_SATELLITE, 0, "CS24"}, /* ND24
                                          * 257chƥG+ HD
                                          * 291chfashiontv
                                          * 300chƥץ饹
                                          * 315chFOXץ饹
                                          * 321chMusicJapan TV
                                          * 350chƥNEWS24
                                          * 362chιͥ */
    {   0, CHTYPE_GROUND, 0,   "1"}, {   1, CHTYPE_GROUND, 0,   "2"},
    {   2, CHTYPE_GROUND, 0,   "3"}, {   3, CHTYPE_GROUND, 0, "C13"},
    {   4, CHTYPE_GROUND, 0, "C14"}, {   5, CHTYPE_GROUND, 0, "C15"},
    {   6, CHTYPE_GROUND, 0, "C16"}, {   7, CHTYPE_GROUND, 0, "C17"},
    {   8, CHTYPE_GROUND, 0, "C18"}, {   9, CHTYPE_GROUND, 0, "C19"},
    {  10, CHTYPE_GROUND, 0, "C20"}, {  11, CHTYPE_GROUND, 0, "C21"},
    {  12, CHTYPE_GROUND, 0, "C22"}, {  13, CHTYPE_GROUND, 0,   "4"},
    {  14, CHTYPE_GROUND, 0,   "5"}, {  15, CHTYPE_GROUND, 0,   "6"},
    {  16, CHTYPE_GROUND, 0,   "7"}, {  17, CHTYPE_GROUND, 0,   "8"},
    {  18, CHTYPE_GROUND, 0,   "9"}, {  19, CHTYPE_GROUND, 0,  "10"},
    {  20, CHTYPE_GROUND, 0,  "11"}, {  21, CHTYPE_GROUND, 0,  "12"},
    {  22, CHTYPE_GROUND, 0, "C23"}, {  23, CHTYPE_GROUND, 0, "C24"},
    {  24, CHTYPE_GROUND, 0, "C25"}, {  25, CHTYPE_GROUND, 0, "C26"},
    {  26, CHTYPE_GROUND, 0, "C27"}, {  27, CHTYPE_GROUND, 0, "C28"},
    {  28, CHTYPE_GROUND, 0, "C29"}, {  29, CHTYPE_GROUND, 0, "C30"},
    {  30, CHTYPE_GROUND, 0, "C31"}, {  31, CHTYPE_GROUND, 0, "C32"},
    {  32, CHTYPE_GROUND, 0, "C33"}, {  33, CHTYPE_GROUND, 0, "C34"},
    {  34, CHTYPE_GROUND, 0, "C35"}, {  35, CHTYPE_GROUND, 0, "C36"},
    {  36, CHTYPE_GROUND, 0, "C37"}, {  37, CHTYPE_GROUND, 0, "C38"},
    {  38, CHTYPE_GROUND, 0, "C39"}, {  39, CHTYPE_GROUND, 0, "C40"},
    {  40, CHTYPE_GROUND, 0, "C41"}, {  41, CHTYPE_GROUND, 0, "C42"},
    {  42, CHTYPE_GROUND, 0, "C43"}, {  43, CHTYPE_GROUND, 0, "C44"},
    {  44, CHTYPE_GROUND, 0, "C45"}, {  45, CHTYPE_GROUND, 0, "C46"},
    {  46, CHTYPE_GROUND, 0, "C47"}, {  47, CHTYPE_GROUND, 0, "C48"},
    {  48, CHTYPE_GROUND, 0, "C49"}, {  49, CHTYPE_GROUND, 0, "C50"},
    {  50, CHTYPE_GROUND, 0, "C51"}, {  51, CHTYPE_GROUND, 0, "C52"},
    {  52, CHTYPE_GROUND, 0, "C53"}, {  53, CHTYPE_GROUND, 0, "C54"},
    {  54, CHTYPE_GROUND, 0, "C55"}, {  55, CHTYPE_GROUND, 0, "C56"},
    {  56, CHTYPE_GROUND, 0, "C57"}, {  57, CHTYPE_GROUND, 0, "C58"},
    {  58, CHTYPE_GROUND, 0, "C59"}, {  59, CHTYPE_GROUND, 0, "C60"},
    {  60, CHTYPE_GROUND, 0, "C61"}, {  61, CHTYPE_GROUND, 0, "C62"},
    {  62, CHTYPE_GROUND, 0, "C63"}, {  63, CHTYPE_GROUND, 0,  "13"},
    {  64, CHTYPE_GROUND, 0,  "14"}, {  65, CHTYPE_GROUND, 0,  "15"},
    {  66, CHTYPE_GROUND, 0,  "16"}, {  67, CHTYPE_GROUND, 0,  "17"},
    {  68, CHTYPE_GROUND, 0,  "18"}, {  69, CHTYPE_GROUND, 0,  "19"},
    {  70, CHTYPE_GROUND, 0,  "20"}, {  71, CHTYPE_GROUND, 0,  "21"},
    {  72, CHTYPE_GROUND, 0,  "22"}, {  73, CHTYPE_GROUND, 0,  "23"},
    {  74, CHTYPE_GROUND, 0,  "24"}, {  75, CHTYPE_GROUND, 0,  "25"},
    {  76, CHTYPE_GROUND, 0,  "26"}, {  77, CHTYPE_GROUND, 0,  "27"},
    {  78, CHTYPE_GROUND, 0,  "28"}, {  79, CHTYPE_GROUND, 0,  "29"},
    {  80, CHTYPE_GROUND, 0,  "30"}, {  81, CHTYPE_GROUND, 0,  "31"},
    {  82, CHTYPE_GROUND, 0,  "32"}, {  83, CHTYPE_GROUND, 0,  "33"},
    {  84, CHTYPE_GROUND, 0,  "34"}, {  85, CHTYPE_GROUND, 0,  "35"},
    {  86, CHTYPE_GROUND, 0,  "36"}, {  87, CHTYPE_GROUND, 0,  "37"},
    {  88, CHTYPE_GROUND, 0,  "38"}, {  89, CHTYPE_GROUND, 0,  "39"},
    {  90, CHTYPE_GROUND, 0,  "40"}, {  91, CHTYPE_GROUND, 0,  "41"},
    {  92, CHTYPE_GROUND, 0,  "42"}, {  93, CHTYPE_GROUND, 0,  "43"},
    {  94, CHTYPE_GROUND, 0,  "44"}, {  95, CHTYPE_GROUND, 0,  "45"},
    {  96, CHTYPE_GROUND, 0,  "46"}, {  97, CHTYPE_GROUND, 0,  "47"},
    {  98, CHTYPE_GROUND, 0,  "48"}, {  99, CHTYPE_GROUND, 0,  "49"},
    { 100, CHTYPE_GROUND, 0,  "50"}, { 101, CHTYPE_GROUND, 0,  "51"},
    { 102, CHTYPE_GROUND, 0,  "52"}, { 103, CHTYPE_GROUND, 0,  "53"},
    { 104, CHTYPE_GROUND, 0,  "54"}, { 105, CHTYPE_GROUND, 0,  "55"},
    { 106, CHTYPE_GROUND, 0,  "56"}, { 107, CHTYPE_GROUND, 0,  "57"},
    { 108, CHTYPE_GROUND, 0,  "58"}, { 109, CHTYPE_GROUND, 0,  "59"},
    { 110, CHTYPE_GROUND, 0,  "60"}, { 111, CHTYPE_GROUND, 0,  "61"},
    { 112, CHTYPE_GROUND, 0,  "62"},
    { 0, 0, 0, NULL} /* terminate */
};

char *bsdev[NUM_BSDEV] = {
    "/dev/pt1video1",
    "/dev/pt1video0",
    "/dev/pt1video5",
    "/dev/pt1video4",
    "/dev/pt1video9",
    "/dev/pt1video8",
    "/dev/pt1video13",
    "/dev/pt1video12",
    "/dev/pt3video1",
    "/dev/pt3video0",
    "/dev/pt3video5",
    "/dev/pt3video4",
    "/dev/pt3video9",
    "/dev/pt3video8",
    "/dev/pt3video13",
    "/dev/pt3video12"
};
char *isdb_t_dev[NUM_ISDB_T_DEV] = {
    "/dev/pt1video2",
    "/dev/pt1video3",
    "/dev/pt1video6",
    "/dev/pt1video7",
    "/dev/pt1video10",
    "/dev/pt1video11",
    "/dev/pt1video14",
    "/dev/pt1video15",
    "/dev/pt3video2",
    "/dev/pt3video3",
    "/dev/pt3video6",
    "/dev/pt3video7",
    "/dev/pt3video10",
    "/dev/pt3video11",
    "/dev/pt3video14",
    "/dev/pt3video15"
};

//global
char  bs_channel_buf[8];
ISDB_T_FREQ_CONV_TABLE isdb_t_conv_set = { 0, CHTYPE_SATELLITE, 0, bs_channel_buf };
extern boolean f_exit;

/* lookup frequency conversion table*/
ISDB_T_FREQ_CONV_TABLE *
searchrecoff(char *channel)
{
    int lp;

    if((channel[0] == 'B' || channel[0] == 'b') &&
       (channel[1] == 'S' || channel[1] == 's')) {
        int node = 0;
        int slot = 0;
        char *bs_ch;

        bs_ch = channel + 2;
        while(isdigit(*bs_ch)) {
            node *= 10;
            node += *bs_ch++ - '0';
        }
        if(*bs_ch == '_' && (node&0x01) && node < ISDB_T_NODE_LIMIT) {
            if(isdigit(*++bs_ch)) {
                slot = *bs_ch - '0';
                if(*++bs_ch == '\0' && slot < ISDB_T_SLOT_LIMIT) {
                    isdb_t_conv_set.set_freq = node / 2;
                    isdb_t_conv_set.add_freq = slot;
                    sprintf(bs_channel_buf, "BS%d_%d", node, slot);
                    return &isdb_t_conv_set;
                }
            }
        }
        return NULL;
    }

    for(lp = 0; isdb_t_conv_table[lp].parm_freq != NULL; lp++) {
        /* return entry number in the table when strings match and
         * lengths are same. */
        if((memcmp(isdb_t_conv_table[lp].parm_freq, channel,
                   strlen(channel)) == 0) &&
           (strlen(channel) == strlen(isdb_t_conv_table[lp].parm_freq))) {
            return &isdb_t_conv_table[lp];
        }
    }
    return NULL;
}

void
show_channels(void)
{
    FILE *f;
    char *home;
    char buf[255], filename[255];

    fprintf(stderr, "Available Channels:\n");

    home = getenv("HOME");
    sprintf(filename, "%s/.recpt1-channels", home);
    f = fopen(filename, "r");
    if(f) {
        while(fgets(buf, 255, f))
            fprintf(stderr, "%s", buf);
        fclose(f);
    }
    else {
        fprintf(stderr, "13-62: Terrestrial Channels\n");
        fprintf(stderr, "101ch: NHK BS1\n");
        fprintf(stderr, "102ch: NHK BS2\n");
        fprintf(stderr, "103ch: NHK BShi\n");
        fprintf(stderr, "141ch: BS Nittele\n");
        fprintf(stderr, "151ch: BS Asahi\n");
        fprintf(stderr, "161ch: BS-TBS\n");
        fprintf(stderr, "171ch: BS Japan\n");
        fprintf(stderr, "181ch: BS Fuji\n");
        fprintf(stderr, "191ch: WOWOW\n");
        fprintf(stderr, "192ch: WOWOW2\n");
        fprintf(stderr, "193ch: WOWOW3\n");
        fprintf(stderr, "200ch: Star Channel\n");
        fprintf(stderr, "211ch: BS11 Digital\n");
        fprintf(stderr, "222ch: TwellV\n");
        fprintf(stderr, "C13-C63: CATV Channels\n");
    }
    fprintf(stderr, "CS2-CS24: CS Channels\n");
}

float
getsignal_isdb_s(int signal)
{
    /* apply linear interpolation */
    static const float afLevelTable[] = {
        24.07f,    // 00    00    0        24.07dB
        24.07f,    // 10    00    4096     24.07dB
        18.61f,    // 20    00    8192     18.61dB
        15.21f,    // 30    00    12288    15.21dB
        12.50f,    // 40    00    16384    12.50dB
        10.19f,    // 50    00    20480    10.19dB
        8.140f,    // 60    00    24576    8.140dB
        6.270f,    // 70    00    28672    6.270dB
        4.550f,    // 80    00    32768    4.550dB
        3.730f,    // 88    00    34816    3.730dB
        3.630f,    // 88    FF    35071    3.630dB
        2.940f,    // 90    00    36864    2.940dB
        1.420f,    // A0    00    40960    1.420dB
        0.000f     // B0    00    45056    -0.01dB
    };

    unsigned char sigbuf[4];
    memset(sigbuf, '\0', sizeof(sigbuf));
    sigbuf[0] =  (((signal & 0xFF00) >> 8) & 0XFF);
    sigbuf[1] =  (signal & 0xFF);

    /* calculate signal level */
    if(sigbuf[0] <= 0x10U) {
        /* clipped maximum */
        return 24.07f;
    }
    else if (sigbuf[0] >= 0xB0U) {
        /* clipped minimum */
        return 0.0f;
    }
    else {
        /* linear interpolation */
        const float fMixRate =
            (float)(((unsigned short)(sigbuf[0] & 0x0FU) << 8) |
                    (unsigned short)sigbuf[0]) / 4096.0f;
        return afLevelTable[sigbuf[0] >> 4] * (1.0f - fMixRate) +
            afLevelTable[(sigbuf[0] >> 4) + 0x01U] * fMixRate;
    }
}

static void
do_bell(int bell)
{
    int i;
    for(i=0; i < bell; i++) {
        fprintf(stderr, "\a");
        usleep(400000);
    }
}

void
calc_cn(int fd, int type, boolean use_bell)
{
    int     rc;
    double  P;
    double  CNR;
    int bell = 0;

    if(ioctl(fd, GET_SIGNAL_STRENGTH, &rc) < 0) {
        fprintf(stderr, "Tuner Select Error\n");
        return ;
    }

    if(type == CHTYPE_GROUND) {
        P = log10(5505024/(double)rc) * 10;
        CNR = (0.000024 * P * P * P * P) - (0.0016 * P * P * P) +
                    (0.0398 * P * P) + (0.5491 * P)+3.0965;
    }
    else {
        CNR = getsignal_isdb_s(rc);
    }

    if(CNR >= 30.0)
        bell = 3;
    else if(CNR >= 15.0 && CNR < 30.0)
        bell = 2;
    else if(CNR < 15.0)
        bell = 1;

    fprintf(stderr, "\rC/N = %fdB", CNR);
    if(use_bell)
        do_bell(bell);
}

int
tune(char *channel, thread_data *tdata, char *device)
{
    char **tuner;
    int num_devs;
    int lp;
    FREQUENCY freq;

    /* get channel */
    tdata->table = searchrecoff(channel);
    if(tdata->table == NULL) {
        fprintf(stderr, "Invalid Channel: %s\n", channel);
        return 1;
    }

    freq.frequencyno = tdata->table->set_freq;
    freq.slot = tdata->table->add_freq;

    /* open tuner */
    /* case 1: specified tuner device */
    if(device) {
        tdata->tfd = open(device, O_RDONLY);
        if(tdata->tfd < 0) {
            fprintf(stderr, "Cannot open tuner device: %s\n", device);
            return 1;
        }

        /* power on LNB */
        if(tdata->table->type == CHTYPE_SATELLITE) {
            if(ioctl(tdata->tfd, LNB_ENABLE, tdata->lnb) < 0) {
                fprintf(stderr, "Power on LNB failed: %s\n", device);
            }
        }

        /* tune to specified channel */
        while(ioctl(tdata->tfd, SET_CHANNEL, &freq) < 0) {
            if(f_exit) {
                close_tuner(tdata);
                return 1;
            }
            fprintf(stderr, "No signal. Still trying: %s\n", device);
        }

        fprintf(stderr, "device = %s\n", device);
        strncpy(tdata->ch, channel, sizeof(tdata->ch));
    }
    else {
        /* case 2: loop around available devices */
        if(tdata->table->type == CHTYPE_SATELLITE) {
            tuner = bsdev;
            num_devs = NUM_BSDEV;
        }
        else {
            tuner = isdb_t_dev;
            num_devs = NUM_ISDB_T_DEV;
        }

        for(lp = 0; lp < num_devs; lp++) {
            int count = 0;

            tdata->tfd = open(tuner[lp], O_RDONLY);
            if(tdata->tfd >= 0) {
                /* power on LNB */
                if(tdata->table->type == CHTYPE_SATELLITE) {
                    if(ioctl(tdata->tfd, LNB_ENABLE, tdata->lnb) < 0) {
                        fprintf(stderr, "Warning: Power on LNB failed: %s\n", tuner[lp]);
                    }
                }

                /* tune to specified channel */
                while(ioctl(tdata->tfd, SET_CHANNEL, &freq) < 0 &&
                      count < MAX_RETRY) {
                    if(f_exit) {
                        close_tuner(tdata);
                        return 1;
                    }
                    fprintf(stderr, "No signal. Still trying: %s\n", tuner[lp]);
                    count++;
                }

                if(count >= MAX_RETRY) {
                    close_tuner(tdata);
                    count = 0;
                    continue;
                }

                fprintf(stderr, "device = %s\n", tuner[lp]);
                break; /* found suitable tuner */
            }
        }

        /* all tuners cannot be used */
        if(tdata->tfd < 0) {
            fprintf(stderr, "Cannot tune to the specified channel\n");
            return 1;
        }
        else {
            strncpy(tdata->ch, channel, sizeof(tdata->ch));
        }
    }

    return 0; /* success */
}

int
close_tuner(thread_data *tdata)
{
    int rv = 0;

    if(tdata->tfd == -1)
        return rv;

    if(tdata->table->type == CHTYPE_SATELLITE) {
        if(ioctl(tdata->tfd, LNB_DISABLE, 0) < 0) {
            rv = 1;
        }
    }
    close(tdata->tfd);
    tdata->tfd = -1;

    return rv;
}
