#ifndef		__PT1_TUNER_H__
#define		__PT1_TUNER_H__
/***************************************************************************/
/* 塼ʾ                                                        */
/***************************************************************************/
// SLEEP⡼	
enum	{
	TYPE_SLEEP,
	TYPE_WAKEUP
};

// 塼ʥѥ⡼	
enum {
	BIT_TUNER,
	BIT_LNB_UP,
	BIT_LNB_DOWN,
	BIT_RESET
};

// LNBѥ
enum{
	LNB_OFF,						// LNB OFF
	LNB_11V,						// +11 V
	LNB_15V							// +15 V

};
enum{								// Ÿϡɥꥻå
	TUNER_POWER_OFF,				// ա֥͡
	TUNER_POWER_ON_RESET_ENABLE,	// 󡿥֥͡
	TUNER_POWER_ON_RESET_DISABLE	// 󡿥ǥ֥
};
/***************************************************************************/
/* 塼ʾ                                                        */
/***************************************************************************/
#define		MAX_BS_TS_ID		8			// TS-ID
#define		MAX_ISDB_T_INFO		3			// ϥǥؾ
#define		MAX_ISDB_T_INFO_LEN		2			// ϥǥؾ
/***************************************************************************/
/* ISDB-S                                                         */
/***************************************************************************/
typedef struct  _ISDB_S_CH_TABLE{
	int		channel ;		// ϥֹͥ
	int		real_chno ;		// ºݤΥơֹ֥
	int		slotno ;		// åֹ
}ISDB_S_CH_TABLE ;

/***************************************************************************/
/* ISDB-S                                                         */
/***************************************************************************/
typedef	struct	_ISDB_S_TS_ID{
	__u16	ts_id ;			// TS-ID
	__u16	dmy ;			// PAD
	__u8	low_mode ;		// 㳬 ⡼
	__u8	low_slot ;		// 㳬 åȿ
	__u8	high_mode ;		// ⳬ ⡼
	__u8	high_slot ;		// ⳬ åȿ
}ISDB_S_TS_ID;
typedef	struct	_ISDB_S_TMCC{
	ISDB_S_TS_ID	ts_id[MAX_BS_TS_ID];	// TSֹnФTS ID
#if 0
	__u32	indicator;				// ѹؼ (5ӥå)
	__u32	emergency;				// ư濮 (1ӥå)
	__u32	uplink;					// åץ (4ӥå)
	__u32	ext;					// ĥե饰 (1ӥå)
	__u32	extdata[2];				// ĥΰ (61ӥå)
#endif
	__u32	agc ;					// AGC
	__u32	clockmargin ;			// åȿ
	__u32	carriermargin ;			// ꥢȿ
}ISDB_S_TMCC;

// ؾ
typedef	struct	_ISDB_T_INFO{
	__u32	mode;				// ꥢĴ (3ӥå)
	__u32	rate;				// 沽Ψ (3ӥå)
	__u32	interleave;			// 󥿡꡼Ĺ (3ӥå)
	__u32	segment; 			// ȿ (4ӥå)
}ISDB_T_INFO;

typedef	struct	_ISDB_T_TMCC {
#if 0
	__u32	sysid;		// ƥ༱ (2ӥå)
	__u32	indicator;	// ѥ᡼ڤؤɸ (4ӥå)
	__u32	emergency;	// ۵޷ѵưե饰 (1ӥå)
#endif
	ISDB_T_INFO	info[MAX_ISDB_T_INFO];
#if 0
						// Ⱦ
	__u32	partial;	// ʬե饰 (1ӥå)
	__u32	Phase;		// Ϣ (3ӥå)
	__u32	Reserved;	// ꥶ (12ӥå)
#endif
	__u32	cn[2] ;					// CN
	__u32	agc ;					// AGC
	__u32	clockmargin ;			// åȿ
	__u32	carriermargin ;			// ꥢȿ
}ISDB_T_TMCC;
/***************************************************************************/
/* 塼ʾ                                                        */
/***************************************************************************/
extern	void	settuner_reset(void __iomem *, __u32, __u32);
extern	int		tuner_init(void __iomem *, struct mutex *, int);
extern	void	set_sleepmode(void __iomem *, struct mutex *, int, int, int);

extern	int		bs_tune(void __iomem *, struct mutex *, int, int, ISDB_S_TMCC *);
extern  int     ts_lock(void __iomem *, struct mutex *, int, __u16);

extern	int		isdb_t_tune(void __iomem *, struct mutex *, int, int, ISDB_T_TMCC *);
extern	int		isdb_t_frequency(void __iomem *, struct mutex *, int, int, int);
extern	int		isdb_s_read_signal_strength(void __iomem *, struct mutex *, int);
extern	int		isdb_t_read_signal_strength(void __iomem *, struct mutex *, int);

#endif
