/* -*- tab-width: 4; indent-tabs-mode: t -*- */
/* vim: set ts=4 sts=4 sw=4 noexpandtab number : */
/* tssplitter_lite.c -- split TS stream.

   Copyright 2009 querulous
   Copyright 2010-2012 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <time.h>
#include "decoder.h"
#include "recpt1.h"
#include "tssplitter_lite.h"
#include "ushare.h"
#include "metadata.h"

#ifndef AV_RB32
#define AV_RB32(x)  ((((const uint8_t*)(x))[0] << 24) | \
                     (((const uint8_t*)(x))[1] << 16) | \
                     (((const uint8_t*)(x))[2] <<  8) | \
                      ((const uint8_t*)(x))[3])
#endif

#ifndef AV_RB24
#define AV_RB24(x)  ((((const uint8_t*)(x))[0] << 16) | \
                     (((const uint8_t*)(x))[1] <<  8) | \
                      ((const uint8_t*)(x))[2])
#endif

#ifndef AV_RB16
#define AV_RB16(x)  ((((const uint8_t*)(x))[0] << 8) | ((const uint8_t*)(x))[1])
#endif
#define MAX_SERVICE_ID ( 0xffff )
#define LIST_DECIMAL "0123456789"
#define TSS_STREAM_TYPE_AUDIO (1)
#define TSS_STREAM_TYPE_VIDEO (2)

//global
extern struct ushare_t *ut;

/* prototypes */
static int ReadTs(splitter *sp, ARIB_STD_B25_BUFFER *sbuf);
static int AnalyzePat(splitter *sp, unsigned char *buf);
static int RecreatePat(splitter *sp, unsigned char *buf, int *pos);
static char** AnalyzeSid(char *sid);
static int AnalyzePmt(splitter *sp, const uint8_t *buf, int sid, const int size);
static int GetCrc32(unsigned char *data, int len);
static int GetPid(unsigned char *data);
static int parse_tot( const unsigned char* packet, time_t *t );
//void dump_packet( const uint8_t *packet );
static int parse_pcr(int64_t *ppcr_high, int *ppcr_low, const uint8_t *packet);
static int DemuxTs(const uint8_t *packet, splitter *sp, const int pid);
//static int pes2es(splitpesbuf_t *pesbuf, splitesbuf_t *esbuf, const int pid, int random_access_indicator);
static int pes2es(splitpesbuf_t *pesbuf, splitesbuf_t *esbuf, const int pid);
static int64_t get_pts(const uint8_t *p);
//void search_mpeg_system_header(const uint8_t *p);
static int esbuf_write(splitesbuf_t *esbuf);
static int pesbuf_packet_start_code_prefix(splitpesbuf_t *pesbuf);
static int pesbuf_empty(splitpesbuf_t *pesbuf);
void pesbuf_clear(splitpesbuf_t *pesbuf);
static int pesbuf_add(splitpesbuf_t *pesbuf, const uint8_t *data, int len);
static int esbuf_empty(splitesbuf_t *esbuf);
void esbuf_clear(splitesbuf_t *esbuf, uint64_t pts, uint64_t dts);
static int esbuf_add(splitesbuf_t *esbuf, const uint8_t *data, int len);
static int get_pmt_version(const uint8_t *p);
static int next_adts_start_code(splitesbuf_t *esbuf, int offset);
static int is_video_stream(const int pid, splitesbuf_t *esbuf);
static int is_audio_stream(const int pid, splitesbuf_t *esbuf);
static int AnalyzeAdifHeader(splitesbuf_t *esbuf);
static int get_adif_id(uint8_t *p);
static int get_adif_layer(uint8_t *p);
static int get_adif_protection_absent(uint8_t *p);
static int get_adif_profile(uint8_t *p);
static int get_adif_sampling_frequency_index(uint8_t *p);
static int get_adif_private_bit(uint8_t *p);
static int get_adif_channel_configuration(uint8_t *p);
static int get_adif_original_copy(uint8_t *p);
static int get_adif_home(uint8_t *p);
static int get_adif_copyright_idication_bit(uint8_t *p);
static int get_adif_copyright_idication_start(uint8_t *p);
static int get_adif_aac_frame_length(uint8_t *p);
static int get_adts_buffer_fullness(uint8_t *p);
static int get_adts_no_raw_data_blocks_in_frame(uint8_t *p);
//static int search_pmt_program(splitter *sp, int pid);
static int search_gop_start_code(splitesbuf_t *esbuf);
static int creat_es_file(splitter *sp, int sid, int pid, int av_flag);
static time_t cue2time(char *yyyymmddhhmiss);
static int search_pcr_pid(splitter *sp, int pid);

/**
 * ӥID
 */
static char** AnalyzeSid(
	char* sid)						// [in]		ӥID(޶ڤƥ)
{
	int i = 0;
	char** sid_list = NULL;
	char* p;
	int CommaNum = 0;

	/* sid ϼηΰƤ */
	/* ̵ */
	/* SID[0] */
	/* SID[0],SID[1],...,SID[N-1],SID[N] */

	/*ޤο*/
	p = sid;
	while(*p != '\0')
	{
		if( *p == C_CHAR_COMMA ){
			CommaNum++;
		}
		p++;
	}

	/* sid_listοϥޤο+2(NULLߤ᤹뤫) */
	sid_list = malloc(sizeof(char*)*(CommaNum+2));
	if ( sid_list == NULL )
	{
		fprintf(stderr, "AnalyzeSid() malloc error.\n");
		return NULL;
	}

	/* sidǤ */
	p = sid;
	if ( strlen(p) == 0 )
	{
		sid_list[0] = NULL;
		return sid_list;
	}

	/* ̵ */
	if ( CommaNum == 0 )
	{
		sid_list[0] = sid;
		sid_list[1] = NULL;
		return sid_list;
	}

	/* ޶ڤʣ */
	i=0;
	p = sid;
	/* ʸüã뤫޿ã齪λ */
	while((*p != '\0') || i < CommaNum)
	{
		/* ߤν֤sid_list[i]˥å */
		/* Υߥ󥰤 p 
		 * sidƬ
		 * [,]μʸ
		 * 줫ǤΤ p  sid_list[i] Ƥ褤
		 */
		sid_list[i] = p;
		i++;

		/* ǽ˸[,]NULLʸִ */
		p = strchr(p, C_CHAR_COMMA);
		if ( p == NULL )
		{
			/* ޤĤʤϺǸνоݤʤΤǽλ */
			break;
		}
		*p = '\0';
		/* ֤NULLִʸμΰ֤ꤹ */
		p++;
	}

	/* Ǹsid_list[n]NULLݥ󥿤ǻߤ */
	sid_list[i] = NULL;

	i=0;
	while( sid_list[i] != NULL )
	{
		i++;
	}
#if 0
	for(i=0; sid_list[i] != NULL; i++)
	{
		printf("sid_list[%d]=[%s].\n",i, sid_list[i]);
	}
#endif
	return sid_list;
}

/**
 * 
 */
splitter* split_startup(
	char *sid,		// [in]		ӥID(ǻꤷʸ)
	char *filename,	// [in]		ESե̾(ǻꤷե̾)
	char *arg_cue	// [in]		Ͽ賫ϻ(ǻꤷʸ YYYYMMDDHHMISS)
)
{
	splitter* sp;
	int i;
	sp = malloc(sizeof(splitter));
	if ( sp == NULL )
	{
		fprintf(stderr, "split_startup malloc error.\n");
		return NULL;
	}
	sp->program = malloc( sizeof(program_t) * MAX_SERVICE_ID );
	if ( sp->program == NULL )
	{
		fprintf(stderr, "split_startup malloc error.\n");
		return NULL;
	}
	memset(sp->pids, 0, sizeof(sp->pids));
	memset(sp->pmt_pids, 0, sizeof(sp->pmt_pids));
	memset(sp->cat_pids, 0, sizeof(sp->cat_pids));
	memset(sp->pcr_pids, 0, sizeof(sp->pcr_pids));
	memset(sp->pcr, 0, sizeof(sp->pcr));

	sp->sid_list	= NULL;
	sp->pat			= NULL;
	sp->sid_list	= AnalyzeSid(sid);
	if ( sp->sid_list == NULL )
	{
		free(sp);
		return NULL;
	}
	sp->pat_count	= 0xFF;
	sp->pmt_retain = -1;
	sp->pmt_counter = 0;
	sp->time_cue = 0;
	sp->time_tot = 0;
	sp->pcr_nb = 0;
	memset(sp->esbuf, 0, sizeof(splitesbuf_t *)*MAX_PID);
	memset(sp->pesbuf, 0, sizeof(splitpesbuf_t *)*MAX_PID);
	memset(sp->program, 0, sizeof(program_t *)*MAX_SERVICE_ID);
	for ( i=0; i < MAX_PID; i++ ) {
		/* pmt_version  (N%32) ͤΤǡ0 ǽƤϤʤʤ */
		sp->program[i].pmt_version = -1;
		/* cue Ϻͤǽ(CUE <= STCȤʤϿ賫Ϥ뤿) */
		sp->program[i].cue = INT64_MAX;
	}
	memset(sp->pid_sid_table, 0, sizeof(int)*MAX_PID);
	sp->filename = NULL;
	sp->esout    = 0;
	if ( filename != NULL ) {
		sp->esout = 1;
		sp->filename = filename;
	}
	if ( arg_cue != NULL ) {
		sp->arg_cue = arg_cue;
	} else {
		sp->arg_cue = "00000000000000"; /* ȤꤢǾ */
	}
	sp->split_select_finish = TSS_ERROR;
	return sp;
}

/**
 * ȤPIDꤵ
 */
int split_select(
	splitter *sp,						// [in/out]		splitter¤
	ARIB_STD_B25_BUFFER *sbuf			// [in]			TS
)
{
	int result;
	// TS
	result = ReadTs(sp, sbuf);

	return result;
}

/**
 * λ
 */
void split_shutdown(splitter* sp)
{
	int i = 0;
	if ( sp != NULL ) {
		if ( sp->program != NULL )
		{
			free(sp->program);
			sp->program = NULL;
		}
		if ( sp->pat != NULL )
		{
			free(sp->pat);
			sp->pat = NULL;
		}
		if ( sp->sid_list != NULL )
		{
			free(sp->sid_list);
			sp->sid_list = NULL;
		}
		for(i=0; i < MAX_PID; i++) {
			if ( sp->esbuf[i] != NULL ) {
				if ( sp->esbuf[i]->fd != -1 ) {
					close(sp->esbuf[i]->fd);
					sp->esbuf[i]->fd = -1;
				}
				free(sp->esbuf[i]);
				sp->esbuf[i] = NULL;
			}
			if ( sp->pesbuf[i] != NULL ) {
				free(sp->pesbuf[i]);
				sp->pesbuf[i] = NULL;
			}
		}
		free(sp);
		sp = NULL;
	}
}

/**
 * TS Ͻ
 *
 * оݤΥֹͥΤߤ PAT κƹۤȽо PID ФԤ
 */
static int ReadTs(splitter *sp, ARIB_STD_B25_BUFFER *sbuf)
{
#if 0
	splitter *sp,						// [in/out]		splitter¤
	ARIB_STD_B25_BUFFER *sbuf,			// [in]		pt1_drvTS
#endif

	int length = sbuf->size;
	int pid;
	int result = TSS_ERROR;
	int index;

	index = 0;
	while(length - index - LENGTH_PACKET > 0) {
		pid = GetPid(sbuf->data + index + 1);
		// PAT
		if(PAT == pid) {
			result = AnalyzePat(sp, sbuf->data + index);
			if(TSS_SUCCESS != result) {
				/* ̤δؿmalloc errorȯ */
				return result;
			}
		}

		// PMT
		/* Ĥpmt_pidǤˤϡpmt˽񤫤Ƥ
		 * Ĥ٤PCR/AUDIO/VIDEO PID */
		if(sp->pmt_pids[pid] == 1) {
			/* ˤPMT˰٤ʤ褦ˤƤ */
			sp->pmt_pids[pid]++;
			sp->pmt_counter += 1;
			DemuxTs(sbuf->data +index, sp, pid); /* AnalyzePmt  DemuxTs ץơեɤνɤΤѹ */
		}
		/* Ͽ褹ƤPMTˤĤơˤPCR/AUDIO/VIDEOPID */
		/* pmt_counter  pmt_retain פ˾ */
		if(sp->pmt_counter == sp->pmt_retain) {
			result = TSS_SUCCESS;
			break;
		}
		else {
			result = TSS_ERROR;
		}
		index += LENGTH_PACKET;
	}

	return(result);
}

/**
 * TS ʬΥ
 */
int split_ts(
	splitter *sp,						// [in]		splitterѥ᡼
	ARIB_STD_B25_BUFFER *sbuf,			// [in]		TS
	splitbuf_t *dbuf					// [out]	TS
)
{
	int pid;
	unsigned char *sptr, *dptr;
	int s_offset = 0;
	int d_offset = 0;
	int64_t pcr_h = 0;
	int pcr_l = 0;
	int ret = 0;
	int sid = 0;
	program_t *program;
	static int packet_nb;		/* ѥåȼ */
	int i = 0;

	/*  */
	dbuf->size = 0;
	if (sbuf->size < 0) {
		return TSS_ERROR;
	}

	sptr = sbuf->data;
	dptr = dbuf->buffer;

	while(sbuf->size > s_offset) {
		pid = GetPid(sptr + s_offset + 1);
		sid = sp->pid_sid_table[pid]; /* PIDSID */
		switch(pid) {

		// PAT
		case PAT:
			// 󥫥󥿥ȥå
			if(0xFF == sp->pat_count) {
				sp->pat_count = sp->pat[3];
			}
			else {
				sp->pat_count += 1;
				if(0 == sp->pat_count % 0x10) {
					sp->pat_count -= 0x10;
				}
			}
			sp->pat[3] = sp->pat_count;

			memcpy(dptr + d_offset, sp->pat, LENGTH_PACKET);
			d_offset += LENGTH_PACKET;
			dbuf->size += LENGTH_PACKET;
			break;
		case TOT:
			/* TOT  TDTξƤޤޤƤꡢǤ TOT ʤ */
			/* TOT  500msec θݾڤƤ
			 * äξϺ1.5äθȤʤ
			 */
			if ( sp->time_tot == 0 ) {
				/* splitter¤Τλط(TOT/CUE)Υѥ᡼ */
				parse_tot(sptr + s_offset, &(sp->time_tot));
				sp->time_cue = cue2time(sp->arg_cue);
				sp->tot_packet_nb = packet_nb;
			}
			break;
		default:
			/* ִ˴ؤƤμˢ */
			/*
			 * ִط򰷤äƤѿ
			 * PCR : 42Bit @27MHz(ServiceID(ProgramID, sid)Ω)
			 * PTS : 42Bit @90KHz(ESΩ)
			 * DTS : 42Bit @90KHz(ESΩ)
			 * TOT : MJD + 2ʲ10ʿ(TS1Ĥ)
			 * STC : 64Bit @27MHz(ServiceID(ProgramID, sid)θ߻(PCR))
			 * CUE : Ͽ賫ϻ YYYYMMDDHHMISS ()
			 *
			 * STCδˢ
			 * PCRSTC˻־򥳥ԡ
			 * 1ѥåȤȷв֤᤹ûSTC
			 * (ffmpegmpegts.cƱ)
			 *
			 * CUETOTSTC
			 * TOTSTCӤ뤿ξ롣
			 * TOT time_t
			 * CUE time_t
			 * STC42Bit27MHzο
			 * TOT ˳Program(ServiceID)STCѴͤȤ
			 * Ͽ賫ϻ(27MHz)ͤη׻ϡ
			 *   Program->CUE = STCѴ + 27e6*(ARG_CUE-TOT())
			 * ϿγϳǧȤ Program->CUE  PTS ӤФ褤
			 *
			 * PCR/PTS/DTSϥСեȤˤ34BitܤΩäƤȸʤȢ
			 * Сեν̤
			 */
			if ( 2 == sp->pmt_pids[pid] ) {
				/* PMT  */
				DemuxTs((sptr+s_offset), sp, pid);
			}
			/* pids[pid]  1 ϻĤѥåȤʤΤǽ񤭹 */
			if ( (1 == sp->pids[pid]) ) {
				/* PCRSTCν */
				int pcr_index;
				pcr_index = search_pcr_pid(sp, pid);
				if ( sp->pcr_pids[pid] == 1 && pcr_index != -1) { /* PCRݤ */
					ret = parse_pcr(&pcr_h, &pcr_l, (sptr+s_offset));
					/*
					 * PCR ʣ ServiceID(ProgramID)ǽʣѤ礬
					 * PCR 򻲾Ȥʣ ServiceID(ProgramID)ʬ롼
					 */
					for (i=0; i < sp->pcr[pcr_index].sid_nb; i++) {
						sid = sp->pcr[pcr_index].sid[i];
						program = &(sp->program[sid]);
						/* ä */
						if ( ret == 0 ) { /* PCR βϤ */
							program->stc = pcr_h * 300 + pcr_l; /* PCRSTC*/
							if ( program->pcr1 == 0 ) {
								program->pcr1 = program->stc;
								printf("pcr1 pid[%d] sid[%d] packet_nb[%d] sid_nb[%d] i[%d]\n",
										pid, sid, packet_nb, sp->pcr[pcr_index].sid_nb, i);
							} else if ( program->pcr2 == 0 ) {
//								printf("pcr2 pid[%d] sid[%d] packet_nb[%d], p_packet_nb[%d] sid_nb[%d] i[%d]\n",
//										pid, sid, packet_nb, program->pcr_packet_nb, sp->pcr[pcr_index].sid_nb, i);
								program->pcr2 = program->stc;
								program->pcr_incr = (program->pcr2 -program->pcr1)
									/(packet_nb -program->pcr_packet_nb);
								printf("pcr2 pid[%d] sid[%d] pcr_incr[%llu]\n",
										pid, sid, program->pcr_incr);
							} else {
								/* PCRѤ */
								; /* ˽̵ */
							}
							if ( (program->cue == INT64_MAX ) &&
									(sp->arg_cue != NULL) &&
									(sp->time_tot != 0) ) { /* Ͽ賫ϻ */
								/*
								 * Ͽ賫ϻ = STC +(CUE -TOT)*27MHz
								 * +(TOT鸽ߤޤǤΥѥåȿʬ)*ѥåȤοʤ
								 * -0.49(οŬ)
								 * TOT/STCǻĴơGOPƬФΤǹƤޤäƤ
								 */
								program->cue = program->stc
									+(sp->time_cue -sp->time_tot)*27e6
									+(packet_nb -sp->tot_packet_nb)*program->pcr_incr
									-(27e6*49/100);
								printf("STC[%llu] CUE[%llu] SID[%d]\n",
										program->stc, program->cue, sid);
							}
							program->pcr_packet_nb = packet_nb;
							program->packet_nb = packet_nb;
						} else if ( program->pcr_incr ) { /* PCRβϤ˼Գpcr_incrѿη׻Ѥ*/
							/* STCĹ */
							program->stc += (packet_nb -program->packet_nb)*program->pcr_incr;
							program->packet_nb = packet_nb;
						} else {
							; /* STCʤǤ·äƤޤ */
						}
					} /* for */
				} else { /* оݥѥåȤPCRǤϤʤ */
					program = &(sp->program[sid]);
					if ( program->pcr_incr ) { /* PCRʤpcr_incrѿη׻Ѥ */
						/* STCĹ */
						program->stc += (packet_nb -program->packet_nb)*program->pcr_incr;
						program->packet_nb = packet_nb;
					} else { /* ʳ */
						; /* STCʤǤ·äƤޤ */
					}
				}
#if 0
// NHK G ALL Ȥ SID 1024 Фʤ...orz..
				if ( !(packet_nb % 1000) ) {
					program = &(sp->program[sid]);
					printf("STC[%llu] SID[%d]\n", program->stc, sid);
				}
#endif
				/* TS */
				DemuxTs((sptr+s_offset), sp, pid);
				memcpy(dptr + d_offset, sptr + s_offset, LENGTH_PACKET);
				d_offset += LENGTH_PACKET;
				dbuf->size += LENGTH_PACKET;
			}
			break;
		} /* switch */
		s_offset += LENGTH_PACKET;
		packet_nb += 1; /* ѥåȼû */
	}
	return(TSS_SUCCESS);
}

/**
 * PAT Ͻ
 *
 * PAT Ϥоݥͥ뤬ޤޤƤ뤫åԤPAT ƹۤ
 */
static int AnalyzePat(splitter *sp, unsigned char *buf)
#if 0
	unsigned char* buf,					// [in]		ɤ߹Хåե
	unsigned char** pat,				// [out]	PAT ʺƹ۸
	unsigned char* pids,				// [out]	о PID 
	char** sid_list,					// [in]		оݥӥ ID Υꥹ
	unsigned char* pmt_pids,			// [out]	ӥ ID б PMT  PID
	int* pmt_retain						// [out]	ĤPMTο
)
#endif
{
	int pos[MAX_PID];
	int service_id;
	int i, j, k;
	int size = 0;
	int pid;
	int result = TSS_SUCCESS;
	char **p;
	int sid_found = FALSE;
	int avail_sids[MAX_SERVICES];

	unsigned char *pat = sp->pat;
	unsigned char *pids = sp->pids;
	char **sid_list = sp->sid_list;
	unsigned char *pmt_pids = sp->pmt_pids;

	char chosen_sid[512];
	chosen_sid[0] = '\0';

	if(pat == NULL) {
		/*  */
		sp->pmt_retain = 0;
		memset(pos, 0, sizeof(pos));
		size = buf[7];

		/* prescan SID/PMT */
		for(i = 13, j = 0; i < (size + 8) - 4; i = i + 4) {
			pid = GetPid(&buf[i+2]);
			if(pid == NIT)
				continue;
			avail_sids[j] = (buf[i] << 8) + buf[i+2];
			sp->avail_pmts[j] = pid;
			j++;
		}
		sp->num_pmts = j;

		// оݥͥȽ
		/* size + 8 = ѥåĹ */
		/* ǽ 4 ХȤCRCʤΤФ */
		for(i = 13; i < (size + 8) - 4; i = i + 4) {
			pid = GetPid(&buf[i+2]);
			if(pid == NIT)
				continue;

			service_id = (buf[i] << 8) + buf[i+1];
			p = sid_list;

			while(*p) {
				if(service_id == atoi(*p)) {
					/* Ͽоݤ pmt_pids  1 Ȥ */
					/* Ͽоݤ pmt  pids  1 Ȥ */
					/* б pid_sid_table  ӥID(ProgramID)  */
					pid = GetPid(&buf[i + 2]);
					*(pmt_pids+pid) = 1;
					*(pids+pid) = 1;
					pos[pid] = i;
					sid_found = TRUE;
					sp->pmt_retain += 1;
					sp->program[service_id].pmt_packet_id = pid;
					sp->pid_sid_table[pid] = service_id;
					sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					p++;
					continue;
				}
				else if(!strcasecmp(*p, "hd") || !strcasecmp(*p, "sd1")) {
					/* hd/sd1 ˤ1ܤΥӥ¸ */
					if(service_id == avail_sids[0]) {
						pid = GetPid(&buf[i + 2]);
						*(pmt_pids+pid) = 1;
						*(pids+pid) = 1;
						pos[pid] = i;
						sid_found = TRUE;
						sp->pmt_retain += 1;
						sp->program[service_id].pmt_packet_id = pid;
						sp->pid_sid_table[pid] = service_id;
						sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					}
					p++;
					continue;
				}
				else if(!strcasecmp(*p, "sd2")) {
					/* sd2 ˤ2ܤΥӥ¸ */
					if(service_id == avail_sids[1]) {
						pid = GetPid(&buf[i + 2]);
						*(pmt_pids+pid) = 1;
						*(pids+pid) = 1;
						pos[pid] = i;
						sid_found = TRUE;
						sp->pmt_retain += 1;
						sp->program[service_id].pmt_packet_id = pid;
						sp->pid_sid_table[pid] = service_id;
						sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					}
					p++;
					continue;
				}
				else if(!strcasecmp(*p, "sd3")) {
					/* sd3 ˤ3ܤΥӥ¸ */
					if(service_id == avail_sids[2]) {
						pid = GetPid(&buf[i + 2]);
						*(pmt_pids+pid) = 1;
						*(pids+pid) = 1;
						pos[pid] = i;
						sid_found = TRUE;
						sp->pmt_retain += 1;
						sp->program[service_id].pmt_packet_id = pid;
						sp->pid_sid_table[pid] = service_id;
						sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					}
					p++;
					continue;
				}
				else if(!strcasecmp(*p, "1seg")) {
					/* 1seg ˤ PMTPID=0x1FC8 Υӥ¸ */
					pid = GetPid(&buf[i + 2]);
					if(pid == 0x1FC8) {
						*(pmt_pids+pid) = 1;
						*(pids+pid) = 1;
						pos[pid] = i;
						sid_found = TRUE;
						sp->pmt_retain += 1;
						sp->program[service_id].pmt_packet_id = pid;
						sp->pid_sid_table[pid] = service_id;
						sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					}
					p++;
					continue;
				}
				else if(!strcasecmp(*p, "all")) {
					/* allˤ¸ */
					pid = GetPid(&buf[i + 2]);
					*(pmt_pids+pid) = 1;
					*(pids+pid) = 1;
					pos[pid] = i;
					sid_found = TRUE;
					sp->pmt_retain += 1;
					sp->program[service_id].pmt_packet_id = pid;
					sp->pid_sid_table[pid] = service_id;
					sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
					break;
				}

				p++;
			} /* while */
		}

		/* if sid has been specified but no sid found, fall back to all */
		if(*sid_list && !sid_found) {
			for(i = 17; i < (size + 8) - 4; i = i + 4) {
				service_id = (buf[i] << 8) + buf[i+1];
				pid = GetPid(&buf[i + 2]);
				*(pmt_pids+pid) = 1;
				*(pids+pid) = 1;
				pos[pid] = i;
				sid_found = TRUE;
				sp->pmt_retain += 1;
				sp->program[service_id].pmt_packet_id = pid;
				sp->pid_sid_table[pid] = service_id;
				sprintf(chosen_sid, "%s %d", *chosen_sid ? chosen_sid : "", service_id);
			}
		}

		/* print SIDs */
		fprintf(stderr, "Available sid = ");
		for(k=0; k < sp->num_pmts; k++)
			fprintf(stderr, "%d ", avail_sids[k]);
		fprintf(stderr, "\n");
		fprintf(stderr, "Chosen sid    =%s\n", chosen_sid);

#if 0
		/* print PMTs */
		fprintf(stderr, "Available PMT = ");
		for(k=0; k < sp->num_pmts; k++)
			fprintf(stderr, "0x%x ", sp->avail_pmts[k]);
		fprintf(stderr, "\n");
#endif

		// PAT ƹ
		result = RecreatePat(sp, buf, pos);
#if 0
		int tc;
		for(tc=0; tc<188; tc++)
			fprintf(stderr, "%02x ", *(sp->pat+tc));
#endif
	}

	return(result);
}

/**
 * PAT ƹ۽
 *
 * PMT оݥͥʳΥͥPAT ƹۤ
 */
static int RecreatePat(splitter *sp, unsigned char *buf, int *pos)
#if 0
	splitter *sp						// [in/out]	splitter	
	unsigned char* buf,					// [in]		ɤ߹Хåե
	int *pos							// [in]		о PMT ΥХåեΰ
#endif
{
	unsigned char y[LENGTH_CRC_DATA];
	int crc;
	int i;
	int j;
	int pos_i;
	int pid_num = 0;

	// CRC ׻ΤΥǡ
	{
		// ͥˤäѤʤʬ
		for (i = 0; i < LENGTH_PAT_HEADER - 4; i++)
		{
			y[i] = buf[i + 5];
		}
		// NIT
		y[LENGTH_PAT_HEADER-4] = 0x00;
		y[LENGTH_PAT_HEADER-3] = 0x00;
		y[LENGTH_PAT_HEADER-2] = 0xe0;
		y[LENGTH_PAT_HEADER-1] = 0x10;
		// ͥˤäѤʬ
		for (i = 0; i < MAX_PID; i++)
		{
			if(pos[i] != 0)
			{
				/* buf[pos_i]  y ˥ԡ(ФPIDο) */
				pos_i = pos[i];
				for (j = 0; j < 4; j++)
				{
					y[LENGTH_PAT_HEADER + ((4*pid_num) + j)] = buf[pos_i + j];
				}
				pid_num++;
			}
		}
	}
	/* ѥåȥ׻ */
	y[2] = pid_num * 4 + 0x0d;
	// CRC ׻
	crc = GetCrc32(y, LENGTH_PAT_HEADER + pid_num*4);

	// PAT ƹ
	sp->pat = (unsigned char*)malloc(LENGTH_PACKET);
	if(sp->pat == NULL)
	{
		fprintf(stderr, "RecreatePat() malloc error.\n");
		return(TSS_NULL);
	}
	memset(sp->pat, 0xFF, LENGTH_PACKET);
	for (i = 0; i < 5; i++)
	{
		(sp->pat)[i] = buf[i];
	}
	for (i = 0; i < LENGTH_PAT_HEADER + pid_num*4; i++)
	{
		(sp->pat)[i + 5] = y[i];
	}
	(sp->pat)[5 + LENGTH_PAT_HEADER + pid_num*4] = (crc >> 24) & 0xFF;
	(sp->pat)[6 + LENGTH_PAT_HEADER + pid_num*4] = (crc >> 16) & 0xFF;
	(sp->pat)[7 + LENGTH_PAT_HEADER + pid_num*4] = (crc >>  8) & 0xFF;
	(sp->pat)[8 + LENGTH_PAT_HEADER + pid_num*4] = (crc      ) & 0xFF;

	return(TSS_SUCCESS);
}


/**
 * PMT Ͻ
 *
 * PMT Ϥ¸оݤ PID ꤹ
 * TSإåȥץơեɤν DemuxTs ˰ǤΤǡ
 * ǤϡǡƬݥ󥿤äƤ
 */
static int AnalyzePmt(splitter *sp, const uint8_t *buf, int sid, const int size)
#if 0
	unsigned char* buf,					// [in]		Ƭ
	unsigned char* pids)				// [out]	о PID 
#endif
{
	unsigned char Nall;
	unsigned char N;
	int pcr;
	int epid;
	int av_flag = 0;
	int i = 0;
	int j = 0;
	int pcr_found = 0;
/* ǥХå PMTɽ */
#define PmtDebug (1)

#ifdef PmtDebug
	printf("AnalyzePmt start. Tree List enable.\n");
	printf("SID[%d][0x%04x]\n", sid, sid);
#endif

//	Nall = ((buf[2] & 0x0F) << 4) + buf[3];
	Nall = ((buf[2] & 0x0F) << 8) + buf[3];
// ǼΤTSѥåȤǤϤʤƬݥ󥿤ǤΤsizeǸ
//	if(Nall > LENGTH_PACKET)
//		Nall = LENGTH_PACKET - 8; /* xxx workaround --yaz */
	if(Nall > size)
		Nall = size -8;

	/* get version */
	sp->program[sid].pmt_version = get_pmt_version(buf);
#ifdef PmtDebug
	printf("	pmt_version[%02x]\n", sp->program[sid].pmt_version);
#endif

	// PCR
	pcr = GetPid(&buf[9]);
	sp->pids[pcr] = 1;
	sp->program[sid].pcr_packet_id = pcr;
	sp->pid_sid_table[pcr] = sid; /* PCRϽʣǽΤʤ */
	sp->pcr_pids[pcr] = 1;

	/* PCRνʣå(ʣServiceID(ProgramID)) */
	for( i=0; i < sp->pcr_nb; i++ ) {
		if ( sp->pcr[i].pid == pcr ) {
			/* ȯ */
			for ( j=0; j < sp->pcr[i].sid_nb; j++ ) {
				/* ƱSIDϿƤ뤫ǧ */
				if ( sp->pcr[i].sid[j] == sid ) {
					pcr_found = 1;
					break;
				}
			}
			if ( pcr_found ) {
				/* ƱSIDϿƤ */
#ifdef PmtDebug
				printf("	same sid found pcr[%d] sid[%d]\n", pcr, sid);
#endif
				break;
			}
			/* ʣPCRȯ */
#ifdef PmtDebug
			printf("	same pcr found pcr[%d] sid[%d] sid_nb[%d], i[%d]\n", pcr, sid, sp->pcr[i].sid_nb, i);
#endif
			sp->pcr[i].sid[sp->pcr[i].sid_nb] = sid;
			sp->pcr[i].sid_nb += 1;
			pcr_found = 1;
			break;
		}
	}

	if ( ! pcr_found ) {
		/* PCRΰ蹹 */
#ifdef PmtDebug
		printf("	new pcr found pcr[%d] sid[%d], pcr_nb[%d]\n", pcr, sid, sp->pcr_nb);
#endif
		sp->pcr[sp->pcr_nb].pid = pcr;
		sp->pcr[sp->pcr_nb].sid[0] = sid;
		sp->pcr[sp->pcr_nb].sid_nb = 1;
		sp->pcr_nb += 1;
	}
#ifdef PmtDebug
	printf("	PCR PacketID[%d][0x%04x]\n", pcr, pcr);
#endif

//	N = ((buf[11] & 0x0F) << 4) + buf[12] + 16 + 1;
	N = ((buf[11] & 0x0F) << 8) + buf[12] + 12 + 1;
//	printf("NAll[%d] N[%d]\n", Nall, N);

	// ECM
	//int p = 17;
	int p = 13;
	while(p < N) {
		if ( p > size -4) {
			break;
		}
		uint32_t cat_pid;
		uint32_t tag;
		uint32_t len;

		tag = buf[p];
		len = buf[p+1];
		p += 2;

		if(tag == 0x09 && len >= 4 && p+len <= N) {
//			ca_pid = ((buf[p+2] << 8) | buf[p+3]) & 0x1fff;
			cat_pid = (AV_RB16(buf+p+2)) & 0x1fff;
			sp->pids[cat_pid] = 1;
			sp->cat_pids[cat_pid] = 1;
			sp->pid_sid_table[cat_pid] = sid; /* CATʣServiceIDǽʣ */
#ifdef PmtDebug
			printf("	CAT PacketID[%d][0x%04x]\n", cat_pid, cat_pid);
#endif
		}
		p += len;
	}

	/*
	 * ISO/IEC 13818-1:2000(E) Table 2-29 - Stream type assignments
	 * Value Desctiption
	 * 0x00 ITU-T | ISO/IEC Reserved
	 * 0x01 ISO/IEC 11172 Video
	 * 0x02 ITU-T Rec. H.262 | ISO/IEC 13818-2 Video or ISO/IEC 11172-2 constrained parameter video stream
	 * 0x03 ISO/IEC 11172 Audio
	 * 0x04 ISO/IEC 13818-3 Audio
	 * 0x05 ITU-T Rec. H.222.0 | ISO/IEC 13818-1 private_sections
	 * 0x06 ITU-T Rec. H.222.0 | ISO/IEC 13818-1 PES packets containing private data
	 * 0x07 ISO/IEC 13522 MHEG
	 * 0x08 ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Annex A DSM-CC
	 * 0x09 ITU-T Rec. H.222.1
	 * 0x0A ISO/IEC 13818-6 type A
	 * 0x0B ISO/IEC 13818-6 type B
	 * 0x0C ISO/IEC 13818-6 type C
	 * 0x0D ISO/IEC 13818-6 type D
	 * 0x0E ITU-T Rec. H.222.0 | ISO/IEC 13818-1 auxiliary
	 * 0x0F ISO/IEC 13818-7 Audio with ADTS transport syntax
	 * 0x10 ISO/IEC 14496-2 Visual
	 * 0x11 ISO/IEC 14496-3 Audio with the LATM transport syntax as defined in ISO/IEC 14496-3 / AMD  1
	 * 0x12 ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in PES packets
	 * 0x13 ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in ISO/IEC14496_sections.
	 * 0x14 ISO/IEC 13818-6 Synchronized Download Protocol
	 * 0x15-0x7F ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Reserved
	 * 0x80-0xFF User Private
	 *
	 */

	// ES PID
	while (N < Nall + 8 - 4) {
		av_flag = 0;
		// ȥ꡼̤ 0x0Dtype DˤϽоݳ
		if (0x0D != buf[N]) {
			epid = GetPid(&buf[N + 1]);
			sp->pids[epid] = 1;
			sp->pid_sid_table[epid] = sid;
			if ( buf[N] == 0x02 ) { /* 13818-2 Video */
				sp->program[sid].video[sp->program[sid].video_nb] = epid;
				sp->program[sid].video_nb += 1;
				av_flag = TSS_STREAM_TYPE_VIDEO;
#ifdef PmtDebug
				printf("	VIDEO PacketID[%d][0x%04x] StreamType[0x%02x]\n", epid, epid, buf[N]);
#endif
			} else if ( (buf[N] == 0x04) || (buf[N] == 0x0f) ) {
				/* 13818-3 Audio or 13818-7 Audio with ADTS transport syntax */
				sp->program[sid].audio[sp->program[sid].audio_nb] = epid;
				sp->program[sid].audio_nb += 1;
				av_flag = TSS_STREAM_TYPE_AUDIO;
#ifdef PmtDebug
				printf("	AUDIO PacketID[%d][0x%04x] StreamType[0x%02x]\n", epid, epid, buf[N]);
#endif
			} else {
#ifdef PmtDebug
				printf("	OTHER PacketID[%d][0x%04x] StreamType[0x%02x]\n", epid, epid, buf[N]);
#endif
				; /* A/V ɤǤʤΤϤȤꤢ롼 */
			}
			if ( av_flag && sp->esout ) {
				/* ESХåեNULL */
				if ( sp->esbuf[epid] == NULL ) {
					sp->esbuf[epid] = malloc(sizeof(splitesbuf_t));
					if ( sp->esbuf[epid] == NULL ) {
						fprintf(stderr, "malloc error\n");
						return TSS_NULL;
					}
					sp->esbuf[epid]->size = 0;
					sp->esbuf[epid]->Program = &(sp->program[sid]);
					sp->esbuf[epid]->fd = -1;
					if ( creat_es_file(sp, sid, epid, av_flag) ) {
						return TSS_ERROR;
					}
				}
				/* PESХåեNULL */
				if ( sp->pesbuf[epid] == NULL ) {
					sp->pesbuf[epid] = malloc(sizeof(splitpesbuf_t));
					if ( sp->pesbuf[epid] == NULL ) {
						fprintf(stderr, "malloc error\n");
						return TSS_NULL;
					}
					sp->pesbuf[epid]->size = 0;
					sp->pesbuf[epid]->Program = &(sp->program[sid]);
				}
			}
		}
//		N += 4 + (((buf[N + 3]) & 0x0F) << 4) + buf[N + 4] + 1;
		N += 4 + (((buf[N + 3]) & 0x0F) << 8) + buf[N + 4] + 1;
	}
#ifdef PmtDebug
	printf("AnalyzePmt finish.\n");
#endif
	return TSS_SUCCESS;
}

/**
 * CRC ׻
 */
static int GetCrc32(
	unsigned char* data,				// [in]		CRC ׻оݥǡ
	int len)							// [in]		CRC ׻оݥǡĹ
{
	int crc;
	int i, j;
	int c;
	int bit;

	crc = 0xFFFFFFFF;
	for (i = 0; i < len; i++)
	{
		char x;
		x = data[i];

		for (j = 0; j < 8; j++)
		{

			bit = (x >> (7 - j)) & 0x1;

			c = 0;
			if (crc & 0x80000000)
			{
				c = 1;
			}

			crc = crc << 1;

			if (c ^ bit)
			{
				crc ^= 0x04C11DB7;
			}

			crc &= 0xFFFFFFFF;
		}
	}

	return crc;
}

/**
 * PID 
 */
static int GetPid(
	unsigned char* data)				// [in]		оݥǡΥݥ
{
	return ((data[0] & 0x1F) << 8) + data[1];
}

/* return the 90kHz PCR and the extension for the 27MHz PCR. return
   (-1) if not available */
static int parse_pcr(int64_t *ppcr_high, int *ppcr_low,
                     const uint8_t *packet)
{
	int afc, len, flags;
	const uint8_t *p;
	unsigned int v;

	afc = (packet[3] >> 4) & 3;
	if (afc <= 1)
		return -1;
	p = packet + 4;
	len = p[0];
	p++;
	if (len == 0)
		return -1;
	flags = *p++;
	len--;
	if (!(flags & 0x10))
		return -1;
	if (len < 6)
		return -1;
	v = AV_RB32(p);
	*ppcr_high = ((int64_t)v << 1) | (p[4] >> 7);
	*ppcr_low = ((p[4] & 1) << 8) | p[5];
	return 0;
}

/* pesbufȽ (ret. 0:not empty / 1: empty) */
static int pesbuf_empty(splitpesbuf_t *pesbuf){
	return pesbuf->size == 0;
}

/* pesbuf򥯥ꥢ */
void pesbuf_clear(splitpesbuf_t *pesbuf){
	pesbuf->size = 0;
}

/* pesbuf˥ǡɲ (ret. 0:success / -1:error) */
static int pesbuf_add(splitpesbuf_t *pesbuf, const uint8_t *data, int len){
	if(pesbuf->size + len > sizeof pesbuf->buffer){
		return -1;
	}
	memcpy(pesbuf->buffer +pesbuf->size, data, len);
	pesbuf->size += len;
	return 0;
}

/* pesbuf顢PESƬ(packet_start_code_prefix)õ */
/* (ret. >=0:offset / -1: error)  */
static int pesbuf_packet_start_code_prefix(splitpesbuf_t *pesbuf){
	uint8_t packet_start_code_prefix[3] = {0x00, 0x00, 0x01};
	int i = 0;

	/*  */
	if(pesbuf->size < sizeof packet_start_code_prefix){
		return -1;
	}
	/* Ƭõ */
	if(!memcmp(pesbuf->buffer + i, packet_start_code_prefix, sizeof packet_start_code_prefix)){
		return 0;
	}

#if 0
	/* ƬʳõϡΥɤͭ롣 */
	/* MPEG-Videostart_codeƱʤΤǡɤʤȻפ... */
	for(i = 0; i < pesbuf->size - sizeof packet_start_code_prefix; i++){
		if(!memcmp(pesbuf->buffer + i, packet_start_code_prefix, sizeof packet_start_code_prefix)){
			return i;
		}
	}
#endif

	return -1;
}

/**
 * TSβϤDemuxԤ
 */
static int DemuxTs(const uint8_t *packet, splitter *sp, const int pid)
{
	/*
	 * PESƬޤǤĹ
	 * 4byte : continity counter
	 * 27,28bit  adaptation fileld
	 * (01:ڥɤΤ, 10:adaptation fileldΤߡ11:adaptation fileld+payload00:reserved)
	 * ڥĹ = 188 - TS header(4byte) -adaptation fieldĹ -1
	 */
	/* ꤬Ȥ */

	int payload_offset;	/* ڥɥեå(=ѥåƬΥХȿ) */
	int payload_length;	/* ڥĹ */
	int pes_started;
	int adaptation_field_control;
	int payload_unit_start_indicator;
//	int random_access_indicator = 0;
	int sid = sp->pid_sid_table[pid]; /* SIDPIDƤ뤬PCRCATϽʣƤΤ*/

	payload_offset = LENGTH_TS_HEADER;

	if ( sp->pesbuf[pid] == NULL ) {
		pes_started = 0; /* malloc(ϤäƤɤ) */
	} else {
		pes_started = !pesbuf_empty(sp->pesbuf[pid]);	/* PESѳϺѤ */
	}

	/* adaptation_field_controladaptation_field */
	adaptation_field_control = (packet[3] & 0x30) >> 4;
	if ( adaptation_field_control == 0x02 || adaptation_field_control == 0x00) {
		/* ڥɤʤξ */
		return 0;	/* ̤˥顼ǤϤʤ */
	} else if ( adaptation_field_control == 0x03 ) {
		/* ץơեɡܥڥɤξ */
		if ( packet[LENGTH_TS_HEADER] != 0 ) {
//			random_access_indicator = (packet[5] & 0x40) >> 6;
		}
		/* ڥɳϰ = TSإåĹ + ץơեĹ + 1 */
		payload_offset += packet[LENGTH_TS_HEADER] + 1;
	} else {
		/* ڥɤΤ */
		;	/* ä˽ʤ */
	}

	/* ڥĹФ */
	payload_length = LENGTH_PACKET - payload_offset;
	if( payload_length <= 0 ){	/* payloadĹ0ʲξ */
		return -1;	/* 顼ˤ٤̯ʤȤ */
	}

	/* payload_unit_start_indicator(1) */
	payload_unit_start_indicator = (packet[1] & 0x40) >> 6;
	/* (sectionξϡpointer_fieldνʤɤԤpayload_offsetȿǤ) */
	if ( sp->pmt_pids[pid] == 2 ) { /* PID Ͽоݤ PMT Ǥ뤫 */
		if ( get_pmt_version(packet+payload_offset) != sp->program[sid].pmt_version ) {
			/* pmt version˺ʬ */
			fprintf(stderr, "pmt version diff found pmt_pid[%d]"
					" old_version[0x%02x]"
					" new_version[0x%02x].\n",
					pid,
					sp->program[sid].pmt_version,
					get_pmt_version(packet+payload_offset));
			AnalyzePmt(sp, packet +payload_offset, sid, payload_length);
			/* payload byte٤ */
		}
		return 0; /* PMT ξϽ */
	}
	if ( !sp->esout ) {
		/* ESϤʤPES */
		return 0;
	}
	if ( sp->cat_pids[pid] == 1 ) {
		return 0; /* CATѤʤ */
	}
	if ( sp->pesbuf[pid] == NULL ) {
		/* PESפǤѤʤ */
		return 0;
	}

	/* payload_unit_start_indicator(2) */
	/* ɬפ˱ѺѤPESνȡPESѳϤԤ */
	if( payload_unit_start_indicator ){
		/* PES */
		if ( pes_started ) {
			/* Хåե˥ǡPESüʤΤǽƥꥢ */
//			pes2es(sp->pesbuf[pid], sp->esbuf[pid], pid, random_access_indicator);
			pes2es(sp->pesbuf[pid], sp->esbuf[pid], pid);
			pesbuf_clear(sp->pesbuf[pid]);
		}
		else {
			pes_started = 1;
		}
	}

	/* PESѽ */
	if ( pes_started ){
		/* PESѳϺѤ(줫PESѳϤޤ)ʤ顢payloadPESȤɲ */
		pesbuf_add(sp->pesbuf[pid], packet + payload_offset, payload_length);
	}
	/* Ĥ줵ޤǤ */
	return 0;
}

#if 0
̤Ѥʤ
/* PMT_PID  Program(Service ID)ꤵ */
static int search_pmt_program(splitter *sp, int pid)
{
	/* δؿ٤ΤǤʤ٤Ѥʤ */
	int i;
	for ( i = 0; i < MAX_SERVICE_ID; i++ ) {
		if ( sp->program[i].pmt_packet_id  == pid ) {
			return i;
		}
	}
	return -1;
}
#endif

/* esbufȽ (ret. 0:not empty / 1: empty) */
static int esbuf_empty(splitesbuf_t *esbuf){
	return esbuf->size == 0;
}

/* esbuf򥯥ꥢ */
void esbuf_clear(splitesbuf_t *esbuf, uint64_t pts, uint64_t dts){
	esbuf->size = 0;
	esbuf->pts = pts;
	esbuf->dts = dts;
}

/* esbuf˥ǡɲ (ret. 0:success / -1:error) */
static int esbuf_add(splitesbuf_t *esbuf, const uint8_t *data, int len){
	if(esbuf->size + len > sizeof esbuf->buffer){
		return -1;
	}
	memcpy(esbuf->buffer +esbuf->size, data, len);
	esbuf->size += len;
	return 0;
}

/*
 * PESϤESϤ
 */
//static int pes2es(splitpesbuf_t *pesbuf, splitesbuf_t *esbuf, const int pid, int random_access_indicator)
static int pes2es(splitpesbuf_t *pesbuf, splitesbuf_t *esbuf, const int pid)
{
	int len_pesh = 0;
	int code = 0;
	int flags = 0;
	int len_pes = 0;
	int len_pesh_supposed = 0;
	int pes_extension_flags = 0;
	int pes_extension_flags2 = 0;
	int program_packet_sequence_counter_flag = 0;
	int es_rate = 0;
	const uint8_t *p = pesbuf->buffer;
	const uint8_t *p_end = pesbuf->buffer +pesbuf->size;
	int original_stuffing_length = 0;
	int data_alignment_indicator = false;
	int es_started;
	int payload_offset = 0;
	int payload_length = 0;
	int audio_lipsync_offset = 0;
	int i = 0;
	int64_t audio_pts = 0;
	int adts_freq = 0;
	int64_t adts_frame_time = 0;
	int gop_start = -1;

	/* ꤬Ȥ */
	/* ꤬ȤȥȤ񤯤ȡ
	 * ư褯ʤ
	 * Х
	 * Хʥꥵʤ
	 * 褯ʤ
	 * 褯ʤ
	 */
	if ( esbuf == NULL ) {
		return -1; /* mallocδؿϸƤ󤸤Ǥ */
	} else {
		es_started = !esbuf_empty(esbuf);	/* ESѳϺѤ */
	}

	payload_offset = pesbuf_packet_start_code_prefix(pesbuf);
	if ( payload_offset == -1 ) {
		return -1;
	}
	p += payload_offset;
	/* http://dvd.sourceforge.net/dvdinfo/pes-hdr.html
	 *
	 * Stream ID        : type                                               : extension present?
	 * (1011 1101) 0xBD : Private stream 1 (non MPEG audio, subpictures)     : YES
	 * (1011 1110) 0xBE : Padding stream                                     : NO
	 * (1011 1111) 0xBF : Private stream 2 (navigation data)                 : NO
	 * (110x xxxx) 0xC0 - 0xDF : MPEG-1 or MPEG-2 audio stream number x xxxx : YES
	 * (1110 xxxx) 0xE0 - 0xEF : MPEG-1 or MPEG-2 video stream number xxxx   : YES
	 * note: DVD allows only 8 audio streams/DVD allows only 1 video stream
	 */
	/* http://www2.arib.or.jp/johomem/pdf/2009/2009_0088.pdf
	 *
	 * 0xBC : ץॹȥ꡼ޥå
	 * 0xBD : ץ饤١ȥȥ꡼1
	 * 0xBE : ѥǥ󥰥ȥ꡼
	 * 0xBF : ץ饤١ȥȥ꡼2
	 * 0xC0 - 0xDF : ISO/IEC 13318 3ISO/IEC 11172 3ISO/IEC 13318 7 or ISO/IEC 14496 3 audio xxxx
	 * 0xE0 - 0xEF : ITU-T H.262ISO/IEC 11172 2ISO/IEC 14496 2 or ITU-T H264ȥ꡼
	 * 0xF0 : ECMȥ꡼
	 * 0xF1 : EMMȥ꡼
	 * 0xF2 : ITU-TH.222.0 Annex A  ISO/IEC 13318 6 DSMCCȥ꡼
	 * 0xF3 : ISO/IEC 13522ȥ꡼
	 * 0xF4 : ITU-T H.222.1 type A
	 * 0xF5 : ITU-T H.222.1 type B
	 * 0xF6 : ITU-T H.222.1 type C
	 * 0xF7 : ITU-T H.222.1 type D
	 * 0xF8 : ITU-T H.222.1 type E
	 * 0xF9 : ȥ꡼
	 * 0xFA : ISO/IEC 14496 1SLѥåȲȥ꡼
	 * 0xFB : ISO/IEC 14496 1եåޥåȥ꡼
	 * 0xFC : ᥿ǡȥ꡼
	 * 0xFD : ĥȥ꡼ID
	 * 0xFE : ̤
	 * 0xFF : ץॹȥ꡼ǥ쥯ȥ
	 */
	/* 嵭ꡢǤ
	 * MPEG-1 or MPEG-2 audio stream 
	 * MPEG-1 or MPEG-2 video stream 
	 * Private stream 1 
	 * 0xFD(ĥȥ꡼ID)Ф
	 * 0xBF Private stream 2 ȤƤ뤱ɤ褤Ρ
	 * ¿ʬ褯ʤffmpegǤϤ PRIVATE_STREAM2 ΥɤäƤ
	 */
	code = (p[3] &0xff) | 0x100;
	if ( !((code >= 0x1c0 && code <= 0x1df) ||
				(code >= 0x1e0 && code <= 0x1ef) ||
				 (code == 0x1bd) || (code == 0x1fd))) {
		return -1;
	}
	/* PES ΥǡĹ */
	/* ưΥȥ꡼ǤˤϡESĹȤʤΤ0Ƥ */
	len_pes = AV_RB16(p+4);
	/* PESإåĥ(byte 6) */
	flags = p[6] & 0xff;
	if ( flags & 0x04 ) {
		data_alignment_indicator = true;
		/* data alignment indicator */
		/* video start code or audio syncword. */
		/* 餯Ƕڤȥԥñ */
		//printf("data alignment indicator found pid[%d].\n", pid);
	}
	flags = p[7] & 0xff;
	/* PESإåǡĹ(byte 8) */
	len_pesh = p[8] & 0xff;
	p += LENGTH_PES_HEADER;
	payload_offset += LENGTH_PES_HEADER +len_pesh;
	if ( p +payload_offset >= p_end ) {
		/* PESإåĹޤ */
		return -1;
	}

	/* flags
	 *      +---------------------------------------------------+
	 * name |byte 7(flags)                                      |
	 *      +-----+-----+-----+------+----------+----+----------+
	 * Bit  |76   |5    |4    |3     |2         |1   |0         |
	 *      +-----+-----+-----+------+----------+----+----------+
	 * field|PTS  |ESCR |ES   |DSM   |additional|PES |PES       |
	 * name |DTS  |FLAG |RATE |Trick |copy info |CRC |Extension |
	 *      |flag |     |flag |mode  |flag      |flag|flag      |
	 *      +-----+-----+-----+------+----------+----+----------+
	 * Data |5,5  |6    |3    |1     |1         |2   |1         |(24)
	 * byte |     |     |     |      |          |    |          |
	 *      +-----+-----+-----+------+----------+----+----------+
	 */
	if ( flags & PTS_FLAG ) {
		if ( p +LENGTH_PTS >= p_end ) {
			return -1;
		}
		pesbuf->pts = get_pts(p);
		p += LENGTH_PTS;
		len_pesh_supposed += LENGTH_PTS;
	}
	if ( flags & DTS_FLAG ) {
		if ( p +LENGTH_PTS >= p_end ) {
			return -1;
		}
		pesbuf->dts = get_pts(p);
		p += LENGTH_PTS;
		len_pesh_supposed += LENGTH_PTS;
	}
	if ( flags & ESCR_FLAG ) {
		p += 6;
		len_pesh_supposed += 6;
	}
	if ( flags & ES_RATE_FLAG ) {
		es_rate = AV_RB24(p);
		es_rate = (es_rate >>1) & 0x3fffff;
		es_rate = es_rate * 50;
		printf("pid[%d] es_rate[%d]Byte/Sec.\n", pid, es_rate);
		p += 3;
		len_pesh_supposed += 3;
	}
	if ( flags & DSM_TRICK_MODE_FLAG ) {
		p += 1;
		len_pesh_supposed += 1;
	}
	if ( flags & COPY_INFO_FLAG ) {
		p += 1;
		len_pesh_supposed += 1;
	}
	if ( flags & CRC_FLAG ) {
		p += 2;
		len_pesh_supposed += 2;
	}
	if ( flags & EXTENSION_FLAG ) {
		/* PES Extension flag
		 *      +------------------------------------------------------------------+
		 * name |PES Extension flag                                                |
		 *      +-----------+-----------+----------------+------+---+--------------+
		 * bit  |7          |6          |5               |4     |321|0             |
		 *      +-----------+-----------+----------------+------+---+--------------+
		 * field|PES private|pack header|program         |P-STD |111|PES extension |
		 * name |data flag  |field flag |packet          |buffer|   |flag2         |
		 *      |           |           |sequence counter|flag  |   |              |
		 *      +-----------+-----------+----------------+------+---+--------------+
		 * Data |16         |1          |2               |2     |   |1             |(23)
		 * byte |           |           |                |      |   |              |
		 *      +-----------+-----------+----------------+------+---+--------------+
		 */
		if ( p >= p_end ) {
			return -1;
		}
		pes_extension_flags = *p & 0xff;
		p += 1;
		len_pesh_supposed += 1;
		if ( pes_extension_flags & PES_PRIVATE_DATA_FLAG ) {
			p += 16;
			len_pesh_supposed += 16;
		}
		if ( pes_extension_flags & PACK_HEADER_FIELD_FLAG ) {
			p += 1;
			len_pesh_supposed += 1;
		}
		if ( pes_extension_flags & PROGRAM_PACKET_SEQUENCE_COUNTER ) {
			if ( p >= p_end ) {
				return -1;
			}
			program_packet_sequence_counter_flag = *p & 0xff;
			original_stuffing_length = program_packet_sequence_counter_flag & 0x3f;
			p += 2;
			len_pesh_supposed += 2;
		}
		if ( pes_extension_flags & PSTD_BUFFER_FLAG ) {
			p += 2;
			len_pesh_supposed += 2;
		}
		if ( pes_extension_flags & PES_EXTENSION_FLAG2 ) {
			/* PES Extension flag2
			 *      +------------------------------------------------------------------+
			 * name |PES Extension flag2                                               |
			 *      +------+-----------------------------------------------------------+
			 * bit  |7     |6543210                                                    |
			 *      +------+-----------------------------------------------------------+
			 * field|marker|PES_extension_field_length                                 |
			 * name |bit   |                                                           |
			 *      |'1'   |                                                           |
			 *      +------+-----------------------------------------------------------+
			 * Data |-     |0 <= N <= 127                                              |(127)
			 * byte |      |                                                           |
			 *      +------+-----------------------------------------------------------+
			 */
			if ( p >= p_end ) {
				return -1;
			}
			pes_extension_flags2 = *p & 0x7f;
			p += 1;
			len_pesh_supposed += 1;

			p += pes_extension_flags2;
			len_pesh_supposed += pes_extension_flags2;
		}
	}
	if ( pid != 6417 && pid != 6418 ) {
//		printf("es start? pid[%d]\n", pid);
	}
	/* ESѴ */
	payload_length = pesbuf->size -payload_offset;
//	if ( data_alignment_indicator ) { /* data_alignment_indicator ڤESϤ */
		if ( es_started ) { /* ES ˥ǡѤƤ */
			/*
			 * ӥǥեϤϤ(1. 2. )
			 * 1. ESGOPƬޤ
			 * 2. PTSCUEλ᤮Ƥ뤳( CUE <= PTS )
			 */
			if ( (is_video_stream(pid, esbuf) == 0) && !(esbuf->started) ) {
				/* VIDEO0 ƱδȤ */
				gop_start = search_gop_start_code(esbuf);
				if ( (gop_start != -1) && /* ESХåեGOP_START_CODE¸ߤ뤫 */
						(esbuf->Program->cue <= esbuf->pts*300) ) { /* CUE᤮Ƥ롩 */
					/* ȥ꡼եϳϤ */
					esbuf->started = 1;
					esbuf->Program->video_start = 1;
					esbuf->Program->video_pts = esbuf->pts;
					printf("video stream. pid[%d] v_pts[%llu].\n", pid, esbuf->pts);
				} else {
					/* GOPƬޤޤʤΤϥꥢ */
					esbuf_clear(esbuf, pesbuf->pts, pesbuf->dts);
				}
			} else if ( (is_video_stream(pid, esbuf) != -1) && !(esbuf->started) ) {
				/* VIDEO0 ʳΤΤVIDEO0 Ϥޤǥꥢ */
				if ( !(esbuf->Program->video_start) ) {
					/*
					 * VIDEO0 ϤޤäƤʤ硢
					 * VIDEON Ͼ˥ꥢ
					 */
					esbuf_clear(esbuf, pesbuf->pts, pesbuf->dts);
				} else {
					/*
					 * VIDEO0 ϤޤäƤ硢
					 * VIDEON Ͽ򳫻
					 */
					esbuf->started = 1;
				}
			}
			/*
			 * ǥեϤϤ(1. 2. )
			 * 1. ưѤϳϤƤ
			 * 2. ưGOP1ܤIԥPTSȥǥPTSӤưʲΤɤ餫
			 *    2.1. ʬ11msec(1024*90k/AACΥץ󥰼ȿ)
			 *         1024 : ADTSǡ1ե졼Υץ
			 *         90k  : PTSμȿ
			 *    2.2. ᤮Ƥ(᤮ƤϥǥESѤη³ȼGOPˤ롩)
			 *    ưꥪǥ¦ESХåեѤϤϥʤΤǵˤ뤳̵ʤ
			 */
			else if ( (is_audio_stream(pid, esbuf) != -1) && !(esbuf->started) ) {
				if ( !(esbuf->Program->video_start) ) {
					/*
					 * VIDEO ϤޤäƤʤ硢
					 * ESХåե;͵¤ꡢǥESХåեѤ³
					 */
					if ( esbuf->size + payload_length > sizeof esbuf->buffer ){
						/* 줽ˤʤä饯ꥢ */
						esbuf_clear(esbuf, pesbuf->pts, pesbuf->dts);
					}
				} else if ( esbuf->Program->video_start ) { /* video ѤϤƤ롩*/
					printf("audio stream. pid[%d] a_pts[%llu] v_pts[%llu] size[%d].\n", pid, esbuf->pts, esbuf->Program->video_pts, esbuf->size);
					audio_lipsync_offset = 0;
					audio_pts = esbuf->pts;
					adts_freq = AnalyzeAdifHeader(esbuf);
					adts_frame_time = (int64_t)((float)1024*90000/adts_freq); /* PTS90KHz */
					/* ǥե졼ñ̤ǼΤƤPTSʤ */
					while ( (esbuf->Program->video_pts > audio_pts +adts_frame_time/2) ) {
						/* ǥǡΤƤ audio_pts 1ե졼ʬ礭ʤ */
						i = next_adts_start_code(esbuf, audio_lipsync_offset); /* AACΥǡ */
						if ( i != -1 ) { /* AACǡνü */
							audio_lipsync_offset += i;
						} else {
							/* Хåեüޤǿʤ᤿ǥPTSŤESХåեϥꥢ */
							esbuf_clear(esbuf, pesbuf->pts, pesbuf->dts);
							break;
						}
						printf("audio stream drop. pid[%d] pts[%llu].\n", pid, audio_pts);
						audio_pts += adts_frame_time; /* AAC1ե졼ʬ֤ʤ */
					}
					if ( (esbuf->Program->video_pts <= audio_pts +adts_frame_time/2) ) {
						printf("lipsync start. v_pts[%llu] a_pts[%llu].\n", esbuf->Program->video_pts, audio_pts);
						memmove(esbuf->buffer +audio_lipsync_offset,
								esbuf->buffer,
								esbuf->size -audio_lipsync_offset);
						esbuf->size -= audio_lipsync_offset;
						esbuf->started = 1; /* ǥΥեϤͭ */
					}
				} else {
					; /* Τ̵Ϥ */
				}
			} else {
				/* ˽ʤ */
				;
			}
			/* Хåեե˽Ϥƥꥢ */
			if ( esbuf->started ) { /* ȥ꡼ϥեϤͭ򤵤Ƥ롩 */
				esbuf_write(esbuf);
				esbuf_clear(esbuf, pesbuf->pts, pesbuf->dts);
			}
		} else {
			/* ESѤ򿷤˳ */
			es_started = 1;
			esbuf->pts = pesbuf->pts;
			esbuf->dts = pesbuf->dts;
		}
	//}

	/* ESѽ */
	if ( es_started ) {
		/* ESѳϺѤ(줫ESѳϤޤ)ʤ顢payloadESȤɲ */
		esbuf_add(esbuf, pesbuf->buffer +payload_offset, payload_length);
	}
	/* 줵ޤǤ */
	return 0;
}

/* Program  N ܤ AUDIO STREAM Ǥ뤫ֵѤ */
static int is_audio_stream(const int pid, splitesbuf_t *esbuf)
{
	int i = 0;
	program_t* program = esbuf->Program;
	while (i < program->audio_nb)
	{
		if (program->audio[i] == pid) {
			return i;
		}
		i++;
	}
	return -1;
}

/* Program  N ܤ VIDEO STREAM Ǥ뤫ֵѤ */
static int is_video_stream(const int pid, splitesbuf_t *esbuf)
{
	int i = 0;
	program_t* program = esbuf->Program;
	while (i < program->video_nb)
	{
		if (program->video[i] == pid) {
			return i;
		}
		i++;
	}
	return -1;
}

/*
 * ESեϤ
 * 顼ϥɥ󥰤Ƥʤ͡
 */
static int esbuf_write(splitesbuf_t *esbuf)
{
	int remain = esbuf->size;
	while(remain > 0)
	{
		remain -= write(esbuf->fd, esbuf->buffer+(esbuf->size-remain), remain);
	}
	return 0;
}

#if 0
̤Ѥʤ
/*
 * packet dump
 */
void dump_packet( const uint8_t *packet )
{
	int i = 0;
	uint8_t *p = (uint8_t*)packet;
	char tmp[17];

	printf("HEADER 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F  <ASCII>\n");
	while(i < LENGTH_PACKET) {
		if ( (i%16) == 0 ) {
			printf("0x%04X ", i);
		}
		printf("%02x ", *(p+i));
		if ( isprint(*(p+i)) ){
			tmp[i%16] = *(p+i);
		}
		else {
			tmp[i%16] = '.';
		}
		if ((i%16) == 15) {
			tmp[sizeof(tmp)-1] = '\0';
			printf(" %s\n", tmp);
		}
		i++;
	}
	putchar('\n');
}
#endif

/*
 * TOT  JST_time Ϥ
 */
static int parse_tot( const unsigned char* packet, time_t *t )
{
	/* ջ
	 *  TOT ͭɤå٤ǤƤޤ
	 * ޡط̵뤷Ƥޤ
	 */
	struct tm tm;
	time_t t2;
	int k;
	uint8_t *p = (uint8_t*)packet;
	unsigned int MJD;
	tm.tm_wday = 0;
	tm.tm_yday = 0;
	tm.tm_isdst = 0;

	p += 8;
	MJD = (*(p) & 0xff) <<8;
	p++;
	MJD |= *(p) & 0xff;
	printf("MJD[%x].\n", MJD);

	/* ARIB STD-B10 2 ϿC θ MJD to YYYYMMDD */
	tm.tm_year = (int)floor((MJD - 15078.2)/365.25);
	tm.tm_mon = (int)floor((MJD - 14956.1 - floor(tm.tm_year * 365.25))/30.6001);
	tm.tm_mday = MJD - 14956 - floor(tm.tm_year * 365.25) - floor(tm.tm_mon * 30.6001);
	if ( tm.tm_mon == 14 || tm.tm_mon == 15 )
		k = 1;
	else
		k = 0;
	tm.tm_year += k;
	tm.tm_mon = tm.tm_mon -1 - k * 12;
	tm.tm_mon--;

	/* HHMISS2ʲ10ʿ */
	p++;
	tm.tm_hour = ((*p & 0xf0) >>4)*10 + (*p & 0x0f);
	p++;
	tm.tm_min = ((*p & 0xf0) >>4)*10 + (*p & 0x0f);
	p++;
	tm.tm_sec = ((*p & 0xf0) >>4)*10 + (*p & 0x0f);

	*t = mktime(&tm);
	time(&t2);
//	printf("time[%d] TOT[%d].\n", t2, *t);

	return TRUE;
}

static int64_t get_pts(const uint8_t *p)
{
	int64_t pts = (int64_t)((p[0] >> 1) & 0x07) << 30;
	pts |= (AV_RB16(p + 1) >> 1) << 15;
	pts |=  AV_RB16(p + 3) >> 1;
	return pts;
}

static int get_pmt_version(const uint8_t *p)
{
	return ((p[6] >> 1) & 0x1f);
}

#if 0
̤Ѥʤ
void search_mpeg_system_header(const uint8_t *packet)
{
	int i;
	uint8_t *p = (uint8_t*)packet;
	i = 0;
	for( i=0; i < LENGTH_PACKET-4; i++) {
		if( p[i] == 0x00 && p[i+1] == 0x00 && p[i+2] == 0x01 && p[i+3] == 0xb8 ){
			dump_packet(packet );
		}
	}
}
#endif

/*
 * δؿǤϡߤλͤǤϡƬ֤ΡּΡADTS start codeޤǤĹֵѤ
 * ret == 0  : ;夢ʤ(esbufƬϥإåƬǤ뤿)
 * ret >  0  : Ĥä
 * ret == -1 : Ĥʤä
 */
static int next_adts_start_code(splitesbuf_t *esbuf, int offset)
{
	/*
	 * start code prefix ΤƬ12bit  1 
	 */
	uint16_t adts_start_code = 0xfff0;
	int i = offset +1;
	uint16_t startcode = 0;

	/*  */
	if(esbuf->size -offset < sizeof(adts_start_code)){
		return -1;
	}
	for(; i < esbuf->size - sizeof(adts_start_code); i++) {
		startcode = AV_RB16(esbuf->buffer+i);
		if( startcode == adts_start_code ) { /* ֤12bitϢ³1ΩäƤ뤫 */
#if 0
			printf("adts start code found.i[%d]. 0[%02x] 1[%02x] 2[%02x] 3[%02x] 4[%02x] 5[%02x] 6[%02x]\n",
					i, *(esbuf->buffer+i+0), *(esbuf->buffer+i+1), *(esbuf->buffer+i+2), *(esbuf->buffer+i+3), *(esbuf->buffer+i+4), *(esbuf->buffer+i+5), *(esbuf->buffer+i+6) );
#endif
			return (i-offset);
		}
	}
	return -1;
}

/* ADIF HEADER */
static int AnalyzeAdifHeader(splitesbuf_t *esbuf)
{
	int id = 0;									/* 0:MPEG-4 1:MPEG-2 */
	int layer = 0;								/*  0x00 */
	int protection_absent = 0;					/* ݸ° 0:ݸʤ 1:ݸ */
	int profile = 0;							/* 00:MAIN 01:LC 10:SSR 11:(reserved) */
	int sampling_frequency_index = 0;			/* ץ󥰼ȿơ֥ */
	int private_bit = 0;						/* private bit */
	int channel_configuration = 0;				/* ͥ */
	int original_copy = 0;
	int home = 0;								/* homeäƤʤˡ */
	int copyright_identification_bit = 0;		/* ӥå */
	int copyright_identification_start = 0;		/* ϥӥå */
	int aac_frame_length = 0;					/* AACե졼Ĺ */
	int adts_buffer_fullness = 0;				/* ADTSХåե */
	int no_raw_data_blocks_in_frame = 0;		/* ǡ֥åޤǤλ */
	/*
	 * ץ󥰼ȿơ֥(إåsampling_frequency_indexź)
	 * ñ̡Hz
	 */
	int sampling_frequency_table[16] =
	{
		96000,
		88200,
		64000,
		48000,
		44100,
		32000,
		24000,
		22050,
		16000,
		12000,
		11025,
		8000,
		-1,
		-1,
		-1,
		-1
	};

	uint8_t *p = esbuf->buffer;
	if ( esbuf->size < 8 ) {
		return -1;
	}

	id								= get_adif_id(p+1);
	layer							= get_adif_layer(p+1);
	protection_absent				= get_adif_protection_absent(p+1);
	profile							= get_adif_profile(p+2);
	sampling_frequency_index		= get_adif_sampling_frequency_index(p+2);
	private_bit						= get_adif_private_bit(p+2);
	channel_configuration			= get_adif_channel_configuration(p+3);
	original_copy					= get_adif_original_copy(p+3);
	home							= get_adif_home(p+3);
	copyright_identification_bit	= get_adif_copyright_idication_bit(p+3);
	copyright_identification_start	= get_adif_copyright_idication_start(p+3);
	aac_frame_length				= get_adif_aac_frame_length(p+3);
	adts_buffer_fullness			= get_adts_buffer_fullness(p+5);
	no_raw_data_blocks_in_frame		= get_adts_no_raw_data_blocks_in_frame(p+5);

	/*
	 * Ȥꤢ return  ץ󥰼ȿȤƤ
	 * ϼ¤ΤˤֵѤΤɡ
	 * ѤͽʤΤǼˤƤ
	 */
	return sampling_frequency_table[sampling_frequency_index];
}

static int get_adif_id(uint8_t *p)
{
	return ((*p & 0x08) >>3);
}

static int get_adif_layer(uint8_t *p)
{
	return ((*p & 0x06) >>1);
}

static int get_adif_protection_absent(uint8_t *p)
{
	return (*p & 0x01);
}

static int get_adif_profile(uint8_t *p)
{
	return ((*p & 0xc0) >>6);
}

static int get_adif_sampling_frequency_index(uint8_t *p)
{
	return ((*p & 0x3c) >>2);
}

static int get_adif_private_bit(uint8_t *p)
{
	return ((*p & 0x02) >>1);
}

static int get_adif_channel_configuration(uint8_t *p)
{
	return ((*p & 0x01) <<2 | (*(p+1) & 0xc0 >>6) );
}

static int get_adif_original_copy(uint8_t *p)
{
	return (*p & 0x20 >>5 );
}

static int get_adif_home(uint8_t *p)
{
	return (*p & 0x10 >>4 );
}

static int get_adif_copyright_idication_bit(uint8_t *p)
{
	return (*p & 0x08 >>3 );
}

static int get_adif_copyright_idication_start(uint8_t *p)
{
	return (*p & 0x04 >>2 );
}

static int get_adif_aac_frame_length(uint8_t *p)
{
	return ( ((*p & 0x02) <<11) || ((*(p+1) & 0xff) <<3) || ((*(p+2) & 0xe0) >>5) );
}

static int get_adts_buffer_fullness(uint8_t *p)
{
	return ( ((*p & 0x1f) <<6) || ((*(p+1) &0xfc) >>2));
}

static int get_adts_no_raw_data_blocks_in_frame(uint8_t *p)
{
	return (*p & 0x03);
}

#define GOP_START_CODE (0x000001b8)
/* GOP START CODE 򸡺 */
static int search_gop_start_code(splitesbuf_t *esbuf)
{
	uint32_t gop_start_code = GOP_START_CODE;
	int i;

	/*  */
	if ( esbuf->size < sizeof gop_start_code ){
		return -1;
	}
	for(i = 0; i < esbuf->size - sizeof gop_start_code; i++) {
		if ( (AV_RB32(esbuf->buffer +i)) == gop_start_code ) {
			return i;
		}
	}
	return -1;
}

/* ES Ϥե */
static int creat_es_file(splitter *sp, int sid, int pid, int av_flag)
{
	/*
	 * ESե̿̾§ϰʲȤ
	 *
	 * ե̾Υ١ --es ץΰ
	 * ʲη̿̾ơե륪ץޤǼ»ܤ롣
	 * ե̾prefix_SID_AVΥץֹ.m2v
	 * ե̾prefix_SID_AVΥץֹ.aac
	 *
	 * ա
	 * MPEG-2/MPEG-4 AAC ʳΥǥ褿ν̤
	 */

	char filename[PATH_MAX];
	int size = 0;
	char *suffix = NULL;
	int av_nb = 0;
	char suffix_a[] = "aac";
	char suffix_v[] = "m2v";
	filename[0] = '\0';

	/* äȤդΥɥƤʤΤǸ夫ľ */
	if ( av_flag == TSS_STREAM_TYPE_VIDEO ) {
		suffix = suffix_v;
		av_nb = sp->program[sid].video_nb -1;
	} else if ( av_flag ==  TSS_STREAM_TYPE_AUDIO ){
		suffix = suffix_a;
		av_nb = sp->program[sid].audio_nb -1;
	} else {
		/* Ϥꤨʤ */
		return -1;
	}
	size = strlen(sp->filename);

	if ( size +16 < sizeof(filename) ) {
		snprintf(filename, sizeof(filename), "%s_%05d_%02d.%s", sp->filename, sid, av_nb, suffix);
		filename[PATH_MAX-1] = '\0';
	} else {
		/* ե̾ĤʤƺǤδ */
		return -1;
	}
	umask(0133);
	if ( !(sp->esbuf[pid]->fd = open(filename, O_CREAT|O_APPEND|O_RDWR, 00644)) ) {
		fprintf(stderr, "cannot open es out file. file[%s].\n", filename);
		return -1;
	}
	return 0;
}

static time_t cue2time(char *yyyymmddhhmiss)
{
	struct tm cue_tm;
	time_t cue_time;
	char *p;
	int i, j;
	char str_yyyy[5];
	char str_mm[3];
	char str_dd[3];
	char str_hh[3];
	char str_mi[3];
	char str_ss[3];
	str_yyyy[0] = '\0';
	str_mm[0] = '\0';
	str_dd[0] = '\0';
	str_hh[0] = '\0';
	str_mi[0] = '\0';
	str_ss[0] = '\0';

	p = yyyymmddhhmiss;
	i = strlen(p); 
	j = strspn(p, LIST_DECIMAL);
	if ( i != j && i != 14 ) {
		/* ʳ */
		return -1;
	}
	strncpy(str_yyyy, yyyymmddhhmiss, 4);
	strncpy(str_mm, yyyymmddhhmiss+4, 2);
	strncpy(str_dd, yyyymmddhhmiss+6, 2);
	strncpy(str_hh, yyyymmddhhmiss+8, 2);
	strncpy(str_mi, yyyymmddhhmiss+10, 2);
	strncpy(str_ss, yyyymmddhhmiss+12, 2);
	str_yyyy[4] = '\0';
	str_mm[2] = '\0';
	str_dd[2] = '\0';
	str_hh[2] = '\0';
	str_mi[2] = '\0';
	str_ss[2] = '\0';

	cue_tm.tm_sec = atoi(str_ss);
	cue_tm.tm_min = atoi(str_mi);
	cue_tm.tm_hour = atoi(str_hh);
	cue_tm.tm_mday = atoi(str_dd);
	cue_tm.tm_mon = atoi(str_mm)-1;
	cue_tm.tm_year = atoi(str_yyyy)-1900;
	cue_tm.tm_isdst = -1;
	cue_time = mktime(&cue_tm);
	return cue_time;
}

/* PCR  PID 򸡺 */
static int search_pcr_pid(splitter *sp, int pid)
{
	int i;
	for ( i=0; i < MAX_SERVICES; i++ ) {
		if ( sp->pcr[i].pid == pid ) {
			return i;
		}
	}
	return -1;
}
