/* -*- tab-width: 4; indent-tabs-mode: nil -*- */
#ifndef _RECPT1_H_
#define _RECPT1_H_
#include <sys/types.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include "decoder.h"
#include "tssplitter_lite.h"

#define HAVE_LIBARIB25 1
#define NUM_BSDEV       8
#define NUM_ISDB_T_DEV  8
#define CHTYPE_SATELLITE    0        /* satellite digital */
#define CHTYPE_GROUND       1        /* terrestrial digital */
#define MAX_QUEUE           8192
#define MAX_READ_SIZE       (188 * 87) /* 188*87=16356 splitter188饤ȤԤƤΤǤοȤ*/
#define WRITE_SIZE          (1024 * 1024 * 2)
#define TRUE                1
#define FALSE               0
#define STREAM_MAX (16)


/* type definitions */
typedef int boolean;

typedef struct _BUFSZ {
    int size;
    u_char buffer[MAX_READ_SIZE];
} BUFSZ;

typedef struct _QUEUE_T {
    unsigned int in;        // 륤ǥå
    unsigned int out;        // ˽Фǥå
    unsigned int size;        // 塼Υ
    unsigned int num_avail;    // ˤʤ 0 ˤʤ
    unsigned int num_used;    // äݤˤʤ 0 ˤʤ
    pthread_mutex_t mutex;
    pthread_cond_t cond_avail;    // ǡΤȤԤĤ cond
    pthread_cond_t cond_used;    // ǡΤȤԤĤ cond
    BUFSZ *buffer[1];    // Хåեݥ
} QUEUE_T;

typedef struct _STREAM_QUEUE_T {
    unsigned int in;        // 륤ǥå
    unsigned int out;        // ˽Фǥå
    unsigned int size;        // 塼Υ
    unsigned int num_avail;    // ˤʤ 0 ˤʤ
    unsigned int num_used;    // äݤˤʤ 0 ˤʤ
    pthread_mutex_t mutex;
    pthread_cond_t cond_avail;    // ǡΤȤԤĤ cond
    pthread_cond_t cond_used;    // ǡΤȤԤĤ cond
    ARIB_STD_B25_BUFFER   *buffer[1];    // Хåեݥ
} STREAM_QUEUE_T;

typedef struct _ISDB_T_FREQ_CONV_TABLE {
    int set_freq;    // ºݤioctl()Ԥ
    int type;        // ͥ륿
    int add_freq;    // ɲäȿ(BS/CSξϥåֹ)
    char *parm_freq;    // ѥ᡼Ǽ
} ISDB_T_FREQ_CONV_TABLE;

typedef struct sock_data {
    int sfd;    /* socket fd */
    struct sockaddr_in addr;
} sock_data;

typedef struct _session {
    int id;
    int is_valid;
    QUEUE_T *p_queue;
} session;

typedef struct _streamer {
    pthread_mutex_t mutex;   //openclose(recpt1)write
    int stream_nr;
    session *stream_session[STREAM_MAX]; //NULLߤ
} streamer;

typedef struct thread_data {
    QUEUE_T *queue;
    QUEUE_T *stream_queue;
    decoder *decoder;
    decoder_options *dopt;
    int ch;
    int lnb;    /* LNB voltage */
    int tfd;    /* tuner fd */
    int wfd;    /* output file fd */
    ISDB_T_FREQ_CONV_TABLE *table;
    sock_data *sock_data;
    pthread_t signal_thread;
    int recsec;
    time_t start_time;
    boolean indefinite;
    int msqid;
    splitter *splitter;
    streamer *streamer;
} thread_data;

QUEUE_T *create_queue(size_t size);
BUFSZ * dequeue(QUEUE_T *p_queue);
void destroy_queue(QUEUE_T *p_queue);
void destroy_stream_queue(STREAM_QUEUE_T *p_queue);

#endif
