#!/usr/bin/perl -w
# epgdmp_xml_parse.pl -- parse epgdump XML file.
#
#   Copyright 2012 Naoya OYAMA <naoya.oyama@gmail.com>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

use strict;
use XML::Simple;

my $simple = XML::Simple->new (ForceArray => 1, KeepRoot => 1);
my $data   = $simple->XMLin($ARGV[0]);

my @base              = @{$data->{tv}};
my %tv                = %{$base[0]};
my %channels          = %{$tv{channel}};
my %channel_info_list = ();
my @service_id_list   = ();

while (my ($channelType, $channelRef) = each %channels) {
	my %channel    = %$channelRef;
	my $service_id = $channel{service_id};
	my @si         = ();
	my %sih        = ();
	my $tp         = "";
	my $slot       = "";

	if (defined($channel{satelliteinfo})) {
		@si    = @{$channel{satelliteinfo}};
		%sih   = %{$si[0]};
		$tp    = $sih{TP}[0];
		if ($tp =~ /BS/) {
			$slot  = $sih{SLOT}[0];
		}
	} else {
		$tp    = $ARGV[0];
		$tp    =~ s/^.*\/(\d+)\.xml$/$1/;
	}
	my @dpna       = @{$channel{"display-name"}};
	my %dpnh       = %{$dpna[0]};

	$channel_info_list{$service_id}{SID}  = $service_id;
	$channel_info_list{$service_id}{TP}   = $tp;
	if ($slot =~ /\d/) {
		$channel_info_list{$service_id}{SLOT} = "_" . $slot;
	}
	$channel_info_list{$service_id}{NAME} = $dpnh{content};
	push(@service_id_list, $service_id);
}

foreach my $service_id (sort {$a <=> $b} @service_id_list) {
	print $channel_info_list{$service_id}{SID}  . ",";
	print $channel_info_list{$service_id}{TP}        ;
	print $channel_info_list{$service_id}{SLOT} . ",";
	print $channel_info_list{$service_id}{NAME} . "\n";
}
1;
