/* -*- tab-width: 4; indent-tabs-mode: t -*- */
/* vim: set ts=4 sts=4 sw=4 noexpandtab number : */
/* tssplitter_lite.h  -- split TS stream program's header.

   Copyright 2009 querulous
   Copyright 2010 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */
#ifndef _TS_SPLITTER_LITE_H_
#define _TS_SPLITTER_LITE_H_

#define __STDC_FORMAT_MACROS
#include <inttypes.h>
#include <unistd.h>
#include <limits.h>

#define LENGTH_PACKET		(188)
#define MAX_PID				(8192)
#define MAX_SERVICES		(50)
#define LENGTH_CRC_DATA		(176)
#define false				(0)
#define true				(1)

#define TSS_SUCCESS			(0)
#define TSS_ERROR			(-1)
#define TSS_NULL			(-2)
#define LENGTH_PAT_HEADER	(12)
#define C_CHAR_COMMA		','
#define C_CHAR_DOT			'.'
#define LENGTH_TS_HEADER (4)
#define LENGTH_PES_HEADER (9)
#define LENGTH_PTS (5)

/* ǥǥʽ() P101 ɽ1 ARIBǤPSI/SIμ껲 */
#define PAT					(0x0000)
//#define PMT						 /* PATˤܻ */
#define CAT					(0x0001)
#define NIT					(0x0010)
#define SDT					(0x0011)
#define BAT					(0x0011)
#define EIT					(0x0012) /* 0x0026, 0x0027 */
#define RST					(0x0013)
#define TDT					(0x0014) /* ϥǥǤϻѤʤ */
#define TOT					(0x0014)
#define LIT					(0x0020) /* ޤPMTˤܻ */
#define	ERT					(0x0021) /* ޤPMTˤܻ */
//#define ITT						 /* PMTˤܻ */
#define PCAT				(0x0022)
#define BIT					(0x0024)
#define NBIT				(0x0025)
//#define ECM						 /* PMTˤܻ */
//#define EMM						 /* CATˤܻ */
#define LDT					(0x0025)
#define DCT					(0x0017)
//#define DTL						 /* DCTˤܻ */
#define DIT					(0x001e)
#define SIT					(0x001f)
#define SDTT				(0x0023)
#define CDT					(0x0029)
//#define DSM-CC_Section			 /* PMTˤܻ */

/* إåĹ */
/* TS ѥåȤ˳ƥ֤ݡTSѥåȤλĥ
 * İʾ夢н񤭹뤫Ƚ˻Ѥ롣
 * ǥɤˤϤޤפǤ̵
 */
#define SECTION_LENGTH_PAT	(8)
#define SECTION_LENGTH_PMT	(8)
#define SECTION_LENGTH_CAT	(8)
#define SECTION_LENGTH_NIT	(8)
#define SECTION_LENGTH_BIT	(8)
#define SECTION_LENGTH_SDT	(11)
#define SECTION_LENGTH_EIT	(14) /* H-EIT, M-EIT, L-EIT 򼨤 */
#define SECTION_LENGTH_SDTT	(15)
#define SECTION_LENGTH_CDT	(13)
#define SECTION_LENGTH_TOT	(10)

enum {
	PTS_FLAG = 0x80,
	DTS_FLAG = 0x40,
	ESCR_FLAG = 0x20,
	ES_RATE_FLAG = 0x10,
	DSM_TRICK_MODE_FLAG = 0x08,
	COPY_INFO_FLAG = 0x04,
	CRC_FLAG = 0x02,
	EXTENSION_FLAG = 0x01
};

enum {
	PES_PRIVATE_DATA_FLAG = 0x80,
	PACK_HEADER_FIELD_FLAG = 0x40,
	PROGRAM_PACKET_SEQUENCE_COUNTER = 0x20,
	PSTD_BUFFER_FLAG = 0x10,
	PES_EXTENSION_FLAG2 = 0x01
};

/*
 * PCRSTC()
 * 1. PCRļޤǥ롼(1.4.ޤǤϽǼ»ܤ뤳)
 * 2. 롼׳ϻ(PCR)ȡ롼ȴ(PCR)κʬ
 * 3. 롼׳ϡλδ֤˽ѥåȿ
 * 4. (2.PCRοʤ/3.Υѥåȿ)η׻ˤäơ1ѥåȤˤäƿʤPCRꤹ
 * 5. TSˡ1ĤΥѥåȤ٤4.ꤹвPCR­STCȤ
 * 6. PCR򿷵˼顢STC(Τޤ)
 */
#define MAX_VIDEO (16)
#define MAX_AUDIO (32)
typedef struct _program_t
{
	int64_t stc;
	int64_t cue;		/* Ͽ賫ϻ */
	int pmt_packet_id;	/* Program(Service ID)бPMT */
	int pmt_version;	/* Program(Service ID)бPMTVersion */
	int pcr_packet_id;	/* Program(Service ID)PCRݻPID */
	int64_t pcr1;	/* PCR1 */
	int64_t pcr2;	/* PCR2 */
	int pcr_packet_nb;	/* ľPCRȤΥѥåȿ */
	int packet_nb;	/* ľProgramν»ܤȤΥѥåȿ */
	int64_t pcr_incr;	/* Program(Service ID)˱ơ1ĤTSѥåȤ˷в᤹(ꤹ) */
	int video_start;		/* VODEO0ѳϤƤ롩 */
	int64_t video_pts;		/* Ǹ˽VODEO0ESPTS */
	int video_nb;			/* PMT ¸ߤӥǥȥ꡼ο */
	int audio_nb;			/* PMT ¸ߤ벻ȥ꡼ο */
	int video[MAX_VIDEO];	/* PSϤ˻Ȥ */
	int audio[MAX_AUDIO];	/* PSϤ˻Ȥ */
} program_t;
/*
 * program_t 򥵡ӥIDʬơѤ륤᡼Ǥɡ
 * ӥIDκͤ0xFFFFǤΤǡŪ˳ݤ stack ñ˰Τǡ
 * ¹Ի malloc Ȥ뤫ʤ
 * ɬפʤallocΤޤΤɡ
 */

typedef struct _splitpesbuf_t
{
	program_t *Program;
	int64_t pts;
	int64_t dts;
    int size;
    u_char buffer[3*1024*1024];
} splitpesbuf_t;

typedef struct _splitesbuf_t
{
	program_t *Program;
	int64_t pts;
	int64_t dts;
	int started; /* ESѳϤƤ뤫 */
	int random_access_indicator; /* TS  random_access_indicator */
	int fd; /* ESfd */
    int size;
    u_char buffer[3*1024*1024];
} splitesbuf_t;

/* PCR ͭѹ¤ */
typedef struct _pcr_t
{
	int pid;
	int sid_nb; /* PCR򻲾ȤƤServiceID(ProgramID)ο */
	int sid[MAX_SERVICES];
} pcr_t;


/**
 * splitter¤
 */
typedef struct splitter {
	char *filename; /* ե̤̾äƤ뤿Υݥ */
	char *arg_cue; /* ǼƤϿ賫ϻ(HHMISS) */
	int esout; /* ESϤ롩 */
	unsigned char	pids[MAX_PID];
	unsigned char	pmt_pids[MAX_PID];
	uint8_t			cat_pids[MAX_PID];
	uint8_t			pcr_pids[MAX_PID]; /* PCRʣServiceID(ProgramID)Ƕͭ */
	pcr_t			pcr[MAX_SERVICES];
	int				pcr_nb;
	unsigned char*	pat;
	char**			sid_list;
	unsigned char	pat_count;
	int pmt_retain;
	int pmt_counter;
	int avail_pmts[MAX_SERVICES];
	int num_pmts;
	splitpesbuf_t *pesbuf[MAX_PID];
	splitesbuf_t *esbuf[MAX_PID];
	program_t *program;
	int pid_sid_table[MAX_PID]; /* pid to sid ѴԤΥơ֥ */
	time_t time_cue;
	time_t time_tot;
	int tot_packet_nb; /* TOTΥѥåȼ */
} splitter;

/* b25 decoder would hoard up large chank */
typedef struct _splitbuf_t
{
    int size;
    u_char buffer[1024*1024];
} splitbuf_t;

splitter* split_startup(char *sid, char *filename, char *cue_time);
int split_select(splitter *sp, ARIB_STD_B25_BUFFER *sbuf);
void split_shutdown(splitter *sp);
int split_ts(splitter *splitter, ARIB_STD_B25_BUFFER *sbuf, splitbuf_t *dbuf);

#endif
