/* tssplitter_lite.h  -- split TS stream program's header.

   Copyright 2009 querulous
   Copyright 2010 Naoya OYAMA <naoya.oyama@gmail.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */
#ifndef _TS_SPLITTER_LITE_H_
#define _TS_SPLITTER_LITE_H_
#if defined(WIN32)
	#include <io.h>
	#include <windows.h>
	#include <crtdbg.h>
	
	#pragma warning(disable: 4996)
#else
	#define __STDC_FORMAT_MACROS
	#include <inttypes.h>
	#include <unistd.h>
//	#include "portable.h"
#endif

#define LENGTH_PACKET		(188)
#define MAX_PID				(8192)
#define LENGTH_CRC_DATA		(176)
#define false				(0)
#define true				(1)

#define TSS_SUCCESS			(0)
#define TSS_ERROR			(-1)
#define TSS_NULL			(-2)
#define LENGTH_PAT_HEADER (12)
#define C_CHAR_COMMA		','

/**
 * splitter¤
 */
typedef struct splitter {
	unsigned char	pids[MAX_PID];
	unsigned char	pmt_pids[MAX_PID];
	unsigned char*	pat;
	char**			sid_list;
	unsigned char	pat_count;
	int pmt_drop;
	int pmt_counter;
} splitter;

char** AnalyzeSid(char* sid);
splitter* split_startup(char *sid);
int split_select(splitter *sp, ARIB_STD_B25_BUFFER *sbuf);
void split_shutdown( splitter* sp);
int ReadTs( unsigned char** pat, unsigned char* pids, char** sid_list, unsigned char* pmt_pids, ARIB_STD_B25_BUFFER *sbuf, int* pmt_drop, int* pmt_counter);
//int split_ts( unsigned char** pat, unsigned char* pids, ARIB_STD_B25_BUFFER *sbuf, BUFSZ *dbuf);
int split_ts( splitter *splitter, ARIB_STD_B25_BUFFER *sbuf, BUFSZ *dbuf);
int AnalyzePat(unsigned char* buf, unsigned char** pat, unsigned char* pids, char** sid_list, unsigned char* pmt_pids, int* pmt_drop);
int RecreatePat(unsigned char* buf, unsigned char** pat, unsigned char* pids, int *pos);
int AnalyzePmt(unsigned char* buf, unsigned char* pids);

int GetCrc32(unsigned char* data, int len);
int GetPid(unsigned char* data);
#endif
