#
# global.mak
#
# This file should be included by all Makefile.mingw files for project
# wide definitions (after correctly defining PIDGIN_TREE_TOP).
#

#include optional $(PIDGIN_TREE_TOP)/local.mak to allow overriding of any definitions
-include $(PIDGIN_TREE_TOP)/local.mak

# Locations of our various dependencies
WIN32_DEV_TOP ?= $(PIDGIN_TREE_TOP)/../win32-dev
ASPELL_TOP ?= $(WIN32_DEV_TOP)/aspell-dev-0-50-3-3
GTKSPELL_TOP ?= $(WIN32_DEV_TOP)/gtkspell-2.0.11-daa1
GTK_TOP ?= $(WIN32_DEV_TOP)/gtk_2_0-2.14
GTK_BIN ?= $(GTK_TOP)/bin
BONJOUR_TOP ?= $(WIN32_DEV_TOP)/Bonjour_SDK
LIBXML2_TOP ?= $(WIN32_DEV_TOP)/libxml2-2.7.4
MEANWHILE_TOP ?= $(WIN32_DEV_TOP)/meanwhile-1.0.2_daa2
NSPR_TOP ?= $(WIN32_DEV_TOP)/nspr-4.6.4
NSS_TOP ?= $(WIN32_DEV_TOP)/nss-3.11.4
PERL_LIB_TOP ?= $(WIN32_DEV_TOP)/perl-5.10.0
SILC_TOOLKIT ?= $(WIN32_DEV_TOP)/silc-toolkit-1.1.8
TCL_LIB_TOP ?= $(WIN32_DEV_TOP)/tcl-8.4.5
GSTREAMER_TOP ?= $(WIN32_DEV_TOP)/gstreamer-0.10.13

# Where we installing this stuff to?
PIDGIN_INSTALL_DIR := $(PIDGIN_TREE_TOP)/win32-install-dir
PURPLE_INSTALL_DIR := $(PIDGIN_TREE_TOP)/win32-install-dir
PIDGIN_INSTALL_PLUGINS_DIR := $(PIDGIN_INSTALL_DIR)/plugins
PIDGIN_INSTALL_PERL_DIR := $(PIDGIN_INSTALL_PLUGINS_DIR)/perl
PURPLE_INSTALL_PLUGINS_DIR := $(PURPLE_INSTALL_DIR)/plugins
PURPLE_INSTALL_PERL_DIR := $(PURPLE_INSTALL_PLUGINS_DIR)/perl
PURPLE_INSTALL_PO_DIR := $(PURPLE_INSTALL_DIR)/locale

# Important (enough) locations in our source code
PURPLE_TOP := $(PIDGIN_TREE_TOP)/libpurple
PURPLE_PLUGINS_TOP := $(PURPLE_TOP)/plugins
PURPLE_PERL_TOP := $(PURPLE_PLUGINS_TOP)/perl
PIDGIN_TOP := $(PIDGIN_TREE_TOP)/pidgin
PIDGIN_IDLETRACK_TOP := $(PIDGIN_TOP)/win32/IdleTracker
PIDGIN_PIXMAPS_TOP := $(PIDGIN_TOP)/pixmaps
PIDGIN_PLUGINS_TOP := $(PIDGIN_TOP)/plugins
PURPLE_PO_TOP := $(PIDGIN_TREE_TOP)/po
PURPLE_PROTOS_TOP := $(PURPLE_TOP)/protocols

# Locations of important (in-tree) build targets
PIDGIN_CONFIG_H := $(PIDGIN_TREE_TOP)/config.h
PURPLE_CONFIG_H := $(PIDGIN_TREE_TOP)/config.h
PIDGIN_REVISION_H := $(PIDGIN_TREE_TOP)/package_revision.h
PIDGIN_REVISION_RAW_TXT := $(PIDGIN_TREE_TOP)/package_revision_raw.txt
PIDGIN_IDLETRACK_DLL := $(PIDGIN_IDLETRACK_TOP)/idletrack.dll
PURPLE_PURPLE_H := $(PURPLE_TOP)/purple.h
PURPLE_VERSION_H := $(PURPLE_TOP)/version.h
PURPLE_DLL := $(PURPLE_TOP)/libpurple.dll
PURPLE_PERL_DLL := $(PURPLE_PERL_TOP)/perl.dll
PIDGIN_DLL := $(PIDGIN_TOP)/pidgin.dll
PIDGIN_EXE := $(PIDGIN_TOP)/pidgin.exe
PIDGIN_PORTABLE_EXE := $(PIDGIN_TOP)/pidgin-portable.exe

GCCWARNINGS ?= -Waggregate-return -Wcast-align -Wdeclaration-after-statement -Werror-implicit-function-declaration -Wextra -Wno-sign-compare -Wno-unused-parameter -Winit-self -Wmissing-declarations -Wmissing-prototypes -Wnested-externs -Wpointer-arith -Wundef

# parse the version number from the configure.ac file if it is newer
#m4_define([purple_major_version], [2])
#m4_define([purple_minor_version], [0])
#m4_define([purple_micro_version], [0])
#m4_define([purple_version_suffix], [devel])
PIDGIN_VERSION := $(shell \
  if [ ! $(PIDGIN_TREE_TOP)/VERSION -nt $(PIDGIN_TREE_TOP)/configure.ac ]; then \
    awk 'BEGIN {FS="[\\(\\)\\[\\]]"} /^m4_define..purple_(major|minor)_version/ {printf("%s.",$$5);} /^m4_define..purple_micro_version/ {printf("%s",$$5);} /^m4_define..purple_version_suffix/ {printf("%s",$$5); exit}' \
      $(PIDGIN_TREE_TOP)/configure.ac > $(PIDGIN_TREE_TOP)/VERSION; \
  fi; \
  cat $(PIDGIN_TREE_TOP)/VERSION \
)
PURPLE_VERSION := $(PIDGIN_VERSION)
ifdef EXTRAVERSION
DISPLAY_VERSION := $(PIDGIN_VERSION)-$(EXTRAVERSION)
else
DISPLAY_VERSION := $(PIDGIN_VERSION)
endif

CYRUS_SASL ?= 1

ifeq ($(CYRUS_SASL), 1)
DEFINES += -DHAVE_CYRUS_SASL
endif

DEFINES += -DHAVE_CONFIG_H -DWIN32_LEAN_AND_MEAN

# Use -g flag when building debug version of Pidgin (including plugins).
# Use -fnative-struct instead of -mms-bitfields when using mingw 1.1
# (gcc 2.95)
CFLAGS += -O2 -Wall $(GCCWARNINGS) -pipe -mno-cygwin -mms-bitfields -g

# If not specified, dlls are built with the default base address of 0x10000000.
# When loaded into a process address space a dll will be rebased if its base
# address colides with the base address of an existing dll.  To avoid rebasing 
# we do the following.  Rebasing can slow down the load time of dlls and it
# also renders debug info useless.
DLL_LD_FLAGS += -Wl,--enable-auto-image-base

# Build programs
ifeq "$(origin CC)" "default"
  CC := gcc.exe
endif
GMSGFMT ?= $(GTK_BIN)/msgfmt
MAKENSIS ?= makensis.exe
MAKENSISOPT ?= /
PERL ?= /cygdrive/c/perl/bin/perl
WINDRES ?= windres
STRIP ?= strip

PIDGIN_COMMON_RULES := $(PURPLE_TOP)/win32/rules.mak
PIDGIN_COMMON_TARGETS := $(PURPLE_TOP)/win32/targets.mak
MINGW_MAKEFILE := Makefile.mingw

INSTALL_PIXMAPS ?= 1
INSTALL_SSL_CERTIFICATES ?= 1
