/**
 * @file media.h Media API
 * @ingroup core
 *
 * purple
 *
 * Purple is the legal property of its developers, whose names are too numerous
 * to list here.  Please refer to the COPYRIGHT file distributed with this
 * source distribution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MEDIA_H_
#define __MEDIA_H_

#ifdef USE_FARSIGHT

#include <farsight/farsight.h>
#include <glib.h>
#include <glib-object.h>

#include "connection.h"

G_BEGIN_DECLS

#define PURPLE_TYPE_MEDIA            (purple_media_get_type())
#define PURPLE_MEDIA(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), PURPLE_TYPE_MEDIA, PurpleMedia))
#define PURPLE_MEDIA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), PURPLE_TYPE_MEDIA, PurpleMediaClass))
#define PURPLE_IS_MEDIA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), PURPLE_TYPE_MEDIA))
#define PURPLE_IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), PURPLE_TYPE_MEDIA))
#define PURPLE_MEDIA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), PURPLE_TYPE_MEDIA, PurpleMediaClass))

typedef struct _PurpleMedia PurpleMedia;
typedef struct _PurpleMediaClass PurpleMediaClass;
typedef struct _PurpleMediaPrivate PurpleMediaPrivate;

typedef enum {
	PURPLE_MEDIA_RECV_AUDIO = 1 << 0,
	PURPLE_MEDIA_SEND_AUDIO = 1 << 1,
	PURPLE_MEDIA_RECV_VIDEO = 1 << 2,
	PURPLE_MEDIA_SEND_VIDEO = 1 << 3,
} PurpleMediaStreamType;

struct _PurpleMediaClass
{
	GObjectClass parent_class;
};

struct _PurpleMedia
{
	GObject parent;
	PurpleMediaPrivate *priv;
};

GType purple_media_get_type(void);

void purple_media_get_elements(PurpleMedia *media, GstElement **audio_src, GstElement **audio_sink,
						  GstElement **video_src, GstElement **video_sink);

void purple_media_set_audio_src(PurpleMedia *media, GstElement *video_src);
void purple_media_set_audio_sink(PurpleMedia *media, GstElement *video_src);
void purple_media_set_video_src(PurpleMedia *media, GstElement *video_src);
void purple_media_set_video_sink(PurpleMedia *media, GstElement *video_src);

GstElement *purple_media_get_audio_src(PurpleMedia *media);
GstElement *purple_media_get_audio_sink(PurpleMedia *media);
GstElement *purple_media_get_video_src(PurpleMedia *media);
GstElement *purple_media_get_video_sink(PurpleMedia *media);

GstElement *purple_media_get_audio_pipeline(PurpleMedia *media);

PurpleConnection *purple_media_get_connection(PurpleMedia *media);
const char *purple_media_get_screenname(PurpleMedia *media);
void purple_media_ready(PurpleMedia *media);
void purple_media_accept(PurpleMedia *media);
void purple_media_reject(PurpleMedia *media);
void purple_media_hangup(PurpleMedia *media);
void purple_media_got_hangup(PurpleMedia *media);
G_END_DECLS

#endif  /* USE_FARSIGHT */


#endif  /* __MEDIA_H_ */
