/**
 * @file gtkwhiteboard.h The GtkGaimWhiteboard frontend object
 *
 * gaim
 *
 * Gaim is the legal property of its developers, whose names are too numerous
 * to list here.  Please refer to the COPYRIGHT file distributed with this
 * source distribution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GAIM_GTKWHITEBOARD_H_
#define _GAIM_GTKWHITEBOARD_H_

#include "gtkgaim.h"

#include "whiteboard.h"

#define FULL_CIRCLE_DEGREES		23040

#define BRUSH_STATE_UP			0
#define BRUSH_STATE_DOWN		1
#define BRUSH_STATE_MOTION		2

#define PALETTE_NUM_COLORS		7

/**
 * A GaimGtkWhiteboard
 */
typedef struct _GaimGtkWhiteboard
{
	GaimWhiteboard	*wb;		/**< backend data for this whiteboard */

	GtkWidget	*window;	/**< Window for the Doodle session */
	GtkWidget	*drawing_area;	/**< Drawing area */

	GdkPixmap	*pixmap;	/**< Memory for drawing area */

	int		width;		/**< Canvas width */
	int		height;		/**< Canvas height */
} GaimGtkWhiteboard;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*****************************************************************************/
/** @name GaimGtkWhiteboard API                                              */
/*****************************************************************************/
/*@{*/

/**
 * Gets the GtkWhiteboard UI Operations.
 *
 * @return The GtkWhiteboard UI Operations.
 */
GaimWhiteboardUiOps	*gaim_gtk_whiteboard_get_ui_ops( void );

/*@}*/

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GAIM_GTKWHITEBOARD_H_ */
