#ifndef _PIDGIN_TWITTER_H_
#define _PIDGIN_TWITTER_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include "gtkplugin.h"
#include "util.h"
#include "debug.h"
#include "connection.h"
#include "version.h"
#include "sound.h"
#include "gtkconv.h"
#include "gtkimhtml.h"

/* regp id */
#define RECIPIENT        0
#define SENDER           1
#define COMMAND          2
#define PSEUDO           3
#define MESSAGE          4
#define USER             5
#define USER_FIRST_LINE  6
#define USER_FORMATTED   7

#define PLUGIN_ID	            "gtk-honeyplanet-pidgin_twitter"
#define PLUGIN_NAME	            "pidgin-twitter"

/* options */
#define OPT_PIDGINTWITTER 		"/plugins/pidgin_twitter"
#define OPT_TRANSLATE_RECIPIENT OPT_PIDGINTWITTER "/translate_recipient"
#define OPT_TRANSLATE_SENDER    OPT_PIDGINTWITTER "/translate_sender"
#define OPT_PLAYSOUND_RECIPIENT OPT_PIDGINTWITTER "/playsound_recipient"
#define OPT_PLAYSOUND_SENDER    OPT_PIDGINTWITTER "/playsound_sender"
#define OPT_SOUNDID_RECIPIENT   OPT_PIDGINTWITTER "/soundid_recipient"
#define OPT_SOUNDID_SENDER      OPT_PIDGINTWITTER "/soundid_sender"
#define OPT_ESCAPE_PSEUDO       OPT_PIDGINTWITTER "/escape_pseudo"
#define OPT_USERLIST_RECIPIENT  OPT_PIDGINTWITTER "/userlist_recipient"
#define OPT_USERLIST_SENDER     OPT_PIDGINTWITTER "/userlist_sender"
#define OPT_COUNTER             OPT_PIDGINTWITTER "/counter"
#define OPT_SUPPRESS_OOPS       OPT_PIDGINTWITTER "/suppress_oops"
#define OPT_PREVENT_NOTIFICATION OPT_PIDGINTWITTER "/prevent_notification"
#define OPT_ICON_DIR            OPT_PIDGINTWITTER "/icon_dir"

/* formats and templates */
#define RECIPIENT_FORMAT        "@<a href='http://twitter.com/%s'>%s</a>"
#define SENDER_FORMAT           "%s<a href='http://twitter.com/%s'>%s</a>: "
#define DEFAULT_LIST            "(list of users: separated with ' ,:;')"
#define OOPS_MESSAGE            "<body>Oops! Your update was over 140 characters. We sent the short version to your friends (they can view the entire update on the web).<BR></body>"

/* patterns */
#define P_RECIPIENT        "@([A-Za-z0-9_]+)"
#define P_SENDER           "^(\\r?\\n?)([A-Za-z0-9_]+): "
#define P_COMMAND          "^(?:\\s*)([dDfFgGlLmMnNtTwW]{1}\\s+[A-Za-z0-9_]+)(?:\\s*\\Z)"
#define P_PSEUDO           "^\\s*(?:[\"#$%&'()*+,\\-./:;<=>?\\[\\\\\\]_`{|}~]|[^\\s\\x21-\\x7E])*([dDfFgGlLmMnNtTwW]{1})(?:\\Z|\\s+|[^\\x21-\\x7E]+\\Z)"
#define P_MESSAGE          "^<body>(.*)</body>"
#define P_USER             "^\\(.+?\\)\\s*([A-Za-z0-9_]+):"
#define P_USER_FIRST_LINE  "^\\(.+?\\)\\s*.+:\\s*([A-Za-z0-9_]+):"
#define P_USER_FORMATTED   "^.*?<a .+?>([A-Za-z0-9_]+)</a>:"

/* debug macros */
#define twitter_debug(fmt, ...)	purple_debug(PURPLE_DEBUG_INFO, PLUGIN_NAME, "%s():%4d:  " fmt, __FUNCTION__, (int)__LINE__, ## __VA_ARGS__);
#define twitter_error(fmt, ...)	purple_debug(PURPLE_DEBUG_ERROR, PLUGIN_NAME, "%s():%4d:  " fmt, __FUNCTION__, (int)__LINE__, ## __VA_ARGS__);

/* prototypes */
static void escape(gchar **str);
static gboolean sending_im_cb(PurpleAccount *account, char *recipient, char **buffer, void *data);
static gboolean eval(const GMatchInfo *match_info, GString *result, gpointer user_data);
static void translate(gchar **str, int which);
static void playsound(gchar **str, int which);
static gboolean writing_im_cb(PurpleAccount *account, char *sender, char **buffer, PurpleConversation *conv, int *flags, void *data);
static void insert_text_cb(GtkTextBuffer *textbuffer, GtkTextIter *position, gchar *new_text, gint new_text_length, gpointer user_data);
static void delete_text_cb(GtkTextBuffer *textbuffer, GtkTextIter *start_pos, GtkTextIter *end_pos, gpointer user_data);
static void detach_from_window(void);
static void detach_from_gtkconv(PidginConversation *gtkconv, gpointer null);
static void delete_requested_icon_marks(PidginConversation *gtkconv);
static void attach_to_window(void);
static void attach_to_gtkconv(PidginConversation *gtkconv, gpointer null);
static gboolean is_twitter_account(PurpleAccount *account, const char *name);
static gboolean is_twitter_conv(PurpleConversation *conv);
static void conv_created_cb(PurpleConversation *conv, gpointer null);
static void deleting_conv_cb(PurpleConversation *conv);
static gboolean receiving_im_cb(PurpleAccount *account, char **sender, char **buffer, PurpleConversation *conv, PurpleMessageFlags *flags, void *data);
static void insert_requested_icon(gpointer data, gpointer user_data);
static void downloaded_icon_cb(PurpleUtilFetchUrlData *url_data, gpointer user_data, const gchar *url_text, gsize len, const gchar *error_message);
static void request_icon(const char *buffer);
static void displayed_im_cb(PurpleAccount *account, const char *who, char *message, PurpleConversation *conv, PurpleMessageFlags flags);
static gboolean load_plugin(PurplePlugin *plugin);
static gboolean unload_plugin(PurplePlugin *plugin);
static void counter_prefs_cb(const char *name, PurplePrefType type, gconstpointer val, gpointer data);
static PurplePluginPrefFrame *get_plugin_pref_frame(PurplePlugin *plugin);
static void init_plugin(PurplePlugin *plugin);

#endif
