#ifndef _PIDGIN_AUDACIOUS_H_
#define _PIDGIN_AUDACIOUS_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

#include "gtkplugin.h"
#include "util.h"
#include "debug.h"
#include "connection.h"
#include "version.h"
#include "cmds.h"
#include "savedstatuses.h"

#define PIDGINAUD_PLUGIN_ID     "pidgin_audacious"
#define PLUGIN_NAME             "Pidgin-Audacious"

/* preferences */
#define OPT_PIDGINAUD           "/plugins/pidgin_audacious"
#define OPT_PROCESS_STATUS      OPT_PIDGINAUD "/process_status"
#define OPT_PROCESS_USERINFO    OPT_PIDGINAUD "/process_userinfo"
#define OPT_SONG_TEMPLATE       OPT_PIDGINAUD "/song_template"
#define OPT_PASTE_TEMPLATE      OPT_PIDGINAUD "/paste_template"
#define OPT_LOG_OUTPUT          OPT_PIDGINAUD "/log_output"
#define OPT_PLAYER              OPT_PIDGINAUD "/player"

/* templates */
#define TITLE   "%title"
#define ARTIST  "%artist"
#define ALBUM   "%album"
#define GENRE   "%genre"
#define DEFAULT_SONG_TEMPLATE   "%title - %artist"
#define DEFAULT_PLAYER          "audacious"
#define SONG_TOKEN              "%song"
#define NO_SONG_MESSAGE         "No song being played."

/* constants */
#define DBUS_TIMEOUT 1000
#define MINIMAL_INTERVAL 12
#define PLAYING 0
#define PAUSED  1
#define STOPPED 2

/* custom data type */
typedef struct song_tuple {
    gchar *title;
    gchar *artist;
    gchar *album;
    gchar *genre;
} song_tuple;

/* mpris data containers */
#define DBUS_TYPE_MPRIS_STATUS (dbus_g_type_get_struct ("GValueArray", G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INVALID))

#define DBUS_TYPE_G_STRING_VALUE_HASHTABLE (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE))

/* debug macros */
#define aud_debug(fmt, ...)	do { if(purple_prefs_get_bool(OPT_LOG_OUTPUT)) purple_debug(PURPLE_DEBUG_INFO, PLUGIN_NAME, "%s():%4d:  " fmt, __FUNCTION__, (int)__LINE__, ## __VA_ARGS__); } while(0);

#define aud_error(fmt, ...)	do { if(purple_prefs_get_bool(OPT_LOG_OUTPUT)) purple_debug(PURPLE_DEBUG_ERROR, PLUGIN_NAME, "%s():%4d:  " fmt, __FUNCTION__, (int)__LINE__, ## __VA_ARGS__); } while(0);


/* prototypes */
extern gchar *botch_utf(const gchar *msg, gsize len, gsize *newlen) __attribute__ ((weak));
static void aud_process(gchar *aud_info);
static void track_signal_cb(DBusGProxy *player_proxy, GHashTable *table, gpointer data);
static void status_signal_cb(DBusGProxy *player_proxy, gint status, gpointer data);
static gboolean is_app_playing(void);
static GHashTable *get_song_table(void);
static song_tuple *get_song_tuple(GHashTable *table);
static void signed_on_cb(PurpleConnection *gc, void *data);
static void prefs_cb(const char *name, PurplePrefType type, gconstpointer value, gpointer data);

#endif
