var nightlyApp = {

savedSetTitleFromFolder: window.setTitleFromFolder,
customTitle: '',

init: function()
{
  var brandbundle = document.getElementById("bundle_brand");
  if (nightly.variables.name==null)
  {
    nightly.variables.name=brandbundle.getString("brandShortName");
  }
  nightly.variables.defaulttitle=brandbundle.getString("brandShortName");
  nightly.variables.brandname=brandbundle.getString("brandFullName");
},

openURL: function(url, event)
{
  var uri = Components.classes["@mozilla.org/network/io-service;1"]
                      .getService(Components.interfaces.nsIIOService)
                      .newURI(url, null, null);

  var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                              .getService(Components.interfaces.nsIExternalProtocolService);
  protocolSvc.loadUrl(uri);
},

detectLeaks: function(event)
{
  var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                     .getService(Components.interfaces.nsIWindowMediator);
  var win = wm.getMostRecentWindow("Nightly:LeakReporter");
  if (win)
    win.focus();
  else
    window.openDialog("chrome://nightly/content/leaks/leaks.xul", "_blank", "chrome,all,dialog=no");
},

customSetTitleFromFolder: function(msgfolder, subject)
{
  var brandbundle = document.getElementById("bundle_brand");
  var end = " - "+brandbundle.getString("brandShortName");
  nightlyApp.savedSetTitleFromFolder(msgfolder,subject);

  var title;
  if ((document.title)&&(document.title.length>0))
  {
    title = document.title;
  }
  else
  {
    title = window.title;
  }

  if (title.substring(title.length-end.length)==end)
  {
    title=title.substring(0,title.length-end.length);
    if (nightlyApp.customTitle && nightlyApp.customTitle.length>0)
      title=title+' - '+nightlyApp.customTitle;
  }

  if ((document.title)&&(document.title.length>0))
  {
    document.title=title;
  }
  else
  {
    window.title=title;
  }
},

updateTitle: function()
{
  if (gDBView)
    window.setTitleFromFolder(gDBView.msgFolder,null);
},

setCustomTitle: function(title)
{
  nightlyApp.customTitle=title;
  window.setTitleFromFolder=nightlyApp.customSetTitleFromFolder;
  nightlyApp.updateTitle();
},

setBlankTitle: function()
{
  nightlyApp.customTitle='';
  window.setTitleFromFolder=nightlyApp.customSetTitleFromFolder;
  nightlyApp.updateTitle();
},

setStandardTitle: function()
{
  window.setTitleFromFolder=nightlyApp.savedSetTitleFromFolder;
  nightlyApp.updateTitle();
}

}
