var extensionAppEnabler = {

prefs: null,
cs: null,

init: function() {
  var pos = gAddonContextMenus.indexOf("menuitem_enable");
  gAddonContextMenus.splice(pos, 0, "menuitem_appenable");
  this.cs = Components.classes["@oxymoronical.com/nightly/addoncompatibility;1"]
                      .createInstance(Components.interfaces.nttIAddonCompatibilityService);
},

initView: function() {
  var enableb = document.getElementById("enableallButton");
  
  if (!this.prefs.getBoolPref("showEnableAll")) {
    enableb.hidden = true;
    return;
  }

  var parent = document.getElementById("viewGroup");
  var node = parent.firstChild;
  while (node != null) {
    if (node.selected) {
      switch (node.id) {
        case "extensions-view":
        case "themes-view":
        case "locales-view":
          enableb.hidden = false;
          break;
        default:
          enableb.hidden = true;
      }
      return;
    }
    node = node.nextSibling;
  }

  enableb.hidden = true;
},

load: function() {
  var prefservice = Components.classes['@mozilla.org/preferences-service;1']
                              .getService(Components.interfaces.nsIPrefService);
  this.prefs = prefservice.getBranch("nightly.")
                          .QueryInterface(Components.interfaces.nsIPrefBranchInternal);

  var context = document.getElementById("addonContextMenu");
  context.addEventListener("popupshowing", function() { extensionAppEnabler.popupShowing(); }, false);
  
  var radios = document.getElementById("viewGroup");
  radios.addEventListener("select", function() { extensionAppEnabler.initView(); }, false);
  this.initView();
},

popupShowing: function() {
  var item = gExtensionsView.selectedItem;
  var menu = document.getElementById("menuitem_appenable");
  var menuclone = document.getElementById("menuitem_appenable_clone");
  var addon = this.cs.getAddonForID(item.getAttribute("addonID"));
  menu.hidden = !(addon.isValid() && addon.needsOverride(false));
  if (menuclone)
    menuclone.hidden = menu.hidden;    
},

appEnable: function() {
  var ev = gExtensionsView;
  var item = ev.selectedItem;
  this.cs.confirmOverride([this.cs.getAddonForID(item.getAttribute("addonID"))], 1);
  this.syncCompatibility();
},

enableAll: function() {
  var addons = [];
  var items = gExtensionsView.children;
  for (var i = 0; i < items.length; i++) {
    var addon = this.cs.getAddonForID(items[i].getAttribute("addonID"));
    if (addon.isValid() && addon.needsOverride(false))
      addons.push(addon);
  }
  if (addons.length > 0) {
    this.cs.confirmOverride(addons, addons.length);
    this.syncCompatibility();
  }
},

syncCompatibility: function() {
  var prefService = Components.classes['@mozilla.org/preferences-service;1']
                              .getService(Components.interfaces.nsIPrefBranch);
  try {
    var checkCompatibility = prefService.getBoolPref("extensions.checkCompatibility");
    prefService.setBoolPref("extensions.checkCompatibility", !checkCompatibility);
    prefService.setBoolPref("extensions.checkCompatibility", checkCompatibility);
 	}
 	catch (e) {
    prefService.setBoolPref("extensions.checkCompatibility", false);
    prefService.setBoolPref("extensions.checkCompatibility", true);
  }
  updateOptionalViews();
  updateGlobalCommands();
}
}

extensionAppEnabler.init();

window.addEventListener("load", function() { extensionAppEnabler.load(); }, false);
