var nightlyApp = {

storedTitle: document.documentElement.getAttribute("titlemodifier"),

init: function()
{
  var brandbundle = document.getElementById("bundle_brand");
  if (nightly.variables.name==null)
  {
    nightly.variables.name=brandbundle.getString("brandShortName");
  }
  nightly.variables.brandname=brandbundle.getString("brandFullName");
  nightly.variables.defaulttitle=nightlyApp.storedTitle;
  document.getElementById("content").addEventListener("DOMTitleChanged",nightlyApp.titleUpdated,false);
},

detectLeaks: function(event)
{
  this.openURL('chrome://nightly/content/leaks/leaks.xul', event);
},

openURL: function(url, event)
{
  openUILink(url, event, false, true);
},

titleUpdated: function()
{
  if (!gBrowser.mTabbedMode)
  {
    gBrowser.updateTitlebar();
  }
},

updateTitlebar: function()
{
  window.setTimeout("gBrowser.updateTitlebar();", 50);
},

setCustomTitle: function(title)
{
  document.documentElement.setAttribute("titlemodifier",title);
  document.documentElement.setAttribute("titlemenuseparator"," - ");
  nightlyApp.updateTitlebar();
},

setBlankTitle: function()
{
  document.documentElement.setAttribute("titlemodifier","");
  document.documentElement.setAttribute("titlemenuseparator","");
  nightlyApp.updateTitlebar();
},

setStandardTitle: function()
{
  document.documentElement.setAttribute("titlemodifier",nightlyApp.storedTitle);
  document.documentElement.setAttribute("titlemenuseparator"," - ");
  nightlyApp.updateTitlebar();
}

}
