var session = {

init: function(event)
{
  var menu = document.getElementById("nightly-session-restore");
  var ds = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties);
  var file = ds.get("ProfD", Ci.nsIFile);
  file.append("sessionstore.bak");
  if (!file.exists)
    menu.setAttribute("disabled", "true");
},

_readFile: function(file)
{
  try
  {
    var stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                           .createInstance(Components.interfaces.nsIFileInputStream);
    stream.init(file, 0x01, 0, 0);
    var cvstream = Components.classes["@mozilla.org/intl/converter-input-stream;1"]
                             .createInstance(Components.interfaces.nsIConverterInputStream);
    cvstream.init(stream, "UTF-8", 1024, Components.interfaces.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
    
    var content = "";
    var data = {};
    while (cvstream.readString(4096, data))
      content += data.value;
    cvstream.close();
    
    return content.replace(/\r\n?/g, "\n");
  }
  catch (ex) { }
  
  return null;
},

restore: function()
{
  var ds = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties);
  var file = ds.get("ProfD", Ci.nsIFile);
  file.append("sessionstore.bak");
  if (file.exists)
  {
    var data = this._readFile(file);
    if (data)
    {
      try
      {
        var s = Components.utils.Sandbox("about:blank");
        var state = Components.utils.evalInSandbox(data, s);
        var args = {
          state: state,
          result: false
        };
        window.openDialog("chrome://nightly/content/session/session.xul", "_blank", "chrome,all,modal", args);
        if (args.result)
        {
          var ss = Components.classes["@mozilla.org/browser/sessionstore;1"]
                             .getService(Components.interfaces.nsISessionStore);
          var win = OpenBrowserWindow();
          win.addEventListener("load", function() { ss.setWindowState(win, args.state.toSource(), true); }, false);
        }
        return;
      }
      catch (ex)
      {
      }
    }
    alert("Unable to read from file, this is unrecoverable.");
  }
  else
    alert("There is no session information to restore.");
}
}

window.addEventListener("load", session.init, false);
