const XULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

var gArgs = null;

function acceptRestore()
{
  for (var w in gArgs.state.windows)
  {
    var win = gArgs.state.windows[w];
    for (var t = win.tabs.length-1; t>=0; t--)
    {
      var tab = win.tabs[t];
      if (tab._control.getAttribute("value") !== "true")
      {
        win.tabs.splice(t, 1);
        if (t < win.selected)
          win.selected--;
      }
      else
        delete tab["_control"];
    }
  }
  gArgs.result = true;
}

function addTab(parent, tab)
{
  var item = document.createElementNS(XULNS, "treeitem");
  item.setAttribute("container", "false");
  parent.appendChild(item);
  var row = document.createElementNS(XULNS, "treerow");
  item.appendChild(row);
  var cell = document.createElementNS(XULNS, "treecell");
  if (tab.entries[tab.index-1].title)
    cell.setAttribute("label", tab.entries[tab.index-1].title);
  else
    cell.setAttribute("label", "(Untitled)");
  cell.setAttribute("editable", "false");
  row.appendChild(cell);
  cell = document.createElementNS(XULNS, "treecell");
  cell.setAttribute("value", "true");
  row.appendChild(cell);
  tab._control = cell;
}

function addWindow(parent, win)
{
  var item = document.createElementNS(XULNS, "treeitem");
  item.setAttribute("container", "true");
  item.setAttribute("open", "true");
  parent.appendChild(item);
  var row = document.createElementNS(XULNS, "treerow");
  item.appendChild(row);
  var cell = document.createElementNS(XULNS, "treecell");
  cell.setAttribute("label", "Window");
  cell.setAttribute("editable", "false");
  row.appendChild(cell);
  cell = document.createElementNS(XULNS, "treecell");
  cell.setAttribute("editable", "false");
  row.appendChild(cell);
  var children = document.createElementNS(XULNS, "treechildren");
  item.appendChild(children);
  for (var i in win.tabs)
    addTab(children, win.tabs[i]);
}

function loadState(event)
{
  gArgs = window.arguments[0];
  var parent = document.getElementById("treechildren");
  var windows = gArgs.state.windows;
  for (var i in windows)
    addWindow(parent, windows[i]);
}

window.addEventListener("load", loadState, false);
 