const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

const xulns = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

var sidebar = {

db: null,

init: function()
{
  var service = Cc["@blueprintit.co.uk/breakpad;1"].
                getService(Ci.nttIBreakpadService);
  
  service.loadDatabase();
  service.addProgressListener(sidebar);
},

onDatabaseLoaded: function()
{
  var service = Cc["@blueprintit.co.uk/breakpad;1"].
                getService(Ci.nttIBreakpadService);

  var tree = document.getElementById("tree");
  tree.view = service.getTreeView();
  
  document.getElementById("loading").hidden=true;
  tree.hidden=false;
},

copy: function(event)
{
  var tree = document.getElementById("tree");
  var id = tree.view.getCellText(tree.currentIndex, tree.columns.getNamedColumn("incidentID"));
  var clipboard = Cc["@mozilla.org/widget/clipboardhelper;1"].
                  getService(Ci.nsIClipboardHelper);
  clipboard.copyString(id);
},

command: function(tree, event, row)
{
  var prefservice = Cc['@mozilla.org/preferences-service;1'].
                    getService(Ci.nsIPrefBranch);
  var url = prefservice.getCharPref("nightly.breakpad.searchurl");
  var id = tree.view.getCellText(row, tree.columns.getNamedColumn("incidentID")).substring(3);
  window.parent.openUILink(url+id, event, false, true);
},

selectedCommand: function(event)
{
  var tree = document.getElementById("tree");
  sidebar.command(tree, event, tree.currentIndex);
},

clickCommand: function(event)
{
  var tree = document.getElementById("tree");
  var row = {}, col = {};
  tree.treeBoxObject.getCellAt(event.clientX, event.clientY, row, col, {});
  sidebar.command(tree, event, row.value);
},

checkPopup: function(event)
{
  var tree = document.getElementById("tree");
  var type = tree.view.getCellText(tree.currentIndex, tree.columns.getNamedColumn("type"));
  return type=="incident";
},

QueryInterface: XPCOMUtils.generateQI([Ci.nttIBreakpadProgressListener])
}
