Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

var crashreports = {

init: function(event)
{
  window.removeEventListener("load", crashreports.init, false);
  if (Components.interfaces.nsICrashReporter)
  {
    var service = Components.classes["@blueprintit.co.uk/breakpad;1"]
                            .getService(Components.interfaces.nttIBreakpadService);
    
    if (nightly.preferences.getBoolPref("crashreports.recentlist.display"))
    {
      service.loadDatabase();
      service.addProgressListener(crashreports);
    }
    else
    {
      document.getElementById("nightly-crashreports-incidents").parentNode.hidden=true;
    }
  }
  else
  {
    document.getElementById("nightly-crashreports-separator").hidden = true;
    document.getElementById("nightly-crashreports-recent").hidden = true;
    document.getElementById("nightly-crashreports-sidebar").hidden = true;
  }
},

copy: function(event)
{
  var node = document.popupNode;
  if (node.id.substring(0,12)=="breakpad-id-")
  {
    var id = node.id.substring(12);
    var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                              .getService(Components.interfaces.nsIClipboardHelper);
    clipboard.copyString(id);
    closeMenus(node);
  }
},

onDatabaseLoaded: function()
{
  var service = Components.classes["@blueprintit.co.uk/breakpad;1"]
                          .getService(Components.interfaces.nttIBreakpadService);
  
  var incidents = null;
  
  incidents = service.getPreviousIncidents(10);
  
  var parent = document.getElementById("nightly-crashreports-incidents");
  if ((incidents) && (incidents.length > 0))
  {
    while (parent.firstChild)
      parent.removeChild(parent.firstChild);
    
    var en = incidents.enumerate();
    while (en.hasMoreElements())
    {
      var incident = en.getNext().QueryInterface(Components.interfaces.nttIBreakpadIncident);
      
      var item = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
      item.setAttribute("id", "breakpad-id-"+incident.id);
      item.setAttribute("tooltip", "nightly-crashreport-tooltip");
      item.setAttribute("context", "nightly-crashreport-context");
      item.setAttribute("label", incident.id+" ("+(new Date(incident.date)).toLocaleDateString()+")");
      parent.appendChild(item);
    }
  }
  else
  {
    parent.parentNode.disabled=true;
  }
},

popupTooltip: function(event)
{
  var node = document.tooltipNode;
  if (node.id.substring(0,12)=="breakpad-id-")
  {
    var id = node.id.substring(12);
    var service = Components.classes["@blueprintit.co.uk/breakpad;1"]
                            .getService(Components.interfaces.nttIBreakpadService);
    var incident = service.getIncident(id);
    var label = document.getElementById("nightly-crashreport-tooltip").firstChild;
    label.value=(new Date(incident.date)).toLocaleString();
    return true;
  }
  return false;
},

viewIncident: function(event)
{
  if (event.target.id.substring(0,12)=="breakpad-id-")
  {
    var url = nightly.preferences.getCharPref("breakpad.searchurl");
    var id = event.target.id.substring(15);
    nightlyApp.openURL(url+id, event);
  }
},

QueryInterface: XPCOMUtils.generateQI([Components.interfaces.nttIBreakpadProgressListener])
}

window.addEventListener("load", crashreports.init, false);
