const Cc = Components.classes;
const Ci = Components.interfaces;

var gOS = null;

var observer = {
  observe: function(subject, topic, data) {
    window.focus();
  }
}

function init() {
  var bundle = document.getElementById("bundle");
  setLabelForButton(document.documentElement.getButton("accept"), bundle.getString("Yes"));
  setLabelForButton(document.documentElement.getButton("cancel"), bundle.getString("No"));

  gOS = Cc["@mozilla.org/observer-service;1"].
        getService(Ci.nsIObserverService);
  gOS.addObserver(observer, "xul-window-visible", false);
}

function unload() {
  gOS.removeObserver(observer, "xul-window-visible");
  gOS = null;
}

function setLabelForButton(button, label)
{
  var accessKey = null;
  if (/ *\(\&([^&])\)(:)?$/.test(label)) {
    label = RegExp.leftContext + RegExp.$2;
    accessKey = RegExp.$1;
  } else if (/^(.*[^&])?\&(([^&]).*$)/.test(label)) {
    label = RegExp.$1 + RegExp.$2;
    accessKey = RegExp.$3;
  }
  // && is the magic sequence to embed an & in your label.
  label = label.replace(/\&\&/g, "&");
  button.label = label;
  if (accessKey)
    button.accessKey = accessKey;
}

function accept() {
  var cs = Cc["@oxymoronical.com/nightly/addoncompatibility;1"].
           createInstance(Ci.nttIAddonCompatibilityService);
  var em = Cc["@mozilla.org/extensions/manager;1"].
           getService(Ci.nsIExtensionManager);
  var items = em.getItemList(Ci.nsIUpdateItem.TYPE_ADDON, {});
  for (var i = 0; i < items.length; i++) {
    var addon = cs.getAddonForID(items[i].id);
    if (!addon.isValid())
      continue;
    if (!addon.needsOverride(false) && addon.needsOverride(true))
      addon.overrideCompatibility(true);
  }

  var prefs = Cc["@mozilla.org/preferences-service;1"].
              getService(Ci.nsIPrefBranch);
  if (prefs.prefHasUserValue("extensions.checkCompatibility"))
    prefs.clearUserPref("extensions.checkCompatibility");
  if (prefs.prefHasUserValue("extensions.checkUpdateSecurity"))
    prefs.clearUserPref("extensions.checkUpdateSecurity");
}
