/* 
 * Copyright (C) 2000 Rich Wareham <richwareham@users.sourceforge.net>
 * 
 * This file is part of libdvdnav, a DVD navigation library.
 * 
 * libdvdnav is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * libdvdnav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <dvdnav.h>
#include "dvdnav_internal.h"

#include "vm.h"

/* Characteristics/setting API calls */

dvdnav_status_t dvdnav_get_region_mask(dvdnav_t *self, int *region) {
  if(!self)
   return S_ERR;

  if(!region) {
    printerr("Passed a NULL pointer");
    return S_ERR;
  }

  if(!self->vm) {
    printerr("VM not yet initialised");
    return S_ERR;
  }

  (*region) = self->vm->state.registers.SPRM[20];
  
  return S_OK;
}

dvdnav_status_t dvdnav_set_region_mask(dvdnav_t *self, int mask) {
  if(!self)
   return S_ERR;

  if(!self->vm) {
    printerr("VM not yet initialised");
    return S_ERR;
  }

  self->vm->state.registers.SPRM[20] = (mask & 0xff);
  
  return S_OK;
}

dvdnav_status_t dvdnav_set_readahead_flag(dvdnav_t *self, int use_readahead) {
  if(!self)
   return S_ERR;

  self->use_read_ahead = use_readahead;

  return S_OK;
}

dvdnav_status_t dvdnav_get_readahead_flag(dvdnav_t *self, int* flag) {
  if(!self)
   return S_ERR;

  if(!flag) {
    printerr("Passed a NULL pointer");
    return S_ERR;
  }

  (*flag) = self->use_read_ahead;
  return S_OK;
}

