/*
 * MSMPEG4 backend for ffmpeg encoder and decoder
 * copyright (c) 2001 Fabrice Bellard
 * copyright (c) 2002-2004 Michael Niedermayer <michaelni@gmx.at>
 *
 * msmpeg4v1 & v2 stuff by Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file msmpeg4data.c
 * MSMPEG4 data tables.
 */

#include "msmpeg4data.h"

VLC ff_msmp4_mb_i_vlc;
VLC ff_msmp4_dc_luma_vlc[2];
VLC ff_msmp4_dc_chroma_vlc[2];

/* intra picture macro block coded block pattern */
const uint16_t ff_msmp4_mb_i_table[64][2] = {
{ 0x1, 1 },{ 0x17, 6 },{ 0x9, 5 },{ 0x5, 5 },
{ 0x6, 5 },{ 0x47, 9 },{ 0x20, 7 },{ 0x10, 7 },
{ 0x2, 5 },{ 0x7c, 9 },{ 0x3a, 7 },{ 0x1d, 7 },
{ 0x2, 6 },{ 0xec, 9 },{ 0x77, 8 },{ 0x0, 8 },
{ 0x3, 5 },{ 0xb7, 9 },{ 0x2c, 7 },{ 0x13, 7 },
{ 0x1, 6 },{ 0x168, 10 },{ 0x46, 8 },{ 0x3f, 8 },
{ 0x1e, 6 },{ 0x712, 13 },{ 0xb5, 9 },{ 0x42, 8 },
{ 0x22, 7 },{ 0x1c5, 11 },{ 0x11e, 10 },{ 0x87, 9 },
{ 0x6, 4 },{ 0x3, 9 },{ 0x1e, 7 },{ 0x1c, 6 },
{ 0x12, 7 },{ 0x388, 12 },{ 0x44, 9 },{ 0x70, 9 },
{ 0x1f, 6 },{ 0x23e, 11 },{ 0x39, 8 },{ 0x8e, 9 },
{ 0x1, 7 },{ 0x1c6, 11 },{ 0xb6, 9 },{ 0x45, 9 },
{ 0x14, 6 },{ 0x23f, 11 },{ 0x7d, 9 },{ 0x18, 9 },
{ 0x7, 7 },{ 0x1c7, 11 },{ 0x86, 9 },{ 0x19, 9 },
{ 0x15, 6 },{ 0x1db, 10 },{ 0x2, 9 },{ 0x46, 9 },
{ 0xd, 8 },{ 0x713, 13 },{ 0x1da, 10 },{ 0x169, 10 },
};

/* non intra picture macro block coded block pattern + mb type */
const uint32_t table_mb_non_intra[128][2] = {
{   0x40,  7 },{   0x13c9, 13 },{   0x9fd, 12 },{   0x1fc, 15 },
{  0x9fc, 12 },{    0xa83, 18 },{ 0x12d34, 17 },{  0x83bc, 16 },
{  0x83a, 12 },{    0x7f8, 17 },{   0x3fd, 16 },{   0x3ff, 16 },
{   0x79, 13 },{    0xa82, 18 },{  0x969d, 16 },{   0x2a4, 16 },
{  0x978, 12 },{    0x543, 17 },{  0x41df, 15 },{   0x7f9, 17 },
{ 0x12f3, 13 },{  0x25a6b, 18 },{ 0x25ef9, 18 },{   0x3fa, 16 },
{ 0x20ee, 14 },{  0x969ab, 20 },{  0x969c, 16 },{ 0x25ef8, 18 },
{ 0x12d2, 13 },{    0xa85, 18 },{  0x969e, 16 },{  0x4bc8, 15 },
{   0x3d, 12 },{  0x12f7f, 17 },{   0x2a2, 16 },{  0x969f, 16 },
{ 0x25ee, 14 },{ 0x12d355, 21 },{ 0x12f7d, 17 },{ 0x12f7e, 17 },
{  0x9e5, 12 },{    0xa81, 18 },{ 0x4b4d4, 19 },{  0x83bd, 16 },
{   0x78, 13 },{   0x969b, 16 },{   0x3fe, 16 },{   0x2a5, 16 },
{   0x7e, 13 },{    0xa80, 18 },{   0x2a3, 16 },{   0x3fb, 16 },
{ 0x1076, 13 },{    0xa84, 18 },{   0x153, 15 },{  0x4bc9, 15 },
{   0x55, 13 },{ 0x12d354, 21 },{  0x4bde, 15 },{  0x25e5, 14 },
{  0x25b, 10 },{   0x4b4c, 15 },{   0x96b, 12 },{   0x96a, 12 },
{    0x1,  2 },{      0x0,  7 },{    0x26,  6 },{   0x12b,  9 },
{    0x7,  3 },{    0x20f, 10 },{     0x4,  9 },{    0x28, 12 },
{    0x6,  3 },{    0x20a, 10 },{   0x128,  9 },{    0x2b, 12 },
{   0x11,  5 },{     0x1b, 11 },{   0x13a,  9 },{   0x4ff, 11 },
{    0x3,  4 },{    0x277, 10 },{   0x106,  9 },{   0x839, 12 },
{    0xb,  4 },{    0x27b, 10 },{   0x12c,  9 },{   0x4bf, 11 },
{    0x9,  6 },{     0x35, 12 },{   0x27e, 10 },{  0x13c8, 13 },
{    0x1,  6 },{    0x4aa, 11 },{   0x208, 10 },{    0x29, 12 },
{    0x1,  4 },{    0x254, 10 },{   0x12e,  9 },{   0x838, 12 },
{   0x24,  6 },{    0x4f3, 11 },{   0x276, 10 },{  0x12f6, 13 },
{    0x1,  5 },{    0x27a, 10 },{   0x13e,  9 },{    0x3e, 12 },
{    0x8,  6 },{    0x413, 11 },{     0xc, 10 },{   0x4be, 11 },
{   0x14,  5 },{    0x412, 11 },{   0x253, 10 },{   0x97a, 12 },
{   0x21,  6 },{    0x4ab, 11 },{   0x20b, 10 },{    0x34, 12 },
{   0x15,  5 },{    0x278, 10 },{   0x252, 10 },{   0x968, 12 },
{    0x5,  5 },{      0xb, 10 },{    0x9c,  8 },{     0xe, 10 },
};

/* dc table 0 */

const uint32_t ff_table0_dc_lum[120][2] = {
{     0x1,  1 },{      0x1, 2 },{     0x1,  4 },{     0x1,  5 },
{     0x5,  5 },{      0x7, 5 },{     0x8,  6 },{     0xc,  6 },
{     0x0,  7 },{      0x2, 7 },{    0x12,  7 },{    0x1a,  7 },
{     0x3,  8 },{      0x7, 8 },{    0x27,  8 },{    0x37,  8 },
{     0x5,  9 },{     0x4c, 9 },{    0x6c,  9 },{    0x6d,  9 },
{     0x8, 10 },{    0x19, 10 },{    0x9b, 10 },{    0x1b, 10 },
{    0x9a, 10 },{    0x13, 11 },{    0x34, 11 },{    0x35, 11 },
{    0x61, 12 },{    0x48, 13 },{    0xc4, 13 },{    0x4a, 13 },
{    0xc6, 13 },{    0xc7, 13 },{    0x92, 14 },{   0x18b, 14 },
{    0x93, 14 },{   0x183, 14 },{   0x182, 14 },{    0x96, 14 },
{    0x97, 14 },{   0x180, 14 },{   0x314, 15 },{   0x315, 15 },
{   0x605, 16 },{   0x604, 16 },{   0x606, 16 },{   0xc0e, 17 },
{ 0x303cd, 23 },{ 0x303c9, 23 },{ 0x303c8, 23 },{ 0x303ca, 23 },
{ 0x303cb, 23 },{ 0x303cc, 23 },{ 0x303ce, 23 },{ 0x303cf, 23 },
{ 0x303d0, 23 },{ 0x303d1, 23 },{ 0x303d2, 23 },{ 0x303d3, 23 },
{ 0x303d4, 23 },{ 0x303d5, 23 },{ 0x303d6, 23 },{ 0x303d7, 23 },
{ 0x303d8, 23 },{ 0x303d9, 23 },{ 0x303da, 23 },{ 0x303db, 23 },
{ 0x303dc, 23 },{ 0x303dd, 23 },{ 0x303de, 23 },{ 0x303df, 23 },
{ 0x303e0, 23 },{ 0x303e1, 23 },{ 0x303e2, 23 },{ 0x303e3, 23 },
{ 0x303e4, 23 },{ 0x303e5, 23 },{ 0x303e6, 23 },{ 0x303e7, 23 },
{ 0x303e8, 23 },{ 0x303e9, 23 },{ 0x303ea, 23 },{ 0x303eb, 23 },
{ 0x303ec, 23 },{ 0x303ed, 23 },{ 0x303ee, 23 },{ 0x303ef, 23 },
{ 0x303f0, 23 },{ 0x303f1, 23 },{ 0x303f2, 23 },{ 0x303f3, 23 },
{ 0x303f4, 23 },{ 0x303f5, 23 },{ 0x303f6, 23 },{ 0x303f7, 23 },
{ 0x303f8, 23 },{ 0x303f9, 23 },{ 0x303fa, 23 },{ 0x303fb, 23 },
{ 0x303fc, 23 },{ 0x303fd, 23 },{ 0x303fe, 23 },{ 0x303ff, 23 },
{ 0x60780, 24 },{ 0x60781, 24 },{ 0x60782, 24 },{ 0x60783, 24 },
{ 0x60784, 24 },{ 0x60785, 24 },{ 0x60786, 24 },{ 0x60787, 24 },
{ 0x60788, 24 },{ 0x60789, 24 },{ 0x6078a, 24 },{ 0x6078b, 24 },
{ 0x6078c, 24 },{ 0x6078d, 24 },{ 0x6078e, 24 },{ 0x6078f, 24 },
};

const uint32_t ff_table0_dc_chroma[120][2] = {
{      0x0,  2 },{      0x1,  2 },{      0x5,  3 },{      0x9,  4 },
{      0xd,  4 },{     0x11,  5 },{     0x1d,  5 },{     0x1f,  5 },
{     0x21,  6 },{     0x31,  6 },{     0x38,  6 },{     0x33,  6 },
{     0x39,  6 },{     0x3d,  6 },{     0x61,  7 },{     0x79,  7 },
{     0x80,  8 },{     0xc8,  8 },{     0xca,  8 },{     0xf0,  8 },
{     0x81,  8 },{     0xc0,  8 },{     0xc9,  8 },{    0x107,  9 },
{    0x106,  9 },{    0x196,  9 },{    0x183,  9 },{    0x1e3,  9 },
{    0x1e2,  9 },{    0x20a, 10 },{    0x20b, 10 },{    0x609, 11 },
{    0x412, 11 },{    0x413, 11 },{    0x60b, 11 },{    0x411, 11 },
{    0x60a, 11 },{    0x65f, 11 },{    0x410, 11 },{    0x65d, 11 },
{    0x65e, 11 },{    0xcb8, 12 },{    0xc10, 12 },{    0xcb9, 12 },
{   0x1823, 13 },{   0x3045, 14 },{   0x6089, 15 },{   0xc110, 16 },
{ 0x304448, 22 },{ 0x304449, 22 },{ 0x30444a, 22 },{ 0x30444b, 22 },
{ 0x30444c, 22 },{ 0x30444d, 22 },{ 0x30444e, 22 },{ 0x30444f, 22 },
{ 0x304450, 22 },{ 0x304451, 22 },{ 0x304452, 22 },{ 0x304453, 22 },
{ 0x304454, 22 },{ 0x304455, 22 },{ 0x304456, 22 },{ 0x304457, 22 },
{ 0x304458, 22 },{ 0x304459, 22 },{ 0x30445a, 22 },{ 0x30445b, 22 },
{ 0x30445c, 22 },{ 0x30445d, 22 },{ 0x30445e, 22 },{ 0x30445f, 22 },
{ 0x304460, 22 },{ 0x304461, 22 },{ 0x304462, 22 },{ 0x304463, 22 },
{ 0x304464, 22 },{ 0x304465, 22 },{ 0x304466, 22 },{ 0x304467, 22 },
{ 0x304468, 22 },{ 0x304469, 22 },{ 0x30446a, 22 },{ 0x30446b, 22 },
{ 0x30446c, 22 },{ 0x30446d, 22 },{ 0x30446e, 22 },{ 0x30446f, 22 },
{ 0x304470, 22 },{ 0x304471, 22 },{ 0x304472, 22 },{ 0x304473, 22 },
{ 0x304474, 22 },{ 0x304475, 22 },{ 0x304476, 22 },{ 0x304477, 22 },
{ 0x304478, 22 },{ 0x304479, 22 },{ 0x30447a, 22 },{ 0x30447b, 22 },
{ 0x30447c, 22 },{ 0x30447d, 22 },{ 0x30447e, 22 },{ 0x30447f, 22 },
{ 0x608880, 23 },{ 0x608881, 23 },{ 0x608882, 23 },{ 0x608883, 23 },
{ 0x608884, 23 },{ 0x608885, 23 },{ 0x608886, 23 },{ 0x608887, 23 },
{ 0x608888, 23 },{ 0x608889, 23 },{ 0x60888a, 23 },{ 0x60888b, 23 },
{ 0x60888c, 23 },{ 0x60888d, 23 },{ 0x60888e, 23 },{ 0x60888f, 23 },
};

/* dc table 1 */

const uint32_t ff_table1_dc_lum[120][2] = {
{      0x2,  2 },{      0x3,  2 },{      0x3,  3 },{      0x2,  4 },
{      0x5,  4 },{      0x1,  5 },{      0x3,  5 },{      0x8,  5 },
{      0x0,  6 },{      0x5,  6 },{      0xd,  6 },{      0xf,  6 },
{     0x13,  6 },{      0x8,  7 },{     0x18,  7 },{     0x1c,  7 },
{     0x24,  7 },{      0x4,  8 },{      0x6,  8 },{     0x12,  8 },
{     0x32,  8 },{     0x3b,  8 },{     0x4a,  8 },{     0x4b,  8 },
{      0xb,  9 },{     0x26,  9 },{     0x27,  9 },{     0x66,  9 },
{     0x74,  9 },{     0x75,  9 },{     0x14, 10 },{     0x1c, 10 },
{     0x1f, 10 },{     0x1d, 10 },{     0x2b, 11 },{     0x3d, 11 },
{    0x19d, 11 },{    0x19f, 11 },{     0x54, 12 },{    0x339, 12 },
{    0x338, 12 },{    0x33d, 12 },{     0xab, 13 },{     0xf1, 13 },
{    0x678, 13 },{     0xf2, 13 },{    0x1e0, 14 },{    0x1e1, 14 },
{    0x154, 14 },{    0xcf2, 14 },{    0x3cc, 15 },{    0x2ab, 15 },
{   0x19e7, 15 },{    0x3ce, 15 },{   0x19e6, 15 },{    0x554, 16 },
{    0x79f, 16 },{    0x555, 16 },{    0xf3d, 17 },{    0xf37, 17 },
{    0xf3c, 17 },{    0xf35, 17 },{   0x1e6d, 18 },{   0x1e68, 18 },
{   0x3cd8, 19 },{   0x3cd3, 19 },{   0x3cd9, 19 },{   0x79a4, 20 },
{  0xf34ba, 25 },{  0xf34b4, 25 },{  0xf34b5, 25 },{  0xf34b6, 25 },
{  0xf34b7, 25 },{  0xf34b8, 25 },{  0xf34b9, 25 },{  0xf34bb, 25 },
{  0xf34bc, 25 },{  0xf34bd, 25 },{  0xf34be, 25 },{  0xf34bf, 25 },
{ 0x1e6940, 26 },{ 0x1e6941, 26 },{ 0x1e6942, 26 },{ 0x1e6943, 26 },
{ 0x1e6944, 26 },{ 0x1e6945, 26 },{ 0x1e6946, 26 },{ 0x1e6947, 26 },
{ 0x1e6948, 26 },{ 0x1e6949, 26 },{ 0x1e694a, 26 },{ 0x1e694b, 26 },
{ 0x1e694c, 26 },{ 0x1e694d, 26 },{ 0x1e694e, 26 },{ 0x1e694f, 26 },
{ 0x1e6950, 26 },{ 0x1e6951, 26 },{ 0x1e6952, 26 },{ 0x1e6953, 26 },
{ 0x1e6954, 26 },{ 0x1e6955, 26 },{ 0x1e6956, 26 },{ 0x1e6957, 26 },
{ 0x1e6958, 26 },{ 0x1e6959, 26 },{ 0x1e695a, 26 },{ 0x1e695b, 26 },
{ 0x1e695c, 26 },{ 0x1e695d, 26 },{ 0x1e695e, 26 },{ 0x1e695f, 26 },
{ 0x1e6960, 26 },{ 0x1e6961, 26 },{ 0x1e6962, 26 },{ 0x1e6963, 26 },
{ 0x1e6964, 26 },{ 0x1e6965, 26 },{ 0x1e6966, 26 },{ 0x1e6967, 26 },
};

const uint32_t ff_table1_dc_chroma[120][2] = {
{       0x0,  2 },{       0x1,  2 },{       0x4,  3 },{       0x7,  3 },
{       0xb,  4 },{       0xd,  4 },{      0x15,  5 },{      0x28,  6 },
{      0x30,  6 },{      0x32,  6 },{      0x52,  7 },{      0x62,  7 },
{      0x66,  7 },{      0xa6,  8 },{      0xc6,  8 },{      0xcf,  8 },
{     0x14f,  9 },{     0x18e,  9 },{     0x19c,  9 },{     0x29d, 10 },
{     0x33a, 10 },{     0x538, 11 },{     0x63c, 11 },{     0x63e, 11 },
{     0x63f, 11 },{     0x676, 11 },{     0xa73, 12 },{     0xc7a, 12 },
{     0xcef, 12 },{    0x14e5, 13 },{    0x19dd, 13 },{    0x29c8, 14 },
{    0x29c9, 14 },{    0x63dd, 15 },{    0x33b8, 14 },{    0x33b9, 14 },
{    0xc7b6, 16 },{    0x63d8, 15 },{    0x63df, 15 },{    0xc7b3, 16 },
{    0xc7b4, 16 },{    0xc7b5, 16 },{    0x63de, 15 },{    0xc7b7, 16 },
{    0xc7b8, 16 },{    0xc7b9, 16 },{   0x18f65, 17 },{   0x31ec8, 18 },
{  0xc7b248, 24 },{  0xc7b249, 24 },{  0xc7b24a, 24 },{  0xc7b24b, 24 },
{  0xc7b24c, 24 },{  0xc7b24d, 24 },{  0xc7b24e, 24 },{  0xc7b24f, 24 },
{  0xc7b250, 24 },{  0xc7b251, 24 },{  0xc7b252, 24 },{  0xc7b253, 24 },
{  0xc7b254, 24 },{  0xc7b255, 24 },{  0xc7b256, 24 },{  0xc7b257, 24 },
{  0xc7b258, 24 },{  0xc7b259, 24 },{  0xc7b25a, 24 },{  0xc7b25b, 24 },
{  0xc7b25c, 24 },{  0xc7b25d, 24 },{  0xc7b25e, 24 },{  0xc7b25f, 24 },
{  0xc7b260, 24 },{  0xc7b261, 24 },{  0xc7b262, 24 },{  0xc7b263, 24 },
{  0xc7b264, 24 },{  0xc7b265, 24 },{  0xc7b266, 24 },{  0xc7b267, 24 },
{  0xc7b268, 24 },{  0xc7b269, 24 },{  0xc7b26a, 24 },{  0xc7b26b, 24 },
{  0xc7b26c, 24 },{  0xc7b26d, 24 },{  0xc7b26e, 24 },{  0xc7b26f, 24 },
{  0xc7b270, 24 },{  0xc7b271, 24 },{  0xc7b272, 24 },{  0xc7b273, 24 },
{  0xc7b274, 24 },{  0xc7b275, 24 },{  0xc7b276, 24 },{  0xc7b277, 24 },
{  0xc7b278, 24 },{  0xc7b279, 24 },{  0xc7b27a, 24 },{  0xc7b27b, 24 },
{  0xc7b27c, 24 },{  0xc7b27d, 24 },{  0xc7b27e, 24 },{  0xc7b27f, 24 },
{ 0x18f6480, 25 },{ 0x18f6481, 25 },{ 0x18f6482, 25 },{ 0x18f6483, 25 },
{ 0x18f6484, 25 },{ 0x18f6485, 25 },{ 0x18f6486, 25 },{ 0x18f6487, 25 },
{ 0x18f6488, 25 },{ 0x18f6489, 25 },{ 0x18f648a, 25 },{ 0x18f648b, 25 },
{ 0x18f648c, 25 },{ 0x18f648d, 25 },{ 0x18f648e, 25 },{ 0x18f648f, 25 },
};

/* vlc table 0, for intra luma */

static const uint16_t table0_vlc[133][2] = {
{   0x1,  2 },{   0x6,  3 },{   0xf,  4 },{  0x16,  5 },
{  0x20,  6 },{  0x18,  7 },{   0x8,  8 },{  0x9a,  8 },
{  0x56,  9 },{ 0x13e,  9 },{  0xf0, 10 },{ 0x3a5, 10 },
{  0x77, 11 },{ 0x1ef, 11 },{  0x9a, 12 },{  0x5d, 13 },
{   0x1,  4 },{  0x11,  5 },{   0x2,  7 },{   0xb,  8 },
{  0x12,  9 },{ 0x1d6,  9 },{ 0x27e, 10 },{ 0x191, 11 },
{  0xea, 12 },{ 0x3dc, 12 },{ 0x13b, 13 },{   0x4,  5 },
{  0x14,  7 },{  0x9e,  8 },{   0x9, 10 },{ 0x1ac, 11 },
{ 0x1e2, 11 },{ 0x3ca, 12 },{  0x5f, 13 },{  0x17,  5 },
{  0x4e,  7 },{  0x5e,  9 },{  0xf3, 10 },{ 0x1ad, 11 },
{  0xec, 12 },{ 0x5f0, 13 },{   0xe,  6 },{  0xe1,  8 },
{ 0x3a4, 10 },{  0x9c, 12 },{ 0x13d, 13 },{  0x3b,  6 },
{  0x1c,  9 },{  0x14, 11 },{ 0x9be, 12 },{   0x6,  7 },
{  0x7a,  9 },{ 0x190, 11 },{ 0x137, 13 },{  0x1b,  7 },
{   0x8, 10 },{ 0x75c, 11 },{  0x71,  7 },{  0xd7, 10 },
{ 0x9bf, 12 },{   0x7,  8 },{  0xaf, 10 },{ 0x4cc, 11 },
{  0x34,  8 },{ 0x265, 10 },{  0x9f, 12 },{  0xe0,  8 },
{  0x16, 11 },{ 0x327, 12 },{  0x15,  9 },{ 0x17d, 11 },
{ 0xebb, 12 },{  0x14,  9 },{  0xf6, 10 },{ 0x1e4, 11 },
{  0xcb, 10 },{ 0x99d, 12 },{  0xca, 10 },{ 0x2fc, 12 },
{ 0x17f, 11 },{ 0x4cd, 11 },{ 0x2fd, 12 },{ 0x4fe, 11 },
{ 0x13a, 13 },{   0xa,  4 },{  0x42,  7 },{ 0x1d3,  9 },
{ 0x4dd, 11 },{  0x12,  5 },{  0xe8,  8 },{  0x4c, 11 },
{ 0x136, 13 },{  0x39,  6 },{ 0x264, 10 },{ 0xeba, 12 },
{   0x0,  7 },{  0xae, 10 },{ 0x99c, 12 },{  0x1f,  7 },
{ 0x4de, 11 },{  0x43,  7 },{ 0x4dc, 11 },{   0x3,  8 },
{ 0x3cb, 12 },{   0x6,  8 },{ 0x99e, 12 },{  0x2a,  8 },
{ 0x5f1, 13 },{   0xf,  8 },{ 0x9fe, 12 },{  0x33,  8 },
{ 0x9ff, 12 },{  0x98,  8 },{ 0x99f, 12 },{  0xea,  8 },
{ 0x13c, 13 },{  0x2e,  8 },{ 0x192, 11 },{ 0x136,  9 },
{  0x6a,  9 },{  0x15, 11 },{ 0x3af, 10 },{ 0x1e3, 11 },
{  0x74, 11 },{  0xeb, 12 },{ 0x2f9, 12 },{  0x5c, 13 },
{  0xed, 12 },{ 0x3dd, 12 },{ 0x326, 12 },{  0x5e, 13 },
{  0x16,  7 },
};

static const int8_t table0_level[132] = {
  1,  2,  3,  4,  5,  6,  7,  8,
  9, 10, 11, 12, 13, 14, 15, 16,
  1,  2,  3,  4,  5,  6,  7,  8,
  9, 10, 11,  1,  2,  3,  4,  5,
  6,  7,  8,  1,  2,  3,  4,  5,
  6,  7,  1,  2,  3,  4,  5,  1,
  2,  3,  4,  1,  2,  3,  4,  1,
  2,  3,  1,  2,  3,  1,  2,  3,
  1,  2,  3,  1,  2,  3,  1,  2,
  3,  1,  2,  3,  1,  2,  1,  2,
  1,  1,  1,  1,  1,  1,  2,  3,
  4,  1,  2,  3,  4,  1,  2,  3,
  1,  2,  3,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};

static const int8_t table0_run[132] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  2,  2,  2,  2,  2,
  2,  2,  2,  3,  3,  3,  3,  3,
  3,  3,  4,  4,  4,  4,  4,  5,
  5,  5,  5,  6,  6,  6,  6,  7,
  7,  7,  8,  8,  8,  9,  9,  9,
 10, 10, 10, 11, 11, 11, 12, 12,
 12, 13, 13, 13, 14, 14, 15, 15,
 16, 17, 18, 19, 20,  0,  0,  0,
  0,  1,  1,  1,  1,  2,  2,  2,
  3,  3,  3,  4,  4,  5,  5,  6,
  6,  7,  7,  8,  8,  9,  9, 10,
 10, 11, 11, 12, 12, 13, 13, 14,
 15, 16, 17, 18, 19, 20, 21, 22,
 23, 24, 25, 26,
};

/* vlc table 1, for intra chroma and P macro blocks */

static const uint16_t table1_vlc[149][2] = {
{    0x4,  3 },{   0x14,  5 },{   0x17,  7 },{   0x7f,  8 },
{  0x154,  9 },{  0x1f2, 10 },{   0xbf, 11 },{   0x65, 12 },
{  0xaaa, 12 },{  0x630, 13 },{ 0x1597, 13 },{  0x3b7, 14 },
{ 0x2b22, 14 },{  0xbe6, 15 },{    0xb,  4 },{   0x37,  7 },
{   0x62,  9 },{    0x7, 11 },{  0x166, 12 },{   0xce, 13 },
{ 0x1590, 13 },{  0x5f6, 14 },{  0xbe7, 15 },{    0x7,  5 },
{   0x6d,  8 },{    0x3, 11 },{  0x31f, 12 },{  0x5f2, 14 },
{    0x2,  6 },{   0x61,  9 },{   0x55, 12 },{  0x1df, 14 },
{   0x1a,  6 },{   0x1e, 10 },{  0xac9, 12 },{ 0x2b23, 14 },
{   0x1e,  6 },{   0x1f, 10 },{  0xac3, 12 },{ 0x2b2b, 14 },
{    0x6,  7 },{    0x4, 11 },{  0x2f8, 13 },{   0x19,  7 },
{    0x6, 11 },{  0x63d, 13 },{   0x57,  7 },{  0x182, 11 },
{ 0x2aa2, 14 },{    0x4,  8 },{  0x180, 11 },{  0x59c, 14 },
{   0x7d,  8 },{  0x164, 12 },{  0x76d, 15 },{    0x2,  9 },
{  0x18d, 11 },{ 0x1581, 13 },{   0xad,  8 },{   0x60, 12 },
{  0xc67, 14 },{   0x1c,  9 },{   0xee, 13 },{    0x3,  9 },
{  0x2cf, 13 },{   0xd9,  9 },{ 0x1580, 13 },{    0x2, 11 },
{  0x183, 11 },{   0x57, 12 },{   0x61, 12 },{   0x31, 11 },
{   0x66, 12 },{  0x631, 13 },{  0x632, 13 },{   0xac, 13 },
{  0x31d, 12 },{   0x76, 12 },{   0x3a, 11 },{  0x165, 12 },
{  0xc66, 14 },{    0x3,  2 },{   0x54,  7 },{  0x2ab, 10 },
{   0x16, 13 },{  0x5f7, 14 },{    0x5,  4 },{   0xf8,  9 },
{  0xaa9, 12 },{   0x5f, 15 },{    0x4,  4 },{   0x1c, 10 },
{ 0x1550, 13 },{    0x4,  5 },{   0x77, 11 },{  0x76c, 15 },
{    0xe,  5 },{    0xa, 12 },{    0xc,  5 },{  0x562, 11 },
{    0x4,  6 },{  0x31c, 12 },{    0x6,  6 },{   0xc8, 13 },
{    0xd,  6 },{  0x1da, 13 },{    0x7,  6 },{   0xc9, 13 },
{    0x1,  7 },{   0x2e, 14 },{   0x14,  7 },{ 0x1596, 13 },
{    0xa,  7 },{  0xac2, 12 },{   0x16,  7 },{  0x15b, 14 },
{   0x15,  7 },{  0x15a, 14 },{    0xf,  8 },{   0x5e, 15 },
{   0x7e,  8 },{   0xab,  8 },{   0x2d,  9 },{   0xd8,  9 },
{    0xb,  9 },{   0x14, 10 },{  0x2b3, 10 },{  0x1f3, 10 },
{   0x3a, 10 },{    0x0, 10 },{   0x58, 10 },{   0x2e,  9 },
{   0x5e, 10 },{  0x563, 11 },{   0xec, 12 },{   0x54, 12 },
{  0xac1, 12 },{ 0x1556, 13 },{  0x2fa, 13 },{  0x181, 11 },
{ 0x1557, 13 },{  0x59d, 14 },{ 0x2aa3, 14 },{ 0x2b2a, 14 },
{  0x1de, 14 },{  0x63c, 13 },{   0xcf, 13 },{ 0x1594, 13 },
{    0xd,  9 },
};

static const int8_t table1_level[148] = {
  1,  2,  3,  4,  5,  6,  7,  8,
  9, 10, 11, 12, 13, 14,  1,  2,
  3,  4,  5,  6,  7,  8,  9,  1,
  2,  3,  4,  5,  1,  2,  3,  4,
  1,  2,  3,  4,  1,  2,  3,  4,
  1,  2,  3,  1,  2,  3,  1,  2,
  3,  1,  2,  3,  1,  2,  3,  1,
  2,  3,  1,  2,  3,  1,  2,  1,
  2,  1,  2,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  3,  4,  5,  1,  2,
  3,  4,  1,  2,  3,  1,  2,  3,
  1,  2,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  2,  1,  2,  1,  2,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};

static const int8_t table1_run[148] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  2,
  2,  2,  2,  2,  3,  3,  3,  3,
  4,  4,  4,  4,  5,  5,  5,  5,
  6,  6,  6,  7,  7,  7,  8,  8,
  8,  9,  9,  9, 10, 10, 10, 11,
 11, 11, 12, 12, 12, 13, 13, 14,
 14, 15, 15, 16, 17, 18, 19, 20,
 21, 22, 23, 24, 25, 26, 27, 28,
 29,  0,  0,  0,  0,  0,  1,  1,
  1,  1,  2,  2,  2,  3,  3,  3,
  4,  4,  5,  5,  6,  6,  7,  7,
  8,  8,  9,  9, 10, 10, 11, 11,
 12, 12, 13, 13, 14, 14, 15, 15,
 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43,
};

/* third vlc table */

static const uint16_t table2_vlc[186][2] = {
{    0x1,  2 },{    0x5,  3 },{    0xd,  4 },{   0x12,  5 },
{    0xe,  6 },{   0x15,  7 },{   0x13,  8 },{   0x3f,  8 },
{   0x4b,  9 },{  0x11f,  9 },{   0xb8, 10 },{  0x3e3, 10 },
{  0x172, 11 },{  0x24d, 12 },{  0x3da, 12 },{  0x2dd, 13 },
{ 0x1f55, 13 },{  0x5b9, 14 },{ 0x3eae, 14 },{    0x0,  4 },
{   0x10,  5 },{    0x8,  7 },{   0x20,  8 },{   0x29,  9 },
{  0x1f4,  9 },{  0x233, 10 },{  0x1e0, 11 },{  0x12a, 12 },
{  0x3dd, 12 },{  0x50a, 13 },{ 0x1f29, 13 },{  0xa42, 14 },
{ 0x1272, 15 },{ 0x1737, 15 },{    0x3,  5 },{   0x11,  7 },
{   0xc4,  8 },{   0x4b, 10 },{   0xb4, 11 },{  0x7d4, 11 },
{  0x345, 12 },{  0x2d7, 13 },{  0x7bf, 13 },{  0x938, 14 },
{  0xbbb, 14 },{  0x95e, 15 },{   0x13,  5 },{   0x78,  7 },
{   0x69,  9 },{  0x232, 10 },{  0x461, 11 },{  0x3ec, 12 },
{  0x520, 13 },{ 0x1f2a, 13 },{ 0x3e50, 14 },{ 0x3e51, 14 },
{ 0x1486, 15 },{    0xc,  6 },{   0x24,  9 },{   0x94, 11 },
{  0x8c0, 12 },{  0xf09, 14 },{ 0x1ef0, 15 },{   0x3d,  6 },
{   0x53,  9 },{  0x1a0, 11 },{  0x2d6, 13 },{  0xf08, 14 },
{   0x13,  7 },{   0x7c,  9 },{  0x7c1, 11 },{  0x4ac, 14 },
{   0x1b,  7 },{   0xa0, 10 },{  0x344, 12 },{  0xf79, 14 },
{   0x79,  7 },{  0x3e1, 10 },{  0x2d4, 13 },{ 0x2306, 14 },
{   0x21,  8 },{  0x23c, 10 },{  0xfae, 12 },{ 0x23de, 14 },
{   0x35,  8 },{  0x175, 11 },{  0x7b3, 13 },{   0xc5,  8 },
{  0x174, 11 },{  0x785, 13 },{   0x48,  9 },{  0x1a3, 11 },
{  0x49e, 13 },{   0x2c,  9 },{   0xfa, 10 },{  0x7d6, 11 },
{   0x92, 10 },{  0x5cc, 13 },{ 0x1ef1, 15 },{   0xa3, 10 },
{  0x3ed, 12 },{  0x93e, 14 },{  0x1e2, 11 },{ 0x1273, 15 },
{  0x7c4, 11 },{ 0x1487, 15 },{  0x291, 12 },{  0x293, 12 },
{  0xf8a, 12 },{  0x509, 13 },{  0x508, 13 },{  0x78d, 13 },
{  0x7be, 13 },{  0x78c, 13 },{  0x4ae, 14 },{  0xbba, 14 },
{ 0x2307, 14 },{  0xb9a, 14 },{ 0x1736, 15 },{    0xe,  4 },
{   0x45,  7 },{  0x1f3,  9 },{  0x47a, 11 },{  0x5dc, 13 },
{ 0x23df, 14 },{   0x19,  5 },{   0x28,  9 },{  0x176, 11 },
{  0x49d, 13 },{ 0x23dd, 14 },{   0x30,  6 },{   0xa2, 10 },
{  0x2ef, 12 },{  0x5b8, 14 },{   0x3f,  6 },{   0xa5, 10 },
{  0x3db, 12 },{  0x93f, 14 },{   0x44,  7 },{  0x7cb, 11 },
{  0x95f, 15 },{   0x63,  7 },{  0x3c3, 12 },{   0x15,  8 },
{  0x8f6, 12 },{   0x17,  8 },{  0x498, 13 },{   0x2c,  8 },
{  0x7b2, 13 },{   0x2f,  8 },{ 0x1f54, 13 },{   0x8d,  8 },
{  0x7bd, 13 },{   0x8e,  8 },{ 0x1182, 13 },{   0xfb,  8 },
{  0x50b, 13 },{   0x2d,  8 },{  0x7c0, 11 },{   0x79,  9 },
{ 0x1f5f, 13 },{   0x7a,  9 },{ 0x1f56, 13 },{  0x231, 10 },
{  0x3e4, 10 },{  0x1a1, 11 },{  0x143, 11 },{  0x1f7, 11 },
{  0x16f, 12 },{  0x292, 12 },{  0x2e7, 12 },{  0x16c, 12 },
{  0x16d, 12 },{  0x3dc, 12 },{  0xf8b, 12 },{  0x499, 13 },
{  0x3d8, 12 },{  0x78e, 13 },{  0x2d5, 13 },{ 0x1f5e, 13 },
{ 0x1f2b, 13 },{  0x78f, 13 },{  0x4ad, 14 },{ 0x3eaf, 14 },
{ 0x23dc, 14 },{   0x4a,  9 },
};

static const int8_t table2_level[185] = {
  1,  2,  3,  4,  5,  6,  7,  8,
  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19,  1,  2,  3,  4,  5,
  6,  7,  8,  9, 10, 11, 12, 13,
 14, 15,  1,  2,  3,  4,  5,  6,
  7,  8,  9, 10, 11, 12,  1,  2,
  3,  4,  5,  6,  7,  8,  9, 10,
 11,  1,  2,  3,  4,  5,  6,  1,
  2,  3,  4,  5,  1,  2,  3,  4,
  1,  2,  3,  4,  1,  2,  3,  4,
  1,  2,  3,  4,  1,  2,  3,  1,
  2,  3,  1,  2,  3,  1,  2,  3,
  1,  2,  3,  1,  2,  3,  1,  2,
  1,  2,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  2,  3,  4,  5,  6,  1,  2,  3,
  4,  5,  1,  2,  3,  4,  1,  2,
  3,  4,  1,  2,  3,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,
};

static const int8_t table2_run[185] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,
  3,  4,  4,  4,  4,  4,  4,  5,
  5,  5,  5,  5,  6,  6,  6,  6,
  7,  7,  7,  7,  8,  8,  8,  8,
  9,  9,  9,  9, 10, 10, 10, 11,
 11, 11, 12, 12, 12, 13, 13, 13,
 14, 14, 14, 15, 15, 15, 16, 16,
 17, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30,  0,
  0,  0,  0,  0,  0,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  3,  3,
  3,  3,  4,  4,  4,  5,  5,  6,
  6,  7,  7,  8,  8,  9,  9, 10,
 10, 11, 11, 12, 12, 13, 13, 14,
 14, 15, 15, 16, 17, 18, 19, 20,
 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36,
 37,
};

/* second non intra vlc table */
static const uint16_t table4_vlc[169][2] = {
{    0x0,  3 },{    0x3,  4 },{    0xb,  5 },{   0x14,  6 },
{   0x3f,  6 },{   0x5d,  7 },{   0xa2,  8 },{   0xac,  9 },
{  0x16e,  9 },{  0x20a, 10 },{  0x2e2, 10 },{  0x432, 11 },
{  0x5c9, 11 },{  0x827, 12 },{  0xb54, 12 },{  0x4e6, 13 },
{ 0x105f, 13 },{ 0x172a, 13 },{ 0x20b2, 14 },{ 0x2d4e, 14 },
{ 0x39f0, 14 },{ 0x4175, 15 },{ 0x5a9e, 15 },{    0x4,  4 },
{   0x1e,  5 },{   0x42,  7 },{   0xb6,  8 },{  0x173,  9 },
{  0x395, 10 },{  0x72e, 11 },{  0xb94, 12 },{ 0x16a4, 13 },
{ 0x20b3, 14 },{ 0x2e45, 14 },{    0x5,  5 },{   0x40,  7 },
{   0x49,  9 },{  0x28f, 10 },{  0x5cb, 11 },{  0x48a, 13 },
{  0x9dd, 14 },{ 0x73e2, 15 },{   0x18,  5 },{   0x25,  8 },
{   0x8a, 10 },{  0x51b, 11 },{  0xe5f, 12 },{  0x9c9, 14 },
{ 0x139c, 15 },{   0x29,  6 },{   0x4f,  9 },{  0x412, 11 },
{  0x48d, 13 },{ 0x2e41, 14 },{   0x38,  6 },{  0x10e,  9 },
{  0x5a8, 11 },{ 0x105c, 13 },{ 0x39f2, 14 },{   0x58,  7 },
{  0x21f, 10 },{  0xe7e, 12 },{ 0x39ff, 14 },{   0x23,  8 },
{  0x2e3, 10 },{  0x4e5, 13 },{ 0x2e40, 14 },{   0xa1,  8 },
{  0x5be, 11 },{  0x9c8, 14 },{   0x83,  8 },{  0x13a, 11 },
{ 0x1721, 13 },{   0x44,  9 },{  0x276, 12 },{ 0x39f6, 14 },
{   0x8b, 10 },{  0x4ef, 13 },{ 0x5a9b, 15 },{  0x208, 10 },
{ 0x1cfe, 13 },{  0x399, 10 },{ 0x1cb4, 13 },{  0x39e, 10 },
{ 0x39f3, 14 },{  0x5ab, 11 },{ 0x73e3, 15 },{  0x737, 11 },
{ 0x5a9f, 15 },{  0x82d, 12 },{  0xe69, 12 },{  0xe68, 12 },
{  0x433, 11 },{  0xb7b, 12 },{ 0x2df8, 14 },{ 0x2e56, 14 },
{ 0x2e57, 14 },{ 0x39f7, 14 },{ 0x51a5, 15 },{    0x3,  3 },
{   0x2a,  6 },{   0xe4,  8 },{  0x28e, 10 },{  0x735, 11 },
{ 0x1058, 13 },{ 0x1cfa, 13 },{ 0x2df9, 14 },{ 0x4174, 15 },
{    0x9,  4 },{   0x54,  8 },{  0x398, 10 },{  0x48b, 13 },
{ 0x139d, 15 },{    0xd,  4 },{   0xad,  9 },{  0x826, 12 },
{ 0x2d4c, 14 },{   0x11,  5 },{  0x16b,  9 },{  0xb7f, 12 },
{ 0x51a4, 15 },{   0x19,  5 },{  0x21b, 10 },{ 0x16fd, 13 },
{   0x1d,  5 },{  0x394, 10 },{ 0x28d3, 14 },{   0x2b,  6 },
{  0x5bc, 11 },{ 0x5a9a, 15 },{   0x2f,  6 },{  0x247, 12 },
{   0x10,  7 },{  0xa35, 12 },{   0x3e,  6 },{  0xb7a, 12 },
{   0x59,  7 },{ 0x105e, 13 },{   0x26,  8 },{  0x9cf, 14 },
{   0x55,  8 },{ 0x1cb5, 13 },{   0x57,  8 },{  0xe5b, 12 },
{   0xa0,  8 },{ 0x1468, 13 },{  0x170,  9 },{   0x90, 10 },
{  0x1ce,  9 },{  0x21a, 10 },{  0x218, 10 },{  0x168,  9 },
{  0x21e, 10 },{  0x244, 12 },{  0x736, 11 },{  0x138, 11 },
{  0x519, 11 },{  0xe5e, 12 },{  0x72c, 11 },{  0xb55, 12 },
{  0x9dc, 14 },{ 0x20bb, 14 },{  0x48c, 13 },{ 0x1723, 13 },
{ 0x2e44, 14 },{ 0x16a5, 13 },{  0x518, 11 },{ 0x39fe, 14 },
{  0x169,  9 },
};

static const int8_t table4_level[168] = {
  1,  2,  3,  4,  5,  6,  7,  8,
  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19, 20, 21, 22, 23,  1,
  2,  3,  4,  5,  6,  7,  8,  9,
 10, 11,  1,  2,  3,  4,  5,  6,
  7,  8,  1,  2,  3,  4,  5,  6,
  7,  1,  2,  3,  4,  5,  1,  2,
  3,  4,  5,  1,  2,  3,  4,  1,
  2,  3,  4,  1,  2,  3,  1,  2,
  3,  1,  2,  3,  1,  2,  3,  1,
  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  2,  3,  4,  5,
  6,  7,  8,  9,  1,  2,  3,  4,
  5,  1,  2,  3,  4,  1,  2,  3,
  4,  1,  2,  3,  1,  2,  3,  1,
  2,  3,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
};

static const int8_t table4_run[168] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  2,  2,
  2,  2,  3,  3,  3,  3,  3,  3,
  3,  4,  4,  4,  4,  4,  5,  5,
  5,  5,  5,  6,  6,  6,  6,  7,
  7,  7,  7,  8,  8,  8,  9,  9,
  9, 10, 10, 10, 11, 11, 11, 12,
 12, 13, 13, 14, 14, 15, 15, 16,
 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  1,  1,  1,  1,
  1,  2,  2,  2,  2,  3,  3,  3,
  3,  4,  4,  4,  5,  5,  5,  6,
  6,  6,  7,  7,  8,  8,  9,  9,
 10, 10, 11, 11, 12, 12, 13, 13,
 14, 14, 15, 16, 17, 18, 19, 20,
 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36,
};

extern const uint16_t inter_vlc[103][2];
extern const int8_t inter_level[102];
extern const int8_t inter_run[102];

extern const uint16_t intra_vlc[103][2];
extern const int8_t intra_level[102];
extern const int8_t intra_run[102];

RLTable rl_table[NB_RL_TABLES] = {
    /* intra luminance tables */
    /* low motion  */
    {
        132,
        85,
        table0_vlc,
        table0_run,
        table0_level,
    },
    /* high motion */
    {
        185,
        119,
        table2_vlc,
        table2_run,
        table2_level,
    },
    /* mid-rate */
    {
        102,
        67,
        intra_vlc,
        intra_run,
        intra_level,
    },
    /* intra chrominance / non intra tables */
    /* low motion inter */
    {
        148,
        81,
        table1_vlc,
        table1_run,
        table1_level,
    },
    /* high motion inter */
    {
        168,
        99,
        table4_vlc,
        table4_run,
        table4_level,
    },
    /* mid rate inter */
    {
        102,
        58,
        inter_vlc,
        inter_run,
        inter_level,
    },
};

/* motion vector table 0 */

static const uint16_t table0_mv_code[1100] = {
 0x0001, 0x0003, 0x0005, 0x0007, 0x0003, 0x0008, 0x000c, 0x0001,
 0x0002, 0x001b, 0x0006, 0x000b, 0x0015, 0x0002, 0x000e, 0x000f,
 0x0014, 0x0020, 0x0022, 0x0025, 0x0027, 0x0029, 0x002d, 0x004b,
 0x004d, 0x0003, 0x0022, 0x0023, 0x0025, 0x0027, 0x0042, 0x0048,
 0x0049, 0x0050, 0x005c, 0x0091, 0x009f, 0x000e, 0x0043, 0x004c,
 0x0054, 0x0056, 0x008c, 0x0098, 0x009a, 0x009b, 0x00b1, 0x00b2,
 0x0120, 0x0121, 0x0126, 0x0133, 0x0139, 0x01a1, 0x01a4, 0x01a5,
 0x01a6, 0x01a7, 0x01ae, 0x01af, 0x000b, 0x0019, 0x0085, 0x0090,
 0x009b, 0x00aa, 0x00af, 0x010c, 0x010e, 0x011c, 0x011e, 0x0133,
 0x0144, 0x0160, 0x0174, 0x0175, 0x0177, 0x0178, 0x0249, 0x024b,
 0x0252, 0x0261, 0x0265, 0x0270, 0x0352, 0x0353, 0x0355, 0x0359,
 0x0010, 0x0011, 0x0013, 0x0034, 0x0035, 0x0036, 0x0037, 0x003d,
 0x003e, 0x0109, 0x0126, 0x0156, 0x021a, 0x021e, 0x023a, 0x023e,
 0x028e, 0x028f, 0x02cf, 0x0491, 0x0494, 0x049f, 0x04a0, 0x04a3,
 0x04a6, 0x04a7, 0x04ad, 0x04ae, 0x04c0, 0x04c4, 0x04c6, 0x04c8,
 0x04c9, 0x04f5, 0x04f6, 0x04f7, 0x0680, 0x0682, 0x0683, 0x0688,
 0x0689, 0x068d, 0x068e, 0x068f, 0x06a2, 0x06a3, 0x06a9, 0x06b0,
 0x06b1, 0x06b4, 0x06b5, 0x0024, 0x0060, 0x0063, 0x0078, 0x0079,
 0x0211, 0x0244, 0x0245, 0x0247, 0x0248, 0x0249, 0x024a, 0x024b,
 0x026b, 0x02af, 0x02b8, 0x02bb, 0x0436, 0x0476, 0x0477, 0x047e,
 0x04c8, 0x04c9, 0x04ca, 0x0514, 0x0586, 0x0587, 0x0598, 0x059d,
 0x05d9, 0x05da, 0x0920, 0x0921, 0x093b, 0x093c, 0x093d, 0x0942,
 0x0943, 0x0944, 0x0945, 0x0959, 0x095e, 0x095f, 0x0982, 0x0983,
 0x098e, 0x098f, 0x09c4, 0x09e7, 0x09e8, 0x09e9, 0x0d02, 0x0d17,
 0x0d18, 0x0d19, 0x0d41, 0x0d42, 0x0d43, 0x0d50, 0x0d5f, 0x0d6d,
 0x0d6e, 0x0d6f, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x041e, 0x041f, 0x0420, 0x0421,
 0x048c, 0x048d, 0x04d3, 0x04d4, 0x04d5, 0x055c, 0x055d, 0x0572,
 0x0573, 0x0574, 0x0575, 0x08de, 0x08df, 0x08fe, 0x08ff, 0x0996,
 0x0a36, 0x0a37, 0x0b08, 0x0b09, 0x0b0a, 0x0b0b, 0x0b32, 0x0b33,
 0x0b34, 0x0b35, 0x0b36, 0x0b37, 0x0b38, 0x0b39, 0x0bb0, 0x0bf7,
 0x0bf8, 0x0bf9, 0x0bfa, 0x0bfb, 0x0bfc, 0x0bfd, 0x0bfe, 0x0bff,
 0x1254, 0x1255, 0x1256, 0x1257, 0x1270, 0x1271, 0x1272, 0x1273,
 0x1274, 0x1275, 0x12ab, 0x12ac, 0x12ad, 0x12ae, 0x12af, 0x12b0,
 0x12b1, 0x1315, 0x1316, 0x1317, 0x13bf, 0x13c0, 0x13c1, 0x13c2,
 0x13c3, 0x13c4, 0x13c5, 0x13c6, 0x13c7, 0x13c8, 0x13c9, 0x13ca,
 0x13cb, 0x13cc, 0x13cd, 0x1a06, 0x1a07, 0x1a28, 0x1a29, 0x1a2a,
 0x1a2b, 0x1a2c, 0x1a2d, 0x1a80, 0x1abb, 0x1abc, 0x1abd, 0x1ad8,
 0x1ad9, 0x0094, 0x0095, 0x0096, 0x0097, 0x00a0, 0x00a1, 0x00a2,
 0x00a3, 0x0831, 0x0832, 0x0833, 0x0834, 0x0835, 0x0836, 0x0837,
 0x0838, 0x0839, 0x083a, 0x083b, 0x0939, 0x093a, 0x093b, 0x093c,
 0x093d, 0x093e, 0x093f, 0x09a0, 0x09a1, 0x09a2, 0x09a3, 0x09a4,
 0x09a5, 0x11ac, 0x11ad, 0x11ae, 0x11af, 0x11b0, 0x11b1, 0x11b2,
 0x11b3, 0x11b4, 0x11b5, 0x11b6, 0x11b7, 0x11b8, 0x11b9, 0x11ba,
 0x11bb, 0x132f, 0x1454, 0x1455, 0x1456, 0x1457, 0x1458, 0x1459,
 0x145a, 0x145b, 0x145c, 0x145d, 0x145e, 0x145f, 0x1460, 0x1461,
 0x1462, 0x1463, 0x1464, 0x1465, 0x1466, 0x1467, 0x1468, 0x1469,
 0x146a, 0x146b, 0x17de, 0x17df, 0x17e0, 0x17e1, 0x17e2, 0x17e3,
 0x17e4, 0x17e5, 0x17e6, 0x17e7, 0x17e8, 0x17e9, 0x17ea, 0x17eb,
 0x17ec, 0x17ed, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 0x2545,
 0x2546, 0x2547, 0x2548, 0x2549, 0x254a, 0x254b, 0x254c, 0x254d,
 0x254e, 0x254f, 0x2550, 0x2551, 0x2552, 0x2553, 0x2554, 0x2555,
 0x2628, 0x2766, 0x2767, 0x2768, 0x2769, 0x276a, 0x276b, 0x276c,
 0x276d, 0x276e, 0x276f, 0x2770, 0x2771, 0x2772, 0x2773, 0x2774,
 0x2775, 0x2776, 0x2777, 0x2778, 0x2779, 0x277a, 0x277b, 0x277c,
 0x277d, 0x3503, 0x3544, 0x3545, 0x3546, 0x3547, 0x3560, 0x3561,
 0x3562, 0x3563, 0x3564, 0x3565, 0x3566, 0x3567, 0x3568, 0x3569,
 0x356a, 0x356b, 0x356c, 0x356d, 0x356e, 0x356f, 0x3570, 0x3571,
 0x3572, 0x3573, 0x3574, 0x3575, 0x03f0, 0x103d, 0x103e, 0x103f,
 0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047,
 0x1048, 0x1049, 0x104a, 0x104b, 0x104c, 0x104d, 0x104e, 0x104f,
 0x1050, 0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057,
 0x1058, 0x1059, 0x105a, 0x105b, 0x105c, 0x105d, 0x105e, 0x105f,
 0x1060, 0x1061, 0x1270, 0x1271, 0x21b8, 0x21b9, 0x21ba, 0x21bb,
 0x21bc, 0x21bd, 0x21be, 0x21bf, 0x21f0, 0x21f1, 0x21f2, 0x21f3,
 0x21f4, 0x21f5, 0x21f6, 0x21f7, 0x21f8, 0x21f9, 0x21fa, 0x21fb,
 0x21fc, 0x21fd, 0x21fe, 0x21ff, 0x2340, 0x2341, 0x2342, 0x2343,
 0x2344, 0x2345, 0x2346, 0x2347, 0x2348, 0x2349, 0x234a, 0x234b,
 0x234c, 0x234d, 0x234e, 0x234f, 0x2350, 0x2351, 0x2352, 0x2353,
 0x2354, 0x2355, 0x2356, 0x2357, 0x265c, 0x2f88, 0x2f89, 0x2f8a,
 0x2f8b, 0x2f8c, 0x2f8d, 0x2f8e, 0x2f8f, 0x2f90, 0x2f91, 0x2f92,
 0x2f93, 0x2f94, 0x2f95, 0x2f96, 0x2f97, 0x2f98, 0x2f99, 0x2f9a,
 0x2f9b, 0x2f9c, 0x2f9d, 0x2f9e, 0x2f9f, 0x2fa0, 0x2fa1, 0x2fa2,
 0x2fa3, 0x2fa4, 0x2fa5, 0x2fa6, 0x2fa7, 0x2fa8, 0x2fa9, 0x2faa,
 0x2fab, 0x2fac, 0x2fad, 0x2fae, 0x2faf, 0x2fb0, 0x2fb1, 0x2fb2,
 0x2fb3, 0x2fb4, 0x2fb5, 0x2fb6, 0x2fb7, 0x2fb8, 0x2fb9, 0x2fba,
 0x2fbb, 0x4c52, 0x4c53, 0x4e28, 0x4e29, 0x4e2a, 0x4e2b, 0x4e2c,
 0x4e2d, 0x4e2e, 0x4e2f, 0x4e30, 0x4e31, 0x4e32, 0x4e33, 0x4e34,
 0x4e35, 0x4e36, 0x4e37, 0x4e38, 0x4e39, 0x4e3a, 0x4e3b, 0x4e3c,
 0x4e3d, 0x4e3e, 0x4e3f, 0x4e80, 0x4e81, 0x4e82, 0x4e83, 0x4e84,
 0x4e85, 0x4e86, 0x4e87, 0x4e88, 0x4e89, 0x4e8a, 0x4e8b, 0x4e8c,
 0x4e8d, 0x4e8e, 0x4e8f, 0x4e90, 0x4e91, 0x4e92, 0x4e93, 0x4e94,
 0x4e95, 0x4e96, 0x4e97, 0x4e98, 0x4e99, 0x4e9a, 0x4e9b, 0x4e9c,
 0x4e9d, 0x4e9e, 0x4e9f, 0x4ea0, 0x4ea1, 0x4ea2, 0x4ea3, 0x4ea4,
 0x4ea5, 0x4ea6, 0x4ea7, 0x4ea8, 0x4ea9, 0x4eaa, 0x4eab, 0x4eac,
 0x4ead, 0x4eae, 0x4eaf, 0x4eb0, 0x4eb1, 0x4eb2, 0x4eb3, 0x4eb4,
 0x4eb5, 0x4eb6, 0x4eb7, 0x4eb8, 0x4eb9, 0x4eba, 0x4ebb, 0x4ebc,
 0x4ebd, 0x4ebe, 0x4ebf, 0x4ec0, 0x4ec1, 0x4ec2, 0x4ec3, 0x4ec4,
 0x4ec5, 0x4ec6, 0x4ec7, 0x4ec8, 0x4ec9, 0x4eca, 0x4ecb, 0x6a04,
 0x6a05, 0x07e2, 0x07e3, 0x07e4, 0x07e5, 0x07e6, 0x07e7, 0x07e8,
 0x07e9, 0x07ea, 0x07eb, 0x07ec, 0x07ed, 0x07ee, 0x07ef, 0x07f0,
 0x07f1, 0x07f2, 0x07f3, 0x07f4, 0x07f5, 0x07f6, 0x07f7, 0x07f8,
 0x07f9, 0x07fa, 0x07fb, 0x07fc, 0x07fd, 0x07fe, 0x07ff, 0x2000,
 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008,
 0x2009, 0x200a, 0x200b, 0x200c, 0x200d, 0x200e, 0x200f, 0x2010,
 0x2011, 0x2012, 0x2013, 0x2014, 0x2015, 0x2016, 0x2017, 0x2018,
 0x2019, 0x201a, 0x201b, 0x201c, 0x201d, 0x201e, 0x201f, 0x2020,
 0x2021, 0x2022, 0x2023, 0x2024, 0x2025, 0x2026, 0x2027, 0x2028,
 0x2029, 0x202a, 0x202b, 0x202c, 0x202d, 0x202e, 0x202f, 0x2030,
 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037, 0x2038,
 0x2039, 0x203a, 0x203b, 0x203c, 0x203d, 0x203e, 0x203f, 0x2040,
 0x2041, 0x2042, 0x2043, 0x2044, 0x2045, 0x2046, 0x2047, 0x2048,
 0x2049, 0x204a, 0x204b, 0x204c, 0x204d, 0x204e, 0x204f, 0x2050,
 0x2051, 0x2052, 0x2053, 0x2054, 0x2055, 0x2056, 0x2057, 0x2058,
 0x2059, 0x205a, 0x205b, 0x205c, 0x205d, 0x205e, 0x205f, 0x2060,
 0x2061, 0x2062, 0x2063, 0x2064, 0x2065, 0x2066, 0x2067, 0x2068,
 0x2069, 0x206a, 0x206b, 0x206c, 0x206d, 0x206e, 0x206f, 0x2070,
 0x2071, 0x2072, 0x2073, 0x2074, 0x2075, 0x2076, 0x2077, 0x2078,
 0x2079, 0x4cba, 0x4cbb, 0x5d88, 0x5d89, 0x5d8a, 0x5d8b, 0x5d8c,
 0x5d8d, 0x5d8e, 0x5d8f, 0x5db0, 0x5db1, 0x5db2, 0x5db3, 0x5db4,
 0x5db5, 0x5db6, 0x5db7, 0x5db8, 0x5db9, 0x5dba, 0x5dbb, 0x5dbc,
 0x5dbd, 0x5dbe, 0x5dbf, 0x5e40, 0x5e41, 0x5e42, 0x5e43, 0x5e44,
 0x5e45, 0x5e46, 0x5e47, 0x5e48, 0x5e49, 0x5e4a, 0x5e4b, 0x5e4c,
 0x5e4d, 0x5e4e, 0x5e4f, 0x5e50, 0x5e51, 0x5e52, 0x5e53, 0x5e54,
 0x5e55, 0x5e56, 0x5e57, 0x5e58, 0x5e59, 0x5e5a, 0x5e5b, 0x5e5c,
 0x5e5d, 0x5e5e, 0x5e5f, 0x5e60, 0x5e61, 0x5e62, 0x5e63, 0x5e64,
 0x5e65, 0x5e66, 0x5e67, 0x5e68, 0x5e69, 0x5e6a, 0x5e6b, 0x5e6c,
 0x5e6d, 0x5e6e, 0x5e6f, 0x5e70, 0x5e71, 0x5e72, 0x5e73, 0x5e74,
 0x5e75, 0x5e76, 0x5e77, 0x5e78, 0x5e79, 0x5e7a, 0x5e7b, 0x5e7c,
 0x5e7d, 0x5e7e, 0x5e7f, 0x5e80, 0x5e81, 0x5e82, 0x5e83, 0x5e84,
 0x5e85, 0x5e86, 0x5e87, 0x5e88, 0x5e89, 0x5e8a, 0x5e8b, 0x5e8c,
 0x5e8d, 0x5e8e, 0x5e8f, 0x5e90, 0x5e91, 0x5e92, 0x5e93, 0x5e94,
 0x5e95, 0x5e96, 0x5e97, 0x5e98, 0x5e99, 0x5e9a, 0x5e9b, 0x5e9c,
 0x5e9d, 0x5e9e, 0x5e9f, 0x5ea0, 0x5ea1, 0x5ea2, 0x5ea3, 0x5ea4,
 0x5ea5, 0x5ea6, 0x5ea7, 0x5ea8, 0x5ea9, 0x5eaa, 0x5eab, 0x5eac,
 0x5ead, 0x5eae, 0x5eaf, 0x5eb0, 0x5eb1, 0x5eb2, 0x5eb3, 0x5eb4,
 0x5eb5, 0x5eb6, 0x5eb7, 0x5eb8, 0x5eb9, 0x5eba, 0x5ebb, 0x5ebc,
 0x5ebd, 0x5ebe, 0x5ebf, 0x5ec0, 0x5ec1, 0x5ec2, 0x5ec3, 0x5ec4,
 0x5ec5, 0x5ec6, 0x5ec7, 0x5ec8, 0x5ec9, 0x5eca, 0x5ecb, 0x5ecc,
 0x5ecd, 0x5ece, 0x5ecf, 0x5ed0, 0x5ed1, 0x5ed2, 0x5ed3, 0x5ed4,
 0x5ed5, 0x5ed6, 0x5ed7, 0x5ed8, 0x5ed9, 0x5eda, 0x5edb, 0x5edc,
 0x5edd, 0x5ede, 0x5edf, 0x5ee0, 0x5ee1, 0x5ee2, 0x5ee3, 0x5ee4,
 0x5ee5, 0x5ee6, 0x5ee7, 0x5ee8, 0x5ee9, 0x5eea, 0x5eeb, 0x5eec,
 0x5eed, 0x5eee, 0x5eef, 0x5ef0, 0x5ef1, 0x5ef2, 0x5ef3, 0x5ef4,
 0x5ef5, 0x5ef6, 0x5ef7, 0x5ef8, 0x5ef9, 0x5efa, 0x5efb, 0x5efc,
 0x5efd, 0x5efe, 0x5eff, 0x5f00, 0x5f01, 0x5f02, 0x5f03, 0x5f04,
 0x5f05, 0x5f06, 0x5f07, 0x5f08, 0x5f09, 0x5f0a, 0x5f0b, 0x5f0c,
 0x5f0d, 0x5f0e, 0x5f0f, 0x0000,
};

static const uint8_t table0_mv_bits[1100] = {
  1,  4,  4,  4,  5,  5,  5,  6,
  6,  6,  7,  7,  7,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17,  8,
};

static const uint8_t table0_mvx[1099] = {
 32, 32, 31, 32, 33, 31, 33, 31,
 33, 32, 34, 32, 30, 32, 31, 34,
 35, 32, 34, 33, 29, 33, 30, 30,
 31, 31, 35, 29, 33, 35, 33, 34,
 31, 29, 30, 34, 30, 36, 28, 32,
 34, 37, 30, 27, 32, 25, 39, 32,
 34, 32, 35, 35, 35, 31, 35, 29,
 32, 29, 30, 29, 37, 27, 36, 38,
 37, 33, 32, 31, 29, 31, 28, 36,
 33, 30, 34, 33, 33, 28, 27, 25,
 31, 26, 39, 32, 32, 31, 33, 39,
 31, 38, 28, 36, 21, 23, 43, 36,
 34, 41, 30, 25, 28, 31, 30, 34,
 38, 35, 61, 34, 28, 30, 37, 37,
 35, 27, 36,  3, 59, 38, 37, 32,
 31, 29, 26, 33, 37, 33, 27, 27,
 35, 34, 34, 40, 42, 33, 32, 29,
  4,  5, 28, 24, 25, 35, 39, 38,
 32, 23, 27, 32, 30, 35, 26, 34,
 60, 36, 29, 22, 26, 41,  7, 30,
 38, 30, 36, 29, 30, 41, 26, 25,
 32, 34, 24, 39,  1, 25, 39, 32,
 28, 29, 32, 38, 26, 36, 28, 63,
 28, 39, 23, 21, 26, 35, 31, 35,
 57, 31, 29, 29, 28, 30, 27, 35,
  2, 38, 40, 34, 37, 29, 38, 43,
 26, 32, 33, 42, 24, 40, 28, 32,
 32, 32, 36, 32, 43, 25, 21, 31,
 30, 31, 41, 29, 33, 37, 26, 37,
 27, 59, 23, 33, 35, 31, 31, 37,
 38, 39, 32, 23, 32, 27, 37, 36,
 31, 40, 25, 27, 38, 31, 36, 28,
 31, 36, 25, 45,  3, 34, 38, 39,
 40, 38, 30, 32, 19, 24, 25, 26,
 45, 20, 24, 33, 33, 31, 41, 34,
 39, 47, 40, 58, 59, 41, 33,  3,
 17, 61, 42, 30, 26, 29, 36, 61,
 33, 37, 62, 28, 25, 38, 25, 38,
 17, 23, 34, 33, 21, 33, 49, 27,
 32, 23, 27, 22, 24, 22, 39, 43,
 27, 37,  6, 42, 47, 26, 30, 31,
 41, 39, 33, 22, 45, 36, 32, 45,
 19, 22, 30,  5,  5, 17, 29, 22,
 31, 31, 43, 37, 27, 32, 32, 32,
 33, 34, 43, 35, 29, 26, 22, 32,
 19, 32, 25, 31, 41, 49, 28, 34,
 28, 39, 34, 19, 37, 38, 29, 21,
 36, 42, 24, 48, 16, 28, 49, 22,
 34, 31, 38, 39, 44, 11, 35, 30,
 33, 33, 23, 28, 33, 46, 15, 13,
 24, 41, 24, 34, 34, 30, 26, 24,
 14, 60, 21, 29, 39, 23, 35, 37,
 63, 45, 33, 34, 47, 41, 22, 42,
 35, 35, 23, 32, 35, 43, 32,  7,
 31, 41, 20, 31, 16, 13, 63, 25,
 30, 32, 35, 30, 30, 31, 42, 47,
 39, 38, 40, 40, 51, 55, 56, 18,
 21, 39, 39, 33, 17, 41, 23, 24,
 43, 25, 31, 20, 19, 45,  1, 34,
 31, 22, 35, 15, 46, 46, 35, 31,
 28, 29, 29, 23, 41, 27, 14, 53,
 53, 27, 24, 32, 57, 32, 17, 42,
 37, 29, 33,  1, 25, 32, 32, 63,
 26, 40, 44, 36, 31, 39, 20, 20,
 44, 23, 33, 34, 35, 33, 33, 28,
 41, 23, 41, 41, 29, 25, 26, 49,
 29, 24, 37, 49, 50, 51, 51, 26,
 39, 25, 26, 15, 39, 18, 42, 17,
  4, 31, 32, 32, 60,  1, 42, 32,
  0, 12, 19, 35, 21, 41, 17, 26,
 20, 45, 46, 32, 37, 22, 47, 29,
 31, 27, 29, 30, 21, 33, 35, 18,
 25, 33, 50, 51, 42,  2, 15, 51,
 53, 33, 25, 29, 55, 37, 38, 33,
 38, 59, 38, 33, 39, 13, 32, 40,
 61, 61, 32,  9, 44,  3, 31, 29,
 25, 31, 27, 23,  9, 25,  9, 29,
 20, 30, 30, 42, 18, 28, 25, 28,
 28, 21, 29, 43, 29, 43, 26, 44,
 44, 21, 38, 21, 24, 45, 45, 35,
 39, 22, 35, 36, 34, 34, 45, 34,
 29, 31, 46, 25, 46, 16, 17, 31,
 20, 32, 47, 47, 47, 32, 49, 49,
 49, 31,  1, 27, 28, 39, 39, 21,
 36, 23, 51,  2, 40, 51, 32, 53,
 24, 30, 24, 30, 21, 40, 57, 57,
 31, 41, 58, 32, 12,  4, 32, 34,
 59, 31, 32, 13,  9, 35, 26, 35,
 37, 61, 37, 63, 26, 29, 41, 38,
 23, 20, 41, 26, 41, 42, 42, 42,
 26, 26, 26, 26,  1, 26, 37, 37,
 37, 23, 34, 42, 27, 43, 34, 27,
 31, 24, 33, 16,  3, 31, 24, 33,
 24,  4, 44, 44, 11, 44, 31, 13,
 13, 44, 45, 13, 25, 22, 38, 26,
 38, 38, 39, 32, 30, 39, 30, 22,
 32, 26, 30, 47, 47, 47, 19, 47,
 30, 31, 35,  8, 23, 47, 47, 27,
 35, 47, 31, 48, 35, 19, 36, 49,
 49, 33, 31, 39, 27, 39, 49, 49,
 50, 50, 50, 39, 31, 51, 51, 39,
 28, 33, 33, 21, 40, 31, 52, 53,
 40, 53,  9, 33, 31, 53, 54, 54,
 54, 55, 55, 34, 15, 56, 25, 56,
 21, 21, 40, 40, 25, 40, 58, 36,
  5, 41, 41, 12, 60, 41, 41, 37,
 22, 61, 18, 29, 29, 30, 61, 30,
 61, 62, 62, 30, 30, 63, 18, 13,
 30, 23, 19, 20, 20, 41, 13,  2,
  5,  5,  1,  5, 32,  6, 32, 35,
 20, 35, 27, 35, 35, 36, 36, 13,
 36, 41, 41, 41,  3, 30, 42, 27,
 20, 30, 27, 28, 30, 21, 33, 33,
 14, 24, 30, 42, 24, 33, 25, 42,
 43, 14, 43, 43, 14, 43,  7, 36,
 37, 37, 37, 37,  7, 14, 25, 43,
 43, 44, 15, 37,  7,  7,  3,  1,
  8, 15, 15,  8, 44, 44, 44, 45,
 45, 45, 45,  8,  8, 45, 21, 45,
 28, 28, 28, 21, 28, 28, 22, 37,
 46, 46, 37,  8, 29, 37, 29, 22,
 46, 37, 22, 29, 47, 47, 38, 38,
 16, 38, 38, 33, 38, 22, 47, 47,
 29, 25, 16,  0, 48,  1, 34, 48,
 48, 34, 25, 26, 26, 49, 49, 26,
  1, 49,  4, 26,  4, 49,  1,  9,
 49, 49, 49, 10, 49, 17, 38, 17,
 17, 50, 38, 50, 50, 22, 38, 51,
 38, 38, 51, 39, 39, 18, 22, 39,
 51, 22, 52, 52, 52, 39, 53, 53,
 10, 23, 18, 29, 10, 53, 29, 54,
 11, 54, 11, 11, 55,  1, 18, 55,
 55, 55, 55, 55, 55, 29, 34, 18,
 29, 56, 56, 34, 57, 34, 34, 29,
 29, 57, 57, 35, 35, 35, 35, 35,
 39, 35, 59, 59, 18, 59, 39, 30,
 18, 40, 60, 60, 61, 30, 18, 61,
 61, 19, 19,
};

static const uint8_t table0_mvy[1099] = {
 32, 31, 32, 33, 32, 31, 31, 33,
 33, 34, 32, 30, 32, 35, 34, 31,
 32, 29, 33, 30, 32, 34, 33, 31,
 30, 35, 31, 31, 29, 33, 35, 30,
 29, 33, 34, 34, 30, 32, 32, 36,
 29, 32, 35, 32, 28, 32, 32, 27,
 35, 37, 34, 29, 30, 36, 35, 34,
 25, 30, 29, 35, 33, 31, 31, 32,
 31, 28, 39, 28, 29, 37, 31, 33,
 27, 36, 28, 36, 37, 33, 33, 31,
 27, 32, 31, 38, 26, 25, 25, 33,
 39, 31, 34, 30, 32, 32, 32, 34,
 36, 32, 28, 33, 30, 38, 37, 27,
 33, 28, 32, 37, 35, 38, 29, 34,
 27, 29, 29, 32, 32, 34, 35,  3,
 26, 36, 31, 38, 30, 26, 35, 34,
 37, 26, 25, 32, 32, 39, 23, 37,
 32, 32, 29, 32, 29, 36, 29, 30,
 41, 31, 30, 21, 39, 25, 34, 38,
 32, 35, 39, 32, 33, 33, 32, 27,
 29, 25, 28, 27, 26, 31, 30, 35,
 24, 24, 31, 34, 32, 30, 35, 40,
 28, 38,  5, 35, 29, 36, 36, 32,
 38, 30, 33, 31, 35, 26, 23, 38,
 32, 41, 28, 25, 37, 40, 37, 39,
 32, 36, 33, 39, 25, 26, 28, 31,
 28, 42, 23, 31, 33, 31, 39,  1,
 59, 22, 27,  4, 33, 34, 33, 24,
 41,  3, 35, 41, 41, 28, 36, 36,
 28, 33, 35, 21, 23, 21, 22, 37,
 27, 27, 43, 29, 60, 39, 27, 25,
 59, 34, 27, 27, 26, 40, 37, 27,
 61, 26, 39, 33, 31, 22, 37, 25,
 30, 25, 24, 61, 31, 34, 25, 38,
 32, 32, 30,  3, 61, 43, 29, 23,
 28, 32, 28, 32, 31, 34,  5, 33,
 32, 33, 33, 42, 37, 23, 38, 31,
 40, 26, 32, 26, 37, 38, 36, 24,
 29, 30, 20, 22, 29, 24, 32, 41,
  2, 34, 25, 33, 29, 31, 39, 35,
 36, 24, 32, 30, 33, 27, 44, 60,
 30, 36, 19, 34, 31, 24, 16, 35,
 32, 38, 21, 33, 31, 31, 21, 35,
  5, 17, 29, 38, 38, 18, 58, 19,
 43, 41, 30, 41, 43, 39, 29,  7,
 29, 17, 28, 19, 28, 31, 25, 19,
 40, 26, 21, 33, 39, 23, 40, 30,
 39, 34, 35, 32, 32, 24, 33, 30,
 40, 47, 39, 37, 32, 33, 24, 23,
 45, 47, 27, 23, 42, 32, 32, 33,
 36, 37, 37, 17, 18, 22, 40, 38,
 32, 31, 35, 24, 17, 25, 17, 23,
 33, 34, 51, 42, 31, 36, 36, 29,
 21, 22, 37, 44, 43, 25, 47, 33,
 45, 27, 31, 58, 31, 32, 31, 38,
 43, 20, 47, 45, 54,  1, 26, 34,
 38, 14, 22, 24, 33, 34, 32, 32,
 37, 21, 23, 49, 35, 23, 28, 39,
 39, 23, 55, 33, 30, 30, 63, 16,
 42, 28, 13, 33, 33, 35, 19, 46,
 43, 17, 19, 36, 39, 24, 31, 32,
 33, 26, 28, 62, 33, 63, 33, 39,
 19, 49, 17, 31, 43, 13, 15, 29,
 25, 35, 33, 23, 49, 41, 28, 29,
 34, 38,  7, 61, 11, 50, 13, 41,
 19, 47, 25, 26, 15, 42, 41, 29,
 45, 27, 17, 35, 32, 29, 32, 24,
 13, 26, 26, 31, 24, 33, 28, 30,
 31, 11, 45, 46, 33, 33, 35, 57,
 32, 32, 35, 45, 34, 11, 37, 42,
 39, 37, 31, 49, 21, 27, 29, 47,
 53, 40, 51, 16, 26,  1, 40, 30,
 41, 44, 34, 25, 27, 31, 35, 35,
 31, 15, 49,  1, 35, 40,  5, 58,
 21, 29, 22, 59, 45, 31,  9, 26,
  9, 29, 11, 32, 30,  3, 13, 20,
 18, 20, 11,  3, 29, 40, 31, 53,
 30, 17, 20, 37, 31, 42, 47, 47,
 54, 38,  9, 34, 13, 37, 21, 25,
 27, 43, 42, 45, 40, 25, 27, 46,
 22, 25, 53, 20,  2, 14, 39, 15,
 22, 44, 34, 21, 38, 33, 27, 48,
 34, 52, 35, 47, 49, 54,  2, 13,
 23, 52, 29, 45, 22, 49, 54, 21,
 40, 42, 31, 30, 29, 34,  0, 25,
 23, 51, 24, 59, 28, 38, 29, 31,
  2, 13, 31,  8, 31, 33, 12, 45,
 41,  7, 14, 30, 25, 18, 43, 20,
 43, 35, 44,  1, 49, 42, 42, 18,
 41, 38, 41, 44, 53, 11, 20, 25,
 45, 46, 47, 48, 39, 52, 46, 49,
 63, 55, 44, 38, 13, 13, 57, 22,
 51, 16, 12, 28, 35, 57, 25, 20,
 26, 28, 28, 29, 32, 31, 62, 34,
 35, 35, 19, 49, 48, 39, 40, 18,
 43, 46, 11,  6, 48, 19, 49, 41,
 10, 23, 58, 17, 21, 23, 34, 30,
 60,  0, 44, 34, 26, 37, 46, 43,
 49, 59,  4, 34, 59, 37, 22, 25,
 28, 46,  6, 40, 59, 42, 36, 61,
 28, 30, 31, 43, 10, 22, 23, 47,
 20, 52, 55, 36, 25, 16,  1, 11,
 27, 29,  5, 63, 18, 41, 31, 34,
 38,  1,  5, 13, 28, 31, 17, 38,
 39, 41, 36, 37, 22, 39, 33, 43,
 43, 15, 17, 49, 30, 21, 22, 20,
 10, 17, 25, 54, 57,  3, 34,  8,
 36, 25, 31, 14, 15, 19, 29, 25,
 18, 39, 53, 22, 27, 20, 29, 33,
 41, 42, 35, 62, 50, 29, 53, 50,
 35, 55, 42, 61, 63,  4,  7, 42,
 21, 46, 47, 49, 27, 46, 17, 55,
 41, 50, 63,  4, 56, 18,  8, 10,
 18, 51, 63, 36, 55, 18,  5, 55,
  9, 29, 17, 21, 30, 27,  1, 59,
  7, 11, 12, 15,  5, 42, 24, 41,
 43,  7, 27, 22, 25, 31, 30, 37,
 22, 39, 53, 29, 36, 37, 48,  0,
  5, 13, 17, 31, 32, 26, 46, 28,
 44, 45, 46, 53, 49, 51,  3, 41,
  3, 22, 42, 33,  5, 45,  7, 22,
 40, 53, 24, 14, 25, 27, 10, 12,
 34, 16, 17, 53, 20, 26, 39, 45,
 18, 45, 35, 33, 31, 49,  4, 39,
 42, 11, 51,  5, 13, 26, 27, 17,
 52, 30,  0, 22, 12, 34, 62, 36,
 38, 41, 47, 30, 63, 38, 41, 43,
 59, 33, 45, 37, 38, 40, 47, 24,
 48, 49, 30,  1, 10, 22, 49, 15,
 39, 59, 31, 32, 33, 18, 13, 15,
 31, 21, 27, 44, 42, 39, 46, 17,
 26, 32, 30, 31,  0, 30, 34,  9,
 12, 13, 25, 31, 32, 55, 43, 35,
 61, 33, 35, 46, 25, 47, 48, 62,
 63, 38, 61,  1,  2,  5,  7,  9,
 46, 10, 34, 35, 36, 55, 51,  7,
 40, 23, 34, 37,  5, 13, 42, 18,
 25, 27, 28,
};

/* motion vector table 1 */
static const uint16_t table1_mv_code[1100] = {
 0x0000, 0x0007, 0x0009, 0x000f, 0x000a, 0x0011, 0x001a, 0x001c,
 0x0011, 0x0031, 0x0025, 0x002d, 0x002f, 0x006f, 0x0075, 0x0041,
 0x004c, 0x004e, 0x005c, 0x0060, 0x0062, 0x0066, 0x0068, 0x0069,
 0x006b, 0x00a6, 0x00c1, 0x00cb, 0x00cc, 0x00ce, 0x00da, 0x00e8,
 0x00ee, 0x0087, 0x0090, 0x009e, 0x009f, 0x00ba, 0x00ca, 0x00d8,
 0x00db, 0x00df, 0x0104, 0x0109, 0x010c, 0x0143, 0x0145, 0x014a,
 0x0156, 0x015c, 0x01b3, 0x01d3, 0x01da, 0x0103, 0x0109, 0x010b,
 0x0122, 0x0127, 0x0134, 0x0161, 0x0164, 0x0176, 0x0184, 0x018d,
 0x018e, 0x018f, 0x0190, 0x0193, 0x0196, 0x019d, 0x019e, 0x019f,
 0x01a9, 0x01b2, 0x01b4, 0x01ba, 0x01bb, 0x01bc, 0x0201, 0x0202,
 0x0205, 0x0207, 0x020d, 0x0210, 0x0211, 0x0215, 0x021b, 0x021f,
 0x0281, 0x0285, 0x0290, 0x029c, 0x029d, 0x02a2, 0x02a7, 0x02a8,
 0x02aa, 0x02b0, 0x02b1, 0x02b4, 0x02bc, 0x02bf, 0x0320, 0x0326,
 0x0327, 0x0329, 0x032a, 0x0336, 0x0360, 0x0362, 0x0363, 0x0372,
 0x03b2, 0x03bc, 0x03bd, 0x0203, 0x0205, 0x021a, 0x0249, 0x024a,
 0x024c, 0x02c7, 0x02ca, 0x02ce, 0x02ef, 0x030d, 0x0322, 0x0325,
 0x0338, 0x0373, 0x037a, 0x0409, 0x0415, 0x0416, 0x0418, 0x0428,
 0x042d, 0x042f, 0x0434, 0x0508, 0x0509, 0x0510, 0x0511, 0x051c,
 0x051e, 0x0524, 0x0541, 0x0543, 0x0546, 0x0547, 0x054d, 0x0557,
 0x055f, 0x056a, 0x056c, 0x056d, 0x056f, 0x0576, 0x0577, 0x057a,
 0x057b, 0x057c, 0x057d, 0x0600, 0x0601, 0x0603, 0x0614, 0x0616,
 0x0617, 0x061c, 0x061f, 0x0642, 0x0648, 0x0649, 0x064a, 0x064b,
 0x0657, 0x0668, 0x0669, 0x066b, 0x066e, 0x067f, 0x06c2, 0x06c8,
 0x06cb, 0x06de, 0x06df, 0x06e2, 0x06e3, 0x06ef, 0x0748, 0x074b,
 0x076e, 0x076f, 0x077c, 0x0409, 0x0423, 0x0428, 0x0429, 0x042a,
 0x042b, 0x0432, 0x0433, 0x0496, 0x049a, 0x04d5, 0x04db, 0x0581,
 0x0582, 0x058b, 0x058c, 0x058d, 0x0598, 0x0599, 0x059a, 0x059e,
 0x05dd, 0x0619, 0x0632, 0x0633, 0x0648, 0x0672, 0x06a1, 0x06a2,
 0x06a3, 0x06af, 0x06e2, 0x06e3, 0x06e4, 0x0800, 0x0801, 0x0802,
 0x0803, 0x081a, 0x081b, 0x0829, 0x082f, 0x0832, 0x083e, 0x083f,
 0x0852, 0x0853, 0x0858, 0x086b, 0x0877, 0x0878, 0x0879, 0x087a,
 0x087b, 0x0a00, 0x0a01, 0x0a0d, 0x0a0e, 0x0a0f, 0x0a24, 0x0a37,
 0x0a3a, 0x0a3b, 0x0a3e, 0x0a46, 0x0a47, 0x0a4a, 0x0a4b, 0x0a5f,
 0x0a79, 0x0a7a, 0x0a7b, 0x0a80, 0x0a81, 0x0a84, 0x0a85, 0x0a99,
 0x0aa5, 0x0aa6, 0x0ab8, 0x0aba, 0x0abb, 0x0abc, 0x0abd, 0x0ac8,
 0x0ace, 0x0acf, 0x0ad7, 0x0adc, 0x0aeb, 0x0c04, 0x0c25, 0x0c26,
 0x0c27, 0x0c2a, 0x0c2b, 0x0c3a, 0x0c3b, 0x0c3c, 0x0c3d, 0x0ca0,
 0x0cad, 0x0cd4, 0x0cd5, 0x0cfc, 0x0cfd, 0x0d86, 0x0d92, 0x0d93,
 0x0d94, 0x0d95, 0x0db0, 0x0db8, 0x0db9, 0x0dba, 0x0dbb, 0x0dc0,
 0x0dc2, 0x0dc3, 0x0dda, 0x0ddb, 0x0ddc, 0x0ddd, 0x0e92, 0x0e93,
 0x0e94, 0x0e95, 0x0ec7, 0x0ecc, 0x0ece, 0x0ecf, 0x0ed8, 0x0ed9,
 0x0eda, 0x0edb, 0x0808, 0x0809, 0x080a, 0x0810, 0x0811, 0x0844,
 0x0845, 0x0861, 0x0862, 0x0863, 0x086c, 0x0922, 0x0923, 0x092e,
 0x092f, 0x0936, 0x0937, 0x09b1, 0x09b2, 0x09b3, 0x09b4, 0x09b5,
 0x09b8, 0x09b9, 0x09ba, 0x09bb, 0x09bc, 0x09bd, 0x09be, 0x09bf,
 0x0b00, 0x0b15, 0x0b2c, 0x0b2d, 0x0b2e, 0x0b2f, 0x0b36, 0x0bb9,
 0x0c28, 0x0c2a, 0x0c2b, 0x0c2c, 0x0c2d, 0x0c2e, 0x0c2f, 0x0c30,
 0x0c31, 0x0c38, 0x0c60, 0x0c61, 0x0c62, 0x0c63, 0x0c8d, 0x0c8e,
 0x0c8f, 0x0c92, 0x0cbe, 0x0cbf, 0x0ce6, 0x0ce7, 0x0d40, 0x0d41,
 0x0d57, 0x0d58, 0x0d59, 0x0d5a, 0x0d5b, 0x0d5c, 0x0d5d, 0x0d98,
 0x0d99, 0x0d9a, 0x0d9b, 0x0d9c, 0x0d9d, 0x0dad, 0x0dae, 0x0daf,
 0x0dc0, 0x0dc1, 0x0dc2, 0x0dc3, 0x0dca, 0x0dcb, 0x0dec, 0x0ded,
 0x0dee, 0x0def, 0x1018, 0x1022, 0x1023, 0x1030, 0x1031, 0x1032,
 0x1033, 0x1050, 0x1051, 0x105c, 0x1074, 0x1075, 0x1076, 0x1077,
 0x1078, 0x1079, 0x107a, 0x107b, 0x10b2, 0x10b3, 0x10b8, 0x10b9,
 0x10ba, 0x10bb, 0x10d4, 0x10ea, 0x10eb, 0x10ec, 0x10ed, 0x1404,
 0x1405, 0x1406, 0x1407, 0x1410, 0x1411, 0x1412, 0x1413, 0x1414,
 0x1415, 0x1416, 0x1417, 0x1418, 0x1419, 0x1466, 0x1467, 0x1468,
 0x1469, 0x146a, 0x146b, 0x146c, 0x146d, 0x147e, 0x147f, 0x1488,
 0x1489, 0x148a, 0x148b, 0x14b6, 0x14b7, 0x14b8, 0x14b9, 0x14ba,
 0x14bb, 0x14bc, 0x14bd, 0x14f0, 0x14f1, 0x14f8, 0x14f9, 0x14fa,
 0x14fb, 0x14fc, 0x14fd, 0x14fe, 0x14ff, 0x152a, 0x152b, 0x152c,
 0x152d, 0x152e, 0x152f, 0x1530, 0x1531, 0x1548, 0x1549, 0x154e,
 0x154f, 0x1558, 0x1559, 0x155a, 0x155b, 0x1572, 0x159a, 0x159b,
 0x15ac, 0x15ba, 0x15bb, 0x15d0, 0x15d1, 0x15d2, 0x15d3, 0x15d4,
 0x15d5, 0x181d, 0x181e, 0x181f, 0x1840, 0x1841, 0x1842, 0x1843,
 0x1844, 0x1845, 0x1846, 0x1847, 0x1848, 0x1849, 0x1861, 0x1862,
 0x1863, 0x1864, 0x1865, 0x1866, 0x1867, 0x1868, 0x1869, 0x186a,
 0x186b, 0x186c, 0x186d, 0x186e, 0x191b, 0x191c, 0x191d, 0x191e,
 0x191f, 0x1942, 0x1943, 0x1944, 0x1945, 0x1946, 0x1947, 0x1958,
 0x1959, 0x19ed, 0x19ee, 0x19ef, 0x19f0, 0x19f1, 0x19f2, 0x19f3,
 0x19f4, 0x19f5, 0x19f6, 0x19f7, 0x1b0e, 0x1b0f, 0x1b62, 0x1b63,
 0x1b64, 0x1b65, 0x1b66, 0x1b67, 0x1b68, 0x1b69, 0x1b6a, 0x1b6b,
 0x1b6c, 0x1b6d, 0x1b6e, 0x1b6f, 0x1b82, 0x1ba8, 0x1ba9, 0x1baa,
 0x1bab, 0x1bac, 0x1bad, 0x1bae, 0x1baf, 0x1bb0, 0x1bb1, 0x1bb2,
 0x1bb3, 0x1d80, 0x1d81, 0x1d82, 0x1d83, 0x1d84, 0x1d85, 0x1d86,
 0x1d87, 0x1d88, 0x1d89, 0x1d8a, 0x1d8b, 0x1d8c, 0x1d8d, 0x1007,
 0x1008, 0x1009, 0x100a, 0x100b, 0x100c, 0x100d, 0x100e, 0x100f,
 0x1016, 0x1080, 0x1081, 0x1082, 0x1083, 0x1084, 0x1085, 0x1086,
 0x1087, 0x10c0, 0x123a, 0x123b, 0x123c, 0x123d, 0x123e, 0x123f,
 0x1240, 0x1241, 0x1242, 0x1243, 0x1350, 0x1352, 0x1353, 0x1358,
 0x1359, 0x135a, 0x135b, 0x135c, 0x135d, 0x135e, 0x135f, 0x1360,
 0x1361, 0x1602, 0x1603, 0x160c, 0x160d, 0x160e, 0x160f, 0x1620,
 0x1621, 0x1622, 0x1623, 0x1624, 0x1625, 0x1626, 0x1627, 0x1628,
 0x1629, 0x166e, 0x166f, 0x167c, 0x167d, 0x167e, 0x167f, 0x1770,
 0x1771, 0x1852, 0x1853, 0x1872, 0x1873, 0x1874, 0x1875, 0x1876,
 0x1877, 0x1878, 0x1879, 0x187a, 0x187b, 0x187c, 0x187d, 0x187e,
 0x187f, 0x1918, 0x1919, 0x1926, 0x1927, 0x1970, 0x1971, 0x1972,
 0x1973, 0x1974, 0x1975, 0x1976, 0x1977, 0x1978, 0x1979, 0x197a,
 0x197b, 0x1aa0, 0x1aa1, 0x1aa2, 0x1aa3, 0x1aa4, 0x1aa5, 0x1aa6,
 0x1aa7, 0x1aa8, 0x1aa9, 0x1aaa, 0x1aab, 0x1aac, 0x1aad, 0x1b3c,
 0x1b3d, 0x1b3e, 0x1b3f, 0x1b50, 0x1b51, 0x1b52, 0x1b53, 0x1b54,
 0x1b55, 0x1b56, 0x1b57, 0x1b58, 0x1b59, 0x2032, 0x2033, 0x2034,
 0x2035, 0x2036, 0x2037, 0x2038, 0x2039, 0x203a, 0x203b, 0x203c,
 0x203d, 0x203e, 0x203f, 0x2040, 0x2041, 0x2042, 0x2043, 0x20ba,
 0x20bb, 0x20cc, 0x20cd, 0x20ce, 0x20cf, 0x20e0, 0x20e1, 0x20e2,
 0x20e3, 0x20e4, 0x20e5, 0x20e6, 0x20e7, 0x21aa, 0x21ab, 0x21c0,
 0x21c1, 0x21c2, 0x21c3, 0x21c4, 0x21c5, 0x21c6, 0x21c7, 0x21c8,
 0x21c9, 0x21ca, 0x21cb, 0x21cc, 0x21cd, 0x21ce, 0x21cf, 0x21d0,
 0x21d1, 0x21d2, 0x21d3, 0x2894, 0x2895, 0x2896, 0x2897, 0x2898,
 0x2899, 0x289a, 0x289b, 0x289c, 0x289d, 0x289e, 0x289f, 0x28c0,
 0x28c1, 0x28c2, 0x28c3, 0x28c4, 0x28c5, 0x28c6, 0x28c7, 0x28c8,
 0x28c9, 0x28ca, 0x28cb, 0x2930, 0x2931, 0x2932, 0x2933, 0x2934,
 0x2935, 0x2936, 0x2937, 0x2938, 0x2939, 0x293a, 0x293b, 0x293c,
 0x293d, 0x293e, 0x293f, 0x2960, 0x2961, 0x2962, 0x2963, 0x2964,
 0x2965, 0x2966, 0x2967, 0x2968, 0x2969, 0x296a, 0x296b, 0x2a40,
 0x2a41, 0x2a42, 0x2a43, 0x2a44, 0x2a45, 0x2a46, 0x2a47, 0x2a48,
 0x2a49, 0x2a4a, 0x2a4b, 0x2a4c, 0x2a4d, 0x2a4e, 0x2a4f, 0x2a50,
 0x2a51, 0x2a52, 0x2a53, 0x2ae6, 0x2ae7, 0x2b24, 0x2b25, 0x2b26,
 0x2b27, 0x2b28, 0x2b29, 0x2b2a, 0x2b2b, 0x2b2c, 0x2b2d, 0x2b2e,
 0x2b2f, 0x2b30, 0x2b31, 0x2b32, 0x2b33, 0x2b5a, 0x2b5b, 0x3014,
 0x3015, 0x3016, 0x3017, 0x3020, 0x3021, 0x3022, 0x3023, 0x3024,
 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0x302a, 0x302b, 0x302c,
 0x302d, 0x302e, 0x302f, 0x3030, 0x3031, 0x3032, 0x3033, 0x3034,
 0x3035, 0x3036, 0x3037, 0x3038, 0x3039, 0x30c0, 0x30c1, 0x30de,
 0x30df, 0x3218, 0x3219, 0x321a, 0x321b, 0x321c, 0x321d, 0x321e,
 0x321f, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226,
 0x3227, 0x3228, 0x3229, 0x322a, 0x322b, 0x322c, 0x322d, 0x322e,
 0x322f, 0x3230, 0x3231, 0x3232, 0x3233, 0x3234, 0x3235, 0x3378,
 0x3379, 0x337a, 0x337b, 0x337c, 0x337d, 0x337e, 0x337f, 0x33c0,
 0x33c1, 0x33c2, 0x33c3, 0x33c4, 0x33c5, 0x33c6, 0x33c7, 0x33c8,
 0x33c9, 0x33ca, 0x33cb, 0x33cc, 0x33cd, 0x33ce, 0x33cf, 0x33d0,
 0x33d1, 0x33d2, 0x33d3, 0x33d4, 0x33d5, 0x33d6, 0x33d7, 0x33d8,
 0x33d9, 0x3706, 0x3707, 0x3730, 0x3731, 0x3732, 0x3733, 0x3734,
 0x3735, 0x3736, 0x3737, 0x3738, 0x3739, 0x373a, 0x373b, 0x373c,
 0x373d, 0x373e, 0x373f, 0x3740, 0x3741, 0x3742, 0x3743, 0x3744,
 0x3745, 0x3746, 0x3747, 0x3748, 0x3749, 0x374a, 0x374b, 0x374c,
 0x374d, 0x374e, 0x374f, 0x3b34, 0x3b35, 0x3b36, 0x3b37, 0x3be8,
 0x3be9, 0x3bea, 0x3beb, 0x3bec, 0x3bed, 0x3bee, 0x3bef, 0x3bf0,
 0x3bf1, 0x3bf2, 0x3bf3, 0x3bf4, 0x3bf5, 0x3bf6, 0x3bf7, 0x3bf8,
 0x3bf9, 0x3bfa, 0x3bfb, 0x3bfc, 0x3bfd, 0x3bfe, 0x3bff, 0x2000,
 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008,
 0x2009, 0x200a, 0x200b, 0x200c, 0x200d, 0x202e, 0x202f, 0x2182,
 0x2183, 0x21b4, 0x21b5, 0x21b6, 0x21b7, 0x21b8, 0x21b9, 0x21ba,
 0x21bb, 0x21bc, 0x21bd, 0x21be, 0x21bf, 0x2460, 0x2461, 0x2462,
 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246a,
 0x246b, 0x246c, 0x246d, 0x246e, 0x246f, 0x2470, 0x2471, 0x2472,
 0x2473, 0x26a2, 0x26a3, 0x000b,
};

static const uint8_t table1_mv_bits[1100] = {
  2,  4,  4,  4,  5,  5,  5,  5,
  6,  6,  7,  7,  7,  7,  7,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15,  4,
};

static const uint8_t table1_mvx[1099] = {
 32, 31, 32, 31, 33, 32, 33, 33,
 31, 34, 30, 32, 32, 34, 35, 32,
 34, 33, 29, 30, 30, 32, 31, 31,
 33, 35, 35, 33, 31, 29, 29, 33,
 34, 30, 31, 28, 36, 30, 34, 32,
 32, 37, 32, 32, 25, 27, 39, 32,
 32, 32, 38, 35, 36, 32, 37, 61,
 26, 32, 34, 35,  3, 35, 27, 28,
 29, 34, 28, 37, 31, 36, 32, 27,
 31, 30, 29, 39, 33, 29, 33, 35,
 25, 25, 29, 33, 31, 31, 31, 33,
 32, 30, 32, 32, 41, 39, 33, 36,
 32, 28, 34, 36, 38, 24, 60, 31,
 23, 28, 32, 33, 59, 32, 40, 30,
  5, 34, 32, 38, 32, 30, 43,  4,
 32, 32, 42, 31, 31, 32, 26, 38,
 26, 22, 21, 37, 61, 63, 37, 31,
 32, 33,  2,  1, 23, 33, 41, 27,
 35, 30, 38, 23, 33,  3, 28, 34,
 34, 27, 41, 29, 39, 35, 36, 29,
 32, 27, 30, 32, 24, 61, 37, 26,
 59, 25, 35, 27, 36, 37, 30, 31,
 34, 40,  3, 28, 34, 39, 32, 31,
 32, 30, 24, 28, 35, 36, 26, 32,
 31, 33, 29, 33, 39, 25, 30, 24,
 35, 59, 29, 34, 25, 30, 21, 35,
 43, 40, 32, 29,  5, 28, 31, 62,
 33, 33, 25, 31, 21, 31, 43, 31,
 34, 33, 20, 40, 39, 31, 31, 57,
 38, 32, 42, 33, 32, 31, 32, 29,
 30, 44,  5, 31, 22, 34, 36, 17,
 38, 58, 38, 35, 32, 60, 35, 24,
 32, 38, 16, 45, 42, 32, 31, 29,
  4, 30, 17, 40, 46, 48, 63, 32,
 42, 19, 41, 22, 28, 36, 45, 33,
 33, 32, 29,  7, 41, 42, 18, 33,
 33, 32, 22, 37,  1, 26, 22, 23,
 49, 28, 26, 27, 32, 33, 27, 23,
 28, 36, 15,  6, 34, 27, 31, 26,
 23,  2, 33, 32, 34, 41, 28, 32,
 41,  0, 36, 38, 34, 31, 47, 32,
 17, 31, 39, 33, 37, 51, 30, 47,
 32, 50, 32, 19, 63, 30, 25, 27,
 33, 62, 24, 31, 27, 30, 37, 31,
 45, 32, 39, 20, 46, 47, 35, 19,
 34,  1, 49, 21, 21, 14, 51, 26,
 23, 31, 36, 35, 58, 29, 29, 21,
 20, 42, 13, 28, 12, 40, 31, 33,
 39, 60, 32, 44, 33, 31, 28, 37,
 29, 32, 30, 49, 43, 28, 39, 25,
 32, 48,  2, 15, 20, 25, 31, 28,
 21, 24, 25, 15, 31, 17, 37, 43,
 18, 32, 33, 24, 33, 36, 13, 33,
 31, 39, 11, 31, 33, 32, 39, 37,
 32, 32, 29, 17, 44, 46, 36, 35,
 26, 37, 58, 32, 34, 38,  8, 38,
 38, 22, 29, 25, 16, 35, 32, 35,
 33, 43, 18, 46, 38, 50, 33, 18,
 53, 60, 13, 32, 36, 33, 51, 36,
 43, 45, 27, 42, 29, 24, 30, 25,
 31, 52, 31, 35, 38,  9, 22, 34,
  4, 17, 28, 55, 42, 25, 17, 20,
 47, 34, 33, 16, 40, 25, 16, 30,
 53, 29, 10, 11, 14, 26, 33,  4,
 35, 44, 26, 16, 31, 26, 34, 38,
 29, 31, 30, 24, 22, 61, 32,  9,
 45, 34, 31, 19,  9, 31, 46, 31,
 35, 54, 29, 57, 30, 50,  3, 31,
 63, 34, 47, 41, 51, 18, 31, 14,
 37, 38, 31, 24, 32, 31, 50, 33,
 31, 54, 27,  9, 33, 23, 19, 32,
 29, 29, 33, 28, 47, 49, 30, 47,
 33, 27, 25, 54, 44, 45, 50, 58,
 51, 48, 33, 59, 33, 34, 57, 13,
 26, 33, 13, 48, 30, 11,  7, 56,
 34, 55, 26,  0, 26, 35,  1, 51,
 33, 53, 31, 45, 12, 29, 29, 51,
 31, 48,  2,  6, 34, 30, 28, 33,
 60, 40, 27, 46, 31,  9, 35, 29,
 31, 39, 55, 46, 19, 37, 62, 34,
 30, 16, 19, 49, 41, 41, 39, 37,
 14,  5, 13, 35, 55, 30, 40, 40,
 42,  8, 20, 25, 45, 35, 33, 36,
 54, 38, 27, 37, 62, 40, 15, 59,
 49, 31, 29, 34, 34, 39, 24, 29,
 25, 29, 21, 29, 10, 61, 33, 49,
 35, 34,  3, 38, 39, 29,  7, 41,
  1, 35,  4, 23, 15, 23, 11, 37,
 28, 35, 30, 30, 24,  1, 43, 56,
  8, 34, 42, 24, 45, 30, 20, 23,
  8, 38, 22, 33, 17, 52, 34, 22,
 53, 43, 44,  1, 27, 31, 41, 43,
 41, 30, 31, 36, 30,  5, 55, 31,
 33, 30, 40, 23, 15, 29, 34, 34,
 59, 34, 30, 11, 13, 38,  5,  0,
 30, 42,  5, 30, 29, 34, 10, 44,
 30, 63, 35, 12,  3, 26, 15, 17,
 25, 34, 43, 39, 34, 56, 29, 23,
 30, 12, 30, 10, 35,  9, 24, 58,
 10, 12, 54, 33, 37, 20, 41, 35,
 29, 18, 61, 30, 40, 24, 39, 53,
 62, 26, 29, 33, 34, 53, 49, 21,
 27, 11, 63, 20, 26, 23,  7, 13,
  6, 47, 29, 30,  9, 51, 22, 34,
 21, 25, 33, 56, 57, 30, 38, 51,
 51, 38, 63, 28, 40, 35, 33, 18,
 33, 33, 24, 58, 58, 34, 49, 29,
 43,  4,  1,  4, 42, 35, 35, 30,
 17,  5, 56, 61, 25, 37, 36, 55,
 28, 35, 29, 50, 48, 52,  2, 42,
 34, 40, 46, 46, 43, 35, 29, 48,
 20, 29, 31, 41,  7, 30, 35, 19,
 14, 21,  8, 39, 39, 40, 46, 55,
 34,  6, 30, 34, 37, 25, 37, 33,
 22, 44, 52, 17, 35, 29, 36, 35,
 40, 37, 28, 30, 50, 14, 28, 55,
  6, 23, 19, 14, 30,  3, 30, 28,
 28, 61, 61, 47, 45, 48, 40, 40,
 34, 34, 25, 30, 29, 35,  4, 26,
 53, 50, 26, 41, 27, 59, 27, 38,
 39,  3, 50, 43, 47, 23, 33, 55,
 35, 21, 23, 35, 61, 33, 46, 52,
 35, 34, 24, 30, 43, 16, 37, 21,
  2, 24, 45, 34, 30, 55, 55,  1,
 29, 29, 26, 28, 25, 31, 36, 22,
 17, 30, 52,  2, 44, 44, 57, 26,
 62, 41, 39, 57, 26, 46, 49, 11,
 16, 19,  5, 59, 38, 39, 58, 38,
 25, 49, 50, 22, 28, 59,  9, 59,
  7, 28, 55, 17,  4, 35, 50, 21,
 29, 44, 47, 18, 24, 19, 25, 42,
 35,  3, 51, 35, 16, 35, 30, 63,
 57, 39, 39, 25, 35, 38,  9, 16,
 36, 45, 31, 60, 14, 34, 42, 24,
  0, 37, 18, 61, 57, 37, 28, 53,
 20, 46, 14, 47, 38, 38, 38,  9,
 34, 39, 43, 17, 39, 59,  5, 27,
  0, 12, 27,
};

static const uint8_t table1_mvy[1099] = {
 32, 32, 31, 31, 32, 33, 31, 33,
 33, 32, 32, 30, 34, 31, 32, 29,
 33, 30, 32, 33, 31, 35, 34, 30,
 34, 31, 33, 29, 29, 31, 33, 35,
 30, 30, 35, 32, 32, 34, 34, 28,
 25, 32, 36, 27, 32, 32, 32, 37,
 39,  3, 32, 30, 31, 26, 31, 32,
 32, 38, 29, 29, 32, 34, 31, 31,
 34, 35, 33, 33, 28, 33,  1, 33,
 27, 29, 30, 31, 28, 29, 37, 35,
 31, 33, 35, 27, 36, 37, 25, 25,
 61, 35,  4,  5, 32, 33, 36, 30,
 23, 30, 28, 34, 31, 32, 32, 39,
 32, 34, 21, 39, 32, 59, 32, 28,
 32, 36, 60, 33, 24, 36, 32, 32,
 41,  2, 32, 38, 26, 22, 33, 30,
 31, 32, 32, 30, 31, 32, 29,  3,
 40, 38, 32, 32, 33, 26, 31, 34,
 28, 38, 34, 31,  3, 31, 35, 38,
 27, 35, 33, 28, 29, 27, 29, 27,
 43, 29, 37, 63, 31, 33, 34, 30,
 31, 30, 37, 30, 35, 35, 26, 41,
 37, 31, 33, 28, 26, 30, 42, 24,
  7, 27, 33, 29, 36, 28, 34, 57,
 23, 41, 36, 23, 35, 34, 25, 30,
 25, 33, 25, 25, 29, 24, 33, 39,
 33, 33,  0, 37, 31, 36, 21, 32,
 61, 24, 35, 61, 31,  5, 31, 59,
 39, 21, 32, 30, 34, 22, 40, 32,
 29, 16, 31,  5, 62,  2, 20, 39,
 39, 32, 33,  1, 31, 24, 36, 32,
 36, 32, 28, 26,  6, 31, 38, 34,
 58, 35, 32, 33, 33, 17, 43, 26,
 31, 40, 31, 34, 32, 32, 31, 19,
 30, 32, 29, 33, 38, 38, 32, 59,
 40, 18, 38, 32, 35, 34, 32, 17,
  1, 15, 30, 28, 31, 28, 34, 29,
 32, 27, 35, 27, 49, 22, 37, 34,
 37, 26, 32, 32, 22, 28, 45, 29,
 30, 31, 43, 46, 41, 30, 26, 13,
 34, 32, 27, 38, 42, 42, 33, 47,
 33, 60, 27, 42, 25, 32, 22, 32,
 48, 32, 45, 33, 33, 41, 27, 25,
 19, 31, 35, 19, 36, 42, 27, 17,
 31, 44, 28, 33, 33, 31, 23, 31,
 40, 33, 31, 34, 30, 32, 33, 36,
 35, 47, 37, 41, 31, 23, 41, 29,
 30, 35, 32, 25, 32, 28, 58,  2,
 37, 33, 14, 33, 49, 20, 39, 36,
 21,  9, 23, 33, 35, 24, 39, 37,
 11, 33, 30, 31, 31, 28, 51, 40,
 35, 29, 25, 33, 46, 35, 37, 30,
 30,  8, 63, 28, 15, 40, 33, 45,
 49, 25, 32,  4, 47, 51, 36, 39,
 53, 10, 24, 29, 30, 31, 25, 40,
 38, 38, 33, 56, 23, 27, 32, 37,
 26, 29, 43, 36, 33, 24, 55, 43,
  9, 29, 34, 34, 24, 33, 18, 33,
 33, 30, 31, 50, 24, 60, 30, 39,
 34, 30, 39, 28, 22, 38,  2, 26,
 63, 32, 57, 21, 39, 33, 28, 18,
 30, 34, 22, 33, 29, 41, 30, 34,
 35, 21, 13, 34, 35, 39, 30, 46,
 32, 42, 32, 31, 33, 26, 11, 33,
 22, 31, 25, 31, 53, 27, 43, 25,
 40, 50, 21, 36, 38, 30, 12, 31,
 34, 20, 15, 29, 32, 62, 30, 13,
 17, 32, 19, 31, 20, 31, 30,  7,
  1, 17, 34, 37, 31, 31, 44, 34,
 26, 40, 16, 37, 52, 48, 30, 20,
 18, 33, 38, 29,  7, 25, 30, 54,
 45, 47, 46, 41, 29, 29, 16, 30,
 14, 26, 38, 34, 34, 29, 34, 30,
 29, 30, 57, 30,  4, 46, 33, 29,
 39, 44, 30, 31, 50, 33, 31, 32,
 19, 32, 40, 31, 37, 47,  1, 35,
 16, 31,  0, 35, 33,  1, 17, 34,
  9, 34, 33, 31, 49, 43, 42, 51,
 34, 29, 23, 29, 14, 30, 45, 49,
 11, 24, 31, 28, 35, 41, 30, 44,
 18, 29, 34, 35, 36, 25, 26, 21,
 31, 30, 34, 19, 34, 44, 36, 38,
 25, 31, 28, 23, 37,  3, 55, 41,
 30, 22, 41, 24, 33, 26, 35, 35,
 30, 55, 51, 47, 48, 38, 24, 15,
 21, 50, 25, 46, 30, 29, 10, 34,
 42, 45, 29, 42, 22,  3, 33, 27,
 34,  1, 34, 28, 34, 36, 35, 23,
 23, 13, 58,  3, 26, 63, 25, 31,
 34, 61, 38, 39, 25, 61, 29, 37,
 30, 41, 26, 48, 28, 33, 50, 35,
 30, 37, 29, 29, 40,  6, 39, 28,
 28, 19,  8, 22, 45, 34, 35, 10,
 58, 17, 37, 39, 30, 18, 54, 14,
 29, 16, 59, 30, 35, 23, 35, 30,
 47, 36, 29, 55, 20, 12, 31, 35,
 14, 29, 18, 34, 34, 24, 29, 26,
 22,  2, 27, 23,  8, 30, 55, 38,
 60, 31,  4, 34, 49, 34, 27, 34,
 33, 30, 31, 54, 42, 35, 38, 46,
 44, 26, 27,  9, 39, 25, 21, 29,
 28, 42, 13,  0,  5, 34, 37, 28,
 24, 29, 63, 26, 22, 27, 29, 25,
 33, 25, 61,  0, 35, 25, 36, 15,
 27, 40, 53, 33,  3, 10, 16, 37,
 38, 18, 30, 46, 27,  9,  6, 29,
 62,  8, 42, 28, 29,  3, 25, 16,
 26, 29, 35, 28, 27, 51, 61, 48,
 37,  9, 34,  7, 49, 45, 20, 29,
 21,  5,  5, 29, 28, 34, 29, 24,
 10, 24, 35, 36, 38, 55, 11, 36,
 38, 53, 54, 26, 30, 49, 20, 27,
 30, 39, 33, 41, 49, 22, 38, 38,
  4, 30,  8,  9,  3, 24, 22, 50,
 37, 36, 31, 27,  2,  9, 42, 63,
 25, 19, 44,  1, 28, 28, 48, 30,
 34, 41, 41, 38, 12, 27, 15,  0,
 16, 34, 35, 38, 28, 29, 40, 42,
 51, 52, 45, 54, 59, 59, 42, 44,
 37, 26, 46, 24, 15, 39, 22, 46,
 19, 35, 38, 17, 37, 23, 52, 55,
 50, 37, 26, 11, 37, 12, 24, 30,
 16, 13, 22, 13, 36, 35, 40, 41,
 34, 41, 26, 53, 51,  5, 21, 30,
  2, 63, 41, 20,  1, 56, 21, 24,
 25,  5, 28, 35, 26, 28, 30, 18,
 29, 23, 40, 34, 20, 42, 39, 34,
 28, 61, 38, 27, 62,  9, 36, 17,
  9, 49, 24, 25, 54, 34, 39, 37,
  3,  1, 25, 38, 38, 44, 35, 36,
 12, 60, 36, 38, 40, 25, 43, 39,
 53, 28, 39, 57, 46, 10, 52, 27,
 35, 42, 45, 59, 15, 60, 38, 24,
 23, 39, 12, 29, 24,  0, 20, 16,
 28, 43, 35, 28,  1, 49,  4, 21,
 42, 39, 29,  3, 44, 21, 53, 55,
 11,  5,  3, 39, 53, 28, 25, 19,
 34, 28, 21,
};

MVTable mv_tables[2] = {
    {
        1099,
        table0_mv_code,
        table0_mv_bits,
        table0_mvx,
        table0_mvy,
    },
    {
        1099,
        table1_mv_code,
        table1_mv_bits,
        table1_mvx,
        table1_mvy,
    }
};

const uint8_t v2_mb_type[8][2] = {
 {1, 1}, {0   , 2}, {3   , 3}, {9   , 5},
 {5, 4}, {0x21, 7}, {0x20, 7}, {0x11, 6},
};

const uint8_t v2_intra_cbpc[4][2] = {
 {1, 1}, {0, 3}, {1, 3}, {1, 2},
};

const uint8_t wmv1_y_dc_scale_table[32]={
//  0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
    0, 8, 8, 8, 8, 8, 9, 9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21
};
const uint8_t wmv1_c_dc_scale_table[32]={
//  0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
    0, 8, 8, 8, 8, 9, 9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22
};

const uint8_t old_ff_y_dc_scale_table[32]={
//  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31
    0, 8, 8, 8, 8,10,12,14,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39
};

const uint8_t wmv1_scantable[WMV1_SCANTABLE_COUNT][64]={
  {
    0x00, 0x08, 0x01, 0x02, 0x09, 0x10, 0x18, 0x11,
    0x0A, 0x03, 0x04, 0x0B, 0x12, 0x19, 0x20, 0x28,
    0x30, 0x38, 0x29, 0x21, 0x1A, 0x13, 0x0C, 0x05,
    0x06, 0x0D, 0x14, 0x1B, 0x22, 0x31, 0x39, 0x3A,
    0x32, 0x2A, 0x23, 0x1C, 0x15, 0x0E, 0x07, 0x0F,
    0x16, 0x1D, 0x24, 0x2B, 0x33, 0x3B, 0x3C, 0x34,
    0x2C, 0x25, 0x1E, 0x17, 0x1F, 0x26, 0x2D, 0x35,
    0x3D, 0x3E, 0x36, 0x2E, 0x27, 0x2F, 0x37, 0x3F,
  },
  {
    0x00, 0x08, 0x01, 0x02, 0x09, 0x10, 0x18, 0x11,
    0x0A, 0x03, 0x04, 0x0B, 0x12, 0x19, 0x20, 0x28,
    0x21, 0x30, 0x1A, 0x13, 0x0C, 0x05, 0x06, 0x0D,
    0x14, 0x1B, 0x22, 0x29, 0x38, 0x31, 0x39, 0x2A,
    0x23, 0x1C, 0x15, 0x0E, 0x07, 0x0F, 0x16, 0x1D,
    0x24, 0x2B, 0x32, 0x3A, 0x33, 0x3B, 0x2C, 0x25,
    0x1E, 0x17, 0x1F, 0x26, 0x2D, 0x34, 0x3C, 0x35,
    0x3D, 0x2E, 0x27, 0x2F, 0x36, 0x3E, 0x37, 0x3F,
  },
  {
    0x00, 0x01, 0x08, 0x02, 0x03, 0x09, 0x10, 0x18,
    0x11, 0x0A, 0x04, 0x05, 0x0B, 0x12, 0x19, 0x20,
    0x28, 0x30, 0x21, 0x1A, 0x13, 0x0C, 0x06, 0x07,
    0x0D, 0x14, 0x1B, 0x22, 0x29, 0x38, 0x31, 0x39,
    0x2A, 0x23, 0x1C, 0x15, 0x0E, 0x0F, 0x16, 0x1D,
    0x24, 0x2B, 0x32, 0x3A, 0x33, 0x2C, 0x25, 0x1E,
    0x17, 0x1F, 0x26, 0x2D, 0x34, 0x3B, 0x3C, 0x35,
    0x2E, 0x27, 0x2F, 0x36, 0x3D, 0x3E, 0x37, 0x3F,
  },
  {
    0x00, 0x08, 0x10, 0x01, 0x18, 0x20, 0x28, 0x09,
    0x02, 0x03, 0x0A, 0x11, 0x19, 0x30, 0x38, 0x29,
    0x21, 0x1A, 0x12, 0x0B, 0x04, 0x05, 0x0C, 0x13,
    0x1B, 0x22, 0x31, 0x39, 0x32, 0x2A, 0x23, 0x1C,
    0x14, 0x0D, 0x06, 0x07, 0x0E, 0x15, 0x1D, 0x24,
    0x2B, 0x33, 0x3A, 0x3B, 0x34, 0x2C, 0x25, 0x1E,
    0x16, 0x0F, 0x17, 0x1F, 0x26, 0x2D, 0x3C, 0x35,
    0x2E, 0x27, 0x2F, 0x36, 0x3D, 0x3E, 0x37, 0x3F,
  }
};

const uint8_t table_inter_intra[4][2]={
    {0,1} /*Luma-Left Chroma-Left*/,
    {2,2} /*Luma-Top  Chroma-Left*/,
    {6,3} /*luma-Left Chroma-Top */,
    {7,3} /*luma-Top  Chroma-Top */
};

static const uint32_t table_mb_non_intra2[128][2] = {
{0x0000A7, 14}, {0x01B2B8, 18}, {0x01B28E, 18}, {0x036575, 19},
{0x006CAC, 16}, {0x000A69, 18}, {0x002934, 20}, {0x00526B, 21},
{0x006CA1, 16}, {0x01B2B9, 18}, {0x0029AD, 20}, {0x029353, 24},
{0x006CA7, 16}, {0x006CAB, 16}, {0x01B2BB, 18}, {0x00029B, 16},
{0x00D944, 17}, {0x000A6A, 18}, {0x0149A8, 23}, {0x03651F, 19},
{0x006CAF, 16}, {0x000A4C, 18}, {0x03651E, 19}, {0x000A48, 18},
{0x00299C, 20}, {0x00299F, 20}, {0x029352, 24}, {0x0029AC, 20},
{0x000296, 16}, {0x00D946, 17}, {0x000A68, 18}, {0x000298, 16},
{0x000527, 17}, {0x00D94D, 17}, {0x0014D7, 19}, {0x036574, 19},
{0x000A5C, 18}, {0x01B299, 18}, {0x00299D, 20}, {0x00299E, 20},
{0x000525, 17}, {0x000A66, 18}, {0x00A4D5, 22}, {0x00149B, 19},
{0x000295, 16}, {0x006CAD, 16}, {0x000A49, 18}, {0x000521, 17},
{0x006CAA, 16}, {0x00D945, 17}, {0x01B298, 18}, {0x00052F, 17},
{0x003654, 15}, {0x006CA0, 16}, {0x000532, 17}, {0x000291, 16},
{0x003652, 15}, {0x000520, 17}, {0x000A5D, 18}, {0x000294, 16},
{0x00009B, 11}, {0x0006E2, 12}, {0x000028, 12}, {0x0001B0, 10},
{0x000001,  3}, {0x000010,  8}, {0x00002F,  6}, {0x00004C, 10},
{0x00000D,  4}, {0x000000, 10}, {0x000006,  9}, {0x000134, 12},
{0x00000C,  4}, {0x000007, 10}, {0x000007,  9}, {0x0006E1, 12},
{0x00000E,  5}, {0x0000DA,  9}, {0x000022,  9}, {0x000364, 11},
{0x00000F,  4}, {0x000006, 10}, {0x00000F,  9}, {0x000135, 12},
{0x000014,  5}, {0x0000DD,  9}, {0x000004,  9}, {0x000015, 11},
{0x00001A,  6}, {0x0001B3, 10}, {0x000005, 10}, {0x0006E3, 12},
{0x00000C,  5}, {0x0000B9,  8}, {0x000004,  8}, {0x0000DB,  9},
{0x00000E,  4}, {0x00000B, 10}, {0x000023,  9}, {0x0006CB, 12},
{0x000005,  6}, {0x0001B1, 10}, {0x000001, 10}, {0x0006E0, 12},
{0x000011,  5}, {0x0000DF,  9}, {0x00000E,  9}, {0x000373, 11},
{0x000003,  5}, {0x0000B8,  8}, {0x000006,  8}, {0x000175,  9},
{0x000015,  5}, {0x000174,  9}, {0x000027,  9}, {0x000372, 11},
{0x000010,  5}, {0x0000BB,  8}, {0x000005,  8}, {0x0000DE,  9},
{0x00000F,  5}, {0x000001,  9}, {0x000012,  8}, {0x000004, 10},
{0x000002,  3}, {0x000016,  5}, {0x000009,  4}, {0x000001,  5},
};

static const uint32_t table_mb_non_intra3[128][2] = {
{0x0002A1, 10}, {0x005740, 15}, {0x01A0BF, 18}, {0x015D19, 17},
{0x001514, 13}, {0x00461E, 15}, {0x015176, 17}, {0x015177, 17},
{0x0011AD, 13}, {0x00682E, 16}, {0x0682F9, 20}, {0x03417D, 19},
{0x001A36, 14}, {0x002A2D, 14}, {0x00D05E, 17}, {0x006824, 16},
{0x001515, 13}, {0x00545C, 15}, {0x0230E9, 18}, {0x011AFA, 17},
{0x0015D7, 13}, {0x005747, 15}, {0x008D79, 16}, {0x006825, 16},
{0x002BA2, 14}, {0x00A8BA, 16}, {0x0235F6, 18}, {0x015D18, 17},
{0x0011AE, 13}, {0x00346F, 15}, {0x008C3B, 16}, {0x00346E, 15},
{0x000D1A, 13}, {0x00461F, 15}, {0x0682F8, 20}, {0x011875, 17},
{0x002BA1, 14}, {0x008D61, 16}, {0x0235F7, 18}, {0x0230E8, 18},
{0x001513, 13}, {0x008D7B, 16}, {0x011AF4, 17}, {0x011AF5, 17},
{0x001185, 13}, {0x0046BF, 15}, {0x008D60, 16}, {0x008D7C, 16},
{0x001512, 13}, {0x00461C, 15}, {0x00AE8D, 16}, {0x008D78, 16},
{0x000D0E, 13}, {0x003413, 15}, {0x0046B1, 15}, {0x003416, 15},
{0x000AEA, 12}, {0x002A2C, 14}, {0x005741, 15}, {0x002A2F, 14},
{0x000158,  9}, {0x0008D2, 12}, {0x00054C, 11}, {0x000686, 12},
{0x000000,  2}, {0x000069,  8}, {0x00006B,  8}, {0x00068C, 12},
{0x000007,  3}, {0x00015E,  9}, {0x0002A3, 10}, {0x000AE9, 12},
{0x000006,  3}, {0x000231, 10}, {0x0002B8, 10}, {0x001A08, 14},
{0x000010,  5}, {0x0001A9, 10}, {0x000342, 11}, {0x000A88, 12},
{0x000004,  4}, {0x0001A2, 10}, {0x0002A4, 10}, {0x001184, 13},
{0x000012,  5}, {0x000232, 10}, {0x0002B2, 10}, {0x000680, 12},
{0x00001B,  6}, {0x00046A, 11}, {0x00068E, 12}, {0x002359, 14},
{0x000016,  5}, {0x00015F,  9}, {0x0002A0, 10}, {0x00054D, 11},
{0x000005,  4}, {0x000233, 10}, {0x0002B9, 10}, {0x0015D6, 13},
{0x000022,  6}, {0x000468, 11}, {0x000683, 12}, {0x001A0A, 14},
{0x000013,  5}, {0x000236, 10}, {0x0002BB, 10}, {0x001186, 13},
{0x000017,  5}, {0x0001AB, 10}, {0x0002A7, 10}, {0x0008D3, 12},
{0x000014,  5}, {0x000237, 10}, {0x000460, 11}, {0x000D0F, 13},
{0x000019,  6}, {0x0001AA, 10}, {0x0002B3, 10}, {0x000681, 12},
{0x000018,  6}, {0x0001A8, 10}, {0x0002A5, 10}, {0x00068F, 12},
{0x000007,  4}, {0x000055,  7}, {0x000047,  7}, {0x0000AD,  8},
};

static const uint32_t table_mb_non_intra4[128][2] = {
{0x0000D4,  8}, {0x0021C5, 14}, {0x00F18A, 16}, {0x00D5BC, 16},
{0x000879, 12}, {0x00354D, 14}, {0x010E3F, 17}, {0x010F54, 17},
{0x000866, 12}, {0x00356E, 14}, {0x010F55, 17}, {0x010E3E, 17},
{0x0010CE, 13}, {0x003C84, 14}, {0x00D5BD, 16}, {0x00F18B, 16},
{0x000868, 12}, {0x00438C, 15}, {0x0087AB, 16}, {0x00790B, 15},
{0x000F10, 12}, {0x00433D, 15}, {0x006AD3, 15}, {0x00790A, 15},
{0x001AA7, 13}, {0x0043D4, 15}, {0x00871E, 16}, {0x006ADF, 15},
{0x000D7C, 12}, {0x003C94, 14}, {0x00438D, 15}, {0x006AD2, 15},
{0x0006BC, 11}, {0x0021E9, 14}, {0x006ADA, 15}, {0x006A99, 15},
{0x0010F7, 13}, {0x004389, 15}, {0x006ADB, 15}, {0x0078C4, 15},
{0x000D56, 12}, {0x0035F7, 14}, {0x00438E, 15}, {0x006A98, 15},
{0x000D52, 12}, {0x003C95, 14}, {0x004388, 15}, {0x00433C, 15},
{0x000D54, 12}, {0x001E4B, 13}, {0x003C63, 14}, {0x003C83, 14},
{0x000861, 12}, {0x0021EB, 14}, {0x00356C, 14}, {0x0035F6, 14},
{0x000863, 12}, {0x00219F, 14}, {0x003568, 14}, {0x003C82, 14},
{0x0001AE,  9}, {0x0010C0, 13}, {0x000F11, 12}, {0x001AFA, 13},
{0x000000,  1}, {0x0000F0,  8}, {0x0001AD,  9}, {0x0010C1, 13},
{0x00000A,  4}, {0x0003C5, 10}, {0x000789, 11}, {0x001AB5, 13},
{0x000009,  4}, {0x000435, 11}, {0x000793, 11}, {0x001E40, 13},
{0x00001D,  5}, {0x0003CB, 10}, {0x000878, 12}, {0x001AAF, 13},
{0x00000B,  4}, {0x0003C7, 10}, {0x000791, 11}, {0x001AAB, 13},
{0x00001F,  5}, {0x000436, 11}, {0x0006BF, 11}, {0x000F19, 12},
{0x00003D,  6}, {0x000D51, 12}, {0x0010C4, 13}, {0x0021E8, 14},
{0x000036,  6}, {0x000437, 11}, {0x0006AF, 11}, {0x0010C5, 13},
{0x00000C,  4}, {0x000432, 11}, {0x000794, 11}, {0x001E30, 13},
{0x000042,  7}, {0x000870, 12}, {0x000F24, 12}, {0x001E43, 13},
{0x000020,  6}, {0x00043E, 11}, {0x000795, 11}, {0x001AAA, 13},
{0x000037,  6}, {0x0006AC, 11}, {0x0006AE, 11}, {0x0010F6, 13},
{0x000034,  6}, {0x00043A, 11}, {0x000D50, 12}, {0x001AAE, 13},
{0x000039,  6}, {0x00043F, 11}, {0x00078D, 11}, {0x0010D2, 13},
{0x000038,  6}, {0x00043B, 11}, {0x0006BD, 11}, {0x0010D3, 13},
{0x000011,  5}, {0x0001AC,  9}, {0x0000F3,  8}, {0x000439, 11},
};

const uint32_t (* const wmv2_inter_table[WMV2_INTER_CBP_TABLE_COUNT])[2]={
    table_mb_non_intra2,
    table_mb_non_intra3,
    table_mb_non_intra4,
    table_mb_non_intra,
};

const uint8_t wmv2_scantableA[64]={
0x00, 0x01, 0x02, 0x08, 0x03, 0x09, 0x0A, 0x10,
0x04, 0x0B, 0x11, 0x18, 0x12, 0x0C, 0x05, 0x13,
0x19, 0x0D, 0x14, 0x1A, 0x1B, 0x06, 0x15, 0x1C,
0x0E, 0x16, 0x1D, 0x07, 0x1E, 0x0F, 0x17, 0x1F,
};

const uint8_t wmv2_scantableB[64]={
0x00, 0x08, 0x01, 0x10, 0x09, 0x18, 0x11, 0x02,
0x20, 0x0A, 0x19, 0x28, 0x12, 0x30, 0x21, 0x1A,
0x38, 0x29, 0x22, 0x03, 0x31, 0x39, 0x0B, 0x2A,
0x13, 0x32, 0x1B, 0x3A, 0x23, 0x2B, 0x33, 0x3B,
};
