/*
 * AAC data
 * Copyright (c) 2005-2006 Oded Shimon ( ods15 ods15 dyndns org )
 * Copyright (c) 2006-2007 Maxim Gavrilov ( maxim.gavrilov gmail com )
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file aactab.c
 * AAC data
 * @author Oded Shimon  ( ods15 ods15 dyndns org )
 * @author Maxim Gavrilov ( maxim.gavrilov gmail com )
 */

#include "libavutil/mem.h"
#include "aac.h"

#include <stdint.h>

const uint8_t ff_aac_num_swb_1024[] = {
    41, 41, 47, 49, 49, 51, 47, 47, 43, 43, 43, 40
};

const uint8_t ff_aac_num_swb_128[] = {
    12, 12, 12, 14, 14, 14, 15, 15, 15, 15, 15, 15
};

const uint32_t ff_aac_scalefactor_code[121] = {
    0x3ffe8, 0x3ffe6, 0x3ffe7, 0x3ffe5, 0x7fff5, 0x7fff1, 0x7ffed, 0x7fff6,
    0x7ffee, 0x7ffef, 0x7fff0, 0x7fffc, 0x7fffd, 0x7ffff, 0x7fffe, 0x7fff7,
    0x7fff8, 0x7fffb, 0x7fff9, 0x3ffe4, 0x7fffa, 0x3ffe3, 0x1ffef, 0x1fff0,
    0x0fff5, 0x1ffee, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff1, 0x07ff6, 0x07ff7,
    0x03ff9, 0x03ff5, 0x03ff7, 0x03ff3, 0x03ff6, 0x03ff2, 0x01ff7, 0x01ff5,
    0x00ff9, 0x00ff7, 0x00ff6, 0x007f9, 0x00ff4, 0x007f8, 0x003f9, 0x003f7,
    0x003f5, 0x001f8, 0x001f7, 0x000fa, 0x000f8, 0x000f6, 0x00079, 0x0003a,
    0x00038, 0x0001a, 0x0000b, 0x00004, 0x00000, 0x0000a, 0x0000c, 0x0001b,
    0x00039, 0x0003b, 0x00078, 0x0007a, 0x000f7, 0x000f9, 0x001f6, 0x001f9,
    0x003f4, 0x003f6, 0x003f8, 0x007f5, 0x007f4, 0x007f6, 0x007f7, 0x00ff5,
    0x00ff8, 0x01ff4, 0x01ff6, 0x01ff8, 0x03ff8, 0x03ff4, 0x0fff0, 0x07ff4,
    0x0fff6, 0x07ff5, 0x3ffe2, 0x7ffd9, 0x7ffda, 0x7ffdb, 0x7ffdc, 0x7ffdd,
    0x7ffde, 0x7ffd8, 0x7ffd2, 0x7ffd3, 0x7ffd4, 0x7ffd5, 0x7ffd6, 0x7fff2,
    0x7ffdf, 0x7ffe7, 0x7ffe8, 0x7ffe9, 0x7ffea, 0x7ffeb, 0x7ffe6, 0x7ffe0,
    0x7ffe1, 0x7ffe2, 0x7ffe3, 0x7ffe4, 0x7ffe5, 0x7ffd7, 0x7ffec, 0x7fff4,
    0x7fff3,
};

const uint8_t ff_aac_scalefactor_bits[121] = {
    18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 18, 19, 18, 17, 17, 16, 17, 16, 16, 16, 16, 15, 15,
    14, 14, 14, 14, 14, 14, 13, 13, 12, 12, 12, 11, 12, 11, 10, 10,
    10,  9,  9,  8,  8,  8,  7,  6,  6,  5,  4,  3,  1,  4,  4,  5,
     6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 10, 11, 11, 11, 11, 12,
    12, 13, 13, 13, 14, 14, 16, 15, 16, 15, 18, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19,
};

static const uint16_t codes1[81] = {
    0x7f8, 0x1f1, 0x7fd, 0x3f5, 0x068, 0x3f0, 0x7f7, 0x1ec,
    0x7f5, 0x3f1, 0x072, 0x3f4, 0x074, 0x011, 0x076, 0x1eb,
    0x06c, 0x3f6, 0x7fc, 0x1e1, 0x7f1, 0x1f0, 0x061, 0x1f6,
    0x7f2, 0x1ea, 0x7fb, 0x1f2, 0x069, 0x1ed, 0x077, 0x017,
    0x06f, 0x1e6, 0x064, 0x1e5, 0x067, 0x015, 0x062, 0x012,
    0x000, 0x014, 0x065, 0x016, 0x06d, 0x1e9, 0x063, 0x1e4,
    0x06b, 0x013, 0x071, 0x1e3, 0x070, 0x1f3, 0x7fe, 0x1e7,
    0x7f3, 0x1ef, 0x060, 0x1ee, 0x7f0, 0x1e2, 0x7fa, 0x3f3,
    0x06a, 0x1e8, 0x075, 0x010, 0x073, 0x1f4, 0x06e, 0x3f7,
    0x7f6, 0x1e0, 0x7f9, 0x3f2, 0x066, 0x1f5, 0x7ff, 0x1f7,
    0x7f4,
};

static const uint8_t bits1[81] = {
    11,  9, 11, 10,  7, 10, 11,  9, 11, 10,  7, 10,  7,  5,  7,  9,
     7, 10, 11,  9, 11,  9,  7,  9, 11,  9, 11,  9,  7,  9,  7,  5,
     7,  9,  7,  9,  7,  5,  7,  5,  1,  5,  7,  5,  7,  9,  7,  9,
     7,  5,  7,  9,  7,  9, 11,  9, 11,  9,  7,  9, 11,  9, 11, 10,
     7,  9,  7,  5,  7,  9,  7, 10, 11,  9, 11, 10,  7,  9, 11,  9,
    11,
};

static const uint16_t codes2[81] = {
    0x1f3, 0x06f, 0x1fd, 0x0eb, 0x023, 0x0ea, 0x1f7, 0x0e8,
    0x1fa, 0x0f2, 0x02d, 0x070, 0x020, 0x006, 0x02b, 0x06e,
    0x028, 0x0e9, 0x1f9, 0x066, 0x0f8, 0x0e7, 0x01b, 0x0f1,
    0x1f4, 0x06b, 0x1f5, 0x0ec, 0x02a, 0x06c, 0x02c, 0x00a,
    0x027, 0x067, 0x01a, 0x0f5, 0x024, 0x008, 0x01f, 0x009,
    0x000, 0x007, 0x01d, 0x00b, 0x030, 0x0ef, 0x01c, 0x064,
    0x01e, 0x00c, 0x029, 0x0f3, 0x02f, 0x0f0, 0x1fc, 0x071,
    0x1f2, 0x0f4, 0x021, 0x0e6, 0x0f7, 0x068, 0x1f8, 0x0ee,
    0x022, 0x065, 0x031, 0x002, 0x026, 0x0ed, 0x025, 0x06a,
    0x1fb, 0x072, 0x1fe, 0x069, 0x02e, 0x0f6, 0x1ff, 0x06d,
    0x1f6,
};

static const uint8_t bits2[81] = {
    9, 7, 9, 8, 6, 8, 9, 8, 9, 8, 6, 7, 6, 5, 6, 7,
    6, 8, 9, 7, 8, 8, 6, 8, 9, 7, 9, 8, 6, 7, 6, 5,
    6, 7, 6, 8, 6, 5, 6, 5, 3, 5, 6, 5, 6, 8, 6, 7,
    6, 5, 6, 8, 6, 8, 9, 7, 9, 8, 6, 8, 8, 7, 9, 8,
    6, 7, 6, 4, 6, 8, 6, 7, 9, 7, 9, 7, 6, 8, 9, 7,
    9,
};

static const uint16_t codes3[81] = {
    0x0000, 0x0009, 0x00ef, 0x000b, 0x0019, 0x00f0, 0x01eb, 0x01e6,
    0x03f2, 0x000a, 0x0035, 0x01ef, 0x0034, 0x0037, 0x01e9, 0x01ed,
    0x01e7, 0x03f3, 0x01ee, 0x03ed, 0x1ffa, 0x01ec, 0x01f2, 0x07f9,
    0x07f8, 0x03f8, 0x0ff8, 0x0008, 0x0038, 0x03f6, 0x0036, 0x0075,
    0x03f1, 0x03eb, 0x03ec, 0x0ff4, 0x0018, 0x0076, 0x07f4, 0x0039,
    0x0074, 0x03ef, 0x01f3, 0x01f4, 0x07f6, 0x01e8, 0x03ea, 0x1ffc,
    0x00f2, 0x01f1, 0x0ffb, 0x03f5, 0x07f3, 0x0ffc, 0x00ee, 0x03f7,
    0x7ffe, 0x01f0, 0x07f5, 0x7ffd, 0x1ffb, 0x3ffa, 0xffff, 0x00f1,
    0x03f0, 0x3ffc, 0x01ea, 0x03ee, 0x3ffb, 0x0ff6, 0x0ffa, 0x7ffc,
    0x07f2, 0x0ff5, 0xfffe, 0x03f4, 0x07f7, 0x7ffb, 0x0ff7, 0x0ff9,
    0x7ffa,
};

static const uint8_t bits3[81] = {
     1,  4,  8,  4,  5,  8,  9,  9, 10,  4,  6,  9,  6,  6,  9,  9,
     9, 10,  9, 10, 13,  9,  9, 11, 11, 10, 12,  4,  6, 10,  6,  7,
    10, 10, 10, 12,  5,  7, 11,  6,  7, 10,  9,  9, 11,  9, 10, 13,
     8,  9, 12, 10, 11, 12,  8, 10, 15,  9, 11, 15, 13, 14, 16,  8,
    10, 14,  9, 10, 14, 12, 12, 15, 11, 12, 16, 10, 11, 15, 12, 12,
    15,
};

static const uint16_t codes4[81] = {
    0x007, 0x016, 0x0f6, 0x018, 0x008, 0x0ef, 0x1ef, 0x0f3,
    0x7f8, 0x019, 0x017, 0x0ed, 0x015, 0x001, 0x0e2, 0x0f0,
    0x070, 0x3f0, 0x1ee, 0x0f1, 0x7fa, 0x0ee, 0x0e4, 0x3f2,
    0x7f6, 0x3ef, 0x7fd, 0x005, 0x014, 0x0f2, 0x009, 0x004,
    0x0e5, 0x0f4, 0x0e8, 0x3f4, 0x006, 0x002, 0x0e7, 0x003,
    0x000, 0x06b, 0x0e3, 0x069, 0x1f3, 0x0eb, 0x0e6, 0x3f6,
    0x06e, 0x06a, 0x1f4, 0x3ec, 0x1f0, 0x3f9, 0x0f5, 0x0ec,
    0x7fb, 0x0ea, 0x06f, 0x3f7, 0x7f9, 0x3f3, 0xfff, 0x0e9,
    0x06d, 0x3f8, 0x06c, 0x068, 0x1f5, 0x3ee, 0x1f2, 0x7f4,
    0x7f7, 0x3f1, 0xffe, 0x3ed, 0x1f1, 0x7f5, 0x7fe, 0x3f5,
    0x7fc,
};

static const uint8_t bits4[81] = {
     4,  5,  8,  5,  4,  8,  9,  8, 11,  5,  5,  8,  5,  4,  8,  8,
     7, 10,  9,  8, 11,  8,  8, 10, 11, 10, 11,  4,  5,  8,  4,  4,
     8,  8,  8, 10,  4,  4,  8,  4,  4,  7,  8,  7,  9,  8,  8, 10,
     7,  7,  9, 10,  9, 10,  8,  8, 11,  8,  7, 10, 11, 10, 12,  8,
     7, 10,  7,  7,  9, 10,  9, 11, 11, 10, 12, 10,  9, 11, 11, 10,
    11,
};

static const uint16_t codes5[81] = {
    0x1fff, 0x0ff7, 0x07f4, 0x07e8, 0x03f1, 0x07ee, 0x07f9, 0x0ff8,
    0x1ffd, 0x0ffd, 0x07f1, 0x03e8, 0x01e8, 0x00f0, 0x01ec, 0x03ee,
    0x07f2, 0x0ffa, 0x0ff4, 0x03ef, 0x01f2, 0x00e8, 0x0070, 0x00ec,
    0x01f0, 0x03ea, 0x07f3, 0x07eb, 0x01eb, 0x00ea, 0x001a, 0x0008,
    0x0019, 0x00ee, 0x01ef, 0x07ed, 0x03f0, 0x00f2, 0x0073, 0x000b,
    0x0000, 0x000a, 0x0071, 0x00f3, 0x07e9, 0x07ef, 0x01ee, 0x00ef,
    0x0018, 0x0009, 0x001b, 0x00eb, 0x01e9, 0x07ec, 0x07f6, 0x03eb,
    0x01f3, 0x00ed, 0x0072, 0x00e9, 0x01f1, 0x03ed, 0x07f7, 0x0ff6,
    0x07f0, 0x03e9, 0x01ed, 0x00f1, 0x01ea, 0x03ec, 0x07f8, 0x0ff9,
    0x1ffc, 0x0ffc, 0x0ff5, 0x07ea, 0x03f3, 0x03f2, 0x07f5, 0x0ffb,
    0x1ffe,
};

static const uint8_t bits5[81] = {
    13, 12, 11, 11, 10, 11, 11, 12, 13, 12, 11, 10,  9,  8,  9, 10,
    11, 12, 12, 10,  9,  8,  7,  8,  9, 10, 11, 11,  9,  8,  5,  4,
     5,  8,  9, 11, 10,  8,  7,  4,  1,  4,  7,  8, 11, 11,  9,  8,
     5,  4,  5,  8,  9, 11, 11, 10,  9,  8,  7,  8,  9, 10, 11, 12,
    11, 10,  9,  8,  9, 10, 11, 12, 13, 12, 12, 11, 10, 10, 11, 12,
    13,
};

static const uint16_t codes6[81] = {
    0x7fe, 0x3fd, 0x1f1, 0x1eb, 0x1f4, 0x1ea, 0x1f0, 0x3fc,
    0x7fd, 0x3f6, 0x1e5, 0x0ea, 0x06c, 0x071, 0x068, 0x0f0,
    0x1e6, 0x3f7, 0x1f3, 0x0ef, 0x032, 0x027, 0x028, 0x026,
    0x031, 0x0eb, 0x1f7, 0x1e8, 0x06f, 0x02e, 0x008, 0x004,
    0x006, 0x029, 0x06b, 0x1ee, 0x1ef, 0x072, 0x02d, 0x002,
    0x000, 0x003, 0x02f, 0x073, 0x1fa, 0x1e7, 0x06e, 0x02b,
    0x007, 0x001, 0x005, 0x02c, 0x06d, 0x1ec, 0x1f9, 0x0ee,
    0x030, 0x024, 0x02a, 0x025, 0x033, 0x0ec, 0x1f2, 0x3f8,
    0x1e4, 0x0ed, 0x06a, 0x070, 0x069, 0x074, 0x0f1, 0x3fa,
    0x7ff, 0x3f9, 0x1f6, 0x1ed, 0x1f8, 0x1e9, 0x1f5, 0x3fb,
    0x7fc,
};

static const uint8_t bits6[81] = {
    11, 10,  9,  9,  9,  9,  9, 10, 11, 10,  9,  8,  7,  7,  7,  8,
     9, 10,  9,  8,  6,  6,  6,  6,  6,  8,  9,  9,  7,  6,  4,  4,
     4,  6,  7,  9,  9,  7,  6,  4,  4,  4,  6,  7,  9,  9,  7,  6,
     4,  4,  4,  6,  7,  9,  9,  8,  6,  6,  6,  6,  6,  8,  9, 10,
     9,  8,  7,  7,  7,  7,  8, 10, 11, 10,  9,  9,  9,  9,  9, 10,
    11,
};

static const uint16_t codes7[64] = {
    0x000, 0x005, 0x037, 0x074, 0x0f2, 0x1eb, 0x3ed, 0x7f7,
    0x004, 0x00c, 0x035, 0x071, 0x0ec, 0x0ee, 0x1ee, 0x1f5,
    0x036, 0x034, 0x072, 0x0ea, 0x0f1, 0x1e9, 0x1f3, 0x3f5,
    0x073, 0x070, 0x0eb, 0x0f0, 0x1f1, 0x1f0, 0x3ec, 0x3fa,
    0x0f3, 0x0ed, 0x1e8, 0x1ef, 0x3ef, 0x3f1, 0x3f9, 0x7fb,
    0x1ed, 0x0ef, 0x1ea, 0x1f2, 0x3f3, 0x3f8, 0x7f9, 0x7fc,
    0x3ee, 0x1ec, 0x1f4, 0x3f4, 0x3f7, 0x7f8, 0xffd, 0xffe,
    0x7f6, 0x3f0, 0x3f2, 0x3f6, 0x7fa, 0x7fd, 0xffc, 0xfff,
};

static const uint8_t bits7[64] = {
     1,  3,  6,  7,  8,  9, 10, 11,  3,  4,  6,  7,  8,  8,  9,  9,
     6,  6,  7,  8,  8,  9,  9, 10,  7,  7,  8,  8,  9,  9, 10, 10,
     8,  8,  9,  9, 10, 10, 10, 11,  9,  8,  9,  9, 10, 10, 11, 11,
    10,  9,  9, 10, 10, 11, 12, 12, 11, 10, 10, 10, 11, 11, 12, 12,
};

static const uint16_t codes8[64] = {
    0x00e, 0x005, 0x010, 0x030, 0x06f, 0x0f1, 0x1fa, 0x3fe,
    0x003, 0x000, 0x004, 0x012, 0x02c, 0x06a, 0x075, 0x0f8,
    0x00f, 0x002, 0x006, 0x014, 0x02e, 0x069, 0x072, 0x0f5,
    0x02f, 0x011, 0x013, 0x02a, 0x032, 0x06c, 0x0ec, 0x0fa,
    0x071, 0x02b, 0x02d, 0x031, 0x06d, 0x070, 0x0f2, 0x1f9,
    0x0ef, 0x068, 0x033, 0x06b, 0x06e, 0x0ee, 0x0f9, 0x3fc,
    0x1f8, 0x074, 0x073, 0x0ed, 0x0f0, 0x0f6, 0x1f6, 0x1fd,
    0x3fd, 0x0f3, 0x0f4, 0x0f7, 0x1f7, 0x1fb, 0x1fc, 0x3ff,
};

static const uint8_t bits8[64] = {
     5,  4,  5,  6,  7,  8,  9, 10,  4,  3,  4,  5,  6,  7,  7,  8,
     5,  4,  4,  5,  6,  7,  7,  8,  6,  5,  5,  6,  6,  7,  8,  8,
     7,  6,  6,  6,  7,  7,  8,  9,  8,  7,  6,  7,  7,  8,  8, 10,
     9,  7,  7,  8,  8,  8,  9,  9, 10,  8,  8,  8,  9,  9,  9, 10,
};

static const uint16_t codes9[169] = {
    0x0000, 0x0005, 0x0037, 0x00e7, 0x01de, 0x03ce, 0x03d9, 0x07c8,
    0x07cd, 0x0fc8, 0x0fdd, 0x1fe4, 0x1fec, 0x0004, 0x000c, 0x0035,
    0x0072, 0x00ea, 0x00ed, 0x01e2, 0x03d1, 0x03d3, 0x03e0, 0x07d8,
    0x0fcf, 0x0fd5, 0x0036, 0x0034, 0x0071, 0x00e8, 0x00ec, 0x01e1,
    0x03cf, 0x03dd, 0x03db, 0x07d0, 0x0fc7, 0x0fd4, 0x0fe4, 0x00e6,
    0x0070, 0x00e9, 0x01dd, 0x01e3, 0x03d2, 0x03dc, 0x07cc, 0x07ca,
    0x07de, 0x0fd8, 0x0fea, 0x1fdb, 0x01df, 0x00eb, 0x01dc, 0x01e6,
    0x03d5, 0x03de, 0x07cb, 0x07dd, 0x07dc, 0x0fcd, 0x0fe2, 0x0fe7,
    0x1fe1, 0x03d0, 0x01e0, 0x01e4, 0x03d6, 0x07c5, 0x07d1, 0x07db,
    0x0fd2, 0x07e0, 0x0fd9, 0x0feb, 0x1fe3, 0x1fe9, 0x07c4, 0x01e5,
    0x03d7, 0x07c6, 0x07cf, 0x07da, 0x0fcb, 0x0fda, 0x0fe3, 0x0fe9,
    0x1fe6, 0x1ff3, 0x1ff7, 0x07d3, 0x03d8, 0x03e1, 0x07d4, 0x07d9,
    0x0fd3, 0x0fde, 0x1fdd, 0x1fd9, 0x1fe2, 0x1fea, 0x1ff1, 0x1ff6,
    0x07d2, 0x03d4, 0x03da, 0x07c7, 0x07d7, 0x07e2, 0x0fce, 0x0fdb,
    0x1fd8, 0x1fee, 0x3ff0, 0x1ff4, 0x3ff2, 0x07e1, 0x03df, 0x07c9,
    0x07d6, 0x0fca, 0x0fd0, 0x0fe5, 0x0fe6, 0x1feb, 0x1fef, 0x3ff3,
    0x3ff4, 0x3ff5, 0x0fe0, 0x07ce, 0x07d5, 0x0fc6, 0x0fd1, 0x0fe1,
    0x1fe0, 0x1fe8, 0x1ff0, 0x3ff1, 0x3ff8, 0x3ff6, 0x7ffc, 0x0fe8,
    0x07df, 0x0fc9, 0x0fd7, 0x0fdc, 0x1fdc, 0x1fdf, 0x1fed, 0x1ff5,
    0x3ff9, 0x3ffb, 0x7ffd, 0x7ffe, 0x1fe7, 0x0fcc, 0x0fd6, 0x0fdf,
    0x1fde, 0x1fda, 0x1fe5, 0x1ff2, 0x3ffa, 0x3ff7, 0x3ffc, 0x3ffd,
    0x7fff,
};

static const uint8_t bits9[169] = {
     1,  3,  6,  8,  9, 10, 10, 11, 11, 12, 12, 13, 13,  3,  4,  6,
     7,  8,  8,  9, 10, 10, 10, 11, 12, 12,  6,  6,  7,  8,  8,  9,
    10, 10, 10, 11, 12, 12, 12,  8,  7,  8,  9,  9, 10, 10, 11, 11,
    11, 12, 12, 13,  9,  8,  9,  9, 10, 10, 11, 11, 11, 12, 12, 12,
    13, 10,  9,  9, 10, 11, 11, 11, 12, 11, 12, 12, 13, 13, 11,  9,
    10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 11, 10, 10, 11, 11,
    12, 12, 13, 13, 13, 13, 13, 13, 11, 10, 10, 11, 11, 11, 12, 12,
    13, 13, 14, 13, 14, 11, 10, 11, 11, 12, 12, 12, 12, 13, 13, 14,
    14, 14, 12, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 12,
    11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 13, 12, 12, 12,
    13, 13, 13, 13, 14, 14, 14, 14, 15,
};

static const uint16_t codes10[169] = {
    0x022, 0x008, 0x01d, 0x026, 0x05f, 0x0d3, 0x1cf, 0x3d0,
    0x3d7, 0x3ed, 0x7f0, 0x7f6, 0xffd, 0x007, 0x000, 0x001,
    0x009, 0x020, 0x054, 0x060, 0x0d5, 0x0dc, 0x1d4, 0x3cd,
    0x3de, 0x7e7, 0x01c, 0x002, 0x006, 0x00c, 0x01e, 0x028,
    0x05b, 0x0cd, 0x0d9, 0x1ce, 0x1dc, 0x3d9, 0x3f1, 0x025,
    0x00b, 0x00a, 0x00d, 0x024, 0x057, 0x061, 0x0cc, 0x0dd,
    0x1cc, 0x1de, 0x3d3, 0x3e7, 0x05d, 0x021, 0x01f, 0x023,
    0x027, 0x059, 0x064, 0x0d8, 0x0df, 0x1d2, 0x1e2, 0x3dd,
    0x3ee, 0x0d1, 0x055, 0x029, 0x056, 0x058, 0x062, 0x0ce,
    0x0e0, 0x0e2, 0x1da, 0x3d4, 0x3e3, 0x7eb, 0x1c9, 0x05e,
    0x05a, 0x05c, 0x063, 0x0ca, 0x0da, 0x1c7, 0x1ca, 0x1e0,
    0x3db, 0x3e8, 0x7ec, 0x1e3, 0x0d2, 0x0cb, 0x0d0, 0x0d7,
    0x0db, 0x1c6, 0x1d5, 0x1d8, 0x3ca, 0x3da, 0x7ea, 0x7f1,
    0x1e1, 0x0d4, 0x0cf, 0x0d6, 0x0de, 0x0e1, 0x1d0, 0x1d6,
    0x3d1, 0x3d5, 0x3f2, 0x7ee, 0x7fb, 0x3e9, 0x1cd, 0x1c8,
    0x1cb, 0x1d1, 0x1d7, 0x1df, 0x3cf, 0x3e0, 0x3ef, 0x7e6,
    0x7f8, 0xffa, 0x3eb, 0x1dd, 0x1d3, 0x1d9, 0x1db, 0x3d2,
    0x3cc, 0x3dc, 0x3ea, 0x7ed, 0x7f3, 0x7f9, 0xff9, 0x7f2,
    0x3ce, 0x1e4, 0x3cb, 0x3d8, 0x3d6, 0x3e2, 0x3e5, 0x7e8,
    0x7f4, 0x7f5, 0x7f7, 0xffb, 0x7fa, 0x3ec, 0x3df, 0x3e1,
    0x3e4, 0x3e6, 0x3f0, 0x7e9, 0x7ef, 0xff8, 0xffe, 0xffc,
    0xfff,
};

static const uint8_t bits10[169] = {
     6,  5,  6,  6,  7,  8,  9, 10, 10, 10, 11, 11, 12,  5,  4,  4,
     5,  6,  7,  7,  8,  8,  9, 10, 10, 11,  6,  4,  5,  5,  6,  6,
     7,  8,  8,  9,  9, 10, 10,  6,  5,  5,  5,  6,  7,  7,  8,  8,
     9,  9, 10, 10,  7,  6,  6,  6,  6,  7,  7,  8,  8,  9,  9, 10,
    10,  8,  7,  6,  7,  7,  7,  8,  8,  8,  9, 10, 10, 11,  9,  7,
     7,  7,  7,  8,  8,  9,  9,  9, 10, 10, 11,  9,  8,  8,  8,  8,
     8,  9,  9,  9, 10, 10, 11, 11,  9,  8,  8,  8,  8,  8,  9,  9,
    10, 10, 10, 11, 11, 10,  9,  9,  9,  9,  9,  9, 10, 10, 10, 11,
    11, 12, 10,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 12, 11,
    10,  9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 11, 10, 10, 10,
    10, 10, 10, 11, 11, 12, 12, 12, 12,
};

static const uint16_t codes11[289] = {
    0x000, 0x006, 0x019, 0x03d, 0x09c, 0x0c6, 0x1a7, 0x390,
    0x3c2, 0x3df, 0x7e6, 0x7f3, 0xffb, 0x7ec, 0xffa, 0xffe,
    0x38e, 0x005, 0x001, 0x008, 0x014, 0x037, 0x042, 0x092,
    0x0af, 0x191, 0x1a5, 0x1b5, 0x39e, 0x3c0, 0x3a2, 0x3cd,
    0x7d6, 0x0ae, 0x017, 0x007, 0x009, 0x018, 0x039, 0x040,
    0x08e, 0x0a3, 0x0b8, 0x199, 0x1ac, 0x1c1, 0x3b1, 0x396,
    0x3be, 0x3ca, 0x09d, 0x03c, 0x015, 0x016, 0x01a, 0x03b,
    0x044, 0x091, 0x0a5, 0x0be, 0x196, 0x1ae, 0x1b9, 0x3a1,
    0x391, 0x3a5, 0x3d5, 0x094, 0x09a, 0x036, 0x038, 0x03a,
    0x041, 0x08c, 0x09b, 0x0b0, 0x0c3, 0x19e, 0x1ab, 0x1bc,
    0x39f, 0x38f, 0x3a9, 0x3cf, 0x093, 0x0bf, 0x03e, 0x03f,
    0x043, 0x045, 0x09e, 0x0a7, 0x0b9, 0x194, 0x1a2, 0x1ba,
    0x1c3, 0x3a6, 0x3a7, 0x3bb, 0x3d4, 0x09f, 0x1a0, 0x08f,
    0x08d, 0x090, 0x098, 0x0a6, 0x0b6, 0x0c4, 0x19f, 0x1af,
    0x1bf, 0x399, 0x3bf, 0x3b4, 0x3c9, 0x3e7, 0x0a8, 0x1b6,
    0x0ab, 0x0a4, 0x0aa, 0x0b2, 0x0c2, 0x0c5, 0x198, 0x1a4,
    0x1b8, 0x38c, 0x3a4, 0x3c4, 0x3c6, 0x3dd, 0x3e8, 0x0ad,
    0x3af, 0x192, 0x0bd, 0x0bc, 0x18e, 0x197, 0x19a, 0x1a3,
    0x1b1, 0x38d, 0x398, 0x3b7, 0x3d3, 0x3d1, 0x3db, 0x7dd,
    0x0b4, 0x3de, 0x1a9, 0x19b, 0x19c, 0x1a1, 0x1aa, 0x1ad,
    0x1b3, 0x38b, 0x3b2, 0x3b8, 0x3ce, 0x3e1, 0x3e0, 0x7d2,
    0x7e5, 0x0b7, 0x7e3, 0x1bb, 0x1a8, 0x1a6, 0x1b0, 0x1b2,
    0x1b7, 0x39b, 0x39a, 0x3ba, 0x3b5, 0x3d6, 0x7d7, 0x3e4,
    0x7d8, 0x7ea, 0x0ba, 0x7e8, 0x3a0, 0x1bd, 0x1b4, 0x38a,
    0x1c4, 0x392, 0x3aa, 0x3b0, 0x3bc, 0x3d7, 0x7d4, 0x7dc,
    0x7db, 0x7d5, 0x7f0, 0x0c1, 0x7fb, 0x3c8, 0x3a3, 0x395,
    0x39d, 0x3ac, 0x3ae, 0x3c5, 0x3d8, 0x3e2, 0x3e6, 0x7e4,
    0x7e7, 0x7e0, 0x7e9, 0x7f7, 0x190, 0x7f2, 0x393, 0x1be,
    0x1c0, 0x394, 0x397, 0x3ad, 0x3c3, 0x3c1, 0x3d2, 0x7da,
    0x7d9, 0x7df, 0x7eb, 0x7f4, 0x7fa, 0x195, 0x7f8, 0x3bd,
    0x39c, 0x3ab, 0x3a8, 0x3b3, 0x3b9, 0x3d0, 0x3e3, 0x3e5,
    0x7e2, 0x7de, 0x7ed, 0x7f1, 0x7f9, 0x7fc, 0x193, 0xffd,
    0x3dc, 0x3b6, 0x3c7, 0x3cc, 0x3cb, 0x3d9, 0x3da, 0x7d3,
    0x7e1, 0x7ee, 0x7ef, 0x7f5, 0x7f6, 0xffc, 0xfff, 0x19d,
    0x1c2, 0x0b5, 0x0a1, 0x096, 0x097, 0x095, 0x099, 0x0a0,
    0x0a2, 0x0ac, 0x0a9, 0x0b1, 0x0b3, 0x0bb, 0x0c0, 0x18f,
    0x004,
};

static const uint8_t bits11[289] = {
     4,  5,  6,  7,  8,  8,  9, 10, 10, 10, 11, 11, 12, 11, 12, 12,
    10,  5,  4,  5,  6,  7,  7,  8,  8,  9,  9,  9, 10, 10, 10, 10,
    11,  8,  6,  5,  5,  6,  7,  7,  8,  8,  8,  9,  9,  9, 10, 10,
    10, 10,  8,  7,  6,  6,  6,  7,  7,  8,  8,  8,  9,  9,  9, 10,
    10, 10, 10,  8,  8,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,  9,
    10, 10, 10, 10,  8,  8,  7,  7,  7,  7,  8,  8,  8,  9,  9,  9,
     9, 10, 10, 10, 10,  8,  9,  8,  8,  8,  8,  8,  8,  8,  9,  9,
     9, 10, 10, 10, 10, 10,  8,  9,  8,  8,  8,  8,  8,  8,  9,  9,
     9, 10, 10, 10, 10, 10, 10,  8, 10,  9,  8,  8,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 11,  8, 10,  9,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 11, 11,  8, 11,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 11, 10, 11, 11,  8, 11, 10,  9,  9, 10,
     9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,  8, 11, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,  9, 11, 10,  9,
     9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,  9, 11, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,  9, 12,
    10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12,  9,
     9,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,
     5,
};

const uint16_t *ff_aac_spectral_codes[11] = {
    codes1,  codes2,  codes3, codes4, codes5, codes6, codes7, codes8,
    codes9, codes10, codes11,
};

const uint8_t *ff_aac_spectral_bits[11] = {
    bits1,  bits2,  bits3, bits4, bits5, bits6, bits7, bits8,
    bits9, bits10, bits11,
};

const uint16_t ff_aac_spectral_sizes[11] = {
    81, 81, 81, 81, 81, 81, 64, 64, 169, 169, 289,
};

static const int8_t codebook_vector0[324] = {
 -1, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1,  1, -1, -1,  0, -1,
 -1, -1,  0,  0, -1, -1,  0,  1, -1, -1,  1, -1, -1, -1,  1,  0,
 -1, -1,  1,  1, -1,  0, -1, -1, -1,  0, -1,  0, -1,  0, -1,  1,
 -1,  0,  0, -1, -1,  0,  0,  0, -1,  0,  0,  1, -1,  0,  1, -1,
 -1,  0,  1,  0, -1,  0,  1,  1, -1,  1, -1, -1, -1,  1, -1,  0,
 -1,  1, -1,  1, -1,  1,  0, -1, -1,  1,  0,  0, -1,  1,  0,  1,
 -1,  1,  1, -1, -1,  1,  1,  0, -1,  1,  1,  1,  0, -1, -1, -1,
  0, -1, -1,  0,  0, -1, -1,  1,  0, -1,  0, -1,  0, -1,  0,  0,
  0, -1,  0,  1,  0, -1,  1, -1,  0, -1,  1,  0,  0, -1,  1,  1,
  0,  0, -1, -1,  0,  0, -1,  0,  0,  0, -1,  1,  0,  0,  0, -1,
  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1, -1,  0,  0,  1,  0,
  0,  0,  1,  1,  0,  1, -1, -1,  0,  1, -1,  0,  0,  1, -1,  1,
  0,  1,  0, -1,  0,  1,  0,  0,  0,  1,  0,  1,  0,  1,  1, -1,
  0,  1,  1,  0,  0,  1,  1,  1,  1, -1, -1, -1,  1, -1, -1,  0,
  1, -1, -1,  1,  1, -1,  0, -1,  1, -1,  0,  0,  1, -1,  0,  1,
  1, -1,  1, -1,  1, -1,  1,  0,  1, -1,  1,  1,  1,  0, -1, -1,
  1,  0, -1,  0,  1,  0, -1,  1,  1,  0,  0, -1,  1,  0,  0,  0,
  1,  0,  0,  1,  1,  0,  1, -1,  1,  0,  1,  0,  1,  0,  1,  1,
  1,  1, -1, -1,  1,  1, -1,  0,  1,  1, -1,  1,  1,  1,  0, -1,
  1,  1,  0,  0,  1,  1,  0,  1,  1,  1,  1, -1,  1,  1,  1,  0,
  1,  1,  1,  1,
};

static const int8_t codebook_vector2[324] = {
  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  1,  0,
  0,  0,  1,  1,  0,  0,  1,  2,  0,  0,  2,  0,  0,  0,  2,  1,
  0,  0,  2,  2,  0,  1,  0,  0,  0,  1,  0,  1,  0,  1,  0,  2,
  0,  1,  1,  0,  0,  1,  1,  1,  0,  1,  1,  2,  0,  1,  2,  0,
  0,  1,  2,  1,  0,  1,  2,  2,  0,  2,  0,  0,  0,  2,  0,  1,
  0,  2,  0,  2,  0,  2,  1,  0,  0,  2,  1,  1,  0,  2,  1,  2,
  0,  2,  2,  0,  0,  2,  2,  1,  0,  2,  2,  2,  1,  0,  0,  0,
  1,  0,  0,  1,  1,  0,  0,  2,  1,  0,  1,  0,  1,  0,  1,  1,
  1,  0,  1,  2,  1,  0,  2,  0,  1,  0,  2,  1,  1,  0,  2,  2,
  1,  1,  0,  0,  1,  1,  0,  1,  1,  1,  0,  2,  1,  1,  1,  0,
  1,  1,  1,  1,  1,  1,  1,  2,  1,  1,  2,  0,  1,  1,  2,  1,
  1,  1,  2,  2,  1,  2,  0,  0,  1,  2,  0,  1,  1,  2,  0,  2,
  1,  2,  1,  0,  1,  2,  1,  1,  1,  2,  1,  2,  1,  2,  2,  0,
  1,  2,  2,  1,  1,  2,  2,  2,  2,  0,  0,  0,  2,  0,  0,  1,
  2,  0,  0,  2,  2,  0,  1,  0,  2,  0,  1,  1,  2,  0,  1,  2,
  2,  0,  2,  0,  2,  0,  2,  1,  2,  0,  2,  2,  2,  1,  0,  0,
  2,  1,  0,  1,  2,  1,  0,  2,  2,  1,  1,  0,  2,  1,  1,  1,
  2,  1,  1,  2,  2,  1,  2,  0,  2,  1,  2,  1,  2,  1,  2,  2,
  2,  2,  0,  0,  2,  2,  0,  1,  2,  2,  0,  2,  2,  2,  1,  0,
  2,  2,  1,  1,  2,  2,  1,  2,  2,  2,  2,  0,  2,  2,  2,  1,
  2,  2,  2,  2,
};

static const int8_t codebook_vector4[162] = {
 -4, -4, -4, -3, -4, -2, -4, -1, -4,  0, -4,  1, -4,  2, -4,  3,
 -4,  4, -3, -4, -3, -3, -3, -2, -3, -1, -3,  0, -3,  1, -3,  2,
 -3,  3, -3,  4, -2, -4, -2, -3, -2, -2, -2, -1, -2,  0, -2,  1,
 -2,  2, -2,  3, -2,  4, -1, -4, -1, -3, -1, -2, -1, -1, -1,  0,
 -1,  1, -1,  2, -1,  3, -1,  4,  0, -4,  0, -3,  0, -2,  0, -1,
  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,  1, -4,  1, -3,  1, -2,
  1, -1,  1,  0,  1,  1,  1,  2,  1,  3,  1,  4,  2, -4,  2, -3,
  2, -2,  2, -1,  2,  0,  2,  1,  2,  2,  2,  3,  2,  4,  3, -4,
  3, -3,  3, -2,  3, -1,  3,  0,  3,  1,  3,  2,  3,  3,  3,  4,
  4, -4,  4, -3,  4, -2,  4, -1,  4,  0,  4,  1,  4,  2,  4,  3,
  4,  4,
};

static const int8_t codebook_vector6[128] = {
  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,
  1,  0,  1,  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  6,  1,  7,
  2,  0,  2,  1,  2,  2,  2,  3,  2,  4,  2,  5,  2,  6,  2,  7,
  3,  0,  3,  1,  3,  2,  3,  3,  3,  4,  3,  5,  3,  6,  3,  7,
  4,  0,  4,  1,  4,  2,  4,  3,  4,  4,  4,  5,  4,  6,  4,  7,
  5,  0,  5,  1,  5,  2,  5,  3,  5,  4,  5,  5,  5,  6,  5,  7,
  6,  0,  6,  1,  6,  2,  6,  3,  6,  4,  6,  5,  6,  6,  6,  7,
  7,  0,  7,  1,  7,  2,  7,  3,  7,  4,  7,  5,  7,  6,  7,  7,
};

static const int8_t codebook_vector8[338] = {
  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,
  0,  8,  0,  9,  0, 10,  0, 11,  0, 12,  1,  0,  1,  1,  1,  2,
  1,  3,  1,  4,  1,  5,  1,  6,  1,  7,  1,  8,  1,  9,  1, 10,
  1, 11,  1, 12,  2,  0,  2,  1,  2,  2,  2,  3,  2,  4,  2,  5,
  2,  6,  2,  7,  2,  8,  2,  9,  2, 10,  2, 11,  2, 12,  3,  0,
  3,  1,  3,  2,  3,  3,  3,  4,  3,  5,  3,  6,  3,  7,  3,  8,
  3,  9,  3, 10,  3, 11,  3, 12,  4,  0,  4,  1,  4,  2,  4,  3,
  4,  4,  4,  5,  4,  6,  4,  7,  4,  8,  4,  9,  4, 10,  4, 11,
  4, 12,  5,  0,  5,  1,  5,  2,  5,  3,  5,  4,  5,  5,  5,  6,
  5,  7,  5,  8,  5,  9,  5, 10,  5, 11,  5, 12,  6,  0,  6,  1,
  6,  2,  6,  3,  6,  4,  6,  5,  6,  6,  6,  7,  6,  8,  6,  9,
  6, 10,  6, 11,  6, 12,  7,  0,  7,  1,  7,  2,  7,  3,  7,  4,
  7,  5,  7,  6,  7,  7,  7,  8,  7,  9,  7, 10,  7, 11,  7, 12,
  8,  0,  8,  1,  8,  2,  8,  3,  8,  4,  8,  5,  8,  6,  8,  7,
  8,  8,  8,  9,  8, 10,  8, 11,  8, 12,  9,  0,  9,  1,  9,  2,
  9,  3,  9,  4,  9,  5,  9,  6,  9,  7,  9,  8,  9,  9,  9, 10,
  9, 11,  9, 12, 10,  0, 10,  1, 10,  2, 10,  3, 10,  4, 10,  5,
 10,  6, 10,  7, 10,  8, 10,  9, 10, 10, 10, 11, 10, 12, 11,  0,
 11,  1, 11,  2, 11,  3, 11,  4, 11,  5, 11,  6, 11,  7, 11,  8,
 11,  9, 11, 10, 11, 11, 11, 12, 12,  0, 12,  1, 12,  2, 12,  3,
 12,  4, 12,  5, 12,  6, 12,  7, 12,  8, 12,  9, 12, 10, 12, 11,
 12, 12,
};

static const int8_t codebook_vector10[578] = {
  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,
  0,  8,  0,  9,  0, 10,  0, 11,  0, 12,  0, 13,  0, 14,  0, 15,
  0, 16,  1,  0,  1,  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  6,
  1,  7,  1,  8,  1,  9,  1, 10,  1, 11,  1, 12,  1, 13,  1, 14,
  1, 15,  1, 16,  2,  0,  2,  1,  2,  2,  2,  3,  2,  4,  2,  5,
  2,  6,  2,  7,  2,  8,  2,  9,  2, 10,  2, 11,  2, 12,  2, 13,
  2, 14,  2, 15,  2, 16,  3,  0,  3,  1,  3,  2,  3,  3,  3,  4,
  3,  5,  3,  6,  3,  7,  3,  8,  3,  9,  3, 10,  3, 11,  3, 12,
  3, 13,  3, 14,  3, 15,  3, 16,  4,  0,  4,  1,  4,  2,  4,  3,
  4,  4,  4,  5,  4,  6,  4,  7,  4,  8,  4,  9,  4, 10,  4, 11,
  4, 12,  4, 13,  4, 14,  4, 15,  4, 16,  5,  0,  5,  1,  5,  2,
  5,  3,  5,  4,  5,  5,  5,  6,  5,  7,  5,  8,  5,  9,  5, 10,
  5, 11,  5, 12,  5, 13,  5, 14,  5, 15,  5, 16,  6,  0,  6,  1,
  6,  2,  6,  3,  6,  4,  6,  5,  6,  6,  6,  7,  6,  8,  6,  9,
  6, 10,  6, 11,  6, 12,  6, 13,  6, 14,  6, 15,  6, 16,  7,  0,
  7,  1,  7,  2,  7,  3,  7,  4,  7,  5,  7,  6,  7,  7,  7,  8,
  7,  9,  7, 10,  7, 11,  7, 12,  7, 13,  7, 14,  7, 15,  7, 16,
  8,  0,  8,  1,  8,  2,  8,  3,  8,  4,  8,  5,  8,  6,  8,  7,
  8,  8,  8,  9,  8, 10,  8, 11,  8, 12,  8, 13,  8, 14,  8, 15,
  8, 16,  9,  0,  9,  1,  9,  2,  9,  3,  9,  4,  9,  5,  9,  6,
  9,  7,  9,  8,  9,  9,  9, 10,  9, 11,  9, 12,  9, 13,  9, 14,
  9, 15,  9, 16, 10,  0, 10,  1, 10,  2, 10,  3, 10,  4, 10,  5,
 10,  6, 10,  7, 10,  8, 10,  9, 10, 10, 10, 11, 10, 12, 10, 13,
 10, 14, 10, 15, 10, 16, 11,  0, 11,  1, 11,  2, 11,  3, 11,  4,
 11,  5, 11,  6, 11,  7, 11,  8, 11,  9, 11, 10, 11, 11, 11, 12,
 11, 13, 11, 14, 11, 15, 11, 16, 12,  0, 12,  1, 12,  2, 12,  3,
 12,  4, 12,  5, 12,  6, 12,  7, 12,  8, 12,  9, 12, 10, 12, 11,
 12, 12, 12, 13, 12, 14, 12, 15, 12, 16, 13,  0, 13,  1, 13,  2,
 13,  3, 13,  4, 13,  5, 13,  6, 13,  7, 13,  8, 13,  9, 13, 10,
 13, 11, 13, 12, 13, 13, 13, 14, 13, 15, 13, 16, 14,  0, 14,  1,
 14,  2, 14,  3, 14,  4, 14,  5, 14,  6, 14,  7, 14,  8, 14,  9,
 14, 10, 14, 11, 14, 12, 14, 13, 14, 14, 14, 15, 14, 16, 15,  0,
 15,  1, 15,  2, 15,  3, 15,  4, 15,  5, 15,  6, 15,  7, 15,  8,
 15,  9, 15, 10, 15, 11, 15, 12, 15, 13, 15, 14, 15, 15, 15, 16,
 16,  0, 16,  1, 16,  2, 16,  3, 16,  4, 16,  5, 16,  6, 16,  7,
 16,  8, 16,  9, 16, 10, 16, 11, 16, 12, 16, 13, 16, 14, 16, 15,
 16, 16,
};

const int8_t *ff_aac_codebook_vectors[] = {
    codebook_vector0, codebook_vector0, codebook_vector2,
    codebook_vector2, codebook_vector4, codebook_vector4,
    codebook_vector6, codebook_vector6, codebook_vector8,
    codebook_vector8, codebook_vector10,
};

#ifdef CONFIG_HARDCODED_TABLES

const float ff_aac_ivquant_tab[IVQUANT_SIZE] = {
    -4085.3368071, -4074.6805676, -4064.0312908, -4053.3889857,
    -4042.7536614, -4032.1253271, -4021.5039921, -4010.8896656,
    -4000.2823568, -3989.6820750, -3979.0888296, -3968.5026299,
    -3957.9234854, -3947.3514054, -3936.7863993, -3926.2284768,
    -3915.6776473, -3905.1339203, -3894.5973054, -3884.0678123,
    -3873.5454506, -3863.0302299, -3852.5221601, -3842.0212507,
    -3831.5275117, -3821.0409528, -3810.5615838, -3800.0894147,
    -3789.6244554, -3779.1667157, -3768.7162058, -3758.2729355,
    -3747.8369150, -3737.4081544, -3726.9866637, -3716.5724532,
    -3706.1655329, -3695.7659132, -3685.3736044, -3674.9886166,
    -3664.6109603, -3654.2406458, -3643.8776835, -3633.5220839,
    -3623.1738574, -3612.8330147, -3602.4995662, -3592.1735225,
    -3581.8548943, -3571.5436923, -3561.2399271, -3550.9436095,
    -3540.6547503, -3530.3733604, -3520.0994506, -3509.8330317,
    -3499.5741148, -3489.3227109, -3479.0788309, -3468.8424860,
    -3458.6136872, -3448.3924458, -3438.1787728, -3427.9726795,
    -3417.7741773, -3407.5832773, -3397.3999911, -3387.2243299,
    -3377.0563052, -3366.8959286, -3356.7432115, -3346.5981655,
    -3336.4608022, -3326.3311334, -3316.2091706, -3306.0949257,
    -3295.9884105, -3285.8896367, -3275.7986164, -3265.7153613,
    -3255.6398836, -3245.5721951, -3235.5123081, -3225.4602346,
    -3215.4159867, -3205.3795768, -3195.3510169, -3185.3303196,
    -3175.3174970, -3165.3125617, -3155.3155261, -3145.3264026,
    -3135.3452039, -3125.3719425, -3115.4066312, -3105.4492825,
    -3095.4999092, -3085.5585243, -3075.6251404, -3065.6997706,
    -3055.7824278, -3045.8731250, -3035.9718753, -3026.0786917,
    -3016.1935876, -3006.3165760, -2996.4476703, -2986.5868839,
    -2976.7342300, -2966.8897222, -2957.0533740, -2947.2251989,
    -2937.4052106, -2927.5934226, -2917.7898488, -2907.9945030,
    -2898.2073989, -2888.4285505, -2878.6579717, -2868.8956767,
    -2859.1416793, -2849.3959939, -2839.6586345, -2829.9296156,
    -2820.2089512, -2810.4966560, -2800.7927443, -2791.0972306,
    -2781.4101295, -2771.7314556, -2762.0612237, -2752.3994485,
    -2742.7461448, -2733.1013276, -2723.4650117, -2713.8372123,
    -2704.2179443, -2694.6072231, -2685.0050637, -2675.4114815,
    -2665.8264919, -2656.2501103, -2646.6823521, -2637.1232331,
    -2627.5727687, -2618.0309748, -2608.4978671, -2598.9734614,
    -2589.4577738, -2579.9508201, -2570.4526166, -2560.9631792,
    -2551.4825244, -2542.0106682, -2532.5476273, -2523.0934179,
    -2513.6480566, -2504.2115601, -2494.7839450, -2485.3652281,
    -2475.9554262, -2466.5545562, -2457.1626352, -2447.7796803,
    -2438.4057086, -2429.0407373, -2419.6847838, -2410.3378655,
    -2401.0000000, -2391.6712048, -2382.3514975, -2373.0408959,
    -2363.7394180, -2354.4470815, -2345.1639046, -2335.8899054,
    -2326.6251019, -2317.3695127, -2308.1231559, -2298.8860501,
    -2289.6582139, -2280.4396659, -2271.2304249, -2262.0305097,
    -2252.8399393, -2243.6587327, -2234.4869090, -2225.3244875,
    -2216.1714876, -2207.0279286, -2197.8938301, -2188.7692117,
    -2179.6540933, -2170.5484945, -2161.4524354, -2152.3659360,
    -2143.2890165, -2134.2216972, -2125.1639983, -2116.1159404,
    -2107.0775442, -2098.0488302, -2089.0298192, -2080.0205323,
    -2071.0209905, -2062.0312148, -2053.0512267, -2044.0810473,
    -2035.1206983, -2026.1702013, -2017.2295780, -2008.2988502,
    -1999.3780400, -1990.4671694, -1981.5662607, -1972.6753362,
    -1963.7944183, -1954.9235298, -1946.0626932, -1937.2119316,
    -1928.3712678, -1919.5407249, -1910.7203263, -1901.9100954,
    -1893.1100555, -1884.3202305, -1875.5406441, -1866.7713202,
    -1858.0122829, -1849.2635565, -1840.5251653, -1831.7971337,
    -1823.0794865, -1814.3722485, -1805.6754445, -1796.9890997,
    -1788.3132394, -1779.6478889, -1770.9930739, -1762.3488199,
    -1753.7151529, -1745.0920989, -1736.4796841, -1727.8779349,
    -1719.2868777, -1710.7065393, -1702.1369465, -1693.5781262,
    -1685.0301058, -1676.4929125, -1667.9665739, -1659.4511177,
    -1650.9465718, -1642.4529642, -1633.9703232, -1625.4986772,
    -1617.0380549, -1608.5884850, -1600.1499965, -1591.7226186,
    -1583.3063807, -1574.9013124, -1566.5074433, -1558.1248036,
    -1549.7534233, -1541.3933328, -1533.0445627, -1524.7071438,
    -1516.3811070, -1508.0664836, -1499.7633050, -1491.4716029,
    -1483.1914090, -1474.9227555, -1466.6656746, -1458.4201990,
    -1450.1863613, -1441.9641946, -1433.7537320, -1425.5550071,
    -1417.3680536, -1409.1929053, -1401.0295965, -1392.8781617,
    -1384.7386355, -1376.6110529, -1368.4954490, -1360.3918594,
    -1352.3003198, -1344.2208661, -1336.1535347, -1328.0983621,
    -1320.0553851, -1312.0246407, -1304.0061665, -1296.0000000,
    -1288.0061792, -1280.0247424, -1272.0557280, -1264.0991750,
    -1256.1551226, -1248.2236101, -1240.3046773, -1232.3983645,
    -1224.5047118, -1216.6237602, -1208.7555507, -1200.9001246,
    -1193.0575238, -1185.2277903, -1177.4109665, -1169.6070953,
    -1161.8162197, -1154.0383833, -1146.2736299, -1138.5220038,
    -1130.7835495, -1123.0583122, -1115.3463371, -1107.6476700,
    -1099.9623571, -1092.2904450, -1084.6319806, -1076.9870114,
    -1069.3555851, -1061.7377500, -1054.1335548, -1046.5430486,
    -1038.9662809, -1031.4033017, -1023.8541615, -1016.3189112,
    -1008.7976022, -1001.2902864,  -993.7970162,  -986.3178444,
     -978.8528243,  -971.4020099,  -963.9654554,  -956.5432158,
     -949.1353466,  -941.7419036,  -934.3629435,  -926.9985233,
     -919.6487005,  -912.3135336,  -904.9930812,  -897.6874027,
     -890.3965581,  -883.1206081,  -875.8596139,  -868.6136373,
     -861.3827409,  -854.1669878,  -846.9664418,  -839.7811675,
     -832.6112300,  -825.4566953,  -818.3176299,  -811.1941012,
     -804.0861773,  -796.9939269,  -789.9174197,  -782.8567260,
     -775.8119169,  -768.7830645,  -761.7702415,  -754.7735215,
     -747.7929790,  -740.8286894,  -733.8807287,  -726.9491743,
     -720.0341040,  -713.1355968,  -706.2537328,  -699.3885927,
     -692.5402584,  -685.7088129,  -678.8943400,  -672.0969248,
     -665.3166532,  -658.5536125,  -651.8078908,  -645.0795775,
     -638.3687633,  -631.6755398,  -625.0000000,  -618.3422381,
     -611.7023495,  -605.0804310,  -598.4765806,  -591.8908978,
     -585.3234834,  -578.7744395,  -572.2438698,  -565.7318795,
     -559.2385751,  -552.7640648,  -546.3084584,  -539.8718672,
     -533.4544042,  -527.0561843,  -520.6773237,  -514.3179408,
     -507.9781556,  -501.6580901,  -495.3578679,  -489.0776150,
     -482.8174592,  -476.5775303,  -470.3579603,  -464.1588834,
     -457.9804359,  -451.8227566,  -445.6859865,  -439.5702691,
     -433.4757504,  -427.4025787,  -421.3509053,  -415.3208841,
     -409.3126715,  -403.3264272,  -397.3623135,  -391.4204959,
     -385.5011431,  -379.6044268,  -373.7305221,  -367.8796078,
     -362.0518657,  -356.2474818,  -350.4666456,  -344.7095504,
     -338.9763937,  -333.2673772,  -327.5827066,  -321.9225924,
     -316.2872495,  -310.6768976,  -305.0917613,  -299.5320705,
     -293.9980602,  -288.4899710,  -283.0080491,  -277.5525469,
     -272.1237227,  -266.7218414,  -261.3471743,  -256.0000000,
     -250.6806041,  -245.3892798,  -240.1263282,  -234.8920585,
     -229.6867885,  -224.5108452,  -219.3645645,  -214.2482925,
     -209.1623853,  -204.1072101,  -199.0831450,  -194.0905802,
     -189.1299182,  -184.2015749,  -179.3059798,  -174.4435769,
     -169.6148258,  -164.8202021,  -160.0601987,  -155.3353268,
     -150.6461166,  -145.9931191,  -141.3769069,  -136.7980757,
     -132.2572463,  -127.7550655,  -123.2922085,  -118.8693810,
     -114.4873209,  -110.1468012,  -105.8486329,  -101.5936673,
      -97.3828002,   -93.2169752,   -89.0971879,   -85.0244912,
      -81.0000000,   -77.0248978,   -73.1004435,   -69.2279794,
      -65.4089405,   -61.6448653,   -57.9374077,   -54.2883523,
      -50.6996313,   -47.1733451,   -43.7117870,   -40.3174736,
      -36.9931811,   -33.7419917,   -30.5673509,   -27.4731418,
      -24.4637810,   -21.5443469,   -18.7207544,   -16.0000000,
      -13.3905183,   -10.9027236,    -8.5498797,    -6.3496042,
       -4.3267487,    -2.5198421,    -1.0000000,     0.0000000,
        1.0000000,     2.5198421,     4.3267487,     6.3496042,
        8.5498797,    10.9027236,    13.3905183,    16.0000000,
       18.7207544,    21.5443469,    24.4637810,    27.4731418,
       30.5673509,    33.7419917,    36.9931811,    40.3174736,
       43.7117870,    47.1733451,    50.6996313,    54.2883523,
       57.9374077,    61.6448653,    65.4089405,    69.2279794,
       73.1004435,    77.0248978,    81.0000000,    85.0244912,
       89.0971879,    93.2169752,    97.3828002,   101.5936673,
      105.8486329,   110.1468012,   114.4873209,   118.8693810,
      123.2922085,   127.7550655,   132.2572463,   136.7980757,
      141.3769069,   145.9931191,   150.6461166,   155.3353268,
      160.0601987,   164.8202021,   169.6148258,   174.4435769,
      179.3059798,   184.2015749,   189.1299182,   194.0905802,
      199.0831450,   204.1072101,   209.1623853,   214.2482925,
      219.3645645,   224.5108452,   229.6867885,   234.8920585,
      240.1263282,   245.3892798,   250.6806041,   256.0000000,
      261.3471743,   266.7218414,   272.1237227,   277.5525469,
      283.0080491,   288.4899710,   293.9980602,   299.5320705,
      305.0917613,   310.6768976,   316.2872495,   321.9225924,
      327.5827066,   333.2673772,   338.9763937,   344.7095504,
      350.4666456,   356.2474818,   362.0518657,   367.8796078,
      373.7305221,   379.6044268,   385.5011431,   391.4204959,
      397.3623135,   403.3264272,   409.3126715,   415.3208841,
      421.3509053,   427.4025787,   433.4757504,   439.5702691,
      445.6859865,   451.8227566,   457.9804359,   464.1588834,
      470.3579603,   476.5775303,   482.8174592,   489.0776150,
      495.3578679,   501.6580901,   507.9781556,   514.3179408,
      520.6773237,   527.0561843,   533.4544042,   539.8718672,
      546.3084584,   552.7640648,   559.2385751,   565.7318795,
      572.2438698,   578.7744395,   585.3234834,   591.8908978,
      598.4765806,   605.0804310,   611.7023495,   618.3422381,
      625.0000000,   631.6755398,   638.3687633,   645.0795775,
      651.8078908,   658.5536125,   665.3166532,   672.0969248,
      678.8943400,   685.7088129,   692.5402584,   699.3885927,
      706.2537328,   713.1355968,   720.0341040,   726.9491743,
      733.8807287,   740.8286894,   747.7929790,   754.7735215,
      761.7702415,   768.7830645,   775.8119169,   782.8567260,
      789.9174197,   796.9939269,   804.0861773,   811.1941012,
      818.3176299,   825.4566953,   832.6112300,   839.7811675,
      846.9664418,   854.1669878,   861.3827409,   868.6136373,
      875.8596139,   883.1206081,   890.3965581,   897.6874027,
      904.9930812,   912.3135336,   919.6487005,   926.9985233,
      934.3629435,   941.7419036,   949.1353466,   956.5432158,
      963.9654554,   971.4020099,   978.8528243,   986.3178444,
      993.7970162,  1001.2902864,  1008.7976022,  1016.3189112,
     1023.8541615,  1031.4033017,  1038.9662809,  1046.5430486,
     1054.1335548,  1061.7377500,  1069.3555851,  1076.9870114,
     1084.6319806,  1092.2904450,  1099.9623571,  1107.6476700,
     1115.3463371,  1123.0583122,  1130.7835495,  1138.5220038,
     1146.2736299,  1154.0383833,  1161.8162197,  1169.6070953,
     1177.4109665,  1185.2277903,  1193.0575238,  1200.9001246,
     1208.7555507,  1216.6237602,  1224.5047118,  1232.3983645,
     1240.3046773,  1248.2236101,  1256.1551226,  1264.0991750,
     1272.0557280,  1280.0247424,  1288.0061792,  1296.0000000,
     1304.0061665,  1312.0246407,  1320.0553851,  1328.0983621,
     1336.1535347,  1344.2208661,  1352.3003198,  1360.3918594,
     1368.4954490,  1376.6110529,  1384.7386355,  1392.8781617,
     1401.0295965,  1409.1929053,  1417.3680536,  1425.5550071,
     1433.7537320,  1441.9641946,  1450.1863613,  1458.4201990,
     1466.6656746,  1474.9227555,  1483.1914090,  1491.4716029,
     1499.7633050,  1508.0664836,  1516.3811070,  1524.7071438,
     1533.0445627,  1541.3933328,  1549.7534233,  1558.1248036,
     1566.5074433,  1574.9013124,  1583.3063807,  1591.7226186,
     1600.1499965,  1608.5884850,  1617.0380549,  1625.4986772,
     1633.9703232,  1642.4529642,  1650.9465718,  1659.4511177,
     1667.9665739,  1676.4929125,  1685.0301058,  1693.5781262,
     1702.1369465,  1710.7065393,  1719.2868777,  1727.8779349,
     1736.4796841,  1745.0920989,  1753.7151529,  1762.3488199,
     1770.9930739,  1779.6478889,  1788.3132394,  1796.9890997,
     1805.6754445,  1814.3722485,  1823.0794865,  1831.7971337,
     1840.5251653,  1849.2635565,  1858.0122829,  1866.7713202,
     1875.5406441,  1884.3202305,  1893.1100555,  1901.9100954,
     1910.7203263,  1919.5407249,  1928.3712678,  1937.2119316,
     1946.0626932,  1954.9235298,  1963.7944183,  1972.6753362,
     1981.5662607,  1990.4671694,  1999.3780400,  2008.2988502,
     2017.2295780,  2026.1702013,  2035.1206983,  2044.0810473,
     2053.0512267,  2062.0312148,  2071.0209905,  2080.0205323,
     2089.0298192,  2098.0488302,  2107.0775442,  2116.1159404,
     2125.1639983,  2134.2216972,  2143.2890165,  2152.3659360,
     2161.4524354,  2170.5484945,  2179.6540933,  2188.7692117,
     2197.8938301,  2207.0279286,  2216.1714876,  2225.3244875,
     2234.4869090,  2243.6587327,  2252.8399393,  2262.0305097,
     2271.2304249,  2280.4396659,  2289.6582139,  2298.8860501,
     2308.1231559,  2317.3695127,  2326.6251019,  2335.8899054,
     2345.1639046,  2354.4470815,  2363.7394180,  2373.0408959,
     2382.3514975,  2391.6712048,  2401.0000000,  2410.3378655,
     2419.6847838,  2429.0407373,  2438.4057086,  2447.7796803,
     2457.1626352,  2466.5545562,  2475.9554262,  2485.3652281,
     2494.7839450,  2504.2115601,  2513.6480566,  2523.0934179,
     2532.5476273,  2542.0106682,  2551.4825244,  2560.9631792,
     2570.4526166,  2579.9508201,  2589.4577738,  2598.9734614,
     2608.4978671,  2618.0309748,  2627.5727687,  2637.1232331,
     2646.6823521,  2656.2501103,  2665.8264919,  2675.4114815,
     2685.0050637,  2694.6072231,  2704.2179443,  2713.8372123,
     2723.4650117,  2733.1013276,  2742.7461448,  2752.3994485,
     2762.0612237,  2771.7314556,  2781.4101295,  2791.0972306,
     2800.7927443,  2810.4966560,  2820.2089512,  2829.9296156,
     2839.6586345,  2849.3959939,  2859.1416793,  2868.8956767,
     2878.6579717,  2888.4285505,  2898.2073989,  2907.9945030,
     2917.7898488,  2927.5934226,  2937.4052106,  2947.2251989,
     2957.0533740,  2966.8897222,  2976.7342300,  2986.5868839,
     2996.4476703,  3006.3165760,  3016.1935876,  3026.0786917,
     3035.9718753,  3045.8731250,  3055.7824278,  3065.6997706,
     3075.6251404,  3085.5585243,  3095.4999092,  3105.4492825,
     3115.4066312,  3125.3719425,  3135.3452039,  3145.3264026,
     3155.3155261,  3165.3125617,  3175.3174970,  3185.3303196,
     3195.3510169,  3205.3795768,  3215.4159867,  3225.4602346,
     3235.5123081,  3245.5721951,  3255.6398836,  3265.7153613,
     3275.7986164,  3285.8896367,  3295.9884105,  3306.0949257,
     3316.2091706,  3326.3311334,  3336.4608022,  3346.5981655,
     3356.7432115,  3366.8959286,  3377.0563052,  3387.2243299,
     3397.3999911,  3407.5832773,  3417.7741773,  3427.9726795,
     3438.1787728,  3448.3924458,  3458.6136872,  3468.8424860,
     3479.0788309,  3489.3227109,  3499.5741148,  3509.8330317,
     3520.0994506,  3530.3733604,  3540.6547503,  3550.9436095,
     3561.2399271,  3571.5436923,  3581.8548943,  3592.1735225,
     3602.4995662,  3612.8330147,  3623.1738574,  3633.5220839,
     3643.8776835,  3654.2406458,  3664.6109603,  3674.9886166,
     3685.3736044,  3695.7659132,  3706.1655329,  3716.5724532,
     3726.9866637,  3737.4081544,  3747.8369150,  3758.2729355,
     3768.7162058,  3779.1667157,  3789.6244554,  3800.0894147,
     3810.5615838,  3821.0409528,  3831.5275117,  3842.0212507,
     3852.5221601,  3863.0302299,  3873.5454506,  3884.0678123,
     3894.5973054,  3905.1339203,  3915.6776473,  3926.2284768,
     3936.7863993,  3947.3514054,  3957.9234854,  3968.5026299,
     3979.0888296,  3989.6820750,  4000.2823568,  4010.8896656,
     4021.5039921,  4032.1253271,  4042.7536614,  4053.3889857,
     4064.0312908,  4074.6805676,  4085.3368071,  4096.0000000,
};

/**
 * Table of pow(2, (i - 200)/4.) used for different purposes depending on the
 * range of indices to the table:
 * [ 0, 255] scale factor decoding when using C dsp.float_to_int16
 * [60, 315] scale factor decoding when using SIMD dsp.float_to_int16
 * [45, 300] intensity stereo position decoding mapped in reverse order i.e. 0->300, 1->299, ..., 254->46, 255->45
 */
const float ff_aac_pow2sf_tab[316] = {
    8.88178420e-16, 1.05622810e-15, 1.25607397e-15, 1.49373210e-15,
    1.77635684e-15, 2.11245619e-15, 2.51214793e-15, 2.98746420e-15,
    3.55271368e-15, 4.22491238e-15, 5.02429587e-15, 5.97492839e-15,
    7.10542736e-15, 8.44982477e-15, 1.00485917e-14, 1.19498568e-14,
    1.42108547e-14, 1.68996495e-14, 2.00971835e-14, 2.38997136e-14,
    2.84217094e-14, 3.37992991e-14, 4.01943669e-14, 4.77994272e-14,
    5.68434189e-14, 6.75985982e-14, 8.03887339e-14, 9.55988543e-14,
    1.13686838e-13, 1.35197196e-13, 1.60777468e-13, 1.91197709e-13,
    2.27373675e-13, 2.70394393e-13, 3.21554936e-13, 3.82395417e-13,
    4.54747351e-13, 5.40788785e-13, 6.43109871e-13, 7.64790834e-13,
    9.09494702e-13, 1.08157757e-12, 1.28621974e-12, 1.52958167e-12,
    1.81898940e-12, 2.16315514e-12, 2.57243948e-12, 3.05916334e-12,
    3.63797881e-12, 4.32631028e-12, 5.14487897e-12, 6.11832668e-12,
    7.27595761e-12, 8.65262056e-12, 1.02897579e-11, 1.22366534e-11,
    1.45519152e-11, 1.73052411e-11, 2.05795159e-11, 2.44733067e-11,
    2.91038305e-11, 3.46104823e-11, 4.11590317e-11, 4.89466134e-11,
    5.82076609e-11, 6.92209645e-11, 8.23180635e-11, 9.78932268e-11,
    1.16415322e-10, 1.38441929e-10, 1.64636127e-10, 1.95786454e-10,
    2.32830644e-10, 2.76883858e-10, 3.29272254e-10, 3.91572907e-10,
    4.65661287e-10, 5.53767716e-10, 6.58544508e-10, 7.83145814e-10,
    9.31322575e-10, 1.10753543e-09, 1.31708902e-09, 1.56629163e-09,
    1.86264515e-09, 2.21507086e-09, 2.63417803e-09, 3.13258326e-09,
    3.72529030e-09, 4.43014173e-09, 5.26835606e-09, 6.26516652e-09,
    7.45058060e-09, 8.86028346e-09, 1.05367121e-08, 1.25303330e-08,
    1.49011612e-08, 1.77205669e-08, 2.10734243e-08, 2.50606661e-08,
    2.98023224e-08, 3.54411338e-08, 4.21468485e-08, 5.01213321e-08,
    5.96046448e-08, 7.08822677e-08, 8.42936970e-08, 1.00242664e-07,
    1.19209290e-07, 1.41764535e-07, 1.68587394e-07, 2.00485328e-07,
    2.38418579e-07, 2.83529071e-07, 3.37174788e-07, 4.00970657e-07,
    4.76837158e-07, 5.67058141e-07, 6.74349576e-07, 8.01941314e-07,
    9.53674316e-07, 1.13411628e-06, 1.34869915e-06, 1.60388263e-06,
    1.90734863e-06, 2.26823256e-06, 2.69739830e-06, 3.20776526e-06,
    3.81469727e-06, 4.53646513e-06, 5.39479661e-06, 6.41553051e-06,
    7.62939453e-06, 9.07293026e-06, 1.07895932e-05, 1.28310610e-05,
    1.52587891e-05, 1.81458605e-05, 2.15791864e-05, 2.56621220e-05,
    3.05175781e-05, 3.62917210e-05, 4.31583729e-05, 5.13242441e-05,
    6.10351562e-05, 7.25834421e-05, 8.63167458e-05, 1.02648488e-04,
    1.22070312e-04, 1.45166884e-04, 1.72633492e-04, 2.05296976e-04,
    2.44140625e-04, 2.90333768e-04, 3.45266983e-04, 4.10593953e-04,
    4.88281250e-04, 5.80667537e-04, 6.90533966e-04, 8.21187906e-04,
    9.76562500e-04, 1.16133507e-03, 1.38106793e-03, 1.64237581e-03,
    1.95312500e-03, 2.32267015e-03, 2.76213586e-03, 3.28475162e-03,
    3.90625000e-03, 4.64534029e-03, 5.52427173e-03, 6.56950324e-03,
    7.81250000e-03, 9.29068059e-03, 1.10485435e-02, 1.31390065e-02,
    1.56250000e-02, 1.85813612e-02, 2.20970869e-02, 2.62780130e-02,
    3.12500000e-02, 3.71627223e-02, 4.41941738e-02, 5.25560260e-02,
    6.25000000e-02, 7.43254447e-02, 8.83883476e-02, 1.05112052e-01,
    1.25000000e-01, 1.48650889e-01, 1.76776695e-01, 2.10224104e-01,
    2.50000000e-01, 2.97301779e-01, 3.53553391e-01, 4.20448208e-01,
    5.00000000e-01, 5.94603558e-01, 7.07106781e-01, 8.40896415e-01,
    1.00000000e+00, 1.18920712e+00, 1.41421356e+00, 1.68179283e+00,
    2.00000000e+00, 2.37841423e+00, 2.82842712e+00, 3.36358566e+00,
    4.00000000e+00, 4.75682846e+00, 5.65685425e+00, 6.72717132e+00,
    8.00000000e+00, 9.51365692e+00, 1.13137085e+01, 1.34543426e+01,
    1.60000000e+01, 1.90273138e+01, 2.26274170e+01, 2.69086853e+01,
    3.20000000e+01, 3.80546277e+01, 4.52548340e+01, 5.38173706e+01,
    6.40000000e+01, 7.61092554e+01, 9.05096680e+01, 1.07634741e+02,
    1.28000000e+02, 1.52218511e+02, 1.81019336e+02, 2.15269482e+02,
    2.56000000e+02, 3.04437021e+02, 3.62038672e+02, 4.30538965e+02,
    5.12000000e+02, 6.08874043e+02, 7.24077344e+02, 8.61077929e+02,
    1.02400000e+03, 1.21774809e+03, 1.44815469e+03, 1.72215586e+03,
    2.04800000e+03, 2.43549617e+03, 2.89630938e+03, 3.44431172e+03,
    4.09600000e+03, 4.87099234e+03, 5.79261875e+03, 6.88862343e+03,
    8.19200000e+03, 9.74198469e+03, 1.15852375e+04, 1.37772469e+04,
    1.63840000e+04, 1.94839694e+04, 2.31704750e+04, 2.75544937e+04,
    3.27680000e+04, 3.89679387e+04, 4.63409500e+04, 5.51089875e+04,
    6.55360000e+04, 7.79358775e+04, 9.26819000e+04, 1.10217975e+05,
    1.31072000e+05, 1.55871755e+05, 1.85363800e+05, 2.20435950e+05,
    2.62144000e+05, 3.11743510e+05, 3.70727600e+05, 4.40871900e+05,
    5.24288000e+05, 6.23487020e+05, 7.41455200e+05, 8.81743800e+05,
    1.04857600e+06, 1.24697404e+06, 1.48291040e+06, 1.76348760e+06,
    2.09715200e+06, 2.49394808e+06, 2.96582080e+06, 3.52697520e+06,
    4.19430400e+06, 4.98789616e+06, 5.93164160e+06, 7.05395040e+06,
    8.38860800e+06, 9.97579232e+06, 1.18632832e+07, 1.41079008e+07,
    1.67772160e+07, 1.99515846e+07, 2.37265664e+07, 2.82158016e+07,
    3.35544320e+07, 3.99031693e+07, 4.74531328e+07, 5.64316032e+07,
    6.71088640e+07, 7.98063385e+07, 9.49062656e+07, 1.12863206e+08,
    1.34217728e+08, 1.59612677e+08, 1.89812531e+08, 2.25726413e+08,
    2.68435456e+08, 3.19225354e+08, 3.79625062e+08, 4.51452825e+08,
};

#endif /* CONFIG_HARDCODED_TABLES */
