/*
 * gcc fixes for altivec.
 * Used to workaround broken gcc (FSF gcc-3 pre gcc-3.3) 
 * and to stay somewhat compatible with Darwin.
 */

#ifndef _GCC_FIXES_
#define _GCC_FIXES_

#ifdef HAVE_ALTIVEC_H
#include <altivec.h>
#endif

#ifdef CONFIG_DARWIN
#define AVV(x...) (x)
/* The Apple assembler shipped w/ gcc-3.3 knows about DCBZL, previous assemblers don't
   We assume here that the Darwin GCC is from Apple.... */
#if (__GNUC__ * 100 + __GNUC_MINOR__ < 303)
#define NO_DCBZL
#endif
#else
#define AVV(x...) {x}
/* I don't think any non-Apple assembler knows about DCBZL */
#define NO_DCBZL
#if (__GNUC__ * 100 + __GNUC_MINOR__ < 303)  

/* This code was provided to me by Bartosch Pixa
 * as a separate header file (broken_mergel.h).
 * thanks to lu_zero for the workaround.
 *
 * See this mail for more information:
 * http://gcc.gnu.org/ml/gcc/2003-04/msg00967.html
 */

static inline vector signed char my_vmrglb (vector signed char const A,
					  vector signed char const B)
{
    static const vector unsigned char lowbyte = {
	0x08, 0x18, 0x09, 0x19, 0x0a, 0x1a, 0x0b,  0x1b,
	0x0c, 0x1c, 0x0d, 0x1d, 0x0e, 0x1e, 0x0f, 0x1f
    };
    return vec_perm (A, B, lowbyte);
}

static inline vector signed short my_vmrglh (vector signed short const A,
					  vector signed short const B)
{
    static const vector unsigned char lowhalf = {
    	0x08, 0x09, 0x18, 0x19, 0x0a, 0x0b, 0x1a, 0x1b,
	0x0c, 0x0d, 0x1c, 0x1d, 0x0e, 0x0f, 0x1e, 0x1f
    };
    return vec_perm (A, B, lowhalf);
}

static inline vector signed int my_vmrglw (vector signed int const A,
					  vector signed int const B)
{
    static const vector unsigned char lowword = {
    	0x08, 0x09, 0x0a, 0x0b, 0x18, 0x19, 0x1a, 0x1b,
	0x0c, 0x0d, 0x0e, 0x0f, 0x1c, 0x1d, 0x1e, 0x1f
    };
    return vec_perm (A, B, lowword);
}
/*#define my_vmrglb my_vmrglb 
#define my_vmrglh my_vmrglh 
#define my_vmrglw my_vmrglw 
*/
#undef vec_mergel

#define vec_mergel(a1, a2) \
__ch (__bin_args_eq (vector signed char, (a1), vector signed char, (a2)), \
      ((vector signed char) my_vmrglb ((vector signed char) (a1), (vector signed char) (a2))), \
__ch (__bin_args_eq (vector unsigned char, (a1), vector unsigned char, (a2)), \
      ((vector unsigned char) my_vmrglb ((vector signed char) (a1), (vector signed char) (a2))), \
__ch (__bin_args_eq (vector signed short, (a1), vector signed short, (a2)), \
      ((vector signed short) my_vmrglh ((vector signed short) (a1), (vector signed short) (a2))), \
__ch (__bin_args_eq (vector unsigned short, (a1), vector unsigned short, (a2)), \
      ((vector unsigned short) my_vmrglh ((vector signed short) (a1), (vector signed short) (a2))), \
__ch (__bin_args_eq (vector float, (a1), vector float, (a2)), \
      ((vector float) my_vmrglw ((vector signed int) (a1), (vector signed int) (a2))), \
__ch (__bin_args_eq (vector signed int, (a1), vector signed int, (a2)), \
      ((vector signed int) my_vmrglw ((vector signed int) (a1), (vector signed int) (a2))), \
__ch (__bin_args_eq (vector unsigned int, (a1), vector unsigned int, (a2)), \
      ((vector unsigned int) my_vmrglw ((vector signed int) (a1), (vector signed int) (a2))), \
    __altivec_link_error_invalid_argument ())))))))

#endif

#endif /* CONFIG_DARWIN */

#endif /* _GCC_FIXES_ */
