/*
 * Musepack decoder
 * Copyright (c) 2006 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef FFMPEG_MPCDATA_H
#define FFMPEG_MPCDATA_H

#include <stdint.h>

static const int8_t mpc_idx30[] = { -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1};
static const int8_t mpc_idx31[] = { -1,-1,-1, 0, 0, 0, 1, 1, 1,-1,-1,-1, 0, 0, 0, 1, 1, 1,-1,-1,-1, 0, 0, 0, 1, 1, 1};
static const int8_t mpc_idx32[] = { -1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1};
static const int8_t mpc_idx50[] = { -2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2,-2,-1, 0, 1, 2};
static const int8_t mpc_idx51[] = { -2,-2,-2,-2,-2,-1,-1,-1,-1,-1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2};

static const float mpc_CC[18] = {
    65536.0000, 21845.3333, 13107.2000, 9362.2857, 7281.7778, 4369.0667, 2114.0645,
    1040.2539, 516.0315, 257.0039, 128.2505, 64.0626, 32.0156, 16.0039, 8.0010,
    4.0002, 2.0001, 1.0000
};

#define MPC7_SCFI_SIZE  4
#define MPC7_SCFI_BITS  3
static const uint8_t mpc7_scfi[MPC7_SCFI_SIZE * 2] = {
    0x2, 3, 0x1, 1, 0x3, 3, 0x0, 2
};

#define MPC7_DSCF_SIZE 16
#define MPC7_DSCF_BITS  6
static const uint8_t mpc7_dscf[MPC7_DSCF_SIZE * 2] = {
    0x20, 6, 0x04, 5, 0x11, 5, 0x1E, 5, 0x0D, 4, 0x00, 3, 0x03, 3, 0x09, 4,
    0x05, 3, 0x02, 3, 0x0E, 4, 0x03, 4, 0x1F, 5, 0x05, 5, 0x21, 6, 0x0C, 4
};

#define MPC7_HDR_SIZE  10
#define MPC7_HDR_BITS   9
static const uint8_t mpc7_hdr[MPC7_HDR_SIZE * 2] = {
    0x5C, 8, 0x2F, 7, 0x0A, 5, 0x04, 4, 0x00, 2,
    0x01, 1, 0x03, 3, 0x16, 6, 0xBB, 9, 0xBA, 9
};

#define MPC7_QUANT_VLC_TABLES 7
static const uint8_t mpc7_quant_vlc_sizes[MPC7_QUANT_VLC_TABLES * 2] = {
    27, 25, 7, 9, 15, 31, 63
};

static const uint8_t mpc7_quant_vlc_off[MPC7_QUANT_VLC_TABLES] = {
    0, 0, 3, 4, 7, 15, 31
};

static const uint16_t mpc7_quant_vlc[MPC7_QUANT_VLC_TABLES][2][64 * 2] = {
{
    {
        0x0036,  6, 0x0009,  5, 0x0020,  6, 0x0005,  5, 0x000A,  4, 0x0007,  5,
        0x0034,  6, 0x0000,  5, 0x0023,  6, 0x000A,  5, 0x0006,  4, 0x0004,  5,
        0x000B,  4, 0x0007,  3, 0x000C,  4, 0x0003,  5, 0x0007,  4, 0x000B,  5,
        0x0022,  6, 0x0001,  5, 0x0035,  6, 0x0006,  5, 0x0009,  4, 0x0002,  5,
        0x0021,  6, 0x0008,  5, 0x0037,  6
    },
    {
        0x0067,  8, 0x003E,  7, 0x00E1,  9, 0x0037,  7, 0x0003,  4, 0x0034,  7,
        0x0065,  8, 0x003C,  7, 0x00E3,  9, 0x0018,  6, 0x0000,  4, 0x003D,  7,
        0x0004,  4, 0x0001,  1, 0x0005,  4, 0x003F,  7, 0x0001,  4, 0x003B,  7,
        0x00E2,  9, 0x0039,  7, 0x0064,  8, 0x0035,  7, 0x0002,  4, 0x0036,  7,
        0x00E0,  9, 0x003A,  7, 0x0066,  8
    }
},
{
    {
        0x0059,  7, 0x002F,  6, 0x000F,  5, 0x0000,  5, 0x005B,  7, 0x0004,  5,
        0x0006,  4, 0x000D,  4, 0x0004,  4, 0x0005,  5, 0x0014,  5, 0x000C,  4,
        0x0004,  3, 0x000F,  4, 0x000E,  5, 0x0003,  5, 0x0003,  4, 0x000E,  4,
        0x0005,  4, 0x0001,  5, 0x005A,  7, 0x0002,  5, 0x0015,  5, 0x002E,  6,
        0x0058,  7
    },
    {
        0x0399, 10, 0x0071,  7, 0x0033,  6, 0x00E7,  8, 0x039A, 10, 0x0068,  7,
        0x001E,  5, 0x0000,  3, 0x001D,  5, 0x0069,  7, 0x0032,  6, 0x0001,  3,
        0x0002,  2, 0x0003,  3, 0x0031,  6, 0x006B,  7, 0x001B,  5, 0x0002,  3,
        0x001F,  5, 0x0070,  7, 0x0398, 10, 0x006A,  7, 0x0030,  6, 0x0072,  7,
        0x039B, 10
    }
},
{
    {
        0x000C,  4, 0x0004,  3, 0x0000,  2, 0x0001,  2, 0x0007,  3, 0x0005,  3, 0x000D,  4
    },
    {
        0x0004,  5, 0x0003,  4, 0x0002,  2, 0x0003,  2, 0x0001,  2, 0x0000,  3, 0x0005,  5
    }
},
{
    {
        0x0005,  4, 0x0000,  3, 0x0004,  3, 0x0006,  3, 0x0007,  3, 0x0005,  3, 0x0003,  3, 0x0001,  3, 0x0004,  4
    },
    {
        0x0009,  5, 0x000C,  4, 0x0003,  3, 0x0000,  2, 0x0002,  2, 0x0007,  3, 0x000D,  4, 0x0005,  4, 0x0008,  5
    }
},
{
    {
        0x0039,  6, 0x0017,  5, 0x0008,  4, 0x000A,  4, 0x000D,  4, 0x0000,  3,
        0x0002,  3, 0x0003,  3, 0x0001,  3, 0x000F,  4, 0x000C,  4, 0x0009,  4,
        0x001D,  5, 0x0016,  5, 0x0038,  6,
    },
    {
        0x00E5,  8, 0x0038,  6, 0x0007,  5, 0x0002,  4, 0x0000,  3, 0x0003,  3,
        0x0005,  3, 0x0006,  3, 0x0004,  3, 0x0002,  3, 0x000F,  4, 0x001D,  5,
        0x0006,  5, 0x0073,  7, 0x00E4,  8,
    },
},
{
    {
        0x0041,  7, 0x0006,  6, 0x002C,  6, 0x002D,  6, 0x003B,  6, 0x000D,  5,
        0x0011,  5, 0x0013,  5, 0x0017,  5, 0x0015,  5, 0x001A,  5, 0x001E,  5,
        0x0000,  4, 0x0002,  4, 0x0005,  4, 0x0007,  4, 0x0003,  4, 0x0004,  4,
        0x001F,  5, 0x001C,  5, 0x0019,  5, 0x001B,  5, 0x0018,  5, 0x0014,  5,
        0x0012,  5, 0x000C,  5, 0x0002,  5, 0x003A,  6, 0x0021,  6, 0x0007,  6,
        0x0040,  7
    },
    {
        0x1948, 13, 0x194A, 13, 0x0328, 10, 0x0195,  9, 0x00CB,  8, 0x0066,  7,
        0x0031,  6, 0x0009,  5, 0x000F,  5, 0x001F,  5, 0x0002,  4, 0x0006,  4,
        0x0008,  4, 0x000B,  4, 0x000D,  4, 0x0000,  3, 0x000E,  4, 0x000A,  4,
        0x0009,  4, 0x0005,  4, 0x0003,  4, 0x001E,  5, 0x000E,  5, 0x0008,  5,
        0x0030,  6, 0x0067,  7, 0x00C9,  8, 0x00C8,  8, 0x0653, 11, 0x1949, 13,
        0x194B, 13
    }
},
{
    {
        0x0067,  8, 0x0099,  8, 0x00B5,  8, 0x00E9,  8, 0x0040,  7, 0x0041,  7,
        0x004D,  7, 0x0051,  7, 0x005B,  7, 0x0071,  7, 0x0070,  7, 0x0018,  6,
        0x001D,  6, 0x0023,  6, 0x0025,  6, 0x0029,  6, 0x002C,  6, 0x002E,  6,
        0x0033,  6, 0x0031,  6, 0x0036,  6, 0x0037,  6, 0x0039,  6, 0x003C,  6,
        0x0000,  5, 0x0002,  5, 0x000A,  5, 0x0005,  5, 0x0009,  5, 0x0006,  5,
        0x000D,  5, 0x0007,  5, 0x000B,  5, 0x000F,  5, 0x0008,  5, 0x0004,  5,
        0x0003,  5, 0x0001,  5, 0x003F,  6, 0x003E,  6, 0x003D,  6, 0x0035,  6,
        0x003B,  6, 0x0034,  6, 0x0030,  6, 0x002F,  6, 0x002B,  6, 0x002A,  6,
        0x0027,  6, 0x0024,  6, 0x0021,  6, 0x001C,  6, 0x0075,  7, 0x0065,  7,
        0x0064,  7, 0x0050,  7, 0x0045,  7, 0x0044,  7, 0x0032,  7, 0x00E8,  8,
        0x00B4,  8, 0x0098,  8, 0x0066,  8
    },
    {
        0x37A4, 14, 0x37AD, 14, 0x37A6, 14, 0x37AE, 14, 0x0DEA, 12, 0x02F0, 10,
        0x02F1, 10, 0x00A0,  9, 0x00A2,  9, 0x01BC,  9, 0x007A,  8, 0x00DF,  8,
        0x003C,  7, 0x0049,  7, 0x006E,  7, 0x000E,  6, 0x0018,  6, 0x0019,  6,
        0x0022,  6, 0x0025,  6, 0x0036,  6, 0x0003,  5, 0x0009,  5, 0x000B,  5,
        0x0010,  5, 0x0013,  5, 0x0015,  5, 0x0018,  5, 0x001A,  5, 0x001D,  5,
        0x001F,  5, 0x0002,  4, 0x0000,  4, 0x001E,  5, 0x001C,  5, 0x0019,  5,
        0x0016,  5, 0x0014,  5, 0x000E,  5, 0x000D,  5, 0x0008,  5, 0x0006,  5,
        0x0002,  5, 0x002E,  6, 0x0023,  6, 0x001F,  6, 0x0015,  6, 0x000F,  6,
        0x005F,  7, 0x0048,  7, 0x0029,  7, 0x00BD,  8, 0x007B,  8, 0x0179,  9,
        0x00A1,  9, 0x037B, 10, 0x0147, 10, 0x0146, 10, 0x0DE8, 12, 0x37AF, 14,
        0x37A7, 14, 0x37AC, 14, 0x37A5, 14
    }
}
};

static const float mpc7_SCF[128] = {
    307.330047607421875000, 255.999984741210937500, 213.243041992187500000, 177.627334594726562500,
    147.960128784179687500, 123.247924804687500000, 102.663139343261718750, 85.516410827636718750,
    71.233520507812500000, 59.336143493652343750, 49.425861358642578125, 41.170787811279296875,
    34.294471740722656250, 28.566631317138671875, 23.795452117919921875, 19.821151733398437500,
    16.510635375976562500, 13.753040313720703125, 11.456016540527343750, 9.542640686035156250,
    7.948835372924804688, 6.621226310729980469, 5.515353679656982422, 4.594182968139648438,
    3.826865673065185547, 3.187705039978027344, 2.655296564102172852, 2.211810588836669922,
    1.842395424842834473, 1.534679770469665527, 1.278358578681945801, 1.064847946166992188,
    0.886997759342193604, 0.738851964473724365, 0.615449428558349609, 0.512657463550567627,
    0.427033752202987671, 0.355710864067077637, 0.296300262212753296, 0.246812388300895691,
    0.205589950084686279, 0.171252459287643433, 0.142649993300437927, 0.118824683129787445,
    0.098978661000728607, 0.082447312772274017, 0.068677015602588654, 0.057206626981496811,
    0.047652013599872589, 0.039693206548690796, 0.033063672482967377, 0.027541399002075195,
    0.022941453382372856, 0.019109787419438362, 0.015918083488941193, 0.013259455561637878,
    0.011044870130717754, 0.009200163185596466, 0.007663558237254620, 0.006383595988154411,
    0.005317411851137877, 0.004429301247000694, 0.003689522389322519, 0.003073300700634718,
    0.002560000168159604, 0.002132430672645569, 0.001776273478753865, 0.001479601487517357,
    0.001232479466125369, 0.001026631565764546, 0.000855164253152907, 0.000712335284333676,
    0.000593361502978951, 0.000494258652906865, 0.000411707907915115, 0.000342944724252447,
    0.000285666319541633, 0.000237954518524930, 0.000198211506358348, 0.000165106350323185,
    0.000137530398205854, 0.000114560163638089, 0.000095426403277088, 0.000079488345363643,
    0.000066212254751008, 0.000055153526773211, 0.000045941822463647, 0.000038268648495432,
    0.000031877043511486, 0.000026552961571724, 0.000022118103515822, 0.000018423952496960,
    0.000015346795407822, 0.000012783583770215, 0.000010648477655195, 0.000008869976227288,
    0.000007388518497464, 0.000006154492893984, 0.000005126573796588, 0.000004270336830814,
    0.000003557107902452, 0.000002963002089018, 0.000002468123511790, 0.000002055899130937,
    0.000001712524181130, 0.000001426499579793, 0.000001188246528727, 0.000000989786371974,
    0.000000824472920158, 0.000000686770022185, 0.000000572066142013, 0.000000476520028769,
    0.000000396931966407, 0.000000330636652279, 0.000000275413924555, 0.000000229414467867,
    0.000000191097811353, 0.000000159180785886, 0.000000132594522029, 0.000000110448674207,
    0.000000092001613439, 0.000000076635565449, 0.000000063835940978, 0.000000053174105119,
    0.000000044293003043, 0.000000036895215771, 0.000000030733001921, 0.000000025599996789
};

#endif /* FFMPEG_MPCDATA_H */
