/*
 * Real Audio 1.0 (14.4K)
 * Copyright (c) 2003 the ffmpeg project
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_RA144_H
#define AVCODEC_RA144_H

#include <stdint.h>

/* 14.4 data tables */
static const int16_t gain_val_tab[256][3] = {
    {541,  956,  768}, {877,  581,  568}, {675,  787,  635}, {624,  732,  668},
    {623,  839,  697}, {640,  693,  991}, {925,  687,  608}, {552,  797,  572},
    {535,  832,  799}, {762,  605,  577}, {832,  561, 1003}, {590,  687,  588},
    {646,  901,  732}, {828,  689,  896}, {875,  624,  848}, {571,  942, 1022},
    {824,  736,  643}, {517,  765,  512}, {562,  908,  761}, {694,  913,  675},
    {704,  524,  672}, {721,  757,  558}, {884,  551,  633}, {558, 1007,  846},
    {932,  746,  777}, {566,  822,  926}, {613,  771,  611}, {737,  671, 1008},
    {651,  594,  579}, {801,  636,  564}, {852,  910,  719}, {998,  614,  575},
    {665,  935,  628}, {631,  596,  829}, {644,  926,  526}, {879,  988,  613},
    {941,  692,  693}, {565,  672,  576}, {547,  628,  740}, {639,  532,  537},
    {955,  604,  598}, {562,  580,  900}, {603,  899,  621}, {746,  533,  624},
    {729,  514,  735}, {853,  551,  692}, {949, 1018, 1004}, {544,  988,  735},
    {789,  782,  821}, {897,  516,  754}, {517,  702,  828}, {586,  818,  763},
    {907,  652,  592}, {528,  652,  642}, {531,  708,  780}, {666,  625,  727},
    {947,  727,  554}, {549,  657,  981}, {605,  920,  852}, {624,  619,  983},
    {605,  909,  547}, {690,  935,  516}, {700,  612,  853}, {767,  832,  574},
    {523,  898,  923}, {722,  958,  691}, {613,  771,  928}, {758,  757,  584},
    {512,  567,  577}, {615,  638,  698}, {574,  642,  589}, {993,  682,  878},
    {539,  890,  913}, {694,  928,  544}, {805,  600,  680}, {540,  951,  782},
    {816,  950,  590}, {955,  847,  811}, {547,  883,  556}, {652,  888,  604},
    {863,  585,  855}, {1023, 997,  516}, {932,  614,  640}, {627,  564,  573},
    {876,  900,  724}, {515,  857,  896}, {647,  953,  879}, {806,  854,  857},
    {545,  583,  631}, {657,  601,  751}, {740,  905,  795}, {841, 1016,  568},
    {747,  589,  983}, {878,  613,  526}, {864,  723,  779}, {534,  674,  774},
    {950,  649,  939}, {590,  703,  899}, {618,  527,  579}, {725,  647,  972},
    {641,  647,  707}, {730,  663,  644}, {807,  572,  578}, {879,  611,  821},
    {667,  729,  841}, {782,  585,  751}, {802,  733,  976}, {850,  871,  708},
    {870,  743,  704}, {941,  899,  585}, {943,  632,  875}, {1023, 732,  638},
    {778,  753,  655}, {843,  945,  945}, {942,  969,  572}, {1008, 559,  854},
    {868,  729,  787}, {970,  686,  547}, {535,  635,  674}, {560,  636,  828},
    {994,  592,  833}, {548,  621,  694}, {550,  801,  955}, {582,  522,  646},
    {606,  625,  818}, {623,  591,  874}, {669,  535, 1001}, {701,  938,  592},
    {925,  820,  738}, {735,  790,  544}, {575,  788,  674}, {655,  783,  528},
    {527,  513,  677}, {782,  852,  940}, {578,  910,  513}, {692,  882,  734},
    {586,  683,  715}, {739,  609,  717}, {778,  773,  697}, {922,  785,  813},
    {766,  651,  984}, {978,  596,  515}, {535,  757,  540}, {662,  687,  589},
    {554,  536,  979}, {723,  982,  690}, {936,  956,  527}, {590, 1002,  547},
    {517,  653,  825}, {832,  592,  974}, {512,  957,  903}, {631,  545,  906},
    {514,  720,  649}, {596,  679,  694}, {617,  740,  979}, {711,  685,  877},
    {655,  835,  848}, {754,  839,  698}, {871,  515,  769}, {955,  852,  573},
    {640,  859,  587}, {792,  863,  554}, {843,  708,  682}, {971,  768,  552},
    {891,  536,  690}, {1016, 560,  663}, {543,  870,  674}, {601,  999,  585},
    {945,  966,  889}, {529,  912,  777}, {574, 1020,  714}, {609,  922,  932},
    {598,  778,  929}, {651,  772,  744}, {691,  957,  722}, {729,  766,  984},
    {547,  519,  632}, {583,  532,  922}, {633,  995,  603}, {677,  571,  874},
    {602,  545,  666}, {627,  542,  875}, {672,  983,  598}, {692,  979,  730},
    {668,  634,  872}, {711,  706,  674}, {739,  977,  595}, {759,  905,  763},
    {756,  582,  763}, {748, 1013,  908}, {804,  937,  950}, {785,  543,  998},
    {999,  684,  942}, {626,  633,  996}, {626,  567,  835}, {739,  571,  973},
    {655,  769,  707}, {702,  952,  571}, {727,  712,  514}, {744,  686,  741},
    {731,  552,  714}, {824,  991,  726}, {795,  615,  544}, {870,  575,  824},
    {803,  832,  923}, {819,  839,  531}, {887,  786,  852}, {933,  764,  570},
    {716,  906,  654}, {784,  804,  563}, {774,  535,  876}, {807,  598,  649},
    {817,  759,  718}, {831,  993,  846}, {858,  567,  605}, {876, 1012,  651},
    {852,  548,  549}, {895, 1008,  871}, {892, 1000,  591}, {935,  516,  836},
    {931,  612,  776}, {968,  614,  816}, {524,  777,  719}, {549,  694,  786},
    {882,  754,  534}, {597,  837,  766}, {635,  954,  704}, {803,  550,  798},
    {699,  654,  798}, {924,  767,  738}, {970,  675,  608}, {632,  706,  684},
    {858,  767,  563}, {527,  765,  702}, {559,  924, 1003}, {618,  524,  611},
    {999,  942,  963}, {547,  857,  935}, {734,  926,  569}, {967,  746,  551},
    {834,  633,  881}, {941,  701,  727}, {945,  564,  636}, {512,  563,  793},
    {984,  556,  570}, {984,  540,  740}, {527,  764,  874}, {530,  664, 1014},
    {546,  515,  521}, {554,  934,  672}, {598,  945,  556}, {627,  531,  733},
    {576, 1020, 1014}, {623,  924,  594}, {678,  909,  603}, {814,  744,  543}
};

static const uint8_t gain_exp_tab[256][3] = {
    {14, 14, 14}, {14, 14, 14}, {14, 13, 14}, {13, 13, 14},
    {13, 14, 13}, {13, 14, 15}, {13, 13, 13}, {12, 14, 13},
    {13, 13, 13}, {13, 13, 12}, {13, 12, 13}, {12, 13, 12},
    {12, 13, 13}, {12, 13, 13}, {12, 12, 13}, {11, 13, 13},
    {13, 12, 13}, {12, 12, 12}, {13, 12, 12}, {13, 12, 11},
    {12, 12, 12}, {12, 13, 11}, {12, 12, 11}, {11, 13, 12},
    {12, 12, 12}, {11, 12, 12}, {11, 12, 12}, {11, 12, 13},
    {11, 12, 11}, {11, 12, 11}, {11, 13, 12}, {11, 12, 12},
    {12, 12, 12}, {12, 11, 12}, {12, 12, 11}, {12, 12, 11},
    {13, 11, 11}, {12, 11, 10}, {11, 11, 11}, {11, 11, 10},
    {12, 11, 12}, {11, 11, 12}, {11, 12, 11}, {11, 11, 11},
    {11, 11, 12}, {11, 11, 12}, {11, 12, 12}, {10, 12, 12},
    {11, 12, 11}, {11, 11, 11}, {10, 12, 11}, {10, 12, 11},
    {11, 11, 11}, {10, 11, 11}, {10, 11, 12}, {10, 11, 12},
    {11, 12, 11}, {10, 12, 12}, {10, 13, 12}, {10, 12, 13},
    {10, 12, 11}, {10, 12, 11}, {10, 12, 12}, {10, 12, 12},
    {12, 11, 12}, {12, 11, 11}, {11, 11, 12}, {11, 11, 11},
    {11, 10, 11}, {11, 10, 11}, {12, 10, 10}, {12, 10, 10},
    {11, 11, 11}, {11, 11, 10}, {11, 11, 10}, {10, 12, 10},
    {11, 11, 11}, {11, 11, 11}, {10, 11, 11}, {10, 11, 11},
    {11, 10, 11}, {11, 11, 10}, {11, 10, 10}, {10, 10, 10},
    {11, 11, 10}, {10, 11, 10}, {10, 11, 10}, {10, 11, 10},
    {10, 10, 11}, {10, 10, 11}, {10, 11, 11}, {10, 11, 11},
    {10, 10, 11}, {10, 10, 10}, {10, 10, 11}, { 9, 10, 11},
    {11, 11, 11}, {10, 11, 11}, {10, 11, 10}, {10, 11, 11},
    {10, 11, 11}, {10, 11, 11}, {10, 11, 11}, {10, 11, 12},
    {10, 12, 11}, {10, 12, 11}, {10, 12, 12}, {10, 13, 12},
    {10, 12, 11}, {10, 12, 11}, {10, 12, 12}, {10, 12, 12},
    {10, 12, 10}, {10, 12, 11}, {10, 12, 10}, {10, 11, 11},
    {10, 11, 11}, {10, 11, 11}, { 9, 11, 11}, { 9, 11, 12},
    {10, 12, 11}, { 9, 12, 11}, { 9, 12, 12}, { 9, 12, 12},
    { 9, 12, 11}, { 9, 12, 12}, { 9, 12, 12}, { 9, 13, 12},
    {12, 10, 11}, {11, 10, 10}, {10, 10, 11}, {10, 10, 10},
    {11,  9, 10}, {11, 10, 10}, {10, 10,  9}, {10, 10,  9},
    {10, 10, 10}, {10, 10, 10}, {10, 10, 10}, {10, 10, 10},
    {10, 10, 10}, {10, 10,  9}, { 9, 10,  9}, { 9, 10,  9},
    {10,  9, 11}, {10, 10, 10}, {10, 10, 10}, { 9, 10, 10},
    {10,  9, 10}, {10,  9, 10}, { 9, 10, 10}, { 9,  9, 10},
    { 9, 10, 10}, { 9, 10, 10}, { 9, 10, 11}, { 9, 10, 11},
    { 9, 10, 10}, { 9, 10, 10}, { 9,  9, 10}, { 9, 10, 10},
    {10, 11, 10}, {10, 11, 10}, {10, 11, 10}, {10, 11, 10},
    {10, 10, 10}, {10, 10, 10}, { 9, 11, 10}, { 9, 11, 10},
    {10, 11, 11}, { 9, 11, 11}, { 9, 11, 11}, { 9, 11, 12},
    { 9, 11, 11}, { 9, 11, 11}, { 9, 11, 11}, { 9, 11, 12},
    { 9, 11, 10}, { 9, 11, 11}, { 9, 12, 10}, { 9, 11, 11},
    { 9, 11, 11}, { 9, 11, 12}, { 9, 12, 11}, { 9, 12, 12},
    { 9, 12, 11}, { 9, 12, 11}, { 9, 12, 11}, { 9, 12, 12},
    { 9, 12, 11}, { 9, 13, 12}, { 9, 13, 12}, { 9, 12, 13},
    {10, 11, 10}, { 9, 11, 10}, { 9, 10, 10}, { 9, 10, 10},
    { 9, 11, 10}, { 9, 11, 10}, { 9, 11, 10}, { 9, 11, 11},
    { 9, 10, 10}, { 9, 11, 10}, { 9, 10, 10}, { 9, 10, 11},
    { 9, 11, 11}, { 9, 11, 11}, { 9, 11, 11}, { 9, 11, 11},
    { 9, 12, 10}, { 9, 12, 10}, { 9, 11, 11}, { 9, 11, 11},
    { 9, 12, 11}, { 9, 12, 12}, { 9, 12, 11}, { 9, 13, 12},
    { 9, 11, 10}, { 9, 12, 11}, { 9, 12, 11}, { 9, 11, 12},
    { 9, 12, 11}, { 9, 12, 12}, { 8, 12, 11}, { 8, 12, 12},
    {10,  9,  9}, { 9,  9,  9}, { 9, 10,  9}, { 9,  9,  9},
    { 9,  9, 10}, { 9,  9, 10}, { 9,  9,  9}, { 8,  9,  9},
    { 9, 10,  9}, { 8, 10,  9}, { 8, 10, 10}, { 8,  9, 10},
    { 9,  9,  9}, { 7,  8,  8}, { 8, 10,  9}, { 8,  9,  9},
    { 9, 11, 10}, { 9, 11, 10}, { 9, 10, 10}, { 8, 10, 11},
    { 9, 11, 10}, { 9, 11, 11}, { 8, 11, 11}, { 8, 11, 12},
    { 8, 10,  9}, { 8, 11, 10}, { 8, 11, 10}, { 8, 10, 11},
    { 8, 12, 11}, { 8, 12, 11}, { 8, 11, 10}, { 8, 11, 10}
};

static const int8_t cb1_vects[128][40]={
    {
     38,  -4,  15,  -4,  14, -13,  12, -11,  -2,  -6,
     -6, -11, -45, -16, -11, -13,  -7,   6, -12,   4,
    -20,   3, -16,  12,  -1,  12,  46,  24,   0,  33,
     -3,   9, -12, -12,  -8,  -7,  17,  -6,   0,  -2,
    }, {
     60, -16,   3, -22,  10, -32,   0, -28, -17, -18,
     -3, -25, -37, -23, -10,   3,   2,   3,   0,   3,
    -14,   0, -14,  -1,   0,   2,  32,   9,  -1,  25,
      7,  13,  -5,  13,   8,   1,   2,   8, -10,   6,
    }, {
     27, -12,  28,  -2,   6,  -7,  15,   9, -11,   1,
    -13, -11, -40,   4, -29, -14, -19,  -5, -23,  -8,
    -30, -13, -17,   0, -14,  12,  34,  20,  -2,  25,
      2, -16,  -4, -12,  15,  16,  29,   7,  24,  10,
    }, {
     49, -24,  16, -20,   2, -26,   2,  -7, -25, -10,
    -11, -25, -32,  -3, -27,   2,  -8,  -8, -11,  -9,
    -24, -17, -16, -14, -13,   2,  20,   5,  -4,  17,
     14, -12,   3,  13,  33,  25,  14,  23,  15,  19,
    }, {
     46,  -6,  21,   8,  -2, -16,  -5,  -8, -11,   4,
      8,  15, -24,   4,  -2, -26,  -3, -16, -16, -14,
     -9,  -2,  -1,   4,  19,   7,  36,  17,   9,  13,
      0,  31,  -5, -12,   7,  -8,  11, -15, -13,  -4,
    }, {
     68, -18,   9,  -9,  -6, -35, -18, -25, -26,  -7,
     10,   1, -16,  -3,  -1,  -9,   6, -19,  -4, -15,
     -4,  -6,   0,  -8,  20,  -2,  23,   2,   7,   5,
     12,  35,   1,  13,  24,   0,  -3,   0, -22,   4,
    }, {
     35, -14,  34,  10, -10, -10,  -1,  12, -20,  12,
      0,  15, -18,  24, -20, -27, -14, -28, -27, -27,
    -20, -19,  -2,  -8,   5,   7,  25,  13,   5,   5,
      6,   5,   2, -12,  31,  15,  23,  -1,  12,   8,
    }, {
     57, -26,  22,  -7, -14, -28, -14,  -3, -35,   0,
      3,   1, -11,  16, -18, -10,  -4, -31, -15, -28,
    -14, -23,  -1, -21,   7,  -2,  11,  -1,   3,  -1,
     18,   9,  10,  13,  49,  24,   8,  14,   2,  16,
    }, {
     25,  15,  22,  11,  18,   4,  15, -22,   8,  -2,
    -17,  -9, -48, -20, -30, -17, -16,  11,  -1,  16,
      2,  10,  -5,  26,  -2,  -4,  22,   0,   2,  10,
     -6,  13, -14,  10, -23,   0,  10,  -2,   1,   0,
    }, {
     47,   3,  11,  -6,  15, -13,   2, -38,  -6, -13,
    -15, -22, -40, -28, -28,   0,  -5,   8,  10,  15,
      7,   7,  -4,  13,  -1, -14,   9, -14,   0,   2,
      4,  18,  -7,  36,  -6,   8,  -3,  13,  -7,   8,
    }, {
     14,   7,  36,  13,  10,  10,  18,   0,   0,   5,
    -25,  -8, -43,   0, -48, -18, -27,   0, -12,   3,
     -7,  -6,  -7,  13, -15,  -5,  11,  -3,   0,   2,
      0, -12,  -6,  10,   0,  23,  22,  11,  26,  12,
    }, {
     36,  -5,  24,  -4,   7,  -7,   6, -17, -14,  -5,
    -22, -22, -35,  -8, -46,  -1, -17,  -3,   0,   2,
     -2, -10,  -5,   0, -14, -15,  -2, -18,  -2,  -4,
     11,  -7,   1,  36,  18,  32,   7,  27,  17,  20,
    }, {
     33,  13,  29,  24,   1,   1,  -2, -18,   0,   9,
     -3,  17, -27,   0, -21, -30, -12, -11,  -5,  -2,
     12,   4,   9,  19,  18,  -9,  13,  -6,  11,  -8,
     -2,  35,  -8,  10,  -7,  -1,   4, -11, -10,  -2,
    }, {
     55,   1,  17,   6,  -1, -16, -15, -35, -15,  -2,
      0,   4, -19,  -8, -20, -13,  -1, -14,   7,  -3,
     18,   0,  10,   5,  19, -19,   0, -21,   8, -16,
      9,  39,   0,  36,  10,   7,  -9,   4, -20,   5,
    }, {
     22,   5,  42,  26,  -6,   8,   1,   2,  -9,  17,
    -10,  18, -21,  19, -39, -31, -23, -23, -16, -15,
      2, -12,   7,   6,   5,  -9,   1, -10,   7, -16,
      4,   9,   0,  10,  17,  22,  16,   2,  14,   9,
    }, {
     44,  -6,  30,   8,  -9, -10, -11, -14, -23,   5,
     -8,   4, -14,  12, -37, -14, -12, -26,  -4, -16,
      8, -16,   9,  -7,   6, -19, -12, -25,   5, -24,
     15,  13,   8,  36,  34,  31,   1,  18,   4,  18,
    }, {
     -3,  -5,  -9,  -7,  15,  -1,   5,  13,   2,  12,
      5,   2, -21, -23,  -2, -16,   0,   5,  -6,  13,
    -23,   3, -32,  10, -15,   8,  44,  28,   9,  37,
     -2,  13,  -9, -15, -12, -27,  -7, -12,   0, -11,
    }, {
     18, -17, -21, -25,  11, -19,  -6,  -3, -11,   0,
      7, -11, -13, -31,  -1,   0,   9,   1,   5,  12,
    -18,   0, -31,  -2, -13,  -1,  30,  14,   7,  29,
      9,  18,  -1,  10,   4, -18, -22,   3, -10,  -2,
    }, {
    -13, -13,   3,  -5,   7,   4,   9,  34,  -5,  20,
     -2,   3, -16,  -3, -20, -17, -11,  -7, -17,   0,
    -34, -13, -33,  -2, -28,   8,  32,  24,   5,  29,
      3, -12,   0, -15,  11,  -3,   3,   2,  24,   1,
    }, {
      8, -25,  -8, -23,   3, -13,  -3,  17, -20,   8,
      0, -10,  -8, -11, -18,   0,  -1, -10,  -5,   0,
    -28, -17, -32, -15, -26,  -1,  19,   9,   3,  21,
     15,  -7,   6,   9,  29,   5, -10,  17,  15,   9,
    }, {
      4,  -6,  -3,   5,  -1,  -4, -11,  16,  -6,  23,
     19,  29,   0,  -3,   6, -30,   3, -17, -10,  -5,
    -13,  -2, -17,   3,   5,   3,  35,  21,  17,  17,
      2,  35,  -2, -15,   3, -28, -13, -21, -13, -13,
    }, {
     26, -19, -15, -12,  -5, -22, -24,   0, -21,  12,
     21,  15,   8, -11,   7, -12,  14, -20,   2,  -6,
     -7,  -6, -16,  -9,   6,  -5,  21,   7,  15,  10,
     13,  39,   5,  10,  20, -19, -28,  -5, -22,  -5,
    }, {
     -5, -15,   9,   7,  -9,   2,  -8,  37, -14,  31,
     11,  29,   5,  16, -11, -30,  -7, -29, -21, -18,
    -23, -19, -18,  -9,  -7,   3,  23,  17,  14,   9,
      8,   9,   6, -15,  27,  -4,  -2,  -6,  12,  -1,
    }, {
     16, -27,  -2, -10, -13, -16, -20,  20, -29,  20,
     14,  16,  13,   8,  -9, -13,   2, -33,  -9, -19,
    -17, -23, -17, -22,  -6,  -6,   9,   2,  12,   2,
     20,  13,  13,  10,  45,   4, -16,   8,   2,   7,
    }, {
    -16,  14,  -2,   8,  20,  17,   9,   2,  14,  16,
     -6,   5, -24, -28, -21, -20,  -8,   9,   4,  25,
     -1,  11, -22,  24, -15,  -8,  21,   5,  11,  14,
     -5,  18, -11,   7, -27, -20, -14,  -7,   1,  -9,
    }, {
      6,   2, -14,  -9,  16,  -1,  -3, -14,   0,   5,
     -3,  -8, -16, -36, -19,  -3,   1,   6,  17,  24,
      4,   7, -21,  11, -14, -18,   7,  -9,   9,   7,
      6,  22,  -3,  33, -10, -11, -28,   7,  -7,   0,
    }, {
    -26,   6,  11,  10,  12,  23,  12,  23,   5,  24,
    -13,   5, -19,  -8, -38, -21, -20,  -2,  -6,  12,
    -11,  -5, -23,  11, -29,  -9,   9,   0,   7,   6,
      1,  -7,  -2,   7,  -3,   3,  -2,   6,  27,   3,
    }, {
     -4,  -6,   0,  -7,   8,   4,   0,   6,  -9,  13,
    -11,  -7, -11, -15, -37,  -4,  -9,  -5,   5,  11,
     -5,  -9, -22,  -1, -27, -18,  -4, -14,   5,   0,
     12,  -3,   4,  32,  14,  12, -17,  22,  17,  11,
    }, {
     -8,  12,   3,  21,   3,  14,  -8,   5,   4,  28,
      7,  32,  -2,  -8, -12, -34,  -4, -12,   1,   6,
      9,   4,  -7,  17,   4, -13,  11,  -1,  19,  -4,
      0,  39,  -4,   7, -11, -21, -20, -16, -10, -11,
    }, {
     13,   0,  -8,   3,   0,  -4, -21, -11,  -9,  16,
     10,  18,   5, -16, -10, -16,   5, -15,  13,   5,
     15,   1,  -6,   4,   6, -23,  -2, -16,  17, -12,
     10,  44,   3,  33,   6, -12, -34,  -1, -20,  -3,
    }, {
    -18,   4,  17,  23,  -4,  20,  -4,  26,  -3,  36,
      0,  32,   2,  12, -29, -34, -16, -24, -10,  -6,
      0, -12,  -8,   4,  -8, -13,   0,  -6,  16, -12,
      5,  13,   3,   7,  13,   3,  -8,  -2,  14,   0,
    }, {
      3,  -7,   5,   5,  -8,   2, -17,   9, -18,  24,
      2,  19,  10,   4, -28, -17,  -5, -28,   2,  -7,
      4, -15,  -7,  -8,  -6, -23, -13, -21,  14, -20,
     17,  18,  11,  33,  30,  11, -23,  13,   5,   9,
    }, {
     60,  10,   7,  -1,   9,  -8,   6, -13,   2, -15,
     -1, -10, -13, -11,  15,   0,   6,   9,  -1,   0,
    -13,   1, -11,  -3, -13,  21,  13,  26,  -7,  31,
    -10,  -7, -16, -33, -31, -10,  22,  -8,   1,  -2,
    }, {
     82,  -1,  -4, -19,   6, -27,  -6, -29, -12, -26,
      1, -24,  -5, -18,  17,  17,  17,   6,  10,   0,
     -7,  -2,  -9, -16, -12,  11,   0,  11,  -9,  23,
      0,  -3,  -8,  -8, -13,  -1,   8,   7,  -7,   6,
    }, {
     49,   2,  21,   0,   1,  -2,   9,   8,  -6,  -6,
     -8, -10,  -8,   9,  -2,   0,  -4,  -2, -13, -12,
    -23, -15, -12, -16, -26,  21,   2,  21, -11,  23,
     -4, -33,  -7, -33,  -6,  13,  34,   5,  27,  10,
    }, {
     71, -10,   9, -17,  -1, -20,  -3,  -8, -21, -18,
     -6, -24,   0,   1,   0,  16,   6,  -5,   0, -13,
    -17, -19, -11, -29, -25,  11, -11,   6, -13,  15,
      7, -29,   0,  -8,  11,  22,  20,  21,  17,  18,
    }, {
     67,   8,  14,  11,  -7, -11, -11,  -9,  -7,  -3,
     13,  16,   8,   9,  24, -12,  10, -13,  -5, -17,
     -2,  -4,   3, -10,   6,  17,   4,  19,   0,  11,
     -6,  13,  -9, -33, -14, -10,  16, -17, -10,  -4,
    }, {
     90,  -3,   2,  -6, -10, -29, -24, -26, -21, -15,
     15,   2,  16,   1,  25,   4,  21, -16,   6, -18,
      3,  -8,   5, -24,   8,   7,  -9,   4,  -1,   3,
      5,  18,  -1,  -7,   2,  -1,   2,  -1, -19,   3,
    }, {
     57,   0,  27,  13, -14,  -5,  -7,  11, -15,   4,
      5,  16,  13,  29,   6, -13,   0, -25, -16, -31,
    -12, -22,   2, -23,  -6,  16,  -7,  14,  -2,   3,
      0, -12,   0, -33,   9,  13,  28,  -3,  14,   7,
    }, {
     79, -11,  15,  -4, -18, -23, -20,  -5, -30,  -7,
      7,   2,  21,  21,   8,   3,  10, -28,  -4, -31,
     -6, -25,   3, -37,  -4,   7, -20,   0,  -4,  -4,
     11,  -7,   6,  -8,  27,  22,  14,  12,   5,  16,
    }, {
     47,  30,  15,  14,  14,   9,   9, -23,  13, -10,
    -12,  -7, -16, -15,  -3,  -3,  -1,  14,   9,  12,
      9,   8,   0,  10, -14,   4,  -9,   2,  -5,   8,
    -13,  -3, -18, -10, -45,  -3,  16,  -4,   4,   0,
    }, {
     69,  17,   3,  -3,  10,  -8,  -3, -40,  -1, -21,
    -10, -21,  -8, -23,  -1,  13,   8,  11,  21,  11,
     15,   4,   0,  -2, -13,  -5, -23, -12,  -7,   0,
     -1,   0, -10,  14, -28,   5,   1,  11,  -5,   7,
    }, {
     36,  21,  28,  16,   6,  16,  12,  -2,   4,  -2,
    -20,  -7, -11,   4, -20,  -4, -12,   2,  -1,   0,
      0,  -8,  -2,  -2, -27,   4, -21,  -2,  -9,   0,
     -6, -29,  -9, -10, -21,  21,  28,  10,  29,  11,
    }, {
     58,   9,  16,  -1,   2,  -2,   0, -19, -10, -13,
    -17, -21,  -3,  -3, -19,  12,  -2,   0,  10,  -1,
      5, -12,   0, -15, -26,  -5, -34, -16, -11,  -7,
      4, -25,  -2,  14,  -3,  29,  13,  25,  20,  20,
    }, {
     55,  28,  21,  27,  -2,   7,  -8, -20,   4,   1,
      1,  18,   5,   4,   5, -16,   2,  -8,   5,  -5,
     19,   2,  14,   3,   6,   0, -18,  -4,   2, -11,
     -8,  18, -11, -10, -29,  -3,  10, -13,  -8,  -3,
    }, {
     77,  16,   9,   9,  -6, -11, -21, -37, -10, -10,
      4,   5,  13,  -3,   7,   0,  13, -11,  17,  -6,
     25,  -1,  15,  -9,   7,  -9, -32, -19,   0, -18,
      2,  22,  -3,  15, -12,   5,  -4,   2, -17,   5,
    }, {
     44,  20,  34,  29, -10,  13,  -4,   0,  -4,   9,
     -5,  19,  10,  24, -11, -17,  -8, -20,  -5, -19,
      9, -14,  12,  -9,  -6,   0, -30,  -9,   0, -19,
     -2,  -7,  -2, -10,  -5,  20,  21,   1,  17,   9,
    }, {
     66,   8,  23,  11, -14,  -5, -17, -16, -19,  -2,
     -3,   5,  18,  17, -10,   0,   1, -23,   6, -20,
     15, -18,  14, -22,  -5, -10, -44, -23,  -2, -26,
      9,  -3,   4,  14,  12,  29,   7,  16,   7,  18,
    }, {
     18,   9, -17,  -4,  11,   3,   0,  11,   7,   4,
     10,   3,  10, -18,  24,  -3,  14,   7,   4,  10,
    -16,   1, -27,  -4, -27,  17,  12,  30,   0,  35,
     -9,  -3, -12, -36, -35, -30,  -2, -13,   2, -11,
    }, {
     40,  -2, -29, -22,   7, -14, -12,  -5,  -7,  -7,
     12,  -9,  18, -26,  26,  14,  24,   4,  16,   9,
    -10,  -2, -26, -18, -26,   7,  -1,  15,  -1,  27,
      2,   0,  -4, -11, -17, -21, -16,   1,  -7,  -3,
    }, {
      8,   1,  -3,  -2,   3,  10,   3,  32,  -1,  12,
      2,   4,  15,   1,   7,  -3,   2,  -4,  -6,  -3,
    -26, -15, -29, -17, -40,  17,   0,  26,  -2,  27,
     -2, -29,  -4, -36, -10,  -6,   9,   0,  27,   0,
    }, {
     30, -11, -15, -20,   0,  -8,  -9,  15, -15,   0,
      5,  -9,  23,  -6,   8,  13,  13,  -7,   5,  -3,
    -20, -19, -27, -31, -39,   7, -13,  11,  -4,  19,
      8, -25,   3, -11,   7,   2,  -4,  16,  18,   9,
    }, {
     26,   7, -11,   8,  -5,   1, -17,  14,  -1,  15,
     24,  30,  32,   1,  33, -16,  18, -14,   0,  -8,
     -6,  -4, -12, -12,  -6,  13,   2,  23,   8,  15,
     -4,  17,  -5, -36, -18, -30,  -8, -22, -10, -14,
    }, {
     48,  -4, -23,  -9,  -9, -17, -30,  -2, -16,   3,
     26,  16,  40,  -6,  35,   1,  28, -17,  12,  -9,
      0,  -8, -11, -25,  -5,   3, -10,   8,   6,   7,
      6,  22,   1, -11,  -1, -21, -22,  -7, -19,  -5,
    }, {
     15,   0,   2,  10, -13,   7, -14,  35, -10,  23,
     16,  31,  37,  21,  16, -17,   6, -26, -10, -21,
    -16, -21, -13, -25, -19,  13,  -8,  19,   5,   7,
      1,  -8,   2, -36,   5,  -6,   3,  -8,  15,  -1,
    }, {
     37, -12,  -9,  -7, -17, -11, -26,  18, -25,  12,
     19,  17,  45,  14,  17,   0,  17, -30,   1, -22,
    -10, -25, -12, -38, -18,   3, -22,   4,   3,   0,
     13,  -3,  10, -11,  23,   2, -10,   7,   5,   7,
    }, {
      5,  29,  -9,  11,  15,  22,   3,   0,  18,   8,
     -1,   6,   7, -23,   6,  -6,   5,  12,  15,  21,
      5,   8, -17,   9, -28,   0, -11,   6,   2,  12,
    -11,   0, -14, -13, -49, -22,  -8,  -9,   4,  -9,
    }, {
     27,  16, -21,  -6,  12,   3,  -9, -16,   3,  -2,
      1,  -7,  15, -31,   7,  10,  16,   9,  27,  21,
     11,   5, -16,  -3, -26,  -9, -24,  -7,   0,   4,
      0,   4,  -6,  11, -32, -14, -23,   6,  -5,  -1,
    }, {
     -4,  20,   3,  13,   8,  28,   6,  21,  10,  16,
     -8,   7,  12,  -3, -11,  -7,  -5,   0,   4,   8,
     -4,  -8, -18,  -3, -41,   0, -22,   2,   0,   4,
     -5, -25,  -6, -14, -25,   1,   2,   4,  29,   2,
    }, {
     17,   8,  -8,  -4,   4,  10,  -6,   5,  -4,   5,
     -6,  -6,  20, -10,  -9,   9,   4,  -2,  16,   7,
      1, -12, -17, -16, -39,  -9, -36, -12,  -2,  -3,
      6, -21,   1,  11,  -7,  10, -11,  20,  20,  11,
    }, {
     13,  27,  -3,  24,  -1,  19, -14,   3,   9,  20,
     12,  33,  29,  -3,  15, -20,   9,  -9,  11,   3,
     16,   2,  -2,   2,  -7,  -3, -20,   0,  10,  -7,
     -7,  22,  -7, -13, -33, -23, -14, -18,  -7, -12,
    }, {
     35,  15, -15,   6,  -4,   1, -27, -12,  -5,   8,
     15,  19,  37, -11,  16,  -2,  20, -12,  23,   2,
     22,  -1,  -1, -11,  -5, -13, -34, -14,   8, -14,
      4,  26,   0,  11, -16, -14, -29,  -2, -17,  -3,
    }, {
      3,  19,   9,  26,  -8,  26, -10,  24,   0,  28,
      5,  33,  34,  17,  -2, -20,  -1, -22,   0, -10,
      6, -14,  -3, -10, -20,  -4, -32,  -4,   7, -15,
      0,  -3,   0, -13,  -9,   0,  -3,  -4,  17,   0,
    }, {
     25,   7,  -2,   8, -12,   7, -23,   8, -13,  16,
      7,  20,  42,   9,   0,  -3,   9, -25,  12, -10,
     12, -18,  -2, -24, -19, -13, -46, -19,   5, -22,
     10,   0,   8,  11,   8,   9, -17,  11,   7,   8,
    }, {
    -25,  -7,   2,  -8,  12,  -7,  23,  -8,  13, -16,
     -7, -20, -42,  -9,   0,   3,  -9,  25, -12,  10,
    -12,  18,   2,  24,  19,  13,  46,  19,  -5,  22,
    -10,   0,  -8, -11,  -8,  -9,  17, -11,  -7,  -8,
    }, {
     -3, -19,  -9, -26,   8, -26,  10, -24,   0, -28,
     -5, -33, -34, -17,   2,  20,   1,  22,   0,  10,
     -6,  14,   3,  10,  20,   4,  32,   4,  -7,  15,
      0,   3,   0,  13,   9,   0,   3,   4, -17,   0,
    }, {
    -35, -15,  15,  -6,   4,  -1,  27,  12,   5,  -8,
    -15, -19, -37,  11, -16,   2, -20,  12, -23,  -2,
    -22,   1,   1,  11,   5,  13,  34,  14,  -8,  14,
     -4, -26,   0, -11,  16,  14,  29,   2,  17,   3,
    }, {
    -13, -27,   3, -24,   1, -19,  14,  -3,  -9, -20,
    -12, -33, -29,   3, -15,  20,  -9,   9, -11,  -3,
    -16,  -2,   2,  -2,   7,   3,  20,   0, -10,   7,
      7, -22,   7,  13,  33,  23,  14,  18,   7,  12,
    }, {
    -17,  -8,   8,   4,  -4, -10,   6,  -5,   4,  -5,
      6,   6, -20,  10,   9,  -9,  -4,   2, -16,  -7,
     -1,  12,  17,  16,  39,   9,  36,  12,   2,   3,
     -6,  21,  -1, -11,   7, -10,  11, -20, -20, -11,
    }, {
      4, -20,  -3, -13,  -8, -28,  -6, -21, -10, -16,
      8,  -7, -12,   3,  11,   7,   5,   0,  -4,  -8,
      4,   8,  18,   3,  41,   0,  22,  -2,   0,  -4,
      5,  25,   6,  14,  25,  -1,  -2,  -4, -29,  -2,
    }, {
    -27, -16,  21,   6, -12,  -3,   9,  16,  -3,   2,
     -1,   7, -15,  31,  -7, -10, -16,  -9, -27, -21,
    -11,  -5,  16,   3,  26,   9,  24,   7,   0,  -4,
      0,  -4,   6, -11,  32,  14,  23,  -6,   5,   1,
    }, {
     -5, -29,   9, -11, -15, -22,  -3,   0, -18,  -8,
      1,  -6,  -7,  23,  -6,   6,  -5, -12, -15, -21,
     -5,  -8,  17,  -9,  28,   0,  11,  -6,  -2, -12,
     11,   0,  14,  13,  49,  22,   8,   9,  -4,   9,
    }, {
    -37,  12,   9,   7,  17,  11,  26, -18,  25, -12,
    -19, -17, -45, -14, -17,   0, -17,  30,  -1,  22,
     10,  25,  12,  38,  18,  -3,  22,  -4,  -3,   0,
    -13,   3, -10,  11, -23,  -2,  10,  -7,  -5,  -7,
    }, {
    -15,   0,  -2, -10,  13,  -7,  14, -35,  10, -23,
    -16, -31, -37, -21, -16,  17,  -6,  26,  10,  21,
     16,  21,  13,  25,  19, -13,   8, -19,  -5,  -7,
     -1,   8,  -2,  36,  -5,   6,  -3,   8, -15,   1,
    }, {
    -48,   4,  23,   9,   9,  17,  30,   2,  16,  -3,
    -26, -16, -40,   6, -35,  -1, -28,  17, -12,   9,
      0,   8,  11,  25,   5,  -3,  10,  -8,  -6,  -7,
     -6, -22,  -1,  11,   1,  21,  22,   7,  19,   5,
    }, {
    -26,  -7,  11,  -8,   5,  -1,  17, -14,   1, -15,
    -24, -30, -32,  -1, -33,  16, -18,  14,   0,   8,
      6,   4,  12,  12,   6, -13,  -2, -23,  -8, -15,
      4, -17,   5,  36,  18,  30,   8,  22,  10,  14,
    }, {
    -30,  11,  15,  20,   0,   8,   9, -15,  15,   0,
     -5,   9, -23,   6,  -8, -13, -13,   7,  -5,   3,
     20,  19,  27,  31,  39,  -7,  13, -11,   4, -19,
     -8,  25,  -3,  11,  -7,  -2,   4, -16, -18,  -9,
    }, {
     -8,  -1,   3,   2,  -3, -10,  -3, -32,   1, -12,
     -2,  -4, -15,  -1,  -7,   3,  -2,   4,   6,   3,
     26,  15,  29,  17,  40, -17,   0, -26,   2, -27,
      2,  29,   4,  36,  10,   6,  -9,   0, -27,   0,
    }, {
    -40,   2,  29,  22,  -7,  14,  12,   5,   7,   7,
    -12,   9, -18,  26, -26, -14, -24,  -4, -16,  -9,
     10,   2,  26,  18,  26,  -7,   1, -15,   1, -27,
     -2,   0,   4,  11,  17,  21,  16,  -1,   7,   3,
    }, {
    -18,  -9,  17,   4, -11,  -3,   0, -11,  -7,  -4,
    -10,  -3, -10,  18, -24,   3, -14,  -7,  -4, -10,
     16,  -1,  27,   4,  27, -17, -12, -30,   0, -35,
      9,   3,  12,  36,  35,  30,   2,  13,  -2,  11,
    }, {
    -66,  -8, -23, -11,  14,   5,  17,  16,  19,   2,
      3,  -5, -18, -17,  10,   0,  -1,  23,  -6,  20,
    -15,  18, -14,  22,   5,  10,  44,  23,   2,  26,
     -9,   3,  -4, -14, -12, -29,  -7, -16,  -7, -18,
    }, {
    -44, -20, -34, -29,  10, -13,   4,   0,   4,  -9,
      5, -19, -10, -24,  11,  17,   8,  20,   5,  19,
     -9,  14, -12,   9,   6,   0,  30,   9,   0,  19,
      2,   7,   2,  10,   5, -20, -21,  -1, -17,  -9,
    }, {
    -77, -16,  -9,  -9,   6,  11,  21,  37,  10,  10,
     -4,  -5, -13,   3,  -7,   0, -13,  11, -17,   6,
    -25,   1, -15,   9,  -7,   9,  32,  19,   0,  18,
     -2, -22,   3, -15,  12,  -5,   4,  -2,  17,  -5,
    }, {
    -55, -28, -21, -27,   2,  -7,   8,  20,  -4,  -1,
     -1, -18,  -5,  -4,  -5,  16,  -2,   8,  -5,   5,
    -19,  -2, -14,  -3,  -6,   0,  18,   4,  -2,  11,
      8, -18,  11,  10,  29,   3, -10,  13,   8,   3,
    }, {
    -58,  -9, -16,   1,  -2,   2,   0,  19,  10,  13,
     17,  21,   3,   3,  19, -12,   2,   0, -10,   1,
     -5,  12,   0,  15,  26,   5,  34,  16,  11,   7,
     -4,  25,   2, -14,   3, -29, -13, -25, -20, -20,
    }, {
    -36, -21, -28, -16,  -6, -16, -12,   2,  -4,   2,
     20,   7,  11,  -4,  20,   4,  12,  -2,   1,   0,
      0,   8,   2,   2,  27,  -4,  21,   2,   9,   0,
      6,  29,   9,  10,  21, -21, -28, -10, -29, -11,
    }, {
    -69, -17,  -3,   3, -10,   8,   3,  40,   1,  21,
     10,  21,   8,  23,   1, -13,  -8, -11, -21, -11,
    -15,  -4,   0,   2,  13,   5,  23,  12,   7,   0,
      1,   0,  10, -14,  28,  -5,  -1, -11,   5,  -7,
    }, {
    -47, -30, -15, -14, -14,  -9,  -9,  23, -13,  10,
     12,   7,  16,  15,   3,   3,   1, -14,  -9, -12,
     -9,  -8,   0, -10,  14,  -4,   9,  -2,   5,  -8,
     13,   3,  18,  10,  45,   3, -16,   4,  -4,   0,
    }, {
    -79,  11, -15,   4,  18,  23,  20,   5,  30,   7,
     -7,  -2, -21, -21,  -8,  -3, -10,  28,   4,  31,
      6,  25,  -3,  37,   4,  -7,  20,   0,   4,   4,
    -11,   7,  -6,   8, -27, -22, -14, -12,  -5, -16,
    }, {
    -57,   0, -27, -13,  14,   5,   7, -11,  15,  -4,
     -5, -16, -13, -29,  -6,  13,   0,  25,  16,  31,
     12,  22,  -2,  23,   6, -16,   7, -14,   2,  -3,
      0,  12,   0,  33,  -9, -13, -28,   3, -14,  -7,
    }, {
    -90,   3,  -2,   6,  10,  29,  24,  26,  21,  15,
    -15,  -2, -16,  -1, -25,  -4, -21,  16,  -6,  18,
     -3,   8,  -5,  24,  -8,  -7,   9,  -4,   1,  -3,
     -5, -18,   1,   7,  -2,   1,  -2,   1,  19,  -3,
    }, {
    -67,  -8, -14, -11,   7,  11,  11,   9,   7,   3,
    -13, -16,  -8,  -9, -24,  12, -10,  13,   5,  17,
      2,   4,  -3,  10,  -6, -17,  -4, -19,   0, -11,
      6, -13,   9,  33,  14,  10, -16,  17,  10,   4,
    }, {
    -71,  10,  -9,  17,   1,  20,   3,   8,  21,  18,
      6,  24,   0,  -1,   0, -16,  -6,   5,   0,  13,
     17,  19,  11,  29,  25, -11,  11,  -6,  13, -15,
     -7,  29,   0,   8, -11, -22, -20, -21, -17, -18,
    }, {
    -49,  -2, -21,   0,  -1,   2,  -9,  -8,   6,   6,
      8,  10,   8,  -9,   2,   0,   4,   2,  13,  12,
     23,  15,  12,  16,  26, -21,  -2, -21,  11, -23,
      4,  33,   7,  33,   6, -13, -34,  -5, -27, -10,
    }, {
    -82,   1,   4,  19,  -6,  27,   6,  29,  12,  26,
     -1,  24,   5,  18, -17, -17, -17,  -6, -10,   0,
      7,   2,   9,  16,  12, -11,   0, -11,   9, -23,
      0,   3,   8,   8,  13,   1,  -8,  -7,   7,  -6,
    }, {
    -60, -10,  -7,   1,  -9,   8,  -6,  13,  -2,  15,
      1,  10,  13,  11, -15,   0,  -6,  -9,   1,   0,
     13,  -1,  11,   3,  13, -21, -13, -26,   7, -31,
     10,   7,  16,  33,  31,  10, -22,   8,  -1,   2,
    }, {
     -3,   7,  -5,  -5,   8,  -2,  17,  -9,  18, -24,
     -2, -19, -10,  -4,  28,  17,   5,  28,  -2,   7,
     -4,  15,   7,   8,   6,  23,  13,  21, -14,  20,
    -17, -18, -11, -33, -30, -11,  23, -13,  -5,  -9,
    }, {
     18,  -4, -17, -23,   4, -20,   4, -26,   3, -36,
      0, -32,  -2, -12,  29,  34,  16,  24,  10,   6,
      0,  12,   8,  -4,   8,  13,   0,   6, -16,  12,
     -5, -13,  -3,  -7, -13,  -3,   8,   2, -14,   0,
    }, {
    -13,   0,   8,  -3,   0,   4,  21,  11,   9, -16,
    -10, -18,  -5,  16,  10,  16,  -5,  15, -13,  -5,
    -15,  -1,   6,  -4,  -6,  23,   2,  16, -17,  12,
    -10, -44,  -3, -33,  -6,  12,  34,   1,  20,   3,
    }, {
      8, -12,  -3, -21,  -3, -14,   8,  -5,  -4, -28,
     -7, -32,   2,   8,  12,  34,   4,  12,  -1,  -6,
     -9,  -4,   7, -17,  -4,  13, -11,   1, -19,   4,
      0, -39,   4,  -7,  11,  21,  20,  16,  10,  11,
    }, {
      4,   6,   0,   7,  -8,  -4,   0,  -6,   9, -13,
     11,   7,  11,  15,  37,   4,   9,   5,  -5, -11,
      5,   9,  22,   1,  27,  18,   4,  14,  -5,   0,
    -12,   3,  -4, -32, -14, -12,  17, -22, -17, -11,
    }, {
     26,  -6, -11, -10, -12, -23, -12, -23,  -5, -24,
     13,  -5,  19,   8,  38,  21,  20,   2,   6, -12,
     11,   5,  23, -11,  29,   9,  -9,   0,  -7,  -6,
     -1,   7,   2,  -7,   3,  -3,   2,  -6, -27,  -3,
    }, {
     -6,  -2,  14,   9, -16,   1,   3,  14,   0,  -5,
      3,   8,  16,  36,  19,   3,  -1,  -6, -17, -24,
     -4,  -7,  21, -11,  14,  18,  -7,   9,  -9,  -7,
     -6, -22,   3, -33,  10,  11,  28,  -7,   7,   0,
    }, {
     16, -14,   2,  -8, -20, -17,  -9,  -2, -14, -16,
      6,  -5,  24,  28,  21,  20,   8,  -9,  -4, -25,
      1, -11,  22, -24,  15,   8, -21,  -5, -11, -14,
      5, -18,  11,  -7,  27,  20,  14,   7,  -1,   9,
    }, {
    -16,  27,   2,  10,  13,  16,  20, -20,  29, -20,
    -14, -16, -13,  -8,   9,  13,  -2,  33,   9,  19,
     17,  23,  17,  22,   6,   6,  -9,  -2, -12,  -2,
    -20, -13, -13, -10, -45,  -4,  16,  -8,  -2,  -7,
    }, {
      5,  15,  -9,  -7,   9,  -2,   8, -37,  14, -31,
    -11, -29,  -5, -16,  11,  30,   7,  29,  21,  18,
     23,  19,  18,   9,   7,  -3, -23, -17, -14,  -9,
     -8,  -9,  -6,  15, -27,   4,   2,   6, -12,   1,
    }, {
    -26,  19,  15,  12,   5,  22,  24,   0,  21, -12,
    -21, -15,  -8,  11,  -7,  12, -14,  20,  -2,   6,
      7,   6,  16,   9,  -6,   5, -21,  -7, -15, -10,
    -13, -39,  -5, -10, -20,  19,  28,   5,  22,   5,
    }, {
     -4,   6,   3,  -5,   1,   4,  11, -16,   6, -23,
    -19, -29,   0,   3,  -6,  30,  -3,  17,  10,   5,
     13,   2,  17,  -3,  -5,  -3, -35, -21, -17, -17,
     -2, -35,   2,  15,  -3,  28,  13,  21,  13,  13,
    }, {
     -8,  25,   8,  23,  -3,  13,   3, -17,  20,  -8,
      0,  10,   8,  11,  18,   0,   1,  10,   5,   0,
     28,  17,  32,  15,  26,   1, -19,  -9,  -3, -21,
    -15,   7,  -6,  -9, -29,  -5,  10, -17, -15,  -9,
    }, {
     13,  13,  -3,   5,  -7,  -4,  -9, -34,   5, -20,
      2,  -3,  16,   3,  20,  17,  11,   7,  17,   0,
     34,  13,  33,   2,  28,  -8, -32, -24,  -5, -29,
     -3,  12,   0,  15, -11,   3,  -3,  -2, -24,  -1,
    }, {
    -18,  17,  21,  25, -11,  19,   6,   3,  11,   0,
     -7,  11,  13,  31,   1,   0,  -9,  -1,  -5, -12,
     18,   0,  31,   2,  13,   1, -30, -14,  -7, -29,
     -9, -18,   1, -10,  -4,  18,  22,  -3,  10,   2,
    }, {
      3,   5,   9,   7, -15,   1,  -5, -13,  -2, -12,
     -5,  -2,  21,  23,   2,  16,   0,  -5,   6, -13,
     23,  -3,  32, -10,  15,  -8, -44, -28,  -9, -37,
      2, -13,   9,  15,  12,  27,   7,  12,   0,  11,
    }, {
    -44,   6, -30,  -8,   9,  10,  11,  14,  23,  -5,
      8,  -4,  14, -12,  37,  14,  12,  26,   4,  16,
     -8,  16,  -9,   7,  -6,  19,  12,  25,  -5,  24,
    -15, -13,  -8, -36, -34, -31,  -1, -18,  -4, -18,
    }, {
    -22,  -5, -42, -26,   6,  -8,  -1,  -2,   9, -17,
     10, -18,  21, -19,  39,  31,  23,  23,  16,  15,
     -2,  12,  -7,  -6,  -5,   9,  -1,  10,  -7,  16,
     -4,  -9,   0, -10, -17, -22, -16,  -2, -14,  -9,
    }, {
    -55,  -1, -17,  -6,   1,  16,  15,  35,  15,   2,
      0,  -4,  19,   8,  20,  13,   1,  14,  -7,   3,
    -18,   0, -10,  -5, -19,  19,   0,  21,  -8,  16,
     -9, -39,   0, -36, -10,  -7,   9,  -4,  20,  -5,
    }, {
    -33, -13, -29, -24,  -1,  -1,   2,  18,   0,  -9,
      3, -17,  27,   0,  21,  30,  12,  11,   5,   2,
    -12,  -4,  -9, -19, -18,   9, -13,   6, -11,   8,
      2, -35,   8, -10,   7,   1,  -4,  11,  10,   2,
    }, {
    -36,   5, -24,   4,  -7,   7,  -6,  17,  14,   5,
     22,  22,  35,   8,  46,   1,  17,   3,   0,  -2,
      2,  10,   5,   0,  14,  15,   2,  18,   2,   4,
    -11,   7,  -1, -36, -18, -32,  -7, -27, -17, -20,
    }, {
    -14,  -7, -36, -13, -10, -10, -18,   0,   0,  -5,
     25,   8,  43,   0,  48,  18,  27,   0,  12,  -3,
      7,   6,   7, -13,  15,   5, -11,   3,   0,  -2,
      0,  12,   6, -10,   0, -23, -22, -11, -26, -12,
    }, {
    -47,  -3, -11,   6, -15,  13,  -2,  38,   6,  13,
     15,  22,  40,  28,  28,   0,   5,  -8, -10, -15,
     -7,  -7,   4, -13,   1,  14,  -9,  14,   0,  -2,
     -4, -18,   7, -36,   6,  -8,   3, -13,   7,  -8,
    }, {
    -25, -15, -22, -11, -18,  -4, -15,  22,  -8,   2,
     17,   9,  48,  20,  30,  17,  16, -11,   1, -16,
     -2, -10,   5, -26,   2,   4, -22,   0,  -2, -10,
      6, -13,  14, -10,  23,   0, -10,   2,  -1,   0,
    }, {
    -57,  26, -22,   7,  14,  28,  14,   3,  35,   0,
     -3,  -1,  11, -16,  18,  10,   4,  31,  15,  28,
     14,  23,   1,  21,  -7,   2, -11,   1,  -3,   1,
    -18,  -9, -10, -13, -49, -24,  -8, -14,  -2, -16,
    }, {
    -35,  14, -34, -10,  10,  10,   1, -12,  20, -12,
      0, -15,  18, -24,  20,  27,  14,  28,  27,  27,
     20,  19,   2,   8,  -5,  -7, -25, -13,  -5,  -5,
     -6,  -5,  -2,  12, -31, -15, -23,   1, -12,  -8,
    }, {
    -68,  18,  -9,   9,   6,  35,  18,  25,  26,   7,
    -10,  -1,  16,   3,   1,   9,  -6,  19,   4,  15,
      4,   6,   0,   8, -20,   2, -23,  -2,  -7,  -5,
    -12, -35,  -1, -13, -24,   0,   3,   0,  22,  -4,
    }, {
    -46,   6, -21,  -8,   2,  16,   5,   8,  11,  -4,
     -8, -15,  24,  -4,   2,  26,   3,  16,  16,  14,
      9,   2,   1,  -4, -19,  -7, -36, -17,  -9, -13,
      0, -31,   5,  12,  -7,   8, -11,  15,  13,   4,
    }, {
    -49,  24, -16,  20,  -2,  26,  -2,   7,  25,  10,
     11,  25,  32,   3,  27,  -2,   8,   8,  11,   9,
     24,  17,  16,  14,  13,  -2, -20,  -5,   4, -17,
    -14,  12,  -3, -13, -33, -25, -14, -23, -15, -19,
    }, {
    -27,  12, -28,   2,  -6,   7, -15,  -9,  11,  -1,
     13,  11,  40,  -4,  29,  14,  19,   5,  23,   8,
     30,  13,  17,   0,  14, -12, -34, -20,   2, -25,
     -2,  16,   4,  12, -15, -16, -29,  -7, -24, -10,
    }, {
    -60,  16,  -3,  22, -10,  32,   0,  28,  17,  18,
      3,  25,  37,  23,  10,  -3,  -2,  -3,   0,  -3,
     14,   0,  14,   1,   0,  -2, -32,  -9,   1, -25,
     -7, -13,   5, -13,  -8,  -1,  -2,  -8,  10,  -6,
    }, {
    -38,   4, -15,   4, -14,  13, -12,  11,   2,   6,
      6,  11,  45,  16,  11,  13,   7,  -6,  12,  -4,
     20,  -3,  16, -12,   1, -12, -46, -24,   0, -33,
      3,  -9,  12,  12,   8,   7, -17,   6,   0,   2
    }
};

static const int8_t cb2_vects[128][40]={
    {
     73, -32, -60, -15, -26,  59,   2, -33,  30, -10,
     -3, -17,   8,  30,  -1, -26,  -4, -22,  10,  16,
    -36,  -5, -11,  56,  37,   6, -10,  -5, -13,  -3,
      6,  -5,  11,   4, -19,  -5, -16,  41,  24,  13,
    }, {
      4, -11, -37,  23,  -5,  46,  -2, -29,  -5, -39,
    -21,  -9,   0,  49,  12,  -9, -16, -26,  22,  15,
    -45, -20,  -5,  40,  22,  17, -26,  31, -14,   2,
    -14,  10,  30,  20, -27,  -9, -39,  39,  18,   5,
    }, {
     34, -25, -48, -28, -11,  34,  -2, -41,   9,  -7,
    -17,  21,  20,  24, -17, -33,   0, -24,  10,  42,
      3,  -5,  10,  42,  11,   8,  -3,   3,  16,   9,
     22,  -2,   0, -33, -10,  18,   7,  58,  10,  28,
    }, {
    -34,  -4, -25,  10,   9,  21,  -7, -36, -26, -36,
    -35,  28,  12,  42,  -3, -16, -12, -28,  21,  42,
     -5, -21,  16,  26,  -4,  19, -19,  39,  15,  15,
      1,  13,  19, -17, -17,  14, -15,  55,   4,  19,
    }, {
     28, -20, -51, -14,  -6,   7,   0, -26,  27,  -4,
     18, -40,  -6,  16,  -1, -15,   0, -55,  -5, -16,
    -19,  14,  -3,  49,  14,   1, -22, -30, -12,   0,
     24,  15,   9, -17, -45, -29,   4,  28,  51,  35,
    }, {
    -40,   0, -28,  24,  14,  -5,  -4, -21,  -7, -33,
      0, -32, -15,  35,  12,   1, -11, -58,   5, -16,
    -28,   0,   1,  33,   0,  11, -39,   5, -14,   6,
      3,  31,  28,  -1, -53, -33, -19,  25,  46,  26,
    }, {
    -11, -14, -39, -27,   9, -17,  -4, -33,   6,   0,
      4,  -1,   5,  10, -17, -22,   5, -57,  -5,   9,
     20,  13,  18,  35, -11,   3, -16, -22,  17,  13,
     40,  19,  -1, -55, -35,  -5,  27,  44,  37,  49,
    }, {
    -80,   6, -16,  11,  30, -30,  -9, -28, -28, -29,
    -13,   6,  -2,  28,  -3,  -5,  -7, -60,   5,   9,
     11,  -1,  24,  19, -27,  13, -32,  13,  15,  19,
     19,  35,  17, -39, -43,  -9,   4,  42,  32,  41,
    }, {
     78, -21, -43,   4, -38,  17,  17,  -5,  55,  24,
    -15, -36,  14,   4,  24, -24,  12,   5,  17,  31,
    -54,  -5,  -2,  27,  43, -12,   2,   9,  -9, -15,
     22,  -3,  28,  21, -20,   3,  20,  28,   9,  -5,
    }, {
      9,  -1, -20,  43, -17,   3,  12,   0,  20,  -4,
    -33, -29,   6,  22,  38,  -7,   0,   1,  29,  30,
    -63, -21,   3,  11,  27,  -1, -14,  45, -10,  -9,
      1,  12,  47,  37, -28,   0,  -2,  26,   4, -13,
    }, {
     39, -14, -30,  -8, -22,  -8,  12, -12,  34,  27,
    -29,   2,  26,  -2,   8, -31,  16,   3,  17,  57,
    -14,  -6,  19,  13,  16, -10,   8,  17,  20,  -2,
     38,   0,  17, -16, -11,  27,  44,  45,  -4,   8,
    }, {
    -29,   5,  -7,  30,  -1, -21,   7,  -7,   0,   0,
    -47,   9,  18,  15,  22, -14,   4,   0,  28,  57,
    -23, -21,  25,  -2,   1,   0,  -7,  53,  19,   3,
     17,  15,  36,   0, -19,  24,  21,  43,  -9,   0,
    }, {
     33, -10, -34,   5, -17, -35,  15,   1,  53,  30,
      6, -59,   0, -10,  24, -13,  17, -27,   1,  -1,
    -37,  13,   4,  20,  20, -18, -10, -16,  -8, -11,
     39,  18,  26,   0, -46, -20,  41,  15,  37,  15,
    }, {
    -35,  10, -11,  44,   3, -48,  10,   6,  17,   2,
    -11, -51,  -8,   8,  38,   3,   4, -31,  12,  -2,
    -46,  -1,  10,   4,   5,  -7, -26,  19, -10,  -5,
     18,  34,  45,  15, -54, -24,  18,  13,  31,   7,
    }, {
     -5,  -3, -21,  -7,  -2, -60,  10,  -5,  32,  34,
     -7, -20,  11, -16,   8, -20,  21, -29,   1,  24,
      2,  13,  27,   6,  -5, -15,  -3,  -8,  21,   1,
     55,  21,  15, -38, -37,   3,  65,  32,  23,  30,
    }, {
    -74,  17,   0,  31,  18, -73,   5,   0,  -3,   5,
    -25, -12,   3,   1,  22,  -3,   9, -33,  12,  24,
     -6,  -2,  33,  -9, -21,  -5, -20,  27,  19,   7,
     34,  37,  34, -22, -44,   0,  41,  29,  17,  21,
    }, {
     76, -35, -31, -28, -49,  43, -40,   0,  29, -14,
      8,   5,  10,  18, -26, -46,   0,   7,   6,   3,
    -25,  -7,  -2,  40,  28,  14,  18,  -3, -27, -28,
     -8, -45, -13,  34, -13, -27, -15,  31,  12,   3,
    }, {
      7, -15,  -9,   9, -28,  29, -45,   5,  -6, -43,
     -9,  12,   2,  36, -12, -30, -11,   3,  17,   3,
    -34, -22,   3,  24,  12,  24,   2,  32, -28, -22,
    -29, -29,   5,  50, -21, -31, -38,  29,   7,  -5,
    }, {
     36, -29, -19, -41, -34,  18, -45,  -6,   8, -10,
     -5,  43,  23,  11, -42, -53,   5,   5,   6,  30,
     14,  -8,  20,  26,   1,  16,  25,   4,   3, -15,
      7, -41, -23,  -3,  -4,  -3,   8,  48,  -1,  17,
    }, {
    -32,  -8,   3,  -2, -13,   4, -50,  -1, -27, -39,
    -23,  51,  15,  30, -27, -37,  -7,   1,  17,  29,
      5, -23,  25,  10, -14,  26,   8,  41,   1,  -9,
    -13, -26,  -5,  12, -12,  -7, -14,  45,  -6,   9,
    }, {
     31, -24, -23, -27, -29,  -9, -43,   8,  26,  -7,
     30, -17,  -4,   3, -26, -35,   5, -24, -10, -28,
     -9,  12,   5,  33,   5,   8,   5, -29, -26, -24,
      9, -23, -14,  12, -39, -52,   5,  18,  39,  24,
    }, {
    -37,  -3,   0,  10,  -7, -22, -48,  12,  -8, -36,
     12,  -9, -12,  22, -12, -19,  -6, -28,   0, -29,
    -18,  -3,  11,  17, -10,  18, -10,   7, -27, -18,
    -11,  -7,   3,  28, -47, -55, -18,  15,  34,  16,
    }, {
     -8, -17, -10, -40, -13, -34, -47,   0,   5,  -4,
     16,  21,   8,  -2, -42, -43,  10, -26, -10,  -2,
     31,  11,  27,  19, -21,  10,  12, -20,   3, -11,
     25, -20, -25, -25, -29, -28,  28,  34,  25,  38,
    }, {
    -77,   2,  11,  -1,   7, -47, -52,   5, -29, -33,
     -1,  28,   0,  15, -28, -26,  -2, -30,   0,  -2,
     22,  -4,  33,   3, -36,  21,  -3,  15,   2,  -5,
      4,  -4,  -6,  -9, -37, -31,   5,  32,  20,  30,
    }, {
     81, -25, -14,  -8, -61,   0, -25,  28,  54,  20,
     -3, -14,  17,  -8,   0, -44,  16,  35,  13,  18,
    -43,  -7,   6,  11,  33,  -4,  30,  11, -22, -40,
      6, -43,   3,  50, -14, -18,  22,  18,  -1, -16,
    }, {
     12,  -4,   8,  29, -39, -12, -30,  33,  19,  -8,
    -21,  -6,   8,   9,  13, -28,   4,  31,  24,  18,
    -52, -23,  12,  -4,  18,   5,  14,  47, -24, -34,
    -14, -27,  22,  66, -22, -22,  -1,  16,  -6, -24,
    }, {
     41, -18,  -2, -21, -45, -24, -30,  21,  33,  24,
    -17,  24,  29, -15, -16, -51,  21,  33,  13,  45,
     -3,  -8,  28,  -2,   7,  -2,  37,  19,   7, -27,
     22, -39,  -7,  12,  -5,   5,  45,  35, -15,  -1,
    }, {
    -27,   1,  20,  17, -24, -38, -35,  26,  -1,  -4,
    -35,  32,  21,   3,  -2, -35,   8,  29,  24,  44,
    -12, -24,  34, -18,  -8,   7,  21,  55,   5, -21,
      2, -23,  11,  28, -13,   1,  22,  33, -21, -10,
    }, {
     36, -13,  -5,  -7, -40, -51, -28,  36,  52,  27,
     18, -36,   2, -22,   0, -33,  21,   2,  -3, -13,
    -26,  11,  14,   4,  10, -10,  18, -14, -22, -36,
     24, -21,   1,  28, -40, -42,  42,   5,  25,   5,
    }, {
    -32,   6,  17,  31, -19, -65, -33,  41,  16,  -1,
      0, -29,  -6,  -4,  13, -17,   9,  -1,   8, -14,
    -35,  -3,  19, -11,  -4,   0,   1,  21, -23, -30,
      3,  -5,  20,  44, -48, -46,  19,   3,  20,  -3,
    }, {
     -3,  -7,   6, -20, -25, -77, -32,  29,  31,  30,
      4,   2,  14, -29, -16, -40,  26,   0,  -3,  12,
     13,  10,  36,  -9, -15,  -8,  24,  -6,   7, -22,
     40, -17,  -8,  -9, -31, -18,  66,  22,  11,  19,
    }, {
    -72,  13,  29,  18,  -4, -90, -37,  34,  -4,   1,
    -13,   9,   6, -11,  -2, -24,  13,  -3,   7,  11,
      4,  -4,  42, -25, -31,   1,   8,  29,   6, -17,
     19,  -2,  10,   6, -38, -22,  42,  19,   6,  11,
    }, {
    116, -20, -68, -30, -28,  83,  28, -18,  32, -22,
    -13, -21,   5,  28,   5,  -7, -24,  -8, -22,  17,
    -23,  30, -25,  45,  15,  -9, -11, -18,  22, -10,
      4,  -2,  19, -12,  23,   3, -43,   2,  12,  -4,
    }, {
     47,   0, -45,   7,  -7,  69,  23, -13,  -2, -51,
    -32, -14,  -3,  47,  19,   8, -37, -11, -10,  16,
    -32,  15, -19,  29,   0,   1, -28,  18,  20,  -4,
    -16,  13,  38,   3,  15,   0, -66,   0,   7, -13,
    }, {
     77, -13, -56, -43, -13,  57,  23, -26,  11, -19,
    -27,  16,  17,  22, -10, -15, -19, -10, -22,  43,
     16,  30,  -2,  31, -11,  -6,  -5,  -9,  52,   2,
     20,   0,   8, -50,  33,  27, -19,  19,  -1,   9,
    }, {
      8,   6, -33,  -4,   7,  44,  18, -21, -23, -48,
    -46,  24,   9,  40,   3,   1, -32, -13, -11,  43,
      7,  14,   3,  15, -26,   3, -21,  26,  50,   8,
      0,  16,  27, -34,  25,  23, -43,  17,  -6,   1,
    }, {
     71,  -9, -59, -29,  -8,  30,  26, -11,  30, -16,
      8, -44,  -9,  14,   5,   2, -19, -40, -38, -15,
     -7,  50, -17,  38,  -7, -14, -24, -43,  22,  -6,
     22,  19,  17, -34,  -2, -20, -23, -10,  39,  16,
    }, {
      2,  11, -36,   9,  13,  17,  21,  -6,  -5, -45,
    -10, -36, -18,  33,  19,  19, -31, -44, -27, -15,
    -16,  34, -11,  22, -22,  -4, -40,  -7,  21,   0,
      1,  35,  36, -18, -10, -24, -46, -12,  34,   8,
    }, {
     32,  -2, -47, -42,   7,   5,  21, -18,   9, -12,
     -5,  -5,   2,   8, -10,  -4, -14, -42, -38,  10,
     33,  49,   5,  24, -33, -12, -17, -35,  52,   6,
     38,  22,   7, -72,   7,   3,   0,   6,  25,  30,
    }, {
    -36,  18, -24,  -3,  28,  -7,  16, -13, -26, -41,
    -24,   1,  -5,  26,   3,  12, -27, -46, -27,  10,
     24,  34,  10,   8, -49,  -2, -34,   0,  51,  12,
     17,  38,  25, -56,   0,   0, -22,   3,  20,  22,
    }, {
    121,  -9, -50, -10, -40,  40,  43,   9,  58,  12,
    -25, -41,  11,   2,  31,  -5,  -8,  19, -15,  32,
    -41,  30, -16,  16,  20, -28,   0,  -3,  26, -22,
     19,   0,  36,   4,  22,  12,  -6,  -9,  -1, -24,
    }, {
     52,  10, -27,  27, -18,  26,  38,  14,  23, -16,
    -44, -33,   3,  20,  45,  10, -20,  15,  -3,  31,
    -50,  14, -10,   0,   5, -17, -15,  32,  24, -16,
     -1,  15,  55,  20,  14,   8, -29, -12,  -7, -32,
    }, {
     82,  -3, -38, -23, -24,  15,  38,   2,  37,  15,
    -39,  -2,  23,  -4,  15, -12,  -3,  17, -15,  58,
     -1,  29,   6,   2,  -5, -26,   7,   4,  56,  -9,
     35,   3,  25, -33,  32,  36,  17,   7, -15,  -9,
    }, {
     13,  17, -15,  15,  -3,   1,  33,   7,   1, -12,
    -58,   5,  15,  13,  29,   3, -16,  13,  -4,  57,
    -10,  13,  11, -13, -21, -15,  -9,  40,  55,  -3,
     14,  19,  44, -17,  24,  32,  -5,   4, -21, -18,
    }, {
     76,   1, -41,  -9, -19, -12,  41,  17,  55,  18,
     -3, -63,  -3, -12,  30,   5,  -3, -12, -31,   0,
    -24,  49,  -8,   9,  -1, -33, -12, -29,  27, -18,
     37,  21,  34, -17,  -3, -11,  14, -23,  25,  -2,
    }, {
      7,  22, -18,  29,   1, -25,  36,  21,  20,  -9,
    -22, -56, -11,   6,  45,  21, -15, -16, -20,  -1,
    -33,  34,  -2,  -6, -17, -23, -28,   6,  25, -12,
     16,  37,  53,  -1, -11, -15,  -8, -25,  20, -11,
    }, {
     37,   8, -29, -22,  -4, -37,  36,   9,  34,  22,
    -17, -24,   8, -18,  15,  -2,   1, -14, -31,  25,
     15,  48,  13,  -4, -28, -31,  -5, -21,  57,  -4,
     53,  24,  23, -55,   6,  12,  37,  -6,  11,  11,
    }, {
    -31,  28,  -6,  16,  16, -50,  31,  14,   0,  -6,
    -36, -17,   0,   0,  29,  14, -11, -18, -20,  25,
      6,  33,  19, -20, -43, -21, -21,  14,  55,   0,
     32,  40,  42, -39,  -1,   8,  14,  -8,   6,   3,
    }, {
    119, -24, -39, -44, -51,  66, -14,  15,  31, -26,
     -1,   0,   7,  16, -19, -28, -19,  22, -26,   4,
    -13,  28, -16,  29,   5,  -1,  16, -16,   8, -35,
    -10, -42,  -4,  17,  29, -19, -42,  -7,   0, -15,
    }, {
     50,  -3, -16,  -5, -30,  53, -19,  20,  -3, -55,
    -19,   8,   0,  34,  -5, -11, -32,  18, -15,   4,
    -22,  13, -10,  13,  -9,   8,   0,  19,   7, -29,
    -31, -26,  13,  33,  21, -22, -65,  -9,  -4, -23,
    }, {
     79, -17, -27, -56, -36,  41, -19,   8,  10, -22,
    -15,  39,  20,   9, -35, -35, -15,  20, -26,  31,
     26,  27,   6,  15, -20,   0,  23,  -8,  38, -22,
      5, -38, -15, -20,  39,   4, -18,   9, -13,  -1,
    }, {
     10,   3,  -4, -18, -15,  27, -24,  13, -24, -51,
    -34,  47,  12,  28, -21, -19, -27,  16, -15,  30,
     17,  12,  12,   0, -36,  10,   7,  27,  37, -16,
    -15, -22,   3,  -4,  31,   1, -42,   7, -18,  -9,
    }, {
     74, -12, -30, -42, -30,  14, -16,  23,  29, -19,
     20, -21,  -7,   1, -19, -17, -14, -10, -43, -27,
      3,  48,  -8,  22, -16,  -7,   4, -42,   9, -31,
      6, -20,  -6,  -4,   3, -43, -22, -20,  28,   5,
    }, {
      5,   7,  -7,  -4,  -9,   0, -21,  28,  -6, -48,
      2, -14, -15,  20,  -5,   0, -27, -14, -32, -28,
     -5,  32,  -2,   6, -32,   3, -12,  -5,   8, -25,
    -14,  -4,  12,  11,  -4, -47, -45, -22,  22,  -2,
    }, {
     34,  -6, -18, -55, -15, -11, -21,  16,   8, -16,
      6,  16,   5,  -4, -35, -24, -10, -12, -43,  -1,
     43,  47,  14,   8, -43,  -5,  10, -34,  39, -18,
     22, -16, -17, -42,  13, -19,   1,  -3,  14,  20,
    }, {
    -34,  14,   4, -17,   5, -24, -26,  20, -27, -45,
    -12,  24,  -2,  13, -21,  -8, -22, -16, -32,  -2,
     34,  31,  20,  -7, -58,   5,  -5,   2,  38, -12,
      2,  -1,   1, -26,   5, -23, -21,  -6,   8,  11,
    }, {
    124, -13, -21, -23, -62,  23,   0,  43,  57,   8,
    -13, -18,  14, -10,   6, -26,  -3,  49, -19,  19,
    -31,  27,  -7,   0,  11, -20,  29,  -1,  12, -47,
      4, -39,  11,  34,  28,  -9,  -5, -19, -13, -34,
    }, {
     55,   6,   1,  14, -41,  10,  -4,  48,  22, -20,
    -31, -10,   5,   7,  20,  -9, -16,  45,  -8,  19,
    -40,  12,  -1, -15,  -4, -10,  12,  34,  11, -41,
    -16, -24,  30,  49,  20, -13, -28, -22, -18, -43,
    }, {
     84,  -6,  -9, -36, -47,  -1,  -4,  36,  36,  12,
    -27,  20,  26, -17,  -9, -33,   1,  47, -19,  46,
      9,  27,  15, -13, -15, -18,  35,   6,  42, -33,
     20, -36,   1,  -4,  38,  14,  18,  -2, -27, -20,
    }, {
     15,  13,  13,   1, -26, -14,  -9,  41,   1, -16,
    -46,  27,  18,   1,   4, -16, -11,  43,  -8,  45,
      0,  11,  21, -29, -30,  -8,  19,  42,  41, -28,
      0, -20,  20,  11,  30,  10,  -4,  -5, -32, -28,
    }, {
     79,  -2, -12, -22, -42, -28,  -1,  51,  54,  15,
      8, -41,   0, -24,   6, -15,   1,  17, -36, -12,
    -14,  47,   0,  -6, -11, -26,  16, -27,  13, -43,
     22, -18,  10,  12,   2, -34,  15, -33,  13, -13,
    }, {
     10,  18,  10,  15, -21, -41,  -6,  56,  19, -13,
     -9, -33,  -9,  -6,  20,   1, -11,  13, -24, -13,
    -23,  32,   6, -22, -26, -15,   0,   8,  12, -37,
      1,  -2,  28,  27,  -5, -37,  -7, -35,   8, -21,
    }, {
     39,   4,   0, -35, -27, -53,  -6,  44,  33,  18,
     -5,  -2,  11, -31,  -9, -22,   6,  15, -36,  13,
     25,  46,  23, -20, -37, -24,  23, -19,  43, -29,
     38, -14,   0, -26,  12, -10,  38, -16,   0,   0,
    }, {
    -29,  25,  22,   2,  -6, -67, -11,  49,  -1, -10,
    -24,   5,   3, -13,   4,  -5,  -6,  11, -25,  12,
     16,  31,  28, -36, -53, -13,   6,  16,  42, -24,
     17,   1,  18, -10,   4, -13,  15, -18,  -5,  -7,
    }, {
     29, -25, -22,  -2,   6,  67,  11, -49,   1,  10,
     24,  -5,  -3,  13,  -4,   5,   6, -11,  25, -12,
    -16, -31, -28,  36,  53,  13,  -6, -16, -42,  24,
    -17,  -1, -18,  10,  -4,  13, -15,  18,   5,   7,
    }, {
    -39,  -4,   0,  35,  27,  53,   6, -44, -33, -18,
      5,   2, -11,  31,   9,  22,  -6, -15,  36, -13,
    -25, -46, -23,  20,  37,  24, -23,  19, -43,  29,
    -38,  14,   0,  26, -12,  10, -38,  16,   0,   0,
    }, {
    -10, -18, -10, -15,  21,  41,   6, -56, -19,  13,
      9,  33,   9,   6, -20,  -1,  11, -13,  24,  13,
     23, -32,  -6,  22,  26,  15,   0,  -8, -12,  37,
     -1,   2, -28, -27,   5,  37,   7,  35,  -8,  21,
    }, {
    -79,   2,  12,  22,  42,  28,   1, -51, -54, -15,
     -8,  41,   0,  24,  -6,  15,  -1, -17,  36,  12,
     14, -47,   0,   6,  11,  26, -16,  27, -13,  43,
    -22,  18, -10, -12,  -2,  34, -15,  33, -13,  13,
    }, {
    -15, -13, -13,  -1,  26,  14,   9, -41,  -1,  16,
     46, -27, -18,  -1,  -4,  16,  11, -43,   8, -45,
      0, -11, -21,  29,  30,   8, -19, -42, -41,  28,
      0,  20, -20, -11, -30, -10,   4,   5,  32,  28,
    }, {
    -84,   6,   9,  36,  47,   1,   4, -36, -36, -12,
     27, -20, -26,  17,   9,  33,  -1, -47,  19, -46,
     -9, -27, -15,  13,  15,  18, -35,  -6, -42,  33,
    -20,  36,  -1,   4, -38, -14, -18,   2,  27,  20,
    }, {
    -55,  -6,  -1, -14,  41, -10,   4, -48, -22,  20,
     31,  10,  -5,  -7, -20,   9,  16, -45,   8, -19,
     40, -12,   1,  15,   4,  10, -12, -34, -11,  41,
     16,  24, -30, -49, -20,  13,  28,  22,  18,  43,
    }, {
   -124,  13,  21,  23,  62, -23,   0, -43, -57,  -8,
     13,  18, -14,  10,  -6,  26,   3, -49,  19, -19,
     31, -27,   7,   0, -11,  20, -29,   1, -12,  47,
     -4,  39, -11, -34, -28,   9,   5,  19,  13,  34,
    }, {
     34, -14,  -4,  17,  -5,  24,  26, -20,  27,  45,
     12, -24,   2, -13,  21,   8,  22,  16,  32,   2,
    -34, -31, -20,   7,  58,  -5,   5,  -2, -38,  12,
     -2,   1,  -1,  26,  -5,  23,  21,   6,  -8, -11,
    }, {
    -34,   6,  18,  55,  15,  11,  21, -16,  -8,  16,
     -6, -16,  -5,   4,  35,  24,  10,  12,  43,   1,
    -43, -47, -14,  -8,  43,   5, -10,  34, -39,  18,
    -22,  16,  17,  42, -13,  19,  -1,   3, -14, -20,
    }, {
     -5,  -7,   7,   4,   9,   0,  21, -28,   6,  48,
     -2,  14,  15, -20,   5,   0,  27,  14,  32,  28,
      5, -32,   2,  -6,  32,  -3,  12,   5,  -8,  25,
     14,   4, -12, -11,   4,  47,  45,  22, -22,   2,
    }, {
    -74,  12,  30,  42,  30, -14,  16, -23, -29,  19,
    -20,  21,   7,  -1,  19,  17,  14,  10,  43,  27,
     -3, -48,   8, -22,  16,   7,  -4,  42,  -9,  31,
     -6,  20,   6,   4,  -3,  43,  22,  20, -28,  -5,
    }, {
    -10,  -3,   4,  18,  15, -27,  24, -13,  24,  51,
     34, -47, -12, -28,  21,  19,  27, -16,  15, -30,
    -17, -12, -12,   0,  36, -10,  -7, -27, -37,  16,
     15,  22,  -3,   4, -31,  -1,  42,  -7,  18,   9,
    }, {
    -79,  17,  27,  56,  36, -41,  19,  -8, -10,  22,
     15, -39, -20,  -9,  35,  35,  15, -20,  26, -31,
    -26, -27,  -6, -15,  20,   0, -23,   8, -38,  22,
     -5,  38,  15,  20, -39,  -4,  18,  -9,  13,   1,
    }, {
    -50,   3,  16,   5,  30, -53,  19, -20,   3,  55,
     19,  -8,   0, -34,   5,  11,  32, -18,  15,  -4,
     22, -13,  10, -13,   9,  -8,   0, -19,  -7,  29,
     31,  26, -13, -33, -21,  22,  65,   9,   4,  23,
    }, {
   -119,  24,  39,  44,  51, -66,  14, -15, -31,  26,
      1,   0,  -7, -16,  19,  28,  19, -22,  26,  -4,
     13, -28,  16, -29,  -5,   1, -16,  16,  -8,  35,
     10,  42,   4, -17, -29,  19,  42,   7,   0,  15,
    }, {
     31, -28,   6, -16, -16,  50, -31, -14,   0,   6,
     36,  17,   0,   0, -29, -14,  11,  18,  20, -25,
     -6, -33, -19,  20,  43,  21,  21, -14, -55,   0,
    -32, -40, -42,  39,   1,  -8, -14,   8,  -6,  -3,
    }, {
    -37,  -8,  29,  22,   4,  37, -36,  -9, -34, -22,
     17,  24,  -8,  18, -15,   2,  -1,  14,  31, -25,
    -15, -48, -13,   4,  28,  31,   5,  21, -57,   4,
    -53, -24, -23,  55,  -6, -12, -37,   6, -11, -11,
    }, {
     -7, -22,  18, -29,  -1,  25, -36, -21, -20,   9,
     22,  56,  11,  -6, -45, -21,  15,  16,  20,   1,
     33, -34,   2,   6,  17,  23,  28,  -6, -25,  12,
    -16, -37, -53,   1,  11,  15,   8,  25, -20,  11,
    }, {
    -76,  -1,  41,   9,  19,  12, -41, -17, -55, -18,
      3,  63,   3,  12, -30,  -5,   3,  12,  31,   0,
     24, -49,   8,  -9,   1,  33,  12,  29, -27,  18,
    -37, -21, -34,  17,   3,  11, -14,  23, -25,   2,
    }, {
    -13, -17,  15, -15,   3,  -1, -33,  -7,  -1,  12,
     58,  -5, -15, -13, -29,  -3,  16, -13,   4, -57,
     10, -13, -11,  13,  21,  15,   9, -40, -55,   3,
    -14, -19, -44,  17, -24, -32,   5,  -4,  21,  18,
    }, {
    -82,   3,  38,  23,  24, -15, -38,  -2, -37, -15,
     39,   2, -23,   4, -15,  12,   3, -17,  15, -58,
      1, -29,  -6,  -2,   5,  26,  -7,  -4, -56,   9,
    -35,  -3, -25,  33, -32, -36, -17,  -7,  15,   9,
    }, {
    -52, -10,  27, -27,  18, -26, -38, -14, -23,  16,
     44,  33,  -3, -20, -45, -10,  20, -15,   3, -31,
     50, -14,  10,   0,  -5,  17,  15, -32, -24,  16,
      1, -15, -55, -20, -14,  -8,  29,  12,   7,  32,
    }, {
   -121,   9,  50,  10,  40, -40, -43,  -9, -58, -12,
     25,  41, -11,  -2, -31,   5,   8, -19,  15, -32,
     41, -30,  16, -16, -20,  28,   0,   3, -26,  22,
    -19,   0, -36,  -4, -22, -12,   6,   9,   1,  24,
    }, {
     36, -18,  24,   3, -28,   7, -16,  13,  26,  41,
     24,  -1,   5, -26,  -3, -12,  27,  46,  27, -10,
    -24, -34, -10,  -8,  49,   2,  34,   0, -51, -12,
    -17, -38, -25,  56,   0,   0,  22,  -3, -20, -22,
    }, {
    -32,   2,  47,  42,  -7,  -5, -21,  18,  -9,  12,
      5,   5,  -2,  -8,  10,   4,  14,  42,  38, -10,
    -33, -49,  -5, -24,  33,  12,  17,  35, -52,  -6,
    -38, -22,  -7,  72,  -7,  -3,   0,  -6, -25, -30,
    }, {
     -2, -11,  36,  -9, -13, -17, -21,   6,   5,  45,
     10,  36,  18, -33, -19, -19,  31,  44,  27,  15,
     16, -34,  11, -22,  22,   4,  40,   7, -21,   0,
     -1, -35, -36,  18,  10,  24,  46,  12, -34,  -8,
    }, {
    -71,   9,  59,  29,   8, -30, -26,  11, -30,  16,
     -8,  44,   9, -14,  -5,  -2,  19,  40,  38,  15,
      7, -50,  17, -38,   7,  14,  24,  43, -22,   6,
    -22, -19, -17,  34,   2,  20,  23,  10, -39, -16,
    }, {
     -8,  -6,  33,   4,  -7, -44, -18,  21,  23,  48,
     46, -24,  -9, -40,  -3,  -1,  32,  13,  11, -43,
     -7, -14,  -3, -15,  26,  -3,  21, -26, -50,  -8,
      0, -16, -27,  34, -25, -23,  43, -17,   6,  -1,
    }, {
    -77,  13,  56,  43,  13, -57, -23,  26, -11,  19,
     27, -16, -17, -22,  10,  15,  19,  10,  22, -43,
    -16, -30,   2, -31,  11,   6,   5,   9, -52,  -2,
    -20,   0,  -8,  50, -33, -27,  19, -19,   1,  -9,
    }, {
    -47,   0,  45,  -7,   7, -69, -23,  13,   2,  51,
     32,  14,   3, -47, -19,  -8,  37,  11,  10, -16,
     32, -15,  19, -29,   0,  -1,  28, -18, -20,   4,
     16, -13, -38,  -3, -15,   0,  66,   0,  -7,  13,
    }, {
   -116,  20,  68,  30,  28, -83, -28,  18, -32,  22,
     13,  21,  -5, -28,  -5,   7,  24,   8,  22, -17,
     23, -30,  25, -45, -15,   9,  11,  18, -22,  10,
     -4,   2, -19,  12, -23,  -3,  43,  -2, -12,   4,
    }, {
     72, -13, -29, -18,   4,  90,  37, -34,   4,  -1,
     13,  -9,  -6,  11,   2,  24, -13,   3,  -7, -11,
     -4,   4, -42,  25,  31,  -1,  -8, -29,  -6,  17,
    -19,   2, -10,  -6,  38,  22, -42, -19,  -6, -11,
    }, {
      3,   7,  -6,  20,  25,  77,  32, -29, -31, -30,
     -4,  -2, -14,  29,  16,  40, -26,   0,   3, -12,
    -13, -10, -36,   9,  15,   8, -24,   6,  -7,  22,
    -40,  17,   8,   9,  31,  18, -66, -22, -11, -19,
    }, {
     32,  -6, -17, -31,  19,  65,  33, -41, -16,   1,
      0,  29,   6,   4, -13,  17,  -9,   1,  -8,  14,
     35,   3, -19,  11,   4,   0,  -1, -21,  23,  30,
     -3,   5, -20, -44,  48,  46, -19,  -3, -20,   3,
    }, {
    -36,  13,   5,   7,  40,  51,  28, -36, -52, -27,
    -18,  36,  -2,  22,   0,  33, -21,  -2,   3,  13,
     26, -11, -14,  -4, -10,  10, -18,  14,  22,  36,
    -24,  21,  -1, -28,  40,  42, -42,  -5, -25,  -5,
    }, {
     27,  -1, -20, -17,  24,  38,  35, -26,   1,   4,
     35, -32, -21,  -3,   2,  35,  -8, -29, -24, -44,
     12,  24, -34,  18,   8,  -7, -21, -55,  -5,  21,
     -2,  23, -11, -28,  13,  -1, -22, -33,  21,  10,
    }, {
    -41,  18,   2,  21,  45,  24,  30, -21, -33, -24,
     17, -24, -29,  15,  16,  51, -21, -33, -13, -45,
      3,   8, -28,   2,  -7,   2, -37, -19,  -7,  27,
    -22,  39,   7, -12,   5,  -5, -45, -35,  15,   1,
    }, {
    -12,   4,  -8, -29,  39,  12,  30, -33, -19,   8,
     21,   6,  -8,  -9, -13,  28,  -4, -31, -24, -18,
     52,  23, -12,   4, -18,  -5, -14, -47,  24,  34,
     14,  27, -22, -66,  22,  22,   1, -16,   6,  24,
    }, {
    -81,  25,  14,   8,  61,   0,  25, -28, -54, -20,
      3,  14, -17,   8,   0,  44, -16, -35, -13, -18,
     43,   7,  -6, -11, -33,   4, -30, -11,  22,  40,
     -6,  43,  -3, -50,  14,  18, -22, -18,   1,  16,
    }, {
     77,  -2, -11,   1,  -7,  47,  52,  -5,  29,  33,
      1, -28,   0, -15,  28,  26,   2,  30,   0,   2,
    -22,   4, -33,  -3,  36, -21,   3, -15,  -2,   5,
     -4,   4,   6,   9,  37,  31,  -5, -32, -20, -30,
    }, {
      8,  17,  10,  40,  13,  34,  47,   0,  -5,   4,
    -16, -21,  -8,   2,  42,  43, -10,  26,  10,   2,
    -31, -11, -27, -19,  21, -10, -12,  20,  -3,  11,
    -25,  20,  25,  25,  29,  28, -28, -34, -25, -38,
    }, {
     37,   3,   0, -10,   7,  22,  48, -12,   8,  36,
    -12,   9,  12, -22,  12,  19,   6,  28,   0,  29,
     18,   3, -11, -17,  10, -18,  10,  -7,  27,  18,
     11,   7,  -3, -28,  47,  55,  18, -15, -34, -16,
    }, {
    -31,  24,  23,  27,  29,   9,  43,  -8, -26,   7,
    -30,  17,   4,  -3,  26,  35,  -5,  24,  10,  28,
      9, -12,  -5, -33,  -5,  -8,  -5,  29,  26,  24,
     -9,  23,  14, -12,  39,  52,  -5, -18, -39, -24,
    }, {
     32,   8,  -3,   2,  13,  -4,  50,   1,  27,  39,
     23, -51, -15, -30,  27,  37,   7,  -1, -17, -29,
     -5,  23, -25, -10,  14, -26,  -8, -41,  -1,   9,
     13,  26,   5, -12,  12,   7,  14, -45,   6,  -9,
    }, {
    -36,  29,  19,  41,  34, -18,  45,   6,  -8,  10,
      5, -43, -23, -11,  42,  53,  -5,  -5,  -6, -30,
    -14,   8, -20, -26,  -1, -16, -25,  -4,  -3,  15,
     -7,  41,  23,   3,   4,   3,  -8, -48,   1, -17,
    }, {
     -7,  15,   9,  -9,  28, -29,  45,  -5,   6,  43,
      9, -12,  -2, -36,  12,  30,  11,  -3, -17,  -3,
     34,  22,  -3, -24, -12, -24,  -2, -32,  28,  22,
     29,  29,  -5, -50,  21,  31,  38, -29,  -7,   5,
    }, {
    -76,  35,  31,  28,  49, -43,  40,   0, -29,  14,
     -8,  -5, -10, -18,  26,  46,   0,  -7,  -6,  -3,
     25,   7,   2, -40, -28, -14, -18,   3,  27,  28,
      8,  45,  13, -34,  13,  27,  15, -31, -12,  -3,
    }, {
     74, -17,   0, -31, -18,  73,  -5,   0,   3,  -5,
     25,  12,  -3,  -1, -22,   3,  -9,  33, -12, -24,
      6,   2, -33,   9,  21,   5,  20, -27, -19,  -7,
    -34, -37, -34,  22,  44,   0, -41, -29, -17, -21,
    }, {
      5,   3,  21,   7,   2,  60, -10,   5, -32, -34,
      7,  20, -11,  16,  -8,  20, -21,  29,  -1, -24,
     -2, -13, -27,  -6,   5,  15,   3,   8, -21,  -1,
    -55, -21, -15,  38,  37,  -3, -65, -32, -23, -30,
    }, {
     35, -10,  11, -44,  -3,  48, -10,  -6, -17,  -2,
     11,  51,   8,  -8, -38,  -3,  -4,  31, -12,   2,
     46,   1, -10,  -4,  -5,   7,  26, -19,  10,   5,
    -18, -34, -45, -15,  54,  24, -18, -13, -31,  -7,
    }, {
    -33,  10,  34,  -5,  17,  35, -15,  -1, -53, -30,
     -6,  59,   0,  10, -24,  13, -17,  27,  -1,   1,
     37, -13,  -4, -20, -20,  18,  10,  16,   8,  11,
    -39, -18, -26,   0,  46,  20, -41, -15, -37, -15,
    }, {
     29,  -5,   7, -30,   1,  21,  -7,   7,   0,   0,
     47,  -9, -18, -15, -22,  14,  -4,   0, -28, -57,
     23,  21, -25,   2,  -1,   0,   7, -53, -19,  -3,
    -17, -15, -36,   0,  19, -24, -21, -43,   9,   0,
    }, {
    -39,  14,  30,   8,  22,   8, -12,  12, -34, -27,
     29,  -2, -26,   2,  -8,  31, -16,  -3, -17, -57,
     14,   6, -19, -13, -16,  10,  -8, -17, -20,   2,
    -38,   0, -17,  16,  11, -27, -44, -45,   4,  -8,
    }, {
     -9,   1,  20, -43,  17,  -3, -12,   0, -20,   4,
     33,  29,  -6, -22, -38,   7,   0,  -1, -29, -30,
     63,  21,  -3, -11, -27,   1,  14, -45,  10,   9,
     -1, -12, -47, -37,  28,   0,   2, -26,  -4,  13,
    }, {
    -78,  21,  43,  -4,  38, -17, -17,   5, -55, -24,
     15,  36, -14,  -4, -24,  24, -12,  -5, -17, -31,
     54,   5,   2, -27, -43,  12,  -2,  -9,   9,  15,
    -22,   3, -28, -21,  20,  -3, -20, -28,  -9,   5,
    }, {
     80,  -6,  16, -11, -30,  30,   9,  28,  28,  29,
     13,  -6,   2, -28,   3,   5,   7,  60,  -5,  -9,
    -11,   1, -24, -19,  27, -13,  32, -13, -15, -19,
    -19, -35, -17,  39,  43,   9,  -4, -42, -32, -41,
    }, {
     11,  14,  39,  27,  -9,  17,   4,  33,  -6,   0,
     -4,   1,  -5, -10,  17,  22,  -5,  57,   5,  -9,
    -20, -13, -18, -35,  11,  -3,  16,  22, -17, -13,
    -40, -19,   1,  55,  35,   5, -27, -44, -37, -49,
    }, {
     40,   0,  28, -24, -14,   5,   4,  21,   7,  33,
      0,  32,  15, -35, -12,  -1,  11,  58,  -5,  16,
     28,   0,  -1, -33,   0, -11,  39,  -5,  14,  -6,
     -3, -31, -28,   1,  53,  33,  19, -25, -46, -26,
    }, {
    -28,  20,  51,  14,   6,  -7,   0,  26, -27,   4,
    -18,  40,   6, -16,   1,  15,   0,  55,   5,  16,
     19, -14,   3, -49, -14,  -1,  22,  30,  12,   0,
    -24, -15,  -9,  17,  45,  29,  -4, -28, -51, -35,
    }, {
     34,   4,  25, -10,  -9, -21,   7,  36,  26,  36,
     35, -28, -12, -42,   3,  16,  12,  28, -21, -42,
      5,  21, -16, -26,   4, -19,  19, -39, -15, -15,
     -1, -13, -19,  17,  17, -14,  15, -55,  -4, -19,
    }, {
    -34,  25,  48,  28,  11, -34,   2,  41,  -9,   7,
     17, -21, -20, -24,  17,  33,   0,  24, -10, -42,
     -3,   5, -10, -42, -11,  -8,   3,  -3, -16,  -9,
    -22,   2,   0,  33,  10, -18,  -7, -58, -10, -28,
    }, {
     -4,  11,  37, -23,   5, -46,   2,  29,   5,  39,
     21,   9,   0, -49, -12,   9,  16,  26, -22, -15,
     45,  20,   5, -40, -22, -17,  26, -31,  14,  -2,
     14, -10, -30, -20,  27,   9,  39, -39, -18,  -5,
    }, {
    -73,  32,  60,  15,  26, -59,  -2,  33, -30,  10,
      3,  17,  -8, -30,   1,  26,   4,  22, -10, -16,
     36,   5,  11, -56, -37,  -6,  10,   5,  13,   3,
     -6,   5, -11,  -4,  19,   5,  16, -41, -24, -13
    }
};

static const uint16_t cb1_base[128]={
    19657, 18474, 18365, 17520, 21048, 18231, 18584, 16671,
    20363, 19069, 19409, 18430, 21844, 18753, 19613, 17411,
    20389, 21772, 20129, 21702, 20978, 20472, 19627, 19387,
    21477, 23134, 21841, 23919, 22089, 21519, 21134, 20852,
    19675, 17821, 19044, 17477, 19986, 16955, 18446, 16086,
    21138, 18899, 20952, 18929, 21452, 17833, 20104, 17159,
    19770, 20056, 20336, 20866, 19329, 18217, 18908, 18004,
    21556, 21948, 23079, 23889, 20922, 19544, 20984, 19781,
    19781, 20984, 19544, 20922, 23889, 23079, 21948, 21556,
    18004, 18908, 18217, 19329, 20866, 20336, 20056, 19770,
    17159, 20104, 17833, 21452, 18929, 20952, 18899, 21138,
    16086, 18446, 16955, 19986, 17477, 19044, 17821, 19675,
    20852, 21134, 21519, 22089, 23919, 21841, 23134, 21477,
    19387, 19627, 20472, 20978, 21702, 20129, 21772, 20389,
    17411, 19613, 18753, 21844, 18430, 19409, 19069, 20363,
    16671, 18584, 18231, 21048, 17520, 18365, 18474, 19657,
};

static const uint16_t cb2_base[128]={
    12174, 13380, 13879, 13832, 13170, 13227, 13204, 12053,
    12410, 13988, 14348, 14631, 13100, 13415, 13224, 12268,
    11982, 13825, 13499, 14210, 13877, 14788, 13811, 13109,
    11449, 13275, 12833, 13717, 12728, 13696, 12759, 12405,
    10230, 12185, 11628, 13161, 11762, 13458, 12312, 12818,
    10443, 12773, 12011, 14020, 11818, 13825, 12453, 13226,
    10446, 13162, 11881, 14300, 12859, 16288, 13490, 15053,
    10155, 12820, 11519, 13973, 12041, 15081, 12635, 14198,
    14198, 12635, 15081, 12041, 13973, 11519, 12820, 10155,
    15053, 13490, 16288, 12859, 14300, 11881, 13162, 10446,
    13226, 12453, 13825, 11818, 14020, 12011, 12773, 10443,
    12818, 12312, 13458, 11762, 13161, 11628, 12185, 10230,
    12405, 12759, 13696, 12728, 13717, 12833, 13275, 11449,
    13109, 13811, 14788, 13877, 14210, 13499, 13825, 11982,
    12268, 13224, 13415, 13100, 14631, 14348, 13988, 12410,
    12053, 13204, 13227, 13170, 13832, 13879, 13380, 12174,
};

static const int16_t energy_tab[32]={
        0,    16,    20,    25,    32,    41,    51,    65,
       81,   103,   129,   163,   205,   259,   326,   410,
      516,   650,   819,  1031,  1298,  1634,  2057,  2590,
     3261,  4105,  5168,  6507,  8192, 10313, 12983, 16345
};

static const int16_t lpc_refl_cb1[64]={
    -4041, -4018, -3998, -3977, -3954, -3930, -3906, -3879,
    -3852, -3825, -3795, -3764, -3731, -3699, -3666, -3631,
    -3594, -3555, -3513, -3468, -3420, -3372, -3321, -3268,
    -3212, -3153, -3090, -3021, -2944, -2863, -2772, -2676,
    -2565, -2445, -2328, -2202, -2072, -1941, -1808, -1660,
    -1508, -1348, -1185,  -994,  -798,  -600,  -374,  -110,
      152,   447,   720,   982,  1229,  1456,  1682,  1916,
     2130,  2353,  2595,  2853,  3118,  3363,  3588,  3814
};

static const int16_t lpc_refl_cb2[32]={
    -3091, -2386, -1871, -1425, -1021,  -649,  -316,   -20,
      267,   544,   810,  1065,  1305,  1534,  1756,  1970,
     2171,  2359,  2536,  2700,  2854,  2996,  3133,  3263,
     3386,  3499,  3603,  3701,  3789,  3870,  3947,  4020
};

static const int16_t lpc_refl_cb3[32]={
    -3525, -3295, -3081, -2890, -2696, -2511, -2328, -2149,
    -1979, -1817, -1658, -1498, -1341, -1188, -1032,  -876,
     -721,  -561,  -394,  -228,   -54,   119,   296,   484,
      683,   895,  1123,  1373,  1651,  1965,  2360,  2854
};

static const int16_t lpc_refl_cb4[16]={
    -1845, -1057,  -522,   -77,   301,   647,   975,  1285,
     1582,  1873,  2163,  2452,  2735,  3017,  3299,  3569
};

static const int16_t lpc_refl_cb5[16]={
    -2691, -2187, -1788, -1435, -1118,  -837,  -571,  -316,
      -59,   201,   470,   759,  1077,  1457,  1908,  2495
};

static const int16_t lpc_refl_cb6[8]={
    -1372,  -474,   133,   632,  1100,  1571,  2075,  2672
};

static const int16_t lpc_refl_cb7[8]={
    -2389, -1787, -1231,  -717,  -239,   234,   770,  1474
};

static const int16_t lpc_refl_cb8[8]={
    -1569,  -864,  -296,   200,   670,  1151,  1709,  2385
};

static const int16_t lpc_refl_cb9[8]={
    -2200, -1608, -1062,  -569,  -120,   338,   863,  1621
};

static const int16_t lpc_refl_cb10[4]={
     -617,   190,   802,  1483
};

static const int16_t * const lpc_refl_cb[10]={
    lpc_refl_cb1, lpc_refl_cb2, lpc_refl_cb3, lpc_refl_cb4, lpc_refl_cb5,
    lpc_refl_cb6, lpc_refl_cb7, lpc_refl_cb8, lpc_refl_cb9, lpc_refl_cb10
};

#endif /* AVCODEC_RA144_H */
