/*
 * Real Audio 1.0 (14.4K)
 * Copyright (c) 2003 the ffmpeg project
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef FFMPEG_RA144_H
#define FFMPEG_RA144_H

/* 14.4 data tables */
static const unsigned short sqrt_table[4096]={
        0,  1024,  1448,  1773,  2048,  2289,  2508,  2709,
     2896,  3072,  3238,  3396,  3547,  3692,  3831,  3965,
     4096,  4222,  4344,  4463,  4579,  4692,  4802,  4910,
     5016,  5120,  5221,  5320,  5418,  5514,  5608,  5701,
     5792,  5882,  5970,  6058,  6144,  6228,  6312,  6394,
     6476,  6556,  6636,  6714,  6792,  6869,  6945,  7020,
     7094,  7168,  7240,  7312,  7384,  7454,  7524,  7594,
     7662,  7731,  7798,  7865,  7931,  7997,  8062,  8127,
     8192,  8255,  8319,  8381,  8444,  8505,  8567,  8628,
     8688,  8749,  8808,  8868,  8927,  8985,  9043,  9101,
     9158,  9216,  9272,  9329,  9385,  9440,  9496,  9551,
     9605,  9660,  9714,  9768,  9821,  9875,  9928,  9980,
    10033, 10085, 10137, 10188, 10240, 10291, 10341, 10392,
    10442, 10492, 10542, 10592, 10641, 10690, 10739, 10788,
    10836, 10885, 10933, 10981, 11028, 11076, 11123, 11170,
    11217, 11264, 11310, 11356, 11402, 11448, 11494, 11539,
    11585, 11630, 11675, 11720, 11764, 11809, 11853, 11897,
    11941, 11985, 12029, 12072, 12116, 12159, 12202, 12245,
    12288, 12330, 12373, 12415, 12457, 12499, 12541, 12583,
    12624, 12666, 12707, 12748, 12789, 12830, 12871, 12912,
    12952, 12993, 13033, 13073, 13113, 13153, 13193, 13232,
    13272, 13312, 13351, 13390, 13429, 13468, 13507, 13546,
    13584, 13623, 13661, 13700, 13738, 13776, 13814, 13852,
    13890, 13927, 13965, 14002, 14040, 14077, 14114, 14151,
    14188, 14225, 14262, 14299, 14336, 14372, 14408, 14445,
    14481, 14517, 14553, 14589, 14625, 14661, 14697, 14732,
    14768, 14803, 14839, 14874, 14909, 14944, 14979, 15014,
    15049, 15084, 15119, 15153, 15188, 15222, 15257, 15291,
    15325, 15360, 15394, 15428, 15462, 15495, 15529, 15563,
    15597, 15630, 15664, 15697, 15730, 15764, 15797, 15830,
    15863, 15896, 15929, 15962, 15995, 16028, 16060, 16093,
    16125, 16158, 16190, 16223, 16255, 16287, 16319, 16351,
    16384, 16415, 16447, 16479, 16511, 16543, 16574, 16606,
    16638, 16669, 16700, 16732, 16763, 16794, 16826, 16857,
    16888, 16919, 16950, 16981, 17011, 17042, 17073, 17104,
    17134, 17165, 17195, 17226, 17256, 17287, 17317, 17347,
    17377, 17408, 17438, 17468, 17498, 17528, 17557, 17587,
    17617, 17647, 17676, 17706, 17736, 17765, 17795, 17824,
    17854, 17883, 17912, 17941, 17971, 18000, 18029, 18058,
    18087, 18116, 18145, 18174, 18203, 18231, 18260, 18289,
    18317, 18346, 18375, 18403, 18432, 18460, 18488, 18517,
    18545, 18573, 18601, 18630, 18658, 18686, 18714, 18742,
    18770, 18798, 18826, 18853, 18881, 18909, 18937, 18964,
    18992, 19019, 19047, 19075, 19102, 19129, 19157, 19184,
    19211, 19239, 19266, 19293, 19320, 19347, 19374, 19402,
    19429, 19456, 19482, 19509, 19536, 19563, 19590, 19617,
    19643, 19670, 19697, 19723, 19750, 19776, 19803, 19829,
    19856, 19882, 19908, 19935, 19961, 19987, 20013, 20040,
    20066, 20092, 20118, 20144, 20170, 20196, 20222, 20248,
    20274, 20300, 20325, 20351, 20377, 20403, 20428, 20454,
    20480, 20505, 20531, 20556, 20582, 20607, 20633, 20658,
    20683, 20709, 20734, 20759, 20784, 20810, 20835, 20860,
    20885, 20910, 20935, 20960, 20985, 21010, 21035, 21060,
    21085, 21110, 21135, 21159, 21184, 21209, 21234, 21258,
    21283, 21308, 21332, 21357, 21381, 21406, 21430, 21455,
    21479, 21504, 21528, 21552, 21577, 21601, 21625, 21649,
    21673, 21698, 21722, 21746, 21770, 21794, 21818, 21842,
    21866, 21890, 21914, 21938, 21962, 21986, 22010, 22033,
    22057, 22081, 22105, 22128, 22152, 22176, 22199, 22223,
    22246, 22270, 22294, 22317, 22341, 22364, 22387, 22411,
    22434, 22458, 22481, 22504, 22528, 22551, 22574, 22597,
    22620, 22644, 22667, 22690, 22713, 22736, 22759, 22782,
    22805, 22828, 22851, 22874, 22897, 22920, 22943, 22965,
    22988, 23011, 23034, 23057, 23079, 23102, 23125, 23147,
    23170, 23193, 23215, 23238, 23260, 23283, 23305, 23328,
    23350, 23373, 23395, 23418, 23440, 23462, 23485, 23507,
    23529, 23552, 23574, 23596, 23618, 23640, 23663, 23685,
    23707, 23729, 23751, 23773, 23795, 23817, 23839, 23861,
    23883, 23905, 23927, 23949, 23971, 23993, 24014, 24036,
    24058, 24080, 24102, 24123, 24145, 24167, 24188, 24210,
    24232, 24253, 24275, 24297, 24318, 24340, 24361, 24383,
    24404, 24426, 24447, 24469, 24490, 24511, 24533, 24554,
    24576, 24597, 24618, 24639, 24661, 24682, 24703, 24724,
    24746, 24767, 24788, 24809, 24830, 24851, 24872, 24893,
    24914, 24936, 24957, 24978, 24999, 25019, 25040, 25061,
    25082, 25103, 25124, 25145, 25166, 25187, 25207, 25228,
    25249, 25270, 25290, 25311, 25332, 25353, 25373, 25394,
    25415, 25435, 25456, 25476, 25497, 25517, 25538, 25559,
    25579, 25600, 25620, 25640, 25661, 25681, 25702, 25722,
    25742, 25763, 25783, 25803, 25824, 25844, 25864, 25885,
    25905, 25925, 25945, 25966, 25986, 26006, 26026, 26046,
    26066, 26086, 26106, 26127, 26147, 26167, 26187, 26207,
    26227, 26247, 26267, 26287, 26307, 26326, 26346, 26366,
    26386, 26406, 26426, 26446, 26465, 26485, 26505, 26525,
    26545, 26564, 26584, 26604, 26624, 26643, 26663, 26683,
    26702, 26722, 26741, 26761, 26781, 26800, 26820, 26839,
    26859, 26878, 26898, 26917, 26937, 26956, 26976, 26995,
    27014, 27034, 27053, 27073, 27092, 27111, 27131, 27150,
    27169, 27189, 27208, 27227, 27246, 27266, 27285, 27304,
    27323, 27342, 27362, 27381, 27400, 27419, 27438, 27457,
    27476, 27495, 27514, 27533, 27553, 27572, 27591, 27610,
    27629, 27648, 27666, 27685, 27704, 27723, 27742, 27761,
    27780, 27799, 27818, 27836, 27855, 27874, 27893, 27912,
    27930, 27949, 27968, 27987, 28005, 28024, 28043, 28062,
    28080, 28099, 28118, 28136, 28155, 28173, 28192, 28211,
    28229, 28248, 28266, 28285, 28303, 28322, 28340, 28359,
    28377, 28396, 28414, 28433, 28451, 28470, 28488, 28506,
    28525, 28543, 28562, 28580, 28598, 28617, 28635, 28653,
    28672, 28690, 28708, 28726, 28745, 28763, 28781, 28799,
    28817, 28836, 28854, 28872, 28890, 28908, 28926, 28944,
    28963, 28981, 28999, 29017, 29035, 29053, 29071, 29089,
    29107, 29125, 29143, 29161, 29179, 29197, 29215, 29233,
    29251, 29269, 29287, 29305, 29322, 29340, 29358, 29376,
    29394, 29412, 29429, 29447, 29465, 29483, 29501, 29518,
    29536, 29554, 29572, 29589, 29607, 29625, 29642, 29660,
    29678, 29696, 29713, 29731, 29748, 29766, 29784, 29801,
    29819, 29836, 29854, 29872, 29889, 29907, 29924, 29942,
    29959, 29977, 29994, 30012, 30029, 30047, 30064, 30081,
    30099, 30116, 30134, 30151, 30168, 30186, 30203, 30221,
    30238, 30255, 30273, 30290, 30307, 30324, 30342, 30359,
    30376, 30394, 30411, 30428, 30445, 30462, 30480, 30497,
    30514, 30531, 30548, 30566, 30583, 30600, 30617, 30634,
    30651, 30668, 30685, 30702, 30720, 30737, 30754, 30771,
    30788, 30805, 30822, 30839, 30856, 30873, 30890, 30907,
    30924, 30941, 30958, 30974, 30991, 31008, 31025, 31042,
    31059, 31076, 31093, 31110, 31126, 31143, 31160, 31177,
    31194, 31211, 31227, 31244, 31261, 31278, 31294, 31311,
    31328, 31345, 31361, 31378, 31395, 31411, 31428, 31445,
    31461, 31478, 31495, 31511, 31528, 31545, 31561, 31578,
    31595, 31611, 31628, 31644, 31661, 31677, 31694, 31710,
    31727, 31744, 31760, 31777, 31793, 31809, 31826, 31842,
    31859, 31875, 31892, 31908, 31925, 31941, 31957, 31974,
    31990, 32007, 32023, 32039, 32056, 32072, 32088, 32105,
    32121, 32137, 32154, 32170, 32186, 32203, 32219, 32235,
    32251, 32268, 32284, 32300, 32316, 32333, 32349, 32365,
    32381, 32397, 32414, 32430, 32446, 32462, 32478, 32494,
    32510, 32527, 32543, 32559, 32575, 32591, 32607, 32623,
    32639, 32655, 32671, 32687, 32703, 32719, 32735, 32751,
    32768, 32783, 32799, 32815, 32831, 32847, 32863, 32879,
    32895, 32911, 32927, 32943, 32959, 32975, 32991, 33007,
    33023, 33038, 33054, 33070, 33086, 33102, 33118, 33133,
    33149, 33165, 33181, 33197, 33212, 33228, 33244, 33260,
    33276, 33291, 33307, 33323, 33339, 33354, 33370, 33386,
    33401, 33417, 33433, 33448, 33464, 33480, 33495, 33511,
    33527, 33542, 33558, 33574, 33589, 33605, 33620, 33636,
    33652, 33667, 33683, 33698, 33714, 33729, 33745, 33760,
    33776, 33792, 33807, 33823, 33838, 33854, 33869, 33884,
    33900, 33915, 33931, 33946, 33962, 33977, 33993, 34008,
    34023, 34039, 34054, 34070, 34085, 34100, 34116, 34131,
    34146, 34162, 34177, 34193, 34208, 34223, 34238, 34254,
    34269, 34284, 34300, 34315, 34330, 34346, 34361, 34376,
    34391, 34407, 34422, 34437, 34452, 34467, 34483, 34498,
    34513, 34528, 34543, 34559, 34574, 34589, 34604, 34619,
    34634, 34649, 34665, 34680, 34695, 34710, 34725, 34740,
    34755, 34770, 34785, 34800, 34816, 34831, 34846, 34861,
    34876, 34891, 34906, 34921, 34936, 34951, 34966, 34981,
    34996, 35011, 35026, 35041, 35056, 35071, 35086, 35100,
    35115, 35130, 35145, 35160, 35175, 35190, 35205, 35220,
    35235, 35250, 35264, 35279, 35294, 35309, 35324, 35339,
    35353, 35368, 35383, 35398, 35413, 35428, 35442, 35457,
    35472, 35487, 35501, 35516, 35531, 35546, 35560, 35575,
    35590, 35605, 35619, 35634, 35649, 35664, 35678, 35693,
    35708, 35722, 35737, 35752, 35766, 35781, 35796, 35810,
    35825, 35840, 35854, 35869, 35883, 35898, 35913, 35927,
    35942, 35956, 35971, 35985, 36000, 36015, 36029, 36044,
    36058, 36073, 36087, 36102, 36116, 36131, 36145, 36160,
    36174, 36189, 36203, 36218, 36232, 36247, 36261, 36276,
    36290, 36305, 36319, 36333, 36348, 36362, 36377, 36391,
    36406, 36420, 36434, 36449, 36463, 36477, 36492, 36506,
    36521, 36535, 36549, 36564, 36578, 36592, 36607, 36621,
    36635, 36650, 36664, 36678, 36692, 36707, 36721, 36735,
    36750, 36764, 36778, 36792, 36807, 36821, 36835, 36849,
    36864, 36878, 36892, 36906, 36920, 36935, 36949, 36963,
    36977, 36991, 37005, 37020, 37034, 37048, 37062, 37076,
    37090, 37104, 37119, 37133, 37147, 37161, 37175, 37189,
    37203, 37217, 37231, 37246, 37260, 37274, 37288, 37302,
    37316, 37330, 37344, 37358, 37372, 37386, 37400, 37414,
    37428, 37442, 37456, 37470, 37484, 37498, 37512, 37526,
    37540, 37554, 37568, 37582, 37596, 37610, 37624, 37638,
    37652, 37665, 37679, 37693, 37707, 37721, 37735, 37749,
    37763, 37777, 37791, 37804, 37818, 37832, 37846, 37860,
    37874, 37888, 37901, 37915, 37929, 37943, 37957, 37970,
    37984, 37998, 38012, 38026, 38039, 38053, 38067, 38081,
    38095, 38108, 38122, 38136, 38150, 38163, 38177, 38191,
    38204, 38218, 38232, 38246, 38259, 38273, 38287, 38300,
    38314, 38328, 38341, 38355, 38369, 38382, 38396, 38410,
    38423, 38437, 38451, 38464, 38478, 38492, 38505, 38519,
    38532, 38546, 38560, 38573, 38587, 38600, 38614, 38628,
    38641, 38655, 38668, 38682, 38695, 38709, 38722, 38736,
    38749, 38763, 38777, 38790, 38804, 38817, 38831, 38844,
    38858, 38871, 38885, 38898, 38912, 38925, 38938, 38952,
    38965, 38979, 38992, 39006, 39019, 39033, 39046, 39059,
    39073, 39086, 39100, 39113, 39126, 39140, 39153, 39167,
    39180, 39193, 39207, 39220, 39234, 39247, 39260, 39274,
    39287, 39300, 39314, 39327, 39340, 39354, 39367, 39380,
    39394, 39407, 39420, 39433, 39447, 39460, 39473, 39487,
    39500, 39513, 39526, 39540, 39553, 39566, 39579, 39593,
    39606, 39619, 39632, 39646, 39659, 39672, 39685, 39698,
    39712, 39725, 39738, 39751, 39764, 39778, 39791, 39804,
    39817, 39830, 39843, 39857, 39870, 39883, 39896, 39909,
    39922, 39936, 39949, 39962, 39975, 39988, 40001, 40014,
    40027, 40040, 40053, 40067, 40080, 40093, 40106, 40119,
    40132, 40145, 40158, 40171, 40184, 40197, 40210, 40223,
    40236, 40249, 40262, 40275, 40288, 40301, 40314, 40327,
    40340, 40353, 40366, 40379, 40392, 40405, 40418, 40431,
    40444, 40457, 40470, 40483, 40496, 40509, 40522, 40535,
    40548, 40561, 40574, 40587, 40600, 40612, 40625, 40638,
    40651, 40664, 40677, 40690, 40703, 40716, 40728, 40741,
    40754, 40767, 40780, 40793, 40806, 40818, 40831, 40844,
    40857, 40870, 40883, 40895, 40908, 40921, 40934, 40947,
    40960, 40972, 40985, 40998, 41011, 41023, 41036, 41049,
    41062, 41075, 41087, 41100, 41113, 41126, 41138, 41151,
    41164, 41177, 41189, 41202, 41215, 41227, 41240, 41253,
    41266, 41278, 41291, 41304, 41316, 41329, 41342, 41354,
    41367, 41380, 41392, 41405, 41418, 41430, 41443, 41456,
    41468, 41481, 41494, 41506, 41519, 41532, 41544, 41557,
    41569, 41582, 41595, 41607, 41620, 41632, 41645, 41658,
    41670, 41683, 41695, 41708, 41720, 41733, 41746, 41758,
    41771, 41783, 41796, 41808, 41821, 41833, 41846, 41858,
    41871, 41883, 41896, 41909, 41921, 41934, 41946, 41959,
    41971, 41984, 41996, 42008, 42021, 42033, 42046, 42058,
    42071, 42083, 42096, 42108, 42121, 42133, 42146, 42158,
    42170, 42183, 42195, 42208, 42220, 42233, 42245, 42257,
    42270, 42282, 42295, 42307, 42319, 42332, 42344, 42356,
    42369, 42381, 42394, 42406, 42418, 42431, 42443, 42455,
    42468, 42480, 42492, 42505, 42517, 42529, 42542, 42554,
    42566, 42579, 42591, 42603, 42616, 42628, 42640, 42653,
    42665, 42677, 42689, 42702, 42714, 42726, 42738, 42751,
    42763, 42775, 42788, 42800, 42812, 42824, 42836, 42849,
    42861, 42873, 42885, 42898, 42910, 42922, 42934, 42947,
    42959, 42971, 42983, 42995, 43008, 43020, 43032, 43044,
    43056, 43068, 43081, 43093, 43105, 43117, 43129, 43141,
    43154, 43166, 43178, 43190, 43202, 43214, 43226, 43238,
    43251, 43263, 43275, 43287, 43299, 43311, 43323, 43335,
    43347, 43360, 43372, 43384, 43396, 43408, 43420, 43432,
    43444, 43456, 43468, 43480, 43492, 43504, 43516, 43529,
    43541, 43553, 43565, 43577, 43589, 43601, 43613, 43625,
    43637, 43649, 43661, 43673, 43685, 43697, 43709, 43721,
    43733, 43745, 43757, 43769, 43781, 43793, 43805, 43817,
    43829, 43841, 43853, 43864, 43876, 43888, 43900, 43912,
    43924, 43936, 43948, 43960, 43972, 43984, 43996, 44008,
    44020, 44032, 44043, 44055, 44067, 44079, 44091, 44103,
    44115, 44127, 44139, 44150, 44162, 44174, 44186, 44198,
    44210, 44222, 44233, 44245, 44257, 44269, 44281, 44293,
    44305, 44316, 44328, 44340, 44352, 44364, 44375, 44387,
    44399, 44411, 44423, 44434, 44446, 44458, 44470, 44482,
    44493, 44505, 44517, 44529, 44541, 44552, 44564, 44576,
    44588, 44599, 44611, 44623, 44635, 44646, 44658, 44670,
    44682, 44693, 44705, 44717, 44728, 44740, 44752, 44764,
    44775, 44787, 44799, 44810, 44822, 44834, 44846, 44857,
    44869, 44881, 44892, 44904, 44916, 44927, 44939, 44951,
    44962, 44974, 44986, 44997, 45009, 45021, 45032, 45044,
    45056, 45067, 45079, 45090, 45102, 45114, 45125, 45137,
    45148, 45160, 45172, 45183, 45195, 45207, 45218, 45230,
    45241, 45253, 45264, 45276, 45288, 45299, 45311, 45322,
    45334, 45345, 45357, 45369, 45380, 45392, 45403, 45415,
    45426, 45438, 45449, 45461, 45472, 45484, 45496, 45507,
    45519, 45530, 45542, 45553, 45565, 45576, 45588, 45599,
    45611, 45622, 45634, 45645, 45657, 45668, 45680, 45691,
    45702, 45714, 45725, 45737, 45748, 45760, 45771, 45783,
    45794, 45806, 45817, 45829, 45840, 45851, 45863, 45874,
    45886, 45897, 45909, 45920, 45931, 45943, 45954, 45966,
    45977, 45988, 46000, 46011, 46023, 46034, 46045, 46057,
    46068, 46080, 46091, 46102, 46114, 46125, 46136, 46148,
    46159, 46170, 46182, 46193, 46204, 46216, 46227, 46239,
    46250, 46261, 46273, 46284, 46295, 46306, 46318, 46329,
    46340, 46352, 46363, 46374, 46386, 46397, 46408, 46420,
    46431, 46442, 46453, 46465, 46476, 46487, 46499, 46510,
    46521, 46532, 46544, 46555, 46566, 46577, 46589, 46600,
    46611, 46622, 46634, 46645, 46656, 46667, 46679, 46690,
    46701, 46712, 46724, 46735, 46746, 46757, 46768, 46780,
    46791, 46802, 46813, 46824, 46836, 46847, 46858, 46869,
    46880, 46892, 46903, 46914, 46925, 46936, 46947, 46959,
    46970, 46981, 46992, 47003, 47014, 47026, 47037, 47048,
    47059, 47070, 47081, 47092, 47104, 47115, 47126, 47137,
    47148, 47159, 47170, 47181, 47192, 47204, 47215, 47226,
    47237, 47248, 47259, 47270, 47281, 47292, 47303, 47315,
    47326, 47337, 47348, 47359, 47370, 47381, 47392, 47403,
    47414, 47425, 47436, 47447, 47458, 47469, 47480, 47491,
    47503, 47514, 47525, 47536, 47547, 47558, 47569, 47580,
    47591, 47602, 47613, 47624, 47635, 47646, 47657, 47668,
    47679, 47690, 47701, 47712, 47723, 47734, 47745, 47756,
    47767, 47778, 47789, 47800, 47811, 47822, 47832, 47843,
    47854, 47865, 47876, 47887, 47898, 47909, 47920, 47931,
    47942, 47953, 47964, 47975, 47986, 47997, 48008, 48018,
    48029, 48040, 48051, 48062, 48073, 48084, 48095, 48106,
    48117, 48128, 48138, 48149, 48160, 48171, 48182, 48193,
    48204, 48215, 48225, 48236, 48247, 48258, 48269, 48280,
    48291, 48301, 48312, 48323, 48334, 48345, 48356, 48367,
    48377, 48388, 48399, 48410, 48421, 48432, 48442, 48453,
    48464, 48475, 48486, 48496, 48507, 48518, 48529, 48540,
    48550, 48561, 48572, 48583, 48594, 48604, 48615, 48626,
    48637, 48648, 48658, 48669, 48680, 48691, 48701, 48712,
    48723, 48734, 48744, 48755, 48766, 48777, 48787, 48798,
    48809, 48820, 48830, 48841, 48852, 48863, 48873, 48884,
    48895, 48906, 48916, 48927, 48938, 48948, 48959, 48970,
    48981, 48991, 49002, 49013, 49023, 49034, 49045, 49055,
    49066, 49077, 49087, 49098, 49109, 49119, 49130, 49141,
    49152, 49162, 49173, 49183, 49194, 49205, 49215, 49226,
    49237, 49247, 49258, 49269, 49279, 49290, 49301, 49311,
    49322, 49333, 49343, 49354, 49364, 49375, 49386, 49396,
    49407, 49417, 49428, 49439, 49449, 49460, 49470, 49481,
    49492, 49502, 49513, 49523, 49534, 49545, 49555, 49566,
    49576, 49587, 49597, 49608, 49619, 49629, 49640, 49650,
    49661, 49671, 49682, 49693, 49703, 49714, 49724, 49735,
    49745, 49756, 49766, 49777, 49787, 49798, 49808, 49819,
    49829, 49840, 49851, 49861, 49872, 49882, 49893, 49903,
    49914, 49924, 49935, 49945, 49956, 49966, 49977, 49987,
    49998, 50008, 50019, 50029, 50039, 50050, 50060, 50071,
    50081, 50092, 50102, 50113, 50123, 50134, 50144, 50155,
    50165, 50176, 50186, 50196, 50207, 50217, 50228, 50238,
    50249, 50259, 50269, 50280, 50290, 50301, 50311, 50322,
    50332, 50342, 50353, 50363, 50374, 50384, 50394, 50405,
    50415, 50426, 50436, 50446, 50457, 50467, 50478, 50488,
    50498, 50509, 50519, 50530, 50540, 50550, 50561, 50571,
    50581, 50592, 50602, 50612, 50623, 50633, 50644, 50654,
    50664, 50675, 50685, 50695, 50706, 50716, 50726, 50737,
    50747, 50757, 50768, 50778, 50788, 50799, 50809, 50819,
    50830, 50840, 50850, 50860, 50871, 50881, 50891, 50902,
    50912, 50922, 50933, 50943, 50953, 50963, 50974, 50984,
    50994, 51005, 51015, 51025, 51035, 51046, 51056, 51066,
    51076, 51087, 51097, 51107, 51118, 51128, 51138, 51148,
    51159, 51169, 51179, 51189, 51200, 51210, 51220, 51230,
    51240, 51251, 51261, 51271, 51281, 51292, 51302, 51312,
    51322, 51332, 51343, 51353, 51363, 51373, 51383, 51394,
    51404, 51414, 51424, 51434, 51445, 51455, 51465, 51475,
    51485, 51496, 51506, 51516, 51526, 51536, 51546, 51557,
    51567, 51577, 51587, 51597, 51607, 51618, 51628, 51638,
    51648, 51658, 51668, 51679, 51689, 51699, 51709, 51719,
    51729, 51739, 51750, 51760, 51770, 51780, 51790, 51800,
    51810, 51820, 51830, 51841, 51851, 51861, 51871, 51881,
    51891, 51901, 51911, 51921, 51932, 51942, 51952, 51962,
    51972, 51982, 51992, 52002, 52012, 52022, 52032, 52042,
    52053, 52063, 52073, 52083, 52093, 52103, 52113, 52123,
    52133, 52143, 52153, 52163, 52173, 52183, 52193, 52203,
    52213, 52224, 52234, 52244, 52254, 52264, 52274, 52284,
    52294, 52304, 52314, 52324, 52334, 52344, 52354, 52364,
    52374, 52384, 52394, 52404, 52414, 52424, 52434, 52444,
    52454, 52464, 52474, 52484, 52494, 52504, 52514, 52524,
    52534, 52544, 52554, 52564, 52574, 52584, 52594, 52604,
    52614, 52624, 52633, 52643, 52653, 52663, 52673, 52683,
    52693, 52703, 52713, 52723, 52733, 52743, 52753, 52763,
    52773, 52783, 52793, 52803, 52812, 52822, 52832, 52842,
    52852, 52862, 52872, 52882, 52892, 52902, 52912, 52922,
    52931, 52941, 52951, 52961, 52971, 52981, 52991, 53001,
    53011, 53021, 53030, 53040, 53050, 53060, 53070, 53080,
    53090, 53100, 53109, 53119, 53129, 53139, 53149, 53159,
    53169, 53179, 53188, 53198, 53208, 53218, 53228, 53238,
    53248, 53257, 53267, 53277, 53287, 53297, 53307, 53316,
    53326, 53336, 53346, 53356, 53366, 53375, 53385, 53395,
    53405, 53415, 53424, 53434, 53444, 53454, 53464, 53473,
    53483, 53493, 53503, 53513, 53522, 53532, 53542, 53552,
    53562, 53571, 53581, 53591, 53601, 53611, 53620, 53630,
    53640, 53650, 53659, 53669, 53679, 53689, 53699, 53708,
    53718, 53728, 53738, 53747, 53757, 53767, 53777, 53786,
    53796, 53806, 53816, 53825, 53835, 53845, 53855, 53864,
    53874, 53884, 53893, 53903, 53913, 53923, 53932, 53942,
    53952, 53961, 53971, 53981, 53991, 54000, 54010, 54020,
    54029, 54039, 54049, 54059, 54068, 54078, 54088, 54097,
    54107, 54117, 54126, 54136, 54146, 54155, 54165, 54175,
    54184, 54194, 54204, 54214, 54223, 54233, 54243, 54252,
    54262, 54272, 54281, 54291, 54300, 54310, 54320, 54329,
    54339, 54349, 54358, 54368, 54378, 54387, 54397, 54407,
    54416, 54426, 54435, 54445, 54455, 54464, 54474, 54484,
    54493, 54503, 54512, 54522, 54532, 54541, 54551, 54561,
    54570, 54580, 54589, 54599, 54609, 54618, 54628, 54637,
    54647, 54657, 54666, 54676, 54685, 54695, 54704, 54714,
    54724, 54733, 54743, 54752, 54762, 54772, 54781, 54791,
    54800, 54810, 54819, 54829, 54839, 54848, 54858, 54867,
    54877, 54886, 54896, 54905, 54915, 54924, 54934, 54944,
    54953, 54963, 54972, 54982, 54991, 55001, 55010, 55020,
    55029, 55039, 55048, 55058, 55067, 55077, 55087, 55096,
    55106, 55115, 55125, 55134, 55144, 55153, 55163, 55172,
    55182, 55191, 55201, 55210, 55220, 55229, 55239, 55248,
    55258, 55267, 55277, 55286, 55296, 55305, 55314, 55324,
    55333, 55343, 55352, 55362, 55371, 55381, 55390, 55400,
    55409, 55419, 55428, 55438, 55447, 55456, 55466, 55475,
    55485, 55494, 55504, 55513, 55523, 55532, 55541, 55551,
    55560, 55570, 55579, 55589, 55598, 55608, 55617, 55626,
    55636, 55645, 55655, 55664, 55673, 55683, 55692, 55702,
    55711, 55721, 55730, 55739, 55749, 55758, 55768, 55777,
    55786, 55796, 55805, 55815, 55824, 55833, 55843, 55852,
    55861, 55871, 55880, 55890, 55899, 55908, 55918, 55927,
    55937, 55946, 55955, 55965, 55974, 55983, 55993, 56002,
    56011, 56021, 56030, 56040, 56049, 56058, 56068, 56077,
    56086, 56096, 56105, 56114, 56124, 56133, 56142, 56152,
    56161, 56170, 56180, 56189, 56198, 56208, 56217, 56226,
    56236, 56245, 56254, 56264, 56273, 56282, 56292, 56301,
    56310, 56320, 56329, 56338, 56347, 56357, 56366, 56375,
    56385, 56394, 56403, 56413, 56422, 56431, 56440, 56450,
    56459, 56468, 56478, 56487, 56496, 56505, 56515, 56524,
    56533, 56542, 56552, 56561, 56570, 56580, 56589, 56598,
    56607, 56617, 56626, 56635, 56644, 56654, 56663, 56672,
    56681, 56691, 56700, 56709, 56718, 56728, 56737, 56746,
    56755, 56765, 56774, 56783, 56792, 56802, 56811, 56820,
    56829, 56838, 56848, 56857, 56866, 56875, 56885, 56894,
    56903, 56912, 56921, 56931, 56940, 56949, 56958, 56967,
    56977, 56986, 56995, 57004, 57013, 57023, 57032, 57041,
    57050, 57059, 57069, 57078, 57087, 57096, 57105, 57114,
    57124, 57133, 57142, 57151, 57160, 57170, 57179, 57188,
    57197, 57206, 57215, 57225, 57234, 57243, 57252, 57261,
    57270, 57279, 57289, 57298, 57307, 57316, 57325, 57334,
    57344, 57353, 57362, 57371, 57380, 57389, 57398, 57407,
    57417, 57426, 57435, 57444, 57453, 57462, 57471, 57480,
    57490, 57499, 57508, 57517, 57526, 57535, 57544, 57553,
    57563, 57572, 57581, 57590, 57599, 57608, 57617, 57626,
    57635, 57644, 57654, 57663, 57672, 57681, 57690, 57699,
    57708, 57717, 57726, 57735, 57744, 57753, 57763, 57772,
    57781, 57790, 57799, 57808, 57817, 57826, 57835, 57844,
    57853, 57862, 57871, 57880, 57889, 57899, 57908, 57917,
    57926, 57935, 57944, 57953, 57962, 57971, 57980, 57989,
    57998, 58007, 58016, 58025, 58034, 58043, 58052, 58061,
    58070, 58079, 58088, 58097, 58106, 58115, 58124, 58133,
    58143, 58152, 58161, 58170, 58179, 58188, 58197, 58206,
    58215, 58224, 58233, 58242, 58251, 58260, 58269, 58278,
    58287, 58296, 58305, 58314, 58323, 58332, 58341, 58350,
    58359, 58368, 58376, 58385, 58394, 58403, 58412, 58421,
    58430, 58439, 58448, 58457, 58466, 58475, 58484, 58493,
    58502, 58511, 58520, 58529, 58538, 58547, 58556, 58565,
    58574, 58583, 58592, 58601, 58610, 58618, 58627, 58636,
    58645, 58654, 58663, 58672, 58681, 58690, 58699, 58708,
    58717, 58726, 58735, 58744, 58752, 58761, 58770, 58779,
    58788, 58797, 58806, 58815, 58824, 58833, 58842, 58851,
    58859, 58868, 58877, 58886, 58895, 58904, 58913, 58922,
    58931, 58940, 58948, 58957, 58966, 58975, 58984, 58993,
    59002, 59011, 59020, 59028, 59037, 59046, 59055, 59064,
    59073, 59082, 59091, 59099, 59108, 59117, 59126, 59135,
    59144, 59153, 59162, 59170, 59179, 59188, 59197, 59206,
    59215, 59224, 59232, 59241, 59250, 59259, 59268, 59277,
    59285, 59294, 59303, 59312, 59321, 59330, 59339, 59347,
    59356, 59365, 59374, 59383, 59392, 59400, 59409, 59418,
    59427, 59436, 59444, 59453, 59462, 59471, 59480, 59489,
    59497, 59506, 59515, 59524, 59533, 59541, 59550, 59559,
    59568, 59577, 59585, 59594, 59603, 59612, 59621, 59629,
    59638, 59647, 59656, 59665, 59673, 59682, 59691, 59700,
    59708, 59717, 59726, 59735, 59744, 59752, 59761, 59770,
    59779, 59787, 59796, 59805, 59814, 59822, 59831, 59840,
    59849, 59858, 59866, 59875, 59884, 59893, 59901, 59910,
    59919, 59928, 59936, 59945, 59954, 59963, 59971, 59980,
    59989, 59998, 60006, 60015, 60024, 60032, 60041, 60050,
    60059, 60067, 60076, 60085, 60094, 60102, 60111, 60120,
    60128, 60137, 60146, 60155, 60163, 60172, 60181, 60189,
    60198, 60207, 60216, 60224, 60233, 60242, 60250, 60259,
    60268, 60276, 60285, 60294, 60303, 60311, 60320, 60329,
    60337, 60346, 60355, 60363, 60372, 60381, 60389, 60398,
    60407, 60416, 60424, 60433, 60442, 60450, 60459, 60468,
    60476, 60485, 60494, 60502, 60511, 60520, 60528, 60537,
    60546, 60554, 60563, 60572, 60580, 60589, 60597, 60606,
    60615, 60623, 60632, 60641, 60649, 60658, 60667, 60675,
    60684, 60693, 60701, 60710, 60718, 60727, 60736, 60744,
    60753, 60762, 60770, 60779, 60788, 60796, 60805, 60813,
    60822, 60831, 60839, 60848, 60856, 60865, 60874, 60882,
    60891, 60900, 60908, 60917, 60925, 60934, 60943, 60951,
    60960, 60968, 60977, 60986, 60994, 61003, 61011, 61020,
    61029, 61037, 61046, 61054, 61063, 61071, 61080, 61089,
    61097, 61106, 61114, 61123, 61132, 61140, 61149, 61157,
    61166, 61174, 61183, 61192, 61200, 61209, 61217, 61226,
    61234, 61243, 61251, 61260, 61269, 61277, 61286, 61294,
    61303, 61311, 61320, 61328, 61337, 61346, 61354, 61363,
    61371, 61380, 61388, 61397, 61405, 61414, 61422, 61431,
    61440, 61448, 61457, 61465, 61474, 61482, 61491, 61499,
    61508, 61516, 61525, 61533, 61542, 61550, 61559, 61567,
    61576, 61584, 61593, 61601, 61610, 61618, 61627, 61635,
    61644, 61652, 61661, 61669, 61678, 61686, 61695, 61703,
    61712, 61720, 61729, 61737, 61746, 61754, 61763, 61771,
    61780, 61788, 61797, 61805, 61814, 61822, 61831, 61839,
    61848, 61856, 61865, 61873, 61882, 61890, 61899, 61907,
    61916, 61924, 61932, 61941, 61949, 61958, 61966, 61975,
    61983, 61992, 62000, 62009, 62017, 62026, 62034, 62042,
    62051, 62059, 62068, 62076, 62085, 62093, 62102, 62110,
    62118, 62127, 62135, 62144, 62152, 62161, 62169, 62177,
    62186, 62194, 62203, 62211, 62220, 62228, 62236, 62245,
    62253, 62262, 62270, 62279, 62287, 62295, 62304, 62312,
    62321, 62329, 62337, 62346, 62354, 62363, 62371, 62380,
    62388, 62396, 62405, 62413, 62422, 62430, 62438, 62447,
    62455, 62464, 62472, 62480, 62489, 62497, 62505, 62514,
    62522, 62531, 62539, 62547, 62556, 62564, 62573, 62581,
    62589, 62598, 62606, 62614, 62623, 62631, 62640, 62648,
    62656, 62665, 62673, 62681, 62690, 62698, 62706, 62715,
    62723, 62732, 62740, 62748, 62757, 62765, 62773, 62782,
    62790, 62798, 62807, 62815, 62823, 62832, 62840, 62848,
    62857, 62865, 62873, 62882, 62890, 62898, 62907, 62915,
    62923, 62932, 62940, 62948, 62957, 62965, 62973, 62982,
    62990, 62998, 63007, 63015, 63023, 63032, 63040, 63048,
    63057, 63065, 63073, 63082, 63090, 63098, 63106, 63115,
    63123, 63131, 63140, 63148, 63156, 63165, 63173, 63181,
    63190, 63198, 63206, 63214, 63223, 63231, 63239, 63248,
    63256, 63264, 63272, 63281, 63289, 63297, 63306, 63314,
    63322, 63330, 63339, 63347, 63355, 63364, 63372, 63380,
    63388, 63397, 63405, 63413, 63421, 63430, 63438, 63446,
    63454, 63463, 63471, 63479, 63488, 63496, 63504, 63512,
    63521, 63529, 63537, 63545, 63554, 63562, 63570, 63578,
    63587, 63595, 63603, 63611, 63619, 63628, 63636, 63644,
    63652, 63661, 63669, 63677, 63685, 63694, 63702, 63710,
    63718, 63727, 63735, 63743, 63751, 63759, 63768, 63776,
    63784, 63792, 63801, 63809, 63817, 63825, 63833, 63842,
    63850, 63858, 63866, 63874, 63883, 63891, 63899, 63907,
    63915, 63924, 63932, 63940, 63948, 63956, 63965, 63973,
    63981, 63989, 63997, 64006, 64014, 64022, 64030, 64038,
    64047, 64055, 64063, 64071, 64079, 64088, 64096, 64104,
    64112, 64120, 64128, 64137, 64145, 64153, 64161, 64169,
    64177, 64186, 64194, 64202, 64210, 64218, 64226, 64235,
    64243, 64251, 64259, 64267, 64275, 64284, 64292, 64300,
    64308, 64316, 64324, 64332, 64341, 64349, 64357, 64365,
    64373, 64381, 64389, 64398, 64406, 64414, 64422, 64430,
    64438, 64446, 64455, 64463, 64471, 64479, 64487, 64495,
    64503, 64512, 64520, 64528, 64536, 64544, 64552, 64560,
    64568, 64576, 64585, 64593, 64601, 64609, 64617, 64625,
    64633, 64641, 64650, 64658, 64666, 64674, 64682, 64690,
    64698, 64706, 64714, 64722, 64731, 64739, 64747, 64755,
    64763, 64771, 64779, 64787, 64795, 64803, 64812, 64820,
    64828, 64836, 64844, 64852, 64860, 64868, 64876, 64884,
    64892, 64900, 64909, 64917, 64925, 64933, 64941, 64949,
    64957, 64965, 64973, 64981, 64989, 64997, 65005, 65013,
    65021, 65030, 65038, 65046, 65054, 65062, 65070, 65078,
    65086, 65094, 65102, 65110, 65118, 65126, 65134, 65142,
    65150, 65158, 65166, 65175, 65183, 65191, 65199, 65207,
    65215, 65223, 65231, 65239, 65247, 65255, 65263, 65271,
    65279, 65287, 65295, 65303, 65311, 65319, 65327, 65335,
    65343, 65351, 65359, 65367, 65375, 65383, 65391, 65399,
    65407, 65415, 65423, 65431, 65439, 65447, 65455, 65463,
    65471, 65479, 65487, 65495, 65503, 65511, 65519, 65527
};

static const signed short wavtable1[2304]={
     541,   956,   768, -1011,  -811,  -717,  -571,  -893,  -576,
     877,   581,   568,  -997,  -975,  -646,  -752,  -661,  -632,
     675,   787,   635,  -519,  -838,  -977,  -890,  -605,  -789,
     624,   732,   668,  -893,  -815,  -956,  -762,  -523,  -873,
     623,   839,   697, -1022,  -849,  -571,  -759,  -688,  -949,
     640,   693,   991,  -867,  -619,  -671,  -800,  -940,  -959,
     925,   687,   608,  -621,  -549,  -817,  -837,  -924,  -722,
     552,   797,   572,  -861,  -617,  -892,  -596,  -621,  -640,
     535,   832,   799,  -871,  -836,  -649,  -560,  -676,  -624,
     762,   605,   577,  -902,  -859,  -682,  -568,  -716,  -650,
     832,   561,  1003,  -913,  -815,  -550,  -676,  -616,  -982,
     590,   687,   588,  -793,  -679,  -790,  -681,  -923,  -677,
     646,   901,   732,  -569,  -924,  -645,  -816,  -794,  -524,
     828,   689,   896,  -557,  -725,  -603,  -670,  -927,  -784,
     875,   624,   848,  -533,  -725,  -516,  -748,  -760,  -702,
     571,   942,  1022,  -526,  -570,  -941,  -638,  -868, -1020,
     824,   736,   643,  -593,  -517,  -925,  -663,  -530,  -808,
     517,   765,   512,  -774,  -518,  -767,  -523,  -572,  -513,
     562,   908,   761,  -997,  -836,  -675,  -617,  -805,  -566,
     694,   913,   675,  -619,  -916,  -603,  -941,  -815,  -891,
     704,   524,   672,  -722,  -925,  -689,  -969,  -538,  -883,
     721,   757,   558,  -534,  -786,  -826, -1018,  -561,  -608,
     884,   551,   633,  -951,  -546,  -681,  -763,  -592,  -784,
     558,  1007,   846,  -549,  -923,  -832,  -608,  -991,  -699,
     932,   746,   777,  -679,  -707,  -566,  -849,  -544,  -589,
     566,   822,   926,  -910,  -513,  -744,  -627,  -659,  -839,
     613,   771,   611,  -924,  -731,  -921,  -733,  -581,  -729,
     737,   671,  1008,  -967,  -726,  -661,  -531,  -880,  -993,
     651,   594,   579,  -757,  -737,  -673,  -830,  -691,  -655,
     801,   636,   564,  -996,  -883,  -702,  -626,  -792,  -622,
     852,   910,   719,  -757,  -599,  -639,  -709,  -809, -1012,
     998,   614,   575,  -599,  -561,  -691,  -974,  -737,  -647,
     665,   935,   628,  -607,  -816,  -574,  -863,  -854,  -771,
     631,   596,   829,  -735, -1023,  -966,  -778,  -694,  -672,
     644,   926,   526,  -583,  -663,  -953,  -811,  -838,  -542,
     879,   988,   613,  -848,  -526,  -592,  -755,  -953,  -734,
     941,   692,   693,  -637,  -638,  -939,  -866,  -937,  -940,
     565,   672,   576,  -742,  -637,  -757,  -625,  -882,  -649,
     547,   628,   740,  -671,  -791,  -909,  -585,  -771,  -535,
     639,   532,   537,  -665,  -671,  -559,  -798,  -554,  -564,
     955,   604,   598,  -564,  -558,  -706,  -891,  -714,  -699,
     562,   580,   900,  -637,  -989, -1021,  -617,  -658,  -791,
     603,   899,   621,  -530,  -733,  -545,  -712,  -789,  -755,
     746,   533,   624,  -776,  -909,  -650,  -543,  -555,  -761,
     729,   514,   735,  -733,  -523,  -739,  -519,  -517,  -528,
     853,   551,   692,  -919,  -577,  -745,  -711,  -593,  -936,
     949,  1018,  1004,  -944,  -931,  -999,  -880, -1013,  -985,
     544,   988,   735,  -525,  -781,  -710,  -578,  -954,  -528,
     789,   782,   821,  -603,  -633,  -628,  -608,  -598,  -659,
     897,   516,   754,  -906,  -661,  -761,  -786,  -521,  -556,
     517,   702,   828,  -710,  -837,  -568,  -523,  -963,  -670,
     586,   818,   763,  -937,  -874,  -609,  -672,  -654,  -568,
     907,   652,   592,  -578,  -525,  -754,  -804,  -830,  -686,
     528,   652,   642,  -673,  -663,  -818,  -546,  -830,  -806,
     531,   708,   780,  -736,  -811,  -540,  -552,  -981,  -595,
     666,   625,   727,  -813,  -946,  -888,  -867,  -763,  -516,
     947,   727,   554,  -673,  -512,  -787,  -875,  -517,  -599,
     549,   657,   981,  -705,  -526,  -630,  -589,  -843,  -941,
     605,   920,   852,  -544, -1008,  -766,  -716,  -827,  -709,
     624,   619,   983,  -755,  -599,  -595,  -761,  -750,  -944,
     605,   909,   547,  -537,  -646,  -971,  -715,  -807,  -584,
     690,   935,   516,  -631,  -697,  -944,  -932,  -855,  -521,
     700,   612,   853,  -838,  -584, -1021,  -959,  -732,  -711,
     767,   832,   574,  -623,  -861,  -933,  -575,  -676,  -643,
     523,   898,   923,  -919,  -945,  -810,  -536,  -789,  -833,
     722,   958,   691,  -676,  -976,  -647, -1020,  -896,  -935,
     613,   771,   928,  -924,  -556,  -700,  -734,  -581,  -842,
     758,   757,   584,  -561,  -866,  -865,  -562,  -560,  -667,
     512,   567,   577,  -567,  -577,  -639,  -512,  -628,  -650,
     615,   638,   698,  -766,  -839,  -871,  -739,  -795,  -954,
     574,   642,   589,  -720,  -660,  -739,  -644,  -806,  -677,
     993,   682,   878,  -662,  -852,  -585,  -963,  -910,  -753,
     539,   890,   913,  -939,  -963,  -795,  -569,  -775,  -815,
     694,   928,   544,  -629,  -738,  -987,  -941,  -842,  -578,
     805,   600,   680,  -944,  -535,  -798,  -633,  -704,  -905,
     540,   951,   782, -1004,  -825,  -727,  -570,  -884,  -597,
     816,   950,   590,  -757,  -941,  -548,  -650,  -881,  -681,
     955,   847,   811,  -790,  -757,  -671,  -891,  -700,  -643,
     547,   883,   556,  -945,  -595,  -960,  -586,  -762,  -605,
     652,   888,   604,  -565,  -770,  -524,  -831,  -770,  -713,
     863,   585,   855,  -986,  -721,  -978,  -727,  -668,  -715,
    1023,   997,   516,  -997,  -516, -1006, -1023,  -972,  -520,
     932,   614,   640,  -560,  -583,  -769,  -850,  -738,  -800,
     627,   564,   573,  -691,  -702,  -631,  -769,  -621,  -641,
     876,   900,   724,  -770,  -620,  -637,  -750,  -792,  -512,
     515,   857,   896,  -863,  -902,  -750,  -519,  -718,  -784,
     647,   953,   879,  -602,  -555,  -818,  -817,  -888,  -755,
     806,   854,   857,  -672,  -675,  -715,  -634,  -712,  -718,
     545,   583,   631,  -621,  -672,  -719,  -581,  -664,  -778,
     657,   601,   751,  -772,  -963,  -882,  -843,  -707,  -550,
     740,   905,   795,  -654,  -575,  -704,  -535,  -801,  -618,
     841,  1016,   568,  -835,  -934,  -564,  -691, -1009,  -631,
     747,   589,   983,  -861,  -718,  -566,  -545,  -679,  -945,
     878,   613,   526,  -526,  -902,  -630,  -753,  -736,  -540,
     864,   723,   779,  -610,  -657,  -550,  -729, -1022,  -592,
     534,   674,   774,  -703,  -808, -1019,  -557,  -887,  -586,
     950,   649,   939,  -602,  -871,  -595,  -881,  -824,  -861,
     590,   703,   899,  -811,  -518,  -618,  -680,  -966,  -790,
     618,   527,   579,  -637,  -700,  -597,  -746,  -543,  -657,
     725,   647,   972,  -917,  -689,  -615,  -513,  -818,  -924,
     641,   647,   707,  -810,  -885,  -893,  -803,  -817,  -976,
     730,   663,   644,  -946,  -920,  -835,  -521,  -860,  -812,
     807,   572,   578,  -902,  -912,  -646,  -637,  -639,  -653,
     879,   611,   821,  -524,  -705,  -979,  -755,  -729,  -658,
     667,   729,   841,  -951,  -549,  -599,  -871,  -519,  -692,
     782,   585,   751,  -895,  -574,  -859,  -598,  -670,  -551,
     802,   733,   976,  -574,  -765,  -699,  -628,  -525,  -931,
     850,   871,   708,  -724,  -588,  -602,  -706,  -742,  -979,
     870,   743,   704,  -632,  -598, -1023,  -739,  -540,  -970,
     941,   899,   585,  -827,  -538,  -514,  -866,  -790,  -669,
     943,   632,   875,  -582,  -806,  -541,  -869,  -781,  -749,
    1023,   732,   638,  -731,  -637,  -912, -1022,  -523,  -795,
     778,   753,   655,  -573,  -997,  -965,  -592,  -554,  -839,
     843,   945,   945,  -779,  -779,  -873,  -694,  -873,  -873,
     942,   969,   572,  -892,  -527,  -542,  -867,  -918,  -640,
    1008,   559,   854,  -551,  -841,  -934,  -993,  -612,  -712,
     868,   729,   787,  -618,  -668,  -560,  -737,  -519,  -605,
     970,   686,   547,  -650,  -518,  -733,  -919,  -919,  -585,
     535,   635,   674,  -664,  -705,  -836,  -560,  -788,  -887,
     560,   636,   828,  -696,  -907,  -514,  -613,  -790,  -670,
     994,   592,   833,  -575,  -809,  -964,  -966,  -686,  -677,
     548,   621,   694,  -665,  -743,  -843,  -587,  -755,  -942,
     550,   801,   955,  -861,  -513,  -748,  -591,  -627,  -892,
     582,   522,   646,  -594,  -735,  -659,  -663,  -533,  -815,
     606,   625,   818,  -739,  -969,  -999,  -717,  -763,  -655,
     623,   591,   874,  -720,  -531, -1010,  -758,  -683,  -746,
     669,   535,  1001,  -700,  -654,  -523,  -876,  -559,  -979,
     701,   938,   592,  -642,  -810,  -542,  -960,  -860,  -684,
     925,   820,   738,  -741,  -667,  -592,  -835,  -657,  -533,
     735,   790,   544,  -567,  -781,  -840,  -527,  -610,  -578,
     575,   788,   674,  -886,  -758,  -519,  -647,  -607,  -888,
     655,   783,   528, -1003,  -677,  -809,  -840,  -599,  -545,
     527,   513,   677,  -529,  -699,  -679,  -544,  -514,  -897,
     782,   852,   940,  -651,  -718,  -783,  -597,  -709,  -863,
     578,   910,   513,  -514,  -581,  -914,  -654,  -809,  -515,
     692,   882,   734,  -596,  -993,  -632,  -937,  -759,  -526,
     586,   683,   715,  -782,  -818,  -954,  -670,  -911,  -999,
     739,   609,   717,  -880,  -518,  -854,  -534,  -725, -1006,
     778,   773,   697,  -588,  -530,  -527,  -592,  -584,  -951,
     922,   785,   813,  -707,  -732,  -624,  -830,  -602,  -646,
     766,   651,   984,  -974,  -736,  -626,  -573,  -827,  -946,
     978,   596,   515,  -569,  -984,  -600,  -934,  -694,  -518,
     535,   757,   540,  -792,  -565,  -799,  -560,  -559,  -571,
     662,   687,   589,  -890,  -762,  -791,  -857,  -924,  -678,
     554,   536,   979,  -580,  -530,  -512,  -601,  -561,  -936,
     723,   982,   690,  -694,  -976,  -662, -1022,  -943,  -932,
     936,   956,   527,  -875,  -965,  -986,  -856,  -894,  -543,
     590,  1002,   547,  -577,  -631,  -536,  -680,  -980,  -586,
     517,   653,   825,  -660,  -833,  -526,  -522,  -834,  -664,
     832,   592,   974,  -964,  -792,  -564,  -677,  -686,  -928,
     512,   957,   903,  -957,  -903,  -844,  -512,  -894,  -796,
     631,   545,   906,  -672,  -558,  -965,  -777,  -581,  -802,
     514,   720,   649,  -723,  -652,  -913,  -516, -1012,  -824,
     596,   679,   694,  -790,  -807,  -920,  -693,  -900,  -940,
     617,   740,   979,  -892,  -590,  -708,  -743,  -535,  -936,
     711,   685,   877,  -952,  -609,  -587,  -987,  -917,  -752,
     655,   835,   848,  -534,  -542,  -691,  -838,  -681,  -702,
     754,   839,   698,  -618,  -515,  -573,  -556,  -688,  -954,
     871,   515,   769,  -877,  -655,  -774,  -742,  -518,  -578,
     955,   852,   573,  -795,  -535,  -955,  -892,  -709,  -643,
     640,   859,   587,  -537,  -735,  -986,  -801,  -721,  -674,
     792,   863,   554,  -667,  -858,  -935,  -612,  -727,  -601,
     843,   708,   682,  -583,  -562,  -944,  -694,  -979,  -910,
     971,   768,   552,  -728,  -524,  -829,  -921,  -576,  -596,
     891,   536,   690,  -935,  -601,  -724,  -776,  -563,  -931,
    1016,   560,   663,  -556,  -659,  -727, -1009,  -614,  -860,
     543,   870,   674,  -924,  -716,  -573,  -577,  -739,  -889,
     601,   999,   585,  -586,  -686,  -571,  -705,  -975,  -668,
     945,   966,   889,  -892,  -821,  -840,  -872,  -912,  -773,
     529,   912,   777,  -943,  -804,  -692,  -547,  -812,  -590,
     574,  1020,   714,  -572,  -801,  -711,  -643, -1016,  -997,
     609,   922,   932,  -549,  -555,  -840,  -725,  -831,  -848,
     598,   778,   929,  -909,  -543,  -707,  -698,  -592,  -844,
     651,   772,   744,  -982,  -947,  -561,  -827,  -582,  -541,
     691,   957,   722,  -646,  -976,  -675,  -934,  -894, -1020,
     729,   766,   984,  -546,  -701,  -736,  -520,  -573,  -945,
     547,   519,   632,  -555,  -675,  -640,  -585,  -526,  -780,
     583,   532,   922,  -607,  -525,  -960,  -664,  -554,  -831,
     633,   995,   603,  -615,  -745,  -586,  -783,  -968,  -710,
     677,   571,   874,  -757,  -578,  -977,  -896,  -638,  -747,
     602,   545,   666,  -641,  -783,  -709,  -708,  -580,  -866,
     627,   542,   875,  -665,  -536,  -928,  -769,  -575,  -748,
     672,   983,   598,  -645,  -786,  -575,  -882,  -944,  -700,
     692,   979,   730,  -662,  -988,  -698,  -937,  -937,  -521,
     668,   634,   872,  -827,  -569,  -540,  -871,  -785,  -742,
     711,   706,   674,  -982,  -937,  -931,  -988,  -975,  -889,
     739,   977,   595,  -706,  -860,  -568,  -534,  -932,  -691,
     759,   905,   763,  -671,  -566,  -675,  -563,  -799,  -569,
     756,   582,   763,  -860,  -563,  -868,  -558,  -663,  -568,
     748,  1013,   908,  -741,  -664,  -898,  -547, -1002,  -805,
     804,   937,   950,  -736,  -746,  -869,  -631,  -858,  -882,
     785,   543,   998,  -833,  -766,  -529,  -602,  -576,  -973,
     999,   684,   942,  -668,  -920,  -630,  -975,  -915,  -868,
     626,   633,   996,  -774,  -609,  -616,  -765,  -783,  -970,
     626,   567,   835,  -693, -1021,  -925,  -765,  -628,  -681,
     739,   571,   973,  -825,  -702,  -543,  -533,  -637,  -925,
     655,   769,   707,  -984,  -906,  -531,  -839,  -577,  -978,
     702,   952,   571,  -653,  -785,  -532,  -964,  -886,  -638,
     727,   712,   514, -1012,  -730,  -715,  -516,  -990,  -516,
     744,   686,   741,  -998,  -539,  -994,  -541,  -921,  -536,
     731,   552,   714,  -789, -1021,  -772,  -522,  -596,  -998,
     824,   991,   726,  -798,  -585,  -703,  -664,  -959,  -515,
     795,   615,   544,  -955,  -844,  -653,  -617,  -738,  -578,
     870,   575,   824,  -978,  -700,  -926,  -739,  -646,  -664,
     803,   832,   923,  -653,  -724,  -750,  -630,  -677,  -832,
     819,   839,   531,  -671,  -849,  -871,  -655,  -688,  -550,
     887,   786,   852,  -681,  -738,  -654,  -769,  -603,  -709,
     933,   764,   570,  -696,  -519,  -851,  -850,  -570,  -634,
     716,   906,   654,  -634,  -916,  -579, -1003,  -802,  -837,
     784,   804,   563,  -616,  -864,  -885,  -601,  -631,  -620,
     774,   535,   876,  -809,  -662,  -915,  -585,  -559,  -749,
     807,   598,   649,  -943, -1023,  -758,  -636,  -699,  -822,
     817,   759,   718,  -606,  -573,  -533,  -652,  -563, -1008,
     831,   993,   846,  -806,  -687,  -821,  -675,  -963,  -699,
     858,   567,   605,  -951, -1015,  -670,  -720,  -628,  -716,
     876,  1012,   651,  -866,  -557,  -643,  -750, -1001,  -827,
     852,   548,   549,  -913,  -914,  -588,  -710,  -587,  -589,
     895,  1008,   871,  -881,  -761,  -858,  -782,  -993,  -741,
     892,  1000,   591,  -872,  -515,  -578,  -777,  -977,  -683,
     935,   516,   836,  -944,  -764,  -844,  -855,  -521,  -682,
     931,   612,   776,  -557,  -706,  -929,  -847,  -733,  -589,
     968,   614,   816,  -581,  -771,  -980,  -915,  -738,  -651,
     524,   777,   719,  -796,  -737,  -546,  -537,  -590, -1012,
     549,   694,   786,  -744,  -843,  -533,  -589,  -941,  -603,
     882,   754,   534,  -649,  -920,  -787,  -759,  -555,  -557,
     597,   837,   766,  -977,  -895,  -627,  -697,  -684,  -574,
     635,   954,   704,  -592,  -873,  -656,  -788,  -890,  -969,
     803,   550,   798,  -863,  -626,  -858,  -630,  -591,  -622,
     699,   654,   798,  -894,  -545, -1021,  -954,  -837,  -622,
     924,   767,   738,  -693,  -666,  -553,  -834,  -575,  -531,
     970,   675,   608,  -639,  -576,  -801,  -919,  -890,  -722,
     632,   706,   684,  -873,  -844,  -944,  -780,  -976,  -914,
     858,   767,   563,  -643,  -945,  -844,  -719,  -574,  -620,
     527,   765,   702,  -788,  -724,  -525,  -543,  -572,  -964,
     559,   924,  1003, -1009,  -547,  -905,  -610,  -833,  -983,
     618,   524,   611,  -633,  -738,  -625,  -747,  -536,  -729,
     999,   942,   963,  -920,  -940,  -886,  -976,  -867,  -905,
     547,   857,   935,  -916,  -999,  -783,  -584,  -718,  -854,
     734,   926,   569,  -665,  -818,  -515,  -527,  -838,  -634,
     967,   746,   551,  -705,  -520,  -804,  -913,  -544,  -593,
     834,   633,   881,  -515,  -718,  -545,  -679,  -783,  -758,
     941,   701,   727,  -645,  -668,  -997,  -865,  -961,  -516,
     945,   564,   636,  -521,  -587,  -701,  -873,  -623,  -790,
     512,   563,   793,  -563,  -794,  -873,  -512,  -619,  -615,
     984,   556,   570,  -534,  -548,  -620,  -945,  -604,  -636,
     984,   540,   740,  -519,  -712,  -782,  -946,  -570,  -536,
     527,   764,   874,  -787,  -901,  -652,  -543,  -570,  -747,
     530,   664,  1014,  -688,  -525,  -658,  -549,  -862, -1005,
     546,   515,   521,  -550,  -556,  -525,  -584,  -519,  -531,
     554,   934,   672, -1011,  -728,  -613,  -600,  -852,  -882,
     598,   945,   556,  -552,  -650,  -513,  -700,  -872,  -603,
     627,   531,   733,  -651,  -899,  -760,  -769,  -551,  -525,
     576,  1020,  1014,  -574,  -571, -1011,  -650, -1016, -1005,
     623,   924,   594,  -563,  -724,  -537,  -759,  -835,  -691,
     678,   909,   603,  -602,  -800,  -536,  -899,  -807,  -712,
     814,   744,   543,  -592,  -865,  -790,  -648,  -541,  -577
};

static const unsigned short wavtable2[2304]={
    14,  14,  14,  20,  20,  19,  21,  20,  20,
    14,  14,  14,  20,  20,  20,  20,  21,  21,
    14,  13,  14,  18,  20,  19,  21,  18,  21,
    13,  13,  14,  18,  19,  19,  19,  18,  21,
    13,  14,  13,  19,  18,  18,  19,  20,  19,
    13,  14,  15,  19,  19,  20,  19,  21,  22,
    13,  13,  13,  17,  17,  18,  18,  19,  19,
    12,  14,  13,  18,  17,  19,  17,  20,  19,
    13,  13,  13,  18,  18,  17,  19,  18,  18,
    13,  13,  12,  18,  17,  17,  18,  19,  17,
    13,  12,  13,  17,  17,  16,  18,  17,  18,
    12,  13,  12,  17,  16,  17,  17,  19,  17,
    12,  13,  13,  16,  17,  17,  17,  18,  18,
    12,  13,  13,  16,  16,  17,  16,  19,  18,
    12,  12,  13,  15,  16,  16,  16,  17,  18,
    11,  13,  13,  15,  15,  17,  15,  18,  18,
    13,  12,  13,  16,  17,  17,  18,  16,  19,
    12,  12,  12,  16,  16,  16,  17,  16,  17,
    13,  12,  12,  17,  17,  15,  19,  16,  16,
    13,  12,  11,  16,  16,  14,  19,  16,  15,
    12,  12,  12,  16,  16,  16,  17,  17,  17,
    12,  13,  11,  16,  15,  16,  17,  18,  15,
    12,  12,  11,  16,  14,  15,  16,  17,  15,
    11,  13,  12,  15,  15,  16,  15,  18,  16,
    12,  12,  12,  15,  15,  15,  16,  16,  16,
    11,  12,  12,  15,  14,  15,  15,  16,  16,
    11,  12,  12,  15,  15,  16,  15,  16,  17,
    11,  12,  13,  15,  15,  16,  14,  17,  18,
    11,  12,  11,  15,  14,  15,  15,  17,  15,
    11,  12,  11,  15,  14,  15,  14,  17,  15,
    11,  13,  12,  15,  14,  16,  14,  18,  17,
    11,  12,  12,  14,  14,  16,  14,  17,  17,
    12,  12,  12,  15,  16,  15,  17,  16,  17,
    12,  11,  12,  15,  16,  15,  17,  15,  16,
    12,  12,  11,  15,  15,  15,  17,  16,  15,
    12,  12,  11,  15,  14,  14,  16,  16,  15,
    13,  11,  11,  15,  15,  14,  18,  15,  15,
    12,  11,  10,  15,  14,  13,  17,  15,  13,
    11,  11,  11,  14,  14,  14,  15,  15,  14,
    11,  11,  10,  14,  13,  13,  15,  15,  13,
    12,  11,  12,  14,  15,  15,  16,  15,  17,
    11,  11,  12,  14,  15,  15,  15,  15,  16,
    11,  12,  11,  14,  14,  14,  15,  16,  15,
    11,  11,  11,  14,  14,  14,  14,  15,  15,
    11,  11,  12,  14,  14,  15,  14,  15,  16,
    11,  11,  12,  14,  14,  15,  14,  15,  17,
    11,  12,  12,  14,  14,  15,  14,  16,  16,
    10,  12,  12,  13,  14,  15,  13,  16,  16,
    11,  12,  11,  14,  13,  14,  14,  16,  14,
    11,  11,  11,  14,  13,  14,  14,  15,  14,
    10,  12,  11,  14,  13,  14,  13,  17,  14,
    10,  12,  11,  14,  13,  14,  13,  16,  14,
    11,  11,  11,  13,  13,  14,  14,  15,  15,
    10,  11,  11,  13,  13,  14,  13,  15,  15,
    10,  11,  12,  13,  14,  14,  13,  15,  16,
    10,  11,  12,  13,  14,  15,  13,  15,  16,
    11,  12,  11,  14,  13,  15,  14,  16,  15,
    10,  12,  12,  14,  13,  15,  13,  17,  16,
    10,  13,  12,  14,  14,  16,  13,  18,  16,
    10,  12,  13,  14,  14,  16,  13,  17,  18,
    10,  12,  11,  13,  13,  15,  13,  16,  15,
    10,  12,  11,  13,  13,  15,  13,  16,  15,
    10,  12,  12,  14,  13,  16,  13,  17,  16,
    10,  12,  12,  13,  14,  16,  12,  16,  17,
    12,  11,  12,  15,  16,  14,  17,  14,  16,
    12,  11,  11,  14,  15,  13,  17,  14,  15,
    11,  11,  12,  14,  14,  14,  15,  14,  16,
    11,  11,  11,  13,  14,  14,  14,  14,  15,
    11,  10,  11,  13,  14,  13,  15,  13,  15,
    11,  10,  11,  13,  14,  13,  15,  13,  15,
    12,  10,  10,  14,  14,  12,  17,  13,  13,
    12,  10,  10,  13,  13,  11,  16,  13,  12,
    11,  11,  11,  14,  14,  13,  15,  14,  14,
    11,  11,  10,  13,  13,  13,  15,  14,  13,
    11,  11,  10,  14,  12,  13,  14,  15,  13,
    10,  12,  10,  14,  12,  13,  13,  16,  12,
    11,  11,  11,  13,  14,  13,  14,  14,  15,
    11,  11,  11,  13,  13,  13,  14,  14,  14,
    10,  11,  11,  13,  13,  14,  13,  14,  15,
    10,  11,  11,  12,  13,  13,  13,  14,  15,
    11,  10,  11,  13,  13,  13,  14,  13,  14,
    11,  11,  10,  13,  12,  13,  14,  14,  13,
    11,  10,  10,  12,  12,  12,  14,  13,  13,
    10,  10,  10,  12,  12,  12,  13,  13,  13,
    11,  11,  10,  13,  12,  12,  14,  14,  12,
    10,  11,  10,  13,  12,  12,  13,  14,  12,
    10,  11,  10,  12,  11,  12,  13,  14,  12,
    10,  11,  10,  12,  11,  12,  12,  14,  12,
    10,  10,  11,  12,  13,  13,  13,  13,  15,
    10,  10,  11,  12,  13,  13,  13,  13,  14,
    10,  11,  11,  12,  12,  13,  12,  14,  14,
    10,  11,  11,  12,  13,  13,  12,  14,  15,
    10,  10,  11,  12,  12,  12,  12,  13,  14,
    10,  10,  10,  11,  12,  12,  12,  13,  13,
    10,  10,  11,  11,  12,  12,  12,  13,  14,
     9,  10,  11,  11,  12,  13,  11,  13,  14,
    11,  11,  11,  13,  13,  13,  14,  15,  14,
    10,  11,  11,  13,  12,  13,  13,  15,  14,
    10,  11,  10,  13,  12,  13,  13,  15,  13,
    10,  11,  11,  13,  12,  13,  12,  15,  14,
    10,  11,  11,  13,  13,  14,  13,  15,  15,
    10,  11,  11,  13,  13,  14,  12,  15,  15,
    10,  11,  11,  13,  13,  14,  12,  15,  15,
    10,  11,  12,  12,  13,  15,  12,  15,  16,
    10,  12,  11,  14,  12,  14,  13,  16,  14,
    10,  12,  11,  14,  12,  15,  12,  17,  14,
    10,  12,  12,  13,  13,  15,  12,  16,  16,
    10,  13,  12,  14,  13,  16,  12,  18,  17,
    10,  12,  11,  13,  12,  15,  12,  16,  15,
    10,  12,  11,  13,  12,  14,  12,  16,  15,
    10,  12,  12,  13,  13,  15,  12,  17,  16,
    10,  12,  12,  13,  13,  16,  12,  16,  17,
    10,  12,  10,  13,  12,  14,  12,  16,  13,
    10,  12,  11,  13,  12,  14,  12,  16,  14,
    10,  12,  10,  13,  11,  13,  12,  16,  13,
    10,  11,  11,  12,  12,  14,  12,  15,  14,
    10,  11,  11,  12,  12,  13,  12,  14,  14,
    10,  11,  11,  12,  12,  14,  12,  15,  15,
     9,  11,  11,  12,  12,  14,  11,  15,  15,
     9,  11,  12,  12,  13,  14,  11,  15,  16,
    10,  12,  11,  13,  12,  15,  12,  17,  14,
     9,  12,  11,  13,  12,  15,  11,  17,  15,
     9,  12,  12,  13,  12,  15,  11,  16,  16,
     9,  12,  12,  13,  13,  16,  11,  17,  17,
     9,  12,  11,  13,  12,  15,  11,  17,  14,
     9,  12,  12,  13,  12,  16,  11,  17,  16,
     9,  12,  12,  13,  12,  15,  11,  17,  16,
     9,  13,  12,  13,  13,  16,  11,  18,  17,
    12,  10,  11,  13,  14,  12,  16,  12,  14,
    11,  10,  10,  12,  13,  12,  14,  12,  13,
    10,  10,  11,  12,  13,  12,  13,  12,  15,
    10,  10,  10,  12,  12,  12,  13,  12,  13,
    11,   9,  10,  12,  13,  11,  15,  11,  13,
    11,  10,  10,  12,  12,  11,  14,  12,  12,
    10,  10,   9,  11,  11,  11,  13,  12,  11,
    10,  10,   9,  11,  11,  10,  13,  12,  10,
    10,  10,  10,  12,  12,  12,  13,  13,  13,
    10,  10,  10,  12,  11,  12,  12,  13,  13,
    10,  10,  10,  11,  11,  11,  12,  12,  13,
    10,  10,  10,  11,  11,  11,  12,  12,  12,
    10,  10,  10,  12,  11,  11,  12,  13,  12,
    10,  10,   9,  11,  11,  11,  12,  13,  11,
     9,  10,   9,  11,  10,  11,  11,  12,  11,
     9,  10,   9,  11,  10,  11,  11,  13,  11,
    10,   9,  11,  11,  12,  11,  13,  11,  14,
    10,  10,  10,  11,  12,  11,  13,  12,  13,
    10,  10,  10,  11,  12,  12,  12,  12,  13,
     9,  10,  10,  10,  11,  11,  11,  12,  13,
    10,   9,  10,  11,  12,  10,  13,  11,  12,
    10,   9,  10,  11,  11,  10,  12,  11,  12,
     9,  10,  10,  11,  11,  11,  11,  12,  12,
     9,   9,  10,  10,  10,  11,  11,  11,  12,
     9,  10,  10,  11,  11,  12,  11,  13,  13,
     9,  10,  10,  11,  11,  12,  11,  13,  13,
     9,  10,  11,  11,  11,  12,  11,  12,  14,
     9,  10,  11,  11,  11,  12,  11,  13,  14,
     9,  10,  10,  10,  10,  11,  11,  12,  12,
     9,  10,  10,  10,  10,  11,  10,  12,  13,
     9,   9,  10,  10,  10,  11,  10,  11,  12,
     9,  10,  10,  10,  10,  12,  10,  12,  13,
    10,  11,  10,  12,  12,  13,  13,  14,  13,
    10,  11,  10,  12,  12,  13,  12,  14,  13,
    10,  11,  10,  12,  11,  13,  12,  15,  13,
    10,  11,  10,  12,  11,  13,  12,  14,  13,
    10,  10,  10,  12,  11,  12,  12,  13,  13,
    10,  10,  10,  11,  11,  12,  12,  13,  13,
     9,  11,  10,  12,  11,  12,  11,  14,  13,
     9,  11,  10,  11,  11,  12,  11,  14,  13,
    10,  11,  11,  12,  12,  13,  12,  14,  14,
     9,  11,  11,  12,  12,  13,  11,  14,  14,
     9,  11,  11,  11,  12,  13,  11,  14,  15,
     9,  11,  12,  11,  12,  14,  11,  14,  16,
     9,  11,  11,  12,  11,  13,  11,  14,  14,
     9,  11,  11,  12,  12,  13,  11,  14,  14,
     9,  11,  11,  11,  12,  13,  11,  14,  15,
     9,  11,  12,  11,  12,  14,  10,  14,  16,
     9,  11,  10,  12,  11,  13,  11,  15,  13,
     9,  11,  11,  12,  11,  14,  11,  15,  14,
     9,  12,  10,  12,  11,  13,  11,  16,  13,
     9,  11,  11,  12,  11,  14,  11,  15,  14,
     9,  11,  11,  12,  12,  14,  11,  15,  15,
     9,  11,  12,  12,  12,  15,  11,  15,  16,
     9,  12,  11,  12,  12,  14,  11,  16,  15,
     9,  12,  12,  12,  13,  15,  11,  16,  16,
     9,  12,  11,  13,  11,  14,  11,  17,  14,
     9,  12,  11,  13,  12,  15,  11,  17,  15,
     9,  12,  11,  12,  12,  14,  10,  16,  15,
     9,  12,  12,  12,  12,  15,  10,  16,  16,
     9,  12,  11,  13,  11,  15,  10,  17,  14,
     9,  13,  12,  13,  12,  16,  10,  18,  16,
     9,  13,  12,  13,  12,  16,  10,  18,  16,
     9,  12,  13,  13,  13,  16,  10,  17,  18,
    10,  11,  10,  12,  11,  12,  12,  15,  12,
     9,  11,  10,  12,  10,  12,  11,  15,  12,
     9,  10,  10,  11,  11,  12,  11,  13,  12,
     9,  10,  10,  11,  10,  11,  10,  13,  12,
     9,  11,  10,  12,  11,  12,  11,  14,  13,
     9,  11,  10,  11,  11,  12,  11,  14,  13,
     9,  11,  10,  12,  11,  13,  10,  15,  13,
     9,  11,  11,  12,  11,  14,  10,  15,  14,
     9,  10,  10,  11,  11,  12,  10,  13,  13,
     9,  11,  10,  11,  10,  12,  10,  14,  12,
     9,  10,  10,  11,  11,  12,  10,  13,  13,
     9,  10,  11,  11,  11,  13,  10,  13,  14,
     9,  11,  11,  11,  11,  13,  10,  14,  14,
     9,  11,  11,  11,  12,  14,  10,  14,  15,
     9,  11,  11,  11,  11,  13,  10,  14,  14,
     9,  11,  11,  11,  11,  14,  10,  14,  15,
     9,  12,  10,  12,  11,  13,  11,  16,  13,
     9,  12,  10,  12,  11,  14,  10,  16,  13,
     9,  11,  11,  12,  11,  14,  10,  15,  14,
     9,  11,  11,  12,  12,  14,  10,  15,  15,
     9,  12,  11,  12,  11,  14,  10,  16,  15,
     9,  12,  12,  12,  12,  15,  10,  16,  16,
     9,  12,  11,  13,  12,  15,  10,  17,  15,
     9,  13,  12,  13,  12,  16,  10,  18,  17,
     9,  11,  10,  12,  11,  13,  10,  15,  13,
     9,  12,  11,  12,  11,  14,  10,  16,  14,
     9,  12,  11,  12,  11,  14,  10,  16,  15,
     9,  11,  12,  12,  12,  15,  10,  15,  16,
     9,  12,  11,  12,  11,  15,  10,  17,  14,
     9,  12,  12,  12,  12,  16,  10,  17,  16,
     8,  12,  11,  12,  11,  14,   9,  16,  15,
     8,  12,  12,  12,  12,  15,   9,  17,  16,
    10,   9,   9,  10,  11,  10,  12,  10,  11,
     9,   9,   9,  10,  10,   9,  11,  10,  10,
     9,  10,   9,  10,  10,  10,  11,  12,  11,
     9,   9,   9,  10,   9,  10,  10,  11,  10,
     9,   9,  10,  10,  10,  11,  11,  11,  12,
     9,   9,  10,   9,  10,  10,  10,  10,  12,
     9,   9,   9,   9,   9,  10,  10,  11,  11,
     8,   9,   9,   9,   9,  10,   9,  11,  11,
     9,  10,   9,  10,  10,  11,  10,  12,  11,
     8,  10,   9,  10,   9,  10,   9,  12,  11,
     8,  10,  10,  10,   9,  11,   9,  12,  12,
     8,   9,  10,   9,  10,  11,   9,  11,  13,
     9,   9,   9,   9,   9,   9,  10,  10,  10,
     7,   8,   8,   7,   7,   7,   7,   8,   8,
     8,  10,   9,   9,   9,  10,   8,  12,  11,
     8,   9,   9,   8,   8,  10,   8,  10,  11,
     9,  11,  10,  11,  10,  12,  10,  15,  12,
     9,  11,  10,  11,  10,  13,  10,  15,  12,
     9,  10,  10,  10,  10,  12,  10,  13,  13,
     8,  10,  11,  10,  11,  13,   9,  13,  14,
     9,  11,  10,  11,  10,  13,  10,  15,  13,
     9,  11,  11,  11,  11,  14,  10,  15,  14,
     8,  11,  11,  11,  11,  13,   9,  14,  14,
     8,  11,  12,  11,  11,  14,   9,  15,  16,
     8,  10,   9,  10,   9,  11,   9,  13,  11,
     8,  11,  10,  11,  10,  12,   9,  14,  13,
     8,  11,  10,  10,  10,  12,   9,  14,  13,
     8,  10,  11,  10,  11,  13,   9,  13,  14,
     8,  12,  11,  11,  10,  14,   9,  16,  14,
     8,  12,  11,  11,  11,  14,   9,  16,  15,
     8,  11,  10,  10,  10,  12,   9,  14,  13,
     8,  11,  10,  10,  10,  13,   8,  14,  13
};

static const signed short etable1[5120]={
     38,  -4,  15,  -4,  14, -13,  12, -11,  -2,  -6,
     -6, -11, -45, -16, -11, -13,  -7,   6, -12,   4,
    -20,   3, -16,  12,  -1,  12,  46,  24,   0,  33,
     -3,   9, -12, -12,  -8,  -7,  17,  -6,   0,  -2,
     60, -16,   3, -22,  10, -32,   0, -28, -17, -18,
     -3, -25, -37, -23, -10,   3,   2,   3,   0,   3,
    -14,   0, -14,  -1,   0,   2,  32,   9,  -1,  25,
      7,  13,  -5,  13,   8,   1,   2,   8, -10,   6,
     27, -12,  28,  -2,   6,  -7,  15,   9, -11,   1,
    -13, -11, -40,   4, -29, -14, -19,  -5, -23,  -8,
    -30, -13, -17,   0, -14,  12,  34,  20,  -2,  25,
      2, -16,  -4, -12,  15,  16,  29,   7,  24,  10,
     49, -24,  16, -20,   2, -26,   2,  -7, -25, -10,
    -11, -25, -32,  -3, -27,   2,  -8,  -8, -11,  -9,
    -24, -17, -16, -14, -13,   2,  20,   5,  -4,  17,
     14, -12,   3,  13,  33,  25,  14,  23,  15,  19,
     46,  -6,  21,   8,  -2, -16,  -5,  -8, -11,   4,
      8,  15, -24,   4,  -2, -26,  -3, -16, -16, -14,
     -9,  -2,  -1,   4,  19,   7,  36,  17,   9,  13,
      0,  31,  -5, -12,   7,  -8,  11, -15, -13,  -4,
     68, -18,   9,  -9,  -6, -35, -18, -25, -26,  -7,
     10,   1, -16,  -3,  -1,  -9,   6, -19,  -4, -15,
     -4,  -6,   0,  -8,  20,  -2,  23,   2,   7,   5,
     12,  35,   1,  13,  24,   0,  -3,   0, -22,   4,
     35, -14,  34,  10, -10, -10,  -1,  12, -20,  12,
      0,  15, -18,  24, -20, -27, -14, -28, -27, -27,
    -20, -19,  -2,  -8,   5,   7,  25,  13,   5,   5,
      6,   5,   2, -12,  31,  15,  23,  -1,  12,   8,
     57, -26,  22,  -7, -14, -28, -14,  -3, -35,   0,
      3,   1, -11,  16, -18, -10,  -4, -31, -15, -28,
    -14, -23,  -1, -21,   7,  -2,  11,  -1,   3,  -1,
     18,   9,  10,  13,  49,  24,   8,  14,   2,  16,
     25,  15,  22,  11,  18,   4,  15, -22,   8,  -2,
    -17,  -9, -48, -20, -30, -17, -16,  11,  -1,  16,
      2,  10,  -5,  26,  -2,  -4,  22,   0,   2,  10,
     -6,  13, -14,  10, -23,   0,  10,  -2,   1,   0,
     47,   3,  11,  -6,  15, -13,   2, -38,  -6, -13,
    -15, -22, -40, -28, -28,   0,  -5,   8,  10,  15,
      7,   7,  -4,  13,  -1, -14,   9, -14,   0,   2,
      4,  18,  -7,  36,  -6,   8,  -3,  13,  -7,   8,
     14,   7,  36,  13,  10,  10,  18,   0,   0,   5,
    -25,  -8, -43,   0, -48, -18, -27,   0, -12,   3,
     -7,  -6,  -7,  13, -15,  -5,  11,  -3,   0,   2,
      0, -12,  -6,  10,   0,  23,  22,  11,  26,  12,
     36,  -5,  24,  -4,   7,  -7,   6, -17, -14,  -5,
    -22, -22, -35,  -8, -46,  -1, -17,  -3,   0,   2,
     -2, -10,  -5,   0, -14, -15,  -2, -18,  -2,  -4,
     11,  -7,   1,  36,  18,  32,   7,  27,  17,  20,
     33,  13,  29,  24,   1,   1,  -2, -18,   0,   9,
     -3,  17, -27,   0, -21, -30, -12, -11,  -5,  -2,
     12,   4,   9,  19,  18,  -9,  13,  -6,  11,  -8,
     -2,  35,  -8,  10,  -7,  -1,   4, -11, -10,  -2,
     55,   1,  17,   6,  -1, -16, -15, -35, -15,  -2,
      0,   4, -19,  -8, -20, -13,  -1, -14,   7,  -3,
     18,   0,  10,   5,  19, -19,   0, -21,   8, -16,
      9,  39,   0,  36,  10,   7,  -9,   4, -20,   5,
     22,   5,  42,  26,  -6,   8,   1,   2,  -9,  17,
    -10,  18, -21,  19, -39, -31, -23, -23, -16, -15,
      2, -12,   7,   6,   5,  -9,   1, -10,   7, -16,
      4,   9,   0,  10,  17,  22,  16,   2,  14,   9,
     44,  -6,  30,   8,  -9, -10, -11, -14, -23,   5,
     -8,   4, -14,  12, -37, -14, -12, -26,  -4, -16,
      8, -16,   9,  -7,   6, -19, -12, -25,   5, -24,
     15,  13,   8,  36,  34,  31,   1,  18,   4,  18,
     -3,  -5,  -9,  -7,  15,  -1,   5,  13,   2,  12,
      5,   2, -21, -23,  -2, -16,   0,   5,  -6,  13,
    -23,   3, -32,  10, -15,   8,  44,  28,   9,  37,
     -2,  13,  -9, -15, -12, -27,  -7, -12,   0, -11,
     18, -17, -21, -25,  11, -19,  -6,  -3, -11,   0,
      7, -11, -13, -31,  -1,   0,   9,   1,   5,  12,
    -18,   0, -31,  -2, -13,  -1,  30,  14,   7,  29,
      9,  18,  -1,  10,   4, -18, -22,   3, -10,  -2,
    -13, -13,   3,  -5,   7,   4,   9,  34,  -5,  20,
     -2,   3, -16,  -3, -20, -17, -11,  -7, -17,   0,
    -34, -13, -33,  -2, -28,   8,  32,  24,   5,  29,
      3, -12,   0, -15,  11,  -3,   3,   2,  24,   1,
      8, -25,  -8, -23,   3, -13,  -3,  17, -20,   8,
      0, -10,  -8, -11, -18,   0,  -1, -10,  -5,   0,
    -28, -17, -32, -15, -26,  -1,  19,   9,   3,  21,
     15,  -7,   6,   9,  29,   5, -10,  17,  15,   9,
      4,  -6,  -3,   5,  -1,  -4, -11,  16,  -6,  23,
     19,  29,   0,  -3,   6, -30,   3, -17, -10,  -5,
    -13,  -2, -17,   3,   5,   3,  35,  21,  17,  17,
      2,  35,  -2, -15,   3, -28, -13, -21, -13, -13,
     26, -19, -15, -12,  -5, -22, -24,   0, -21,  12,
     21,  15,   8, -11,   7, -12,  14, -20,   2,  -6,
     -7,  -6, -16,  -9,   6,  -5,  21,   7,  15,  10,
     13,  39,   5,  10,  20, -19, -28,  -5, -22,  -5,
     -5, -15,   9,   7,  -9,   2,  -8,  37, -14,  31,
     11,  29,   5,  16, -11, -30,  -7, -29, -21, -18,
    -23, -19, -18,  -9,  -7,   3,  23,  17,  14,   9,
      8,   9,   6, -15,  27,  -4,  -2,  -6,  12,  -1,
     16, -27,  -2, -10, -13, -16, -20,  20, -29,  20,
     14,  16,  13,   8,  -9, -13,   2, -33,  -9, -19,
    -17, -23, -17, -22,  -6,  -6,   9,   2,  12,   2,
     20,  13,  13,  10,  45,   4, -16,   8,   2,   7,
    -16,  14,  -2,   8,  20,  17,   9,   2,  14,  16,
     -6,   5, -24, -28, -21, -20,  -8,   9,   4,  25,
     -1,  11, -22,  24, -15,  -8,  21,   5,  11,  14,
     -5,  18, -11,   7, -27, -20, -14,  -7,   1,  -9,
      6,   2, -14,  -9,  16,  -1,  -3, -14,   0,   5,
     -3,  -8, -16, -36, -19,  -3,   1,   6,  17,  24,
      4,   7, -21,  11, -14, -18,   7,  -9,   9,   7,
      6,  22,  -3,  33, -10, -11, -28,   7,  -7,   0,
    -26,   6,  11,  10,  12,  23,  12,  23,   5,  24,
    -13,   5, -19,  -8, -38, -21, -20,  -2,  -6,  12,
    -11,  -5, -23,  11, -29,  -9,   9,   0,   7,   6,
      1,  -7,  -2,   7,  -3,   3,  -2,   6,  27,   3,
     -4,  -6,   0,  -7,   8,   4,   0,   6,  -9,  13,
    -11,  -7, -11, -15, -37,  -4,  -9,  -5,   5,  11,
     -5,  -9, -22,  -1, -27, -18,  -4, -14,   5,   0,
     12,  -3,   4,  32,  14,  12, -17,  22,  17,  11,
     -8,  12,   3,  21,   3,  14,  -8,   5,   4,  28,
      7,  32,  -2,  -8, -12, -34,  -4, -12,   1,   6,
      9,   4,  -7,  17,   4, -13,  11,  -1,  19,  -4,
      0,  39,  -4,   7, -11, -21, -20, -16, -10, -11,
     13,   0,  -8,   3,   0,  -4, -21, -11,  -9,  16,
     10,  18,   5, -16, -10, -16,   5, -15,  13,   5,
     15,   1,  -6,   4,   6, -23,  -2, -16,  17, -12,
     10,  44,   3,  33,   6, -12, -34,  -1, -20,  -3,
    -18,   4,  17,  23,  -4,  20,  -4,  26,  -3,  36,
      0,  32,   2,  12, -29, -34, -16, -24, -10,  -6,
      0, -12,  -8,   4,  -8, -13,   0,  -6,  16, -12,
      5,  13,   3,   7,  13,   3,  -8,  -2,  14,   0,
      3,  -7,   5,   5,  -8,   2, -17,   9, -18,  24,
      2,  19,  10,   4, -28, -17,  -5, -28,   2,  -7,
      4, -15,  -7,  -8,  -6, -23, -13, -21,  14, -20,
     17,  18,  11,  33,  30,  11, -23,  13,   5,   9,
     60,  10,   7,  -1,   9,  -8,   6, -13,   2, -15,
     -1, -10, -13, -11,  15,   0,   6,   9,  -1,   0,
    -13,   1, -11,  -3, -13,  21,  13,  26,  -7,  31,
    -10,  -7, -16, -33, -31, -10,  22,  -8,   1,  -2,
     82,  -1,  -4, -19,   6, -27,  -6, -29, -12, -26,
      1, -24,  -5, -18,  17,  17,  17,   6,  10,   0,
     -7,  -2,  -9, -16, -12,  11,   0,  11,  -9,  23,
      0,  -3,  -8,  -8, -13,  -1,   8,   7,  -7,   6,
     49,   2,  21,   0,   1,  -2,   9,   8,  -6,  -6,
     -8, -10,  -8,   9,  -2,   0,  -4,  -2, -13, -12,
    -23, -15, -12, -16, -26,  21,   2,  21, -11,  23,
     -4, -33,  -7, -33,  -6,  13,  34,   5,  27,  10,
     71, -10,   9, -17,  -1, -20,  -3,  -8, -21, -18,
     -6, -24,   0,   1,   0,  16,   6,  -5,   0, -13,
    -17, -19, -11, -29, -25,  11, -11,   6, -13,  15,
      7, -29,   0,  -8,  11,  22,  20,  21,  17,  18,
     67,   8,  14,  11,  -7, -11, -11,  -9,  -7,  -3,
     13,  16,   8,   9,  24, -12,  10, -13,  -5, -17,
     -2,  -4,   3, -10,   6,  17,   4,  19,   0,  11,
     -6,  13,  -9, -33, -14, -10,  16, -17, -10,  -4,
     90,  -3,   2,  -6, -10, -29, -24, -26, -21, -15,
     15,   2,  16,   1,  25,   4,  21, -16,   6, -18,
      3,  -8,   5, -24,   8,   7,  -9,   4,  -1,   3,
      5,  18,  -1,  -7,   2,  -1,   2,  -1, -19,   3,
     57,   0,  27,  13, -14,  -5,  -7,  11, -15,   4,
      5,  16,  13,  29,   6, -13,   0, -25, -16, -31,
    -12, -22,   2, -23,  -6,  16,  -7,  14,  -2,   3,
      0, -12,   0, -33,   9,  13,  28,  -3,  14,   7,
     79, -11,  15,  -4, -18, -23, -20,  -5, -30,  -7,
      7,   2,  21,  21,   8,   3,  10, -28,  -4, -31,
     -6, -25,   3, -37,  -4,   7, -20,   0,  -4,  -4,
     11,  -7,   6,  -8,  27,  22,  14,  12,   5,  16,
     47,  30,  15,  14,  14,   9,   9, -23,  13, -10,
    -12,  -7, -16, -15,  -3,  -3,  -1,  14,   9,  12,
      9,   8,   0,  10, -14,   4,  -9,   2,  -5,   8,
    -13,  -3, -18, -10, -45,  -3,  16,  -4,   4,   0,
     69,  17,   3,  -3,  10,  -8,  -3, -40,  -1, -21,
    -10, -21,  -8, -23,  -1,  13,   8,  11,  21,  11,
     15,   4,   0,  -2, -13,  -5, -23, -12,  -7,   0,
     -1,   0, -10,  14, -28,   5,   1,  11,  -5,   7,
     36,  21,  28,  16,   6,  16,  12,  -2,   4,  -2,
    -20,  -7, -11,   4, -20,  -4, -12,   2,  -1,   0,
      0,  -8,  -2,  -2, -27,   4, -21,  -2,  -9,   0,
     -6, -29,  -9, -10, -21,  21,  28,  10,  29,  11,
     58,   9,  16,  -1,   2,  -2,   0, -19, -10, -13,
    -17, -21,  -3,  -3, -19,  12,  -2,   0,  10,  -1,
      5, -12,   0, -15, -26,  -5, -34, -16, -11,  -7,
      4, -25,  -2,  14,  -3,  29,  13,  25,  20,  20,
     55,  28,  21,  27,  -2,   7,  -8, -20,   4,   1,
      1,  18,   5,   4,   5, -16,   2,  -8,   5,  -5,
     19,   2,  14,   3,   6,   0, -18,  -4,   2, -11,
     -8,  18, -11, -10, -29,  -3,  10, -13,  -8,  -3,
     77,  16,   9,   9,  -6, -11, -21, -37, -10, -10,
      4,   5,  13,  -3,   7,   0,  13, -11,  17,  -6,
     25,  -1,  15,  -9,   7,  -9, -32, -19,   0, -18,
      2,  22,  -3,  15, -12,   5,  -4,   2, -17,   5,
     44,  20,  34,  29, -10,  13,  -4,   0,  -4,   9,
     -5,  19,  10,  24, -11, -17,  -8, -20,  -5, -19,
      9, -14,  12,  -9,  -6,   0, -30,  -9,   0, -19,
     -2,  -7,  -2, -10,  -5,  20,  21,   1,  17,   9,
     66,   8,  23,  11, -14,  -5, -17, -16, -19,  -2,
     -3,   5,  18,  17, -10,   0,   1, -23,   6, -20,
     15, -18,  14, -22,  -5, -10, -44, -23,  -2, -26,
      9,  -3,   4,  14,  12,  29,   7,  16,   7,  18,
     18,   9, -17,  -4,  11,   3,   0,  11,   7,   4,
     10,   3,  10, -18,  24,  -3,  14,   7,   4,  10,
    -16,   1, -27,  -4, -27,  17,  12,  30,   0,  35,
     -9,  -3, -12, -36, -35, -30,  -2, -13,   2, -11,
     40,  -2, -29, -22,   7, -14, -12,  -5,  -7,  -7,
     12,  -9,  18, -26,  26,  14,  24,   4,  16,   9,
    -10,  -2, -26, -18, -26,   7,  -1,  15,  -1,  27,
      2,   0,  -4, -11, -17, -21, -16,   1,  -7,  -3,
      8,   1,  -3,  -2,   3,  10,   3,  32,  -1,  12,
      2,   4,  15,   1,   7,  -3,   2,  -4,  -6,  -3,
    -26, -15, -29, -17, -40,  17,   0,  26,  -2,  27,
     -2, -29,  -4, -36, -10,  -6,   9,   0,  27,   0,
     30, -11, -15, -20,   0,  -8,  -9,  15, -15,   0,
      5,  -9,  23,  -6,   8,  13,  13,  -7,   5,  -3,
    -20, -19, -27, -31, -39,   7, -13,  11,  -4,  19,
      8, -25,   3, -11,   7,   2,  -4,  16,  18,   9,
     26,   7, -11,   8,  -5,   1, -17,  14,  -1,  15,
     24,  30,  32,   1,  33, -16,  18, -14,   0,  -8,
     -6,  -4, -12, -12,  -6,  13,   2,  23,   8,  15,
     -4,  17,  -5, -36, -18, -30,  -8, -22, -10, -14,
     48,  -4, -23,  -9,  -9, -17, -30,  -2, -16,   3,
     26,  16,  40,  -6,  35,   1,  28, -17,  12,  -9,
      0,  -8, -11, -25,  -5,   3, -10,   8,   6,   7,
      6,  22,   1, -11,  -1, -21, -22,  -7, -19,  -5,
     15,   0,   2,  10, -13,   7, -14,  35, -10,  23,
     16,  31,  37,  21,  16, -17,   6, -26, -10, -21,
    -16, -21, -13, -25, -19,  13,  -8,  19,   5,   7,
      1,  -8,   2, -36,   5,  -6,   3,  -8,  15,  -1,
     37, -12,  -9,  -7, -17, -11, -26,  18, -25,  12,
     19,  17,  45,  14,  17,   0,  17, -30,   1, -22,
    -10, -25, -12, -38, -18,   3, -22,   4,   3,   0,
     13,  -3,  10, -11,  23,   2, -10,   7,   5,   7,
      5,  29,  -9,  11,  15,  22,   3,   0,  18,   8,
     -1,   6,   7, -23,   6,  -6,   5,  12,  15,  21,
      5,   8, -17,   9, -28,   0, -11,   6,   2,  12,
    -11,   0, -14, -13, -49, -22,  -8,  -9,   4,  -9,
     27,  16, -21,  -6,  12,   3,  -9, -16,   3,  -2,
      1,  -7,  15, -31,   7,  10,  16,   9,  27,  21,
     11,   5, -16,  -3, -26,  -9, -24,  -7,   0,   4,
      0,   4,  -6,  11, -32, -14, -23,   6,  -5,  -1,
     -4,  20,   3,  13,   8,  28,   6,  21,  10,  16,
     -8,   7,  12,  -3, -11,  -7,  -5,   0,   4,   8,
     -4,  -8, -18,  -3, -41,   0, -22,   2,   0,   4,
     -5, -25,  -6, -14, -25,   1,   2,   4,  29,   2,
     17,   8,  -8,  -4,   4,  10,  -6,   5,  -4,   5,
     -6,  -6,  20, -10,  -9,   9,   4,  -2,  16,   7,
      1, -12, -17, -16, -39,  -9, -36, -12,  -2,  -3,
      6, -21,   1,  11,  -7,  10, -11,  20,  20,  11,
     13,  27,  -3,  24,  -1,  19, -14,   3,   9,  20,
     12,  33,  29,  -3,  15, -20,   9,  -9,  11,   3,
     16,   2,  -2,   2,  -7,  -3, -20,   0,  10,  -7,
     -7,  22,  -7, -13, -33, -23, -14, -18,  -7, -12,
     35,  15, -15,   6,  -4,   1, -27, -12,  -5,   8,
     15,  19,  37, -11,  16,  -2,  20, -12,  23,   2,
     22,  -1,  -1, -11,  -5, -13, -34, -14,   8, -14,
      4,  26,   0,  11, -16, -14, -29,  -2, -17,  -3,
      3,  19,   9,  26,  -8,  26, -10,  24,   0,  28,
      5,  33,  34,  17,  -2, -20,  -1, -22,   0, -10,
      6, -14,  -3, -10, -20,  -4, -32,  -4,   7, -15,
      0,  -3,   0, -13,  -9,   0,  -3,  -4,  17,   0,
     25,   7,  -2,   8, -12,   7, -23,   8, -13,  16,
      7,  20,  42,   9,   0,  -3,   9, -25,  12, -10,
     12, -18,  -2, -24, -19, -13, -46, -19,   5, -22,
     10,   0,   8,  11,   8,   9, -17,  11,   7,   8,
    -25,  -7,   2,  -8,  12,  -7,  23,  -8,  13, -16,
     -7, -20, -42,  -9,   0,   3,  -9,  25, -12,  10,
    -12,  18,   2,  24,  19,  13,  46,  19,  -5,  22,
    -10,   0,  -8, -11,  -8,  -9,  17, -11,  -7,  -8,
     -3, -19,  -9, -26,   8, -26,  10, -24,   0, -28,
     -5, -33, -34, -17,   2,  20,   1,  22,   0,  10,
     -6,  14,   3,  10,  20,   4,  32,   4,  -7,  15,
      0,   3,   0,  13,   9,   0,   3,   4, -17,   0,
    -35, -15,  15,  -6,   4,  -1,  27,  12,   5,  -8,
    -15, -19, -37,  11, -16,   2, -20,  12, -23,  -2,
    -22,   1,   1,  11,   5,  13,  34,  14,  -8,  14,
     -4, -26,   0, -11,  16,  14,  29,   2,  17,   3,
    -13, -27,   3, -24,   1, -19,  14,  -3,  -9, -20,
    -12, -33, -29,   3, -15,  20,  -9,   9, -11,  -3,
    -16,  -2,   2,  -2,   7,   3,  20,   0, -10,   7,
      7, -22,   7,  13,  33,  23,  14,  18,   7,  12,
    -17,  -8,   8,   4,  -4, -10,   6,  -5,   4,  -5,
      6,   6, -20,  10,   9,  -9,  -4,   2, -16,  -7,
     -1,  12,  17,  16,  39,   9,  36,  12,   2,   3,
     -6,  21,  -1, -11,   7, -10,  11, -20, -20, -11,
      4, -20,  -3, -13,  -8, -28,  -6, -21, -10, -16,
      8,  -7, -12,   3,  11,   7,   5,   0,  -4,  -8,
      4,   8,  18,   3,  41,   0,  22,  -2,   0,  -4,
      5,  25,   6,  14,  25,  -1,  -2,  -4, -29,  -2,
    -27, -16,  21,   6, -12,  -3,   9,  16,  -3,   2,
     -1,   7, -15,  31,  -7, -10, -16,  -9, -27, -21,
    -11,  -5,  16,   3,  26,   9,  24,   7,   0,  -4,
      0,  -4,   6, -11,  32,  14,  23,  -6,   5,   1,
     -5, -29,   9, -11, -15, -22,  -3,   0, -18,  -8,
      1,  -6,  -7,  23,  -6,   6,  -5, -12, -15, -21,
     -5,  -8,  17,  -9,  28,   0,  11,  -6,  -2, -12,
     11,   0,  14,  13,  49,  22,   8,   9,  -4,   9,
    -37,  12,   9,   7,  17,  11,  26, -18,  25, -12,
    -19, -17, -45, -14, -17,   0, -17,  30,  -1,  22,
     10,  25,  12,  38,  18,  -3,  22,  -4,  -3,   0,
    -13,   3, -10,  11, -23,  -2,  10,  -7,  -5,  -7,
    -15,   0,  -2, -10,  13,  -7,  14, -35,  10, -23,
    -16, -31, -37, -21, -16,  17,  -6,  26,  10,  21,
     16,  21,  13,  25,  19, -13,   8, -19,  -5,  -7,
     -1,   8,  -2,  36,  -5,   6,  -3,   8, -15,   1,
    -48,   4,  23,   9,   9,  17,  30,   2,  16,  -3,
    -26, -16, -40,   6, -35,  -1, -28,  17, -12,   9,
      0,   8,  11,  25,   5,  -3,  10,  -8,  -6,  -7,
     -6, -22,  -1,  11,   1,  21,  22,   7,  19,   5,
    -26,  -7,  11,  -8,   5,  -1,  17, -14,   1, -15,
    -24, -30, -32,  -1, -33,  16, -18,  14,   0,   8,
      6,   4,  12,  12,   6, -13,  -2, -23,  -8, -15,
      4, -17,   5,  36,  18,  30,   8,  22,  10,  14,
    -30,  11,  15,  20,   0,   8,   9, -15,  15,   0,
     -5,   9, -23,   6,  -8, -13, -13,   7,  -5,   3,
     20,  19,  27,  31,  39,  -7,  13, -11,   4, -19,
     -8,  25,  -3,  11,  -7,  -2,   4, -16, -18,  -9,
     -8,  -1,   3,   2,  -3, -10,  -3, -32,   1, -12,
     -2,  -4, -15,  -1,  -7,   3,  -2,   4,   6,   3,
     26,  15,  29,  17,  40, -17,   0, -26,   2, -27,
      2,  29,   4,  36,  10,   6,  -9,   0, -27,   0,
    -40,   2,  29,  22,  -7,  14,  12,   5,   7,   7,
    -12,   9, -18,  26, -26, -14, -24,  -4, -16,  -9,
     10,   2,  26,  18,  26,  -7,   1, -15,   1, -27,
     -2,   0,   4,  11,  17,  21,  16,  -1,   7,   3,
    -18,  -9,  17,   4, -11,  -3,   0, -11,  -7,  -4,
    -10,  -3, -10,  18, -24,   3, -14,  -7,  -4, -10,
     16,  -1,  27,   4,  27, -17, -12, -30,   0, -35,
      9,   3,  12,  36,  35,  30,   2,  13,  -2,  11,
    -66,  -8, -23, -11,  14,   5,  17,  16,  19,   2,
      3,  -5, -18, -17,  10,   0,  -1,  23,  -6,  20,
    -15,  18, -14,  22,   5,  10,  44,  23,   2,  26,
     -9,   3,  -4, -14, -12, -29,  -7, -16,  -7, -18,
    -44, -20, -34, -29,  10, -13,   4,   0,   4,  -9,
      5, -19, -10, -24,  11,  17,   8,  20,   5,  19,
     -9,  14, -12,   9,   6,   0,  30,   9,   0,  19,
      2,   7,   2,  10,   5, -20, -21,  -1, -17,  -9,
    -77, -16,  -9,  -9,   6,  11,  21,  37,  10,  10,
     -4,  -5, -13,   3,  -7,   0, -13,  11, -17,   6,
    -25,   1, -15,   9,  -7,   9,  32,  19,   0,  18,
     -2, -22,   3, -15,  12,  -5,   4,  -2,  17,  -5,
    -55, -28, -21, -27,   2,  -7,   8,  20,  -4,  -1,
     -1, -18,  -5,  -4,  -5,  16,  -2,   8,  -5,   5,
    -19,  -2, -14,  -3,  -6,   0,  18,   4,  -2,  11,
      8, -18,  11,  10,  29,   3, -10,  13,   8,   3,
    -58,  -9, -16,   1,  -2,   2,   0,  19,  10,  13,
     17,  21,   3,   3,  19, -12,   2,   0, -10,   1,
     -5,  12,   0,  15,  26,   5,  34,  16,  11,   7,
     -4,  25,   2, -14,   3, -29, -13, -25, -20, -20,
    -36, -21, -28, -16,  -6, -16, -12,   2,  -4,   2,
     20,   7,  11,  -4,  20,   4,  12,  -2,   1,   0,
      0,   8,   2,   2,  27,  -4,  21,   2,   9,   0,
      6,  29,   9,  10,  21, -21, -28, -10, -29, -11,
    -69, -17,  -3,   3, -10,   8,   3,  40,   1,  21,
     10,  21,   8,  23,   1, -13,  -8, -11, -21, -11,
    -15,  -4,   0,   2,  13,   5,  23,  12,   7,   0,
      1,   0,  10, -14,  28,  -5,  -1, -11,   5,  -7,
    -47, -30, -15, -14, -14,  -9,  -9,  23, -13,  10,
     12,   7,  16,  15,   3,   3,   1, -14,  -9, -12,
     -9,  -8,   0, -10,  14,  -4,   9,  -2,   5,  -8,
     13,   3,  18,  10,  45,   3, -16,   4,  -4,   0,
    -79,  11, -15,   4,  18,  23,  20,   5,  30,   7,
     -7,  -2, -21, -21,  -8,  -3, -10,  28,   4,  31,
      6,  25,  -3,  37,   4,  -7,  20,   0,   4,   4,
    -11,   7,  -6,   8, -27, -22, -14, -12,  -5, -16,
    -57,   0, -27, -13,  14,   5,   7, -11,  15,  -4,
     -5, -16, -13, -29,  -6,  13,   0,  25,  16,  31,
     12,  22,  -2,  23,   6, -16,   7, -14,   2,  -3,
      0,  12,   0,  33,  -9, -13, -28,   3, -14,  -7,
    -90,   3,  -2,   6,  10,  29,  24,  26,  21,  15,
    -15,  -2, -16,  -1, -25,  -4, -21,  16,  -6,  18,
     -3,   8,  -5,  24,  -8,  -7,   9,  -4,   1,  -3,
     -5, -18,   1,   7,  -2,   1,  -2,   1,  19,  -3,
    -67,  -8, -14, -11,   7,  11,  11,   9,   7,   3,
    -13, -16,  -8,  -9, -24,  12, -10,  13,   5,  17,
      2,   4,  -3,  10,  -6, -17,  -4, -19,   0, -11,
      6, -13,   9,  33,  14,  10, -16,  17,  10,   4,
    -71,  10,  -9,  17,   1,  20,   3,   8,  21,  18,
      6,  24,   0,  -1,   0, -16,  -6,   5,   0,  13,
     17,  19,  11,  29,  25, -11,  11,  -6,  13, -15,
     -7,  29,   0,   8, -11, -22, -20, -21, -17, -18,
    -49,  -2, -21,   0,  -1,   2,  -9,  -8,   6,   6,
      8,  10,   8,  -9,   2,   0,   4,   2,  13,  12,
     23,  15,  12,  16,  26, -21,  -2, -21,  11, -23,
      4,  33,   7,  33,   6, -13, -34,  -5, -27, -10,
    -82,   1,   4,  19,  -6,  27,   6,  29,  12,  26,
     -1,  24,   5,  18, -17, -17, -17,  -6, -10,   0,
      7,   2,   9,  16,  12, -11,   0, -11,   9, -23,
      0,   3,   8,   8,  13,   1,  -8,  -7,   7,  -6,
    -60, -10,  -7,   1,  -9,   8,  -6,  13,  -2,  15,
      1,  10,  13,  11, -15,   0,  -6,  -9,   1,   0,
     13,  -1,  11,   3,  13, -21, -13, -26,   7, -31,
     10,   7,  16,  33,  31,  10, -22,   8,  -1,   2,
     -3,   7,  -5,  -5,   8,  -2,  17,  -9,  18, -24,
     -2, -19, -10,  -4,  28,  17,   5,  28,  -2,   7,
     -4,  15,   7,   8,   6,  23,  13,  21, -14,  20,
    -17, -18, -11, -33, -30, -11,  23, -13,  -5,  -9,
     18,  -4, -17, -23,   4, -20,   4, -26,   3, -36,
      0, -32,  -2, -12,  29,  34,  16,  24,  10,   6,
      0,  12,   8,  -4,   8,  13,   0,   6, -16,  12,
     -5, -13,  -3,  -7, -13,  -3,   8,   2, -14,   0,
    -13,   0,   8,  -3,   0,   4,  21,  11,   9, -16,
    -10, -18,  -5,  16,  10,  16,  -5,  15, -13,  -5,
    -15,  -1,   6,  -4,  -6,  23,   2,  16, -17,  12,
    -10, -44,  -3, -33,  -6,  12,  34,   1,  20,   3,
      8, -12,  -3, -21,  -3, -14,   8,  -5,  -4, -28,
     -7, -32,   2,   8,  12,  34,   4,  12,  -1,  -6,
     -9,  -4,   7, -17,  -4,  13, -11,   1, -19,   4,
      0, -39,   4,  -7,  11,  21,  20,  16,  10,  11,
      4,   6,   0,   7,  -8,  -4,   0,  -6,   9, -13,
     11,   7,  11,  15,  37,   4,   9,   5,  -5, -11,
      5,   9,  22,   1,  27,  18,   4,  14,  -5,   0,
    -12,   3,  -4, -32, -14, -12,  17, -22, -17, -11,
     26,  -6, -11, -10, -12, -23, -12, -23,  -5, -24,
     13,  -5,  19,   8,  38,  21,  20,   2,   6, -12,
     11,   5,  23, -11,  29,   9,  -9,   0,  -7,  -6,
     -1,   7,   2,  -7,   3,  -3,   2,  -6, -27,  -3,
     -6,  -2,  14,   9, -16,   1,   3,  14,   0,  -5,
      3,   8,  16,  36,  19,   3,  -1,  -6, -17, -24,
     -4,  -7,  21, -11,  14,  18,  -7,   9,  -9,  -7,
     -6, -22,   3, -33,  10,  11,  28,  -7,   7,   0,
     16, -14,   2,  -8, -20, -17,  -9,  -2, -14, -16,
      6,  -5,  24,  28,  21,  20,   8,  -9,  -4, -25,
      1, -11,  22, -24,  15,   8, -21,  -5, -11, -14,
      5, -18,  11,  -7,  27,  20,  14,   7,  -1,   9,
    -16,  27,   2,  10,  13,  16,  20, -20,  29, -20,
    -14, -16, -13,  -8,   9,  13,  -2,  33,   9,  19,
     17,  23,  17,  22,   6,   6,  -9,  -2, -12,  -2,
    -20, -13, -13, -10, -45,  -4,  16,  -8,  -2,  -7,
      5,  15,  -9,  -7,   9,  -2,   8, -37,  14, -31,
    -11, -29,  -5, -16,  11,  30,   7,  29,  21,  18,
     23,  19,  18,   9,   7,  -3, -23, -17, -14,  -9,
     -8,  -9,  -6,  15, -27,   4,   2,   6, -12,   1,
    -26,  19,  15,  12,   5,  22,  24,   0,  21, -12,
    -21, -15,  -8,  11,  -7,  12, -14,  20,  -2,   6,
      7,   6,  16,   9,  -6,   5, -21,  -7, -15, -10,
    -13, -39,  -5, -10, -20,  19,  28,   5,  22,   5,
     -4,   6,   3,  -5,   1,   4,  11, -16,   6, -23,
    -19, -29,   0,   3,  -6,  30,  -3,  17,  10,   5,
     13,   2,  17,  -3,  -5,  -3, -35, -21, -17, -17,
     -2, -35,   2,  15,  -3,  28,  13,  21,  13,  13,
     -8,  25,   8,  23,  -3,  13,   3, -17,  20,  -8,
      0,  10,   8,  11,  18,   0,   1,  10,   5,   0,
     28,  17,  32,  15,  26,   1, -19,  -9,  -3, -21,
    -15,   7,  -6,  -9, -29,  -5,  10, -17, -15,  -9,
     13,  13,  -3,   5,  -7,  -4,  -9, -34,   5, -20,
      2,  -3,  16,   3,  20,  17,  11,   7,  17,   0,
     34,  13,  33,   2,  28,  -8, -32, -24,  -5, -29,
     -3,  12,   0,  15, -11,   3,  -3,  -2, -24,  -1,
    -18,  17,  21,  25, -11,  19,   6,   3,  11,   0,
     -7,  11,  13,  31,   1,   0,  -9,  -1,  -5, -12,
     18,   0,  31,   2,  13,   1, -30, -14,  -7, -29,
     -9, -18,   1, -10,  -4,  18,  22,  -3,  10,   2,
      3,   5,   9,   7, -15,   1,  -5, -13,  -2, -12,
     -5,  -2,  21,  23,   2,  16,   0,  -5,   6, -13,
     23,  -3,  32, -10,  15,  -8, -44, -28,  -9, -37,
      2, -13,   9,  15,  12,  27,   7,  12,   0,  11,
    -44,   6, -30,  -8,   9,  10,  11,  14,  23,  -5,
      8,  -4,  14, -12,  37,  14,  12,  26,   4,  16,
     -8,  16,  -9,   7,  -6,  19,  12,  25,  -5,  24,
    -15, -13,  -8, -36, -34, -31,  -1, -18,  -4, -18,
    -22,  -5, -42, -26,   6,  -8,  -1,  -2,   9, -17,
     10, -18,  21, -19,  39,  31,  23,  23,  16,  15,
     -2,  12,  -7,  -6,  -5,   9,  -1,  10,  -7,  16,
     -4,  -9,   0, -10, -17, -22, -16,  -2, -14,  -9,
    -55,  -1, -17,  -6,   1,  16,  15,  35,  15,   2,
      0,  -4,  19,   8,  20,  13,   1,  14,  -7,   3,
    -18,   0, -10,  -5, -19,  19,   0,  21,  -8,  16,
     -9, -39,   0, -36, -10,  -7,   9,  -4,  20,  -5,
    -33, -13, -29, -24,  -1,  -1,   2,  18,   0,  -9,
      3, -17,  27,   0,  21,  30,  12,  11,   5,   2,
    -12,  -4,  -9, -19, -18,   9, -13,   6, -11,   8,
      2, -35,   8, -10,   7,   1,  -4,  11,  10,   2,
    -36,   5, -24,   4,  -7,   7,  -6,  17,  14,   5,
     22,  22,  35,   8,  46,   1,  17,   3,   0,  -2,
      2,  10,   5,   0,  14,  15,   2,  18,   2,   4,
    -11,   7,  -1, -36, -18, -32,  -7, -27, -17, -20,
    -14,  -7, -36, -13, -10, -10, -18,   0,   0,  -5,
     25,   8,  43,   0,  48,  18,  27,   0,  12,  -3,
      7,   6,   7, -13,  15,   5, -11,   3,   0,  -2,
      0,  12,   6, -10,   0, -23, -22, -11, -26, -12,
    -47,  -3, -11,   6, -15,  13,  -2,  38,   6,  13,
     15,  22,  40,  28,  28,   0,   5,  -8, -10, -15,
     -7,  -7,   4, -13,   1,  14,  -9,  14,   0,  -2,
     -4, -18,   7, -36,   6,  -8,   3, -13,   7,  -8,
    -25, -15, -22, -11, -18,  -4, -15,  22,  -8,   2,
     17,   9,  48,  20,  30,  17,  16, -11,   1, -16,
     -2, -10,   5, -26,   2,   4, -22,   0,  -2, -10,
      6, -13,  14, -10,  23,   0, -10,   2,  -1,   0,
    -57,  26, -22,   7,  14,  28,  14,   3,  35,   0,
     -3,  -1,  11, -16,  18,  10,   4,  31,  15,  28,
     14,  23,   1,  21,  -7,   2, -11,   1,  -3,   1,
    -18,  -9, -10, -13, -49, -24,  -8, -14,  -2, -16,
    -35,  14, -34, -10,  10,  10,   1, -12,  20, -12,
      0, -15,  18, -24,  20,  27,  14,  28,  27,  27,
     20,  19,   2,   8,  -5,  -7, -25, -13,  -5,  -5,
     -6,  -5,  -2,  12, -31, -15, -23,   1, -12,  -8,
    -68,  18,  -9,   9,   6,  35,  18,  25,  26,   7,
    -10,  -1,  16,   3,   1,   9,  -6,  19,   4,  15,
      4,   6,   0,   8, -20,   2, -23,  -2,  -7,  -5,
    -12, -35,  -1, -13, -24,   0,   3,   0,  22,  -4,
    -46,   6, -21,  -8,   2,  16,   5,   8,  11,  -4,
     -8, -15,  24,  -4,   2,  26,   3,  16,  16,  14,
      9,   2,   1,  -4, -19,  -7, -36, -17,  -9, -13,
      0, -31,   5,  12,  -7,   8, -11,  15,  13,   4,
    -49,  24, -16,  20,  -2,  26,  -2,   7,  25,  10,
     11,  25,  32,   3,  27,  -2,   8,   8,  11,   9,
     24,  17,  16,  14,  13,  -2, -20,  -5,   4, -17,
    -14,  12,  -3, -13, -33, -25, -14, -23, -15, -19,
    -27,  12, -28,   2,  -6,   7, -15,  -9,  11,  -1,
     13,  11,  40,  -4,  29,  14,  19,   5,  23,   8,
     30,  13,  17,   0,  14, -12, -34, -20,   2, -25,
     -2,  16,   4,  12, -15, -16, -29,  -7, -24, -10,
    -60,  16,  -3,  22, -10,  32,   0,  28,  17,  18,
      3,  25,  37,  23,  10,  -3,  -2,  -3,   0,  -3,
     14,   0,  14,   1,   0,  -2, -32,  -9,   1, -25,
     -7, -13,   5, -13,  -8,  -1,  -2,  -8,  10,  -6,
    -38,   4, -15,   4, -14,  13, -12,  11,   2,   6,
      6,  11,  45,  16,  11,  13,   7,  -6,  12,  -4,
     20,  -3,  16, -12,   1, -12, -46, -24,   0, -33,
      3,  -9,  12,  12,   8,   7, -17,   6,   0,   2
};

static const signed short etable2[5120]={
     73, -32, -60, -15, -26,  59,   2, -33,  30, -10,
     -3, -17,   8,  30,  -1, -26,  -4, -22,  10,  16,
    -36,  -5, -11,  56,  37,   6, -10,  -5, -13,  -3,
      6,  -5,  11,   4, -19,  -5, -16,  41,  24,  13,
      4, -11, -37,  23,  -5,  46,  -2, -29,  -5, -39,
    -21,  -9,   0,  49,  12,  -9, -16, -26,  22,  15,
    -45, -20,  -5,  40,  22,  17, -26,  31, -14,   2,
    -14,  10,  30,  20, -27,  -9, -39,  39,  18,   5,
     34, -25, -48, -28, -11,  34,  -2, -41,   9,  -7,
    -17,  21,  20,  24, -17, -33,   0, -24,  10,  42,
      3,  -5,  10,  42,  11,   8,  -3,   3,  16,   9,
     22,  -2,   0, -33, -10,  18,   7,  58,  10,  28,
    -34,  -4, -25,  10,   9,  21,  -7, -36, -26, -36,
    -35,  28,  12,  42,  -3, -16, -12, -28,  21,  42,
     -5, -21,  16,  26,  -4,  19, -19,  39,  15,  15,
      1,  13,  19, -17, -17,  14, -15,  55,   4,  19,
     28, -20, -51, -14,  -6,   7,   0, -26,  27,  -4,
     18, -40,  -6,  16,  -1, -15,   0, -55,  -5, -16,
    -19,  14,  -3,  49,  14,   1, -22, -30, -12,   0,
     24,  15,   9, -17, -45, -29,   4,  28,  51,  35,
    -40,   0, -28,  24,  14,  -5,  -4, -21,  -7, -33,
      0, -32, -15,  35,  12,   1, -11, -58,   5, -16,
    -28,   0,   1,  33,   0,  11, -39,   5, -14,   6,
      3,  31,  28,  -1, -53, -33, -19,  25,  46,  26,
    -11, -14, -39, -27,   9, -17,  -4, -33,   6,   0,
      4,  -1,   5,  10, -17, -22,   5, -57,  -5,   9,
     20,  13,  18,  35, -11,   3, -16, -22,  17,  13,
     40,  19,  -1, -55, -35,  -5,  27,  44,  37,  49,
    -80,   6, -16,  11,  30, -30,  -9, -28, -28, -29,
    -13,   6,  -2,  28,  -3,  -5,  -7, -60,   5,   9,
     11,  -1,  24,  19, -27,  13, -32,  13,  15,  19,
     19,  35,  17, -39, -43,  -9,   4,  42,  32,  41,
     78, -21, -43,   4, -38,  17,  17,  -5,  55,  24,
    -15, -36,  14,   4,  24, -24,  12,   5,  17,  31,
    -54,  -5,  -2,  27,  43, -12,   2,   9,  -9, -15,
     22,  -3,  28,  21, -20,   3,  20,  28,   9,  -5,
      9,  -1, -20,  43, -17,   3,  12,   0,  20,  -4,
    -33, -29,   6,  22,  38,  -7,   0,   1,  29,  30,
    -63, -21,   3,  11,  27,  -1, -14,  45, -10,  -9,
      1,  12,  47,  37, -28,   0,  -2,  26,   4, -13,
     39, -14, -30,  -8, -22,  -8,  12, -12,  34,  27,
    -29,   2,  26,  -2,   8, -31,  16,   3,  17,  57,
    -14,  -6,  19,  13,  16, -10,   8,  17,  20,  -2,
     38,   0,  17, -16, -11,  27,  44,  45,  -4,   8,
    -29,   5,  -7,  30,  -1, -21,   7,  -7,   0,   0,
    -47,   9,  18,  15,  22, -14,   4,   0,  28,  57,
    -23, -21,  25,  -2,   1,   0,  -7,  53,  19,   3,
     17,  15,  36,   0, -19,  24,  21,  43,  -9,   0,
     33, -10, -34,   5, -17, -35,  15,   1,  53,  30,
      6, -59,   0, -10,  24, -13,  17, -27,   1,  -1,
    -37,  13,   4,  20,  20, -18, -10, -16,  -8, -11,
     39,  18,  26,   0, -46, -20,  41,  15,  37,  15,
    -35,  10, -11,  44,   3, -48,  10,   6,  17,   2,
    -11, -51,  -8,   8,  38,   3,   4, -31,  12,  -2,
    -46,  -1,  10,   4,   5,  -7, -26,  19, -10,  -5,
     18,  34,  45,  15, -54, -24,  18,  13,  31,   7,
     -5,  -3, -21,  -7,  -2, -60,  10,  -5,  32,  34,
     -7, -20,  11, -16,   8, -20,  21, -29,   1,  24,
      2,  13,  27,   6,  -5, -15,  -3,  -8,  21,   1,
     55,  21,  15, -38, -37,   3,  65,  32,  23,  30,
    -74,  17,   0,  31,  18, -73,   5,   0,  -3,   5,
    -25, -12,   3,   1,  22,  -3,   9, -33,  12,  24,
     -6,  -2,  33,  -9, -21,  -5, -20,  27,  19,   7,
     34,  37,  34, -22, -44,   0,  41,  29,  17,  21,
     76, -35, -31, -28, -49,  43, -40,   0,  29, -14,
      8,   5,  10,  18, -26, -46,   0,   7,   6,   3,
    -25,  -7,  -2,  40,  28,  14,  18,  -3, -27, -28,
     -8, -45, -13,  34, -13, -27, -15,  31,  12,   3,
      7, -15,  -9,   9, -28,  29, -45,   5,  -6, -43,
     -9,  12,   2,  36, -12, -30, -11,   3,  17,   3,
    -34, -22,   3,  24,  12,  24,   2,  32, -28, -22,
    -29, -29,   5,  50, -21, -31, -38,  29,   7,  -5,
     36, -29, -19, -41, -34,  18, -45,  -6,   8, -10,
     -5,  43,  23,  11, -42, -53,   5,   5,   6,  30,
     14,  -8,  20,  26,   1,  16,  25,   4,   3, -15,
      7, -41, -23,  -3,  -4,  -3,   8,  48,  -1,  17,
    -32,  -8,   3,  -2, -13,   4, -50,  -1, -27, -39,
    -23,  51,  15,  30, -27, -37,  -7,   1,  17,  29,
      5, -23,  25,  10, -14,  26,   8,  41,   1,  -9,
    -13, -26,  -5,  12, -12,  -7, -14,  45,  -6,   9,
     31, -24, -23, -27, -29,  -9, -43,   8,  26,  -7,
     30, -17,  -4,   3, -26, -35,   5, -24, -10, -28,
     -9,  12,   5,  33,   5,   8,   5, -29, -26, -24,
      9, -23, -14,  12, -39, -52,   5,  18,  39,  24,
    -37,  -3,   0,  10,  -7, -22, -48,  12,  -8, -36,
     12,  -9, -12,  22, -12, -19,  -6, -28,   0, -29,
    -18,  -3,  11,  17, -10,  18, -10,   7, -27, -18,
    -11,  -7,   3,  28, -47, -55, -18,  15,  34,  16,
     -8, -17, -10, -40, -13, -34, -47,   0,   5,  -4,
     16,  21,   8,  -2, -42, -43,  10, -26, -10,  -2,
     31,  11,  27,  19, -21,  10,  12, -20,   3, -11,
     25, -20, -25, -25, -29, -28,  28,  34,  25,  38,
    -77,   2,  11,  -1,   7, -47, -52,   5, -29, -33,
     -1,  28,   0,  15, -28, -26,  -2, -30,   0,  -2,
     22,  -4,  33,   3, -36,  21,  -3,  15,   2,  -5,
      4,  -4,  -6,  -9, -37, -31,   5,  32,  20,  30,
     81, -25, -14,  -8, -61,   0, -25,  28,  54,  20,
     -3, -14,  17,  -8,   0, -44,  16,  35,  13,  18,
    -43,  -7,   6,  11,  33,  -4,  30,  11, -22, -40,
      6, -43,   3,  50, -14, -18,  22,  18,  -1, -16,
     12,  -4,   8,  29, -39, -12, -30,  33,  19,  -8,
    -21,  -6,   8,   9,  13, -28,   4,  31,  24,  18,
    -52, -23,  12,  -4,  18,   5,  14,  47, -24, -34,
    -14, -27,  22,  66, -22, -22,  -1,  16,  -6, -24,
     41, -18,  -2, -21, -45, -24, -30,  21,  33,  24,
    -17,  24,  29, -15, -16, -51,  21,  33,  13,  45,
     -3,  -8,  28,  -2,   7,  -2,  37,  19,   7, -27,
     22, -39,  -7,  12,  -5,   5,  45,  35, -15,  -1,
    -27,   1,  20,  17, -24, -38, -35,  26,  -1,  -4,
    -35,  32,  21,   3,  -2, -35,   8,  29,  24,  44,
    -12, -24,  34, -18,  -8,   7,  21,  55,   5, -21,
      2, -23,  11,  28, -13,   1,  22,  33, -21, -10,
     36, -13,  -5,  -7, -40, -51, -28,  36,  52,  27,
     18, -36,   2, -22,   0, -33,  21,   2,  -3, -13,
    -26,  11,  14,   4,  10, -10,  18, -14, -22, -36,
     24, -21,   1,  28, -40, -42,  42,   5,  25,   5,
    -32,   6,  17,  31, -19, -65, -33,  41,  16,  -1,
      0, -29,  -6,  -4,  13, -17,   9,  -1,   8, -14,
    -35,  -3,  19, -11,  -4,   0,   1,  21, -23, -30,
      3,  -5,  20,  44, -48, -46,  19,   3,  20,  -3,
     -3,  -7,   6, -20, -25, -77, -32,  29,  31,  30,
      4,   2,  14, -29, -16, -40,  26,   0,  -3,  12,
     13,  10,  36,  -9, -15,  -8,  24,  -6,   7, -22,
     40, -17,  -8,  -9, -31, -18,  66,  22,  11,  19,
    -72,  13,  29,  18,  -4, -90, -37,  34,  -4,   1,
    -13,   9,   6, -11,  -2, -24,  13,  -3,   7,  11,
      4,  -4,  42, -25, -31,   1,   8,  29,   6, -17,
     19,  -2,  10,   6, -38, -22,  42,  19,   6,  11,
    116, -20, -68, -30, -28,  83,  28, -18,  32, -22,
    -13, -21,   5,  28,   5,  -7, -24,  -8, -22,  17,
    -23,  30, -25,  45,  15,  -9, -11, -18,  22, -10,
      4,  -2,  19, -12,  23,   3, -43,   2,  12,  -4,
     47,   0, -45,   7,  -7,  69,  23, -13,  -2, -51,
    -32, -14,  -3,  47,  19,   8, -37, -11, -10,  16,
    -32,  15, -19,  29,   0,   1, -28,  18,  20,  -4,
    -16,  13,  38,   3,  15,   0, -66,   0,   7, -13,
     77, -13, -56, -43, -13,  57,  23, -26,  11, -19,
    -27,  16,  17,  22, -10, -15, -19, -10, -22,  43,
     16,  30,  -2,  31, -11,  -6,  -5,  -9,  52,   2,
     20,   0,   8, -50,  33,  27, -19,  19,  -1,   9,
      8,   6, -33,  -4,   7,  44,  18, -21, -23, -48,
    -46,  24,   9,  40,   3,   1, -32, -13, -11,  43,
      7,  14,   3,  15, -26,   3, -21,  26,  50,   8,
      0,  16,  27, -34,  25,  23, -43,  17,  -6,   1,
     71,  -9, -59, -29,  -8,  30,  26, -11,  30, -16,
      8, -44,  -9,  14,   5,   2, -19, -40, -38, -15,
     -7,  50, -17,  38,  -7, -14, -24, -43,  22,  -6,
     22,  19,  17, -34,  -2, -20, -23, -10,  39,  16,
      2,  11, -36,   9,  13,  17,  21,  -6,  -5, -45,
    -10, -36, -18,  33,  19,  19, -31, -44, -27, -15,
    -16,  34, -11,  22, -22,  -4, -40,  -7,  21,   0,
      1,  35,  36, -18, -10, -24, -46, -12,  34,   8,
     32,  -2, -47, -42,   7,   5,  21, -18,   9, -12,
     -5,  -5,   2,   8, -10,  -4, -14, -42, -38,  10,
     33,  49,   5,  24, -33, -12, -17, -35,  52,   6,
     38,  22,   7, -72,   7,   3,   0,   6,  25,  30,
    -36,  18, -24,  -3,  28,  -7,  16, -13, -26, -41,
    -24,   1,  -5,  26,   3,  12, -27, -46, -27,  10,
     24,  34,  10,   8, -49,  -2, -34,   0,  51,  12,
     17,  38,  25, -56,   0,   0, -22,   3,  20,  22,
    121,  -9, -50, -10, -40,  40,  43,   9,  58,  12,
    -25, -41,  11,   2,  31,  -5,  -8,  19, -15,  32,
    -41,  30, -16,  16,  20, -28,   0,  -3,  26, -22,
     19,   0,  36,   4,  22,  12,  -6,  -9,  -1, -24,
     52,  10, -27,  27, -18,  26,  38,  14,  23, -16,
    -44, -33,   3,  20,  45,  10, -20,  15,  -3,  31,
    -50,  14, -10,   0,   5, -17, -15,  32,  24, -16,
     -1,  15,  55,  20,  14,   8, -29, -12,  -7, -32,
     82,  -3, -38, -23, -24,  15,  38,   2,  37,  15,
    -39,  -2,  23,  -4,  15, -12,  -3,  17, -15,  58,
     -1,  29,   6,   2,  -5, -26,   7,   4,  56,  -9,
     35,   3,  25, -33,  32,  36,  17,   7, -15,  -9,
     13,  17, -15,  15,  -3,   1,  33,   7,   1, -12,
    -58,   5,  15,  13,  29,   3, -16,  13,  -4,  57,
    -10,  13,  11, -13, -21, -15,  -9,  40,  55,  -3,
     14,  19,  44, -17,  24,  32,  -5,   4, -21, -18,
     76,   1, -41,  -9, -19, -12,  41,  17,  55,  18,
     -3, -63,  -3, -12,  30,   5,  -3, -12, -31,   0,
    -24,  49,  -8,   9,  -1, -33, -12, -29,  27, -18,
     37,  21,  34, -17,  -3, -11,  14, -23,  25,  -2,
      7,  22, -18,  29,   1, -25,  36,  21,  20,  -9,
    -22, -56, -11,   6,  45,  21, -15, -16, -20,  -1,
    -33,  34,  -2,  -6, -17, -23, -28,   6,  25, -12,
     16,  37,  53,  -1, -11, -15,  -8, -25,  20, -11,
     37,   8, -29, -22,  -4, -37,  36,   9,  34,  22,
    -17, -24,   8, -18,  15,  -2,   1, -14, -31,  25,
     15,  48,  13,  -4, -28, -31,  -5, -21,  57,  -4,
     53,  24,  23, -55,   6,  12,  37,  -6,  11,  11,
    -31,  28,  -6,  16,  16, -50,  31,  14,   0,  -6,
    -36, -17,   0,   0,  29,  14, -11, -18, -20,  25,
      6,  33,  19, -20, -43, -21, -21,  14,  55,   0,
     32,  40,  42, -39,  -1,   8,  14,  -8,   6,   3,
    119, -24, -39, -44, -51,  66, -14,  15,  31, -26,
     -1,   0,   7,  16, -19, -28, -19,  22, -26,   4,
    -13,  28, -16,  29,   5,  -1,  16, -16,   8, -35,
    -10, -42,  -4,  17,  29, -19, -42,  -7,   0, -15,
     50,  -3, -16,  -5, -30,  53, -19,  20,  -3, -55,
    -19,   8,   0,  34,  -5, -11, -32,  18, -15,   4,
    -22,  13, -10,  13,  -9,   8,   0,  19,   7, -29,
    -31, -26,  13,  33,  21, -22, -65,  -9,  -4, -23,
     79, -17, -27, -56, -36,  41, -19,   8,  10, -22,
    -15,  39,  20,   9, -35, -35, -15,  20, -26,  31,
     26,  27,   6,  15, -20,   0,  23,  -8,  38, -22,
      5, -38, -15, -20,  39,   4, -18,   9, -13,  -1,
     10,   3,  -4, -18, -15,  27, -24,  13, -24, -51,
    -34,  47,  12,  28, -21, -19, -27,  16, -15,  30,
     17,  12,  12,   0, -36,  10,   7,  27,  37, -16,
    -15, -22,   3,  -4,  31,   1, -42,   7, -18,  -9,
     74, -12, -30, -42, -30,  14, -16,  23,  29, -19,
     20, -21,  -7,   1, -19, -17, -14, -10, -43, -27,
      3,  48,  -8,  22, -16,  -7,   4, -42,   9, -31,
      6, -20,  -6,  -4,   3, -43, -22, -20,  28,   5,
      5,   7,  -7,  -4,  -9,   0, -21,  28,  -6, -48,
      2, -14, -15,  20,  -5,   0, -27, -14, -32, -28,
     -5,  32,  -2,   6, -32,   3, -12,  -5,   8, -25,
    -14,  -4,  12,  11,  -4, -47, -45, -22,  22,  -2,
     34,  -6, -18, -55, -15, -11, -21,  16,   8, -16,
      6,  16,   5,  -4, -35, -24, -10, -12, -43,  -1,
     43,  47,  14,   8, -43,  -5,  10, -34,  39, -18,
     22, -16, -17, -42,  13, -19,   1,  -3,  14,  20,
    -34,  14,   4, -17,   5, -24, -26,  20, -27, -45,
    -12,  24,  -2,  13, -21,  -8, -22, -16, -32,  -2,
     34,  31,  20,  -7, -58,   5,  -5,   2,  38, -12,
      2,  -1,   1, -26,   5, -23, -21,  -6,   8,  11,
    124, -13, -21, -23, -62,  23,   0,  43,  57,   8,
    -13, -18,  14, -10,   6, -26,  -3,  49, -19,  19,
    -31,  27,  -7,   0,  11, -20,  29,  -1,  12, -47,
      4, -39,  11,  34,  28,  -9,  -5, -19, -13, -34,
     55,   6,   1,  14, -41,  10,  -4,  48,  22, -20,
    -31, -10,   5,   7,  20,  -9, -16,  45,  -8,  19,
    -40,  12,  -1, -15,  -4, -10,  12,  34,  11, -41,
    -16, -24,  30,  49,  20, -13, -28, -22, -18, -43,
     84,  -6,  -9, -36, -47,  -1,  -4,  36,  36,  12,
    -27,  20,  26, -17,  -9, -33,   1,  47, -19,  46,
      9,  27,  15, -13, -15, -18,  35,   6,  42, -33,
     20, -36,   1,  -4,  38,  14,  18,  -2, -27, -20,
     15,  13,  13,   1, -26, -14,  -9,  41,   1, -16,
    -46,  27,  18,   1,   4, -16, -11,  43,  -8,  45,
      0,  11,  21, -29, -30,  -8,  19,  42,  41, -28,
      0, -20,  20,  11,  30,  10,  -4,  -5, -32, -28,
     79,  -2, -12, -22, -42, -28,  -1,  51,  54,  15,
      8, -41,   0, -24,   6, -15,   1,  17, -36, -12,
    -14,  47,   0,  -6, -11, -26,  16, -27,  13, -43,
     22, -18,  10,  12,   2, -34,  15, -33,  13, -13,
     10,  18,  10,  15, -21, -41,  -6,  56,  19, -13,
     -9, -33,  -9,  -6,  20,   1, -11,  13, -24, -13,
    -23,  32,   6, -22, -26, -15,   0,   8,  12, -37,
      1,  -2,  28,  27,  -5, -37,  -7, -35,   8, -21,
     39,   4,   0, -35, -27, -53,  -6,  44,  33,  18,
     -5,  -2,  11, -31,  -9, -22,   6,  15, -36,  13,
     25,  46,  23, -20, -37, -24,  23, -19,  43, -29,
     38, -14,   0, -26,  12, -10,  38, -16,   0,   0,
    -29,  25,  22,   2,  -6, -67, -11,  49,  -1, -10,
    -24,   5,   3, -13,   4,  -5,  -6,  11, -25,  12,
     16,  31,  28, -36, -53, -13,   6,  16,  42, -24,
     17,   1,  18, -10,   4, -13,  15, -18,  -5,  -7,
     29, -25, -22,  -2,   6,  67,  11, -49,   1,  10,
     24,  -5,  -3,  13,  -4,   5,   6, -11,  25, -12,
    -16, -31, -28,  36,  53,  13,  -6, -16, -42,  24,
    -17,  -1, -18,  10,  -4,  13, -15,  18,   5,   7,
    -39,  -4,   0,  35,  27,  53,   6, -44, -33, -18,
      5,   2, -11,  31,   9,  22,  -6, -15,  36, -13,
    -25, -46, -23,  20,  37,  24, -23,  19, -43,  29,
    -38,  14,   0,  26, -12,  10, -38,  16,   0,   0,
    -10, -18, -10, -15,  21,  41,   6, -56, -19,  13,
      9,  33,   9,   6, -20,  -1,  11, -13,  24,  13,
     23, -32,  -6,  22,  26,  15,   0,  -8, -12,  37,
     -1,   2, -28, -27,   5,  37,   7,  35,  -8,  21,
    -79,   2,  12,  22,  42,  28,   1, -51, -54, -15,
     -8,  41,   0,  24,  -6,  15,  -1, -17,  36,  12,
     14, -47,   0,   6,  11,  26, -16,  27, -13,  43,
    -22,  18, -10, -12,  -2,  34, -15,  33, -13,  13,
    -15, -13, -13,  -1,  26,  14,   9, -41,  -1,  16,
     46, -27, -18,  -1,  -4,  16,  11, -43,   8, -45,
      0, -11, -21,  29,  30,   8, -19, -42, -41,  28,
      0,  20, -20, -11, -30, -10,   4,   5,  32,  28,
    -84,   6,   9,  36,  47,   1,   4, -36, -36, -12,
     27, -20, -26,  17,   9,  33,  -1, -47,  19, -46,
     -9, -27, -15,  13,  15,  18, -35,  -6, -42,  33,
    -20,  36,  -1,   4, -38, -14, -18,   2,  27,  20,
    -55,  -6,  -1, -14,  41, -10,   4, -48, -22,  20,
     31,  10,  -5,  -7, -20,   9,  16, -45,   8, -19,
     40, -12,   1,  15,   4,  10, -12, -34, -11,  41,
     16,  24, -30, -49, -20,  13,  28,  22,  18,  43,
   -124,  13,  21,  23,  62, -23,   0, -43, -57,  -8,
     13,  18, -14,  10,  -6,  26,   3, -49,  19, -19,
     31, -27,   7,   0, -11,  20, -29,   1, -12,  47,
     -4,  39, -11, -34, -28,   9,   5,  19,  13,  34,
     34, -14,  -4,  17,  -5,  24,  26, -20,  27,  45,
     12, -24,   2, -13,  21,   8,  22,  16,  32,   2,
    -34, -31, -20,   7,  58,  -5,   5,  -2, -38,  12,
     -2,   1,  -1,  26,  -5,  23,  21,   6,  -8, -11,
    -34,   6,  18,  55,  15,  11,  21, -16,  -8,  16,
     -6, -16,  -5,   4,  35,  24,  10,  12,  43,   1,
    -43, -47, -14,  -8,  43,   5, -10,  34, -39,  18,
    -22,  16,  17,  42, -13,  19,  -1,   3, -14, -20,
     -5,  -7,   7,   4,   9,   0,  21, -28,   6,  48,
     -2,  14,  15, -20,   5,   0,  27,  14,  32,  28,
      5, -32,   2,  -6,  32,  -3,  12,   5,  -8,  25,
     14,   4, -12, -11,   4,  47,  45,  22, -22,   2,
    -74,  12,  30,  42,  30, -14,  16, -23, -29,  19,
    -20,  21,   7,  -1,  19,  17,  14,  10,  43,  27,
     -3, -48,   8, -22,  16,   7,  -4,  42,  -9,  31,
     -6,  20,   6,   4,  -3,  43,  22,  20, -28,  -5,
    -10,  -3,   4,  18,  15, -27,  24, -13,  24,  51,
     34, -47, -12, -28,  21,  19,  27, -16,  15, -30,
    -17, -12, -12,   0,  36, -10,  -7, -27, -37,  16,
     15,  22,  -3,   4, -31,  -1,  42,  -7,  18,   9,
    -79,  17,  27,  56,  36, -41,  19,  -8, -10,  22,
     15, -39, -20,  -9,  35,  35,  15, -20,  26, -31,
    -26, -27,  -6, -15,  20,   0, -23,   8, -38,  22,
     -5,  38,  15,  20, -39,  -4,  18,  -9,  13,   1,
    -50,   3,  16,   5,  30, -53,  19, -20,   3,  55,
     19,  -8,   0, -34,   5,  11,  32, -18,  15,  -4,
     22, -13,  10, -13,   9,  -8,   0, -19,  -7,  29,
     31,  26, -13, -33, -21,  22,  65,   9,   4,  23,
   -119,  24,  39,  44,  51, -66,  14, -15, -31,  26,
      1,   0,  -7, -16,  19,  28,  19, -22,  26,  -4,
     13, -28,  16, -29,  -5,   1, -16,  16,  -8,  35,
     10,  42,   4, -17, -29,  19,  42,   7,   0,  15,
     31, -28,   6, -16, -16,  50, -31, -14,   0,   6,
     36,  17,   0,   0, -29, -14,  11,  18,  20, -25,
     -6, -33, -19,  20,  43,  21,  21, -14, -55,   0,
    -32, -40, -42,  39,   1,  -8, -14,   8,  -6,  -3,
    -37,  -8,  29,  22,   4,  37, -36,  -9, -34, -22,
     17,  24,  -8,  18, -15,   2,  -1,  14,  31, -25,
    -15, -48, -13,   4,  28,  31,   5,  21, -57,   4,
    -53, -24, -23,  55,  -6, -12, -37,   6, -11, -11,
     -7, -22,  18, -29,  -1,  25, -36, -21, -20,   9,
     22,  56,  11,  -6, -45, -21,  15,  16,  20,   1,
     33, -34,   2,   6,  17,  23,  28,  -6, -25,  12,
    -16, -37, -53,   1,  11,  15,   8,  25, -20,  11,
    -76,  -1,  41,   9,  19,  12, -41, -17, -55, -18,
      3,  63,   3,  12, -30,  -5,   3,  12,  31,   0,
     24, -49,   8,  -9,   1,  33,  12,  29, -27,  18,
    -37, -21, -34,  17,   3,  11, -14,  23, -25,   2,
    -13, -17,  15, -15,   3,  -1, -33,  -7,  -1,  12,
     58,  -5, -15, -13, -29,  -3,  16, -13,   4, -57,
     10, -13, -11,  13,  21,  15,   9, -40, -55,   3,
    -14, -19, -44,  17, -24, -32,   5,  -4,  21,  18,
    -82,   3,  38,  23,  24, -15, -38,  -2, -37, -15,
     39,   2, -23,   4, -15,  12,   3, -17,  15, -58,
      1, -29,  -6,  -2,   5,  26,  -7,  -4, -56,   9,
    -35,  -3, -25,  33, -32, -36, -17,  -7,  15,   9,
    -52, -10,  27, -27,  18, -26, -38, -14, -23,  16,
     44,  33,  -3, -20, -45, -10,  20, -15,   3, -31,
     50, -14,  10,   0,  -5,  17,  15, -32, -24,  16,
      1, -15, -55, -20, -14,  -8,  29,  12,   7,  32,
   -121,   9,  50,  10,  40, -40, -43,  -9, -58, -12,
     25,  41, -11,  -2, -31,   5,   8, -19,  15, -32,
     41, -30,  16, -16, -20,  28,   0,   3, -26,  22,
    -19,   0, -36,  -4, -22, -12,   6,   9,   1,  24,
     36, -18,  24,   3, -28,   7, -16,  13,  26,  41,
     24,  -1,   5, -26,  -3, -12,  27,  46,  27, -10,
    -24, -34, -10,  -8,  49,   2,  34,   0, -51, -12,
    -17, -38, -25,  56,   0,   0,  22,  -3, -20, -22,
    -32,   2,  47,  42,  -7,  -5, -21,  18,  -9,  12,
      5,   5,  -2,  -8,  10,   4,  14,  42,  38, -10,
    -33, -49,  -5, -24,  33,  12,  17,  35, -52,  -6,
    -38, -22,  -7,  72,  -7,  -3,   0,  -6, -25, -30,
     -2, -11,  36,  -9, -13, -17, -21,   6,   5,  45,
     10,  36,  18, -33, -19, -19,  31,  44,  27,  15,
     16, -34,  11, -22,  22,   4,  40,   7, -21,   0,
     -1, -35, -36,  18,  10,  24,  46,  12, -34,  -8,
    -71,   9,  59,  29,   8, -30, -26,  11, -30,  16,
     -8,  44,   9, -14,  -5,  -2,  19,  40,  38,  15,
      7, -50,  17, -38,   7,  14,  24,  43, -22,   6,
    -22, -19, -17,  34,   2,  20,  23,  10, -39, -16,
     -8,  -6,  33,   4,  -7, -44, -18,  21,  23,  48,
     46, -24,  -9, -40,  -3,  -1,  32,  13,  11, -43,
     -7, -14,  -3, -15,  26,  -3,  21, -26, -50,  -8,
      0, -16, -27,  34, -25, -23,  43, -17,   6,  -1,
    -77,  13,  56,  43,  13, -57, -23,  26, -11,  19,
     27, -16, -17, -22,  10,  15,  19,  10,  22, -43,
    -16, -30,   2, -31,  11,   6,   5,   9, -52,  -2,
    -20,   0,  -8,  50, -33, -27,  19, -19,   1,  -9,
    -47,   0,  45,  -7,   7, -69, -23,  13,   2,  51,
     32,  14,   3, -47, -19,  -8,  37,  11,  10, -16,
     32, -15,  19, -29,   0,  -1,  28, -18, -20,   4,
     16, -13, -38,  -3, -15,   0,  66,   0,  -7,  13,
   -116,  20,  68,  30,  28, -83, -28,  18, -32,  22,
     13,  21,  -5, -28,  -5,   7,  24,   8,  22, -17,
     23, -30,  25, -45, -15,   9,  11,  18, -22,  10,
     -4,   2, -19,  12, -23,  -3,  43,  -2, -12,   4,
     72, -13, -29, -18,   4,  90,  37, -34,   4,  -1,
     13,  -9,  -6,  11,   2,  24, -13,   3,  -7, -11,
     -4,   4, -42,  25,  31,  -1,  -8, -29,  -6,  17,
    -19,   2, -10,  -6,  38,  22, -42, -19,  -6, -11,
      3,   7,  -6,  20,  25,  77,  32, -29, -31, -30,
     -4,  -2, -14,  29,  16,  40, -26,   0,   3, -12,
    -13, -10, -36,   9,  15,   8, -24,   6,  -7,  22,
    -40,  17,   8,   9,  31,  18, -66, -22, -11, -19,
     32,  -6, -17, -31,  19,  65,  33, -41, -16,   1,
      0,  29,   6,   4, -13,  17,  -9,   1,  -8,  14,
     35,   3, -19,  11,   4,   0,  -1, -21,  23,  30,
     -3,   5, -20, -44,  48,  46, -19,  -3, -20,   3,
    -36,  13,   5,   7,  40,  51,  28, -36, -52, -27,
    -18,  36,  -2,  22,   0,  33, -21,  -2,   3,  13,
     26, -11, -14,  -4, -10,  10, -18,  14,  22,  36,
    -24,  21,  -1, -28,  40,  42, -42,  -5, -25,  -5,
     27,  -1, -20, -17,  24,  38,  35, -26,   1,   4,
     35, -32, -21,  -3,   2,  35,  -8, -29, -24, -44,
     12,  24, -34,  18,   8,  -7, -21, -55,  -5,  21,
     -2,  23, -11, -28,  13,  -1, -22, -33,  21,  10,
    -41,  18,   2,  21,  45,  24,  30, -21, -33, -24,
     17, -24, -29,  15,  16,  51, -21, -33, -13, -45,
      3,   8, -28,   2,  -7,   2, -37, -19,  -7,  27,
    -22,  39,   7, -12,   5,  -5, -45, -35,  15,   1,
    -12,   4,  -8, -29,  39,  12,  30, -33, -19,   8,
     21,   6,  -8,  -9, -13,  28,  -4, -31, -24, -18,
     52,  23, -12,   4, -18,  -5, -14, -47,  24,  34,
     14,  27, -22, -66,  22,  22,   1, -16,   6,  24,
    -81,  25,  14,   8,  61,   0,  25, -28, -54, -20,
      3,  14, -17,   8,   0,  44, -16, -35, -13, -18,
     43,   7,  -6, -11, -33,   4, -30, -11,  22,  40,
     -6,  43,  -3, -50,  14,  18, -22, -18,   1,  16,
     77,  -2, -11,   1,  -7,  47,  52,  -5,  29,  33,
      1, -28,   0, -15,  28,  26,   2,  30,   0,   2,
    -22,   4, -33,  -3,  36, -21,   3, -15,  -2,   5,
     -4,   4,   6,   9,  37,  31,  -5, -32, -20, -30,
      8,  17,  10,  40,  13,  34,  47,   0,  -5,   4,
    -16, -21,  -8,   2,  42,  43, -10,  26,  10,   2,
    -31, -11, -27, -19,  21, -10, -12,  20,  -3,  11,
    -25,  20,  25,  25,  29,  28, -28, -34, -25, -38,
     37,   3,   0, -10,   7,  22,  48, -12,   8,  36,
    -12,   9,  12, -22,  12,  19,   6,  28,   0,  29,
     18,   3, -11, -17,  10, -18,  10,  -7,  27,  18,
     11,   7,  -3, -28,  47,  55,  18, -15, -34, -16,
    -31,  24,  23,  27,  29,   9,  43,  -8, -26,   7,
    -30,  17,   4,  -3,  26,  35,  -5,  24,  10,  28,
      9, -12,  -5, -33,  -5,  -8,  -5,  29,  26,  24,
     -9,  23,  14, -12,  39,  52,  -5, -18, -39, -24,
     32,   8,  -3,   2,  13,  -4,  50,   1,  27,  39,
     23, -51, -15, -30,  27,  37,   7,  -1, -17, -29,
     -5,  23, -25, -10,  14, -26,  -8, -41,  -1,   9,
     13,  26,   5, -12,  12,   7,  14, -45,   6,  -9,
    -36,  29,  19,  41,  34, -18,  45,   6,  -8,  10,
      5, -43, -23, -11,  42,  53,  -5,  -5,  -6, -30,
    -14,   8, -20, -26,  -1, -16, -25,  -4,  -3,  15,
     -7,  41,  23,   3,   4,   3,  -8, -48,   1, -17,
     -7,  15,   9,  -9,  28, -29,  45,  -5,   6,  43,
      9, -12,  -2, -36,  12,  30,  11,  -3, -17,  -3,
     34,  22,  -3, -24, -12, -24,  -2, -32,  28,  22,
     29,  29,  -5, -50,  21,  31,  38, -29,  -7,   5,
    -76,  35,  31,  28,  49, -43,  40,   0, -29,  14,
     -8,  -5, -10, -18,  26,  46,   0,  -7,  -6,  -3,
     25,   7,   2, -40, -28, -14, -18,   3,  27,  28,
      8,  45,  13, -34,  13,  27,  15, -31, -12,  -3,
     74, -17,   0, -31, -18,  73,  -5,   0,   3,  -5,
     25,  12,  -3,  -1, -22,   3,  -9,  33, -12, -24,
      6,   2, -33,   9,  21,   5,  20, -27, -19,  -7,
    -34, -37, -34,  22,  44,   0, -41, -29, -17, -21,
      5,   3,  21,   7,   2,  60, -10,   5, -32, -34,
      7,  20, -11,  16,  -8,  20, -21,  29,  -1, -24,
     -2, -13, -27,  -6,   5,  15,   3,   8, -21,  -1,
    -55, -21, -15,  38,  37,  -3, -65, -32, -23, -30,
     35, -10,  11, -44,  -3,  48, -10,  -6, -17,  -2,
     11,  51,   8,  -8, -38,  -3,  -4,  31, -12,   2,
     46,   1, -10,  -4,  -5,   7,  26, -19,  10,   5,
    -18, -34, -45, -15,  54,  24, -18, -13, -31,  -7,
    -33,  10,  34,  -5,  17,  35, -15,  -1, -53, -30,
     -6,  59,   0,  10, -24,  13, -17,  27,  -1,   1,
     37, -13,  -4, -20, -20,  18,  10,  16,   8,  11,
    -39, -18, -26,   0,  46,  20, -41, -15, -37, -15,
     29,  -5,   7, -30,   1,  21,  -7,   7,   0,   0,
     47,  -9, -18, -15, -22,  14,  -4,   0, -28, -57,
     23,  21, -25,   2,  -1,   0,   7, -53, -19,  -3,
    -17, -15, -36,   0,  19, -24, -21, -43,   9,   0,
    -39,  14,  30,   8,  22,   8, -12,  12, -34, -27,
     29,  -2, -26,   2,  -8,  31, -16,  -3, -17, -57,
     14,   6, -19, -13, -16,  10,  -8, -17, -20,   2,
    -38,   0, -17,  16,  11, -27, -44, -45,   4,  -8,
     -9,   1,  20, -43,  17,  -3, -12,   0, -20,   4,
     33,  29,  -6, -22, -38,   7,   0,  -1, -29, -30,
     63,  21,  -3, -11, -27,   1,  14, -45,  10,   9,
     -1, -12, -47, -37,  28,   0,   2, -26,  -4,  13,
    -78,  21,  43,  -4,  38, -17, -17,   5, -55, -24,
     15,  36, -14,  -4, -24,  24, -12,  -5, -17, -31,
     54,   5,   2, -27, -43,  12,  -2,  -9,   9,  15,
    -22,   3, -28, -21,  20,  -3, -20, -28,  -9,   5,
     80,  -6,  16, -11, -30,  30,   9,  28,  28,  29,
     13,  -6,   2, -28,   3,   5,   7,  60,  -5,  -9,
    -11,   1, -24, -19,  27, -13,  32, -13, -15, -19,
    -19, -35, -17,  39,  43,   9,  -4, -42, -32, -41,
     11,  14,  39,  27,  -9,  17,   4,  33,  -6,   0,
     -4,   1,  -5, -10,  17,  22,  -5,  57,   5,  -9,
    -20, -13, -18, -35,  11,  -3,  16,  22, -17, -13,
    -40, -19,   1,  55,  35,   5, -27, -44, -37, -49,
     40,   0,  28, -24, -14,   5,   4,  21,   7,  33,
      0,  32,  15, -35, -12,  -1,  11,  58,  -5,  16,
     28,   0,  -1, -33,   0, -11,  39,  -5,  14,  -6,
     -3, -31, -28,   1,  53,  33,  19, -25, -46, -26,
    -28,  20,  51,  14,   6,  -7,   0,  26, -27,   4,
    -18,  40,   6, -16,   1,  15,   0,  55,   5,  16,
     19, -14,   3, -49, -14,  -1,  22,  30,  12,   0,
    -24, -15,  -9,  17,  45,  29,  -4, -28, -51, -35,
     34,   4,  25, -10,  -9, -21,   7,  36,  26,  36,
     35, -28, -12, -42,   3,  16,  12,  28, -21, -42,
      5,  21, -16, -26,   4, -19,  19, -39, -15, -15,
     -1, -13, -19,  17,  17, -14,  15, -55,  -4, -19,
    -34,  25,  48,  28,  11, -34,   2,  41,  -9,   7,
     17, -21, -20, -24,  17,  33,   0,  24, -10, -42,
     -3,   5, -10, -42, -11,  -8,   3,  -3, -16,  -9,
    -22,   2,   0,  33,  10, -18,  -7, -58, -10, -28,
     -4,  11,  37, -23,   5, -46,   2,  29,   5,  39,
     21,   9,   0, -49, -12,   9,  16,  26, -22, -15,
     45,  20,   5, -40, -22, -17,  26, -31,  14,  -2,
     14, -10, -30, -20,  27,   9,  39, -39, -18,  -5,
    -73,  32,  60,  15,  26, -59,  -2,  33, -30,  10,
      3,  17,  -8, -30,   1,  26,   4,  22, -10, -16,
     36,   5,  11, -56, -37,  -6,  10,   5,  13,   3,
     -6,   5, -11,  -4,  19,   5,  16, -41, -24, -13
};

static const unsigned long ftable1[128]={
    314527,  295599,  293848,  280320,  336779,  291703,  297354,  266749,
    325815,  305109,  310555,  294891,  349515,  300052,  313812,  278588,
    326231,  348357,  322076,  347246,  335655,  327567,  314037,  310198,
    343640,  370152,  349471,  382719,  353433,  344311,  338152,  333632,
    314810,  285147,  304708,  279643,  319779,  271292,  295149,  257376,
    338219,  302387,  335244,  302877,  343236,  285341,  321676,  274547,
    316321,  320899,  325378,  333870,  309279,  291473,  302532,  288065,
    344907,  351169,  369278,  382224,  334752,  312711,  335747,  316511,
    316511,  335747,  312711,  334752,  382224,  369278,  351169,  344907,
    288065,  302532,  291473,  309279,  333870,  325378,  320899,  316321,
    274547,  321676,  285341,  343236,  302877,  335244,  302387,  338219,
    257376,  295149,  271292,  319779,  279643,  304708,  285147,  314810,
    333632,  338152,  344311,  353433,  382719,  349471,  370152,  343640,
    310198,  314037,  327567,  335655,  347246,  322076,  348357,  326231,
    278588,  313812,  300052,  349515,  294891,  310555,  305109,  325815,
    266749,  297354,  291703,  336779,  280320,  293848,  295599,  314527
};

static const unsigned long ftable2[128]={
    194793,  214093,  222075,  221325,  210734,  211641,  211270,  192855,
    198561,  223821,  229577,  234105,  209600,  214643,  211594,  196292,
    191722,  221201,  215984,  227369,  222035,  236618,  220978,  209746,
    183193,  212405,  205343,  219484,  203652,  219140,  204153,  198495,
    163695,  194973,  186057,  210587,  188197,  215336,  197004,  205097,
    167090,  204380,  192189,  224334,  189091,  221215,  199256,  211624,
    167150,  210594,  190109,  228813,  205750,  260616,  215853,  240851,
    162492,  205131,  184310,  223583,  192669,  241298,  202170,  227169,
    227169,  202170,  241298,  192669,  223583,  184310,  205131,  162492,
    240851,  215853,  260616,  205750,  228813,  190109,  210594,  167150,
    211624,  199256,  221215,  189091,  224334,  192189,  204380,  167090,
    205097,  197004,  215336,  188197,  210587,  186057,  194973,  163695,
    198495,  204153,  219140,  203652,  219484,  205343,  212405,  183193,
    209746,  220978,  236618,  222035,  227369,  215984,  221201,  191722,
    196292,  211594,  214643,  209600,  234105,  229577,  223821,  198561,
    192855,  211270,  211641,  210734,  221325,  222075,  214093,  194793
};

static const short decodeval[63]={
        0,     6,    16,    18,    20,    23,    25,    29,
       32,    36,    41,    46,    51,    57,    65,    73,
       81,    91,   103,   115,   129,   145,   163,   183,
      205,   230,   259,   290,   326,   365,   410,   460,
      516,   579,   650,   730,   819,   919,  1031,  1157,
     1298,  1456,  1634,  1833,  2057,  2308,  2590,  2906,
     3261,  3659,  4105,  4606,  5168,  5799,  6507,  7301,
     8192,  9191, 10313, 11571, 12983, 14567, 16345
};

static const short decodetable1[127]={
    -4041, -4029, -4018, -4008, -3998, -3988, -3977, -3966,
    -3954, -3942, -3930, -3918, -3906, -3892, -3879, -3866,
    -3852, -3839, -3825, -3810, -3795, -3779, -3764, -3748,
    -3731, -3715, -3699, -3683, -3666, -3649, -3631, -3613,
    -3594, -3574, -3555, -3534, -3513, -3491, -3468, -3444,
    -3420, -3396, -3372, -3346, -3321, -3295, -3268, -3240,
    -3212, -3183, -3153, -3122, -3090, -3056, -3021, -2983,
    -2944, -2903, -2863, -2817, -2772, -2724, -2676, -2620,
    -2565, -2505, -2445, -2387, -2328, -2265, -2202, -2137,
    -2072, -2006, -1941, -1874, -1808, -1734, -1660, -1584,
    -1508, -1428, -1348, -1267, -1185, -1090,  -994,  -896,
     -798,  -699,  -600,  -487,  -374,  -242,  -110,    21,
      152,   300,   447,   584,   720,   851,   982,  1105,
     1229,  1342,  1456,  1569,  1682,  1799,  1916,  2023,
     2130,  2242,  2353,  2474,  2595,  2724,  2853,  2986,
     3118,  3240,  3363,  3475,  3588,  3701,  3814
};

static const short decodetable2[63]={
    -3091, -2739, -2386, -2129, -1871, -1648, -1425, -1223,
    -1021,  -835,  -649,  -483,  -316,  -168,   -20,   123,
      267,   406,   544,   677,   810,   937,  1065,  1185,
     1305,  1420,  1534,  1645,  1756,  1863,  1970,  2071,
     2171,  2265,  2359,  2448,  2536,  2618,  2700,  2777,
     2854,  2925,  2996,  3064,  3133,  3198,  3263,  3324,
     3386,  3442,  3499,  3551,  3603,  3652,  3701,  3745,
     3789,  3829,  3870,  3908,  3947,  3983,  4020
};

static const short decodetable3[63]={
    -3525, -3410, -3295, -3188, -3081, -2985, -2890, -2793,
    -2696, -2603, -2511, -2419, -2328, -2238, -2149, -2064,
    -1979, -1898, -1817, -1737, -1658, -1578, -1498, -1420,
    -1341, -1265, -1188, -1110, -1032,  -954,  -876,  -798,
     -721,  -641,  -561,  -478,  -394,  -311,  -228,  -141,
      -54,    32,   119,   208,   296,   390,   484,   584,
      683,   789,   895,  1009,  1123,  1248,  1373,  1512,
     1651,  1808,  1965,  2162,  2360,  2607,  2854
};

static const short decodetable4[31]={
    -1845, -1451, -1057,  -790,  -522,  -300,   -77,   111,
      301,   474,   647,   811,   975,  1130,  1285,  1434,
     1582,  1727,  1873,  2018,  2163,  2308,  2452,  2594,
     2735,  2876,  3017,  3158,  3299,  3434,  3569
};

static const short decodetable5[31]={
    -2691, -2439, -2187, -1987, -1788, -1611, -1435, -1276,
    -1118,  -977,  -837,  -704,  -571,  -444,  -316,  -188,
      -59,    71,   201,   336,   470,   614,   759,   918,
     1077,  1267,  1457,  1682,  1908,  2201,  2495
};

static const short decodetable6[15]={
    -1372,  -923,  -474,  -170,   133,   383,   632,   866,
     1100,  1335,  1571,  1823,  2075,  2374,  2672
};

static const short decodetable7[15]={
    -2389, -2088, -1787, -1509, -1231,  -974,  -717,  -478,
     -239,    -2,   234,   502,   770,  1122,  1474
};

static const short decodetable8[15]={
    -1569, -1217,  -864,  -580,  -296,   -47,   200,   435,
      670,   911,  1151,  1430,  1709,  2047,  2385
};

static const short decodetable9[15]={
    -2200, -1904, -1608, -1335, -1062,  -816,  -569,  -344,
     -120,   108,   338,   600,   863,  1242,  1621
};

static const short decodetable10[7]={
     -617,  -213,   190,   496,   802,  1142,  1483
};

static const short *decodetable[10]={
decodetable1,decodetable2,decodetable3,decodetable4,decodetable5,
decodetable6,decodetable7,decodetable8,decodetable9,decodetable10};

#endif /* FFMPEG_RA144_H */
