/*
 * RealVideo 3/4 decoder
 * Copyright (c) 2007 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file rv34vlc.h
 * RV30/40 VLC tables.
 */

#ifndef FFMPEG_RV34VLC_H
#define FFMPEG_RV34VLC_H

#include <stdint.h>

#define NUM_INTRA_TABLES 5
#define NUM_INTER_TABLES 7

#define CBPPAT_VLC_SIZE   1296
#define CBP_VLC_SIZE        16
#define FIRSTBLK_VLC_SIZE  864
#define OTHERBLK_VLC_SIZE  108
#define COEFF_VLC_SIZE      32

static const uint8_t rv34_table_intra_cbppat[NUM_INTRA_TABLES][2][CBPPAT_VLC_SIZE] = {
  {
    {
       8, 10, 10, 10, 10, 10, 11, 10, 10, 11, 10, 10, 10, 10, 10,  6,
      12, 12, 13, 12, 13, 12, 13, 11, 13, 13, 13, 12, 13, 12, 12,  8,
      14, 13, 16, 13, 15, 13, 16, 12, 16, 16, 16, 14, 16, 13, 14, 10,
      12, 13, 12, 12, 13, 13, 13, 12, 13, 13, 12, 12, 13, 12, 12,  8,
      13, 14, 14, 12, 14, 14, 14, 12, 14, 15, 14, 12, 14, 13, 13,  8,
      16, 16, 16, 12, 16, 16, 16, 13, 16, 16, 16, 13, 16, 14, 14,  9,
      14, 16, 13, 13, 16, 16, 16, 14, 15, 16, 14, 13, 15, 15, 14, 10,
      16, 16, 14, 13, 16, 16, 16, 13, 16, 16, 16, 13, 16, 15, 14, 10,
      16, 16, 16, 11, 16, 16, 16, 12, 16, 16, 16, 12, 16, 16, 15,  9,
      12, 13, 13, 13, 12, 12, 14, 12, 12, 14, 13, 12, 12, 12, 12,  8,
      14, 14, 16, 14, 13, 12, 14, 12, 14, 15, 14, 13, 13, 12, 13,  8,
      16, 16, 16, 15, 16, 13, 16, 13, 16, 16, 16, 15, 16, 13, 15, 10,
      14, 16, 14, 14, 14, 14, 15, 13, 14, 16, 14, 13, 13, 13, 13,  9,
      16, 16, 16, 14, 16, 14, 16, 12, 16, 16, 14, 13, 14, 13, 13,  8,
      16, 16, 16, 14, 16, 14, 16, 13, 16, 16, 16, 14, 16, 14, 14,  9,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 14, 10,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 16, 14, 16, 15, 14,  9,
      16, 16, 16, 13, 16, 16, 16, 12, 16, 16, 16, 13, 16, 15, 15,  8,
      14, 16, 16, 16, 14, 14, 16, 14, 16, 16, 16, 15, 13, 13, 14, 10,
      16, 16, 16, 16, 15, 13, 16, 13, 16, 16, 16, 16, 16, 13, 14, 10,
      16, 16, 16, 16, 16, 11, 16, 12, 16, 16, 16, 16, 16, 12, 16,  9,
      16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 14, 14, 10,
      16, 16, 16, 16, 16, 15, 16, 13, 16, 16, 16, 15, 16, 13, 14,  9,
      16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 16, 16, 13, 14,  8,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 11,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 14,  9,
      16, 16, 16, 14, 16, 15, 16, 11, 16, 16, 16, 14, 16, 14, 14,  8,
      12, 13, 13, 13, 13, 13, 14, 12, 12, 13, 12, 12, 12, 12, 12,  8,
      14, 14, 16, 14, 15, 14, 16, 13, 14, 15, 14, 13, 14, 13, 13,  9,
      16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 16, 14, 16, 14, 16, 10,
      14, 15, 14, 14, 15, 14, 15, 13, 14, 14, 13, 12, 13, 13, 13,  9,
      15, 16, 15, 14, 16, 16, 16, 13, 15, 16, 14, 12, 14, 13, 13,  8,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 16, 13, 16, 14, 14,  9,
      16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 13, 13, 16, 16, 14, 10,
      16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 15, 13, 16, 14, 14,  9,
      16, 16, 16, 12, 16, 16, 16, 13, 16, 16, 16, 12, 16, 16, 15,  8,
      13, 14, 14, 14, 14, 14, 16, 13, 13, 14, 14, 13, 12, 12, 12,  8,
      16, 16, 16, 14, 15, 14, 16, 13, 15, 16, 14, 13, 13, 12, 13,  8,
      16, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 14, 16, 13, 14,  9,
      15, 16, 16, 15, 16, 15, 16, 13, 14, 16, 14, 13, 13, 13, 12,  8,
      16, 16, 16, 14, 16, 14, 15, 12, 15, 15, 14, 12, 13, 12, 12,  7,
      16, 16, 16, 14, 16, 14, 16, 12, 16, 16, 16, 13, 16, 13, 13,  7,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 14, 14, 16, 14, 13,  9,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 14, 12, 16, 13, 12,  7,
      16, 16, 16, 12, 16, 16, 16, 11, 16, 16, 15, 12, 16, 13, 13,  6,
      16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 15, 13, 13, 14, 10,
      16, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 14, 13, 14,  9,
      16, 16, 16, 16, 16, 13, 16, 13, 16, 16, 16, 16, 16, 12, 14,  8,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 14, 13, 13,  9,
      16, 16, 16, 16, 16, 14, 16, 13, 16, 16, 16, 13, 14, 12, 12,  7,
      16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 13, 14, 12, 13,  6,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 14,  9,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 13, 15, 13, 12,  7,
      16, 16, 16, 13, 16, 14, 16, 11, 16, 16, 16, 12, 16, 12, 12,  5,
      14, 16, 15, 16, 16, 16, 16, 15, 14, 15, 14, 14, 13, 14, 13, 10,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 14, 16, 10,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 14, 14, 15, 14, 13, 10,
      16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 14, 13, 16, 14, 14,  9,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 15,  9,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 13, 16, 16, 13, 10,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 13, 16, 16, 13,  9,
      16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 15, 12, 16, 16, 14,  8,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 15, 14, 13, 13, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 14, 13, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 15,  9,
      16, 16, 16, 16, 16, 16, 16, 15, 15, 16, 14, 14, 14, 13, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 14, 12, 13, 12, 12,  7,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 13, 16, 13, 13,  7,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 13, 16, 14, 13,  9,
      16, 16, 16, 15, 16, 16, 16, 13, 16, 16, 13, 12, 14, 13, 12,  6,
      16, 16, 16, 13, 16, 16, 16, 12, 16, 16, 14, 10, 15, 12, 12,  5,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 13, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 15, 13, 12, 13,  8,
      16, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 15, 12, 14,  8,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 13, 13, 13,  8,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 15, 13, 12, 11, 12,  6,
      16, 16, 16, 15, 16, 14, 16, 12, 16, 16, 16, 12, 13, 10, 12,  5,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 13, 14, 12,  8,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 13, 12, 13, 12, 10,  5,
      16, 16, 16, 13, 16, 13, 16, 10, 16, 16, 13, 10, 13, 10, 10,  1,
    },
    {
       2,  7,  7,  8,  7,  8,  9,  8,  7,  9,  8,  8,  8,  8,  9,  7,
       6,  9, 10, 10, 10, 10, 11, 10, 10, 11, 11, 11, 10, 11, 11,  9,
       9, 11, 12, 12, 12, 13, 14, 13, 13, 14, 14, 13, 13, 13, 14, 11,
       6, 10,  9, 10, 10, 11, 11, 11, 10, 11, 10, 11, 11, 11, 11,  9,
       6,  9, 10, 10, 10, 11, 12, 11, 10, 12, 11, 11, 11, 11, 11,  8,
       9, 11, 12, 12, 12, 13, 13, 13, 12, 14, 14, 13, 13, 13, 13, 10,
       9, 13, 11, 13, 13, 14, 14, 13, 13, 14, 13, 13, 14, 14, 14, 12,
       9, 12, 12, 12, 12, 14, 14, 13, 13, 14, 13, 13, 13, 14, 13, 11,
       8, 12, 12, 11, 12, 14, 14, 12, 13, 14, 14, 13, 13, 13, 14, 11,
       6, 10, 10, 11,  9, 10, 12, 11, 10, 12, 11, 11, 10, 11, 11,  9,
       7, 10, 10, 11, 10, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11,  9,
       9, 12, 13, 13, 12, 12, 14, 13, 13, 14, 14, 13, 14, 13, 14, 11,
       8, 11, 11, 12, 11, 12, 12, 12, 11, 13, 12, 12, 12, 12, 12, 10,
       7, 10, 10, 11, 10, 11, 12, 11, 10, 12, 11, 11, 11, 11, 11,  8,
       9, 11, 12, 12, 12, 12, 13, 12, 12, 13, 13, 12, 13, 12, 13, 10,
      10, 13, 13, 14, 14, 14, 15, 14, 14, 15, 14, 15, 14, 14, 14, 12,
       9, 12, 12, 13, 12, 13, 14, 13, 12, 13, 13, 12, 13, 13, 13, 10,
       9, 12, 12, 12, 12, 13, 14, 12, 12, 14, 13, 12, 13, 13, 13, 10,
       9, 12, 13, 13, 11, 13, 14, 13, 13, 14, 14, 14, 12, 13, 13, 11,
      10, 12, 13, 13, 12, 12, 14, 13, 13, 14, 14, 14, 13, 13, 14, 11,
      10, 13, 14, 14, 13, 12, 15, 13, 14, 14, 14, 14, 15, 13, 14, 11,
      11, 14, 14, 14, 13, 14, 15, 14, 14, 15, 15, 14, 13, 14, 14, 12,
      10, 13, 12, 13, 12, 12, 14, 13, 13, 14, 13, 13, 13, 13, 13, 10,
      10, 12, 13, 13, 13, 12, 14, 12, 13, 14, 14, 13, 13, 13, 13, 10,
      13, 15, 16, 16, 15, 15, 16, 16, 15, 16, 15, 16, 16, 16, 16, 14,
      11, 14, 14, 14, 14, 14, 15, 14, 14, 15, 15, 14, 14, 14, 15, 11,
      10, 13, 13, 13, 13, 13, 14, 12, 13, 14, 14, 13, 13, 13, 13, 10,
       6, 10, 10, 11, 10, 11, 12, 11, 10, 12, 10, 11, 10, 11, 11,  9,
       8, 11, 11, 12, 11, 12, 13, 12, 11, 12, 12, 12, 12, 12, 12, 10,
      11, 13, 14, 14, 13, 14, 15, 14, 13, 15, 15, 14, 14, 14, 15, 12,
       7, 11, 10, 12, 11, 12, 12, 12, 11, 12, 11, 12, 11, 12, 12, 10,
       7, 10, 10, 11, 10, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11,  9,
      10, 12, 13, 13, 12, 13, 14, 13, 13, 14, 13, 13, 13, 13, 13, 10,
      10, 13, 12, 14, 13, 14, 14, 14, 13, 14, 12, 14, 15, 14, 14, 11,
      10, 12, 12, 12, 12, 13, 14, 13, 13, 14, 13, 12, 13, 13, 13, 10,
       9, 12, 13, 13, 13, 14, 14, 13, 13, 14, 14, 13, 13, 13, 13, 10,
       7, 10, 10, 11, 10, 11, 12, 11, 10, 12, 12, 11,  9, 11, 11,  9,
       7, 10, 11, 11, 10, 11, 12, 11, 10, 12, 12, 11, 11, 11, 11,  9,
      10, 12, 13, 13, 13, 13, 15, 13, 13, 14, 13, 13, 13, 13, 13, 10,
       8, 11, 11, 11, 11, 11, 12, 11, 11, 12, 12, 11, 11, 12, 11,  9,
       6,  9,  9, 10,  9, 10, 10, 10,  9, 11, 10, 10,  9, 10, 10,  7,
       8, 10, 11, 11, 11, 11, 12, 11, 11, 12, 12, 11, 11, 11, 11,  8,
      10, 13, 13, 13, 13, 14, 14, 13, 13, 14, 13, 13, 13, 13, 13, 11,
       8, 11, 11, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, 11, 11,  8,
       8, 11, 11, 11, 11, 12, 12, 10, 11, 12, 12, 11, 11, 11, 11,  8,
      10, 13, 13, 13, 12, 13, 14, 13, 12, 14, 14, 14, 10, 13, 13, 11,
      10, 12, 12, 13, 12, 13, 14, 12, 12, 13, 13, 13, 12, 12, 13, 10,
      11, 13, 14, 14, 13, 13, 14, 13, 13, 15, 14, 13, 13, 13, 13, 10,
      10, 12, 13, 13, 12, 13, 14, 13, 13, 14, 14, 13, 12, 13, 13, 11,
       8, 11, 11, 11, 11, 11, 12, 11, 11, 12, 12, 11, 11, 11, 11,  8,
       9, 11, 12, 12, 11, 11, 12, 11, 12, 12, 12, 11, 12, 11, 11,  8,
      12, 15, 14, 14, 14, 15, 15, 14, 14, 15, 15, 14, 14, 14, 15, 12,
      10, 12, 12, 12, 12, 12, 13, 12, 12, 13, 13, 12, 12, 12, 12,  9,
       9, 11, 11, 11, 11, 11, 12, 10, 11, 12, 12, 11, 11, 11, 11,  7,
      10, 13, 13, 13, 13, 14, 15, 14, 13, 14, 14, 14, 12, 14, 15, 12,
      11, 14, 14, 14, 14, 15, 15, 14, 14, 15, 15, 15, 14, 15, 15, 12,
      13, 16, 16, 16, 15, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 14,
      10, 13, 13, 14, 13, 15, 14, 14, 13, 15, 13, 14, 14, 14, 14, 12,
      10, 13, 13, 13, 13, 13, 14, 13, 13, 14, 13, 13, 13, 13, 14, 11,
      12, 14, 14, 14, 14, 15, 15, 14, 14, 15, 15, 14, 15, 14, 14, 12,
      11, 14, 14, 15, 14, 15, 15, 14, 14, 15, 12, 14, 15, 16, 15, 12,
      11, 13, 13, 14, 13, 14, 14, 14, 14, 14, 13, 13, 14, 14, 14, 11,
      11, 14, 14, 14, 14, 15, 15, 14, 14, 16, 14, 13, 14, 14, 14, 11,
      10, 13, 13, 13, 12, 14, 14, 14, 12, 15, 14, 14, 11, 13, 13, 12,
      10, 12, 13, 14, 12, 13, 14, 13, 13, 14, 14, 13, 12, 13, 13, 11,
      12, 14, 14, 15, 14, 15, 16, 15, 15, 15, 15, 15, 14, 14, 15, 12,
      10, 13, 13, 13, 12, 13, 14, 13, 13, 14, 13, 13, 12, 13, 13, 11,
       9, 11, 11, 12, 11, 12, 12, 11, 11, 12, 12, 11, 11, 11, 11,  9,
      10, 12, 12, 12, 12, 12, 13, 12, 12, 13, 13, 12, 13, 12, 12,  9,
      11, 13, 13, 15, 14, 14, 15, 14, 14, 15, 14, 14, 14, 14, 14, 11,
      10, 12, 12, 12, 12, 12, 13, 12, 12, 13, 11, 11, 12, 12, 12,  8,
       9, 12, 12, 11, 12, 12, 13, 11, 12, 12, 12, 11, 12, 11, 11,  8,
      10, 13, 13, 14, 12, 14, 15, 14, 13, 15, 15, 14, 10, 13, 13, 11,
      11, 13, 14, 13, 13, 14, 14, 13, 13, 14, 14, 14, 11, 13, 13, 11,
      12, 14, 14, 14, 14, 14, 15, 14, 15, 16, 15, 14, 13, 13, 14, 11,
      11, 14, 13, 14, 13, 14, 15, 14, 13, 15, 14, 14, 11, 13, 13, 11,
       9, 12, 12, 12, 11, 12, 13, 11, 12, 13, 12, 11, 10, 11, 11,  8,
      10, 12, 12, 12, 12, 12, 13, 11, 12, 12, 12, 11, 11, 11, 11,  8,
      12, 15, 14, 15, 14, 15, 16, 15, 15, 15, 15, 14, 14, 14, 14, 12,
      10, 12, 12, 12, 12, 12, 13, 11, 12, 13, 12, 11, 11, 11, 11,  8,
       8, 10, 10, 10, 10, 10, 11,  9, 10, 11, 10,  9, 10,  9,  9,  5,
    },
  },
  {
    {
      12, 12, 11,  9, 11, 10, 11,  9, 11, 11, 10,  9,  9,  8,  9,  5,
      14, 13, 14, 11, 14, 11, 13, 10, 14, 13, 12, 10, 12, 10, 11,  6,
      16, 13, 16, 12, 16, 12, 16, 11, 16, 14, 16, 12, 15, 12, 13,  8,
      14, 14, 12, 11, 14, 12, 13, 10, 13, 13, 11, 10, 12, 11, 10,  6,
      16, 15, 14, 11, 16, 13, 14, 10, 15, 14, 13, 10, 13, 11, 11,  7,
      16, 16, 16, 11, 16, 14, 16, 11, 16, 16, 15, 12, 15, 13, 13,  8,
      16, 16, 13, 12, 16, 16, 15, 12, 16, 16, 12, 11, 15, 13, 12,  8,
      16, 16, 14, 11, 16, 16, 16, 11, 16, 16, 14, 11, 15, 14, 13,  8,
      16, 16, 15, 10, 16, 16, 16, 10, 16, 16, 15, 11, 16, 14, 14,  8,
      14, 14, 14, 12, 13, 11, 13, 10, 13, 13, 12, 11, 11, 10, 10,  6,
      16, 15, 16, 13, 13, 11, 14, 11, 15, 14, 13, 11, 12, 10, 11,  7,
      16, 15, 16, 14, 16, 11, 16, 11, 16, 16, 16, 13, 16, 12, 13,  8,
      16, 16, 14, 13, 15, 13, 14, 11, 14, 15, 13, 11, 13, 11, 11,  7,
      16, 16, 15, 13, 15, 13, 14, 11, 16, 15, 14, 11, 13, 11, 11,  7,
      16, 16, 16, 13, 16, 13, 16, 11, 16, 16, 16, 12, 16, 12, 13,  8,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 14, 13, 15, 14, 13,  9,
      16, 16, 16, 13, 16, 16, 16, 12, 16, 16, 14, 12, 15, 13, 13,  8,
      16, 16, 16, 12, 16, 16, 16, 11, 16, 16, 15, 12, 16, 13, 13,  7,
      16, 16, 16, 16, 13, 12, 16, 12, 16, 16, 14, 13, 12, 11, 12,  8,
      16, 16, 16, 15, 14, 11, 16, 11, 16, 16, 16, 13, 14, 11, 13,  8,
      16, 16, 16, 16, 15, 10, 16, 11, 16, 16, 16, 14, 15, 11, 13,  8,
      16, 16, 16, 16, 16, 14, 16, 13, 16, 16, 14, 14, 14, 12, 13,  9,
      16, 16, 16, 15, 16, 13, 16, 12, 16, 16, 16, 13, 14, 12, 13,  8,
      16, 16, 16, 14, 16, 12, 16, 11, 16, 16, 16, 13, 15, 12, 13,  7,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 15, 16, 14, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 14, 16, 13, 13,  8,
      16, 16, 16, 14, 16, 14, 16, 10, 16, 16, 16, 13, 16, 13, 13,  7,
      14, 14, 13, 12, 13, 12, 13, 11, 12, 13, 11, 10, 11, 10, 10,  6,
      16, 16, 15, 13, 16, 13, 15, 11, 14, 14, 13, 11, 13, 11, 11,  7,
      16, 16, 16, 14, 16, 14, 16, 12, 16, 16, 16, 13, 16, 13, 14,  9,
      16, 16, 13, 13, 15, 14, 14, 11, 13, 14, 11, 11, 12, 11, 11,  7,
      16, 16, 15, 12, 16, 14, 15, 11, 14, 14, 12, 11, 13, 11, 11,  7,
      16, 16, 16, 13, 16, 14, 16, 12, 16, 16, 14, 12, 16, 13, 13,  8,
      16, 16, 14, 14, 16, 16, 16, 13, 16, 16, 12, 11, 15, 13, 12,  8,
      16, 16, 15, 13, 16, 16, 16, 12, 16, 16, 13, 11, 16, 13, 12,  8,
      16, 16, 16, 11, 16, 16, 16, 11, 16, 16, 14, 11, 16, 14, 13,  7,
      16, 16, 15, 13, 14, 13, 14, 11, 14, 14, 12, 11, 11, 10, 11,  7,
      16, 16, 16, 13, 14, 12, 15, 11, 15, 14, 13, 11, 12, 11, 11,  7,
      16, 16, 16, 14, 16, 13, 16, 12, 16, 16, 16, 13, 14, 12, 13,  8,
      16, 16, 15, 13, 15, 14, 14, 12, 14, 14, 12, 11, 12, 11, 11,  7,
      16, 16, 14, 12, 15, 13, 14, 11, 15, 14, 13, 11, 12, 11, 11,  6,
      16, 16, 16, 13, 16, 13, 16, 11, 16, 15, 14, 11, 14, 11, 12,  6,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 13, 12, 14, 13, 12,  8,
      16, 16, 15, 13, 16, 14, 15, 11, 16, 16, 13, 11, 14, 12, 11,  6,
      16, 16, 16, 12, 16, 14, 15, 11, 16, 16, 13, 10, 14, 12, 12,  6,
      16, 16, 16, 16, 16, 14, 16, 13, 16, 16, 14, 13, 12, 11, 12,  8,
      16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 15, 13, 13, 11, 12,  8,
      16, 16, 16, 15, 16, 12, 16, 12, 16, 16, 16, 14, 14, 11, 13,  7,
      16, 16, 16, 16, 16, 15, 16, 13, 16, 16, 14, 13, 13, 12, 12,  8,
      16, 16, 16, 14, 15, 13, 15, 11, 16, 15, 14, 12, 13, 11, 11,  6,
      16, 16, 16, 14, 16, 12, 15, 11, 16, 16, 15, 12, 14, 11, 12,  6,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 15, 13, 14, 13, 12,  8,
      16, 16, 16, 14, 16, 14, 16, 12, 16, 16, 14, 12, 13, 12, 11,  6,
      16, 16, 16, 13, 16, 13, 15, 10, 16, 16, 14, 11, 14, 11, 11,  5,
      16, 16, 15, 14, 16, 16, 16, 13, 14, 14, 12, 12, 12, 12, 12,  8,
      16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 14, 13, 14, 13, 13,  9,
      16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 16, 13, 15,  9,
      16, 16, 14, 15, 16, 16, 16, 14, 14, 16, 12, 12, 13, 13, 12,  8,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 15, 13, 12, 14, 12, 12,  8,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 14, 12, 16, 13, 13,  8,
      16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 11, 11, 15, 14, 12,  8,
      16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 12, 11, 15, 13, 12,  8,
      16, 16, 16, 13, 16, 16, 16, 12, 16, 16, 13, 10, 16, 13, 12,  7,
      16, 16, 16, 16, 16, 15, 16, 13, 14, 16, 13, 13, 12, 12, 12,  8,
      16, 16, 16, 15, 16, 14, 16, 13, 16, 16, 14, 13, 13, 12, 12,  8,
      16, 16, 16, 16, 16, 15, 16, 13, 16, 16, 16, 13, 15, 12, 14,  8,
      16, 16, 16, 15, 16, 16, 16, 13, 14, 16, 13, 12, 12, 12, 11,  8,
      16, 16, 16, 14, 16, 14, 16, 12, 14, 14, 13, 11, 13, 11, 11,  6,
      16, 16, 16, 14, 16, 14, 16, 12, 16, 15, 14, 11, 14, 11, 12,  6,
      16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 12, 12, 14, 13, 11,  8,
      16, 16, 15, 14, 16, 16, 16, 12, 16, 15, 12, 11, 13, 12, 11,  6,
      16, 16, 16, 13, 16, 14, 16, 11, 16, 14, 13, 10, 14, 11, 11,  5,
      16, 16, 16, 16, 16, 16, 16, 14, 14, 16, 15, 13, 11, 11, 11,  8,
      16, 16, 16, 16, 16, 15, 16, 13, 16, 16, 16, 13, 12, 11, 12,  7,
      16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 13, 13, 11, 13,  7,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 14, 13, 12, 12, 11,  7,
      16, 16, 16, 15, 16, 14, 15, 12, 16, 14, 13, 12, 12, 11, 11,  6,
      16, 16, 16, 14, 16, 13, 15, 11, 16, 14, 14, 11, 13, 10, 11,  5,
      16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 13, 12, 12, 12, 11,  7,
      16, 16, 16, 14, 16, 14, 15, 12, 16, 15, 12, 11, 12, 11, 10,  5,
      16, 16, 16, 13, 16, 13, 14, 10, 16, 14, 12,  9, 12, 10,  9,  3,
    },
    {
       2,  6,  6,  7,  6,  7,  8,  7,  7,  8,  7,  8,  7,  8,  8,  5,
       5,  8,  9,  9,  9,  9, 12, 10, 10, 11, 10, 10, 10, 11, 11,  8,
       9, 10, 13, 12, 13, 12, 15, 13, 13, 14, 13, 14, 13, 13, 14, 11,
       5, 10,  9, 10, 10, 10, 12, 10, 10, 12, 10, 11, 11, 11, 11,  8,
       6,  9, 10,  9, 10, 11, 12, 10, 10, 12, 11, 11, 10, 11, 11,  8,
       9, 11, 12, 11, 12, 13, 14, 12, 13, 14, 14, 12, 13, 13, 13, 11,
      10, 13, 11, 12, 14, 14, 15, 13, 13, 15, 12, 13, 14, 14, 14, 12,
       9, 12, 12, 12, 13, 13, 15, 13, 13, 14, 13, 13, 14, 13, 15, 11,
       8, 11, 12, 10, 12, 13, 14, 12, 13, 14, 14, 13, 13, 13, 14, 11,
       5,  9, 10, 10,  9, 10, 12, 11, 10, 12, 11, 11,  9, 11, 11,  9,
       6, 10, 10, 11, 10, 10, 12, 11, 11, 12, 11, 11, 11, 11, 11,  9,
       9, 11, 13, 13, 12, 11, 14, 12, 13, 15, 13, 13, 14, 13, 14, 11,
       8, 11, 11, 12, 11, 12, 13, 12, 12, 13, 12, 13, 12, 12, 12, 10,
       7, 10, 10, 11, 10, 11, 12, 11, 11, 12, 11, 11, 11, 11, 12,  9,
       9, 12, 12, 12, 12, 12, 14, 12, 13, 14, 13, 13, 13, 13, 13, 11,
      11, 14, 13, 15, 15, 16, 16, 15, 15, 16, 15, 15, 16, 16, 15, 13,
      10, 12, 13, 13, 13, 14, 15, 13, 13, 14, 13, 13, 14, 14, 14, 11,
       9, 12, 12, 12, 13, 13, 14, 12, 13, 14, 14, 13, 13, 13, 14, 11,
       9, 13, 13, 13, 11, 12, 15, 13, 13, 15, 14, 14, 11, 13, 14, 11,
      10, 13, 13, 13, 12, 12, 15, 13, 13, 15, 14, 14, 13, 13, 14, 11,
      10, 12, 13, 13, 12, 11, 14, 12, 13, 15, 13, 13, 13, 13, 14, 11,
      11, 14, 15, 15, 13, 14, 16, 14, 14, 16, 16, 14, 14, 15, 15, 13,
      10, 13, 13, 13, 12, 13, 14, 13, 13, 14, 14, 14, 13, 13, 14, 11,
      10, 12, 13, 13, 13, 12, 14, 13, 13, 14, 14, 13, 13, 13, 13, 11,
      13, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      12, 15, 15, 15, 14, 15, 16, 14, 15, 16, 16, 15, 16, 15, 15, 13,
      10, 12, 12, 12, 13, 13, 14, 12, 13, 14, 13, 13, 13, 13, 13, 11,
       6, 10, 10, 11, 10, 11, 12, 11, 10, 12, 11, 11, 10, 11, 11,  9,
       8, 11, 12, 12, 12, 12, 13, 12, 12, 13, 12, 13, 12, 13, 13, 10,
      11, 13, 15, 14, 15, 14, 16, 14, 15, 16, 16, 14, 15, 15, 15, 13,
       7, 11, 10, 12, 11, 11, 13, 11, 11, 13, 10, 11, 12, 12, 12, 10,
       7, 11, 11, 11, 11, 11, 13, 11, 11, 13, 11, 12, 12, 12, 12,  9,
      10, 12, 13, 13, 13, 13, 15, 13, 14, 15, 14, 14, 14, 14, 15, 11,
      10, 13, 12, 14, 14, 14, 15, 13, 13, 15, 12, 13, 15, 15, 14, 12,
      10, 13, 12, 12, 13, 13, 15, 14, 13, 15, 13, 13, 14, 14, 14, 11,
      10, 13, 13, 12, 13, 14, 15, 13, 13, 15, 13, 13, 14, 14, 14, 11,
       7, 10, 11, 11, 10, 11, 12, 11, 10, 12, 12, 12,  9, 11, 12,  9,
       7, 11, 11, 11, 11, 11, 13, 11, 11, 13, 12, 12, 11, 12, 12,  9,
      10, 12, 14, 13, 13, 13, 16, 13, 14, 16, 14, 14, 13, 13, 14, 11,
       8, 11, 11, 12, 11, 12, 13, 12, 12, 13, 12, 12, 12, 12, 12, 10,
       6,  9,  9, 10,  9, 10, 11, 10, 10, 11, 10, 10, 10, 10, 10,  8,
       8, 11, 11, 11, 12, 11, 13, 11, 12, 13, 12, 12, 12, 12, 12, 10,
      11, 14, 13, 14, 14, 14, 16, 14, 14, 16, 14, 14, 15, 15, 14, 12,
       9, 12, 11, 12, 12, 12, 13, 12, 12, 13, 12, 12, 12, 12, 12, 10,
       8, 11, 11, 11, 11, 11, 13, 11, 12, 12, 12, 12, 12, 12, 12,  9,
      10, 13, 14, 13, 11, 13, 14, 14, 13, 15, 15, 14, 10, 13, 14, 11,
      10, 13, 13, 13, 12, 13, 14, 13, 13, 14, 14, 14, 13, 13, 13, 11,
      10, 13, 14, 13, 13, 12, 15, 13, 14, 15, 14, 14, 14, 13, 14, 12,
      11, 14, 14, 14, 13, 13, 15, 14, 14, 15, 14, 15, 13, 14, 14, 12,
       9, 11, 12, 12, 11, 11, 13, 12, 12, 13, 12, 12, 12, 12, 12, 10,
       9, 11, 12, 12, 12, 11, 13, 11, 12, 13, 12, 12, 12, 12, 12, 10,
      13, 15, 15, 16, 15, 16, 16, 15, 16, 16, 16, 15, 15, 15, 16, 14,
      10, 13, 13, 13, 13, 13, 14, 13, 13, 14, 13, 13, 13, 13, 13, 11,
       8, 11, 11, 11, 11, 11, 12, 11, 11, 12, 12, 11, 12, 11, 12,  9,
      11, 14, 14, 15, 14, 15, 15, 14, 13, 15, 14, 15, 12, 14, 15, 13,
      12, 15, 15, 15, 15, 15, 16, 15, 15, 16, 16, 16, 15, 16, 15, 13,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      11, 14, 13, 15, 14, 14, 16, 14, 14, 16, 13, 14, 15, 14, 15, 12,
      11, 14, 13, 14, 14, 14, 16, 15, 14, 16, 14, 14, 15, 15, 15, 12,
      13, 15, 15, 15, 15, 16, 16, 15, 16, 16, 16, 15, 16, 16, 16, 13,
      11, 14, 13, 14, 14, 14, 15, 14, 14, 16, 12, 14, 16, 16, 14, 12,
      11, 14, 14, 14, 14, 15, 16, 15, 14, 16, 13, 14, 16, 15, 14, 12,
      12, 14, 14, 14, 14, 14, 16, 14, 15, 16, 14, 14, 14, 15, 15, 12,
      11, 14, 14, 14, 13, 14, 16, 15, 13, 16, 15, 15, 11, 14, 14, 12,
      11, 14, 14, 15, 14, 14, 16, 14, 14, 15, 14, 14, 13, 15, 15, 12,
      13, 15, 16, 15, 15, 15, 16, 15, 16, 16, 16, 16, 15, 15, 16, 13,
      11, 14, 14, 14, 14, 14, 15, 14, 14, 16, 14, 14, 14, 15, 14, 12,
       9, 12, 12, 12, 12, 12, 13, 12, 12, 13, 12, 13, 12, 12, 12, 10,
      11, 13, 13, 13, 13, 13, 14, 13, 13, 14, 13, 14, 13, 13, 14, 11,
      12, 15, 14, 15, 15, 15, 16, 15, 14, 16, 14, 14, 16, 16, 14, 13,
      10, 12, 12, 12, 12, 12, 14, 12, 13, 13, 12, 12, 13, 13, 13, 10,
      10, 12, 12, 12, 12, 12, 14, 12, 12, 13, 12, 12, 12, 12, 12, 10,
      10, 14, 14, 14, 12, 14, 16, 14, 13, 16, 16, 16, 10, 13, 14, 12,
      11, 14, 14, 14, 13, 14, 16, 14, 14, 16, 15, 14, 12, 13, 14, 12,
      12, 14, 14, 14, 14, 14, 16, 14, 14, 16, 15, 15, 14, 14, 15, 12,
      12, 14, 15, 15, 14, 15, 16, 14, 15, 15, 15, 15, 13, 15, 14, 12,
       9, 12, 12, 12, 12, 13, 13, 12, 12, 13, 13, 12, 11, 12, 12, 10,
      10, 12, 12, 12, 12, 12, 13, 12, 12, 13, 12, 12, 12, 12, 12, 10,
      13, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 15, 16, 15, 13,
      10, 12, 12, 13, 12, 13, 13, 12, 13, 14, 13, 13, 12, 13, 13, 10,
       7, 10, 10, 10, 10, 10, 11, 10, 10, 11, 10, 10, 10, 10, 10,  7,
    },
  },
  {
    {
      10, 10,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  4,
      13, 11, 12,  9, 12,  9, 12,  9, 12, 11, 11,  9, 10,  9,  9,  6,
      15, 12, 15, 11, 14, 10, 14, 10, 14, 13, 13, 11, 13, 11, 12,  7,
      13, 12, 11,  9, 12, 11, 12,  9, 12, 12, 10,  9, 10, 10,  9,  6,
      14, 13, 12, 10, 13, 12, 13,  9, 13, 12, 11, 10, 12, 11, 10,  6,
      16, 14, 14, 10, 15, 13, 14, 10, 15, 15, 14, 11, 14, 12, 12,  8,
      15, 14, 12, 11, 15, 14, 13, 11, 14, 14, 11, 10, 13, 12, 11,  8,
      15, 16, 13, 11, 16, 14, 14, 11, 15, 15, 12, 10, 14, 13, 12,  8,
      16, 15, 14, 10, 16, 14, 14, 10, 16, 15, 14, 10, 14, 13, 12,  7,
      13, 12, 12, 11, 11,  9, 12,  9, 12, 12, 11, 10, 10,  9,  9,  6,
      13, 13, 14, 12, 12, 10, 12, 10, 14, 13, 12, 11, 11, 10, 10,  7,
      16, 14, 16, 13, 14, 11, 15, 10, 16, 15, 14, 12, 14, 11, 12,  8,
      14, 14, 13, 12, 13, 12, 13, 10, 13, 13, 12, 11, 11, 10, 10,  7,
      15, 14, 14, 12, 14, 12, 13, 10, 14, 13, 12, 11, 12, 11, 11,  7,
      16, 15, 16, 13, 15, 13, 15, 10, 16, 15, 14, 12, 14, 12, 12,  7,
      15, 16, 14, 13, 16, 14, 14, 12, 15, 15, 12, 12, 13, 12, 12,  8,
      16, 16, 14, 13, 16, 14, 14, 11, 15, 15, 14, 11, 14, 12, 12,  8,
      16, 16, 15, 12, 16, 14, 15, 10, 16, 16, 13, 12, 14, 13, 12,  7,
      14, 14, 14, 13, 13, 11, 13, 11, 14, 14, 13, 12, 11, 10, 11,  8,
      16, 15, 16, 13, 13, 11, 14, 11, 15, 14, 14, 13, 12, 11, 12,  8,
      15, 15, 16, 14, 14, 10, 14, 10, 16, 15, 15, 13, 14, 10, 12,  8,
      16, 16, 16, 14, 15, 13, 14, 12, 15, 15, 13, 13, 13, 12, 12,  8,
      16, 16, 16, 14, 15, 13, 14, 11, 16, 16, 14, 13, 13, 12, 12,  8,
      16, 16, 16, 14, 16, 12, 15, 11, 16, 15, 15, 13, 14, 12, 12,  8,
      16, 16, 16, 16, 16, 15, 15, 13, 16, 16, 14, 13, 14, 13, 12,  9,
      16, 16, 16, 14, 16, 15, 15, 11, 16, 16, 14, 13, 15, 13, 12,  8,
      16, 16, 16, 14, 16, 14, 14, 10, 16, 16, 15, 13, 14, 12, 12,  7,
      12, 12, 12, 11, 12, 11, 12, 10, 11, 11, 10,  9,  9,  9,  9,  6,
      14, 13, 14, 12, 13, 12, 13, 10, 13, 13, 12, 10, 12, 10, 11,  7,
      16, 14, 16, 13, 15, 13, 16, 12, 15, 14, 14, 12, 14, 12, 13,  8,
      14, 14, 13, 11, 14, 12, 13, 11, 12, 12, 10, 10, 11, 10, 10,  7,
      14, 14, 13, 12, 14, 12, 13, 11, 13, 13, 12, 10, 12, 11, 10,  7,
      16, 15, 15, 12, 16, 14, 15, 11, 16, 14, 13, 11, 14, 12, 12,  8,
      16, 16, 13, 13, 16, 15, 14, 12, 14, 14, 11, 11, 13, 12, 11,  8,
      16, 16, 14, 12, 16, 14, 14, 12, 15, 14, 12, 11, 14, 12, 12,  8,
      16, 15, 14, 11, 16, 15, 15, 11, 16, 15, 13, 11, 14, 13, 12,  8,
      14, 13, 13, 12, 13, 11, 13, 10, 12, 13, 11, 10, 10, 10, 10,  7,
      15, 14, 14, 13, 13, 12, 13, 11, 14, 13, 12, 11, 12, 10, 11,  7,
      16, 15, 16, 14, 15, 12, 15, 11, 16, 14, 14, 12, 14, 11, 12,  8,
      14, 15, 13, 12, 14, 13, 13, 11, 13, 13, 11, 11, 11, 10, 10,  7,
      14, 14, 14, 12, 14, 13, 13, 10, 14, 13, 12, 10, 12, 10, 10,  6,
      16, 15, 15, 13, 16, 13, 15, 11, 15, 14, 13, 11, 13, 11, 11,  7,
      16, 16, 14, 13, 16, 15, 14, 12, 15, 15, 12, 11, 13, 12, 11,  8,
      16, 16, 14, 13, 16, 14, 14, 11, 15, 14, 12, 11, 13, 12, 11,  7,
      16, 16, 15, 12, 16, 14, 14, 11, 15, 15, 13, 11, 14, 12, 11,  6,
      16, 15, 15, 14, 14, 12, 14, 12, 13, 14, 13, 12, 11, 11, 11,  8,
      16, 16, 16, 14, 14, 12, 15, 12, 15, 14, 14, 12, 12, 11, 12,  8,
      16, 16, 16, 15, 14, 12, 15, 12, 16, 15, 14, 13, 13, 11, 12,  8,
      16, 16, 16, 15, 15, 14, 15, 12, 14, 14, 13, 12, 12, 11, 11,  8,
      16, 16, 15, 14, 14, 12, 14, 11, 14, 14, 13, 12, 12, 11, 11,  7,
      16, 16, 16, 14, 15, 12, 14, 11, 15, 15, 14, 12, 13, 11, 12,  7,
      16, 16, 16, 16, 16, 15, 16, 13, 15, 15, 14, 12, 13, 12, 11,  8,
      16, 16, 16, 14, 15, 14, 14, 12, 16, 15, 13, 12, 13, 12, 11,  7,
      16, 16, 16, 13, 16, 13, 14, 10, 16, 15, 14, 11, 13, 11, 11,  6,
      14, 15, 13, 13, 14, 13, 14, 12, 12, 13, 11, 11, 11, 11, 10,  8,
      16, 16, 15, 13, 16, 14, 16, 13, 14, 14, 13, 12, 13, 12, 12,  8,
      16, 16, 16, 14, 16, 14, 16, 13, 16, 14, 15, 13, 15, 13, 13,  9,
      15, 15, 14, 14, 15, 14, 14, 12, 13, 14, 11, 11, 12, 12, 11,  8,
      15, 16, 15, 13, 15, 14, 14, 12, 14, 14, 12, 11, 13, 12, 12,  8,
      16, 16, 16, 13, 16, 15, 15, 13, 16, 15, 14, 11, 15, 12, 13,  8,
      16, 16, 14, 13, 16, 15, 15, 13, 14, 14, 10, 11, 14, 12, 11,  8,
      16, 16, 15, 13, 16, 16, 15, 13, 15, 14, 12, 11, 14, 13, 12,  8,
      16, 16, 15, 13, 16, 15, 16, 12, 16, 14, 13, 10, 15, 13, 12,  7,
      15, 15, 15, 14, 14, 14, 15, 12, 13, 14, 12, 12, 11, 11, 11,  8,
      16, 15, 16, 14, 15, 13, 15, 12, 14, 14, 13, 12, 12, 11, 12,  8,
      16, 16, 16, 15, 16, 14, 16, 13, 16, 15, 14, 12, 14, 11, 13,  8,
      16, 16, 15, 14, 16, 14, 15, 13, 14, 14, 12, 11, 12, 11, 11,  8,
      15, 16, 15, 14, 15, 14, 14, 12, 14, 13, 12, 11, 12, 11, 11,  7,
      16, 16, 16, 14, 16, 13, 16, 12, 15, 14, 13, 11, 13, 11, 12,  7,
      16, 16, 15, 14, 16, 15, 15, 13, 14, 15, 11, 11, 13, 12, 11,  8,
      16, 16, 15, 13, 16, 14, 15, 12, 15, 14, 12, 11, 13, 11, 11,  7,
      16, 16, 15, 13, 16, 14, 16, 12, 15, 14, 13, 10, 13, 11, 11,  6,
      16, 16, 16, 14, 14, 14, 15, 13, 14, 14, 14, 12, 11, 11, 11,  8,
      16, 16, 16, 14, 15, 14, 16, 13, 15, 14, 14, 13, 12, 11, 11,  7,
      16, 16, 16, 16, 15, 13, 16, 12, 15, 15, 14, 12, 13, 10, 12,  7,
      16, 16, 16, 14, 15, 15, 14, 13, 14, 14, 13, 12, 12, 11, 11,  8,
      16, 15, 16, 14, 16, 13, 15, 12, 14, 14, 13, 12, 12, 10, 10,  6,
      16, 15, 16, 14, 16, 13, 16, 11, 16, 14, 13, 11, 13, 10, 11,  6,
      16, 16, 16, 15, 16, 16, 15, 13, 14, 16, 12, 12, 12, 12, 10,  7,
      16, 16, 16, 14, 16, 14, 14, 12, 15, 15, 12, 11, 12, 11, 10,  6,
      16, 16, 16, 13, 16, 13, 15, 10, 15, 14, 13, 10, 13, 10, 10,  4,
    },
    {
       1,  6,  6,  7,  6,  7,  9,  8,  7,  9,  7,  8,  7,  8,  8,  6,
       6,  9, 10, 10, 10, 10, 12, 11, 10, 12, 11, 11, 11, 11, 12,  9,
       9, 10, 13, 11, 13, 12, 14, 13, 14, 14, 14, 14, 14, 14, 14, 12,
       6, 10,  9, 10, 10, 11, 13, 11, 11, 13, 10, 12, 11, 12, 12,  9,
       6, 10, 10, 10, 10, 11, 13, 11, 11, 13, 12, 12, 11, 12, 12,  9,
       9, 11, 13, 12, 13, 14, 15, 13, 14, 16, 14, 14, 14, 14, 15, 12,
      10, 13, 11, 13, 14, 14, 16, 14, 14, 15, 13, 14, 15, 15, 16, 12,
       9, 13, 12, 12, 14, 14, 16, 14, 14, 15, 14, 14, 15, 15, 15, 12,
       8, 11, 12, 11, 13, 14, 15, 13, 13, 15, 14, 14, 13, 15, 15, 11,
       6, 10, 10, 11,  9, 10, 13, 11, 10, 13, 11, 12, 10, 12, 12,  9,
       6, 10, 10, 11, 11, 10, 13, 11, 11, 13, 11, 12, 12, 12, 13, 10,
       9, 12, 13, 13, 13, 12, 16, 13, 14, 15, 14, 14, 15, 14, 15, 12,
       8, 12, 12, 13, 12, 13, 15, 14, 13, 15, 13, 14, 13, 13, 14, 11,
       7, 11, 11, 12, 11, 12, 13, 12, 12, 13, 12, 13, 12, 13, 13, 10,
       9, 12, 13, 13, 13, 13, 16, 13, 13, 15, 14, 14, 14, 15, 15, 12,
      11, 15, 14, 15, 15, 16, 16, 16, 15, 16, 15, 16, 16, 16, 16, 14,
      10, 13, 13, 14, 14, 14, 16, 15, 14, 16, 15, 15, 15, 15, 16, 13,
       9, 12, 13, 13, 13, 14, 16, 14, 13, 15, 14, 14, 14, 16, 15, 12,
      10, 13, 14, 14, 11, 13, 16, 14, 14, 16, 15, 15, 12, 14, 15, 12,
      10, 13, 14, 14, 12, 12, 16, 15, 14, 16, 15, 15, 14, 14, 16, 12,
       9, 12, 13, 14, 13, 11, 16, 13, 14, 15, 13, 14, 14, 14, 15, 12,
      11, 15, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 13, 14, 14, 13, 14, 16, 15, 14, 16, 16, 16, 14, 15, 16, 13,
      10, 13, 13, 14, 13, 13, 16, 13, 13, 14, 14, 15, 15, 14, 15, 13,
      13, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      12, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 12, 13, 14, 13, 13, 14, 13, 13, 14, 13, 14, 14, 14, 15, 12,
       6, 10, 11, 11, 10, 11, 13, 12, 11, 13, 11, 12, 11, 12, 12, 10,
       8, 12, 13, 13, 12, 13, 14, 14, 13, 15, 14, 14, 14, 14, 15, 12,
      12, 14, 16, 15, 15, 15, 16, 15, 16, 16, 16, 16, 16, 16, 16, 14,
       7, 11, 11, 12, 12, 12, 14, 13, 12, 14, 11, 12, 13, 13, 13, 11,
       8, 11, 12, 12, 12, 12, 14, 13, 12, 14, 12, 13, 13, 14, 14, 11,
      11, 13, 14, 14, 14, 14, 16, 15, 15, 16, 15, 15, 16, 16, 16, 13,
      10, 14, 12, 14, 14, 15, 16, 15, 13, 16, 12, 14, 16, 16, 15, 13,
      10, 13, 13, 14, 14, 15, 16, 15, 14, 16, 14, 15, 15, 16, 16, 12,
      10, 13, 14, 13, 14, 14, 16, 15, 14, 16, 15, 15, 14, 16, 16, 13,
       7, 11, 11, 11, 10, 12, 14, 13, 11, 14, 13, 13, 10, 12, 13, 10,
       8, 11, 12, 12, 11, 12, 14, 13, 12, 15, 13, 13, 12, 13, 14, 11,
      11, 13, 14, 14, 14, 14, 16, 15, 14, 16, 15, 16, 16, 16, 16, 14,
       8, 12, 12, 13, 12, 13, 15, 14, 12, 15, 13, 13, 13, 14, 14, 11,
       6, 10, 10, 11, 10, 11, 13, 12, 11, 13, 11, 12, 11, 12, 12,  9,
       9, 12, 13, 13, 13, 13, 14, 13, 13, 15, 14, 14, 14, 14, 14, 12,
      11, 15, 14, 15, 14, 15, 16, 16, 16, 16, 15, 16, 16, 16, 16, 14,
       9, 13, 12, 13, 13, 13, 15, 14, 13, 14, 13, 14, 14, 15, 14, 12,
       9, 12, 12, 12, 12, 13, 14, 13, 13, 14, 13, 13, 13, 13, 14, 11,
      10, 13, 15, 14, 12, 14, 16, 14, 14, 16, 15, 15, 12, 14, 16, 12,
      10, 14, 14, 14, 13, 14, 16, 15, 14, 16, 16, 16, 13, 14, 16, 13,
      11, 13, 14, 14, 14, 13, 16, 14, 14, 16, 15, 15, 15, 15, 16, 13,
      11, 15, 15, 15, 14, 15, 16, 16, 15, 16, 16, 16, 14, 16, 16, 13,
       9, 13, 13, 13, 12, 13, 15, 14, 13, 15, 14, 14, 13, 14, 15, 11,
       9, 12, 12, 13, 12, 12, 14, 13, 13, 14, 13, 14, 14, 14, 14, 11,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      11, 14, 14, 15, 15, 14, 16, 16, 14, 16, 14, 15, 15, 16, 16, 12,
       9, 12, 12, 13, 12, 12, 14, 12, 12, 14, 13, 13, 13, 13, 14, 11,
      11, 14, 14, 16, 14, 16, 16, 16, 13, 16, 14, 16, 14, 16, 16, 13,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 15, 14, 16, 14, 15, 16, 16, 15, 16, 14, 15, 16, 16, 16, 13,
      11, 15, 14, 16, 15, 16, 16, 16, 15, 16, 15, 16, 16, 16, 16, 14,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      11, 14, 13, 14, 15, 14, 16, 15, 14, 16, 12, 14, 16, 16, 15, 13,
      11, 14, 14, 16, 14, 15, 16, 16, 15, 16, 14, 15, 16, 16, 16, 14,
      12, 14, 14, 15, 14, 16, 16, 15, 14, 16, 15, 15, 15, 16, 16, 13,
      11, 14, 15, 15, 13, 15, 16, 16, 14, 16, 16, 16, 12, 15, 15, 13,
      11, 15, 16, 16, 15, 16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 14,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      11, 15, 14, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
      10, 13, 13, 14, 14, 14, 16, 15, 14, 16, 14, 15, 14, 14, 15, 12,
      12, 15, 14, 16, 14, 15, 16, 15, 15, 16, 15, 15, 16, 15, 16, 13,
      12, 16, 14, 16, 15, 16, 16, 16, 16, 16, 14, 15, 16, 16, 16, 14,
      10, 13, 13, 14, 14, 13, 16, 14, 13, 16, 13, 14, 15, 15, 15, 12,
      10, 13, 13, 14, 13, 13, 16, 14, 14, 15, 14, 14, 14, 14, 15, 12,
      10, 14, 15, 14, 13, 15, 16, 15, 14, 16, 16, 16, 11, 14, 16, 12,
      11, 14, 14, 16, 14, 15, 16, 15, 15, 16, 16, 16, 13, 15, 16, 13,
      12, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 15, 16, 13,
      12, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 13,
      10, 13, 14, 14, 13, 14, 16, 14, 13, 16, 15, 14, 12, 14, 16, 11,
      10, 13, 13, 14, 13, 14, 16, 14, 14, 15, 14, 14, 13, 14, 14, 11,
      13, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      11, 13, 14, 15, 14, 14, 16, 15, 14, 16, 14, 15, 14, 15, 16, 12,
       8, 11, 11, 11, 11, 12, 13, 12, 11, 13, 11, 12, 11, 12, 12,  9,
    },
  },
  {
    {
       8,  8,  8,  7,  8,  7,  8,  6,  8,  8,  7,  6,  7,  6,  6,  4,
      11, 10, 11,  9, 11,  9, 11,  8, 11, 10, 10,  9, 10,  8,  9,  6,
      13, 11, 13, 10, 12, 10, 13,  9, 13, 12, 13, 10, 12, 10, 11,  7,
      11, 11, 10,  9, 11, 10, 11,  9, 10, 11,  9,  8, 10,  9,  9,  6,
      12, 12, 11,  9, 12, 11, 12,  9, 12, 12, 11,  9, 11, 10, 10,  7,
      14, 13, 13, 10, 15, 12, 13, 10, 15, 13, 13, 10, 13, 12, 12,  8,
      13, 13, 11, 10, 14, 13, 12, 10, 13, 13, 10, 10, 12, 11, 10,  8,
      15, 14, 13, 10, 14, 13, 13, 10, 14, 13, 12, 10, 13, 12, 11,  8,
      14, 14, 13, 10, 16, 13, 13, 10, 15, 14, 13, 10, 13, 12, 12,  8,
      11, 11, 11, 10, 10,  9, 10,  9, 10, 10, 10,  9,  9,  8,  9,  6,
      12, 12, 12, 11, 11,  9, 12,  9, 12, 12, 11, 10, 11,  9, 10,  7,
      14, 13, 14, 12, 13, 10, 13, 10, 15, 13, 14, 12, 12, 10, 12,  8,
      13, 13, 12, 11, 12, 11, 12, 10, 12, 12, 11, 10, 11, 10, 10,  7,
      14, 13, 13, 11, 13, 12, 12, 10, 13, 13, 12, 11, 12, 10, 10,  7,
      16, 15, 15, 12, 14, 12, 13, 10, 15, 14, 13, 12, 13, 12, 12,  8,
      15, 15, 13, 13, 14, 14, 14, 12, 14, 14, 12, 11, 13, 12, 11,  8,
      15, 16, 14, 12, 15, 14, 13, 11, 15, 15, 13, 12, 13, 12, 11,  8,
      16, 15, 15, 12, 16, 14, 14, 10, 15, 15, 14, 12, 14, 12, 12,  8,
      13, 13, 13, 13, 11, 10, 12, 10, 12, 13, 12, 11, 10, 10, 10,  8,
      14, 13, 14, 13, 12, 10, 13, 10, 14, 14, 13, 12, 12, 10, 11,  8,
      15, 14, 16, 14, 13, 10, 14, 10, 16, 14, 14, 13, 13, 10, 12,  8,
      15, 15, 14, 14, 14, 13, 13, 12, 14, 14, 13, 12, 12, 11, 11,  9,
      15, 15, 15, 14, 14, 12, 14, 11, 15, 14, 13, 13, 13, 11, 11,  8,
      16, 15, 16, 14, 15, 12, 14, 11, 16, 16, 15, 13, 14, 12, 12,  8,
      16, 16, 16, 14, 15, 14, 14, 12, 15, 15, 14, 13, 13, 12, 11,  9,
      16, 16, 15, 15, 16, 14, 14, 11, 16, 16, 14, 13, 14, 12, 12,  8,
      16, 16, 16, 13, 15, 13, 14, 10, 16, 16, 15, 13, 14, 12, 12,  8,
      11, 11, 11, 10, 11, 10, 11,  9, 10, 10,  9,  8,  9,  9,  9,  6,
      12, 12, 13, 11, 12, 11, 12, 10, 12, 12, 11, 10, 11, 10, 10,  7,
      15, 13, 15, 12, 14, 13, 14, 11, 14, 13, 13, 11, 13, 11, 12,  8,
      12, 13, 12, 11, 13, 11, 12, 10, 11, 12, 10,  9, 11, 10, 10,  7,
      14, 13, 13, 11, 14, 12, 13, 11, 12, 12, 11, 10, 12, 11, 10,  7,
      15, 14, 15, 12, 15, 13, 15, 11, 15, 14, 13, 11, 13, 12, 12,  8,
      14, 14, 13, 12, 15, 14, 13, 12, 13, 13, 11, 10, 13, 12, 11,  8,
      16, 15, 13, 12, 15, 14, 14, 12, 14, 14, 12, 11, 14, 12, 11,  8,
      16, 15, 14, 12, 16, 15, 15, 11, 15, 14, 13, 11, 14, 13, 12,  8,
      12, 12, 12, 11, 12, 11, 12, 10, 11, 11, 11, 10, 10,  9,  9,  7,
      13, 13, 14, 12, 13, 11, 13, 11, 13, 12, 12, 11, 11, 10, 10,  7,
      15, 14, 16, 13, 14, 12, 14, 11, 14, 14, 14, 12, 13, 11, 12,  8,
      13, 13, 13, 12, 13, 12, 13, 11, 12, 12, 11, 10, 11, 10, 10,  7,
      14, 14, 13, 12, 13, 12, 13, 10, 13, 13, 11, 10, 12, 10, 10,  7,
      16, 15, 15, 13, 15, 12, 14, 11, 15, 14, 13, 11, 13, 11, 11,  7,
      15, 16, 14, 13, 15, 14, 14, 12, 14, 14, 12, 11, 13, 12, 11,  8,
      16, 15, 14, 13, 15, 14, 14, 11, 14, 14, 12, 11, 13, 12, 11,  7,
      16, 15, 15, 12, 16, 14, 14, 11, 15, 14, 13, 11, 14, 12, 11,  7,
      14, 15, 14, 14, 13, 12, 13, 12, 13, 13, 12, 12, 11, 10, 11,  8,
      15, 15, 15, 14, 13, 12, 14, 12, 14, 14, 13, 12, 12, 11, 11,  8,
      16, 15, 16, 14, 14, 12, 15, 12, 16, 14, 14, 13, 13, 11, 12,  8,
      15, 15, 15, 14, 14, 13, 14, 12, 14, 14, 13, 12, 12, 11, 11,  8,
      15, 15, 15, 14, 14, 13, 14, 12, 14, 14, 13, 12, 12, 11, 11,  7,
      16, 15, 16, 14, 15, 12, 15, 11, 15, 14, 14, 12, 13, 11, 12,  7,
      16, 16, 16, 15, 16, 15, 14, 13, 15, 15, 13, 12, 13, 12, 11,  9,
      16, 16, 16, 14, 15, 14, 14, 12, 15, 15, 13, 12, 14, 12, 11,  8,
      16, 16, 16, 14, 16, 14, 14, 11, 15, 15, 14, 12, 14, 12, 11,  7,
      13, 13, 13, 12, 13, 12, 13, 11, 11, 12, 11, 10, 10, 10, 10,  8,
      15, 14, 14, 13, 14, 13, 14, 12, 13, 13, 12, 11, 13, 11, 11,  8,
      16, 15, 16, 14, 16, 14, 16, 13, 15, 14, 14, 12, 14, 12, 13,  9,
      14, 15, 13, 13, 14, 13, 14, 12, 12, 13, 11, 11, 12, 11, 11,  8,
      15, 15, 14, 13, 15, 14, 14, 12, 13, 13, 12, 11, 13, 12, 11,  8,
      16, 16, 16, 13, 16, 15, 16, 13, 15, 14, 14, 12, 14, 13, 13,  9,
      14, 15, 13, 13, 16, 15, 15, 13, 13, 14, 11, 11, 13, 12, 11,  9,
      16, 16, 14, 13, 16, 15, 16, 13, 14, 14, 12, 11, 14, 13, 12,  8,
      16, 16, 15, 12, 16, 15, 15, 12, 15, 14, 13, 11, 14, 13, 12,  8,
      14, 14, 14, 13, 14, 13, 14, 12, 12, 13, 12, 11, 11, 11, 11,  8,
      15, 15, 15, 14, 14, 13, 15, 12, 14, 13, 13, 12, 12, 11, 11,  8,
      16, 16, 16, 15, 15, 14, 16, 13, 15, 14, 14, 12, 14, 12, 12,  9,
      15, 15, 14, 14, 14, 14, 14, 13, 13, 14, 12, 11, 12, 11, 11,  8,
      15, 15, 15, 13, 15, 14, 14, 12, 13, 13, 12, 11, 12, 11, 11,  7,
      16, 15, 16, 14, 16, 14, 15, 12, 15, 14, 14, 12, 13, 12, 12,  8,
      16, 16, 15, 14, 16, 15, 15, 13, 14, 14, 12, 11, 13, 12, 11,  8,
      16, 16, 15, 13, 16, 14, 14, 12, 14, 15, 12, 11, 13, 12, 11,  7,
      16, 16, 16, 13, 16, 15, 15, 12, 15, 14, 13, 11, 14, 12, 11,  7,
      15, 15, 15, 14, 13, 13, 14, 13, 13, 14, 13, 12, 11, 11, 11,  8,
      16, 16, 16, 14, 15, 13, 15, 12, 14, 14, 14, 13, 12, 11, 12,  8,
      16, 16, 16, 14, 15, 13, 15, 12, 15, 14, 14, 12, 13, 11, 12,  8,
      15, 16, 16, 14, 15, 14, 15, 13, 14, 14, 12, 12, 11, 11, 11,  8,
      16, 15, 15, 14, 15, 14, 14, 12, 14, 14, 13, 12, 12, 11, 11,  7,
      16, 16, 16, 13, 15, 13, 15, 12, 15, 14, 14, 12, 13, 11, 11,  7,
      16, 16, 16, 15, 15, 16, 15, 13, 14, 14, 12, 12, 12, 12, 11,  8,
      16, 16, 16, 14, 16, 14, 14, 12, 15, 15, 13, 11, 12, 11, 10,  7,
      16, 16, 15, 13, 16, 14, 14, 11, 15, 14, 13, 10, 13, 11, 10,  5,
    },
    {
       1,  6,  6,  7,  6,  7,  9,  7,  6,  9,  7,  8,  7,  8,  8,  5,
       5,  8, 10, 10, 10, 10, 12, 11, 11, 12, 11, 11, 11, 12, 12,  9,
       9, 10, 12, 11, 13, 12, 15, 13, 14, 15, 15, 14, 14, 15, 15, 12,
       6, 10,  9, 10, 10, 11, 13, 12, 11, 13, 11, 12, 12, 12, 12, 10,
       6, 10, 10, 10, 11, 11, 13, 11, 11, 13, 12, 12, 11, 12, 12, 10,
       9, 12, 13, 12, 13, 13, 16, 13, 14, 16, 15, 14, 14, 15, 16, 12,
       9, 13, 11, 13, 14, 14, 16, 15, 14, 16, 13, 15, 15, 15, 15, 12,
       9, 13, 12, 13, 14, 15, 16, 15, 14, 16, 15, 15, 15, 15, 16, 12,
       8, 12, 12, 11, 13, 14, 15, 13, 13, 15, 14, 14, 14, 14, 14, 12,
       6, 10, 10, 11,  9, 10, 13, 11, 11, 13, 12, 12, 10, 12, 12,  9,
       6, 10, 11, 11, 11, 10, 13, 12, 11, 13, 12, 12, 12, 12, 13, 10,
       9, 12, 13, 13, 13, 12, 16, 13, 14, 16, 14, 15, 16, 14, 15, 12,
       8, 12, 13, 13, 13, 13, 16, 14, 13, 16, 13, 14, 14, 14, 14, 12,
       7, 11, 11, 12, 11, 12, 14, 13, 12, 14, 13, 13, 12, 13, 13, 11,
       9, 12, 13, 13, 13, 13, 15, 14, 14, 16, 16, 15, 15, 15, 16, 12,
      11, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 14, 14, 15, 15, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 13,
       9, 13, 13, 13, 14, 14, 16, 14, 14, 16, 15, 14, 14, 16, 16, 13,
       9, 13, 14, 14, 11, 13, 16, 14, 13, 16, 15, 16, 13, 14, 15, 12,
      10, 13, 14, 15, 13, 12, 16, 14, 14, 16, 15, 15, 14, 14, 16, 13,
       9, 12, 13, 14, 12, 11, 15, 13, 13, 15, 13, 14, 15, 14, 16, 12,
      11, 15, 16, 16, 14, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 13,
      11, 14, 14, 15, 13, 14, 16, 15, 15, 16, 16, 16, 16, 16, 16, 13,
      10, 12, 13, 14, 13, 13, 16, 14, 14, 14, 14, 16, 15, 14, 16, 13,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       9, 12, 13, 14, 13, 13, 16, 13, 13, 15, 15, 16, 15, 15, 16, 12,
       6, 11, 11, 12, 10, 12, 13, 12, 11, 13, 11, 12, 11, 12, 13, 10,
       9, 12, 13, 13, 13, 13, 16, 14, 14, 15, 14, 14, 14, 14, 14, 12,
      12, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       7, 11, 11, 12, 12, 12, 14, 13, 12, 14, 11, 13, 13, 13, 13, 11,
       8, 12, 12, 13, 12, 13, 14, 13, 13, 14, 13, 13, 13, 14, 14, 11,
      11, 14, 14, 15, 16, 15, 16, 16, 15, 16, 16, 16, 16, 16, 16, 13,
      10, 14, 12, 14, 15, 15, 16, 16, 14, 16, 12, 15, 16, 16, 16, 13,
      11, 14, 13, 15, 15, 15, 16, 16, 14, 16, 14, 14, 16, 16, 16, 13,
      11, 14, 14, 14, 15, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 13,
       7, 11, 12, 11, 10, 12, 14, 13, 12, 14, 13, 13, 10, 12, 13, 10,
       8, 12, 12, 13, 12, 12, 15, 13, 13, 14, 13, 13, 13, 13, 14, 11,
      11, 13, 15, 16, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
       9, 12, 13, 13, 13, 13, 15, 14, 13, 15, 13, 14, 13, 14, 14, 12,
       7, 11, 11, 11, 11, 11, 13, 12, 11, 13, 11, 12, 11, 12, 12, 10,
       9, 12, 13, 13, 13, 13, 16, 13, 14, 16, 15, 14, 14, 14, 16, 12,
      12, 14, 14, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 14,
      10, 13, 13, 14, 14, 14, 16, 15, 14, 16, 14, 14, 16, 15, 15, 12,
       9, 12, 13, 13, 13, 15, 16, 14, 13, 16, 14, 13, 13, 14, 14, 11,
      10, 14, 15, 14, 12, 14, 16, 15, 13, 16, 16, 16, 12, 14, 16, 12,
      11, 14, 14, 14, 14, 14, 16, 15, 15, 16, 16, 16, 14, 15, 16, 13,
      11, 14, 14, 16, 14, 13, 16, 15, 14, 16, 15, 16, 15, 15, 16, 13,
      12, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 14,
      10, 13, 14, 14, 13, 14, 16, 14, 13, 16, 15, 15, 13, 14, 14, 12,
       9, 12, 13, 14, 13, 12, 16, 14, 13, 16, 14, 14, 14, 14, 15, 12,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
       9, 12, 13, 13, 13, 13, 14, 13, 12, 15, 14, 14, 14, 14, 14, 11,
      11, 14, 14, 16, 14, 16, 16, 16, 13, 16, 14, 16, 14, 16, 16, 13,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 14, 14, 16, 16, 15, 16, 16, 15, 16, 14, 16, 16, 16, 16, 14,
      12, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 14, 12, 15, 15, 15, 16, 16, 14, 16, 12, 14, 16, 16, 15, 14,
      12, 15, 14, 16, 16, 16, 16, 16, 15, 16, 14, 16, 16, 16, 16, 14,
      12, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14,
      11, 15, 15, 16, 14, 16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 13,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      11, 15, 14, 16, 14, 14, 16, 15, 14, 16, 15, 16, 15, 16, 16, 12,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
      12, 16, 15, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 14,
      10, 14, 13, 14, 15, 14, 16, 15, 14, 16, 13, 16, 16, 16, 15, 13,
      10, 14, 14, 14, 13, 14, 16, 15, 15, 16, 14, 14, 14, 16, 16, 12,
      10, 14, 15, 14, 13, 16, 16, 15, 13, 16, 16, 16, 12, 14, 16, 12,
      11, 16, 16, 16, 14, 15, 16, 16, 16, 16, 16, 16, 14, 16, 16, 13,
      12, 15, 14, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 14,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 14,
      11, 14, 14, 14, 14, 15, 16, 14, 14, 16, 16, 16, 13, 15, 15, 12,
      10, 14, 13, 14, 14, 14, 16, 15, 14, 16, 15, 15, 14, 14, 16, 12,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      12, 14, 14, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 13,
       8, 11, 11, 12, 12, 12, 13, 12, 11, 13, 12, 12, 12, 13, 12, 10,
    },
  },
  {
    {
       5,  6,  6,  6,  6,  6,  7,  6,  6,  7,  6,  6,  6,  6,  6,  4,
       9,  9,  9,  8,  9,  8, 10,  8, 10, 10,  9,  9,  9,  8,  9,  6,
      11, 10, 12, 10, 11, 10, 12,  9, 12, 11, 11, 10, 11, 10, 11,  8,
       9, 10,  9,  8, 10, 10, 10,  9,  9, 10,  8,  8,  9,  9,  8,  7,
      10, 11, 10,  9, 11, 11, 11,  9, 11, 11, 10,  9, 10, 10, 10,  7,
      13, 12, 12, 10, 13, 12, 13, 10, 13, 12, 12, 11, 13, 12, 11,  9,
      11, 12, 10, 10, 12, 12, 11, 10, 11, 12, 10, 10, 11, 11, 10,  8,
      12, 12, 11, 10, 13, 13, 13, 10, 13, 13, 12, 11, 13, 12, 11,  9,
      12, 12, 12, 10, 13, 13, 13, 10, 13, 13, 12, 10, 13, 12, 12,  9,
       9,  9, 10, 10,  9,  8, 10,  9,  9, 10,  9,  9,  8,  8,  9,  6,
      10, 11, 11, 11, 10,  9, 11,  9, 11, 11, 11, 10, 10,  9, 10,  7,
      12, 12, 13, 12, 12, 10, 13, 10, 13, 13, 13, 12, 12, 11, 11,  9,
      11, 12, 11, 11, 11, 11, 11, 10, 11, 12, 10, 10, 10, 10, 10,  8,
      12, 12, 12, 11, 12, 11, 11, 10, 12, 12, 11, 11, 11, 11, 10,  8,
      14, 13, 13, 12, 13, 12, 13, 10, 14, 14, 13, 12, 13, 12, 12,  9,
      13, 14, 13, 12, 13, 13, 13, 12, 13, 13, 12, 12, 12, 12, 11,  9,
      14, 14, 13, 12, 13, 13, 13, 11, 14, 14, 13, 12, 13, 12, 12,  9,
      14, 15, 14, 12, 15, 13, 13, 11, 15, 14, 14, 12, 14, 13, 12,  9,
      11, 11, 12, 12, 10, 10, 12, 11, 11, 12, 11, 11, 10, 10, 10,  8,
      12, 12, 14, 13, 11, 10, 12, 11, 13, 13, 13, 12, 12, 10, 11,  9,
      13, 13, 14, 14, 12, 10, 13, 11, 14, 14, 14, 13, 12, 11, 12,  9,
      13, 13, 13, 13, 12, 13, 13, 12, 13, 14, 12, 12, 12, 12, 11,  9,
      13, 14, 14, 13, 13, 12, 13, 11, 14, 14, 13, 12, 13, 12, 12,  9,
      14, 14, 14, 14, 14, 12, 13, 11, 15, 15, 15, 13, 14, 12, 12,  9,
      14, 15, 15, 13, 14, 14, 13, 12, 13, 14, 13, 13, 12, 12, 11, 10,
      16, 16, 15, 14, 15, 14, 13, 11, 15, 15, 14, 13, 13, 13, 12,  9,
      15, 15, 15, 13, 14, 13, 13, 11, 15, 15, 15, 13, 14, 13, 12,  9,
       8,  9,  9,  9,  9,  9, 10,  9,  8, 10,  9,  9,  8,  8,  9,  7,
      11, 11, 11, 11, 11, 11, 12, 10, 11, 11, 11, 10, 10, 10, 10,  8,
      13, 13, 14, 12, 13, 12, 14, 11, 13, 13, 13, 12, 13, 11, 12,  9,
      10, 11, 10, 11, 11, 11, 12, 10, 10, 11, 10, 10, 10, 10, 10,  8,
      12, 12, 12, 11, 12, 12, 12, 11, 11, 12, 11, 10, 11, 11, 10,  8,
      14, 13, 14, 12, 14, 13, 14, 12, 14, 13, 13, 11, 13, 12, 12,  9,
      12, 13, 12, 12, 13, 13, 13, 12, 12, 13, 11, 11, 12, 12, 11,  9,
      13, 14, 13, 12, 14, 14, 14, 12, 14, 13, 12, 11, 13, 12, 12,  9,
      14, 14, 13, 12, 15, 14, 15, 12, 14, 14, 13, 11, 13, 13, 12,  9,
      10, 11, 11, 11, 10, 10, 12, 10, 10, 11, 10, 10,  9,  9, 10,  7,
      12, 12, 13, 12, 12, 11, 12, 11, 12, 12, 12, 11, 11, 10, 10,  8,
      14, 13, 14, 13, 14, 12, 13, 12, 14, 13, 14, 12, 13, 11, 12,  9,
      12, 13, 12, 12, 12, 12, 12, 11, 11, 12, 11, 10, 10, 10, 10,  8,
      12, 12, 12, 12, 12, 12, 12, 11, 12, 12, 11, 10, 11, 10, 10,  7,
      14, 14, 14, 12, 14, 12, 14, 11, 14, 13, 13, 11, 13, 11, 11,  8,
      13, 15, 13, 13, 14, 14, 14, 12, 13, 14, 12, 12, 12, 12, 11,  9,
      14, 15, 13, 12, 14, 13, 13, 11, 13, 13, 12, 11, 13, 12, 11,  8,
      15, 15, 15, 12, 15, 14, 14, 11, 14, 14, 13, 11, 13, 12, 12,  8,
      12, 13, 13, 13, 12, 12, 13, 12, 12, 13, 12, 12, 11, 11, 11,  9,
      13, 14, 15, 14, 13, 12, 14, 12, 13, 13, 14, 12, 12, 11, 12,  9,
      14, 14, 15, 14, 14, 12, 14, 12, 14, 14, 14, 13, 13, 11, 12,  9,
      13, 14, 14, 14, 13, 13, 14, 13, 13, 13, 12, 12, 12, 12, 11,  9,
      14, 14, 14, 13, 13, 13, 13, 12, 13, 14, 13, 12, 12, 11, 11,  8,
      15, 14, 15, 14, 14, 13, 14, 11, 15, 14, 14, 12, 13, 11, 12,  8,
      14, 15, 14, 14, 15, 14, 14, 13, 14, 15, 13, 13, 12, 12, 11, 10,
      16, 15, 14, 14, 14, 14, 13, 12, 14, 14, 13, 12, 13, 12, 11,  9,
      15, 15, 15, 14, 16, 14, 14, 11, 15, 15, 14, 12, 13, 12, 11,  8,
      11, 12, 11, 12, 12, 12, 12, 11, 10, 11, 10, 10, 10, 10, 10,  8,
      13, 13, 13, 13, 13, 13, 14, 12, 12, 12, 12, 12, 12, 11, 12,  9,
      14, 14, 14, 13, 15, 13, 15, 13, 14, 14, 14, 12, 14, 12, 13, 10,
      12, 13, 12, 13, 13, 13, 13, 12, 11, 12, 11, 11, 12, 11, 11,  9,
      14, 14, 13, 13, 14, 14, 14, 12, 12, 13, 12, 11, 13, 12, 12,  9,
      14, 14, 15, 13, 15, 15, 15, 13, 15, 13, 13, 12, 14, 12, 13, 10,
      13, 15, 12, 13, 14, 14, 14, 13, 12, 13, 11, 11, 13, 12, 11, 10,
      14, 15, 14, 13, 15, 14, 15, 13, 14, 14, 12, 11, 13, 13, 12,  9,
      14, 15, 14, 13, 15, 14, 15, 13, 14, 14, 13, 11, 14, 13, 12,  9,
      12, 13, 13, 13, 12, 13, 13, 12, 11, 12, 12, 11, 11, 11, 11,  9,
      13, 14, 14, 13, 14, 13, 14, 12, 13, 13, 13, 12, 12, 11, 11,  9,
      15, 15, 16, 14, 15, 14, 14, 13, 15, 14, 14, 13, 13, 12, 13, 10,
      13, 14, 14, 13, 13, 14, 14, 13, 12, 13, 12, 12, 11, 11, 11,  9,
      14, 14, 14, 13, 14, 13, 14, 12, 13, 13, 12, 11, 12, 11, 11,  8,
      15, 15, 15, 13, 15, 14, 14, 12, 14, 13, 13, 12, 13, 12, 12,  9,
      14, 15, 14, 14, 15, 15, 14, 13, 13, 14, 12, 12, 13, 12, 12,  9,
      15, 15, 14, 13, 15, 14, 14, 13, 14, 14, 12, 11, 13, 12, 11,  8,
      15, 16, 14, 13, 15, 15, 15, 12, 14, 14, 13, 11, 14, 12, 12,  8,
      12, 14, 13, 13, 13, 13, 14, 12, 12, 13, 12, 12, 10, 11, 11,  9,
      14, 15, 15, 14, 13, 13, 15, 13, 13, 14, 14, 12, 12, 11, 12,  9,
      15, 15, 16, 14, 14, 13, 15, 13, 14, 14, 14, 13, 13, 11, 12,  9,
      14, 15, 14, 14, 14, 14, 14, 13, 13, 14, 13, 12, 12, 12, 11,  9,
      14, 15, 15, 14, 14, 14, 14, 12, 13, 14, 13, 12, 12, 11, 11,  8,
      15, 15, 15, 14, 14, 13, 15, 12, 15, 14, 14, 12, 13, 11, 11,  8,
      14, 16, 14, 14, 14, 15, 14, 13, 13, 14, 12, 12, 12, 12, 11,  9,
      15, 15, 15, 14, 15, 14, 14, 12, 14, 14, 13, 12, 12, 11, 11,  8,
      15, 15, 14, 13, 15, 13, 14, 12, 14, 14, 13, 11, 13, 11, 11,  7,
    },
    {
       1,  5,  6,  7,  6,  7,  9,  8,  6,  9,  8,  8,  7,  8,  8,  6,
       5,  8, 10, 10, 10, 11, 13, 12, 11, 13, 12, 12, 12, 12, 13, 10,
       8, 10, 13, 12, 13, 13, 16, 14, 14, 16, 16, 14, 16, 16, 16, 12,
       5, 10,  9, 11, 11, 12, 13, 12, 11, 13, 11, 12, 12, 12, 13, 10,
       6, 10, 11, 11, 11, 12, 14, 12, 11, 13, 13, 13, 12, 13, 13, 11,
       8, 12, 13, 12, 14, 14, 16, 14, 14, 16, 16, 16, 16, 16, 16, 13,
       9, 13, 11, 14, 14, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 13,
       9, 13, 13, 13, 14, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 14,
       8, 12, 13, 12, 13, 14, 16, 14, 14, 16, 16, 16, 14, 16, 16, 13,
       5, 10, 11, 12,  9, 11, 13, 12, 11, 13, 13, 13, 11, 12, 13, 10,
       6, 10, 11, 12, 11, 11, 14, 13, 12, 14, 12, 13, 13, 13, 13, 11,
       9, 12, 14, 15, 13, 13, 16, 16, 14, 16, 16, 16, 16, 16, 16, 13,
       8, 13, 13, 14, 13, 14, 16, 16, 14, 16, 14, 16, 14, 16, 14, 13,
       7, 11, 12, 13, 12, 12, 14, 13, 12, 14, 13, 14, 13, 14, 14, 12,
       9, 13, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 15, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       9, 13, 14, 14, 14, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 14,
       9, 13, 14, 15, 11, 13, 16, 14, 14, 16, 16, 16, 13, 14, 16, 13,
       9, 13, 14, 16, 13, 13, 16, 16, 14, 16, 16, 16, 16, 15, 16, 14,
       8, 12, 13, 16, 13, 12, 16, 14, 13, 16, 14, 16, 16, 16, 16, 13,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 14, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       9, 13, 16, 16, 14, 14, 16, 16, 14, 16, 16, 16, 16, 16, 16, 14,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 13, 14, 15, 14, 14, 16, 14, 13, 16, 16, 16, 14, 16, 16, 14,
       6, 11, 11, 12, 11, 12, 14, 13, 11, 14, 12, 13, 12, 13, 13, 11,
       9, 13, 13, 14, 13, 14, 16, 16, 14, 16, 16, 16, 15, 16, 16, 13,
      11, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       7, 11, 11, 13, 12, 13, 16, 14, 12, 16, 12, 14, 14, 14, 14, 12,
       8, 12, 12, 13, 12, 14, 16, 14, 13, 16, 14, 14, 14, 14, 14, 12,
      11, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 14, 13, 16, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 16,
      10, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       7, 11, 12, 12, 11, 13, 16, 14, 12, 15, 14, 14, 11, 13, 13, 12,
       8, 12, 12, 13, 13, 13, 16, 14, 13, 16, 13, 15, 13, 14, 14, 12,
      11, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       8, 12, 13, 14, 13, 14, 16, 16, 14, 16, 14, 16, 14, 16, 15, 13,
       6, 11, 11, 12, 11, 12, 13, 13, 11, 13, 12, 13, 12, 13, 13, 11,
       9, 13, 14, 14, 14, 14, 16, 14, 14, 16, 16, 16, 16, 16, 14, 13,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 14, 13, 14, 14, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 13,
       9, 13, 14, 13, 13, 16, 16, 14, 13, 16, 16, 16, 13, 16, 14, 13,
      10, 14, 14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 13, 14, 16, 14,
      11, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 14, 16, 16, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 14, 14, 14, 14, 16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 13,
       9, 13, 13, 16, 14, 14, 16, 16, 14, 16, 14, 16, 16, 16, 16, 13,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 13, 14, 14, 13, 16, 16, 14, 13, 16, 14, 16, 14, 14, 16, 12,
      10, 14, 14, 16, 16, 16, 16, 16, 13, 16, 16, 16, 14, 16, 16, 14,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 14, 13, 16, 16, 16, 16, 16, 14, 16, 12, 16, 16, 16, 16, 14,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 14,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15,
      11, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 13,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 15, 14, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 14,
      10, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
      10, 14, 16, 16, 13, 16, 16, 16, 14, 16, 16, 16, 12, 16, 16, 14,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16,
      11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 15, 14, 16, 14, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 13,
      10, 15, 14, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
       8, 12, 12, 13, 12, 14, 14, 14, 12, 16, 13, 14, 12, 14, 14, 11,
    },
  },
};


static const uint8_t rv34_table_intra_cbp[NUM_INTRA_TABLES][8][CBP_VLC_SIZE] = {
  {
    { 0,  3,  3,  4,  3,  5,  5,  5,  2,  5,  4,  6,  4,  6,  6,  6, },
    { 0,  2,  3,  4,  2,  5,  6,  7,  3,  6,  5,  7,  4,  7,  8,  8, },
    { 0,  3,  4,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  3, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  6,  3,  5,  6,  5, },
    { 0,  4,  4,  4,  4,  5,  5,  4,  4,  5,  4,  5,  4,  4,  4,  2, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  6,  6,  5,  6,  5,  6,  4,  6,  6,  5,  4,  4,  4,  4,  1, },
    { 0,  4,  4,  4,  4,  5,  5,  4,  4,  5,  5,  4,  4,  4,  4,  2, },
  },
  {
    { 0,  4,  3,  4,  3,  4,  5,  4,  3,  5,  4,  5,  3,  5,  5,  5, },
    { 0,  2,  3,  4,  2,  5,  6,  7,  3,  6,  5,  7,  4,  7,  8,  8, },
    { 0,  4,  4,  4,  4,  4,  5,  4,  4,  5,  4,  4,  3,  4,  4,  3, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  6,  3,  5,  6,  5, },
    { 0,  4,  4,  4,  4,  4,  5,  4,  4,  5,  5,  5,  4,  4,  4,  2, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  5,  6,  5,  5,  5,  6,  4,  6,  6,  5,  4,  5,  4,  4,  1, },
    { 0,  4,  4,  4,  4,  4,  5,  4,  4,  5,  5,  4,  4,  4,  5,  2, },
  },
  {
    { 0,  3,  3,  4,  3,  4,  4,  5,  3,  5,  4,  5,  4,  5,  5,  5, },
    { 0,  2,  3,  4,  2,  4,  6,  7,  3,  6,  5,  7,  5,  7,  8,  8, },
    { 0,  4,  4,  4,  4,  4,  5,  4,  3,  5,  4,  4,  4,  4,  4,  3, },
    { 0,  3,  3,  4,  3,  3,  6,  6,  3,  6,  4,  6,  3,  6,  6,  5, },
    { 0,  4,  4,  4,  3,  4,  5,  4,  4,  5,  4,  4,  4,  4,  4,  3, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  5,  5,  5,  5,  5,  6,  4,  5,  6,  5,  5,  5,  4,  4,  1, },
    { 0,  4,  4,  4,  4,  4,  6,  4,  4,  6,  5,  4,  4,  4,  4,  2, },
  },
  {
    { 0,  3,  3,  4,  3,  4,  4,  5,  3,  5,  4,  5,  4,  5,  5,  5, },
    { 0,  2,  3,  4,  2,  4,  7,  6,  3,  7,  5,  7,  5,  7,  7,  7, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  3,  3,  3,  3,  4,  6,  6,  3,  6,  4,  6,  3,  6,  6,  5, },
    { 0,  3,  4,  4,  3,  4,  5,  4,  4,  5,  4,  5,  4,  5,  4,  3, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  4,  5,  4,  4,  4,  5,  4,  4,  5,  5,  4,  4,  4,  4,  2, },
    { 0,  4,  4,  4,  4,  5,  5,  4,  4,  5,  5,  4,  4,  4,  4,  2, },
  },
  {
    { 0,  3,  3,  4,  3,  4,  5,  6,  2,  5,  4,  7,  4,  6,  6,  7, },
    { 0,  2,  3,  4,  2,  4,  6,  7,  3,  7,  5,  7,  5,  7,  7,  7, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  2,  3,  4,  3,  4,  6,  5,  3,  6,  4,  6,  4,  6,  6,  6, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4, },
    { 0,  4,  4,  4,  4,  5,  5,  4,  4,  5,  5,  4,  4,  4,  4,  2, },
    { 0,  3,  4,  4,  4,  4,  5,  4,  4,  5,  4,  4,  4,  4,  4,  3, },
  },
};


static const uint8_t rv34_table_intra_firstpat[NUM_INTRA_TABLES][4][FIRSTBLK_VLC_SIZE] = {
  {
    {
       0, 10,  5, 10,  7, 12,  9, 11,  8, 13,  9, 12, 10, 13, 11, 12,
      16, 16, 14, 15, 15, 16, 13, 14,  5, 12,  6, 11,  9, 13, 10, 11,
       9, 14,  9, 12, 11, 14, 11, 12, 16, 16, 14, 15, 15, 16, 13, 13,
      10, 15,  9, 12, 12, 16, 11, 12, 12, 16, 10, 13, 13, 16, 11, 12,
      16, 16, 13, 14, 15, 16, 13, 12,  6, 12,  8, 11,  8, 12, 10, 11,
       9, 14, 10, 12, 10, 13, 11, 12, 15, 16, 14, 15, 14, 16, 13, 13,
       8, 13,  9, 12, 10, 13, 10, 12, 10, 14,  9, 12, 11, 14, 10, 12,
      15, 16, 13, 15, 14, 16, 13, 13, 11, 16, 10, 13, 13, 16, 11, 12,
      12, 16, 11, 13, 13, 16, 11, 12, 16, 16, 13, 14, 15, 16, 12, 12,
      10, 16, 12, 14, 10, 14, 11, 12, 12, 16, 13, 14, 11, 14, 12, 12,
      16, 16, 15, 16, 14, 15, 13, 13, 11, 16, 12, 14, 11, 14, 11, 12,
      12, 16, 12, 14, 11, 14, 11, 12, 16, 16, 14, 15, 13, 15, 13, 12,
      14, 16, 13, 14, 13, 16, 12, 12, 14, 16, 13, 14, 13, 16, 12, 12,
      16, 16, 14, 14, 14, 15, 12, 11,  2, 10,  6, 10,  7, 12,  9, 11,
       8, 12,  9, 11, 10, 13, 10, 11, 15, 16, 14, 15, 14, 16, 13, 13,
       5, 12,  6, 11,  9, 13, 10, 11,  9, 13,  9, 11, 10, 13, 10, 11,
      15, 16, 13, 14, 14, 16, 13, 13,  9, 15,  8, 12, 12, 15, 11, 11,
      11, 16, 10, 12, 13, 15, 11, 11, 15, 16, 13, 14, 15, 16, 12, 12,
       6, 12,  8, 11,  8, 12,  9, 11,  9, 14,  9, 12, 10, 13, 10, 11,
      15, 16, 14, 15, 14, 16, 13, 13,  7, 13,  8, 11,  9, 13, 10, 11,
       9, 14,  9, 12, 10, 13, 10, 11, 14, 16, 13, 14, 13, 16, 12, 12,
      11, 16, 10, 12, 12, 15, 11, 11, 11, 16, 10, 12, 12, 15, 11, 11,
      15, 16, 12, 13, 14, 16, 12, 11,  9, 15, 11, 13,  9, 13, 11, 12,
      11, 16, 12, 14, 10, 14, 11, 12, 16, 16, 14, 15, 13, 15, 12, 12,
      11, 16, 11, 14, 10, 14, 11, 12, 11, 16, 12, 13, 11, 14, 11, 11,
      15, 16, 14, 15, 13, 14, 12, 12, 13, 16, 12, 14, 13, 15, 11, 11,
      13, 16, 12, 14, 13, 15, 11, 11, 16, 16, 13, 14, 13, 15, 11, 10,
       5, 12,  7, 11,  8, 13, 10, 11,  9, 13,  9, 12, 10, 14, 11, 12,
      16, 16, 14, 15, 14, 16, 13, 13,  7, 13,  7, 11,  9, 13, 10, 11,
       9, 14,  9, 12, 11, 14, 11, 12, 16, 16, 14, 14, 14, 16, 13, 13,
       9, 15,  8, 12, 12, 15, 11, 12, 11, 16, 10, 12, 13, 16, 11, 12,
      16, 16, 13, 14, 15, 16, 12, 12,  7, 13,  8, 12,  9, 13, 10, 11,
      10, 14, 10, 12, 10, 14, 11, 12, 16, 16, 14, 15, 14, 16, 13, 13,
       8, 14,  9, 12, 10, 13, 10, 11,  9, 14,  9, 12, 10, 14, 10, 11,
      15, 16, 13, 14, 14, 16, 12, 12, 11, 16, 10, 12, 12, 15, 11, 12,
      11, 16, 10, 12, 12, 15, 11, 11, 15, 16, 12, 14, 14, 16, 12, 11,
      10, 16, 11, 13,  9, 14, 11, 12, 12, 16, 12, 14, 11, 14, 11, 12,
      16, 16, 14, 16, 14, 15, 13, 12, 11, 16, 11, 14, 10, 14, 11, 12,
      11, 16, 12, 14, 11, 14, 11, 11, 15, 16, 14, 15, 13, 15, 12, 12,
      13, 16, 12, 14, 13, 15, 11, 11, 13, 16, 12, 14, 12, 14, 11, 11,
      15, 16, 12, 13, 13, 14, 11, 10,  6, 13,  8, 11,  9, 13, 10, 11,
      10, 14, 10, 12, 10, 13, 10, 11, 15, 16, 13, 13, 13, 14, 12, 11,
       7, 13,  8, 11,  9, 13,  9, 11, 10, 14,  9, 11, 10, 13, 10, 11,
      15, 16, 13, 13, 13, 14, 11, 11,  9, 14,  8, 11, 10, 13,  9, 10,
      11, 15,  9, 11, 11, 13,  9, 10, 15, 16, 12, 13, 13, 14, 10,  9,
       7, 13,  8, 11,  9, 13,  9, 11, 10, 14, 10, 12, 10, 13, 10, 11,
      15, 16, 13, 13, 13, 14, 11, 11,  8, 13,  8, 11,  9, 13,  9, 10,
       9, 14,  9, 11, 10, 13,  9, 10, 14, 16, 12, 13, 13, 14, 11, 10,
       9, 14,  8, 11, 10, 13,  9,  9, 10, 14,  8, 11, 10, 13,  9,  9,
      14, 16, 11, 12, 12, 14, 10,  9,  9, 14,  9, 12,  8, 12,  9, 10,
      11, 15, 10, 12, 10, 13,  9, 10, 15, 16, 13, 13, 12, 13, 11, 10,
       9, 14,  9, 12,  9, 12,  9, 10, 10, 14, 10, 12,  9, 12,  9,  9,
      14, 16, 12, 13, 11, 13, 10,  9, 10, 14,  9, 11, 10, 12,  8,  8,
      10, 14,  9, 11, 10, 12,  8,  8, 12, 14,  9, 10, 10, 11,  8,  7,
    },
    {
       0,  9,  6,  9,  6, 10,  8,  9,  7, 11,  8, 11,  9, 11,  9, 10,
      14, 16, 13, 14, 13, 14, 12, 11,  5, 11,  7, 10,  8, 10,  8,  9,
       8, 12,  8, 11,  9, 12,  9, 10, 14, 16, 12, 13, 13, 14, 11, 11,
      10, 14,  9, 11, 11, 13, 10, 10, 11, 15,  9, 11, 12, 13, 10, 10,
      15, 16, 12, 12, 13, 14, 11,  9,  6, 11,  7, 10,  7, 10,  8,  9,
       8, 12,  9, 11,  9, 11,  9, 10, 14, 16, 13, 13, 13, 14, 11, 11,
       7, 12,  8, 11,  8, 11,  9,  9,  9, 13,  9, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 12, 14, 11, 10, 11, 14, 10, 12, 11, 13, 10, 10,
      12, 15, 10, 12, 12, 13, 10, 10, 15, 16, 12, 12, 13, 14, 10,  9,
      10, 14, 11, 13,  9, 12, 10, 10, 11, 15, 12, 13, 10, 12, 10, 10,
      14, 16, 13, 14, 12, 13, 11, 10, 11, 14, 11, 13, 10, 12, 10, 10,
      12, 15, 11, 13, 10, 12, 10, 10, 15, 16, 13, 13, 12, 13, 11,  9,
      13, 16, 12, 13, 12, 13, 10,  9, 14, 16, 12, 13, 12, 13, 10,  9,
      16, 16, 12, 12, 13, 13, 10,  7,  4, 10,  6,  9,  7, 10,  8,  9,
       8, 12,  9, 11,  9, 11,  9,  9, 14, 16, 13, 13, 13, 14, 11, 11,
       6, 11,  7, 10,  8, 11,  8,  9,  9, 12,  9, 11,  9, 12,  9,  9,
      14, 16, 12, 13, 13, 14, 11, 10, 10, 14,  9, 11, 11, 13,  9,  9,
      11, 14,  9, 11, 11, 13, 10,  9, 14, 16, 11, 12, 13, 14, 10,  9,
       6, 11,  8, 10,  7, 10,  8,  9,  9, 12,  9, 11,  9, 11,  9,  9,
      14, 16, 13, 13, 12, 13, 11, 10,  8, 12,  8, 10,  8, 11,  9,  9,
       9, 12,  9, 11,  9, 11,  9,  9, 14, 16, 12, 13, 12, 13, 11, 10,
      11, 14, 10, 11, 11, 13,  9,  9, 11, 14, 10, 11, 11, 13,  9,  9,
      14, 16, 11, 12, 13, 14, 10,  8, 10, 14, 11, 12,  9, 12, 10, 10,
      11, 14, 11, 13, 10, 12, 10, 10, 14, 16, 13, 14, 12, 13, 11,  9,
      11, 14, 11, 12, 10, 12, 10, 10, 11, 14, 11, 12, 10, 12, 10,  9,
      14, 16, 13, 13, 11, 12, 10,  9, 13, 16, 12, 13, 12, 13, 10,  9,
      13, 16, 11, 12, 11, 13, 10,  8, 15, 16, 12, 12, 12, 12,  9,  7,
       8, 12,  8, 11,  9, 12,  9, 10, 10, 14, 10, 12, 11, 13, 10, 10,
      16, 16, 14, 14, 14, 14, 12, 11,  8, 13,  8, 11,  9, 12, 10, 10,
      11, 14, 10, 12, 11, 13, 10, 10, 16, 16, 13, 14, 14, 14, 12, 11,
      11, 14,  9, 12, 11, 13, 10, 10, 12, 15, 10, 12, 12, 14, 10, 10,
      15, 16, 12, 12, 14, 14, 11,  9,  9, 13,  9, 11,  9, 12, 10, 10,
      11, 14, 10, 12, 10, 12, 10, 10, 15, 16, 14, 14, 13, 14, 12, 11,
       9, 13,  9, 11, 10, 12, 10, 10, 10, 14, 10, 12, 10, 12, 10, 10,
      15, 16, 13, 13, 13, 14, 11, 10, 11, 15, 10, 12, 11, 13, 10, 10,
      11, 15, 10, 12, 12, 13, 10,  9, 15, 16, 11, 12, 13, 14, 10,  9,
      11, 15, 11, 13, 10, 12, 10, 10, 12, 16, 12, 13, 11, 13, 10, 10,
      16, 16, 14, 14, 12, 13, 11,  9, 11, 15, 11, 13, 10, 13, 10, 10,
      12, 15, 12, 13, 10, 12, 10, 10, 14, 16, 13, 13, 12, 13, 10,  9,
      13, 16, 12, 13, 12, 13, 10,  9, 13, 16, 11, 12, 11, 13, 10,  9,
      14, 16, 11, 12, 12, 12,  9,  7, 10, 15, 10, 12, 11, 13, 10, 10,
      12, 16, 12, 13, 12, 13, 11, 10, 16, 16, 14, 14, 14, 15, 12, 10,
      10, 14, 10, 12, 10, 13, 10, 10, 12, 15, 11, 12, 11, 13, 10, 10,
      16, 16, 14, 13, 14, 14, 11,  9, 11, 14, 10, 11, 11, 12,  9,  9,
      12, 15, 10, 11, 11, 13,  9,  8, 16, 16, 12, 12, 13, 13, 10,  7,
      10, 15, 10, 12, 10, 13, 10, 10, 12, 15, 11, 12, 11, 13, 10, 10,
      16, 16, 14, 13, 14, 14, 11,  9, 10, 14, 10, 12, 10, 12, 10, 10,
      12, 15, 11, 12, 11, 13, 10, 10, 16, 16, 13, 13, 13, 14, 11,  9,
      11, 14, 10, 11, 10, 12,  9,  8, 11, 14,  9, 11, 11, 12,  9,  8,
      14, 16, 10, 11, 12, 13,  9,  7, 11, 15, 11, 12, 10, 12, 10,  9,
      13, 16, 11, 12, 11, 12, 10,  9, 16, 16, 13, 13, 12, 13, 10,  7,
      11, 15, 10, 12, 10, 12,  9,  8, 12, 15, 11, 12, 10, 12,  9,  8,
      14, 16, 12, 12, 11, 12,  9,  7, 11, 14, 10, 11, 10, 12,  8,  7,
      11, 14,  9, 10, 10, 11,  8,  6, 12, 15,  9,  9,  9, 10,  7,  4,
    },
    {
       0,  6,  3,  7,  3,  7,  6,  7,  5,  9,  6,  9,  7,  9,  8,  8,
      16, 16, 16, 16, 16, 16, 16, 11,  3,  8,  5,  8,  6,  8,  7,  7,
       7, 11,  7, 10,  8, 10,  8,  9, 16, 16, 16, 16, 16, 16, 14, 10,
       8, 16,  7, 11, 10, 16,  9,  9, 11, 16,  9, 14, 16, 16, 10,  9,
      16, 16, 16, 16, 16, 16, 16, 10,  3,  8,  5,  8,  5,  8,  7,  7,
       7, 11,  8, 10,  8, 10,  8,  9, 16, 16, 16, 16, 16, 16, 16, 11,
       6, 10,  7,  9,  7, 10,  8,  8,  8, 11,  8, 10,  8, 11,  8,  8,
      16, 16, 16, 16, 16, 16, 11, 10, 10, 16,  9, 13, 11, 16, 10,  9,
      11, 16,  9, 11, 16, 16, 10,  9, 16, 16, 11, 16, 16, 16, 11,  9,
       9, 16, 10, 11,  8, 11,  9,  9, 11, 16, 12, 16, 10, 16, 10, 10,
      16, 16, 16, 16, 16, 16, 16, 10, 10, 16, 11, 16, 10, 16, 10, 10,
      11, 16, 11, 16, 10, 16, 10,  9, 16, 16, 16, 16, 16, 16, 11,  9,
      16, 16, 16, 16, 16, 16, 11,  9, 16, 16, 16, 16, 16, 16, 11,  9,
      16, 16, 11, 16, 16, 16,  9,  7, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       2,  8,  5,  9,  6,  9,  8,  8,  8, 12,  9, 11,  9, 11, 10, 10,
      16, 16, 14, 16, 14, 16, 14, 12,  5, 10,  6,  9,  8, 10,  8,  9,
       9, 12,  9, 11, 10, 12, 10, 10, 16, 16, 14, 15, 15, 16, 13, 12,
      10, 13,  9, 12, 11, 12, 10, 10, 12, 15, 11, 12, 12, 13, 11, 10,
      16, 16, 15, 14, 15, 16, 13, 12,  6, 10,  8, 10,  7, 10,  8,  9,
       9, 13, 10, 11, 10, 12, 10, 10, 16, 16, 14, 16, 14, 16, 13, 12,
       7, 11,  8, 11,  9, 11,  9,  9, 10, 13, 10, 11, 10, 12, 10,  9,
      16, 16, 14, 14, 14, 15, 12, 11, 11, 14, 11, 12, 11, 13, 10, 10,
      12, 15, 11, 13, 12, 13, 11, 10, 16, 16, 14, 16, 15, 15, 13, 11,
      10, 13, 11, 12, 10, 12, 10, 10, 12, 15, 12, 13, 11, 13, 11, 11,
      16, 16, 15, 16, 14, 15, 13, 11, 11, 14, 11, 13, 11, 12, 11, 10,
      12, 16, 12, 13, 12, 13, 11, 10, 16, 16, 15, 16, 13, 15, 12, 11,
      13, 15, 12, 13, 13, 14, 11, 11, 14, 16, 13, 13, 13, 14, 11, 11,
      16, 16, 15, 14, 15, 15, 12, 10,  3,  8,  6,  9,  7,  9,  8,  8,
       8, 12,  9, 11,  9, 11,  9,  9, 16, 16, 15, 15, 15, 16, 13, 12,
       6, 10,  7,  9,  8, 10,  8,  8,  9, 12,  9, 11, 10, 12, 10,  9,
      16, 16, 14, 14, 14, 15, 13, 11, 10, 13,  9, 11, 11, 12, 10, 10,
      12, 14, 11, 12, 12, 13, 11, 10, 16, 16, 14, 14, 15, 15, 13, 11,
       6, 10,  8, 10,  7, 10,  8,  9, 10, 12, 10, 11, 10, 11, 10,  9,
      16, 16, 14, 15, 14, 15, 13, 11,  8, 11,  8, 10,  9, 11,  9,  9,
       9, 13,  9, 11, 10, 11,  9,  9, 16, 16, 13, 14, 14, 14, 12, 10,
      11, 14, 10, 12, 11, 12, 10, 10, 12, 14, 11, 12, 12, 13, 10, 10,
      16, 16, 13, 14, 15, 15, 12, 10, 10, 13, 11, 12, 10, 12, 10, 10,
      12, 14, 12, 13, 11, 13, 11, 10, 16, 16, 15, 14, 14, 14, 12, 11,
      11, 14, 11, 12, 10, 12, 10, 10, 12, 15, 12, 12, 11, 13, 10, 10,
      16, 16, 14, 15, 13, 14, 12, 10, 13, 15, 12, 13, 12, 13, 11, 10,
      13, 16, 12, 13, 12, 13, 11, 10, 16, 16, 13, 14, 13, 15, 11,  9,
       6, 10,  8, 10,  8, 11,  9, 10, 11, 13, 11, 12, 11, 13, 11, 10,
      16, 16, 16, 16, 16, 16, 13, 12,  8, 11,  9, 11,  9, 11, 10, 10,
      11, 14, 11, 12, 11, 12, 11, 10, 16, 16, 15, 15, 16, 16, 13, 12,
      11, 14, 10, 12, 12, 13, 11, 10, 13, 16, 12, 13, 13, 14, 11, 11,
      16, 16, 15, 16, 16, 16, 13, 12,  8, 12,  9, 11,  9, 11, 10, 10,
      11, 14, 11, 12, 11, 12, 11, 10, 16, 16, 16, 16, 16, 16, 13, 12,
       9, 12, 10, 11, 10, 12, 10, 10, 11, 14, 11, 12, 11, 13, 10, 10,
      16, 16, 15, 14, 15, 15, 13, 11, 12, 14, 11, 13, 12, 13, 11, 10,
      12, 15, 11, 12, 13, 13, 11, 10, 16, 16, 14, 15, 16, 15, 13, 11,
      11, 15, 12, 13, 11, 13, 11, 10, 13, 16, 13, 14, 12, 14, 11, 11,
      16, 16, 16, 16, 15, 15, 13, 12, 12, 14, 12, 13, 11, 13, 11, 10,
      13, 15, 12, 13, 11, 13, 11, 10, 16, 16, 15, 15, 13, 15, 13, 11,
      13, 16, 13, 13, 13, 13, 12, 11, 13, 16, 13, 13, 13, 13, 11, 10,
      16, 16, 13, 15, 14, 14, 12,  9,  9, 13, 10, 12, 11, 13, 11, 11,
      13, 16, 13, 14, 13, 14, 12, 11, 16, 16, 16, 16, 16, 16, 14, 12,
      10, 14, 11, 13, 11, 13, 11, 10, 13, 16, 13, 13, 13, 14, 12, 11,
      16, 16, 16, 16, 16, 16, 14, 12, 11, 15, 11, 13, 12, 13, 11, 10,
      14, 16, 12, 13, 13, 14, 12, 10, 16, 16, 15, 16, 16, 16, 13, 11,
      10, 14, 11, 12, 11, 13, 11, 10, 13, 16, 12, 13, 12, 14, 12, 11,
      16, 16, 16, 16, 16, 16, 14, 12, 11, 14, 11, 12, 11, 13, 11, 10,
      13, 15, 12, 13, 12, 13, 11, 10, 16, 16, 15, 15, 16, 16, 13, 11,
      12, 15, 12, 13, 12, 13, 11, 10, 13, 16, 12, 13, 13, 13, 11, 10,
      16, 16, 14, 14, 16, 15, 13, 10, 12, 15, 12, 13, 12, 13, 11, 10,
      14, 16, 13, 14, 13, 14, 12, 11, 16, 16, 16, 16, 15, 16, 13, 11,
      12, 16, 12, 13, 12, 13, 11, 10, 13, 16, 13, 13, 12, 14, 11, 10,
      16, 16, 15, 16, 14, 15, 13, 10, 12, 15, 12, 14, 12, 13, 11, 10,
      13, 16, 12, 13, 12, 13, 11, 10, 16, 16, 13, 14, 13, 14, 11,  8,
    },
  },
  {
    {
       0, 11,  5, 11,  7, 13, 10, 12,  7, 13,  9, 13, 10, 14, 12, 13,
      16, 16, 15, 16, 16, 16, 15, 15,  4, 13,  6, 12, 10, 14, 11, 12,
       8, 14,  9, 13, 11, 15, 12, 13, 16, 16, 15, 16, 15, 16, 15, 14,
       9, 16,  9, 13, 13, 16, 12, 13, 12, 16, 10, 14, 14, 16, 13, 13,
      16, 16, 14, 16, 16, 16, 14, 14,  5, 13,  8, 13,  8, 13, 11, 12,
       9, 14, 10, 13, 10, 14, 12, 13, 16, 16, 15, 16, 15, 16, 14, 15,
       7, 14,  9, 13, 10, 14, 11, 13,  9, 15, 10, 13, 11, 14, 12, 13,
      16, 16, 14, 16, 15, 16, 14, 14, 11, 16, 11, 14, 13, 16, 12, 13,
      12, 16, 11, 14, 14, 16, 12, 13, 16, 16, 14, 15, 16, 16, 14, 13,
      10, 16, 12, 15, 10, 15, 12, 14, 12, 16, 13, 16, 11, 15, 13, 14,
      16, 16, 16, 16, 14, 16, 14, 14, 11, 16, 12, 15, 11, 16, 12, 13,
      12, 16, 13, 15, 12, 16, 12, 13, 16, 16, 16, 16, 14, 16, 14, 14,
      14, 16, 13, 15, 14, 16, 13, 13, 14, 16, 14, 15, 14, 16, 13, 13,
      16, 16, 15, 16, 15, 16, 13, 13,  2, 12,  6, 11,  7, 13, 10, 12,
       7, 13,  9, 12, 10, 14, 11, 12, 16, 16, 15, 16, 15, 16, 14, 15,
       5, 13,  6, 12,  9, 13, 10, 12,  8, 14,  9, 13, 11, 14, 11, 13,
      16, 16, 14, 16, 15, 16, 14, 14,  9, 16,  8, 13, 12, 16, 11, 13,
      11, 16, 10, 13, 13, 16, 12, 13, 16, 16, 13, 15, 16, 16, 13, 13,
       5, 13,  8, 12,  7, 13, 10, 12,  8, 14, 10, 13, 10, 14, 11, 13,
      16, 16, 14, 16, 15, 16, 14, 14,  7, 14,  8, 12,  9, 14, 11, 12,
       8, 14,  9, 13, 10, 14, 11, 12, 15, 16, 14, 15, 14, 16, 13, 14,
      11, 16, 10, 13, 13, 16, 12, 13, 11, 16, 10, 13, 13, 16, 12, 13,
      16, 16, 13, 15, 15, 16, 13, 13,  9, 16, 12, 15,  9, 14, 11, 13,
      11, 16, 13, 15, 11, 14, 12, 13, 16, 16, 15, 16, 14, 16, 14, 14,
      11, 16, 12, 14, 11, 15, 12, 13, 11, 16, 12, 14, 11, 15, 12, 13,
      16, 16, 15, 16, 14, 16, 13, 13, 13, 16, 13, 15, 13, 16, 12, 13,
      14, 16, 13, 15, 13, 16, 12, 12, 16, 16, 14, 15, 14, 16, 12, 12,
       4, 13,  7, 12,  8, 14, 11, 12,  9, 14, 10, 13, 11, 14, 12, 13,
      16, 16, 15, 16, 16, 16, 15, 15,  6, 14,  7, 12, 10, 14, 11, 12,
       9, 15, 10, 13, 11, 15, 12, 13, 16, 16, 15, 16, 16, 16, 14, 14,
       9, 16,  8, 13, 12, 16, 11, 13, 12, 16, 10, 14, 13, 16, 12, 13,
      16, 16, 14, 16, 16, 16, 14, 14,  6, 14,  8, 13,  8, 14, 11, 13,
       9, 15, 10, 13, 11, 14, 12, 13, 16, 16, 15, 16, 16, 16, 14, 14,
       7, 15,  9, 13, 10, 14, 11, 13,  9, 15, 10, 13, 11, 14, 11, 13,
      16, 16, 14, 16, 15, 16, 14, 14, 10, 16, 10, 13, 12, 16, 12, 13,
      11, 16, 10, 13, 13, 16, 12, 13, 16, 16, 13, 14, 15, 16, 13, 13,
       9, 16, 12, 14,  9, 14, 11, 13, 12, 16, 12, 15, 11, 15, 12, 13,
      16, 16, 16, 16, 15, 16, 14, 14, 10, 16, 12, 15, 11, 15, 12, 13,
      11, 16, 12, 14, 11, 15, 12, 13, 16, 16, 14, 16, 13, 16, 13, 13,
      13, 16, 13, 15, 13, 16, 12, 13, 13, 16, 12, 14, 13, 16, 12, 12,
      15, 16, 13, 14, 13, 16, 12, 12,  6, 14,  8, 13,  9, 14, 10, 12,
      10, 15, 10, 12, 11, 14, 11, 12, 16, 16, 14, 14, 14, 16, 13, 13,
       7, 15,  8, 13,  9, 14, 10, 12, 10, 15, 10, 13, 11, 14, 11, 12,
      16, 16, 14, 14, 14, 16, 13, 12,  9, 16,  8, 12, 11, 14, 10, 11,
      11, 16, 10, 13, 11, 14, 10, 11, 16, 16, 13, 14, 14, 16, 12, 11,
       7, 14,  9, 13,  9, 14, 10, 12, 10, 16, 10, 13, 11, 14, 11, 12,
      16, 16, 14, 14, 14, 15, 13, 12,  7, 14,  9, 13,  9, 14, 10, 12,
       9, 14, 10, 12, 10, 14, 11, 12, 15, 16, 13, 14, 14, 15, 12, 12,
       9, 15,  9, 12, 11, 14, 10, 11, 10, 15,  9, 12, 11, 14, 10, 11,
      14, 16, 11, 13, 13, 15, 11, 11,  9, 16, 10, 13,  9, 14, 10, 11,
      11, 16, 11, 13, 10, 14, 10, 11, 16, 16, 14, 15, 13, 15, 12, 12,
       9, 16, 10, 13,  9, 13, 10, 11, 10, 15, 10, 13, 10, 13, 10, 11,
      14, 16, 13, 14, 12, 14, 11, 11, 11, 16, 10, 13, 11, 13,  9, 10,
      11, 14, 10, 12, 10, 13,  9,  9, 13, 15, 10, 11, 11, 12,  9,  8,
    },
    {
       0, 10,  5, 10,  6, 11,  8, 10,  7, 12,  8, 11,  9, 12,  9, 10,
      14, 16, 13, 13, 13, 14, 12, 11,  5, 12,  6, 10,  8, 12,  9, 10,
       8, 13,  8, 11,  9, 12,  9, 10, 14, 16, 12, 13, 13, 14, 11, 11,
       9, 15,  8, 12, 11, 14, 10, 10, 11, 16,  9, 12, 12, 14, 10, 10,
      14, 16, 11, 12, 13, 14, 11, 10,  5, 12,  8, 11,  7, 11,  9, 10,
       8, 13,  9, 11,  9, 12,  9, 10, 14, 16, 12, 13, 13, 14, 11, 11,
       7, 13,  8, 11,  9, 12,  9, 10,  9, 13,  9, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 12, 13, 11, 10, 11, 15, 10, 12, 12, 14, 10, 10,
      12, 16, 10, 12, 12, 14, 10, 10, 14, 16, 11, 12, 13, 14, 10,  9,
      10, 15, 11, 13,  9, 13, 10, 10, 11, 15, 12, 13, 10, 12, 10, 10,
      14, 16, 13, 14, 12, 13, 11, 10, 11, 16, 11, 13, 10, 13, 10, 10,
      11, 16, 11, 13, 10, 13, 10, 10, 14, 16, 13, 14, 12, 13, 11,  9,
      13, 16, 12, 13, 12, 14, 11, 10, 14, 16, 12, 13, 12, 14, 10,  9,
      16, 16, 12, 13, 13, 13, 10,  8,  3, 11,  6, 10,  7, 11,  9, 10,
       8, 12,  8, 11,  9, 12,  9, 10, 14, 16, 13, 13, 13, 14, 11, 11,
       5, 12,  6, 10,  8, 12,  9, 10,  8, 13,  8, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 13, 14, 11, 10,  9, 14,  8, 11, 11, 14, 10, 10,
      11, 15,  9, 11, 12, 14, 10, 10, 14, 16, 11, 12, 13, 14, 11,  9,
       6, 12,  8, 11,  7, 11,  9, 10,  8, 13,  9, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 13, 13, 11, 10,  7, 13,  8, 11,  8, 12,  9, 10,
       9, 13,  9, 11,  9, 12,  9,  9, 14, 16, 12, 13, 12, 13, 11, 10,
      10, 15,  9, 12, 11, 14, 10, 10, 11, 15,  9, 11, 11, 13, 10,  9,
      14, 16, 11, 12, 13, 14, 10,  9,  9, 15, 11, 13,  9, 12, 10, 10,
      11, 15, 11, 13,  9, 12, 10, 10, 14, 16, 13, 14, 12, 13, 11, 10,
      10, 15, 11, 13, 10, 13, 10, 10, 11, 15, 11, 13, 10, 12, 10, 10,
      14, 16, 12, 13, 11, 12, 10,  9, 13, 16, 12, 13, 12, 14, 10,  9,
      13, 16, 11, 12, 12, 13, 10,  9, 14, 16, 11, 12, 12, 13,  9,  8,
       7, 13,  8, 12,  9, 13, 10, 11, 10, 14, 10, 12, 11, 13, 11, 11,
      16, 16, 13, 14, 14, 14, 12, 11,  8, 14,  8, 12,  9, 13, 10, 10,
      10, 14, 10, 12, 11, 13, 10, 10, 16, 16, 13, 13, 14, 14, 12, 11,
      10, 15,  9, 12, 11, 14, 10, 10, 12, 16, 10, 12, 12, 14, 10, 10,
      16, 16, 12, 13, 14, 15, 11, 10,  8, 14,  9, 12,  9, 13, 10, 11,
      10, 15, 10, 12, 10, 13, 10, 11, 16, 16, 13, 14, 14, 14, 12, 11,
       8, 14,  9, 12,  9, 13, 10, 10, 10, 14, 10, 12, 10, 13, 10, 10,
      15, 16, 13, 13, 13, 14, 11, 10, 10, 15, 10, 12, 12, 14, 10, 10,
      11, 16,  9, 12, 12, 14, 10, 10, 14, 16, 11, 12, 13, 14, 10,  9,
      11, 16, 11, 13, 10, 13, 10, 10, 12, 16, 12, 13, 10, 13, 11, 10,
      15, 16, 14, 14, 12, 13, 11, 10, 11, 16, 11, 13, 10, 13, 10, 10,
      11, 16, 12, 13, 10, 12, 10, 10, 14, 16, 13, 14, 11, 13, 11,  9,
      13, 16, 12, 13, 12, 14, 10, 10, 12, 16, 11, 12, 12, 13, 10,  9,
      14, 16, 11, 12, 11, 12,  9,  8, 10, 16, 10, 13, 11, 14, 11, 11,
      12, 16, 11, 13, 12, 14, 11, 11, 16, 16, 14, 13, 14, 14, 12, 10,
      10, 15, 10, 13, 10, 13, 10, 11, 12, 16, 11, 13, 11, 13, 11, 10,
      16, 16, 14, 13, 14, 14, 12, 10, 11, 15,  9, 12, 11, 13, 10,  9,
      12, 16, 10, 12, 12, 13, 10,  9, 16, 16, 12, 12, 13, 14, 10,  8,
      10, 16, 10, 13, 10, 14, 11, 11, 12, 16, 11, 13, 12, 14, 11, 10,
      16, 16, 14, 13, 14, 14, 12, 10,  9, 15,  9, 12, 10, 13, 10, 10,
      11, 16, 10, 12, 11, 13, 10, 10, 16, 16, 13, 13, 13, 14, 11,  9,
      10, 15,  9, 11, 11, 13,  9,  9, 11, 15,  9, 11, 11, 13,  9,  8,
      14, 16, 10, 11, 13, 13, 10,  8, 11, 16, 11, 13, 10, 13, 10,  9,
      13, 16, 11, 13, 11, 13, 10,  9, 16, 16, 13, 13, 13, 13, 10,  8,
      11, 16, 10, 12, 10, 13, 10,  9, 11, 16, 11, 12, 10, 12,  9,  9,
      15, 16, 12, 13, 11, 12, 10,  8, 11, 16, 10, 12, 11, 12,  9,  8,
      11, 15,  9, 11, 10, 12,  9,  7, 13, 15,  9,  9, 10, 10,  7,  5,
    },
    {
       0,  7,  3,  8,  4,  9,  7,  8,  5, 10,  7, 10,  8, 11,  8,  9,
      16, 16, 16, 16, 16, 16, 11, 10,  2, 10,  4,  9,  7, 10,  7,  8,
       7, 16,  7, 10,  9, 16,  8,  9, 16, 16, 16, 16, 16, 16, 11, 10,
       8, 16,  7, 10, 10, 16,  9,  8, 10, 16,  9, 11, 16, 16,  9,  9,
      16, 16, 16, 16, 16, 16, 11,  9,  3, 10,  6,  9,  6, 11,  8,  8,
       7, 16,  8, 10,  9, 16,  9,  9, 16, 16, 16, 16, 16, 16, 11, 10,
       5, 16,  7, 10,  8, 11,  8,  8,  8, 16,  8, 10,  9, 16,  8,  8,
      16, 16, 11, 16, 16, 16, 10,  9,  9, 16,  9, 11, 11, 16,  9,  9,
      11, 16,  9, 11, 11, 16,  9,  8, 16, 16, 10, 16, 16, 16, 10,  9,
       8, 16, 10, 16,  8, 16, 10,  9, 12, 16, 11, 16, 10, 16, 10,  9,
      16, 16, 16, 16, 16, 16, 12, 10, 10, 16, 11, 16, 10, 16, 10,  9,
      11, 16, 11, 16, 10, 16, 10,  9, 16, 16, 16, 16, 16, 16, 11,  9,
      16, 16, 16, 16, 16, 16, 10,  9, 16, 16, 11, 16, 16, 16, 10,  9,
      16, 16, 10, 11, 11, 16,  9,  7, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       2,  9,  6,  9,  6, 10,  8,  9,  8, 12,  9, 11,  9, 12, 10, 10,
      16, 16, 14, 14, 15, 15, 13, 12,  5, 11,  7, 10,  8, 11,  9,  9,
       9, 13,  9, 11, 10, 12, 10, 10, 15, 16, 14, 14, 14, 16, 12, 11,
      10, 14,  9, 11, 11, 13, 10, 10, 12, 15, 10, 12, 12, 13, 11, 10,
      16, 16, 14, 15, 14, 15, 12, 11,  5, 11,  8, 10,  7, 11,  9,  9,
       9, 13,  9, 12,  9, 12, 10, 10, 15, 16, 13, 14, 13, 16, 12, 11,
       7, 12,  8, 11,  9, 11,  9, 10,  9, 13,  9, 11, 10, 12,  9,  9,
      16, 16, 13, 14, 13, 14, 11, 11, 10, 14, 10, 12, 11, 13, 10, 10,
      11, 16, 11, 12, 12, 13, 10, 10, 16, 16, 13, 14, 13, 14, 12, 11,
      10, 14, 11, 13, 10, 13, 10, 11, 12, 16, 12, 13, 10, 12, 11, 11,
      16, 16, 14, 15, 13, 14, 12, 11, 11, 15, 11, 13, 11, 13, 10, 10,
      12, 15, 12, 13, 11, 13, 11, 10, 15, 16, 14, 15, 13, 15, 12, 11,
      12, 16, 12, 13, 12, 14, 11, 11, 13, 16, 12, 13, 12, 14, 11, 10,
      16, 16, 13, 14, 13, 14, 11, 10,  3, 10,  6,  9,  7, 10,  8,  9,
       9, 12,  9, 11, 10, 12,  9, 10, 15, 16, 14, 14, 14, 14, 12, 11,
       6, 11,  7, 10,  8, 10,  9,  9,  9, 13,  9, 11, 10, 12,  9,  9,
      15, 16, 13, 14, 14, 15, 12, 11, 10, 14,  9, 11, 11, 12, 10, 10,
      12, 14, 10, 12, 11, 13, 10, 10, 15, 16, 13, 14, 14, 16, 12, 11,
       6, 11,  8, 10,  7, 11,  9,  9,  9, 13,  9, 11,  9, 12,  9,  9,
      15, 16, 14, 14, 13, 14, 12, 11,  7, 11,  8, 11,  8, 11,  9,  9,
       9, 12,  9, 11,  9, 12,  9,  9, 15, 16, 13, 13, 13, 14, 11, 10,
      10, 13, 10, 12, 11, 13, 10, 10, 11, 15, 10, 12, 11, 13, 10, 10,
      14, 16, 12, 13, 13, 14, 11, 10, 10, 14, 11, 12,  9, 12, 10, 10,
      11, 15, 11, 13, 10, 13, 10, 10, 15, 16, 14, 14, 13, 14, 12, 11,
      10, 14, 10, 12, 10, 12, 10, 10, 11, 15, 11, 12, 10, 12, 10, 10,
      15, 16, 13, 14, 12, 14, 11, 10, 12, 16, 11, 13, 12, 14, 11, 10,
      12, 16, 12, 13, 11, 13, 10, 10, 15, 16, 12, 14, 12, 14, 11,  9,
       7, 12,  9, 11,  9, 12, 10, 10, 11, 14, 11, 12, 11, 13, 11, 11,
      16, 16, 15, 16, 15, 16, 13, 12,  8, 12,  9, 11,  9, 12, 10, 10,
      11, 14, 11, 12, 11, 13, 10, 10, 16, 16, 14, 15, 15, 16, 13, 12,
      11, 14, 10, 12, 11, 13, 10, 10, 12, 16, 11, 13, 12, 14, 11, 10,
      16, 16, 14, 15, 14, 16, 12, 11,  8, 13,  9, 11,  9, 12, 10, 10,
      11, 14, 11, 12, 11, 13, 10, 10, 16, 16, 15, 15, 14, 15, 13, 12,
       9, 13,  9, 12,  9, 12, 10, 10, 11, 14, 10, 12, 10, 12, 10, 10,
      16, 16, 14, 15, 14, 14, 12, 11, 11, 15, 11, 12, 11, 13, 11, 10,
      12, 16, 11, 12, 12, 13, 11, 10, 16, 16, 13, 15, 14, 15, 11, 11,
      11, 16, 11, 13, 10, 13, 11, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      16, 16, 14, 15, 14, 15, 13, 11, 11, 16, 11, 13, 11, 13, 11, 10,
      12, 16, 12, 13, 10, 13, 11, 10, 16, 16, 14, 14, 12, 14, 12, 10,
      12, 16, 12, 14, 12, 14, 11, 11, 13, 16, 12, 14, 12, 14, 11, 10,
      15, 16, 12, 14, 12, 14, 11,  9,  9, 14, 11, 13, 11, 13, 11, 11,
      13, 16, 12, 14, 13, 14, 12, 11, 16, 16, 16, 16, 16, 16, 14, 12,
       9, 14, 10, 12, 10, 13, 11, 11, 12, 16, 12, 13, 13, 14, 11, 11,
      16, 16, 16, 16, 16, 14, 13, 12, 10, 15, 11, 13, 11, 14, 11, 10,
      13, 16, 12, 13, 12, 15, 11, 10, 16, 16, 14, 16, 15, 16, 13, 11,
      10, 14, 10, 13, 11, 14, 11, 11, 13, 16, 12, 13, 12, 14, 11, 11,
      16, 16, 16, 16, 15, 16, 13, 12, 10, 14, 10, 12, 10, 13, 10, 11,
      12, 15, 12, 13, 12, 13, 11, 10, 16, 16, 14, 14, 15, 15, 13, 11,
      11, 16, 11, 13, 11, 14, 11, 10, 12, 16, 11, 13, 12, 14, 11, 10,
      16, 16, 13, 14, 14, 15, 12, 10, 11, 16, 12, 13, 11, 14, 11, 10,
      13, 16, 13, 14, 12, 14, 11, 11, 16, 16, 15, 16, 15, 15, 12, 11,
      11, 16, 12, 13, 11, 14, 11, 10, 13, 16, 12, 13, 11, 14, 11, 10,
      16, 16, 14, 15, 13, 14, 12, 10, 12, 16, 12, 14, 12, 14, 10, 10,
      12, 16, 11, 13, 11, 14, 10, 10, 14, 16, 11, 13, 12, 13, 10,  8,
    },
  },
  {
    {
       0, 12,  6, 13,  7, 14, 11, 14,  8, 14, 10, 14, 11, 15, 13, 15,
      16, 16, 16, 16, 16, 16, 16, 16,  5, 14,  7, 13, 10, 16, 12, 14,
       9, 16, 10, 14, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16,  9, 14, 14, 16, 13, 16, 12, 16, 11, 16, 16, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  5, 14,  9, 14,  8, 14, 12, 14,
       9, 16, 11, 14, 11, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 14, 11, 16, 12, 14, 10, 16, 11, 15, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 12, 16, 14, 16, 14, 16,
      13, 16, 12, 16, 15, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 13, 16, 11, 16, 14, 16, 13, 16, 14, 16, 13, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 14, 16, 13, 16, 14, 16,
      13, 16, 14, 16, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 15, 16, 16, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 12,  6, 12,  8, 14, 11, 13,
       8, 14, 10, 13, 11, 14, 13, 14, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 14,  7, 13, 10, 14, 11, 14,  9, 16, 10, 14, 12, 16, 13, 15,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16,  9, 14, 13, 16, 13, 14,
      12, 16, 11, 15, 14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 14,  9, 13,  8, 14, 12, 14,  9, 16, 11, 14, 11, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 15,  9, 14, 10, 16, 12, 14,
       9, 16, 10, 14, 11, 16, 12, 14, 16, 16, 16, 16, 16, 16, 15, 16,
      11, 16, 11, 15, 14, 16, 13, 15, 12, 16, 11, 15, 14, 16, 13, 14,
      16, 16, 14, 16, 16, 16, 14, 16, 10, 16, 13, 16, 10, 16, 13, 16,
      12, 16, 14, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 13, 16, 12, 16, 13, 16, 12, 16, 13, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 15, 16, 14, 16, 14, 16, 16, 16, 14, 16,
      15, 16, 14, 16, 14, 16, 14, 16, 16, 16, 16, 16, 16, 16, 14, 14,
       4, 14,  8, 13,  9, 16, 12, 14,  9, 16, 11, 14, 11, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 15,  8, 13, 10, 16, 12, 14,
      10, 16, 11, 14, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16,  9, 14, 13, 16, 13, 15, 12, 16, 11, 16, 14, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16,  9, 14,  9, 16, 12, 14,
      10, 16, 11, 15, 12, 16, 13, 15, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 14, 11, 16, 12, 14, 10, 16, 11, 14, 12, 16, 13, 15,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 11, 15, 14, 16, 13, 15,
      12, 16, 11, 15, 14, 16, 13, 14, 16, 16, 14, 16, 16, 16, 14, 16,
      10, 16, 13, 16, 10, 16, 13, 15, 13, 16, 14, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 13, 16, 12, 16, 13, 16,
      12, 16, 13, 16, 11, 16, 13, 16, 16, 16, 16, 16, 15, 16, 15, 16,
      14, 16, 14, 16, 15, 16, 14, 16, 14, 16, 14, 16, 14, 16, 14, 14,
      16, 16, 14, 16, 15, 16, 14, 14,  6, 16,  9, 14, 10, 16, 12, 14,
      10, 16, 11, 13, 12, 16, 13, 14, 16, 16, 16, 16, 16, 16, 14, 14,
       7, 16,  9, 14, 10, 16, 12, 13, 11, 16, 11, 14, 12, 16, 12, 14,
      16, 16, 16, 16, 16, 16, 14, 14,  9, 16,  9, 14, 12, 16, 11, 13,
      12, 16, 11, 14, 12, 16, 12, 13, 16, 16, 14, 16, 16, 16, 13, 14,
       7, 16, 10, 14, 10, 16, 12, 14, 11, 16, 11, 14, 11, 16, 12, 14,
      16, 16, 16, 16, 16, 16, 14, 14,  8, 16, 10, 14, 10, 16, 11, 13,
      10, 16, 11, 13, 11, 16, 12, 13, 16, 16, 14, 16, 16, 16, 14, 14,
      10, 16,  9, 13, 12, 16, 11, 13, 11, 16, 10, 13, 12, 16, 11, 12,
      16, 16, 13, 15, 15, 16, 13, 13,  9, 16, 11, 14,  9, 16, 11, 13,
      12, 16, 12, 16, 12, 16, 12, 13, 16, 16, 16, 16, 15, 16, 14, 14,
      10, 16, 11, 14, 10, 16, 11, 13, 11, 16, 12, 14, 10, 15, 11, 13,
      16, 16, 15, 16, 13, 16, 13, 13, 12, 16, 11, 13, 12, 16, 11, 12,
      12, 16, 11, 13, 11, 14, 11, 11, 13, 16, 12, 13, 12, 14, 11, 11,
    },
    {
       0, 10,  5, 10,  6, 11,  8, 10,  7, 12,  8, 11,  8, 12,  9, 10,
      14, 16, 13, 13, 13, 14, 12, 11,  4, 12,  6, 10,  8, 12,  9, 10,
       8, 13,  8, 11,  9, 12,  9, 10, 14, 16, 12, 13, 13, 14, 11, 11,
       9, 15,  8, 12, 12, 14, 10, 11, 11, 16,  9, 12, 12, 14, 10, 10,
      14, 16, 11, 13, 13, 15, 11, 11,  4, 12,  8, 11,  6, 11,  9, 10,
       8, 13,  9, 11,  8, 12,  9, 10, 14, 16, 12, 13, 13, 14, 11, 11,
       7, 13,  8, 11,  9, 12,  9, 10,  8, 13,  9, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 12, 13, 11, 10, 11, 16, 10, 12, 12, 14, 10, 11,
      11, 16, 10, 12, 12, 14, 10, 10, 15, 16, 11, 13, 13, 14, 11, 10,
      10, 16, 11, 13,  9, 13, 10, 11, 11, 15, 12, 13, 10, 12, 10, 11,
      15, 16, 13, 14, 12, 13, 11, 11, 11, 16, 11, 13, 10, 13, 10, 11,
      12, 16, 11, 13, 10, 13, 10, 10, 15, 16, 13, 14, 12, 13, 11, 10,
      13, 16, 12, 13, 13, 14, 11, 11, 14, 16, 12, 13, 12, 14, 11, 10,
      16, 16, 13, 13, 13, 14, 11,  9,  3, 11,  6, 10,  6, 11,  9, 10,
       8, 12,  8, 11,  9, 12,  9, 10, 14, 16, 13, 13, 13, 13, 12, 11,
       5, 12,  6, 10,  8, 12,  9, 10,  8, 13,  8, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 13, 14, 11, 11,  9, 15,  8, 11, 11, 14, 10, 10,
      11, 15,  9, 11, 12, 14, 10, 10, 14, 16, 11, 12, 13, 14, 11, 10,
       5, 12,  8, 11,  7, 11,  9, 10,  8, 13,  9, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 13, 13, 11, 11,  7, 13,  8, 11,  8, 12,  9, 10,
       8, 13,  8, 11,  9, 12,  9,  9, 13, 16, 11, 13, 12, 13, 11, 10,
      10, 15,  9, 12, 11, 14, 10, 10, 11, 15,  9, 11, 11, 13, 10, 10,
      14, 16, 11, 12, 13, 14, 10, 10,  9, 16, 11, 13,  9, 12, 10, 10,
      11, 16, 11, 13,  9, 12, 10, 10, 15, 16, 13, 14, 12, 13, 11, 10,
      11, 16, 11, 13, 10, 13, 10, 10, 11, 15, 11, 13,  9, 12, 10, 10,
      14, 16, 12, 13, 11, 13, 10, 10, 13, 16, 12, 13, 12, 14, 11, 10,
      13, 16, 11, 13, 12, 13, 10, 10, 14, 16, 11, 12, 12, 13, 10,  9,
       7, 14,  8, 12,  9, 13, 10, 11, 10, 14, 10, 12, 11, 13, 11, 11,
      16, 16, 14, 14, 14, 14, 12, 12,  7, 14,  8, 12,  9, 13, 10, 11,
      10, 14, 10, 12, 11, 13, 10, 11, 16, 16, 13, 13, 14, 14, 12, 11,
      10, 15,  9, 12, 12, 14, 10, 10, 12, 16,  9, 12, 12, 14, 10, 10,
      16, 16, 12, 13, 14, 15, 12, 11,  8, 14,  9, 12,  9, 13, 10, 11,
      10, 15, 10, 12, 10, 13, 10, 11, 16, 16, 14, 14, 14, 14, 12, 11,
       8, 14,  9, 12,  9, 13, 10, 11, 10, 14, 10, 12, 10, 13, 10, 10,
      15, 16, 13, 13, 13, 14, 12, 11, 10, 15, 10, 12, 12, 14, 10, 10,
      11, 16,  9, 12, 12, 14, 10, 10, 14, 16, 11, 12, 13, 14, 11, 10,
      11, 16, 11, 14,  9, 13, 10, 11, 12, 16, 12, 14, 10, 13, 11, 11,
      16, 16, 14, 15, 13, 14, 12, 11, 11, 16, 12, 14, 10, 13, 11, 11,
      11, 16, 11, 13, 10, 13, 10, 10, 15, 16, 13, 14, 12, 13, 11, 10,
      13, 16, 12, 14, 13, 14, 11, 10, 12, 16, 11, 13, 12, 13, 10, 10,
      14, 16, 11, 12, 11, 13, 10,  9, 10, 16, 10, 13, 11, 14, 11, 11,
      12, 16, 11, 13, 12, 14, 11, 11, 16, 16, 14, 13, 14, 15, 12, 11,
      10, 16, 10, 13, 10, 14, 11, 11, 12, 16, 11, 13, 11, 14, 11, 11,
      16, 16, 14, 13, 14, 14, 12, 11, 11, 15,  9, 12, 11, 14, 10, 10,
      13, 16, 10, 12, 12, 14, 10, 10, 16, 16, 13, 13, 14, 14, 11, 10,
      10, 16, 10, 13, 11, 14, 11, 11, 12, 16, 11, 13, 12, 14, 11, 11,
      16, 16, 14, 14, 14, 14, 12, 11,  9, 16, 10, 13, 10, 14, 11, 11,
      11, 15, 11, 12, 11, 13, 11, 11, 16, 16, 13, 13, 14, 14, 12, 10,
      10, 15,  9, 12, 11, 14, 10, 10, 11, 16,  9, 11, 11, 13, 10,  9,
      15, 16, 11, 12, 13, 14, 10,  9, 11, 16, 11, 13, 10, 13, 10, 10,
      13, 16, 12, 13, 11, 13, 10, 10, 16, 16, 14, 14, 13, 13, 11, 10,
      11, 16, 11, 13, 10, 13, 10, 10, 12, 16, 11, 13, 10, 13, 10, 10,
      15, 16, 13, 13, 12, 13, 11,  9, 11, 16, 11, 12, 11, 13, 10,  9,
      11, 15, 10, 11, 11, 12,  9,  8, 13, 15, 10, 10, 10, 11,  8,  7,
    },
    {
       0,  9,  3,  8,  5,  9,  7,  8,  5, 11,  6,  9,  8, 11,  8,  9,
      16, 16, 16, 16, 16, 16, 11, 10,  2, 10,  4,  9,  7, 10,  7,  8,
       7, 16,  7, 10,  9, 11,  8,  9, 16, 16, 11, 16, 16, 16, 11, 10,
       7, 16,  7, 10, 10, 16,  8,  9, 10, 16,  8, 10, 11, 16,  9,  9,
      16, 16, 16, 16, 16, 16, 11, 10,  3, 11,  6,  9,  6, 11,  8,  8,
       7, 16,  8, 10,  8, 11,  8,  9, 16, 16, 15, 16, 16, 16, 11, 10,
       5, 11,  7,  9,  8, 11,  8,  8,  7, 16,  7, 10,  8, 11,  8,  8,
      16, 16, 11, 16, 16, 16, 10,  9,  9, 16,  8, 11, 11, 16,  9,  9,
      10, 16,  8, 11, 11, 16,  9,  9, 16, 16, 10, 16, 16, 16, 10,  9,
       8, 16, 10, 11,  8, 16,  9,  9, 11, 16, 11, 16, 10, 16, 10,  9,
      16, 16, 16, 16, 16, 16, 11, 10,  9, 16, 10, 16, 10, 16,  9,  9,
      10, 16, 10, 16,  9, 16,  9,  9, 16, 16, 16, 16, 15, 16, 10,  9,
      16, 16, 11, 16, 16, 16, 10, 10, 13, 16, 11, 16, 11, 16, 10,  9,
      16, 16, 10, 11, 11, 16,  9,  8, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       1, 10,  6, 10,  7, 11,  9, 10,  8, 12,  9, 12,  9, 12, 10, 10,
      16, 16, 14, 16, 14, 15, 13, 12,  5, 12,  7, 10,  9, 11,  9, 10,
       9, 13,  9, 12, 10, 13, 10, 10, 16, 16, 14, 15, 14, 14, 13, 12,
      10, 15, 10, 12, 12, 14, 11, 11, 12, 16, 11, 13, 12, 14, 11, 11,
      16, 16, 14, 16, 15, 16, 13, 12,  6, 12,  8, 11,  8, 11, 10, 10,
       9, 13, 10, 12, 10, 12, 10, 10, 15, 16, 13, 15, 13, 14, 12, 12,
       7, 13,  9, 11,  9, 12, 10, 10,  9, 14, 10, 12, 10, 13, 10, 10,
      15, 16, 13, 15, 13, 14, 12, 11, 11, 15, 11, 13, 12, 14, 11, 11,
      12, 16, 11, 13, 12, 14, 11, 11, 16, 16, 13, 15, 14, 16, 12, 11,
      10, 16, 12, 14, 10, 13, 11, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      16, 16, 15, 16, 14, 16, 13, 12, 11, 16, 12, 14, 11, 14, 11, 11,
      12, 16, 12, 14, 11, 14, 11, 11, 16, 16, 14, 15, 13, 15, 12, 12,
      13, 16, 13, 15, 13, 15, 12, 12, 13, 16, 12, 15, 12, 15, 11, 11,
      16, 16, 13, 16, 13, 15, 12, 11,  4, 11,  7, 10,  7, 11,  9, 10,
       9, 13,  9, 12, 10, 12, 10, 10, 15, 16, 14, 15, 14, 15, 13, 12,
       6, 12,  7, 11,  9, 11,  9, 10,  9, 13,  9, 12, 10, 12, 10, 10,
      15, 16, 14, 15, 14, 15, 12, 12, 10, 15,  9, 12, 12, 13, 11, 11,
      12, 15, 11, 13, 12, 14, 11, 11, 16, 16, 13, 15, 14, 16, 12, 12,
       6, 12,  8, 11,  8, 11,  9, 10,  9, 14, 10, 12, 10, 12, 10, 10,
      14, 16, 13, 14, 13, 14, 12, 12,  8, 13,  9, 11,  9, 12, 10, 10,
       9, 13,  9, 12,  9, 12,  9, 10, 14, 16, 13, 14, 13, 14, 12, 11,
      11, 15, 11, 13, 11, 14, 11, 11, 12, 16, 10, 13, 12, 13, 11, 10,
      15, 16, 12, 15, 13, 16, 12, 11, 10, 15, 11, 13, 10, 13, 11, 11,
      12, 16, 12, 14, 11, 13, 11, 11, 16, 16, 14, 15, 13, 16, 13, 12,
      11, 16, 11, 14, 11, 13, 11, 11, 12, 16, 12, 14, 10, 13, 11, 11,
      15, 16, 13, 16, 12, 14, 12, 11, 12, 16, 12, 14, 12, 15, 11, 11,
      13, 16, 12, 14, 12, 14, 11, 11, 15, 16, 13, 15, 13, 15, 11, 10,
       7, 13,  9, 12, 10, 13, 11, 11, 11, 15, 12, 13, 12, 13, 11, 11,
      16, 16, 15, 16, 16, 16, 14, 13,  8, 13,  9, 12, 10, 13, 11, 11,
      12, 15, 11, 13, 12, 13, 11, 11, 16, 16, 14, 15, 15, 16, 13, 12,
      11, 16, 11, 13, 12, 14, 11, 11, 13, 16, 12, 14, 13, 15, 12, 11,
      16, 16, 14, 16, 15, 16, 13, 12,  9, 15, 10, 13, 10, 13, 11, 11,
      12, 15, 11, 13, 11, 13, 11, 11, 16, 16, 14, 16, 16, 16, 13, 12,
       9, 14, 10, 13, 10, 13, 11, 11, 11, 14, 11, 13, 11, 13, 11, 11,
      16, 16, 14, 16, 14, 16, 12, 12, 11, 16, 11, 14, 12, 14, 12, 11,
      12, 16, 11, 13, 13, 14, 11, 11, 16, 16, 13, 15, 14, 16, 12, 11,
      12, 16, 12, 14, 11, 14, 11, 11, 13, 16, 13, 14, 12, 15, 12, 11,
      16, 16, 16, 16, 14, 16, 13, 12, 12, 16, 12, 14, 11, 14, 12, 11,
      12, 16, 12, 15, 11, 14, 11, 11, 16, 16, 14, 16, 13, 15, 12, 12,
      13, 16, 13, 16, 13, 16, 12, 12, 13, 16, 12, 15, 12, 16, 11, 11,
      14, 16, 12, 15, 12, 15, 11, 10,  9, 16, 11, 14, 12, 14, 12, 12,
      13, 16, 13, 15, 14, 16, 12, 12, 16, 16, 16, 16, 16, 16, 14, 13,
      10, 16, 11, 14, 12, 14, 12, 12, 13, 16, 13, 14, 13, 16, 12, 12,
      16, 16, 15, 16, 16, 16, 13, 12, 11, 16, 11, 14, 12, 15, 12, 11,
      13, 16, 12, 14, 13, 16, 12, 11, 16, 16, 14, 16, 16, 16, 13, 12,
      11, 16, 11, 14, 12, 14, 12, 12, 13, 16, 12, 15, 13, 16, 12, 12,
      16, 16, 16, 16, 16, 16, 14, 13, 10, 16, 11, 14, 11, 15, 11, 11,
      13, 16, 12, 14, 12, 14, 12, 11, 16, 16, 14, 16, 16, 16, 13, 12,
      11, 16, 11, 15, 12, 15, 12, 11, 13, 16, 11, 14, 13, 15, 12, 11,
      16, 16, 13, 16, 14, 16, 12, 11, 12, 16, 12, 15, 11, 15, 12, 11,
      14, 16, 13, 15, 12, 16, 12, 11, 16, 16, 15, 16, 14, 16, 13, 12,
      11, 16, 12, 15, 11, 15, 11, 11, 13, 16, 13, 16, 11, 15, 11, 11,
      16, 16, 14, 16, 13, 15, 12, 11, 12, 16, 12, 15, 12, 16, 11, 11,
      12, 16, 11, 15, 12, 14, 11, 11, 13, 16, 12, 13, 11, 13, 10,  9,
    },
  },
  {
    {
       0, 13,  6, 13,  8, 14, 12, 16,  8, 16, 11, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 16,  7, 14, 11, 16, 13, 16,
       9, 16, 11, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 10, 16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  5, 16, 10, 16,  8, 16, 13, 16,
      10, 16, 12, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16, 11, 16, 13, 16, 10, 16, 12, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 12, 16, 16, 16, 16, 16,
      14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 16, 16, 11, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16,
      14, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 13,  7, 13,  8, 16, 12, 16,
       8, 16, 10, 16, 11, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       4, 16,  7, 14, 10, 16, 12, 16,  9, 16, 10, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 10, 16,  9, 16, 14, 16, 14, 16,
      13, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16,  9, 16,  8, 16, 12, 16,  9, 16, 11, 16, 11, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 16, 10, 16, 11, 16, 13, 16,
       9, 16, 11, 16, 11, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 12, 16, 16, 16, 14, 16, 13, 16, 12, 16, 16, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 13, 16, 11, 16, 14, 16,
      13, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 14, 16, 13, 16, 14, 16, 13, 16, 14, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       4, 16,  8, 16,  9, 16, 13, 16, 10, 16, 11, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16,  8, 16, 11, 16, 13, 16,
      10, 16, 11, 16, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16,  9, 16, 13, 16, 13, 16, 13, 16, 12, 16, 16, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 10, 16, 10, 16, 13, 16,
      10, 16, 12, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16, 11, 16, 13, 16, 10, 16, 11, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 11, 16, 16, 16, 14, 16,
      12, 16, 11, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 13, 16, 10, 16, 13, 16, 13, 16, 16, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 13, 16, 12, 16, 14, 16,
      12, 16, 15, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 10, 16, 10, 16, 13, 16,
      11, 16, 11, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16,  9, 16, 11, 16, 12, 16, 11, 16, 11, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16,  9, 16, 12, 16, 12, 16,
      13, 16, 11, 16, 13, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16, 10, 16, 12, 16, 11, 16, 12, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 10, 16, 11, 16, 12, 16,
      10, 16, 11, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 10, 14, 12, 16, 12, 16, 11, 16, 10, 14, 13, 16, 12, 14,
      16, 16, 14, 16, 16, 16, 14, 16,  9, 16, 12, 16, 10, 16, 12, 16,
      13, 16, 13, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 11, 16, 12, 16, 11, 16, 12, 16, 11, 16, 12, 15,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 12, 16, 13, 16, 12, 13,
      12, 16, 12, 16, 12, 16, 12, 13, 16, 16, 13, 14, 13, 16, 13, 13,
    },
    {
       0, 10,  5, 10,  5, 10,  8, 10,  6, 11,  8, 11,  8, 11,  9, 10,
      14, 16, 13, 14, 13, 14, 12, 12,  4, 12,  5, 10,  8, 12,  9, 10,
       7, 12,  8, 11,  9, 12,  9, 10, 14, 16, 12, 13, 13, 14, 12, 12,
       9, 16,  8, 12, 12, 14, 10, 11, 11, 16,  9, 12, 12, 14, 11, 11,
      14, 16, 12, 13, 14, 15, 12, 12,  4, 12,  7, 11,  6, 11,  9, 10,
       8, 12,  9, 11,  8, 11,  9, 10, 14, 16, 12, 14, 13, 14, 12, 12,
       7, 13,  8, 11,  8, 12,  9, 10,  8, 13,  8, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 12, 13, 11, 11, 11, 16, 10, 12, 12, 14, 11, 11,
      12, 16, 10, 12, 12, 14, 11, 11, 16, 16, 12, 13, 14, 15, 12, 11,
      10, 16, 11, 14,  9, 13, 10, 11, 11, 16, 12, 14, 10, 13, 11, 11,
      15, 16, 13, 14, 13, 14, 12, 12, 11, 16, 12, 14, 10, 13, 11, 11,
      12, 16, 12, 14, 11, 13, 11, 11, 15, 16, 13, 14, 13, 14, 12, 11,
      14, 16, 13, 14, 13, 15, 12, 12, 14, 16, 12, 14, 13, 15, 11, 11,
      16, 16, 13, 14, 14, 15, 12, 11,  3, 11,  5, 10,  6, 11,  9, 10,
       7, 12,  8, 11,  9, 11,  9, 10, 14, 16, 13, 13, 13, 14, 12, 12,
       5, 12,  6, 10,  8, 12,  9, 10,  8, 13,  8, 11,  9, 12,  9, 10,
      14, 16, 12, 13, 13, 14, 12, 12,  9, 16,  8, 11, 11, 14, 10, 11,
      11, 16,  9, 12, 12, 14, 10, 11, 15, 16, 12, 13, 14, 15, 12, 11,
       5, 12,  7, 11,  6, 11,  9, 10,  8, 13,  9, 11,  8, 11,  9, 10,
      14, 16, 12, 14, 13, 13, 12, 12,  7, 13,  8, 11,  8, 12,  9, 10,
       8, 12,  8, 11,  9, 12,  9, 10, 13, 16, 12, 13, 12, 13, 11, 11,
      10, 16,  9, 12, 12, 14, 10, 11, 11, 15,  9, 12, 12, 14, 10, 11,
      14, 16, 11, 13, 13, 14, 11, 11,  9, 16, 11, 14,  8, 13, 10, 11,
      11, 16, 12, 13, 10, 13, 10, 11, 16, 16, 13, 15, 13, 14, 12, 12,
      11, 16, 11, 14, 10, 13, 10, 11, 11, 16, 11, 13, 10, 13, 10, 11,
      14, 16, 13, 14, 12, 13, 11, 11, 14, 16, 12, 14, 13, 15, 11, 11,
      13, 16, 12, 13, 12, 14, 11, 11, 14, 16, 12, 13, 12, 13, 11, 10,
       6, 14,  8, 12,  9, 13, 10, 11, 10, 14, 10, 12, 11, 13, 11, 12,
      16, 16, 14, 14, 14, 14, 13, 12,  7, 14,  8, 12,  9, 13, 10, 11,
      10, 14, 10, 12, 11, 13, 11, 11, 16, 16, 13, 14, 14, 15, 13, 12,
      10, 16,  8, 12, 12, 14, 10, 11, 12, 16, 10, 12, 13, 15, 11, 11,
      16, 16, 13, 14, 15, 16, 12, 12,  8, 15,  9, 13,  9, 13, 10, 11,
      10, 15, 10, 13, 10, 13, 11, 11, 16, 16, 14, 14, 14, 14, 13, 12,
       8, 15,  9, 12, 10, 13, 10, 11, 10, 14, 10, 12, 10, 13, 10, 11,
      16, 16, 13, 14, 13, 14, 12, 12, 10, 16, 10, 13, 12, 15, 11, 11,
      11, 16,  9, 12, 12, 14, 11, 11, 14, 16, 11, 13, 14, 16, 12, 11,
      10, 16, 12, 14,  9, 13, 11, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      16, 16, 15, 16, 14, 14, 13, 12, 11, 16, 12, 14, 11, 14, 11, 11,
      11, 16, 12, 14, 10, 13, 11, 11, 15, 16, 13, 15, 12, 14, 12, 11,
      14, 16, 13, 14, 13, 16, 12, 12, 12, 16, 12, 13, 12, 14, 11, 11,
      14, 16, 11, 12, 12, 13, 10, 10,  9, 16, 10, 14, 11, 15, 12, 12,
      12, 16, 11, 13, 12, 15, 12, 12, 16, 16, 14, 13, 15, 15, 13, 12,
      10, 16, 10, 14, 11, 15, 11, 12, 12, 16, 11, 13, 12, 14, 12, 12,
      16, 16, 14, 13, 15, 14, 13, 12, 11, 16,  9, 12, 12, 14, 11, 11,
      13, 16, 11, 13, 13, 15, 11, 11, 16, 16, 14, 14, 16, 16, 12, 12,
      10, 16, 10, 14, 11, 14, 11, 12, 12, 16, 11, 13, 12, 14, 12, 12,
      16, 16, 14, 14, 15, 15, 13, 12, 10, 16, 10, 13, 11, 14, 11, 12,
      11, 16, 11, 13, 11, 14, 11, 12, 16, 16, 14, 14, 14, 14, 13, 12,
      11, 16, 10, 12, 12, 15, 11, 11, 12, 16,  9, 12, 12, 14, 10, 11,
      16, 16, 12, 13, 14, 15, 11, 11, 11, 16, 12, 14, 10, 14, 11, 11,
      13, 16, 12, 14, 12, 14, 11, 11, 16, 16, 15, 15, 14, 15, 12, 12,
      11, 16, 12, 14, 11, 14, 11, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      16, 16, 14, 14, 13, 14, 12, 11, 12, 16, 11, 13, 12, 14, 10, 10,
      12, 15, 11, 12, 12, 13, 10, 10, 14, 15, 11, 11, 12, 12, 10,  9,
    },
    {
       0,  8,  3,  8,  5,  9,  7,  8,  5, 10,  6, 10,  8, 11,  8,  9,
      16, 16, 15, 16, 16, 16, 11, 11,  2, 10,  4,  9,  7, 10,  7,  8,
       7, 16,  7, 10,  9, 11,  8,  9, 16, 16, 15, 16, 16, 16, 11, 11,
       7, 16,  6, 11, 10, 16,  9, 10, 10, 16,  9, 11, 11, 16,  9, 10,
      16, 16, 16, 16, 16, 16, 16, 11,  3, 10,  6,  9,  5, 10,  7,  9,
       7, 16,  8, 10,  8, 11,  8,  9, 16, 16, 16, 16, 16, 16, 11, 11,
       5, 11,  7, 10,  8, 11,  8,  9,  7, 14,  7, 10,  8, 11,  8,  9,
      16, 16, 11, 16, 16, 16, 10, 11,  9, 16,  9, 11, 11, 16,  9, 10,
      10, 16,  8, 11, 11, 16,  9, 10, 16, 16, 11, 16, 16, 16, 11, 10,
       8, 16,  9, 16,  7, 16,  9, 10, 11, 16, 11, 16, 10, 16, 10, 10,
      16, 16, 16, 16, 16, 16, 16, 11,  9, 16, 10, 16,  9, 16,  9, 10,
      10, 16, 10, 16,  9, 16,  9, 10, 16, 16, 16, 16, 11, 16, 11, 11,
      16, 16, 16, 16, 16, 16, 10, 10, 11, 16, 11, 16, 11, 16, 10, 10,
      16, 16, 11, 16, 11, 16, 10,  9, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       1, 10,  6, 10,  7, 11,  9, 10,  8, 12,  9, 12,  9, 12, 10, 10,
      15, 16, 14, 15, 14, 16, 13, 12,  5, 12,  7, 11,  8, 11,  9, 10,
       9, 13,  9, 12, 10, 12, 10, 10, 16, 16, 14, 15, 13, 16, 13, 12,
      10, 15, 10, 13, 12, 14, 11, 11, 12, 16, 11, 13, 12, 14, 11, 11,
      16, 16, 14, 16, 14, 16, 13, 12,  5, 12,  8, 11,  7, 11,  9, 10,
       9, 13, 10, 12,  9, 12, 10, 10, 14, 16, 14, 15, 13, 14, 13, 12,
       7, 13,  9, 12,  9, 12, 10, 10,  9, 13,  9, 12,  9, 12, 10, 10,
      14, 16, 13, 14, 13, 15, 12, 12, 11, 16, 11, 13, 12, 14, 11, 11,
      12, 16, 11, 14, 12, 14, 11, 11, 16, 16, 14, 16, 14, 16, 13, 12,
      10, 16, 11, 14, 10, 13, 11, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      15, 16, 15, 16, 14, 16, 13, 12, 11, 16, 12, 14, 11, 14, 11, 12,
      12, 16, 12, 14, 11, 14, 11, 11, 15, 16, 14, 16, 13, 16, 13, 12,
      13, 16, 13, 16, 13, 16, 12, 12, 13, 16, 13, 16, 13, 16, 12, 12,
      16, 16, 14, 15, 14, 16, 13, 12,  4, 11,  7, 10,  7, 11,  9, 10,
       9, 13,  9, 11,  9, 12, 10, 10, 15, 16, 14, 15, 14, 15, 13, 12,
       6, 12,  7, 11,  8, 11,  9, 10,  9, 13,  9, 12, 10, 12, 10, 10,
      15, 16, 13, 14, 14, 15, 12, 12, 10, 14, 10, 12, 12, 13, 11, 11,
      12, 16, 11, 13, 12, 14, 11, 11, 16, 16, 14, 15, 15, 16, 13, 12,
       6, 12,  8, 11,  8, 11,  9, 10,  9, 13, 10, 12,  9, 12, 10, 10,
      16, 16, 14, 15, 13, 14, 12, 12,  8, 13,  9, 11,  9, 12,  9, 10,
       9, 13,  9, 12,  9, 12,  9, 10, 14, 16, 13, 14, 13, 14, 12, 11,
      11, 15, 11, 13, 12, 14, 11, 11, 11, 16, 10, 13, 12, 14, 11, 11,
      15, 16, 13, 15, 14, 16, 12, 11, 10, 16, 12, 13, 10, 13, 11, 11,
      11, 16, 12, 14, 10, 13, 11, 11, 16, 16, 14, 16, 13, 16, 13, 12,
      11, 16, 12, 14, 10, 14, 11, 11, 11, 16, 12, 14, 10, 13, 11, 11,
      16, 16, 14, 16, 12, 15, 12, 11, 13, 16, 13, 15, 13, 15, 12, 12,
      13, 16, 12, 15, 12, 15, 12, 11, 15, 16, 13, 16, 13, 16, 12, 11,
       8, 14,  9, 12, 10, 13, 11, 11, 11, 16, 11, 13, 11, 13, 11, 11,
      16, 16, 16, 16, 16, 16, 14, 13,  9, 14, 10, 12, 10, 13, 11, 11,
      11, 16, 11, 13, 12, 13, 11, 11, 16, 16, 15, 16, 15, 16, 14, 12,
      11, 16, 11, 13, 12, 14, 12, 11, 13, 16, 12, 14, 13, 14, 12, 11,
      16, 16, 15, 16, 16, 16, 14, 13,  9, 14, 10, 13, 10, 13, 11, 11,
      11, 16, 11, 13, 11, 13, 11, 11, 16, 16, 15, 16, 14, 15, 14, 13,
       9, 14, 10, 13, 10, 13, 11, 11, 11, 15, 11, 13, 11, 13, 11, 11,
      16, 16, 14, 16, 14, 16, 13, 12, 12, 16, 12, 14, 13, 14, 12, 11,
      12, 16, 11, 14, 12, 15, 12, 11, 16, 16, 13, 16, 15, 16, 13, 11,
      11, 16, 12, 14, 11, 14, 12, 11, 13, 16, 13, 15, 12, 14, 12, 12,
      16, 16, 16, 16, 14, 16, 14, 13, 12, 16, 13, 15, 11, 14, 12, 12,
      12, 16, 13, 14, 11, 15, 12, 11, 16, 16, 15, 16, 13, 15, 13, 12,
      13, 16, 13, 15, 13, 16, 12, 12, 13, 16, 13, 15, 13, 15, 12, 12,
      15, 16, 13, 16, 13, 15, 11, 10, 10, 16, 12, 14, 12, 15, 12, 12,
      14, 16, 13, 15, 13, 16, 13, 12, 16, 16, 16, 16, 16, 16, 15, 13,
      10, 16, 12, 14, 12, 15, 12, 12, 13, 16, 13, 15, 13, 15, 13, 12,
      16, 16, 16, 16, 16, 16, 14, 13, 11, 16, 12, 15, 13, 16, 12, 12,
      14, 16, 13, 16, 13, 16, 12, 12, 16, 16, 15, 16, 15, 16, 14, 12,
      11, 16, 12, 14, 12, 16, 12, 12, 14, 16, 13, 15, 13, 15, 13, 12,
      16, 16, 16, 16, 16, 16, 15, 13, 11, 16, 12, 14, 12, 15, 12, 12,
      13, 16, 12, 14, 12, 15, 12, 12, 16, 16, 16, 16, 16, 16, 14, 12,
      12, 16, 12, 15, 13, 16, 12, 12, 13, 16, 12, 15, 13, 15, 12, 11,
      16, 16, 14, 16, 15, 16, 13, 12, 12, 16, 13, 16, 12, 16, 12, 12,
      15, 16, 14, 16, 13, 16, 12, 12, 16, 16, 16, 16, 16, 16, 14, 13,
      12, 16, 13, 15, 12, 16, 12, 12, 13, 16, 13, 15, 12, 15, 12, 12,
      16, 16, 15, 16, 14, 16, 13, 12, 13, 16, 13, 16, 12, 16, 12, 12,
      13, 16, 12, 16, 12, 15, 12, 12, 14, 16, 12, 14, 12, 14, 11, 10,
    },
  },
  {
    {
       0, 16,  6, 16,  8, 16, 16, 16,  9, 16, 11, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 16,  7, 16, 11, 16, 16, 16,
      10, 16, 11, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 10, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  5, 16, 10, 16,  9, 16, 16, 16,
      10, 16, 13, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 11, 16, 12, 16, 16, 16, 10, 16, 12, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 16,  7, 16,  8, 16, 13, 16,
       9, 16, 11, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       4, 16,  7, 16, 11, 16, 13, 16,  9, 16, 11, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16,  9, 16, 16, 16, 16, 16,
      13, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       4, 16, 10, 16,  8, 16, 16, 16, 10, 16, 12, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 16, 10, 16, 11, 16, 16, 16,
       9, 16, 11, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 12, 16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       4, 16,  8, 16, 10, 16, 16, 16, 10, 16, 11, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16,  8, 16, 11, 16, 16, 16,
      10, 16, 12, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16,  9, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 10, 16, 10, 16, 16, 16,
      11, 16, 12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 11, 16, 11, 16, 16, 16, 10, 16, 12, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 12, 16, 16, 16, 16, 16,
      12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 12, 16, 16, 16,
      12, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 10, 16, 11, 16, 16, 16,
      11, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16,  9, 16, 11, 16, 13, 16, 11, 16, 12, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16,  9, 16, 13, 16, 12, 16,
      13, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16, 10, 16, 14, 16, 12, 16, 12, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 11, 16, 11, 16, 13, 16,
      10, 16, 12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 10, 16, 13, 16, 12, 16, 12, 16, 11, 16, 16, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 12, 16, 10, 16, 13, 16,
      16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 13, 16, 11, 16, 13, 16, 12, 16, 13, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 13, 16, 16, 16, 12, 16,
      13, 16, 12, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       0, 10,  4, 10,  5, 11,  9, 11,  6, 11,  8, 11,  8, 12, 10, 12,
      15, 16, 13, 15, 14, 15, 13, 14,  4, 12,  5, 11,  8, 12,  9, 11,
       7, 13,  8, 12,  9, 13, 10, 12, 15, 16, 13, 15, 14, 16, 13, 14,
      10, 16,  9, 13, 12, 16, 11, 13, 11, 16, 10, 14, 13, 16, 12, 13,
      16, 16, 14, 16, 15, 16, 14, 15,  4, 12,  7, 12,  6, 12,  9, 11,
       8, 13,  9, 12,  9, 12, 10, 12, 15, 16, 13, 15, 14, 15, 13, 14,
       7, 13,  8, 12,  9, 13, 10, 12,  8, 13,  9, 12,  9, 13, 10, 12,
      14, 16, 13, 15, 13, 15, 13, 14, 12, 16, 11, 14, 13, 16, 12, 13,
      12, 16, 11, 14, 13, 16, 12, 13, 16, 16, 14, 16, 15, 16, 14, 15,
      10, 16, 12, 16, 10, 14, 12, 13, 12, 16, 13, 16, 11, 14, 12, 13,
      16, 16, 16, 16, 15, 16, 14, 15, 12, 16, 13, 16, 11, 15, 12, 13,
      13, 16, 13, 16, 12, 15, 12, 14, 16, 16, 16, 16, 14, 16, 13, 14,
      16, 16, 14, 16, 14, 16, 13, 15, 16, 16, 14, 16, 14, 16, 13, 15,
      16, 16, 16, 16, 16, 16, 14, 16,  2, 11,  5, 11,  6, 11,  9, 11,
       7, 12,  8, 11,  9, 12, 10, 12, 15, 16, 14, 14, 14, 14, 13, 14,
       4, 13,  6, 11,  8, 12,  9, 11,  8, 13,  8, 12, 10, 13, 10, 12,
      15, 16, 13, 15, 14, 15, 13, 14,  9, 16,  8, 13, 12, 15, 11, 12,
      11, 16, 10, 14, 13, 16, 12, 13, 16, 16, 14, 16, 16, 16, 14, 15,
       5, 13,  8, 12,  7, 12,  9, 11,  8, 13,  9, 12,  9, 12, 10, 12,
      16, 16, 14, 15, 14, 15, 13, 13,  7, 13,  8, 12,  9, 13, 10, 12,
       8, 13,  8, 12,  9, 13, 10, 12, 14, 16, 13, 14, 13, 15, 12, 13,
      11, 16, 10, 14, 13, 16, 12, 13, 11, 16, 10, 13, 12, 15, 11, 13,
      14, 16, 12, 14, 14, 16, 13, 14, 10, 16, 12, 15,  9, 14, 11, 13,
      12, 16, 12, 16, 11, 14, 12, 13, 16, 16, 15, 16, 16, 16, 14, 15,
      11, 16, 12, 15, 11, 15, 12, 13, 12, 16, 12, 15, 11, 14, 12, 13,
      16, 16, 14, 16, 13, 15, 13, 14, 15, 16, 14, 16, 14, 16, 13, 14,
      14, 16, 13, 16, 14, 16, 13, 14, 16, 16, 14, 16, 14, 16, 13, 14,
       7, 15,  8, 13,  9, 14, 11, 13, 10, 14, 10, 13, 11, 14, 12, 13,
      16, 16, 15, 16, 15, 16, 15, 14,  7, 16,  8, 13, 10, 14, 11, 13,
      11, 15, 10, 13, 12, 14, 12, 13, 16, 16, 16, 16, 16, 16, 15, 15,
      10, 16,  9, 13, 13, 16, 12, 13, 13, 16, 11, 14, 14, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 16,  8, 16, 10, 14,  9, 14, 11, 13,
      11, 16, 11, 14, 11, 14, 12, 13, 16, 16, 16, 16, 16, 16, 14, 15,
       8, 16, 10, 14, 10, 14, 11, 13, 10, 15, 10, 14, 11, 14, 12, 13,
      16, 16, 14, 16, 15, 16, 14, 14, 11, 16, 10, 14, 13, 16, 12, 13,
      11, 16, 10, 13, 13, 16, 12, 13, 16, 16, 13, 16, 16, 16, 14, 14,
      11, 16, 12, 16, 10, 15, 12, 13, 14, 16, 14, 16, 12, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 13, 16, 11, 16, 12, 14,
      12, 16, 13, 16, 11, 14, 12, 13, 16, 16, 16, 16, 14, 16, 14, 14,
      15, 16, 14, 16, 16, 16, 13, 14, 13, 16, 13, 15, 14, 16, 13, 14,
      14, 16, 13, 14, 14, 15, 13, 14,  9, 16, 11, 16, 12, 16, 13, 14,
      12, 16, 12, 15, 13, 16, 13, 14, 16, 16, 16, 15, 16, 16, 15, 15,
      10, 16, 10, 16, 12, 16, 12, 14, 12, 16, 12, 14, 13, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 15, 11, 16, 10, 14, 14, 16, 12, 13,
      14, 16, 12, 16, 14, 16, 13, 14, 16, 16, 16, 16, 16, 16, 16, 15,
      10, 16, 12, 16, 11, 16, 12, 14, 13, 16, 12, 15, 13, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 16, 15, 10, 16, 11, 16, 12, 16, 12, 14,
      12, 16, 12, 15, 13, 16, 13, 14, 16, 16, 16, 16, 16, 16, 14, 14,
      11, 16, 10, 14, 14, 16, 12, 13, 13, 16, 11, 14, 14, 16, 12, 13,
      16, 16, 15, 16, 16, 16, 14, 14, 12, 16, 13, 16, 11, 16, 12, 14,
      15, 16, 14, 16, 13, 16, 13, 14, 16, 16, 16, 16, 16, 16, 14, 16,
      12, 16, 13, 16, 12, 16, 12, 14, 13, 16, 13, 16, 12, 16, 12, 13,
      16, 16, 16, 16, 16, 16, 14, 15, 13, 16, 13, 16, 14, 16, 12, 13,
      13, 16, 13, 14, 14, 16, 12, 13, 16, 16, 14, 14, 14, 15, 13, 13,
    },
    {
       0,  9,  3,  9,  5,  9,  7,  9,  5, 10,  7, 11,  8, 11,  9, 10,
      16, 16, 16, 16, 16, 16, 16, 16,  2, 11,  4, 10,  7, 11,  8, 10,
       7, 16,  7, 11,  9, 16,  9, 11, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16,  7, 16, 11, 16, 10, 11, 11, 16, 10, 16, 16, 16, 11, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  2, 11,  6, 10,  6, 10,  8, 10,
       7, 16,  8, 16,  8, 11,  9, 11, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 13,  7, 11,  8, 11,  9, 11,  6, 12,  8, 12,  8, 12,  9, 11,
      16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 10, 16, 12, 16, 10, 13,
      10, 16,  9, 16, 11, 16, 11, 12, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16,  8, 16, 10, 12, 11, 16, 12, 16, 10, 16, 11, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 11, 16, 10, 16, 11, 16,
      11, 16, 12, 16, 10, 16, 11, 12, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       1, 10,  5, 10,  6, 10,  9, 10,  7, 12,  9, 12,  9, 12, 10, 10,
      16, 16, 15, 16, 14, 16, 13, 13,  5, 12,  7, 11,  8, 11,  9, 10,
       8, 13,  9, 12, 10, 12, 10, 11, 16, 16, 16, 16, 14, 16, 13, 12,
      10, 16, 10, 13, 12, 14, 12, 12, 12, 16, 11, 14, 13, 15, 12, 12,
      16, 16, 16, 15, 16, 16, 14, 13,  5, 12,  8, 11,  7, 11,  9, 10,
       8, 13, 10, 12,  9, 12, 10, 10, 15, 16, 14, 15, 14, 14, 13, 13,
       7, 13,  9, 12,  9, 12, 10, 10,  9, 13, 10, 13, 10, 13, 10, 10,
      14, 16, 14, 15, 14, 16, 13, 12, 11, 16, 12, 14, 12, 15, 12, 12,
      12, 16, 12, 15, 13, 16, 12, 12, 16, 16, 15, 16, 16, 16, 14, 13,
      10, 16, 12, 14, 10, 14, 12, 12, 12, 16, 13, 14, 11, 14, 12, 12,
      16, 16, 16, 16, 14, 16, 14, 13, 11, 16, 12, 14, 11, 14, 12, 12,
      12, 16, 13, 16, 11, 15, 12, 12, 16, 16, 16, 16, 14, 16, 14, 13,
      13, 16, 14, 16, 14, 16, 13, 13, 13, 16, 13, 16, 13, 16, 13, 12,
      16, 16, 16, 16, 16, 16, 13, 13,  4, 11,  7, 10,  7, 11,  9, 10,
       8, 12,  9, 12,  9, 12, 10, 11, 15, 16, 14, 15, 14, 16, 13, 13,
       6, 12,  7, 11,  8, 11,  9, 10,  9, 13,  9, 12, 10, 12, 10, 10,
      16, 16, 15, 16, 15, 16, 13, 12, 10, 16, 10, 13, 12, 14, 12, 11,
      12, 16, 11, 14, 13, 14, 12, 12, 16, 16, 16, 14, 16, 16, 14, 13,
       6, 12,  8, 11,  7, 11,  9, 10,  9, 14, 10, 12,  9, 12, 10, 10,
      15, 16, 14, 16, 14, 16, 14, 13,  7, 13,  9, 12,  9, 12, 10, 10,
       9, 13,  9, 12,  9, 12, 10, 10, 14, 16, 13, 14, 14, 16, 12, 11,
      11, 16, 11, 14, 12, 14, 12, 12, 12, 16, 11, 14, 12, 14, 12, 11,
      16, 16, 13, 16, 14, 16, 13, 12, 10, 16, 12, 14, 10, 14, 11, 11,
      12, 16, 13, 14, 11, 14, 12, 12, 16, 16, 16, 16, 14, 16, 13, 13,
      11, 16, 12, 16, 11, 14, 12, 12, 12, 16, 12, 14, 11, 14, 12, 11,
      16, 16, 15, 16, 13, 15, 13, 12, 13, 16, 14, 16, 13, 16, 13, 12,
      13, 16, 13, 16, 13, 16, 13, 12, 16, 16, 14, 16, 14, 16, 12, 11,
       8, 13, 10, 12, 10, 13, 11, 11, 11, 14, 12, 14, 12, 14, 12, 12,
      16, 16, 16, 16, 16, 16, 14, 13,  9, 14, 10, 13, 10, 13, 11, 11,
      12, 16, 12, 13, 12, 13, 12, 11, 16, 16, 16, 16, 16, 16, 15, 14,
      12, 16, 11, 14, 13, 15, 12, 12, 13, 16, 12, 15, 14, 15, 13, 12,
      16, 16, 16, 16, 16, 16, 15, 13,  9, 14, 11, 13, 10, 13, 11, 11,
      11, 16, 12, 14, 12, 14, 12, 12, 16, 16, 16, 16, 16, 16, 16, 13,
      10, 15, 11, 13, 11, 14, 12, 11, 11, 16, 12, 14, 11, 14, 12, 11,
      16, 16, 16, 16, 16, 16, 14, 12, 12, 16, 12, 14, 13, 15, 13, 12,
      12, 16, 12, 14, 13, 15, 12, 12, 16, 16, 14, 16, 16, 16, 14, 12,
      12, 16, 13, 16, 11, 14, 12, 12, 14, 16, 14, 16, 12, 16, 13, 12,
      16, 16, 16, 16, 16, 16, 16, 13, 12, 16, 13, 16, 12, 16, 13, 12,
      12, 16, 13, 16, 12, 16, 12, 12, 16, 16, 16, 16, 14, 16, 14, 12,
      14, 16, 14, 16, 14, 16, 14, 13, 13, 16, 13, 16, 13, 16, 13, 12,
      16, 16, 13, 16, 13, 16, 12, 11,  9, 16, 12, 15, 13, 16, 13, 12,
      13, 16, 14, 16, 14, 16, 14, 13, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 16, 12, 15, 12, 15, 13, 12, 13, 16, 14, 16, 13, 16, 13, 12,
      16, 16, 16, 16, 16, 16, 16, 13, 12, 16, 12, 16, 13, 16, 13, 12,
      14, 16, 13, 16, 14, 16, 13, 12, 16, 16, 16, 16, 16, 16, 16, 13,
      11, 16, 12, 15, 12, 16, 13, 12, 14, 16, 14, 16, 13, 16, 13, 13,
      16, 16, 16, 16, 16, 16, 15, 13, 11, 16, 12, 16, 12, 16, 13, 12,
      13, 16, 13, 15, 13, 16, 13, 12, 16, 16, 16, 16, 16, 16, 15, 13,
      12, 16, 12, 16, 13, 16, 13, 12, 13, 16, 12, 16, 13, 16, 13, 12,
      16, 16, 14, 16, 16, 16, 14, 12, 12, 16, 14, 16, 11, 16, 13, 12,
      14, 16, 14, 16, 13, 16, 13, 12, 16, 16, 16, 16, 16, 16, 16, 13,
      12, 16, 13, 16, 12, 16, 13, 12, 13, 16, 13, 16, 12, 16, 13, 12,
      16, 16, 16, 16, 14, 16, 14, 12, 13, 16, 13, 16, 13, 16, 13, 13,
      13, 16, 12, 16, 12, 16, 12, 12, 14, 16, 13, 15, 13, 16, 12, 11,
    },
  },
};


static const uint8_t rv34_table_intra_secondpat[NUM_INTRA_TABLES][2][OTHERBLK_VLC_SIZE] = {
  {
    {
       0,  5, 10,  3,  6, 10,  7,  8,  9,  4,  6, 10,  6,  7,  9,  8,
       8,  9,  8,  8,  9,  8,  9,  9,  9,  9,  8,  3,  6, 10,  4,  6,
      10,  7,  7,  9,  5,  7, 10,  6,  7,  9,  7,  7,  8,  7,  8,  9,
       8,  8,  9,  8,  8,  7,  6,  8, 10,  6,  8, 10,  7,  8,  9,  7,
       8, 10,  7,  8, 10,  8,  8,  8,  8,  9,  9,  8,  8,  9,  9,  8,
       7,  7,  8,  9,  7,  8,  9,  7,  7,  7,  8,  8,  9,  7,  8,  9,
       7,  7,  7,  8,  8,  8,  7,  7,  7,  7,  6,  5,
    },
    {
       0,  5, 11,  3,  6, 11,  8,  9, 11,  3,  6, 10,  6,  7, 11,  9,
       9, 11,  7,  9, 11,  9,  9, 11, 10, 10, 11,  2,  6, 10,  4,  7,
      10,  7,  9, 11,  4,  7, 11,  6,  7, 10,  9,  9, 11,  7,  9, 11,
       8,  9, 10, 10, 10, 10,  5,  8, 11,  6,  8, 11,  8,  9, 11,  6,
       8, 11,  7,  8, 11,  9,  9, 11,  8, 10, 11,  9,  9, 11, 10, 10,
      10,  8,  9, 11,  8,  9, 11,  9,  9, 10,  8,  9, 11,  8,  9, 11,
       9,  9, 10,  8,  9, 10,  9,  9, 10,  9,  9,  8,
    },
  },
  {
    {
       0,  5, 10,  4,  6, 10,  7,  8, 10,  4,  6, 10,  6,  7,  9,  8,
       8,  9,  8,  8,  9,  8,  9,  9,  9,  9,  9,  2,  6, 10,  4,  6,
      10,  7,  7,  9,  5,  7, 10,  6,  7,  9,  7,  7,  9,  7,  8,  9,
       8,  8,  9,  9,  8,  8,  6,  8, 10,  6,  8, 10,  7,  8,  9,  6,
       8, 10,  7,  8, 10,  8,  8,  9,  8,  9, 10,  8,  8,  9,  9,  9,
       8,  8,  8, 10,  7,  8,  9,  7,  8,  8,  7,  8, 10,  7,  8,  9,
       7,  7,  8,  8,  8,  9,  8,  8,  8,  7,  7,  6,
    },
    {
       0,  5, 12,  4,  7, 12,  8, 10, 13,  4,  7, 12,  6,  8, 12, 10,
      10, 12,  8,  9, 12, 10, 10, 12, 12, 12, 12,  1,  6, 12,  4,  7,
      12,  8,  9, 12,  4,  7, 12,  6,  8, 11,  9, 10, 12,  8,  9, 12,
       9, 10, 11, 11, 11, 12,  6,  8, 12,  7,  9, 12,  9, 10, 13,  6,
       9, 12,  8,  9, 12, 10, 10, 12,  9, 10, 12, 10, 10, 12, 12, 12,
      12,  8, 10, 12,  9, 10, 12, 10, 10, 12,  8, 10, 12,  9, 10, 12,
      10, 10, 11,  9, 10, 12, 10, 10, 11, 11, 10, 10,
    },
  },
  {
    {
       0,  5, 10,  3,  6, 10,  7,  8, 11,  4,  6, 10,  6,  7, 10,  8,
       9, 10,  8,  8, 10,  9,  9, 10, 10, 10, 10,  2,  6, 10,  4,  6,
      10,  7,  8, 10,  4,  7, 10,  6,  7, 10,  8,  8, 10,  7,  8, 10,
       8,  8,  9, 10,  9,  9,  5,  8, 11,  6,  8, 10,  7,  9, 10,  6,
       8, 11,  7,  8, 10,  8,  8, 10,  8,  9, 11,  9,  9, 10, 10,  9,
       9,  8,  9, 10,  8,  9, 10,  8,  9, 10,  8,  9, 10,  8,  8, 10,
       8,  8,  9,  8,  9, 10,  8,  8,  9,  9,  8,  8,
    },
    {
       0,  6, 13,  4,  7, 14,  9, 11, 14,  3,  7, 13,  7,  8, 13, 11,
      11, 14,  8, 10, 13, 10, 11, 13, 13, 13, 14,  1,  6, 12,  4,  8,
      13,  9, 10, 15,  4,  8, 13,  7,  8, 12, 11, 11, 14,  8, 10, 13,
      10, 10, 13, 13, 13, 14,  5,  9, 13,  7,  9, 13, 10, 11, 14,  6,
      10, 14,  8, 10, 14, 11, 11, 14,  9, 11, 14, 11, 11, 13, 13, 13,
      14,  9, 10, 14,  9, 11, 13, 11, 12, 14,  9, 11, 13,  9, 11, 14,
      11, 12, 13, 10, 12, 15, 11, 11, 13, 13, 12, 13,
    },
  },
  {
    {
       0,  5, 11,  3,  6, 11,  7,  9, 12,  3,  6, 11,  6,  7, 11,  9,
       9, 11,  8,  9, 11,  9,  9, 11, 11, 11, 12,  2,  6, 11,  4,  6,
      11,  7,  9, 11,  4,  7, 11,  5,  7, 10,  9,  9, 11,  7,  8, 11,
       9,  9, 10, 11, 11, 11,  5,  8, 11,  6,  8, 11,  8,  9, 12,  6,
       8, 11,  7,  8, 11,  9,  9, 11,  8,  9, 12,  9,  9, 11, 11, 11,
      11,  8, 10, 12,  8, 10, 11,  9, 10, 12,  8, 10, 12,  8,  9, 12,
      10, 10, 12,  9, 10, 12,  9,  9, 11, 11, 10, 11,
    },
    {
       0,  6, 13,  3,  8, 14, 10, 12, 16,  3,  8, 15,  7,  9, 15, 12,
      13, 15,  9, 11, 15, 11, 12, 16, 14, 16, 16,  1,  7, 13,  4,  8,
      14,  9, 11, 15,  4,  8, 14,  7,  9, 14, 12, 13, 15,  8, 10, 14,
      11, 11, 14, 16, 14, 16,  6,  9, 14,  7, 10, 14, 11, 13, 15,  7,
      10, 14,  9, 10, 13, 12, 12, 15, 10, 11, 14, 11, 11, 14, 14, 14,
      16,  9, 11, 14, 10, 11, 14, 13, 14, 15,  9, 12, 14, 10, 12, 16,
      13, 14, 16, 10, 13, 16, 12, 12, 14, 15, 14, 15,
    },
  },
  {
    {
       0,  6, 12,  3,  7, 12,  9, 11, 13,  4,  7, 12,  6,  8, 12, 10,
      11, 13,  8, 10, 13, 10, 11, 13, 13, 13, 14,  1,  6, 12,  4,  7,
      12,  9, 10, 14,  4,  7, 12,  6,  7, 12, 10, 11, 13,  8,  9, 13,
      10, 10, 12, 13, 13, 14,  6,  9, 13,  7,  9, 13, 10, 12, 14,  7,
       9, 13,  8, 10, 13, 11, 11, 14,  9, 11, 13, 11, 11, 14, 13, 13,
      14, 10, 12, 14, 10, 12, 14, 12, 13, 15, 10, 12, 14, 10, 12, 14,
      12, 13, 15, 11, 13, 15, 12, 12, 15, 14, 14, 14,
    },
    {
       0,  6, 16,  3,  8, 16, 10, 13, 16,  3,  8, 16,  7,  9, 16, 13,
      16, 16,  8, 10, 16, 11, 13, 16, 16, 16, 16,  1,  7, 14,  4,  8,
      16, 10, 12, 16,  4,  8, 13,  7,  9, 16, 13, 14, 16,  8, 10, 16,
      11, 11, 14, 16, 16, 16,  6,  9, 14,  8, 10, 14, 12, 16, 16,  6,
      10, 13,  9, 11, 16, 13, 14, 16,  9, 12, 16, 12, 11, 16, 16, 16,
      16, 10, 12, 16, 11, 12, 16, 16, 14, 16,  9, 12, 16, 11, 12, 16,
      16, 15, 16, 10, 13, 16, 12, 13, 16, 16, 16, 16,
    },
  },
};

static const uint8_t rv34_table_intra_thirdpat[NUM_INTRA_TABLES][2][OTHERBLK_VLC_SIZE] = {
  {
    {
       0,  5, 10,  3,  6, 10,  7,  8, 10,  4,  7, 10,  6,  7, 10,  8,
       8, 10,  8,  9, 10,  9,  9, 10,  9,  9,  9,  2,  6, 10,  4,  7,
      10,  7,  8,  9,  5,  7, 10,  6,  7, 10,  8,  8,  9,  8,  9, 10,
       8,  8,  9,  9,  9,  8,  6,  8, 11,  6,  8, 10,  7,  8, 10,  6,
       8, 11,  7,  8, 10,  8,  8,  9,  8,  9, 10,  9,  9, 10,  9,  9,
       9,  7,  8, 10,  7,  8, 10,  7,  8,  8,  7,  8, 10,  7,  8,  9,
       7,  8,  8,  8,  8,  9,  8,  8,  8,  7,  7,  7,
    },
    {
       0,  4, 10,  3,  6, 10,  7,  8, 11,  3,  6, 10,  5,  7, 10,  9,
       9, 11,  9, 10, 11,  9, 10, 11, 11, 11, 11,  2,  6, 10,  4,  6,
      10,  7,  8, 10,  4,  7, 10,  6,  7, 10,  8,  9, 10,  8,  9, 11,
       9,  9, 11, 10, 10, 11,  6,  8, 11,  6,  8, 11,  8,  9, 11,  7,
       9, 11,  7,  8, 11,  9,  9, 11,  9, 10, 12, 10, 10, 12, 11, 11,
      11,  8,  9, 11,  8,  9, 11,  9,  9, 11,  9, 10, 11,  9, 10, 11,
       9, 10, 11, 10, 11, 12, 10, 10, 12, 10, 10, 10,
    },
  },
  {
    {
       0,  5, 10,  3,  6, 10,  7,  8, 10,  4,  7, 10,  6,  7, 10,  8,
       9, 10,  8,  9, 11,  8,  9, 10, 10, 10, 10,  2,  6, 10,  4,  6,
      10,  7,  8, 10,  4,  7, 10,  5,  7, 10,  8,  8, 10,  8,  9, 10,
       8,  9, 10,  9,  9,  9,  5,  7, 11,  6,  8, 11,  7,  8, 11,  6,
       8, 11,  7,  8, 10,  8,  9, 10,  8,  9, 11,  9,  9, 10, 10,  9,
      10,  7,  8, 10,  7,  8, 10,  8,  9, 10,  8,  9, 10,  8,  9, 10,
       8,  8, 10,  9,  9, 10,  9,  9, 10,  9,  9,  9,
    },
    {
       0,  5, 11,  3,  6, 11,  8,  9, 12,  4,  7, 12,  6,  7, 12,  9,
      10, 13, 10, 11, 13, 10, 11, 14, 12, 13, 14,  1,  6, 11,  4,  7,
      11,  8,  9, 12,  5,  7, 11,  6,  8, 12,  9, 10, 13, 10, 11, 14,
      10, 11, 13, 12, 12, 14,  6,  8, 12,  7,  9, 13,  9, 10, 14,  7,
      10, 13,  8, 10, 12, 11, 11, 13, 11, 13, 14, 11, 12, 14, 13, 13,
      15,  9, 10, 12,  9, 11, 14, 10, 11, 14, 11, 11, 13, 10, 11, 13,
      11, 12, 14, 12, 14, 15, 13, 13, 14, 13, 13, 14,
    },
  },
  {
    {
       0,  5, 11,  3,  6, 11,  7,  9, 11,  4,  6, 11,  5,  7, 10,  9,
       9, 11,  8,  9, 11,  9, 10, 11, 11, 11, 11,  2,  6, 10,  3,  6,
      10,  7,  9, 11,  4,  7, 10,  5,  7, 10,  8,  9, 11,  8,  9, 11,
       9,  9, 11, 11, 11, 11,  5,  8, 11,  6,  8, 11,  8, 10, 12,  6,
       8, 11,  7,  8, 11,  9, 10, 11,  9, 10, 12,  9, 10, 11, 11, 11,
      11,  8,  9, 11,  8, 10, 12,  9, 11, 12,  8, 10, 12,  9, 10, 12,
      10, 11, 12, 10, 11, 12, 10, 10, 11, 11, 11, 11,
    },
    {
       0,  5, 13,  2,  7, 16,  9, 11, 16,  4,  8, 16,  7,  9, 16, 12,
      12, 16, 12, 16, 16, 12, 16, 16, 16, 16, 16,  1,  6, 13,  4,  8,
      16,  9, 11, 16,  6,  9, 16,  7, 10, 16, 13, 13, 16, 13, 15, 16,
      12, 16, 16, 16, 16, 16,  7,  9, 16,  8, 11, 15, 11, 13, 16, 10,
      12, 16, 10, 12, 16, 16, 13, 16, 16, 16, 16, 14, 16, 16, 16, 16,
      16, 12, 12, 16, 12, 16, 16, 16, 16, 16, 13, 14, 16, 12, 13, 16,
      16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  6, 11,  3,  7, 11,  8, 10, 12,  4,  7, 11,  6,  8, 11, 10,
      11, 12,  9, 10, 12, 10, 10, 12, 12, 12, 13,  1,  6, 11,  4,  7,
      11,  8, 10, 12,  4,  7, 11,  6,  8, 11, 10, 10, 12,  9, 10, 12,
      10, 10, 12, 13, 13, 13,  6,  8, 12,  7, 10, 12, 10, 12, 13,  7,
       9, 12,  8, 10, 12, 11, 11, 13, 11, 12, 14, 11, 11, 13, 13, 13,
      13,  9, 11, 13, 10, 12, 14, 12, 13, 15, 10, 12, 14, 11, 12, 14,
      13, 13, 14, 12, 13, 15, 13, 13, 14, 14, 14, 14,
    },
    {
       0,  5, 16,  2,  6, 16, 10, 14, 16,  4,  8, 16,  7,  9, 16, 11,
      16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16,  1,  6, 12,  4,  8,
      12, 12, 12, 16,  6,  8, 16,  8, 10, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 12, 16, 16,  7, 10, 16,  8, 11, 14, 16, 16, 16, 10,
      12, 16, 10, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  5, 11,  3,  6, 11, 10, 10, 12,  3,  7, 11,  6,  8, 11, 11,
      11, 12, 10, 10, 12, 11, 11, 13, 14, 13, 14,  1,  6, 11,  4,  7,
      11, 10, 11, 13,  5,  7, 11,  7,  8, 11, 11, 11, 13, 10, 11, 13,
      11, 11, 12, 13, 13, 14,  7, 10, 12,  9, 11, 13, 12, 13, 14,  9,
      10, 13,  9, 10, 13, 12, 11, 13, 12, 13, 16, 12, 13, 13, 14, 14,
      14, 11, 14, 16, 12, 14, 15, 14, 13, 16, 13, 13, 15, 13, 14, 16,
      14, 13, 16, 13, 13, 16, 13, 14, 15, 15, 14, 15,
    },
    {
       0,  4, 16,  2,  7, 16, 10, 16, 16,  4, 10, 16,  7, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  1,  6, 13,  4, 11,
      16, 16, 16, 16,  6, 10, 16,  8, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16,  8, 16, 16, 10, 16, 16, 16, 16, 16, 10,
      16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
};


static const uint8_t rv34_intra_coeffvlc[NUM_INTRA_TABLES][COEFF_VLC_SIZE] = {
{
  1,  3,  3,  4,  4,  5,  6,  6,  6,  7,  7,  7,  8,  8,  9,  9,
  9,  9, 10, 10, 10, 11, 11, 11, 10, 10, 10, 12, 13, 14, 15, 15,
},
{
  1,  2,  3,  5,  5,  6,  6,  7,  7,  8,  8,  9, 10, 10, 10, 11,
 11, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 14, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 12, 12, 12,
 13, 13, 14, 14, 14, 14, 16, 16, 14, 16, 16, 16, 14, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 12, 12, 12,
 13, 13, 16, 16, 16, 16, 16, 16, 16, 16, 14, 12, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  7,  7,  8,  8,  9, 10, 10, 12, 11, 13, 12,
 15, 13, 14, 13, 12, 15, 14, 13, 12, 12, 10, 11, 16, 16, 16, 16,
}
};


static const uint8_t rv34_inter_cbppatvlc[NUM_INTER_TABLES][CBPPAT_VLC_SIZE] = {
{
  7,  9,  9,  8,  9,  8,  9,  8,  9,  9,  8,  8,  8,  8,  8,  4,
  7, 10, 11, 10, 11, 10, 12, 10, 12, 11, 11, 10, 11, 10, 10,  7,
 10, 11, 15, 12, 15, 12, 15, 12, 15, 14, 14, 12, 14, 12, 14,  9,
  7, 11, 10, 10, 12, 11, 11, 10, 11, 12, 10, 10, 11, 10, 10,  7,
  8, 12, 12, 11, 13, 12, 12, 10, 13, 13, 12, 10, 12, 11, 11,  7,
 11, 13, 15, 11, 15, 13, 15, 12, 16, 14, 14, 12, 15, 13, 13,  9,
 10, 15, 11, 12, 15, 14, 14, 12, 15, 15, 12, 12, 14, 14, 12,  9,
 11, 15, 13, 12, 16, 15, 14, 12, 15, 15, 13, 12, 15, 14, 13,  9,
 13, 15, 14, 10, 16, 15, 16, 11, 16, 16, 15, 12, 16, 15, 15,  9,
  7, 11, 11, 11, 11, 10, 11, 10, 11, 12, 11, 10, 10, 10, 10,  7,
  9, 12, 13, 12, 12, 11, 13, 10, 13, 13, 12, 11, 12, 10, 11,  7,
 12, 13, 16, 14, 15, 12, 16, 12, 16, 15, 15, 13, 15, 12, 14,  9,
  9, 13, 13, 12, 13, 12, 13, 11, 13, 13, 12, 11, 12, 11, 11,  7,
  9, 13, 13, 12, 13, 12, 13, 11, 13, 13, 13, 11, 12, 11, 11,  7,
 12, 14, 15, 13, 16, 13, 15, 11, 16, 14, 15, 12, 15, 12, 13,  8,
 12, 16, 14, 14, 16, 15, 15, 13, 16, 15, 14, 13, 15, 14, 13,  9,
 12, 15, 14, 13, 15, 14, 15, 12, 16, 15, 14, 12, 14, 13, 13,  8,
 13, 16, 16, 12, 16, 14, 16, 11, 16, 16, 15, 12, 16, 14, 14,  8,
 10, 15, 15, 15, 12, 12, 14, 12, 14, 15, 15, 14, 12, 12, 13,  9,
 11, 15, 16, 14, 13, 12, 15, 12, 16, 15, 15, 14, 14, 12, 13,  9,
 14, 15, 16, 16, 15, 11, 16, 12, 16, 16, 16, 15, 16, 12, 15,  9,
 12, 16, 16, 15, 14, 14, 14, 13, 16, 16, 15, 14, 14, 13, 13,  9,
 12, 15, 15, 14, 14, 13, 15, 12, 16, 15, 14, 13, 14, 13, 13,  8,
 13, 16, 16, 15, 16, 12, 16, 11, 16, 16, 16, 14, 16, 13, 14,  8,
 14, 16, 16, 16, 16, 16, 15, 14, 16, 16, 16, 15, 16, 15, 14, 11,
 13, 16, 16, 15, 16, 15, 15, 12, 16, 16, 16, 14, 15, 14, 14,  9,
 14, 16, 16, 13, 16, 14, 16, 10, 16, 16, 16, 13, 16, 14, 14,  8,
  7, 12, 11, 11, 11, 11, 12, 10, 11, 11, 10, 10, 10, 10, 10,  7,
  9, 13, 13, 12, 13, 12, 13, 11, 13, 13, 12, 11, 12, 11, 11,  8,
 12, 14, 16, 14, 16, 14, 16, 13, 16, 14, 15, 13, 15, 13, 14,  9,
  9, 13, 12, 12, 13, 12, 13, 11, 12, 13, 11, 10, 12, 11, 11,  7,
  9, 13, 13, 12, 13, 12, 13, 11, 13, 13, 12, 11, 12, 11, 11,  7,
 12, 14, 16, 13, 16, 14, 15, 12, 15, 15, 14, 12, 15, 13, 13,  8,
 11, 15, 13, 14, 15, 15, 14, 13, 15, 15, 12, 12, 14, 14, 12,  9,
 11, 15, 14, 13, 15, 14, 14, 12, 15, 14, 13, 11, 14, 13, 12,  8,
 13, 16, 15, 12, 16, 15, 16, 12, 16, 16, 14, 11, 15, 14, 14,  8,
  8, 13, 13, 12, 12, 12, 13, 11, 12, 13, 12, 11, 11, 10, 10,  7,
  9, 13, 14, 12, 13, 12, 13, 11, 13, 13, 13, 11, 12, 11, 11,  7,
 12, 14, 16, 14, 15, 13, 15, 12, 15, 15, 15, 13, 14, 12, 13,  8,
  9, 13, 13, 12, 13, 12, 13, 11, 13, 13, 12, 11, 12, 11, 11,  7,
  9, 13, 12, 12, 13, 12, 12, 10, 13, 13, 12, 10, 12, 10, 10,  6,
 11, 14, 14, 12, 14, 12, 14, 11, 14, 14, 13, 11, 13, 11, 12,  7,
 12, 16, 14, 14, 15, 15, 14, 13, 15, 15, 13, 12, 14, 13, 12,  8,
 11, 14, 13, 12, 14, 13, 13, 11, 14, 14, 13, 11, 13, 12, 11,  7,
 11, 14, 14, 12, 15, 13, 14, 11, 15, 14, 13, 11, 14, 12, 12,  6,
 11, 16, 15, 15, 13, 14, 15, 13, 14, 15, 15, 13, 12, 12, 12,  9,
 12, 15, 15, 14, 14, 13, 15, 12, 15, 15, 14, 13, 13, 11, 12,  8,
 13, 16, 16, 15, 16, 13, 16, 13, 16, 16, 15, 14, 14, 12, 14,  8,
 11, 16, 15, 14, 14, 14, 14, 13, 15, 15, 14, 13, 13, 12, 12,  8,
 11, 14, 14, 13, 13, 12, 14, 11, 14, 14, 13, 12, 12, 11, 11,  7,
 12, 14, 15, 13, 14, 12, 14, 11, 15, 14, 14, 12, 13, 11, 12,  7,
 13, 16, 16, 16, 16, 15, 16, 14, 16, 16, 15, 14, 15, 14, 13,  9,
 12, 15, 14, 13, 15, 13, 14, 12, 15, 15, 13, 12, 13, 12, 12,  7,
 11, 15, 14, 12, 14, 13, 14, 10, 15, 14, 13, 11, 13, 11, 11,  5,
 10, 15, 15, 15, 15, 14, 15, 13, 12, 14, 12, 12, 12, 13, 12,  9,
 12, 16, 16, 15, 16, 15, 16, 14, 14, 15, 14, 13, 14, 13, 13,  9,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14, 16, 14, 15, 11,
 11, 15, 15, 14, 15, 15, 15, 14, 14, 15, 12, 12, 13, 13, 12,  9,
 12, 15, 15, 14, 16, 14, 15, 13, 14, 14, 13, 12, 14, 13, 12,  8,
 13, 16, 16, 15, 16, 16, 16, 14, 16, 16, 15, 12, 16, 14, 14,  9,
 13, 16, 14, 16, 16, 16, 16, 15, 15, 16, 11, 12, 16, 15, 12,  9,
 13, 16, 15, 14, 16, 15, 16, 14, 15, 16, 12, 11, 15, 14, 13,  8,
 13, 16, 16, 13, 16, 16, 16, 13, 16, 16, 13, 11, 16, 14, 14,  8,
 11, 15, 15, 15, 14, 14, 15, 13, 13, 15, 14, 13, 12, 12, 12,  9,
 11, 15, 16, 14, 15, 14, 15, 13, 14, 14, 14, 13, 13, 12, 13,  8,
 13, 16, 16, 16, 16, 15, 16, 14, 16, 16, 16, 13, 15, 12, 14,  9,
 11, 16, 15, 14, 14, 14, 15, 13, 14, 14, 13, 12, 13, 12, 11,  8,
 11, 14, 14, 13, 14, 13, 14, 12, 13, 13, 12, 11, 12, 11, 11,  7,
 12, 15, 15, 13, 15, 14, 15, 12, 15, 14, 14, 11, 13, 12, 12,  7,
 13, 16, 15, 15, 16, 16, 16, 14, 15, 16, 12, 12, 14, 14, 12,  8,
 11, 15, 14, 13, 15, 13, 14, 12, 14, 14, 12, 11, 13, 12, 11,  6,
 11, 14, 14, 12, 15, 13, 14, 11, 15, 14, 12, 10, 13, 11, 11,  5,
 12, 16, 16, 16, 15, 15, 16, 15, 14, 16, 15, 15, 10, 12, 12,  9,
 13, 16, 16, 16, 15, 14, 16, 13, 15, 15, 15, 14, 12, 11, 13,  8,
 14, 16, 16, 16, 16, 14, 16, 13, 16, 16, 16, 14, 14, 11, 14,  8,
 13, 16, 16, 15, 15, 15, 15, 14, 15, 16, 14, 13, 12, 12, 11,  8,
 11, 15, 15, 13, 14, 13, 14, 12, 14, 14, 13, 12, 12, 11, 11,  6,
 11, 15, 15, 13, 15, 12, 14, 11, 14, 14, 13, 11, 12, 10, 11,  5,
 13, 16, 16, 15, 16, 16, 16, 14, 16, 16, 14, 14, 14, 13, 11,  8,
 11, 14, 14, 13, 14, 13, 14, 11, 14, 14, 12, 11, 12, 11, 10,  5,
 10, 13, 13, 11, 13, 12, 13,  9, 13, 13, 12,  9, 12, 10, 10,  3,
},
{
  5,  7,  7,  7,  7,  7,  8,  7,  7,  8,  7,  7,  7,  7,  7,  4,
  7,  9, 11,  9, 11,  9, 11,  9, 11, 10, 10,  9, 10,  9, 10,  6,
 11, 11, 14, 11, 14, 11, 14, 11, 15, 13, 14, 12, 14, 12, 13,  9,
  6, 11, 10,  9, 11, 10, 11,  9, 11, 11,  9,  9, 10, 10,  9,  6,
  8, 11, 11, 10, 12, 11, 12, 10, 12, 12, 11, 10, 12, 11, 11,  7,
 11, 13, 14, 11, 15, 13, 15, 11, 15, 14, 14, 12, 14, 13, 13,  9,
 10, 14, 11, 11, 15, 14, 13, 12, 14, 14, 11, 11, 14, 13, 12,  9,
 11, 14, 13, 11, 15, 14, 14, 11, 15, 15, 13, 11, 14, 14, 13,  9,
 12, 14, 14, 10, 16, 15, 16, 11, 16, 16, 15, 11, 16, 15, 14,  9,
  6, 10, 11, 10, 10,  9, 11,  9, 10, 11, 10, 10,  9,  9,  9,  6,
  9, 12, 12, 11, 12, 10, 12, 10, 12, 12, 12, 11, 11, 10, 11,  7,
 12, 13, 15, 13, 14, 11, 15, 11, 15, 15, 14, 13, 14, 12, 14,  9,
  9, 12, 12, 11, 12, 11, 12, 11, 12, 13, 11, 11, 12, 11, 11,  7,
  9, 12, 12, 11, 13, 11, 12, 10, 13, 13, 12, 11, 12, 11, 11,  7,
 12, 14, 15, 12, 15, 12, 14, 11, 15, 15, 14, 12, 14, 13, 13,  8,
 12, 15, 14, 13, 15, 14, 14, 13, 16, 16, 14, 13, 15, 14, 13,  9,
 12, 15, 14, 13, 15, 14, 14, 12, 15, 15, 13, 12, 14, 13, 13,  9,
 13, 15, 15, 12, 16, 14, 15, 11, 16, 16, 15, 12, 15, 14, 14,  9,
 10, 14, 14, 14, 12, 11, 13, 12, 14, 15, 14, 13, 12, 11, 12,  9,
 12, 14, 15, 14, 13, 11, 14, 12, 15, 15, 15, 14, 13, 11, 13,  9,
 13, 15, 16, 15, 14, 11, 16, 11, 16, 16, 16, 14, 15, 12, 15,  9,
 12, 15, 15, 14, 14, 14, 14, 13, 15, 15, 14, 14, 14, 13, 13,  9,
 12, 15, 15, 14, 14, 13, 14, 12, 15, 15, 14, 13, 14, 13, 13,  9,
 13, 15, 16, 14, 15, 13, 16, 11, 16, 16, 15, 14, 15, 13, 14,  9,
 14, 16, 16, 16, 16, 16, 15, 14, 16, 16, 16, 16, 16, 16, 14, 11,
 14, 16, 16, 14, 16, 15, 15, 12, 16, 16, 16, 14, 15, 14, 14,  9,
 14, 16, 16, 14, 16, 14, 16, 11, 16, 16, 16, 14, 16, 14, 14,  9,
  6, 11, 10, 10, 10, 10, 11, 10, 10, 11,  9,  9,  9,  9,  9,  6,
  9, 12, 12, 11, 13, 11, 13, 11, 12, 12, 11, 11, 12, 11, 11,  7,
 12, 14, 16, 13, 16, 14, 16, 13, 15, 14, 15, 12, 15, 13, 14,  9,
  8, 12, 11, 11, 12, 12, 12, 11, 11, 12, 10, 10, 11, 11, 10,  7,
  9, 12, 12, 11, 13, 12, 13, 11, 13, 12, 11, 10, 12, 11, 11,  7,
 12, 14, 15, 12, 15, 14, 15, 12, 15, 14, 14, 12, 14, 13, 13,  9,
 11, 15, 13, 13, 15, 14, 14, 13, 14, 15, 11, 11, 14, 14, 12,  9,
 11, 14, 13, 12, 15, 14, 14, 12, 14, 14, 12, 11, 14, 13, 12,  8,
 13, 15, 15, 12, 16, 15, 15, 12, 15, 15, 14, 11, 15, 14, 14,  8,
  8, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 10, 10, 10,  7,
  9, 13, 13, 12, 13, 11, 13, 11, 12, 13, 12, 11, 11, 10, 11,  7,
 12, 14, 15, 14, 15, 13, 15, 12, 15, 14, 14, 13, 14, 12, 13,  9,
  9, 13, 12, 12, 12, 12, 12, 11, 12, 13, 11, 11, 11, 11, 10,  7,
  9, 12, 12, 11, 12, 11, 12, 10, 12, 12, 11, 10, 11, 10, 10,  7,
 11, 13, 14, 12, 14, 12, 14, 11, 14, 13, 13, 11, 13, 11, 12,  7,
 12, 15, 14, 13, 15, 14, 14, 13, 15, 15, 13, 12, 13, 13, 12,  9,
 11, 14, 13, 12, 14, 13, 13, 11, 14, 14, 12, 11, 13, 12, 11,  7,
 11, 14, 14, 12, 14, 13, 14, 11, 14, 14, 13, 11, 13, 12, 12,  7,
 11, 15, 15, 14, 13, 13, 14, 13, 14, 15, 14, 13, 11, 11, 12,  9,
 12, 15, 15, 14, 14, 12, 14, 12, 14, 14, 14, 13, 12, 11, 12,  8,
 13, 16, 16, 15, 15, 12, 16, 13, 16, 15, 15, 14, 14, 12, 14,  9,
 12, 15, 15, 14, 14, 14, 14, 13, 15, 15, 14, 13, 12, 12, 12,  9,
 11, 14, 14, 13, 13, 12, 13, 11, 14, 13, 13, 12, 12, 11, 11,  7,
 12, 14, 15, 13, 14, 12, 14, 11, 15, 14, 13, 12, 13, 11, 12,  7,
 13, 16, 16, 15, 16, 15, 15, 14, 16, 16, 15, 14, 14, 14, 12,  9,
 12, 15, 14, 13, 14, 13, 14, 12, 15, 14, 13, 12, 13, 12, 12,  8,
 12, 14, 14, 13, 15, 13, 14, 11, 14, 14, 13, 12, 13, 12, 12,  6,
 10, 14, 14, 13, 14, 14, 14, 13, 12, 13, 12, 12, 12, 12, 11,  9,
 12, 15, 15, 14, 15, 14, 16, 14, 14, 14, 13, 12, 14, 13, 13,  9,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14, 16, 14, 16, 11,
 11, 15, 14, 14, 15, 14, 14, 14, 13, 14, 11, 12, 13, 13, 12,  9,
 12, 15, 14, 14, 15, 14, 15, 13, 14, 14, 13, 12, 14, 13, 13,  9,
 13, 16, 16, 14, 16, 15, 16, 14, 16, 15, 15, 12, 16, 14, 14,  9,
 13, 16, 14, 15, 16, 16, 16, 14, 14, 16, 11, 12, 15, 14, 12,  9,
 13, 16, 15, 14, 16, 15, 16, 14, 15, 15, 12, 11, 15, 14, 13,  9,
 14, 16, 16, 13, 16, 16, 16, 14, 16, 15, 13, 11, 16, 14, 14,  9,
 11, 15, 15, 14, 14, 14, 14, 13, 13, 14, 13, 13, 11, 11, 11,  9,
 12, 15, 15, 14, 15, 14, 15, 13, 14, 14, 13, 13, 13, 12, 12,  9,
 13, 16, 16, 16, 16, 14, 16, 14, 16, 15, 16, 14, 15, 12, 14,  9,
 11, 15, 14, 14, 15, 14, 14, 13, 14, 14, 12, 12, 12, 12, 11,  8,
 11, 14, 14, 13, 14, 13, 13, 12, 13, 13, 12, 11, 12, 11, 11,  7,
 12, 14, 15, 13, 15, 13, 14, 13, 14, 14, 13, 12, 13, 12, 12,  8,
 13, 16, 15, 15, 16, 15, 15, 14, 15, 16, 12, 12, 14, 14, 11,  9,
 12, 15, 14, 13, 15, 13, 14, 12, 14, 14, 12, 11, 13, 12, 11,  7,
 12, 14, 14, 13, 15, 13, 14, 12, 15, 14, 13, 10, 13, 12, 12,  6,
 12, 16, 16, 15, 14, 14, 15, 14, 13, 15, 14, 14, 10, 11, 11,  9,
 13, 16, 16, 15, 15, 14, 15, 14, 15, 15, 15, 14, 12, 11, 12,  8,
 14, 16, 16, 16, 16, 14, 16, 14, 16, 15, 15, 14, 14, 11, 14,  8,
 12, 16, 16, 15, 15, 14, 15, 14, 14, 16, 14, 14, 12, 12, 11,  8,
 11, 14, 14, 13, 14, 13, 14, 12, 14, 14, 13, 12, 12, 11, 11,  7,
 12, 14, 15, 13, 14, 13, 14, 12, 14, 14, 13, 12, 13, 11, 12,  6,
 14, 16, 16, 16, 16, 16, 15, 14, 16, 16, 14, 13, 13, 13, 11,  8,
 12, 15, 15, 13, 15, 13, 14, 12, 14, 14, 13, 12, 13, 12, 10,  6,
 11, 14, 13, 12, 14, 12, 13, 10, 14, 13, 12, 10, 12, 10, 10,  4,
},
{
  4,  6,  6,  6,  6,  6,  7,  6,  6,  7,  6,  6,  6,  6,  6,  3,
  6,  9, 10,  9, 10,  9, 11,  9, 10, 10, 10,  9, 10,  9, 10,  6,
 10, 11, 14, 11, 14, 11, 14, 11, 14, 13, 14, 11, 14, 11, 13,  9,
  6, 10,  9,  9, 10, 10, 10,  9, 10, 11,  9,  9, 10, 10,  9,  6,
  8, 11, 11,  9, 12, 11, 12, 10, 12, 12, 11, 10, 12, 11, 11,  7,
 11, 13, 14, 11, 15, 13, 15, 11, 15, 14, 14, 11, 15, 13, 14,  9,
 10, 13, 11, 11, 14, 14, 13, 11, 14, 14, 11, 11, 13, 13, 11,  9,
 11, 14, 12, 11, 15, 14, 14, 11, 15, 15, 13, 11, 14, 14, 13,  9,
 12, 14, 13, 10, 16, 15, 16, 11, 16, 16, 14, 11, 16, 14, 14,  9,
  6, 10, 10, 10,  9,  9, 10,  9, 10, 11, 10, 10,  9,  9,  9,  6,
  8, 11, 12, 11, 11, 10, 12, 10, 12, 12, 12, 11, 11, 10, 11,  7,
 11, 13, 15, 13, 14, 11, 15, 11, 15, 14, 14, 13, 14, 12, 14,  9,
  8, 12, 12, 12, 12, 12, 12, 11, 12, 13, 11, 11, 11, 11, 11,  8,
  9, 12, 12, 11, 12, 12, 13, 11, 13, 13, 12, 11, 12, 11, 11,  8,
 11, 14, 15, 13, 14, 13, 15, 11, 15, 15, 14, 13, 15, 13, 14,  9,
 12, 16, 14, 14, 15, 15, 14, 12, 15, 16, 14, 13, 14, 14, 13, 10,
 11, 15, 14, 13, 15, 14, 15, 12, 15, 16, 14, 13, 15, 14, 13,  9,
 13, 15, 15, 12, 16, 15, 16, 12, 16, 16, 15, 13, 15, 14, 14,  9,
 10, 14, 14, 14, 11, 11, 13, 11, 14, 14, 14, 13, 11, 11, 11,  9,
 11, 14, 15, 14, 13, 11, 14, 12, 15, 15, 15, 14, 13, 11, 13,  9,
 13, 14, 16, 15, 14, 11, 16, 12, 16, 16, 16, 14, 15, 12, 15, 10,
 12, 16, 15, 15, 14, 14, 14, 12, 16, 16, 14, 14, 14, 13, 13, 10,
 12, 15, 15, 14, 14, 13, 14, 12, 15, 16, 14, 14, 14, 13, 13,  9,
 13, 16, 16, 14, 16, 13, 16, 12, 16, 16, 16, 14, 16, 13, 15, 10,
 14, 16, 16, 16, 16, 16, 15, 14, 16, 16, 16, 16, 16, 16, 14, 11,
 13, 16, 16, 15, 16, 16, 16, 13, 16, 16, 16, 15, 16, 15, 14, 10,
 14, 16, 16, 14, 16, 14, 16, 12, 16, 16, 16, 15, 16, 15, 15, 10,
  6, 10, 10, 10, 10, 10, 11, 10,  9, 10,  9,  9,  9,  9,  9,  6,
  9, 12, 12, 11, 12, 11, 13, 11, 12, 12, 11, 10, 12, 11, 11,  8,
 12, 14, 15, 14, 15, 14, 16, 13, 15, 14, 14, 12, 15, 13, 14, 10,
  8, 12, 11, 11, 12, 12, 12, 11, 11, 12, 10, 10, 11, 11, 10,  7,
  9, 12, 12, 11, 13, 12, 13, 11, 12, 13, 11, 10, 12, 12, 11,  8,
 11, 14, 14, 13, 15, 14, 15, 13, 15, 14, 14, 12, 15, 13, 14,  9,
 11, 15, 12, 13, 15, 15, 14, 13, 14, 15, 11, 11, 14, 14, 12,  9,
 11, 14, 13, 13, 15, 14, 15, 13, 15, 15, 13, 11, 15, 14, 13,  9,
 13, 15, 15, 12, 16, 15, 16, 13, 16, 15, 14, 11, 16, 15, 14,  9,
  8, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11,  9, 10, 10,  7,
  9, 12, 13, 12, 12, 11, 13, 11, 12, 13, 12, 12, 11, 11, 11,  8,
 12, 14, 15, 14, 15, 13, 16, 13, 15, 14, 15, 13, 14, 12, 14,  9,
  9, 13, 12, 12, 12, 12, 13, 12, 12, 13, 11, 11, 11, 11, 10,  8,
  9, 12, 12, 12, 12, 12, 13, 11, 12, 13, 11, 11, 12, 11, 11,  7,
 11, 13, 14, 13, 14, 13, 15, 12, 14, 14, 14, 12, 14, 12, 13,  8,
 12, 15, 14, 14, 15, 15, 14, 13, 15, 16, 13, 13, 14, 14, 12,  9,
 11, 14, 13, 13, 14, 14, 14, 12, 14, 15, 13, 12, 14, 13, 12,  8,
 11, 14, 14, 13, 15, 14, 15, 12, 15, 15, 14, 12, 14, 13, 13,  8,
 11, 14, 14, 14, 13, 13, 14, 13, 13, 14, 14, 13, 11, 11, 11,  9,
 11, 15, 15, 14, 14, 13, 15, 13, 14, 15, 14, 14, 13, 11, 13,  9,
 13, 16, 16, 16, 15, 13, 16, 13, 16, 16, 16, 15, 15, 12, 15, 10,
 11, 15, 15, 15, 14, 14, 14, 13, 15, 15, 14, 14, 13, 13, 12,  9,
 11, 14, 14, 13, 13, 13, 14, 12, 14, 14, 13, 13, 13, 12, 12,  8,
 12, 15, 15, 14, 15, 13, 15, 12, 15, 15, 14, 13, 14, 12, 13,  8,
 13, 16, 16, 16, 16, 16, 16, 14, 16, 16, 15, 15, 15, 15, 13, 10,
 12, 15, 15, 14, 15, 14, 15, 13, 15, 16, 14, 13, 14, 14, 13,  9,
 12, 15, 15, 14, 15, 14, 15, 12, 15, 15, 14, 13, 14, 13, 13,  8,
 10, 14, 13, 13, 14, 13, 14, 13, 11, 13, 11, 11, 11, 11, 11,  9,
 12, 15, 16, 14, 15, 14, 16, 14, 14, 14, 14, 13, 14, 13, 13, 10,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 13, 16, 14, 16, 11,
 11, 15, 14, 14, 15, 14, 15, 14, 13, 14, 11, 12, 13, 13, 11,  9,
 12, 15, 15, 14, 15, 15, 16, 14, 14, 14, 13, 12, 14, 13, 13,  9,
 13, 16, 16, 15, 16, 16, 16, 15, 16, 15, 15, 12, 16, 14, 15, 10,
 12, 16, 14, 15, 16, 16, 16, 14, 14, 16, 11, 12, 14, 15, 12,  9,
 13, 16, 15, 14, 16, 16, 16, 14, 15, 16, 13, 12, 15, 15, 13,  9,
 14, 16, 16, 14, 16, 16, 16, 15, 16, 16, 14, 12, 16, 15, 15, 10,
 11, 14, 14, 14, 14, 14, 14, 13, 12, 14, 13, 13, 11, 11, 11,  9,
 11, 15, 15, 14, 14, 14, 16, 14, 14, 14, 14, 13, 13, 12, 13,  9,
 13, 16, 16, 16, 16, 15, 16, 15, 16, 15, 16, 14, 15, 13, 15, 10,
 11, 15, 15, 14, 14, 14, 15, 14, 14, 15, 13, 13, 12, 13, 11,  9,
 11, 14, 14, 13, 14, 14, 14, 13, 13, 14, 13, 12, 13, 12, 12,  8,
 12, 15, 15, 14, 16, 14, 16, 14, 15, 15, 15, 13, 14, 13, 14,  9,
 13, 16, 15, 16, 16, 16, 16, 15, 15, 16, 13, 13, 14, 14, 12,  9,
 12, 15, 14, 14, 15, 15, 15, 13, 14, 15, 13, 12, 14, 13, 12,  8,
 12, 15, 14, 14, 15, 15, 15, 13, 15, 15, 14, 12, 14, 13, 13,  8,
 12, 16, 15, 15, 13, 14, 15, 14, 13, 15, 14, 14, 10, 11, 11,  9,
 12, 16, 16, 15, 15, 14, 16, 14, 15, 15, 15, 14, 13, 12, 13,  9,
 14, 16, 16, 16, 16, 14, 16, 15, 16, 15, 16, 15, 14, 12, 15, 10,
 12, 16, 15, 15, 15, 15, 15, 14, 15, 16, 14, 14, 12, 13, 11,  9,
 11, 15, 15, 14, 14, 14, 15, 13, 14, 15, 14, 13, 13, 12, 12,  8,
 12, 15, 15, 14, 15, 14, 15, 13, 15, 15, 14, 13, 14, 12, 13,  8,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 14, 14, 14, 14, 11,  9,
 12, 15, 15, 14, 15, 15, 15, 13, 15, 15, 14, 13, 14, 13, 12,  8,
 11, 14, 14, 13, 14, 13, 14, 12, 13, 14, 13, 12, 13, 12, 12,  7,
},
{
  2,  6,  6,  5,  6,  6,  7,  6,  6,  7,  6,  6,  6,  6,  6,  3,
  6,  9, 10,  9, 10,  9, 11,  9, 10, 10, 10,  9, 10,  9, 10,  7,
 10, 11, 14, 11, 14, 11, 14, 11, 14, 13, 14, 12, 14, 12, 13,  9,
  6, 10,  9,  9, 10, 10, 10,  9, 10, 11,  9,  9, 10, 10,  9,  7,
  8, 11, 11,  9, 12, 11, 12, 10, 12, 12, 11, 10, 12, 11, 11,  8,
 11, 13, 14, 11, 16, 13, 15, 12, 16, 14, 14, 12, 15, 13, 14, 10,
 10, 13, 11, 11, 14, 14, 13, 11, 13, 14, 11, 11, 13, 13, 11,  9,
 11, 13, 13, 11, 15, 14, 14, 12, 15, 15, 13, 12, 15, 14, 13, 10,
 12, 14, 14, 11, 16, 15, 16, 12, 16, 16, 15, 12, 16, 15, 15, 10,
  6, 10, 10, 10,  9,  9, 10,  9, 10, 11, 10, 10,  9,  9,  9,  7,
  8, 11, 12, 11, 11, 10, 12, 10, 12, 12, 12, 11, 11, 10, 11,  8,
 12, 13, 16, 13, 14, 11, 16, 12, 16, 15, 15, 13, 14, 12, 14, 10,
  9, 13, 12, 12, 12, 12, 12, 11, 13, 13, 12, 12, 12, 12, 11,  8,
 10, 13, 13, 12, 13, 12, 13, 11, 14, 14, 13, 12, 13, 12, 12,  9,
 12, 14, 16, 13, 15, 13, 15, 12, 16, 16, 16, 13, 16, 14, 14, 10,
 12, 16, 14, 14, 16, 15, 14, 13, 16, 16, 14, 14, 15, 15, 13, 11,
 12, 16, 15, 14, 16, 15, 15, 12, 16, 16, 15, 14, 16, 15, 14, 10,
 14, 16, 16, 14, 16, 15, 16, 13, 16, 16, 16, 14, 16, 16, 15, 11,
 10, 14, 14, 13, 11, 11, 13, 12, 14, 14, 13, 13, 11, 11, 12,  9,
 12, 14, 16, 14, 13, 11, 14, 12, 16, 15, 15, 14, 14, 12, 13, 10,
 13, 14, 16, 15, 14, 11, 16, 12, 16, 16, 16, 15, 16, 13, 15, 11,
 12, 16, 15, 15, 14, 14, 14, 13, 16, 16, 15, 15, 14, 14, 13, 11,
 13, 16, 16, 15, 14, 14, 15, 13, 16, 16, 16, 15, 15, 14, 14, 11,
 14, 16, 16, 15, 16, 14, 16, 13, 16, 16, 16, 15, 16, 14, 15, 11,
 15, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 14, 12,
 15, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 15, 12,
 15, 16, 16, 15, 16, 15, 16, 13, 16, 16, 16, 16, 16, 16, 16, 11,
  6, 10, 10, 10, 10, 10, 11, 10,  9, 10,  9,  9,  9,  9,  9,  7,
  9, 12, 13, 12, 13, 12, 14, 12, 12, 12, 12, 11, 12, 11, 11,  8,
 12, 14, 16, 14, 16, 14, 16, 14, 15, 14, 15, 13, 16, 13, 14, 11,
  8, 12, 11, 11, 12, 12, 12, 11, 11, 12, 10, 10, 11, 11, 10,  8,
 10, 13, 13, 12, 14, 13, 14, 12, 13, 13, 12, 11, 13, 12, 12,  9,
 12, 15, 15, 13, 16, 15, 16, 14, 16, 15, 15, 12, 16, 14, 15, 10,
 11, 15, 13, 13, 16, 15, 14, 13, 14, 15, 11, 12, 14, 14, 12, 10,
 12, 16, 14, 13, 16, 16, 16, 14, 16, 15, 13, 12, 15, 15, 14, 10,
 14, 16, 16, 14, 16, 16, 16, 14, 16, 16, 15, 13, 16, 16, 15, 11,
  8, 12, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11,  9, 10, 10,  8,
 10, 13, 14, 13, 13, 12, 14, 12, 13, 13, 13, 12, 12, 11, 12,  9,
 13, 15, 16, 15, 16, 14, 16, 14, 16, 15, 16, 14, 15, 13, 15, 11,
 10, 13, 13, 13, 13, 13, 13, 12, 13, 14, 12, 12, 12, 12, 11,  9,
 10, 13, 13, 13, 13, 13, 14, 12, 13, 14, 13, 12, 12, 12, 12,  9,
 12, 15, 15, 14, 16, 14, 16, 13, 16, 15, 15, 13, 15, 13, 14, 10,
 13, 16, 15, 15, 16, 16, 15, 14, 16, 16, 13, 14, 15, 15, 12, 10,
 12, 16, 14, 14, 16, 16, 15, 13, 16, 16, 14, 13, 15, 14, 13, 10,
 13, 16, 16, 14, 16, 15, 16, 13, 16, 16, 16, 13, 16, 15, 15, 10,
 11, 15, 15, 14, 13, 13, 14, 13, 13, 15, 14, 14, 11, 12, 12, 10,
 12, 15, 16, 15, 14, 13, 16, 14, 16, 15, 16, 14, 13, 12, 13, 10,
 14, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 16, 13, 16, 11,
 12, 16, 16, 16, 15, 15, 15, 14, 15, 16, 14, 14, 13, 14, 12, 10,
 12, 16, 16, 15, 15, 14, 16, 13, 16, 16, 15, 14, 14, 13, 13, 10,
 13, 16, 16, 15, 16, 14, 16, 13, 16, 16, 16, 15, 16, 14, 15, 10,
 15, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 13, 12,
 14, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 15, 16, 15, 14, 11,
 14, 16, 16, 15, 16, 16, 16, 13, 16, 16, 16, 15, 16, 15, 14, 10,
 10, 14, 13, 13, 13, 13, 14, 13, 11, 13, 11, 11, 11, 11, 11,  9,
 12, 15, 16, 15, 16, 15, 16, 14, 14, 14, 14, 13, 14, 13, 14, 11,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 14, 16, 12,
 11, 15, 14, 14, 15, 15, 15, 14, 13, 14, 11, 12, 13, 13, 12, 10,
 13, 16, 15, 15, 16, 16, 16, 15, 15, 15, 13, 12, 15, 14, 13, 10,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 12,
 13, 16, 14, 15, 16, 16, 16, 15, 14, 16, 11, 12, 15, 15, 12, 10,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 13, 16, 16, 14, 11,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 11,
 11, 15, 15, 14, 13, 14, 14, 14, 13, 14, 13, 13, 11, 12, 11, 10,
 12, 16, 16, 16, 16, 15, 16, 15, 15, 15, 15, 14, 13, 12, 14, 10,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 14, 16, 12,
 12, 16, 15, 15, 16, 16, 16, 14, 14, 15, 13, 13, 13, 13, 12, 10,
 12, 16, 16, 15, 15, 15, 16, 14, 14, 15, 14, 13, 14, 13, 13, 10,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14, 16, 14, 15, 11,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 15, 15, 12, 11,
 13, 16, 16, 15, 16, 16, 16, 14, 16, 16, 14, 13, 16, 14, 13, 10,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14, 16, 14, 15, 10,
 12, 16, 16, 15, 14, 15, 16, 14, 13, 15, 14, 14, 11, 12, 12, 10,
 13, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 15, 13, 12, 14, 11,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 11,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 15, 15, 13, 14, 12, 11,
 13, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14, 14, 13, 13, 10,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 15, 15, 14, 14, 10,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 15, 16, 13, 11,
 14, 16, 16, 16, 16, 16, 16, 14, 16, 16, 15, 14, 15, 14, 13, 10,
 12, 15, 15, 14, 15, 14, 16, 14, 14, 16, 15, 13, 14, 13, 13,  9,
},
{
  2,  5,  5,  5,  5,  5,  6,  6,  5,  6,  5,  6,  5,  6,  6,  4,
  6,  8, 10,  8, 10,  9, 11,  9, 10, 10, 10,  9, 10,  9, 10,  8,
 10, 11, 13, 11, 13, 11, 14, 11, 14, 13, 13, 12, 13, 12, 13, 10,
  6, 10,  8,  9, 10, 10, 10,  9, 10, 11,  9,  9, 10, 10,  9,  7,
  8, 11, 11, 10, 12, 11, 12, 10, 12, 12, 11, 10, 12, 12, 11,  9,
 11, 13, 14, 11, 15, 14, 15, 12, 16, 14, 14, 12, 15, 14, 14, 11,
 10, 13, 11, 11, 14, 13, 13, 12, 13, 14, 11, 11, 13, 13, 12, 10,
 11, 14, 13, 11, 16, 14, 14, 12, 15, 15, 14, 12, 15, 14, 14, 11,
 12, 14, 14, 11, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 15, 12,
  6, 10, 10, 10,  8,  9, 10,  9, 10, 11, 10, 10,  9,  9,  9,  8,
  8, 11, 12, 12, 11, 10, 12, 11, 12, 12, 12, 12, 12, 11, 12,  9,
 11, 13, 16, 14, 14, 12, 15, 12, 16, 15, 16, 14, 14, 13, 14, 11,
  9, 13, 12, 12, 12, 12, 12, 11, 13, 13, 12, 12, 12, 12, 11, 10,
 10, 13, 13, 12, 13, 12, 13, 11, 14, 14, 13, 13, 13, 13, 12, 10,
 13, 14, 16, 14, 15, 14, 16, 13, 16, 16, 16, 14, 16, 14, 15, 12,
 12, 16, 14, 14, 16, 15, 14, 13, 16, 16, 14, 14, 15, 15, 13, 12,
 13, 16, 15, 14, 16, 16, 15, 13, 16, 16, 15, 14, 16, 16, 14, 12,
 14, 16, 16, 14, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 12,
 10, 13, 14, 13, 11, 11, 13, 12, 13, 14, 13, 13, 11, 12, 12, 10,
 11, 14, 15, 15, 13, 12, 14, 13, 16, 16, 16, 15, 14, 13, 14, 11,
 12, 14, 16, 16, 14, 12, 16, 13, 16, 16, 16, 16, 15, 13, 16, 12,
 12, 16, 15, 16, 14, 15, 14, 14, 16, 16, 15, 16, 14, 14, 13, 12,
 13, 16, 16, 16, 16, 14, 16, 13, 16, 16, 16, 16, 16, 14, 15, 12,
 14, 16, 16, 16, 16, 14, 16, 14, 16, 16, 16, 16, 16, 15, 16, 13,
 15, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 15, 13,
 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 13,
 15, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 13,
  6, 10, 10, 10, 10, 10, 10, 10,  8, 10,  9,  9,  8,  9,  9,  7,
  9, 12, 13, 12, 13, 12, 13, 12, 12, 12, 12, 11, 12, 11, 12, 10,
 12, 14, 16, 14, 16, 14, 16, 14, 16, 15, 15, 14, 16, 14, 15, 12,
  8, 12, 11, 11, 12, 12, 12, 11, 11, 12, 10, 10, 11, 12, 10,  9,
 10, 13, 13, 12, 14, 13, 14, 12, 13, 13, 12, 11, 13, 13, 12, 10,
 13, 15, 16, 14, 16, 16, 16, 14, 16, 15, 15, 13, 16, 15, 15, 12,
 11, 15, 13, 13, 15, 15, 15, 14, 14, 14, 11, 12, 14, 14, 12, 11,
 13, 16, 14, 14, 16, 16, 16, 14, 16, 15, 13, 13, 16, 14, 14, 11,
 14, 16, 16, 14, 16, 16, 16, 15, 16, 16, 16, 14, 16, 16, 16, 12,
  8, 12, 12, 12, 11, 11, 12, 12, 11, 12, 11, 11,  9, 10, 10,  9,
 10, 13, 14, 13, 13, 12, 14, 13, 13, 13, 13, 13, 12, 11, 12, 10,
 13, 15, 16, 15, 16, 14, 16, 14, 16, 16, 16, 15, 16, 13, 15, 12,
 10, 14, 13, 13, 13, 13, 13, 13, 13, 14, 12, 12, 12, 12, 11, 10,
 10, 13, 13, 13, 13, 13, 14, 12, 13, 14, 13, 12, 13, 12, 12, 10,
 13, 16, 16, 14, 16, 15, 16, 14, 16, 16, 15, 14, 16, 14, 15, 11,
 13, 16, 15, 16, 16, 16, 15, 14, 16, 16, 14, 14, 15, 15, 13, 12,
 13, 16, 15, 14, 16, 16, 16, 14, 16, 16, 14, 14, 15, 15, 14, 11,
 14, 16, 16, 15, 16, 16, 16, 14, 16, 16, 16, 15, 16, 16, 15, 12,
 11, 14, 15, 14, 13, 13, 14, 14, 13, 15, 14, 14, 11, 12, 12, 11,
 13, 16, 16, 16, 14, 14, 16, 14, 16, 16, 16, 15, 14, 13, 14, 12,
 14, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 14, 16, 13,
 13, 16, 16, 16, 15, 16, 15, 15, 16, 16, 15, 16, 14, 14, 13, 12,
 13, 16, 16, 15, 15, 14, 16, 14, 16, 16, 16, 15, 14, 14, 14, 11,
 14, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 15, 16, 12,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 13,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12,
  9, 13, 13, 13, 13, 13, 14, 13, 10, 12, 11, 12, 11, 12, 11, 10,
 12, 15, 16, 15, 16, 16, 16, 16, 14, 14, 14, 13, 14, 13, 14, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 14,
 11, 15, 14, 14, 15, 14, 15, 14, 13, 14, 11, 12, 13, 13, 12, 11,
 13, 16, 16, 15, 16, 16, 16, 15, 15, 15, 14, 13, 16, 15, 14, 12,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 13,
 12, 16, 14, 15, 16, 16, 16, 16, 14, 16, 11, 13, 15, 16, 13, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 16, 16, 15, 12,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 13,
 11, 15, 14, 14, 13, 14, 15, 14, 12, 14, 13, 13, 11, 12, 12, 11,
 13, 16, 16, 16, 16, 15, 16, 16, 15, 15, 15, 15, 14, 13, 14, 12,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 13,
 13, 16, 16, 16, 16, 16, 16, 15, 14, 16, 13, 14, 13, 14, 13, 11,
 13, 16, 16, 16, 16, 16, 16, 15, 15, 16, 15, 14, 14, 14, 14, 11,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 15, 16, 16, 13, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 16, 16, 15, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12,
 11, 16, 16, 15, 13, 15, 16, 15, 13, 15, 15, 15, 11, 12, 12, 11,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 15, 12,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 13,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 14, 14, 13, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 12,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 14, 13,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 12,
 12, 14, 14, 14, 14, 15, 16, 14, 14, 16, 15, 14, 14, 15, 14, 11,
},
{
  1,  5,  5,  6,  5,  6,  7,  7,  5,  7,  6,  7,  5,  6,  6,  6,
  6,  9, 10,  9, 10,  9, 11, 10, 11, 11, 11, 10, 11, 10, 11,  9,
 10, 11, 14, 12, 14, 12, 16, 12, 16, 13, 16, 13, 14, 13, 16, 12,
  6, 10,  9,  9, 10, 11, 11, 10, 10, 11,  9, 10, 10, 11, 10,  9,
  8, 11, 11, 10, 13, 12, 13, 12, 13, 13, 12, 12, 13, 13, 13, 11,
 11, 13, 16, 12, 16, 16, 16, 13, 16, 16, 16, 14, 16, 16, 16, 13,
 10, 14, 11, 12, 14, 14, 13, 13, 13, 16, 12, 13, 14, 16, 13, 12,
 11, 14, 13, 12, 16, 16, 16, 14, 16, 16, 14, 14, 16, 16, 16, 13,
 12, 14, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
  6, 10, 10, 11,  9,  9, 11, 10, 10, 11, 11, 11,  9, 10, 10,  9,
  9, 12, 13, 12, 12, 11, 13, 12, 13, 13, 13, 13, 12, 12, 13, 11,
 12, 13, 16, 16, 16, 13, 16, 14, 16, 16, 16, 16, 16, 14, 16, 13,
  9, 13, 13, 13, 13, 13, 13, 13, 13, 14, 13, 13, 13, 13, 12, 11,
 10, 14, 14, 13, 14, 13, 14, 13, 16, 16, 14, 15, 14, 14, 14, 12,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 10, 14, 14, 16, 11, 12, 14, 13, 14, 16, 16, 16, 12, 13, 13, 12,
 12, 16, 16, 16, 13, 13, 16, 14, 16, 16, 16, 16, 16, 14, 16, 13,
 13, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  6, 10, 10, 10, 10, 11, 11, 11,  9, 11,  9, 10,  9, 10, 10,  9,
  9, 13, 13, 13, 13, 13, 14, 13, 12, 13, 13, 12, 13, 12, 13, 11,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
  8, 13, 12, 12, 13, 13, 13, 13, 11, 13, 10, 12, 12, 13, 12, 11,
 10, 14, 13, 13, 16, 16, 16, 14, 14, 14, 13, 13, 14, 14, 14, 12,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 11, 16, 13, 16, 16, 16, 16, 16, 14, 16, 12, 13, 16, 16, 14, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  8, 13, 13, 13, 11, 12, 13, 13, 11, 13, 12, 13, 10, 12, 12, 11,
 10, 14, 16, 16, 14, 13, 16, 14, 14, 16, 16, 14, 13, 13, 14, 12,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 10, 16, 14, 16, 14, 14, 14, 14, 13, 16, 13, 14, 13, 14, 12, 12,
 10, 14, 14, 14, 14, 16, 16, 14, 14, 16, 14, 14, 14, 14, 14, 12,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 13, 16, 16, 16, 14, 16, 16, 16, 12, 14, 14, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  9, 14, 13, 14, 13, 14, 16, 16, 11, 13, 12, 13, 11, 13, 12, 12,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 14, 16, 16, 16, 16, 16, 13, 16, 12, 13, 14, 16, 13, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 14, 16, 12, 16, 16, 16, 14, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 14, 16, 16, 16, 13, 16, 14, 16, 12, 13, 13, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 16, 12, 16, 14, 14,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13,
},
{
  1,  5,  5,  6,  5,  6,  7,  8,  5,  7,  6,  8,  6,  7,  7,  7,
  5,  9, 10, 10, 10, 10, 12, 11, 10, 11, 11, 11, 10, 11, 12, 10,
  9, 11, 13, 12, 13, 12, 16, 14, 16, 14, 16, 16, 16, 13, 16, 13,
  5, 10,  9, 10, 10, 11, 11, 11, 10, 11,  9, 11, 10, 11, 11, 10,
  8, 11, 11, 11, 12, 13, 13, 13, 12, 13, 12, 12, 13, 13, 13, 12,
 11, 13, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  9, 14, 11, 12, 14, 16, 13, 14, 13, 16, 12, 14, 16, 16, 13, 13,
 11, 16, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 14, 14, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  5, 10, 11, 11,  9, 10, 11, 11, 10, 12, 11, 12,  9, 11, 11, 11,
  8, 12, 13, 13, 11, 11, 14, 13, 13, 14, 13, 16, 12, 12, 13, 12,
 11, 13, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  9, 13, 12, 13, 12, 13, 13, 14, 13, 16, 13, 16, 13, 16, 13, 13,
 10, 14, 13, 14, 13, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  9, 14, 16, 16, 11, 12, 14, 16, 13, 16, 16, 16, 12, 14, 13, 13,
 11, 16, 16, 16, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 14, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  5, 10, 10, 11, 10, 11, 12, 12,  8, 11, 10, 11,  9, 11, 11, 11,
  9, 12, 13, 13, 13, 13, 16, 16, 12, 13, 13, 13, 13, 13, 16, 13,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  8, 13, 11, 13, 12, 13, 13, 14, 11, 13, 10, 13, 12, 14, 12, 12,
 10, 14, 13, 14, 16, 16, 16, 16, 13, 16, 13, 14, 16, 16, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 13, 16, 16, 16, 16, 16, 13, 16, 12, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  8, 13, 13, 13, 11, 13, 14, 16, 11, 13, 13, 14, 10, 12, 12, 12,
 10, 14, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16, 13, 13, 16, 14,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 10, 16, 14, 16, 13, 16, 16, 16, 13, 16, 13, 16, 13, 16, 13, 14,
 10, 16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 13,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 10, 16, 16, 16, 13, 16, 16, 16, 14, 16, 16, 16, 12, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  9, 14, 13, 16, 13, 16, 16, 16, 10, 14, 12, 14, 11, 13, 13, 13,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 16, 16, 16, 16, 12, 16, 12, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 16, 16, 16, 16, 13, 16, 13, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 10, 16, 16, 16, 14, 16, 16, 16, 12, 16, 16, 16, 12, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 11, 16, 16, 16, 14, 16, 16, 16, 14, 16, 16, 16, 12, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 10, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 14,
}
};


static const uint8_t rv34_inter_cbpvlc[NUM_INTER_TABLES][4][CBP_VLC_SIZE] = {
{
 { 0,  6,  6,  3,  6,  4,  5,  3,  6,  5,  4,  3,  3,  4,  4,  3 },
 { 0,  6,  6,  4,  6,  4,  5,  3,  6,  5,  4,  3,  4,  4,  4,  2 },
 { 0,  7,  7,  4,  7,  5,  5,  4,  7,  5,  5,  4,  5,  4,  4,  1 },
 { 0,  7,  7,  5,  7,  5,  6,  4,  7,  6,  5,  3,  5,  4,  4,  1 }
},
{
 { 0,  6,  6,  3,  6,  3,  5,  4,  6,  5,  3,  4,  3,  4,  4,  3 },
 { 0,  6,  6,  4,  6,  4,  4,  4,  6,  4,  4,  3,  4,  4,  4,  2 },
 { 0,  6,  6,  4,  6,  4,  5,  4,  6,  5,  4,  3,  4,  4,  3,  2 },
 { 0,  7,  7,  5,  7,  5,  6,  4,  7,  6,  5,  3,  5,  4,  4,  1 }
},
{
 { 0,  6,  6,  3,  6,  3,  5,  4,  6,  5,  3,  4,  3,  4,  4,  3 },
 { 0,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4,  4,  4,  4,  4,  2 },
 { 0,  6,  6,  4,  6,  4,  5,  3,  6,  5,  4,  3,  4,  4,  4,  2 },
 { 0,  7,  7,  5,  7,  5,  6,  4,  7,  6,  5,  3,  5,  4,  4,  1 }
},
{
 { 0,  6,  6,  3,  6,  3,  5,  4,  6,  5,  3,  4,  3,  4,  4,  3 },
 { 0,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4,  4,  4,  4,  4,  2 },
 { 0,  6,  6,  4,  6,  4,  5,  3,  6,  5,  4,  3,  4,  4,  4,  2 },
 { 0,  7,  7,  4,  7,  5,  6,  4,  7,  6,  5,  4,  4,  4,  4,  1 }
},
{
 { 0,  5,  5,  3,  5,  3,  5,  4,  5,  5,  3,  4,  3,  4,  4,  4 },
 { 0,  5,  5,  3,  5,  4,  5,  4,  5,  5,  3,  4,  3,  4,  4,  3 },
 { 0,  6,  6,  4,  6,  4,  5,  4,  6,  5,  4,  3,  4,  4,  3,  2 },
 { 0,  7,  7,  4,  7,  5,  6,  4,  7,  6,  5,  4,  4,  4,  4,  1 }
},
{
 { 0,  5,  5,  3,  5,  3,  5,  4,  5,  5,  3,  4,  3,  4,  4,  4 },
 { 0,  5,  5,  3,  5,  4,  5,  4,  5,  5,  3,  4,  3,  4,  4,  3 },
 { 0,  5,  5,  3,  5,  4,  4,  4,  5,  4,  4,  4,  3,  4,  4,  3 },
 { 0,  6,  6,  4,  6,  4,  5,  4,  6,  5,  4,  3,  4,  4,  3,  2 }
},
{
 { 0,  4,  4,  3,  4,  3,  5,  5,  4,  5,  3,  5,  3,  5,  4,  5 },
 { 0,  4,  4,  3,  4,  4,  5,  4,  4,  5,  3,  5,  3,  5,  4,  4 },
 { 0,  4,  4,  3,  4,  4,  5,  4,  4,  5,  4,  4,  3,  4,  4,  4 },
 { 0,  4,  4,  3,  5,  4,  5,  4,  5,  5,  4,  4,  3,  4,  4,  3 }
}
};


static const uint8_t rv34_table_inter_firstpat[NUM_INTER_TABLES][2][FIRSTBLK_VLC_SIZE] = {
  {
    {
       0,  7,  5,  7,  5,  7,  6,  6,  7, 10,  7,  9,  8,  9,  8,  7,
      12, 14, 11, 12, 12, 12, 11,  9,  6,  9,  6,  8,  7,  9,  7,  7,
       8, 11,  8,  9,  9, 10,  9,  8, 13, 15, 12, 12, 12, 13, 11,  9,
      10, 13,  9, 10, 11, 12,  9,  8, 12, 14, 10, 11, 12, 13, 10,  9,
      16, 16, 12, 12, 14, 13, 11,  9,  6,  9,  7,  9,  7,  9,  8,  7,
       9, 11,  9, 10,  9, 10,  9,  8, 14, 16, 12, 12, 13, 13, 11,  9,
       8, 11,  8, 10,  9, 10,  9,  8, 10, 13, 10, 11, 10, 11,  9,  8,
      14, 16, 12, 12, 13, 13, 11,  9, 12, 14, 10, 11, 12, 13, 10,  9,
      13, 16, 11, 12, 13, 13, 10,  9, 16, 16, 13, 12, 14, 14, 11,  9,
      11, 13, 11, 12, 10, 11, 10,  9, 13, 14, 12, 12, 11, 12, 10,  9,
      16, 16, 13, 13, 13, 13, 11,  9, 12, 15, 12, 12, 11, 12, 10,  9,
      13, 16, 13, 13, 12, 12, 11,  9, 16, 16, 14, 13, 13, 13, 11,  9,
      14, 16, 13, 13, 13, 14, 11,  9, 16, 16, 13, 13, 14, 14, 11,  9,
      16, 16, 13, 13, 14, 13, 11,  8,  4,  9,  6,  8,  6,  9,  7,  7,
       8, 11,  8,  9,  9, 10,  8,  8, 13, 15, 12, 12, 13, 13, 11,  9,
       7, 10,  7,  9,  8, 10,  8,  8,  9, 12,  9, 10, 10, 11,  9,  8,
      14, 16, 12, 12, 13, 13, 11,  9, 11, 13,  9, 10, 11, 12,  9,  8,
      12, 14, 10, 11, 12, 13, 10,  9, 16, 16, 13, 12, 14, 14, 11,  9,
       7, 10,  8,  9,  8, 10,  8,  8, 10, 12, 10, 11, 10, 11,  9,  8,
      14, 16, 13, 13, 13, 13, 11,  9,  9, 12,  9, 10,  9, 11,  9,  8,
      11, 13, 10, 11, 10, 11, 10,  9, 15, 16, 13, 13, 13, 13, 11,  9,
      12, 14, 11, 11, 12, 13, 10,  9, 13, 16, 11, 12, 13, 13, 10,  9,
      16, 16, 12, 12, 14, 13, 11,  8, 11, 14, 11, 12, 10, 11, 10,  9,
      13, 15, 12, 13, 11, 12, 10,  9, 16, 16, 14, 13, 13, 13, 11,  9,
      12, 15, 12, 13, 11, 12, 10,  9, 13, 16, 13, 13, 12, 12, 11,  9,
      16, 16, 14, 13, 13, 13, 11,  9, 15, 16, 13, 13, 13, 13, 11,  9,
      16, 16, 13, 13, 13, 13, 11,  9, 16, 16, 13, 12, 13, 13, 10,  7,
       8, 11,  8, 10,  9, 11,  9,  9, 10, 13, 10, 11, 11, 12, 10,  9,
      15, 16, 13, 13, 14, 14, 12, 10,  9, 12,  9, 11, 10, 11,  9,  9,
      12, 14, 11, 11, 11, 12, 10,  9, 16, 16, 13, 13, 14, 14, 12, 10,
      12, 14, 10, 11, 12, 13, 10,  9, 14, 16, 11, 12, 13, 14, 10,  9,
      16, 16, 13, 13, 15, 14, 11,  9,  9, 12, 10, 11,  9, 11, 10,  9,
      12, 14, 11, 12, 11, 12, 10,  9, 16, 16, 14, 13, 14, 14, 12, 10,
      11, 14, 10, 12, 11, 12, 10,  9, 12, 15, 11, 12, 12, 13, 11, 10,
      16, 16, 14, 13, 14, 14, 12, 10, 13, 16, 11, 12, 13, 14, 11,  9,
      14, 16, 12, 12, 13, 14, 11,  9, 16, 16, 13, 13, 14, 14, 11,  9,
      12, 15, 12, 13, 10, 12, 10,  9, 14, 16, 13, 13, 11, 12, 11, 10,
      16, 16, 14, 14, 14, 13, 12,  9, 13, 16, 13, 13, 12, 13, 11, 10,
      14, 16, 13, 13, 12, 13, 11, 10, 16, 16, 14, 14, 13, 13, 12,  9,
      15, 16, 13, 13, 13, 14, 11,  9, 16, 16, 13, 13, 13, 14, 11,  9,
      16, 16, 13, 12, 13, 13, 10,  8, 10, 13, 10, 11, 10, 12, 10,  9,
      12, 14, 11, 12, 12, 13, 11, 10, 16, 16, 13, 13, 14, 14, 12,  9,
      11, 14, 10, 11, 11, 12, 10,  9, 13, 16, 11, 12, 12, 13, 11, 10,
      16, 16, 14, 13, 14, 14, 12,  9, 12, 15, 10, 11, 12, 13,  9,  8,
      14, 16, 11, 11, 13, 14, 10,  8, 16, 16, 12, 12, 14, 14, 10,  8,
      11, 14, 11, 12, 11, 12, 10,  9, 13, 16, 12, 13, 12, 13, 11, 10,
      16, 16, 14, 13, 14, 14, 12,  9, 12, 15, 11, 12, 11, 13, 10, 10,
      13, 16, 12, 13, 12, 13, 11, 10, 16, 16, 14, 13, 14, 14, 12,  9,
      13, 16, 11, 11, 13, 13, 10,  8, 14, 16, 11, 12, 13, 14, 10,  8,
      16, 16, 12, 12, 14, 14, 10,  8, 12, 15, 12, 13, 10, 11, 10,  9,
      14, 16, 13, 13, 11, 12, 10,  9, 16, 16, 14, 13, 13, 13, 11,  8,
      13, 16, 12, 13, 11, 12, 10,  9, 14, 16, 13, 13, 12, 12, 10,  9,
      16, 16, 14, 13, 13, 12, 10,  8, 14, 16, 12, 12, 12, 13, 10,  8,
      14, 16, 12, 12, 12, 13, 10,  7, 16, 16, 11, 11, 12, 11,  8,  5,
    },
    {
       0,  7,  4,  8,  5,  8,  7,  8,  6, 10,  7, 10,  8, 10,  9,  9,
      13, 16, 12, 13, 13, 14, 12, 12,  4, 10,  6,  9,  8, 11,  8,  9,
       8, 12,  8, 11, 10, 12, 10, 10, 14, 16, 12, 13, 14, 15, 12, 12,
       9, 14,  9, 11, 12, 14, 11, 11, 11, 15, 10, 12, 13, 14, 11, 11,
      15, 16, 13, 14, 15, 16, 13, 12,  5, 10,  7, 10,  7, 10,  9,  9,
       8, 12,  9, 11, 10, 11, 10, 10, 14, 16, 13, 14, 14, 14, 12, 12,
       8, 12,  8, 11, 10, 12, 10, 10, 10, 14, 10, 12, 11, 13, 10, 11,
      15, 16, 13, 14, 14, 15, 13, 12, 11, 16, 10, 12, 13, 15, 11, 11,
      13, 16, 11, 13, 14, 15, 12, 12, 16, 16, 14, 14, 16, 16, 13, 12,
      11, 15, 11, 13, 11, 13, 11, 11, 13, 16, 12, 14, 12, 13, 12, 12,
      16, 16, 14, 15, 15, 15, 13, 12, 12, 16, 12, 14, 12, 14, 12, 12,
      14, 16, 13, 14, 13, 14, 12, 12, 16, 16, 14, 16, 16, 16, 13, 12,
      14, 16, 13, 14, 15, 16, 13, 12, 16, 16, 14, 15, 16, 16, 13, 12,
      16, 16, 15, 16, 16, 16, 13, 12,  2,  9,  5,  8,  6,  9,  8,  9,
       7, 11,  8, 10,  9, 11,  9, 10, 13, 16, 12, 13, 14, 14, 12, 12,
       5, 11,  6, 10,  9, 11,  9,  9,  9, 13,  9, 11, 10, 12, 10, 10,
      14, 16, 12, 14, 14, 15, 12, 12,  9, 14,  9, 11, 12, 14, 10, 11,
      11, 16, 10, 12, 13, 14, 11, 11, 16, 16, 13, 14, 15, 16, 13, 12,
       6, 11,  7, 10,  8, 11,  9,  9,  9, 13,  9, 11, 10, 12, 10, 10,
      14, 16, 13, 14, 14, 14, 12, 12,  8, 13,  8, 11, 10, 12, 10, 10,
      10, 13, 10, 12, 11, 13, 10, 11, 14, 16, 13, 14, 14, 15, 12, 12,
      11, 15, 10, 12, 13, 15, 11, 11, 12, 16, 11, 13, 13, 15, 12, 11,
      16, 16, 13, 14, 15, 16, 13, 12, 11, 15, 11, 13, 10, 13, 11, 11,
      13, 16, 12, 14, 12, 13, 12, 11, 16, 16, 14, 15, 15, 15, 13, 12,
      12, 16, 12, 13, 12, 14, 12, 12, 13, 16, 12, 14, 13, 14, 12, 12,
      16, 16, 14, 15, 15, 15, 13, 12, 14, 16, 13, 14, 15, 16, 12, 12,
      16, 16, 13, 14, 15, 16, 12, 12, 16, 16, 14, 15, 16, 16, 13, 12,
       6, 12,  7, 10,  9, 12,  9, 10,  9, 13,  9, 12, 11, 13, 11, 11,
      14, 16, 13, 14, 15, 15, 13, 12,  8, 13,  8, 11, 10, 13, 10, 10,
      10, 14, 10, 12, 12, 14, 11, 11, 15, 16, 13, 14, 16, 16, 13, 12,
      10, 15,  9, 12, 12, 15, 11, 11, 12, 16, 11, 13, 14, 16, 12, 12,
      16, 16, 14, 14, 16, 16, 13, 12,  8, 13,  9, 11, 10, 12, 10, 11,
      11, 14, 11, 12, 11, 13, 11, 11, 16, 16, 14, 15, 15, 16, 13, 12,
      10, 14, 10, 12, 11, 13, 11, 11, 11, 15, 11, 13, 12, 14, 11, 11,
      15, 16, 13, 14, 15, 16, 13, 12, 12, 16, 11, 13, 13, 16, 12, 12,
      13, 16, 11, 13, 14, 16, 12, 12, 16, 16, 13, 14, 16, 16, 13, 12,
      12, 16, 12, 14, 11, 13, 11, 11, 13, 16, 13, 14, 12, 14, 12, 12,
      16, 16, 15, 16, 16, 16, 14, 13, 13, 16, 12, 14, 12, 14, 12, 12,
      14, 16, 13, 14, 13, 14, 12, 12, 16, 16, 14, 16, 14, 16, 13, 12,
      15, 16, 13, 15, 15, 16, 13, 12, 15, 16, 13, 15, 14, 16, 13, 12,
      16, 16, 14, 15, 15, 16, 13, 11,  8, 13,  8, 11, 10, 13, 10, 11,
      11, 15, 10, 12, 12, 14, 11, 11, 15, 16, 13, 14, 15, 15, 13, 12,
       9, 14,  9, 12, 11, 14, 10, 11, 11, 16, 10, 12, 13, 14, 11, 11,
      16, 16, 13, 14, 15, 16, 13, 12, 11, 15,  9, 12, 12, 14, 10, 10,
      12, 16, 11, 12, 14, 15, 11, 11, 16, 16, 13, 14, 16, 16, 12, 11,
       9, 14, 10, 12, 11, 13, 11, 11, 12, 16, 11, 13, 12, 14, 11, 11,
      16, 16, 14, 14, 15, 15, 13, 12, 10, 15, 10, 12, 12, 14, 11, 11,
      12, 16, 11, 13, 13, 14, 11, 11, 16, 16, 14, 14, 15, 16, 13, 12,
      12, 16, 10, 12, 13, 15, 11, 11, 13, 16, 11, 13, 14, 15, 11, 11,
      16, 16, 13, 13, 15, 16, 12, 11, 12, 16, 11, 13, 10, 13, 11, 11,
      14, 16, 13, 14, 12, 14, 11, 11, 16, 16, 15, 16, 14, 15, 13, 11,
      13, 16, 12, 14, 12, 14, 11, 11, 13, 16, 12, 14, 12, 14, 11, 11,
      16, 16, 14, 15, 14, 14, 12, 11, 14, 16, 12, 13, 13, 15, 11, 11,
      14, 16, 12, 13, 13, 14, 11, 11, 15, 16, 12, 13, 13, 13, 10,  9,
    },
  },
  {
    {
       0,  7,  4,  7,  5,  7,  6,  6,  6, 10,  7,  8,  8,  9,  8,  7,
      13, 14, 11, 12, 12, 12, 11,  9,  5,  9,  6,  8,  7,  9,  7,  7,
       8, 11,  8,  9,  9, 10,  9,  8, 13, 16, 12, 12, 12, 13, 11,  9,
      10, 13,  8, 10, 11, 12,  9,  9, 12, 14, 10, 11, 12, 13, 10,  9,
      15, 16, 12, 12, 14, 14, 11,  9,  6, 10,  7,  9,  7,  9,  8,  7,
       8, 11,  9, 10,  9, 10,  9,  8, 14, 16, 12, 12, 13, 12, 11,  9,
       8, 11,  8, 10,  9, 10,  9,  8, 10, 13, 10, 11, 10, 11,  9,  9,
      14, 16, 12, 12, 13, 13, 11,  9, 12, 15, 10, 11, 12, 13, 10,  9,
      13, 16, 11, 12, 13, 13, 10,  9, 16, 16, 12, 13, 14, 14, 11,  9,
      10, 14, 11, 12,  9, 11, 10,  9, 12, 15, 12, 13, 11, 12, 11,  9,
      16, 16, 13, 13, 13, 13, 11,  9, 12, 15, 12, 13, 11, 12, 11,  9,
      13, 16, 12, 13, 12, 13, 11, 10, 16, 16, 13, 13, 13, 13, 11,  9,
      14, 16, 13, 13, 13, 14, 11, 10, 16, 16, 13, 13, 13, 14, 11, 10,
      16, 16, 13, 13, 14, 14, 11,  9,  4,  9,  6,  8,  6,  9,  7,  7,
       8, 11,  8,  9,  9, 10,  9,  8, 13, 15, 12, 12, 13, 13, 11,  9,
       6, 10,  7,  9,  8, 10,  8,  8,  9, 12,  9, 10, 10, 11,  9,  8,
      14, 16, 12, 12, 13, 13, 11, 10, 10, 13,  8, 10, 11, 12,  9,  9,
      12, 15, 10, 11, 12, 13, 10,  9, 16, 16, 12, 12, 14, 14, 11,  9,
       7, 11,  8,  9,  7, 10,  8,  8,  9, 12, 10, 11,  9, 11,  9,  9,
      14, 16, 12, 13, 13, 13, 11, 10,  9, 12,  9, 10,  9, 11,  9,  9,
      10, 13, 10, 11, 10, 11, 10,  9, 14, 16, 12, 13, 13, 13, 11,  9,
      12, 15, 10, 11, 12, 13, 10,  9, 13, 16, 11, 12, 13, 13, 10,  9,
      16, 16, 12, 12, 14, 14, 11,  9, 10, 14, 11, 12,  9, 11, 10,  9,
      12, 16, 12, 13, 11, 12, 11,  9, 16, 16, 14, 14, 13, 13, 11,  9,
      12, 16, 12, 13, 11, 12, 10, 10, 13, 16, 12, 13, 11, 12, 11, 10,
      16, 16, 13, 13, 13, 13, 11,  9, 14, 16, 13, 13, 13, 14, 11,  9,
      15, 16, 13, 13, 13, 14, 11,  9, 16, 16, 13, 13, 13, 13, 10,  8,
       7, 11,  8, 10,  9, 11,  9,  9, 10, 13, 10, 11, 11, 12, 10, 10,
      15, 16, 13, 13, 14, 14, 12, 10,  9, 13,  9, 11, 10, 12, 10,  9,
      11, 14, 10, 12, 12, 13, 10, 10, 16, 16, 13, 13, 14, 14, 12, 10,
      11, 15,  9, 11, 12, 13, 10,  9, 13, 16, 11, 12, 13, 14, 11, 10,
      16, 16, 13, 13, 15, 15, 11, 10,  9, 13, 10, 11,  9, 11, 10,  9,
      11, 14, 11, 12, 11, 12, 11, 10, 16, 16, 14, 14, 14, 14, 12, 10,
      10, 14, 10, 12, 11, 12, 10, 10, 12, 15, 11, 12, 12, 13, 11, 10,
      16, 16, 13, 13, 14, 14, 12, 10, 13, 16, 11, 12, 13, 14, 11, 10,
      13, 16, 11, 12, 13, 14, 11, 10, 16, 16, 12, 13, 14, 14, 11,  9,
      11, 15, 12, 13, 10, 12, 10, 10, 13, 16, 13, 14, 11, 13, 11, 10,
      16, 16, 14, 14, 14, 14, 12, 10, 13, 16, 13, 13, 11, 13, 11, 10,
      14, 16, 13, 14, 12, 13, 11, 10, 16, 16, 14, 14, 13, 13, 12, 10,
      15, 16, 13, 14, 14, 14, 11, 10, 15, 16, 13, 13, 13, 14, 11, 10,
      16, 16, 12, 13, 13, 13, 10,  8,  9, 13, 10, 11, 10, 12, 10, 10,
      12, 15, 11, 12, 12, 13, 11, 10, 16, 16, 14, 13, 14, 14, 12, 10,
      10, 14, 10, 12, 11, 13, 10, 10, 13, 16, 11, 12, 12, 14, 11, 10,
      16, 16, 13, 13, 14, 14, 12, 10, 12, 16,  9, 11, 12, 14, 10,  9,
      13, 16, 10, 12, 13, 14, 10,  9, 16, 16, 12, 12, 14, 14, 11,  9,
      10, 14, 11, 12, 10, 12, 10, 10, 13, 16, 12, 13, 12, 13, 11, 10,
      16, 16, 14, 14, 14, 14, 12, 10, 11, 16, 11, 12, 11, 13, 11, 10,
      13, 16, 12, 13, 12, 14, 11, 10, 16, 16, 14, 14, 14, 14, 12, 10,
      13, 16, 11, 12, 13, 14, 10,  9, 14, 16, 11, 12, 13, 14, 10,  9,
      16, 16, 12, 12, 14, 14, 10,  8, 12, 16, 12, 13, 10, 12, 10,  9,
      14, 16, 13, 13, 11, 12, 11,  9, 16, 16, 14, 14, 13, 13, 11,  9,
      13, 16, 12, 13, 11, 12, 10,  9, 14, 16, 13, 13, 11, 13, 11,  9,
      16, 16, 14, 14, 13, 13, 11,  9, 14, 16, 12, 13, 12, 13, 10,  8,
      14, 16, 12, 12, 12, 13, 10,  8, 15, 16, 11, 11, 11, 12,  9,  6,
    },
    {
       0,  7,  4,  7,  5,  8,  7,  8,  5, 10,  7, 10,  8, 10,  9, 10,
      13, 16, 12, 14, 14, 14, 13, 12,  4, 10,  6,  9,  8, 11,  9,  9,
       8, 12,  8, 11, 10, 12, 10, 10, 14, 16, 13, 14, 14, 15, 13, 12,
       9, 14,  9, 12, 12, 14, 11, 11, 12, 16, 11, 13, 13, 15, 12, 12,
      15, 16, 14, 15, 15, 16, 13, 13,  5, 10,  7, 10,  7, 10,  9,  9,
       8, 12,  9, 11,  9, 11, 10, 10, 14, 16, 13, 14, 14, 15, 13, 12,
       7, 12,  8, 11, 10, 12, 10, 10, 10, 13, 10, 12, 11, 13, 11, 11,
      15, 16, 13, 15, 14, 16, 13, 13, 11, 16, 11, 13, 13, 16, 12, 12,
      13, 16, 12, 14, 14, 16, 12, 12, 16, 16, 14, 16, 16, 16, 14, 13,
      11, 15, 12, 14, 11, 13, 11, 12, 13, 16, 12, 14, 12, 14, 12, 12,
      16, 16, 14, 16, 14, 16, 13, 13, 13, 16, 12, 14, 12, 14, 12, 12,
      14, 16, 13, 15, 13, 15, 13, 13, 16, 16, 15, 16, 16, 16, 14, 13,
      15, 16, 13, 16, 15, 16, 13, 13, 16, 16, 14, 16, 16, 16, 14, 13,
      16, 16, 16, 16, 16, 16, 14, 13,  2,  9,  5,  8,  6,  9,  8,  9,
       7, 11,  8, 10,  9, 11,  9, 10, 14, 16, 13, 14, 14, 15, 13, 12,
       5, 11,  6, 10,  9, 11,  9, 10,  8, 13,  9, 11, 11, 12, 10, 11,
      14, 16, 13, 14, 14, 16, 13, 13,  9, 15,  9, 12, 12, 14, 11, 11,
      12, 16, 11, 13, 13, 15, 12, 12, 16, 16, 14, 15, 16, 16, 14, 13,
       6, 11,  7, 10,  8, 11,  9, 10,  9, 13,  9, 12, 10, 12, 10, 11,
      14, 16, 13, 14, 14, 15, 13, 13,  8, 12,  8, 11, 10, 12, 10, 11,
       9, 13, 10, 12, 11, 13, 11, 11, 14, 16, 13, 14, 14, 16, 13, 13,
      12, 16, 11, 13, 13, 15, 12, 12, 13, 16, 11, 13, 14, 16, 12, 12,
      16, 16, 14, 15, 16, 16, 13, 13, 11, 15, 11, 14, 10, 13, 11, 12,
      13, 16, 13, 15, 12, 14, 12, 12, 16, 16, 15, 16, 15, 16, 14, 13,
      12, 16, 12, 14, 12, 14, 12, 12, 13, 16, 13, 15, 13, 14, 12, 13,
      16, 16, 15, 16, 15, 16, 13, 13, 15, 16, 13, 16, 15, 16, 13, 13,
      16, 16, 14, 16, 16, 16, 13, 13, 16, 16, 15, 16, 16, 16, 14, 13,
       5, 12,  7, 10,  9, 12, 10, 10,  9, 13,  9, 12, 11, 13, 11, 11,
      15, 16, 13, 14, 15, 15, 13, 13,  7, 13,  8, 11, 10, 13, 10, 11,
      10, 14, 10, 12, 12, 14, 11, 12, 16, 16, 14, 15, 16, 16, 14, 13,
      10, 16,  9, 12, 13, 15, 11, 12, 13, 16, 11, 13, 14, 16, 12, 12,
      16, 16, 14, 16, 16, 16, 14, 13,  8, 13,  9, 12,  9, 12, 10, 11,
      11, 15, 11, 13, 11, 13, 11, 12, 16, 16, 14, 16, 16, 16, 14, 13,
       9, 14, 10, 12, 11, 13, 11, 12, 11, 15, 11, 13, 12, 14, 12, 12,
      16, 16, 14, 16, 15, 16, 14, 13, 12, 16, 11, 14, 14, 16, 12, 12,
      13, 16, 12, 14, 14, 16, 13, 13, 16, 16, 13, 15, 16, 16, 14, 13,
      11, 16, 12, 14, 10, 13, 12, 12, 13, 16, 13, 15, 12, 14, 12, 13,
      16, 16, 16, 16, 16, 16, 14, 14, 13, 16, 13, 15, 12, 15, 12, 13,
      13, 16, 13, 15, 12, 15, 13, 13, 16, 16, 15, 16, 14, 16, 14, 13,
      16, 16, 14, 16, 16, 16, 14, 13, 15, 16, 14, 16, 15, 16, 14, 13,
      16, 16, 14, 16, 15, 16, 13, 12,  8, 14,  9, 12, 10, 14, 11, 12,
      11, 16, 10, 13, 12, 14, 12, 12, 16, 16, 14, 15, 15, 16, 14, 13,
       9, 15,  9, 12, 12, 14, 11, 12, 12, 16, 11, 13, 13, 15, 12, 12,
      16, 16, 14, 15, 16, 16, 14, 13, 11, 16,  9, 12, 13, 15, 11, 11,
      13, 16, 11, 13, 14, 16, 12, 12, 16, 16, 14, 14, 16, 16, 13, 12,
       9, 15, 10, 13, 11, 14, 11, 12, 12, 16, 11, 14, 12, 14, 12, 12,
      16, 16, 14, 16, 16, 16, 14, 13, 10, 16, 10, 13, 12, 15, 12, 12,
      12, 16, 12, 14, 13, 15, 12, 12, 16, 16, 14, 16, 16, 16, 14, 13,
      12, 16, 11, 13, 13, 16, 12, 12, 13, 16, 11, 13, 14, 16, 12, 12,
      16, 16, 13, 14, 16, 16, 13, 12, 11, 16, 12, 14, 10, 13, 11, 12,
      13, 16, 13, 15, 12, 14, 12, 12, 16, 16, 16, 16, 15, 16, 13, 12,
      12, 16, 12, 15, 12, 14, 12, 12, 13, 16, 13, 15, 12, 14, 12, 12,
      16, 16, 15, 16, 14, 15, 13, 12, 14, 16, 13, 14, 13, 16, 12, 12,
      13, 16, 12, 14, 13, 15, 12, 12, 14, 16, 12, 13, 13, 14, 11, 10,
    },
  },
  {
    {
       0,  7,  4,  7,  5,  7,  6,  6,  6, 10,  7,  8,  8,  9,  8,  8,
      13, 14, 11, 12, 12, 12, 11, 10,  5,  9,  6,  8,  7,  9,  7,  7,
       8, 11,  8,  9,  9, 10,  9,  8, 13, 16, 12, 12, 13, 13, 11, 10,
      10, 14,  8, 10, 11, 13,  9,  9, 12, 15, 10, 11, 12, 13, 10, 10,
      16, 16, 12, 13, 14, 14, 11, 10,  5, 10,  7,  9,  6,  9,  8,  8,
       8, 11,  9, 10,  9, 10,  9,  8, 14, 16, 12, 12, 13, 13, 11, 10,
       8, 12,  8, 10,  9, 10,  9,  9, 10, 13,  9, 11, 10, 11,  9,  9,
      14, 16, 12, 13, 13, 13, 11, 10, 12, 16, 10, 12, 12, 13, 10, 10,
      13, 16, 11, 12, 13, 14, 11, 10, 16, 16, 12, 13, 14, 14, 11, 10,
      10, 14, 11, 13,  9, 11, 10, 10, 12, 16, 12, 13, 11, 12, 11, 10,
      16, 16, 13, 14, 13, 13, 12, 10, 12, 16, 12, 13, 11, 13, 11, 10,
      13, 16, 12, 13, 12, 13, 11, 10, 16, 16, 13, 14, 13, 14, 12, 10,
      14, 16, 13, 14, 13, 14, 12, 11, 16, 16, 13, 14, 14, 15, 12, 11,
      16, 16, 13, 14, 14, 14, 11, 10,  3,  9,  5,  8,  6,  9,  7,  7,
       8, 11,  8, 10,  9, 10,  9,  8, 14, 15, 12, 12, 13, 13, 11, 10,
       6, 11,  6,  9,  8, 10,  8,  8,  9, 12,  9, 10, 10, 11,  9,  9,
      14, 16, 12, 13, 13, 13, 11, 10, 10, 14,  8, 11, 12, 13,  9,  9,
      12, 16, 10, 11, 12, 13, 10, 10, 16, 16, 12, 13, 14, 14, 11, 10,
       6, 11,  8, 10,  7, 10,  8,  8,  9, 12, 10, 11,  9, 11,  9,  9,
      14, 16, 12, 13, 13, 13, 12, 10,  9, 12,  9, 11,  9, 11,  9,  9,
      10, 13, 10, 11, 10, 12, 10,  9, 14, 16, 12, 13, 13, 13, 11, 10,
      12, 16, 10, 12, 12, 14, 10, 10, 13, 16, 10, 12, 13, 14, 11, 10,
      16, 16, 12, 13, 14, 14, 11, 10, 10, 15, 11, 13,  9, 11, 10, 10,
      12, 16, 12, 13, 11, 12, 11, 10, 16, 16, 14, 14, 13, 14, 12, 10,
      12, 16, 12, 13, 11, 13, 11, 10, 13, 16, 12, 13, 11, 13, 11, 10,
      16, 16, 13, 14, 13, 13, 12, 10, 14, 16, 13, 14, 14, 14, 11, 11,
      15, 16, 13, 14, 13, 14, 11, 10, 16, 16, 13, 13, 13, 14, 11,  9,
       7, 12,  8, 11,  9, 11,  9, 10, 10, 14, 10, 12, 11, 12, 11, 10,
      16, 16, 13, 13, 14, 14, 12, 11,  9, 13,  9, 11, 10, 12, 10, 10,
      11, 15, 10, 12, 12, 13, 11, 10, 16, 16, 13, 14, 14, 14, 12, 11,
      11, 16,  9, 11, 12, 14, 10, 10, 13, 16, 10, 12, 13, 14, 11, 10,
      16, 16, 13, 14, 16, 16, 12, 11,  9, 13, 10, 12,  9, 12, 10, 10,
      11, 15, 11, 13, 11, 13, 11, 11, 16, 16, 14, 14, 14, 14, 13, 11,
      10, 14, 10, 12, 11, 13, 11, 10, 12, 16, 11, 13, 12, 13, 11, 11,
      16, 16, 13, 14, 14, 14, 12, 11, 13, 16, 11, 13, 13, 14, 11, 11,
      13, 16, 11, 13, 13, 14, 11, 11, 16, 16, 12, 13, 14, 15, 12, 10,
      11, 16, 12, 14, 10, 12, 11, 10, 13, 16, 13, 14, 11, 13, 11, 11,
      16, 16, 15, 16, 14, 14, 13, 11, 13, 16, 13, 14, 12, 13, 11, 11,
      13, 16, 13, 14, 12, 13, 11, 11, 16, 16, 14, 14, 13, 14, 12, 11,
      15, 16, 13, 14, 14, 16, 12, 11, 14, 16, 13, 14, 13, 14, 12, 11,
      16, 16, 12, 13, 13, 14, 11,  9,  9, 14, 10, 12, 10, 13, 11, 11,
      12, 16, 12, 13, 12, 14, 12, 11, 16, 16, 14, 14, 14, 14, 13, 11,
      10, 16, 10, 13, 12, 14, 11, 11, 13, 16, 12, 13, 13, 14, 12, 11,
      16, 16, 14, 14, 15, 15, 13, 11, 12, 16,  9, 12, 13, 14, 10, 10,
      14, 16, 11, 12, 13, 15, 11, 10, 16, 16, 13, 13, 15, 16, 11, 10,
      10, 16, 11, 13, 11, 13, 11, 11, 13, 16, 12, 14, 12, 14, 12, 11,
      16, 16, 14, 14, 14, 14, 13, 11, 11, 16, 11, 13, 12, 14, 11, 11,
      13, 16, 12, 14, 13, 14, 12, 11, 16, 16, 14, 14, 14, 15, 13, 11,
      13, 16, 11, 13, 13, 14, 11, 10, 14, 16, 11, 13, 13, 14, 11, 10,
      16, 16, 12, 13, 14, 15, 11,  9, 12, 16, 12, 14, 10, 13, 11, 10,
      14, 16, 13, 14, 11, 13, 11, 10, 16, 16, 14, 15, 13, 14, 12, 10,
      13, 16, 13, 14, 11, 13, 11, 10, 14, 16, 13, 14, 12, 13, 11, 10,
      16, 16, 14, 14, 13, 13, 11, 10, 14, 16, 12, 13, 13, 14, 11,  9,
      14, 16, 12, 13, 12, 13, 10,  9, 14, 16, 11, 11, 12, 12,  9,  7,
    },
    {
       0,  7,  3,  8,  5,  8,  7,  9,  5, 10,  7, 10,  8, 11, 10, 10,
      14, 16, 14, 15, 14, 16, 14, 14,  4, 10,  6, 10,  8, 11,  9, 10,
       8, 12,  9, 11, 10, 12, 11, 11, 15, 16, 14, 16, 15, 16, 14, 14,
      10, 16, 10, 13, 13, 16, 12, 13, 13, 16, 12, 14, 14, 16, 13, 13,
      16, 16, 16, 16, 16, 16, 14, 15,  4, 10,  7, 10,  7, 10,  9, 10,
       8, 12,  9, 12, 10, 12, 11, 12, 14, 16, 14, 16, 15, 16, 14, 14,
       8, 12,  9, 12, 10, 13, 11, 12, 10, 14, 11, 13, 11, 14, 12, 13,
      16, 16, 14, 16, 16, 16, 14, 15, 12, 16, 12, 14, 14, 16, 13, 14,
      14, 16, 13, 16, 16, 16, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 12, 16, 11, 14, 13, 13, 13, 16, 13, 16, 13, 15, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 16, 13, 16, 13, 16, 13, 16, 13, 14,
      14, 16, 14, 16, 14, 16, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 15, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  2,  9,  5,  9,  6, 10,  8, 10,
       7, 11,  8, 11,  9, 12, 10, 11, 14, 16, 14, 16, 15, 16, 14, 14,
       5, 11,  6, 10,  9, 12, 10, 11,  9, 13,  9, 12, 11, 13, 11, 12,
      16, 16, 14, 16, 16, 16, 14, 14, 10, 16,  9, 13, 13, 16, 12, 13,
      13, 16, 12, 14, 14, 16, 13, 13, 16, 16, 16, 16, 16, 16, 16, 14,
       5, 11,  8, 11,  7, 11, 10, 11,  9, 13, 10, 13, 10, 13, 11, 12,
      16, 16, 14, 16, 16, 16, 14, 14,  8, 13,  9, 12, 10, 13, 11, 12,
      10, 14, 10, 13, 11, 14, 12, 12, 16, 16, 14, 16, 15, 16, 14, 14,
      12, 16, 12, 14, 14, 16, 13, 14, 14, 16, 12, 16, 15, 16, 13, 14,
      16, 16, 15, 16, 16, 16, 15, 15, 11, 16, 12, 16, 10, 14, 12, 13,
      13, 16, 14, 16, 13, 16, 13, 14, 16, 16, 16, 16, 16, 16, 15, 16,
      13, 16, 13, 16, 13, 16, 13, 14, 14, 16, 14, 16, 13, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 15, 16, 16, 16, 15, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16,
       5, 13,  7, 12,  9, 13, 11, 12, 10, 14, 10, 13, 11, 13, 12, 13,
      16, 16, 16, 16, 16, 16, 16, 15,  7, 14,  8, 12, 11, 14, 11, 12,
      11, 16, 11, 13, 13, 16, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 10, 14, 14, 16, 12, 13, 13, 16, 12, 15, 16, 16, 14, 14,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 14, 10, 13,  9, 13, 11, 12,
      11, 16, 12, 14, 12, 14, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 11, 14, 12, 14, 12, 13, 11, 16, 12, 14, 12, 15, 13, 13,
      16, 16, 15, 16, 16, 16, 15, 16, 13, 16, 12, 16, 15, 16, 14, 14,
      13, 16, 12, 16, 16, 16, 14, 14, 16, 16, 14, 16, 16, 16, 14, 16,
      11, 16, 13, 16, 10, 14, 12, 13, 14, 16, 14, 16, 13, 16, 14, 14,
      16, 16, 16, 16, 16, 16, 16, 16, 13, 16, 14, 16, 13, 16, 14, 15,
      13, 16, 14, 16, 13, 16, 14, 15, 16, 16, 16, 16, 15, 16, 15, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 15, 16,
      16, 16, 15, 16, 16, 16, 14, 14,  8, 16, 10, 14, 11, 16, 12, 13,
      12, 16, 12, 14, 13, 16, 13, 14, 16, 16, 16, 16, 16, 16, 16, 14,
      10, 16, 10, 14, 12, 16, 12, 13, 13, 16, 12, 15, 14, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 16, 15, 11, 16, 10, 13, 13, 16, 12, 13,
      14, 16, 12, 14, 15, 16, 13, 13, 16, 16, 16, 16, 16, 16, 15, 14,
      10, 16, 11, 14, 11, 16, 12, 13, 13, 16, 13, 16, 13, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 16, 15, 11, 16, 12, 14, 13, 16, 13, 14,
      13, 16, 13, 16, 14, 16, 13, 14, 16, 16, 16, 16, 16, 16, 16, 15,
      13, 16, 12, 14, 14, 16, 13, 13, 13, 16, 12, 15, 14, 16, 13, 13,
      16, 16, 14, 16, 16, 16, 14, 13, 11, 16, 12, 16, 11, 15, 12, 13,
      14, 16, 14, 16, 13, 16, 13, 14, 16, 16, 16, 16, 16, 16, 14, 14,
      12, 16, 13, 16, 12, 16, 13, 14, 13, 16, 14, 16, 13, 16, 13, 14,
      16, 16, 16, 16, 14, 16, 14, 14, 14, 16, 13, 16, 14, 16, 13, 13,
      13, 16, 13, 16, 14, 16, 13, 13, 15, 16, 13, 14, 13, 15, 12, 12,
    },
  },
  {
    {
       0,  7,  4,  6,  4,  7,  6,  7,  6,  9,  7,  8,  7,  9,  8,  8,
      13, 14, 12, 12, 12, 13, 11, 11,  5,  9,  5,  8,  7,  9,  7,  8,
       8, 11,  8, 10,  9, 10,  9,  9, 13, 15, 12, 13, 12, 13, 11, 11,
       9, 14,  8, 11, 11, 13, 10, 10, 11, 15, 10, 12, 12, 13, 10, 11,
      14, 16, 12, 13, 14, 14, 12, 11,  5,  9,  7,  9,  6,  9,  8,  8,
       8, 11,  8, 10,  8, 10,  9,  9, 13, 16, 12, 13, 13, 13, 11, 11,
       7, 11,  8, 10,  9, 11,  9,  9,  9, 13,  9, 11, 10, 11, 10, 10,
      14, 16, 12, 13, 13, 13, 12, 11, 11, 16, 10, 12, 12, 14, 11, 11,
      13, 16, 11, 13, 13, 14, 11, 11, 16, 16, 13, 14, 14, 15, 12, 11,
      10, 15, 11, 13,  9, 12, 10, 10, 12, 16, 12, 13, 11, 12, 11, 11,
      15, 16, 13, 14, 13, 14, 12, 11, 12, 16, 12, 14, 11, 13, 11, 11,
      13, 16, 12, 14, 12, 13, 12, 11, 16, 16, 13, 14, 14, 14, 12, 11,
      14, 16, 13, 14, 14, 15, 12, 12, 16, 16, 13, 14, 14, 16, 12, 12,
      16, 16, 14, 14, 14, 15, 12, 11,  3,  9,  5,  8,  6,  9,  7,  8,
       7, 11,  8, 10,  9, 10,  9,  9, 13, 14, 12, 13, 13, 13, 12, 11,
       6, 11,  6,  9,  8, 10,  8,  9,  9, 12,  8, 10, 10, 11,  9, 10,
      14, 16, 12, 13, 13, 14, 12, 11,  9, 14,  8, 11, 11, 13, 10, 10,
      12, 16, 10, 12, 12, 14, 11, 11, 16, 16, 12, 13, 14, 15, 12, 11,
       6, 11,  8, 10,  7, 10,  8,  9,  9, 12,  9, 11,  9, 11, 10, 10,
      14, 16, 13, 13, 13, 14, 12, 11,  8, 12,  9, 11,  9, 11,  9, 10,
      10, 13,  9, 11, 10, 12, 10, 10, 14, 16, 12, 13, 13, 14, 12, 11,
      12, 16, 10, 12, 12, 14, 11, 11, 12, 16, 10, 12, 13, 14, 11, 11,
      15, 16, 12, 13, 14, 14, 11, 11, 10, 15, 11, 13,  9, 12, 10, 10,
      12, 16, 12, 14, 11, 13, 11, 11, 16, 16, 14, 14, 14, 14, 12, 11,
      12, 16, 12, 14, 11, 13, 11, 11, 13, 16, 12, 14, 11, 13, 11, 11,
      16, 16, 13, 14, 13, 14, 12, 11, 14, 16, 13, 14, 14, 15, 12, 11,
      14, 16, 13, 14, 13, 15, 12, 11, 16, 16, 13, 14, 13, 14, 11, 10,
       6, 13,  8, 11,  9, 12, 10, 10, 10, 14, 10, 12, 11, 13, 11, 11,
      16, 16, 13, 14, 14, 14, 13, 12,  8, 14,  8, 12, 10, 13, 10, 11,
      11, 15, 10, 12, 12, 13, 11, 11, 16, 16, 14, 14, 15, 16, 13, 12,
      11, 16,  9, 12, 12, 14, 11, 11, 13, 16, 11, 13, 13, 16, 11, 11,
      16, 16, 13, 14, 16, 16, 13, 12,  8, 14, 10, 12,  9, 12, 10, 11,
      11, 15, 11, 13, 11, 13, 11, 11, 16, 16, 14, 15, 14, 15, 13, 12,
      10, 15, 10, 13, 11, 13, 11, 11, 11, 15, 11, 13, 12, 13, 11, 11,
      16, 16, 13, 15, 14, 15, 13, 12, 12, 16, 11, 13, 13, 15, 11, 11,
      13, 16, 11, 13, 13, 15, 11, 11, 16, 16, 12, 14, 14, 16, 12, 11,
      11, 16, 12, 14, 10, 13, 11, 11, 13, 16, 13, 15, 12, 14, 12, 12,
      16, 16, 15, 16, 14, 15, 13, 12, 12, 16, 13, 14, 12, 14, 12, 12,
      13, 16, 13, 14, 12, 14, 12, 12, 16, 16, 14, 15, 13, 14, 12, 12,
      15, 16, 13, 15, 14, 16, 12, 12, 14, 16, 13, 14, 13, 15, 12, 12,
      15, 16, 12, 13, 13, 14, 11, 10,  9, 15, 10, 13, 11, 14, 11, 12,
      12, 16, 12, 14, 12, 14, 12, 12, 16, 16, 14, 14, 14, 15, 13, 12,
      10, 16, 10, 13, 12, 14, 12, 12, 13, 16, 12, 14, 13, 15, 12, 12,
      16, 16, 14, 14, 15, 16, 13, 12, 11, 16,  9, 12, 13, 15, 11, 11,
      14, 16, 11, 13, 14, 16, 11, 11, 16, 16, 13, 14, 16, 16, 12, 11,
      10, 16, 11, 14, 11, 14, 12, 12, 13, 16, 13, 14, 12, 14, 12, 12,
      16, 16, 14, 15, 15, 15, 13, 12, 11, 16, 12, 14, 12, 15, 12, 12,
      13, 16, 12, 14, 13, 15, 12, 12, 16, 16, 14, 15, 15, 16, 13, 12,
      12, 16, 11, 13, 13, 15, 11, 11, 13, 16, 11, 13, 13, 15, 11, 11,
      16, 16, 12, 13, 14, 16, 12, 10, 11, 16, 12, 14, 10, 13, 11, 11,
      14, 16, 13, 14, 12, 14, 11, 11, 16, 16, 15, 16, 14, 14, 12, 11,
      12, 16, 13, 14, 11, 14, 11, 11, 13, 16, 13, 14, 12, 14, 11, 11,
      16, 16, 14, 15, 13, 14, 12, 11, 14, 16, 12, 14, 13, 14, 11, 10,
      13, 16, 12, 13, 12, 14, 11, 10, 14, 16, 11, 12, 12, 12, 10,  8,
    },
    {
       0,  8,  4,  9,  5,  9,  8, 10,  6, 11,  8, 11,  9, 12, 11, 12,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 11,  6, 11,  9, 12, 10, 12,
       9, 13, 10, 13, 11, 16, 12, 13, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 11, 16, 16, 16, 14, 16, 14, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 11,  8, 12,  7, 12, 10, 12,
       8, 13, 10, 13, 10, 13, 12, 14, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 13, 10, 14, 11, 16, 12, 14, 11, 16, 12, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 14, 16, 12, 16, 16, 16, 13, 16, 16, 16, 14, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 10,  5, 10,  7, 11,  9, 11,
       8, 12,  9, 12, 10, 13, 12, 13, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 12,  7, 12, 10, 13, 11, 12,  9, 16, 10, 13, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 10, 16, 16, 16, 14, 16,
      14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       6, 12,  9, 13,  8, 12, 11, 13, 10, 16, 11, 16, 11, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 10, 14, 11, 16, 12, 16,
      10, 16, 11, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 14, 16, 11, 16, 14, 16,
      16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       6, 16,  9, 13, 10, 16, 12, 14, 11, 16, 12, 16, 12, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16,  9, 14, 12, 16, 13, 16,
      12, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 10, 16, 16, 16, 14, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 11, 16, 10, 16, 12, 16,
      12, 16, 13, 16, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 13, 16, 14, 16, 11, 16, 13, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 13, 16, 16, 16, 16, 16,
      14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 11, 16, 14, 16, 16, 16, 16, 16, 14, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 11, 16, 12, 16, 13, 16,
      13, 16, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 11, 16, 13, 16, 14, 16, 14, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 10, 16, 16, 16, 13, 16,
      16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 12, 16, 13, 16, 13, 16, 16, 16, 14, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 13, 16, 14, 16, 16, 16,
      13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 12, 16, 16, 16, 14, 16, 14, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 13, 16, 11, 16, 13, 16,
      16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 14, 15,
    },
  },
  {
    {
       0,  7,  3,  7,  4,  7,  6,  7,  6,  9,  7,  9,  7,  9,  8,  9,
      13, 14, 12, 13, 13, 13, 12, 12,  4,  9,  5,  9,  7,  9,  8,  9,
       7, 11,  8, 10,  9, 11,  9, 10, 13, 16, 12, 14, 13, 14, 12, 12,
       9, 14,  8, 12, 12, 14, 10, 11, 11, 16, 10, 13, 13, 14, 11, 12,
      15, 16, 13, 14, 14, 16, 12, 12,  5, 10,  7,  9,  6,  9,  8,  9,
       8, 11,  8, 11,  8, 10,  9, 10, 14, 16, 12, 14, 13, 14, 12, 12,
       7, 12,  8, 11,  9, 11,  9, 10,  9, 13,  9, 12, 10, 12, 10, 11,
      14, 16, 12, 14, 13, 14, 12, 12, 12, 16, 11, 13, 13, 15, 11, 12,
      13, 16, 11, 14, 13, 15, 12, 12, 15, 16, 13, 15, 14, 16, 13, 13,
      10, 15, 12, 14,  9, 13, 11, 12, 12, 16, 12, 14, 11, 13, 12, 12,
      15, 16, 13, 15, 14, 15, 13, 13, 12, 16, 12, 14, 12, 14, 12, 12,
      13, 16, 13, 14, 12, 14, 12, 12, 16, 16, 14, 15, 14, 16, 13, 13,
      15, 16, 13, 15, 14, 16, 12, 13, 16, 16, 14, 16, 14, 16, 13, 13,
      16, 16, 14, 16, 15, 16, 13, 13,  3,  9,  5,  9,  6,  9,  8,  9,
       7, 11,  8, 10,  9, 11,  9, 10, 14, 15, 13, 14, 13, 14, 12, 12,
       5, 11,  6, 10,  8, 11,  9, 10,  9, 12,  9, 11, 10, 12, 10, 11,
      14, 16, 13, 14, 14, 15, 13, 13,  9, 15,  8, 12, 12, 14, 10, 11,
      12, 16, 10, 13, 13, 15, 11, 12, 15, 16, 13, 14, 14, 16, 13, 13,
       6, 11,  8, 11,  7, 10,  9, 10,  9, 13, 10, 12,  9, 12, 10, 11,
      14, 16, 13, 14, 14, 14, 13, 13,  8, 13,  9, 12,  9, 12, 10, 11,
       9, 13,  9, 12, 10, 12, 10, 11, 14, 16, 12, 14, 13, 14, 12, 12,
      12, 16, 11, 13, 13, 15, 11, 12, 12, 16, 11, 13, 13, 15, 11, 12,
      14, 16, 12, 14, 14, 15, 12, 12, 10, 15, 11, 14,  9, 13, 11, 12,
      12, 16, 12, 14, 11, 14, 12, 12, 16, 16, 14, 16, 14, 15, 13, 13,
      12, 16, 12, 14, 11, 14, 12, 12, 12, 16, 13, 14, 11, 14, 12, 12,
      15, 16, 14, 15, 13, 15, 12, 13, 14, 16, 13, 15, 14, 16, 13, 13,
      14, 16, 13, 15, 14, 16, 12, 13, 15, 16, 13, 15, 13, 15, 12, 12,
       6, 13,  8, 12,  9, 12, 10, 11, 10, 14, 11, 13, 11, 13, 12, 12,
      15, 16, 14, 15, 15, 15, 14, 13,  8, 14,  9, 12, 11, 13, 11, 12,
      11, 15, 11, 13, 12, 14, 12, 12, 16, 16, 14, 15, 15, 16, 14, 14,
      10, 16,  9, 13, 12, 15, 11, 12, 13, 16, 11, 14, 13, 16, 12, 12,
      16, 16, 14, 15, 16, 16, 13, 13,  8, 14, 10, 13,  9, 13, 11, 12,
      11, 15, 12, 14, 11, 14, 12, 12, 16, 16, 15, 16, 15, 16, 14, 14,
      10, 15, 10, 13, 11, 14, 11, 12, 11, 15, 11, 14, 12, 14, 12, 12,
      15, 16, 14, 15, 14, 16, 13, 13, 12, 16, 11, 14, 13, 16, 12, 12,
      12, 16, 11, 14, 13, 15, 12, 12, 15, 16, 12, 14, 15, 16, 13, 13,
      11, 16, 12, 14, 10, 14, 11, 12, 13, 16, 13, 16, 12, 14, 12, 13,
      16, 16, 16, 16, 15, 16, 14, 13, 12, 16, 13, 15, 12, 14, 12, 13,
      13, 16, 13, 15, 12, 14, 12, 13, 16, 16, 14, 16, 13, 15, 13, 13,
      15, 16, 14, 16, 14, 16, 13, 13, 14, 16, 13, 15, 13, 16, 13, 13,
      14, 16, 12, 14, 13, 14, 12, 12,  9, 16, 11, 14, 11, 15, 12, 13,
      13, 16, 12, 14, 12, 15, 13, 13, 16, 16, 14, 15, 15, 15, 14, 13,
      11, 16, 11, 14, 12, 16, 12, 13, 13, 16, 12, 14, 13, 16, 13, 13,
      16, 16, 14, 15, 16, 16, 14, 13, 11, 16, 10, 13, 13, 16, 11, 12,
      14, 16, 11, 14, 14, 16, 12, 12, 16, 16, 14, 14, 16, 16, 13, 12,
      11, 16, 12, 14, 11, 15, 12, 13, 13, 16, 13, 15, 13, 16, 13, 13,
      16, 16, 15, 16, 15, 16, 14, 13, 11, 16, 12, 15, 12, 16, 12, 13,
      13, 16, 13, 15, 13, 16, 13, 13, 16, 16, 15, 16, 15, 16, 14, 13,
      12, 16, 11, 14, 13, 16, 12, 12, 13, 16, 11, 14, 13, 16, 12, 12,
      16, 16, 13, 14, 15, 16, 12, 12, 11, 16, 12, 14, 10, 14, 11, 12,
      14, 16, 13, 15, 12, 15, 12, 12, 16, 16, 16, 16, 14, 15, 13, 12,
      12, 16, 13, 15, 12, 14, 12, 12, 13, 16, 13, 15, 12, 14, 12, 12,
      16, 16, 14, 16, 14, 15, 12, 12, 14, 16, 13, 15, 13, 16, 11, 12,
      13, 16, 12, 14, 13, 15, 11, 11, 14, 16, 12, 13, 12, 13, 11, 10,
    },
    {
       0,  8,  4,  9,  5, 10,  9, 11,  5, 11,  9, 12,  9, 13, 12, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 11,  6, 12,  9, 13, 11, 13,
       9, 16, 10, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 12,  8, 13,  7, 12, 11, 16,
       8, 16, 11, 16, 11, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 10, 16, 11, 16, 13, 16, 11, 16, 12, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 10,  6, 11,  7, 12, 10, 13,
       7, 12, 10, 13, 10, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 13,  7, 12, 10, 16, 12, 16, 10, 16, 11, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 11, 16, 16, 16, 16, 16,
      16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 13,  9, 16,  8, 16, 12, 16,  9, 16, 12, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 11, 16, 12, 16, 13, 16,
      10, 16, 12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       6, 16,  9, 16, 10, 16, 13, 16, 11, 16, 12, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16,  9, 16, 12, 16, 13, 16,
      12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 10, 16, 16, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 11, 16, 11, 16, 13, 16,
      12, 16, 13, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 13, 16, 16, 16, 11, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 16, 11, 16, 12, 16, 16, 16,
      13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 11, 16, 13, 16, 16, 16, 16, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 10, 16, 16, 16, 16, 16,
      16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 13, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 12, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 16, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  7,  4,  8,  4,  8,  7,  8,  6, 10,  7, 10,  8, 10,  9, 10,
      13, 16, 13, 15, 13, 15, 13, 14,  4, 10,  5, 10,  7, 10,  9, 10,
       7, 12,  8, 11,  9, 12, 10, 11, 13, 16, 13, 15, 13, 16, 13, 14,
       9, 16,  9, 13, 12, 16, 11, 13, 11, 16, 11, 14, 13, 16, 12, 14,
      15, 16, 14, 16, 15, 16, 14, 14,  4, 10,  7, 10,  6, 10,  9, 10,
       8, 12,  9, 12,  9, 11, 10, 12, 13, 16, 13, 16, 14, 16, 13, 14,
       7, 12,  8, 12,  9, 12, 10, 12,  9, 13, 10, 13, 10, 13, 11, 12,
      14, 16, 13, 16, 14, 16, 13, 14, 12, 16, 11, 14, 13, 16, 12, 14,
      13, 16, 12, 16, 14, 16, 13, 14, 16, 16, 14, 16, 15, 16, 14, 14,
      10, 16, 12, 15, 10, 14, 12, 13, 12, 16, 13, 16, 12, 14, 13, 14,
      15, 16, 14, 16, 14, 16, 14, 14, 12, 16, 13, 16, 12, 16, 13, 14,
      13, 16, 13, 16, 13, 16, 13, 14, 16, 16, 14, 16, 15, 16, 14, 15,
      15, 16, 14, 16, 15, 16, 13, 15, 16, 16, 14, 16, 15, 16, 14, 15,
      16, 16, 16, 16, 16, 16, 15, 15,  2,  9,  5, 10,  6, 10,  8, 10,
       7, 11,  8, 11,  9, 11, 10, 11, 14, 16, 13, 15, 14, 15, 14, 14,
       5, 11,  6, 11,  8, 12,  9, 11,  8, 13,  9, 12, 10, 13, 11, 12,
      14, 16, 13, 15, 14, 16, 14, 14,  9, 16,  8, 13, 12, 16, 11, 13,
      12, 16, 11, 14, 13, 16, 12, 13, 16, 16, 14, 16, 15, 16, 14, 15,
       5, 12,  8, 11,  7, 11,  9, 11,  9, 13, 10, 13, 10, 13, 11, 12,
      14, 16, 14, 16, 14, 16, 14, 15,  8, 13,  9, 13, 10, 13, 11, 12,
       9, 13, 10, 13, 10, 13, 11, 13, 13, 16, 13, 15, 13, 16, 13, 14,
      12, 16, 11, 14, 13, 16, 12, 14, 12, 16, 11, 14, 13, 16, 12, 14,
      14, 16, 13, 16, 14, 16, 13, 14, 10, 16, 12, 15,  9, 14, 11, 13,
      12, 16, 13, 16, 12, 15, 12, 14, 16, 16, 15, 16, 15, 16, 14, 14,
      12, 16, 13, 16, 12, 16, 12, 14, 12, 16, 13, 16, 12, 15, 13, 14,
      15, 16, 14, 16, 14, 16, 14, 14, 15, 16, 14, 16, 14, 16, 14, 15,
      14, 16, 13, 16, 14, 16, 13, 14, 16, 16, 14, 16, 14, 16, 13, 14,
       6, 14,  9, 13,  9, 14, 11, 12, 10, 14, 11, 13, 11, 14, 12, 13,
      16, 16, 15, 16, 15, 16, 14, 15,  8, 15,  9, 13, 11, 14, 11, 13,
      11, 16, 11, 14, 12, 15, 12, 14, 16, 16, 15, 16, 16, 16, 15, 16,
      10, 16,  9, 14, 12, 16, 12, 13, 13, 16, 11, 15, 14, 16, 13, 14,
      16, 16, 15, 16, 16, 16, 15, 16,  8, 15, 10, 13, 10, 14, 11, 13,
      11, 16, 12, 14, 12, 14, 12, 14, 16, 16, 16, 16, 16, 16, 15, 16,
      10, 16, 11, 14, 11, 15, 12, 13, 11, 16, 11, 14, 12, 15, 12, 14,
      16, 16, 14, 16, 15, 16, 14, 15, 12, 16, 11, 15, 13, 16, 13, 14,
      12, 16, 11, 14, 13, 16, 13, 14, 15, 16, 13, 16, 16, 16, 14, 15,
      10, 16, 12, 15, 10, 15, 12, 13, 13, 16, 13, 16, 12, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 15, 12, 16, 13, 16, 12, 16, 13, 14,
      12, 16, 13, 16, 12, 16, 13, 14, 16, 16, 15, 16, 14, 16, 14, 15,
      15, 16, 14, 16, 15, 16, 14, 15, 14, 16, 13, 16, 14, 16, 13, 14,
      14, 16, 13, 15, 14, 16, 13, 14,  9, 16, 11, 16, 11, 16, 12, 14,
      13, 16, 12, 16, 13, 16, 13, 14, 16, 16, 15, 16, 16, 16, 15, 15,
      11, 16, 11, 16, 12, 16, 13, 14, 13, 16, 12, 16, 13, 16, 13, 14,
      16, 16, 15, 16, 16, 16, 15, 15, 11, 16, 10, 15, 13, 16, 12, 13,
      14, 16, 12, 16, 14, 16, 13, 14, 16, 16, 15, 16, 16, 16, 14, 14,
      11, 16, 12, 16, 11, 16, 13, 14, 13, 16, 13, 16, 13, 16, 13, 14,
      16, 16, 16, 16, 16, 16, 15, 15, 11, 16, 12, 16, 12, 16, 13, 14,
      13, 16, 13, 16, 13, 16, 13, 14, 16, 16, 15, 16, 16, 16, 15, 14,
      12, 16, 12, 15, 13, 16, 12, 14, 13, 16, 12, 16, 14, 16, 13, 14,
      16, 16, 14, 16, 16, 16, 14, 14, 11, 16, 12, 16, 11, 16, 12, 14,
      14, 16, 14, 16, 12, 16, 13, 14, 16, 16, 16, 16, 16, 16, 15, 14,
      12, 16, 13, 16, 12, 16, 12, 14, 13, 16, 13, 16, 12, 16, 13, 14,
      16, 16, 16, 16, 15, 16, 14, 14, 14, 16, 13, 16, 14, 16, 12, 14,
      13, 16, 13, 16, 13, 16, 12, 13, 15, 16, 13, 14, 14, 15, 13, 13,
    },
    {
       0,  8,  4, 10,  5, 11, 10, 16,  5, 12,  9, 16, 10, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 12,  7, 12,  9, 16, 12, 16,
       9, 16, 11, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 12,  9, 16,  8, 16, 12, 16,
       8, 16, 11, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       8, 16, 11, 16, 12, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 11,  6, 12,  7, 16, 11, 16,
       7, 16, 10, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16,  7, 16, 10, 16, 12, 16,  9, 16, 11, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 11, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16, 10, 16,  8, 16, 12, 16,  9, 16, 12, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 11, 16, 12, 16, 16, 16,
      10, 16, 12, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16,  9, 16, 10, 16, 16, 16, 11, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16,  9, 16, 12, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 11, 16, 11, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      11, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 10, 16, 12, 16, 16, 16,
      12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16,  9, 16, 16, 16, 16, 16,
      16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      13, 16, 12, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  8,  4, 10,  5,  9,  8, 10,  6, 11,  8, 12,  8, 11, 10, 13,
      14, 16, 14, 16, 14, 16, 16, 16,  3, 11,  5, 11,  8, 12, 10, 12,
       7, 12,  9, 13, 10, 13, 11, 13, 14, 16, 14, 16, 16, 16, 16, 16,
       9, 16,  9, 16, 12, 16, 12, 16, 11, 16, 11, 16, 14, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 11,  7, 12,  6, 11, 10, 12,
       8, 13,  9, 13,  9, 13, 11, 14, 13, 16, 14, 16, 14, 16, 16, 16,
       7, 13,  9, 13,  9, 13, 11, 13,  9, 14, 10, 16, 11, 16, 12, 16,
      15, 16, 14, 16, 16, 16, 16, 16, 12, 16, 12, 16, 14, 16, 13, 16,
      13, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 10, 16, 13, 16, 12, 16, 13, 16, 12, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 13, 16, 13, 16, 14, 16,
      13, 16, 14, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  2, 10,  5, 11,  6, 11,  9, 11,
       7, 12,  9, 13,  9, 13, 11, 13, 14, 16, 16, 16, 16, 16, 16, 16,
       4, 12,  6, 12,  8, 13, 10, 13,  8, 13,  9, 13, 11, 16, 12, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16,  8, 16, 12, 16, 12, 16,
      12, 16, 11, 16, 13, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 12,  8, 13,  7, 13, 10, 13,  8, 14, 10, 14, 10, 14, 12, 14,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 14,  9, 16, 10, 16, 11, 14,
       8, 14, 10, 16, 11, 16, 12, 16, 13, 16, 14, 16, 16, 16, 16, 16,
      11, 16, 11, 16, 13, 16, 13, 16, 12, 16, 12, 16, 14, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 12, 16, 10, 16, 12, 16,
      12, 16, 13, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 13, 16, 12, 16, 14, 16, 12, 16, 13, 16, 12, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       6, 16,  8, 16,  9, 16, 11, 13, 10, 16, 11, 16, 11, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 16,  9, 16, 10, 16, 12, 16,
      11, 16, 11, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16,  9, 16, 12, 16, 13, 16, 13, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  7, 16, 10, 16,  9, 16, 12, 16,
      11, 16, 12, 16, 12, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16, 11, 16, 11, 16, 12, 16, 11, 16, 12, 16, 13, 16, 13, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 12, 16, 14, 16, 14, 16,
      12, 16, 12, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 10, 16, 13, 16, 13, 16, 14, 16, 13, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 13, 16, 12, 16, 14, 16,
      12, 16, 14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 11, 16, 11, 16, 13, 16,
      12, 16, 13, 16, 13, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 11, 16, 13, 16, 13, 16, 13, 16, 13, 16, 14, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 11, 16, 14, 16, 13, 16,
      14, 16, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 12, 16, 12, 16, 13, 16, 13, 16, 13, 16, 13, 16, 14, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 12, 16, 13, 16, 14, 16,
      13, 16, 13, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 12, 16, 14, 16, 14, 16, 14, 16, 14, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 13, 16, 11, 16, 14, 16,
      16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 14, 16, 13, 16, 14, 16, 16, 16, 16, 16, 14, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       0, 10,  4, 12,  5, 16, 11, 16,  6, 16, 10, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  3, 16,  7, 16, 10, 16, 16, 16,
       9, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  4, 16, 10, 16,  9, 16, 16, 16,
       9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16, 12, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  1, 16,  6, 16,  8, 16, 16, 16,
       8, 16, 11, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16,  8, 16, 11, 16, 16, 16, 10, 16, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 11, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16, 11, 16,  9, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  9, 16, 12, 16, 16, 16, 16, 16,
      10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       5, 16,  9, 16, 11, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 10, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  8, 16, 16, 16, 11, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      12, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16,  6, 16, 11, 16, 15, 16, 16, 16,
      15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       9, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16,  9, 16, 16, 16, 16, 16,
      16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
};

static const uint8_t rv34_table_inter_secondpat[NUM_INTER_TABLES][2][OTHERBLK_VLC_SIZE] = {
  {
    {
       0,  4,  8,  3,  6,  8,  6,  7,  8,  4,  6,  8,  6,  7,  8,  7,
       8,  8,  7,  8,  8,  8,  8,  8,  8,  8,  8,  3,  6,  8,  4,  6,
       9,  7,  7,  8,  5,  7,  9,  6,  7,  9,  8,  8,  8,  7,  8,  8,
       8,  8,  8,  8,  8,  7,  6,  8,  9,  7,  8,  9,  7,  8,  9,  7,
       8,  9,  7,  8,  9,  8,  8,  9,  8,  8,  9,  8,  9,  9,  8,  8,
       8,  8,  9,  9,  8,  9,  9,  7,  8,  8,  8,  9,  9,  8,  9,  9,
       8,  8,  8,  7,  8,  8,  8,  8,  8,  7,  7,  6,
    },
    {
       0,  4,  9,  3,  6,  9,  7,  8, 10,  3,  6,  9,  5,  7, 10,  9,
       9, 10,  7,  8, 10,  8,  9, 10, 10, 10, 10,  2,  6,  9,  4,  7,
      10,  8,  9, 10,  4,  7, 10,  6,  7, 10,  9,  9, 10,  7,  8, 10,
       8,  9, 10, 10, 10, 10,  6,  8, 10,  7,  9, 11,  9, 10, 11,  7,
       9, 11,  8,  9, 11, 10, 10, 11,  8,  9, 11,  9, 10, 11, 11, 11,
      10,  8, 10, 11,  9, 10, 11,  9, 10, 11,  8, 10, 11,  9, 10, 11,
      10, 10, 11,  8, 10, 11,  9, 10, 10, 10, 10,  9,
    },
  },
  {
    {
       0,  4,  8,  3,  6,  8,  6,  7,  9,  4,  6,  8,  5,  7,  8,  8,
       8,  9,  7,  7,  8,  8,  8,  8,  8,  9,  8,  3,  6,  8,  4,  6,
       9,  7,  7,  9,  5,  6,  9,  6,  7,  9,  8,  8,  9,  7,  8,  8,
       8,  8,  8,  8,  8,  8,  6,  8,  9,  7,  8, 10,  7,  8,  9,  7,
       8, 10,  7,  8, 10,  8,  8,  9,  7,  8,  9,  8,  9,  9,  9,  9,
       8,  7,  9, 10,  8,  9, 10,  8,  8,  8,  8,  9, 10,  8,  9,  9,
       8,  8,  8,  7,  8,  8,  8,  8,  8,  8,  7,  6,
    },
    {
       0,  4,  9,  3,  6, 10,  8,  9, 11,  3,  5,  9,  5,  7, 10,  9,
      10, 11,  7,  8, 10,  9,  9, 11, 11, 11, 12,  2,  5, 10,  4,  7,
      10,  8,  9, 11,  4,  6, 10,  6,  7, 10,  9, 10, 11,  7,  9, 10,
       9,  9, 11, 11, 11, 11,  6,  8, 11,  7,  9, 11,  9, 10, 12,  7,
       9, 11,  8,  9, 12, 10, 10, 12,  8, 10, 11, 10, 10, 11, 12, 11,
      11,  8, 10, 12,  9, 11, 12, 10, 11, 12,  9, 10, 12, 10, 11, 12,
      11, 11, 12,  9, 10, 12, 10, 10, 11, 11, 11, 10,
    },
  },
  {
    {
       0,  4,  8,  3,  6,  9,  7,  8,  9,  4,  6,  8,  5,  7,  9,  8,
       9,  9,  7,  8,  9,  8,  8,  9,  9,  9,  9,  2,  6,  9,  4,  6,
       9,  7,  8, 10,  5,  7,  9,  6,  7,  9,  8,  8,  9,  7,  8,  9,
       8,  8,  9,  9,  9,  9,  6,  8, 10,  7,  8, 10,  8,  9, 10,  6,
       8, 10,  8,  8, 10,  9,  9, 10,  8,  9, 10,  9,  9, 10, 10, 10,
       9,  8,  9, 10,  8,  9, 10,  8,  9, 10,  8,  9, 10,  9,  9, 10,
       9,  9,  9,  8,  9,  9,  8,  9,  9,  9,  9,  8,
    },
    {
       0,  4, 10,  3,  6, 10,  8, 10, 12,  2,  6, 10,  6,  8, 11, 10,
      11, 12,  7,  9, 11,  9, 10, 12, 12, 13, 13,  2,  6, 10,  4,  7,
      11,  9, 10, 13,  4,  7, 11,  7,  8, 11, 10, 11, 12,  8,  9, 12,
      10, 10, 12, 12, 12, 13,  6,  9, 12,  8, 10, 13, 10, 12, 14,  7,
      10, 13,  9, 10, 13, 11, 11, 13,  9, 11, 13, 11, 11, 13, 13, 13,
      13,  9, 11, 13, 10, 12, 14, 11, 12, 14,  9, 11, 14, 11, 12, 14,
      12, 12, 14,  9, 12, 13, 11, 12, 13, 13, 12, 12,
    },
  },
  {
    {
       0,  4,  9,  3,  6,  9,  7,  8, 10,  3,  6,  9,  6,  7,  9,  9,
       9, 10,  7,  8,  9,  8,  9, 10, 10, 10, 11,  2,  6,  9,  4,  7,
      10,  7,  9, 10,  4,  7, 10,  6,  7, 10,  9,  9, 10,  7,  8, 10,
       8,  9, 10, 10, 10, 10,  6,  8, 11,  7,  9, 11,  8, 10, 11,  6,
       9, 11,  8,  9, 11,  9,  9, 11,  8,  9, 11,  9, 10, 11, 11, 10,
      10,  8, 10, 11,  9, 10, 11,  9, 10, 11,  8, 10, 11,  9, 10, 11,
      10, 10, 11,  8, 10, 11,  9, 10, 11, 10, 10, 10,
    },
    {
       0,  4, 12,  3,  7, 12, 10, 11, 14,  3,  6, 12,  7,  9, 13, 12,
      13, 14,  8, 11, 13, 11, 12, 14, 14, 14, 14,  1,  7, 12,  5,  8,
      13, 10, 12, 14,  4,  8, 13,  8,  9, 13, 12, 13, 14,  9, 11, 14,
      11, 12, 14, 14, 14, 14,  7, 10, 14,  9, 11, 14, 11, 13, 16,  8,
      11, 14, 10, 12, 14, 13, 13, 16, 10, 12, 15, 12, 13, 15, 15, 15,
      15, 10, 13, 15, 12, 13, 14, 13, 15, 15, 10, 13, 15, 12, 13, 15,
      13, 14, 15, 10, 13, 14, 12, 13, 14, 14, 14, 14,
    },
  },
  {
    {
       0,  4,  9,  3,  6, 10,  7,  9, 11,  3,  5,  9,  5,  7, 10,  9,
      10, 12,  7,  8, 10,  9, 10, 11, 11, 12, 12,  2,  6, 10,  4,  7,
      10,  7,  9, 12,  4,  7, 10,  6,  7, 11,  9, 10, 12,  7,  9, 11,
       9,  9, 11, 11, 11, 12,  5,  8, 11,  7,  9, 12,  9, 10, 13,  6,
       9, 12,  8,  9, 12, 10, 10, 12,  8, 10, 12, 10, 10, 12, 12, 12,
      12,  8, 10, 12,  9, 11, 13, 10, 11, 13,  9, 11, 13, 10, 11, 13,
      11, 11, 13,  9, 11, 12, 10, 11, 12, 11, 11, 12,
    },
    {
       0,  4, 12,  3,  7, 13, 10, 12, 15,  3,  7, 13,  7,  9, 14, 12,
      12, 13,  8, 11, 14, 11, 13, 15, 15, 14, 14,  1,  6, 13,  5,  8,
      13, 10, 13, 15,  4,  8, 13,  8,  9, 14, 13, 13, 15,  8, 11, 14,
      12, 12, 15, 15, 14, 14,  7, 10, 13,  9, 11, 13, 12, 14, 16,  8,
      11, 14, 10, 12, 15, 13, 13, 16, 10, 12, 15, 12, 13, 15, 15, 14,
      15, 11, 12, 14, 12, 14, 14, 13, 15, 15, 10, 12, 14, 12, 13, 15,
      14, 15, 15, 10, 13, 13, 12, 13, 15, 14, 14, 15,
    },
  },
  {
    {
       0,  5, 10,  3,  7, 11,  9, 11, 14,  3,  7, 11,  7,  8, 12, 11,
      12, 14,  7,  9, 12, 10, 11, 14, 13, 14, 16,  1,  7, 11,  5,  8,
      12,  9, 11, 15,  4,  8, 12,  7,  9, 13, 11, 12, 15,  8, 10, 13,
      10, 11, 14, 14, 14, 16,  6,  9, 13,  8, 11, 14, 10, 13, 16,  7,
      10, 14,  9, 11, 15, 12, 13, 16,  9, 11, 15, 12, 12, 15, 14, 14,
      16, 10, 12, 14, 11, 13, 15, 12, 14, 16, 10, 12, 15, 11, 13, 16,
      13, 14, 16, 10, 13, 16, 12, 13, 15, 14, 15, 16,
    },
    {
       0,  5, 16,  3,  8, 14, 11, 13, 14,  2,  8, 14,  8, 10, 16, 13,
      13, 14,  9, 13, 16, 12, 13, 16, 16, 14, 16,  1,  7, 14,  6, 10,
      14, 12, 16, 16,  5,  9, 14,  9, 11, 16, 15, 16, 16, 10, 12, 16,
      13, 13, 16, 16, 14, 16,  8, 11, 14, 11, 13, 14, 14, 14, 16,  8,
      12, 14, 11, 13, 16, 16, 16, 16, 10, 12, 15, 13, 14, 16, 16, 16,
      16, 11, 14, 14, 14, 15, 16, 16, 15, 16, 10, 13, 16, 13, 14, 14,
      16, 16, 16, 10, 13, 16, 13, 14, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  5, 11,  3,  7, 13,  9, 12, 16,  3,  7, 12,  6,  9, 14, 11,
      13, 16,  7, 10, 16, 11, 12, 16, 16, 16, 16,  1,  6, 12,  5,  9,
      16,  9, 13, 16,  4,  8, 16,  7, 10, 16, 12, 15, 16,  7, 11, 16,
      11, 12, 16, 16, 16, 16,  6, 10, 15,  8, 11, 16, 11, 14, 16,  7,
      11, 16, 10, 12, 16, 13, 16, 16,  9, 13, 16, 13, 14, 16, 16, 16,
      16, 10, 12, 16, 12, 16, 16, 16, 16, 16, 11, 13, 16, 13, 16, 16,
      16, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       0,  5, 16,  3,  8, 16, 12, 12, 16,  2,  8, 16,  8, 10, 16, 13,
      13, 16,  9, 13, 16, 12, 13, 16, 16, 16, 16,  1,  8, 16,  6, 10,
      16, 12, 16, 16,  5,  9, 16,  9, 11, 16, 13, 16, 16,  9, 12, 14,
      12, 12, 16, 16, 16, 16,  8, 11, 13, 11, 12, 16, 14, 16, 16,  8,
      12, 16, 11, 13, 16, 16, 15, 16,  9, 13, 14, 12, 13, 16, 16, 16,
      16, 10, 12, 13, 14, 13, 16, 16, 16, 16,  9, 13, 16, 13, 12, 16,
      16, 16, 16, 10, 12, 16, 14, 15, 16, 16, 16, 16,
    },
  },
};

static const uint8_t rv34_table_inter_thirdpat[NUM_INTER_TABLES][2][OTHERBLK_VLC_SIZE] = {
  {
    {
       0,  5,  8,  3,  6,  9,  6,  7,  9,  4,  6,  9,  6,  7,  9,  8,
       8,  9,  7,  8,  9,  8,  9,  9,  9,  9,  9,  2,  6,  9,  4,  7,
       9,  7,  8,  9,  5,  7,  9,  6,  7,  9,  8,  8,  9,  7,  8,  9,
       8,  9,  9,  9,  9,  8,  5,  8, 10,  6,  8, 10,  8,  9,  9,  7,
       8, 10,  7,  9, 10,  8,  9,  9,  8,  9, 10,  9,  9, 10,  9,  9,
       9,  7,  9, 10,  8,  9, 10,  8,  8,  9,  8,  9, 10,  8,  9, 10,
       8,  8,  9,  8,  9,  9,  8,  9,  9,  8,  8,  7,
    },
    {
       0,  4,  9,  2,  6, 10,  7,  8, 10,  3,  6, 10,  6,  7, 10,  9,
       9, 10,  8,  9, 11,  9, 10, 11, 10, 11, 11,  2,  6, 10,  4,  7,
      10,  8,  9, 10,  5,  7, 10,  7,  8, 10,  9,  9, 10,  9, 10, 11,
      10, 10, 11, 11, 11, 11,  6,  9, 11,  7,  9, 11,  9, 10, 12,  8,
       9, 11,  8, 10, 11, 10, 10, 11, 10, 11, 12, 11, 11, 12, 11, 11,
      11,  9, 11, 12, 10, 11, 12, 10, 11, 12, 10, 11, 12, 10, 11, 12,
      11, 11, 12, 11, 12, 12, 11, 12, 12, 12, 11, 11,
    },
  },
  {
    {
       0,  4,  9,  3,  6,  9,  6,  8,  9,  4,  6,  9,  5,  7,  9,  8,
       8,  9,  7,  8, 10,  8,  9, 10,  9,  9,  9,  2,  6,  9,  4,  7,
       9,  7,  8,  9,  5,  7,  9,  6,  7, 10,  8,  9,  9,  7,  9, 10,
       8,  9, 10,  9,  9,  9,  5,  8, 10,  6,  8, 10,  8,  9, 10,  7,
       8, 10,  7,  9, 11,  9,  9, 10,  8,  9, 10,  9, 10, 10, 10, 10,
       9,  7,  9, 10,  8,  9, 11,  8,  9, 10,  8,  9, 11,  8,  9, 11,
       9,  9, 10,  9,  9, 10,  9,  9, 10,  9,  9,  8,
    },
    {
       0,  4,  9,  2,  5, 10,  7,  8, 11,  3,  6, 10,  6,  7, 10,  9,
      10, 11,  8,  9, 11,  9, 10, 11, 11, 11, 12,  2,  6, 10,  4,  7,
      10,  8,  9, 11,  5,  7, 10,  6,  8, 10,  9, 10, 11,  9, 10, 12,
      10, 10, 12, 11, 12, 12,  6,  9, 11,  8,  9, 12,  9, 11, 13,  8,
      10, 12,  9, 10, 12, 11, 11, 12, 10, 12, 13, 11, 12, 13, 13, 12,
      13, 10, 11, 13, 10, 12, 13, 11, 12, 13, 11, 12, 13, 11, 12, 13,
      12, 12, 13, 12, 13, 14, 13, 13, 14, 13, 13, 13,
    },
  },
  {
    {
       0,  4,  9,  3,  6,  9,  7,  8, 10,  3,  6,  9,  5,  7, 10,  8,
       9, 10,  7,  9, 10,  8,  9, 10, 10, 10, 10,  2,  6,  9,  4,  7,
      10,  7,  9, 10,  4,  7, 10,  6,  8, 10,  8,  9, 10,  8,  9, 10,
       9,  9, 10, 10, 10, 10,  5,  8, 11,  7,  9, 11,  8, 10, 11,  7,
       9, 11,  8,  9, 11,  9, 10, 11,  9, 10, 11, 10, 10, 11, 11, 11,
      11,  8, 10, 11,  9, 10, 11,  9, 10, 11,  9, 10, 12,  9, 10, 12,
      10, 11, 11,  9, 10, 11, 10, 11, 11, 10, 10, 10,
    },
    {
       0,  4, 10,  3,  6, 11,  8, 10, 12,  3,  6, 11,  6,  8, 11, 10,
      11, 13,  9, 10, 13, 11, 12, 14, 13, 13, 14,  1,  6, 10,  5,  8,
      12,  9, 10, 13,  5,  8, 11,  7,  9, 12, 11, 11, 13, 10, 12, 13,
      11, 12, 14, 14, 13, 15,  7, 10, 12,  9, 11, 14, 11, 12, 15,  9,
      11, 13, 10, 11, 14, 12, 12, 14, 12, 14, 16, 13, 13, 16, 14, 14,
      16, 12, 13, 15, 12, 14, 15, 13, 14, 16, 13, 14, 16, 14, 14, 16,
      14, 15, 16, 14, 16, 16, 15, 16, 16, 15, 15, 16,
    },
  },
  {
    {
       0,  4,  9,  2,  6,  9,  7,  9, 11,  3,  6, 10,  6,  7, 10,  9,
      10, 11,  7,  9, 10,  9, 10, 11, 11, 11, 12,  2,  6, 10,  4,  7,
      10,  8,  9, 11,  5,  7, 10,  7,  8, 10,  9, 10, 11,  8,  9, 11,
       9, 10, 11, 11, 12, 11,  6,  9, 11,  7, 10, 12,  9, 11, 12,  7,
      10, 12,  9, 10, 12, 11, 11, 12,  9, 11, 12, 10, 11, 12, 12, 12,
      12,  9, 11, 12,  9, 11, 13, 11, 12, 13,  9, 11, 13, 10, 12, 13,
      11, 12, 13, 11, 12, 13, 11, 12, 13, 12, 13, 12,
    },
    {
       0,  4, 11,  2,  6, 12,  9, 11, 16,  4,  7, 12,  7,  9, 15, 11,
      12, 16, 10, 11, 16, 11, 13, 16, 16, 16, 16,  1,  6, 11,  5,  8,
      16,  9, 12, 16,  6,  9, 15,  8, 10, 16, 12, 13, 16, 12, 14, 16,
      12, 16, 16, 16, 16, 16,  8, 11, 14, 10, 12, 16, 12, 16, 16, 10,
      13, 16, 12, 16, 16, 13, 14, 16, 14, 16, 16, 16, 16, 16, 16, 16,
      16, 13, 13, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  5,  9,  3,  6, 10,  8, 10, 12,  3,  6, 10,  6,  8, 10, 10,
      11, 12,  8,  9, 11, 10, 10, 12, 13, 13, 13,  1,  6, 10,  5,  8,
      11,  9, 11, 13,  5,  8, 11,  7,  9, 11, 11, 11, 13,  8,  9, 11,
      10, 10, 12, 13, 13, 14,  6,  9, 12,  8, 11, 13, 11, 13, 15,  8,
      10, 13, 10, 11, 13, 12, 13, 15, 10, 12, 13, 12, 12, 13, 14, 14,
      14,  9, 12, 14, 11, 13, 15, 13, 15, 16, 11, 13, 15, 12, 14, 15,
      14, 15, 16, 13, 14, 15, 14, 14, 15, 15, 16, 16,
    },
    {
       0,  4, 16,  2,  7, 16, 10, 13, 16,  3,  8, 16,  7, 10, 16, 16,
      16, 16, 12, 16, 16, 15, 16, 16, 16, 16, 16,  1,  7, 16,  6,  9,
      16, 10, 16, 16,  7, 12, 16,  9, 13, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16,  9, 16, 16, 11, 13, 16, 16, 16, 16, 12,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  4,  9,  3,  6, 11,  9, 12, 16,  3,  6, 10,  6,  8, 11, 12,
      13, 16,  8,  9, 12, 10, 11, 13, 16, 16, 16,  1,  6, 10,  5,  8,
      12, 10, 13, 16,  5,  8, 11,  8,  9, 13, 13, 14, 16,  9, 10, 14,
      11, 12, 15, 16, 16, 16,  6, 10, 13,  9, 12, 16, 14, 16, 16,  9,
      12, 14, 11, 13, 16, 16, 16, 16, 12, 14, 16, 14, 16, 16, 16, 16,
      16, 11, 16, 16, 13, 16, 16, 16, 16, 16, 12, 16, 16, 13, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       0,  4, 16,  2,  8, 16, 10, 16, 16,  3,  9, 16,  8, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  1,  7, 16,  5, 10,
      16, 16, 16, 16,  7, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 10, 15, 16, 10, 16, 16, 16, 16, 16, 14,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
  {
    {
       0,  3,  9,  3,  7, 11, 11, 15, 16,  3,  6, 11,  7,  9, 12, 16,
      16, 16,  8, 10, 16, 11, 16, 16, 16, 16, 16,  1,  6, 11,  6,  9,
      15, 16, 16, 16,  5,  8, 16,  9, 11, 16, 16, 16, 16, 10, 16, 16,
      16, 16, 16, 16, 16, 16,  7, 11, 16, 11, 16, 16, 16, 16, 16, 11,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
    {
       0,  4, 16,  2,  8, 16, 16, 16, 16,  3, 12, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  1,  7, 16,  5, 12,
      16, 16, 16, 16,  6, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16,  9, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    },
  },
};


static const uint8_t rv34_inter_coeffvlc[NUM_INTER_TABLES][COEFF_VLC_SIZE] = {
{
  1,  2,  4,  4,  5,  5,  6,  7,  7,  7,  8,  8,  8,  9,  9, 10,
 10, 10, 10, 11, 11, 11, 11, 12, 11, 11, 11, 13, 14, 15, 16, 16,
},
{
  1,  2,  3,  5,  5,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 10,
 11, 11, 12, 12, 12, 12, 13, 13, 12, 12, 13, 14, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 11, 12,
 12, 12, 13, 13, 13, 14, 14, 15, 14, 14, 16, 16, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12,
 13, 13, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 13, 14, 15, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  7,  8, 10, 10, 11, 11, 13, 12, 12, 13,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
},
{
  1,  2,  3,  4,  5,  6,  7,  8, 10, 10, 10, 11, 14, 13, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16,
}
};

#endif /* FFMPEG_RV34VLC_H */
