/*
 * Generate a header file for hardcoded ff_cos_* tables
 *
 * Copyright (c) 2009 Reimar Döffinger <Reimar.Doeffinger@gmx.de>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdio.h>
#include <math.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#define BITS 16
#define FLOATFMT "%.18e"

int main(void)
{
    int i, j;
    printf("/* This file was generated by libavcodec/costablegen */\n");
    printf("#include \"dsputil.h\"\n");
    for (i = 4; i <= BITS; i++) {
        int m = 1 << i;
        double freq = 2*M_PI/m;
        printf("const DECLARE_ALIGNED_16(FFTSample, ff_cos_%i[]) = {\n   ", m);
        for (j = 0; j < m/2 - 1; j++) {
            int idx = j > m/4 ? m/2 - j : j;
            printf(" "FLOATFMT",", cos(idx*freq));
            if ((j & 3) == 3)
                printf("\n   ");
        }
        printf(" "FLOATFMT"\n};\n", cos(freq));
    }
    return 0;
}
