/*
 * Real Audio 1.0 (14.4K)
 * Copyright (c) 2003 the ffmpeg project
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef FFMPEG_RA144_H
#define FFMPEG_RA144_H

#include <stdint.h>

/* 14.4 data tables */
static const int16_t wavtable1[256][9] = {
    { 541,   956,   768, -1011,  -811,  -717,  -571,  -893,  -576},
    { 877,   581,   568,  -997,  -975,  -646,  -752,  -661,  -632},
    { 675,   787,   635,  -519,  -838,  -977,  -890,  -605,  -789},
    { 624,   732,   668,  -893,  -815,  -956,  -762,  -523,  -873},
    { 623,   839,   697, -1022,  -849,  -571,  -759,  -688,  -949},
    { 640,   693,   991,  -867,  -619,  -671,  -800,  -940,  -959},
    { 925,   687,   608,  -621,  -549,  -817,  -837,  -924,  -722},
    { 552,   797,   572,  -861,  -617,  -892,  -596,  -621,  -640},
    { 535,   832,   799,  -871,  -836,  -649,  -560,  -676,  -624},
    { 762,   605,   577,  -902,  -859,  -682,  -568,  -716,  -650},
    { 832,   561,  1003,  -913,  -815,  -550,  -676,  -616,  -982},
    { 590,   687,   588,  -793,  -679,  -790,  -681,  -923,  -677},
    { 646,   901,   732,  -569,  -924,  -645,  -816,  -794,  -524},
    { 828,   689,   896,  -557,  -725,  -603,  -670,  -927,  -784},
    { 875,   624,   848,  -533,  -725,  -516,  -748,  -760,  -702},
    { 571,   942,  1022,  -526,  -570,  -941,  -638,  -868, -1020},
    { 824,   736,   643,  -593,  -517,  -925,  -663,  -530,  -808},
    { 517,   765,   512,  -774,  -518,  -767,  -523,  -572,  -513},
    { 562,   908,   761,  -997,  -836,  -675,  -617,  -805,  -566},
    { 694,   913,   675,  -619,  -916,  -603,  -941,  -815,  -891},
    { 704,   524,   672,  -722,  -925,  -689,  -969,  -538,  -883},
    { 721,   757,   558,  -534,  -786,  -826, -1018,  -561,  -608},
    { 884,   551,   633,  -951,  -546,  -681,  -763,  -592,  -784},
    { 558,  1007,   846,  -549,  -923,  -832,  -608,  -991,  -699},
    { 932,   746,   777,  -679,  -707,  -566,  -849,  -544,  -589},
    { 566,   822,   926,  -910,  -513,  -744,  -627,  -659,  -839},
    { 613,   771,   611,  -924,  -731,  -921,  -733,  -581,  -729},
    { 737,   671,  1008,  -967,  -726,  -661,  -531,  -880,  -993},
    { 651,   594,   579,  -757,  -737,  -673,  -830,  -691,  -655},
    { 801,   636,   564,  -996,  -883,  -702,  -626,  -792,  -622},
    { 852,   910,   719,  -757,  -599,  -639,  -709,  -809, -1012},
    { 998,   614,   575,  -599,  -561,  -691,  -974,  -737,  -647},
    { 665,   935,   628,  -607,  -816,  -574,  -863,  -854,  -771},
    { 631,   596,   829,  -735, -1023,  -966,  -778,  -694,  -672},
    { 644,   926,   526,  -583,  -663,  -953,  -811,  -838,  -542},
    { 879,   988,   613,  -848,  -526,  -592,  -755,  -953,  -734},
    { 941,   692,   693,  -637,  -638,  -939,  -866,  -937,  -940},
    { 565,   672,   576,  -742,  -637,  -757,  -625,  -882,  -649},
    { 547,   628,   740,  -671,  -791,  -909,  -585,  -771,  -535},
    { 639,   532,   537,  -665,  -671,  -559,  -798,  -554,  -564},
    { 955,   604,   598,  -564,  -558,  -706,  -891,  -714,  -699},
    { 562,   580,   900,  -637,  -989, -1021,  -617,  -658,  -791},
    { 603,   899,   621,  -530,  -733,  -545,  -712,  -789,  -755},
    { 746,   533,   624,  -776,  -909,  -650,  -543,  -555,  -761},
    { 729,   514,   735,  -733,  -523,  -739,  -519,  -517,  -528},
    { 853,   551,   692,  -919,  -577,  -745,  -711,  -593,  -936},
    { 949,  1018,  1004,  -944,  -931,  -999,  -880, -1013,  -985},
    { 544,   988,   735,  -525,  -781,  -710,  -578,  -954,  -528},
    { 789,   782,   821,  -603,  -633,  -628,  -608,  -598,  -659},
    { 897,   516,   754,  -906,  -661,  -761,  -786,  -521,  -556},
    { 517,   702,   828,  -710,  -837,  -568,  -523,  -963,  -670},
    { 586,   818,   763,  -937,  -874,  -609,  -672,  -654,  -568},
    { 907,   652,   592,  -578,  -525,  -754,  -804,  -830,  -686},
    { 528,   652,   642,  -673,  -663,  -818,  -546,  -830,  -806},
    { 531,   708,   780,  -736,  -811,  -540,  -552,  -981,  -595},
    { 666,   625,   727,  -813,  -946,  -888,  -867,  -763,  -516},
    { 947,   727,   554,  -673,  -512,  -787,  -875,  -517,  -599},
    { 549,   657,   981,  -705,  -526,  -630,  -589,  -843,  -941},
    { 605,   920,   852,  -544, -1008,  -766,  -716,  -827,  -709},
    { 624,   619,   983,  -755,  -599,  -595,  -761,  -750,  -944},
    { 605,   909,   547,  -537,  -646,  -971,  -715,  -807,  -584},
    { 690,   935,   516,  -631,  -697,  -944,  -932,  -855,  -521},
    { 700,   612,   853,  -838,  -584, -1021,  -959,  -732,  -711},
    { 767,   832,   574,  -623,  -861,  -933,  -575,  -676,  -643},
    { 523,   898,   923,  -919,  -945,  -810,  -536,  -789,  -833},
    { 722,   958,   691,  -676,  -976,  -647, -1020,  -896,  -935},
    { 613,   771,   928,  -924,  -556,  -700,  -734,  -581,  -842},
    { 758,   757,   584,  -561,  -866,  -865,  -562,  -560,  -667},
    { 512,   567,   577,  -567,  -577,  -639,  -512,  -628,  -650},
    { 615,   638,   698,  -766,  -839,  -871,  -739,  -795,  -954},
    { 574,   642,   589,  -720,  -660,  -739,  -644,  -806,  -677},
    { 993,   682,   878,  -662,  -852,  -585,  -963,  -910,  -753},
    { 539,   890,   913,  -939,  -963,  -795,  -569,  -775,  -815},
    { 694,   928,   544,  -629,  -738,  -987,  -941,  -842,  -578},
    { 805,   600,   680,  -944,  -535,  -798,  -633,  -704,  -905},
    { 540,   951,   782, -1004,  -825,  -727,  -570,  -884,  -597},
    { 816,   950,   590,  -757,  -941,  -548,  -650,  -881,  -681},
    { 955,   847,   811,  -790,  -757,  -671,  -891,  -700,  -643},
    { 547,   883,   556,  -945,  -595,  -960,  -586,  -762,  -605},
    { 652,   888,   604,  -565,  -770,  -524,  -831,  -770,  -713},
    { 863,   585,   855,  -986,  -721,  -978,  -727,  -668,  -715},
    {1023,   997,   516,  -997,  -516, -1006, -1023,  -972,  -520},
    { 932,   614,   640,  -560,  -583,  -769,  -850,  -738,  -800},
    { 627,   564,   573,  -691,  -702,  -631,  -769,  -621,  -641},
    { 876,   900,   724,  -770,  -620,  -637,  -750,  -792,  -512},
    { 515,   857,   896,  -863,  -902,  -750,  -519,  -718,  -784},
    { 647,   953,   879,  -602,  -555,  -818,  -817,  -888,  -755},
    { 806,   854,   857,  -672,  -675,  -715,  -634,  -712,  -718},
    { 545,   583,   631,  -621,  -672,  -719,  -581,  -664,  -778},
    { 657,   601,   751,  -772,  -963,  -882,  -843,  -707,  -550},
    { 740,   905,   795,  -654,  -575,  -704,  -535,  -801,  -618},
    { 841,  1016,   568,  -835,  -934,  -564,  -691, -1009,  -631},
    { 747,   589,   983,  -861,  -718,  -566,  -545,  -679,  -945},
    { 878,   613,   526,  -526,  -902,  -630,  -753,  -736,  -540},
    { 864,   723,   779,  -610,  -657,  -550,  -729, -1022,  -592},
    { 534,   674,   774,  -703,  -808, -1019,  -557,  -887,  -586},
    { 950,   649,   939,  -602,  -871,  -595,  -881,  -824,  -861},
    { 590,   703,   899,  -811,  -518,  -618,  -680,  -966,  -790},
    { 618,   527,   579,  -637,  -700,  -597,  -746,  -543,  -657},
    { 725,   647,   972,  -917,  -689,  -615,  -513,  -818,  -924},
    { 641,   647,   707,  -810,  -885,  -893,  -803,  -817,  -976},
    { 730,   663,   644,  -946,  -920,  -835,  -521,  -860,  -812},
    { 807,   572,   578,  -902,  -912,  -646,  -637,  -639,  -653},
    { 879,   611,   821,  -524,  -705,  -979,  -755,  -729,  -658},
    { 667,   729,   841,  -951,  -549,  -599,  -871,  -519,  -692},
    { 782,   585,   751,  -895,  -574,  -859,  -598,  -670,  -551},
    { 802,   733,   976,  -574,  -765,  -699,  -628,  -525,  -931},
    { 850,   871,   708,  -724,  -588,  -602,  -706,  -742,  -979},
    { 870,   743,   704,  -632,  -598, -1023,  -739,  -540,  -970},
    { 941,   899,   585,  -827,  -538,  -514,  -866,  -790,  -669},
    { 943,   632,   875,  -582,  -806,  -541,  -869,  -781,  -749},
    {1023,   732,   638,  -731,  -637,  -912, -1022,  -523,  -795},
    { 778,   753,   655,  -573,  -997,  -965,  -592,  -554,  -839},
    { 843,   945,   945,  -779,  -779,  -873,  -694,  -873,  -873},
    { 942,   969,   572,  -892,  -527,  -542,  -867,  -918,  -640},
    {1008,   559,   854,  -551,  -841,  -934,  -993,  -612,  -712},
    { 868,   729,   787,  -618,  -668,  -560,  -737,  -519,  -605},
    { 970,   686,   547,  -650,  -518,  -733,  -919,  -919,  -585},
    { 535,   635,   674,  -664,  -705,  -836,  -560,  -788,  -887},
    { 560,   636,   828,  -696,  -907,  -514,  -613,  -790,  -670},
    { 994,   592,   833,  -575,  -809,  -964,  -966,  -686,  -677},
    { 548,   621,   694,  -665,  -743,  -843,  -587,  -755,  -942},
    { 550,   801,   955,  -861,  -513,  -748,  -591,  -627,  -892},
    { 582,   522,   646,  -594,  -735,  -659,  -663,  -533,  -815},
    { 606,   625,   818,  -739,  -969,  -999,  -717,  -763,  -655},
    { 623,   591,   874,  -720,  -531, -1010,  -758,  -683,  -746},
    { 669,   535,  1001,  -700,  -654,  -523,  -876,  -559,  -979},
    { 701,   938,   592,  -642,  -810,  -542,  -960,  -860,  -684},
    { 925,   820,   738,  -741,  -667,  -592,  -835,  -657,  -533},
    { 735,   790,   544,  -567,  -781,  -840,  -527,  -610,  -578},
    { 575,   788,   674,  -886,  -758,  -519,  -647,  -607,  -888},
    { 655,   783,   528, -1003,  -677,  -809,  -840,  -599,  -545},
    { 527,   513,   677,  -529,  -699,  -679,  -544,  -514,  -897},
    { 782,   852,   940,  -651,  -718,  -783,  -597,  -709,  -863},
    { 578,   910,   513,  -514,  -581,  -914,  -654,  -809,  -515},
    { 692,   882,   734,  -596,  -993,  -632,  -937,  -759,  -526},
    { 586,   683,   715,  -782,  -818,  -954,  -670,  -911,  -999},
    { 739,   609,   717,  -880,  -518,  -854,  -534,  -725, -1006},
    { 778,   773,   697,  -588,  -530,  -527,  -592,  -584,  -951},
    { 922,   785,   813,  -707,  -732,  -624,  -830,  -602,  -646},
    { 766,   651,   984,  -974,  -736,  -626,  -573,  -827,  -946},
    { 978,   596,   515,  -569,  -984,  -600,  -934,  -694,  -518},
    { 535,   757,   540,  -792,  -565,  -799,  -560,  -559,  -571},
    { 662,   687,   589,  -890,  -762,  -791,  -857,  -924,  -678},
    { 554,   536,   979,  -580,  -530,  -512,  -601,  -561,  -936},
    { 723,   982,   690,  -694,  -976,  -662, -1022,  -943,  -932},
    { 936,   956,   527,  -875,  -965,  -986,  -856,  -894,  -543},
    { 590,  1002,   547,  -577,  -631,  -536,  -680,  -980,  -586},
    { 517,   653,   825,  -660,  -833,  -526,  -522,  -834,  -664},
    { 832,   592,   974,  -964,  -792,  -564,  -677,  -686,  -928},
    { 512,   957,   903,  -957,  -903,  -844,  -512,  -894,  -796},
    { 631,   545,   906,  -672,  -558,  -965,  -777,  -581,  -802},
    { 514,   720,   649,  -723,  -652,  -913,  -516, -1012,  -824},
    { 596,   679,   694,  -790,  -807,  -920,  -693,  -900,  -940},
    { 617,   740,   979,  -892,  -590,  -708,  -743,  -535,  -936},
    { 711,   685,   877,  -952,  -609,  -587,  -987,  -917,  -752},
    { 655,   835,   848,  -534,  -542,  -691,  -838,  -681,  -702},
    { 754,   839,   698,  -618,  -515,  -573,  -556,  -688,  -954},
    { 871,   515,   769,  -877,  -655,  -774,  -742,  -518,  -578},
    { 955,   852,   573,  -795,  -535,  -955,  -892,  -709,  -643},
    { 640,   859,   587,  -537,  -735,  -986,  -801,  -721,  -674},
    { 792,   863,   554,  -667,  -858,  -935,  -612,  -727,  -601},
    { 843,   708,   682,  -583,  -562,  -944,  -694,  -979,  -910},
    { 971,   768,   552,  -728,  -524,  -829,  -921,  -576,  -596},
    { 891,   536,   690,  -935,  -601,  -724,  -776,  -563,  -931},
    {1016,   560,   663,  -556,  -659,  -727, -1009,  -614,  -860},
    { 543,   870,   674,  -924,  -716,  -573,  -577,  -739,  -889},
    { 601,   999,   585,  -586,  -686,  -571,  -705,  -975,  -668},
    { 945,   966,   889,  -892,  -821,  -840,  -872,  -912,  -773},
    { 529,   912,   777,  -943,  -804,  -692,  -547,  -812,  -590},
    { 574,  1020,   714,  -572,  -801,  -711,  -643, -1016,  -997},
    { 609,   922,   932,  -549,  -555,  -840,  -725,  -831,  -848},
    { 598,   778,   929,  -909,  -543,  -707,  -698,  -592,  -844},
    { 651,   772,   744,  -982,  -947,  -561,  -827,  -582,  -541},
    { 691,   957,   722,  -646,  -976,  -675,  -934,  -894, -1020},
    { 729,   766,   984,  -546,  -701,  -736,  -520,  -573,  -945},
    { 547,   519,   632,  -555,  -675,  -640,  -585,  -526,  -780},
    { 583,   532,   922,  -607,  -525,  -960,  -664,  -554,  -831},
    { 633,   995,   603,  -615,  -745,  -586,  -783,  -968,  -710},
    { 677,   571,   874,  -757,  -578,  -977,  -896,  -638,  -747},
    { 602,   545,   666,  -641,  -783,  -709,  -708,  -580,  -866},
    { 627,   542,   875,  -665,  -536,  -928,  -769,  -575,  -748},
    { 672,   983,   598,  -645,  -786,  -575,  -882,  -944,  -700},
    { 692,   979,   730,  -662,  -988,  -698,  -937,  -937,  -521},
    { 668,   634,   872,  -827,  -569,  -540,  -871,  -785,  -742},
    { 711,   706,   674,  -982,  -937,  -931,  -988,  -975,  -889},
    { 739,   977,   595,  -706,  -860,  -568,  -534,  -932,  -691},
    { 759,   905,   763,  -671,  -566,  -675,  -563,  -799,  -569},
    { 756,   582,   763,  -860,  -563,  -868,  -558,  -663,  -568},
    { 748,  1013,   908,  -741,  -664,  -898,  -547, -1002,  -805},
    { 804,   937,   950,  -736,  -746,  -869,  -631,  -858,  -882},
    { 785,   543,   998,  -833,  -766,  -529,  -602,  -576,  -973},
    { 999,   684,   942,  -668,  -920,  -630,  -975,  -915,  -868},
    { 626,   633,   996,  -774,  -609,  -616,  -765,  -783,  -970},
    { 626,   567,   835,  -693, -1021,  -925,  -765,  -628,  -681},
    { 739,   571,   973,  -825,  -702,  -543,  -533,  -637,  -925},
    { 655,   769,   707,  -984,  -906,  -531,  -839,  -577,  -978},
    { 702,   952,   571,  -653,  -785,  -532,  -964,  -886,  -638},
    { 727,   712,   514, -1012,  -730,  -715,  -516,  -990,  -516},
    { 744,   686,   741,  -998,  -539,  -994,  -541,  -921,  -536},
    { 731,   552,   714,  -789, -1021,  -772,  -522,  -596,  -998},
    { 824,   991,   726,  -798,  -585,  -703,  -664,  -959,  -515},
    { 795,   615,   544,  -955,  -844,  -653,  -617,  -738,  -578},
    { 870,   575,   824,  -978,  -700,  -926,  -739,  -646,  -664},
    { 803,   832,   923,  -653,  -724,  -750,  -630,  -677,  -832},
    { 819,   839,   531,  -671,  -849,  -871,  -655,  -688,  -550},
    { 887,   786,   852,  -681,  -738,  -654,  -769,  -603,  -709},
    { 933,   764,   570,  -696,  -519,  -851,  -850,  -570,  -634},
    { 716,   906,   654,  -634,  -916,  -579, -1003,  -802,  -837},
    { 784,   804,   563,  -616,  -864,  -885,  -601,  -631,  -620},
    { 774,   535,   876,  -809,  -662,  -915,  -585,  -559,  -749},
    { 807,   598,   649,  -943, -1023,  -758,  -636,  -699,  -822},
    { 817,   759,   718,  -606,  -573,  -533,  -652,  -563, -1008},
    { 831,   993,   846,  -806,  -687,  -821,  -675,  -963,  -699},
    { 858,   567,   605,  -951, -1015,  -670,  -720,  -628,  -716},
    { 876,  1012,   651,  -866,  -557,  -643,  -750, -1001,  -827},
    { 852,   548,   549,  -913,  -914,  -588,  -710,  -587,  -589},
    { 895,  1008,   871,  -881,  -761,  -858,  -782,  -993,  -741},
    { 892,  1000,   591,  -872,  -515,  -578,  -777,  -977,  -683},
    { 935,   516,   836,  -944,  -764,  -844,  -855,  -521,  -682},
    { 931,   612,   776,  -557,  -706,  -929,  -847,  -733,  -589},
    { 968,   614,   816,  -581,  -771,  -980,  -915,  -738,  -651},
    { 524,   777,   719,  -796,  -737,  -546,  -537,  -590, -1012},
    { 549,   694,   786,  -744,  -843,  -533,  -589,  -941,  -603},
    { 882,   754,   534,  -649,  -920,  -787,  -759,  -555,  -557},
    { 597,   837,   766,  -977,  -895,  -627,  -697,  -684,  -574},
    { 635,   954,   704,  -592,  -873,  -656,  -788,  -890,  -969},
    { 803,   550,   798,  -863,  -626,  -858,  -630,  -591,  -622},
    { 699,   654,   798,  -894,  -545, -1021,  -954,  -837,  -622},
    { 924,   767,   738,  -693,  -666,  -553,  -834,  -575,  -531},
    { 970,   675,   608,  -639,  -576,  -801,  -919,  -890,  -722},
    { 632,   706,   684,  -873,  -844,  -944,  -780,  -976,  -914},
    { 858,   767,   563,  -643,  -945,  -844,  -719,  -574,  -620},
    { 527,   765,   702,  -788,  -724,  -525,  -543,  -572,  -964},
    { 559,   924,  1003, -1009,  -547,  -905,  -610,  -833,  -983},
    { 618,   524,   611,  -633,  -738,  -625,  -747,  -536,  -729},
    { 999,   942,   963,  -920,  -940,  -886,  -976,  -867,  -905},
    { 547,   857,   935,  -916,  -999,  -783,  -584,  -718,  -854},
    { 734,   926,   569,  -665,  -818,  -515,  -527,  -838,  -634},
    { 967,   746,   551,  -705,  -520,  -804,  -913,  -544,  -593},
    { 834,   633,   881,  -515,  -718,  -545,  -679,  -783,  -758},
    { 941,   701,   727,  -645,  -668,  -997,  -865,  -961,  -516},
    { 945,   564,   636,  -521,  -587,  -701,  -873,  -623,  -790},
    { 512,   563,   793,  -563,  -794,  -873,  -512,  -619,  -615},
    { 984,   556,   570,  -534,  -548,  -620,  -945,  -604,  -636},
    { 984,   540,   740,  -519,  -712,  -782,  -946,  -570,  -536},
    { 527,   764,   874,  -787,  -901,  -652,  -543,  -570,  -747},
    { 530,   664,  1014,  -688,  -525,  -658,  -549,  -862, -1005},
    { 546,   515,   521,  -550,  -556,  -525,  -584,  -519,  -531},
    { 554,   934,   672, -1011,  -728,  -613,  -600,  -852,  -882},
    { 598,   945,   556,  -552,  -650,  -513,  -700,  -872,  -603},
    { 627,   531,   733,  -651,  -899,  -760,  -769,  -551,  -525},
    { 576,  1020,  1014,  -574,  -571, -1011,  -650, -1016, -1005},
    { 623,   924,   594,  -563,  -724,  -537,  -759,  -835,  -691},
    { 678,   909,   603,  -602,  -800,  -536,  -899,  -807,  -712},
    { 814,   744,   543,  -592,  -865,  -790,  -648,  -541,  -577}
};

static const uint8_t wavtable2[256][9] = {
    {14, 14, 14, 20, 20, 19, 21, 20, 20},
    {14, 14, 14, 20, 20, 20, 20, 21, 21},
    {14, 13, 14, 18, 20, 19, 21, 18, 21},
    {13, 13, 14, 18, 19, 19, 19, 18, 21},
    {13, 14, 13, 19, 18, 18, 19, 20, 19},
    {13, 14, 15, 19, 19, 20, 19, 21, 22},
    {13, 13, 13, 17, 17, 18, 18, 19, 19},
    {12, 14, 13, 18, 17, 19, 17, 20, 19},
    {13, 13, 13, 18, 18, 17, 19, 18, 18},
    {13, 13, 12, 18, 17, 17, 18, 19, 17},
    {13, 12, 13, 17, 17, 16, 18, 17, 18},
    {12, 13, 12, 17, 16, 17, 17, 19, 17},
    {12, 13, 13, 16, 17, 17, 17, 18, 18},
    {12, 13, 13, 16, 16, 17, 16, 19, 18},
    {12, 12, 13, 15, 16, 16, 16, 17, 18},
    {11, 13, 13, 15, 15, 17, 15, 18, 18},
    {13, 12, 13, 16, 17, 17, 18, 16, 19},
    {12, 12, 12, 16, 16, 16, 17, 16, 17},
    {13, 12, 12, 17, 17, 15, 19, 16, 16},
    {13, 12, 11, 16, 16, 14, 19, 16, 15},
    {12, 12, 12, 16, 16, 16, 17, 17, 17},
    {12, 13, 11, 16, 15, 16, 17, 18, 15},
    {12, 12, 11, 16, 14, 15, 16, 17, 15},
    {11, 13, 12, 15, 15, 16, 15, 18, 16},
    {12, 12, 12, 15, 15, 15, 16, 16, 16},
    {11, 12, 12, 15, 14, 15, 15, 16, 16},
    {11, 12, 12, 15, 15, 16, 15, 16, 17},
    {11, 12, 13, 15, 15, 16, 14, 17, 18},
    {11, 12, 11, 15, 14, 15, 15, 17, 15},
    {11, 12, 11, 15, 14, 15, 14, 17, 15},
    {11, 13, 12, 15, 14, 16, 14, 18, 17},
    {11, 12, 12, 14, 14, 16, 14, 17, 17},
    {12, 12, 12, 15, 16, 15, 17, 16, 17},
    {12, 11, 12, 15, 16, 15, 17, 15, 16},
    {12, 12, 11, 15, 15, 15, 17, 16, 15},
    {12, 12, 11, 15, 14, 14, 16, 16, 15},
    {13, 11, 11, 15, 15, 14, 18, 15, 15},
    {12, 11, 10, 15, 14, 13, 17, 15, 13},
    {11, 11, 11, 14, 14, 14, 15, 15, 14},
    {11, 11, 10, 14, 13, 13, 15, 15, 13},
    {12, 11, 12, 14, 15, 15, 16, 15, 17},
    {11, 11, 12, 14, 15, 15, 15, 15, 16},
    {11, 12, 11, 14, 14, 14, 15, 16, 15},
    {11, 11, 11, 14, 14, 14, 14, 15, 15},
    {11, 11, 12, 14, 14, 15, 14, 15, 16},
    {11, 11, 12, 14, 14, 15, 14, 15, 17},
    {11, 12, 12, 14, 14, 15, 14, 16, 16},
    {10, 12, 12, 13, 14, 15, 13, 16, 16},
    {11, 12, 11, 14, 13, 14, 14, 16, 14},
    {11, 11, 11, 14, 13, 14, 14, 15, 14},
    {10, 12, 11, 14, 13, 14, 13, 17, 14},
    {10, 12, 11, 14, 13, 14, 13, 16, 14},
    {11, 11, 11, 13, 13, 14, 14, 15, 15},
    {10, 11, 11, 13, 13, 14, 13, 15, 15},
    {10, 11, 12, 13, 14, 14, 13, 15, 16},
    {10, 11, 12, 13, 14, 15, 13, 15, 16},
    {11, 12, 11, 14, 13, 15, 14, 16, 15},
    {10, 12, 12, 14, 13, 15, 13, 17, 16},
    {10, 13, 12, 14, 14, 16, 13, 18, 16},
    {10, 12, 13, 14, 14, 16, 13, 17, 18},
    {10, 12, 11, 13, 13, 15, 13, 16, 15},
    {10, 12, 11, 13, 13, 15, 13, 16, 15},
    {10, 12, 12, 14, 13, 16, 13, 17, 16},
    {10, 12, 12, 13, 14, 16, 12, 16, 17},
    {12, 11, 12, 15, 16, 14, 17, 14, 16},
    {12, 11, 11, 14, 15, 13, 17, 14, 15},
    {11, 11, 12, 14, 14, 14, 15, 14, 16},
    {11, 11, 11, 13, 14, 14, 14, 14, 15},
    {11, 10, 11, 13, 14, 13, 15, 13, 15},
    {11, 10, 11, 13, 14, 13, 15, 13, 15},
    {12, 10, 10, 14, 14, 12, 17, 13, 13},
    {12, 10, 10, 13, 13, 11, 16, 13, 12},
    {11, 11, 11, 14, 14, 13, 15, 14, 14},
    {11, 11, 10, 13, 13, 13, 15, 14, 13},
    {11, 11, 10, 14, 12, 13, 14, 15, 13},
    {10, 12, 10, 14, 12, 13, 13, 16, 12},
    {11, 11, 11, 13, 14, 13, 14, 14, 15},
    {11, 11, 11, 13, 13, 13, 14, 14, 14},
    {10, 11, 11, 13, 13, 14, 13, 14, 15},
    {10, 11, 11, 12, 13, 13, 13, 14, 15},
    {11, 10, 11, 13, 13, 13, 14, 13, 14},
    {11, 11, 10, 13, 12, 13, 14, 14, 13},
    {11, 10, 10, 12, 12, 12, 14, 13, 13},
    {10, 10, 10, 12, 12, 12, 13, 13, 13},
    {11, 11, 10, 13, 12, 12, 14, 14, 12},
    {10, 11, 10, 13, 12, 12, 13, 14, 12},
    {10, 11, 10, 12, 11, 12, 13, 14, 12},
    {10, 11, 10, 12, 11, 12, 12, 14, 12},
    {10, 10, 11, 12, 13, 13, 13, 13, 15},
    {10, 10, 11, 12, 13, 13, 13, 13, 14},
    {10, 11, 11, 12, 12, 13, 12, 14, 14},
    {10, 11, 11, 12, 13, 13, 12, 14, 15},
    {10, 10, 11, 12, 12, 12, 12, 13, 14},
    {10, 10, 10, 11, 12, 12, 12, 13, 13},
    {10, 10, 11, 11, 12, 12, 12, 13, 14},
    { 9, 10, 11, 11, 12, 13, 11, 13, 14},
    {11, 11, 11, 13, 13, 13, 14, 15, 14},
    {10, 11, 11, 13, 12, 13, 13, 15, 14},
    {10, 11, 10, 13, 12, 13, 13, 15, 13},
    {10, 11, 11, 13, 12, 13, 12, 15, 14},
    {10, 11, 11, 13, 13, 14, 13, 15, 15},
    {10, 11, 11, 13, 13, 14, 12, 15, 15},
    {10, 11, 11, 13, 13, 14, 12, 15, 15},
    {10, 11, 12, 12, 13, 15, 12, 15, 16},
    {10, 12, 11, 14, 12, 14, 13, 16, 14},
    {10, 12, 11, 14, 12, 15, 12, 17, 14},
    {10, 12, 12, 13, 13, 15, 12, 16, 16},
    {10, 13, 12, 14, 13, 16, 12, 18, 17},
    {10, 12, 11, 13, 12, 15, 12, 16, 15},
    {10, 12, 11, 13, 12, 14, 12, 16, 15},
    {10, 12, 12, 13, 13, 15, 12, 17, 16},
    {10, 12, 12, 13, 13, 16, 12, 16, 17},
    {10, 12, 10, 13, 12, 14, 12, 16, 13},
    {10, 12, 11, 13, 12, 14, 12, 16, 14},
    {10, 12, 10, 13, 11, 13, 12, 16, 13},
    {10, 11, 11, 12, 12, 14, 12, 15, 14},
    {10, 11, 11, 12, 12, 13, 12, 14, 14},
    {10, 11, 11, 12, 12, 14, 12, 15, 15},
    { 9, 11, 11, 12, 12, 14, 11, 15, 15},
    { 9, 11, 12, 12, 13, 14, 11, 15, 16},
    {10, 12, 11, 13, 12, 15, 12, 17, 14},
    { 9, 12, 11, 13, 12, 15, 11, 17, 15},
    { 9, 12, 12, 13, 12, 15, 11, 16, 16},
    { 9, 12, 12, 13, 13, 16, 11, 17, 17},
    { 9, 12, 11, 13, 12, 15, 11, 17, 14},
    { 9, 12, 12, 13, 12, 16, 11, 17, 16},
    { 9, 12, 12, 13, 12, 15, 11, 17, 16},
    { 9, 13, 12, 13, 13, 16, 11, 18, 17},
    {12, 10, 11, 13, 14, 12, 16, 12, 14},
    {11, 10, 10, 12, 13, 12, 14, 12, 13},
    {10, 10, 11, 12, 13, 12, 13, 12, 15},
    {10, 10, 10, 12, 12, 12, 13, 12, 13},
    {11,  9, 10, 12, 13, 11, 15, 11, 13},
    {11, 10, 10, 12, 12, 11, 14, 12, 12},
    {10, 10,  9, 11, 11, 11, 13, 12, 11},
    {10, 10,  9, 11, 11, 10, 13, 12, 10},
    {10, 10, 10, 12, 12, 12, 13, 13, 13},
    {10, 10, 10, 12, 11, 12, 12, 13, 13},
    {10, 10, 10, 11, 11, 11, 12, 12, 13},
    {10, 10, 10, 11, 11, 11, 12, 12, 12},
    {10, 10, 10, 12, 11, 11, 12, 13, 12},
    {10, 10,  9, 11, 11, 11, 12, 13, 11},
    { 9, 10,  9, 11, 10, 11, 11, 12, 11},
    { 9, 10,  9, 11, 10, 11, 11, 13, 11},
    {10,  9, 11, 11, 12, 11, 13, 11, 14},
    {10, 10, 10, 11, 12, 11, 13, 12, 13},
    {10, 10, 10, 11, 12, 12, 12, 12, 13},
    { 9, 10, 10, 10, 11, 11, 11, 12, 13},
    {10,  9, 10, 11, 12, 10, 13, 11, 12},
    {10,  9, 10, 11, 11, 10, 12, 11, 12},
    { 9, 10, 10, 11, 11, 11, 11, 12, 12},
    { 9,  9, 10, 10, 10, 11, 11, 11, 12},
    { 9, 10, 10, 11, 11, 12, 11, 13, 13},
    { 9, 10, 10, 11, 11, 12, 11, 13, 13},
    { 9, 10, 11, 11, 11, 12, 11, 12, 14},
    { 9, 10, 11, 11, 11, 12, 11, 13, 14},
    { 9, 10, 10, 10, 10, 11, 11, 12, 12},
    { 9, 10, 10, 10, 10, 11, 10, 12, 13},
    { 9,  9, 10, 10, 10, 11, 10, 11, 12},
    { 9, 10, 10, 10, 10, 12, 10, 12, 13},
    {10, 11, 10, 12, 12, 13, 13, 14, 13},
    {10, 11, 10, 12, 12, 13, 12, 14, 13},
    {10, 11, 10, 12, 11, 13, 12, 15, 13},
    {10, 11, 10, 12, 11, 13, 12, 14, 13},
    {10, 10, 10, 12, 11, 12, 12, 13, 13},
    {10, 10, 10, 11, 11, 12, 12, 13, 13},
    { 9, 11, 10, 12, 11, 12, 11, 14, 13},
    { 9, 11, 10, 11, 11, 12, 11, 14, 13},
    {10, 11, 11, 12, 12, 13, 12, 14, 14},
    { 9, 11, 11, 12, 12, 13, 11, 14, 14},
    { 9, 11, 11, 11, 12, 13, 11, 14, 15},
    { 9, 11, 12, 11, 12, 14, 11, 14, 16},
    { 9, 11, 11, 12, 11, 13, 11, 14, 14},
    { 9, 11, 11, 12, 12, 13, 11, 14, 14},
    { 9, 11, 11, 11, 12, 13, 11, 14, 15},
    { 9, 11, 12, 11, 12, 14, 10, 14, 16},
    { 9, 11, 10, 12, 11, 13, 11, 15, 13},
    { 9, 11, 11, 12, 11, 14, 11, 15, 14},
    { 9, 12, 10, 12, 11, 13, 11, 16, 13},
    { 9, 11, 11, 12, 11, 14, 11, 15, 14},
    { 9, 11, 11, 12, 12, 14, 11, 15, 15},
    { 9, 11, 12, 12, 12, 15, 11, 15, 16},
    { 9, 12, 11, 12, 12, 14, 11, 16, 15},
    { 9, 12, 12, 12, 13, 15, 11, 16, 16},
    { 9, 12, 11, 13, 11, 14, 11, 17, 14},
    { 9, 12, 11, 13, 12, 15, 11, 17, 15},
    { 9, 12, 11, 12, 12, 14, 10, 16, 15},
    { 9, 12, 12, 12, 12, 15, 10, 16, 16},
    { 9, 12, 11, 13, 11, 15, 10, 17, 14},
    { 9, 13, 12, 13, 12, 16, 10, 18, 16},
    { 9, 13, 12, 13, 12, 16, 10, 18, 16},
    { 9, 12, 13, 13, 13, 16, 10, 17, 18},
    {10, 11, 10, 12, 11, 12, 12, 15, 12},
    { 9, 11, 10, 12, 10, 12, 11, 15, 12},
    { 9, 10, 10, 11, 11, 12, 11, 13, 12},
    { 9, 10, 10, 11, 10, 11, 10, 13, 12},
    { 9, 11, 10, 12, 11, 12, 11, 14, 13},
    { 9, 11, 10, 11, 11, 12, 11, 14, 13},
    { 9, 11, 10, 12, 11, 13, 10, 15, 13},
    { 9, 11, 11, 12, 11, 14, 10, 15, 14},
    { 9, 10, 10, 11, 11, 12, 10, 13, 13},
    { 9, 11, 10, 11, 10, 12, 10, 14, 12},
    { 9, 10, 10, 11, 11, 12, 10, 13, 13},
    { 9, 10, 11, 11, 11, 13, 10, 13, 14},
    { 9, 11, 11, 11, 11, 13, 10, 14, 14},
    { 9, 11, 11, 11, 12, 14, 10, 14, 15},
    { 9, 11, 11, 11, 11, 13, 10, 14, 14},
    { 9, 11, 11, 11, 11, 14, 10, 14, 15},
    { 9, 12, 10, 12, 11, 13, 11, 16, 13},
    { 9, 12, 10, 12, 11, 14, 10, 16, 13},
    { 9, 11, 11, 12, 11, 14, 10, 15, 14},
    { 9, 11, 11, 12, 12, 14, 10, 15, 15},
    { 9, 12, 11, 12, 11, 14, 10, 16, 15},
    { 9, 12, 12, 12, 12, 15, 10, 16, 16},
    { 9, 12, 11, 13, 12, 15, 10, 17, 15},
    { 9, 13, 12, 13, 12, 16, 10, 18, 17},
    { 9, 11, 10, 12, 11, 13, 10, 15, 13},
    { 9, 12, 11, 12, 11, 14, 10, 16, 14},
    { 9, 12, 11, 12, 11, 14, 10, 16, 15},
    { 9, 11, 12, 12, 12, 15, 10, 15, 16},
    { 9, 12, 11, 12, 11, 15, 10, 17, 14},
    { 9, 12, 12, 12, 12, 16, 10, 17, 16},
    { 8, 12, 11, 12, 11, 14,  9, 16, 15},
    { 8, 12, 12, 12, 12, 15,  9, 17, 16},
    {10,  9,  9, 10, 11, 10, 12, 10, 11},
    { 9,  9,  9, 10, 10,  9, 11, 10, 10},
    { 9, 10,  9, 10, 10, 10, 11, 12, 11},
    { 9,  9,  9, 10,  9, 10, 10, 11, 10},
    { 9,  9, 10, 10, 10, 11, 11, 11, 12},
    { 9,  9, 10,  9, 10, 10, 10, 10, 12},
    { 9,  9,  9,  9,  9, 10, 10, 11, 11},
    { 8,  9,  9,  9,  9, 10,  9, 11, 11},
    { 9, 10,  9, 10, 10, 11, 10, 12, 11},
    { 8, 10,  9, 10,  9, 10,  9, 12, 11},
    { 8, 10, 10, 10,  9, 11,  9, 12, 12},
    { 8,  9, 10,  9, 10, 11,  9, 11, 13},
    { 9,  9,  9,  9,  9,  9, 10, 10, 10},
    { 7,  8,  8,  7,  7,  7,  7,  8,  8},
    { 8, 10,  9,  9,  9, 10,  8, 12, 11},
    { 8,  9,  9,  8,  8, 10,  8, 10, 11},
    { 9, 11, 10, 11, 10, 12, 10, 15, 12},
    { 9, 11, 10, 11, 10, 13, 10, 15, 12},
    { 9, 10, 10, 10, 10, 12, 10, 13, 13},
    { 8, 10, 11, 10, 11, 13,  9, 13, 14},
    { 9, 11, 10, 11, 10, 13, 10, 15, 13},
    { 9, 11, 11, 11, 11, 14, 10, 15, 14},
    { 8, 11, 11, 11, 11, 13,  9, 14, 14},
    { 8, 11, 12, 11, 11, 14,  9, 15, 16},
    { 8, 10,  9, 10,  9, 11,  9, 13, 11},
    { 8, 11, 10, 11, 10, 12,  9, 14, 13},
    { 8, 11, 10, 10, 10, 12,  9, 14, 13},
    { 8, 10, 11, 10, 11, 13,  9, 13, 14},
    { 8, 12, 11, 11, 10, 14,  9, 16, 14},
    { 8, 12, 11, 11, 11, 14,  9, 16, 15},
    { 8, 11, 10, 10, 10, 12,  9, 14, 13},
    { 8, 11, 10, 10, 10, 13,  8, 14, 13}
};

static const int8_t etable1[128][40]={
    {
     38,  -4,  15,  -4,  14, -13,  12, -11,  -2,  -6,
     -6, -11, -45, -16, -11, -13,  -7,   6, -12,   4,
    -20,   3, -16,  12,  -1,  12,  46,  24,   0,  33,
     -3,   9, -12, -12,  -8,  -7,  17,  -6,   0,  -2,
    }, {
     60, -16,   3, -22,  10, -32,   0, -28, -17, -18,
     -3, -25, -37, -23, -10,   3,   2,   3,   0,   3,
    -14,   0, -14,  -1,   0,   2,  32,   9,  -1,  25,
      7,  13,  -5,  13,   8,   1,   2,   8, -10,   6,
    }, {
     27, -12,  28,  -2,   6,  -7,  15,   9, -11,   1,
    -13, -11, -40,   4, -29, -14, -19,  -5, -23,  -8,
    -30, -13, -17,   0, -14,  12,  34,  20,  -2,  25,
      2, -16,  -4, -12,  15,  16,  29,   7,  24,  10,
    }, {
     49, -24,  16, -20,   2, -26,   2,  -7, -25, -10,
    -11, -25, -32,  -3, -27,   2,  -8,  -8, -11,  -9,
    -24, -17, -16, -14, -13,   2,  20,   5,  -4,  17,
     14, -12,   3,  13,  33,  25,  14,  23,  15,  19,
    }, {
     46,  -6,  21,   8,  -2, -16,  -5,  -8, -11,   4,
      8,  15, -24,   4,  -2, -26,  -3, -16, -16, -14,
     -9,  -2,  -1,   4,  19,   7,  36,  17,   9,  13,
      0,  31,  -5, -12,   7,  -8,  11, -15, -13,  -4,
    }, {
     68, -18,   9,  -9,  -6, -35, -18, -25, -26,  -7,
     10,   1, -16,  -3,  -1,  -9,   6, -19,  -4, -15,
     -4,  -6,   0,  -8,  20,  -2,  23,   2,   7,   5,
     12,  35,   1,  13,  24,   0,  -3,   0, -22,   4,
    }, {
     35, -14,  34,  10, -10, -10,  -1,  12, -20,  12,
      0,  15, -18,  24, -20, -27, -14, -28, -27, -27,
    -20, -19,  -2,  -8,   5,   7,  25,  13,   5,   5,
      6,   5,   2, -12,  31,  15,  23,  -1,  12,   8,
    }, {
     57, -26,  22,  -7, -14, -28, -14,  -3, -35,   0,
      3,   1, -11,  16, -18, -10,  -4, -31, -15, -28,
    -14, -23,  -1, -21,   7,  -2,  11,  -1,   3,  -1,
     18,   9,  10,  13,  49,  24,   8,  14,   2,  16,
    }, {
     25,  15,  22,  11,  18,   4,  15, -22,   8,  -2,
    -17,  -9, -48, -20, -30, -17, -16,  11,  -1,  16,
      2,  10,  -5,  26,  -2,  -4,  22,   0,   2,  10,
     -6,  13, -14,  10, -23,   0,  10,  -2,   1,   0,
    }, {
     47,   3,  11,  -6,  15, -13,   2, -38,  -6, -13,
    -15, -22, -40, -28, -28,   0,  -5,   8,  10,  15,
      7,   7,  -4,  13,  -1, -14,   9, -14,   0,   2,
      4,  18,  -7,  36,  -6,   8,  -3,  13,  -7,   8,
    }, {
     14,   7,  36,  13,  10,  10,  18,   0,   0,   5,
    -25,  -8, -43,   0, -48, -18, -27,   0, -12,   3,
     -7,  -6,  -7,  13, -15,  -5,  11,  -3,   0,   2,
      0, -12,  -6,  10,   0,  23,  22,  11,  26,  12,
    }, {
     36,  -5,  24,  -4,   7,  -7,   6, -17, -14,  -5,
    -22, -22, -35,  -8, -46,  -1, -17,  -3,   0,   2,
     -2, -10,  -5,   0, -14, -15,  -2, -18,  -2,  -4,
     11,  -7,   1,  36,  18,  32,   7,  27,  17,  20,
    }, {
     33,  13,  29,  24,   1,   1,  -2, -18,   0,   9,
     -3,  17, -27,   0, -21, -30, -12, -11,  -5,  -2,
     12,   4,   9,  19,  18,  -9,  13,  -6,  11,  -8,
     -2,  35,  -8,  10,  -7,  -1,   4, -11, -10,  -2,
    }, {
     55,   1,  17,   6,  -1, -16, -15, -35, -15,  -2,
      0,   4, -19,  -8, -20, -13,  -1, -14,   7,  -3,
     18,   0,  10,   5,  19, -19,   0, -21,   8, -16,
      9,  39,   0,  36,  10,   7,  -9,   4, -20,   5,
    }, {
     22,   5,  42,  26,  -6,   8,   1,   2,  -9,  17,
    -10,  18, -21,  19, -39, -31, -23, -23, -16, -15,
      2, -12,   7,   6,   5,  -9,   1, -10,   7, -16,
      4,   9,   0,  10,  17,  22,  16,   2,  14,   9,
    }, {
     44,  -6,  30,   8,  -9, -10, -11, -14, -23,   5,
     -8,   4, -14,  12, -37, -14, -12, -26,  -4, -16,
      8, -16,   9,  -7,   6, -19, -12, -25,   5, -24,
     15,  13,   8,  36,  34,  31,   1,  18,   4,  18,
    }, {
     -3,  -5,  -9,  -7,  15,  -1,   5,  13,   2,  12,
      5,   2, -21, -23,  -2, -16,   0,   5,  -6,  13,
    -23,   3, -32,  10, -15,   8,  44,  28,   9,  37,
     -2,  13,  -9, -15, -12, -27,  -7, -12,   0, -11,
    }, {
     18, -17, -21, -25,  11, -19,  -6,  -3, -11,   0,
      7, -11, -13, -31,  -1,   0,   9,   1,   5,  12,
    -18,   0, -31,  -2, -13,  -1,  30,  14,   7,  29,
      9,  18,  -1,  10,   4, -18, -22,   3, -10,  -2,
    }, {
    -13, -13,   3,  -5,   7,   4,   9,  34,  -5,  20,
     -2,   3, -16,  -3, -20, -17, -11,  -7, -17,   0,
    -34, -13, -33,  -2, -28,   8,  32,  24,   5,  29,
      3, -12,   0, -15,  11,  -3,   3,   2,  24,   1,
    }, {
      8, -25,  -8, -23,   3, -13,  -3,  17, -20,   8,
      0, -10,  -8, -11, -18,   0,  -1, -10,  -5,   0,
    -28, -17, -32, -15, -26,  -1,  19,   9,   3,  21,
     15,  -7,   6,   9,  29,   5, -10,  17,  15,   9,
    }, {
      4,  -6,  -3,   5,  -1,  -4, -11,  16,  -6,  23,
     19,  29,   0,  -3,   6, -30,   3, -17, -10,  -5,
    -13,  -2, -17,   3,   5,   3,  35,  21,  17,  17,
      2,  35,  -2, -15,   3, -28, -13, -21, -13, -13,
    }, {
     26, -19, -15, -12,  -5, -22, -24,   0, -21,  12,
     21,  15,   8, -11,   7, -12,  14, -20,   2,  -6,
     -7,  -6, -16,  -9,   6,  -5,  21,   7,  15,  10,
     13,  39,   5,  10,  20, -19, -28,  -5, -22,  -5,
    }, {
     -5, -15,   9,   7,  -9,   2,  -8,  37, -14,  31,
     11,  29,   5,  16, -11, -30,  -7, -29, -21, -18,
    -23, -19, -18,  -9,  -7,   3,  23,  17,  14,   9,
      8,   9,   6, -15,  27,  -4,  -2,  -6,  12,  -1,
    }, {
     16, -27,  -2, -10, -13, -16, -20,  20, -29,  20,
     14,  16,  13,   8,  -9, -13,   2, -33,  -9, -19,
    -17, -23, -17, -22,  -6,  -6,   9,   2,  12,   2,
     20,  13,  13,  10,  45,   4, -16,   8,   2,   7,
    }, {
    -16,  14,  -2,   8,  20,  17,   9,   2,  14,  16,
     -6,   5, -24, -28, -21, -20,  -8,   9,   4,  25,
     -1,  11, -22,  24, -15,  -8,  21,   5,  11,  14,
     -5,  18, -11,   7, -27, -20, -14,  -7,   1,  -9,
    }, {
      6,   2, -14,  -9,  16,  -1,  -3, -14,   0,   5,
     -3,  -8, -16, -36, -19,  -3,   1,   6,  17,  24,
      4,   7, -21,  11, -14, -18,   7,  -9,   9,   7,
      6,  22,  -3,  33, -10, -11, -28,   7,  -7,   0,
    }, {
    -26,   6,  11,  10,  12,  23,  12,  23,   5,  24,
    -13,   5, -19,  -8, -38, -21, -20,  -2,  -6,  12,
    -11,  -5, -23,  11, -29,  -9,   9,   0,   7,   6,
      1,  -7,  -2,   7,  -3,   3,  -2,   6,  27,   3,
    }, {
     -4,  -6,   0,  -7,   8,   4,   0,   6,  -9,  13,
    -11,  -7, -11, -15, -37,  -4,  -9,  -5,   5,  11,
     -5,  -9, -22,  -1, -27, -18,  -4, -14,   5,   0,
     12,  -3,   4,  32,  14,  12, -17,  22,  17,  11,
    }, {
     -8,  12,   3,  21,   3,  14,  -8,   5,   4,  28,
      7,  32,  -2,  -8, -12, -34,  -4, -12,   1,   6,
      9,   4,  -7,  17,   4, -13,  11,  -1,  19,  -4,
      0,  39,  -4,   7, -11, -21, -20, -16, -10, -11,
    }, {
     13,   0,  -8,   3,   0,  -4, -21, -11,  -9,  16,
     10,  18,   5, -16, -10, -16,   5, -15,  13,   5,
     15,   1,  -6,   4,   6, -23,  -2, -16,  17, -12,
     10,  44,   3,  33,   6, -12, -34,  -1, -20,  -3,
    }, {
    -18,   4,  17,  23,  -4,  20,  -4,  26,  -3,  36,
      0,  32,   2,  12, -29, -34, -16, -24, -10,  -6,
      0, -12,  -8,   4,  -8, -13,   0,  -6,  16, -12,
      5,  13,   3,   7,  13,   3,  -8,  -2,  14,   0,
    }, {
      3,  -7,   5,   5,  -8,   2, -17,   9, -18,  24,
      2,  19,  10,   4, -28, -17,  -5, -28,   2,  -7,
      4, -15,  -7,  -8,  -6, -23, -13, -21,  14, -20,
     17,  18,  11,  33,  30,  11, -23,  13,   5,   9,
    }, {
     60,  10,   7,  -1,   9,  -8,   6, -13,   2, -15,
     -1, -10, -13, -11,  15,   0,   6,   9,  -1,   0,
    -13,   1, -11,  -3, -13,  21,  13,  26,  -7,  31,
    -10,  -7, -16, -33, -31, -10,  22,  -8,   1,  -2,
    }, {
     82,  -1,  -4, -19,   6, -27,  -6, -29, -12, -26,
      1, -24,  -5, -18,  17,  17,  17,   6,  10,   0,
     -7,  -2,  -9, -16, -12,  11,   0,  11,  -9,  23,
      0,  -3,  -8,  -8, -13,  -1,   8,   7,  -7,   6,
    }, {
     49,   2,  21,   0,   1,  -2,   9,   8,  -6,  -6,
     -8, -10,  -8,   9,  -2,   0,  -4,  -2, -13, -12,
    -23, -15, -12, -16, -26,  21,   2,  21, -11,  23,
     -4, -33,  -7, -33,  -6,  13,  34,   5,  27,  10,
    }, {
     71, -10,   9, -17,  -1, -20,  -3,  -8, -21, -18,
     -6, -24,   0,   1,   0,  16,   6,  -5,   0, -13,
    -17, -19, -11, -29, -25,  11, -11,   6, -13,  15,
      7, -29,   0,  -8,  11,  22,  20,  21,  17,  18,
    }, {
     67,   8,  14,  11,  -7, -11, -11,  -9,  -7,  -3,
     13,  16,   8,   9,  24, -12,  10, -13,  -5, -17,
     -2,  -4,   3, -10,   6,  17,   4,  19,   0,  11,
     -6,  13,  -9, -33, -14, -10,  16, -17, -10,  -4,
    }, {
     90,  -3,   2,  -6, -10, -29, -24, -26, -21, -15,
     15,   2,  16,   1,  25,   4,  21, -16,   6, -18,
      3,  -8,   5, -24,   8,   7,  -9,   4,  -1,   3,
      5,  18,  -1,  -7,   2,  -1,   2,  -1, -19,   3,
    }, {
     57,   0,  27,  13, -14,  -5,  -7,  11, -15,   4,
      5,  16,  13,  29,   6, -13,   0, -25, -16, -31,
    -12, -22,   2, -23,  -6,  16,  -7,  14,  -2,   3,
      0, -12,   0, -33,   9,  13,  28,  -3,  14,   7,
    }, {
     79, -11,  15,  -4, -18, -23, -20,  -5, -30,  -7,
      7,   2,  21,  21,   8,   3,  10, -28,  -4, -31,
     -6, -25,   3, -37,  -4,   7, -20,   0,  -4,  -4,
     11,  -7,   6,  -8,  27,  22,  14,  12,   5,  16,
    }, {
     47,  30,  15,  14,  14,   9,   9, -23,  13, -10,
    -12,  -7, -16, -15,  -3,  -3,  -1,  14,   9,  12,
      9,   8,   0,  10, -14,   4,  -9,   2,  -5,   8,
    -13,  -3, -18, -10, -45,  -3,  16,  -4,   4,   0,
    }, {
     69,  17,   3,  -3,  10,  -8,  -3, -40,  -1, -21,
    -10, -21,  -8, -23,  -1,  13,   8,  11,  21,  11,
     15,   4,   0,  -2, -13,  -5, -23, -12,  -7,   0,
     -1,   0, -10,  14, -28,   5,   1,  11,  -5,   7,
    }, {
     36,  21,  28,  16,   6,  16,  12,  -2,   4,  -2,
    -20,  -7, -11,   4, -20,  -4, -12,   2,  -1,   0,
      0,  -8,  -2,  -2, -27,   4, -21,  -2,  -9,   0,
     -6, -29,  -9, -10, -21,  21,  28,  10,  29,  11,
    }, {
     58,   9,  16,  -1,   2,  -2,   0, -19, -10, -13,
    -17, -21,  -3,  -3, -19,  12,  -2,   0,  10,  -1,
      5, -12,   0, -15, -26,  -5, -34, -16, -11,  -7,
      4, -25,  -2,  14,  -3,  29,  13,  25,  20,  20,
    }, {
     55,  28,  21,  27,  -2,   7,  -8, -20,   4,   1,
      1,  18,   5,   4,   5, -16,   2,  -8,   5,  -5,
     19,   2,  14,   3,   6,   0, -18,  -4,   2, -11,
     -8,  18, -11, -10, -29,  -3,  10, -13,  -8,  -3,
    }, {
     77,  16,   9,   9,  -6, -11, -21, -37, -10, -10,
      4,   5,  13,  -3,   7,   0,  13, -11,  17,  -6,
     25,  -1,  15,  -9,   7,  -9, -32, -19,   0, -18,
      2,  22,  -3,  15, -12,   5,  -4,   2, -17,   5,
    }, {
     44,  20,  34,  29, -10,  13,  -4,   0,  -4,   9,
     -5,  19,  10,  24, -11, -17,  -8, -20,  -5, -19,
      9, -14,  12,  -9,  -6,   0, -30,  -9,   0, -19,
     -2,  -7,  -2, -10,  -5,  20,  21,   1,  17,   9,
    }, {
     66,   8,  23,  11, -14,  -5, -17, -16, -19,  -2,
     -3,   5,  18,  17, -10,   0,   1, -23,   6, -20,
     15, -18,  14, -22,  -5, -10, -44, -23,  -2, -26,
      9,  -3,   4,  14,  12,  29,   7,  16,   7,  18,
    }, {
     18,   9, -17,  -4,  11,   3,   0,  11,   7,   4,
     10,   3,  10, -18,  24,  -3,  14,   7,   4,  10,
    -16,   1, -27,  -4, -27,  17,  12,  30,   0,  35,
     -9,  -3, -12, -36, -35, -30,  -2, -13,   2, -11,
    }, {
     40,  -2, -29, -22,   7, -14, -12,  -5,  -7,  -7,
     12,  -9,  18, -26,  26,  14,  24,   4,  16,   9,
    -10,  -2, -26, -18, -26,   7,  -1,  15,  -1,  27,
      2,   0,  -4, -11, -17, -21, -16,   1,  -7,  -3,
    }, {
      8,   1,  -3,  -2,   3,  10,   3,  32,  -1,  12,
      2,   4,  15,   1,   7,  -3,   2,  -4,  -6,  -3,
    -26, -15, -29, -17, -40,  17,   0,  26,  -2,  27,
     -2, -29,  -4, -36, -10,  -6,   9,   0,  27,   0,
    }, {
     30, -11, -15, -20,   0,  -8,  -9,  15, -15,   0,
      5,  -9,  23,  -6,   8,  13,  13,  -7,   5,  -3,
    -20, -19, -27, -31, -39,   7, -13,  11,  -4,  19,
      8, -25,   3, -11,   7,   2,  -4,  16,  18,   9,
    }, {
     26,   7, -11,   8,  -5,   1, -17,  14,  -1,  15,
     24,  30,  32,   1,  33, -16,  18, -14,   0,  -8,
     -6,  -4, -12, -12,  -6,  13,   2,  23,   8,  15,
     -4,  17,  -5, -36, -18, -30,  -8, -22, -10, -14,
    }, {
     48,  -4, -23,  -9,  -9, -17, -30,  -2, -16,   3,
     26,  16,  40,  -6,  35,   1,  28, -17,  12,  -9,
      0,  -8, -11, -25,  -5,   3, -10,   8,   6,   7,
      6,  22,   1, -11,  -1, -21, -22,  -7, -19,  -5,
    }, {
     15,   0,   2,  10, -13,   7, -14,  35, -10,  23,
     16,  31,  37,  21,  16, -17,   6, -26, -10, -21,
    -16, -21, -13, -25, -19,  13,  -8,  19,   5,   7,
      1,  -8,   2, -36,   5,  -6,   3,  -8,  15,  -1,
    }, {
     37, -12,  -9,  -7, -17, -11, -26,  18, -25,  12,
     19,  17,  45,  14,  17,   0,  17, -30,   1, -22,
    -10, -25, -12, -38, -18,   3, -22,   4,   3,   0,
     13,  -3,  10, -11,  23,   2, -10,   7,   5,   7,
    }, {
      5,  29,  -9,  11,  15,  22,   3,   0,  18,   8,
     -1,   6,   7, -23,   6,  -6,   5,  12,  15,  21,
      5,   8, -17,   9, -28,   0, -11,   6,   2,  12,
    -11,   0, -14, -13, -49, -22,  -8,  -9,   4,  -9,
    }, {
     27,  16, -21,  -6,  12,   3,  -9, -16,   3,  -2,
      1,  -7,  15, -31,   7,  10,  16,   9,  27,  21,
     11,   5, -16,  -3, -26,  -9, -24,  -7,   0,   4,
      0,   4,  -6,  11, -32, -14, -23,   6,  -5,  -1,
    }, {
     -4,  20,   3,  13,   8,  28,   6,  21,  10,  16,
     -8,   7,  12,  -3, -11,  -7,  -5,   0,   4,   8,
     -4,  -8, -18,  -3, -41,   0, -22,   2,   0,   4,
     -5, -25,  -6, -14, -25,   1,   2,   4,  29,   2,
    }, {
     17,   8,  -8,  -4,   4,  10,  -6,   5,  -4,   5,
     -6,  -6,  20, -10,  -9,   9,   4,  -2,  16,   7,
      1, -12, -17, -16, -39,  -9, -36, -12,  -2,  -3,
      6, -21,   1,  11,  -7,  10, -11,  20,  20,  11,
    }, {
     13,  27,  -3,  24,  -1,  19, -14,   3,   9,  20,
     12,  33,  29,  -3,  15, -20,   9,  -9,  11,   3,
     16,   2,  -2,   2,  -7,  -3, -20,   0,  10,  -7,
     -7,  22,  -7, -13, -33, -23, -14, -18,  -7, -12,
    }, {
     35,  15, -15,   6,  -4,   1, -27, -12,  -5,   8,
     15,  19,  37, -11,  16,  -2,  20, -12,  23,   2,
     22,  -1,  -1, -11,  -5, -13, -34, -14,   8, -14,
      4,  26,   0,  11, -16, -14, -29,  -2, -17,  -3,
    }, {
      3,  19,   9,  26,  -8,  26, -10,  24,   0,  28,
      5,  33,  34,  17,  -2, -20,  -1, -22,   0, -10,
      6, -14,  -3, -10, -20,  -4, -32,  -4,   7, -15,
      0,  -3,   0, -13,  -9,   0,  -3,  -4,  17,   0,
    }, {
     25,   7,  -2,   8, -12,   7, -23,   8, -13,  16,
      7,  20,  42,   9,   0,  -3,   9, -25,  12, -10,
     12, -18,  -2, -24, -19, -13, -46, -19,   5, -22,
     10,   0,   8,  11,   8,   9, -17,  11,   7,   8,
    }, {
    -25,  -7,   2,  -8,  12,  -7,  23,  -8,  13, -16,
     -7, -20, -42,  -9,   0,   3,  -9,  25, -12,  10,
    -12,  18,   2,  24,  19,  13,  46,  19,  -5,  22,
    -10,   0,  -8, -11,  -8,  -9,  17, -11,  -7,  -8,
    }, {
     -3, -19,  -9, -26,   8, -26,  10, -24,   0, -28,
     -5, -33, -34, -17,   2,  20,   1,  22,   0,  10,
     -6,  14,   3,  10,  20,   4,  32,   4,  -7,  15,
      0,   3,   0,  13,   9,   0,   3,   4, -17,   0,
    }, {
    -35, -15,  15,  -6,   4,  -1,  27,  12,   5,  -8,
    -15, -19, -37,  11, -16,   2, -20,  12, -23,  -2,
    -22,   1,   1,  11,   5,  13,  34,  14,  -8,  14,
     -4, -26,   0, -11,  16,  14,  29,   2,  17,   3,
    }, {
    -13, -27,   3, -24,   1, -19,  14,  -3,  -9, -20,
    -12, -33, -29,   3, -15,  20,  -9,   9, -11,  -3,
    -16,  -2,   2,  -2,   7,   3,  20,   0, -10,   7,
      7, -22,   7,  13,  33,  23,  14,  18,   7,  12,
    }, {
    -17,  -8,   8,   4,  -4, -10,   6,  -5,   4,  -5,
      6,   6, -20,  10,   9,  -9,  -4,   2, -16,  -7,
     -1,  12,  17,  16,  39,   9,  36,  12,   2,   3,
     -6,  21,  -1, -11,   7, -10,  11, -20, -20, -11,
    }, {
      4, -20,  -3, -13,  -8, -28,  -6, -21, -10, -16,
      8,  -7, -12,   3,  11,   7,   5,   0,  -4,  -8,
      4,   8,  18,   3,  41,   0,  22,  -2,   0,  -4,
      5,  25,   6,  14,  25,  -1,  -2,  -4, -29,  -2,
    }, {
    -27, -16,  21,   6, -12,  -3,   9,  16,  -3,   2,
     -1,   7, -15,  31,  -7, -10, -16,  -9, -27, -21,
    -11,  -5,  16,   3,  26,   9,  24,   7,   0,  -4,
      0,  -4,   6, -11,  32,  14,  23,  -6,   5,   1,
    }, {
     -5, -29,   9, -11, -15, -22,  -3,   0, -18,  -8,
      1,  -6,  -7,  23,  -6,   6,  -5, -12, -15, -21,
     -5,  -8,  17,  -9,  28,   0,  11,  -6,  -2, -12,
     11,   0,  14,  13,  49,  22,   8,   9,  -4,   9,
    }, {
    -37,  12,   9,   7,  17,  11,  26, -18,  25, -12,
    -19, -17, -45, -14, -17,   0, -17,  30,  -1,  22,
     10,  25,  12,  38,  18,  -3,  22,  -4,  -3,   0,
    -13,   3, -10,  11, -23,  -2,  10,  -7,  -5,  -7,
    }, {
    -15,   0,  -2, -10,  13,  -7,  14, -35,  10, -23,
    -16, -31, -37, -21, -16,  17,  -6,  26,  10,  21,
     16,  21,  13,  25,  19, -13,   8, -19,  -5,  -7,
     -1,   8,  -2,  36,  -5,   6,  -3,   8, -15,   1,
    }, {
    -48,   4,  23,   9,   9,  17,  30,   2,  16,  -3,
    -26, -16, -40,   6, -35,  -1, -28,  17, -12,   9,
      0,   8,  11,  25,   5,  -3,  10,  -8,  -6,  -7,
     -6, -22,  -1,  11,   1,  21,  22,   7,  19,   5,
    }, {
    -26,  -7,  11,  -8,   5,  -1,  17, -14,   1, -15,
    -24, -30, -32,  -1, -33,  16, -18,  14,   0,   8,
      6,   4,  12,  12,   6, -13,  -2, -23,  -8, -15,
      4, -17,   5,  36,  18,  30,   8,  22,  10,  14,
    }, {
    -30,  11,  15,  20,   0,   8,   9, -15,  15,   0,
     -5,   9, -23,   6,  -8, -13, -13,   7,  -5,   3,
     20,  19,  27,  31,  39,  -7,  13, -11,   4, -19,
     -8,  25,  -3,  11,  -7,  -2,   4, -16, -18,  -9,
    }, {
     -8,  -1,   3,   2,  -3, -10,  -3, -32,   1, -12,
     -2,  -4, -15,  -1,  -7,   3,  -2,   4,   6,   3,
     26,  15,  29,  17,  40, -17,   0, -26,   2, -27,
      2,  29,   4,  36,  10,   6,  -9,   0, -27,   0,
    }, {
    -40,   2,  29,  22,  -7,  14,  12,   5,   7,   7,
    -12,   9, -18,  26, -26, -14, -24,  -4, -16,  -9,
     10,   2,  26,  18,  26,  -7,   1, -15,   1, -27,
     -2,   0,   4,  11,  17,  21,  16,  -1,   7,   3,
    }, {
    -18,  -9,  17,   4, -11,  -3,   0, -11,  -7,  -4,
    -10,  -3, -10,  18, -24,   3, -14,  -7,  -4, -10,
     16,  -1,  27,   4,  27, -17, -12, -30,   0, -35,
      9,   3,  12,  36,  35,  30,   2,  13,  -2,  11,
    }, {
    -66,  -8, -23, -11,  14,   5,  17,  16,  19,   2,
      3,  -5, -18, -17,  10,   0,  -1,  23,  -6,  20,
    -15,  18, -14,  22,   5,  10,  44,  23,   2,  26,
     -9,   3,  -4, -14, -12, -29,  -7, -16,  -7, -18,
    }, {
    -44, -20, -34, -29,  10, -13,   4,   0,   4,  -9,
      5, -19, -10, -24,  11,  17,   8,  20,   5,  19,
     -9,  14, -12,   9,   6,   0,  30,   9,   0,  19,
      2,   7,   2,  10,   5, -20, -21,  -1, -17,  -9,
    }, {
    -77, -16,  -9,  -9,   6,  11,  21,  37,  10,  10,
     -4,  -5, -13,   3,  -7,   0, -13,  11, -17,   6,
    -25,   1, -15,   9,  -7,   9,  32,  19,   0,  18,
     -2, -22,   3, -15,  12,  -5,   4,  -2,  17,  -5,
    }, {
    -55, -28, -21, -27,   2,  -7,   8,  20,  -4,  -1,
     -1, -18,  -5,  -4,  -5,  16,  -2,   8,  -5,   5,
    -19,  -2, -14,  -3,  -6,   0,  18,   4,  -2,  11,
      8, -18,  11,  10,  29,   3, -10,  13,   8,   3,
    }, {
    -58,  -9, -16,   1,  -2,   2,   0,  19,  10,  13,
     17,  21,   3,   3,  19, -12,   2,   0, -10,   1,
     -5,  12,   0,  15,  26,   5,  34,  16,  11,   7,
     -4,  25,   2, -14,   3, -29, -13, -25, -20, -20,
    }, {
    -36, -21, -28, -16,  -6, -16, -12,   2,  -4,   2,
     20,   7,  11,  -4,  20,   4,  12,  -2,   1,   0,
      0,   8,   2,   2,  27,  -4,  21,   2,   9,   0,
      6,  29,   9,  10,  21, -21, -28, -10, -29, -11,
    }, {
    -69, -17,  -3,   3, -10,   8,   3,  40,   1,  21,
     10,  21,   8,  23,   1, -13,  -8, -11, -21, -11,
    -15,  -4,   0,   2,  13,   5,  23,  12,   7,   0,
      1,   0,  10, -14,  28,  -5,  -1, -11,   5,  -7,
    }, {
    -47, -30, -15, -14, -14,  -9,  -9,  23, -13,  10,
     12,   7,  16,  15,   3,   3,   1, -14,  -9, -12,
     -9,  -8,   0, -10,  14,  -4,   9,  -2,   5,  -8,
     13,   3,  18,  10,  45,   3, -16,   4,  -4,   0,
    }, {
    -79,  11, -15,   4,  18,  23,  20,   5,  30,   7,
     -7,  -2, -21, -21,  -8,  -3, -10,  28,   4,  31,
      6,  25,  -3,  37,   4,  -7,  20,   0,   4,   4,
    -11,   7,  -6,   8, -27, -22, -14, -12,  -5, -16,
    }, {
    -57,   0, -27, -13,  14,   5,   7, -11,  15,  -4,
     -5, -16, -13, -29,  -6,  13,   0,  25,  16,  31,
     12,  22,  -2,  23,   6, -16,   7, -14,   2,  -3,
      0,  12,   0,  33,  -9, -13, -28,   3, -14,  -7,
    }, {
    -90,   3,  -2,   6,  10,  29,  24,  26,  21,  15,
    -15,  -2, -16,  -1, -25,  -4, -21,  16,  -6,  18,
     -3,   8,  -5,  24,  -8,  -7,   9,  -4,   1,  -3,
     -5, -18,   1,   7,  -2,   1,  -2,   1,  19,  -3,
    }, {
    -67,  -8, -14, -11,   7,  11,  11,   9,   7,   3,
    -13, -16,  -8,  -9, -24,  12, -10,  13,   5,  17,
      2,   4,  -3,  10,  -6, -17,  -4, -19,   0, -11,
      6, -13,   9,  33,  14,  10, -16,  17,  10,   4,
    }, {
    -71,  10,  -9,  17,   1,  20,   3,   8,  21,  18,
      6,  24,   0,  -1,   0, -16,  -6,   5,   0,  13,
     17,  19,  11,  29,  25, -11,  11,  -6,  13, -15,
     -7,  29,   0,   8, -11, -22, -20, -21, -17, -18,
    }, {
    -49,  -2, -21,   0,  -1,   2,  -9,  -8,   6,   6,
      8,  10,   8,  -9,   2,   0,   4,   2,  13,  12,
     23,  15,  12,  16,  26, -21,  -2, -21,  11, -23,
      4,  33,   7,  33,   6, -13, -34,  -5, -27, -10,
    }, {
    -82,   1,   4,  19,  -6,  27,   6,  29,  12,  26,
     -1,  24,   5,  18, -17, -17, -17,  -6, -10,   0,
      7,   2,   9,  16,  12, -11,   0, -11,   9, -23,
      0,   3,   8,   8,  13,   1,  -8,  -7,   7,  -6,
    }, {
    -60, -10,  -7,   1,  -9,   8,  -6,  13,  -2,  15,
      1,  10,  13,  11, -15,   0,  -6,  -9,   1,   0,
     13,  -1,  11,   3,  13, -21, -13, -26,   7, -31,
     10,   7,  16,  33,  31,  10, -22,   8,  -1,   2,
    }, {
     -3,   7,  -5,  -5,   8,  -2,  17,  -9,  18, -24,
     -2, -19, -10,  -4,  28,  17,   5,  28,  -2,   7,
     -4,  15,   7,   8,   6,  23,  13,  21, -14,  20,
    -17, -18, -11, -33, -30, -11,  23, -13,  -5,  -9,
    }, {
     18,  -4, -17, -23,   4, -20,   4, -26,   3, -36,
      0, -32,  -2, -12,  29,  34,  16,  24,  10,   6,
      0,  12,   8,  -4,   8,  13,   0,   6, -16,  12,
     -5, -13,  -3,  -7, -13,  -3,   8,   2, -14,   0,
    }, {
    -13,   0,   8,  -3,   0,   4,  21,  11,   9, -16,
    -10, -18,  -5,  16,  10,  16,  -5,  15, -13,  -5,
    -15,  -1,   6,  -4,  -6,  23,   2,  16, -17,  12,
    -10, -44,  -3, -33,  -6,  12,  34,   1,  20,   3,
    }, {
      8, -12,  -3, -21,  -3, -14,   8,  -5,  -4, -28,
     -7, -32,   2,   8,  12,  34,   4,  12,  -1,  -6,
     -9,  -4,   7, -17,  -4,  13, -11,   1, -19,   4,
      0, -39,   4,  -7,  11,  21,  20,  16,  10,  11,
    }, {
      4,   6,   0,   7,  -8,  -4,   0,  -6,   9, -13,
     11,   7,  11,  15,  37,   4,   9,   5,  -5, -11,
      5,   9,  22,   1,  27,  18,   4,  14,  -5,   0,
    -12,   3,  -4, -32, -14, -12,  17, -22, -17, -11,
    }, {
     26,  -6, -11, -10, -12, -23, -12, -23,  -5, -24,
     13,  -5,  19,   8,  38,  21,  20,   2,   6, -12,
     11,   5,  23, -11,  29,   9,  -9,   0,  -7,  -6,
     -1,   7,   2,  -7,   3,  -3,   2,  -6, -27,  -3,
    }, {
     -6,  -2,  14,   9, -16,   1,   3,  14,   0,  -5,
      3,   8,  16,  36,  19,   3,  -1,  -6, -17, -24,
     -4,  -7,  21, -11,  14,  18,  -7,   9,  -9,  -7,
     -6, -22,   3, -33,  10,  11,  28,  -7,   7,   0,
    }, {
     16, -14,   2,  -8, -20, -17,  -9,  -2, -14, -16,
      6,  -5,  24,  28,  21,  20,   8,  -9,  -4, -25,
      1, -11,  22, -24,  15,   8, -21,  -5, -11, -14,
      5, -18,  11,  -7,  27,  20,  14,   7,  -1,   9,
    }, {
    -16,  27,   2,  10,  13,  16,  20, -20,  29, -20,
    -14, -16, -13,  -8,   9,  13,  -2,  33,   9,  19,
     17,  23,  17,  22,   6,   6,  -9,  -2, -12,  -2,
    -20, -13, -13, -10, -45,  -4,  16,  -8,  -2,  -7,
    }, {
      5,  15,  -9,  -7,   9,  -2,   8, -37,  14, -31,
    -11, -29,  -5, -16,  11,  30,   7,  29,  21,  18,
     23,  19,  18,   9,   7,  -3, -23, -17, -14,  -9,
     -8,  -9,  -6,  15, -27,   4,   2,   6, -12,   1,
    }, {
    -26,  19,  15,  12,   5,  22,  24,   0,  21, -12,
    -21, -15,  -8,  11,  -7,  12, -14,  20,  -2,   6,
      7,   6,  16,   9,  -6,   5, -21,  -7, -15, -10,
    -13, -39,  -5, -10, -20,  19,  28,   5,  22,   5,
    }, {
     -4,   6,   3,  -5,   1,   4,  11, -16,   6, -23,
    -19, -29,   0,   3,  -6,  30,  -3,  17,  10,   5,
     13,   2,  17,  -3,  -5,  -3, -35, -21, -17, -17,
     -2, -35,   2,  15,  -3,  28,  13,  21,  13,  13,
    }, {
     -8,  25,   8,  23,  -3,  13,   3, -17,  20,  -8,
      0,  10,   8,  11,  18,   0,   1,  10,   5,   0,
     28,  17,  32,  15,  26,   1, -19,  -9,  -3, -21,
    -15,   7,  -6,  -9, -29,  -5,  10, -17, -15,  -9,
    }, {
     13,  13,  -3,   5,  -7,  -4,  -9, -34,   5, -20,
      2,  -3,  16,   3,  20,  17,  11,   7,  17,   0,
     34,  13,  33,   2,  28,  -8, -32, -24,  -5, -29,
     -3,  12,   0,  15, -11,   3,  -3,  -2, -24,  -1,
    }, {
    -18,  17,  21,  25, -11,  19,   6,   3,  11,   0,
     -7,  11,  13,  31,   1,   0,  -9,  -1,  -5, -12,
     18,   0,  31,   2,  13,   1, -30, -14,  -7, -29,
     -9, -18,   1, -10,  -4,  18,  22,  -3,  10,   2,
    }, {
      3,   5,   9,   7, -15,   1,  -5, -13,  -2, -12,
     -5,  -2,  21,  23,   2,  16,   0,  -5,   6, -13,
     23,  -3,  32, -10,  15,  -8, -44, -28,  -9, -37,
      2, -13,   9,  15,  12,  27,   7,  12,   0,  11,
    }, {
    -44,   6, -30,  -8,   9,  10,  11,  14,  23,  -5,
      8,  -4,  14, -12,  37,  14,  12,  26,   4,  16,
     -8,  16,  -9,   7,  -6,  19,  12,  25,  -5,  24,
    -15, -13,  -8, -36, -34, -31,  -1, -18,  -4, -18,
    }, {
    -22,  -5, -42, -26,   6,  -8,  -1,  -2,   9, -17,
     10, -18,  21, -19,  39,  31,  23,  23,  16,  15,
     -2,  12,  -7,  -6,  -5,   9,  -1,  10,  -7,  16,
     -4,  -9,   0, -10, -17, -22, -16,  -2, -14,  -9,
    }, {
    -55,  -1, -17,  -6,   1,  16,  15,  35,  15,   2,
      0,  -4,  19,   8,  20,  13,   1,  14,  -7,   3,
    -18,   0, -10,  -5, -19,  19,   0,  21,  -8,  16,
     -9, -39,   0, -36, -10,  -7,   9,  -4,  20,  -5,
    }, {
    -33, -13, -29, -24,  -1,  -1,   2,  18,   0,  -9,
      3, -17,  27,   0,  21,  30,  12,  11,   5,   2,
    -12,  -4,  -9, -19, -18,   9, -13,   6, -11,   8,
      2, -35,   8, -10,   7,   1,  -4,  11,  10,   2,
    }, {
    -36,   5, -24,   4,  -7,   7,  -6,  17,  14,   5,
     22,  22,  35,   8,  46,   1,  17,   3,   0,  -2,
      2,  10,   5,   0,  14,  15,   2,  18,   2,   4,
    -11,   7,  -1, -36, -18, -32,  -7, -27, -17, -20,
    }, {
    -14,  -7, -36, -13, -10, -10, -18,   0,   0,  -5,
     25,   8,  43,   0,  48,  18,  27,   0,  12,  -3,
      7,   6,   7, -13,  15,   5, -11,   3,   0,  -2,
      0,  12,   6, -10,   0, -23, -22, -11, -26, -12,
    }, {
    -47,  -3, -11,   6, -15,  13,  -2,  38,   6,  13,
     15,  22,  40,  28,  28,   0,   5,  -8, -10, -15,
     -7,  -7,   4, -13,   1,  14,  -9,  14,   0,  -2,
     -4, -18,   7, -36,   6,  -8,   3, -13,   7,  -8,
    }, {
    -25, -15, -22, -11, -18,  -4, -15,  22,  -8,   2,
     17,   9,  48,  20,  30,  17,  16, -11,   1, -16,
     -2, -10,   5, -26,   2,   4, -22,   0,  -2, -10,
      6, -13,  14, -10,  23,   0, -10,   2,  -1,   0,
    }, {
    -57,  26, -22,   7,  14,  28,  14,   3,  35,   0,
     -3,  -1,  11, -16,  18,  10,   4,  31,  15,  28,
     14,  23,   1,  21,  -7,   2, -11,   1,  -3,   1,
    -18,  -9, -10, -13, -49, -24,  -8, -14,  -2, -16,
    }, {
    -35,  14, -34, -10,  10,  10,   1, -12,  20, -12,
      0, -15,  18, -24,  20,  27,  14,  28,  27,  27,
     20,  19,   2,   8,  -5,  -7, -25, -13,  -5,  -5,
     -6,  -5,  -2,  12, -31, -15, -23,   1, -12,  -8,
    }, {
    -68,  18,  -9,   9,   6,  35,  18,  25,  26,   7,
    -10,  -1,  16,   3,   1,   9,  -6,  19,   4,  15,
      4,   6,   0,   8, -20,   2, -23,  -2,  -7,  -5,
    -12, -35,  -1, -13, -24,   0,   3,   0,  22,  -4,
    }, {
    -46,   6, -21,  -8,   2,  16,   5,   8,  11,  -4,
     -8, -15,  24,  -4,   2,  26,   3,  16,  16,  14,
      9,   2,   1,  -4, -19,  -7, -36, -17,  -9, -13,
      0, -31,   5,  12,  -7,   8, -11,  15,  13,   4,
    }, {
    -49,  24, -16,  20,  -2,  26,  -2,   7,  25,  10,
     11,  25,  32,   3,  27,  -2,   8,   8,  11,   9,
     24,  17,  16,  14,  13,  -2, -20,  -5,   4, -17,
    -14,  12,  -3, -13, -33, -25, -14, -23, -15, -19,
    }, {
    -27,  12, -28,   2,  -6,   7, -15,  -9,  11,  -1,
     13,  11,  40,  -4,  29,  14,  19,   5,  23,   8,
     30,  13,  17,   0,  14, -12, -34, -20,   2, -25,
     -2,  16,   4,  12, -15, -16, -29,  -7, -24, -10,
    }, {
    -60,  16,  -3,  22, -10,  32,   0,  28,  17,  18,
      3,  25,  37,  23,  10,  -3,  -2,  -3,   0,  -3,
     14,   0,  14,   1,   0,  -2, -32,  -9,   1, -25,
     -7, -13,   5, -13,  -8,  -1,  -2,  -8,  10,  -6,
    }, {
    -38,   4, -15,   4, -14,  13, -12,  11,   2,   6,
      6,  11,  45,  16,  11,  13,   7,  -6,  12,  -4,
     20,  -3,  16, -12,   1, -12, -46, -24,   0, -33,
      3,  -9,  12,  12,   8,   7, -17,   6,   0,   2
    }
};

static const int8_t etable2[128][40]={
    {
     73, -32, -60, -15, -26,  59,   2, -33,  30, -10,
     -3, -17,   8,  30,  -1, -26,  -4, -22,  10,  16,
    -36,  -5, -11,  56,  37,   6, -10,  -5, -13,  -3,
      6,  -5,  11,   4, -19,  -5, -16,  41,  24,  13,
    }, {
      4, -11, -37,  23,  -5,  46,  -2, -29,  -5, -39,
    -21,  -9,   0,  49,  12,  -9, -16, -26,  22,  15,
    -45, -20,  -5,  40,  22,  17, -26,  31, -14,   2,
    -14,  10,  30,  20, -27,  -9, -39,  39,  18,   5,
    }, {
     34, -25, -48, -28, -11,  34,  -2, -41,   9,  -7,
    -17,  21,  20,  24, -17, -33,   0, -24,  10,  42,
      3,  -5,  10,  42,  11,   8,  -3,   3,  16,   9,
     22,  -2,   0, -33, -10,  18,   7,  58,  10,  28,
    }, {
    -34,  -4, -25,  10,   9,  21,  -7, -36, -26, -36,
    -35,  28,  12,  42,  -3, -16, -12, -28,  21,  42,
     -5, -21,  16,  26,  -4,  19, -19,  39,  15,  15,
      1,  13,  19, -17, -17,  14, -15,  55,   4,  19,
    }, {
     28, -20, -51, -14,  -6,   7,   0, -26,  27,  -4,
     18, -40,  -6,  16,  -1, -15,   0, -55,  -5, -16,
    -19,  14,  -3,  49,  14,   1, -22, -30, -12,   0,
     24,  15,   9, -17, -45, -29,   4,  28,  51,  35,
    }, {
    -40,   0, -28,  24,  14,  -5,  -4, -21,  -7, -33,
      0, -32, -15,  35,  12,   1, -11, -58,   5, -16,
    -28,   0,   1,  33,   0,  11, -39,   5, -14,   6,
      3,  31,  28,  -1, -53, -33, -19,  25,  46,  26,
    }, {
    -11, -14, -39, -27,   9, -17,  -4, -33,   6,   0,
      4,  -1,   5,  10, -17, -22,   5, -57,  -5,   9,
     20,  13,  18,  35, -11,   3, -16, -22,  17,  13,
     40,  19,  -1, -55, -35,  -5,  27,  44,  37,  49,
    }, {
    -80,   6, -16,  11,  30, -30,  -9, -28, -28, -29,
    -13,   6,  -2,  28,  -3,  -5,  -7, -60,   5,   9,
     11,  -1,  24,  19, -27,  13, -32,  13,  15,  19,
     19,  35,  17, -39, -43,  -9,   4,  42,  32,  41,
    }, {
     78, -21, -43,   4, -38,  17,  17,  -5,  55,  24,
    -15, -36,  14,   4,  24, -24,  12,   5,  17,  31,
    -54,  -5,  -2,  27,  43, -12,   2,   9,  -9, -15,
     22,  -3,  28,  21, -20,   3,  20,  28,   9,  -5,
    }, {
      9,  -1, -20,  43, -17,   3,  12,   0,  20,  -4,
    -33, -29,   6,  22,  38,  -7,   0,   1,  29,  30,
    -63, -21,   3,  11,  27,  -1, -14,  45, -10,  -9,
      1,  12,  47,  37, -28,   0,  -2,  26,   4, -13,
    }, {
     39, -14, -30,  -8, -22,  -8,  12, -12,  34,  27,
    -29,   2,  26,  -2,   8, -31,  16,   3,  17,  57,
    -14,  -6,  19,  13,  16, -10,   8,  17,  20,  -2,
     38,   0,  17, -16, -11,  27,  44,  45,  -4,   8,
    }, {
    -29,   5,  -7,  30,  -1, -21,   7,  -7,   0,   0,
    -47,   9,  18,  15,  22, -14,   4,   0,  28,  57,
    -23, -21,  25,  -2,   1,   0,  -7,  53,  19,   3,
     17,  15,  36,   0, -19,  24,  21,  43,  -9,   0,
    }, {
     33, -10, -34,   5, -17, -35,  15,   1,  53,  30,
      6, -59,   0, -10,  24, -13,  17, -27,   1,  -1,
    -37,  13,   4,  20,  20, -18, -10, -16,  -8, -11,
     39,  18,  26,   0, -46, -20,  41,  15,  37,  15,
    }, {
    -35,  10, -11,  44,   3, -48,  10,   6,  17,   2,
    -11, -51,  -8,   8,  38,   3,   4, -31,  12,  -2,
    -46,  -1,  10,   4,   5,  -7, -26,  19, -10,  -5,
     18,  34,  45,  15, -54, -24,  18,  13,  31,   7,
    }, {
     -5,  -3, -21,  -7,  -2, -60,  10,  -5,  32,  34,
     -7, -20,  11, -16,   8, -20,  21, -29,   1,  24,
      2,  13,  27,   6,  -5, -15,  -3,  -8,  21,   1,
     55,  21,  15, -38, -37,   3,  65,  32,  23,  30,
    }, {
    -74,  17,   0,  31,  18, -73,   5,   0,  -3,   5,
    -25, -12,   3,   1,  22,  -3,   9, -33,  12,  24,
     -6,  -2,  33,  -9, -21,  -5, -20,  27,  19,   7,
     34,  37,  34, -22, -44,   0,  41,  29,  17,  21,
    }, {
     76, -35, -31, -28, -49,  43, -40,   0,  29, -14,
      8,   5,  10,  18, -26, -46,   0,   7,   6,   3,
    -25,  -7,  -2,  40,  28,  14,  18,  -3, -27, -28,
     -8, -45, -13,  34, -13, -27, -15,  31,  12,   3,
    }, {
      7, -15,  -9,   9, -28,  29, -45,   5,  -6, -43,
     -9,  12,   2,  36, -12, -30, -11,   3,  17,   3,
    -34, -22,   3,  24,  12,  24,   2,  32, -28, -22,
    -29, -29,   5,  50, -21, -31, -38,  29,   7,  -5,
    }, {
     36, -29, -19, -41, -34,  18, -45,  -6,   8, -10,
     -5,  43,  23,  11, -42, -53,   5,   5,   6,  30,
     14,  -8,  20,  26,   1,  16,  25,   4,   3, -15,
      7, -41, -23,  -3,  -4,  -3,   8,  48,  -1,  17,
    }, {
    -32,  -8,   3,  -2, -13,   4, -50,  -1, -27, -39,
    -23,  51,  15,  30, -27, -37,  -7,   1,  17,  29,
      5, -23,  25,  10, -14,  26,   8,  41,   1,  -9,
    -13, -26,  -5,  12, -12,  -7, -14,  45,  -6,   9,
    }, {
     31, -24, -23, -27, -29,  -9, -43,   8,  26,  -7,
     30, -17,  -4,   3, -26, -35,   5, -24, -10, -28,
     -9,  12,   5,  33,   5,   8,   5, -29, -26, -24,
      9, -23, -14,  12, -39, -52,   5,  18,  39,  24,
    }, {
    -37,  -3,   0,  10,  -7, -22, -48,  12,  -8, -36,
     12,  -9, -12,  22, -12, -19,  -6, -28,   0, -29,
    -18,  -3,  11,  17, -10,  18, -10,   7, -27, -18,
    -11,  -7,   3,  28, -47, -55, -18,  15,  34,  16,
    }, {
     -8, -17, -10, -40, -13, -34, -47,   0,   5,  -4,
     16,  21,   8,  -2, -42, -43,  10, -26, -10,  -2,
     31,  11,  27,  19, -21,  10,  12, -20,   3, -11,
     25, -20, -25, -25, -29, -28,  28,  34,  25,  38,
    }, {
    -77,   2,  11,  -1,   7, -47, -52,   5, -29, -33,
     -1,  28,   0,  15, -28, -26,  -2, -30,   0,  -2,
     22,  -4,  33,   3, -36,  21,  -3,  15,   2,  -5,
      4,  -4,  -6,  -9, -37, -31,   5,  32,  20,  30,
    }, {
     81, -25, -14,  -8, -61,   0, -25,  28,  54,  20,
     -3, -14,  17,  -8,   0, -44,  16,  35,  13,  18,
    -43,  -7,   6,  11,  33,  -4,  30,  11, -22, -40,
      6, -43,   3,  50, -14, -18,  22,  18,  -1, -16,
    }, {
     12,  -4,   8,  29, -39, -12, -30,  33,  19,  -8,
    -21,  -6,   8,   9,  13, -28,   4,  31,  24,  18,
    -52, -23,  12,  -4,  18,   5,  14,  47, -24, -34,
    -14, -27,  22,  66, -22, -22,  -1,  16,  -6, -24,
    }, {
     41, -18,  -2, -21, -45, -24, -30,  21,  33,  24,
    -17,  24,  29, -15, -16, -51,  21,  33,  13,  45,
     -3,  -8,  28,  -2,   7,  -2,  37,  19,   7, -27,
     22, -39,  -7,  12,  -5,   5,  45,  35, -15,  -1,
    }, {
    -27,   1,  20,  17, -24, -38, -35,  26,  -1,  -4,
    -35,  32,  21,   3,  -2, -35,   8,  29,  24,  44,
    -12, -24,  34, -18,  -8,   7,  21,  55,   5, -21,
      2, -23,  11,  28, -13,   1,  22,  33, -21, -10,
    }, {
     36, -13,  -5,  -7, -40, -51, -28,  36,  52,  27,
     18, -36,   2, -22,   0, -33,  21,   2,  -3, -13,
    -26,  11,  14,   4,  10, -10,  18, -14, -22, -36,
     24, -21,   1,  28, -40, -42,  42,   5,  25,   5,
    }, {
    -32,   6,  17,  31, -19, -65, -33,  41,  16,  -1,
      0, -29,  -6,  -4,  13, -17,   9,  -1,   8, -14,
    -35,  -3,  19, -11,  -4,   0,   1,  21, -23, -30,
      3,  -5,  20,  44, -48, -46,  19,   3,  20,  -3,
    }, {
     -3,  -7,   6, -20, -25, -77, -32,  29,  31,  30,
      4,   2,  14, -29, -16, -40,  26,   0,  -3,  12,
     13,  10,  36,  -9, -15,  -8,  24,  -6,   7, -22,
     40, -17,  -8,  -9, -31, -18,  66,  22,  11,  19,
    }, {
    -72,  13,  29,  18,  -4, -90, -37,  34,  -4,   1,
    -13,   9,   6, -11,  -2, -24,  13,  -3,   7,  11,
      4,  -4,  42, -25, -31,   1,   8,  29,   6, -17,
     19,  -2,  10,   6, -38, -22,  42,  19,   6,  11,
    }, {
    116, -20, -68, -30, -28,  83,  28, -18,  32, -22,
    -13, -21,   5,  28,   5,  -7, -24,  -8, -22,  17,
    -23,  30, -25,  45,  15,  -9, -11, -18,  22, -10,
      4,  -2,  19, -12,  23,   3, -43,   2,  12,  -4,
    }, {
     47,   0, -45,   7,  -7,  69,  23, -13,  -2, -51,
    -32, -14,  -3,  47,  19,   8, -37, -11, -10,  16,
    -32,  15, -19,  29,   0,   1, -28,  18,  20,  -4,
    -16,  13,  38,   3,  15,   0, -66,   0,   7, -13,
    }, {
     77, -13, -56, -43, -13,  57,  23, -26,  11, -19,
    -27,  16,  17,  22, -10, -15, -19, -10, -22,  43,
     16,  30,  -2,  31, -11,  -6,  -5,  -9,  52,   2,
     20,   0,   8, -50,  33,  27, -19,  19,  -1,   9,
    }, {
      8,   6, -33,  -4,   7,  44,  18, -21, -23, -48,
    -46,  24,   9,  40,   3,   1, -32, -13, -11,  43,
      7,  14,   3,  15, -26,   3, -21,  26,  50,   8,
      0,  16,  27, -34,  25,  23, -43,  17,  -6,   1,
    }, {
     71,  -9, -59, -29,  -8,  30,  26, -11,  30, -16,
      8, -44,  -9,  14,   5,   2, -19, -40, -38, -15,
     -7,  50, -17,  38,  -7, -14, -24, -43,  22,  -6,
     22,  19,  17, -34,  -2, -20, -23, -10,  39,  16,
    }, {
      2,  11, -36,   9,  13,  17,  21,  -6,  -5, -45,
    -10, -36, -18,  33,  19,  19, -31, -44, -27, -15,
    -16,  34, -11,  22, -22,  -4, -40,  -7,  21,   0,
      1,  35,  36, -18, -10, -24, -46, -12,  34,   8,
    }, {
     32,  -2, -47, -42,   7,   5,  21, -18,   9, -12,
     -5,  -5,   2,   8, -10,  -4, -14, -42, -38,  10,
     33,  49,   5,  24, -33, -12, -17, -35,  52,   6,
     38,  22,   7, -72,   7,   3,   0,   6,  25,  30,
    }, {
    -36,  18, -24,  -3,  28,  -7,  16, -13, -26, -41,
    -24,   1,  -5,  26,   3,  12, -27, -46, -27,  10,
     24,  34,  10,   8, -49,  -2, -34,   0,  51,  12,
     17,  38,  25, -56,   0,   0, -22,   3,  20,  22,
    }, {
    121,  -9, -50, -10, -40,  40,  43,   9,  58,  12,
    -25, -41,  11,   2,  31,  -5,  -8,  19, -15,  32,
    -41,  30, -16,  16,  20, -28,   0,  -3,  26, -22,
     19,   0,  36,   4,  22,  12,  -6,  -9,  -1, -24,
    }, {
     52,  10, -27,  27, -18,  26,  38,  14,  23, -16,
    -44, -33,   3,  20,  45,  10, -20,  15,  -3,  31,
    -50,  14, -10,   0,   5, -17, -15,  32,  24, -16,
     -1,  15,  55,  20,  14,   8, -29, -12,  -7, -32,
    }, {
     82,  -3, -38, -23, -24,  15,  38,   2,  37,  15,
    -39,  -2,  23,  -4,  15, -12,  -3,  17, -15,  58,
     -1,  29,   6,   2,  -5, -26,   7,   4,  56,  -9,
     35,   3,  25, -33,  32,  36,  17,   7, -15,  -9,
    }, {
     13,  17, -15,  15,  -3,   1,  33,   7,   1, -12,
    -58,   5,  15,  13,  29,   3, -16,  13,  -4,  57,
    -10,  13,  11, -13, -21, -15,  -9,  40,  55,  -3,
     14,  19,  44, -17,  24,  32,  -5,   4, -21, -18,
    }, {
     76,   1, -41,  -9, -19, -12,  41,  17,  55,  18,
     -3, -63,  -3, -12,  30,   5,  -3, -12, -31,   0,
    -24,  49,  -8,   9,  -1, -33, -12, -29,  27, -18,
     37,  21,  34, -17,  -3, -11,  14, -23,  25,  -2,
    }, {
      7,  22, -18,  29,   1, -25,  36,  21,  20,  -9,
    -22, -56, -11,   6,  45,  21, -15, -16, -20,  -1,
    -33,  34,  -2,  -6, -17, -23, -28,   6,  25, -12,
     16,  37,  53,  -1, -11, -15,  -8, -25,  20, -11,
    }, {
     37,   8, -29, -22,  -4, -37,  36,   9,  34,  22,
    -17, -24,   8, -18,  15,  -2,   1, -14, -31,  25,
     15,  48,  13,  -4, -28, -31,  -5, -21,  57,  -4,
     53,  24,  23, -55,   6,  12,  37,  -6,  11,  11,
    }, {
    -31,  28,  -6,  16,  16, -50,  31,  14,   0,  -6,
    -36, -17,   0,   0,  29,  14, -11, -18, -20,  25,
      6,  33,  19, -20, -43, -21, -21,  14,  55,   0,
     32,  40,  42, -39,  -1,   8,  14,  -8,   6,   3,
    }, {
    119, -24, -39, -44, -51,  66, -14,  15,  31, -26,
     -1,   0,   7,  16, -19, -28, -19,  22, -26,   4,
    -13,  28, -16,  29,   5,  -1,  16, -16,   8, -35,
    -10, -42,  -4,  17,  29, -19, -42,  -7,   0, -15,
    }, {
     50,  -3, -16,  -5, -30,  53, -19,  20,  -3, -55,
    -19,   8,   0,  34,  -5, -11, -32,  18, -15,   4,
    -22,  13, -10,  13,  -9,   8,   0,  19,   7, -29,
    -31, -26,  13,  33,  21, -22, -65,  -9,  -4, -23,
    }, {
     79, -17, -27, -56, -36,  41, -19,   8,  10, -22,
    -15,  39,  20,   9, -35, -35, -15,  20, -26,  31,
     26,  27,   6,  15, -20,   0,  23,  -8,  38, -22,
      5, -38, -15, -20,  39,   4, -18,   9, -13,  -1,
    }, {
     10,   3,  -4, -18, -15,  27, -24,  13, -24, -51,
    -34,  47,  12,  28, -21, -19, -27,  16, -15,  30,
     17,  12,  12,   0, -36,  10,   7,  27,  37, -16,
    -15, -22,   3,  -4,  31,   1, -42,   7, -18,  -9,
    }, {
     74, -12, -30, -42, -30,  14, -16,  23,  29, -19,
     20, -21,  -7,   1, -19, -17, -14, -10, -43, -27,
      3,  48,  -8,  22, -16,  -7,   4, -42,   9, -31,
      6, -20,  -6,  -4,   3, -43, -22, -20,  28,   5,
    }, {
      5,   7,  -7,  -4,  -9,   0, -21,  28,  -6, -48,
      2, -14, -15,  20,  -5,   0, -27, -14, -32, -28,
     -5,  32,  -2,   6, -32,   3, -12,  -5,   8, -25,
    -14,  -4,  12,  11,  -4, -47, -45, -22,  22,  -2,
    }, {
     34,  -6, -18, -55, -15, -11, -21,  16,   8, -16,
      6,  16,   5,  -4, -35, -24, -10, -12, -43,  -1,
     43,  47,  14,   8, -43,  -5,  10, -34,  39, -18,
     22, -16, -17, -42,  13, -19,   1,  -3,  14,  20,
    }, {
    -34,  14,   4, -17,   5, -24, -26,  20, -27, -45,
    -12,  24,  -2,  13, -21,  -8, -22, -16, -32,  -2,
     34,  31,  20,  -7, -58,   5,  -5,   2,  38, -12,
      2,  -1,   1, -26,   5, -23, -21,  -6,   8,  11,
    }, {
    124, -13, -21, -23, -62,  23,   0,  43,  57,   8,
    -13, -18,  14, -10,   6, -26,  -3,  49, -19,  19,
    -31,  27,  -7,   0,  11, -20,  29,  -1,  12, -47,
      4, -39,  11,  34,  28,  -9,  -5, -19, -13, -34,
    }, {
     55,   6,   1,  14, -41,  10,  -4,  48,  22, -20,
    -31, -10,   5,   7,  20,  -9, -16,  45,  -8,  19,
    -40,  12,  -1, -15,  -4, -10,  12,  34,  11, -41,
    -16, -24,  30,  49,  20, -13, -28, -22, -18, -43,
    }, {
     84,  -6,  -9, -36, -47,  -1,  -4,  36,  36,  12,
    -27,  20,  26, -17,  -9, -33,   1,  47, -19,  46,
      9,  27,  15, -13, -15, -18,  35,   6,  42, -33,
     20, -36,   1,  -4,  38,  14,  18,  -2, -27, -20,
    }, {
     15,  13,  13,   1, -26, -14,  -9,  41,   1, -16,
    -46,  27,  18,   1,   4, -16, -11,  43,  -8,  45,
      0,  11,  21, -29, -30,  -8,  19,  42,  41, -28,
      0, -20,  20,  11,  30,  10,  -4,  -5, -32, -28,
    }, {
     79,  -2, -12, -22, -42, -28,  -1,  51,  54,  15,
      8, -41,   0, -24,   6, -15,   1,  17, -36, -12,
    -14,  47,   0,  -6, -11, -26,  16, -27,  13, -43,
     22, -18,  10,  12,   2, -34,  15, -33,  13, -13,
    }, {
     10,  18,  10,  15, -21, -41,  -6,  56,  19, -13,
     -9, -33,  -9,  -6,  20,   1, -11,  13, -24, -13,
    -23,  32,   6, -22, -26, -15,   0,   8,  12, -37,
      1,  -2,  28,  27,  -5, -37,  -7, -35,   8, -21,
    }, {
     39,   4,   0, -35, -27, -53,  -6,  44,  33,  18,
     -5,  -2,  11, -31,  -9, -22,   6,  15, -36,  13,
     25,  46,  23, -20, -37, -24,  23, -19,  43, -29,
     38, -14,   0, -26,  12, -10,  38, -16,   0,   0,
    }, {
    -29,  25,  22,   2,  -6, -67, -11,  49,  -1, -10,
    -24,   5,   3, -13,   4,  -5,  -6,  11, -25,  12,
     16,  31,  28, -36, -53, -13,   6,  16,  42, -24,
     17,   1,  18, -10,   4, -13,  15, -18,  -5,  -7,
    }, {
     29, -25, -22,  -2,   6,  67,  11, -49,   1,  10,
     24,  -5,  -3,  13,  -4,   5,   6, -11,  25, -12,
    -16, -31, -28,  36,  53,  13,  -6, -16, -42,  24,
    -17,  -1, -18,  10,  -4,  13, -15,  18,   5,   7,
    }, {
    -39,  -4,   0,  35,  27,  53,   6, -44, -33, -18,
      5,   2, -11,  31,   9,  22,  -6, -15,  36, -13,
    -25, -46, -23,  20,  37,  24, -23,  19, -43,  29,
    -38,  14,   0,  26, -12,  10, -38,  16,   0,   0,
    }, {
    -10, -18, -10, -15,  21,  41,   6, -56, -19,  13,
      9,  33,   9,   6, -20,  -1,  11, -13,  24,  13,
     23, -32,  -6,  22,  26,  15,   0,  -8, -12,  37,
     -1,   2, -28, -27,   5,  37,   7,  35,  -8,  21,
    }, {
    -79,   2,  12,  22,  42,  28,   1, -51, -54, -15,
     -8,  41,   0,  24,  -6,  15,  -1, -17,  36,  12,
     14, -47,   0,   6,  11,  26, -16,  27, -13,  43,
    -22,  18, -10, -12,  -2,  34, -15,  33, -13,  13,
    }, {
    -15, -13, -13,  -1,  26,  14,   9, -41,  -1,  16,
     46, -27, -18,  -1,  -4,  16,  11, -43,   8, -45,
      0, -11, -21,  29,  30,   8, -19, -42, -41,  28,
      0,  20, -20, -11, -30, -10,   4,   5,  32,  28,
    }, {
    -84,   6,   9,  36,  47,   1,   4, -36, -36, -12,
     27, -20, -26,  17,   9,  33,  -1, -47,  19, -46,
     -9, -27, -15,  13,  15,  18, -35,  -6, -42,  33,
    -20,  36,  -1,   4, -38, -14, -18,   2,  27,  20,
    }, {
    -55,  -6,  -1, -14,  41, -10,   4, -48, -22,  20,
     31,  10,  -5,  -7, -20,   9,  16, -45,   8, -19,
     40, -12,   1,  15,   4,  10, -12, -34, -11,  41,
     16,  24, -30, -49, -20,  13,  28,  22,  18,  43,
    }, {
   -124,  13,  21,  23,  62, -23,   0, -43, -57,  -8,
     13,  18, -14,  10,  -6,  26,   3, -49,  19, -19,
     31, -27,   7,   0, -11,  20, -29,   1, -12,  47,
     -4,  39, -11, -34, -28,   9,   5,  19,  13,  34,
    }, {
     34, -14,  -4,  17,  -5,  24,  26, -20,  27,  45,
     12, -24,   2, -13,  21,   8,  22,  16,  32,   2,
    -34, -31, -20,   7,  58,  -5,   5,  -2, -38,  12,
     -2,   1,  -1,  26,  -5,  23,  21,   6,  -8, -11,
    }, {
    -34,   6,  18,  55,  15,  11,  21, -16,  -8,  16,
     -6, -16,  -5,   4,  35,  24,  10,  12,  43,   1,
    -43, -47, -14,  -8,  43,   5, -10,  34, -39,  18,
    -22,  16,  17,  42, -13,  19,  -1,   3, -14, -20,
    }, {
     -5,  -7,   7,   4,   9,   0,  21, -28,   6,  48,
     -2,  14,  15, -20,   5,   0,  27,  14,  32,  28,
      5, -32,   2,  -6,  32,  -3,  12,   5,  -8,  25,
     14,   4, -12, -11,   4,  47,  45,  22, -22,   2,
    }, {
    -74,  12,  30,  42,  30, -14,  16, -23, -29,  19,
    -20,  21,   7,  -1,  19,  17,  14,  10,  43,  27,
     -3, -48,   8, -22,  16,   7,  -4,  42,  -9,  31,
     -6,  20,   6,   4,  -3,  43,  22,  20, -28,  -5,
    }, {
    -10,  -3,   4,  18,  15, -27,  24, -13,  24,  51,
     34, -47, -12, -28,  21,  19,  27, -16,  15, -30,
    -17, -12, -12,   0,  36, -10,  -7, -27, -37,  16,
     15,  22,  -3,   4, -31,  -1,  42,  -7,  18,   9,
    }, {
    -79,  17,  27,  56,  36, -41,  19,  -8, -10,  22,
     15, -39, -20,  -9,  35,  35,  15, -20,  26, -31,
    -26, -27,  -6, -15,  20,   0, -23,   8, -38,  22,
     -5,  38,  15,  20, -39,  -4,  18,  -9,  13,   1,
    }, {
    -50,   3,  16,   5,  30, -53,  19, -20,   3,  55,
     19,  -8,   0, -34,   5,  11,  32, -18,  15,  -4,
     22, -13,  10, -13,   9,  -8,   0, -19,  -7,  29,
     31,  26, -13, -33, -21,  22,  65,   9,   4,  23,
    }, {
   -119,  24,  39,  44,  51, -66,  14, -15, -31,  26,
      1,   0,  -7, -16,  19,  28,  19, -22,  26,  -4,
     13, -28,  16, -29,  -5,   1, -16,  16,  -8,  35,
     10,  42,   4, -17, -29,  19,  42,   7,   0,  15,
    }, {
     31, -28,   6, -16, -16,  50, -31, -14,   0,   6,
     36,  17,   0,   0, -29, -14,  11,  18,  20, -25,
     -6, -33, -19,  20,  43,  21,  21, -14, -55,   0,
    -32, -40, -42,  39,   1,  -8, -14,   8,  -6,  -3,
    }, {
    -37,  -8,  29,  22,   4,  37, -36,  -9, -34, -22,
     17,  24,  -8,  18, -15,   2,  -1,  14,  31, -25,
    -15, -48, -13,   4,  28,  31,   5,  21, -57,   4,
    -53, -24, -23,  55,  -6, -12, -37,   6, -11, -11,
    }, {
     -7, -22,  18, -29,  -1,  25, -36, -21, -20,   9,
     22,  56,  11,  -6, -45, -21,  15,  16,  20,   1,
     33, -34,   2,   6,  17,  23,  28,  -6, -25,  12,
    -16, -37, -53,   1,  11,  15,   8,  25, -20,  11,
    }, {
    -76,  -1,  41,   9,  19,  12, -41, -17, -55, -18,
      3,  63,   3,  12, -30,  -5,   3,  12,  31,   0,
     24, -49,   8,  -9,   1,  33,  12,  29, -27,  18,
    -37, -21, -34,  17,   3,  11, -14,  23, -25,   2,
    }, {
    -13, -17,  15, -15,   3,  -1, -33,  -7,  -1,  12,
     58,  -5, -15, -13, -29,  -3,  16, -13,   4, -57,
     10, -13, -11,  13,  21,  15,   9, -40, -55,   3,
    -14, -19, -44,  17, -24, -32,   5,  -4,  21,  18,
    }, {
    -82,   3,  38,  23,  24, -15, -38,  -2, -37, -15,
     39,   2, -23,   4, -15,  12,   3, -17,  15, -58,
      1, -29,  -6,  -2,   5,  26,  -7,  -4, -56,   9,
    -35,  -3, -25,  33, -32, -36, -17,  -7,  15,   9,
    }, {
    -52, -10,  27, -27,  18, -26, -38, -14, -23,  16,
     44,  33,  -3, -20, -45, -10,  20, -15,   3, -31,
     50, -14,  10,   0,  -5,  17,  15, -32, -24,  16,
      1, -15, -55, -20, -14,  -8,  29,  12,   7,  32,
    }, {
   -121,   9,  50,  10,  40, -40, -43,  -9, -58, -12,
     25,  41, -11,  -2, -31,   5,   8, -19,  15, -32,
     41, -30,  16, -16, -20,  28,   0,   3, -26,  22,
    -19,   0, -36,  -4, -22, -12,   6,   9,   1,  24,
    }, {
     36, -18,  24,   3, -28,   7, -16,  13,  26,  41,
     24,  -1,   5, -26,  -3, -12,  27,  46,  27, -10,
    -24, -34, -10,  -8,  49,   2,  34,   0, -51, -12,
    -17, -38, -25,  56,   0,   0,  22,  -3, -20, -22,
    }, {
    -32,   2,  47,  42,  -7,  -5, -21,  18,  -9,  12,
      5,   5,  -2,  -8,  10,   4,  14,  42,  38, -10,
    -33, -49,  -5, -24,  33,  12,  17,  35, -52,  -6,
    -38, -22,  -7,  72,  -7,  -3,   0,  -6, -25, -30,
    }, {
     -2, -11,  36,  -9, -13, -17, -21,   6,   5,  45,
     10,  36,  18, -33, -19, -19,  31,  44,  27,  15,
     16, -34,  11, -22,  22,   4,  40,   7, -21,   0,
     -1, -35, -36,  18,  10,  24,  46,  12, -34,  -8,
    }, {
    -71,   9,  59,  29,   8, -30, -26,  11, -30,  16,
     -8,  44,   9, -14,  -5,  -2,  19,  40,  38,  15,
      7, -50,  17, -38,   7,  14,  24,  43, -22,   6,
    -22, -19, -17,  34,   2,  20,  23,  10, -39, -16,
    }, {
     -8,  -6,  33,   4,  -7, -44, -18,  21,  23,  48,
     46, -24,  -9, -40,  -3,  -1,  32,  13,  11, -43,
     -7, -14,  -3, -15,  26,  -3,  21, -26, -50,  -8,
      0, -16, -27,  34, -25, -23,  43, -17,   6,  -1,
    }, {
    -77,  13,  56,  43,  13, -57, -23,  26, -11,  19,
     27, -16, -17, -22,  10,  15,  19,  10,  22, -43,
    -16, -30,   2, -31,  11,   6,   5,   9, -52,  -2,
    -20,   0,  -8,  50, -33, -27,  19, -19,   1,  -9,
    }, {
    -47,   0,  45,  -7,   7, -69, -23,  13,   2,  51,
     32,  14,   3, -47, -19,  -8,  37,  11,  10, -16,
     32, -15,  19, -29,   0,  -1,  28, -18, -20,   4,
     16, -13, -38,  -3, -15,   0,  66,   0,  -7,  13,
    }, {
   -116,  20,  68,  30,  28, -83, -28,  18, -32,  22,
     13,  21,  -5, -28,  -5,   7,  24,   8,  22, -17,
     23, -30,  25, -45, -15,   9,  11,  18, -22,  10,
     -4,   2, -19,  12, -23,  -3,  43,  -2, -12,   4,
    }, {
     72, -13, -29, -18,   4,  90,  37, -34,   4,  -1,
     13,  -9,  -6,  11,   2,  24, -13,   3,  -7, -11,
     -4,   4, -42,  25,  31,  -1,  -8, -29,  -6,  17,
    -19,   2, -10,  -6,  38,  22, -42, -19,  -6, -11,
    }, {
      3,   7,  -6,  20,  25,  77,  32, -29, -31, -30,
     -4,  -2, -14,  29,  16,  40, -26,   0,   3, -12,
    -13, -10, -36,   9,  15,   8, -24,   6,  -7,  22,
    -40,  17,   8,   9,  31,  18, -66, -22, -11, -19,
    }, {
     32,  -6, -17, -31,  19,  65,  33, -41, -16,   1,
      0,  29,   6,   4, -13,  17,  -9,   1,  -8,  14,
     35,   3, -19,  11,   4,   0,  -1, -21,  23,  30,
     -3,   5, -20, -44,  48,  46, -19,  -3, -20,   3,
    }, {
    -36,  13,   5,   7,  40,  51,  28, -36, -52, -27,
    -18,  36,  -2,  22,   0,  33, -21,  -2,   3,  13,
     26, -11, -14,  -4, -10,  10, -18,  14,  22,  36,
    -24,  21,  -1, -28,  40,  42, -42,  -5, -25,  -5,
    }, {
     27,  -1, -20, -17,  24,  38,  35, -26,   1,   4,
     35, -32, -21,  -3,   2,  35,  -8, -29, -24, -44,
     12,  24, -34,  18,   8,  -7, -21, -55,  -5,  21,
     -2,  23, -11, -28,  13,  -1, -22, -33,  21,  10,
    }, {
    -41,  18,   2,  21,  45,  24,  30, -21, -33, -24,
     17, -24, -29,  15,  16,  51, -21, -33, -13, -45,
      3,   8, -28,   2,  -7,   2, -37, -19,  -7,  27,
    -22,  39,   7, -12,   5,  -5, -45, -35,  15,   1,
    }, {
    -12,   4,  -8, -29,  39,  12,  30, -33, -19,   8,
     21,   6,  -8,  -9, -13,  28,  -4, -31, -24, -18,
     52,  23, -12,   4, -18,  -5, -14, -47,  24,  34,
     14,  27, -22, -66,  22,  22,   1, -16,   6,  24,
    }, {
    -81,  25,  14,   8,  61,   0,  25, -28, -54, -20,
      3,  14, -17,   8,   0,  44, -16, -35, -13, -18,
     43,   7,  -6, -11, -33,   4, -30, -11,  22,  40,
     -6,  43,  -3, -50,  14,  18, -22, -18,   1,  16,
    }, {
     77,  -2, -11,   1,  -7,  47,  52,  -5,  29,  33,
      1, -28,   0, -15,  28,  26,   2,  30,   0,   2,
    -22,   4, -33,  -3,  36, -21,   3, -15,  -2,   5,
     -4,   4,   6,   9,  37,  31,  -5, -32, -20, -30,
    }, {
      8,  17,  10,  40,  13,  34,  47,   0,  -5,   4,
    -16, -21,  -8,   2,  42,  43, -10,  26,  10,   2,
    -31, -11, -27, -19,  21, -10, -12,  20,  -3,  11,
    -25,  20,  25,  25,  29,  28, -28, -34, -25, -38,
    }, {
     37,   3,   0, -10,   7,  22,  48, -12,   8,  36,
    -12,   9,  12, -22,  12,  19,   6,  28,   0,  29,
     18,   3, -11, -17,  10, -18,  10,  -7,  27,  18,
     11,   7,  -3, -28,  47,  55,  18, -15, -34, -16,
    }, {
    -31,  24,  23,  27,  29,   9,  43,  -8, -26,   7,
    -30,  17,   4,  -3,  26,  35,  -5,  24,  10,  28,
      9, -12,  -5, -33,  -5,  -8,  -5,  29,  26,  24,
     -9,  23,  14, -12,  39,  52,  -5, -18, -39, -24,
    }, {
     32,   8,  -3,   2,  13,  -4,  50,   1,  27,  39,
     23, -51, -15, -30,  27,  37,   7,  -1, -17, -29,
     -5,  23, -25, -10,  14, -26,  -8, -41,  -1,   9,
     13,  26,   5, -12,  12,   7,  14, -45,   6,  -9,
    }, {
    -36,  29,  19,  41,  34, -18,  45,   6,  -8,  10,
      5, -43, -23, -11,  42,  53,  -5,  -5,  -6, -30,
    -14,   8, -20, -26,  -1, -16, -25,  -4,  -3,  15,
     -7,  41,  23,   3,   4,   3,  -8, -48,   1, -17,
    }, {
     -7,  15,   9,  -9,  28, -29,  45,  -5,   6,  43,
      9, -12,  -2, -36,  12,  30,  11,  -3, -17,  -3,
     34,  22,  -3, -24, -12, -24,  -2, -32,  28,  22,
     29,  29,  -5, -50,  21,  31,  38, -29,  -7,   5,
    }, {
    -76,  35,  31,  28,  49, -43,  40,   0, -29,  14,
     -8,  -5, -10, -18,  26,  46,   0,  -7,  -6,  -3,
     25,   7,   2, -40, -28, -14, -18,   3,  27,  28,
      8,  45,  13, -34,  13,  27,  15, -31, -12,  -3,
    }, {
     74, -17,   0, -31, -18,  73,  -5,   0,   3,  -5,
     25,  12,  -3,  -1, -22,   3,  -9,  33, -12, -24,
      6,   2, -33,   9,  21,   5,  20, -27, -19,  -7,
    -34, -37, -34,  22,  44,   0, -41, -29, -17, -21,
    }, {
      5,   3,  21,   7,   2,  60, -10,   5, -32, -34,
      7,  20, -11,  16,  -8,  20, -21,  29,  -1, -24,
     -2, -13, -27,  -6,   5,  15,   3,   8, -21,  -1,
    -55, -21, -15,  38,  37,  -3, -65, -32, -23, -30,
    }, {
     35, -10,  11, -44,  -3,  48, -10,  -6, -17,  -2,
     11,  51,   8,  -8, -38,  -3,  -4,  31, -12,   2,
     46,   1, -10,  -4,  -5,   7,  26, -19,  10,   5,
    -18, -34, -45, -15,  54,  24, -18, -13, -31,  -7,
    }, {
    -33,  10,  34,  -5,  17,  35, -15,  -1, -53, -30,
     -6,  59,   0,  10, -24,  13, -17,  27,  -1,   1,
     37, -13,  -4, -20, -20,  18,  10,  16,   8,  11,
    -39, -18, -26,   0,  46,  20, -41, -15, -37, -15,
    }, {
     29,  -5,   7, -30,   1,  21,  -7,   7,   0,   0,
     47,  -9, -18, -15, -22,  14,  -4,   0, -28, -57,
     23,  21, -25,   2,  -1,   0,   7, -53, -19,  -3,
    -17, -15, -36,   0,  19, -24, -21, -43,   9,   0,
    }, {
    -39,  14,  30,   8,  22,   8, -12,  12, -34, -27,
     29,  -2, -26,   2,  -8,  31, -16,  -3, -17, -57,
     14,   6, -19, -13, -16,  10,  -8, -17, -20,   2,
    -38,   0, -17,  16,  11, -27, -44, -45,   4,  -8,
    }, {
     -9,   1,  20, -43,  17,  -3, -12,   0, -20,   4,
     33,  29,  -6, -22, -38,   7,   0,  -1, -29, -30,
     63,  21,  -3, -11, -27,   1,  14, -45,  10,   9,
     -1, -12, -47, -37,  28,   0,   2, -26,  -4,  13,
    }, {
    -78,  21,  43,  -4,  38, -17, -17,   5, -55, -24,
     15,  36, -14,  -4, -24,  24, -12,  -5, -17, -31,
     54,   5,   2, -27, -43,  12,  -2,  -9,   9,  15,
    -22,   3, -28, -21,  20,  -3, -20, -28,  -9,   5,
    }, {
     80,  -6,  16, -11, -30,  30,   9,  28,  28,  29,
     13,  -6,   2, -28,   3,   5,   7,  60,  -5,  -9,
    -11,   1, -24, -19,  27, -13,  32, -13, -15, -19,
    -19, -35, -17,  39,  43,   9,  -4, -42, -32, -41,
    }, {
     11,  14,  39,  27,  -9,  17,   4,  33,  -6,   0,
     -4,   1,  -5, -10,  17,  22,  -5,  57,   5,  -9,
    -20, -13, -18, -35,  11,  -3,  16,  22, -17, -13,
    -40, -19,   1,  55,  35,   5, -27, -44, -37, -49,
    }, {
     40,   0,  28, -24, -14,   5,   4,  21,   7,  33,
      0,  32,  15, -35, -12,  -1,  11,  58,  -5,  16,
     28,   0,  -1, -33,   0, -11,  39,  -5,  14,  -6,
     -3, -31, -28,   1,  53,  33,  19, -25, -46, -26,
    }, {
    -28,  20,  51,  14,   6,  -7,   0,  26, -27,   4,
    -18,  40,   6, -16,   1,  15,   0,  55,   5,  16,
     19, -14,   3, -49, -14,  -1,  22,  30,  12,   0,
    -24, -15,  -9,  17,  45,  29,  -4, -28, -51, -35,
    }, {
     34,   4,  25, -10,  -9, -21,   7,  36,  26,  36,
     35, -28, -12, -42,   3,  16,  12,  28, -21, -42,
      5,  21, -16, -26,   4, -19,  19, -39, -15, -15,
     -1, -13, -19,  17,  17, -14,  15, -55,  -4, -19,
    }, {
    -34,  25,  48,  28,  11, -34,   2,  41,  -9,   7,
     17, -21, -20, -24,  17,  33,   0,  24, -10, -42,
     -3,   5, -10, -42, -11,  -8,   3,  -3, -16,  -9,
    -22,   2,   0,  33,  10, -18,  -7, -58, -10, -28,
    }, {
     -4,  11,  37, -23,   5, -46,   2,  29,   5,  39,
     21,   9,   0, -49, -12,   9,  16,  26, -22, -15,
     45,  20,   5, -40, -22, -17,  26, -31,  14,  -2,
     14, -10, -30, -20,  27,   9,  39, -39, -18,  -5,
    }, {
    -73,  32,  60,  15,  26, -59,  -2,  33, -30,  10,
      3,  17,  -8, -30,   1,  26,   4,  22, -10, -16,
     36,   5,  11, -56, -37,  -6,  10,   5,  13,   3,
     -6,   5, -11,  -4,  19,   5,  16, -41, -24, -13
    }
};

static const uint32_t ftable1[128]={
    314527,  295599,  293848,  280320,  336779,  291703,  297354,  266749,
    325815,  305109,  310555,  294891,  349515,  300052,  313812,  278588,
    326231,  348357,  322076,  347246,  335655,  327567,  314037,  310198,
    343640,  370152,  349471,  382719,  353433,  344311,  338152,  333632,
    314810,  285147,  304708,  279643,  319779,  271292,  295149,  257376,
    338219,  302387,  335244,  302877,  343236,  285341,  321676,  274547,
    316321,  320899,  325378,  333870,  309279,  291473,  302532,  288065,
    344907,  351169,  369278,  382224,  334752,  312711,  335747,  316511,
    316511,  335747,  312711,  334752,  382224,  369278,  351169,  344907,
    288065,  302532,  291473,  309279,  333870,  325378,  320899,  316321,
    274547,  321676,  285341,  343236,  302877,  335244,  302387,  338219,
    257376,  295149,  271292,  319779,  279643,  304708,  285147,  314810,
    333632,  338152,  344311,  353433,  382719,  349471,  370152,  343640,
    310198,  314037,  327567,  335655,  347246,  322076,  348357,  326231,
    278588,  313812,  300052,  349515,  294891,  310555,  305109,  325815,
    266749,  297354,  291703,  336779,  280320,  293848,  295599,  314527
};

static const uint32_t ftable2[128]={
    194793,  214093,  222075,  221325,  210734,  211641,  211270,  192855,
    198561,  223821,  229577,  234105,  209600,  214643,  211594,  196292,
    191722,  221201,  215984,  227369,  222035,  236618,  220978,  209746,
    183193,  212405,  205343,  219484,  203652,  219140,  204153,  198495,
    163695,  194973,  186057,  210587,  188197,  215336,  197004,  205097,
    167090,  204380,  192189,  224334,  189091,  221215,  199256,  211624,
    167150,  210594,  190109,  228813,  205750,  260616,  215853,  240851,
    162492,  205131,  184310,  223583,  192669,  241298,  202170,  227169,
    227169,  202170,  241298,  192669,  223583,  184310,  205131,  162492,
    240851,  215853,  260616,  205750,  228813,  190109,  210594,  167150,
    211624,  199256,  221215,  189091,  224334,  192189,  204380,  167090,
    205097,  197004,  215336,  188197,  210587,  186057,  194973,  163695,
    198495,  204153,  219140,  203652,  219484,  205343,  212405,  183193,
    209746,  220978,  236618,  222035,  227369,  215984,  221201,  191722,
    196292,  211594,  214643,  209600,  234105,  229577,  223821,  198561,
    192855,  211270,  211641,  210734,  221325,  222075,  214093,  194793
};

static const int16_t decodeval[63]={
        0,     6,    16,    18,    20,    23,    25,    29,
       32,    36,    41,    46,    51,    57,    65,    73,
       81,    91,   103,   115,   129,   145,   163,   183,
      205,   230,   259,   290,   326,   365,   410,   460,
      516,   579,   650,   730,   819,   919,  1031,  1157,
     1298,  1456,  1634,  1833,  2057,  2308,  2590,  2906,
     3261,  3659,  4105,  4606,  5168,  5799,  6507,  7301,
     8192,  9191, 10313, 11571, 12983, 14567, 16345
};

static const int16_t decodetable1[127]={
    -4041, -4029, -4018, -4008, -3998, -3988, -3977, -3966,
    -3954, -3942, -3930, -3918, -3906, -3892, -3879, -3866,
    -3852, -3839, -3825, -3810, -3795, -3779, -3764, -3748,
    -3731, -3715, -3699, -3683, -3666, -3649, -3631, -3613,
    -3594, -3574, -3555, -3534, -3513, -3491, -3468, -3444,
    -3420, -3396, -3372, -3346, -3321, -3295, -3268, -3240,
    -3212, -3183, -3153, -3122, -3090, -3056, -3021, -2983,
    -2944, -2903, -2863, -2817, -2772, -2724, -2676, -2620,
    -2565, -2505, -2445, -2387, -2328, -2265, -2202, -2137,
    -2072, -2006, -1941, -1874, -1808, -1734, -1660, -1584,
    -1508, -1428, -1348, -1267, -1185, -1090,  -994,  -896,
     -798,  -699,  -600,  -487,  -374,  -242,  -110,    21,
      152,   300,   447,   584,   720,   851,   982,  1105,
     1229,  1342,  1456,  1569,  1682,  1799,  1916,  2023,
     2130,  2242,  2353,  2474,  2595,  2724,  2853,  2986,
     3118,  3240,  3363,  3475,  3588,  3701,  3814
};

static const int16_t decodetable2[63]={
    -3091, -2739, -2386, -2129, -1871, -1648, -1425, -1223,
    -1021,  -835,  -649,  -483,  -316,  -168,   -20,   123,
      267,   406,   544,   677,   810,   937,  1065,  1185,
     1305,  1420,  1534,  1645,  1756,  1863,  1970,  2071,
     2171,  2265,  2359,  2448,  2536,  2618,  2700,  2777,
     2854,  2925,  2996,  3064,  3133,  3198,  3263,  3324,
     3386,  3442,  3499,  3551,  3603,  3652,  3701,  3745,
     3789,  3829,  3870,  3908,  3947,  3983,  4020
};

static const int16_t decodetable3[63]={
    -3525, -3410, -3295, -3188, -3081, -2985, -2890, -2793,
    -2696, -2603, -2511, -2419, -2328, -2238, -2149, -2064,
    -1979, -1898, -1817, -1737, -1658, -1578, -1498, -1420,
    -1341, -1265, -1188, -1110, -1032,  -954,  -876,  -798,
     -721,  -641,  -561,  -478,  -394,  -311,  -228,  -141,
      -54,    32,   119,   208,   296,   390,   484,   584,
      683,   789,   895,  1009,  1123,  1248,  1373,  1512,
     1651,  1808,  1965,  2162,  2360,  2607,  2854
};

static const int16_t decodetable4[31]={
    -1845, -1451, -1057,  -790,  -522,  -300,   -77,   111,
      301,   474,   647,   811,   975,  1130,  1285,  1434,
     1582,  1727,  1873,  2018,  2163,  2308,  2452,  2594,
     2735,  2876,  3017,  3158,  3299,  3434,  3569
};

static const int16_t decodetable5[31]={
    -2691, -2439, -2187, -1987, -1788, -1611, -1435, -1276,
    -1118,  -977,  -837,  -704,  -571,  -444,  -316,  -188,
      -59,    71,   201,   336,   470,   614,   759,   918,
     1077,  1267,  1457,  1682,  1908,  2201,  2495
};

static const int16_t decodetable6[15]={
    -1372,  -923,  -474,  -170,   133,   383,   632,   866,
     1100,  1335,  1571,  1823,  2075,  2374,  2672
};

static const int16_t decodetable7[15]={
    -2389, -2088, -1787, -1509, -1231,  -974,  -717,  -478,
     -239,    -2,   234,   502,   770,  1122,  1474
};

static const int16_t decodetable8[15]={
    -1569, -1217,  -864,  -580,  -296,   -47,   200,   435,
      670,   911,  1151,  1430,  1709,  2047,  2385
};

static const int16_t decodetable9[15]={
    -2200, -1904, -1608, -1335, -1062,  -816,  -569,  -344,
     -120,   108,   338,   600,   863,  1242,  1621
};

static const int16_t decodetable10[7]={
     -617,  -213,   190,   496,   802,  1142,  1483
};

static const int16_t *decodetable[10]={
    decodetable1,decodetable2,decodetable3,decodetable4,decodetable5,
    decodetable6,decodetable7,decodetable8,decodetable9,decodetable10
};

#endif /* FFMPEG_RA144_H */
