require 'kinput2'

class KanjiConv < KanjiConvCore
  attr_reader :input, :selection, :dialog

  def initialize
    super
    @input  = JTextEdit.new

    @selection = Selection.new (self)
    @dialog = Dialog.new (self)
    @mode = ModeMaster.new (self)

    @fundMode  = FundMode.new(self)
    @inputMode = InputMode.new(self)
    @convMode  = ConvMode.new(self)
    @mode.set(:fund,  @fundMode)
    @mode.set(:input, @inputMode)
    @mode.set(:conv,  @convMode)
    @mode.change(:fund)

    debug_message("Initialize Done.")
  end

  def reset
    super
    @mode.change(:fund)
    @input.reset
    reset_cand_list
  end

  def convert (word)
    cand_list = [word, word.upcase]
    return cand_list
  end

  ## inputEvent (keynum, keysym = nil, state = nil)
  ## ReturnValue 1:Pass 0:Trap
  def inputEvent (keynum, keysym = nil, state = nil)
    debug_message("KeyNum: #{keynum}, KeySym: #{keysym}, Status: #{state}")

    if keynum == 0 then
      return 1
    end
    key = [keynum]

    if @mode.current then
      trap = @mode.current.call (keynum, keysym, state)
      return ((trap == true) ? 0 : 1)
    end
    return 1;
  end

  def selection_fix (index)
    fix (index)
    @mode.change(:fund)
  end

  def fix (fixed_arg)
    ### Must NOT chage @mode here, because exceptional case can exist.
    super (fixed_arg)
    @input.reset
    reset_cand_list
  end

  def insert (keysym, modifiers)
    debug_message("insert '#{keysym.chr}'")
    @input.insert(keysym.chr)
    set_cand_list (convert(@input.text), 0)
  end
end

class PrimeModeCore < ModeCore
  def initialize (parent)
    super
  end

  private
  def insert (keysym, modifiers)
    @parent.insert(keysym, modifiers)
    @parent.mode.change(:input)
    return true
  end

  def fix (keysym, modifiers)
    fix_internal(keysym, modifiers)
    @parent.mode.change(:fund)
    return true
  end

  def fix_and_insert (keysym, modifiers)
    fix_internal (keysym, modifiers)
    insert (keysym, modifiers)
    return true
  end

  def cursor_right (keysym, modifiers)
    @parent.input.cursor_right
    return true
  end
  def cursor_left (keysym, modifiers)
    @parent.input.cursor_left
    return true
  end
  def cursor_beginning (keysym, modifiers)
    @parent.input.cursor_beginning
    return true
  end
  def cursor_end (keysym, modifiers)
    @parent.input.cursor_end
    return true
  end

  def selection_right (keysym, modifiers)
    @parent.selection.right
    return true
  end
  def selection_left (keysym, modifiers)
    @parent.selection.left
    return true
  end
  def selection_beginning (keysym, modifiers)
    @parent.selection.line_beginning
    return true
  end
  def selection_end (keysym, modifiers)
    @parent.selection.line_end
    return true
  end
  def selection_up (keysym, modifiers)
    @parent.selection.up
    return true
  end
  def selection_down (keysym, modifiers)
    @parent.selection.down
    return true
  end
end

class FundMode < PrimeModeCore
  def initialize (parent)
    super
    @label = '[ $B$"(B ]'
    @trap  = false
  end

  def initialize_keys
    (33..126).each {|char|
      @keymap.add(char, :insert)
    }
  end

  def on (prev_mode = nil)
    @parent.selection.close
  end
end

class InputMode < PrimeModeCore
  def initialize (parent)
    super
    @label   = "[$BF~NO(B]"
  end

  def initialize_keys
    (33..126).each {|char|
      @keymap.add(char, :insert)
    }
    (?A..?Z).each {|char|
      @keymap.add(char, :fix_and_insert)
    }
    @keymap.add(:enter, :fix)
    @keymap.add([?m, :ctrl], :fix)
    @keymap.add(:space, :convert)
    @keymap.add(:backspace, :backspace)
    @keymap.add([?h, :ctrl], :backspace)
    @keymap.add(:delete, :delete)
    @keymap.add([?d, :ctrl], :delete)
    @keymap.add(:left, :cursor_left)
    @keymap.add([?b, :ctrl], :cursor_left)
    @keymap.add(:right, :cursor_right)
    @keymap.add([?f, :ctrl], :cursor_right)
    @keymap.add([?a, :ctrl], :cursor_beginning)
    @keymap.add([?e, :ctrl], :cursor_end)
    @keymap.add([?g, :ctrl], :cancel)
    @keymap.add(:esc, :cancel)
  end

  def on (prev_mode = nil)
    @parent.selection.close
  end

  def entries
    return @parent.input.segments
  end

  private
  def fix_internal (keysym, modifiers)
    @parent.fix(@parent.input.text)
  end

  def backspace (keysym, modifiers)
    @parent.input.backspace
    if @parent.input.text.length == 0 then
      @parent.mode.change(:fund)
    end
    return true
  end

  def delete (keysym, modifiers)
    @parent.input.delete
    if @parent.input.text.length == 0 then
      @parent.mode.change(:fund)
    end
    return true
  end

  def cancel (keysym, modifiers)
    @parent.input.reset
    @parent.mode.change(:fund)
    return true
  end

  def convert (keysym, modifiers)
    if @parent.set_cand_list (@parent.convert(@parent.input.text)) then
      @parent.set_cand_index(0)
      @parent.mode.change(:conv)
    end
    return true
  end
end

class ConvMode < PrimeModeCore
  def initialize (parent)
    super
    @label  = "[$BJQ49(B]"
  end

  def initialize_keys
    (33..126).each {|char|
      @keymap.add(char, :fix_and_insert)
    }
    @keymap.add(:enter, :fix)
    @keymap.add([?m, :ctrl], :fix)
    @keymap.add(:space, :convert)
#     @keymap.add(:backspace, :backspace)
#     @keymap.add([?h, :ctrl], :backspace)
#     @keymap.add(:delete, :delete)
#     @keymap.add([?d, :ctrl], :delete)
    @keymap.add(:left, :selection_left)
    @keymap.add([?b, :ctrl], :selection_left)
    @keymap.add(:right, :selection_right)
    @keymap.add([?f, :ctrl], :selection_right)
    @keymap.add(:down, :selection_down)
    @keymap.add([?n, :ctrl], :selection_down)
    @keymap.add(:up, :selection_up)
    @keymap.add([?p, :ctrl], :selection_up)
    @keymap.add([?a, :ctrl], :selection_beginning)
    @keymap.add([?e, :ctrl], :selection_end)
    @keymap.add([?g, :ctrl], :cancel)
    @keymap.add(:esc, :cancel)
  end

  def on (prev_mode = nil)
    @parent.selection.open
  end

  def entries
    return ['', @parent.cand_list[@parent.cand_index]]
  end

  private
  def fix_internal (keysym, modifiers)
    @parent.fix(@parent.cand_list[@parent.cand_index])
  end
  
  def cancel (keysym, modifiers)
    @parent.mode.change(:input)
    return true
  end

  def convert (keysym, modifiers)
    return selection_right(keysym, modifiers)
  end
end

$kanjiConv = KanjiConv.new
#p local_variables
