/* $Id: ruby-c.c,v 1.2 2003/06/10 02:11:25 komatsu Exp $ */
/*
 * AUTHOR:  Hiroyuki Komatsu <komatsu@taiyaki.org> http://taiyaki.org/
 * LICENSE: GPL2
 */

#include <stdarg.h>
#include "ruby-c.h"
#define RUBY_EVALF_BUF 1024

VALUE
ruby_eval (char *statement)
{
    int state;
    VALUE result;

    result = rb_eval_string_protect (statement,  &state);
    if (state) {
	EXTERN VALUE ruby_errinfo;

	fprintf(stderr, "Eval Error in \"%s\"\n", statement);
	fprintf(stderr, "%s\n", STR2CSTR(ruby_errinfo));
    }
    return result;
}

VALUE
ruby_evalf (char *statement_format, ...)
{
    va_list ap;
    char statement[RUBY_EVALF_BUF];
    int length;

    va_start (ap, statement_format);
    length = vsnprintf (statement, RUBY_EVALF_BUF, statement_format, ap);
    va_end (ap);

    if (length == -1) { /* Before glibc 2.0.6 */
	fprintf (stderr, "ruby_evalf: Error, Out of Buffer\n");
	fprintf (stderr, "Buffer size is %d\n", RUBY_EVALF_BUF);
	return Qnil;
    } else if (length > RUBY_EVALF_BUF -1) { /* C99 */
	VALUE result;
	char *d_statement = malloc (sizeof (char) * length + 1);
	va_start (ap, statement_format);
	vsnprintf (d_statement, length + 1, statement_format, ap);
	va_end (ap);
	result = ruby_eval (d_statement);
	free (d_statement);
	return result;
    } else {
	return ruby_eval (statement);
    }
}

void
ruby_load (char *filename)
{
    int state;
    rb_load_protect (rb_str_new2 (filename), 0, &state);
    if (state) {
	fprintf(stderr, "Load Error for \"%s\"\n", filename);
	fprintf(stderr, "%s\n", STR2CSTR(ruby_errinfo));
    }
}
