/*
 *  $Id: jslib.h,v 1.5 2005/04/10 15:26:37 aonoto Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 *       Nihongo Henkan  Library Header File
 */

#ifndef WNN_JSLIB_H
#define WNN_JSLIB_H

#ifndef _WNN_SETJMP
#define _WNN_SETJMP
#include <setjmp.h>
#endif

#define JLIB_VERSION    0x4003

#ifndef w_char
#define w_char  unsigned short
#endif /* w_char */

/* ü٥(ʻֹ) */
#define WNN_BUN_SENTOU  -1      /* ʸƬˤʤ */
#define WNN_ALL_HINSI   -2      /* ʤǤ⤨ */
/* ü٥ */
#define WNN_VECT_KANREN 0       /* ϢʸѴνü٥ */
#define WNN_VECT_KANTAN 1       /* ñʸѴνü٥ */
#define WNN_VECT_KANZEN 1       /* Фνü٥ 
                                   ñʸѴΤΤ */
#define WNN_VECT_BUNSETSU 2     /* ϢʸѴΡʸνü٥ */
#define WNN_VECT_NO     -1      /* ü٥1 ̵ */
/* ʸνü³ */
#define WNN_CONNECT_BK  1       /* ꤵ줿ü٥³Ǥ */
#define WNN_NOT_CONNECT_BK      0       /* */
/* ʸü³ */
#define WNN_CONNECT     1       /* ꤵ줿(ʻ졢°)³Ǥ */
#define WNN_SENTOU      2       /* ʸƬ */
#define WNN_NOT_CONNECT 3       /* Ƭˤʤʤ³Ǥʤ */
#define WNN_GIJI        4       /* ʸä */

/* ʸľ򤷤 */
#define WNN_HIRAGANA    -1      /* Ҥ餬 */  /* ɤߤΤޤ */
#define WNN_KATAKANA    -11     /*  */
/*  */
#define WNN_NUM_HAN     -2      /* Ⱦѿ */  /* ɤߤΤޤ */
#define WNN_NUM_ZEN     -12     /* ѿ */  /*  */
#define WNN_NUM_KAN     -13     /*  */    /*  */
#define WNN_NUM_KANSUUJI -15    /*  */    /* ɴ󽽻 */
#define WNN_NUM_KANOLD  -16     /*  */    /* ɴ */
#define WNN_NUM_HANCAN  -17     /* Ⱦѿ */  /* 1,234 */
#define WNN_NUM_ZENCAN  -18     /* ѿ */  /*  */
/* ѿ */
#define WNN_ALP_HAN     -4      /* Ⱦ */      /* ɤߤΤޤ */
#define WNN_ALP_ZEN     -30     /*  */
/*  */
#define WNN_KIG_HAN     -5      /* Ⱦ */      /* ɤߤΤޤ */
#define WNN_KIG_JIS     -40     /* (JIS) */
#define WNN_KIG_ASC     -41     /* (ASC) */

#define WNN_FT_DICT_FILE 1
#define WNN_FT_HINDO_FILE 2
#define WNN_FT_FUZOKUGO_FILE 3

#define WNN_STATIC_DICT 1       /* static dict */
#define WNN_UD_DICT 2           /* updatable dict */
#define WNN_REV_DICT 3          /* Updatable Dictonary with Reverse Index */
#define WNN_REG_DICT 4          /* Regular Expressino Dictonary */

/* for CHINESE PIN-IN : with Si Sheng () */
#define CWNN_REV_DICT           0x103   /* Updatable with Reverse Index */

/* for CHINESE: Bi Xing (ɮ) */
#define BWNN_REV_DICT           0x203   /* Updatable with Reverse Index */

#define WNN_DIC_RDONLY  1
#define WNN_DIC_RW      0

#define WNN_DIC_ADD_REV 1       /* Ѵ */
#define WNN_DIC_ADD_NOR 0       /* ̾Ѵ */

/* header file for dic_syurui */
#define WNN_FILE_NOT_EXIST -1
#define WNN_NOT_A_JISHO 0
/* KURI
#define WNN_USER_DIC 1
#define WNN_SYSTEM_DIC 3
*/
#define WNN_HINDO_FILE 4
#define WNN_FUZOKUGO_FILE 5

/* set_hindo operation */
#define WNN_HINDO_NOP -2
#define WNN_IMA_ON -3
#define WNN_IMA_OFF -4
#define WNN_HINDO_INC -3
#define WNN_HINDO_DECL -4
#define WNN_ENTRY_NO_USE -1

/*      Wnn constant
*/
#define WNN_HOSTLEN 16
#define WNN_ENVNAME_LEN 32

/*      js_who  */
#define WNN_MAX_ENV_OF_A_CLIENT 32

struct wnn_jwho
{
  int sd;                       /* jserver Υåȥǥץ */
  char user_name[64];           /* 桼̾ */
  char host_name[64];           /* ۥ̾ */
  int env[WNN_MAX_ENV_OF_A_CLIENT];     /* Υ饤ȤѤƤ
                                           Ķֹ󡣶ƤȤˤϡ-1  */
};
typedef struct wnn_jwho WNN_JWHO;

/*      js_env_list     */
#define WNN_MAX_JISHO_OF_AN_ENV 30
#define WNN_MAX_FILE_OF_AN_ENV 60

struct wnn_env_info
{
  int env_id;                   /* Ķֹ */
  char env_name[WNN_ENVNAME_LEN];       /* Ķ̾ */
  int ref_count;                /* ȿ */
  /* struct wnn_param; */
  int fzk_fid;                  /* °Υեֹ */
  int jishomax;                 /* ѤƤ뼭θĿ */
  int jisho[WNN_MAX_JISHO_OF_AN_ENV];   /* ѤƤ뼭μֹ档
                                           ǽjishomaxḤ̂ */
  int file[WNN_MAX_FILE_OF_AN_ENV];     /* δĶˤĤʤäƤ
                                           եֹ(ƤȤˤϡ-1 ) */
};
typedef struct wnn_env_info WNN_ENV_INFO;

#define WNN_COMMENT_LEN 512     /* jisho no comment no nagasa */
#define WNN_F_NAMELEN 100
#define WNN_PASSWD_LEN 16       /* File Passwd Length */


struct wnn_dic_info
{
  int dic_no;                   /* ֹ */
  int body;                     /* ΤΥեֹ */
  int hindo;                    /* ٤Υեֹ */
  int rw;                       /* Ͽǽɤ
                                   (WNN_DIC_RW, WNN_DIC_RDONLY) */
  int hindo_rw;                 /* ٤ǽɤ
                                   (WNN_DIC_RW, WNN_DIC_RDONLY) */
  int enablef;                  /* 񤬻椫ɤ
                                   (1 = , 0 = ) */
  int nice;                     /* Ѵͥ */
  int rev;                      /* Ѵɤ(1 = Ѵ, 0 = Ѵ) */
/* added H.T */
  w_char comment[WNN_COMMENT_LEN];      /* Υ */
  char fname[WNN_F_NAMELEN];    /* Υե̾ */
  char hfname[WNN_F_NAMELEN];   /* ٤Υե̾ */
  char passwd[WNN_PASSWD_LEN];  /* Υѥ */
  char hpasswd[WNN_PASSWD_LEN]; /* ٤Υѥ */
  int type;                     /* μ(WNN_UD_DICT,WNN_STATIC_DICT) */
  int gosuu;                    /* θ */
  int localf;
  int hlocalf;
};

typedef struct wnn_dic_info WNN_DIC_INFO;

struct wnn_file_stat
{
  int type;                     /* եμ
                                   WNN_STATIC_DICT              
                                   WNN_UD_DICT          Ͽǽ
                                   WNN_HINDO_FILE               ٥ե
                                   WNN_FUZOKUGO_FILE    °ե
                                   WNN_NOT_A_JISHO              ¾   */
};

typedef struct wnn_file_stat WNN_FILE_STAT;

/*      */
extern int wnn_errorno;         /* WnnΥ顼Ϥѿ𤵤 */

extern char *wnn_dic_types[];   /* "","Ͽ","Ѵ","" */

extern char *cwnn_dic_types[];  /* "","Ͽ","Ѵ","" */
extern char *bwnn_dic_types[];  /* "","Ͽ","Ѵ","" */

#define FILE_ALREADY_READ -2

/* ι¤Τϡ饤֥Ѥ */
struct wnn_jserver_id
{
  int sd;
  char js_name[40];
  int js_dead;
  jmp_buf js_dead_env;          /* ФǤenv */
  int js_dead_env_flg;          /* jd_server_dead_envͭݤ  */
};

typedef struct wnn_jserver_id WNN_JSERVER_ID;

/* ι¤Τϡ饤֥Ѥ */
struct wnn_env
{
  int env_id;
  WNN_JSERVER_ID *js_id;
  char lang[16];                /* for exsample "ja_JP" */
};

typedef struct wnn_env WNN_ENV;

struct wnn_param
{
  int n;                        /* ()ʸϤΣ */
  int nsho;                     /* ʸξʸκ */
  int p1;                       /* Ω٤Υѥ᡼ */
  int p2;                       /* ʸĹΥѥ᡼ */
  int p3;                       /* ΩĹΥѥ᡼ */
  int p4;                       /* ȤäӥåȤΥѥ᡼ */
  int p5;                       /* Υѥ᡼ */
  int p6;                       /* ʸɾͤΥѥ᡼ */
  int p7;                       /* ʸĹΥѥ᡼ */
  int p8;                       /* ʸΥѥ᡼ */
  int p9;                       /* ʻ  */
  int p10;                      /* ʻ ʤ *//* CWNN:ѿ */
  int p11;                      /* ʻ ѿ *//* CWNN: */
  int p12;                      /* ʻ  *//* CWNN:̤ */
  int p13;                      /* ʻ ĳ̤ *//* CWNN:ĳ̤ */
  int p14;                      /* ʻ ° *//* BWNN:No of koho */
  int p15;                      /* ʻ ̤ *//* CWNN:Not used */
};

#ifdef nodef
struct wnn_dic_info_struct
{
  int body_fid;
  int hindo_fid;
  int enablef;
  int rw;
  int hindo_rw;
  int nice;
};

typedef struct wnn_dic_info_struct WNN_DIC_INFO_STRUCT;
#endif

struct wnn_file_info_struct
{
  int fid;                      /* եֹ */
  char name[WNN_F_NAMELEN];     /* ե̾ */
  int localf;                   /* СȤΥե뤫ɤ
                                   1: С
                                   0: 饤ȡ   */
  int type;                     /* եμ */
  int ref_count;                /* (Ķ)ȿ */
};

typedef struct wnn_file_info_struct WNN_FILE_INFO_STRUCT;

#define WNN_VECT_L      ((256+8*4-1)/(8*4) + 5) /***** !!!!! ****/

struct wnn_sho_bunsetsu
{
  int end;                      /* ʸ end char index */
  int start;                    /* ʸ top char index */
  int jiriend;                  /* ʸμΩ end char index */
  int dic_no;                   /* ΩμΥȥֹ */
  int entry;                    /* ʸμΩ켭 entry */

  int hinsi;                    /* Ωʻ */
  int status;                   /* ʸƬ */
  int status_bkwd;              /* usiro ʸ³Ǥ뤫 */
  int hindo;                    /* 伫Ω */
  int ima;                      /* 伫ΩκȤäӥå */
  int kangovect;                /* ³٥ȥơ֥ؤΥݥ */
  int hyoka;                    /* ʸɾ */
  w_char *kanji;                /* Ωʸ */
  w_char *yomi;                 /* Ωɤʸ */
  w_char *fuzoku;               /* °ʸ */
/*
 *٤ˤĤƤϡ٥ե뤬ꤵƤϡ
 *hindo = ٥ե() + ()
 *ima = ٥եκȤäӥå
 *
 *٥ե뤬ꤵƤʤˤϡ
 *hindo = ()͡ima = κȤäӥå
 *Ǥ롣ǡͤȤϡ׻7ӥåȤ˰̤줿ͤǤ롣
 *ͤǤϤʤ֤ͤΤϡѴ̤ΥǥХåΤǤ롣
 */
};

struct wnn_dai_bunsetsu
{
  int end;                      /* ʸ end char index */
  int start;                    /* ʸ top char index */
  struct wnn_sho_bunsetsu *sbn; /* ʸϷ̤ؤΥݥ */
  int hyoka;                    /* ʸɾ */
  int sbncnt;                   /* ʸ (ξϡ)
                                   DSD_SBNϡ*sbn  sbncnt  */
};

struct wnn_jdata
{
  int dic_no;                   /* ֹ */
  int serial;                   /* Υȥֹ */
  int hinshi;                   /* ʻֹ(ʻֹʻ̾бϡmanual/etc
                                   β򻲾) */
  int hindo;                    /*  */
  int ima;                      /* Ȥäӥå */
  int int_hindo;                /*  */
  int int_ima;                  /* ⡢Ȥäӥå */
  w_char *yomi;                 /* ɤߤʸ */
  w_char *kanji;                /* ʸ */
  w_char *com;                  /* ȥΥʸ */
/*
 *٤ˤĤƤϡ٥ե뤬ꤵƤϡ
 *hindo = ٥ե()͡ima = ٥եκȤäӥå
 *int_hindo = ()͡int_ima = κȤäӥå
 *
 *٥ե뤬ꤵƤʤˤϡ
 *hindo = ()͡ima = κȤäӥå
 *int_hindo = -1int_ima = -1
 *
 *ɤξǤ⡢ȥ꤬ߤξ֤λˤϡ
 *hindo = -1, ima = 0 뤤ϡ
 *int_hindo = -1, int_ima = 0 Ȥʤ롣
 *ǡ()ͤȤϡ׻7ӥåȤ˰̤줿ͤ顢
 *ºݤͤꤷͤǤ롣
 */
};

struct wnn_ret_buf
{
  int size;                     /* buf  alloc Ƥ礭 */
  char *buf;                    /* malloc ʤɤǤȤ줿ΰ */
};


#define WNN_F_UNIQ_LEN  (sizeof(struct wnn_file_uniq))

/* ι¤Τϡ饤֥Ѥ */
struct wnn_file_head
{
  struct wnn_file_uniq
  {
    int time;
    int dev;
    int inode;
    char createhost[WNN_HOSTLEN];
  }
  file_uniq;
  struct wnn_file_uniq file_uniq_org;
  int file_type;
  char file_passwd[WNN_PASSWD_LEN];
};

#define WNN_HINSI_NAME_LEN 64

#define WNN_FILE_HEADER_LEN     (WNN_PASSWD_LEN + 8 + WNN_FILE_STRING_LEN + \
                                 sizeof(struct wnn_file_uniq) * 2 + 4)
                                /*
                                   8 is for future use 
                                   4 is for file_type.
                                 */

#ifndef JSERVER
/*
  JSLIB function declaration
*/
#define js_open(server, timeout)        js_open_lang(server, "ja_JP", timeout)
#define js_connect(server,env_name)     js_connect_lang(server, env_name, "ja_JP")

/* prototypes */
WNN_JSERVER_ID *js_open_lang (register char *server, register char *lang, register int timeout);
int js_close (WNN_JSERVER_ID *server);
struct wnn_env *js_connect_lang (WNN_JSERVER_ID *server, register char *env_name, char *lang);
int js_disconnect (register struct wnn_env *env);

int js_env_list (WNN_JSERVER_ID *server, struct wnn_ret_buf *ret);
int js_param_set(struct wnn_env *env, register struct wnn_param *para);
int js_param_get(struct wnn_env *env, register struct wnn_param *para);
char *js_get_lang(struct wnn_env *env);
/**************************************/
int js_access(struct wnn_env *env, char *path, int amode);
int js_dic_add(struct wnn_env *env, int fid, int hfid, int rev, int jnice, int rw, int hrw, char *pw1, char *pw2);
int js_dic_delete(struct wnn_env *env, int dicno);
int js_dic_file_create (struct wnn_env *env, char *fn, int type, w_char *comment, char *passwd, char *hpasswd);
int js_dic_file_create_client (struct wnn_env *env, char *fn, int type, w_char *com, char *passwd, char *hpasswd);
int js_dic_info (struct wnn_env *env, int dic_no, register WNN_DIC_INFO *ret);
int js_dic_list(struct wnn_env *env, struct wnn_ret_buf *ret);
int js_dic_list_all (WNN_JSERVER_ID *server, struct wnn_ret_buf *ret);
int js_dic_use(struct wnn_env *env, int dic_no, int flag);
int js_env_exist (register WNN_JSERVER_ID *server, register char *env_name);
int js_env_sticky(register struct wnn_env *env);
int js_env_un_sticky(register struct wnn_env *env);
int js_file_comment_set (struct wnn_env *env, int fid, w_char *comment);
int js_file_discard(struct wnn_env *env, int fid);
int js_file_info (struct wnn_env *env, int fid, register WNN_FILE_INFO_STRUCT *file);
int js_file_list(struct wnn_env *env, struct wnn_ret_buf *ret);
int js_file_list_all (WNN_JSERVER_ID *server, struct wnn_ret_buf *ret);
int js_file_loaded (WNN_JSERVER_ID *server, char *path);
int js_file_loaded_local (WNN_JSERVER_ID *server, char *path);
int js_file_password_set(struct wnn_env *env, int fid, int which, char *old, char *new);
int js_file_read(struct wnn_env *env, char *fn);
int js_file_receive(struct wnn_env *env, int fid, char *fn);
int js_file_remove (WNN_JSERVER_ID *server, char *n, char *pwd);
int js_file_remove_client (WNN_JSERVER_ID *server, char *n, char *pwd);
int js_file_send(struct wnn_env *env, char *fn);
int js_file_stat (struct wnn_env *env, char *path, WNN_FILE_STAT *s);
int js_file_write(struct wnn_env *env, int fid, char *fn);
int js_fuzokugo_get(struct wnn_env *env);
int js_fuzokugo_set(struct wnn_env *env, int fid);
void js_flush (struct wnn_env *env);
int js_hindo_file_create (struct wnn_env *env, int fid, char *fn, w_char *comment, char *hpasswd);
int js_hindo_file_create_client (struct wnn_env *env, int fid, char *fn, w_char *com, char *hpasswd);
int js_hindo_set(struct wnn_env *env, int dic, int entry, int ima, int hindo);
int js_hinsi_dicts(struct wnn_env *env, int no, struct wnn_ret_buf *rb);
int js_hinsi_list (struct wnn_env *env, int dic_no, w_char *name, struct wnn_ret_buf *rb);
int js_hinsi_name (WNN_JSERVER_ID *server, int no, struct wnn_ret_buf *rb);
int js_hinsi_number (WNN_JSERVER_ID *server, w_char *name);
int js_hinsi_table_set (struct wnn_env *env, int dic_no, w_char *hinsi_table);
int js_isconnect (register struct wnn_env *env);
int js_kanren (struct wnn_env *env, w_char *yomi, int hinsi, w_char *fzk, int vec, int vec1, int vec2, struct wnn_ret_buf *rb);
int js_kantan_dai (struct wnn_env *env, w_char *yomi, int hinsi, w_char *fzk, int vec, int vec1, struct wnn_ret_buf *rb);
int js_kantan_sho (struct wnn_env *env, w_char *yomi, int hinsi, w_char *fzk, int vec, int vec1, struct wnn_ret_buf *rb);
int js_kanzen_dai (struct wnn_env *env, w_char *yomi, int hinsi, w_char *fzk, int vec, int vec1, struct wnn_ret_buf *rb);
int js_kanzen_sho (struct wnn_env *env, w_char *yomi, int hinsi, w_char *fzk, int vec, int vec1, struct wnn_ret_buf *rb);
int js_kill (WNN_JSERVER_ID *server);
int js_mkdir(struct wnn_env *env, char *path);
int js_version (WNN_JSERVER_ID *server, int *serv, int *libv);
int js_who (WNN_JSERVER_ID *server, struct wnn_ret_buf *ret);
int js_word_add (struct wnn_env *env, int dic_no, w_char *yomi, w_char *kanji, w_char *comment, int hinshi, int init_hindo);
int js_word_comment_set (struct wnn_env *env, int dic_no, int entry, w_char *comment);
int js_word_delete(struct wnn_env *env, int dic_no, int entry);
int js_word_info(struct wnn_env *env, int dic_no, int entry, struct wnn_ret_buf *ret);
int js_word_search (struct wnn_env *env, int dic_no, w_char *yomi, struct wnn_ret_buf *ret);
int js_word_search_by_env (struct wnn_env *env, w_char *yomi, struct wnn_ret_buf *ret);

/* haven't discovered yet --yaz */
extern WNN_JSERVER_ID *js_change_current_jserver ();

#endif
#endif  /* WNN_JSLIB_H */
