;;; quail/latin-ltx.el -- Quail package for Latin scripts

;; Copyright (C) 2001 Electrotechnical Laboratory, JAPAN.
;; Licensed to the Free Software Foundation.

;; Keywords: multilingual, input method, Greek

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'quail)

(quail-define-package
 "latin-latex2e" "Latin" "LL" t
 "The LaTeX-like input method for Latin characters.
The characters in latin-iso8859-1 and mule-unicode-0100-24ff are supported."
 nil t t nil nil nil nil nil nil nil t)

(quail-define-rules
 ("!`" ?,A!(B)
 ("{\\pounds}" ?,A#(B) ("\\pounds" ?,A#(B)
 ("{\\S}" ?,A'(B) ("\\S" ?,A'(B)
 ("\\\"{}" ?,A((B)
 ("{\\copyright}" ?,A)(B) ("\\copyright" ?,A)(B)
 ("$^a$" ?,A*(B)
 ("\\={}" ?,A/(B)
 ("$\\pm$" ?,A1(B)
 ("$^2$" ?,A2(B)
 ("$^3$" ?,A3(B)
 ("\\'{}" ?,A4(B)
 ("{\\P}" ?,A6(B) ("\\P" ?,A6(B)
 ("$\\cdot$" ?,A7(B)
 ("\\c{}" ?,A8(B)
 ("$^1$" ?,A9(B)
 ("$^o$" ?,A:(B)
 ("?`" ?,A?(B)
 
 ("\\`{A}" ?,A@(B)  ("\\`A" ?,A@(B)
 ("\\'{A}" ?,AA(B)  ("\\'A" ?,AA(B)
 ("\\^{A}" ?,AB(B)  ("\\^A" ?,AB(B)
 ("\\~{A}" ?,AC(B)  ("\\~A" ?,AC(B)
 ("\\\"{A}" ?,AD(B)  ("\\\"A" ?,AD(B)
 ("\\\k{A}" ?,B!(B)
 ("{\\AA}" ?,AE(B) ("\\AA" ?,AE(B)
 ("{\\AE}" ?,AF(B) ("\\AE" ?,AF(B)
 ("\\c{C}" ?,AG(B)  ("\\cC" ?,AG(B)
 ("\\`{E}" ?,AH(B)  ("\\`E" ?,AH(B)
 ("\\'{E}" ?,AI(B)  ("\\'E" ?,AI(B)
 ("\\^{E}" ?,AJ(B)  ("\\^E" ?,AJ(B)
 ("\\\"{E}" ?,AK(B)  ("\\\"E" ?,AK(B)
 ("\\\k{E}" ?,BJ(B)
 ("\\`{I}" ?,AL(B)  ("\\`I" ?,AL(B)
 ("\\'{I}" ?,AM(B)  ("\\'I" ?,AM(B)
 ("\\^{I}" ?,AN(B)  ("\\^I" ?,AN(B)
 ("\\\"{I}" ?,AO(B)  ("\\\"I" ?,AO(B)
 ("\\\k{I}" ?,DG(B)

 ("\\~{N}" ?,AQ(B)  ("\\~N" ?,AQ(B)
 ("\\`{O}" ?,AR(B)  ("\\`O" ?,AR(B)
 ("\\'{O}" ?,AS(B)  ("\\'O" ?,AS(B)
 ("\\^{O}" ?,AT(B)  ("\\^O" ?,AT(B)
 ("\\~{O}" ?,AU(B)  ("\\~O" ?,AU(B)
 ("\\\"{O}" ?,AV(B)  ("\\\"O" ?,AV(B)
 ("\\\k{O}" ?$,1"J(B)
 ("$\\times$" ?,AW(B)
 ("{\\O}" ?,AX(B) ("\\O" ?,AX(B)
 ("\\`{U}" ?,AY(B) ("\\`U" ?,AY(B)
 ("\\'{U}" ?,AZ(B) ("\\'U" ?,AZ(B)
 ("\\^{U}" ?,A[(B) ("\\^U" ?,A[(B)
 ("\\\"{U}" ?,A\(B) ("\\\"U" ?,A\(B)
 ("\\\k{U}" ?,DY(B)
 ("\\'{Y}" ?,A](B) ("\\'Y" ?,A](B)
 ("{\\ss}" ?,A_(B) ("\\ss" ?,A_(B)

 ("\\`{a}" ?,A`(B) ("\\`a" ?,A`(B)
 ("\\'{a}" ?,Aa(B) ("\\'a" ?,Aa(B)
 ("\\^{a}" ?,Ab(B) ("\\^a" ?,Ab(B)
 ("\\~{a}" ?,Ac(B) ("\\~a" ?,Ac(B)
 ("\\\"{a}" ?,Ad(B) ("\\\"a" ?,Ad(B)
 ("\\\k{a}" ?,B1(B)
 ("{\\aa}" ?,Ae(B) ("\\aa" ?,Ae(B)
 ("{\\ae}" ?,Af(B) ("\\ae" ?,Af(B)
 ("\\c{c}" ?,Ag(B) ("\\cc" ?,Ag(B)
 ("\\`{e}" ?,Ah(B) ("\\`e" ?,Ah(B)
 ("\\'{e}" ?,Ai(B) ("\\'e" ?,Ai(B)
 ("\\^{e}" ?,Aj(B) ("\\^e" ?,Aj(B)
 ("\\\"{e}" ?,Ak(B) ("\\\"e" ?,Ak(B)
 ("\\\k{e}" ?,Bj(B)
 ("\\`{\\i}" ?,Al(B)  ("\\`i" ?,Al(B)
 ("\\'{\\i}" ?,Am(B)  ("\\'i" ?,Am(B)
 ("\\^{\\i}" ?,An(B) ("\\^i" ?,An(B)
 ("\\\"{\\i}" ?,Ao(B) ("\\\"i" ?,Ao(B)
 ("\\\k{i}" ?,Dg(B)

 ("\\~{n}" ?,Aq(B) ("\\~n" ?,Aq(B)
 ("\\`{o}" ?,Ar(B) ("\\`o" ?,Ar(B)
 ("\\'{o}" ?,As(B) ("\\'o" ?,As(B)
 ("\\^{o}" ?,At(B) ("\\^o" ?,At(B)
 ("\\~{o}" ?,Au(B) ("\\~o" ?,Au(B)
 ("\\\"{o}" ?,Av(B) ("\\\"o" ?,Av(B)
 ("\\\k{o}" ?$,1"K(B)
 ("$\\div$" ?,Aw(B)
 ("{\\o}" ?,Ax(B) ("\\o" ?,Ax(B)
 ("\\`{u}" ?,Ay(B) ("\\`u" ?,Ay(B)
 ("\\'{u}" ?,Az(B) ("\\'u" ?,Az(B)
 ("\\^{u}" ?,A{(B) ("\\^u" ?,A{(B)
 ("\\\"{u}" ?,A|(B) ("\\\"u" ?,A|(B)
 ("\\\k{u}" ?,Dy(B)
 ("\\'{y}" ?,A}(B) ("\\'y" ?,A}(B)
 ("\\\"{y}" ?,A(B) ("\\\"y" ?,A(B)

 ("\\={A}" ?$,1  (B) ("\\=A" ?$,1  (B)
 ("\\={a}" ?$,1 !(B) ("\\=a" ?$,1 !(B)
 ("\\u{A}" ?$,1 "(B) ("\\uA" ?$,1 "(B)
 ("\\u{a}" ?$,1 #(B) ("\\ua" ?$,1 #(B)
 ("\\'{C}" ?$,1 &(B) ("\\'C" ?$,1 &(B)
 ("\\'{c}" ?$,1 '(B) ("\\'c" ?$,1 '(B)
 ("\\^{C}" ?$,1 ((B) ("\\^C" ?$,1 ((B)
 ("\\^{c}" ?$,1 )(B) ("\\^c" ?$,1 )(B)
 ("\\.{C}" ?$,1 *(B) ("\\.C" ?$,1 *(B)
 ("\\.{c}" ?$,1 +(B) ("\\.c" ?$,1 +(B)
 ("\\v{C}" ?$,1 ,(B) ("\\vC" ?$,1 ,(B)
 ("\\v{c}" ?$,1 -(B) ("\\vc" ?$,1 -(B)
 ("\\v{D}" ?$,1 .(B) ("\\vD" ?$,1 .(B)
 ("\\v{d}" ?$,1 /(B) ("\\vd" ?$,1 /(B)

 ("\\={E}" ?$,1 2(B) ("\\=E" ?$,1 2(B)
 ("\\={e}" ?$,1 3(B) ("\\=e" ?$,1 3(B)
 ("\\u{E}" ?$,1 4(B) ("\\uE" ?$,1 4(B)
 ("\\u{e}" ?$,1 5(B) ("\\ue" ?$,1 5(B)
 ("\\.{E}" ?$,1 6(B) ("\\.E" ?$,1 6(B)
 ("\\e{e}" ?$,1 7(B) ("\\ee" ?$,1 7(B)
 ("\\v{E}" ?$,1 :(B) ("\\vE" ?$,1 :(B)
 ("\\v{e}" ?$,1 ;(B) ("\\ve" ?$,1 ;(B)
 ("\\^{G}" ?$,1 <(B) ("\\^G" ?$,1 <(B)
 ("\\^{g}" ?$,1 =(B) ("\\^g" ?$,1 =(B)
 ("\\u{G}" ?$,1 >(B) ("\\uG" ?$,1 >(B)
 ("\\u{g}" ?$,1 ?(B) ("\\ug" ?$,1 ?(B)

 ("\\.{G}" ?$,1 @(B) ("\\.G" ?$,1 @(B)
 ("\\.{g}" ?$,1 A(B) ("\\.g" ?$,1 A(B)
 ("\\c{G}" ?$,1 B(B) ("\\cG" ?$,1 B(B)
 ("\\c{g}" ?$,1 C(B) ("\\cg" ?$,1 C(B)
 ("\\^{H}" ?$,1 D(B) ("\\^H" ?$,1 D(B)
 ("\\^{h}" ?$,1 E(B) ("\\^h" ?$,1 E(B)
 ("\\~{I}" ?$,1 H(B) ("\\~I" ?$,1 H(B)
 ("\\~{\\i}" ?$,1 I(B) ("\\~i" ?$,1 I(B)
 ("\\={I}" ?$,1 J(B) ("\\=I" ?$,1 J(B)
 ("\\={\\i}" ?$,1 K(B) ("\\=i" ?$,1 K(B)
 ("\\u{I}" ?$,1 L(B) ("\\uI" ?$,1 L(B)
 ("\\u{\\i}" ?$,1 M(B) ("\\ui" ?$,1 M(B)

 ("\\.{I}" ?$,1 P(B) ("\\.I" ?$,1 P(B)
 ("{\\i}" ?$,1 Q(B) ("\\i" ?$,1 Q(B)
 ("\\^{J}" ?$,1 T(B) ("\\^J" ?$,1 T(B)
 ("\\^{\\j}" ?$,1 U(B) ("\\^j" ?$,1 U(B)
 ("\\c{K}" ?$,1 V(B) ("\\cK" ?$,1 V(B)
 ("\\c{k}" ?$,1 W(B) ("\\ck" ?$,1 W(B)
 ("\\'{L}" ?$,1 Y(B) ("\\'L" ?$,1 Y(B)
 ("\\'{l}" ?$,1 Z(B) ("\\'l" ?$,1 Z(B)
 ("\\c{L}" ?$,1 [(B) ("\\cL" ?$,1 [(B)
 ("\\c{l}" ?$,1 \(B) ("\\cl" ?$,1 \(B)

 ("{\\L}" ?$,1 a(B) ("\\L" ?$,1 a(B)
 ("{\\l}" ?$,1 b(B) ("\\l" ?$,1 b(B)
 ("\\'{N}" ?$,1 c(B) ("\\'N" ?$,1 c(B)
 ("\\'{n}" ?$,1 d(B) ("\\'n" ?$,1 d(B)
 ("\\c{N}" ?$,1 e(B) ("\\cN" ?$,1 e(B)
 ("\\c{n}" ?$,1 f(B) ("\\cn" ?$,1 f(B)
 ("\\v{N}" ?$,1 g(B) ("\\vN" ?$,1 g(B)
 ("\\v{n}" ?$,1 h(B) ("\\vn" ?$,1 h(B)
 ("\\={O}" ?$,1 l(B) ("\\=O" ?$,1 l(B)
 ("\\={o}" ?$,1 m(B) ("\\=o" ?$,1 m(B)
 ("\\u{O}" ?$,1 n(B) ("\\uO" ?$,1 n(B)
 ("\\u{o}" ?$,1 o(B) ("\\uo" ?$,1 o(B)

 ("\\H{O}" ?$,1 p(B) ("\\HO" ?$,1 p(B)
 ("\\U{o}" ?$,1 q(B) ("\\Uo" ?$,1 q(B)
 ("{\\OE}" ?$,1 r(B) ("\\OE" ?$,1 r(B)
 ("{\\oe}" ?$,1 s(B) ("\\oe" ?$,1 s(B)
 ("\\'{R}" ?$,1 t(B) ("\\'R" ?$,1 t(B)
 ("\\'{r}" ?$,1 u(B) ("\\'r" ?$,1 u(B)
 ("\\c{R}" ?$,1 v(B) ("\\cR" ?$,1 v(B)
 ("\\c{r}" ?$,1 w(B) ("\\cr" ?$,1 w(B)
 ("\\v{R}" ?$,1 x(B) ("\\vR" ?$,1 x(B)
 ("\\v{r}" ?$,1 y(B) ("\\vr" ?$,1 y(B)
 ("\\'{S}" ?$,1 z(B) ("\\'S" ?$,1 z(B)
 ("\\'{s}" ?$,1 {(B) ("\\'s" ?$,1 {(B)
 ("\\^{S}" ?$,1 |(B) ("\\^S" ?$,1 |(B)
 ("\\^{s}" ?$,1 }(B) ("\\^s" ?$,1 }(B)
 ("\\c{S}" ?$,1 ~(B) ("\\cS" ?$,1 ~(B)
 ("\\c{s}" ?$,1 (B) ("\\cs" ?$,1 (B)

 ("\\v{S}" ?$,1! (B) ("\\vS" ?$,1! (B)
 ("\\v{s}" ?$,1!!(B) ("\\vs" ?$,1!!(B)
 ("\\c{T}" ?$,1!"(B) ("\\cT" ?$,1!"(B)
 ("\\c{t}" ?$,1!#(B) ("\\ct" ?$,1!#(B)
 ("\\v{T}" ?$,1!$(B) ("\\vT" ?$,1!$(B)
 ("\\v{t}" ?$,1!%(B) ("\\vt" ?$,1!%(B)
 ("\\~{U}" ?$,1!((B) ("\\~U" ?$,1!((B)
 ("\\~{u}" ?$,1!)(B) ("\\~u" ?$,1!)(B)
 ("\\={U}" ?$,1!*(B) ("\\=U" ?$,1!*(B)
 ("\\={u}" ?$,1!+(B) ("\\=u" ?$,1!+(B)
 ("\\u{U}" ?$,1!,(B) ("\\uU" ?$,1!,(B)
 ("\\u{u}" ?$,1!-(B) ("\\uu" ?$,1!-(B)

 ("\\H{U}" ?$,1!0(B) ("\\HU" ?$,1!0(B)
 ("\\H{u}" ?$,1!1(B) ("\\Hu" ?$,1!1(B)
 ("\\^{W}" ?$,1!4(B) ("\\^W" ?$,1!4(B)
 ("\\^{w}" ?$,1!5(B) ("\\^w" ?$,1!5(B)
 ("\\^{Y}" ?$,1!6(B) ("\\^Y" ?$,1!6(B)
 ("\\^{y}" ?$,1!7(B) ("\\^y" ?$,1!7(B)
 ("\\\"{Y}" ?$,1!8(B) ("\\\"Y" ?$,1!8(B)
 ("\\'{Z}" ?$,1!9(B) ("\\'Z" ?$,1!9(B)
 ("\\'{z}" ?$,1!:(B) ("\\'z" ?$,1!:(B)
 ("\\.{Z}" ?$,1!;(B) ("\\.Z" ?$,1!;(B)
 ("\\.{z}" ?$,1!<(B) ("\\.z" ?$,1!<(B)
 ("\\v{Z}" ?$,1!=(B) ("\\vZ" ?$,1!=(B)
 ("\\v{z}" ?$,1!>(B) ("\\vz" ?$,1!>(B)

 ("\\v{A}" ?$,1"-(B) ("\\vA" ?$,1"-(B)
 ("\\v{a}" ?$,1".(B) ("\\va" ?$,1".(B)
 ("\\v{I}" ?$,1"/(B) ("\\vI" ?$,1"/(B)
 ("\\v{\\i}" ?$,1"0(B) ("\\vi" ?$,1"0(B)
 ("\\v{O}" ?$,1"1(B) ("\\vO" ?$,1"1(B)
 ("\\v{o}" ?$,1"2(B) ("\\vo" ?$,1"2(B)
 ("\\v{U}" ?$,1"3(B) ("\\vU" ?$,1"3(B)
 ("\\v{u}" ?$,1"4(B) ("\\vu" ?$,1"4(B)

 ("\\={\\AE}" ?$,1"B(B) ("\\=\\AE" ?$,1"B(B)
 ("\\={\\ae}" ?$,1"C(B) ("\\=\\ae" ?$,1"C(B)
 ("\\v{G}" ?$,1"F(B) ("\\vG" ?$,1"F(B)
 ("\\v{g}" ?$,1"G(B) ("\\vg" ?$,1"G(B)
 ("\\v{K}" ?$,1"H(B) ("\\vK" ?$,1"H(B)
 ("\\v{k}" ?k) ("\\vk" ?k)

 ("\\v{\\j}" ?$,1"P(B) ("\\vj" ?$,1"P(B)
 ("\\'{G}" ?$,1"T(B) ("\\'G" ?$,1"T(B)
 ("\\'{g}" ?$,1"U(B) ("\\'g" ?$,1"U(B)
 ("\\`{N}" ?$,1"X(B) ("\\`N" ?$,1"X(B)
 ("\\`{n}" ?$,1"Y(B) ("\\`n" ?$,1"Y(B)
 ("\\'{\\AE}" ?$,1"\(B) ("\\'\\AE")
 ("\\'{\\ae}" ?$,1"](B) ("\\'\\ae" ?$,1"](B)
 ("\\'{\\O}" ?$,1"^(B) ("\\'\\O")
 ("\\'{\\o}" ?$,1"_(B) ("\\'\\o" ?$,1"_(B)

 ("\\v{H}" ?$,1"~(B) ("\\vH" ?$,1"~(B)
 ("\\v{h}" ?$,1"(B) ("\\vh" ?$,1"(B)
 ("\\.{A}" ?$,1#&(B) ("\\.A" ?$,1#&(B)
 ("\\.{a}" ?$,1#'(B) ("\\.a" ?$,1#'(B)
 ("\\c{E}" ?$,1#((B) ("\\cE" ?$,1#((B)
 ("\\c{e}" ?$,1#)(B) ("\\ce" ?$,1#)(B)
 ("\\.{O}" ?$,1#.(B) ("\\.O" ?$,1#.(B)
 ("\\.{o}" ?$,1#/(B) ("\\.o" ?$,1#/(B)
 ("\\={Y}" ?$,1#2(B) ("\\=Y" ?$,1#2(B)
 ("\\={y}" ?$,1#3(B) ("\\=y" ?$,1#3(B)

 ("\\v{}" ?$,1$g(B)
 ("\\u{}" ?$,1$x(B)
 ("\\.{}" ?$,1$y(B)
 ("\\~{}" ?$,1$|(B)
 ("\\H{}" ?$,1$}(B)
)
