;;; hangul.el --- Quail package for inputting Korean Hangul characters  -*-coding: iso-2022-7bit;-*-

;; Copyright (C) 1997 Electrotechnical Laboratory, JAPAN.
;; Licensed to the Free Software Foundation.

;; Keywords: multilingual, input method, Korean, Hangul

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;;; Code:

(require 'quail)
(require 'korea-util)

(quail-define-package
 "korean-hangul" "Korean" "$(CGQ(B2"
 '((?r . "$(C$!(B") (?s . "$(C$$(B") (?e . "$(C$'(B") (?f . "$(C$)(B") (?a . "$(C$1(B")
   (?q . "$(C$2(B") (?t . "$(C$5(B") (?d . "$(C$7(B") (?w . "$(C$8(B") (?c . "$(C$:(B")
   (?z . "$(C$;(B") (?x . "$(C$<(B") (?v . "$(C$=(B") (?g . "$(C$>(B")
   (?R . "$(C$"(B") (?E . "$(C$((B") (?Q . "$(C$3(B") (?W . "$(C$9(B") (?T . "$(C$6(B")
   (?O . "$(C$B(B") (?P . "$(C$F(B")
   (?k . "$(C$?(B") (?i . "$(C$A(B") (?j . "$(C$C(B") (?p . "$(C$D(B") (?u . "$(C$E(B") (?h . "$(C$G(B")
   (?y . "$(C$K(B") (?n . "$(C$L(B") (?b . "$(C$P(B") (?m . "$(C$Q(B") (?l . "$(C$S(B"))
 "$(CGQ1[(B 2$(C9z=D(B: Hangul input method with Hangul keyboard layout (KSC5601)
  $(CGQ1[(B:	$(C$!$"$$$'$($)$1$2$3$5$6$7$8$9$:$;$<$=$>$?$A$C$D$F$E$G$K$L$P$Q$S$@$B(B
  KEY:	r R s e E f a q Q t T d w W c z x v g k i j p P u h y n b m l o O

The key sequence \"Z<key>\" can be used for \"$(C#0(B..$(C#A(B..$(C#a(B..\".
The key sequence \"H<key-sequence>\" can be used for \"$(C$U$V(B...\".
The key sequnece \"S<key>\" can be used for such symbols as \"$(C!M!L"6(B...\".

You can use the key TAB to know the available key combination.
For instance, typing \"S\" followed by TAB will tell you
 which key you should type to input some specific symbol.
--- Example ---
<key sequence>		r	k	r	k
<string inserted>	$(C$!(B	$(C0!(B	$(C0"(B	$(C0!0!(B
<key sequence>		r	k	r	<C-SP>	k
<string inserted>	$(C$!(B	$(C0!(B	$(C0"(B	$(C0"(B	$(C0"$?(B"
 nil t t nil nil nil t)

(quail-define-rules
 ("r"	?$(C$!(B)
 ("s"	?$(C$$(B)
 ("e"	?$(C$'(B)
 ("f"	?$(C$)(B)
 ("a"	?$(C$1(B)
 ("q"	?$(C$2(B)
 ("t"	?$(C$5(B)
 ("d"	?$(C$7(B)
 ("w"	?$(C$8(B)
 ("c"	?$(C$:(B)
 ("z"	?$(C$;(B)
 ("x"	?$(C$<(B)
 ("v"	?$(C$=(B)
 ("g"	?$(C$>(B)
 
 ("R"	?$(C$"(B)
 ("E"	?$(C$((B)
 ("Q"	?$(C$3(B)
 ("W"	?$(C$9(B)
 ("T"	?$(C$6(B)
 ("P"	?$(C$F(B)
 
 ("k"	?$(C$?(B)
 ("i"	?$(C$A(B)
 ("j"	?$(C$C(B)
 ("p"	?$(C$D(B)
 ("u"	?$(C$E(B)
 ("h"	?$(C$G(B)
 ("y"	?$(C$K(B)
 ("n"	?$(C$L(B)
 ("b"	?$(C$P(B)
 ("m"	?$(C$Q(B)
 ("l"	?$(C$S(B)
 ("o"	?$(C$@(B)
 ("O"	?$(C$B(B)
 
 ("rk"	?$(C0!(B)
 ("rkr"	?$(C0"(B)
 ("rks"	?$(C0#(B)
 ("rke"	?$(C0$(B)
 ("rkf"	?$(C0%(B)
 ("rkfr"	?$(C0&(B)
 ("rkfa"	?$(C0'(B)
 ("rka"	?$(C0((B)
 ("rkq"	?$(C0)(B)
 ("rkqt"	?$(C0*(B)
 ("rkt"	?$(C0+(B)
 ("rkT"	?$(C0,(B)
 ("rkd"	?$(C0-(B)
 ("rkw"	?$(C0.(B)
 ("rkc"	?$(C0/(B)
 ("rkx"	?$(C00(B)
 ("rkv"	?$(C01(B)
 ("rkg"	?$(C02(B)
 ("ro"	?$(C03(B)
 ("ror"	?$(C04(B)
 ("ros"	?$(C05(B)
 ("rof"	?$(C06(B)
 ("roa"	?$(C07(B)
 ("roq"	?$(C08(B)
 ("rot"	?$(C09(B)
 ("roT"	?$(C0:(B)
 ("rod"	?$(C0;(B)
 ("ri"	?$(C0<(B)
 ("rir"	?$(C0=(B)
 ("ris"	?$(C0>(B)
 ("rif"	?$(C0?(B)
 ("rit"	?$(C0@(B)
 ("rid"	?$(C0A(B)
 ("rO"	?$(C0B(B)
 ("rOs"	?$(C0C(B)
 ("rOf"	?$(C0D(B)
 ("rj"	?$(C0E(B)
 ("rjr"	?$(C0F(B)
 ("rjs"	?$(C0G(B)
 ("rje"	?$(C0H(B)
 ("rjf"	?$(C0I(B)
 ("rjfa"	?$(C0J(B)
 ("rja"	?$(C0K(B)
 ("rjq"	?$(C0L(B)
 ("rjt"	?$(C0M(B)
 ("rjT"	?$(C0N(B)
 ("rjd"	?$(C0O(B)
 ("rjw"	?$(C0P(B)
 ("rjx"	?$(C0Q(B)
 ("rjv"	?$(C0R(B)
 ("rjg"	?$(C0S(B)
 ("rp"	?$(C0T(B)
 ("rps"	?$(C0U(B)
 ("rpf"	?$(C0V(B)
 ("rpa"	?$(C0W(B)
 ("rpq"	?$(C0X(B)
 ("rpt"	?$(C0Y(B)
 ("rpd"	?$(C0[(B)
 ("rpT"	?$(C0Z(B)
 ("ru"	?$(C0\(B)
 ("rur"	?$(C0](B)
 ("ruR"	?$(C0^(B)
 ("rus"	?$(C0_(B)
 ("rue"	?$(C0`(B)
 ("ruf"	?$(C0a(B)
 ("rua"	?$(C0b(B)
 ("ruq"	?$(C0c(B)
 ("rut"	?$(C0d(B)
 ("ruT"	?$(C0e(B)
 ("rud"	?$(C0f(B)
 ("rux"	?$(C0g(B)
 ("rP"	?$(C0h(B)
 ("rPs"	?$(C0i(B)
 ("rPf"	?$(C0j(B)
 ("rPq"	?$(C0k(B)
 ("rPt"	?$(C0l(B)
 ("rh"	?$(C0m(B)
 ("rhr"	?$(C0n(B)
 ("rhs"	?$(C0o(B)
 ("rhe"	?$(C0p(B)
 ("rhf"	?$(C0q(B)
 ("rhfa"	?$(C0r(B)
 ("rhft"	?$(C0s(B)
 ("rhfg"	?$(C0t(B)
 ("rha"	?$(C0u(B)
 ("rhq"	?$(C0v(B)
 ("rht"	?$(C0w(B)
 ("rhd"	?$(C0x(B)
 ("rhw"	?$(C0y(B)
 ("rhk"	?$(C0z(B)
 ("rhkr"	?$(C0{(B)
 ("rhks"	?$(C0|(B)
 ("rhkf"	?$(C0}(B)
 ("rhkfa"	?$(C0~(B)
 ("rhka"	?$(C1!(B)
 ("rhkq"	?$(C1"(B)
 ("rhkt"	?$(C1#(B)
 ("rhkd"	?$(C1$(B)
 ("rho"	?$(C1%(B)
 ("rhos"	?$(C1&(B)
 ("rhof"	?$(C1'(B)
 ("rhoq"	?$(C1((B)
 ("rhoT"	?$(C1)(B)
 ("rhod"	?$(C1*(B)
 ("rhl"	?$(C1+(B)
 ("rhlr"	?$(C1,(B)
 ("rhls"	?$(C1-(B)
 ("rhlf"	?$(C1.(B)
 ("rhla"	?$(C1/(B)
 ("rhlq"	?$(C10(B)
 ("rhlt"	?$(C11(B)
 ("rhld"	?$(C12(B)
 ("ry"	?$(C13(B)
 ("rys"	?$(C14(B)
 ("ryf"	?$(C15(B)
 ("ryq"	?$(C16(B)
 ("ryt"	?$(C17(B)
 ("rn"	?$(C18(B)
 ("rnr"	?$(C19(B)
 ("rns"	?$(C1:(B)
 ("rne"	?$(C1;(B)
 ("rnf"	?$(C1<(B)
 ("rnfr"	?$(C1=(B)
 ("rnfa"	?$(C1>(B)
 ("rnfg"	?$(C1?(B)
 ("rna"	?$(C1@(B)
 ("rnq"	?$(C1A(B)
 ("rnt"	?$(C1B(B)
 ("rnd"	?$(C1C(B)
 ("rnw"	?$(C1D(B)
 ("rnj"	?$(C1E(B)
 ("rnjr"	?$(C1F(B)
 ("rnjs"	?$(C1G(B)
 ("rnjf"	?$(C1H(B)
 ("rnjT"	?$(C1I(B)
 ("rnjd"	?$(C1J(B)
 ("rnp"	?$(C1K(B)
 ("rnpt"	?$(C1L(B)
 ("rnl"	?$(C1M(B)
 ("rnlr"	?$(C1N(B)
 ("rnls"	?$(C1O(B)
 ("rnlf"	?$(C1P(B)
 ("rnla"	?$(C1Q(B)
 ("rnlq"	?$(C1R(B)
 ("rnlt"	?$(C1S(B)
 ("rb"	?$(C1T(B)
 ("rbs"	?$(C1U(B)
 ("rbf"	?$(C1V(B)
 ("rm"	?$(C1W(B)
 ("rmr"	?$(C1X(B)
 ("rms"	?$(C1Y(B)
 ("rme"	?$(C1Z(B)
 ("rmf"	?$(C1[(B)
 ("rmfr"	?$(C1\(B)
 ("rma"	?$(C1](B)
 ("rmq"	?$(C1^(B)
 ("rmt"	?$(C1_(B)
 ("rmd"	?$(C1`(B)
 ("rml"	?$(C1a(B)
 ("rl"	?$(C1b(B)
 ("rlr"	?$(C1c(B)
 ("rls"	?$(C1d(B)
 ("rle"	?$(C1e(B)
 ("rlf"	?$(C1f(B)
 ("rlfa"	?$(C1g(B)
 ("rla"	?$(C1h(B)
 ("rlq"	?$(C1i(B)
 ("rlt"	?$(C1j(B)
 ("rld"	?$(C1k(B)
 ("rlw"	?$(C1l(B)
 ("rlv"	?$(C1m(B)
 ("Rk"	?$(C1n(B)
 ("Rkr"	?$(C1o(B)
 ("RkR"	?$(C1p(B)
 ("Rks"	?$(C1q(B)
 ("Rkf"	?$(C1r(B)
 ("Rkfa"	?$(C1s(B)
 ("Rka"	?$(C1t(B)
 ("Rkq"	?$(C1u(B)
 ("Rkt"	?$(C1v(B)
 ("RkT"	?$(C1w(B)
 ("Rkd"	?$(C1x(B)
 ("Rkx"	?$(C1y(B)
 ("Ro"	?$(C1z(B)
 ("Ror"	?$(C1{(B)
 ("Ros"	?$(C1|(B)
 ("Rof"	?$(C1}(B)
 ("Roa"	?$(C1~(B)
 ("Roq"	?$(C2!(B)
 ("Rot"	?$(C2"(B)
 ("RoT"	?$(C2#(B)
 ("Rod"	?$(C2$(B)
 ("Ri"	?$(C2%(B)
 ("Rir"	?$(C2&(B)
 ("Rif"	?$(C2'(B)
 ("Rj"	?$(C2((B)
 ("Rjr"	?$(C2)(B)
 ("RjR"	?$(C2*(B)
 ("Rjs"	?$(C2+(B)
 ("Rjf"	?$(C2,(B)
 ("Rja"	?$(C2-(B)
 ("Rjq"	?$(C2.(B)
 ("Rjt"	?$(C2/(B)
 ("RjT"	?$(C20(B)
 ("Rjd"	?$(C21(B)
 ("Rp"	?$(C22(B)
 ("Rpr"	?$(C23(B)
 ("Rps"	?$(C24(B)
 ("Rpa"	?$(C25(B)
 ("Rpt"	?$(C26(B)
 ("Rpd"	?$(C27(B)
 ("Ru"	?$(C28(B)
 ("Rus"	?$(C29(B)
 ("Ruf"	?$(C2:(B)
 ("Rut"	?$(C2;(B)
 ("RuT"	?$(C2<(B)
 ("Rux"	?$(C2=(B)
 ("RP"	?$(C2>(B)
 ("Rh"	?$(C2?(B)
 ("Rhr"	?$(C2@(B)
 ("Rhs"	?$(C2A(B)
 ("Rhsg"	?$(C2B(B)
 ("Rhf"	?$(C2C(B)
 ("Rha"	?$(C2D(B)
 ("Rhq"	?$(C2E(B)
 ("Rht"	?$(C2F(B)
 ("Rhd"	?$(C2G(B)
 ("Rhw"	?$(C2H(B)
 ("Rhc"	?$(C2I(B)
 ("Rhk"	?$(C2J(B)
 ("Rhkr"	?$(C2K(B)
 ("Rhkf"	?$(C2L(B)
 ("RhkT"	?$(C2M(B)
 ("Rhkd"	?$(C2N(B)
 ("Rho"	?$(C2O(B)
 ("Rhor"	?$(C2P(B)
 ("Rhod"	?$(C2Q(B)
 ("Rhl"	?$(C2R(B)
 ("Rhls"	?$(C2S(B)
 ("Rhlf"	?$(C2T(B)
 ("Rhla"	?$(C2U(B)
 ("Rhlq"	?$(C2V(B)
 ("Rhld"	?$(C2W(B)
 ("Ry"	?$(C2X(B)
 ("Rn"	?$(C2Y(B)
 ("Rnr"	?$(C2Z(B)
 ("Rns"	?$(C2[(B)
 ("Rnf"	?$(C2\(B)
 ("Rnfg"	?$(C2](B)
 ("Rna"	?$(C2^(B)
 ("Rnq"	?$(C2_(B)
 ("Rnt"	?$(C2`(B)
 ("Rnd"	?$(C2a(B)
 ("Rnw"	?$(C2b(B)
 ("Rnj"	?$(C2c(B)
 ("Rnjf"	?$(C2d(B)
 ("RnjT"	?$(C2e(B)
 ("Rnjd"	?$(C2f(B)
 ("Rnp"	?$(C2g(B)
 ("Rnpr"	?$(C2h(B)
 ("Rnps"	?$(C2i(B)
 ("Rnpf"	?$(C2j(B)
 ("Rnpa"	?$(C2k(B)
 ("Rnpq"	?$(C2l(B)
 ("RnpT"	?$(C2m(B)
 ("Rnl"	?$(C2n(B)
 ("Rnls"	?$(C2o(B)
 ("Rnlf"	?$(C2p(B)
 ("Rnla"	?$(C2q(B)
 ("Rnlq"	?$(C2r(B)
 ("Rb"	?$(C2s(B)
 ("Rm"	?$(C2t(B)
 ("Rmr"	?$(C2u(B)
 ("Rms"	?$(C2v(B)
 ("Rmsg"	?$(C2w(B)
 ("Rmf"	?$(C2x(B)
 ("Rmfa"	?$(C2y(B)
 ("Rmfg"	?$(C2z(B)
 ("Rma"	?$(C2{(B)
 ("Rmq"	?$(C2|(B)
 ("Rmt"	?$(C2}(B)
 ("Rmd"	?$(C2~(B)
 ("Rmx"	?$(C3!(B)
 ("Rl"	?$(C3"(B)
 ("Rlr"	?$(C3#(B)
 ("Rls"	?$(C3$(B)
 ("Rlf"	?$(C3%(B)
 ("Rla"	?$(C3&(B)
 ("Rlq"	?$(C3'(B)
 ("Rlt"	?$(C3((B)
 ("Rld"	?$(C3)(B)
 ("sk"	?$(C3*(B)
 ("skr"	?$(C3+(B)
 ("skR"	?$(C3,(B)
 ("sks"	?$(C3-(B)
 ("ske"	?$(C3.(B)
 ("skf"	?$(C3/(B)
 ("skfr"	?$(C30(B)
 ("skfa"	?$(C31(B)
 ("ska"	?$(C32(B)
 ("skq"	?$(C33(B)
 ("skt"	?$(C34(B)
 ("skT"	?$(C35(B)
 ("skd"	?$(C36(B)
 ("skw"	?$(C37(B)
 ("skc"	?$(C38(B)
 ("skx"	?$(C39(B)
 ("skg"	?$(C3:(B)
 ("so"	?$(C3;(B)
 ("sor"	?$(C3<(B)
 ("sos"	?$(C3=(B)
 ("sof"	?$(C3>(B)
 ("soa"	?$(C3?(B)
 ("soq"	?$(C3@(B)
 ("sot"	?$(C3A(B)
 ("soT"	?$(C3B(B)
 ("sod"	?$(C3C(B)
 ("si"	?$(C3D(B)
 ("sir"	?$(C3E(B)
 ("sis"	?$(C3F(B)
 ("sif"	?$(C3G(B)
 ("sia"	?$(C3H(B)
 ("sid"	?$(C3I(B)
 ("sj"	?$(C3J(B)
 ("sjr"	?$(C3K(B)
 ("sjrt"	?$(C3L(B)
 ("sjs"	?$(C3M(B)
 ("sjf"	?$(C3N(B)
 ("sjfa"	?$(C3O(B)
 ("sjfq"	?$(C3P(B)
 ("sja"	?$(C3Q(B)
 ("sjq"	?$(C3R(B)
 ("sjt"	?$(C3S(B)
 ("sjT"	?$(C3T(B)
 ("sjd"	?$(C3U(B)
 ("sjg"	?$(C3V(B)
 ("sp"	?$(C3W(B)
 ("spr"	?$(C3X(B)
 ("sps"	?$(C3Y(B)
 ("spf"	?$(C3Z(B)
 ("spa"	?$(C3[(B)
 ("spq"	?$(C3\(B)
 ("spt"	?$(C3](B)
 ("spT"	?$(C3^(B)
 ("spd"	?$(C3_(B)
 ("su"	?$(C3`(B)
 ("sur"	?$(C3a(B)
 ("sus"	?$(C3b(B)
 ("suf"	?$(C3c(B)
 ("sua"	?$(C3d(B)
 ("suq"	?$(C3e(B)
 ("suT"	?$(C3f(B)
 ("sud"	?$(C3g(B)
 ("suz"	?$(C3h(B)
 ("sP"	?$(C3i(B)
 ("sPs"	?$(C3j(B)
 ("sh"	?$(C3k(B)
 ("shr"	?$(C3l(B)
 ("shs"	?$(C3m(B)
 ("shf"	?$(C3n(B)
 ("shfa"	?$(C3o(B)
 ("sha"	?$(C3p(B)
 ("shq"	?$(C3q(B)
 ("sht"	?$(C3r(B)
 ("shd"	?$(C3s(B)
 ("shv"	?$(C3t(B)
 ("shg"	?$(C3u(B)
 ("shk"	?$(C3v(B)
 ("shks"	?$(C3w(B)
 ("shkf"	?$(C3x(B)
 ("shkT"	?$(C3y(B)
 ("shl"	?$(C3z(B)
 ("shls"	?$(C3{(B)
 ("shlf"	?$(C3|(B)
 ("shla"	?$(C3}(B)
 ("shlq"	?$(C3~(B)
 ("shlt"	?$(C4!(B)
 ("sy"	?$(C4"(B)
 ("syr"	?$(C4#(B)
 ("sys"	?$(C4$(B)
 ("syf"	?$(C4%(B)
 ("syq"	?$(C4&(B)
 ("syt"	?$(C4'(B)
 ("syd"	?$(C4((B)
 ("sn"	?$(C4)(B)
 ("snr"	?$(C4*(B)
 ("sns"	?$(C4+(B)
 ("sne"	?$(C4,(B)
 ("snf"	?$(C4-(B)
 ("sna"	?$(C4.(B)
 ("snq"	?$(C4/(B)
 ("snt"	?$(C40(B)
 ("snd"	?$(C41(B)
 ("snj"	?$(C42(B)
 ("snjT"	?$(C43(B)
 ("snp"	?$(C44(B)
 ("snl"	?$(C45(B)
 ("snls"	?$(C46(B)
 ("snlf"	?$(C47(B)
 ("snla"	?$(C48(B)
 ("snlq"	?$(C49(B)
 ("sb"	?$(C4:(B)
 ("sbr"	?$(C4;(B)
 ("sbf"	?$(C4<(B)
 ("sba"	?$(C4=(B)
 ("sbq"	?$(C4>(B)
 ("sbd"	?$(C4?(B)
 ("sm"	?$(C4@(B)
 ("smr"	?$(C4A(B)
 ("sms"	?$(C4B(B)
 ("smf"	?$(C4C(B)
 ("smfr"	?$(C4D(B)
 ("smfa"	?$(C4E(B)
 ("sma"	?$(C4F(B)
 ("smq"	?$(C4G(B)
 ("smt"	?$(C4H(B)
 ("smd"	?$(C4I(B)
 ("smw"	?$(C4J(B)
 ("smv"	?$(C4K(B)
 ("sml"	?$(C4L(B)
 ("smls"	?$(C4M(B)
 ("smlf"	?$(C4N(B)
 ("sl"	?$(C4O(B)
 ("slr"	?$(C4P(B)
 ("sls"	?$(C4Q(B)
 ("slf"	?$(C4R(B)
 ("slfa"	?$(C4S(B)
 ("sla"	?$(C4T(B)
 ("slq"	?$(C4U(B)
 ("slt"	?$(C4V(B)
 ("sld"	?$(C4W(B)
 ("slv"	?$(C4X(B)
 ("ek"	?$(C4Y(B)
 ("ekr"	?$(C4Z(B)
 ("ekR"	?$(C4[(B)
 ("eks"	?$(C4\(B)
 ("eke"	?$(C4](B)
 ("ekf"	?$(C4^(B)
 ("ekfr"	?$(C4_(B)
 ("ekfa"	?$(C4`(B)
 ("ekfq"	?$(C4a(B)
 ("ekfg"	?$(C4b(B)
 ("eka"	?$(C4c(B)
 ("ekq"	?$(C4d(B)
 ("ekt"	?$(C4e(B)
 ("ekT"	?$(C4f(B)
 ("ekd"	?$(C4g(B)
 ("ekw"	?$(C4h(B)
 ("ekc"	?$(C4i(B)
 ("ekg"	?$(C4j(B)
 ("eo"	?$(C4k(B)
 ("eor"	?$(C4l(B)
 ("eos"	?$(C4m(B)
 ("eof"	?$(C4n(B)
 ("eoa"	?$(C4o(B)
 ("eoq"	?$(C4p(B)
 ("eot"	?$(C4q(B)
 ("eoT"	?$(C4r(B)
 ("eod"	?$(C4s(B)
 ("ei"	?$(C4t(B)
 ("ej"	?$(C4u(B)
 ("ejr"	?$(C4v(B)
 ("ejR"	?$(C4w(B)
 ("ejs"	?$(C4x(B)
 ("eje"	?$(C4y(B)
 ("ejf"	?$(C4z(B)
 ("ejfa"	?$(C4{(B)
 ("ejfq"	?$(C4|(B)
 ("eja"	?$(C4}(B)
 ("ejq"	?$(C4~(B)
 ("ejt"	?$(C5!(B)
 ("ejd"	?$(C5"(B)
 ("ejc"	?$(C5#(B)
 ("ejv"	?$(C5$(B)
 ("ep"	?$(C5%(B)
 ("epr"	?$(C5&(B)
 ("eps"	?$(C5'(B)
 ("epf"	?$(C5((B)
 ("epa"	?$(C5)(B)
 ("epq"	?$(C5*(B)
 ("ept"	?$(C5+(B)
 ("epT"	?$(C5,(B)
 ("epd"	?$(C5-(B)
 ("eu"	?$(C5.(B)
 ("eus"	?$(C5/(B)
 ("euf"	?$(C50(B)
 ("euT"	?$(C51(B)
 ("eud"	?$(C52(B)
 ("eP"	?$(C53(B)
 ("ePs"	?$(C54(B)
 ("eh"	?$(C55(B)
 ("ehr"	?$(C56(B)
 ("ehs"	?$(C57(B)
 ("ehe"	?$(C58(B)
 ("ehf"	?$(C59(B)
 ("ehfa"	?$(C5:(B)
 ("ehft"	?$(C5;(B)
 ("eha"	?$(C5<(B)
 ("ehq"	?$(C5=(B)
 ("eht"	?$(C5>(B)
 ("ehd"	?$(C5?(B)
 ("ehc"	?$(C5@(B)
 ("ehx"	?$(C5A(B)
 ("ehk"	?$(C5B(B)
 ("ehks"	?$(C5C(B)
 ("ehkf"	?$(C5D(B)
 ("eho"	?$(C5E(B)
 ("ehoT"	?$(C5F(B)
 ("ehl"	?$(C5G(B)
 ("ehls"	?$(C5H(B)
 ("ehlf"	?$(C5I(B)
 ("ehla"	?$(C5J(B)
 ("ehlq"	?$(C5K(B)
 ("ehlt"	?$(C5L(B)
 ("ey"	?$(C5M(B)
 ("en"	?$(C5N(B)
 ("enr"	?$(C5O(B)
 ("ens"	?$(C5P(B)
 ("enf"	?$(C5Q(B)
 ("ena"	?$(C5R(B)
 ("enq"	?$(C5S(B)
 ("ent"	?$(C5T(B)
 ("end"	?$(C5U(B)
 ("enj"	?$(C5V(B)
 ("enjT"	?$(C5W(B)
 ("enp"	?$(C5X(B)
 ("enpd"	?$(C5Y(B)
 ("enl"	?$(C5Z(B)
 ("enls"	?$(C5[(B)
 ("enlf"	?$(C5\(B)
 ("enlq"	?$(C5](B)
 ("enlt"	?$(C5^(B)
 ("enld"	?$(C5_(B)
 ("eb"	?$(C5`(B)
 ("ebs"	?$(C5a(B)
 ("ebf"	?$(C5b(B)
 ("eba"	?$(C5c(B)
 ("ebd"	?$(C5d(B)
 ("em"	?$(C5e(B)
 ("emr"	?$(C5f(B)
 ("ems"	?$(C5g(B)
 ("eme"	?$(C5h(B)
 ("emf"	?$(C5i(B)
 ("emfa"	?$(C5j(B)
 ("ema"	?$(C5k(B)
 ("emq"	?$(C5l(B)
 ("emt"	?$(C5m(B)
 ("emd"	?$(C5n(B)
 ("eml"	?$(C5o(B)
 ("el"	?$(C5p(B)
 ("elr"	?$(C5q(B)
 ("els"	?$(C5r(B)
 ("ele"	?$(C5s(B)
 ("elf"	?$(C5t(B)
 ("ela"	?$(C5u(B)
 ("elq"	?$(C5v(B)
 ("elt"	?$(C5w(B)
 ("elT"	?$(C5x(B)
 ("eld"	?$(C5y(B)
 ("elw"	?$(C5z(B)
 ("Ek"	?$(C5{(B)
 ("Ekr"	?$(C5|(B)
 ("Eks"	?$(C5}(B)
 ("Ekf"	?$(C5~(B)
 ("Eka"	?$(C6!(B)
 ("Ekq"	?$(C6"(B)
 ("Ekt"	?$(C6#(B)
 ("EkT"	?$(C6$(B)
 ("Ekd"	?$(C6%(B)
 ("Ekg"	?$(C6&(B)
 ("Eo"	?$(C6'(B)
 ("Eor"	?$(C6((B)
 ("Eos"	?$(C6)(B)
 ("Eof"	?$(C6*(B)
 ("Eoa"	?$(C6+(B)
 ("Eoq"	?$(C6,(B)
 ("Eot"	?$(C6-(B)
 ("EoT"	?$(C6.(B)
 ("Eod"	?$(C6/(B)
 ("Ej"	?$(C60(B)
 ("Ejr"	?$(C61(B)
 ("Ejs"	?$(C62(B)
 ("Ejf"	?$(C63(B)
 ("Ejfa"	?$(C64(B)
 ("Ejfq"	?$(C65(B)
 ("Eja"	?$(C66(B)
 ("Ejq"	?$(C67(B)
 ("Ejt"	?$(C68(B)
 ("EjT"	?$(C69(B)
 ("Ejd"	?$(C6:(B)
 ("Ejg"	?$(C6;(B)
 ("Ep"	?$(C6<(B)
 ("Epr"	?$(C6=(B)
 ("Eps"	?$(C6>(B)
 ("Epf"	?$(C6?(B)
 ("Epa"	?$(C6@(B)
 ("Epq"	?$(C6A(B)
 ("Ept"	?$(C6B(B)
 ("EpT"	?$(C6C(B)
 ("Epd"	?$(C6D(B)
 ("Eu"	?$(C6E(B)
 ("EuT"	?$(C6F(B)
 ("Eh"	?$(C6G(B)
 ("Ehr"	?$(C6H(B)
 ("Ehs"	?$(C6I(B)
 ("Ehf"	?$(C6J(B)
 ("Ehd"	?$(C6K(B)
 ("Ehk"	?$(C6L(B)
 ("Ehkf"	?$(C6M(B)
 ("Eho"	?$(C6N(B)
 ("Ehl"	?$(C6O(B)
 ("Ehls"	?$(C6P(B)
 ("En"	?$(C6Q(B)
 ("Enr"	?$(C6R(B)
 ("Ens"	?$(C6S(B)
 ("Enf"	?$(C6T(B)
 ("Enfg"	?$(C6U(B)
 ("Ena"	?$(C6V(B)
 ("End"	?$(C6W(B)
 ("Enp"	?$(C6X(B)
 ("Enl"	?$(C6Y(B)
 ("Enls"	?$(C6Z(B)
 ("Enlf"	?$(C6[(B)
 ("Enla"	?$(C6\(B)
 ("Enlq"	?$(C6](B)
 ("Enld"	?$(C6^(B)
 ("Em"	?$(C6_(B)
 ("Emr"	?$(C6`(B)
 ("Ems"	?$(C6a(B)
 ("Eme"	?$(C6b(B)
 ("Emf"	?$(C6c(B)
 ("Ema"	?$(C6d(B)
 ("Emq"	?$(C6e(B)
 ("Emt"	?$(C6f(B)
 ("Eml"	?$(C6g(B)
 ("Emls"	?$(C6h(B)
 ("Emlf"	?$(C6i(B)
 ("Emla"	?$(C6j(B)
 ("Emlq"	?$(C6k(B)
 ("El"	?$(C6l(B)
 ("Els"	?$(C6m(B)
 ("Elf"	?$(C6n(B)
 ("Ela"	?$(C6o(B)
 ("Elq"	?$(C6p(B)
 ("Elt"	?$(C6q(B)
 ("Eld"	?$(C6r(B)
 ("fk"	?$(C6s(B)
 ("fkr"	?$(C6t(B)
 ("fks"	?$(C6u(B)
 ("fkf"	?$(C6v(B)
 ("fka"	?$(C6w(B)
 ("fkq"	?$(C6x(B)
 ("fkt"	?$(C6y(B)
 ("fkT"	?$(C6z(B)
 ("fkd"	?$(C6{(B)
 ("fkw"	?$(C6|(B)
 ("fkv"	?$(C6}(B)
 ("fkg"	?$(C6~(B)
 ("fo"	?$(C7!(B)
 ("for"	?$(C7"(B)
 ("fos"	?$(C7#(B)
 ("fof"	?$(C7$(B)
 ("foa"	?$(C7%(B)
 ("foq"	?$(C7&(B)
 ("fot"	?$(C7'(B)
 ("foT"	?$(C7((B)
 ("fod"	?$(C7)(B)
 ("fi"	?$(C7*(B)
 ("fir"	?$(C7+(B)
 ("fis"	?$(C7,(B)
 ("fit"	?$(C7-(B)
 ("fid"	?$(C7.(B)
 ("fj"	?$(C7/(B)
 ("fjr"	?$(C70(B)
 ("fjs"	?$(C71(B)
 ("fjf"	?$(C72(B)
 ("fja"	?$(C73(B)
 ("fjq"	?$(C74(B)
 ("fjt"	?$(C75(B)
 ("fjT"	?$(C76(B)
 ("fjd"	?$(C77(B)
 ("fjg"	?$(C78(B)
 ("fp"	?$(C79(B)
 ("fpr"	?$(C7:(B)
 ("fps"	?$(C7;(B)
 ("fpf"	?$(C7<(B)
 ("fpa"	?$(C7=(B)
 ("fpq"	?$(C7>(B)
 ("fpt"	?$(C7?(B)
 ("fpd"	?$(C7@(B)
 ("fu"	?$(C7A(B)
 ("fur"	?$(C7B(B)
 ("fus"	?$(C7C(B)
 ("fuf"	?$(C7D(B)
 ("fua"	?$(C7E(B)
 ("fuq"	?$(C7F(B)
 ("fut"	?$(C7G(B)
 ("fuT"	?$(C7H(B)
 ("fud"	?$(C7I(B)
 ("fP"	?$(C7J(B)
 ("fPs"	?$(C7K(B)
 ("fPq"	?$(C7L(B)
 ("fPt"	?$(C7M(B)
 ("fh"	?$(C7N(B)
 ("fhr"	?$(C7O(B)
 ("fhs"	?$(C7P(B)
 ("fhf"	?$(C7Q(B)
 ("fha"	?$(C7R(B)
 ("fhq"	?$(C7S(B)
 ("fht"	?$(C7T(B)
 ("fhd"	?$(C7U(B)
 ("fhk"	?$(C7V(B)
 ("fhks"	?$(C7W(B)
 ("fhkd"	?$(C7X(B)
 ("fhoT"	?$(C7Y(B)
 ("fhl"	?$(C7Z(B)
 ("fhls"	?$(C7[(B)
 ("fhlf"	?$(C7\(B)
 ("fhla"	?$(C7](B)
 ("fhlq"	?$(C7^(B)
 ("fhlt"	?$(C7_(B)
 ("fhld"	?$(C7`(B)
 ("fy"	?$(C7a(B)
 ("fys"	?$(C7b(B)
 ("fyf"	?$(C7c(B)
 ("fyq"	?$(C7d(B)
 ("fyt"	?$(C7e(B)
 ("fyd"	?$(C7f(B)
 ("fn"	?$(C7g(B)
 ("fnr"	?$(C7h(B)
 ("fns"	?$(C7i(B)
 ("fnf"	?$(C7j(B)
 ("fna"	?$(C7k(B)
 ("fnq"	?$(C7l(B)
 ("fnt"	?$(C7m(B)
 ("fnd"	?$(C7n(B)
 ("fnj"	?$(C7o(B)
 ("fnjT"	?$(C7p(B)
 ("fnp"	?$(C7q(B)
 ("fnl"	?$(C7r(B)
 ("fnlr"	?$(C7s(B)
 ("fnls"	?$(C7t(B)
 ("fnlf"	?$(C7u(B)
 ("fnla"	?$(C7v(B)
 ("fnlt"	?$(C7w(B)
 ("fnld"	?$(C7x(B)
 ("fb"	?$(C7y(B)
 ("fbr"	?$(C7z(B)
 ("fbs"	?$(C7{(B)
 ("fbf"	?$(C7|(B)
 ("fba"	?$(C7}(B)
 ("fbq"	?$(C7~(B)
 ("fbt"	?$(C8!(B)
 ("fbd"	?$(C8"(B)
 ("fm"	?$(C8#(B)
 ("fmr"	?$(C8$(B)
 ("fms"	?$(C8%(B)
 ("fmf"	?$(C8&(B)
 ("fma"	?$(C8'(B)
 ("fmq"	?$(C8((B)
 ("fmt"	?$(C8)(B)
 ("fmd"	?$(C8*(B)
 ("fmw"	?$(C8+(B)
 ("fmx"	?$(C8,(B)
 ("fmv"	?$(C8-(B)
 ("fl"	?$(C8.(B)
 ("flr"	?$(C8/(B)
 ("fls"	?$(C80(B)
 ("flf"	?$(C81(B)
 ("fla"	?$(C82(B)
 ("flq"	?$(C83(B)
 ("flt"	?$(C84(B)
 ("fld"	?$(C85(B)
 ("ak"	?$(C86(B)
 ("akr"	?$(C87(B)
 ("aks"	?$(C88(B)
 ("aksg"	?$(C89(B)
 ("ake"	?$(C8:(B)
 ("akf"	?$(C8;(B)
 ("akfr"	?$(C8<(B)
 ("akfa"	?$(C8=(B)
 ("aka"	?$(C8>(B)
 ("akq"	?$(C8?(B)
 ("akt"	?$(C8@(B)
 ("akd"	?$(C8A(B)
 ("akw"	?$(C8B(B)
 ("akx"	?$(C8C(B)
 ("akg"	?$(C8D(B)
 ("ao"	?$(C8E(B)
 ("aor"	?$(C8F(B)
 ("aos"	?$(C8G(B)
 ("aof"	?$(C8H(B)
 ("aoa"	?$(C8I(B)
 ("aoq"	?$(C8J(B)
 ("aot"	?$(C8K(B)
 ("aoT"	?$(C8L(B)
 ("aod"	?$(C8M(B)
 ("aow"	?$(C8N(B)
 ("ai"	?$(C8O(B)
 ("air"	?$(C8P(B)
 ("aif"	?$(C8Q(B)
 ("aid"	?$(C8R(B)
 ("aj"	?$(C8S(B)
 ("ajr"	?$(C8T(B)
 ("ajs"	?$(C8U(B)
 ("ajf"	?$(C8V(B)
 ("ajfa"	?$(C8W(B)
 ("aja"	?$(C8X(B)
 ("ajq"	?$(C8Y(B)
 ("ajt"	?$(C8Z(B)
 ("ajd"	?$(C8[(B)
 ("ajw"	?$(C8\(B)
 ("ajg"	?$(C8](B)
 ("ap"	?$(C8^(B)
 ("apr"	?$(C8_(B)
 ("aps"	?$(C8`(B)
 ("apf"	?$(C8a(B)
 ("apa"	?$(C8b(B)
 ("apq"	?$(C8c(B)
 ("apt"	?$(C8d(B)
 ("apT"	?$(C8e(B)
 ("apd"	?$(C8f(B)
 ("au"	?$(C8g(B)
 ("aur"	?$(C8h(B)
 ("aus"	?$(C8i(B)
 ("auf"	?$(C8j(B)
 ("aut"	?$(C8k(B)
 ("auT"	?$(C8l(B)
 ("aud"	?$(C8m(B)
 ("auc"	?$(C8n(B)
 ("aP"	?$(C8o(B)
 ("ah"	?$(C8p(B)
 ("ahr"	?$(C8q(B)
 ("ahrt"	?$(C8r(B)
 ("ahs"	?$(C8s(B)
 ("ahf"	?$(C8t(B)
 ("ahfa"	?$(C8u(B)
 ("aha"	?$(C8v(B)
 ("ahq"	?$(C8w(B)
 ("aht"	?$(C8x(B)
 ("ahd"	?$(C8y(B)
 ("ahk"	?$(C8z(B)
 ("ahks"	?$(C8{(B)
 ("ahkT"	?$(C8|(B)
 ("ahkd"	?$(C8}(B)
 ("ahl"	?$(C8~(B)
 
 ("ahls"	?$(C9!(B)
 ("ahlf"	?$(C9"(B)
 ("ahlq"	?$(C9#(B)
 ("ahlt"	?$(C9$(B)
 ("ahld"	?$(C9%(B)
 ("ay"	?$(C9&(B)
 ("ays"	?$(C9'(B)
 ("ayf"	?$(C9((B)
 ("ayq"	?$(C9)(B)
 ("ayt"	?$(C9*(B)
 ("an"	?$(C9+(B)
 ("anr"	?$(C9,(B)
 ("anR"	?$(C9-(B)
 ("ans"	?$(C9.(B)
 ("ane"	?$(C9/(B)
 ("anf"	?$(C90(B)
 ("anfr"	?$(C91(B)
 ("anfa"	?$(C92(B)
 ("ana"	?$(C93(B)
 ("anq"	?$(C94(B)
 ("ant"	?$(C95(B)
 ("and"	?$(C96(B)
 ("anx"	?$(C97(B)
 ("ang"	?$(C98(B)
 ("anj"	?$(C99(B)
 ("anjs"	?$(C9:(B)
 ("anjf"	?$(C9;(B)
 ("anjq"	?$(C9<(B)
 ("anjt"	?$(C9=(B)
 ("anp"	?$(C9>(B)
 ("anl"	?$(C9?(B)
 ("anls"	?$(C9@(B)
 ("anlf"	?$(C9A(B)
 ("ab"	?$(C9B(B)
 
 ("abs"	?$(C9C(B)
 ("abf"	?$(C9D(B)
 ("aba"	?$(C9E(B)
 ("abt"	?$(C9F(B)
 ("am"	?$(C9G(B)
 ("ams"	?$(C9H(B)
 ("amf"	?$(C9I(B)
 ("ama"	?$(C9J(B)
 ("amt"	?$(C9K(B)
 ("al"	?$(C9L(B)
 ("alr"	?$(C9M(B)
 ("als"	?$(C9N(B)
 ("ale"	?$(C9O(B)
 ("alf"	?$(C9P(B)
 ("alfa"	?$(C9Q(B)
 ("ala"	?$(C9R(B)
 ("alq"	?$(C9S(B)
 ("alt"	?$(C9T(B)
 ("alT"	?$(C9U(B)
 ("ald"	?$(C9V(B)
 ("alc"	?$(C9W(B)
 ("alx"	?$(C9X(B)
 ("qk"	?$(C9Y(B)
 ("qkr"	?$(C9Z(B)
 ("qkR"	?$(C9[(B)
 ("qkrt"	?$(C9\(B)
 ("qks"	?$(C9](B)
 ("qke"	?$(C9^(B)
 ("qkf"	?$(C9_(B)
 ("qkfr"	?$(C9`(B)
 ("qkfa"	?$(C9a(B)
 ("qkfq"	?$(C9b(B)
 ("qka"	?$(C9c(B)
 ("qkq"	?$(C9d(B)
 ("qkt"	?$(C9e(B)
 ("qkd"	?$(C9f(B)
 ("qkx"	?$(C9g(B)
 ("qo"	?$(C9h(B)
 ("qor"	?$(C9i(B)
 ("qos"	?$(C9j(B)
 ("qof"	?$(C9k(B)
 ("qoa"	?$(C9l(B)
 ("qoq"	?$(C9m(B)
 ("qot"	?$(C9n(B)
 ("qoT"	?$(C9o(B)
 ("qod"	?$(C9p(B)
 ("qox"	?$(C9q(B)
 ("qi"	?$(C9r(B)
 ("qir"	?$(C9s(B)
 ("qis"	?$(C9t(B)
 ("qiq"	?$(C9u(B)
 ("qj"	?$(C9v(B)
 ("qjr"	?$(C9w(B)
 ("qjs"	?$(C9x(B)
 ("qje"	?$(C9y(B)
 ("qjf"	?$(C9z(B)
 ("qjfa"	?$(C9{(B)
 ("qja"	?$(C9|(B)
 ("qjq"	?$(C9}(B)
 ("qjt"	?$(C9~(B)
 ("qjd"	?$(C:!(B)
 ("qjw"	?$(C:"(B)
 ("qp"	?$(C:#(B)
 ("qpr"	?$(C:$(B)
 ("qps"	?$(C:%(B)
 ("qpe"	?$(C:&(B)
 ("qpf"	?$(C:'(B)
 ("qpa"	?$(C:((B)
 ("qpq"	?$(C:)(B)
 ("qpt"	?$(C:*(B)
 ("qpT"	?$(C:+(B)
 ("qpd"	?$(C:,(B)
 ("qu"	?$(C:-(B)
 ("qur"	?$(C:.(B)
 ("qus"	?$(C:/(B)
 ("quf"	?$(C:0(B)
 ("quq"	?$(C:1(B)
 ("qut"	?$(C:2(B)
 ("quT"	?$(C:3(B)
 ("qud"	?$(C:4(B)
 ("qux"	?$(C:5(B)
 ("qP"	?$(C:6(B)
 ("qPs"	?$(C:7(B)
 ("qh"	?$(C:8(B)
 ("qhr"	?$(C:9(B)
 ("qhR"	?$(C::(B)
 ("qhs"	?$(C:;(B)
 ("qhf"	?$(C:<(B)
 ("qha"	?$(C:=(B)
 ("qhq"	?$(C:>(B)
 ("qht"	?$(C:?(B)
 ("qhd"	?$(C:@(B)
 ("qhk"	?$(C:A(B)
 ("qhks"	?$(C:B(B)
 ("qhkT"	?$(C:C(B)
 ("qho"	?$(C:D(B)
 ("qhoT"	?$(C:E(B)
 ("qhl"	?$(C:F(B)
 ("qhlr"	?$(C:G(B)
 ("qhls"	?$(C:H(B)
 ("qhlf"	?$(C:I(B)
 ("qhla"	?$(C:J(B)
 ("qhlq"	?$(C:K(B)
 ("qy"	?$(C:L(B)
 ("qys"	?$(C:M(B)
 ("qn"	?$(C:N(B)
 ("qnr"	?$(C:O(B)
 ("qns"	?$(C:P(B)
 ("qne"	?$(C:Q(B)
 ("qnf"	?$(C:R(B)
 ("qnfr"	?$(C:S(B)
 ("qnfa"	?$(C:T(B)
 ("qna"	?$(C:U(B)
 ("qnq"	?$(C:V(B)
 ("qnt"	?$(C:W(B)
 ("qnd"	?$(C:X(B)
 ("qnx"	?$(C:Y(B)
 ("qnv"	?$(C:Z(B)
 ("qnj"	?$(C:[(B)
 ("qnjf"	?$(C:\(B)
 ("qnjT"	?$(C:](B)
 ("qnp"	?$(C:^(B)
 ("qnl"	?$(C:_(B)
 ("qnlr"	?$(C:`(B)
 ("qnls"	?$(C:a(B)
 ("qnlf"	?$(C:b(B)
 ("qnld"	?$(C:c(B)
 ("qb"	?$(C:d(B)
 ("qbs"	?$(C:e(B)
 ("qbf"	?$(C:f(B)
 ("qba"	?$(C:g(B)
 ("qbt"	?$(C:h(B)
 ("qbd"	?$(C:i(B)
 ("qm"	?$(C:j(B)
 ("qmr"	?$(C:k(B)
 ("qms"	?$(C:l(B)
 ("qmf"	?$(C:m(B)
 ("qma"	?$(C:n(B)
 ("qmq"	?$(C:o(B)
 ("qmt"	?$(C:p(B)
 ("ql"	?$(C:q(B)
 ("qlr"	?$(C:r(B)
 ("qls"	?$(C:s(B)
 ("qlf"	?$(C:t(B)
 ("qlfa"	?$(C:u(B)
 ("qla"	?$(C:v(B)
 ("qlq"	?$(C:w(B)
 ("qlt"	?$(C:x(B)
 ("qld"	?$(C:y(B)
 ("qlw"	?$(C:z(B)
 ("qlc"	?$(C:{(B)
 ("Qk"	?$(C:|(B)
 ("Qkr"	?$(C:}(B)
 ("Qks"	?$(C:~(B)
 ("Qkf"	?$(C;!(B)
 ("Qkfa"	?$(C;"(B)
 ("Qka"	?$(C;#(B)
 ("Qkq"	?$(C;$(B)
 ("Qkt"	?$(C;%(B)
 ("QkT"	?$(C;&(B)
 ("Qkd"	?$(C;'(B)
 ("Qkg"	?$(C;((B)
 ("Qo"	?$(C;)(B)
 ("Qor"	?$(C;*(B)
 ("Qos"	?$(C;+(B)
 ("Qof"	?$(C;,(B)
 ("Qoa"	?$(C;-(B)
 ("Qoq"	?$(C;.(B)
 ("Qot"	?$(C;/(B)
 ("QoT"	?$(C;0(B)
 ("Qod"	?$(C;1(B)
 ("Qi"	?$(C;2(B)
 ("Qir"	?$(C;3(B)
 ("Qia"	?$(C;4(B)
 ("Qj"	?$(C;5(B)
 ("Qjr"	?$(C;6(B)
 ("Qjs"	?$(C;7(B)
 ("Qje"	?$(C;8(B)
 ("Qjf"	?$(C;9(B)
 ("Qja"	?$(C;:(B)
 ("Qjt"	?$(C;;(B)
 ("QjT"	?$(C;<(B)
 ("Qjd"	?$(C;=(B)
 ("Qp"	?$(C;>(B)
 ("Qpd"	?$(C;?(B)
 ("Qu"	?$(C;@(B)
 ("Qur"	?$(C;A(B)
 ("Qua"	?$(C;B(B)
 ("Quq"	?$(C;C(B)
 ("Qut"	?$(C;D(B)
 ("QuT"	?$(C;E(B)
 ("Qud"	?$(C;F(B)
 ("Qh"	?$(C;G(B)
 ("Qhr"	?$(C;H(B)
 ("Qhs"	?$(C;I(B)
 ("Qhf"	?$(C;J(B)
 ("Qha"	?$(C;K(B)
 ("Qhq"	?$(C;L(B)
 ("Qhd"	?$(C;M(B)
 ("Qhl"	?$(C;N(B)
 ("Qy"	?$(C;O(B)
 ("Qyd"	?$(C;P(B)
 ("Qn"	?$(C;Q(B)
 ("Qnr"	?$(C;R(B)
 ("Qns"	?$(C;S(B)
 ("Qnf"	?$(C;T(B)
 ("Qna"	?$(C;U(B)
 ("Qnt"	?$(C;V(B)
 ("Qnd"	?$(C;W(B)
 ("Qb"	?$(C;X(B)
 ("Qbd"	?$(C;Y(B)
 ("Qm"	?$(C;Z(B)
 ("Qms"	?$(C;[(B)
 ("Qmf"	?$(C;\(B)
 ("Qma"	?$(C;](B)
 ("Qmq"	?$(C;^(B)
 ("Ql"	?$(C;_(B)
 ("Qlr"	?$(C;`(B)
 ("Qls"	?$(C;a(B)
 ("Qlf"	?$(C;b(B)
 ("Qla"	?$(C;c(B)
 ("Qlq"	?$(C;d(B)
 ("Qlt"	?$(C;e(B)
 ("Qld"	?$(C;f(B)
 ("tk"	?$(C;g(B)
 ("tkr"	?$(C;h(B)
 ("tkrt"	?$(C;i(B)
 ("tks"	?$(C;j(B)
 ("tke"	?$(C;k(B)
 ("tkf"	?$(C;l(B)
 ("tkfr"	?$(C;m(B)
 ("tkfa"	?$(C;n(B)
 ("tka"	?$(C;o(B)
 ("tkq"	?$(C;p(B)
 ("tkt"	?$(C;q(B)
 ("tkT"	?$(C;r(B)
 ("tkd"	?$(C;s(B)
 ("tkx"	?$(C;t(B)
 ("to"	?$(C;u(B)
 ("tor"	?$(C;v(B)
 ("tos"	?$(C;w(B)
 ("tof"	?$(C;x(B)
 ("toa"	?$(C;y(B)
 ("toq"	?$(C;z(B)
 ("tot"	?$(C;{(B)
 ("toT"	?$(C;|(B)
 ("tod"	?$(C;}(B)
 ("ti"	?$(C;~(B)
 ("tir"	?$(C<!(B)
 ("tis"	?$(C<"(B)
 ("tif"	?$(C<#(B)
 ("tia"	?$(C<$(B)
 ("tiq"	?$(C<%(B)
 ("tit"	?$(C<&(B)
 ("tid"	?$(C<'(B)
 ("tO"	?$(C<((B)
 ("tOs"	?$(C<)(B)
 ("tOf"	?$(C<*(B)
 ("tOa"	?$(C<+(B)
 ("tOd"	?$(C<,(B)
 ("tj"	?$(C<-(B)
 ("tjr"	?$(C<.(B)
 ("tjR"	?$(C</(B)
 ("tjrt"	?$(C<0(B)
 ("tjs"	?$(C<1(B)
 ("tje"	?$(C<2(B)
 ("tjf"	?$(C<3(B)
 ("tjfa"	?$(C<4(B)
 ("tjfq"	?$(C<5(B)
 ("tja"	?$(C<6(B)
 ("tjq"	?$(C<7(B)
 ("tjt"	?$(C<8(B)
 ("tjT"	?$(C<9(B)
 ("tjd"	?$(C<:(B)
 ("tjv"	?$(C<;(B)
 ("tp"	?$(C<<(B)
 ("tpr"	?$(C<=(B)
 ("tps"	?$(C<>(B)
 ("tpf"	?$(C<?(B)
 ("tpa"	?$(C<@(B)
 ("tpq"	?$(C<A(B)
 ("tpt"	?$(C<B(B)
 ("tpT"	?$(C<C(B)
 ("tpd"	?$(C<D(B)
 ("tu"	?$(C<E(B)
 ("tur"	?$(C<F(B)
 ("tus"	?$(C<G(B)
 ("tuf"	?$(C<H(B)
 ("tua"	?$(C<I(B)
 ("tuq"	?$(C<J(B)
 ("tut"	?$(C<K(B)
 ("tuT"	?$(C<L(B)
 ("tud"	?$(C<M(B)
 ("tP"	?$(C<N(B)
 ("tPs"	?$(C<O(B)
 ("tPf"	?$(C<P(B)
 ("tPd"	?$(C<Q(B)
 ("th"	?$(C<R(B)
 ("thr"	?$(C<S(B)
 ("thR"	?$(C<T(B)
 ("ths"	?$(C<U(B)
 ("thf"	?$(C<V(B)
 ("thfa"	?$(C<W(B)
 ("tha"	?$(C<X(B)
 ("thq"	?$(C<Y(B)
 ("tht"	?$(C<Z(B)
 ("thd"	?$(C<[(B)
 ("thx"	?$(C<\(B)
 ("thk"	?$(C<](B)
 ("thkr"	?$(C<^(B)
 ("thks"	?$(C<_(B)
 ("thkf"	?$(C<`(B)
 ("thkd"	?$(C<a(B)
 ("tho"	?$(C<b(B)
 ("thos"	?$(C<c(B)
 ("thof"	?$(C<d(B)
 ("thoa"	?$(C<e(B)
 ("thot"	?$(C<f(B)
 ("thoT"	?$(C<g(B)
 ("thl"	?$(C<h(B)
 ("thls"	?$(C<i(B)
 ("thlf"	?$(C<j(B)
 ("thla"	?$(C<k(B)
 ("thlq"	?$(C<l(B)
 ("thlt"	?$(C<m(B)
 ("ty"	?$(C<n(B)
 ("tyr"	?$(C<o(B)
 ("tys"	?$(C<p(B)
 ("tyf"	?$(C<q(B)
 ("tya"	?$(C<r(B)
 ("tyq"	?$(C<s(B)
 ("tyt"	?$(C<t(B)
 ("tyd"	?$(C<u(B)
 ("tn"	?$(C<v(B)
 ("tnr"	?$(C<w(B)
 ("tns"	?$(C<x(B)
 ("tne"	?$(C<y(B)
 ("tnf"	?$(C<z(B)
 ("tna"	?$(C<{(B)
 ("tnq"	?$(C<|(B)
 ("tnt"	?$(C<}(B)
 ("tnd"	?$(C<~(B)
 ("tnc"	?$(C=!(B)
 ("tnx"	?$(C="(B)
 ("tnv"	?$(C=#(B)
 ("tnj"	?$(C=$(B)
 ("tnjT"	?$(C=%(B)
 ("tnp"	?$(C=&(B)
 ("tnpr"	?$(C='(B)
 ("tnps"	?$(C=((B)
 ("tnpf"	?$(C=)(B)
 ("tnpa"	?$(C=*(B)
 ("tnpd"	?$(C=+(B)
 ("tnl"	?$(C=,(B)
 ("tnlr"	?$(C=-(B)
 ("tnls"	?$(C=.(B)
 ("tnlf"	?$(C=/(B)
 ("tnla"	?$(C=0(B)
 ("tnlq"	?$(C=1(B)
 ("tnlt"	?$(C=2(B)
 ("tnld"	?$(C=3(B)
 ("tb"	?$(C=4(B)
 ("tbr"	?$(C=5(B)
 ("tbf"	?$(C=6(B)
 ("tba"	?$(C=7(B)
 ("tbt"	?$(C=8(B)
 ("tbd"	?$(C=9(B)
 ("tm"	?$(C=:(B)
 ("tmr"	?$(C=;(B)
 ("tms"	?$(C=<(B)
 ("tmf"	?$(C==(B)
 ("tmfr"	?$(C=>(B)
 ("tma"	?$(C=?(B)
 ("tmq"	?$(C=@(B)
 ("tmt"	?$(C=A(B)
 ("tmd"	?$(C=B(B)
 ("tl"	?$(C=C(B)
 ("tlr"	?$(C=D(B)
 ("tls"	?$(C=E(B)
 ("tle"	?$(C=F(B)
 ("tlf"	?$(C=G(B)
 ("tlfg"	?$(C=H(B)
 ("tla"	?$(C=I(B)
 ("tlq"	?$(C=J(B)
 ("tlt"	?$(C=K(B)
 ("tld"	?$(C=L(B)
 ("tlv"	?$(C=M(B)
 ("Tk"	?$(C=N(B)
 ("Tkr"	?$(C=O(B)
 ("Tkrt"	?$(C=P(B)
 ("Tks"	?$(C=Q(B)
 ("Tkf"	?$(C=R(B)
 ("Tka"	?$(C=S(B)
 ("Tkq"	?$(C=T(B)
 ("TkT"	?$(C=U(B)
 ("Tkd"	?$(C=V(B)
 ("Tkg"	?$(C=W(B)
 ("To"	?$(C=X(B)
 ("Tor"	?$(C=Y(B)
 ("Tos"	?$(C=Z(B)
 ("Tof"	?$(C=[(B)
 ("Toa"	?$(C=\(B)
 ("Toq"	?$(C=](B)
 ("ToT"	?$(C=^(B)
 ("Tod"	?$(C=_(B)
 ("Tid"	?$(C=`(B)
 ("Tj"	?$(C=a(B)
 ("Tjr"	?$(C=b(B)
 ("Tjs"	?$(C=c(B)
 ("Tjf"	?$(C=d(B)
 ("Tjfa"	?$(C=e(B)
 ("Tja"	?$(C=f(B)
 ("Tjq"	?$(C=g(B)
 ("TjT"	?$(C=h(B)
 ("Tjd"	?$(C=i(B)
 ("Tp"	?$(C=j(B)
 ("Tps"	?$(C=k(B)
 ("Tpf"	?$(C=l(B)
 ("TPs"	?$(C=m(B)
 ("Th"	?$(C=n(B)
 ("Thr"	?$(C=o(B)
 ("Ths"	?$(C=p(B)
 ("The"	?$(C=q(B)
 ("Thf"	?$(C=r(B)
 ("Thfa"	?$(C=s(B)
 ("Tha"	?$(C=t(B)
 ("Thq"	?$(C=u(B)
 ("Thd"	?$(C=v(B)
 ("Thk"	?$(C=w(B)
 ("Thkr"	?$(C=x(B)
 ("Thks"	?$(C=y(B)
 ("ThkT"	?$(C=z(B)
 ("Tho"	?$(C={(B)
 ("ThoT"	?$(C=|(B)
 ("Thl"	?$(C=}(B)
 ("Thls"	?$(C=~(B)
 ("Thlf"	?$(C>!(B)
 ("Thla"	?$(C>"(B)
 ("Thlq"	?$(C>#(B)
 ("Ty"	?$(C>$(B)
 ("Tn"	?$(C>%(B)
 ("Tnr"	?$(C>&(B)
 ("Tns"	?$(C>'(B)
 ("Tnf"	?$(C>((B)
 ("Tna"	?$(C>)(B)
 ("Tnq"	?$(C>*(B)
 ("Tnd"	?$(C>+(B)
 ("Tnj"	?$(C>,(B)
 ("TnjT"	?$(C>-(B)
 ("Tnp"	?$(C>.(B)
 ("Tnl"	?$(C>/(B)
 ("Tnls"	?$(C>0(B)
 ("Tbd"	?$(C>1(B)
 ("Tm"	?$(C>2(B)
 ("Tmr"	?$(C>3(B)
 ("Tms"	?$(C>4(B)
 ("Tmf"	?$(C>5(B)
 ("Tmfa"	?$(C>6(B)
 ("Tmfg"	?$(C>7(B)
 ("Tma"	?$(C>8(B)
 ("Tmq"	?$(C>9(B)
 ("Tml"	?$(C>:(B)
 ("Tmls"	?$(C>;(B)
 ("Tmlf"	?$(C><(B)
 ("Tmla"	?$(C>=(B)
 ("Tl"	?$(C>>(B)
 ("Tlr"	?$(C>?(B)
 ("Tls"	?$(C>@(B)
 ("Tlf"	?$(C>A(B)
 ("Tla"	?$(C>B(B)
 ("Tlq"	?$(C>C(B)
 ("Tlt"	?$(C>D(B)
 ("Tld"	?$(C>E(B)
 ("dk"	?$(C>F(B)
 ("dkr"	?$(C>G(B)
 ("dks"	?$(C>H(B)
 ("dksw"	?$(C>I(B)
 ("dksg"	?$(C>J(B)
 ("dkf"	?$(C>K(B)
 ("dkfr"	?$(C>L(B)
 ("dkfa"	?$(C>M(B)
 ("dkfg"	?$(C>N(B)
 ("dka"	?$(C>O(B)
 ("dkq"	?$(C>P(B)
 ("dkt"	?$(C>Q(B)
 ("dkT"	?$(C>R(B)
 ("dkd"	?$(C>S(B)
 ("dkx"	?$(C>T(B)
 ("dkv"	?$(C>U(B)
 ("do"	?$(C>V(B)
 ("dor"	?$(C>W(B)
 ("dos"	?$(C>X(B)
 ("dof"	?$(C>Y(B)
 ("doa"	?$(C>Z(B)
 ("doq"	?$(C>[(B)
 ("dot"	?$(C>\(B)
 ("doT"	?$(C>](B)
 ("dod"	?$(C>^(B)
 ("di"	?$(C>_(B)
 ("dir"	?$(C>`(B)
 ("dis"	?$(C>a(B)
 ("dif"	?$(C>b(B)
 ("difq"	?$(C>c(B)
 ("dia"	?$(C>d(B)
 ("diq"	?$(C>e(B)
 ("dit"	?$(C>f(B)
 ("did"	?$(C>g(B)
 ("dix"	?$(C>h(B)
 ("dig"	?$(C>i(B)
 ("dO"	?$(C>j(B)
 ("dOs"	?$(C>k(B)
 ("dOf"	?$(C>l(B)
 ("dOq"	?$(C>m(B)
 ("dj"	?$(C>n(B)
 ("djr"	?$(C>o(B)
 ("djs"	?$(C>p(B)
 ("djsw"	?$(C>q(B)
 ("dje"	?$(C>r(B)
 ("djf"	?$(C>s(B)
 ("djfr"	?$(C>t(B)
 ("djfa"	?$(C>u(B)
 ("dja"	?$(C>v(B)
 ("djq"	?$(C>w(B)
 ("djqt"	?$(C>x(B)
 ("djt"	?$(C>y(B)
 ("djT"	?$(C>z(B)
 ("djd"	?$(C>{(B)
 ("djw"	?$(C>|(B)
 ("djz"	?$(C>}(B)
 ("djv"	?$(C>~(B)
 ("dp"	?$(C?!(B)
 ("dpr"	?$(C?"(B)
 ("dps"	?$(C?#(B)
 ("dpf"	?$(C?$(B)
 ("dpa"	?$(C?%(B)
 ("dpq"	?$(C?&(B)
 ("dpt"	?$(C?'(B)
 ("dpd"	?$(C?((B)
 ("du"	?$(C?)(B)
 ("dur"	?$(C?*(B)
 ("duR"	?$(C?+(B)
 ("dus"	?$(C?,(B)
 ("duf"	?$(C?-(B)
 ("dufa"	?$(C?.(B)
 ("dufq"	?$(C?/(B)
 ("dua"	?$(C?0(B)
 ("duq"	?$(C?1(B)
 ("duqt"	?$(C?2(B)
 ("dut"	?$(C?3(B)
 ("duT"	?$(C?4(B)
 ("dud"	?$(C?5(B)
 ("dux"	?$(C?6(B)
 ("duv"	?$(C?7(B)
 ("dug"	?$(C?8(B)
 ("dP"	?$(C?9(B)
 ("dPs"	?$(C?:(B)
 ("dPf"	?$(C?;(B)
 ("dPa"	?$(C?<(B)
 ("dPq"	?$(C?=(B)
 ("dPt"	?$(C?>(B)
 ("dPT"	?$(C??(B)
 ("dh"	?$(C?@(B)
 ("dhr"	?$(C?A(B)
 ("dhs"	?$(C?B(B)
 ("dhf"	?$(C?C(B)
 ("dhfr"	?$(C?D(B)
 ("dhfa"	?$(C?E(B)
 ("dhft"	?$(C?F(B)
 ("dhfg"	?$(C?G(B)
 ("dha"	?$(C?H(B)
 ("dhq"	?$(C?I(B)
 ("dht"	?$(C?J(B)
 ("dhd"	?$(C?K(B)
 ("dhc"	?$(C?L(B)
 ("dhk"	?$(C?M(B)
 ("dhkr"	?$(C?N(B)
 ("dhks"	?$(C?O(B)
 ("dhkf"	?$(C?P(B)
 ("dhka"	?$(C?Q(B)
 ("dhkq"	?$(C?R(B)
 ("dhkt"	?$(C?S(B)
 ("dhkT"	?$(C?T(B)
 ("dhkd"	?$(C?U(B)
 ("dho"	?$(C?V(B)
 ("dhor"	?$(C?W(B)
 ("dhos"	?$(C?X(B)
 ("dhoa"	?$(C?Y(B)
 ("dhot"	?$(C?Z(B)
 ("dhod"	?$(C?[(B)
 ("dhl"	?$(C?\(B)
 ("dhlr"	?$(C?](B)
 ("dhls"	?$(C?^(B)
 ("dhlf"	?$(C?_(B)
 ("dhla"	?$(C?`(B)
 ("dhlq"	?$(C?a(B)
 ("dhlt"	?$(C?b(B)
 ("dhld"	?$(C?c(B)
 ("dy"	?$(C?d(B)
 ("dyr"	?$(C?e(B)
 ("dys"	?$(C?f(B)
 ("dyf"	?$(C?g(B)
 ("dya"	?$(C?h(B)
 ("dyq"	?$(C?i(B)
 ("dyt"	?$(C?j(B)
 ("dyd"	?$(C?k(B)
 ("dn"	?$(C?l(B)
 ("dnr"	?$(C?m(B)
 ("dns"	?$(C?n(B)
 ("dnf"	?$(C?o(B)
 ("dnfr"	?$(C?p(B)
 ("dnfa"	?$(C?q(B)
 ("dna"	?$(C?r(B)
 ("dnq"	?$(C?s(B)
 ("dnt"	?$(C?t(B)
 ("dnd"	?$(C?u(B)
 ("dnj"	?$(C?v(B)
 ("dnjr"	?$(C?w(B)
 ("dnjs"	?$(C?x(B)
 ("dnjf"	?$(C?y(B)
 ("dnja"	?$(C?z(B)
 ("dnjq"	?$(C?{(B)
 ("dnjT"	?$(C?|(B)
 ("dnjd"	?$(C?}(B)
 ("dnp"	?$(C?~(B)
 ("dnpr"	?$(C@!(B)
 ("dnps"	?$(C@"(B)
 ("dnpf"	?$(C@#(B)
 ("dnpa"	?$(C@$(B)
 ("dnpq"	?$(C@%(B)
 ("dnpd"	?$(C@&(B)
 ("dnl"	?$(C@'(B)
 ("dnlr"	?$(C@((B)
 ("dnls"	?$(C@)(B)
 ("dnlf"	?$(C@*(B)
 ("dnla"	?$(C@+(B)
 ("dnlq"	?$(C@,(B)
 ("dnlt"	?$(C@-(B)
 ("dnld"	?$(C@.(B)
 ("db"	?$(C@/(B)
 ("dbr"	?$(C@0(B)
 ("dbs"	?$(C@1(B)
 ("dbf"	?$(C@2(B)
 ("dba"	?$(C@3(B)
 ("dbq"	?$(C@4(B)
 ("dbt"	?$(C@5(B)
 ("dbd"	?$(C@6(B)
 ("dbc"	?$(C@7(B)
 ("dm"	?$(C@8(B)
 ("dmr"	?$(C@9(B)
 ("dms"	?$(C@:(B)
 ("dmf"	?$(C@;(B)
 ("dmfv"	?$(C@<(B)
 ("dma"	?$(C@=(B)
 ("dmq"	?$(C@>(B)
 ("dmt"	?$(C@?(B)
 ("dmd"	?$(C@@(B)
 ("dmw"	?$(C@A(B)
 ("dmc"	?$(C@B(B)
 ("dmz"	?$(C@C(B)
 ("dmx"	?$(C@D(B)
 ("dmv"	?$(C@E(B)
 ("dmg"	?$(C@F(B)
 ("dml"	?$(C@G(B)
 ("dmls"	?$(C@H(B)
 ("dmlf"	?$(C@I(B)
 ("dmla"	?$(C@J(B)
 ("dmlt"	?$(C@K(B)
 ("dl"	?$(C@L(B)
 ("dlr"	?$(C@M(B)
 ("dls"	?$(C@N(B)
 ("dlf"	?$(C@O(B)
 ("dlfr"	?$(C@P(B)
 ("dlfa"	?$(C@Q(B)
 ("dlfg"	?$(C@R(B)
 ("dla"	?$(C@S(B)
 ("dlq"	?$(C@T(B)
 ("dlt"	?$(C@U(B)
 ("dlT"	?$(C@V(B)
 ("dld"	?$(C@W(B)
 ("dlw"	?$(C@X(B)
 ("dlv"	?$(C@Y(B)
 ("wk"	?$(C@Z(B)
 ("wkr"	?$(C@[(B)
 ("wks"	?$(C@\(B)
 ("wksg"	?$(C@](B)
 ("wke"	?$(C@^(B)
 ("wkf"	?$(C@_(B)
 ("wkfa"	?$(C@`(B)
 ("wka"	?$(C@a(B)
 ("wkq"	?$(C@b(B)
 ("wkt"	?$(C@c(B)
 ("wkT"	?$(C@d(B)
 ("wkd"	?$(C@e(B)
 ("wkw"	?$(C@f(B)
 ("wo"	?$(C@g(B)
 ("wor"	?$(C@h(B)
 ("wos"	?$(C@i(B)
 ("wof"	?$(C@j(B)
 ("woa"	?$(C@k(B)
 ("woq"	?$(C@l(B)
 ("wot"	?$(C@m(B)
 ("woT"	?$(C@n(B)
 ("wod"	?$(C@o(B)
 ("wi"	?$(C@p(B)
 ("wir"	?$(C@q(B)
 ("wis"	?$(C@r(B)
 ("wisg"	?$(C@s(B)
 ("wif"	?$(C@t(B)
 ("wia"	?$(C@u(B)
 ("wid"	?$(C@v(B)
 ("wO"	?$(C@w(B)
 ("wOs"	?$(C@x(B)
 ("wOf"	?$(C@y(B)
 ("wj"	?$(C@z(B)
 ("wjr"	?$(C@{(B)
 ("wjs"	?$(C@|(B)
 ("wjf"	?$(C@}(B)
 ("wjfa"	?$(C@~(B)
 ("wja"	?$(CA!(B)
 ("wjq"	?$(CA"(B)
 ("wjt"	?$(CA#(B)
 ("wjd"	?$(CA$(B)
 ("wjw"	?$(CA%(B)
 ("wp"	?$(CA&(B)
 ("wpr"	?$(CA'(B)
 ("wps"	?$(CA((B)
 ("wpf"	?$(CA)(B)
 ("wpa"	?$(CA*(B)
 ("wpq"	?$(CA+(B)
 ("wpt"	?$(CA,(B)
 ("wpd"	?$(CA-(B)
 ("wu"	?$(CA.(B)
 ("wus"	?$(CA/(B)
 ("wuf"	?$(CA0(B)
 ("wua"	?$(CA1(B)
 ("wuq"	?$(CA2(B)
 ("wuT"	?$(CA3(B)
 ("wud"	?$(CA4(B)
 ("wP"	?$(CA5(B)
 ("wh"	?$(CA6(B)
 ("whr"	?$(CA7(B)
 ("whs"	?$(CA8(B)
 ("whf"	?$(CA9(B)
 ("whfa"	?$(CA:(B)
 ("wha"	?$(CA;(B)
 ("whq"	?$(CA<(B)
 ("wht"	?$(CA=(B)
 ("whd"	?$(CA>(B)
 ("whw"	?$(CA?(B)
 ("whc"	?$(CA@(B)
 ("whg"	?$(CAA(B)
 ("whk"	?$(CAB(B)
 ("whkr"	?$(CAC(B)
 ("whkf"	?$(CAD(B)
 ("whkq"	?$(CAE(B)
 ("whkt"	?$(CAF(B)
 ("whkd"	?$(CAG(B)
 ("who"	?$(CAH(B)
 ("whoT"	?$(CAI(B)
 ("whod"	?$(CAJ(B)
 ("whl"	?$(CAK(B)
 ("whls"	?$(CAL(B)
 ("whlf"	?$(CAM(B)
 ("whla"	?$(CAN(B)
 ("whlq"	?$(CAO(B)
 ("whlt"	?$(CAP(B)
 ("whld"	?$(CAQ(B)
 ("wy"	?$(CAR(B)
 ("wyr"	?$(CAS(B)
 ("wys"	?$(CAT(B)
 ("wyd"	?$(CAU(B)
 ("wn"	?$(CAV(B)
 ("wnr"	?$(CAW(B)
 ("wns"	?$(CAX(B)
 ("wnf"	?$(CAY(B)
 ("wnfr"	?$(CAZ(B)
 ("wnfa"	?$(CA[(B)
 ("wna"	?$(CA\(B)
 ("wnq"	?$(CA](B)
 ("wnt"	?$(CA^(B)
 ("wnd"	?$(CA_(B)
 ("wnj"	?$(CA`(B)
 ("wnjT"	?$(CAa(B)
 ("wnp"	?$(CAb(B)
 ("wnl"	?$(CAc(B)
 ("wnlr"	?$(CAd(B)
 ("wnls"	?$(CAe(B)
 ("wnlf"	?$(CAf(B)
 ("wnla"	?$(CAg(B)
 ("wnlq"	?$(CAh(B)
 ("wnlt"	?$(CAi(B)
 ("wb"	?$(CAj(B)
 ("wbs"	?$(CAk(B)
 ("wbf"	?$(CAl(B)
 ("wba"	?$(CAm(B)
 ("wm"	?$(CAn(B)
 ("wmr"	?$(CAo(B)
 ("wms"	?$(CAp(B)
 ("wmf"	?$(CAq(B)
 ("wma"	?$(CAr(B)
 ("wmq"	?$(CAs(B)
 ("wmt"	?$(CAt(B)
 ("wmd"	?$(CAu(B)
 ("wl"	?$(CAv(B)
 ("wlr"	?$(CAw(B)
 ("wls"	?$(CAx(B)
 ("wle"	?$(CAy(B)
 ("wlf"	?$(CAz(B)
 ("wlfa"	?$(CA{(B)
 ("wla"	?$(CA|(B)
 ("wlq"	?$(CA}(B)
 ("wlt"	?$(CA~(B)
 ("wld"	?$(CB!(B)
 ("wlw"	?$(CB"(B)
 ("wlx"	?$(CB#(B)
 ("wlv"	?$(CB$(B)
 ("Wk"	?$(CB%(B)
 ("Wkr"	?$(CB&(B)
 ("Wks"	?$(CB'(B)
 ("Wksg"	?$(CB((B)
 ("Wkf"	?$(CB)(B)
 ("Wkfq"	?$(CB*(B)
 ("Wka"	?$(CB+(B)
 ("Wkq"	?$(CB,(B)
 ("Wkt"	?$(CB-(B)
 ("WkT"	?$(CB.(B)
 ("Wkd"	?$(CB/(B)
 ("Wo"	?$(CB0(B)
 ("Wor"	?$(CB1(B)
 ("Wos"	?$(CB2(B)
 ("Wof"	?$(CB3(B)
 ("Woa"	?$(CB4(B)
 ("Woq"	?$(CB5(B)
 ("Wot"	?$(CB6(B)
 ("WoT"	?$(CB7(B)
 ("Wod"	?$(CB8(B)
 ("Wi"	?$(CB9(B)
 ("Wis"	?$(CB:(B)
 ("Wid"	?$(CB;(B)
 ("Wj"	?$(CB<(B)
 ("Wjr"	?$(CB=(B)
 ("Wjs"	?$(CB>(B)
 ("Wjf"	?$(CB?(B)
 ("Wja"	?$(CB@(B)
 ("Wjq"	?$(CBA(B)
 ("Wjt"	?$(CBB(B)
 ("WjT"	?$(CBC(B)
 ("Wjd"	?$(CBD(B)
 ("Wp"	?$(CBE(B)
 ("Wpd"	?$(CBF(B)
 ("Wu"	?$(CBG(B)
 ("WuT"	?$(CBH(B)
 ("Wh"	?$(CBI(B)
 ("Whr"	?$(CBJ(B)
 ("Whs"	?$(CBK(B)
 ("Whf"	?$(CBL(B)
 ("Wha"	?$(CBM(B)
 ("Whq"	?$(CBN(B)
 ("Wht"	?$(CBO(B)
 ("Whd"	?$(CBP(B)
 ("Whc"	?$(CBQ(B)
 ("Whk"	?$(CBR(B)
 ("Whkr"	?$(CBS(B)
 ("Whkf"	?$(CBT(B)
 ("WhkT"	?$(CBU(B)
 ("Who"	?$(CBV(B)
 ("WhoT"	?$(CBW(B)
 ("Whl"	?$(CBX(B)
 ("Whls"	?$(CBY(B)
 ("Whlf"	?$(CBZ(B)
 ("Whla"	?$(CB[(B)
 ("Whlq"	?$(CB\(B)
 ("Wyd"	?$(CB](B)
 ("Wn"	?$(CB^(B)
 ("Wnr"	?$(CB_(B)
 ("Wns"	?$(CB`(B)
 ("Wnf"	?$(CBa(B)
 ("Wna"	?$(CBb(B)
 ("Wnq"	?$(CBc(B)
 ("Wnd"	?$(CBd(B)
 ("Wnj"	?$(CBe(B)
 ("WnjT"	?$(CBf(B)
 ("Wnjd"	?$(CBg(B)
 ("Wnl"	?$(CBh(B)
 ("Wb"	?$(CBi(B)
 ("Wm"	?$(CBj(B)
 ("Wma"	?$(CBk(B)
 ("Wmt"	?$(CBl(B)
 ("Wmd"	?$(CBm(B)
 ("Wl"	?$(CBn(B)
 ("Wlr"	?$(CBo(B)
 ("Wls"	?$(CBp(B)
 ("Wlf"	?$(CBq(B)
 ("Wla"	?$(CBr(B)
 ("Wlq"	?$(CBs(B)
 ("Wld"	?$(CBt(B)
 ("Wlw"	?$(CBu(B)
 ("Wlg"	?$(CBv(B)
 ("ck"	?$(CBw(B)
 ("ckr"	?$(CBx(B)
 ("cks"	?$(CBy(B)
 ("cksg"	?$(CBz(B)
 ("ckf"	?$(CB{(B)
 ("cka"	?$(CB|(B)
 ("ckq"	?$(CB}(B)
 ("ckt"	?$(CB~(B)
 ("ckT"	?$(CC!(B)
 ("ckd"	?$(CC"(B)
 ("ckw"	?$(CC#(B)
 ("co"	?$(CC$(B)
 ("cor"	?$(CC%(B)
 ("cos"	?$(CC&(B)
 ("cof"	?$(CC'(B)
 ("coa"	?$(CC((B)
 ("coq"	?$(CC)(B)
 ("cot"	?$(CC*(B)
 ("coT"	?$(CC+(B)
 ("cod"	?$(CC,(B)
 ("ci"	?$(CC-(B)
 ("cis"	?$(CC.(B)
 ("cisg"	?$(CC/(B)
 ("cif"	?$(CC0(B)
 ("cia"	?$(CC1(B)
 ("cid"	?$(CC2(B)
 ("cj"	?$(CC3(B)
 ("cjr"	?$(CC4(B)
 ("cjs"	?$(CC5(B)
 ("cjf"	?$(CC6(B)
 ("cja"	?$(CC7(B)
 ("cjq"	?$(CC8(B)
 ("cjt"	?$(CC9(B)
 ("cjT"	?$(CC:(B)
 ("cjd"	?$(CC;(B)
 ("cp"	?$(CC<(B)
 ("cpr"	?$(CC=(B)
 ("cps"	?$(CC>(B)
 ("cpf"	?$(CC?(B)
 ("cpa"	?$(CC@(B)
 ("cpq"	?$(CCA(B)
 ("cpt"	?$(CCB(B)
 ("cpd"	?$(CCC(B)
 ("cu"	?$(CCD(B)
 ("cus"	?$(CCE(B)
 ("cuT"	?$(CCF(B)
 ("cP"	?$(CCG(B)
 ("cPs"	?$(CCH(B)
 ("cPd"	?$(CCI(B)
 ("ch"	?$(CCJ(B)
 ("chr"	?$(CCK(B)
 ("chs"	?$(CCL(B)
 ("chf"	?$(CCM(B)
 ("cha"	?$(CCN(B)
 ("chq"	?$(CCO(B)
 ("cht"	?$(CCP(B)
 ("chd"	?$(CCQ(B)
 ("chk"	?$(CCR(B)
 ("chks"	?$(CCS(B)
 ("chkf"	?$(CCT(B)
 ("chkd"	?$(CCU(B)
 ("chl"	?$(CCV(B)
 ("chls"	?$(CCW(B)
 ("chlf"	?$(CCX(B)
 ("chla"	?$(CCY(B)
 ("chlq"	?$(CCZ(B)
 ("chlt"	?$(CC[(B)
 ("chld"	?$(CC\(B)
 ("cy"	?$(CC](B)
 ("cya"	?$(CC^(B)
 ("cn"	?$(CC_(B)
 ("cnr"	?$(CC`(B)
 ("cns"	?$(CCa(B)
 ("cnf"	?$(CCb(B)
 ("cna"	?$(CCc(B)
 ("cnq"	?$(CCd(B)
 ("cnt"	?$(CCe(B)
 ("cnd"	?$(CCf(B)
 ("cnj"	?$(CCg(B)
 ("cnjT"	?$(CCh(B)
 ("cnp"	?$(CCi(B)
 ("cnps"	?$(CCj(B)
 ("cnl"	?$(CCk(B)
 ("cnls"	?$(CCl(B)
 ("cnlf"	?$(CCm(B)
 ("cnla"	?$(CCn(B)
 ("cnlq"	?$(CCo(B)
 ("cnlt"	?$(CCp(B)
 ("cnld"	?$(CCq(B)
 ("cb"	?$(CCr(B)
 ("cbs"	?$(CCs(B)
 ("cbf"	?$(CCt(B)
 ("cba"	?$(CCu(B)
 ("cbd"	?$(CCv(B)
 ("cm"	?$(CCw(B)
 ("cmr"	?$(CCx(B)
 ("cms"	?$(CCy(B)
 ("cmf"	?$(CCz(B)
 ("cma"	?$(CC{(B)
 ("cmq"	?$(CC|(B)
 ("cmt"	?$(CC}(B)
 ("cmd"	?$(CC~(B)
 ("cl"	?$(CD!(B)
 ("clr"	?$(CD"(B)
 ("cls"	?$(CD#(B)
 ("cle"	?$(CD$(B)
 ("clf"	?$(CD%(B)
 ("clfr"	?$(CD&(B)
 ("cla"	?$(CD'(B)
 ("clq"	?$(CD((B)
 ("clt"	?$(CD)(B)
 ("cld"	?$(CD*(B)
 ("zk"	?$(CD+(B)
 ("zkr"	?$(CD,(B)
 ("zks"	?$(CD-(B)
 ("zkf"	?$(CD.(B)
 ("zka"	?$(CD/(B)
 ("zkq"	?$(CD0(B)
 ("zkt"	?$(CD1(B)
 ("zkd"	?$(CD2(B)
 ("zo"	?$(CD3(B)
 ("zor"	?$(CD4(B)
 ("zos"	?$(CD5(B)
 ("zof"	?$(CD6(B)
 ("zoa"	?$(CD7(B)
 ("zoq"	?$(CD8(B)
 ("zot"	?$(CD9(B)
 ("zoT"	?$(CD:(B)
 ("zod"	?$(CD;(B)
 ("zi"	?$(CD<(B)
 ("zir"	?$(CD=(B)
 ("zid"	?$(CD>(B)
 ("zj"	?$(CD?(B)
 ("zjr"	?$(CD@(B)
 ("zjs"	?$(CDA(B)
 ("zje"	?$(CDB(B)
 ("zjf"	?$(CDC(B)
 ("zja"	?$(CDD(B)
 ("zjq"	?$(CDE(B)
 ("zjt"	?$(CDF(B)
 ("zjT"	?$(CDG(B)
 ("zjd"	?$(CDH(B)
 ("zp"	?$(CDI(B)
 ("zpr"	?$(CDJ(B)
 ("zps"	?$(CDK(B)
 ("zpf"	?$(CDL(B)
 ("zpa"	?$(CDM(B)
 ("zpq"	?$(CDN(B)
 ("zpt"	?$(CDO(B)
 ("zpd"	?$(CDP(B)
 ("zu"	?$(CDQ(B)
 ("zus"	?$(CDR(B)
 ("zuf"	?$(CDS(B)
 ("zua"	?$(CDT(B)
 ("zuq"	?$(CDU(B)
 ("zut"	?$(CDV(B)
 ("zuT"	?$(CDW(B)
 ("zud"	?$(CDX(B)
 ("zP"	?$(CDY(B)
 ("zh"	?$(CDZ(B)
 ("zhr"	?$(CD[(B)
 ("zhs"	?$(CD\(B)
 ("zhf"	?$(CD](B)
 ("zha"	?$(CD^(B)
 ("zhq"	?$(CD_(B)
 ("zht"	?$(CD`(B)
 ("zhd"	?$(CDa(B)
 ("zhk"	?$(CDb(B)
 ("zhkr"	?$(CDc(B)
 ("zhks"	?$(CDd(B)
 ("zhkf"	?$(CDe(B)
 ("zhka"	?$(CDf(B)
 ("zhkd"	?$(CDg(B)
 ("zho"	?$(CDh(B)
 ("zhod"	?$(CDi(B)
 ("zhl"	?$(CDj(B)
 ("zhlf"	?$(CDk(B)
 ("zy"	?$(CDl(B)
 ("zn"	?$(CDm(B)
 ("znr"	?$(CDn(B)
 ("zns"	?$(CDo(B)
 ("znf"	?$(CDp(B)
 ("zna"	?$(CDq(B)
 ("znq"	?$(CDr(B)
 ("znt"	?$(CDs(B)
 ("znd"	?$(CDt(B)
 ("znj"	?$(CDu(B)
 ("znjs"	?$(CDv(B)
 ("znjf"	?$(CDw(B)
 ("znjd"	?$(CDx(B)
 ("znp"	?$(CDy(B)
 ("znpd"	?$(CDz(B)
 ("znl"	?$(CD{(B)
 ("znlr"	?$(CD|(B)
 ("znls"	?$(CD}(B)
 ("znlf"	?$(CD~(B)
 ("znla"	?$(CE!(B)
 ("znlq"	?$(CE"(B)
 ("znlt"	?$(CE#(B)
 ("znld"	?$(CE$(B)
 ("zb"	?$(CE%(B)
 ("zbs"	?$(CE&(B)
 ("zbf"	?$(CE'(B)
 ("zba"	?$(CE((B)
 ("zm"	?$(CE)(B)
 ("zmr"	?$(CE*(B)
 ("zms"	?$(CE+(B)
 ("zmf"	?$(CE,(B)
 ("zma"	?$(CE-(B)
 ("zmq"	?$(CE.(B)
 ("zmd"	?$(CE/(B)
 ("zl"	?$(CE0(B)
 ("zlr"	?$(CE1(B)
 ("zls"	?$(CE2(B)
 ("zlf"	?$(CE3(B)
 ("zla"	?$(CE4(B)
 ("zlq"	?$(CE5(B)
 ("zlt"	?$(CE6(B)
 ("zld"	?$(CE7(B)
 ("xk"	?$(CE8(B)
 ("xkr"	?$(CE9(B)
 ("xks"	?$(CE:(B)
 ("xkf"	?$(CE;(B)
 ("xkfr"	?$(CE<(B)
 ("xka"	?$(CE=(B)
 ("xkq"	?$(CE>(B)
 ("xkt"	?$(CE?(B)
 ("xkT"	?$(CE@(B)
 ("xkd"	?$(CEA(B)
 ("xo"	?$(CEB(B)
 ("xor"	?$(CEC(B)
 ("xos"	?$(CED(B)
 ("xof"	?$(CEE(B)
 ("xoa"	?$(CEF(B)
 ("xoq"	?$(CEG(B)
 ("xot"	?$(CEH(B)
 ("xoT"	?$(CEI(B)
 ("xod"	?$(CEJ(B)
 ("xi"	?$(CEK(B)
 ("xid"	?$(CEL(B)
 ("xj"	?$(CEM(B)
 ("xjr"	?$(CEN(B)
 ("xjs"	?$(CEO(B)
 ("xjf"	?$(CEP(B)
 ("xjfa"	?$(CEQ(B)
 ("xja"	?$(CER(B)
 ("xjq"	?$(CES(B)
 ("xjt"	?$(CET(B)
 ("xjT"	?$(CEU(B)
 ("xjd"	?$(CEV(B)
 ("xp"	?$(CEW(B)
 ("xpr"	?$(CEX(B)
 ("xps"	?$(CEY(B)
 ("xpf"	?$(CEZ(B)
 ("xpa"	?$(CE[(B)
 ("xpq"	?$(CE\(B)
 ("xpt"	?$(CE](B)
 ("xpd"	?$(CE^(B)
 ("xu"	?$(CE_(B)
 ("xus"	?$(CE`(B)
 ("xuT"	?$(CEa(B)
 ("xP"	?$(CEb(B)
 ("xPs"	?$(CEc(B)
 ("xh"	?$(CEd(B)
 ("xhr"	?$(CEe(B)
 ("xhs"	?$(CEf(B)
 ("xhf"	?$(CEg(B)
 ("xha"	?$(CEh(B)
 ("xhq"	?$(CEi(B)
 ("xht"	?$(CEj(B)
 ("xhd"	?$(CEk(B)
 ("xhv"	?$(CEl(B)
 ("xhk"	?$(CEm(B)
 ("xhks"	?$(CEn(B)
 ("xho"	?$(CEo(B)
 ("xhl"	?$(CEp(B)
 ("xhls"	?$(CEq(B)
 ("xhlt"	?$(CEr(B)
 ("xhld"	?$(CEs(B)
 ("xy"	?$(CEt(B)
 ("xn"	?$(CEu(B)
 ("xnr"	?$(CEv(B)
 ("xns"	?$(CEw(B)
 ("xnf"	?$(CEx(B)
 ("xna"	?$(CEy(B)
 ("xnq"	?$(CEz(B)
 ("xnt"	?$(CE{(B)
 ("xnd"	?$(CE|(B)
 ("xnj"	?$(CE}(B)
 ("xnjT"	?$(CE~(B)
 ("xnp"	?$(CF!(B)
 ("xnl"	?$(CF"(B)
 ("xnlr"	?$(CF#(B)
 ("xnls"	?$(CF$(B)
 ("xnlf"	?$(CF%(B)
 ("xnla"	?$(CF&(B)
 ("xnlq"	?$(CF'(B)
 ("xnld"	?$(CF((B)
 ("xb"	?$(CF)(B)
 ("xbs"	?$(CF*(B)
 ("xbf"	?$(CF+(B)
 ("xba"	?$(CF,(B)
 ("xbd"	?$(CF-(B)
 ("xm"	?$(CF.(B)
 ("xmr"	?$(CF/(B)
 ("xms"	?$(CF0(B)
 ("xme"	?$(CF1(B)
 ("xmf"	?$(CF2(B)
 ("xmfa"	?$(CF3(B)
 ("xma"	?$(CF4(B)
 ("xmq"	?$(CF5(B)
 ("xmt"	?$(CF6(B)
 ("xml"	?$(CF7(B)
 ("xmls"	?$(CF8(B)
 ("xmlf"	?$(CF9(B)
 ("xmla"	?$(CF:(B)
 ("xmlq"	?$(CF;(B)
 ("xl"	?$(CF<(B)
 ("xlr"	?$(CF=(B)
 ("xls"	?$(CF>(B)
 ("xlf"	?$(CF?(B)
 ("xla"	?$(CF@(B)
 ("xlq"	?$(CFA(B)
 ("xlt"	?$(CFB(B)
 ("xld"	?$(CFC(B)
 ("vk"	?$(CFD(B)
 ("vkr"	?$(CFE(B)
 ("vkR"	?$(CFF(B)
 ("vks"	?$(CFG(B)
 ("vkf"	?$(CFH(B)
 ("vkfa"	?$(CFI(B)
 ("vka"	?$(CFJ(B)
 ("vkq"	?$(CFK(B)
 ("vkt"	?$(CFL(B)
 ("vkT"	?$(CFM(B)
 ("vkd"	?$(CFN(B)
 ("vkx"	?$(CFO(B)
 ("vo"	?$(CFP(B)
 ("vor"	?$(CFQ(B)
 ("vos"	?$(CFR(B)
 ("vof"	?$(CFS(B)
 ("voa"	?$(CFT(B)
 ("voq"	?$(CFU(B)
 ("vot"	?$(CFV(B)
 ("voT"	?$(CFW(B)
 ("vod"	?$(CFX(B)
 ("vi"	?$(CFY(B)
 ("vir"	?$(CFZ(B)
 ("vj"	?$(CF[(B)
 ("vjr"	?$(CF\(B)
 ("vjs"	?$(CF](B)
 ("vjf"	?$(CF^(B)
 ("vja"	?$(CF_(B)
 ("vjq"	?$(CF`(B)
 ("vjt"	?$(CFa(B)
 ("vjT"	?$(CFb(B)
 ("vjd"	?$(CFc(B)
 ("vp"	?$(CFd(B)
 ("vpr"	?$(CFe(B)
 ("vps"	?$(CFf(B)
 ("vpf"	?$(CFg(B)
 ("vpa"	?$(CFh(B)
 ("vpq"	?$(CFi(B)
 ("vpt"	?$(CFj(B)
 ("vpd"	?$(CFk(B)
 ("vu"	?$(CFl(B)
 ("vus"	?$(CFm(B)
 ("vuf"	?$(CFn(B)
 ("vua"	?$(CFo(B)
 ("vuq"	?$(CFp(B)
 ("vuT"	?$(CFq(B)
 ("vud"	?$(CFr(B)
 ("vP"	?$(CFs(B)
 ("vPf"	?$(CFt(B)
 ("vPq"	?$(CFu(B)
 ("vPt"	?$(CFv(B)
 ("vh"	?$(CFw(B)
 ("vhr"	?$(CFx(B)
 ("vhs"	?$(CFy(B)
 ("vhf"	?$(CFz(B)
 ("vha"	?$(CF{(B)
 ("vhq"	?$(CF|(B)
 ("vht"	?$(CF}(B)
 ("vhd"	?$(CF~(B)
 ("vhk"	?$(CG!(B)
 ("vhkd"	?$(CG"(B)
 ("vhl"	?$(CG#(B)
 ("vhls"	?$(CG$(B)
 ("vy"	?$(CG%(B)
 ("vys"	?$(CG&(B)
 ("vyf"	?$(CG'(B)
 ("vyq"	?$(CG((B)
 ("vyt"	?$(CG)(B)
 ("vn"	?$(CG*(B)
 ("vnr"	?$(CG+(B)
 ("vns"	?$(CG,(B)
 ("vne"	?$(CG-(B)
 ("vnf"	?$(CG.(B)
 ("vnfa"	?$(CG/(B)
 ("vna"	?$(CG0(B)
 ("vnq"	?$(CG1(B)
 ("vnt"	?$(CG2(B)
 ("vnd"	?$(CG3(B)
 ("vnj"	?$(CG4(B)
 ("vnjd"	?$(CG5(B)
 ("vnl"	?$(CG6(B)
 ("vnls"	?$(CG7(B)
 ("vnlf"	?$(CG8(B)
 ("vnla"	?$(CG9(B)
 ("vnlt"	?$(CG:(B)
 ("vb"	?$(CG;(B)
 ("vbs"	?$(CG<(B)
 ("vbf"	?$(CG=(B)
 ("vba"	?$(CG>(B)
 ("vbt"	?$(CG?(B)
 ("vbd"	?$(CG@(B)
 ("vm"	?$(CGA(B)
 ("vms"	?$(CGB(B)
 ("vmf"	?$(CGC(B)
 ("vma"	?$(CGD(B)
 ("vmq"	?$(CGE(B)
 ("vmt"	?$(CGF(B)
 ("vl"	?$(CGG(B)
 ("vlr"	?$(CGH(B)
 ("vls"	?$(CGI(B)
 ("vlf"	?$(CGJ(B)
 ("vla"	?$(CGK(B)
 ("vlq"	?$(CGL(B)
 ("vlt"	?$(CGM(B)
 ("vld"	?$(CGN(B)
 ("gk"	?$(CGO(B)
 ("gkr"	?$(CGP(B)
 ("gks"	?$(CGQ(B)
 ("gkf"	?$(CGR(B)
 ("gkfx"	?$(CGS(B)
 ("gka"	?$(CGT(B)
 ("gkq"	?$(CGU(B)
 ("gkt"	?$(CGV(B)
 ("gkd"	?$(CGW(B)
 ("go"	?$(CGX(B)
 ("gor"	?$(CGY(B)
 ("gos"	?$(CGZ(B)
 ("gof"	?$(CG[(B)
 ("goa"	?$(CG\(B)
 ("goq"	?$(CG](B)
 ("got"	?$(CG^(B)
 ("goT"	?$(CG_(B)
 ("god"	?$(CG`(B)
 ("gi"	?$(CGa(B)
 ("gid"	?$(CGb(B)
 ("gj"	?$(CGc(B)
 ("gjr"	?$(CGd(B)
 ("gjs"	?$(CGe(B)
 ("gjf"	?$(CGf(B)
 ("gjfa"	?$(CGg(B)
 ("gja"	?$(CGh(B)
 ("gjq"	?$(CGi(B)
 ("gjt"	?$(CGj(B)
 ("gjd"	?$(CGk(B)
 ("gp"	?$(CGl(B)
 ("gpr"	?$(CGm(B)
 ("gps"	?$(CGn(B)
 ("gpf"	?$(CGo(B)
 ("gpa"	?$(CGp(B)
 ("gpq"	?$(CGq(B)
 ("gpt"	?$(CGr(B)
 ("gpd"	?$(CGs(B)
 ("gu"	?$(CGt(B)
 ("gur"	?$(CGu(B)
 ("gus"	?$(CGv(B)
 ("guf"	?$(CGw(B)
 ("gua"	?$(CGx(B)
 ("guq"	?$(CGy(B)
 ("gut"	?$(CGz(B)
 ("guT"	?$(CG{(B)
 ("gud"	?$(CG|(B)
 ("gP"	?$(CG}(B)
 ("gPs"	?$(CG~(B)
 ("gPf"	?$(CH!(B)
 ("gPq"	?$(CH"(B)
 ("gh"	?$(CH#(B)
 ("ghr"	?$(CH$(B)
 ("ghs"	?$(CH%(B)
 ("ghf"	?$(CH&(B)
 ("ghfx"	?$(CH'(B)
 ("gha"	?$(CH((B)
 ("ghq"	?$(CH)(B)
 ("ght"	?$(CH*(B)
 ("ghd"	?$(CH+(B)
 ("ghx"	?$(CH,(B)
 ("ghk"	?$(CH-(B)
 ("ghkr"	?$(CH.(B)
 ("ghks"	?$(CH/(B)
 ("ghkf"	?$(CH0(B)
 ("ghkt"	?$(CH1(B)
 ("ghkd"	?$(CH2(B)
 ("gho"	?$(CH3(B)
 ("ghor"	?$(CH4(B)
 ("ghos"	?$(CH5(B)
 ("ghot"	?$(CH6(B)
 ("ghod"	?$(CH7(B)
 ("ghl"	?$(CH8(B)
 ("ghlr"	?$(CH9(B)
 ("ghls"	?$(CH:(B)
 ("ghlf"	?$(CH;(B)
 ("ghlq"	?$(CH<(B)
 ("ghlt"	?$(CH=(B)
 ("ghld"	?$(CH>(B)
 ("gy"	?$(CH?(B)
 ("gys"	?$(CH@(B)
 ("gyf"	?$(CHA(B)
 ("gyq"	?$(CHB(B)
 ("gyt"	?$(CHC(B)
 ("gn"	?$(CHD(B)
 ("gnr"	?$(CHE(B)
 ("gns"	?$(CHF(B)
 ("gnf"	?$(CHG(B)
 ("gnfx"	?$(CHH(B)
 ("gna"	?$(CHI(B)
 ("gnt"	?$(CHJ(B)
 ("gnd"	?$(CHK(B)
 ("gnj"	?$(CHL(B)
 ("gnjs"	?$(CHM(B)
 ("gnjf"	?$(CHN(B)
 ("gnja"	?$(CHO(B)
 ("gnjd"	?$(CHP(B)
 ("gnp"	?$(CHQ(B)
 ("gnpr"	?$(CHR(B)
 ("gnps"	?$(CHS(B)
 ("gnpf"	?$(CHT(B)
 ("gnpd"	?$(CHU(B)
 ("gnl"	?$(CHV(B)
 ("gnlr"	?$(CHW(B)
 ("gnls"	?$(CHX(B)
 ("gnlf"	?$(CHY(B)
 ("gnla"	?$(CHZ(B)
 ("gnlq"	?$(CH[(B)
 ("gnlt"	?$(CH\(B)
 ("gnld"	?$(CH](B)
 ("gb"	?$(CH^(B)
 ("gbr"	?$(CH_(B)
 ("gbs"	?$(CH`(B)
 ("gbf"	?$(CHa(B)
 ("gba"	?$(CHb(B)
 ("gbt"	?$(CHc(B)
 ("gbd"	?$(CHd(B)
 ("gm"	?$(CHe(B)
 ("gmr"	?$(CHf(B)
 ("gms"	?$(CHg(B)
 ("gmsg"	?$(CHh(B)
 ("gme"	?$(CHi(B)
 ("gmf"	?$(CHj(B)
 ("gmfr"	?$(CHk(B)
 ("gma"	?$(CHl(B)
 ("gmq"	?$(CHm(B)
 ("gmt"	?$(CHn(B)
 ("gmd"	?$(CHo(B)
 ("gmx"	?$(CHp(B)
 ("gml"	?$(CHq(B)
 ("gmls"	?$(CHr(B)
 ("gmlf"	?$(CHs(B)
 ("gmla"	?$(CHt(B)
 ("gmlq"	?$(CHu(B)
 ("gmld"	?$(CHv(B)
 ("gl"	?$(CHw(B)
 ("glr"	?$(CHx(B)
 ("gls"	?$(CHy(B)
 ("glf"	?$(CHz(B)
 ("gla"	?$(CH{(B)
 ("glq"	?$(CH|(B)
 ("glt"	?$(CH}(B)
 ("gld"	?$(CH~(B)
 
 ("Z!"	?$(C#!(B)
 ("Z\""	?$(C#"(B)
 ("Z#"	?$(C##(B)
 ("Z$"	?$(C#$(B)
 ("Z%"	?$(C#%(B)
 ("Z&"	?$(C#&(B)
 ("Z'"	?$(C#'(B)
 ("Z("	?$(C#((B)
 ("Z)"	?$(C#)(B)
 ("Z*"	?$(C#*(B)
 ("Z+"	?$(C#+(B)
 ("Z,"	?$(C#,(B)
 ("Z-"	?$(C#-(B)
 ("Z."	?$(C#.(B)
 ("Z/"	?$(C#/(B)
 ("Z0"	?$(C#0(B)
 ("Z1"	?$(C#1(B)
 ("Z2"	?$(C#2(B)
 ("Z3"	?$(C#3(B)
 ("Z4"	?$(C#4(B)
 ("Z5"	?$(C#5(B)
 ("Z6"	?$(C#6(B)
 ("Z7"	?$(C#7(B)
 ("Z8"	?$(C#8(B)
 ("Z9"	?$(C#9(B)
 ("Z:"	?$(C#:(B)
 ("Z;"	?$(C#;(B)
 ("Z<"	?$(C#<(B)
 ("Z="	?$(C#=(B)
 ("Z>"	?$(C#>(B)
 ("Z?"	?$(C#?(B)
 ("Z@"	?$(C#@(B)
 ("ZA"	?$(C#A(B)
 ("ZB"	?$(C#B(B)
 ("ZC"	?$(C#C(B)
 ("ZD"	?$(C#D(B)
 ("ZE"	?$(C#E(B)
 ("ZF"	?$(C#F(B)
 ("ZG"	?$(C#G(B)
 ("ZH"	?$(C#H(B)
 ("ZI"	?$(C#I(B)
 ("ZJ"	?$(C#J(B)
 ("ZK"	?$(C#K(B)
 ("ZL"	?$(C#L(B)
 ("ZM"	?$(C#M(B)
 ("ZN"	?$(C#N(B)
 ("ZO"	?$(C#O(B)
 ("ZP"	?$(C#P(B)
 ("ZQ"	?$(C#Q(B)
 ("ZR"	?$(C#R(B)
 ("ZS"	?$(C#S(B)
 ("ZT"	?$(C#T(B)
 ("ZU"	?$(C#U(B)
 ("ZV"	?$(C#V(B)
 ("ZW"	?$(C#W(B)
 ("ZX"	?$(C#X(B)
 ("ZY"	?$(C#Y(B)
 ("ZZ"	?$(C#Z(B)
 ("Z["	?$(C#[(B)
 ("SW"	?$(C#\(B)
 ("Z]"	?$(C#](B)
 ("Z^"	?$(C#^(B)
 ("Z_"	?$(C#_(B)
 ("Z`"	?$(C#`(B)
 ("Za"	?$(C#a(B)
 ("Zb"	?$(C#b(B)
 ("Zc"	?$(C#c(B)
 ("Zd"	?$(C#d(B)
 ("Ze"	?$(C#e(B)
 ("Zf"	?$(C#f(B)
 ("Zg"	?$(C#g(B)
 ("Zh"	?$(C#h(B)
 ("Zi"	?$(C#i(B)
 ("Zj"	?$(C#j(B)
 ("Zk"	?$(C#k(B)
 ("Zl"	?$(C#l(B)
 ("Zm"	?$(C#m(B)
 ("Zn"	?$(C#n(B)
 ("Zo"	?$(C#o(B)
 ("Zp"	?$(C#p(B)
 ("Zq"	?$(C#q(B)
 ("Zr"	?$(C#r(B)
 ("Zs"	?$(C#s(B)
 ("Zt"	?$(C#t(B)
 ("Zu"	?$(C#u(B)
 ("Zv"	?$(C#v(B)
 ("Zw"	?$(C#w(B)
 ("Zx"	?$(C#x(B)
 ("Zy"	?$(C#y(B)
 ("Zz"	?$(C#z(B)
 ("Z{"	?$(C#{(B)
 ("Z|"	?$(C#|(B)
 ("Z}"	?$(C#}(B)
 ("Z^-"	?$(C#~(B)
 
 ("HS"	?$(C$U(B)
 ("Hse"	?$(C$V(B)
 ("Hst"	?$(C$W(B)
 ("HsT"	?$(C$X(B)
 ("Hfrt"	?$(C$Y(B)
 ("Hfqt"	?$(C$[(B)
 ("Hfe"	?$(C$Z(B)
 ("HfT"	?$(C$\(B)
 ("HfG"	?$(C$](B)
 ("Haq"	?$(C$^(B)
 ("Hat"	?$(C$_(B)
 ("HaT"	?$(C$`(B)
 ("Had"	?$(C$a(B)
 ("Hqr"	?$(C$b(B)
 ("Hqe"	?$(C$c(B)
 ("Hqtr"	?$(C$d(B)
 ("Hqte"	?$(C$e(B)
 ("Hqw"	?$(C$f(B)
 ("Hqx"	?$(C$g(B)
 ("Hqd"	?$(C$h(B)
 ("HQd"	?$(C$i(B)
 ("Htr"	?$(C$j(B)
 ("Hts"	?$(C$k(B)
 ("Hte"	?$(C$l(B)
 ("Htq"	?$(C$m(B)
 ("Htw"	?$(C$n(B)
 ("HT"	?$(C$o(B)
 ("HD"	?$(C$p(B)
 ("Hd"	?$(C$q(B)
 ("Hdw"	?$(C$r(B)
 ("HdT"	?$(C$s(B)
 ("Hvd"	?$(C$t(B)
 ("HG"	?$(C$u(B)
 ("Hg"	?$(C$v(B)
 ("Hyi"	?$(C$w(B)
 ("HyO"	?$(C$x(B)
 ("Hyl"	?$(C$y(B)
 ("Hbu"	?$(C$z(B)
 ("HbP"	?$(C${(B)
 ("Hbl"	?$(C$|(B)
 ("H."	?$(C$}(B)
 ("H.l"	?$(C$~(B)
 
 ("SY"	?$(C!M(B)
 ("SP"	?$(C!L(B)
 ("S%"	?$(C"6(B)
 ("Swn"	?$(C"_(B)
 ("Sks"	?$(C"^(B)
 ("SNo"	?$(C"`(B)
 ("SCo"	?$(C"a(B)
 ("STM"	?$(C"b(B)
 ("Sam"	?$(C"c(B)
 ("Spm"	?$(C"d(B)
 ("STel"	?$(C"e(B)
 ("SC"	?$(C!I(B)
 ("SA"	?$(C!J(B)
 ("SC/"	?$(C!K(B)
 ("SF"	?$(C"5(B))

;;; hangul.el ends here
