;;; quail/cyrillic.el -- Quail package for inputting Cyrillic characters

;; Copyright (C) 1997 Electrotechnical Laboratory, JAPAN.
;; Licensed to the Free Software Foundation.

;; Keywords: multilingual, input method, Cyrillic

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'quail)

(quail-define-package
 "cyrillic-jcuken" "Cyrillic" ",L69(B" nil
 ",L9FC:5=(B keyboard layout widely used in Russia (ISO 8859-5 encoding)"
 nil t t t t)

;;  1! 2@ 3# 4" 5: 6, 7. 8* 9( 0) -_ =+ ,L!(B
;;   ,L9(B  ,LF(B  ,LC(B  ,L:(B  ,L5(B  ,L=(B  ,L3(B  ,LH(B  ,LI(B  ,L7(B  ,LE(B  ,Lj(B
;;    ,LD(B  ,LK(B  ,L2(B  ,L0(B  ,L?(B  ,L@(B  ,L>(B  ,L;(B  ,L4(B ,L6(B  ,LM(B
;;     ,LO(B  ,LG(B  ,LA(B  ,L<(B  ,L8(B  ,LB(B  ,LL(B  ,L1(B  ,LN(B  /?

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?-)
 ("=" ?=)
 ("`" ?,Lq(B)
 ("q" ?,LY(B)
 ("w" ?,Lf(B)
 ("e" ?,Lc(B)
 ("r" ?,LZ(B)
 ("t" ?,LU(B)
 ("y" ?,L](B)
 ("u" ?,LS(B)
 ("i" ?,Lh(B)
 ("o" ?,Li(B)
 ("p" ?,LW(B)
 ("[" ?,Le(B)
 ("]" ?,Lj(B)
 ("a" ?,Ld(B)
 ("s" ?,Lk(B)
 ("d" ?,LR(B)
 ("f" ?,LP(B)
 ("g" ?,L_(B)
 ("h" ?,L`(B)
 ("j" ?,L^(B)
 ("k" ?,L[(B)
 ("l" ?,LT(B)
 (";" ?,LV(B)
 ("'" ?,Lm(B)
 ("\\" ?\\)
 ("z" ?,Lo(B)
 ("x" ?,Lg(B)
 ("c" ?,La(B)
 ("v" ?,L\(B)
 ("b" ?,LX(B)
 ("n" ?,Lb(B)
 ("m" ?,Ll(B)
 ("," ?,LQ(B)
 ("." ?,Ln(B)
 ("/" ?/)
 
 ("!" ?!)
 ("@" ?@)
 ("#" ?#)
 ("$" ?\")
 ("%" ?:)
 ("^" ?,)
 ("&" ?.)
 ("*" ?*)
 ("(" ?()
  (")" ?))
 ("_" ?_)
 ("+" ?+)
 ("~" ?,L!(B)
 ("Q" ?,L9(B)
 ("W" ?,LF(B)
 ("E" ?,LC(B)
 ("R" ?,L:(B)
 ("T" ?,L5(B)
 ("Y" ?,L=(B)
 ("U" ?,L3(B)
 ("I" ?,LH(B)
 ("O" ?,LI(B)
 ("P" ?,L7(B)
 ("{" ?,LE(B)
 ("}" ?,LJ(B)
 ("A" ?,LD(B)
 ("S" ?,LK(B)
 ("D" ?,L2(B)
 ("F" ?,L0(B)
 ("G" ?,L?(B)
 ("H" ?,L@(B)
 ("J" ?,L>(B)
 ("K" ?,L;(B)
 ("L" ?,L4(B)
 (":" ?,L6(B)
 ("\"" ?,LM(B)
 ("|" ?|)
 ("Z" ?,LO(B)
 ("X" ?,LG(B)
 ("C" ?,LA(B)
 ("V" ?,L<(B)
 ("B" ?,L8(B)
 ("N" ?,LB(B)
 ("M" ?,LL(B)
 ("<" ?,L1(B)
 (">" ?,LN(B)
 ("?" ??))

;;

(quail-define-package
 "cyrillic-jis-russian" "Cyrillic" "$B'('+(B" nil
 "$B'+'8'5','&'/(B keyboard layout same as JCUKEN (JIS X0208.1983 encoding)"
		      nil t t t t)

;;  1! 2@ 3# 4" 5: 6, 7. 8* 9( 0) -_ =+ ,L!(B
;;   ,L9(B  ,LF(B  ,LC(B  ,L:(B  ,L5(B  ,L=(B  ,L3(B  ,LH(B  ,LI(B  ,L7(B  ,LE(B  ,Lj(B
;;    ,LD(B  ,LK(B  ,L2(B  ,L0(B  ,L?(B  ,L@(B  ,L>(B  ,L;(B  ,L4(B  ,L6(B  ,LM(B
;;     ,LO(B  ,LG(B  ,LA(B  ,L<(B  ,L8(B  ,LB(B  ,LL(B  ,L1(B  ,LN(B  /?

(quail-define-rules
 ("1" ?$B#1(B)
 ("2" ?$B#2(B)
 ("3" ?$B#3(B)
 ("4" ?$B#4(B)
 ("5" ?$B#5(B)
 ("6" ?$B#6(B)
 ("7" ?$B#7(B)
 ("8" ?$B#8(B)
 ("9" ?$B#9(B)
 ("0" ?$B#0(B)
 ("-" ?$B!](B)
 ("=" ?$B!a(B)
 ("`" ?$B'W(B)
 ("q" ?$B'[(B)
 ("w" ?$B'h(B)
 ("e" ?$B'e(B)
 ("r" ?$B'\(B)
 ("t" ?$B'V(B)
 ("y" ?$B'_(B)
 ("u" ?$B'T(B)
 ("i" ?$B'j(B)
 ("o" ?$B'k(B)
 ("p" ?$B'Y(B)
 ("[" ?$B'g(B)
 ("]" ?$B'l(B)
 ("a" ?$B'f(B)
 ("s" ?$B'm(B)
 ("d" ?$B'S(B)
 ("f" ?$B'Q(B)
 ("g" ?$B'a(B)
 ("h" ?$B'b(B)
 ("j" ?$B'`(B)
 ("k" ?$B'](B)
 ("l" ?$B'U(B)
 (";" ?$B'X(B)
 ("'" ?$B'o(B)
 ("\\" ?$B!@(B)
 ("z" ?$B'q(B)
 ("x" ?$B'i(B)
 ("c" ?$B'c(B)
 ("v" ?$B'^(B)
 ("b" ?$B'Z(B)
 ("n" ?$B'd(B)
 ("m" ?$B'n(B)
 ("," ?$B'R(B)
 ("." ?$B'p(B)
 ("/" ?$B!?(B)
 
 ("!" ?$B!*(B)
 ("@" ?$B!w(B)
 ("#" ?$B!t(B)
 ("$" ?$B!I(B)
 ("%" ?$B!'(B)
 ("^" ?$B!$(B)
 ("&" ?$B!%(B)
 ("*" ?$B!v(B)
 ("(" ?$B!J(B)
  (")" ?$B!K(B)
 ("_" ?$B!2(B)
 ("+" ?$B!\(B)
 ("~" ?$B''(B)
 ("Q" ?$B'+(B)
 ("W" ?$B'8(B)
 ("E" ?$B'5(B)
 ("R" ?$B',(B)
 ("T" ?$B'&(B)
 ("Y" ?$B'/(B)
 ("U" ?$B'$(B)
 ("I" ?$B':(B)
 ("O" ?$B';(B)
 ("P" ?$B')(B)
 ("{" ?$B'7(B)
 ("}" ?$B'<(B)
 ("A" ?$B'6(B)
 ("S" ?$B'=(B)
 ("D" ?$B'#(B)
 ("F" ?$B'!(B)
 ("G" ?$B'1(B)
 ("H" ?$B'2(B)
 ("J" ?$B'0(B)
 ("K" ?$B'-(B)
 ("L" ?$B'%(B)
 (":" ?$B'((B)
 ("\"" ?$B'?(B)
 ("|" ?$B!C(B)
 ("Z" ?$B'A(B)
 ("X" ?$B'9(B)
 ("C" ?$B'3(B)
 ("V" ?$B'.(B)
 ("B" ?$B'*(B)
 ("N" ?$B'4(B)
 ("M" ?$B'>(B)
 ("<" ?$B'"(B)
 (">" ?$B'@(B)
 ("?" ?$B!)(B))

;;

(quail-define-package
 "cyrillic-macedonian" "Cyrillic" ",L6(BM" nil
 ",L)*5@B7(B-,L#,(B keyboard layout based on JUS.I.K1.004 (ISO 8859-5 encoding)"
 nil t t t t)

;;  1! 2" 3# 4$ 5% 6& 7' 8( 9) 0= /? +* <>
;;   ,L)(B  ,L*(B  ,L5(B  ,L@(B  ,LB(B  ,L7(B  ,LC(B  ,L8(B  ,L>(B  ,L?(B  ,LH(B  ,L#(B
;;    ,L0(B  ,LA(B  ,L4(B  ,LD(B  ,L3(B  ,LE(B  ,L((B  ,L:(B  ,L;(B  ,LG(B  ,L,(B  ,L6(B
;;     ,L%(B  ,L/(B  ,LF(B  ,L2(B  ,L1(B  ,L=(B  ,L<(B  ,; .: -_

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?/)
 ("=" ?+)
 ("`" ?<)
 ("q" ?,Ly(B)
 ("w" ?,Lz(B)
 ("e" ?,LU(B)
 ("r" ?,L`(B)
 ("t" ?,Lb(B)
 ("y" ?,LW(B)
 ("u" ?,Lc(B)
 ("i" ?,LX(B)
 ("o" ?,L^(B)
 ("p" ?,L_(B)
 ("[" ?,Lh(B)
 ("]" ?,Ls(B)
 ("a" ?,LP(B)
 ("s" ?,La(B)
 ("d" ?,LT(B)
 ("f" ?,Ld(B)
 ("g" ?,LS(B)
 ("h" ?,Le(B)
 ("j" ?,Lx(B)
 ("k" ?,LZ(B)
 ("l" ?,L[(B)
 (";" ?,Lg(B)
 ("'" ?,L|(B)
 ("\\" ?,LV(B)
 ("z" ?,Lu(B)
 ("x" ?,L(B)
 ("c" ?,Lf(B)
 ("v" ?,LR(B)
 ("b" ?,LQ(B)
 ("n" ?,L](B)
 ("m" ?,L\(B)
 ("," ?,)
 ("." ?.)
 ("/" ?-)
 
 ("!" ?!)
 ("@" ?\")
 ("#" ?#)
 ("$" ?$)
 ("%" ?%)
 ("^" ?&)
 ("&" ?')
 ("*" ?\()
 ("(" ?\))
 (")" ?=)
 ("_" ??)
 ("+" ?*)
 ("~" ?>)
 ("Q" ?,L)(B)
 ("W" ?,L*(B)
 ("E" ?,L5(B)
 ("R" ?,L@(B)
 ("T" ?,LB(B)
 ("Y" ?,L7(B)
 ("U" ?,LC(B)
 ("I" ?,L8(B)
 ("O" ?,L>(B)
 ("P" ?,L?(B)
 ("{" ?,LH(B)
 ("}" ?,L#(B)
 ("A" ?,L0(B)
 ("S" ?,LA(B)
 ("D" ?,L4(B)
 ("F" ?,LD(B)
 ("G" ?,L3(B)
 ("H" ?,LE(B)
 ("J" ?,L((B)
 ("K" ?,L:(B)
 ("L" ?,L;(B)
 (":" ?,LG(B)
 ("\"" ?,L,(B)
 ("|" ?,L6(B)
 ("Z" ?,L%(B)
 ("X" ?,L/(B)
 ("C" ?,LF(B)
 ("V" ?,L2(B)
 ("B" ?,L1(B)
 ("N" ?,L=(B)
 ("M" ?,L<(B)
 ("<" ?\;)
 (">" ?:)
 ("?" ?_))

;;

(quail-define-package
 "cyrillic-serbian" "Cyrillic" ",L6(BS" nil
 ",L)*5@B7(B-,L"+(B keyboard layout based on JUS.I.K1.005 (ISO 8859-5 encoding)"
		      nil t t t t)

;;  1! 2" 3# 4$ 5% 6& 7' 8( 9) 0= /? +* <>
;;   ,L)(B  ,L*(B  ,L5(B  ,L@(B  ,LB(B  ,L7(B  ,LC(B  ,L8(B  ,L>(B  ,L?(B  ,LH(B  ,L"(B
;;    ,L0(B  ,LA(B  ,L4(B  ,LD(B  ,L3(B  ,LE(B  ,L((B  ,L:(B  ,L;(B  ,LG(B  ,L+(B  ,L6(B
;;     ,L%(B  ,L/(B  ,LF(B  ,L2(B  ,L1(B  ,L=(B  ,L<(B  ,; .: -_

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?/)
 ("=" ?+)
 ("`" ?<)
 ("q" ?,Ly(B)
 ("w" ?,Lz(B)
 ("e" ?,LU(B)
 ("r" ?,L`(B)
 ("t" ?,Lb(B)
 ("y" ?,LW(B)
 ("u" ?,Lc(B)
 ("i" ?,LX(B)
 ("o" ?,L^(B)
 ("p" ?,L_(B)
 ("[" ?,Lh(B)
 ("]" ?,Lr(B)
 ("a" ?,LP(B)
 ("s" ?,La(B)
 ("d" ?,LT(B)
 ("f" ?,Ld(B)
 ("g" ?,LS(B)
 ("h" ?,Le(B)
 ("j" ?,Lx(B)
 ("k" ?,LZ(B)
 ("l" ?,L[(B)
 (";" ?,Lg(B)
 ("'" ?,L{(B)
 ("\\" ?,LV(B)
 ("z" ?,Lu(B)
 ("x" ?,L(B)
 ("c" ?,Lf(B)
 ("v" ?,LR(B)
 ("b" ?,LQ(B)
 ("n" ?,L](B)
 ("m" ?,L\(B)
 ("," ?,)
 ("." ?.)
 ("/" ?-)
 
 ("!" ?!)
 ("@" ?\")
 ("#" ?#)
 ("$" ?$)
 ("%" ?%)
 ("^" ?&)
 ("&" ?')
 ("*" ?\()
 ("(" ?\))
 (")" ?=)
 ("_" ??)
 ("+" ?*)
 ("~" ?>)
 ("Q" ?,L)(B)
 ("W" ?,L*(B)
 ("E" ?,L5(B)
 ("R" ?,L@(B)
 ("T" ?,LB(B)
 ("Y" ?,L7(B)
 ("U" ?,LC(B)
 ("I" ?,L8(B)
 ("O" ?,L>(B)
 ("P" ?,L?(B)
 ("{" ?,LH(B)
 ("}" ?,L"(B)
 ("A" ?,L0(B)
 ("S" ?,LA(B)
 ("D" ?,L4(B)
 ("F" ?,LD(B)
 ("G" ?,L3(B)
 ("H" ?,LE(B)
 ("J" ?,L((B)
 ("K" ?,L:(B)
 ("L" ?,L;(B)
 (":" ?,LG(B)
 ("\"" ?,L+(B)
 ("|" ?,L6(B)
 ("Z" ?,L%(B)
 ("X" ?,L/(B)
 ("C" ?,LF(B)
 ("V" ?,L2(B)
 ("B" ?,L1(B)
 ("N" ?,L=(B)
 ("M" ?,L<(B)
 ("<" ?\;)
 (">" ?:)
 ("?" ?_))

;;

(quail-define-package
 "cyrillic-beylorussian" "Cyrillic" ",L6(BB" nil
 ",L)*5@B7(B-,L&.(B BEYLORUSSIAN (ISO 8859-5 encoding)"
 nil t t t t)

;;  1! 2" 3# 4$ 5% 6& 7' 8( 9) 0= /? +* <>
;;   ,L)(B  ,L*(B  ,L5(B  ,L@(B  ,LB(B  ,L7(B  ,LC(B  ,L8(B  ,L>(B  ,L?(B  ,LH(B  ,L&(B
;;    ,L0(B  ,LA(B  ,L4(B  ,LD(B  ,L3(B  ,LE(B  ,L((B  ,L:(B  ,L;(B  ,LG(B  ,L.(B  ,L6(B
;;     ,L%(B  ,L/(B  ,LF(B  ,L2(B  ,L1(B  ,L=(B  ,L<(B  ,; .: -_

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?/)
 ("=" ?+)
 ("`" ?<)
 ("q" ?,Ly(B)
 ("w" ?,Lz(B)
 ("e" ?,LU(B)
 ("r" ?,L`(B)
 ("t" ?,Lb(B)
 ("y" ?,LW(B)
 ("u" ?,Lc(B)
 ("i" ?,LX(B)
 ("o" ?,L^(B)
 ("p" ?,L_(B)
 ("[" ?,Lh(B)
 ("]" ?,Lv(B)
 ("a" ?,LP(B)
 ("s" ?,La(B)
 ("d" ?,LT(B)
 ("f" ?,Ld(B)
 ("g" ?,LS(B)
 ("h" ?,Le(B)
 ("j" ?,Lx(B)
 ("k" ?,LZ(B)
 ("l" ?,L[(B)
 (";" ?,Lg(B)
 ("'" ?,L~(B)
 ("\\" ?,LV(B)
 ("z" ?,Lu(B)
 ("x" ?,L(B)
 ("c" ?,Lf(B)
 ("v" ?,LR(B)
 ("b" ?,LQ(B)
 ("n" ?,L](B)
 ("m" ?,L\(B)
 ("," ?,)
 ("." ?.)
 ("/" ?-)
 
 ("!" ?!)
 ("@" ?\")
 ("#" ?#)
 ("$" ?$)
 ("%" ?%)
 ("^" ?&)
 ("&" ?')
 ("*" ?\()
 ("(" ?\))
 (")" ?=)
 ("_" ??)
 ("+" ?*)
 ("~" ?>)
 ("Q" ?,L)(B)
 ("W" ?,L*(B)
 ("E" ?,L5(B)
 ("R" ?,L@(B)
 ("T" ?,LB(B)
 ("Y" ?,L7(B)
 ("U" ?,LC(B)
 ("I" ?,L8(B)
 ("O" ?,L>(B)
 ("P" ?,L?(B)
 ("{" ?,LH(B)
 ("}" ?,L&(B)
 ("A" ?,L0(B)
 ("S" ?,LA(B)
 ("D" ?,L4(B)
 ("F" ?,LD(B)
 ("G" ?,L3(B)
 ("H" ?,LE(B)
 ("J" ?,L((B)
 ("K" ?,L:(B)
 ("L" ?,L;(B)
 (":" ?,LG(B)
 ("\"" ?,L.(B)
 ("|" ?,L6(B)
 ("Z" ?,L%(B)
 ("X" ?,L/(B)
 ("C" ?,LF(B)
 ("V" ?,L2(B)
 ("B" ?,L1(B)
 ("N" ?,L=(B)
 ("M" ?,L<(B)
 ("<" ?\;)
 (">" ?:)
 ("?" ?_))

;;

(quail-define-package 
 "cyrillic-ukrainian" "Cyrillic" ",L6(BU" nil
 ",L$'5@B7(B-,L&.(B UKRAINIAN (ISO 8859-5 encoding)

Sorry, but 'ghe with upturn' is not included in ISO 8859-5"
 nil t t t t)

;;  1! 2" 3# 4$ 5% 6& 7' 8( 9) 0= /? +* <>
;;   ,L$(B  ,L'(B  ,L5(B  ,L@(B  ,LB(B  ,L7(B  ,LC(B  ,L8(B  ,L>(B  ,L?(B  ,LH(B  ,L&(B
;;    ,L0(B  ,LA(B  ,L4(B  ,LD(B  ,L3(B  ,LE(B  ,L((B  ,L:(B  ,L;(B  ,LG(B  ,L.(B  ,L6(B
;;     ,L%(B  ,L/(B  ,LF(B  ,L2(B  ,L1(B  ,L=(B  ,L<(B  ,; .: -_

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?/)
 ("=" ?+)
 ("`" ?<)
 ("q" ?,Lt(B)
 ("w" ?,Lw(B)
 ("e" ?,LU(B)
 ("r" ?,L`(B)
 ("t" ?,Lb(B)
 ("y" ?,LW(B)
 ("u" ?,Lc(B)
 ("i" ?,LX(B)
 ("o" ?,L^(B)
 ("p" ?,L_(B)
 ("[" ?,Lh(B)
 ("]" ?,Lv(B)
 ("a" ?,LP(B)
 ("s" ?,La(B)
 ("d" ?,LT(B)
 ("f" ?,Ld(B)
 ("g" ?,LS(B)
 ("h" ?,Le(B)
 ("j" ?,Lx(B)
 ("k" ?,LZ(B)
 ("l" ?,L[(B)
 (";" ?,Lg(B)
 ("'" ?,L~(B)
 ("\\" ?,LV(B)
 ("z" ?,Lu(B)
 ("x" ?,L(B)
 ("c" ?,Lf(B)
 ("v" ?,LR(B)
 ("b" ?,LQ(B)
 ("n" ?,L](B)
 ("m" ?,L\(B)
 ("," ?,)
 ("." ?.)
 ("/" ?-)
 
 ("!" ?!)
 ("@" ?\")
 ("#" ?#)
 ("$" ?$)
 ("%" ?%)
 ("^" ?&)
 ("&" ?')
 ("*" ?\()
 ("(" ?\))
 (")" ?=)
 ("_" ??)
 ("+" ?*)
 ("~" ?>)
 ("Q" ?,L$(B)
 ("W" ?,L'(B)
 ("E" ?,L5(B)
 ("R" ?,L@(B)
 ("T" ?,LB(B)
 ("Y" ?,L7(B)
 ("U" ?,LC(B)
 ("I" ?,L8(B)
 ("O" ?,L>(B)
 ("P" ?,L?(B)
 ("{" ?,LH(B)
 ("}" ?,L&(B)
 ("A" ?,L0(B)
 ("S" ?,LA(B)
 ("D" ?,L4(B)
 ("F" ?,LD(B)
 ("G" ?,L3(B)
 ("H" ?,LE(B)
 ("J" ?,L((B)
 ("K" ?,L:(B)
 ("L" ?,L;(B)
 (":" ?,LG(B)
 ("\"" ?,L.(B)
 ("|" ?,L6(B)
 ("Z" ?,L%(B)
 ("X" ?,L/(B)
 ("C" ?,LF(B)
 ("V" ?,L2(B)
 ("B" ?,L1(B)
 ("N" ?,L=(B)
 ("M" ?,L<(B)
 ("<" ?\;)
 (">" ?:)
 ("?" ?_))

;;

(quail-define-package 
 "cyrillic-yawerty" "Cyrillic" ",L6O(B" nil
 ",LO25@BK(B Roman transcription (ISO 8859-5 encoding)

This layout is based on Roman transcription.
When preceded by a '/', the second and the third rows (number key row) change
as follows.

  keytop | Q  W  E  R  T  Y  U  I  O  P  A  S  D
 --------+---------------------------------------
  input  | ,L"(B  ,L#(B  ,L$(B  ,L%(B  ,L&(B  ,L'(B  ,L((B  ,L)(B  ,L*(B  ,L+(B  ,L,(B  ,L.(B  ,L/(B"
		      nil t t t t)

;;  1! 2,Lq(B 3,Lj(B 4,L!(B 5% 6^ 7& 8* 9( 0) -_ ,LG(B  ,LN(B
;;   ,LO(B  ,L2(B  ,L5(B  ,L@(B  ,LB(B  ,LK(B  ,LC(B  ,L8(B  ,L>(B  ,L?(B  ,LH(B  ,LI(B
;;    ,L0(B  ,LA(B  ,L4(B  ,LD(B  ,L3(B  ,LE(B  ,L9(B  ,L:(B  ,L;(B  ;: '" ,LM(B
;;     ,L7(B  ,LL(B  ,LF(B  ,L6(B  ,L1(B  ,L=(B  ,L<(B  ,< .> /?

;;  1! 2,Lq(B 3,Lj(B 4,L!(B 5% 6^ 7& 8* 9( 0) -_ ,LG(B  ,LN(B
;;   ,L"(B  ,L#(B  ,L$(B  ,L%(B  ,L&(B  ,L'(B  ,L((B  ,L)(B  ,L*(B  ,L+(B  ,LH(B  ,LI(B
;;    ,L,(B  ,L.(B  ,L/(B  ,LD(B  ,L3(B  ,LE(B  ,L9(B  ,L:(B  ,L;(B  ;: '" ,LM(B
;;     ,L7(B  ,LL(B  ,LF(B  ,L6(B  ,L1(B  ,L=(B  ,L<(B  ,< .> /?

(quail-define-rules
 ("1" ?1)
 ("2" ?2)
 ("3" ?3)
 ("4" ?4)
 ("5" ?5)
 ("6" ?6)
 ("7" ?7)
 ("8" ?8)
 ("9" ?9)
 ("0" ?0)
 ("-" ?-)
 ("=" ?,Lg(B)
 ("`" ?,Ln(B)
 ("q" ?,Lo(B)
 ("w" ?,LR(B)
 ("e" ?,LU(B)
 ("r" ?,L`(B)
 ("t" ?,Lb(B)
 ("y" ?,Lk(B)
 ("u" ?,Lc(B)
 ("i" ?,LX(B)
 ("o" ?,L^(B)
 ("p" ?,L_(B)
 ("[" ?,Lh(B)
 ("]" ?,Li(B)
 ("a" ?,LP(B)
 ("s" ?,La(B)
 ("d" ?,LT(B)
 ("f" ?,Ld(B)
 ("g" ?,LS(B)
 ("h" ?,Le(B)
 ("j" ?,LY(B)
 ("k" ?,LZ(B)
 ("l" ?,L[(B)
 (";" ?\;)
 ("'" ?')
 ("\\" ?,Lm(B)
 ("z" ?,LW(B)
 ("x" ?,Ll(B)
 ("c" ?,Lf(B)
 ("v" ?,LV(B)
 ("b" ?,LQ(B)
 ("n" ?,L](B)
 ("m" ?,L\(B)
 ("," ?,)
 ("." ?.)
 ("/" ?/)
 
 ("!" ?!)
 ("@" ?,Lq(B)
 ("#" ?,Lj(B)
 ("$" ?,L!(B)
 ("%" ?%)
 ("^" ?^)
 ("&" ?&)
 ("*" ?*)
 ("(" ?\()
 (")" ?\))
 ("_" ?_)
 ("+" ?,LG(B)
 ("~" ?,LN(B)
 ("Q" ?,LO(B)
 ("W" ?,L2(B)
 ("E" ?,L5(B)
 ("R" ?,L@(B)
 ("T" ?,LB(B)
 ("Y" ?,LK(B)
 ("U" ?,LC(B)
 ("I" ?,L8(B)
 ("O" ?,L>(B)
 ("P" ?,L?(B)
 ("{" ?,LH(B)
 ("}" ?,LI(B)
 ("A" ?,L0(B)
 ("S" ?,LA(B)
 ("D" ?,L4(B)
 ("F" ?,LD(B)
 ("G" ?,L3(B)
 ("H" ?,LE(B)
 ("J" ?,L9(B)
 ("K" ?,L:(B)
 ("L" ?,L;(B)
 (":" ?:)
 ("\"" ?\")
 ("|" ?,LM(B)
 ("Z" ?,L7(B)
 ("X" ?,LL(B)
 ("C" ?,LF(B)
 ("V" ?,L6(B)
 ("B" ?,L1(B)
 ("N" ?,L=(B)
 ("M" ?,L<(B)
 ("<" ?<)
 (">" ?>)
 ("?" ??)
 
 ("/q" ?,Lr(B)
 ("/w" ?,Ls(B)
 ("/e" ?,Lt(B)
 ("/r" ?,Lu(B)
 ("/t" ?,Lv(B)
 ("/y" ?,Lw(B)
 ("/u" ?,Lx(B)
 ("/i" ?,Ly(B)
 ("/o" ?,Lz(B)
 ("/p" ?,L{(B)
 ("/a" ?,L|(B)
 ("/s" ?,L~(B)
 ("/d" ?,L(B)
 
 ("/Q" ?,L"(B)
 ("/W" ?,L#(B)
 ("/E" ?,L$(B)
 ("/R" ?,L%(B)
 ("/T" ?,L&(B)
 ("/Y" ?,L'(B)
 ("/U" ?,L((B)
 ("/I" ?,L)(B)
 ("/O" ?,L*(B)
 ("/P" ?,L+(B)
 ("/A" ?,L,(B)
 ("/S" ?,L.(B)
 ("/D" ?,L/(B))
