#include "copyright.h"

/* Copyright    Massachusetts Institute of Technology    1985	*/
/* Copyright (C) 2001, 2002, 2003, 2004, 2005,
                 2006 Free Software Foundation, Inc.  */

/*
 * XMenu:	MIT Project Athena, X Window system menu package
 *
 *	XMenuChangeSelection - Change a menu selection.
 *
 *	Author:		Tony Della Fera, DEC
 *			December 19, 1985
 *
 */

#include "XMenuInt.h"

int
XMenuChangeSelection(display, menu, p_num, s_num, data, data_sw, label, label_sw)
    Display *display;		/* previously opened display. */
    register XMenu *menu;	/* Menu object to be modified. */
    register int p_num;		/* Pane number to be modified. */
    register int s_num;		/* Selection number to modified. */
    char *data;			/* Data value. */
    int data_sw;		/* Change to new data value? */
    char *label;		/* Selection label. */
    int label_sw;		/* Change to new label? */
{
    register XMPane *p_ptr;	/* XMPane pointer. */
    register XMSelect *s_ptr;	/* XMSelect pointer. */

    int label_length;		/* Label length in characters. */
    int label_width;		/* Label width in pixels. */

    /*
     * Check for NULL pointers!
     */
    if (label == NULL) {
	_XMErrorCode = XME_ARG_BOUNDS;
	return(XM_FAILURE);
    }

    /*
     * Find the right pane.
     */
    p_ptr = _XMGetPanePtr(menu, p_num);
    if (p_ptr == NULL) return(XM_FAILURE);

    /*
     * Find the right selection.
     */
    s_ptr = _XMGetSelectionPtr(p_ptr, s_num);
    if (s_ptr == NULL) return(XM_FAILURE);

    /*
     * Reset the label?
     */
    if (label_sw) {
	/*
	 * Determine label size.
	 */
	label_length = strlen(label);
	label_width = XTextWidth(menu->s_fnt_info, label, label_length);

	/*
	 * Change the selection data.
	 */
	s_ptr->label = label;
	s_ptr->label_width = label_width;
	s_ptr->label_length = label_length;

	/*
	 * Schedule a recompute.
	 */
	menu->recompute = 1;
    }

    /*
     * Reset the data?
     */
    if (data_sw) s_ptr->data = data;

    /*
     * Return successfully.
     */
    _XMErrorCode = XME_NO_ERROR;
    return(s_num);
}

/* arch-tag: 229732a6-46bf-4a3a-ad90-3d8ed65c0841
   (do not change this comment) */
