;;; idlw-rinfo.el --- Routine Information for IDLWAVE
;; Copyright (c) 1999 Carsten Dominik
;; Copyright (c) 1999 Free Software Foundation

;; Author: Carsten Dominik <dominik@strw.leidenuniv.nl>
;; Version: 3.11
;; Keywords: languages

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; The constant which contains information about IDLs builtin functions
;; and procedures.  This information is extracted automatically from
;; the IDL documentation.
;;
;; Created by get_rinfo on Thu Dec 16 16:52:16 1999
;; IDL version: 5.3
;; Number of files scanned:  5
;;       903 syntax entries in file refguide.txt
;;       326 syntax entries in file sdf.txt
;;         0 syntax entries in file datamine.txt
;;         6 syntax entries in file edg.txt
;;         0 syntax entries in file insight.txt
;; Number of routines found: 1226
;; Number of keywords found: 5230

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Code:

(defconst idlwave-builtin-routines
  '(
    ("ANNOTATE"               pro nil                 (system) "%s" (("COLOR_INDICES") ("DRAWABLE") ("LOAD_FILE") ("TEK_COLORS") ("WINDOW")) idl)
    ("ARROW"                  pro nil                 (system) "%s, X0, Y0, X1, Y1" (("COLOR") ("DATA") ("HSIZE") ("HTHICK") ("NORMALIZED") ("SOLID") ("THICK")) idl)
    ("AXIS"                   pro nil                 (system) "%s [, X [, Y [, Z]]]" (("CHARSIZE") ("CHARTHICK") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("NODATA") ("NOERASE") ("NORMAL") ("SAVE") ("SUBTITLE") ("T3D") ("TICKLEN") ("XAXIS") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("YAXIS") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE") ("ZVALUE")) idl)
    ("BAR_PLOT"               pro nil                 (system) "%s, Values" (("BACKGROUND") ("BARNAMES") ("BAROFFSET") ("BARSPACE") ("BARWIDTH") ("BASELINES") ("BASERANGE") ("COLORS") ("OUTLINE") ("OVERPLOT") ("ROTATE") ("TITLE") ("XTITLE") ("YTITLE")) idl)
    ("BLAS_AXPY"              pro nil                 (system) "%s, Y, A, X [, D1, Loc1 [, D2, Range]]" nil idl)
    ("BOX_CURSOR"             pro nil                 (system) "%s, [ X0, Y0, NX, NY]" (("FIXED_SIZE") ("INIT") ("MESSAGE")) idl)
    ("BREAKPOINT"             pro nil                 (system) "%s [, File], Index" (("AFTER") ("CLEAR") ("CONDITION") ("DISABLE") ("ENABLE") ("ONCE") ("SET")) idl)
    ("BYTEORDER"              pro nil                 (system) "%s, Variable1, ..., Variablen" (("DTOGFLOAT") ("DTOVAX") ("DTOXDR") ("FTOVAX") ("FTOXDR") ("GFLOATTOD") ("HTONL") ("HTONS") ("L64SWAP") ("LSWAP") ("NTOHL") ("NTOHS") ("SSWAP") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("VAXTOD") ("VAXTOF") ("XDRTOD") ("XDRTOF")) idl)
    ("CALDAT"                 pro nil                 (system) "%s, Julian, Month [, Day [, Year [, Hour [, Minute [, Second]]]]]" nil idl)
    ("CALENDAR"               pro nil                 (system) "%s [[, Month] , Year]" nil idl)
    ("CALL_METHOD"            pro nil                 (system) "%s, Name, ObjRef, [, P1, ..., Pn]" nil idl)
    ("CALL_PROCEDURE"         pro nil                 (system) "%s, Name [, P1, ..., Pn]" nil idl)
    ("CATCH"                  pro nil                 (system) "%s, Variable" (("CANCEL")) idl)
    ("CD"                     pro nil                 (system) "%s [, Directory]" (("CURRENT")) idl)
    ("CDF_ATTDELETE"          pro nil                 (system) "%s, Id, Attribute [, EntryNum]" (("ZVARIABLE")) sdf)
    ("CDF_ATTGET"             pro nil                 (system) "%s, Id, Attribute, EntryNum, Value" (("CDF_TYPE") ("ZVARIABLE")) sdf)
    ("CDF_ATTINQ"             pro nil                 (system) "%s, Id, Attribute, Name, Scope, MaxEntry [, MaxZEntry]" nil sdf)
    ("CDF_ATTPUT"             pro nil                 (system) "%s, Id, Attribute, EntryNum, Value" (("ZVARIABLE")) sdf)
    ("CDF_ATTRENAME"          pro nil                 (system) "%s, Id, OldAttr, NewName" nil sdf)
    ("CDF_CLOSE"              pro nil                 (system) "%s, Id" nil sdf)
    ("CDF_COMPRESSION"        pro nil                 (system) "%s, Id" (("GET_COMPRESSION") ("GET_GZIP_LEVEL") ("GET_VAR_COMPRESSION") ("GET_VAR_GZIP_LEVEL") ("SET_COMPRESSION") ("SET_GZIP_LEVEL") ("SET_VAR_COMPRESSION") ("SET_VAR_GZIP_LEVEL") ("VARIABLE") ("ZVARIABLE")) sdf)
    ("CDF_CONTROL"            pro nil                 (system) "%s, Id" (("ATTRIBUTE") ("GET_ATTR_INFO") ("GET_CACHESIZE") ("GET_COPYRIGHT") ("GET_FILENAME") ("GET_FORMAT") ("GET_NEGTOPOSFP0_MODE") ("GET_NUMATTRS") ("GET_READONLY_MODE") ("GET_RVAR_CACHESIZE") ("GET_VAR_INFO") ("GET_ZMODE") ("GET_ZVAR_CACHESIZE") ("SET_CACHESIZE") ("SET_EXTENDRECS") ("SET_INITIALRECS") ("SET_NEGTOPOSFP0_MODE") ("SET_PADVALUE") ("SET_READONLY_MODE") ("SET_RVAR_CACHESIZE") ("SET_RVARS_CACHESIZE") ("SET_ZMODE") ("SET_ZVAR_CACHESIZE") ("SET_ZVARS_CACHESIZE") ("VARIABLE") ("ZVARIABLE")) sdf)
    ("CDF_DELETE"             pro nil                 (system) "%s, Id" nil sdf)
    ("CDF_DOC"                pro nil                 (system) "%s, Id, Version, Release, Copyright" (("INCREMENT")) sdf)
    ("CDF_EPOCH"              pro nil                 (system) "%s, Epoch, Year [, Month, Day, Hour, Minute, Second, Milli]" (("BREAKDOWN_EPOCH") ("COMPUTE_EPOCH")) sdf)
    ("CDF_LIB_INFO"           pro nil                 (system) "%s" (("COPYRIGHT") ("INCREMENT") ("RELEASE") ("SUBINCREMENT") ("VERSION")) sdf)
    ("CDF_VARDELETE"          pro nil                 (system) "%s, Id, Variable" (("ZVARIABLE")) sdf)
    ("CDF_VARGET"             pro nil                 (system) "%s, Id, Variable, Value" (("COUNT") ("INTERVAL") ("OFFSET") ("REC_COUNT") ("REC_INTERVAL") ("REC_START") ("STRING") ("ZVARIABLE")) sdf)
    ("CDF_VARGET1"            pro nil                 (system) "%s, Id, Variable, Value" (("OFFSET") ("REC_START") ("STRING") ("ZVARIABLE")) sdf)
    ("CDF_VARPUT"             pro nil                 (system) "%s, Id, Variable, Value" (("COUNT") ("INTERVAL") ("OFFSET") ("REC_INTERVAL") ("REC_START") ("ZVARIABLE")) sdf)
    ("CDF_VARRENAME"          pro nil                 (system) "%s, Id, OldVariable, NewName" (("ZVARIABLE")) sdf)
    ("CHOLDC"                 pro nil                 (system) "%s, A, P" (("DOUBLE")) idl)
    ("CIR_3PNT"               pro nil                 (system) "%s, X, Y, R, X0, Y0" nil idl)
    ("CLOSE"                  pro nil                 (system) "%s[, Unit1, ..., Unitn]" (("ALL") ("FILE")) idl)
    ("COLOR_CONVERT"          pro nil                 (system) "%s, I0, I1, I2, O0, O1, O2" (("HLS_RGB") ("HSV_RGB") ("RGB_HLS") ("RGB_HSV")) idl)
    ("CONSTRAINED_MIN"        pro nil                 (system) "%s, X, Xbnd, Gbnd, Nobj, Gcomp, Inform" (("ESPTOP") ("LIMSER") ("MAXIMIZE") ("NSTOP") ("REPORT") ("TITLE")) idl)
    ("CONTOUR"                pro nil                 (system) "%s, Z [, X, Y]" (("BACKGROUND") ("C_ANNOTATION") ("C_CHARSIZE") ("C_CHARTHICK") ("C_COLORS") ("C_LABELS") ("C_LINESTYLE") ("C_ORIENTATION") ("C_SPACING") ("C_THICK") ("CELL_FILL") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("CLOSED") ("COLOR") ("DATA") ("DEVICE") ("DOWNHILL") ("FILL") ("FOLLOW") ("FONT") ("IRREGULAR") ("LEVELS") ("MAX_VALUE") ("MIN_VALUE") ("NLEVELS") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("OVERPLOT") ("PATH_DATA_COORDS") ("PATH_FILENAME") ("PATH_INFO") ("PATH_XY") ("POSITION") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("TRIANGULATION") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE") ("ZVALUE")) idl)
    ("CREATE_VIEW"            pro nil                 (system) "%s" (("AX") ("AY") ("AZ") ("PERSP") ("RADIANS") ("WINX") ("WINY") ("XMAX") ("XMIN") ("YMAX") ("YMIN") ("ZFAC") ("ZMAX") ("ZMIN") ("ZOOM")) idl)
    ("CURSOR"                 pro nil                 (system) "%s, X, Y [, Wait]" (("CHANGE") ("DATA") ("DEVICE") ("DOWN") ("NORMAL") ("NOWAIT") ("UP") ("WAIT")) idl)
    ("CW_ANIMATE_GETP"        pro nil                 (system) "%s, Widget, Pixmaps" (("KILL_ANYWAY")) idl)
    ("CW_ANIMATE_LOAD"        pro nil                 (system) "%s, Widget" (("CYCLE") ("FRAME") ("IMAGE") ("ORDER") ("WINDOW") ("XOFFSET") ("YOFFSET")) idl)
    ("CW_ANIMATE_RUN"         pro nil                 (system) "%s, Widget [, Rate{0 to 100}]" (("NFRAMES") ("STOP")) idl)
    ("CW_LIGHT_EDITOR_GET"    pro nil                 (system) "%s, WidgetID" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")) idl)
    ("CW_LIGHT_EDITOR_SET"    pro nil                 (system) "%s, WidgetID" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")) idl)
    ("CW_PALETTE_EDITOR_GET"  pro nil                 (system) "%s, WidgetID" (("ALPHA") ("HISTOGRAM")) idl)
    ("CW_PALETTE_EDITOR_SET"  pro nil                 (system) "%s, WidgetID" (("ALPHA") ("HISTOGRAM")) idl)
    ("DEFINE_KEY"             pro nil                 (system) "%s, Key [, Value]" (("BACK_CHARACTER") ("BACK_WORD") ("CONTROL") ("DELETE_CHARACTER") ("DELETE_CURRENT") ("DELETE_EOL") ("DELETE_LINE") ("DELETE_WORD") ("END_OF_FILE") ("END_OF_LINE") ("ENTER_LINE") ("ESCAPE") ("FORWARD_CHARACTER") ("FORWARD_WORD") ("INSERT_OVERSTRIKE_TOGGLE") ("MATCH_PREVIOUS") ("NEXT_LINE") ("NOECHO") ("PREVIOUS_LINE") ("RECALL") ("REDRAW") ("START_OF_LINE") ("TERMINATE")) idl)
    ("DEFSYSV"                pro nil                 (system) "%s, Name, Value [, Read_Only]" (("EXISTS")) idl)
    ("DELETE_SYMBOL"          pro nil                 (system) "%s, Name" (("TYPE")) idl)
    ("DELLOG"                 pro nil                 (system) "%s, Lognam" (("TABLE")) idl)
    ("DELVAR"                 pro nil                 (system) "%s, V1, ..., Vn" nil idl)
    ("DEVICE"                 pro nil                 (system) "%s" (("AVANTGARDE") ("AVERAGE_LINES") ("BINARY") ("BITS_PER_PIXEL") ("BKMAN") ("BOLD") ("BOOK") ("BYPASS_TRANSLATION") ("CLOSE") ("CLOSE_DOCUMENT") ("CLOSE_FILE") ("COLOR") ("COLORS") ("COPY") ("COURIER") ("CURSOR_CROSSHAIR") ("CURSOR_IMAGE") ("CURSOR_MASK") ("CURSOR_ORIGINAL") ("CURSOR_STANDARD") ("CURSOR_XY") ("DEMI") ("DEPTH") ("DIRECT_COLOR") ("EJECT") ("ENCAPSULATED") ("ENCODING") ("FILENAME") ("FLOYD") ("FONT_INDEX") ("FONT_SIZE") ("GET_CURRENT_FONT") ("GET_DECOMPOSED") ("GET_FONTNAMES") ("GET_FONTNUM") ("GET_GRAPHICS_FUNCTION") ("GET_SCREEN_SIZE") ("GET_VISUAL_DEPTH") ("GET_VISUAL_NAME") ("GET_WINDOW_POSITION") ("GET_WRITE_MASK") ("GIN_CHARS") ("GLYPH_CACHE") ("HELVETICA") ("INCHES") ("INDEX_COLOR") ("ISOLATIN1") ("ITALIC") ("LANDSCAPE") ("LIGHT") ("MEDIUM") ("NARROW") ("NCAR") ("OBLIQUE") ("OPTIMIZE") ("ORDERED") ("OUTPUT") ("PALATINO") ("PIXELS") ("PLOT_TO") ("PLOTTER_ON_OFF") ("POLYFILL") ("PORTRAIT") ("PREVIEW") ("PRINT_FILE") ("PSEUDO_COLOR") ("RESET_STRING") ("RESOLUTION") ("RETAIN") ("SCALE_FACTOR") ("SCHOOLBOOK") ("SET_CHARACTER_SIZE") ("SET_COLORMAP") ("SET_COLORS") ("SET_FONT") ("SET_GRAPHICS_FUNCTION") ("SET_RESOLUTION") ("SET_STRING") ("SET_TRANSLATION") ("SET_WRITE_MASK") ("STATIC_COLOR") ("STATIC_GRAY") ("SYMBOL") ("TEK4014") ("THRESHOLD") ("TRANSLATION") ("TRUE_COLOR") ("TTY") ("VT240") ("VT241") ("VT340") ("VT341") ("WINDOW_STATE") ("XOFFSET") ("XON_XOFF") ("XSIZE") ("YOFFSET") ("YSIZE") ("Z_BUFFERING")) idl)
    ("DFPMIN"                 pro nil                 (system) "%s, X, Gtol, Fmin, Func, Dfunc" (("DOUBLE") ("EPS") ("ITER") ("ITMAX") ("STEPMAX") ("TOLX")) idl)
    ("DISSOLVE"               pro nil                 (system) "%s, Image" (("ORDER") ("SIZ") ("WAIT") ("X0") ("Y0")) idl)
    ("DLM_LOAD"               pro nil                 (system) "%s, DLMNameStr1 [, DLMNameStr2,..., DLMNameStrn]" nil idl)
    ("DO_APPLE_SCRIPT"        pro nil                 (system) "%s, Script" (("AG_STRING") ("RESULT")) idl)
    ("DOC_LIBRARY"            pro nil                 (system) "%s [, Name]" (("DIRECTORY") ("FILE") ("MULTI") ("OUTPUTS") ("PATH") ("PRINT")) idl)
    ("DRAW_ROI"               pro nil                 (system) "%s, oROI" (("CLIP") ("COLOR") ("DATA") ("DEVICE") ("LINE_FILL") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("PSYM") ("SPACING") ("SYMSIZE") ("T3D") ("THICK")) idl)
    ("EFONT"                  pro nil                 (system) "%s, Init_Font" (("BLOCK") ("GROUP")) idl)
    ("EMPTY"                  pro nil                 (system) "%s" nil idl)
    ("ENABLE_SYSRTN"          pro nil                 (system) "%s [, Routines]" (("DISABLE") ("EXCLUSIVE") ("FUNCTIONS")) idl)
    ("ERASE"                  pro nil                 (system) "%s [, Background_Color]" (("CHANNEL") ("COLOR")) idl)
    ("ERRPLOT"                pro nil                 (system) "%s, [ X, ] Low, High" (("WIDTH")) idl)
    ("EXIT"                   pro nil                 (system) "%s" (("NO_CONFIRM") ("STATUS")) idl)
    ("EXPAND"                 pro nil                 (system) "%s, A, Nx, Ny, Result" (("FILLVAL") ("MAXVAL")) idl)
    ("FLICK"                  pro nil                 (system) "%s, A, B [, Rate]" nil idl)
    ("FLOW3"                  pro nil                 (system) "%s, Vx, Vy, Vz" (("ARROWSIZE") ("BLOB") ("LEN") ("NSTEPS") ("NVECS") ("SX") ("SY") ("SZ")) idl)
    ("FLUSH"                  pro nil                 (system) "%s, Unit1, ..., Unitn" nil idl)
    ("FORWARD_FUNCTION"       pro nil                 (system) "%s Name1, Name2, ..., Namen" nil idl)
    ("FREE_LUN"               pro nil                 (system) "%s, Unit1, ..., Unitn" nil idl)
    ("FUNCT"                  pro nil                 (system) "%s, X, A, F [, Pder]" nil idl)
    ("GAMMA_CT"               pro nil                 (system) "%s, Gamma" (("CURRENT") ("INTENSITY")) idl)
    ("GET_LUN"                pro nil                 (system) "%s, Unit" nil idl)
    ("H_EQ_CT"                pro nil                 (system) "%s [, Image]" nil idl)
    ("H_EQ_INT"               pro nil                 (system) "%s [, Image]" nil idl)
    ("HDF_AN_END"             pro nil                 (system) "%s, an_id" nil sdf)
    ("HDF_AN_ENDACCESS"       pro nil                 (system) "%s, ann_id" nil sdf)
    ("HDF_CLOSE"              pro nil                 (system) "%s, FileHandle" nil sdf)
    ("HDF_DELDD"              pro nil                 (system) "%s, FileHandle, Tag, Ref" nil sdf)
    ("HDF_DF24_ADDIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("JPEG") ("QUALITY") ("RLE")) sdf)
    ("HDF_DF24_GETIMAGE"      pro nil                 (system) "%s, Filename, Image" (("LINE") ("PIXEL") ("PLANE")) sdf)
    ("HDF_DF24_GETINFO"       pro nil                 (system) "%s, Filename, Width, Height, Interlace" nil sdf)
    ("HDF_DF24_READREF"       pro nil                 (system) "%s, Filename, Refno" nil sdf)
    ("HDF_DF24_RESTART"       pro nil                 (system) "%s" nil sdf)
    ("HDF_DFAN_ADDFDS"        pro nil                 (system) "%s, Filename, Description" nil sdf)
    ("HDF_DFAN_ADDFID"        pro nil                 (system) "%s, Filename, Label" nil sdf)
    ("HDF_DFAN_GETDESC"       pro nil                 (system) "%s, Filename, Tag, Ref, Description" (("STRING")) sdf)
    ("HDF_DFAN_GETFDS"        pro nil                 (system) "%s, Filename, Description" (("FIRST") ("STRING")) sdf)
    ("HDF_DFAN_GETFID"        pro nil                 (system) "%s, Filename, Label" (("FIRST")) sdf)
    ("HDF_DFAN_GETLABEL"      pro nil                 (system) "%s, Filename, Tag, Ref, Label" nil sdf)
    ("HDF_DFAN_PUTDESC"       pro nil                 (system) "%s, Filename, Tag, Ref, Description" nil sdf)
    ("HDF_DFAN_PUTLABEL"      pro nil                 (system) "%s, Filename, Tag, Ref, Label" nil sdf)
    ("HDF_DFP_ADDPAL"         pro nil                 (system) "%s, Filename, Palette" nil sdf)
    ("HDF_DFP_GETPAL"         pro nil                 (system) "%s, Filename, Palette" nil sdf)
    ("HDF_DFP_PUTPAL"         pro nil                 (system) "%s, Filename, Palette" (("DELETE") ("OVERWRITE")) sdf)
    ("HDF_DFP_READREF"        pro nil                 (system) "%s, Filename, Refno" nil sdf)
    ("HDF_DFP_RESTART"        pro nil                 (system) "%s" nil sdf)
    ("HDF_DFP_WRITEREF"       pro nil                 (system) "%s, Filename, Refno" nil sdf)
    ("HDF_DFR8_ADDIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("IMCOMP") ("JPEG") ("PALETTE") ("QUALITY") ("RLE")) sdf)
    ("HDF_DFR8_GETIMAGE"      pro nil                 (system) "%s, Filename, Image [, Palette]" nil sdf)
    ("HDF_DFR8_GETINFO"       pro nil                 (system) "%s, Filename, Width, Height, Has_Palette" nil sdf)
    ("HDF_DFR8_PUTIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("IMCOMP") ("JPEG") ("PALETTE") ("QUALITY") ("RLE")) sdf)
    ("HDF_DFR8_READREF"       pro nil                 (system) "%s, Filename, Refno" nil sdf)
    ("HDF_DFR8_RESTART"       pro nil                 (system) "%s" nil sdf)
    ("HDF_DFR8_SETPALETTE"    pro nil                 (system) "%s, Palette" nil sdf)
    ("HDF_DUPDD"              pro nil                 (system) "%s, FileHandle, NewTag, NewRef, OldTag, OldRef" nil sdf)
    ("HDF_GR_END"             pro nil                 (system) "%s, gr_id" nil sdf)
    ("HDF_GR_ENDACCESS"       pro nil                 (system) "%s, ri_id" nil sdf)
    ("HDF_LIB_INFO"           pro nil                 (system) "%s, [FileHandle]" (("MAJOR") ("MINOR") ("RELEASE") ("VERSION")) sdf)
    ("HDF_SD_ADDDATA"         pro nil                 (system) "%s, SDS_ID, Data" (("COUNT") ("NOREVERSE") ("START") ("STRIDE")) sdf)
    ("HDF_SD_ATTRINFO"        pro nil                 (system) "%s, S_ID, Attr_Index" (("COUNT") ("DATA") ("HDF_TYPE") ("NAME") ("TYPE")) sdf)
    ("HDF_SD_ATTRSET"         pro nil                 (system) "%s, S_ID, Attr_Name, Values [, Count]" (("BYTE") ("DFNT_CHAR") ("DFNT_FLOAT32") ("DFNT_FLOAT64") ("DFNT_INT16") ("DFNT_INT32") ("DFNT_INT8") ("DFNT_UINT16") ("DFNT_UINT32") ("DFNT_UINT8") ("DOUBLE") ("FLOAT") ("INT") ("LONG") ("SHORT") ("STRING")) sdf)
    ("HDF_SD_DIMGET"          pro nil                 (system) "%s, Dim_ID" (("COMPATIBILITY") ("COUNT") ("FORMAT") ("LABEL") ("NAME") ("NATTR") ("SCALE") ("TYPE") ("UNIT")) sdf)
    ("HDF_SD_DIMSET"          pro nil                 (system) "%s, Dim_ID" (("BW_INCOMP") ("FORMAT") ("LABEL") ("NAME") ("SCALE") ("UNIT")) sdf)
    ("HDF_SD_END"             pro nil                 (system) "%s, SD_ID" nil sdf)
    ("HDF_SD_ENDACCESS"       pro nil                 (system) "%s, SD_ID" nil sdf)
    ("HDF_SD_FILEINFO"        pro nil                 (system) "%s, SD_ID, Datasets, Attributes" nil sdf)
    ("HDF_SD_GETDATA"         pro nil                 (system) "%s, SDS_ID, Data" (("COUNT") ("NOREVERSE") ("START") ("STRIDE")) sdf)
    ("HDF_SD_GETINFO"         pro nil                 (system) "%s, SDS_ID" (("CALDATA") ("COORDSYS") ("DIMS") ("FILL") ("FORMAT") ("HDF_TYPE") ("LABEL") ("NAME") ("NATTS") ("NDIMS") ("NOREVERSE") ("RANGE") ("TYPE") ("UNIT")) sdf)
    ("HDF_SD_SETCOMPRESS"     pro nil                 (system) "%s, SDS_ID, comptype" (("EFFORT")) sdf)
    ("HDF_SD_SETEXTFILE"      pro nil                 (system) "%s, SDS_ID, Filename" (("OFFSET")) sdf)
    ("HDF_SD_SETINFO"         pro nil                 (system) "%s, SDS_ID" (("CALDATA") ("COORDSYS") ("FILL") ("FORMAT") ("LABEL") ("RANGE") ("UNIT")) sdf)
    ("HDF_UNPACKDATA"         pro nil                 (system) "%s, packeddata, data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]]" (("HDF_ORDER") ("HDF_TYPE") ("NREC")) sdf)
    ("HDF_VD_DETACH"          pro nil                 (system) "%s, VData" nil sdf)
    ("HDF_VD_FDEFINE"         pro nil                 (system) "%s, VData, Fieldname" (("BYTE") ("DLONG") ("DOUBLE") ("DULONG") ("FLOAT") ("INT") ("LONG") ("ORDER") ("UINT") ("ULONG")) sdf)
    ("HDF_VD_GET"             pro nil                 (system) "%s, VData" (("CLASS") ("COUNT") ("FIELDS") ("INTERLACE") ("NAME") ("NFIELDS") ("REF") ("SIZE") ("TAG")) sdf)
    ("HDF_VD_GETINFO"         pro nil                 (system) "%s, VData, Index" (("NAME") ("ORDER") ("SIZE") ("TYPE")) sdf)
    ("HDF_VD_INSERT"          pro nil                 (system) "%s, VGroup, VData(or Vgroup)" (("POSITION")) sdf)
    ("HDF_VD_SEEK"            pro nil                 (system) "%s, VData, Record" nil sdf)
    ("HDF_VD_SETINFO"         pro nil                 (system) "%s, VData" (("CLASS") ("FULL_INTERLACE") ("NAME") ("NO_INTERLACE")) sdf)
    ("HDF_VD_WRITE"           pro nil                 (system) "%s, VData, Fields, Data" (("FULL_INTERLACE") ("NO_INTERLACE") ("NRECORDS")) sdf)
    ("HDF_VG_ADDTR"           pro nil                 (system) "%s, VGroup, Tag, Ref" nil sdf)
    ("HDF_VG_DETACH"          pro nil                 (system) "%s, VGroup" nil sdf)
    ("HDF_VG_GETINFO"         pro nil                 (system) "%s, VGroup" (("CLASS") ("NAME") ("NENTRIES")) sdf)
    ("HDF_VG_GETTR"           pro nil                 (system) "%s, VGroup, Index, Tags, Refs" nil sdf)
    ("HDF_VG_GETTRS"          pro nil                 (system) "%s, VGroup, Tags, Refs" (("MAXSIZE")) sdf)
    ("HDF_VG_INSERT"          pro nil                 (system) "%s, VGroup, VData(or Vgroup)" (("POSITION")) sdf)
    ("HDF_VG_SETINFO"         pro nil                 (system) "%s, VGroup" (("CLASS") ("NAME")) sdf)
    ("HEAP_GC"                pro nil                 (system) "%s" (("OBJ") ("PTR") ("VERBOSE")) idl)
    ("HELP"                   pro nil                 (system) "%s, Expression1, ..., Expressionn" (("ALL_KEYS") ("BREAKPOINTS") ("BRIEF") ("CALLS") ("DEVICE") ("DLM") ("FILES") ("FULL") ("FUNCTIONS") ("HEAP_VARIABLES") ("KEYS") ("LAST_MESSAGE") ("MEMORY") ("MESSAGES") ("NAMES") ("OBJECTS") ("OUTPUT") ("PROCEDURES") ("RECALL_COMMANDS") ("ROUTINES") ("SOURCE_FILES") ("STRUCTURES") ("SYSTEM_VARIABLES") ("TRACEBACK")) idl)
    ("HLS"                    pro nil                 (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" nil idl)
    ("HSV"                    pro nil                 (system) "%s, Vlo, Vhi, Satlo, Sathi, Hue, Loops [, Colr]" nil idl)
    ("IMAGE_CONT"             pro nil                 (system) "%s, A" (("ASPECT") ("INTERP") ("WINDOW_SCALE")) idl)
    ("IMAGE_STATISTICS"       pro nil                 (system) "%s, Data" (("COUNT") ("DATA_SUM") ("LABELED") ("LUT") ("MASK") ("MAXIMUM") ("MEAN") ("MINIMUM") ("STDDEV") ("SUM_OF_SQUARES") ("VARIANCE") ("VECTOR") ("WEIGHT_SUM") ("WEIGHTED")) idl)
    ("INSIGHT"                pro nil                 (system) "%s [, Structure]" (("IMPORT_FILE") ("INDEXED_COLOR") ("PLUGINS_PATH") ("PREFERENCE_FILE") ("PROJECT_FILE")) insight)
    ("INSPUT"                 pro nil                 (system) "%s [, Structure]" (("CIDS") ("COUNT") ("CT_NAME") ("CT_NEW_NAME") ("CT_REPLACE") ("DESCRIPTION") ("GROUP") ("IMAGE") ("NAME") ("NEW_NAME") ("REPLACE")) insight)
    ("INSVIS"                 pro nil                 (system) "%s, Name1 [, Name2, Name3]" (("CIDS") ("DATA_NAME") ("END") ("GROUP") ("MODE") ("TAIL") ("TYPE") ("XRANGE") ("YRANGE")) insight)
    ("ISOCONTOUR"             pro nil                 (system) "%s, Values, Outconn, Outverts" (("AUXDATA_IN") ("AUXDATA_OUT") ("C_VALUE") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("LEVEL_VALUES") ("N_LEVELS") ("OUTCONN_INDICES") ("POLYGONS")) idl)
    ("ISOSURFACE"             pro nil                 (system) "%s, Data, Value, Outverts, Outconn" (("AUXDATA_IN") ("AUXDATA_OUT") ("GEOM_XYZ") ("TETRAHEDRA")) idl)
    ("JOURNAL"                pro nil                 (system) "%s [, Arg]" nil idl)
    ("LINKIMAGE"              pro nil                 (system) "%s, Name, Image [, Type [, Entry]]" (("DEFAULT") ("DEVICE") ("FUNCT") ("KEYWORDS") ("MAX_ARGS") ("MIN_ARGS")) idl)
    ("LIVE_CONTOUR"           pro nil                 (system) "%s [, Z1,..., Z25]" (("BUFFER") ("DIMENSIONS") ("DRAW_DIMENSIONS") ("ERROR") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XINDEPENDENT") ("XRANGE") ("Y") ("YINDEPENDENT") ("YRANGE")) idl)
    ("LIVE_CONTROL"           pro nil                 (system) "%s, [Name]" (("DIALOG") ("ERROR") ("NO_DRAW") ("PROPERTIES") ("SELECT") ("UPDATE_DATA") ("WINDOW_IN")) idl)
    ("LIVE_DESTROY"           pro nil                 (system) "%s, [Name1,..., Name25]" (("ENVIRONMENT") ("ERROR") ("NO_DRAW") ("PURGE") ("WINDOW_IN")) idl)
    ("LIVE_EXPORT"            pro nil                 (system) "%s" (("APPEND") ("COMPRESSION") ("DIALOG") ("DIMENSIONS") ("ERROR") ("FILENAME") ("ORDER") ("PROGRESSIVE") ("QUALITY") ("RESOLUTION") ("TYPE") ("UNITS") ("VISUALIZATION_IN") ("WINDOW_IN")) idl)
    ("LIVE_IMAGE"             pro nil                 (system) "%s, Image" (("BLUE") ("BUFFER") ("DIMENSIONS") ("DRAW_DIMENSIONS") ("ERROR") ("GREEN") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("RED") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN")) idl)
    ("LIVE_INFO"              pro nil                 (system) "%s, [Name]" (("ERROR") ("PROPERTIES") ("WINDOW_IN")) idl)
    ("LIVE_LINE"              pro nil                 (system) "%s" (("ARROW_ANGLE") ("ARROW_END") ("ARROW_SIZE") ("ARROW_START") ("COLOR") ("DIALOG") ("DIMENSIONS") ("ERROR") ("HIDE") ("LINESTYLE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("THICK") ("VISUALIZATION_IN") ("WINDOW_IN")) idl)
    ("LIVE_LOAD"              pro nil                 (system) "%s" nil idl)
    ("LIVE_OPLOT"             pro nil                 (system) "%s, Yvector1 [,... , Yvector25]" (("ERROR") ("INDEPENDENT") ("NAME") ("NEW_AXES") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("REPLACE") ("SUBTYPE") ("VISUALIZATION_IN") ("WINDOW_IN") ("XAXIS_IN") ("YAXIS_IN")) idl)
    ("LIVE_PLOT"              pro nil                 (system) "%s, Yvector1 [, Yvector2,..., Yvector25]" (("BUFFER") ("DIMENSIONS") ("DRAW_DIMENSIONS") ("ERROR") ("HISTOGRAM") ("INDEPENDENT") ("INDEXED_COLOR") ("INSTANCING") ("LINE") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("POLAR") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("SCATTER") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XRANGE") ("Y") ("YRANGE")) idl)
    ("LIVE_PRINT"             pro nil                 (system) "%s" (("DIALOG") ("ERROR") ("SETUP") ("WINDOW_IN")) idl)
    ("LIVE_RECT"              pro nil                 (system) "%s" (("COLOR") ("DIALOG") ("DIMENSIONS") ("ERROR") ("HIDE") ("LINESTYLE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("THICK") ("VISUALIZATION_IN") ("WINDOW_IN")) idl)
    ("LIVE_SURFACE"           pro nil                 (system) "%s, Data, Data2,..." (("BUFFER") ("DIMENSIONS") ("DRAW_DIMENSIONS") ("ERROR") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XINDEPENDENT") ("XRANGE") ("Y") ("YINDEPENDENT") ("YRANGE")) idl)
    ("LIVE_TEXT"              pro nil                 (system) "%s[, Text]" (("ALIGNMENT") ("COLOR") ("DIALOG") ("ENABLE_FORMATTING") ("ERROR") ("FONTNAME") ("FONTSIZE") ("HIDE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("TEXTANGLE") ("VERTICAL_ALIGNMENT") ("VISUALIZATION_IN") ("WINDOW_IN")) idl)
    ("LJLCT"                  pro nil                 (system) "%s" nil idl)
    ("LOADCT"                 pro nil                 (system) "%s [, Table]" (("BOTTOM") ("FILE") ("GET_NAMES") ("NCOLORS") ("SILENT")) idl)
    ("LUDC"                   pro nil                 (system) "%s, A, Index" (("COLUMN") ("DOUBLE") ("INTERCHANGES")) idl)
    ("MAP_CONTINENTS"         pro nil                 (system) "%s" (("COASTS") ("COLOR") ("COUNTRIES") ("FILL_CONTINENTS") ("HIRES") ("MLINESTYLE") ("MLINETHICK") ("ORIENTATION") ("RIVERS") ("SPACING") ("USA")) idl)
    ("MAP_GRID"               pro nil                 (system) "%s" (("BOX_AXES") ("CHARSIZE") ("CLIP_TEXT") ("COLOR") ("GLINESTYLE") ("GLINETHICK") ("LABEL") ("LATALIGN") ("LATDEL") ("LATLAB") ("LATNAMES") ("LATS") ("LONALIGN") ("LONDEL") ("LONLAB") ("LONNAMES") ("LONS") ("ORIENTATION")) idl)
    ("MAP_PROJ_INFO"          pro nil                 (system) "%s [, iproj]" (("AZIMUTHAL") ("CIRCLE") ("CURRENT") ("CYLINDRICAL") ("LL_LIMITS") ("NAME") ("PROJ_NAMES") ("UV_LIMITS") ("UV_RANGE")) idl)
    ("MAP_SET"                pro nil                 (system) "%s [, P0lat, P0lon, Rot]" (("ADVANCE") ("AITOFF") ("ALBERS") ("AZIMUTHAL") ("CENTRAL_AZIMUTH") ("CHARSIZE") ("CLIP") ("COLOR") ("CON_COLOR") ("CONIC") ("CONTINENTS") ("CYLINDRICAL") ("E_CONTINENTS") ("E_GRID") ("E_HORIZON") ("ELLIPSOID") ("GLINESTYLE") ("GLINETHICK") ("GNOMIC") ("GOODESHOMOLOSINE") ("GRID") ("HAMMER") ("HIRES") ("HORIZON") ("ISOTROPIC") ("LABEL") ("LAMBERT") ("LATALIGN") ("LATDEL") ("LATLAB") ("LIMIT") ("LONDEL") ("LONLAB") ("MERCATOR") ("MILLER") ("MLINESTYLE") ("MLINETHICK") ("MOLLEWIDE") ("NOBORDER") ("NOERASE") ("ORTHOGRAPHIC") ("POSITION") ("ROBINSON") ("SAT_P") ("SATELLITE") ("SCALE") ("SINUSOIDAL") ("STANDARD_PARALLELS") ("STEREOGRAPHIC") ("T3D") ("TITLE") ("TRANSVERSE_MERCATOR") ("USA") ("XMARGIN") ("YMARGIN") ("ZVALUE")) idl)
    ("MESH_OBJ"               pro nil                 (system) "%s, Type, Vertex_List, Polygon_List, Array1 [, Array2]" (("DEGREES") ("P1") ("P2") ("P3") ("P4") ("P5")) idl)
    ("MESSAGE"                pro nil                 (system) "%s, [Text]" (("CONTINUE") ("INFORMATIONAL") ("IOERROR") ("NONAME") ("NOPREFIX") ("NOPRINT") ("RESET")) idl)
    ("MK_HTML_HELP"           pro nil                 (system) "%s, Sources, Filename" (("STRICT") ("TITLE") ("VERBOSE")) idl)
    ("MODIFYCT"               pro nil                 (system) "%s, Itab, Name, R, G, B" (("FILE")) idl)
    ("MPEG_CLOSE"             pro nil                 (system) "%s, mpegID" nil idl)
    ("MPEG_PUT"               pro nil                 (system) "%s, mpegID" (("COLOR") ("FRAME") ("IMAGE") ("ORDER") ("WINDOW")) idl)
    ("MPEG_SAVE"              pro nil                 (system) "%s, mpegID" (("FILENAME")) idl)
    ("MSG_CAT_CLOSE"          pro nil                 (system) "%s, object" nil idl)
    ("MSG_CAT_COMPILE"        pro nil                 (system) "%s, input[, output]" (("LOCALE_ALIAS") ("MBCS")) idl)
    ("MULTI"                  pro nil                 (system) "%s, N" nil idl)
    ("NCDF_ATTDEL"            pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")) sdf)
    ("NCDF_ATTGET"            pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")) sdf)
    ("NCDF_ATTPUT"            pro nil                 (system) "%s, Cdfid [, Varid]" (("BYTE") ("CHAR") ("DOUBLE") ("FLOAT") ("GLOBAL") ("LENGTH") ("LONG") ("SHORT")) sdf)
    ("NCDF_ATTRENAME"         pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")) sdf)
    ("NCDF_CLOSE"             pro nil                 (system) "%s, Cdfid" nil sdf)
    ("NCDF_CONTROL"           pro nil                 (system) "%s, Cdfid" (("ABORT") ("ENDEF") ("FILL") ("NOFILL") ("NOVERBOSE") ("OLDFILL") ("REDEF") ("SYNC") ("VERBOSE")) sdf)
    ("NCDF_DIMINQ"            pro nil                 (system) "%s, Cdfid, Dimid, Name, Size" nil sdf)
    ("NCDF_DIMRENAME"         pro nil                 (system) "%s, Cdfid, Dimid, NewName" nil sdf)
    ("NCDF_VARGET"            pro nil                 (system) "%s, Cdfid, Varid, Value" (("COUNT") ("OFFSET") ("STRIDE")) sdf)
    ("NCDF_VARGET1"           pro nil                 (system) "%s, Cdfid, Varid, Value" (("OFFSET")) sdf)
    ("NCDF_VARPUT"            pro nil                 (system) "%s, Cdfid, Varid, Value" (("COUNT") ("OFFSET") ("STRIDE")) sdf)
    ("NCDF_VARRENAME"         pro nil                 (system) "%s, Cdfid, Varid, Name" nil sdf)
    ("OBJ_DESTROY"            pro nil                 (system) "%s, ObjRef [, Arg1, ..., Argn]" nil idl)
    ("ON_ERROR"               pro nil                 (system) "%s, N" nil idl)
    ("ON_IOERROR"             pro nil                 (system) "%s, Label" nil idl)
    ("ONLINE_HELP"            pro nil                 (system) "%s [, Topic]" (("BOOK") ("CONTEXT") ("FULL_PATH") ("QUIT")) idl)
    ("OPENR"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BINARY") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NOAUTOMODE") ("NONE") ("NOSTDIO") ("PRINT") ("SEGMENTED") ("SHARED") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")) idl)
    ("OPENU"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BINARY") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NOAUTOMODE") ("NONE") ("NOSTDIO") ("PRINT") ("SEGMENTED") ("SHARED") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")) idl)
    ("OPENW"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BINARY") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NOAUTOMODE") ("NONE") ("NOSTDIO") ("PRINT") ("SEGMENTED") ("SHARED") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")) idl)
    ("OPLOT"                  pro nil                 (system) "%s, [X,] Y" (("CLIP") ("COLOR") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NSUM") ("POLAR") ("PSYM") ("SYMSIZE") ("T3D") ("THICK") ("ZVALUE")) idl)
    ("OPLOTERR"               pro nil                 (system) "%s, [ X ,] Y , Err [, Psym]" nil idl)
    ("PARTICLE_TRACE"         pro nil                 (system) "%s, Data, Seeds, Verts, Conn [, Normals]" (("ANISOTROPY") ("INTEGRATION") ("MAX_ITERATIONS") ("MAX_STEPSIZE") ("SEED_NORMAL") ("TOLERANCE") ("UNIFORM")) idl)
    ("PLOT"                   pro nil                 (system) "%s, [X,] Y" (("BACKGROUND") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("PSYM") ("SUBTITLE") ("SYMSIZE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE") ("ZVALUE")) idl)
    ("PLOT_3DBOX"             pro nil                 (system) "%s, X, Y, Z" (("AX") ("AZ") ("BACKGROUND") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("GRIDSTYLE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("PSYM") ("SOLID_WALLS") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("XY_PLANE") ("XYSTYLE") ("XZ_PLANE") ("XZSTYLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("YZ_PLANE") ("YZSTYLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE")) idl)
    ("PLOT_FIELD"             pro nil                 (system) "%s, U, V" (("ASPECT") ("LENGTH") ("N") ("TITLE")) idl)
    ("PLOTERR"                pro nil                 (system) "%s, [ X ,] Y , Err" (("PSYM") ("TYPE")) idl)
    ("PLOTS"                  pro nil                 (system) "%s, X [, Y [, Z]]" (("CLIP") ("COLOR") ("CONTINUE") ("DATA") ("DEVICE") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("PSYM") ("SYMSIZE") ("T3D") ("THICK") ("Z")) idl)
    ("POINT_LUN"              pro nil                 (system) "%s, Unit, Position" nil idl)
    ("POLAR_CONTOUR"          pro nil                 (system) "%s, Z, Theta, R" (("C_ANNOTATION") ("C_CHARSIZE") ("C_CHARTHICK") ("C_COLORS") ("C_LINESTYLE") ("C_ORIENTATION") ("C_SPACING") ("C_THICK") ("CLOSED") ("FILL") ("IRREGULAR") ("LEVELS") ("MAX_VALUE") ("MIN_VALUE") ("NLEVELS") ("OVERPLOT") ("PATH_DATA_COORDS") ("SHOW_TRIANGULATION") ("TRIANGULATION") ("XLOG") ("YLOG") ("ZAXIS")) idl)
    ("POLYFILL"               pro nil                 (system) "%s, X [, Y [, Z]]" (("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FILL_PATTERN") ("IMAGE_COORD") ("IMAGE_INTERP") ("LINE_FILL") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("PATTERN") ("SPACING") ("T3D") ("THICK") ("TRANSPARENT") ("Z")) idl)
    ("POLYWARP"               pro nil                 (system) "%s, Xi, Yi, Xo, Yo, Degree, Kx, Ky" nil idl)
    ("POPD"                   pro nil                 (system) "%s" nil idl)
    ("POWELL"                 pro nil                 (system) "%s, P, Xi, Ftol, Fmin, Func" (("DOUBLE") ("ITER") ("ITMAX")) idl)
    ("PRINT"                  pro nil                 (system) "%s [, Expr1, ..., Exprn]" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("REWRITE") ("STDIO_NON_FINITE")) idl)
    ("PRINTD"                 pro nil                 (system) "%s" nil idl)
    ("PRINTF"                 pro nil                 (system) "%s [, Unit, Expr1, ..., Exprn]" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("REWRITE") ("STDIO_NON_FINITE")) idl)
    ("PROFILER"               pro nil                 (system) "%s [, Module]" (("CLEAR") ("DATA") ("OUTPUT") ("REPORT") ("RESET") ("SYSTEM")) idl)
    ("PROFILES"               pro nil                 (system) "%s, Image" (("ORDER") ("SX") ("SY") ("WSIZE")) idl)
    ("PS_SHOW_FONTS"          pro nil                 (system) "%s" (("NOLATIN")) idl)
    ("PSAFM"                  pro nil                 (system) "%s, Input_Filename, Output_Filename" nil idl)
    ("PSEUDO"                 pro nil                 (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" nil idl)
    ("PTR_FREE"               pro nil                 (system) "%s, P1, ... ..., Pn" nil idl)
    ("PUSHD"                  pro nil                 (system) "%s, Dir" nil idl)
    ("RDPIX"                  pro nil                 (system) "%s, Image [, X0, Y0]" nil idl)
    ("READ"                   pro nil                 (system) "%s, [Prompt,] Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("MONTHS") ("PROMPT")) idl)
    ("READ_GIF"               pro nil                 (system) "%s, Filename, Image [, R, G, B]" (("CLOSE") ("MULTIPLE")) idl)
    ("READ_INTERFILE"         pro nil                 (system) "%s, File, Data" nil idl)
    ("READ_JPEG"              pro nil                 (system) "%s [, Filename]" (("BUFFER") ("COLORS") ("DITHER") ("GRAYSCALE") ("ORDER") ("TRUE") ("TWO_PASS_QUANTIZE") ("UNIT")) idl)
    ("READ_PICT"              pro nil                 (system) "%s, Filename, Image [, R, G, B]" nil idl)
    ("READ_PPM"               pro nil                 (system) "%s, Filename, Image" (("MAXVAL")) idl)
    ("READ_SRF"               pro nil                 (system) "%s, Filename, Image [, R, G, B]" nil idl)
    ("READ_WAVE"              pro nil                 (system) "%s, File, Variables, Names, Dimensions" (("MESHNAMES")) idl)
    ("READ_X11_BITMAP"        pro nil                 (system) "%s, File, Bitmap [, X, Y]" (("EXPAND_TO_BYTES")) idl)
    ("READF"                  pro nil                 (system) "%s, [Prompt,] Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("MONTHS") ("PROMPT")) idl)
    ("READS"                  pro nil                 (system) "%s, Input, Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS")) idl)
    ("READU"                  pro nil                 (system) "%s, Unit, Var1, ..., Varn" (("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("TRANSFER_COUNT")) idl)
    ("REDUCE_COLORS"          pro nil                 (system) "%s, Image, Values" nil idl)
    ("REPLICATE_INPLACE"      pro nil                 (system) "%s, X, Value [, D1, Loc1 [, D2, Range]]" nil idl)
    ("RESOLVE_ALL"            pro nil                 (system) "%s" (("CONTINUE_ON_ERROR") ("QUIET")) idl)
    ("RESOLVE_ROUTINE"        pro nil                 (system) "%s, Name" (("EITHER") ("IS_FUNCTION") ("NO_RECOMPLIE")) idl)
    ("RESTORE"                pro nil                 (system) "%s [, Filename]" (("FILENAME") ("RELAXED_STRUCTURE_ASSIGNMENT") ("RESTORED_OBJECTS") ("VERBOSE")) idl)
    ("RETALL"                 pro nil                 (system) "%s" nil idl)
    ("RETURN"                 pro nil                 (system) "%s [, Return_value]" nil idl)
    ("REWIND"                 pro nil                 (system) "%s, Unit" nil idl)
    ("RIEMANN"                pro nil                 (system) "%s, P, A, Theta" (("BACKPROJECT") ("BILINEAR") ("CENTER") ("COR") ("CUBIC") ("D") ("ROW")) idl)
    ("SAVE"                   pro nil                 (system) "%s [, Var1, ..., Varn]" (("ALL") ("COMM") ("COMPRESS") ("FILENAME") ("SYSTEM_VARIABLES") ("VARIABLES") ("VERBOSE")) idl)
    ("SCALE3"                 pro nil                 (system) "%s" (("AX") ("AZ") ("XRANGE") ("YRANGE") ("ZRANGE")) idl)
    ("SCALE3D"                pro nil                 (system) "%s" nil idl)
    ("SET_PLOT"               pro nil                 (system) "%s, Device" (("COPY") ("INTERPOLATE")) idl)
    ("SET_SHADING"            pro nil                 (system) "%s" (("GOURAUD") ("LIGHT") ("REJECT") ("VALUES")) idl)
    ("SET_SYMBOL"             pro nil                 (system) "%s, Name, Value" (("TYPE")) idl)
    ("SETENV"                 pro nil                 (system) "%s, Environment_Expression" nil idl)
    ("SETLOG"                 pro nil                 (system) "%s, Lognam, Value" (("CONCEALED") ("CONFINE") ("NO_ALIAS") ("TABLE") ("TERMINAL")) idl)
    ("SETUP_KEYS"             pro nil                 (system) "%s" (("APP_KEYPAD") ("EIGHTBIT") ("HP9000") ("MIPS") ("NUM_KEYPAD") ("PSTERM") ("SGI") ("SUN") ("VT200")) idl)
    ("SHADE_SURF"             pro nil                 (system) "%s, Z [, X, Y]" (("AX") ("AZ") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("IMAGE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NORMAL") ("PIXELS") ("POSITION") ("SAVE") ("SHADES") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE") ("ZVALUE")) idl)
    ("SHADE_SURF_IRR"         pro nil                 (system) "%s, Z, X, Y" (("AX") ("AZ") ("IMAGE") ("PLIST") ("T3D")) idl)
    ("SHADE_VOLUME"           pro nil                 (system) "%s, Volume, Value, Vertex, Poly" (("LOW") ("SHADES") ("VERBOSE") ("XRANGE") ("YRANGE") ("ZRANGE")) idl)
    ("SHOW3"                  pro nil                 (system) "%s, Image [, X, Y]" (("E_CONTOUR") ("E_SURFACE") ("INTERP") ("SSCALE")) idl)
    ("SHOWFONT"               pro nil                 (system) "%s, Font, Name" (("ENCAPSULATED") ("TT_FONT")) idl)
    ("SKIPF"                  pro nil                 (system) "%s, Unit, Files or SKIPF, Unit, Records, R" nil idl)
    ("SLICER3"                pro nil                 (system) "%s [, hData3D]" (("DATA_NAMES") ("DETACH") ("GROUP") ("MODAL")) idl)
    ("SLIDE_IMAGE"            pro nil                 (system) "%s [, Image]" (("BLOCK") ("CONGRID") ("FULL_WINDOW") ("GROUP") ("ORDER") ("REGISTER") ("RETAIN") ("SHOW_FULL") ("SLIDE_WINDOW") ("TITLE") ("TOP_ID") ("XSIZE") ("XVISIBLE") ("YSIZE") ("YVISIBLE")) idl)
    ("SPAWN"                  pro nil                 (system) "%s [, Command(s) [, Result]]" (("COUNT") ("MACCREATOR") ("NOCLISYM") ("NOLOGNAM") ("NOSHELL") ("NOTIFY") ("NOTTYRESET") ("NOWAIT") ("PID") ("SH") ("UNIT")) idl)
    ("SPH_4PNT"               pro nil                 (system) "%s, X, Y, Z, Xc, Yc, Zc, R" nil idl)
    ("SPLINE_P"               pro nil                 (system) "%s, X, Y, Xr, Yr" (("INTERVAL") ("TAN0") ("TAN1")) idl)
    ("STOP"                   pro nil                 (system) "%s [, Expr1, ..., Exprn]" nil idl)
    ("STREAMLINE"             pro nil                 (system) "%s, Verts, Conn, Normals, Outverts, Outconn" (("ANISOTROPY") ("PROFILE") ("SIZE")) idl)
    ("STRETCH"                pro nil                 (system) "%s [, Low, High [, Gamma]]" (("CHOP")) idl)
    ("STRPUT"                 pro nil                 (system) "%s, Destination, Source [, Position]" nil idl)
    ("STRUCT_ASSIGN"          pro nil                 (system) "%s, Source, Destination" (("NOZERO") ("VERBOSE")) idl)
    ("STRUCT_HIDE"            pro nil                 (system) "%s, Arg1 [, Arg2, ..., Argn]" nil idl)
    ("SURFACE"                pro nil                 (system) "%s, Z [, X, Y]" (("AX") ("AZ") ("BACKGROUND") ("BOTTOM") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("HORIZONTAL") ("LEGO") ("LINESTYLE") ("LOWER_ONLY") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("SAVE") ("SHADES") ("SKIRT") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("UPPER_ONLY") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKV") ("ZTITLE") ("ZVALUE")) idl)
    ("SURFR"                  pro nil                 (system) "%s" (("AX") ("AZ")) idl)
    ("SVDC"                   pro nil                 (system) "%s, A, W, U, V" (("COLUMN") ("DOUBLE")) idl)
    ("T3D"                    pro nil                 (system) "%s" (("OBLIQUE") ("PERSPECTIVE") ("RESET") ("ROTATE") ("SCALE") ("TRANSLATIONS") ("XYEXCH") ("XZEXCH") ("YZEXCH")) idl)
    ("TAPRD"                  pro nil                 (system) "%s, Array, Unit [, Byte_Reverse]" nil idl)
    ("TAPWRT"                 pro nil                 (system) "%s, Array, Unit [, Byte_Reverse]" nil idl)
    ("TEK_COLOR"              pro nil                 (system) "%s [, Start_Index, Colors]" nil idl)
    ("THREED"                 pro nil                 (system) "%s, A [, Sp]" (("TITLE") ("XTITLE") ("YTITLE")) idl)
    ("TIME_TEST2"             pro nil                 (system) "%s [, Filename]" nil idl)
    ("TRIANGULATE"            pro nil                 (system) "%s, X, Y, Triangles [, B]" (("CONNECTIVITY") ("DEGREES") ("FVALUE") ("REPEATS") ("SPHERE")) idl)
    ("TRIQL"                  pro nil                 (system) "%s, D, E, A" (("DOUBLE")) idl)
    ("TRIRED"                 pro nil                 (system) "%s, A, D, E" (("DOUBLE")) idl)
    ("TV"                     pro nil                 (system) "%s, Image [, Position] or TV, Image [, X, Y [, Channel]]" (("CENTIMETERS") ("CHANNEL") ("DATA") ("DEVICE") ("INCHES") ("NORMAL") ("ORDER") ("T3D") ("TRUE") ("WORDS") ("XSIZE") ("YSIZE") ("Z")) idl)
    ("TVCRS"                  pro nil                 (system) "%s [, ON_OFF] or TVCRS [, X, Y]" (("CENTIMETERS") ("DATA") ("DEVICE") ("HIDE_CURSOR") ("INCHES") ("NORMAL") ("T3D") ("Z")) idl)
    ("TVLCT"                  pro nil                 (system) "%s, V1, V2, V3 [, Start]" (("GET") ("HLS") ("HSV")) idl)
    ("TVSCL"                  pro nil                 (system) "%s, Image [, Position] or TVSCL, Image [, X, Y [, Channel]]" (("CENTIMETERS") ("CHANNEL") ("DATA") ("DEVICE") ("INCHES") ("NAN") ("NORMAL") ("ORDER") ("T3D") ("TOP") ("TRUE") ("WORDS") ("XSIZE") ("YSIZE") ("Z")) idl)
    ("USERSYM"                pro nil                 (system) "%s, X [, Y]" (("COLOR") ("FILL") ("THICK")) idl)
    ("VECTOR_FIELD"           pro nil                 (system) "%s, Field, Outverts, Outconn" (("ANISOTROPY") ("SCALE") ("VERTICES")) idl)
    ("VEL"                    pro nil                 (system) "%s, U, V" (("LENGTH") ("NSTEPS") ("NVECS") ("TITLE") ("XMAX")) idl)
    ("VELOVECT"               pro nil                 (system) "%s, U, V [, X, Y]" (("COLOR") ("DOTS") ("LENGTH") ("MISSING")) idl)
    ("VORONOI"                pro nil                 (system) "%s, X, Y, I0, C, Xp, Yp, Rect" nil idl)
    ("WAIT"                   pro nil                 (system) "%s, Seconds" nil idl)
    ("WDELETE"                pro nil                 (system) "%s [, Window_Index [, ...]]" nil idl)
    ("WEOF"                   pro nil                 (system) "%s, Unit" nil idl)
    ("WF_DRAW"                pro nil                 (system) "%s, X, Y" (("COLD") ("COLOR") ("CONVERGENCE") ("DATA") ("DEVICE") ("FRONT_TYPE") ("INTERVAL") ("NORM") ("OCCLUDED") ("PSYM") ("STATIONARY") ("SYM_HT") ("SYM_LEN") ("THICK") ("WARM")) idl)
    ("WIDGET_CONTROL"         pro nil                 (system) "%s [, Widget_ID]" (("ALIGNMENT") ("ALL_TABLE_EVENTS") ("ALL_TEXT_EVENTS") ("AM_PM") ("APPEND") ("BAD_ID") ("BITMAP") ("CANCEL_BUTTON") ("CLEAR_EVENTS") ("COLUMN_LABELS") ("COLUMN_WIDTHS") ("DAYS_OF_WEEK") ("DEFAULT_BUTTON") ("DEFAULT_FONT") ("DELAY_DESTROY") ("DELETE_COLUMNS") ("DELETE_ROWS") ("DESTROY") ("DRAW_BUTTON_EVENTS") ("DRAW_EXPOSE_EVENTS") ("DRAW_MOTION_EVENTS") ("DRAW_VIEWPORT_EVENTS") ("DRAW_XSIZE") ("DRAW_YSIZE") ("DYNAMIC_RESIZE") ("EDIT_CELL") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FORMAT") ("FUNC_GET_VALUE") ("GET_DRAW_VIEW") ("GET_UVALUE") ("GET_VALUE") ("GROUP_LEADER") ("HOURGLASS") ("ICONIFY") ("INPUT_FOCUS") ("INSERT_COLUMNS") ("INSERT_ROWS") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MAP") ("MONTHS") ("NO_COPY") ("NO_NEWLINE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("REALIZE") ("RESET") ("ROW_HEIGHTS") ("ROW_LABELS") ("SCR_XSIZE") ("SCR_YSIZE") ("SEND_EVENT") ("SENSITIVE") ("SET_BUTTON") ("SET_DRAW_VIEW") ("SET_DROPLIST_SELECT") ("SET_LIST_SELECT") ("SET_LIST_TOP") ("SET_SLIDER_MAX") ("SET_SLIDER_MIN") ("SET_TABLE_SELECT") ("SET_TABLE_VIEW") ("SET_TEXT_SELECT") ("SET_TEXT_TOP_LINE") ("SET_UNAME") ("SET_UVALUE") ("SET_VALUE") ("SHOW") ("TABLE_XSIZE") ("TABLE_YSIZE") ("TIMER") ("TLB_GET_OFFSET") ("TLB_GET_SIZE") ("TLB_KILL_REQUEST_EVENTS") ("TLB_SET_TITLE") ("TLB_SET_XOFFSET") ("TLB_SET_YOFFSET") ("TRACKING_EVENTS") ("UNITS") ("UPDATE") ("USE_TABLE_SELECT") ("USE_TEXT_SELECT") ("X_BITMAP_EXTRA") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WINDOW"                 pro nil                 (system) "%s [, Window_Index]" (("COLORS") ("FREE") ("PIXMAP") ("RETAIN") ("TITLE") ("XPOS") ("XSIZE") ("YPOS") ("YSIZE")) idl)
    ("WRITE_BMP"              pro nil                 (system) "%s, Filename, Image[, R, G, B]" (("FOUR_BIT") ("HEADER_DEFINE") ("IHDR")) idl)
    ("WRITE_GIF"              pro nil                 (system) "%s, Filename, Image[, R, G, B]" (("CLOSE") ("MULTIPLE")) idl)
    ("WRITE_IMAGE"            pro nil                 (system) "%s, Filename, Format, Data [, Red, Green, Blue]" (("APPEND")) idl)
    ("WRITE_JPEG"             pro nil                 (system) "%s[, Filename], Image" (("ORDER") ("PROGRESSIVE") ("QUALITY") ("TRUE") ("UNIT")) idl)
    ("WRITE_NRIF"             pro nil                 (system) "%s, File, Image [, R, G, B]" nil idl)
    ("WRITE_PICT"             pro nil                 (system) "%s, Filename [, Image, R, G, B]" nil idl)
    ("WRITE_PNG"              pro nil                 (system) "%s, Filename, Image[, R, G, B]" (("TRANSPARENT") ("VERBOSE")) idl)
    ("WRITE_PPM"              pro nil                 (system) "%s, Filename, Image" (("ASCII")) idl)
    ("WRITE_SPR"              pro nil                 (system) "%s, AS, Filename" nil idl)
    ("WRITE_SRF"              pro nil                 (system) "%s, Filename [, Image, R, G, B]" (("ORDER") ("WRITE_32")) idl)
    ("WRITE_TIFF"             pro nil                 (system) "%s, Filename [, Image, Order]" (("APPEND") ("BLUE") ("COMPRESSION") ("FLOAT") ("GEOTIFF") ("GREEN") ("LONG") ("PLANARCONFIG") ("RED") ("SHORT") ("VERBOSE") ("XRESOL") ("YRESOL")) idl)
    ("WRITE_WAV"              pro nil                 (system) "%s, Filename, Data, Rate" nil idl)
    ("WRITE_WAVE"             pro nil                 (system) "%s, File, Array" (("BIN") ("DATANAME") ("MESHNAME") ("NOMESHDEF") ("VECTOR")) idl)
    ("WRITEU"                 pro nil                 (system) "%s, Unit, Expr1 ..., Exprn" (("REWRITE") ("TRANSFER_COUNT")) idl)
    ("WSET"                   pro nil                 (system) "%s [, Window_Index]" nil idl)
    ("WSHOW"                  pro nil                 (system) "%s [, Window_Index [, Show]]" (("ICONIC")) idl)
    ("XBM_EDIT"               pro nil                 (system) "%s" (("BLOCK") ("FILENAME") ("GROUP") ("XSIZE") ("YSIZE")) idl)
    ("XDISPLAYFILE"           pro nil                 (system) "%s, Filename" (("BLOCK") ("FONT") ("GROUP") ("HEIGHT") ("MODAL") ("TEXT") ("TITLE") ("WIDTH")) idl)
    ("XINTERANIMATE"          pro nil                 (system) "%s [, Rate]" (("CLOSE") ("CYCLE") ("FRAME") ("GROUP") ("IMAGE") ("KEEP_PIXMAPS") ("MPEG_CLOSE") ("MPEG_FILENAME") ("MPEG_OPEN") ("NO_BLOCK") ("ORDER") ("SET") ("SHOWLOAD") ("TITLE") ("TRACK") ("WINDOW") ("XOFFSET") ("YOFFSET")) idl)
    ("XLOADCT"                pro nil                 (system) "%s" (("BLOCK") ("BOTTOM") ("FILE") ("GROUP") ("MODAL") ("NCOLORS") ("SILENT") ("UPDATECALLBACK") ("UPDATECBDATA") ("USE_CURENT")) idl)
    ("XMANAGER"               pro nil                 (system) "%s [, Name, ID]" (("CATCH") ("CLEANUP") ("EVENT_HANDLER") ("GROUP_LEADER") ("JUST_REG") ("NO_BLOCK")) idl)
    ("XMNG_TMPL"              pro nil                 (system) "%s" (("BLOCK") ("GROUP")) idl)
    ("XMTOOL"                 pro nil                 (system) "%s" (("BLOCK") ("GROUP")) idl)
    ("XOBJVIEW"               pro nil                 (system) "%s, Obj" (("BLOCK") ("GROUP") ("STATIONARY") ("XSIZE") ("YSIZE")) idl)
    ("XPALETTE"               pro nil                 (system) "%s" (("BLOCK") ("GROUP") ("UPDATECALLBACK") ("UPDATECBDATA")) idl)
    ("XSURFACE"               pro nil                 (system) "%s, Data" (("BLOCK") ("GROUP")) idl)
    ("XVAREDIT"               pro nil                 (system) "%s, Var" (("GROUP") ("NAME") ("X_SCROLL_SIZE") ("Y_SCROLL_SIZE")) idl)
    ("XYOUTS"                 pro nil                 (system) "%s, [X, Y,] String" (("ALIGNMENT") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("T3D") ("TEXT_AXES") ("WIDTH") ("Z")) idl)
    ("ZOOM"                   pro nil                 (system) "%s" (("CONTINUOUS") ("FACT") ("INTERP") ("KEEP") ("NEW_WINDOW") ("XSIZE") ("YSIZE") ("ZOOM_WINDOW")) idl)
    ("ZOOM_24"                pro nil                 (system) "%s" (("FACT") ("RIGHT") ("XSIZE") ("YSIZE")) idl)
    ("A_CORRELATE"            fun nil                 (system) "Result = %s(X, Lag)" (("COVARIANCE") ("DOUBLE")) idl)
    ("ABS"                    fun nil                 (system) "Result = %s(X)" nil idl)
    ("ACOS"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("ADAPT_HIST_EQUAL"       fun nil                 (system) "Result = %s (Image)" (("CLIP") ("NREGIONS") ("TOP")) idl)
    ("ALOG"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("ALOG10"                 fun nil                 (system) "Result = %s(X)" nil idl)
    ("AMOEBA"                 fun nil                 (system) "Result = %s( Ftol)" (("FUNCTION_NAME") ("FUNCTION_VALUE") ("NCALLS") ("NMAX") ("P0") ("SCALE") ("SIMPLEX")) idl)
    ("ARG_PRESENT"            fun nil                 (system) "Result = %s(Variable)" nil idl)
    ("ASCII_TEMPLATE"         fun nil                 (system) "Result = %s( [Filename])" (("BROWSE_LINES") ("CANCEL") ("GROUP")) idl)
    ("ASIN"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("ASSOC"                  fun nil                 (system) "Result = %s( Unit, Array_Structure [, Offset])" (("PACKED")) idl)
    ("ATAN"                   fun nil                 (system) "Result = %s([Y,] X)" nil idl)
    ("BESELI"                 fun nil                 (system) "Result = %s(X, N)" nil idl)
    ("BESELJ"                 fun nil                 (system) "Result = %s(X, N)" nil idl)
    ("BESELY"                 fun nil                 (system) "Result = %s(X, N)" nil idl)
    ("BETA"                   fun nil                 (system) "Result = %s( Z, W)" (("DOUBLE")) idl)
    ("BILINEAR"               fun nil                 (system) "Result = %s(P, IX, JY)" nil idl)
    ("BIN_DATE"               fun nil                 (system) "Result = %s(Ascii_Time)" nil idl)
    ("BINARY_TEMPLATE"        fun nil                 (system) "Template = %s ( [Filename])" (("CANCEL") ("GROUP") ("N_ROWS") ("TEMPLATE")) idl)
    ("BINDGEN"                fun nil                 (system) "Result = %s(D1, ...,D8)" nil idl)
    ("BINOMIAL"               fun nil                 (system) "Result = %s(V, N, P)" nil idl)
    ("BLK_CON"                fun nil                 (system) "Result = %s( Filter, Signal)" (("B_LENGTH")) idl)
    ("BROYDEN"                fun nil                 (system) "Result = %s( X, Vecfunc)" (("CHECK") ("DOUBLE") ("ITMAX") ("STEPMAX") ("TOLF") ("TOLMIN") ("TOLX")) idl)
    ("BYTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("BYTE"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("BYTSCL"                 fun nil                 (system) "Result = %s( Array)" (("MAX") ("MIN") ("NAN") ("TOP")) idl)
    ("C_CORRELATE"            fun nil                 (system) "Result = %s( X, Y, Lag)" (("COVARIANCE") ("DOUBLE")) idl)
    ("CALL_EXTERNAL"          fun nil                 (system) "Result = %s(Image, Entry [, P0, ..., PN-1])" (("ALL_VALUE") ("B_VALUE") ("CDECL") ("D_VALUE") ("DEFAULT") ("F_VALUE") ("I_VALUE") ("L64_VALUE") ("PORTABLE") ("RETURN_TYPE") ("S_VALUE") ("UI_VALUE") ("UL64_VALUE") ("UL_VALUE") ("UNLOAD") ("VALUE") ("VAX_FLOAT")) idl)
    ("CALL_FUNCTION"          fun nil                 (system) "Result = %s(Name [, P1, ..., Pn])" nil idl)
    ("CALL_METHOD"            fun nil                 (system) "Result = %s, Name, ObjRef, [, P1, ..., Pn]" nil idl)
    ("CDF_ATTCREATE"          fun nil                 (system) "Result = %s( Id, Attribute_Name)" (("GLOBAL_SCOPE") ("VARIABLE_SCOPE")) sdf)
    ("CDF_ATTEXISTS"          fun nil                 (system) "Result = %s( Id, Attribute [, EntryNum])" (("ZVARIABLE")) sdf)
    ("CDF_ATTNUM"             fun nil                 (system) "Result = %s(Id, Attribute_Name)" nil sdf)
    ("CDF_CREATE"             fun nil                 (system) "Result = %s( Filename, [Dimensions])" (("ALPHAOSF1_DECODING") ("ALPHAOSF1_ENCODING") ("ALPHAVMSD_DECODING") ("ALPHAVMSD_ENCODING") ("ALPHAVMSG_DECODING") ("ALPHAVMSG_ENCODING") ("CLOBBER") ("COL_MAJOR") ("DECSTATION_DECODING") ("DECSTATION_ENCODING") ("HOST_DECODING") ("HOST_ENCODING") ("HP_DECODING") ("HP_ENCODING") ("IBMPC_DECODING") ("IBMPC_ENCODING") ("IBMRS_DECODING") ("IBMRS_ENCODING") ("MAC_DECODING") ("MAC_ENCODING") ("MULTI_FILE") ("NETWORK_DECODING") ("NETWORK_ENCODING") ("NEXT_DECODING") ("NEXT_ENCODING") ("ROW_MAJOR") ("SGI_DECODING") ("SGI_ENCODING") ("SINGLE_FILE") ("SUN_DECODING") ("SUN_ENCODING")) sdf)
    ("CDF_ENCODE_EPOCH"       fun nil                 (system) "Result = %s(Epoch)" (("EPOCH")) sdf)
    ("CDF_ERROR"              fun nil                 (system) "Result = %s(Status)" nil sdf)
    ("CDF_EXISTS"             fun nil                 (system) "Result = %s( )" nil sdf)
    ("CDF_INQUIRE"            fun nil                 (system) "Result = %s(Id)" nil sdf)
    ("CDF_OPEN"               fun nil                 (system) "Result = %s(Filename)" nil sdf)
    ("CDF_PARSE_EPOCH"        fun nil                 (system) "Result = %s(Epoch_string)" nil sdf)
    ("CDF_VARCREATE"          fun nil                 (system) "Result = %s( Id, Name [, DimVary])" (("ALLOCATERECS") ("CDF_BYTE") ("CDF_CHAR") ("CDF_DOUBLE") ("CDF_EPOCH") ("CDF_FLOAT") ("CDF_INT1") ("CDF_INT2") ("CDF_INT4") ("CDF_REAL4") ("CDF_REAL8") ("CDF_UCHAR") ("CDF_UINT1") ("CDF_UINT2") ("CDF_UINT4") ("DIMENSIONS") ("NUMELEM") ("REC_NOVARY") ("REC_VARY") ("ZVARIABLE")) sdf)
    ("CDF_VARINQ"             fun nil                 (system) "Result = %s( Id, Variable)" (("ZVARIABLE")) sdf)
    ("CDF_VARNUM"             fun nil                 (system) "Result = %s( Id, VarName [, IsZVar] )" nil sdf)
    ("CEIL"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("CHEBYSHEV"              fun nil                 (system) "Result = %s(D, N)" nil idl)
    ("CHECK_MATH"             fun nil                 (system) "Result = %s()" (("MASK") ("NOCLEAR") ("PRINT")) idl)
    ("CHISQR_CVF"             fun nil                 (system) "Result = %s(P, Df)" nil idl)
    ("CHISQR_PDF"             fun nil                 (system) "Result = %s(V, Df)" nil idl)
    ("CHOLSOL"                fun nil                 (system) "Result = %s( A, P, B)" (("DOUBLE")) idl)
    ("CINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("CLUST_WTS"              fun nil                 (system) "Result = %s( Array)" (("DOUBLE") ("N_CLUSTERS") ("N_ITERATIONS") ("VARIABLE_WTS")) idl)
    ("CLUSTER"                fun nil                 (system) "Result = %s( Array, Weights)" (("DOUBLE") ("N_CLUSTERS")) idl)
    ("COLOR_QUAN"             fun nil                 (system) "Result = %s( Image_R, Image_G, Image_B, R, G, B) or Result = COLOR_QUAN( Image, Dim, R, G, B )" (("COLORS") ("CUBE") ("DITHER") ("ERROR") ("GET_TRANSLATION") ("MAP_ALL") ("TRANSLATION")) idl)
    ("COMFIT"                 fun nil                 (system) "Result = %s( X, Y, A)" (("EXPONENTIAL") ("GEOMETRIC") ("GOMPERTZ") ("HYPERBOLIC") ("LOGISTIC") ("LOGSQUARE") ("SIGMA") ("WEIGHTS") ("YFIT")) idl)
    ("COMPLEX"                fun nil                 (system) "Result = %s( Real [, Imaginary] ) or Result = COMPLEX(Expression, Offset, Dim1 [, ..., Dim8])" nil idl)
    ("COMPLEXARR"             fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("COMPLEXROUND"           fun nil                 (system) "Result = %s(Input)" nil idl)
    ("COMPUTE_MESH_NORMALS"   fun nil                 (system) "Result = %s( fVerts[, iConn] )" nil idl)
    ("COND"                   fun nil                 (system) "Result = %s( A)" (("DOUBLE")) idl)
    ("CONGRID"                fun nil                 (system) "Result = %s( Array, X, Y, Z)" (("CUBIC") ("INTERP") ("MINUS_ONE")) idl)
    ("CONJ"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("CONVERT_COORD"          fun nil                 (system) "Result = %s( X [, Y [, Z]])" (("DATA") ("DEVICE") ("NORMAL") ("T3D") ("TO_DATA") ("TO_DEVICE") ("TO_NORMAL")) idl)
    ("CONVOL"                 fun nil                 (system) "Result = %s( Array, Kernel [, Scale_Factor])" (("CENTER") ("EDGE_TRUNCATE") ("EDGE_WRAP")) idl)
    ("COORD2TO3"              fun nil                 (system) "Result = %s( Mx, My, Dim, D0 [, PTI] )" nil idl)
    ("CORRELATE"              fun nil                 (system) "Result = %s( X [, Y])" (("COVARIANCE") ("DOUBLE")) idl)
    ("COS"                    fun nil                 (system) "Result = %s(X)" nil idl)
    ("COSH"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("CRAMER"                 fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("ZERO")) idl)
    ("CREATE_STRUCT"          fun nil                 (system) "Result = %s( [Tag1, Value1, ..., Tagn, Valuen] ) or Result = CREATE_STRUCT()" (("NAME")) idl)
    ("CROSSP"                 fun nil                 (system) "Result = %s(V1, V2)" nil idl)
    ("CRVLENGTH"              fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE")) idl)
    ("CT_LUMINANCE"           fun nil                 (system) "Result = %s( [R, G, B])" (("BRIGHT") ("DARK") ("READ_TABLES")) idl)
    ("CTI_TEST"               fun nil                 (system) "Result = %s( Obfreq)" (("COEFF") ("CORRECTED") ("CRAMV") ("DF") ("EXFREQ") ("RESIDUAL")) idl)
    ("CURVEFIT"               fun nil                 (system) "Result = %s( X, Y, Weights, A [, Sigma])" (("CHISQ") ("FUNCTION_NAME") ("ITER") ("ITMAX") ("NODERIVATIVE") ("TOL")) idl)
    ("CV_COORD"               fun nil                 (system) "Result = %s()" (("DEGREES") ("FROM_CYLIN") ("FROM_POLAR") ("FROM_RECT") ("FROM_SPHERE") ("TO_CYLIN") ("TO_POLAR") ("TO_RECT") ("TO_SPHERE")) idl)
    ("CVTTOBM"                fun nil                 (system) "Result = %s( Array)" (("THRESHOLD")) idl)
    ("CW_ANIMATE"             fun nil                 (system) "Result = %s( Parent, Sizex, Sizey, Nframes)" (("NO_KILL") ("OPEN_FUNC") ("PIXMAPS") ("TRACK") ("UNAME") ("UVALUE")) idl)
    ("CW_ARCBALL"             fun nil                 (system) "Result = %s( Parent)" (("COLORS") ("FRAME") ("LABEL") ("RETAIN") ("SIZE") ("UNAME") ("UPDATE") ("UVALUE") ("VALUE")) idl)
    ("CW_BGROUP"              fun nil                 (system) "Result = %s( Parent, Names)" (("BUTTON_UVALUE") ("COLUMN") ("EVENT_FUNCT") ("EXCLUSIVE") ("FONT") ("FRAME") ("IDS") ("LABEL_LEFT") ("LABEL_TOP") ("MAP") ("NO_RELEASE") ("NONEXCLUSIVE") ("RETURN_ID") ("RETURN_INDEX") ("RETURN_NAME") ("ROW") ("SCROLL") ("SET_VALUE") ("SPACE") ("UNAME") ("UVALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XPAD") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YPAD") ("YSIZE")) idl)
    ("CW_CLR_INDEX"           fun nil                 (system) "Result = %s( Parent)" (("COLOR_VALUES") ("EVENT_FUNC") ("FRAME") ("LABEL") ("NCOLORS") ("START_COLOR") ("UNAME") ("UVALUE") ("XSIZE") ("YSIZE")) idl)
    ("CW_COLORSEL"            fun nil                 (system) "Result = %s( Parent)" (("FRAME") ("UNAME") ("UVALUE") ("XOFFSET") ("YOFFSET")) idl)
    ("CW_DEFROI"              fun nil                 (system) "Result = %s( Draw)" (("IMAGE_SIZE") ("OFFSET") ("ORDER") ("RESTORE") ("ZOOM")) idl)
    ("CW_DICE"                fun nil                 (system) "Result = %s( Parent)" (("TUMBLE_CNT") ("TUMBLE_PERIOD") ("UNAME") ("UVALUE")) idl)
    ("CW_FIELD"               fun nil                 (system) "Result = %s( Parent)" (("ALL_EVENTS") ("COLUMN") ("FIELDFONT") ("FLOATING") ("FONT") ("FRAME") ("INTEGER") ("LONG") ("NOEDIT") ("RETURN_EVENTS") ("ROW") ("STRING") ("TITLE") ("UNAME") ("UVALUE") ("VALUE") ("XSIZE") ("YSIZE")) idl)
    ("CW_FILESEL"             fun nil                 (system) "Result = %s ( Parent)" (("FILENAME") ("FILTER") ("FIX_FILTER") ("FRAME") ("IMAGE_FILTER") ("MULTIPLE") ("PATH") ("UNAME") ("UVALUE")) idl)
    ("CW_FORM"                fun nil                 (system) "Result = %s( [Parent,] Desc)" (("COLUMN") ("IDS") ("NO_RELEASE") ("TITLE") ("UNAME") ("UVALUE")) idl)
    ("CW_FSLIDER"             fun nil                 (system) "Result = %s( Parent)" (("DRAG") ("EDIT") ("FORMAT") ("FRAME") ("MAXIMUM") ("MINIMUM") ("SCROLL") ("SUPRESS_VALUE") ("TITLE") ("UNAME") ("UVALUE") ("VALUE") ("VERTICAL") ("XSIZE") ("YSIZE")) idl)
    ("CW_LIGHT_EDITOR"        fun nil                 (system) "Result = %s (Parent)" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("FRAME") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("UVALUE") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")) idl)
    ("CW_ORIENT"              fun nil                 (system) "Result = %s( Parent)" (("AX") ("AZ") ("FRAME") ("TITLE") ("UNAME") ("UVALUE") ("XSIZE") ("YSIZE")) idl)
    ("CW_PALETTE_EDITOR"      fun nil                 (system) "Result = %s (Parent)" (("DATA") ("FRAME") ("HISTOGRAM") ("HORIZONTAL") ("SELECTION") ("UNAME") ("UVALUE") ("XSIZE") ("YSIZE")) idl)
    ("CW_PDMENU"              fun nil                 (system) "Result = %s( Parent, Desc)" (("DELIMITER") ("FONT") ("HELP") ("IDS") ("MBAR") ("RETURN_FULL_NAME") ("RETURN_ID") ("RETURN_INDEX") ("RETURN_NAME") ("UNAME") ("UVALUE") ("XOFFSET") ("YOFFSET")) idl)
    ("CW_RGBSLIDER"           fun nil                 (system) "Result = %s( Parent)" (("CMY") ("COLOR_INDEX") ("DRAG") ("FRAME") ("HLS") ("HSV") ("LENGTH") ("RGB") ("UNAME") ("UVALUE") ("VERTICAL")) idl)
    ("CW_TMPL"                fun nil                 (system) "Result = %s( Parent)" (("UNAME") ("UVALUE")) idl)
    ("CW_ZOOM"                fun nil                 (system) "Result = %s( Parent)" (("FRAME") ("MAX") ("MIN") ("RETAIN") ("SAMPLE") ("SCALE") ("TRACK") ("UNAME") ("UVALUE") ("X_SCROLL_SIZE") ("X_ZSIZE") ("XSIZE") ("Y_SCROLL_SIZE") ("Y_ZSIZE") ("YSIZE")) idl)
    ("DBLARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("DCINDGEN"               fun nil                 (system) "Result = %s( D1, ..., D8 )" nil idl)
    ("DCOMPLEX"               fun nil                 (system) "Result = %s( Real [, Imaginary] ) or Result = DCOMPLEX( Expression, Offset, Dim1 [, ..., Dim8] )" nil idl)
    ("DCOMPLEXARR"            fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("DEFROI"                 fun nil                 (system) "Result = %s( Sx, Sy [, Xverts, Yverts])" (("NOFILL") ("NOREGION") ("RESTORE") ("X0") ("Y0") ("ZOOM")) idl)
    ("DERIV"                  fun nil                 (system) "Result = %s([X,] Y)" nil idl)
    ("DERIVSIG"               fun nil                 (system) "Result = %s( [X, Y, Sigx,] Sigy )" nil idl)
    ("DETERM"                 fun nil                 (system) "Result = %s( A)" (("CHECK") ("DOUBLE") ("ZERO")) idl)
    ("DIALOG_MESSAGE"         fun nil                 (system) "Result = %s( Message_Text)" (("CANCEL") ("DEFAULT_CANCEL") ("DEFAULT_NO") ("DIALOG_PARENT") ("DISPLAY_NAME") ("ERROR") ("INFORMATION") ("QUESTION") ("RESOURCE_NAME") ("TITLE")) idl)
    ("DIALOG_PICKFILE"        fun nil                 (system) "Result = %s()" (("DIALOG_PARENT") ("DIRECTORY") ("DISPLAY_NAME") ("FILE") ("FILTER") ("FIX_FILTER") ("GET_PATH") ("GROUP") ("MULTIPLE_FILES") ("MUST_EXIST") ("NOCONFIRM") ("PATH") ("READ") ("RESOURCE_NAME") ("TITLE") ("WRITE")) idl)
    ("DIALOG_PRINTERSETUP"    fun nil                 (system) "Result = %s( [PrintDestination])" (("DIALOG_PARENT") ("DISPLAY_NAME") ("RESOURCE_NAME") ("TITLE")) idl)
    ("DIALOG_PRINTJOB"        fun nil                 (system) "Result = %s( [PrintDestination])" (("DIALOG_PARENT") ("DISPLAY_NAME") ("RESOURCE_NAME") ("TITLE")) idl)
    ("DIALOG_READ_IMAGE"      fun nil                 (system) "Result = %s ( [Filename])" (("BLUE") ("DIALOG_PARENT") ("FILE") ("FILTER") ("FIX_FILTER") ("GREEN") ("IMAGE") ("PATH") ("QUERY") ("RED") ("TITLE")) idl)
    ("DIALOG_WRITE_IMAGE"     fun nil                 (system) "Result = %s ( Image [, R, G, B])" (("DIALOG_PARENT") ("FILENAME") ("FIX_TYPE") ("NOWRITE") ("OPTIONS") ("PATH") ("TITLE") ("TYPE")) idl)
    ("DIGITAL_FILTER"         fun nil                 (system) "Result = %s( Flow, Fhigh, A, Nterms )" nil idl)
    ("DILATE"                 fun nil                 (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" (("BACKGROUND") ("CONSTRAINED") ("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("DINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("DIST"                   fun nil                 (system) "Result = %s(N [, M])" nil idl)
    ("DOUBLE"                 fun nil                 (system) "Result = %s(Expression[, Offset [, Dim1, ..., Dimn]])" nil idl)
    ("EIGENQL"                fun nil                 (system) "Result = %s( A)" (("ABSOLUTE") ("ASCENDING") ("DOUBLE") ("EIGENVECTORS") ("OVERWRITE") ("RESIDUAL")) idl)
    ("EIGENVEC"               fun nil                 (system) "Result = %s( A, Eval)" (("DOUBLE") ("ITMAX") ("RESIDUAL")) idl)
    ("ELMHES"                 fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE") ("NO_BALANCE")) idl)
    ("EOF"                    fun nil                 (system) "Result = %s(Unit)" nil idl)
    ("EOS_EH_CONVANG"         fun nil                 (system) "Result = %s(inAngle, code)" nil sdf)
    ("EOS_EH_GETVERSION"      fun nil                 (system) "Result = %s(fid, version)" nil sdf)
    ("EOS_EH_IDINFO"          fun nil                 (system) "Result = %s(fid, HDFfid, sdInterfaceID)" nil sdf)
    ("EOS_EXISTS"             fun nil                 (system) "Result = %s( )" nil sdf)
    ("EOS_GD_ATTACH"          fun nil                 (system) "Result = %s(fid, gridname)" nil sdf)
    ("EOS_GD_ATTRINFO"        fun nil                 (system) "Result = %s(gridID, attrname, numbertype, count)" nil sdf)
    ("EOS_GD_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil sdf)
    ("EOS_GD_COMPINFO"        fun nil                 (system) "Result = %s(gridID, fieldname, compcode, compparm)" nil sdf)
    ("EOS_GD_CREATE"          fun nil                 (system) "Result = %s(fid, gridname, xdimsize, ydimsize, upleftpt, lowrightpt)" nil sdf)
    ("EOS_GD_DEFBOXREGION"    fun nil                 (system) "Result = %s(gridID, cornerlon, cornerlat)" nil sdf)
    ("EOS_GD_DEFCOMP"         fun nil                 (system) "Result = %s(gridID, compcode [, compparm] )" nil sdf)
    ("EOS_GD_DEFDIM"          fun nil                 (system) "Result = %s(gridID, dimname, dim)" nil sdf)
    ("EOS_GD_DEFFIELD"        fun nil                 (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" (("MERGE")) sdf)
    ("EOS_GD_DEFORIGIN"       fun nil                 (system) "Result = %s(gridID, origincode)" nil sdf)
    ("EOS_GD_DEFPIXREG"       fun nil                 (system) "Result = %s(gridID, pixreg)" nil sdf)
    ("EOS_GD_DEFPROJ"         fun nil                 (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" nil sdf)
    ("EOS_GD_DEFTILE"         fun nil                 (system) "Result = %s( gridID, tilecode [, tilerank, tiledims] )" nil sdf)
    ("EOS_GD_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(gridID, periodID, starttime, stoptime)" nil sdf)
    ("EOS_GD_DEFVRTREGION"    fun nil                 (system) "Result = %s(gridID, regionID, vertObj, range)" nil sdf)
    ("EOS_GD_DETACH"          fun nil                 (system) "Result = %s(gridID)" nil sdf)
    ("EOS_GD_DIMINFO"         fun nil                 (system) "Result = %s(gridID, dimname)" nil sdf)
    ("EOS_GD_DUPREGION"       fun nil                 (system) "Result = %s(regionID)" nil sdf)
    ("EOS_GD_EXTRACTREGION"   fun nil                 (system) "Result = %s(gridID, regionID, fieldname, buffer)" nil sdf)
    ("EOS_GD_FIELDINFO"       fun nil                 (system) "Result = %s(gridID, fieldname, rank, dims, numbertype, dimlist)" nil sdf)
    ("EOS_GD_GETFILLVALUE"    fun nil                 (system) "Result = %s(gridID, fieldname, fillvalue)" nil sdf)
    ("EOS_GD_GETPIXELS"       fun nil                 (system) "Result = %s(gridID, nLonLat, lonVal, latVal, pixRow, pixCol)" nil sdf)
    ("EOS_GD_GETPIXVALUES"    fun nil                 (system) "Result = %s(gridID, nPixels, pixRow, pixCol, fieldname, buffer)" nil sdf)
    ("EOS_GD_GRIDINFO"        fun nil                 (system) "Result = %s(gridID, xdimsize, ydimsize, upleft, lowright)" nil sdf)
    ("EOS_GD_INQATTRS"        fun nil                 (system) "Result = %s( gridID, attrlist)" (("LENGTH")) sdf)
    ("EOS_GD_INQDIMS"         fun nil                 (system) "Result = %s(gridID, dimname, dims)" nil sdf)
    ("EOS_GD_INQFIELDS"       fun nil                 (system) "Result = %s(gridID, fieldlist, rank, numbertype)" nil sdf)
    ("EOS_GD_INQGRID"         fun nil                 (system) "Result = %s( filename, gridlist)" (("LENGTH")) sdf)
    ("EOS_GD_INTERPOLATE"     fun nil                 (system) "Result = %s(gridID, Interp, lonVal, latVal, fieldname, interpVal)" nil sdf)
    ("EOS_GD_NENTRIES"        fun nil                 (system) "Result = %s( gridID, entrycode)" (("LENGTH")) sdf)
    ("EOS_GD_OPEN"            fun nil                 (system) "Result = %s( filename, access)" (("CREATE") ("RDWR") ("READ")) sdf)
    ("EOS_GD_ORIGININFO"      fun nil                 (system) "Result = %s(gridID, origincode)" nil sdf)
    ("EOS_GD_PIXREGINFO"      fun nil                 (system) "Result = %s(gridID, pixregcode)" nil sdf)
    ("EOS_GD_PROJINFO"        fun nil                 (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" nil sdf)
    ("EOS_GD_QUERY"           fun nil                 (system) "Result = %s( Filename, GridName, [Info])" nil sdf)
    ("EOS_GD_READATTR"        fun nil                 (system) "Result = %s(gridID, attrname, datbuf)" nil sdf)
    ("EOS_GD_READFIELD"       fun nil                 (system) "Result = %s( gridID, fieldname, buffer)" (("EDGE") ("START") ("STRIDE")) sdf)
    ("EOS_GD_READTILE"        fun nil                 (system) "Result = %s(gridID, fieldname, tilecoords, buffer)" nil sdf)
    ("EOS_GD_REGIONINFO"      fun nil                 (system) "Result = %s(gridID, regionID, fieldname, ntype, rank, dims, size, upleftpt, lowrightpt)" nil sdf)
    ("EOS_GD_SETFILLVALUE"    fun nil                 (system) "Result = %s(gridID, fieldname, fillvalue)" nil sdf)
    ("EOS_GD_SETTILECACHE"    fun nil                 (system) "Result = %s(gridID, fieldname, maxcache, cachecode)" nil sdf)
    ("EOS_GD_TILEINFO"        fun nil                 (system) "Result = %s(gridID, fieldname, tilecode, tilerank, tiledims)" nil sdf)
    ("EOS_GD_WRITEATTR"       fun nil                 (system) "Result = %s( gridID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")) sdf)
    ("EOS_GD_WRITEFIELD"      fun nil                 (system) "Result = %s( gridID, fieldname, data)" (("EDGE") ("START") ("STRIDE")) sdf)
    ("EOS_GD_WRITEFIELDMETA"  fun nil                 (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" nil sdf)
    ("EOS_GD_WRITETILE"       fun nil                 (system) "Result = %s(gridID, fieldname, tilecoords, data)" nil sdf)
    ("EOS_PT_ATTACH"          fun nil                 (system) "Result = %s(fid, pointname)" nil sdf)
    ("EOS_PT_ATTRINFO"        fun nil                 (system) "Result = %s( pointID, attrname, numbertype, count)" nil sdf)
    ("EOS_PT_BCKLINKINFO"     fun nil                 (system) "Result = %s(pointID, level, linkfield)" nil sdf)
    ("EOS_PT_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil sdf)
    ("EOS_PT_CREATE"          fun nil                 (system) "Result = %s(fid, pointname)" nil sdf)
    ("EOS_PT_DEFBOXREGION"    fun nil                 (system) "Result = %s(pointID, cornerlon, cornerlat)" nil sdf)
    ("EOS_PT_DEFLEVEL"        fun nil                 (system) "Result = %s(pointID, levelname, fieldlist, fieldtype, fieldorder)" nil sdf)
    ("EOS_PT_DEFLINKAGE"      fun nil                 (system) "Result = %s(pointID, parent, child, linkfield)" nil sdf)
    ("EOS_PT_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(pointID, starttime, stoptime)" nil sdf)
    ("EOS_PT_DEFVRTREGION"    fun nil                 (system) "Result = %s( pointID, regionID, vertObj, range)" nil sdf)
    ("EOS_PT_DETACH"          fun nil                 (system) "Result = %s(pointID)" nil sdf)
    ("EOS_PT_EXTRACTPERIOD"   fun nil                 (system) "Result = %s(pointID, periodID, level, fieldlist, buffer)" nil sdf)
    ("EOS_PT_EXTRACTREGION"   fun nil                 (system) "Result = %s( pointID, regionID, level, fieldlist, buffer)" nil sdf)
    ("EOS_PT_FWDLINKINFO"     fun nil                 (system) "Result = %s(pointID, level, linkfield)" nil sdf)
    ("EOS_PT_GETLEVELNAME"    fun nil                 (system) "Result = %s( pointID, level, levelname)" (("LENGTH")) sdf)
    ("EOS_PT_GETRECNUMS"      fun nil                 (system) "Result = %s( pointID, inlevel, outlevel, inNrec, inRecs, outNrec, outRecs)" nil sdf)
    ("EOS_PT_INQATTRS"        fun nil                 (system) "Result = %s( pointID, attrlist)" (("LENGTH")) sdf)
    ("EOS_PT_INQPOINT"        fun nil                 (system) "Result = %s( filename, pointlist)" (("LENGTH")) sdf)
    ("EOS_PT_LEVELINDX"       fun nil                 (system) "Result = %s( pointID, levelname)" nil sdf)
    ("EOS_PT_LEVELINFO"       fun nil                 (system) "Result = %s(pointID, level, fieldlist, fldtype, fldorder)" nil sdf)
    ("EOS_PT_NFIELDS"         fun nil                 (system) "Result = %s( pointID, level)" (("LENGTH")) sdf)
    ("EOS_PT_NLEVELS"         fun nil                 (system) "Result = %s(pointID)" nil sdf)
    ("EOS_PT_NRECS"           fun nil                 (system) "Result = %s( pointID, level)" nil sdf)
    ("EOS_PT_OPEN"            fun nil                 (system) "Result = %s( fieldname)" (("CREATE") ("RDWR") ("READ")) sdf)
    ("EOS_PT_PERIODINFO"      fun nil                 (system) "Result = %s(pointID, periodID, level, fieldlist, size)" nil sdf)
    ("EOS_PT_PERIODRECS"      fun nil                 (system) "Result = %s(pointID, periodID, level, nrec, recs)" nil sdf)
    ("EOS_PT_QUERY"           fun nil                 (system) "Result = %s( Filename, PointName, [Info] )" nil sdf)
    ("EOS_PT_READATTR"        fun nil                 (system) "Result = %s(pointID, attrname, datbuf)" nil sdf)
    ("EOS_PT_READLEVEL"       fun nil                 (system) "Result = %s(pointID, level, fieldlist, nrec, recs, buffer)" nil sdf)
    ("EOS_PT_REGIONINFO"      fun nil                 (system) "Result = %s(pointID, regionID, level, fieldlist, size)" nil sdf)
    ("EOS_PT_REGIONRECS"      fun nil                 (system) "Result = %s(pointID, regionID, level, nrec, recs)" nil sdf)
    ("EOS_PT_SIZEOF"          fun nil                 (system) "Result = %s(pointID, fieldlist, fldlevel)" nil sdf)
    ("EOS_PT_UPDATELEVEL"     fun nil                 (system) "Result = %s(pointID, level, field, list, nrec, recs, data)" nil sdf)
    ("EOS_PT_WRITEATTR"       fun nil                 (system) "Result = %s( pointID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")) sdf)
    ("EOS_PT_WRITELEVEL"      fun nil                 (system) "Result = %s(pointID, level, nrec, data)" nil sdf)
    ("EOS_QUERY"              fun nil                 (system) "Result = %s( Filename, [Info] )" nil sdf)
    ("EOS_SW_ATTACH"          fun nil                 (system) "Result = %s(fid, swathname)" nil sdf)
    ("EOS_SW_ATTRINFO"        fun nil                 (system) "Result = %s(swathID, attrname, numbertype, count)" nil sdf)
    ("EOS_SW_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil sdf)
    ("EOS_SW_COMPINFO"        fun nil                 (system) "Result = %s(swathID, fieldname, compcode, compparm)" nil sdf)
    ("EOS_SW_CREATE"          fun nil                 (system) "Result = %s(fid, swathname)" nil sdf)
    ("EOS_SW_DEFBOXREGION"    fun nil                 (system) "Result = %s(swathID, cornerlon, cornerlat, mode)" nil sdf)
    ("EOS_SW_DEFCOMP"         fun nil                 (system) "Result = %s( swathID, compcode, [, compparm] )" nil sdf)
    ("EOS_SW_DEFDATAFIELD"    fun nil                 (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" (("MERGE")) sdf)
    ("EOS_SW_DEFDIM"          fun nil                 (system) "Result = %s(swathID, fieldname, dim)" nil sdf)
    ("EOS_SW_DEFDIMMAP"       fun nil                 (system) "Result = %s(swathID, geodim, datadim, offset, increment)" nil sdf)
    ("EOS_SW_DEFGEOFIELD"     fun nil                 (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" (("MERGE")) sdf)
    ("EOS_SW_DEFIDXMAP"       fun nil                 (system) "Result = %s(swathID, geodim, datadim, index)" nil sdf)
    ("EOS_SW_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(swathID, starttime , stoptime, mode)" nil sdf)
    ("EOS_SW_DEFVRTREGION"    fun nil                 (system) "Result = %s(swathID, regionID, vertObj, range)" nil sdf)
    ("EOS_SW_DETACH"          fun nil                 (system) "Result = %s(swathID)" nil sdf)
    ("EOS_SW_DIMINFO"         fun nil                 (system) "Result = %s(swathID, dimname)" nil sdf)
    ("EOS_SW_DUPREGION"       fun nil                 (system) "Result = %s(regionID)" nil sdf)
    ("EOS_SW_EXTRACTPERIOD"   fun nil                 (system) "Result = %s(swathID, periodID, fieldname, external_mode, buffer)" nil sdf)
    ("EOS_SW_EXTRACTREGION"   fun nil                 (system) "Result = %s(swathID, regionID, fieldname, external_mode, buffer)" nil sdf)
    ("EOS_SW_FIELDINFO"       fun nil                 (system) "Result = %s(swathID, fieldname, rank, dims, numbertype, dimlist)" nil sdf)
    ("EOS_SW_GETFILLVALUE"    fun nil                 (system) "Result = %s(swathID, fieldname, fillvalue)" nil sdf)
    ("EOS_SW_IDXMAPINFO"      fun nil                 (system) "Result = %s(swathID, geodim, datadim, index)" nil sdf)
    ("EOS_SW_INQATTRS"        fun nil                 (system) "Result = %s( swathID, attrlist)" (("LENGTH")) sdf)
    ("EOS_SW_INQDATAFIELDS"   fun nil                 (system) "Result = %s(swathID, fieldlist, rank, numbertype)" nil sdf)
    ("EOS_SW_INQDIMS"         fun nil                 (system) "Result = %s(swathID, dimname, dim)" nil sdf)
    ("EOS_SW_INQGEOFIELDS"    fun nil                 (system) "Result = %s(swathID, fieldlist, rank, numbertype)" nil sdf)
    ("EOS_SW_INQIDXMAPS"      fun nil                 (system) "Result = %s(swathID, idxmap, idxsizes)" nil sdf)
    ("EOS_SW_INQMAPS"         fun nil                 (system) "Result = %s(swathID, dimmap, offset, increment)" nil sdf)
    ("EOS_SW_INQSWATH"        fun nil                 (system) "Result = %s( filename, swathlist)" (("LENGTH")) sdf)
    ("EOS_SW_MAPINFO"         fun nil                 (system) "Result = %s(swathID, geodim, datadim, offset, increment)" nil sdf)
    ("EOS_SW_NENTRIES"        fun nil                 (system) "Result = %s( swathID, entrycode)" (("LENGTH")) sdf)
    ("EOS_SW_OPEN"            fun nil                 (system) "Result = %s( filename)" (("CREATE") ("RDWR") ("READ")) sdf)
    ("EOS_SW_PERIODINFO"      fun nil                 (system) "Result = %s(swathID, periodID, fieldname, ntype, rank, dims, size)" nil sdf)
    ("EOS_SW_QUERY"           fun nil                 (system) "Result=%s(Filename, SwathName, [Info])" nil sdf)
    ("EOS_SW_READATTR"        fun nil                 (system) "Result = %s(swathID, attrname, datbuf)" nil sdf)
    ("EOS_SW_READFIELD"       fun nil                 (system) "Result = %s( swathID, fieldname, buffer)" (("EDGE") ("START") ("STRIDE")) sdf)
    ("EOS_SW_REGIONINFO"      fun nil                 (system) "Result = %s(swathID, regionID, fieldname, ntype, rank, dims, size)" nil sdf)
    ("EOS_SW_SETFILLVALUE"    fun nil                 (system) "Result = %s(swathID, fieldname, fillvalue)" nil sdf)
    ("EOS_SW_WRITEATTR"       fun nil                 (system) "Result = %s( swathID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")) sdf)
    ("EOS_SW_WRITEDATAMETA"   fun nil                 (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" nil sdf)
    ("EOS_SW_WRITEFIELD"      fun nil                 (system) "Result = %s( swathID, fieldname, cut, data)" (("EDGE") ("START") ("STRIDE")) sdf)
    ("EOS_SW_WRITEGEOMETA"    fun nil                 (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" nil sdf)
    ("ERODE"                  fun nil                 (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("ERRORF"                 fun nil                 (system) "Result = %s(X)" nil idl)
    ("EXECUTE"                fun nil                 (system) "Result = %s(String [, QuietCompile])" nil idl)
    ("EXP"                    fun nil                 (system) "Result = %s(Expression)" nil idl)
    ("EXPAND_PATH"            fun nil                 (system) "Result = %s( String)" (("ARRAY") ("COUNT")) idl)
    ("EXPINT"                 fun nil                 (system) "Result = %s( N, X)" (("DOUBLE") ("EPS") ("ITMAX")) idl)
    ("EXTRAC"                 fun nil                 (system) "Result = %s( Array, C1, C2, ..., Cn, S1, S2, ..., Sn )" nil idl)
    ("EXTRACT_SLICE"          fun nil                 (system) "Result = %s( Vol, Xsize, Ysize, Xcenter, Ycenter, Zcenter, Xrot, Yrot, Zrot)" (("ANISOTROPY") ("OUT_VAL") ("RADIANS") ("SAMPLE") ("VERTICES")) idl)
    ("F_CVF"                  fun nil                 (system) "Result = %s(P, Dfn, Dfd)" nil idl)
    ("F_PDF"                  fun nil                 (system) "Result = %s(V, Dfn, Dfd)" nil idl)
    ("FACTORIAL"              fun nil                 (system) "Result = %s( N)" (("STIRLING")) idl)
    ("FFT"                    fun nil                 (system) "Result = %s( Array [, Direction])" (("DOUBLE") ("INVERSE") ("OVERWRITE")) idl)
    ("FILEPATH"               fun nil                 (system) "Result = %s( Filename)" (("ROOT_DIR") ("SUBDIRECTORY") ("TERMINAL") ("TMP")) idl)
    ("FINDFILE"               fun nil                 (system) "Result = %s( File_Specification)" (("COUNT")) idl)
    ("FINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("FINITE"                 fun nil                 (system) "Result = %s( X)" (("INFINITY") ("NAN")) idl)
    ("FIX"                    fun nil                 (system) "Result = %s( Expression [, Offset [, Dim1, ..., Dim8]])" (("PRINT") ("TYPE")) idl)
    ("FLOAT"                  fun nil                 (system) "Result = %s( Expression [, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("FLOOR"                  fun nil                 (system) "Result = %s(X)" nil idl)
    ("FLTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("FORMAT_AXIS_VALUES"     fun nil                 (system) "Result = %s( Values )" nil idl)
    ("FSTAT"                  fun nil                 (system) "Result = %s(Unit)" nil idl)
    ("FULSTR"                 fun nil                 (system) "Result = %s(A)" nil idl)
    ("FV_TEST"                fun nil                 (system) "Result = %s(X, Y)" nil idl)
    ("FX_ROOT"                fun nil                 (system) "Result = %s(X, Func)" (("DOUBLE") ("ITMAX") ("STOP") ("TOL")) idl)
    ("FZ_ROOTS"               fun nil                 (system) "Result = %s(C)" (("DOUBLE") ("EPS") ("NO_POLISH")) idl)
    ("GAMMA"                  fun nil                 (system) "Result = %s(X)" nil idl)
    ("GAUSS2DFIT"             fun nil                 (system) "Result = %s( Z, A [, X, Y])" (("NEGATIVE") ("TILT")) idl)
    ("GAUSS_CVF"              fun nil                 (system) "Result = %s(P)" nil idl)
    ("GAUSS_PDF"              fun nil                 (system) "Result = %s(V)" nil idl)
    ("GAUSSFIT"               fun nil                 (system) "Result = %s( X, Y [, A])" (("ESTIMATES") ("NTERMS")) idl)
    ("GAUSSINT"               fun nil                 (system) "Result = %s(X)" nil idl)
    ("GET_DRIVE_LIST"         fun nil                 (system) "Result = %s( )" nil idl)
    ("GET_KBRD"               fun nil                 (system) "Result = %s(Wait)" nil idl)
    ("GET_SCREEN_SIZE"        fun nil                 (system) "Result = %s( [Display_name])" (("DISPLAY_NAME") ("RESOLUTION")) idl)
    ("GET_SYMBOL"             fun nil                 (system) "Result = %s( Name)" (("TYPE")) idl)
    ("GETENV"                 fun nil                 (system) "Result = %s(Name)" nil idl)
    ("GRID3"                  fun nil                 (system) "Result = %s( X, Y, Z, F, Gx, Gy, Gz)" (("DELTA") ("DTOL") ("GRID") ("NGRID") ("START")) idl)
    ("GRID_TPS"               fun nil                 (system) "Interp = %s (Xp, Yp, Values)" (("COEFFICIENTS") ("DELTA") ("NGRID") ("START")) idl)
    ("GS_ITER"                fun nil                 (system) "Result = %s( A, B)" (("CHECK") ("LAMBDA") ("MAX_ITER") ("TOL") ("X_0")) idl)
    ("HANNING"                fun nil                 (system) "Result = %s( N1 [, N2])" (("ALPHA")) idl)
    ("HDF_AN_ANNLEN"          fun nil                 (system) "Result = %s(ann_id)" nil sdf)
    ("HDF_AN_ANNLIST"         fun nil                 (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref, ann_list)" nil sdf)
    ("HDF_AN_ATYPE2TAG"       fun nil                 (system) "Result = %s(annot_type)" nil sdf)
    ("HDF_AN_CREATE"          fun nil                 (system) "Result = %s(an_id, obj_tag, obj_ref, annot_type)" nil sdf)
    ("HDF_AN_CREATEF"         fun nil                 (system) "Result = %s(an_id, annot_type)" nil sdf)
    ("HDF_AN_FILEINFO"        fun nil                 (system) "Result = %s(an_id, n_file_labels, n_file_descs, n_data_labels, n_data_descs)" nil sdf)
    ("HDF_AN_GET_TAGREF"      fun nil                 (system) "Result = %s(an_id, index, annot_type, ann_tag, ann_ref)" nil sdf)
    ("HDF_AN_ID2TAGREF"       fun nil                 (system) "Result = %s(ann_id, ann_tag, ann_ref)" nil sdf)
    ("HDF_AN_NUMANN"          fun nil                 (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref)" nil sdf)
    ("HDF_AN_READANN"         fun nil                 (system) "Result = %s( ann_id, annotation)" (("LENGTH")) sdf)
    ("HDF_AN_SELECT"          fun nil                 (system) "Result = %s(an_id, index, annot_type)" nil sdf)
    ("HDF_AN_START"           fun nil                 (system) "Result = %s(file_id)" nil sdf)
    ("HDF_AN_TAG2ATYPE"       fun nil                 (system) "Result = %s(ann_tag)" nil sdf)
    ("HDF_AN_TAGREF2ID"       fun nil                 (system) "Result = %s(an_id, ann_tag, ann_ref)" nil sdf)
    ("HDF_AN_WRITEANN"        fun nil                 (system) "Result = %s( ann_id, annotation)" (("LENGTH")) sdf)
    ("HDF_BROWSER"            fun nil                 (system) "Template = %s([Filename])" (("CANCEL") ("GROUP") ("PREFIX")) idl)
    ("HDF_DF24_LASTREF"       fun nil                 (system) "Result = %s( )" nil sdf)
    ("HDF_DF24_NIMAGES"       fun nil                 (system) "Result = %s(Filename)" nil sdf)
    ("HDF_DFAN_LABLIST"       fun nil                 (system) "Result = %s( Filename, Tag, Reflist, Labellist)" (("LISTSIZE") ("MAXLABEL") ("STARTPOS") ("STRING")) sdf)
    ("HDF_DFAN_LASTREF"       fun nil                 (system) "Result = %s( )" nil sdf)
    ("HDF_DFP_LASTREF"        fun nil                 (system) "Result = %s( )" nil sdf)
    ("HDF_DFP_NPALS"          fun nil                 (system) "Result = %s(Filename)" nil sdf)
    ("HDF_DFR8_LASTREF"       fun nil                 (system) "Result = %s( )" nil sdf)
    ("HDF_DFR8_NIMAGES"       fun nil                 (system) "Result = %s(Filename)" nil sdf)
    ("HDF_EXISTS"             fun nil                 (system) "Result = %s( )" nil sdf)
    ("HDF_GR_ATTRINFO"        fun nil                 (system) "Result = %s(obj_id, attr_index, name, data_type, count)" nil sdf)
    ("HDF_GR_CREATE"          fun nil                 (system) "Result = %s(gr_id, name, ncomp, data_type, interlace_mode, dim_sizes)" nil sdf)
    ("HDF_GR_FILEINFO"        fun nil                 (system) "Result = %s(gr_id, n_images, n_file_attrs)" nil sdf)
    ("HDF_GR_FINDATTR"        fun nil                 (system) "Result = %s(obj_id, attr_name)" nil sdf)
    ("HDF_GR_GETATTR"         fun nil                 (system) "Result = %s(obj_id, attr_index, values)" nil sdf)
    ("HDF_GR_GETCHUNKINFO"    fun nil                 (system) "Result = %s(ri_id, dim_length, flag)" nil sdf)
    ("HDF_GR_GETIMINFO"       fun nil                 (system) "Result = %s(ri_id, gr_name, ncomp, data_type, interlace_mode, dim_sizes, num_attrs)" nil sdf)
    ("HDF_GR_GETLUTID"        fun nil                 (system) "Result = %s(ri_id, pal_index)" nil sdf)
    ("HDF_GR_GETLUTINFO"      fun nil                 (system) "Result = %s(pal_id, ncomp, data_type, interlace_mode, num_entries)" nil sdf)
    ("HDF_GR_IDTOREF"         fun nil                 (system) "Result = %s(ri_id)" nil sdf)
    ("HDF_GR_LUTTOREF"        fun nil                 (system) "Result = %s(pal_id)" nil sdf)
    ("HDF_GR_NAMETOINDEX"     fun nil                 (system) "Result = %s(gr_id, gr_name)" nil sdf)
    ("HDF_GR_READIMAGE"       fun nil                 (system) "Result = %s( ri_id, data)" (("EDGE") ("INTERLACE") ("START") ("STRIDE")) sdf)
    ("HDF_GR_READLUT"         fun nil                 (system) "Result = %s( pal_id, pal_data)" (("INTERLACE")) sdf)
    ("HDF_GR_REFTOINDEX"      fun nil                 (system) "Result = %s(gr_id, gr_ref)" nil sdf)
    ("HDF_GR_SELECT"          fun nil                 (system) "Result = %s(gr_id, index)" nil sdf)
    ("HDF_GR_SETATTR"         fun nil                 (system) "Result = %s(obj_id, attr_name, data_type, count, values)" nil sdf)
    ("HDF_GR_SETCHUNK"        fun nil                 (system) "Result = %s(ri_id, dim_length, comp_type, comp_prm)" nil sdf)
    ("HDF_GR_SETCHUNKCACHE"   fun nil                 (system) "Result = %s(ri_id, maxcache, flags)" nil sdf)
    ("HDF_GR_SETCOMPRESS"     fun nil                 (system) "Result = %s(ri_id, comp_type, comp_prm)" nil sdf)
    ("HDF_GR_SETEXTERNALFILE" fun nil                 (system) "Result = %s(ri_id, filename, offset)" nil sdf)
    ("HDF_GR_START"           fun nil                 (system) "Result = %s(file_id)" nil sdf)
    ("HDF_GR_WRITEIMAGE"      fun nil                 (system) "Result = %s( ri_id, data)" (("EDGE") ("INTERLACE") ("START") ("STRIDE")) sdf)
    ("HDF_GR_WRITELUT"        fun nil                 (system) "Result = %s( pal_id, pal_data)" (("DATA_TYPE") ("INTERLACE_MODE") ("NENTRIES")) sdf)
    ("HDF_HDF2IDLTYPE"        fun nil                 (system) "Result = %s( hdftypecode )" nil sdf)
    ("HDF_IDL2HDFTYPE"        fun nil                 (system) "Result = %s( idltypecode )" nil sdf)
    ("HDF_ISHDF"              fun nil                 (system) "Result = %s(Filename)" nil sdf)
    ("HDF_NEWREF"             fun nil                 (system) "Result = %s(FileHandle)" nil sdf)
    ("HDF_NUMBER"             fun nil                 (system) "Result = %s( FileHandle)" (("TAG")) sdf)
    ("HDF_OPEN"               fun nil                 (system) "Result = %s( Filename)" (("ALL") ("CREATE") ("NUM_DD") ("RDWR") ("READ") ("WRITE")) sdf)
    ("HDF_PACKDATA"           fun nil                 (system) "Result = %s( data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]])" (("HDF_ORDER") ("HDF_TYPE") ("NREC")) sdf)
    ("HDF_READ"               fun nil                 (system) "Result = %s( [Filename])" (("DF24") ("DFR8") ("PREFIX") ("TEMPLATE")) idl)
    ("HDF_SD_ATTRFIND"        fun nil                 (system) "Result = %s(S_ID, Name)" nil sdf)
    ("HDF_SD_CREATE"          fun nil                 (system) "Result = %s( SD_ID, Name, Dims)" (("BYTE") ("DFNT_CHAR") ("DFNT_FLOAT32") ("DFNT_FLOAT64") ("DFNT_INT16") ("DFNT_INT32") ("DFNT_INT8") ("DFNT_UINT16") ("DFNT_UINT32") ("DFNT_UINT8") ("DOUBLE") ("FLOAT") ("HDF_TYPE") ("INT") ("LONG") ("SHORT") ("STRING")) sdf)
    ("HDF_SD_DIMGETID"        fun nil                 (system) "Result = %s(SDS_ID, Dimension_Number)" nil sdf)
    ("HDF_SD_IDTOREF"         fun nil                 (system) "Result = %s(SDS_ID)" nil sdf)
    ("HDF_SD_ISCOORDVAR"      fun nil                 (system) "Result = %s(SDS_ID)" nil sdf)
    ("HDF_SD_NAMETOINDEX"     fun nil                 (system) "Result = %s(SD_ID, SDS_Name)" nil sdf)
    ("HDF_SD_REFTOINDEX"      fun nil                 (system) "Result = %s(SD_ID, Refno)" nil sdf)
    ("HDF_SD_SELECT"          fun nil                 (system) "Result = %s(SD_ID, Number)" nil sdf)
    ("HDF_SD_START"           fun nil                 (system) "Result = %s( Filename)" (("CREATE") ("RDWR") ("READ")) sdf)
    ("HDF_VD_ATTACH"          fun nil                 (system) "Result = %s( FileHandle, VDataId)" (("READ") ("WRITE")) sdf)
    ("HDF_VD_FEXIST"          fun nil                 (system) "Result = %s(VData, Fieldnames)" nil sdf)
    ("HDF_VD_FIND"            fun nil                 (system) "Result = %s(FileHandle, Name)" nil sdf)
    ("HDF_VD_GETID"           fun nil                 (system) "Result = %s(FileHandle, VDataId)" nil sdf)
    ("HDF_VD_GETNEXT"         fun nil                 (system) "Result = %s(VData, Id)" nil sdf)
    ("HDF_VD_ISVD"            fun nil                 (system) "Result = %s(VGroup, Id)" nil sdf)
    ("HDF_VD_LONE"            fun nil                 (system) "Result = %s( FileHandle)" (("MAXSIZE")) sdf)
    ("HDF_VD_READ"            fun nil                 (system) "Result = %s( VData, Data)" (("FIELDS") ("FULL_INTERLACE") ("NO_INTERLACE") ("NRECORDS")) sdf)
    ("HDF_VG_ATTACH"          fun nil                 (system) "Result = %s( FileHandle, VGroupId)" (("READ") ("WRITE")) sdf)
    ("HDF_VG_GETID"           fun nil                 (system) "Result = %s(FileHandle, VGroupId)" nil sdf)
    ("HDF_VG_GETNEXT"         fun nil                 (system) "Result = %s(VGroup, Id)" nil sdf)
    ("HDF_VG_INQTR"           fun nil                 (system) "Result = %s(VGroup, Tag, Ref)" nil sdf)
    ("HDF_VG_ISVD"            fun nil                 (system) "Result = %s(VGroup, Id)" nil sdf)
    ("HDF_VG_ISVG"            fun nil                 (system) "Result = %s(VGroup, Id)" nil sdf)
    ("HDF_VG_LONE"            fun nil                 (system) "Result = %s( FileHandle)" (("MAXSIZE")) sdf)
    ("HDF_VG_NUMBER"          fun nil                 (system) "Result = %s(VGroup)" nil sdf)
    ("HILBERT"                fun nil                 (system) "Result = %s(X [, D])" nil idl)
    ("HIST_2D"                fun nil                 (system) "Result = %s( V1, V2)" (("BIN1") ("BIN2") ("MAX1") ("MAX2") ("MIN1") ("MIN2")) idl)
    ("HIST_EQUAL"             fun nil                 (system) "Result = %s( A)" (("BINSIZE") ("MAXV") ("MINV") ("TOP")) idl)
    ("HISTOGRAM"              fun nil                 (system) "Result = %s( Array)" (("BINSIZE") ("INPUT") ("MAX") ("MIN") ("NAN") ("OMAX") ("OMIN") ("REVERSE_INDICES")) idl)
    ("HQR"                    fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE")) idl)
    ("IBETA"                  fun nil                 (system) "Result = %s(A, B, X)" nil idl)
    ("IDENTITY"               fun nil                 (system) "Result = %s( N)" (("DOUBLE")) idl)
    ("IGAMMA"                 fun nil                 (system) "Result = %s( A, X)" (("METHOD")) idl)
    ("IMAGINARY"              fun nil                 (system) "Result = %s(Complex_Expression)" nil idl)
    ("INDGEN"                 fun nil                 (system) "Result = %s(D1, ..., D8)" (("BYTE") ("COMPLEX") ("DCOMPLEX") ("DOUBLE") ("FLOAT") ("L64") ("LONG") ("STRING") ("TYPE") ("UINT") ("UL64") ("ULONG")) idl)
    ("INSGET"                 fun nil                 (system) "Result = %s([Name])" (("COUNT") ("DIMS_LIST") ("EXCLUSIVE") ("GROUP") ("NAME") ("PTR_OUT") ("TITLE")) insight)
    ("INT_2D"                 fun nil                 (system) "Result = %s( Fxy, AB_Limits, PQ_Limits, Pts)" (("DOUBLE") ("ORDER")) idl)
    ("INT_3D"                 fun nil                 (system) "Result = %s( Fxyz, AB_Limits, PQ_Limits, UV_Limits, Pts)" (("DOUBLE")) idl)
    ("INT_TABULATED"          fun nil                 (system) "Result = %s( X, F)" (("SORT")) idl)
    ("INTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("INTERPOL"               fun nil                 (system) "Result = %s( V, N) or Result = INTERPOL( V, X, U)" (("LSQUADRATIC") ("QUADRATIC") ("SPLINE")) idl)
    ("INTERPOLATE"            fun nil                 (system) "Result = %s( P, X [, Y [, Z]])" (("CUBIC") ("GRID") ("MISSING")) idl)
    ("INVERT"                 fun nil                 (system) "Result = %s( Array [, Status])" (("DOUBLE")) idl)
    ("IOCTL"                  fun nil                 (system) "Result = %s( File_Unit [, Request, Arg])" (("BY_VALUE") ("MT_OFFLINE") ("MT_REWIND") ("MT_SKIP_FILE") ("MT_SKIP_RECORD") ("MT_WEOF") ("SUPRESS_ERROR")) idl)
    ("ISHFT"                  fun nil                 (system) "Result = %s(P1, P2)" nil idl)
    ("JULDAY"                 fun nil                 (system) "Result = %s(Month, Day, Year, Hour, Minute, Second)" nil idl)
    ("KEYWORD_SET"            fun nil                 (system) "Result = %s(Expression)" nil idl)
    ("KRIG2D"                 fun nil                 (system) "Result = %s( Z [, X, Y])" (("A") ("BOUNDS") ("C0") ("C1") ("EXPONENTIAL") ("GS") ("NX") ("NY") ("REGULAR") ("SPHERICAL") ("XGRID") ("XVALUES") ("YGRID") ("YVALUES")) idl)
    ("KURTOSIS"               fun nil                 (system) "Result = %s(X)" (("DOUBLE") ("NAN")) idl)
    ("KW_TEST"                fun nil                 (system) "Result = %s( X)" (("DF") ("MISSING")) idl)
    ("L64INDGEN"              fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("LABEL_DATE"             fun nil                 (system) "Result = %s()" (("DATE_FORMAT") ("MONTHS") ("XTICKFORMAT")) idl)
    ("LABEL_REGION"           fun nil                 (system) "Result = %s( Data)" (("ALL_NEIGHBORS") ("ULONG")) idl)
    ("LADFIT"                 fun nil                 (system) "Result = %s( X, Y)" (("ABSDEV") ("DOUBLE")) idl)
    ("LEEFILT"                fun nil                 (system) "Result = %s( A [, N [, Sig]])" (("EXACT")) idl)
    ("LINBCG"                 fun nil                 (system) "Result = %s( A, B, X)" (("DOUBLE") ("ITER") ("ITMAX") ("ITOL") ("TOL")) idl)
    ("LINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("LINFIT"                 fun nil                 (system) "Result = %s( X, Y)" (("CHISQ") ("DOUBLE") ("PROB") ("SDEV") ("SIGMA")) idl)
    ("LIVE_STYLE"             fun nil                 (system) "Style = %s ({ 'contour' | 'image' | 'plot' | 'surface'})" (("BASE_STYLE") ("COLORBAR_PROPERTIES") ("ERROR") ("GRAPHIC_PROPERTIES") ("GROUP") ("LEGEND_PROPERTIES") ("NAME") ("SAVE") ("TEMPLATE_FILE") ("VISUALIZATION_PROPERTIES") ("XAXIS_PROPERTIES") ("YAXIS_PROPERTIES") ("ZAXIS_PROPERTIES")) idl)
    ("LL_ARC_DISTANCE"        fun nil                 (system) "Result = %s( Lon_lat0, Arc_Dist, Az)" (("DEGREES")) idl)
    ("LMFIT"                  fun nil                 (system) "Result = %s( X, Y, A)" (("ALPHA") ("CHISQ") ("CONVERGENCE") ("COVAR") ("DOUBLE") ("FITA") ("FUNCTION_NAME") ("ITER") ("ITMAX") ("ITMIN") ("SIGMA") ("TOL") ("WEIGHTS")) idl)
    ("LMGR"                   fun nil                 (system) "Result = %s()" (("CLIENTSERVER") ("DEMO") ("EMBEDDED") ("EXPIRE_DATE") ("FORCE_DEMO") ("INSTALL_NUM") ("LMHOSTID") ("RUNTIME") ("SITE_NOTICE") ("STUDENT") ("TRIAL")) idl)
    ("LNGAMMA"                fun nil                 (system) "Result = %s(X)" nil idl)
    ("LNP_TEST"               fun nil                 (system) "Result = %s( X, Y)" (("HIFAC") ("JMAX") ("OFAC") ("WK1") ("WK2")) idl)
    ("LOCALE_GET"             fun nil                 (system) "Result = %s( )" nil idl)
    ("LON64ARR"               fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("LONARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("LONG"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("LONG64"                 fun nil                 (system) "Result = %s( Expression[, Offset [, D1, ..., D8]] )" nil idl)
    ("LSODE"                  fun nil                 (system) "Result = %s( Y, X, H, Derivs[, Status])" (("ATOL") ("RTOL")) idl)
    ("LU_COMPLEX"             fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("INVERSE") ("SPARSE")) idl)
    ("LUMPROVE"               fun nil                 (system) "Result = %s( A, Alud, Index, B, X)" (("COLUMN") ("DOUBLE")) idl)
    ("LUSOL"                  fun nil                 (system) "Result = %s(A, Index, B)" (("COLUMN") ("DOUBLE")) idl)
    ("M_CORRELATE"            fun nil                 (system) "Result = %s(X, Y)" nil idl)
    ("MACHAR"                 fun nil                 (system) "Result = %s()" (("DOUBLE")) idl)
    ("MAKE_ARRAY"             fun nil                 (system) "Result = %s ( [D1, ..., D8])" (("BYTE") ("COMPLEX") ("DCOMPLEX") ("DIMENSION") ("DOUBLE") ("FLOAT") ("INDEX") ("INT") ("L64") ("LONG") ("NOZERO") ("OBJ") ("PTR") ("SIZE") ("STRING") ("TYPE") ("UINT") ("UL64") ("ULONG") ("VALUE")) idl)
    ("MAP_IMAGE"              fun nil                 (system) "Result = %s( Image [, Startx, Starty [, Xsize, Ysize]])" (("BILINEAR") ("COMPRESS") ("LATMAX") ("LATMIN") ("LONMAX") ("LONMIN") ("MAX_VALUE") ("MIN_VALUE") ("MISSING") ("SCALE")) idl)
    ("MAP_PATCH"              fun nil                 (system) "Result = %s( Image_Orig [, Lons, Lats])" (("LAT0") ("LAT1") ("LON0") ("LON1") ("MAX_VALUE") ("MISSING") ("TRIANGULATE") ("XSIZE") ("XSTART") ("YSIZE") ("YSTART")) idl)
    ("MAX"                    fun nil                 (system) "Result = %s( Array [, Max_Subscript])" (("MIN") ("NAN")) idl)
    ("MD_TEST"                fun nil                 (system) "Result = %s( X)" (("ABOVE") ("BELOW") ("MDC")) idl)
    ("MEAN"                   fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")) idl)
    ("MEANABSDEV"             fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("MEDIAN") ("NAN")) idl)
    ("MEDIAN"                 fun nil                 (system) "Result = %s( Array [, Width])" (("EVEN")) idl)
    ("MESH_CLIP"              fun nil                 (system) "Result = %s (Plane, Vertsin, Connin, Vertsout, Connout)" (("AUXDATA_IN") ("AUXDATA_OUT") ("CUT_VERTS")) idl)
    ("MESH_DECIMATE"          fun nil                 (system) "Result = %s (Verts, Conn, Connout)" (("PERCENT_POLYGONS") ("PERCENT_VERTICES") ("VERTICES")) idl)
    ("MESH_ISSOLID"           fun nil                 (system) "Result = %s (Conn)" nil idl)
    ("MESH_MERGE"             fun nil                 (system) "Result = %s (Verts, Conn, Verts1, Conn1)" (("COMBINE_VERTICES") ("TOLERANCE")) idl)
    ("MESH_NUMTRIANGLES"      fun nil                 (system) "Result = %s (Conn)" nil idl)
    ("MESH_SMOOTH"            fun nil                 (system) "Result = %s (Verts, Conn)" (("FIXED_EDGE_VERTICES") ("FIXED_VERTICES") ("ITERATIONS") ("LAMBDA")) idl)
    ("MESH_SURFACEAREA"       fun nil                 (system) "Result = %s ( Verts, Conn)" (("AUXDATA") ("MOMENT")) idl)
    ("MESH_VALIDATE"          fun nil                 (system) "Result = %s ( Verts, Conn)" (("COMBINE_VERTICES") ("PACK_VERTICES") ("REMOVE_NAN") ("TOLERANCE")) idl)
    ("MESH_VOLUME"            fun nil                 (system) "Result = %s ( Verts, Conn)" (("SIGNED")) idl)
    ("MIN"                    fun nil                 (system) "Result = %s( Array [, Min_Subscript])" (("MAX") ("NAN")) idl)
    ("MIN_CURVE_SURF"         fun nil                 (system) "Result = %s(Z [, X, Y])" (("BOUNDS") ("DOUBLE") ("GS") ("NX") ("NY") ("REGULAR") ("TPS") ("XGRID") ("XOUT") ("XPOUT") ("XVALUES") ("YGRID") ("YOUT") ("YPOUT") ("YVALUES")) idl)
    ("MOMENT"                 fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("MDEV") ("NAN") ("SDEV")) idl)
    ("MORPH_CLOSE"            fun nil                 (system) "Result = %s (Image, Structure)" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("MORPH_DISTANCE"         fun nil                 (system) "Result = %s (Data)" (("BACKGROUND") ("NEIGHBOR_SAMPLING") ("NO_COPY")) idl)
    ("MORPH_GRADIENT"         fun nil                 (system) "Result = %s (Image, Structure)" (("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("MORPH_HITORMISS"        fun nil                 (system) "Result = %s (Image, HitStructure, MissStructure)" nil idl)
    ("MORPH_OPEN"             fun nil                 (system) "Result = %s (Image, Structure)" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("MORPH_THIN"             fun nil                 (system) "Result = %s ( Image, HitStructure, MissStructure )" nil idl)
    ("MORPH_TOPHAT"           fun nil                 (system) "Result = %s ( Image, Structure)" (("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")) idl)
    ("MPEG_OPEN"              fun nil                 (system) "mpegID = %s( Dimensions)" (("FILENAME")) idl)
    ("MSG_CAT_OPEN"           fun nil                 (system) "Result = %s( application)" (("DEFAULT_FILENAME") ("FILENAME") ("FOUND") ("LOCALE") ("PATH") ("SUB_QUERY")) idl)
    ("N_ELEMENTS"             fun nil                 (system) "Result = %s(Expression)" nil idl)
    ("N_PARAMS"               fun nil                 (system) "Result = %s()" nil idl)
    ("N_TAGS"                 fun nil                 (system) "Result = %s( Expression)" (("LENGTH")) idl)
    ("NCDF_ATTCOPY"           fun nil                 (system) "Result = %s( Incdf [, Invar])" (("IN_GLOBAL") ("OUT_GLOBAL")) sdf)
    ("NCDF_ATTINQ"            fun nil                 (system) "Result = %s( Cdfid [, Varid])" (("GLOBAL")) sdf)
    ("NCDF_ATTNAME"           fun nil                 (system) "Result = %s( Cdfid [, Varid])" (("GLOBAL")) sdf)
    ("NCDF_CREATE"            fun nil                 (system) "Result = %s( Filename)" (("CLOBBER") ("NOCLOBBER")) sdf)
    ("NCDF_DIMDEF"            fun nil                 (system) "Result = %s( Cdfid, DimName, Size)" (("UNLIMITED")) sdf)
    ("NCDF_DIMID"             fun nil                 (system) "Result = %s( Cdfid, DimName )" nil sdf)
    ("NCDF_EXISTS"            fun nil                 (system) "Result = %s( )" nil sdf)
    ("NCDF_INQUIRE"           fun nil                 (system) "Result = %s(Cdfid)" nil sdf)
    ("NCDF_OPEN"              fun nil                 (system) "Result = %s( Filename)" (("NOWRITE") ("WRITE")) sdf)
    ("NCDF_VARDEF"            fun nil                 (system) "Result = %s( Cdfid, Name [, Dim])" (("BYTE") ("CHAR") ("DOUBLE") ("FLOAT") ("LONG") ("SHORT")) sdf)
    ("NCDF_VARID"             fun nil                 (system) "Result = %s(Cdfid, Name)" nil sdf)
    ("NCDF_VARINQ"            fun nil                 (system) "Result = %s(Cdfid, Varid)" nil sdf)
    ("NEWTON"                 fun nil                 (system) "Result = %s( X, Vecfunc)" (("CHECK") ("DOUBLE") ("ITMAX") ("STEPMAX") ("TOLF") ("TOLMIN") ("TOLX")) idl)
    ("NORM"                   fun nil                 (system) "Result = %s( A)" (("DOUBLE")) idl)
    ("OBJ_CLASS"              fun nil                 (system) "Result = %s( [Arg])" (("COUNT") ("SUPERCLASS")) idl)
    ("OBJ_ISA"                fun nil                 (system) "Result = %s(ObjectInstance, ClassName)" nil idl)
    ("OBJ_NEW"                fun nil                 (system) "Result = %s( [ObjectClassName [, Arg1......Argn]] )" nil idl)
    ("OBJ_VALID"              fun nil                 (system) "Result = %s( [Arg])" (("CAST") ("COUNT")) idl)
    ("OBJARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("P_CORRELATE"            fun nil                 (system) "Result = %s(X, Y, C)" nil idl)
    ("PCOMP"                  fun nil                 (system) "Result = %s( A)" (("COEFFICIENTS") ("COVARIANCE") ("DOUBLE") ("EIGENVALUES") ("NVARIABLES") ("STANDARDIZE") ("VARIANCES")) idl)
    ("PNT_LINE"               fun nil                 (system) "Result = %s( P0, L0, L1 [, Pl])" (("INTERVAL")) idl)
    ("POLAR_SURFACE"          fun nil                 (system) "Result = %s( Z, R, Theta)" (("BOUNDS") ("GRID") ("MISSING") ("QUINTIC") ("SPACING")) idl)
    ("POLY"                   fun nil                 (system) "Result = %s(X, C)" nil idl)
    ("POLY_2D"                fun nil                 (system) "Result = %s( Array, P, Q [, Interp [, Dimx, Dimy]])" (("CUBIC") ("MISSING")) idl)
    ("POLY_AREA"              fun nil                 (system) "Result = %s(X, Y)" (("SIGNED")) idl)
    ("POLY_FIT"               fun nil                 (system) "Result = %s( X, Y, NDegree [, Yfit, Yband, Sigma, Corrm])" (("DOUBLE")) idl)
    ("POLYFILLV"              fun nil                 (system) "Result = %s( X, Y, Sx, Sy [, Run_Length] )" nil idl)
    ("POLYFITW"               fun nil                 (system) "Result = %s(X, Y, Weights, NDegree [, Yfit, Yband, Sigma, Corrm] )" nil idl)
    ("POLYSHADE"              fun nil                 (system) "Result = %s( Vertices, Polygons) or Result = POLYSHADE(X, Y, Z, Polygons) [, DATA]" (("NORMAL") ("POLY_SHADES") ("SHADES") ("T3D") ("TOP") ("XSIZE") ("YSIZE")) idl)
    ("PRIMES"                 fun nil                 (system) "Result = %s(K)" nil idl)
    ("PROFILE"                fun nil                 (system) "Result = %s( Image [, XX, YY])" (("NOMARK") ("XSTART") ("YSTART")) idl)
    ("PROJECT_VOL"            fun nil                 (system) "Return = %s( Vol, X_Sample, Y_Sample, Z_Sample)" (("DEPTH_Q") ("OPAQUE") ("TRANS")) idl)
    ("PTR_NEW"                fun nil                 (system) "Result = %s( [InitExpr])" (("ALLOCATE_HEAP") ("NO_COPY")) idl)
    ("PTR_VALID"              fun nil                 (system) "Result = %s( [Arg])" (("CAST") ("COUNT")) idl)
    ("PTRARR"                 fun nil                 (system) "Result = %s( D1, ... ..., D8)" (("ALLOCATE_HEAP") ("NOZERO")) idl)
    ("QROMB"                  fun nil                 (system) "Result = %s( Func, A, B)" (("DOUBLE") ("EPS") ("JMAX") ("K")) idl)
    ("QROMO"                  fun nil                 (system) "Result = %s(Func, A [, B])" (("DOUBLE") ("EPS") ("JMAX") ("K") ("MIDEXP") ("MIDINF") ("MIDPNT") ("MIDSQL") ("MIDSQU")) idl)
    ("QSIMP"                  fun nil                 (system) "Result = %s( Func, A, B)" (("DOUBLE") ("EPS") ("JMAX")) idl)
    ("QUERY_BMP"              fun nil                 (system) "Result = %s ( Filename [, Info] )" nil idl)
    ("QUERY_DICOM"            fun nil                 (system) "Result = %s( Filename [, Info])" (("IMAGE_INDEX")) idl)
    ("QUERY_GIF"              fun nil                 (system) "Result = %s ( Filename [, Info] )" nil idl)
    ("QUERY_IMAGE"            fun nil                 (system) "Result = %s ( Filename[, Info])" (("CHANNELS") ("DIMENSIONS") ("HAS_PALETTE") ("IMAGE_INDEX") ("NUM_IMAGES") ("PIXEL_TYPE") ("SUPPORTED_READ") ("SUPPORTED_WRITE") ("TYPE")) idl)
    ("QUERY_JPEG"             fun nil                 (system) "Result = %s ( Filename [, Info] )" nil idl)
    ("QUERY_PICT"             fun nil                 (system) "Result = %s ( Filename [, Info] )" nil idl)
    ("QUERY_PNG"              fun nil                 (system) "Result = %s ( Filename [, Info] )" nil idl)
    ("QUERY_PPM"              fun nil                 (system) "Result = %s ( Filename [, Info])" (("MAXVAL")) idl)
    ("QUERY_SRF"              fun nil                 (system) "Result = %s (Filename [, Info] )" nil idl)
    ("QUERY_TIFF"             fun nil                 (system) "Result = %s ( Filename [, Info])" (("IMAGE_INDEX")) idl)
    ("QUERY_WAV"              fun nil                 (system) "Result = %s ( Filename[, Info] )" nil idl)
    ("R_CORRELATE"            fun nil                 (system) "Result = %s( X, Y)" (("D") ("KENDALL") ("PROBD") ("ZD")) idl)
    ("R_TEST"                 fun nil                 (system) "Result = %s( X)" (("N0") ("N1") ("R")) idl)
    ("RANDOMN"                fun nil                 (system) "Result = %s( Seed [, D1, ..., D8])" (("BINOMIAL") ("GAMMA") ("NORMAL") ("POISSON") ("UNIFORM")) idl)
    ("RANDOMU"                fun nil                 (system) "Result = %s( Seed [, D1, ..., D8])" (("BINOMIAL") ("GAMMA") ("NORMAL") ("POISSON") ("UNIFORM")) idl)
    ("RANKS"                  fun nil                 (system) "Result = %s(X)" nil idl)
    ("READ_ASCII"             fun nil                 (system) "Result = %s( [Filename])" (("COMMENT_SYMBOL") ("COUNT") ("DATA_START") ("DELIMITER") ("HEADER") ("MISSING_VALUE") ("NUM_RECORDS") ("RECORD_START") ("TEMPLATE") ("VERBOSE")) idl)
    ("READ_BINARY"            fun nil                 (system) "Result = %s ([Filename] | FileUnit)" (("DATA_DIMS") ("DATA_START") ("DATA_TYPE") ("ENDIAN") ("TEMPLATE")) idl)
    ("READ_BMP"               fun nil                 (system) "Result = %s( Filename, [, R, G, B [, Ihdr]])" (("RGB")) idl)
    ("READ_DICOM"             fun nil                 (system) "Result = %s (Filename [, Red, Green, Blue])" (("IMAGE_INDEX")) idl)
    ("READ_IMAGE"             fun nil                 (system) "Result = %s (Filename [, Red, Green, Blue])" (("ALLOWED_FORMATS") ("FORMAT") ("IMAGE_INDEX")) idl)
    ("READ_PNG"               fun nil                 (system) "Result = %s ( Filename[, R, G, B])" (("TRANSPARENT") ("VERBOSE")) idl)
    ("READ_SPR"               fun nil                 (system) "Result = %s(Filename)" nil idl)
    ("READ_SYLK"              fun nil                 (system) "Result = %s( File)" (("ARRAY") ("COLMAJOR") ("NCOLS") ("NROWS") ("STARTCOL") ("STARTROW") ("USEDOUBLES") ("USELONGS")) idl)
    ("READ_TIFF"              fun nil                 (system) "Result = %s( Filename [, R, G, B])" (("GEOTIFF") ("IMAGE_INDEX") ("ORDER") ("PLANARCONFIG") ("SUB_RECT") ("UNSIGNED") ("VERBOSE")) idl)
    ("READ_WAV"               fun nil                 (system) "Result = %s ( Filename [, Rate] )" nil idl)
    ("READ_XWD"               fun nil                 (system) "Result = %s( Filename[, R, G, B] )" nil idl)
    ("REBIN"                  fun nil                 (system) "Result = %s( Array, D1 [, ..., D8])" (("SAMPLE")) idl)
    ("RECALL_COMMANDS"        fun nil                 (system) "Result = %s()" nil idl)
    ("RECON3"                 fun nil                 (system) "Result = %s( Images, Obj_Rot, Obj_Pos, Focal, Dist,Vol_Pos, Img_Ref, Img_Mag, Vol_Size)" (("MISSING") ("MODE")) idl)
    ("REFORM"                 fun nil                 (system) "Result = %s( Array, D1, ..., D8)" (("OVERWRITE")) idl)
    ("REGRESS"                fun nil                 (system) "Result = %s( X, Y, Weights [, Yfit, Const, Sigma, Ftest, R, Rmul, Chisq, Status])" (("RELATIVE_WEIGHT")) idl)
    ("REPLICATE"              fun nil                 (system) "Result = %s( Value, D1 [, ..., D8] )" nil idl)
    ("REVERSE"                fun nil                 (system) "Result = %s( Array [, Subscript_Index] )" nil idl)
    ("RK4"                    fun nil                 (system) "Result = %s( Y, Dydx, X, H, Derivs)" (("DOUBLE")) idl)
    ("ROBERTS"                fun nil                 (system) "Result = %s(Image)" nil idl)
    ("ROT"                    fun nil                 (system) "Result = %s( A, Angle, [Mag, X0, Y0])" (("CUBIC") ("INTERP") ("MISSING") ("PIVOT")) idl)
    ("ROTATE"                 fun nil                 (system) "Result = %s(Array, Direction)" nil idl)
    ("ROUND"                  fun nil                 (system) "Result = %s(X)" nil idl)
    ("ROUTINE_INFO"           fun nil                 (system) "Result = %s( [Routine])" (("DISABLED") ("ENABLED") ("FUNCTIONS") ("PARAMETERS") ("SOURCE") ("SYSTEM") ("UNRESOLVED") ("VARIABLES")) idl)
    ("RS_TEST"                fun nil                 (system) "Result = %s( X, Y)" (("UX") ("UY")) idl)
    ("S_TEST"                 fun nil                 (system) "Result = %s( X, Y)" (("ZDIFF")) idl)
    ("SEARCH2D"               fun nil                 (system) "Result = %s( Array, Xpos, Ypos, Min_Val, Max_Val)" (("DECREASE") ("DIAGONAL") ("INCREASE") ("LPF_BAND")) idl)
    ("SEARCH3D"               fun nil                 (system) "Result = %s( Array, Xpos, Ypos, Zpos, Min_Val, Max_Val)" (("DECREASE") ("DIAGONAL") ("INCREASE") ("LPF_BAND")) idl)
    ("SFIT"                   fun nil                 (system) "Result = %s( Data, Degree)" (("KX")) idl)
    ("SHIFT"                  fun nil                 (system) "Result = %s(Array, S1, ..., Sn)" nil idl)
    ("SIN"                    fun nil                 (system) "Result = %s(X)" nil idl)
    ("SINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("SINH"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("SIZE"                   fun nil                 (system) "Result = %s( Expression)" (("DIMENSIONS") ("FILE_LUN") ("N_DIMENSIONS") ("N_ELEMENTS") ("STRUCTURE") ("TNAME") ("TYPE")) idl)
    ("SKEWNESS"               fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")) idl)
    ("SMOOTH"                 fun nil                 (system) "Result = %s( Array, Width)" (("EDGE_TRUNCATE") ("NAN")) idl)
    ("SOBEL"                  fun nil                 (system) "Result = %s(Image)" nil idl)
    ("SORT"                   fun nil                 (system) "Result = %s(Array)" nil idl)
    ("SPH_SCAT"               fun nil                 (system) "Result = %s( Lon, Lat, F)" (("BOUNDS") ("BOUT") ("GOUT") ("GS") ("NLAT") ("NLON")) idl)
    ("SPL_INIT"               fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE") ("YP0") ("YPN_1")) idl)
    ("SPL_INTERP"             fun nil                 (system) "Result = %s( X, Y, Y2, X2)" (("DOUBLE")) idl)
    ("SPLINE"                 fun nil                 (system) "Result = %s( X, Y, T [, Sigma] )" nil idl)
    ("SPRSAB"                 fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("THRESH")) idl)
    ("SPRSAX"                 fun nil                 (system) "Result = %s( A, X)" (("DOUBLE")) idl)
    ("SPRSIN"                 fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE") ("THRESH")) idl)
    ("SQRT"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("STANDARDIZE"            fun nil                 (system) "Result = %s( A)" (("DOUBLE")) idl)
    ("STDDEV"                 fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")) idl)
    ("STRARR"                 fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("STRCMP"                 fun nil                 (system) "Result = %s( String1, String2 [, N])" (("FOLD_CASE")) idl)
    ("STRCOMPRESS"            fun nil                 (system) "Result = %s( String)" (("REMOVE_ALL")) idl)
    ("STREGEX"                fun nil                 (system) "Result = %s( StringExpression, RegularExpression)" (("BOOLEAN") ("EXTRACT") ("FOLD_CASE") ("LENGTH") ("SUBEXPR")) idl)
    ("STRING"                 fun nil                 (system) "Result = %s( Expression1, ..., Expressionn)" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("PRINT")) idl)
    ("STRJOIN"                fun nil                 (system) "Result = %s( String [, Delimiter])" (("SINGLE")) idl)
    ("STRLEN"                 fun nil                 (system) "Result = %s(Expression)" nil idl)
    ("STRLOWCASE"             fun nil                 (system) "Result = %s(String)" nil idl)
    ("STRMATCH"               fun nil                 (system) "Result = %s( String, SearchString)" (("FOLD_CASE")) idl)
    ("STRMESSAGE"             fun nil                 (system) "Result = %s( Err)" (("BLOCK") ("CODE") ("NAME")) idl)
    ("STRMID"                 fun nil                 (system) "Result = %s(Expression, First_Character [, Length])" (("REVERSE_OFFSET")) idl)
    ("STRPOS"                 fun nil                 (system) "Result = %s( Expression, Search String [, Pos])" (("REVERSE_OFFSET") ("REVERSE_SEARCH")) idl)
    ("STRSPLIT"               fun nil                 (system) "Result = %s( String [, Pattern])" (("ESCAPE") ("EXTRACT") ("FOLD_CASE") ("LENGTH") ("PRESERVE_NULL") ("REGEX")) idl)
    ("STRTRIM"                fun nil                 (system) "Result = %s( String [, Flag] )" nil idl)
    ("STRUPCASE"              fun nil                 (system) "Result = %s(String)" nil idl)
    ("SVDFIT"                 fun nil                 (system) "Result = %s( X, Y [, M])" (("A") ("CHISQ") ("COVAR") ("DOUBLE") ("FUNCTION_NAME") ("LEGENDRE") ("SIGMA") ("SINGULAR") ("VARIANCE") ("WEIGHTS") ("YFIT")) idl)
    ("SVSOL"                  fun nil                 (system) "Result = %s( U, W, V, B)" (("COLUMN") ("DOUBLE")) idl)
    ("SWAP_ENDIAN"            fun nil                 (system) "Result = %s(Variable)" nil idl)
    ("SYSTIME"                fun nil                 (system) "Result = %s(Arg)" (("JULIAN") ("SECONDS")) idl)
    ("T_CVF"                  fun nil                 (system) "Result = %s(P, Df)" nil idl)
    ("T_PDF"                  fun nil                 (system) "Result = %s(V, Df)" nil idl)
    ("TAG_NAMES"              fun nil                 (system) "Result = %s( Expression)" (("STRUCTURE_NAME")) idl)
    ("TAN"                    fun nil                 (system) "Result = %s(X)" nil idl)
    ("TANH"                   fun nil                 (system) "Result = %s(X)" nil idl)
    ("TEMPORARY"              fun nil                 (system) "Result = %s(Variable)" nil idl)
    ("TETRA_CLIP"             fun nil                 (system) "Result = %s ( Plane, Vertsin, Connin, Vertsout, Connout)" (("AUXDATA_IN") ("AUXDATA_OUT") ("CUT_VERTS")) idl)
    ("TETRA_SURFACE"          fun nil                 (system) "Result = %s (Verts, Connin)" nil idl)
    ("TETRA_VOLUME"           fun nil                 (system) "Result = %s ( Verts, Conn)" (("AUXDATA") ("MOMENT")) idl)
    ("THIN"                   fun nil                 (system) "Result = %s( Image)" (("NEIGHBOR_COUNT") ("PRUNE")) idl)
    ("TM_TEST"                fun nil                 (system) "Result = %s( X, Y)" (("PAIRED") ("UNEQUAL")) idl)
    ("TOTAL"                  fun nil                 (system) "Result = %s( Array [, Dimension])" (("CUMULATIVE") ("DOUBLE") ("NAN")) idl)
    ("TRACE"                  fun nil                 (system) "Result = %s( A)" (("DOUBLE")) idl)
    ("TRANSPOSE"              fun nil                 (system) "Result = %s( Array [, P] )" nil idl)
    ("TRI_SURF"               fun nil                 (system) "Result = %s( Z [, X, Y])" (("BOUNDS") ("EXTRAPOLATE") ("GS") ("MISSING") ("NX") ("NY") ("REGULAR") ("XGRID") ("XVALUES") ("YGRID") ("YVALUES")) idl)
    ("TRIGRID"                fun nil                 (system) "Result = %s( X, Y, Z, Triangles [, GS, Limits] ) For spherical gridding: Result = TRIGRID( F , GS, Limits)" (("DEGREES") ("EXTRAPOLATE") ("INPUT") ("MAX_VALUE") ("MIN_VALUE") ("MISSING") ("NX") ("NY") ("QUINTIC") ("SPHERE") ("XGRID") ("YGRID")) idl)
    ("TRISOL"                 fun nil                 (system) "Result = %s( A, B, C, R)" (("DOUBLE")) idl)
    ("TRNLOG"                 fun nil                 (system) "Result = %s( Lognam, Value)" (("ACMODE") ("FULL_TRANSLATION") ("ISSUE_ERROR") ("RESULT_ACMODE") ("RESULT_TABLE") ("TABLE")) idl)
    ("TS_COEF"                fun nil                 (system) "Result = %s( X, P)" (("MSE")) idl)
    ("TS_DIFF"                fun nil                 (system) "Result = %s( X, K)" (("DOUBLE")) idl)
    ("TS_FCAST"               fun nil                 (system) "Result = %s( X, P, Nvalues)" (("BACKCAST") ("DOUBLE")) idl)
    ("TS_SMOOTH"              fun nil                 (system) "Result = %s( X, Nvalues)" (("BACKWARD") ("DOUBLE") ("FORWARD") ("ORDER")) idl)
    ("TVRD"                   fun nil                 (system) "Result = %s( [X0 [, Y0 [, Nx [, Ny [, Channel]]]]])" (("CHANNEL") ("ORDER") ("TRUE") ("WORDS")) idl)
    ("UINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("UINT"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("UINTARR"                fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("UL64INDGEN"             fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("ULINDGEN"               fun nil                 (system) "Result = %s(D1, ..., D8)" nil idl)
    ("ULON64ARR"              fun nil                 (system) "Result = %s(D1, ..., D8)" (("NOZERO")) idl)
    ("ULONARR"                fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")) idl)
    ("ULONG"                  fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("ULONG64"                fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil idl)
    ("UNIQ"                   fun nil                 (system) "Result = %s( Array [, Index] )" nil idl)
    ("VALUE_LOCATE"           fun nil                 (system) "Result = %s ( Vector, Value )" nil idl)
    ("VARIANCE"               fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")) idl)
    ("VAX_FLOAT"              fun nil                 (system) "Result = %s( [Default])" (("FILE_UNIT")) idl)
    ("VERT_T3D"               fun nil                 (system) "Result = %s( Vertex_List)" (("MATRIX") ("NO_COPY") ("NO_DIVIDE") ("SAVE_DIVIDE")) idl)
    ("VOIGT"                  fun nil                 (system) "Result = %s(A, U)" nil idl)
    ("VOXEL_PROJ"             fun nil                 (system) "Result = %s( V [, RGBO])" (("BACKGROUND") ("CUTTING_PLANE") ("INTERPOLATE") ("MAXIMUM_INTENSITY") ("STEP") ("XSIZE") ("YSIZE") ("ZBUFFER") ("ZPIXELS")) idl)
    ("WARP_TRI"               fun nil                 (system) "Result = %s( Xo, Yo, Xi, Yi, Image)" (("EXTRAPOLATE") ("OUTPUT_SIZE") ("QUINTIC")) idl)
    ("WATERSHED"              fun nil                 (system) "Result = %s ( Image)" (("CONNECTIVITY")) idl)
    ("WHERE"                  fun nil                 (system) "Result = %s( Array_Expression [, Count] )" nil idl)
    ("WIDGET_BASE"            fun nil                 (system) "Result = %s( [Parent])" (("ALIGN_BOTTOM") ("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("ALIGN_TOP") ("APP_MBAR") ("BASE_ALIGN_BOTTOM") ("BASE_ALIGN_CENTER") ("BASE_ALIGN_LEFT") ("BASE_ALIGN_RIGHT") ("BASE_ALIGN_TOP") ("COLUMN") ("DISPLAY_NAME") ("EVENT_FUNC") ("EVENT_PRO") ("EXCLUSIVE") ("FLOATING") ("FRAME") ("FUNC_GET_VALUE") ("GRID_LAYOUT") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MAP") ("MBAR") ("MODAL") ("NO_COPY") ("NONEXCLUSIVE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("RNAME_MBAR") ("ROW") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("SPACE") ("TITLE") ("TLB_FRAME_ATTR") ("TLB_KILL_REQUEST_EVENTS") ("TLB_SIZE_EVENTS") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XPAD") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YPAD") ("YSIZE")) idl)
    ("WIDGET_BUTTON"          fun nil                 (system) "Result = %s( Parent)" (("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("BITMAP") ("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("HELP") ("KILL_NOTIFY") ("MENU") ("NO_COPY") ("NO_RELEASE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("SEPARATOR") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("X_BITMAP_EXTRA") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_DRAW"            fun nil                 (system) "Result = %s(Parent)" (("APP_SCROLL") ("BUTTON_EVENTS") ("COLOR_MODEL") ("COLORS") ("EVENT_FUNC") ("EVENT_PRO") ("EXPOSE_EVENTS") ("FRAME") ("FUNC_GET_VALUE") ("GRAPHICS_LEVEL") ("GROUP_LEADER") ("KILL_NOTIFY") ("MOTION_EVENTS") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RENDERER") ("RESOURCE_NAME") ("RETAIN") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("VIEWPORT_EVENTS") ("X_SCROLL_SIZE") ("XOFFSET") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_DROPLIST"        fun nil                 (system) "Result = %s( Parent)" (("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TITLE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_EVENT"           fun nil                 (system) "Result = %s([Widget_ID])" (("BAD_ID") ("NOWAIT") ("SAVE_HOURGLASS") ("YIELD_TO_TTY")) idl)
    ("WIDGET_INFO"            fun nil                 (system) "Result = %s( [Widget_ID] )" (("ACTIVE") ("CHILD") ("COLUMN_WIDTHS") ("DRAW_BUTTON_EVENTS") ("DRAW_EXPOSE_EVENTS") ("DRAW_MOTION_EVENTS") ("DRAW_VIEWPORT_EVENTS") ("DROPLIST_NUMBER") ("DROPLIST_SELECT") ("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FIND_BY_UNAME") ("GEOMETRY") ("KBRD_FOCUS_EVENTS") ("LIST_MULTIPLE") ("LIST_NUM_VISIBLE") ("LIST_NUMBER") ("LIST_SELECT") ("LIST_TOP") ("MANAGED") ("MODAL") ("NAME") ("PARENT") ("REALIZED") ("ROW_HEIGHTS") ("SIBLING") ("SLIDER_MIN_MAX") ("TABLE_ALL_EVENTS") ("TABLE_EDIT_CELL") ("TABLE_EDITABLE") ("TABLE_SELECT") ("TABLE_VIEW") ("TEXT_ALL_EVENTS") ("TEXT_EDITABLE") ("TEXT_NUMBER") ("TEXT_OFFSET_TO_XY") ("TEXT_SELECT") ("TEXT_TOP_LINE") ("TEXT_XY_TO_OFFSET") ("TLB_KILL_REQUEST_EVENTS") ("TRACKING_EVENTS") ("TYPE") ("UNAME") ("UNITS") ("UPDATE") ("USE_TABLE_SELECT") ("VALID_ID") ("VERSION")) idl)
    ("WIDGET_LABEL"           fun nil                 (system) "Result = %s( Parent)" (("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("DYNAMIC_RESIZE") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_LIST"            fun nil                 (system) "Result = %s( Parent)" (("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("MULTIPLE") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_SLIDER"          fun nil                 (system) "Result = %s( Parent)" (("DRAG") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("MAXIMUM") ("MINIMUM") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("SUPPRESS_VALUE") ("TITLE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("VERTICAL") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_TABLE"           fun nil                 (system) "Result = %s( Parent)" (("ALIGNMENT") ("ALL_EVENTS") ("AM_PM") ("COLUMN_LABELS") ("COLUMN_MAJOR") ("COLUMN_WIDTHS") ("DAYS_OF_WEEK") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FORMAT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MONTHS") ("NO_COPY") ("NO_HEADERS") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESIZEABLE_COLUMNS") ("RESIZEABLE_ROWS") ("RESOURCE_NAME") ("ROW_HEIGHTS") ("ROW_LABELS") ("ROW_MAJOR") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WIDGET_TEXT"            fun nil                 (system) "Result = %s( Parent)" (("ALL_EVENTS") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("NO_COPY") ("NO_NEWLINE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("WRAP") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")) idl)
    ("WRITE_SYLK"             fun nil                 (system) "Result = %s( File, Data)" (("STARTCOL") ("STARTROW")) idl)
    ("WTN"                    fun nil                 (system) "Result = %s( A, Coef)" (("COLUMN") ("DOUBLE") ("INVERSE") ("OVERWRITE")) idl)
    ("XFONT"                  fun nil                 (system) "Result = %s()" (("GROUP") ("PRESERVE")) idl)
    ("XREGISTERED"            fun nil                 (system) "Result = %s(Name)" (("NO_SHOW")) idl)
    ("XSQ_TEST"               fun nil                 (system) "Result = %s( Obfreq, Exfreq)" (("EXCELL") ("OBCELL") ("RESIDUAL")) idl)
    ("Add"                    pro "IDL_Container"     (system) "Obj -> [%s::]%s, Object" (("POSITION")) idl)
    ("Cleanup"                pro "IDL_Container"     (system) "Obj-> [%s::]%s" nil idl)
    ("Move"                   pro "IDL_Container"     (system) "Obj -> [%s::]%s, Source, Destination" nil idl)
    ("Remove"                 pro "IDL_Container"     (system) "Obj -> [%s::]%s [, Child_object]" (("ALL") ("POSITION")) idl)
    ("Count"                  fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s()" nil idl)
    ("Get"                    fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s ()" (("ALL") ("COUNT") ("ISA") ("POSITION")) idl)
    ("Init"                   fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s()" nil idl)
    ("IsContained"            fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s( Object)" (("POSITION")) idl)
    ("AppendData"             pro "IDLanROI"          (system) "Obj->[%s::]%s, X [, Y] [, Z]" (("XRANGE") ("YRANGE") ("ZRANGE")) idl)
    ("Cleanup"                pro "IDLanROI"          (system) "Obj->[%s::]%s" nil idl)
    ("GetProperty"            pro "IDLanROI"          (system) "Obj->[%s::]%s" (("ALL") ("BLOCKSIZE") ("DATA") ("INTERIOR") ("ROI_XRANGE") ("ROI_YRANGE") ("ROI_ZRANGE") ("TYPE")) idl)
    ("RemoveData"             pro "IDLanROI"          (system) "Obj->[%s::]%s" (("COUNT") ("START") ("XRANGE") ("YRANGE") ("ZRANGE")) idl)
    ("ReplaceData"            pro "IDLanROI"          (system) "Obj->[%s::]%s, X[, Y[, Z]]" (("FINISH") ("START") ("XRANGE") ("YRANGE") ("ZRANGE")) idl)
    ("Rotate"                 pro "IDLanROI"          (system) "Obj->[%s::]%s, Axis, Angle" (("CENTER")) idl)
    ("Scale"                  pro "IDLanROI"          (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" nil idl)
    ("SetProperty"            pro "IDLanROI"          (system) "Obj->[%s::]%s" (("BLOCKSIZE") ("DATA") ("INTERIOR")) idl)
    ("Translate"              pro "IDLanROI"          (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" nil idl)
    ("ComputeGeometry"        fun "IDLanROI"          (system) "Result = Obj->[%s::]%s" (("AREA") ("CENTROID") ("PERIMETER") ("SPATIAL_OFFSET") ("SPATIAL_SCALE")) idl)
    ("ComputeMask"            fun "IDLanROI"          (system) "Result = Obj->[%s::]%s()" (("DIMENSIONS") ("INITIALIZE") ("LOCATION") ("MASK_IN") ("MASK_RULE") ("PLANE_NORMAL") ("PLANE_XAXIS")) idl)
    ("ContainsPoints"         fun "IDLanROI"          (system) "Result = Obj->[%s::]%s( X [, Y [, Z]] )" nil idl)
    ("Init"                   fun "IDLanROI"          (system) "Result = Obj ->[%s::]%s( [X [, Y [, Z]]])" (("BLOCKSIZE") ("DATA") ("INTERIOR") ("TYPE")) idl)
    ("Add"                    pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, ROI" nil idl)
    ("Cleanup"                pro "IDLanROIGroup"     (system) "Obj->[%s::]%s" nil idl)
    ("GetProperty"            pro "IDLanROIGroup"     (system) "Obj->[%s::]%s" (("ALL") ("ROIGROUP_XRANGE") ("ROIGROUP_YRANGE") ("ROIGROUP_ZRANGE")) idl)
    ("Rotate"                 pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Axis, Angle" (("CENTER")) idl)
    ("Scale"                  pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" nil idl)
    ("Translate"              pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" nil idl)
    ("ComputeMask"            fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s()" (("DIMENSIONS") ("INITIALIZE") ("LOCATION") ("MASK_IN") ("MASK_RULE")) idl)
    ("ComputeMesh"            fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s( Vertices, Conn)" (("CAPPED") ("SURFACE_AREA")) idl)
    ("ContainsPoints"         fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s( X[, Y[, Z]] )" nil idl)
    ("Init"                   fun "IDLanROIGroup"     (system) "Result = Obj ->[%s::]%s()" nil idl)
    ("Connect"                pro "IDLdbDatabase"     (system) "DBobj ->[%s::]%s" (("CONNECTION") ("DATASOURCE") ("PASSWORD") ("USER_ID")) datamine)
    ("ExecuteSQL"             pro "IDLdbDatabase"     (system) "DBobj->ExecuteSQL, strSQL" nil datamine)
    ("GetProperty"            pro "IDLdbDatabase"     (system) "DBobj->GetProperty" (("CAN_GET_TABLES") ("DBMS_NAME") ("DBMS_VERSION") ("DRIVER_ODBC_LEVEL") ("DRIVER_VERSION") ("IS_CONNECTED") ("IS_READONLY") ("MAX_CONNECTIONS") ("MAX_RECORDSETS") ("ODBC_LEVEL") ("SQL_LEVEL") ("SQL_SERVER_NAME") ("USE_CURSOR_LIB") ("USER_NAME")) datamine)
    ("SetProperty"            pro "IDLdbDatabase"     (system) "DBobj->SetProperty" (("N_BUFFERS") ("SQL") ("TABLE") ("USE_CURSOR_LIB") ("VERBOSE")) datamine)
    ("GetDatasources"         fun "IDLdbDatabase"     (system) "Datasources = DBObj->GetDatasources()" nil datamine)
    ("GetTables"              fun "IDLdbDatabase"     (system) "Tables = DBObj->GetTables()" nil datamine)
    ("AddRecord"              pro "IDLdbRecordset"    (system) "RSObj->AddRecord, [field1][field2]...[fieldn]" (("SET_AUTOINCREMENT")) datamine)
    ("DeleteRecord"           pro "IDLdbRecordset"    (system) "RSobj->DeleteRecord" nil datamine)
    ("GetProperty"            pro "IDLdbRecordset"    (system) "RSobj->GetProperty" (("CAN_MOVE_ABSOLUTE") ("CAN_MOVE_FIRST") ("CAN_MOVE_LAST") ("CAN_MOVE_NEXT") ("CAN_MOVE_PRIOR") ("CAN_MOVE_RELATIVE") ("FIELD_INFO") ("GET_DATABASE") ("IS_READONLY") ("N_BUFFERS") ("RECORDSET_SOURCE")) datamine)
    ("SetField"               pro "IDLdbRecordset"    (system) "RSobj->SetField, iFieldNumber, Value" (("INFORMIX") ("NULL") ("SQL_TSI_DAY") ("SQL_TSI_FRAC_SECOND") ("SQL_TSI_HOUR") ("SQL_TSI_MINUTE") ("SQL_TSI_MONTH") ("SQL_TSI_QUARTER") ("SQL_TSI_SECOND") ("SQL_TSI_WEEK") ("SQL_TSI_YEAR") ("TNSNAME") ("UNIX")) datamine)
    ("CurrentRecord"          fun "IDLdbRecordset"    (system) "number = RSobj->CurrentRecord()" nil datamine)
    ("GetField"               fun "IDLdbRecordset"    (system) "value = RSobj->GetField(iFieldNumber)" (("IS_NULL") ("NULL_VALUE")) datamine)
    ("GetRecord"              fun "IDLdbRecordset"    (system) "Result = RSObj->GetRecord()" nil datamine)
    ("MoveCursor"             fun "IDLdbRecordset"    (system) "Result = RSObj->MoveCursor()" (("ABSOLUTE") ("FIRST") ("LAST") ("NEXT") ("PRIOR") ("RELATIVE")) datamine)
    ("NFields"                fun "IDLdbRecordset"    (system) "status = RSobj->NFields()" nil datamine)
    ("Cleanup"                pro "IDLffDICOM"        (system) "OBJ -> [%s::]%s" nil idl)
    ("DumpElements"           pro "IDLffDICOM"        (system) "Obj -> [%s::]%s [, Filename]" nil idl)
    ("Reset"                  pro "IDLffDICOM"        (system) "Obj -> [%s::]%s" nil idl)
    ("GetChildren"            fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( Reference )" nil idl)
    ("GetDescription"         fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")) idl)
    ("GetElement"             fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")) idl)
    ("GetGroup"               fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group[, Element]])" (("REFERENCE")) idl)
    ("GetLength"              fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")) idl)
    ("GetParent"              fun "IDLffDICOM"        (system) "array = Obj ->[%s::]%s( ReferenceList )" nil idl)
    ("GetPreamble"            fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( )" nil idl)
    ("GetReference"           fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("DESCRIPTION") ("VR")) idl)
    ("GetValue"               fun "IDLffDICOM"        (system) "ptrArray = Obj -> [%s::]%s( [Group [, Element]])" (("NO_COPY") ("REFERENCE")) idl)
    ("GetVR"                  fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")) idl)
    ("Init"                   fun "IDLffDICOM"        (system) "Result = Obj -> [%s::]%s( [ Filename])" (("VERBOSE")) idl)
    ("Read"                   fun "IDLffDICOM"        (system) "Result = Obj -> [%s::]%s( Filename)" (("ENDIAN")) idl)
    ("Cleanup"                pro "IDLffDXF"          (system) "Obj -> [%s::]%s" nil idl)
    ("GetPalette"             pro "IDLffDXF"          (system) "Obj-> [%s::]%s, Red, Green, Blue" nil idl)
    ("PutEntity"              pro "IDLffDXF"          (system) "Obj -> [%s::]%s, Data" nil idl)
    ("RemoveEntity"           pro "IDLffDXF"          (system) "Obj -> [%s::]%s[, Type]" (("INDEX")) idl)
    ("Reset"                  pro "IDLffDXF"          (system) "Obj-> [%s::]%s" nil idl)
    ("SetPalette"             pro "IDLffDXF"          (system) "Obj-> [%s::]%s, Red, Green, Blue" nil idl)
    ("GetContents"            fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( [Filter])" (("BLOCK") ("COUNT") ("LAYER")) idl)
    ("GetEntity"              fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Type)" (("BLOCK") ("INDEX") ("LAYER")) idl)
    ("Init"                   fun "IDLffDXF"          (system) "Result = Obj -> [%s::]%s([ Filename])))" nil idl)
    ("Read"                   fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Filename )" nil idl)
    ("Write"                  fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Filename )" nil idl)
    ("IsValid"                fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( )" nil idl)
    ("Query"                  fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( key)" (("DEFAULT_STRING")) idl)
    ("SetCatalog"             fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( application)" (("FILENAME") ("LOCALE") ("PATH")) idl)
    ("Cleanup"                pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("CRANGE") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("NAME") ("NOTEXT") ("PALETTE") ("PARENT") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" (("COLOR") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("NAME") ("NOTEXT") ("PALETTE") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrAxis"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrAxis"         (system) "Result = Obj -> [%s::]%s([Direction])" (("COLOR") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("NAME") ("NOTEXT") ("PALETTE") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s [, Picture]" (("CREATE_INSTANCE") ("DRAW_INSTANCE")) idl)
    ("Erase"                  pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("COLOR")) idl)
    ("GetProperty"            pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("IMAGE_DATA") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE") ("ZBUFFER_DATA")) idl)
    ("SetProperty"            pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("GetContiguousPixels"    fun "IDLgrBuffer"       (system) "Return = Obj -> [%s::]%s()" nil idl)
    ("GetDeviceInfo"          fun "IDLgrBuffer"       (system) "Result = Obj->[%s::]%s()" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")) idl)
    ("GetFontnames"           fun "IDLgrBuffer"       (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")) idl)
    ("GetTextDimensions"      fun "IDLgrBuffer"       (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")) idl)
    ("Init"                   fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s()" (("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("PickData"               fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" (("PATH")) idl)
    ("Read"                   fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s()" nil idl)
    ("Select"                 fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s(Picture, XY)" (("DIMENSIONS") ("UNITS")) idl)
    ("Cleanup"                pro "IDLgrClipboard"    (system) "Obj-> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s [, Picture]" (("FILENAME") ("POSTSCRIPT") ("VECTOR")) idl)
    ("GetProperty"            pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("GetContiguousPixels"    fun "IDLgrClipboard"    (system) "Return = Obj ->[%s::]%s()" nil idl)
    ("GetDeviceInfo"          fun "IDLgrClipboard"    (system) "Result = Obj->[%s::]%s()" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")) idl)
    ("GetFontnames"           fun "IDLgrClipboard"    (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")) idl)
    ("GetTextDimensions"      fun "IDLgrClipboard"    (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")) idl)
    ("Init"                   fun "IDLgrClipboard"    (system) "Result = Obj -> [%s::]%s()" (("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" (("ALL") ("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("PARENT") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("THREED") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" (("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("ComputeDimensions"      fun "IDLgrColorbar"     (system) "Result = Obj ->[%s::]%s( DestinationObj)" (("PATH")) idl)
    ("Init"                   fun "IDLgrColorbar"     (system) "Result = Obj -> [%s::]%s( [aRed, aGreen, aBlue])" (("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("THREED") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrContour"      (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrContour"      (system) "Obj -> [%s::]%s" (("ALL") ("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOWNHILL") ("FILL") ("GEOM") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PARENT") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrContour"      (system) "Obj -> [%s::]%s" (("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOWNHILL") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrContour"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrContour"      (system) "Result = Obj -> [%s::]%s( [Values])" (("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOWNHILL") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrFont"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrFont"         (system) "Obj -> [%s:]%s" (("ALL") ("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrFont"         (system) "Obj -> [%s:]%s" (("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")) idl)
    ("Init"                   fun "IDLgrFont"         (system) "Result = Obj -> [%s::]%s( [Fontname])" (("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrImage"        (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrImage"        (system) "Obj -> [%s::]%s" (("ALL") ("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("PARENT") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrImage"        (system) "Obj -> [%s::]%s" (("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("RESET_DATA") ("SHARE_DATA") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrImage"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrImage"        (system) "Result = Obj -> [%s::]%s( [ImageData])" (("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("RESET_DATA") ("SHARE_DATA") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrLegend"       (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrLegend"       (system) "Obj -> [%s::]%s" (("ALL") ("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("PARENT") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrLegend"       (system) "Obj-> [%s::]%s" (("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("RECOMPUTE") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("ComputeDimensions"      fun "IDLgrLegend"       (system) "Result = Obj ->[%s::]%s( DestinationObject)" (("PATH")) idl)
    ("Init"                   fun "IDLgrLegend"       (system) "Result = Obj -> [%s::]%s( [aItemNames])" (("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrLight"        (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrLight"        (system) "Obj -> [%s::]%s" (("ALL") ("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("PARENT") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("SetProperty"            pro "IDLgrLight"        (system) "Obj -> [%s::]%s" (("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrLight"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrLight"        (system) "Result = Obj -> [%s::]%s()" (("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Add"                    pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Object" (("ALIAS") ("POSITION")) idl)
    ("Cleanup"                pro "IDLgrModel"        (system) "Obj -> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Destination, Picture" nil idl)
    ("GetProperty"            pro "IDLgrModel"        (system) "Obj -> [%s::]%s" (("ALL") ("HIDE") ("LIGHTING") ("NAME") ("PARENT") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")) idl)
    ("Reset"                  pro "IDLgrModel"        (system) "Obj -> [%s::]%s" nil idl)
    ("Rotate"                 pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Axis, Angle" (("PREMULTIPLY")) idl)
    ("Scale"                  pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Sx, Sy, Sz" (("PREMULTIPLY")) idl)
    ("SetProperty"            pro "IDLgrModel"        (system) "Obj -> [%s::]%s" (("HIDE") ("LIGHTING") ("NAME") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")) idl)
    ("Translate"              pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Tx, Ty, Tz" (("PREMULTIPLY")) idl)
    ("GetByName"              fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s(Name)" nil idl)
    ("GetCTM"                 fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s()" (("HIDE") ("LIGHTING") ("NAME") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("ALL") ("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("INTERLACED") ("SCALE") ("STATISTICS")) idl)
    ("Put"                    pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s, Image[, Frame]" nil idl)
    ("Save"                   pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("CREATOR_TYPE") ("FILENAME")) idl)
    ("SetProperty"            pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("INTERLACED") ("SCALE") ("STATISTICS")) idl)
    ("Init"                   fun "IDLgrMPEG"         (system) "Result = Obj -> [%s::]%s()" (("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("INTERLACED") ("SCALE") ("STATISTICS") ("TEMP_DIRECTORY")) idl)
    ("Cleanup"                pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" (("ALL") ("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("N_COLORS") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")) idl)
    ("LoadCT"                 pro "IDLgrPalette"      (system) "Obj -> [%s::]%s, TableNum" (("FILENAME")) idl)
    ("SetProperty"            pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" (("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")) idl)
    ("SetRGB"                 pro "IDLgrPalette"      (system) "Obj -> [%s::]%s, Index, Red, Green, Blue" nil idl)
    ("GetRGB"                 fun "IDLgrPalette"      (system) "Result = Obj -> [%s::]%s(Index)" nil idl)
    ("Init"                   fun "IDLgrPalette"      (system) "Result=Obj-> [%s::]%s( [aRed, aGreen, aBlue])" (("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")) idl)
    ("NearestColor"           fun "IDLgrPalette"      (system) "Result = Obj-> [%s::]%s(Red, Green, Blue)" nil idl)
    ("Cleanup"                pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" (("ALL") ("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" (("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("UVALUE")) idl)
    ("Init"                   fun "IDLgrPattern"      (system) "Result = Obj -> [%s::]%s( [Style])" (("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("THICK") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("PARENT") ("POLAR") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE") ("ZVALUE")) idl)
    ("SetProperty"            pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" (("COLOR") ("DATAY") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("POLAR") ("RESET_DATA") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZVALUE")) idl)
    ("GetCTM"                 fun "IDLgrPlot"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrPlot"         (system) "Result = Obj -> [%s::]%s( [[X,] Y])" (("COLOR") ("DATAY") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("POLAR") ("RESET_DATA") ("SHARE_DATA") ("SYMBOL") ("THICK") ("USE_ZVALUE") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZVALUE")) idl)
    ("Cleanup"                pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" (("ALL") ("BOTTOM") ("COLOR") ("DATA") ("FILL_PATTERN") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("PARENT") ("POLYGONS") ("REJECT") ("SHADE_RANGE") ("SHADING") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" (("BOTTOM") ("COLOR") ("DATA") ("FILL_PATTERN") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("POLYGONS") ("REJECT") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("GetCTM"                 fun "IDLgrPolygon"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrPolygon"      (system) "Result = Obj -> [%s::]%s( [X, [Y, [Z]]])" (("BOTTOM") ("COLOR") ("DATA") ("FILL_PATTERN") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("PALETTE") ("POLYGONS") ("REJECT") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("Cleanup"                pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("PARENT") ("POLYLINES") ("SHADING") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" (("COLOR") ("DATA") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("POLYLINES") ("RESET_DATA") ("SHADING") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrPolyline"     (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrPolyline"     (system) "Result = Obj -> [%s::]%s( [X, [Y, [Z]]])" (("COLOR") ("DATA") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("POLYLINES") ("RESET_DATA") ("SHADING") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Cleanup"                pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s [, Picture]" (("VECTOR")) idl)
    ("GetProperty"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("LANDSCAPE") ("N_COLORS") ("N_COPIES") ("NAME") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("NewDocument"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil idl)
    ("NewPage"                pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil idl)
    ("SetProperty"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" (("GRAPHICS_TREE") ("LANDSCAPE") ("N_COPIES") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("UNITS") ("UVALUE")) idl)
    ("GetContiguousPixels"    fun "IDLgrPrinter"      (system) "Return = Obj -> [%s::]%s()" nil idl)
    ("GetFontnames"           fun "IDLgrPrinter"      (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")) idl)
    ("GetTextDimensions"      fun "IDLgrPrinter"      (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")) idl)
    ("Init"                   fun "IDLgrPrinter"      (system) "Result = Obj -> [%s::]%s()" (("COLOR_MODEL") ("GRAPHICS_TREE") ("LANDSCAPE") ("N_COLORS") ("N_COPIES") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("UNITS") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrROI"          (system) "Obj->[%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrROI"          (system) "Obj->[%s::]%s" (("ALL") ("COLOR") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("SetProperty"            pro "IDLgrROI"          (system) "Obj->[%s::]%s" (("COLOR") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Init"                   fun "IDLgrROI"          (system) "Result = Obj ->[%s::]%s([X[, Y[, Z]]])" (("COLOR") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("PickVertex"             fun "IDLgrROI"          (system) "Result = Obj->[%s::]%s( Dest, View, Point)" (("PATH")) idl)
    ("Add"                    pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s, ROI" nil idl)
    ("Cleanup"                pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s" nil idl)
    ("Init"                   fun "IDLgrROIGroup"     (system) "Result = Obj ->[%s::]%s()" nil idl)
    ("PickRegion"             fun "IDLgrROIGroup"     (system) "Result = Obj->[%s::]%s( Dest, View, Point)" (("PATH")) idl)
    ("Add"                    pro "IDLgrScene"        (system) "Obj -> [%s::]%s, View" (("POSITION")) idl)
    ("Cleanup"                pro "IDLgrScene"        (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrScene"        (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrScene"        (system) "Obj -> [%s::]%s" (("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")) idl)
    ("GetByName"              fun "IDLgrScene"        (system) "Result = Obj -> [%s::]%s(Name)" nil idl)
    ("Init"                   fun "IDLgrScene"        (system) "Result = Obj -> [%s::]%s()" (("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" (("ALL") ("BOTTOM") ("COLOR") ("DATA") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("PARENT") ("SHADE_RANGE") ("SHADING") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" (("BOTTOM") ("COLOR") ("DATAX") ("DATAY") ("DATAZ") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("GetCTM"                 fun "IDLgrSurface"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrSurface"      (system) "Result = Obj -> [%s::]%s( [Z, [X, Y]])" (("BOTTOM") ("COLOR") ("DATAX") ("DATAY") ("DATAZ") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("Cleanup"                pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" (("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")) idl)
    ("Init"                   fun "IDLgrSymbol"       (system) "Result = Obj -> [%s::]%s( [Data])" (("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")) idl)
    ("AddPolygon"             pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s, X [, Y[, Z]]" (("INTERIOR") ("POLYGON")) idl)
    ("Cleanup"                pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s" nil idl)
    ("Reset"                  pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s" nil idl)
    ("Init"                   fun "IDLgrTessellator"  (system) "Result = Obj -> [%s::]%s( )" nil idl)
    ("Tessellate"             fun "IDLgrTessellator"  (system) "Result = Obj -> [%s::]%s( Vertices, Poly)" (("QUIET")) idl)
    ("Cleanup"                pro "IDLgrText"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrText"         (system) "Obj -> [%s::]%s" (("ALIGNMENT") ("ALL") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("PARENT") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrText"         (system) "Obj -> [%s::]%s" (("ALIGNMENT") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("GetCTM"                 fun "IDLgrText"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrText"         (system) "Result = Obj -> [%s::]%s( [, String or vector of strings])" (("ALIGNMENT") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")) idl)
    ("Add"                    pro "IDLgrView"         (system) "Obj -> [%s::]%s, Model" (("POSITION")) idl)
    ("Cleanup"                pro "IDLgrView"         (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrView"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("EYE") ("LOCATION") ("PARENT") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")) idl)
    ("SetProperty"            pro "IDLgrView"         (system) "Obj -> [%s::]%s" (("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("EYE") ("LOCATION") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")) idl)
    ("GetByName"              fun "IDLgrView"         (system) "Result = Obj -> [%s::]%s(Name)" nil idl)
    ("Init"                   fun "IDLgrView"         (system) "Result = Obj -> [%s::]%s()" (("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("EYE") ("LOCATION") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")) idl)
    ("Add"                    pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s, Object" (("POSITION")) idl)
    ("Cleanup"                pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" nil idl)
    ("GetProperty"            pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" (("ALL") ("HIDE") ("NAME") ("PARENT") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" (("HIDE") ("NAME") ("UVALUE")) idl)
    ("GetByName"              fun "IDLgrViewgroup"    (system) "Result = Obj -> [%s::]%s(Name)" nil idl)
    ("Init"                   fun "IDLgrViewgroup"    (system) "Result = Obj -> [%s::]%s()" (("HIDE") ("NAME") ("UVALUE")) idl)
    ("Cleanup"                pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" nil idl)
    ("ComputeBounds"          pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("OPACITY") ("RESET") ("VOLUMES")) idl)
    ("GetProperty"            pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("ALL") ("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("PARENT") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VALID_DATA") ("VOLUME_SELECT") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")) idl)
    ("SetProperty"            pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VOLUME_SELECT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("GetCTM"                 fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")) idl)
    ("Init"                   fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s( [vol0 [, vol1 [, vol2 [, vol3]]]])" (("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VOLUME_SELECT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")) idl)
    ("PickVoxel"              fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s ( Win, View, Point)" (("PATH")) idl)
    ("Cleanup"                pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrVRML"         (system) "Obj -> [%s::]%s [, Picture]" nil idl)
    ("GetProperty"            pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE")) idl)
    ("SetProperty"            pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")) idl)
    ("GetDeviceInfo"          fun "IDLgrVRML"         (system) "Result = Obj->[%s::]%s()" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")) idl)
    ("GetFontnames"           fun "IDLgrVRML"         (system) "Return = Obj ->[%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")) idl)
    ("GetTextDimensions"      fun "IDLgrVRML"         (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")) idl)
    ("Init"                   fun "IDLgrVRML"         (system) "Result = Obj -> [%s::]%s()" (("COLOR_MODEL") ("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE") ("WOLRDTITLE") ("WORLDINFO")) idl)
    ("Cleanup"                pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" nil idl)
    ("Draw"                   pro "IDLgrWindow"       (system) "Obj -> [%s::]%s [, Picture]" (("CREATE_INSTANCE") ("DRAW_INSTANCE")) idl)
    ("Erase"                  pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("COLOR")) idl)
    ("GetDeviceInfo"          pro "IDLgrWindow"       (system) "Obj->[%s::]%s" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")) idl)
    ("GetProperty"            pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("DISPLAY_NAME") ("GRAPHICS_TREE") ("IMAGE_DATA") ("LOCATION") ("N_COLORS") ("PALETTE") ("QUALITY") ("RENDERER") ("RESOLUTION") ("RETAIN") ("SCREEN_DIMENSIONS") ("TITLE") ("UNITS") ("UVALUE") ("ZBUFFER_DATA")) idl)
    ("Iconify"                pro "IDLgrWindow"       (system) "Obj -> [%s::]%s, IconFlag" nil idl)
    ("SetCurrentCursor"       pro "IDLgrWindow"       (system) "Obj-> [%s::]%s [, CursorName]" (("HOTSPOT") ("IMAGE") ("MASK") ("STANDARD")) idl)
    ("SetProperty"            pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("LOCATION") ("PALETTE") ("QUALITY") ("TITLE") ("UNITS") ("UVALUE")) idl)
    ("Show"                   pro "IDLgrWindow"       (system) "Obj -> [%s::]%s, Position" nil idl)
    ("GetContiguousPixels"    fun "IDLgrWindow"       (system) "Return = Obj -> [%s::]%s()" nil idl)
    ("GetFontnames"           fun "IDLgrWindow"       (system) "Return = Obj -> [%s::]%s(FamilyName)" (("IDL_FONTS") ("STYLES")) idl)
    ("GetTextDimensions"      fun "IDLgrWindow"       (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")) idl)
    ("Init"                   fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s()" (("COLOR_MODEL") ("DIMENSIONS") ("DISPLAY_NAME") ("GRAPHICS_TREE") ("LOCATION") ("N_COLORS") ("PALETTE") ("QUALITY") ("RENDERER") ("RETAIN") ("TITLE") ("UNITS") ("UVALUE")) idl)
    ("PickData"               fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" (("PATH")) idl)
    ("Read"                   fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s()" nil idl)
    ("Select"                 fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s( Picture, XY)" (("DIMENSIONS") ("UNITS")) idl)
    ("Reset"                  pro "TrackBall"         (system) "Obj -> [%s::]%s(Center, Radius)" (("AXIS") ("CONSTRAIN") ("MOUSE")) idl)
    ("Init"                   fun "TrackBall"         (system) "Result = Obj -> [%s::]%s( Center, Radius)" (("AXIS") ("CONSTRAIN") ("MOUSE")) idl)
    ("Update"                 fun "TrackBall"         (system) "Result = Obj -> [%s::]%s( sEvent)" (("MOUSE") ("TRANSFORM") ("TRANSLATE")) idl)
   )
  "1226 builtin routines with 5230 keywords for IDL version 5.3.")


(provide 'idlw-rinfo)
(provide 'idlwave-rinfo)

;;; idlw-rinfo.el ends here
