#include QMK_KEYBOARD_H
#include "bootloader.h"
#ifdef PROTOCOL_LUFA
  #include "lufa.h"
  #include "split_util.h"
#endif
#ifdef SSD1306OLED
  #include "ssd1306.h"
#endif

extern keymap_config_t keymap_config;

#ifdef RGBLIGHT_ENABLE
//Following line allows macro to read current RGB settings
extern rgblight_config_t rgblight_config;
#endif

extern uint8_t is_master;

// Each layer gets a name for readability, which is then used in the keymap matrix below.
// The underscores don't mean anything - you can have a layer called STUFF or any other name.
// Layer names don't all need to be of the same length, obviously, and you can also skip them
// entirely and just use numbers.
#define _QWERTY 0
#define _MAC    1
#define _ECLN   2
#define _ECLNMAC    3
#define _LOWER  4
#define _RAISE  5
#define _ADJUST 16

enum custom_keycodes {
  QWERTY = SAFE_RANGE,
  LOWER,
  RAISE,
  ADJUST,
  BACKLIT,
  RGBRST,
  RTAB,
  LTAB,
  RSPC,
  LSPC,
  USPC,
  DSPC,
  SSCR,
  SWIN,
  NAPP,
  NWIN
};

enum macro_keycodes {
  KC_SAMPLEMACRO,
};

#define KC______ KC_TRNS
#define KC_XXXXX KC_NO
#define KC_LOWER LOWER
#define KC_RAISE RAISE
#define KC_RST   RESET
#define KC_LRST  RGBRST
#define KC_LTOG  RGB_TOG
#define KC_LHUI  RGB_HUI
#define KC_LHUD  RGB_HUD
#define KC_LSAI  RGB_SAI
#define KC_LSAD  RGB_SAD
#define KC_LVAI  RGB_VAI
#define KC_LVAD  RGB_VAD
#define KC_LMOD  RGB_MOD
#define KC_CTLTB CTL_T(KC_TAB)
#define KC_CLESC CTL_T(KC_ESC)
#define KC_GUIEI GUI_T(KC_LANG2)
#define KC_ALTKN ALT_T(KC_LANG1)

#define KC_RTAB  RTAB
#define KC_LTAB  LTAB
#define KC_RSPC  RSPC
#define KC_LSPC  LSPC
#define KC_USPC  USPC
#define KC_DSPC  DSPC
#define KC_SSCR  SSCR
#define KC_SWIN  SWIN
#define KC_NAPP  NAPP
#define KC_NWIN  NWIN

#define KC_L1  TO(_QWERTY)
#define KC_L2  TO(_MAC)
#define KC_L3  TO(_ECLN)
#define KC_L4  TO(_ECLNMAC)


#define SS_RGUI(string) SS_DOWN(X_RGUI) string SS_UP(X_RGUI)


const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  [_QWERTY] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
        TAB,     Q,     W,     E,     R,     T,                      Y,     U,     I,     O,     P,  MINS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CLESC,     A,     S,     D,     F,     G,                      H,     J,     K,     L,  SCLN,  QUOT,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,     Z,     X,     C,     V,     B,                      N,     M,  COMM,   DOT,  SLSH,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LALT,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_MAC] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
        TAB,     Q,     W,     E,     R,     T,                      Y,     U,     I,     O,     P,  MINS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CLESC,     A,     S,     D,     F,     G,                      H,     J,     K,     L,  SCLN,  QUOT,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,     Z,     X,     C,     V,     B,                      N,     M,  COMM,   DOT,  SLSH,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LGUI,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_ECLN] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
        TAB,     Q,     W,  COMM,   DOT,  SCLN,                      M,     R,     D,     Y,     P,  MINS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CLESC,     A,     O,     E,     I,     U,                      G,     T,     K,     S,     N,  QUOT,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,     Z,     X,     C,     V,     F,                      N,     M,     J,     L,  SLSH,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LALT,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_ECLNMAC] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
        TAB,     Q,     W,  COMM,   DOT,  SCLN,                      M,     R,     D,     Y,     P,  MINS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CLESC,     A,     O,     E,     I,     U,                      G,     T,     K,     S,     N,  QUOT,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,     Z,     X,     C,     V,     F,                      N,     M,     J,     L,  SLSH,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LGUI,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_LOWER] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
       PLUS,  EXLM,    AT,  HASH,   DLR,  PERC,                   CIRC,  AMPR,  ASTR,  LPRN,  RPRN,  BSLS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CTLTB,  TILD,  LTAB,  USPC,  RTAB, XXXXX,                  XXXXX,  LCBR,  RCBR,  LBRC,  RBRC,  PIPE,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,   GRV,  LSPC,  DSPC,  RSPC, XXXXX,                  XXXXX,    LT,    GT,  LCBR,  RCBR,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LALT,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_RAISE] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
        EQL,     1,     2,     3,     4,     5,                      6,     7,     8,     9,     0,  BSLS,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      CTLTB, XXXXX,  WH_U,  MS_U,  WH_D,  BTN1,                   HOME,  PGUP,    UP,  PGDN, XXXXX,  PIPE,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
       LSFT,  BTN3,  MS_L,  MS_D,  MS_R,  BTN2,                    END,  LEFT,  DOWN, RIGHT, XXXXX,  RSFT,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LALT,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  ),

  [_ADJUST] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
         F1,    F2,    F3,    F4,    F5,    F6,                     F7,   F8,     F9,   F10,   F11,   F12,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      XXXXX,  SSCR,  SWIN, XXXXX, XXXXX,    L1,                     L3,  MUTE,  VOLD,  VOLU, XXXXX, XXXXX,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
        RST, XXXXX, XXXXX, XXXXX, XXXXX,    L2,                     L4,  MRWD,  MPLY,  MFFD, XXXXX,   RST,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  LOWER,   SPC,  LALT,      ENT,  BSPC, RAISE \
                              //`--------------------'  `--------------------'
  )

#if 0
  [_MAC] = LAYOUT_kc( \
  //,-----------------------------------------.                ,-----------------------------------------.
      _____, _____, _____, _____, _____, _____,                  _____, _____, _____, _____, _____, _____,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      _____, _____, _____, _____, _____, _____,                  _____, _____, _____, _____, _____, _____,\
  //|------+------+------+------+------+------|                |------+------+------+------+------+------|
      _____, _____, _____, _____, _____, _____,                  _____, _____, _____, _____, _____, _____,\
  //|------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
                                  _____, _____,  LGUI,    _____, _____, _____,\
                              //`--------------------'  `--------------------'
  )
#endif

};

int RGB_current_mode;

void persistent_default_layer_set(uint16_t default_layer) {
  eeconfig_update_default_layer(default_layer);
  default_layer_set(default_layer);
}

// Setting ADJUST layer RGB back to default
void update_tri_layer_RGB(uint8_t layer1, uint8_t layer2, uint8_t layer3) {
  if (IS_LAYER_ON(layer1) && IS_LAYER_ON(layer2)) {
    layer_on(layer3);
  } else {
    layer_off(layer3);
  }
}

void matrix_init_user(void) {
    #ifdef RGBLIGHT_ENABLE
      RGB_current_mode = rgblight_config.mode;
    #endif
    //SSD1306 OLED init, make sure to add #define SSD1306OLED in config.h
    #ifdef SSD1306OLED
        iota_gfx_init(!has_usb());   // turns on the display
    #endif
}

//SSD1306 OLED update loop, make sure to add #define SSD1306OLED in config.h
#ifdef SSD1306OLED

// When add source files to SRC in rules.mk, you can use functions.
const char *read_layer_state(void);
const char *read_logo(void);
void set_keylog(uint16_t keycode, keyrecord_t *record);
const char *read_keylog(void);
const char *read_keylogs(void);

// const char *read_mode_icon(bool swap);
// const char *read_host_led_state(void);
// void set_timelog(void);
// const char *read_timelog(void);

void matrix_scan_user(void) {
   iota_gfx_task();
}

void matrix_render_user(struct CharacterMatrix *matrix) {
  if (is_master) {
    // If you want to change the display of OLED, you need to change here
    matrix_write_ln(matrix, read_layer_state());
    matrix_write_ln(matrix, read_keylog());
    matrix_write_ln(matrix, read_keylogs());
    //matrix_write_ln(matrix, read_mode_icon(keymap_config.swap_lalt_lgui));
    //matrix_write_ln(matrix, read_host_led_state());
    //matrix_write_ln(matrix, read_timelog());
  } else {
    matrix_write(matrix, read_logo());
  }
}

void matrix_update(struct CharacterMatrix *dest, const struct CharacterMatrix *source) {
  if (memcmp(dest->display, source->display, sizeof(dest->display))) {
    memcpy(dest->display, source->display, sizeof(dest->display));
    dest->dirty = true;
  }
}

void iota_gfx_task_user(void) {
  struct CharacterMatrix matrix;
  matrix_clear(&matrix);
  matrix_render_user(&matrix);
  matrix_update(&display, &matrix);
}
#endif//SSD1306OLED

bool process_record_user(uint16_t keycode, keyrecord_t *record) {
  if (record->event.pressed) {
#ifdef SSD1306OLED
    set_keylog(keycode, record);
#endif
    // set_timelog();
  }

  switch (keycode) {
    case QWERTY:
      if (record->event.pressed) {
        persistent_default_layer_set(1UL<<_QWERTY);
      }
      return false;
      break;
    case LOWER:
      if (record->event.pressed) {
        layer_on(_LOWER);
        update_tri_layer_RGB(_LOWER, _RAISE, _ADJUST);
      } else {
        layer_off(_LOWER);
        update_tri_layer_RGB(_LOWER, _RAISE, _ADJUST);
      }
      return false;
      break;
    case RAISE:
      if (record->event.pressed) {
        layer_on(_RAISE);
        update_tri_layer_RGB(_LOWER, _RAISE, _ADJUST);
      } else {
        layer_off(_RAISE);
        update_tri_layer_RGB(_LOWER, _RAISE, _ADJUST);
      }
      return false;
      break;
    case ADJUST:
        if (record->event.pressed) {
          layer_on(_ADJUST);
        } else {
          layer_off(_ADJUST);
        }
        return false;
        break;
    case RGB_MOD:
      #ifdef RGBLIGHT_ENABLE
        if (record->event.pressed) {
          rgblight_mode(RGB_current_mode);
          rgblight_step();
          RGB_current_mode = rgblight_config.mode;
        }
      #endif
      return false;
      break;
    case RGBRST:
      #ifdef RGBLIGHT_ENABLE
        if (record->event.pressed) {
          eeconfig_update_rgblight_default();
          rgblight_enable();
          RGB_current_mode = rgblight_config.mode;
        }
      #endif
      break;
  case RTAB:
      //ctrl-tab
      if(record->event.pressed) {
          SEND_STRING(SS_LCTRL(SS_TAP(X_TAB)));
      }
      return false;
      break;
  case LTAB:
      //ctrl-shift-tab
      if(record->event.pressed) {
          SEND_STRING(SS_LSFT(SS_LCTRL(SS_TAP(X_TAB))));
      }
      return false;
      break;
  case RSPC:
      //ctrl-right
      if(record->event.pressed) {
          SEND_STRING(SS_LCTRL(SS_TAP(X_RIGHT)));
      }
      break;
  case LSPC:
      //ctrl-left
      if(record->event.pressed) {
          SEND_STRING(SS_LCTRL(SS_TAP(X_LEFT)));
      }
      return false;
      break;
  case USPC:
      //ctrl-up
      if(record->event.pressed) {
          SEND_STRING(SS_LCTRL(SS_TAP(X_UP)));
      }
      return false;
      break;
  case DSPC:
      //ctrl-down
      if(record->event.pressed) {
          SEND_STRING(SS_LCTRL(SS_TAP(X_DOWN)));
      }
      return false;
      break;
  case SSCR:
      //shift-cmd-3
      if(record->event.pressed) {
          SEND_STRING(SS_LSFT(SS_LGUI(SS_TAP(X_3))));
      }
      return false;
      break;
  case SWIN:
      //shift-cmd-4
      if(record->event.pressed) {
          SEND_STRING(SS_LSFT(SS_LGUI(SS_TAP(X_4))));
      }
      return false;
      break;
  case NAPP:
      //cmd-tab
      if(record->event.pressed) {
          SEND_STRING(SS_RGUI(SS_TAP(X_TAB)));
      }
      return false;
      break;
  case NWIN:
      //cmd-grave
      if(record->event.pressed) {
          SEND_STRING(SS_RGUI(SS_TAP(X_GRAVE)));
      }
      return false;
      break;

#if 0
  case _ENTER:
      if (record->event.pressed && get_mods() & MOD_BIT(KC_HYPR)) {
          SEND_STRING ("string");
      } else {
          SEND_STRING (SS_TAP(X_ENTER));
      }
      return false;
      break;
#endif

  }
  return true;
}

