/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: sine_win.h,v 1.15 2004/09/04 14:56:28 menno Exp $
**/

#ifndef __SINE_WIN_H__
#define __SINE_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

ALIGN static const real_t sine_long_1024[] =
{
    FRAC_CONST(0.00076699031874270449),
    FRAC_CONST(0.002300969151425805),
    FRAC_CONST(0.0038349425697062275),
    FRAC_CONST(0.0053689069639963425),
    FRAC_CONST(0.0069028587247297558),
    FRAC_CONST(0.0084367942423697988),
    FRAC_CONST(0.0099707099074180308),
    FRAC_CONST(0.011504602110422714),
    FRAC_CONST(0.013038467241987334),
    FRAC_CONST(0.014572301692779064),
    FRAC_CONST(0.016106101853537287),
    FRAC_CONST(0.017639864115082053),
    FRAC_CONST(0.019173584868322623),
    FRAC_CONST(0.020707260504265895),
    FRAC_CONST(0.022240887414024961),
    FRAC_CONST(0.023774461988827555),
    FRAC_CONST(0.025307980620024571),
    FRAC_CONST(0.026841439699098531),
    FRAC_CONST(0.028374835617672099),
    FRAC_CONST(0.029908164767516555),
    FRAC_CONST(0.031441423540560301),
    FRAC_CONST(0.032974608328897335),
    FRAC_CONST(0.03450771552479575),
    FRAC_CONST(0.036040741520706229),
    FRAC_CONST(0.037573682709270494),
    FRAC_CONST(0.039106535483329888),
    FRAC_CONST(0.040639296235933736),
    FRAC_CONST(0.042171961360347947),
    FRAC_CONST(0.043704527250063421),
    FRAC_CONST(0.04523699029880459),
    FRAC_CONST(0.046769346900537863),
    FRAC_CONST(0.048301593449480144),
    FRAC_CONST(0.049833726340107277),
    FRAC_CONST(0.051365741967162593),
    FRAC_CONST(0.052897636725665324),
    FRAC_CONST(0.054429407010919133),
    FRAC_CONST(0.055961049218520569),
    FRAC_CONST(0.057492559744367566),
    FRAC_CONST(0.059023934984667931),
    FRAC_CONST(0.060555171335947788),
    FRAC_CONST(0.062086265195060088),
    FRAC_CONST(0.063617212959193106),
    FRAC_CONST(0.065148011025878833),
    FRAC_CONST(0.066678655793001557),
    FRAC_CONST(0.068209143658806329),
    FRAC_CONST(0.069739471021907307),
    FRAC_CONST(0.071269634281296401),
    FRAC_CONST(0.072799629836351673),
    FRAC_CONST(0.074329454086845756),
    FRAC_CONST(0.075859103432954447),
    FRAC_CONST(0.077388574275265049),
    FRAC_CONST(0.078917863014784942),
    FRAC_CONST(0.080446966052950014),
    FRAC_CONST(0.081975879791633066),
    FRAC_CONST(0.083504600633152432),
    FRAC_CONST(0.085033124980280275),
    FRAC_CONST(0.08656144923625117),
    FRAC_CONST(0.088089569804770507),
    FRAC_CONST(0.089617483090022959),
    FRAC_CONST(0.091145185496681005),
    FRAC_CONST(0.09267267342991331),
    FRAC_CONST(0.094199943295393204),
    FRAC_CONST(0.095726991499307162),
    FRAC_CONST(0.097253814448363271),
    FRAC_CONST(0.098780408549799623),
    FRAC_CONST(0.10030677021139286),
    FRAC_CONST(0.10183289584146653),
    FRAC_CONST(0.10335878184889961),
    FRAC_CONST(0.10488442464313497),
    FRAC_CONST(0.10640982063418768),
    FRAC_CONST(0.10793496623265365),
    FRAC_CONST(0.10945985784971798),
    FRAC_CONST(0.11098449189716339),
    FRAC_CONST(0.11250886478737869),
    FRAC_CONST(0.1140329729333672),
    FRAC_CONST(0.11555681274875526),
    FRAC_CONST(0.11708038064780059),
    FRAC_CONST(0.11860367304540072),
    FRAC_CONST(0.1201266863571015),
    FRAC_CONST(0.12164941699910553),
    FRAC_CONST(0.12317186138828048),
    FRAC_CONST(0.12469401594216764),
    FRAC_CONST(0.12621587707899035),
    FRAC_CONST(0.12773744121766231),
    FRAC_CONST(0.12925870477779614),
    FRAC_CONST(0.13077966417971171),
    FRAC_CONST(0.13230031584444465),
    FRAC_CONST(0.13382065619375472),
    FRAC_CONST(0.13534068165013421),
    FRAC_CONST(0.13686038863681638),
    FRAC_CONST(0.13837977357778389),
    FRAC_CONST(0.13989883289777721),
    FRAC_CONST(0.14141756302230302),
    FRAC_CONST(0.14293596037764267),
    FRAC_CONST(0.14445402139086047),
    FRAC_CONST(0.14597174248981221),
    FRAC_CONST(0.14748912010315357),
    FRAC_CONST(0.14900615066034845),
    FRAC_CONST(0.1505228305916774),
    FRAC_CONST(0.15203915632824605),
    FRAC_CONST(0.15355512430199345),
    FRAC_CONST(0.15507073094570051),
    FRAC_CONST(0.15658597269299843),
    FRAC_CONST(0.15810084597837698),
    FRAC_CONST(0.15961534723719306),
    FRAC_CONST(0.16112947290567881),
    FRAC_CONST(0.16264321942095031),
    FRAC_CONST(0.16415658322101581),
    FRAC_CONST(0.16566956074478412),
    FRAC_CONST(0.16718214843207294),
    FRAC_CONST(0.16869434272361733),
    FRAC_CONST(0.17020614006107807),
    FRAC_CONST(0.17171753688704997),
    FRAC_CONST(0.17322852964507032),
    FRAC_CONST(0.1747391147796272),
    FRAC_CONST(0.17624928873616788),
    FRAC_CONST(0.17775904796110717),
    FRAC_CONST(0.17926838890183575),
    FRAC_CONST(0.18077730800672859),
    FRAC_CONST(0.1822858017251533),
    FRAC_CONST(0.18379386650747845),
    FRAC_CONST(0.1853014988050819),
    FRAC_CONST(0.18680869507035927),
    FRAC_CONST(0.18831545175673212),
    FRAC_CONST(0.18982176531865641),
    FRAC_CONST(0.1913276322116309),
    FRAC_CONST(0.19283304889220523),
    FRAC_CONST(0.1943380118179886),
    FRAC_CONST(0.19584251744765785),
    FRAC_CONST(0.19734656224096592),
    FRAC_CONST(0.19885014265875009),
    FRAC_CONST(0.20035325516294045),
    FRAC_CONST(0.20185589621656805),
    FRAC_CONST(0.20335806228377332),
    FRAC_CONST(0.20485974982981442),
    FRAC_CONST(0.20636095532107551),
    FRAC_CONST(0.20786167522507507),
    FRAC_CONST(0.20936190601047416),
    FRAC_CONST(0.21086164414708486),
    FRAC_CONST(0.21236088610587842),
    FRAC_CONST(0.21385962835899375),
    FRAC_CONST(0.21535786737974555),
    FRAC_CONST(0.21685559964263262),
    FRAC_CONST(0.21835282162334632),
    FRAC_CONST(0.2198495297987787),
    FRAC_CONST(0.22134572064703081),
    FRAC_CONST(0.22284139064742112),
    FRAC_CONST(0.2243365362804936),
    FRAC_CONST(0.22583115402802617),
    FRAC_CONST(0.22732524037303886),
    FRAC_CONST(0.22881879179980222),
    FRAC_CONST(0.23031180479384544),
    FRAC_CONST(0.23180427584196478),
    FRAC_CONST(0.23329620143223159),
    FRAC_CONST(0.23478757805400097),
    FRAC_CONST(0.23627840219791957),
    FRAC_CONST(0.23776867035593419),
    FRAC_CONST(0.23925837902129998),
    FRAC_CONST(0.24074752468858843),
    FRAC_CONST(0.24223610385369601),
    FRAC_CONST(0.24372411301385216),
    FRAC_CONST(0.24521154866762754),
    FRAC_CONST(0.24669840731494241),
    FRAC_CONST(0.24818468545707478),
    FRAC_CONST(0.24967037959666857),
    FRAC_CONST(0.25115548623774192),
    FRAC_CONST(0.25264000188569552),
    FRAC_CONST(0.25412392304732062),
    FRAC_CONST(0.25560724623080738),
    FRAC_CONST(0.25708996794575312),
    FRAC_CONST(0.25857208470317034),
    FRAC_CONST(0.26005359301549519),
    FRAC_CONST(0.26153448939659552),
    FRAC_CONST(0.263014770361779),
    FRAC_CONST(0.26449443242780163),
    FRAC_CONST(0.26597347211287559),
    FRAC_CONST(0.26745188593667762),
    FRAC_CONST(0.26892967042035726),
    FRAC_CONST(0.27040682208654482),
    FRAC_CONST(0.27188333745935972),
    FRAC_CONST(0.27335921306441868),
    FRAC_CONST(0.27483444542884394),
    FRAC_CONST(0.27630903108127108),
    FRAC_CONST(0.27778296655185769),
    FRAC_CONST(0.27925624837229118),
    FRAC_CONST(0.28072887307579719),
    FRAC_CONST(0.28220083719714756),
    FRAC_CONST(0.28367213727266843),
    FRAC_CONST(0.28514276984024867),
    FRAC_CONST(0.28661273143934779),
    FRAC_CONST(0.28808201861100413),
    FRAC_CONST(0.28955062789784303),
    FRAC_CONST(0.29101855584408509),
    FRAC_CONST(0.29248579899555388),
    FRAC_CONST(0.29395235389968466),
    FRAC_CONST(0.29541821710553201),
    FRAC_CONST(0.29688338516377827),
    FRAC_CONST(0.2983478546267414),
    FRAC_CONST(0.29981162204838335),
    FRAC_CONST(0.30127468398431795),
    FRAC_CONST(0.30273703699181914),
    FRAC_CONST(0.30419867762982911),
    FRAC_CONST(0.30565960245896612),
    FRAC_CONST(0.3071198080415331),
    FRAC_CONST(0.30857929094152509),
    FRAC_CONST(0.31003804772463789),
    FRAC_CONST(0.31149607495827591),
    FRAC_CONST(0.3129533692115602),
    FRAC_CONST(0.31440992705533666),
    FRAC_CONST(0.31586574506218396),
    FRAC_CONST(0.31732081980642174),
    FRAC_CONST(0.31877514786411848),
    FRAC_CONST(0.32022872581309986),
    FRAC_CONST(0.32168155023295658),
    FRAC_CONST(0.32313361770505233),
    FRAC_CONST(0.32458492481253215),
    FRAC_CONST(0.32603546814033024),
    FRAC_CONST(0.327485244275178),
    FRAC_CONST(0.3289342498056122),
    FRAC_CONST(0.33038248132198278),
    FRAC_CONST(0.33182993541646111),
    FRAC_CONST(0.33327660868304793),
    FRAC_CONST(0.33472249771758122),
    FRAC_CONST(0.33616759911774452),
    FRAC_CONST(0.33761190948307462),
    FRAC_CONST(0.33905542541496964),
    FRAC_CONST(0.34049814351669716),
    FRAC_CONST(0.34194006039340219),
    FRAC_CONST(0.34338117265211504),
    FRAC_CONST(0.34482147690175929),
    FRAC_CONST(0.34626096975316001),
    FRAC_CONST(0.34769964781905138),
    FRAC_CONST(0.34913750771408497),
    FRAC_CONST(0.35057454605483751),
    FRAC_CONST(0.35201075945981908),
    FRAC_CONST(0.35344614454948081),
    FRAC_CONST(0.35488069794622279),
    FRAC_CONST(0.35631441627440241),
    FRAC_CONST(0.3577472961603419),
    FRAC_CONST(0.3591793342323365),
    FRAC_CONST(0.36061052712066227),
    FRAC_CONST(0.36204087145758418),
    FRAC_CONST(0.36347036387736376),
    FRAC_CONST(0.36489900101626732),
    FRAC_CONST(0.36632677951257359),
    FRAC_CONST(0.36775369600658198),
    FRAC_CONST(0.36917974714062002),
    FRAC_CONST(0.37060492955905167),
    FRAC_CONST(0.37202923990828501),
    FRAC_CONST(0.3734526748367803),
    FRAC_CONST(0.37487523099505754),
    FRAC_CONST(0.37629690503570479),
    FRAC_CONST(0.37771769361338564),
    FRAC_CONST(0.37913759338484732),
    FRAC_CONST(0.38055660100892852),
    FRAC_CONST(0.38197471314656722),
    FRAC_CONST(0.38339192646080866),
    FRAC_CONST(0.38480823761681288),
    FRAC_CONST(0.38622364328186298),
    FRAC_CONST(0.38763814012537273),
    FRAC_CONST(0.38905172481889438),
    FRAC_CONST(0.39046439403612659),
    FRAC_CONST(0.39187614445292235),
    FRAC_CONST(0.3932869727472964),
    FRAC_CONST(0.39469687559943356),
    FRAC_CONST(0.39610584969169627),
    FRAC_CONST(0.39751389170863233),
    FRAC_CONST(0.39892099833698291),
    FRAC_CONST(0.40032716626569009),
    FRAC_CONST(0.40173239218590501),
    FRAC_CONST(0.4031366727909953),
    FRAC_CONST(0.404540004776553),
    FRAC_CONST(0.40594238484040251),
    FRAC_CONST(0.40734380968260797),
    FRAC_CONST(0.40874427600548136),
    FRAC_CONST(0.41014378051359024),
    FRAC_CONST(0.41154231991376522),
    FRAC_CONST(0.41293989091510808),
    FRAC_CONST(0.4143364902289991),
    FRAC_CONST(0.41573211456910536),
    FRAC_CONST(0.41712676065138787),
    FRAC_CONST(0.4185204251941097),
    FRAC_CONST(0.41991310491784362),
    FRAC_CONST(0.42130479654547964),
    FRAC_CONST(0.42269549680223295),
    FRAC_CONST(0.42408520241565156),
    FRAC_CONST(0.4254739101156238),
    FRAC_CONST(0.42686161663438643),
    FRAC_CONST(0.42824831870653196),
    FRAC_CONST(0.42963401306901638),
    FRAC_CONST(0.43101869646116703),
    FRAC_CONST(0.43240236562469014),
    FRAC_CONST(0.43378501730367852),
    FRAC_CONST(0.43516664824461926),
    FRAC_CONST(0.4365472551964012),
    FRAC_CONST(0.43792683491032286),
    FRAC_CONST(0.43930538414009995),
    FRAC_CONST(0.4406828996418729),
    FRAC_CONST(0.4420593781742147),
    FRAC_CONST(0.44343481649813848),
    FRAC_CONST(0.44480921137710488),
    FRAC_CONST(0.44618255957703007),
    FRAC_CONST(0.44755485786629301),
    FRAC_CONST(0.44892610301574326),
    FRAC_CONST(0.45029629179870861),
    FRAC_CONST(0.45166542099100249),
    FRAC_CONST(0.45303348737093158),
    FRAC_CONST(0.45440048771930358),
    FRAC_CONST(0.45576641881943464),
    FRAC_CONST(0.45713127745715698),
    FRAC_CONST(0.45849506042082627),
    FRAC_CONST(0.45985776450132954),
    FRAC_CONST(0.46121938649209238),
    FRAC_CONST(0.46257992318908681),
    FRAC_CONST(0.46393937139083852),
    FRAC_CONST(0.4652977278984346),
    FRAC_CONST(0.46665498951553092),
    FRAC_CONST(0.46801115304835983),
    FRAC_CONST(0.46936621530573752),
    FRAC_CONST(0.4707201730990716),
    FRAC_CONST(0.47207302324236866),
    FRAC_CONST(0.47342476255224153),
    FRAC_CONST(0.47477538784791712),
    FRAC_CONST(0.47612489595124358),
    FRAC_CONST(0.47747328368669806),
    FRAC_CONST(0.47882054788139389),
    FRAC_CONST(0.48016668536508839),
    FRAC_CONST(0.48151169297018986),
    FRAC_CONST(0.48285556753176567),
    FRAC_CONST(0.48419830588754903),
    FRAC_CONST(0.48553990487794696),
    FRAC_CONST(0.48688036134604734),
    FRAC_CONST(0.48821967213762679),
    FRAC_CONST(0.48955783410115744),
    FRAC_CONST(0.49089484408781509),
    FRAC_CONST(0.49223069895148602),
    FRAC_CONST(0.49356539554877477),
    FRAC_CONST(0.49489893073901126),
    FRAC_CONST(0.49623130138425825),
    FRAC_CONST(0.49756250434931915),
    FRAC_CONST(0.49889253650174459),
    FRAC_CONST(0.50022139471184068),
    FRAC_CONST(0.50154907585267539),
    FRAC_CONST(0.50287557680008699),
    FRAC_CONST(0.50420089443269034),
    FRAC_CONST(0.50552502563188539),
    FRAC_CONST(0.50684796728186321),
    FRAC_CONST(0.5081697162696146),
    FRAC_CONST(0.50949026948493636),
    FRAC_CONST(0.51080962382043904),
    FRAC_CONST(0.51212777617155469),
    FRAC_CONST(0.51344472343654346),
    FRAC_CONST(0.5147604625165012),
    FRAC_CONST(0.51607499031536663),
    FRAC_CONST(0.51738830373992906),
    FRAC_CONST(0.51870039969983495),
    FRAC_CONST(0.52001127510759604),
    FRAC_CONST(0.52132092687859566),
    FRAC_CONST(0.52262935193109661),
    FRAC_CONST(0.5239365471862486),
    FRAC_CONST(0.52524250956809471),
    FRAC_CONST(0.52654723600357944),
    FRAC_CONST(0.52785072342255523),
    FRAC_CONST(0.52915296875779061),
    FRAC_CONST(0.53045396894497632),
    FRAC_CONST(0.53175372092273332),
    FRAC_CONST(0.53305222163261945),
    FRAC_CONST(0.53434946801913752),
    FRAC_CONST(0.53564545702974109),
    FRAC_CONST(0.53694018561484291),
    FRAC_CONST(0.5382336507278217),
    FRAC_CONST(0.53952584932502889),
    FRAC_CONST(0.54081677836579667),
    FRAC_CONST(0.54210643481244392),
    FRAC_CONST(0.5433948156302848),
    FRAC_CONST(0.54468191778763453),
    FRAC_CONST(0.54596773825581757),
    FRAC_CONST(0.54725227400917409),
    FRAC_CONST(0.54853552202506739),
    FRAC_CONST(0.54981747928389091),
    FRAC_CONST(0.55109814276907543),
    FRAC_CONST(0.55237750946709607),
    FRAC_CONST(0.55365557636747931),
    FRAC_CONST(0.55493234046281037),
    FRAC_CONST(0.55620779874873993),
    FRAC_CONST(0.55748194822399155),
    FRAC_CONST(0.55875478589036831),
    FRAC_CONST(0.56002630875276038),
    FRAC_CONST(0.56129651381915147),
    FRAC_CONST(0.56256539810062656),
    FRAC_CONST(0.56383295861137817),
    FRAC_CONST(0.56509919236871398),
    FRAC_CONST(0.56636409639306384),
    FRAC_CONST(0.56762766770798623),
    FRAC_CONST(0.56888990334017586),
    FRAC_CONST(0.5701508003194703),
    FRAC_CONST(0.57141035567885723),
    FRAC_CONST(0.57266856645448116),
    FRAC_CONST(0.57392542968565075),
    FRAC_CONST(0.57518094241484508),
    FRAC_CONST(0.57643510168772183),
    FRAC_CONST(0.5776879045531228),
    FRAC_CONST(0.57893934806308178),
    FRAC_CONST(0.58018942927283168),
    FRAC_CONST(0.58143814524081017),
    FRAC_CONST(0.58268549302866846),
    FRAC_CONST(0.58393146970127618),
    FRAC_CONST(0.58517607232673041),
    FRAC_CONST(0.5864192979763605),
    FRAC_CONST(0.58766114372473666),
    FRAC_CONST(0.58890160664967572),
    FRAC_CONST(0.59014068383224882),
    FRAC_CONST(0.59137837235678758),
    FRAC_CONST(0.59261466931089113),
    FRAC_CONST(0.59384957178543363),
    FRAC_CONST(0.59508307687456996),
    FRAC_CONST(0.59631518167574371),
    FRAC_CONST(0.59754588328969316),
    FRAC_CONST(0.59877517882045872),
    FRAC_CONST(0.60000306537538894),
    FRAC_CONST(0.6012295400651485),
    FRAC_CONST(0.60245460000372375),
    FRAC_CONST(0.60367824230843037),
    FRAC_CONST(0.60490046409991982),
    FRAC_CONST(0.60612126250218612),
    FRAC_CONST(0.60734063464257293),
    FRAC_CONST(0.60855857765177945),
    FRAC_CONST(0.60977508866386843),
    FRAC_CONST(0.61099016481627166),
    FRAC_CONST(0.61220380324979795),
    FRAC_CONST(0.61341600110863859),
    FRAC_CONST(0.61462675554037505),
    FRAC_CONST(0.61583606369598509),
    FRAC_CONST(0.61704392272984976),
    FRAC_CONST(0.61825032979976025),
    FRAC_CONST(0.61945528206692402),
    FRAC_CONST(0.62065877669597214),
    FRAC_CONST(0.62186081085496536),
    FRAC_CONST(0.62306138171540126),
    FRAC_CONST(0.62426048645222065),
    FRAC_CONST(0.62545812224381436),
    FRAC_CONST(0.62665428627202935),
    FRAC_CONST(0.62784897572217646),
    FRAC_CONST(0.629042187783036),
    FRAC_CONST(0.63023391964686437),
    FRAC_CONST(0.63142416850940186),
    FRAC_CONST(0.63261293156987741),
    FRAC_CONST(0.63380020603101728),
    FRAC_CONST(0.63498598909904946),
    FRAC_CONST(0.63617027798371217),
    FRAC_CONST(0.63735306989825913),
    FRAC_CONST(0.63853436205946679),
    FRAC_CONST(0.63971415168764045),
    FRAC_CONST(0.64089243600662138),
    FRAC_CONST(0.64206921224379254),
    FRAC_CONST(0.64324447763008585),
    FRAC_CONST(0.64441822939998838),
    FRAC_CONST(0.64559046479154869),
    FRAC_CONST(0.64676118104638392),
    FRAC_CONST(0.64793037540968534),
    FRAC_CONST(0.64909804513022595),
    FRAC_CONST(0.65026418746036585),
    FRAC_CONST(0.65142879965605982),
    FRAC_CONST(0.65259187897686244),
    FRAC_CONST(0.65375342268593606),
    FRAC_CONST(0.65491342805005603),
    FRAC_CONST(0.6560718923396176),
    FRAC_CONST(0.65722881282864254),
    FRAC_CONST(0.65838418679478505),
    FRAC_CONST(0.65953801151933866),
    FRAC_CONST(0.6606902842872423),
    FRAC_CONST(0.66184100238708687),
    FRAC_CONST(0.66299016311112147),
    FRAC_CONST(0.66413776375526001),
    FRAC_CONST(0.66528380161908718),
    FRAC_CONST(0.66642827400586524),
    FRAC_CONST(0.66757117822254031),
    FRAC_CONST(0.66871251157974798),
    FRAC_CONST(0.66985227139182102),
    FRAC_CONST(0.67099045497679422),
    FRAC_CONST(0.67212705965641173),
    FRAC_CONST(0.67326208275613297),
    FRAC_CONST(0.67439552160513905),
    FRAC_CONST(0.67552737353633852),
    FRAC_CONST(0.67665763588637495),
    FRAC_CONST(0.6777863059956315),
    FRAC_CONST(0.67891338120823841),
    FRAC_CONST(0.68003885887207893),
    FRAC_CONST(0.68116273633879543),
    FRAC_CONST(0.68228501096379557),
    FRAC_CONST(0.68340568010625868),
    FRAC_CONST(0.6845247411291423),
    FRAC_CONST(0.68564219139918747),
    FRAC_CONST(0.68675802828692589),
    FRAC_CONST(0.68787224916668555),
    FRAC_CONST(0.68898485141659704),
    FRAC_CONST(0.69009583241859995),
    FRAC_CONST(0.69120518955844845),
    FRAC_CONST(0.69231292022571822),
    FRAC_CONST(0.69341902181381176),
    FRAC_CONST(0.69452349171996552),
    FRAC_CONST(0.69562632734525487),
    FRAC_CONST(0.6967275260946012),
    FRAC_CONST(0.69782708537677729),
    FRAC_CONST(0.69892500260441415),
    FRAC_CONST(0.70002127519400625),
    FRAC_CONST(0.70111590056591866),
    FRAC_CONST(0.70220887614439187),
    FRAC_CONST(0.70330019935754873),
    FRAC_CONST(0.70438986763740041),
    FRAC_CONST(0.7054778784198521),
    FRAC_CONST(0.70656422914470951),
    FRAC_CONST(0.70764891725568435),
    FRAC_CONST(0.70873194020040065),
    FRAC_CONST(0.70981329543040084),
    FRAC_CONST(0.71089298040115168),
    FRAC_CONST(0.71197099257204999),
    FRAC_CONST(0.71304732940642923),
    FRAC_CONST(0.71412198837156471),
    FRAC_CONST(0.71519496693868001),
    FRAC_CONST(0.71626626258295312),
    FRAC_CONST(0.71733587278352173),
    FRAC_CONST(0.71840379502348972),
    FRAC_CONST(0.71947002678993299),
    FRAC_CONST(0.72053456557390527),
    FRAC_CONST(0.72159740887044366),
    FRAC_CONST(0.72265855417857561),
    FRAC_CONST(0.72371799900132339),
    FRAC_CONST(0.72477574084571128),
    FRAC_CONST(0.72583177722277037),
    FRAC_CONST(0.72688610564754497),
    FRAC_CONST(0.72793872363909862),
    FRAC_CONST(0.72898962872051931),
    FRAC_CONST(0.73003881841892615),
    FRAC_CONST(0.73108629026547423),
    FRAC_CONST(0.73213204179536129),
    FRAC_CONST(0.73317607054783274),
    FRAC_CONST(0.73421837406618817),
    FRAC_CONST(0.73525894989778673),
    FRAC_CONST(0.73629779559405306),
    FRAC_CONST(0.73733490871048279),
    FRAC_CONST(0.73837028680664851),
    FRAC_CONST(0.73940392744620576),
    FRAC_CONST(0.74043582819689802),
    FRAC_CONST(0.74146598663056329),
    FRAC_CONST(0.74249440032313918),
    FRAC_CONST(0.74352106685466912),
    FRAC_CONST(0.74454598380930725),
    FRAC_CONST(0.74556914877532543),
    FRAC_CONST(0.74659055934511731),
    FRAC_CONST(0.74761021311520515),
    FRAC_CONST(0.74862810768624533),
    FRAC_CONST(0.74964424066303348),
    FRAC_CONST(0.75065860965451059),
    FRAC_CONST(0.75167121227376843),
    FRAC_CONST(0.75268204613805523),
    FRAC_CONST(0.75369110886878121),
    FRAC_CONST(0.75469839809152439),
    FRAC_CONST(0.75570391143603588),
    FRAC_CONST(0.75670764653624567),
    FRAC_CONST(0.75770960103026808),
    FRAC_CONST(0.75870977256040739),
    FRAC_CONST(0.75970815877316344),
    FRAC_CONST(0.76070475731923692),
    FRAC_CONST(0.76169956585353527),
    FRAC_CONST(0.76269258203517787),
    FRAC_CONST(0.76368380352750187),
    FRAC_CONST(0.76467322799806714),
    FRAC_CONST(0.76566085311866239),
    FRAC_CONST(0.76664667656531038),
    FRAC_CONST(0.76763069601827327),
    FRAC_CONST(0.76861290916205827),
    FRAC_CONST(0.76959331368542294),
    FRAC_CONST(0.7705719072813807),
    FRAC_CONST(0.7715486876472063),
    FRAC_CONST(0.77252365248444133),
    FRAC_CONST(0.77349679949889905),
    FRAC_CONST(0.77446812640067086),
    FRAC_CONST(0.77543763090413043),
    FRAC_CONST(0.77640531072794039),
    FRAC_CONST(0.7773711635950562),
    FRAC_CONST(0.77833518723273309),
    FRAC_CONST(0.7792973793725303),
    FRAC_CONST(0.78025773775031659),
    FRAC_CONST(0.78121626010627609),
    FRAC_CONST(0.7821729441849129),
    FRAC_CONST(0.78312778773505731),
    FRAC_CONST(0.78408078850986995),
    FRAC_CONST(0.78503194426684808),
    FRAC_CONST(0.78598125276783015),
    FRAC_CONST(0.7869287117790017),
    FRAC_CONST(0.78787431907090011),
    FRAC_CONST(0.78881807241842017),
    FRAC_CONST(0.78975996960081907),
    FRAC_CONST(0.79070000840172161),
    FRAC_CONST(0.79163818660912577),
    FRAC_CONST(0.79257450201540758),
    FRAC_CONST(0.79350895241732666),
    FRAC_CONST(0.79444153561603059),
    FRAC_CONST(0.79537224941706119),
    FRAC_CONST(0.79630109163035911),
    FRAC_CONST(0.7972280600702687),
    FRAC_CONST(0.79815315255554375),
    FRAC_CONST(0.79907636690935235),
    FRAC_CONST(0.79999770095928191),
    FRAC_CONST(0.8009171525373443),
    FRAC_CONST(0.80183471947998131),
    FRAC_CONST(0.80275039962806916),
    FRAC_CONST(0.80366419082692409),
    FRAC_CONST(0.804576090926307),
    FRAC_CONST(0.80548609778042912),
    FRAC_CONST(0.80639420924795624),
    FRAC_CONST(0.80730042319201445),
    FRAC_CONST(0.80820473748019472),
    FRAC_CONST(0.80910714998455813),
    FRAC_CONST(0.81000765858164114),
    FRAC_CONST(0.81090626115245967),
    FRAC_CONST(0.81180295558251536),
    FRAC_CONST(0.81269773976179949),
    FRAC_CONST(0.81359061158479851),
    FRAC_CONST(0.81448156895049861),
    FRAC_CONST(0.81537060976239129),
    FRAC_CONST(0.81625773192847739),
    FRAC_CONST(0.81714293336127297),
    FRAC_CONST(0.81802621197781344),
    FRAC_CONST(0.81890756569965895),
    FRAC_CONST(0.81978699245289899),
    FRAC_CONST(0.82066449016815746),
    FRAC_CONST(0.82154005678059761),
    FRAC_CONST(0.82241369022992639),
    FRAC_CONST(0.82328538846040011),
    FRAC_CONST(0.82415514942082857),
    FRAC_CONST(0.82502297106458022),
    FRAC_CONST(0.82588885134958678),
    FRAC_CONST(0.82675278823834852),
    FRAC_CONST(0.8276147796979384),
    FRAC_CONST(0.82847482370000713),
    FRAC_CONST(0.82933291822078825),
    FRAC_CONST(0.83018906124110237),
    FRAC_CONST(0.83104325074636232),
    FRAC_CONST(0.83189548472657759),
    FRAC_CONST(0.83274576117635946),
    FRAC_CONST(0.83359407809492514),
    FRAC_CONST(0.83444043348610319),
    FRAC_CONST(0.83528482535833737),
    FRAC_CONST(0.83612725172469216),
    FRAC_CONST(0.83696771060285702),
    FRAC_CONST(0.83780620001515094),
    FRAC_CONST(0.8386427179885273),
    FRAC_CONST(0.83947726255457855),
    FRAC_CONST(0.84030983174954077),
    FRAC_CONST(0.84114042361429808),
    FRAC_CONST(0.84196903619438768),
    FRAC_CONST(0.84279566754000412),
    FRAC_CONST(0.84362031570600404),
    FRAC_CONST(0.84444297875191066),
    FRAC_CONST(0.84526365474191822),
    FRAC_CONST(0.84608234174489694),
    FRAC_CONST(0.84689903783439735),
    FRAC_CONST(0.84771374108865427),
    FRAC_CONST(0.84852644959059265),
    FRAC_CONST(0.84933716142783067),
    FRAC_CONST(0.85014587469268521),
    FRAC_CONST(0.85095258748217573),
    FRAC_CONST(0.85175729789802912),
    FRAC_CONST(0.85256000404668397),
    FRAC_CONST(0.85336070403929543),
    FRAC_CONST(0.85415939599173873),
    FRAC_CONST(0.85495607802461482),
    FRAC_CONST(0.85575074826325392),
    FRAC_CONST(0.85654340483771996),
    FRAC_CONST(0.85733404588281559),
    FRAC_CONST(0.85812266953808602),
    FRAC_CONST(0.8589092739478239),
    FRAC_CONST(0.85969385726107261),
    FRAC_CONST(0.86047641763163207),
    FRAC_CONST(0.86125695321806206),
    FRAC_CONST(0.86203546218368721),
    FRAC_CONST(0.86281194269660033),
    FRAC_CONST(0.86358639292966799),
    FRAC_CONST(0.86435881106053403),
    FRAC_CONST(0.86512919527162369),
    FRAC_CONST(0.86589754375014882),
    FRAC_CONST(0.86666385468811102),
    FRAC_CONST(0.86742812628230692),
    FRAC_CONST(0.86819035673433131),
    FRAC_CONST(0.86895054425058238),
    FRAC_CONST(0.86970868704226556),
    FRAC_CONST(0.87046478332539767),
    FRAC_CONST(0.8712188313208109),
    FRAC_CONST(0.8719708292541577),
    FRAC_CONST(0.8727207753559143),
    FRAC_CONST(0.87346866786138488),
    FRAC_CONST(0.8742145050107063),
    FRAC_CONST(0.87495828504885154),
    FRAC_CONST(0.8757000062256346),
    FRAC_CONST(0.87643966679571361),
    FRAC_CONST(0.87717726501859594),
    FRAC_CONST(0.87791279915864173),
    FRAC_CONST(0.87864626748506813),
    FRAC_CONST(0.87937766827195318),
    FRAC_CONST(0.88010699979824036),
    FRAC_CONST(0.88083426034774204),
    FRAC_CONST(0.88155944820914378),
    FRAC_CONST(0.8822825616760086),
    FRAC_CONST(0.88300359904678072),
    FRAC_CONST(0.88372255862478966),
    FRAC_CONST(0.8844394387182537),
    FRAC_CONST(0.88515423764028511),
    FRAC_CONST(0.88586695370889279),
    FRAC_CONST(0.88657758524698704),
    FRAC_CONST(0.88728613058238315),
    FRAC_CONST(0.88799258804780556),
    FRAC_CONST(0.88869695598089171),
    FRAC_CONST(0.88939923272419552),
    FRAC_CONST(0.89009941662519221),
    FRAC_CONST(0.89079750603628149),
    FRAC_CONST(0.89149349931479138),
    FRAC_CONST(0.89218739482298248),
    FRAC_CONST(0.89287919092805168),
    FRAC_CONST(0.89356888600213602),
    FRAC_CONST(0.89425647842231604),
    FRAC_CONST(0.89494196657062075),
    FRAC_CONST(0.89562534883403),
    FRAC_CONST(0.89630662360447966),
    FRAC_CONST(0.89698578927886397),
    FRAC_CONST(0.89766284425904075),
    FRAC_CONST(0.89833778695183419),
    FRAC_CONST(0.89901061576903907),
    FRAC_CONST(0.89968132912742393),
    FRAC_CONST(0.9003499254487356),
    FRAC_CONST(0.90101640315970233),
    FRAC_CONST(0.90168076069203773),
    FRAC_CONST(0.9023429964824442),
    FRAC_CONST(0.90300310897261704),
    FRAC_CONST(0.90366109660924798),
    FRAC_CONST(0.90431695784402832),
    FRAC_CONST(0.90497069113365325),
    FRAC_CONST(0.90562229493982516),
    FRAC_CONST(0.90627176772925766),
    FRAC_CONST(0.90691910797367803),
    FRAC_CONST(0.90756431414983252),
    FRAC_CONST(0.9082073847394887),
    FRAC_CONST(0.90884831822943912),
    FRAC_CONST(0.90948711311150543),
    FRAC_CONST(0.91012376788254157),
    FRAC_CONST(0.91075828104443757),
    FRAC_CONST(0.91139065110412232),
    FRAC_CONST(0.91202087657356823),
    FRAC_CONST(0.9126489559697939),
    FRAC_CONST(0.91327488781486776),
    FRAC_CONST(0.91389867063591168),
    FRAC_CONST(0.91452030296510445),
    FRAC_CONST(0.91513978333968526),
    FRAC_CONST(0.91575711030195672),
    FRAC_CONST(0.91637228239928914),
    FRAC_CONST(0.91698529818412289),
    FRAC_CONST(0.91759615621397295),
    FRAC_CONST(0.9182048550514309),
    FRAC_CONST(0.91881139326416994),
    FRAC_CONST(0.91941576942494696),
    FRAC_CONST(0.92001798211160657),
    FRAC_CONST(0.92061802990708386),
    FRAC_CONST(0.92121591139940873),
    FRAC_CONST(0.92181162518170812),
    FRAC_CONST(0.92240516985220988),
    FRAC_CONST(0.92299654401424625),
    FRAC_CONST(0.92358574627625656),
    FRAC_CONST(0.9241727752517912),
    FRAC_CONST(0.92475762955951391),
    FRAC_CONST(0.9253403078232062),
    FRAC_CONST(0.92592080867176996),
    FRAC_CONST(0.92649913073923051),
    FRAC_CONST(0.9270752726647401),
    FRAC_CONST(0.92764923309258118),
    FRAC_CONST(0.92822101067216944),
    FRAC_CONST(0.92879060405805702),
    FRAC_CONST(0.9293580119099355),
    FRAC_CONST(0.92992323289263956),
    FRAC_CONST(0.93048626567614978),
    FRAC_CONST(0.93104710893559517),
    FRAC_CONST(0.93160576135125783),
    FRAC_CONST(0.93216222160857432),
    FRAC_CONST(0.93271648839814025),
    FRAC_CONST(0.93326856041571205),
    FRAC_CONST(0.93381843636221096),
    FRAC_CONST(0.9343661149437259),
    FRAC_CONST(0.93491159487151609),
    FRAC_CONST(0.93545487486201462),
    FRAC_CONST(0.9359959536368313),
    FRAC_CONST(0.9365348299227555),
    FRAC_CONST(0.93707150245175919),
    FRAC_CONST(0.93760596996099999),
    FRAC_CONST(0.93813823119282436),
    FRAC_CONST(0.93866828489477017),
    FRAC_CONST(0.9391961298195699),
    FRAC_CONST(0.93972176472515334),
    FRAC_CONST(0.94024518837465088),
    FRAC_CONST(0.94076639953639607),
    FRAC_CONST(0.94128539698392866),
    FRAC_CONST(0.94180217949599765),
    FRAC_CONST(0.94231674585656378),
    FRAC_CONST(0.94282909485480271),
    FRAC_CONST(0.94333922528510772),
    FRAC_CONST(0.94384713594709269),
    FRAC_CONST(0.94435282564559475),
    FRAC_CONST(0.94485629319067721),
    FRAC_CONST(0.94535753739763229),
    FRAC_CONST(0.94585655708698391),
    FRAC_CONST(0.94635335108449059),
    FRAC_CONST(0.946847918221148),
    FRAC_CONST(0.94734025733319194),
    FRAC_CONST(0.94783036726210101),
    FRAC_CONST(0.94831824685459909),
    FRAC_CONST(0.94880389496265838),
    FRAC_CONST(0.94928731044350201),
    FRAC_CONST(0.94976849215960668),
    FRAC_CONST(0.95024743897870523),
    FRAC_CONST(0.95072414977378961),
    FRAC_CONST(0.95119862342311323),
    FRAC_CONST(0.95167085881019386),
    FRAC_CONST(0.95214085482381583),
    FRAC_CONST(0.95260861035803324),
    FRAC_CONST(0.9530741243121722),
    FRAC_CONST(0.95353739559083328),
    FRAC_CONST(0.95399842310389449),
    FRAC_CONST(0.95445720576651349),
    FRAC_CONST(0.95491374249913052),
    FRAC_CONST(0.95536803222747024),
    FRAC_CONST(0.95582007388254542),
    FRAC_CONST(0.95626986640065814),
    FRAC_CONST(0.95671740872340305),
    FRAC_CONST(0.9571626997976701),
    FRAC_CONST(0.95760573857564624),
    FRAC_CONST(0.9580465240148186),
    FRAC_CONST(0.9584850550779761),
    FRAC_CONST(0.95892133073321306),
    FRAC_CONST(0.95935534995393079),
    FRAC_CONST(0.9597871117188399),
    FRAC_CONST(0.96021661501196343),
    FRAC_CONST(0.96064385882263847),
    FRAC_CONST(0.96106884214551935),
    FRAC_CONST(0.961491563980579),
    FRAC_CONST(0.9619120233331121),
    FRAC_CONST(0.9623302192137374),
    FRAC_CONST(0.96274615063839941),
    FRAC_CONST(0.96315981662837136),
    FRAC_CONST(0.96357121621025721),
    FRAC_CONST(0.96398034841599411),
    FRAC_CONST(0.96438721228285429),
    FRAC_CONST(0.9647918068534479),
    FRAC_CONST(0.96519413117572472),
    FRAC_CONST(0.96559418430297683),
    FRAC_CONST(0.96599196529384057),
    FRAC_CONST(0.96638747321229879),
    FRAC_CONST(0.96678070712768327),
    FRAC_CONST(0.96717166611467664),
    FRAC_CONST(0.96756034925331436),
    FRAC_CONST(0.9679467556289878),
    FRAC_CONST(0.9683308843324453),
    FRAC_CONST(0.96871273445979478),
    FRAC_CONST(0.9690923051125061),
    FRAC_CONST(0.96946959539741295),
    FRAC_CONST(0.96984460442671483),
    FRAC_CONST(0.97021733131797916),
    FRAC_CONST(0.97058777519414363),
    FRAC_CONST(0.97095593518351797),
    FRAC_CONST(0.97132181041978616),
    FRAC_CONST(0.97168540004200854),
    FRAC_CONST(0.9720467031946235),
    FRAC_CONST(0.97240571902744977),
    FRAC_CONST(0.97276244669568857),
    FRAC_CONST(0.97311688535992513),
    FRAC_CONST(0.97346903418613095),
    FRAC_CONST(0.9738188923456661),
    FRAC_CONST(0.97416645901528032),
    FRAC_CONST(0.97451173337711572),
    FRAC_CONST(0.97485471461870843),
    FRAC_CONST(0.97519540193299037),
    FRAC_CONST(0.97553379451829136),
    FRAC_CONST(0.97586989157834103),
    FRAC_CONST(0.97620369232227056),
    FRAC_CONST(0.97653519596461447),
    FRAC_CONST(0.97686440172531264),
    FRAC_CONST(0.97719130882971228),
    FRAC_CONST(0.97751591650856928),
    FRAC_CONST(0.97783822399805043),
    FRAC_CONST(0.97815823053973505),
    FRAC_CONST(0.97847593538061683),
    FRAC_CONST(0.97879133777310567),
    FRAC_CONST(0.97910443697502925),
    FRAC_CONST(0.97941523224963478),
    FRAC_CONST(0.97972372286559117),
    FRAC_CONST(0.98002990809698998),
    FRAC_CONST(0.98033378722334796),
    FRAC_CONST(0.98063535952960812),
    FRAC_CONST(0.98093462430614164),
    FRAC_CONST(0.98123158084874973),
    FRAC_CONST(0.98152622845866466),
    FRAC_CONST(0.9818185664425525),
    FRAC_CONST(0.98210859411251361),
    FRAC_CONST(0.98239631078608469),
    FRAC_CONST(0.98268171578624086),
    FRAC_CONST(0.98296480844139644),
    FRAC_CONST(0.98324558808540707),
    FRAC_CONST(0.98352405405757126),
    FRAC_CONST(0.98380020570263149),
    FRAC_CONST(0.98407404237077645),
    FRAC_CONST(0.9843455634176419),
    FRAC_CONST(0.9846147682043126),
    FRAC_CONST(0.9848816560973237),
    FRAC_CONST(0.98514622646866223),
    FRAC_CONST(0.98540847869576842),
    FRAC_CONST(0.98566841216153755),
    FRAC_CONST(0.98592602625432113),
    FRAC_CONST(0.98618132036792827),
    FRAC_CONST(0.98643429390162707),
    FRAC_CONST(0.98668494626014669),
    FRAC_CONST(0.98693327685367771),
    FRAC_CONST(0.98717928509787434),
    FRAC_CONST(0.98742297041385541),
    FRAC_CONST(0.98766433222820571),
    FRAC_CONST(0.98790336997297779),
    FRAC_CONST(0.98814008308569257),
    FRAC_CONST(0.98837447100934128),
    FRAC_CONST(0.98860653319238645),
    FRAC_CONST(0.98883626908876354),
    FRAC_CONST(0.98906367815788154),
    FRAC_CONST(0.98928875986462517),
    FRAC_CONST(0.98951151367935519),
    FRAC_CONST(0.98973193907791057),
    FRAC_CONST(0.98995003554160899),
    FRAC_CONST(0.9901658025572484),
    FRAC_CONST(0.99037923961710816),
    FRAC_CONST(0.99059034621895015),
    FRAC_CONST(0.99079912186602037),
    FRAC_CONST(0.99100556606704937),
    FRAC_CONST(0.99120967833625406),
    FRAC_CONST(0.99141145819333854),
    FRAC_CONST(0.99161090516349537),
    FRAC_CONST(0.99180801877740643),
    FRAC_CONST(0.99200279857124452),
    FRAC_CONST(0.99219524408667392),
    FRAC_CONST(0.99238535487085167),
    FRAC_CONST(0.99257313047642881),
    FRAC_CONST(0.99275857046155114),
    FRAC_CONST(0.99294167438986047),
    FRAC_CONST(0.99312244183049558),
    FRAC_CONST(0.99330087235809328),
    FRAC_CONST(0.99347696555278919),
    FRAC_CONST(0.99365072100021912),
    FRAC_CONST(0.99382213829151966),
    FRAC_CONST(0.99399121702332938),
    FRAC_CONST(0.99415795679778973),
    FRAC_CONST(0.99432235722254581),
    FRAC_CONST(0.9944844179107476),
    FRAC_CONST(0.99464413848105071),
    FRAC_CONST(0.99480151855761711),
    FRAC_CONST(0.99495655777011638),
    FRAC_CONST(0.99510925575372611),
    FRAC_CONST(0.99525961214913339),
    FRAC_CONST(0.9954076266025349),
    FRAC_CONST(0.99555329876563847),
    FRAC_CONST(0.99569662829566352),
    FRAC_CONST(0.99583761485534161),
    FRAC_CONST(0.99597625811291779),
    FRAC_CONST(0.99611255774215113),
    FRAC_CONST(0.99624651342231552),
    FRAC_CONST(0.99637812483820021),
    FRAC_CONST(0.99650739168011082),
    FRAC_CONST(0.9966343136438699),
    FRAC_CONST(0.996758890430818),
    FRAC_CONST(0.99688112174781385),
    FRAC_CONST(0.99700100730723529),
    FRAC_CONST(0.99711854682697998),
    FRAC_CONST(0.99723374003046616),
    FRAC_CONST(0.99734658664663323),
    FRAC_CONST(0.99745708640994191),
    FRAC_CONST(0.99756523906037575),
    FRAC_CONST(0.997671044343441),
    FRAC_CONST(0.99777450201016782),
    FRAC_CONST(0.99787561181711015),
    FRAC_CONST(0.99797437352634699),
    FRAC_CONST(0.99807078690548234),
    FRAC_CONST(0.99816485172764624),
    FRAC_CONST(0.99825656777149518),
    FRAC_CONST(0.99834593482121237),
    FRAC_CONST(0.99843295266650844),
    FRAC_CONST(0.99851762110262221),
    FRAC_CONST(0.99859993993032037),
    FRAC_CONST(0.99867990895589909),
    FRAC_CONST(0.99875752799118334),
    FRAC_CONST(0.99883279685352799),
    FRAC_CONST(0.99890571536581829),
    FRAC_CONST(0.99897628335646982),
    FRAC_CONST(0.99904450065942929),
    FRAC_CONST(0.99911036711417489),
    FRAC_CONST(0.99917388256571638),
    FRAC_CONST(0.99923504686459585),
    FRAC_CONST(0.99929385986688779),
    FRAC_CONST(0.99935032143419944),
    FRAC_CONST(0.9994044314336713),
    FRAC_CONST(0.99945618973797734),
    FRAC_CONST(0.99950559622532531),
    FRAC_CONST(0.99955265077945699),
    FRAC_CONST(0.99959735328964838),
    FRAC_CONST(0.9996397036507102),
    FRAC_CONST(0.99967970176298793),
    FRAC_CONST(0.99971734753236219),
    FRAC_CONST(0.99975264087024884),
    FRAC_CONST(0.99978558169359921),
    FRAC_CONST(0.99981616992490041),
    FRAC_CONST(0.99984440549217524),
    FRAC_CONST(0.99987028832898295),
    FRAC_CONST(0.99989381837441849),
    FRAC_CONST(0.99991499557311347),
    FRAC_CONST(0.999933819875236),
    FRAC_CONST(0.99995029123649048),
    FRAC_CONST(0.99996440961811828),
    FRAC_CONST(0.99997617498689761),
    FRAC_CONST(0.9999855873151432),
    FRAC_CONST(0.99999264658070719),
    FRAC_CONST(0.99999735276697821),
    FRAC_CONST(0.99999970586288223)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t sine_long_960[] =
{
    FRAC_CONST(0.00081812299560725323),
    FRAC_CONST(0.0024543667964602917),
    FRAC_CONST(0.0040906040262347889),
    FRAC_CONST(0.0057268303042312674),
    FRAC_CONST(0.0073630412497795667),
    FRAC_CONST(0.0089992324822505774),
    FRAC_CONST(0.010635399621067975),
    FRAC_CONST(0.012271538285719924),
    FRAC_CONST(0.013907644095770845),
    FRAC_CONST(0.015543712670873098),
    FRAC_CONST(0.017179739630778748),
    FRAC_CONST(0.018815720595351273),
    FRAC_CONST(0.020451651184577292),
    FRAC_CONST(0.022087527018578291),
    FRAC_CONST(0.023723343717622358),
    FRAC_CONST(0.025359096902135895),
    FRAC_CONST(0.02699478219271537),
    FRAC_CONST(0.028630395210139003),
    FRAC_CONST(0.030265931575378519),
    FRAC_CONST(0.031901386909610863),
    FRAC_CONST(0.033536756834229922),
    FRAC_CONST(0.035172036970858266),
    FRAC_CONST(0.036807222941358832),
    FRAC_CONST(0.038442310367846677),
    FRAC_CONST(0.040077294872700696),
    FRAC_CONST(0.041712172078575326),
    FRAC_CONST(0.043346937608412288),
    FRAC_CONST(0.044981587085452281),
    FRAC_CONST(0.046616116133246711),
    FRAC_CONST(0.048250520375669431),
    FRAC_CONST(0.049884795436928406),
    FRAC_CONST(0.051518936941577477),
    FRAC_CONST(0.053152940514528055),
    FRAC_CONST(0.05478680178106083),
    FRAC_CONST(0.056420516366837495),
    FRAC_CONST(0.05805407989791244),
    FRAC_CONST(0.059687488000744485),
    FRAC_CONST(0.061320736302208578),
    FRAC_CONST(0.062953820429607482),
    FRAC_CONST(0.064586736010683557),
    FRAC_CONST(0.066219478673630344),
    FRAC_CONST(0.06785204404710439),
    FRAC_CONST(0.069484427760236861),
    FRAC_CONST(0.071116625442645326),
    FRAC_CONST(0.072748632724445372),
    FRAC_CONST(0.07438044523626236),
    FRAC_CONST(0.076012058609243122),
    FRAC_CONST(0.077643468475067631),
    FRAC_CONST(0.079274670465960706),
    FRAC_CONST(0.080905660214703745),
    FRAC_CONST(0.082536433354646319),
    FRAC_CONST(0.084166985519717977),
    FRAC_CONST(0.085797312344439894),
    FRAC_CONST(0.08742740946393647),
    FRAC_CONST(0.089057272513947183),
    FRAC_CONST(0.090686897130838162),
    FRAC_CONST(0.092316278951613845),
    FRAC_CONST(0.093945413613928788),
    FRAC_CONST(0.095574296756099186),
    FRAC_CONST(0.097202924017114667),
    FRAC_CONST(0.098831291036649963),
    FRAC_CONST(0.10045939345507648),
    FRAC_CONST(0.10208722691347409),
    FRAC_CONST(0.10371478705364276),
    FRAC_CONST(0.10534206951811415),
    FRAC_CONST(0.10696906995016341),
    FRAC_CONST(0.10859578399382072),
    FRAC_CONST(0.11022220729388306),
    FRAC_CONST(0.11184833549592579),
    FRAC_CONST(0.11347416424631435),
    FRAC_CONST(0.11509968919221586),
    FRAC_CONST(0.11672490598161089),
    FRAC_CONST(0.11834981026330495),
    FRAC_CONST(0.11997439768694031),
    FRAC_CONST(0.12159866390300751),
    FRAC_CONST(0.12322260456285709),
    FRAC_CONST(0.12484621531871121),
    FRAC_CONST(0.12646949182367517),
    FRAC_CONST(0.12809242973174936),
    FRAC_CONST(0.12971502469784052),
    FRAC_CONST(0.13133727237777362),
    FRAC_CONST(0.13295916842830346),
    FRAC_CONST(0.13458070850712617),
    FRAC_CONST(0.13620188827289101),
    FRAC_CONST(0.1378227033852118),
    FRAC_CONST(0.13944314950467873),
    FRAC_CONST(0.14106322229286994),
    FRAC_CONST(0.14268291741236291),
    FRAC_CONST(0.14430223052674654),
    FRAC_CONST(0.1459211573006321),
    FRAC_CONST(0.14753969339966552),
    FRAC_CONST(0.14915783449053857),
    FRAC_CONST(0.15077557624100058),
    FRAC_CONST(0.15239291431987001),
    FRAC_CONST(0.1540098443970461),
    FRAC_CONST(0.15562636214352044),
    FRAC_CONST(0.15724246323138855),
    FRAC_CONST(0.15885814333386142),
    FRAC_CONST(0.16047339812527725),
    FRAC_CONST(0.16208822328111283),
    FRAC_CONST(0.16370261447799525),
    FRAC_CONST(0.16531656739371339),
    FRAC_CONST(0.16693007770722967),
    FRAC_CONST(0.16854314109869134),
    FRAC_CONST(0.17015575324944232),
    FRAC_CONST(0.17176790984203447),
    FRAC_CONST(0.17337960656023954),
    FRAC_CONST(0.1749908390890603),
    FRAC_CONST(0.17660160311474243),
    FRAC_CONST(0.17821189432478593),
    FRAC_CONST(0.17982170840795647),
    FRAC_CONST(0.18143104105429744),
    FRAC_CONST(0.18303988795514095),
    FRAC_CONST(0.1846482448031197),
    FRAC_CONST(0.18625610729217834),
    FRAC_CONST(0.1878634711175852),
    FRAC_CONST(0.18947033197594348),
    FRAC_CONST(0.19107668556520319),
    FRAC_CONST(0.19268252758467228),
    FRAC_CONST(0.19428785373502844),
    FRAC_CONST(0.19589265971833042),
    FRAC_CONST(0.19749694123802966),
    FRAC_CONST(0.19910069399898173),
    FRAC_CONST(0.20070391370745785),
    FRAC_CONST(0.20230659607115639),
    FRAC_CONST(0.20390873679921437),
    FRAC_CONST(0.20551033160221882),
    FRAC_CONST(0.20711137619221856),
    FRAC_CONST(0.2087118662827353),
    FRAC_CONST(0.21031179758877552),
    FRAC_CONST(0.21191116582684155),
    FRAC_CONST(0.21350996671494335),
    FRAC_CONST(0.21510819597260972),
    FRAC_CONST(0.21670584932089998),
    FRAC_CONST(0.2183029224824154),
    FRAC_CONST(0.21989941118131037),
    FRAC_CONST(0.22149531114330431),
    FRAC_CONST(0.22309061809569264),
    FRAC_CONST(0.22468532776735861),
    FRAC_CONST(0.22627943588878449),
    FRAC_CONST(0.22787293819206314),
    FRAC_CONST(0.22946583041090929),
    FRAC_CONST(0.23105810828067114),
    FRAC_CONST(0.23264976753834157),
    FRAC_CONST(0.23424080392256985),
    FRAC_CONST(0.2358312131736727),
    FRAC_CONST(0.23742099103364595),
    FRAC_CONST(0.23901013324617584),
    FRAC_CONST(0.24059863555665045),
    FRAC_CONST(0.24218649371217096),
    FRAC_CONST(0.24377370346156332),
    FRAC_CONST(0.24536026055538934),
    FRAC_CONST(0.24694616074595824),
    FRAC_CONST(0.24853139978733788),
    FRAC_CONST(0.25011597343536629),
    FRAC_CONST(0.25169987744766298),
    FRAC_CONST(0.25328310758364025),
    FRAC_CONST(0.25486565960451457),
    FRAC_CONST(0.25644752927331788),
    FRAC_CONST(0.25802871235490898),
    FRAC_CONST(0.25960920461598508),
    FRAC_CONST(0.26118900182509258),
    FRAC_CONST(0.26276809975263904),
    FRAC_CONST(0.264346494170904),
    FRAC_CONST(0.26592418085405067),
    FRAC_CONST(0.26750115557813692),
    FRAC_CONST(0.2690774141211269),
    FRAC_CONST(0.27065295226290209),
    FRAC_CONST(0.2722277657852728),
    FRAC_CONST(0.27380185047198918),
    FRAC_CONST(0.27537520210875299),
    FRAC_CONST(0.2769478164832283),
    FRAC_CONST(0.27851968938505312),
    FRAC_CONST(0.28009081660585067),
    FRAC_CONST(0.28166119393924061),
    FRAC_CONST(0.28323081718085019),
    FRAC_CONST(0.28479968212832563),
    FRAC_CONST(0.28636778458134327),
    FRAC_CONST(0.28793512034162105),
    FRAC_CONST(0.2895016852129294),
    FRAC_CONST(0.29106747500110264),
    FRAC_CONST(0.29263248551405047),
    FRAC_CONST(0.2941967125617686),
    FRAC_CONST(0.29576015195635058),
    FRAC_CONST(0.29732279951199847),
    FRAC_CONST(0.29888465104503475),
    FRAC_CONST(0.30044570237391266),
    FRAC_CONST(0.30200594931922808),
    FRAC_CONST(0.30356538770373032),
    FRAC_CONST(0.30512401335233358),
    FRAC_CONST(0.30668182209212791),
    FRAC_CONST(0.3082388097523906),
    FRAC_CONST(0.30979497216459695),
    FRAC_CONST(0.31135030516243201),
    FRAC_CONST(0.3129048045818012),
    FRAC_CONST(0.31445846626084178),
    FRAC_CONST(0.31601128603993378),
    FRAC_CONST(0.31756325976171151),
    FRAC_CONST(0.31911438327107416),
    FRAC_CONST(0.32066465241519732),
    FRAC_CONST(0.32221406304354389),
    FRAC_CONST(0.3237626110078754),
    FRAC_CONST(0.32531029216226293),
    FRAC_CONST(0.32685710236309828),
    FRAC_CONST(0.32840303746910487),
    FRAC_CONST(0.32994809334134939),
    FRAC_CONST(0.3314922658432522),
    FRAC_CONST(0.33303555084059877),
    FRAC_CONST(0.33457794420155085),
    FRAC_CONST(0.33611944179665709),
    FRAC_CONST(0.33766003949886464),
    FRAC_CONST(0.33919973318352969),
    FRAC_CONST(0.34073851872842903),
    FRAC_CONST(0.34227639201377064),
    FRAC_CONST(0.34381334892220483),
    FRAC_CONST(0.34534938533883547),
    FRAC_CONST(0.34688449715123082),
    FRAC_CONST(0.34841868024943456),
    FRAC_CONST(0.34995193052597684),
    FRAC_CONST(0.35148424387588523),
    FRAC_CONST(0.3530156161966958),
    FRAC_CONST(0.35454604338846402),
    FRAC_CONST(0.35607552135377557),
    FRAC_CONST(0.35760404599775775),
    FRAC_CONST(0.35913161322809023),
    FRAC_CONST(0.36065821895501554),
    FRAC_CONST(0.36218385909135092),
    FRAC_CONST(0.36370852955249849),
    FRAC_CONST(0.36523222625645668),
    FRAC_CONST(0.36675494512383078),
    FRAC_CONST(0.36827668207784414),
    FRAC_CONST(0.36979743304434909),
    FRAC_CONST(0.37131719395183754),
    FRAC_CONST(0.37283596073145214),
    FRAC_CONST(0.37435372931699717),
    FRAC_CONST(0.37587049564494951),
    FRAC_CONST(0.37738625565446909),
    FRAC_CONST(0.37890100528741022),
    FRAC_CONST(0.38041474048833229),
    FRAC_CONST(0.38192745720451066),
    FRAC_CONST(0.38343915138594736),
    FRAC_CONST(0.38494981898538222),
    FRAC_CONST(0.38645945595830333),
    FRAC_CONST(0.38796805826295838),
    FRAC_CONST(0.38947562186036483),
    FRAC_CONST(0.39098214271432141),
    FRAC_CONST(0.39248761679141814),
    FRAC_CONST(0.3939920400610481),
    FRAC_CONST(0.39549540849541737),
    FRAC_CONST(0.39699771806955625),
    FRAC_CONST(0.39849896476132979),
    FRAC_CONST(0.39999914455144892),
    FRAC_CONST(0.40149825342348083),
    FRAC_CONST(0.4029962873638599),
    FRAC_CONST(0.40449324236189854),
    FRAC_CONST(0.40598911440979762),
    FRAC_CONST(0.40748389950265762),
    FRAC_CONST(0.40897759363848879),
    FRAC_CONST(0.41047019281822261),
    FRAC_CONST(0.41196169304572178),
    FRAC_CONST(0.4134520903277914),
    FRAC_CONST(0.41494138067418929),
    FRAC_CONST(0.41642956009763715),
    FRAC_CONST(0.41791662461383078),
    FRAC_CONST(0.41940257024145089),
    FRAC_CONST(0.42088739300217382),
    FRAC_CONST(0.42237108892068231),
    FRAC_CONST(0.42385365402467584),
    FRAC_CONST(0.42533508434488143),
    FRAC_CONST(0.42681537591506419),
    FRAC_CONST(0.42829452477203828),
    FRAC_CONST(0.42977252695567697),
    FRAC_CONST(0.43124937850892364),
    FRAC_CONST(0.4327250754778022),
    FRAC_CONST(0.43419961391142781),
    FRAC_CONST(0.43567298986201736),
    FRAC_CONST(0.43714519938489987),
    FRAC_CONST(0.43861623853852766),
    FRAC_CONST(0.44008610338448595),
    FRAC_CONST(0.44155478998750436),
    FRAC_CONST(0.44302229441546676),
    FRAC_CONST(0.4444886127394222),
    FRAC_CONST(0.44595374103359531),
    FRAC_CONST(0.44741767537539667),
    FRAC_CONST(0.44888041184543348),
    FRAC_CONST(0.45034194652752002),
    FRAC_CONST(0.45180227550868812),
    FRAC_CONST(0.45326139487919759),
    FRAC_CONST(0.45471930073254679),
    FRAC_CONST(0.45617598916548296),
    FRAC_CONST(0.45763145627801283),
    FRAC_CONST(0.45908569817341294),
    FRAC_CONST(0.46053871095824001),
    FRAC_CONST(0.46199049074234161),
    FRAC_CONST(0.46344103363886635),
    FRAC_CONST(0.46489033576427435),
    FRAC_CONST(0.46633839323834758),
    FRAC_CONST(0.46778520218420055),
    FRAC_CONST(0.46923075872829029),
    FRAC_CONST(0.47067505900042683),
    FRAC_CONST(0.47211809913378361),
    FRAC_CONST(0.47355987526490806),
    FRAC_CONST(0.47500038353373153),
    FRAC_CONST(0.47643962008357982),
    FRAC_CONST(0.47787758106118372),
    FRAC_CONST(0.47931426261668875),
    FRAC_CONST(0.48074966090366611),
    FRAC_CONST(0.48218377207912272),
    FRAC_CONST(0.48361659230351117),
    FRAC_CONST(0.48504811774074069),
    FRAC_CONST(0.48647834455818684),
    FRAC_CONST(0.48790726892670194),
    FRAC_CONST(0.48933488702062544),
    FRAC_CONST(0.49076119501779414),
    FRAC_CONST(0.49218618909955225),
    FRAC_CONST(0.4936098654507618),
    FRAC_CONST(0.49503222025981269),
    FRAC_CONST(0.49645324971863303),
    FRAC_CONST(0.49787295002269943),
    FRAC_CONST(0.49929131737104687),
    FRAC_CONST(0.50070834796627917),
    FRAC_CONST(0.50212403801457872),
    FRAC_CONST(0.50353838372571758),
    FRAC_CONST(0.50495138131306638),
    FRAC_CONST(0.50636302699360547),
    FRAC_CONST(0.50777331698793449),
    FRAC_CONST(0.50918224752028263),
    FRAC_CONST(0.51058981481851906),
    FRAC_CONST(0.51199601511416237),
    FRAC_CONST(0.51340084464239111),
    FRAC_CONST(0.51480429964205421),
    FRAC_CONST(0.51620637635567967),
    FRAC_CONST(0.51760707102948678),
    FRAC_CONST(0.51900637991339404),
    FRAC_CONST(0.5204042992610306),
    FRAC_CONST(0.52180082532974559),
    FRAC_CONST(0.5231959543806185),
    FRAC_CONST(0.52458968267846895),
    FRAC_CONST(0.52598200649186677),
    FRAC_CONST(0.52737292209314235),
    FRAC_CONST(0.52876242575839572),
    FRAC_CONST(0.53015051376750777),
    FRAC_CONST(0.53153718240414882),
    FRAC_CONST(0.53292242795578992),
    FRAC_CONST(0.53430624671371152),
    FRAC_CONST(0.53568863497301467),
    FRAC_CONST(0.5370695890326298),
    FRAC_CONST(0.5384491051953274),
    FRAC_CONST(0.53982717976772743),
    FRAC_CONST(0.54120380906030963),
    FRAC_CONST(0.54257898938742311),
    FRAC_CONST(0.54395271706729609),
    FRAC_CONST(0.54532498842204646),
    FRAC_CONST(0.54669579977769045),
    FRAC_CONST(0.54806514746415402),
    FRAC_CONST(0.54943302781528081),
    FRAC_CONST(0.55079943716884383),
    FRAC_CONST(0.55216437186655387),
    FRAC_CONST(0.55352782825406999),
    FRAC_CONST(0.55488980268100907),
    FRAC_CONST(0.55625029150095584),
    FRAC_CONST(0.55760929107147217),
    FRAC_CONST(0.55896679775410718),
    FRAC_CONST(0.56032280791440714),
    FRAC_CONST(0.56167731792192455),
    FRAC_CONST(0.56303032415022869),
    FRAC_CONST(0.56438182297691453),
    FRAC_CONST(0.56573181078361312),
    FRAC_CONST(0.56708028395600085),
    FRAC_CONST(0.56842723888380908),
    FRAC_CONST(0.56977267196083425),
    FRAC_CONST(0.57111657958494688),
    FRAC_CONST(0.5724589581581021),
    FRAC_CONST(0.57379980408634845),
    FRAC_CONST(0.57513911377983773),
    FRAC_CONST(0.57647688365283478),
    FRAC_CONST(0.57781311012372738),
    FRAC_CONST(0.57914778961503466),
    FRAC_CONST(0.58048091855341843),
    FRAC_CONST(0.5818124933696911),
    FRAC_CONST(0.58314251049882604),
    FRAC_CONST(0.58447096637996743),
    FRAC_CONST(0.58579785745643886),
    FRAC_CONST(0.5871231801757536),
    FRAC_CONST(0.58844693098962408),
    FRAC_CONST(0.58976910635397084),
    FRAC_CONST(0.59108970272893235),
    FRAC_CONST(0.59240871657887517),
    FRAC_CONST(0.59372614437240179),
    FRAC_CONST(0.59504198258236196),
    FRAC_CONST(0.5963562276858605),
    FRAC_CONST(0.59766887616426767),
    FRAC_CONST(0.5989799245032289),
    FRAC_CONST(0.60028936919267273),
    FRAC_CONST(0.60159720672682204),
    FRAC_CONST(0.60290343360420195),
    FRAC_CONST(0.60420804632765002),
    FRAC_CONST(0.60551104140432543),
    FRAC_CONST(0.60681241534571839),
    FRAC_CONST(0.60811216466765883),
    FRAC_CONST(0.60941028589032709),
    FRAC_CONST(0.61070677553826169),
    FRAC_CONST(0.61200163014036979),
    FRAC_CONST(0.61329484622993602),
    FRAC_CONST(0.6145864203446314),
    FRAC_CONST(0.61587634902652377),
    FRAC_CONST(0.61716462882208556),
    FRAC_CONST(0.61845125628220421),
    FRAC_CONST(0.61973622796219074),
    FRAC_CONST(0.6210195404217892),
    FRAC_CONST(0.62230119022518593),
    FRAC_CONST(0.62358117394101897),
    FRAC_CONST(0.62485948814238634),
    FRAC_CONST(0.62613612940685637),
    FRAC_CONST(0.62741109431647646),
    FRAC_CONST(0.62868437945778133),
    FRAC_CONST(0.62995598142180387),
    FRAC_CONST(0.6312258968040827),
    FRAC_CONST(0.63249412220467238),
    FRAC_CONST(0.63376065422815175),
    FRAC_CONST(0.63502548948363347),
    FRAC_CONST(0.63628862458477287),
    FRAC_CONST(0.63755005614977711),
    FRAC_CONST(0.63880978080141437),
    FRAC_CONST(0.6400677951670225),
    FRAC_CONST(0.6413240958785188),
    FRAC_CONST(0.64257867957240766),
    FRAC_CONST(0.6438315428897915),
    FRAC_CONST(0.64508268247637779),
    FRAC_CONST(0.64633209498248945),
    FRAC_CONST(0.64757977706307335),
    FRAC_CONST(0.64882572537770888),
    FRAC_CONST(0.65006993659061751),
    FRAC_CONST(0.65131240737067142),
    FRAC_CONST(0.65255313439140239),
    FRAC_CONST(0.65379211433101081),
    FRAC_CONST(0.65502934387237444),
    FRAC_CONST(0.6562648197030575),
    FRAC_CONST(0.65749853851531959),
    FRAC_CONST(0.65873049700612374),
    FRAC_CONST(0.65996069187714679),
    FRAC_CONST(0.66118911983478657),
    FRAC_CONST(0.66241577759017178),
    FRAC_CONST(0.66364066185917048),
    FRAC_CONST(0.66486376936239888),
    FRAC_CONST(0.66608509682523009),
    FRAC_CONST(0.66730464097780284),
    FRAC_CONST(0.66852239855503071),
    FRAC_CONST(0.66973836629660977),
    FRAC_CONST(0.67095254094702894),
    FRAC_CONST(0.67216491925557675),
    FRAC_CONST(0.67337549797635199),
    FRAC_CONST(0.67458427386827102),
    FRAC_CONST(0.67579124369507693),
    FRAC_CONST(0.67699640422534846),
    FRAC_CONST(0.67819975223250772),
    FRAC_CONST(0.6794012844948305),
    FRAC_CONST(0.68060099779545302),
    FRAC_CONST(0.68179888892238183),
    FRAC_CONST(0.6829949546685018),
    FRAC_CONST(0.68418919183158522),
    FRAC_CONST(0.68538159721429948),
    FRAC_CONST(0.6865721676242168),
    FRAC_CONST(0.68776089987382172),
    FRAC_CONST(0.68894779078052026),
    FRAC_CONST(0.69013283716664853),
    FRAC_CONST(0.69131603585948032),
    FRAC_CONST(0.69249738369123692),
    FRAC_CONST(0.69367687749909468),
    FRAC_CONST(0.69485451412519361),
    FRAC_CONST(0.69603029041664599),
    FRAC_CONST(0.6972042032255451),
    FRAC_CONST(0.6983762494089728),
    FRAC_CONST(0.69954642582900894),
    FRAC_CONST(0.70071472935273893),
    FRAC_CONST(0.70188115685226271),
    FRAC_CONST(0.703045705204703),
    FRAC_CONST(0.70420837129221303),
    FRAC_CONST(0.70536915200198613),
    FRAC_CONST(0.70652804422626281),
    FRAC_CONST(0.70768504486233985),
    FRAC_CONST(0.70884015081257845),
    FRAC_CONST(0.70999335898441229),
    FRAC_CONST(0.711144666290356),
    FRAC_CONST(0.71229406964801356),
    FRAC_CONST(0.71344156598008623),
    FRAC_CONST(0.71458715221438096),
    FRAC_CONST(0.71573082528381871),
    FRAC_CONST(0.71687258212644234),
    FRAC_CONST(0.7180124196854254),
    FRAC_CONST(0.71915033490907943),
    FRAC_CONST(0.72028632475086318),
    FRAC_CONST(0.72142038616938997),
    FRAC_CONST(0.72255251612843596),
    FRAC_CONST(0.72368271159694852),
    FRAC_CONST(0.72481096954905444),
    FRAC_CONST(0.72593728696406756),
    FRAC_CONST(0.72706166082649704),
    FRAC_CONST(0.72818408812605595),
    FRAC_CONST(0.72930456585766834),
    FRAC_CONST(0.73042309102147851),
    FRAC_CONST(0.73153966062285747),
    FRAC_CONST(0.73265427167241282),
    FRAC_CONST(0.73376692118599507),
    FRAC_CONST(0.73487760618470677),
    FRAC_CONST(0.73598632369490979),
    FRAC_CONST(0.73709307074823405),
    FRAC_CONST(0.73819784438158409),
    FRAC_CONST(0.73930064163714881),
    FRAC_CONST(0.74040145956240788),
    FRAC_CONST(0.74150029521014049),
    FRAC_CONST(0.74259714563843304),
    FRAC_CONST(0.74369200791068657),
    FRAC_CONST(0.74478487909562552),
    FRAC_CONST(0.74587575626730485),
    FRAC_CONST(0.74696463650511791),
    FRAC_CONST(0.74805151689380456),
    FRAC_CONST(0.74913639452345926),
    FRAC_CONST(0.75021926648953785),
    FRAC_CONST(0.75130012989286621),
    FRAC_CONST(0.7523789818396478),
    FRAC_CONST(0.75345581944147111),
    FRAC_CONST(0.75453063981531809),
    FRAC_CONST(0.75560344008357094),
    FRAC_CONST(0.75667421737402052),
    FRAC_CONST(0.7577429688198738),
    FRAC_CONST(0.75880969155976163),
    FRAC_CONST(0.75987438273774599),
    FRAC_CONST(0.76093703950332836),
    FRAC_CONST(0.76199765901145666),
    FRAC_CONST(0.76305623842253345),
    FRAC_CONST(0.76411277490242291),
    FRAC_CONST(0.76516726562245885),
    FRAC_CONST(0.76621970775945258),
    FRAC_CONST(0.76727009849569949),
    FRAC_CONST(0.76831843501898767),
    FRAC_CONST(0.76936471452260458),
    FRAC_CONST(0.77040893420534517),
    FRAC_CONST(0.77145109127151923),
    FRAC_CONST(0.77249118293095853),
    FRAC_CONST(0.77352920639902467),
    FRAC_CONST(0.77456515889661659),
    FRAC_CONST(0.77559903765017746),
    FRAC_CONST(0.7766308398917029),
    FRAC_CONST(0.77766056285874774),
    FRAC_CONST(0.77868820379443371),
    FRAC_CONST(0.77971375994745684),
    FRAC_CONST(0.78073722857209438),
    FRAC_CONST(0.7817586069282132),
    FRAC_CONST(0.78277789228127592),
    FRAC_CONST(0.78379508190234881),
    FRAC_CONST(0.78481017306810918),
    FRAC_CONST(0.78582316306085265),
    FRAC_CONST(0.78683404916849986),
    FRAC_CONST(0.78784282868460476),
    FRAC_CONST(0.78884949890836087),
    FRAC_CONST(0.78985405714460888),
    FRAC_CONST(0.7908565007038445),
    FRAC_CONST(0.79185682690222425),
    FRAC_CONST(0.79285503306157412),
    FRAC_CONST(0.79385111650939566),
    FRAC_CONST(0.79484507457887377),
    FRAC_CONST(0.79583690460888357),
    FRAC_CONST(0.79682660394399751),
    FRAC_CONST(0.79781416993449272),
    FRAC_CONST(0.79879959993635785),
    FRAC_CONST(0.7997828913113002),
    FRAC_CONST(0.80076404142675273),
    FRAC_CONST(0.80174304765588156),
    FRAC_CONST(0.80271990737759213),
    FRAC_CONST(0.80369461797653707),
    FRAC_CONST(0.80466717684312306),
    FRAC_CONST(0.80563758137351682),
    FRAC_CONST(0.80660582896965372),
    FRAC_CONST(0.80757191703924336),
    FRAC_CONST(0.80853584299577752),
    FRAC_CONST(0.80949760425853612),
    FRAC_CONST(0.81045719825259477),
    FRAC_CONST(0.81141462240883167),
    FRAC_CONST(0.81236987416393436),
    FRAC_CONST(0.81332295096040608),
    FRAC_CONST(0.81427385024657373),
    FRAC_CONST(0.81522256947659355),
    FRAC_CONST(0.81616910611045879),
    FRAC_CONST(0.817113457614006),
    FRAC_CONST(0.81805562145892186),
    FRAC_CONST(0.81899559512275044),
    FRAC_CONST(0.81993337608889916),
    FRAC_CONST(0.82086896184664637),
    FRAC_CONST(0.8218023498911472),
    FRAC_CONST(0.82273353772344116),
    FRAC_CONST(0.82366252285045805),
    FRAC_CONST(0.82458930278502529),
    FRAC_CONST(0.82551387504587381),
    FRAC_CONST(0.82643623715764558),
    FRAC_CONST(0.82735638665089983),
    FRAC_CONST(0.82827432106211907),
    FRAC_CONST(0.82919003793371693),
    FRAC_CONST(0.83010353481404364),
    FRAC_CONST(0.83101480925739324),
    FRAC_CONST(0.83192385882400965),
    FRAC_CONST(0.83283068108009373),
    FRAC_CONST(0.8337352735978093),
    FRAC_CONST(0.83463763395529011),
    FRAC_CONST(0.83553775973664579),
    FRAC_CONST(0.83643564853196872),
    FRAC_CONST(0.83733129793734051),
    FRAC_CONST(0.83822470555483797),
    FRAC_CONST(0.83911586899254031),
    FRAC_CONST(0.84000478586453453),
    FRAC_CONST(0.84089145379092289),
    FRAC_CONST(0.84177587039782842),
    FRAC_CONST(0.84265803331740163),
    FRAC_CONST(0.84353794018782702),
    FRAC_CONST(0.844415588653329),
    FRAC_CONST(0.8452909763641786),
    FRAC_CONST(0.84616410097669936),
    FRAC_CONST(0.84703496015327406),
    FRAC_CONST(0.84790355156235053),
    FRAC_CONST(0.84876987287844818),
    FRAC_CONST(0.8496339217821639),
    FRAC_CONST(0.85049569596017938),
    FRAC_CONST(0.85135519310526508),
    FRAC_CONST(0.85221241091628896),
    FRAC_CONST(0.85306734709822085),
    FRAC_CONST(0.85391999936213903),
    FRAC_CONST(0.85477036542523732),
    FRAC_CONST(0.85561844301082923),
    FRAC_CONST(0.85646422984835635),
    FRAC_CONST(0.85730772367339259),
    FRAC_CONST(0.85814892222765116),
    FRAC_CONST(0.85898782325899026),
    FRAC_CONST(0.85982442452141961),
    FRAC_CONST(0.86065872377510555),
    FRAC_CONST(0.86149071878637817),
    FRAC_CONST(0.8623204073277364),
    FRAC_CONST(0.86314778717785412),
    FRAC_CONST(0.8639728561215867),
    FRAC_CONST(0.86479561194997623),
    FRAC_CONST(0.86561605246025763),
    FRAC_CONST(0.86643417545586487),
    FRAC_CONST(0.8672499787464365),
    FRAC_CONST(0.86806346014782154),
    FRAC_CONST(0.8688746174820855),
    FRAC_CONST(0.86968344857751589),
    FRAC_CONST(0.87048995126862883),
    FRAC_CONST(0.87129412339617363),
    FRAC_CONST(0.87209596280713941),
    FRAC_CONST(0.8728954673547612),
    FRAC_CONST(0.87369263489852422),
    FRAC_CONST(0.87448746330417149),
    FRAC_CONST(0.87527995044370765),
    FRAC_CONST(0.8760700941954066),
    FRAC_CONST(0.87685789244381551),
    FRAC_CONST(0.87764334307976144),
    FRAC_CONST(0.87842644400035663),
    FRAC_CONST(0.8792071931090043),
    FRAC_CONST(0.87998558831540408),
    FRAC_CONST(0.88076162753555787),
    FRAC_CONST(0.88153530869177488),
    FRAC_CONST(0.88230662971267804),
    FRAC_CONST(0.88307558853320878),
    FRAC_CONST(0.88384218309463292),
    FRAC_CONST(0.8846064113445461),
    FRAC_CONST(0.88536827123687933),
    FRAC_CONST(0.88612776073190425),
    FRAC_CONST(0.88688487779623937),
    FRAC_CONST(0.88763962040285393),
    FRAC_CONST(0.8883919865310751),
    FRAC_CONST(0.88914197416659235),
    FRAC_CONST(0.88988958130146301),
    FRAC_CONST(0.8906348059341177),
    FRAC_CONST(0.89137764606936609),
    FRAC_CONST(0.89211809971840139),
    FRAC_CONST(0.89285616489880615),
    FRAC_CONST(0.89359183963455813),
    FRAC_CONST(0.89432512195603453),
    FRAC_CONST(0.89505600990001799),
    FRAC_CONST(0.89578450150970124),
    FRAC_CONST(0.8965105948346932),
    FRAC_CONST(0.89723428793102367),
    FRAC_CONST(0.89795557886114807),
    FRAC_CONST(0.89867446569395382),
    FRAC_CONST(0.89939094650476448),
    FRAC_CONST(0.90010501937534515),
    FRAC_CONST(0.900816682393908),
    FRAC_CONST(0.90152593365511691),
    FRAC_CONST(0.90223277126009283),
    FRAC_CONST(0.90293719331641886),
    FRAC_CONST(0.90363919793814496),
    FRAC_CONST(0.90433878324579353),
    FRAC_CONST(0.90503594736636439),
    FRAC_CONST(0.90573068843333915),
    FRAC_CONST(0.90642300458668679),
    FRAC_CONST(0.90711289397286898),
    FRAC_CONST(0.90780035474484411),
    FRAC_CONST(0.90848538506207266),
    FRAC_CONST(0.90916798309052227),
    FRAC_CONST(0.90984814700267291),
    FRAC_CONST(0.9105258749775208),
    FRAC_CONST(0.91120116520058425),
    FRAC_CONST(0.91187401586390815),
    FRAC_CONST(0.91254442516606893),
    FRAC_CONST(0.9132123913121788),
    FRAC_CONST(0.91387791251389161),
    FRAC_CONST(0.91454098698940678),
    FRAC_CONST(0.91520161296347435),
    FRAC_CONST(0.91585978866739981),
    FRAC_CONST(0.91651551233904871),
    FRAC_CONST(0.91716878222285148),
    FRAC_CONST(0.91781959656980805),
    FRAC_CONST(0.91846795363749245),
    FRAC_CONST(0.91911385169005766),
    FRAC_CONST(0.9197572889982405),
    FRAC_CONST(0.9203982638393654),
    FRAC_CONST(0.92103677449734989),
    FRAC_CONST(0.92167281926270861),
    FRAC_CONST(0.92230639643255874),
    FRAC_CONST(0.92293750431062316),
    FRAC_CONST(0.92356614120723612),
    FRAC_CONST(0.92419230543934783),
    FRAC_CONST(0.92481599533052783),
    FRAC_CONST(0.92543720921097061),
    FRAC_CONST(0.92605594541749991),
    FRAC_CONST(0.92667220229357261),
    FRAC_CONST(0.92728597818928349),
    FRAC_CONST(0.9278972714613698),
    FRAC_CONST(0.92850608047321548),
    FRAC_CONST(0.9291124035948557),
    FRAC_CONST(0.92971623920298097),
    FRAC_CONST(0.93031758568094147),
    FRAC_CONST(0.93091644141875196),
    FRAC_CONST(0.93151280481309506),
    FRAC_CONST(0.93210667426732674),
    FRAC_CONST(0.93269804819147983),
    FRAC_CONST(0.93328692500226818),
    FRAC_CONST(0.93387330312309147),
    FRAC_CONST(0.93445718098403896),
    FRAC_CONST(0.93503855702189376),
    FRAC_CONST(0.9356174296801375),
    FRAC_CONST(0.93619379740895381),
    FRAC_CONST(0.93676765866523259),
    FRAC_CONST(0.93733901191257496),
    FRAC_CONST(0.93790785562129597),
    FRAC_CONST(0.93847418826842988),
    FRAC_CONST(0.93903800833773399),
    FRAC_CONST(0.93959931431969212),
    FRAC_CONST(0.94015810471151917),
    FRAC_CONST(0.94071437801716529),
    FRAC_CONST(0.94126813274731924),
    FRAC_CONST(0.94181936741941319),
    FRAC_CONST(0.94236808055762578),
    FRAC_CONST(0.94291427069288691),
    FRAC_CONST(0.94345793636288133),
    FRAC_CONST(0.94399907611205225),
    FRAC_CONST(0.9445376884916058),
    FRAC_CONST(0.94507377205951448),
    FRAC_CONST(0.94560732538052128),
    FRAC_CONST(0.94613834702614352),
    FRAC_CONST(0.94666683557467624),
    FRAC_CONST(0.94719278961119657),
    FRAC_CONST(0.94771620772756759),
    FRAC_CONST(0.94823708852244104),
    FRAC_CONST(0.94875543060126255),
    FRAC_CONST(0.94927123257627433),
    FRAC_CONST(0.94978449306651924),
    FRAC_CONST(0.95029521069784428),
    FRAC_CONST(0.9508033841029051),
    FRAC_CONST(0.95130901192116835),
    FRAC_CONST(0.9518120927989161),
    FRAC_CONST(0.95231262538924943),
    FRAC_CONST(0.95281060835209208),
    FRAC_CONST(0.95330604035419386),
    FRAC_CONST(0.95379892006913403),
    FRAC_CONST(0.95428924617732525),
    FRAC_CONST(0.95477701736601728),
    FRAC_CONST(0.95526223232929941),
    FRAC_CONST(0.95574488976810545),
    FRAC_CONST(0.95622498839021619),
    FRAC_CONST(0.95670252691026292),
    FRAC_CONST(0.95717750404973156),
    FRAC_CONST(0.95764991853696524),
    FRAC_CONST(0.95811976910716812),
    FRAC_CONST(0.95858705450240911),
    FRAC_CONST(0.95905177347162429),
    FRAC_CONST(0.95951392477062125),
    FRAC_CONST(0.95997350716208196),
    FRAC_CONST(0.96043051941556579),
    FRAC_CONST(0.96088496030751369),
    FRAC_CONST(0.96133682862125036),
    FRAC_CONST(0.96178612314698864),
    FRAC_CONST(0.96223284268183173),
    FRAC_CONST(0.9626769860297768),
    FRAC_CONST(0.96311855200171881),
    FRAC_CONST(0.96355753941545252),
    FRAC_CONST(0.96399394709567654),
    FRAC_CONST(0.96442777387399625),
    FRAC_CONST(0.96485901858892686),
    FRAC_CONST(0.96528768008589627),
    FRAC_CONST(0.96571375721724895),
    FRAC_CONST(0.96613724884224783),
    FRAC_CONST(0.96655815382707866),
    FRAC_CONST(0.96697647104485207),
    FRAC_CONST(0.96739219937560694),
    FRAC_CONST(0.96780533770631338),
    FRAC_CONST(0.96821588493087585),
    FRAC_CONST(0.9686238399501359),
    FRAC_CONST(0.96902920167187501),
    FRAC_CONST(0.96943196901081796),
    FRAC_CONST(0.96983214088863534),
    FRAC_CONST(0.9702297162339466),
    FRAC_CONST(0.97062469398232287),
    FRAC_CONST(0.97101707307629004),
    FRAC_CONST(0.97140685246533098),
    FRAC_CONST(0.97179403110588902),
    FRAC_CONST(0.97217860796137046),
    FRAC_CONST(0.97256058200214734),
    FRAC_CONST(0.97293995220556007),
    FRAC_CONST(0.97331671755592064),
    FRAC_CONST(0.97369087704451474),
    FRAC_CONST(0.97406242966960455),
    FRAC_CONST(0.97443137443643235),
    FRAC_CONST(0.97479771035722163),
    FRAC_CONST(0.97516143645118103),
    FRAC_CONST(0.97552255174450631),
    FRAC_CONST(0.97588105527038305),
    FRAC_CONST(0.97623694606898959),
    FRAC_CONST(0.97659022318749911),
    FRAC_CONST(0.97694088568008242),
    FRAC_CONST(0.97728893260791039),
    FRAC_CONST(0.97763436303915685),
    FRAC_CONST(0.97797717604900047),
    FRAC_CONST(0.97831737071962765),
    FRAC_CONST(0.97865494614023485),
    FRAC_CONST(0.97898990140703124),
    FRAC_CONST(0.97932223562324061),
    FRAC_CONST(0.97965194789910426),
    FRAC_CONST(0.9799790373518833),
    FRAC_CONST(0.98030350310586067),
    FRAC_CONST(0.98062534429234405),
    FRAC_CONST(0.98094456004966768),
    FRAC_CONST(0.98126114952319499),
    FRAC_CONST(0.98157511186532054),
    FRAC_CONST(0.98188644623547261),
    FRAC_CONST(0.98219515180011563),
    FRAC_CONST(0.98250122773275184),
    FRAC_CONST(0.98280467321392362),
    FRAC_CONST(0.98310548743121629),
    FRAC_CONST(0.98340366957925973),
    FRAC_CONST(0.98369921885973044),
    FRAC_CONST(0.98399213448135414),
    FRAC_CONST(0.98428241565990748),
    FRAC_CONST(0.98457006161822058),
    FRAC_CONST(0.98485507158617835),
    FRAC_CONST(0.98513744480072363),
    FRAC_CONST(0.98541718050585803),
    FRAC_CONST(0.98569427795264519),
    FRAC_CONST(0.98596873639921168),
    FRAC_CONST(0.98624055511074971),
    FRAC_CONST(0.98650973335951875),
    FRAC_CONST(0.98677627042484772),
    FRAC_CONST(0.98704016559313645),
    FRAC_CONST(0.98730141815785832),
    FRAC_CONST(0.98756002741956173),
    FRAC_CONST(0.9878159926858715),
    FRAC_CONST(0.98806931327149194),
    FRAC_CONST(0.98831998849820735),
    FRAC_CONST(0.98856801769488489),
    FRAC_CONST(0.98881340019747566),
    FRAC_CONST(0.98905613534901682),
    FRAC_CONST(0.98929622249963345),
    FRAC_CONST(0.98953366100653983),
    FRAC_CONST(0.98976845023404181),
    FRAC_CONST(0.99000058955353776),
    FRAC_CONST(0.99023007834352106),
    FRAC_CONST(0.99045691598958097),
    FRAC_CONST(0.99068110188440506),
    FRAC_CONST(0.99090263542778001),
    FRAC_CONST(0.99112151602659404),
    FRAC_CONST(0.99133774309483769),
    FRAC_CONST(0.99155131605360625),
    FRAC_CONST(0.99176223433110056),
    FRAC_CONST(0.99197049736262888),
    FRAC_CONST(0.99217610459060845),
    FRAC_CONST(0.99237905546456673),
    FRAC_CONST(0.99257934944114334),
    FRAC_CONST(0.99277698598409092),
    FRAC_CONST(0.99297196456427694),
    FRAC_CONST(0.99316428465968509),
    FRAC_CONST(0.99335394575541669),
    FRAC_CONST(0.99354094734369169),
    FRAC_CONST(0.99372528892385081),
    FRAC_CONST(0.99390697000235606),
    FRAC_CONST(0.99408599009279242),
    FRAC_CONST(0.99426234871586938),
    FRAC_CONST(0.99443604539942176),
    FRAC_CONST(0.99460707967841133),
    FRAC_CONST(0.99477545109492771),
    FRAC_CONST(0.99494115919819004),
    FRAC_CONST(0.99510420354454787),
    FRAC_CONST(0.99526458369748239),
    FRAC_CONST(0.99542229922760772),
    FRAC_CONST(0.99557734971267187),
    FRAC_CONST(0.9957297347375581),
    FRAC_CONST(0.99587945389428578),
    FRAC_CONST(0.99602650678201154),
    FRAC_CONST(0.99617089300703077),
    FRAC_CONST(0.996312612182778),
    FRAC_CONST(0.99645166392982831),
    FRAC_CONST(0.99658804787589839),
    FRAC_CONST(0.99672176365584741),
    FRAC_CONST(0.99685281091167788),
    FRAC_CONST(0.99698118929253687),
    FRAC_CONST(0.99710689845471678),
    FRAC_CONST(0.99722993806165661),
    FRAC_CONST(0.99735030778394196),
    FRAC_CONST(0.99746800729930707),
    FRAC_CONST(0.99758303629263489),
    FRAC_CONST(0.99769539445595812),
    FRAC_CONST(0.99780508148846014),
    FRAC_CONST(0.99791209709647588),
    FRAC_CONST(0.99801644099349218),
    FRAC_CONST(0.99811811290014918),
    FRAC_CONST(0.9982171125442405),
    FRAC_CONST(0.9983134396607144),
    FRAC_CONST(0.99840709399167404),
    FRAC_CONST(0.99849807528637868),
    FRAC_CONST(0.99858638330124405),
    FRAC_CONST(0.99867201779984294),
    FRAC_CONST(0.99875497855290607),
    FRAC_CONST(0.99883526533832245),
    FRAC_CONST(0.99891287794114036),
    FRAC_CONST(0.99898781615356746),
    FRAC_CONST(0.99906007977497147),
    FRAC_CONST(0.99912966861188113),
    FRAC_CONST(0.99919658247798593),
    FRAC_CONST(0.99926082119413751),
    FRAC_CONST(0.99932238458834954),
    FRAC_CONST(0.999381272495798),
    FRAC_CONST(0.99943748475882255),
    FRAC_CONST(0.9994910212269259),
    FRAC_CONST(0.99954188175677483),
    FRAC_CONST(0.99959006621220048),
    FRAC_CONST(0.99963557446419837),
    FRAC_CONST(0.99967840639092931),
    FRAC_CONST(0.99971856187771946),
    FRAC_CONST(0.99975604081706027),
    FRAC_CONST(0.99979084310860955),
    FRAC_CONST(0.99982296865919107),
    FRAC_CONST(0.99985241738279484),
    FRAC_CONST(0.99987918920057806),
    FRAC_CONST(0.99990328404086426),
    FRAC_CONST(0.9999247018391445),
    FRAC_CONST(0.99994344253807688),
    FRAC_CONST(0.99995950608748674),
    FRAC_CONST(0.99997289244436727),
    FRAC_CONST(0.99998360157287902),
    FRAC_CONST(0.9999916334443506),
    FRAC_CONST(0.99999698803727821),
    FRAC_CONST(0.99999966533732598)
};
#endif

ALIGN static const real_t sine_short_128[] =
{
    FRAC_CONST(0.0061358846491544753),
    FRAC_CONST(0.01840672990580482),
    FRAC_CONST(0.030674803176636626),
    FRAC_CONST(0.04293825693494082),
    FRAC_CONST(0.055195244349689934),
    FRAC_CONST(0.067443919563664051),
    FRAC_CONST(0.079682437971430126),
    FRAC_CONST(0.091908956497132724),
    FRAC_CONST(0.10412163387205459),
    FRAC_CONST(0.11631863091190475),
    FRAC_CONST(0.12849811079379317),
    FRAC_CONST(0.14065823933284921),
    FRAC_CONST(0.15279718525844344),
    FRAC_CONST(0.16491312048996989),
    FRAC_CONST(0.17700422041214875),
    FRAC_CONST(0.18906866414980619),
    FRAC_CONST(0.2011046348420919),
    FRAC_CONST(0.21311031991609136),
    FRAC_CONST(0.22508391135979283),
    FRAC_CONST(0.2370236059943672),
    FRAC_CONST(0.24892760574572015),
    FRAC_CONST(0.26079411791527551),
    FRAC_CONST(0.27262135544994898),
    FRAC_CONST(0.28440753721127188),
    FRAC_CONST(0.29615088824362379),
    FRAC_CONST(0.30784964004153487),
    FRAC_CONST(0.31950203081601569),
    FRAC_CONST(0.33110630575987643),
    FRAC_CONST(0.34266071731199438),
    FRAC_CONST(0.35416352542049034),
    FRAC_CONST(0.36561299780477385),
    FRAC_CONST(0.37700741021641826),
    FRAC_CONST(0.38834504669882625),
    FRAC_CONST(0.39962419984564679),
    FRAC_CONST(0.41084317105790391),
    FRAC_CONST(0.42200027079979968),
    FRAC_CONST(0.43309381885315196),
    FRAC_CONST(0.4441221445704292),
    FRAC_CONST(0.45508358712634384),
    FRAC_CONST(0.46597649576796618),
    FRAC_CONST(0.47679923006332209),
    FRAC_CONST(0.487550160148436),
    FRAC_CONST(0.49822766697278187),
    FRAC_CONST(0.50883014254310699),
    FRAC_CONST(0.51935599016558964),
    FRAC_CONST(0.52980362468629461),
    FRAC_CONST(0.54017147272989285),
    FRAC_CONST(0.55045797293660481),
    FRAC_CONST(0.56066157619733603),
    FRAC_CONST(0.57078074588696726),
    FRAC_CONST(0.58081395809576453),
    FRAC_CONST(0.59075970185887416),
    FRAC_CONST(0.60061647938386897),
    FRAC_CONST(0.61038280627630948),
    FRAC_CONST(0.6200572117632891),
    FRAC_CONST(0.62963823891492698),
    FRAC_CONST(0.63912444486377573),
    FRAC_CONST(0.64851440102211244),
    FRAC_CONST(0.65780669329707864),
    FRAC_CONST(0.66699992230363747),
    FRAC_CONST(0.67609270357531592),
    FRAC_CONST(0.68508366777270036),
    FRAC_CONST(0.693971460889654),
    FRAC_CONST(0.7027547444572253),
    FRAC_CONST(0.71143219574521643),
    FRAC_CONST(0.72000250796138165),
    FRAC_CONST(0.7284643904482252),
    FRAC_CONST(0.73681656887736979),
    FRAC_CONST(0.74505778544146595),
    FRAC_CONST(0.75318679904361241),
    FRAC_CONST(0.76120238548426178),
    FRAC_CONST(0.76910333764557959),
    FRAC_CONST(0.77688846567323244),
    FRAC_CONST(0.78455659715557524),
    FRAC_CONST(0.79210657730021239),
    FRAC_CONST(0.79953726910790501),
    FRAC_CONST(0.80684755354379922),
    FRAC_CONST(0.8140363297059483),
    FRAC_CONST(0.82110251499110465),
    FRAC_CONST(0.8280450452577558),
    FRAC_CONST(0.83486287498638001),
    FRAC_CONST(0.84155497743689833),
    FRAC_CONST(0.84812034480329712),
    FRAC_CONST(0.85455798836540053),
    FRAC_CONST(0.86086693863776731),
    FRAC_CONST(0.86704624551569265),
    FRAC_CONST(0.87309497841829009),
    FRAC_CONST(0.87901222642863341),
    FRAC_CONST(0.88479709843093779),
    FRAC_CONST(0.89044872324475788),
    FRAC_CONST(0.89596624975618511),
    FRAC_CONST(0.90134884704602203),
    FRAC_CONST(0.90659570451491533),
    FRAC_CONST(0.91170603200542988),
    FRAC_CONST(0.9166790599210427),
    FRAC_CONST(0.9215140393420419),
    FRAC_CONST(0.92621024213831127),
    FRAC_CONST(0.93076696107898371),
    FRAC_CONST(0.9351835099389475),
    FRAC_CONST(0.93945922360218992),
    FRAC_CONST(0.94359345816196039),
    FRAC_CONST(0.94758559101774109),
    FRAC_CONST(0.95143502096900834),
    FRAC_CONST(0.95514116830577067),
    FRAC_CONST(0.9587034748958716),
    FRAC_CONST(0.96212140426904158),
    FRAC_CONST(0.9653944416976894),
    FRAC_CONST(0.96852209427441727),
    FRAC_CONST(0.97150389098625178),
    FRAC_CONST(0.97433938278557586),
    FRAC_CONST(0.97702814265775439),
    FRAC_CONST(0.97956976568544052),
    FRAC_CONST(0.98196386910955524),
    FRAC_CONST(0.98421009238692903),
    FRAC_CONST(0.98630809724459867),
    FRAC_CONST(0.98825756773074946),
    FRAC_CONST(0.99005821026229712),
    FRAC_CONST(0.99170975366909953),
    FRAC_CONST(0.9932119492347945),
    FRAC_CONST(0.99456457073425542),
    FRAC_CONST(0.99576741446765982),
    FRAC_CONST(0.99682029929116567),
    FRAC_CONST(0.99772306664419164),
    FRAC_CONST(0.99847558057329477),
    FRAC_CONST(0.99907772775264536),
    FRAC_CONST(0.99952941750109314),
    FRAC_CONST(0.9998305817958234),
    FRAC_CONST(0.99998117528260111)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t sine_short_120[] =
{
    FRAC_CONST(0.0065449379673518581),
    FRAC_CONST(0.019633692460628301),
    FRAC_CONST(0.032719082821776137),
    FRAC_CONST(0.045798866936520771),
    FRAC_CONST(0.058870803651189033),
    FRAC_CONST(0.071932653156719387),
    FRAC_CONST(0.084982177372441667),
    FRAC_CONST(0.09801714032956059),
    FRAC_CONST(0.11103530855427769),
    FRAC_CONST(0.12403445145048532),
    FRAC_CONST(0.13701234168196802),
    FRAC_CONST(0.14996675555404498),
    FRAC_CONST(0.16289547339458874),
    FRAC_CONST(0.17579627993435451),
    FRAC_CONST(0.18866696468655525),
    FRAC_CONST(0.2015053223256171),
    FRAC_CONST(0.21430915306505074),
    FRAC_CONST(0.2270762630343732),
    FRAC_CONST(0.23980446465501654),
    FRAC_CONST(0.25249157701515795),
    FRAC_CONST(0.26513542624340797),
    FRAC_CONST(0.27773384588129219),
    FRAC_CONST(0.29028467725446233),
    FRAC_CONST(0.3027857698425746),
    FRAC_CONST(0.31523498164776964),
    FRAC_CONST(0.32763017956169349),
    FRAC_CONST(0.33996923973099424),
    FRAC_CONST(0.35225004792123354),
    FRAC_CONST(0.36447049987914965),
    FRAC_CONST(0.37662850169321077),
    FRAC_CONST(0.38872197015239557),
    FRAC_CONST(0.40074883310314097),
    FRAC_CONST(0.41270702980439467),
    FRAC_CONST(0.42459451128071307),
    FRAC_CONST(0.43640924067334208),
    FRAC_CONST(0.44814919358922256),
    FRAC_CONST(0.45981235844785984),
    FRAC_CONST(0.47139673682599764),
    FRAC_CONST(0.48290034380003727),
    FRAC_CONST(0.49432120828614462),
    FRAC_CONST(0.50565737337798455),
    FRAC_CONST(0.51690689668202761),
    FRAC_CONST(0.52806785065036799),
    FRAC_CONST(0.53913832291100017),
    FRAC_CONST(0.55011641659549337),
    FRAC_CONST(0.56100025066400983),
    FRAC_CONST(0.57178796022761225),
    FRAC_CONST(0.58247769686780215),
    FRAC_CONST(0.59306762895323706),
    FRAC_CONST(0.60355594195357143),
    FRAC_CONST(0.61394083875036642),
    FRAC_CONST(0.62422053994501758),
    FRAC_CONST(0.63439328416364549),
    FRAC_CONST(0.64445732835889735),
    FRAC_CONST(0.65441094810861034),
    FRAC_CONST(0.66425243791128175),
    FRAC_CONST(0.67398011147829784),
    FRAC_CONST(0.68359230202287125),
    FRAC_CONST(0.69308736254563585),
    FRAC_CONST(0.70246366611685174),
    FRAC_CONST(0.71171960615517138),
    FRAC_CONST(0.72085359670291882),
    FRAC_CONST(0.7298640726978356),
    FRAC_CONST(0.73874949024124625),
    FRAC_CONST(0.74750832686259672),
    FRAC_CONST(0.75613908178032285),
    FRAC_CONST(0.76464027615900032),
    FRAC_CONST(0.77301045336273699),
    FRAC_CONST(0.78124817920475853),
    FRAC_CONST(0.78935204219315003),
    FRAC_CONST(0.79732065377270711),
    FRAC_CONST(0.80515264856285829),
    FRAC_CONST(0.81284668459161513),
    FRAC_CONST(0.82040144352551359),
    FRAC_CONST(0.82781563089550203),
    FRAC_CONST(0.83508797631874299),
    FRAC_CONST(0.84221723371628654),
    FRAC_CONST(0.84920218152657889),
    FRAC_CONST(0.85604162291477137),
    FRAC_CONST(0.86273438597779184),
    FRAC_CONST(0.86927932394514362),
    FRAC_CONST(0.87567531537539967),
    FRAC_CONST(0.88192126434835494),
    FRAC_CONST(0.88801610065280734),
    FRAC_CONST(0.89395877996993212),
    FRAC_CONST(0.8997482840522214),
    FRAC_CONST(0.90538362089795521),
    FRAC_CONST(0.91086382492117568),
    FRAC_CONST(0.91618795711713596),
    FRAC_CONST(0.92135510522319242),
    FRAC_CONST(0.9263643838751181),
    FRAC_CONST(0.93121493475880346),
    FRAC_CONST(0.93590592675732565),
    FRAC_CONST(0.94043655609335486),
    FRAC_CONST(0.94480604646687805),
    FRAC_CONST(0.94901364918821385),
    FRAC_CONST(0.95305864330629697),
    FRAC_CONST(0.95694033573220882),
    FRAC_CONST(0.9606580613579353),
    FRAC_CONST(0.96421118317032928),
    FRAC_CONST(0.96759909236025976),
    FRAC_CONST(0.9708212084269281),
    FRAC_CONST(0.97387697927733363),
    FRAC_CONST(0.97676588132087239),
    FRAC_CONST(0.97948741955905139),
    FRAC_CONST(0.98204112767030394),
    FRAC_CONST(0.98442656808989171),
    FRAC_CONST(0.98664333208487898),
    FRAC_CONST(0.98869103982416728),
    FRAC_CONST(0.99056934044357725),
    FRAC_CONST(0.99227791210596705),
    FRAC_CONST(0.99381646205637808),
    FRAC_CONST(0.99518472667219682),
    FRAC_CONST(0.99638247150832537),
    FRAC_CONST(0.99740949133735191),
    FRAC_CONST(0.99826561018471593),
    FRAC_CONST(0.99895068135886012),
    FRAC_CONST(0.99946458747636568),
    FRAC_CONST(0.99980724048206482),
    FRAC_CONST(0.99997858166412923)
};
#endif

#ifdef LD_DEC
ALIGN static const real_t sine_mid_512[] =
{
    FRAC_CONST(0.0015339801862847655),
    FRAC_CONST(0.0046019261204485705),
    FRAC_CONST(0.007669828739531097),
    FRAC_CONST(0.010737659167264491),
    FRAC_CONST(0.013805388528060391),
    FRAC_CONST(0.01687298794728171),
    FRAC_CONST(0.019940428551514441),
    FRAC_CONST(0.023007681468839369),
    FRAC_CONST(0.026074717829103901),
    FRAC_CONST(0.029141508764193722),
    FRAC_CONST(0.032208025408304586),
    FRAC_CONST(0.035274238898213947),
    FRAC_CONST(0.038340120373552694),
    FRAC_CONST(0.041405640977076739),
    FRAC_CONST(0.044470771854938668),
    FRAC_CONST(0.047535484156959303),
    FRAC_CONST(0.050599749036899282),
    FRAC_CONST(0.05366353765273052),
    FRAC_CONST(0.056726821166907748),
    FRAC_CONST(0.059789570746639868),
    FRAC_CONST(0.062851757564161406),
    FRAC_CONST(0.065913352797003805),
    FRAC_CONST(0.068974327628266746),
    FRAC_CONST(0.072034653246889332),
    FRAC_CONST(0.075094300847921305),
    FRAC_CONST(0.078153241632794232),
    FRAC_CONST(0.081211446809592441),
    FRAC_CONST(0.084268887593324071),
    FRAC_CONST(0.087325535206192059),
    FRAC_CONST(0.090381360877864983),
    FRAC_CONST(0.093436335845747787),
    FRAC_CONST(0.096490431355252593),
    FRAC_CONST(0.099543618660069319),
    FRAC_CONST(0.10259586902243628),
    FRAC_CONST(0.10564715371341062),
    FRAC_CONST(0.10869744401313872),
    FRAC_CONST(0.11174671121112659),
    FRAC_CONST(0.11479492660651008),
    FRAC_CONST(0.11784206150832498),
    FRAC_CONST(0.12088808723577708),
    FRAC_CONST(0.12393297511851216),
    FRAC_CONST(0.12697669649688587),
    FRAC_CONST(0.13001922272223335),
    FRAC_CONST(0.13306052515713906),
    FRAC_CONST(0.1361005751757062),
    FRAC_CONST(0.1391393441638262),
    FRAC_CONST(0.14217680351944803),
    FRAC_CONST(0.14521292465284746),
    FRAC_CONST(0.14824767898689603),
    FRAC_CONST(0.15128103795733022),
    FRAC_CONST(0.1543129730130201),
    FRAC_CONST(0.15734345561623825),
    FRAC_CONST(0.16037245724292828),
    FRAC_CONST(0.16339994938297323),
    FRAC_CONST(0.1664259035404641),
    FRAC_CONST(0.16945029123396796),
    FRAC_CONST(0.17247308399679595),
    FRAC_CONST(0.17549425337727143),
    FRAC_CONST(0.17851377093899751),
    FRAC_CONST(0.18153160826112497),
    FRAC_CONST(0.18454773693861962),
    FRAC_CONST(0.1875621285825296),
    FRAC_CONST(0.19057475482025274),
    FRAC_CONST(0.19358558729580361),
    FRAC_CONST(0.19659459767008022),
    FRAC_CONST(0.19960175762113097),
    FRAC_CONST(0.20260703884442113),
    FRAC_CONST(0.20561041305309924),
    FRAC_CONST(0.20861185197826349),
    FRAC_CONST(0.21161132736922755),
    FRAC_CONST(0.21460881099378676),
    FRAC_CONST(0.21760427463848364),
    FRAC_CONST(0.22059769010887351),
    FRAC_CONST(0.22358902922978999),
    FRAC_CONST(0.22657826384561),
    FRAC_CONST(0.22956536582051887),
    FRAC_CONST(0.23255030703877524),
    FRAC_CONST(0.23553305940497549),
    FRAC_CONST(0.23851359484431842),
    FRAC_CONST(0.24149188530286933),
    FRAC_CONST(0.24446790274782415),
    FRAC_CONST(0.24744161916777327),
    FRAC_CONST(0.25041300657296522),
    FRAC_CONST(0.25338203699557016),
    FRAC_CONST(0.25634868248994291),
    FRAC_CONST(0.25931291513288623),
    FRAC_CONST(0.26227470702391359),
    FRAC_CONST(0.26523403028551179),
    FRAC_CONST(0.26819085706340318),
    FRAC_CONST(0.27114515952680801),
    FRAC_CONST(0.27409690986870638),
    FRAC_CONST(0.2770460803060999),
    FRAC_CONST(0.27999264308027322),
    FRAC_CONST(0.28293657045705539),
    FRAC_CONST(0.28587783472708062),
    FRAC_CONST(0.28881640820604948),
    FRAC_CONST(0.29175226323498926),
    FRAC_CONST(0.29468537218051433),
    FRAC_CONST(0.2976157074350862),
    FRAC_CONST(0.30054324141727345),
    FRAC_CONST(0.30346794657201132),
    FRAC_CONST(0.30638979537086092),
    FRAC_CONST(0.30930876031226873),
    FRAC_CONST(0.31222481392182488),
    FRAC_CONST(0.31513792875252244),
    FRAC_CONST(0.31804807738501495),
    FRAC_CONST(0.32095523242787521),
    FRAC_CONST(0.32385936651785285),
    FRAC_CONST(0.32676045232013173),
    FRAC_CONST(0.32965846252858749),
    FRAC_CONST(0.33255336986604422),
    FRAC_CONST(0.3354451470845316),
    FRAC_CONST(0.33833376696554113),
    FRAC_CONST(0.34121920232028236),
    FRAC_CONST(0.34410142598993881),
    FRAC_CONST(0.34698041084592368),
    FRAC_CONST(0.34985612979013492),
    FRAC_CONST(0.35272855575521073),
    FRAC_CONST(0.35559766170478385),
    FRAC_CONST(0.35846342063373654),
    FRAC_CONST(0.36132580556845428),
    FRAC_CONST(0.36418478956707989),
    FRAC_CONST(0.36704034571976718),
    FRAC_CONST(0.3698924471489341),
    FRAC_CONST(0.37274106700951576),
    FRAC_CONST(0.37558617848921722),
    FRAC_CONST(0.37842775480876556),
    FRAC_CONST(0.38126576922216238),
    FRAC_CONST(0.38410019501693504),
    FRAC_CONST(0.38693100551438858),
    FRAC_CONST(0.38975817406985641),
    FRAC_CONST(0.39258167407295147),
    FRAC_CONST(0.39540147894781635),
    FRAC_CONST(0.39821756215337356),
    FRAC_CONST(0.40102989718357562),
    FRAC_CONST(0.40383845756765407),
    FRAC_CONST(0.40664321687036903),
    FRAC_CONST(0.40944414869225759),
    FRAC_CONST(0.41224122666988289),
    FRAC_CONST(0.41503442447608163),
    FRAC_CONST(0.41782371582021227),
    FRAC_CONST(0.42060907444840251),
    FRAC_CONST(0.42339047414379605),
    FRAC_CONST(0.42616788872679962),
    FRAC_CONST(0.42894129205532949),
    FRAC_CONST(0.43171065802505726),
    FRAC_CONST(0.43447596056965565),
    FRAC_CONST(0.43723717366104409),
    FRAC_CONST(0.43999427130963326),
    FRAC_CONST(0.44274722756457002),
    FRAC_CONST(0.44549601651398174),
    FRAC_CONST(0.44824061228521989),
    FRAC_CONST(0.45098098904510386),
    FRAC_CONST(0.45371712100016387),
    FRAC_CONST(0.45644898239688392),
    FRAC_CONST(0.45917654752194409),
    FRAC_CONST(0.46189979070246273),
    FRAC_CONST(0.46461868630623782),
    FRAC_CONST(0.46733320874198842),
    FRAC_CONST(0.47004333245959562),
    FRAC_CONST(0.47274903195034279),
    FRAC_CONST(0.47545028174715587),
    FRAC_CONST(0.47814705642484301),
    FRAC_CONST(0.48083933060033396),
    FRAC_CONST(0.48352707893291874),
    FRAC_CONST(0.48621027612448642),
    FRAC_CONST(0.48888889691976317),
    FRAC_CONST(0.4915629161065499),
    FRAC_CONST(0.49423230851595967),
    FRAC_CONST(0.49689704902265447),
    FRAC_CONST(0.49955711254508184),
    FRAC_CONST(0.50221247404571079),
    FRAC_CONST(0.50486310853126759),
    FRAC_CONST(0.50750899105297087),
    FRAC_CONST(0.51015009670676681),
    FRAC_CONST(0.51278640063356296),
    FRAC_CONST(0.51541787801946293),
    FRAC_CONST(0.51804450409599934),
    FRAC_CONST(0.52066625414036716),
    FRAC_CONST(0.52328310347565643),
    FRAC_CONST(0.52589502747108463),
    FRAC_CONST(0.52850200154222848),
    FRAC_CONST(0.531104001151255),
    FRAC_CONST(0.53370100180715296),
    FRAC_CONST(0.53629297906596318),
    FRAC_CONST(0.53887990853100842),
    FRAC_CONST(0.54146176585312344),
    FRAC_CONST(0.54403852673088382),
    FRAC_CONST(0.54661016691083486),
    FRAC_CONST(0.54917666218771966),
    FRAC_CONST(0.55173798840470734),
    FRAC_CONST(0.55429412145362),
    FRAC_CONST(0.5568450372751601),
    FRAC_CONST(0.55939071185913614),
    FRAC_CONST(0.56193112124468947),
    FRAC_CONST(0.5644662415205195),
    FRAC_CONST(0.56699604882510868),
    FRAC_CONST(0.56952051934694714),
    FRAC_CONST(0.57203962932475705),
    FRAC_CONST(0.57455335504771576),
    FRAC_CONST(0.57706167285567944),
    FRAC_CONST(0.57956455913940563),
    FRAC_CONST(0.58206199034077544),
    FRAC_CONST(0.58455394295301533),
    FRAC_CONST(0.58704039352091797),
    FRAC_CONST(0.58952131864106394),
    FRAC_CONST(0.59199669496204099),
    FRAC_CONST(0.59446649918466443),
    FRAC_CONST(0.5969307080621965),
    FRAC_CONST(0.59938929840056454),
    FRAC_CONST(0.60184224705858003),
    FRAC_CONST(0.60428953094815596),
    FRAC_CONST(0.60673112703452448),
    FRAC_CONST(0.60916701233645321),
    FRAC_CONST(0.61159716392646191),
    FRAC_CONST(0.61402155893103838),
    FRAC_CONST(0.61644017453085365),
    FRAC_CONST(0.61885298796097632),
    FRAC_CONST(0.62125997651108755),
    FRAC_CONST(0.62366111752569453),
    FRAC_CONST(0.62605638840434352),
    FRAC_CONST(0.62844576660183271),
    FRAC_CONST(0.63082922962842447),
    FRAC_CONST(0.63320675505005719),
    FRAC_CONST(0.63557832048855611),
    FRAC_CONST(0.63794390362184406),
    FRAC_CONST(0.64030348218415167),
    FRAC_CONST(0.64265703396622686),
    FRAC_CONST(0.64500453681554393),
    FRAC_CONST(0.64734596863651206),
    FRAC_CONST(0.64968130739068319),
    FRAC_CONST(0.6520105310969595),
    FRAC_CONST(0.65433361783180044),
    FRAC_CONST(0.65665054572942894),
    FRAC_CONST(0.65896129298203732),
    FRAC_CONST(0.66126583783999227),
    FRAC_CONST(0.66356415861203977),
    FRAC_CONST(0.66585623366550972),
    FRAC_CONST(0.66814204142651845),
    FRAC_CONST(0.67042156038017309),
    FRAC_CONST(0.67269476907077286),
    FRAC_CONST(0.67496164610201193),
    FRAC_CONST(0.67722217013718033),
    FRAC_CONST(0.67947631989936497),
    FRAC_CONST(0.68172407417164971),
    FRAC_CONST(0.6839654117973154),
    FRAC_CONST(0.68620031168003859),
    FRAC_CONST(0.68842875278409044),
    FRAC_CONST(0.6906507141345346),
    FRAC_CONST(0.69286617481742463),
    FRAC_CONST(0.69507511398000088),
    FRAC_CONST(0.69727751083088652),
    FRAC_CONST(0.69947334464028377),
    FRAC_CONST(0.70166259474016845),
    FRAC_CONST(0.70384524052448494),
    FRAC_CONST(0.70602126144933974),
    FRAC_CONST(0.70819063703319529),
    FRAC_CONST(0.71035334685706231),
    FRAC_CONST(0.71250937056469232),
    FRAC_CONST(0.71465868786276898),
    FRAC_CONST(0.71680127852109954),
    FRAC_CONST(0.71893712237280438),
    FRAC_CONST(0.72106619931450811),
    FRAC_CONST(0.72318848930652735),
    FRAC_CONST(0.72530397237306066),
    FRAC_CONST(0.72741262860237577),
    FRAC_CONST(0.7295144381469969),
    FRAC_CONST(0.73160938122389252),
    FRAC_CONST(0.73369743811466026),
    FRAC_CONST(0.73577858916571348),
    FRAC_CONST(0.73785281478846598),
    FRAC_CONST(0.73992009545951609),
    FRAC_CONST(0.74198041172083096),
    FRAC_CONST(0.74403374417992918),
    FRAC_CONST(0.74608007351006378),
    FRAC_CONST(0.74811938045040349),
    FRAC_CONST(0.75015164580621496),
    FRAC_CONST(0.7521768504490427),
    FRAC_CONST(0.75419497531688917),
    FRAC_CONST(0.75620600141439454),
    FRAC_CONST(0.75820990981301528),
    FRAC_CONST(0.76020668165120242),
    FRAC_CONST(0.7621962981345789),
    FRAC_CONST(0.76417874053611667),
    FRAC_CONST(0.76615399019631281),
    FRAC_CONST(0.76812202852336531),
    FRAC_CONST(0.7700828369933479),
    FRAC_CONST(0.77203639715038441),
    FRAC_CONST(0.77398269060682279),
    FRAC_CONST(0.77592169904340758),
    FRAC_CONST(0.77785340420945304),
    FRAC_CONST(0.77977778792301444),
    FRAC_CONST(0.78169483207105939),
    FRAC_CONST(0.7836045186096382),
    FRAC_CONST(0.78550682956405393),
    FRAC_CONST(0.78740174702903132),
    FRAC_CONST(0.78928925316888565),
    FRAC_CONST(0.79116933021769009),
    FRAC_CONST(0.79304196047944364),
    FRAC_CONST(0.79490712632823701),
    FRAC_CONST(0.79676481020841872),
    FRAC_CONST(0.79861499463476082),
    FRAC_CONST(0.80045766219262271),
    FRAC_CONST(0.80229279553811572),
    FRAC_CONST(0.8041203773982657),
    FRAC_CONST(0.80594039057117628),
    FRAC_CONST(0.80775281792619036),
    FRAC_CONST(0.80955764240405126),
    FRAC_CONST(0.81135484701706373),
    FRAC_CONST(0.81314441484925359),
    FRAC_CONST(0.81492632905652662),
    FRAC_CONST(0.81670057286682785),
    FRAC_CONST(0.81846712958029866),
    FRAC_CONST(0.82022598256943469),
    FRAC_CONST(0.82197711527924155),
    FRAC_CONST(0.82372051122739132),
    FRAC_CONST(0.82545615400437744),
    FRAC_CONST(0.82718402727366902),
    FRAC_CONST(0.82890411477186487),
    FRAC_CONST(0.8306164003088462),
    FRAC_CONST(0.83232086776792968),
    FRAC_CONST(0.83401750110601813),
    FRAC_CONST(0.8357062843537526),
    FRAC_CONST(0.83738720161566194),
    FRAC_CONST(0.83906023707031263),
    FRAC_CONST(0.84072537497045807),
    FRAC_CONST(0.84238259964318596),
    FRAC_CONST(0.84403189549006641),
    FRAC_CONST(0.84567324698729907),
    FRAC_CONST(0.84730663868585832),
    FRAC_CONST(0.84893205521163961),
    FRAC_CONST(0.85054948126560337),
    FRAC_CONST(0.85215890162391983),
    FRAC_CONST(0.8537603011381113),
    FRAC_CONST(0.85535366473519603),
    FRAC_CONST(0.85693897741782865),
    FRAC_CONST(0.85851622426444274),
    FRAC_CONST(0.86008539042939014),
    FRAC_CONST(0.8616464611430813),
    FRAC_CONST(0.86319942171212416),
    FRAC_CONST(0.86474425751946238),
    FRAC_CONST(0.86628095402451299),
    FRAC_CONST(0.86780949676330321),
    FRAC_CONST(0.86932987134860673),
    FRAC_CONST(0.87084206347007886),
    FRAC_CONST(0.87234605889439154),
    FRAC_CONST(0.87384184346536675),
    FRAC_CONST(0.87532940310411078),
    FRAC_CONST(0.87680872380914576),
    FRAC_CONST(0.87827979165654146),
    FRAC_CONST(0.87974259280004741),
    FRAC_CONST(0.88119711347122198),
    FRAC_CONST(0.88264333997956279),
    FRAC_CONST(0.88408125871263499),
    FRAC_CONST(0.88551085613619995),
    FRAC_CONST(0.88693211879434208),
    FRAC_CONST(0.88834503330959624),
    FRAC_CONST(0.88974958638307289),
    FRAC_CONST(0.89114576479458318),
    FRAC_CONST(0.89253355540276469),
    FRAC_CONST(0.89391294514520325),
    FRAC_CONST(0.89528392103855758),
    FRAC_CONST(0.89664647017868015),
    FRAC_CONST(0.89800057974073988),
    FRAC_CONST(0.89934623697934146),
    FRAC_CONST(0.90068342922864686),
    FRAC_CONST(0.90201214390249307),
    FRAC_CONST(0.90333236849451182),
    FRAC_CONST(0.90464409057824624),
    FRAC_CONST(0.90594729780726846),
    FRAC_CONST(0.90724197791529593),
    FRAC_CONST(0.90852811871630612),
    FRAC_CONST(0.90980570810465222),
    FRAC_CONST(0.91107473405517625),
    FRAC_CONST(0.91233518462332275),
    FRAC_CONST(0.91358704794525081),
    FRAC_CONST(0.91483031223794609),
    FRAC_CONST(0.91606496579933161),
    FRAC_CONST(0.91729099700837791),
    FRAC_CONST(0.91850839432521225),
    FRAC_CONST(0.91971714629122736),
    FRAC_CONST(0.92091724152918952),
    FRAC_CONST(0.92210866874334507),
    FRAC_CONST(0.92329141671952764),
    FRAC_CONST(0.9244654743252626),
    FRAC_CONST(0.92563083050987272),
    FRAC_CONST(0.92678747430458175),
    FRAC_CONST(0.92793539482261789),
    FRAC_CONST(0.92907458125931575),
    FRAC_CONST(0.93020502289221907),
    FRAC_CONST(0.93132670908118043),
    FRAC_CONST(0.93243962926846236),
    FRAC_CONST(0.93354377297883617),
    FRAC_CONST(0.93463912981968078),
    FRAC_CONST(0.93572568948108037),
    FRAC_CONST(0.93680344173592156),
    FRAC_CONST(0.93787237643998989),
    FRAC_CONST(0.93893248353206449),
    FRAC_CONST(0.93998375303401394),
    FRAC_CONST(0.94102617505088926),
    FRAC_CONST(0.94205973977101731),
    FRAC_CONST(0.94308443746609349),
    FRAC_CONST(0.94410025849127266),
    FRAC_CONST(0.94510719328526061),
    FRAC_CONST(0.94610523237040334),
    FRAC_CONST(0.94709436635277722),
    FRAC_CONST(0.94807458592227623),
    FRAC_CONST(0.94904588185270056),
    FRAC_CONST(0.950008245001843),
    FRAC_CONST(0.95096166631157508),
    FRAC_CONST(0.95190613680793223),
    FRAC_CONST(0.95284164760119872),
    FRAC_CONST(0.95376818988599033),
    FRAC_CONST(0.95468575494133834),
    FRAC_CONST(0.95559433413077111),
    FRAC_CONST(0.95649391890239499),
    FRAC_CONST(0.95738450078897586),
    FRAC_CONST(0.95826607140801767),
    FRAC_CONST(0.95913862246184189),
    FRAC_CONST(0.96000214573766585),
    FRAC_CONST(0.96085663310767966),
    FRAC_CONST(0.96170207652912254),
    FRAC_CONST(0.96253846804435916),
    FRAC_CONST(0.96336579978095405),
    FRAC_CONST(0.96418406395174572),
    FRAC_CONST(0.96499325285492032),
    FRAC_CONST(0.96579335887408357),
    FRAC_CONST(0.96658437447833312),
    FRAC_CONST(0.96736629222232851),
    FRAC_CONST(0.96813910474636233),
    FRAC_CONST(0.96890280477642887),
    FRAC_CONST(0.96965738512429245),
    FRAC_CONST(0.9704028386875555),
    FRAC_CONST(0.97113915844972509),
    FRAC_CONST(0.9718663374802794),
    FRAC_CONST(0.97258436893473221),
    FRAC_CONST(0.97329324605469825),
    FRAC_CONST(0.97399296216795583),
    FRAC_CONST(0.97468351068851067),
    FRAC_CONST(0.97536488511665687),
    FRAC_CONST(0.97603707903903902),
    FRAC_CONST(0.97670008612871184),
    FRAC_CONST(0.97735390014519996),
    FRAC_CONST(0.97799851493455714),
    FRAC_CONST(0.9786339244294231),
    FRAC_CONST(0.97926012264908202),
    FRAC_CONST(0.97987710369951764),
    FRAC_CONST(0.98048486177346938),
    FRAC_CONST(0.98108339115048659),
    FRAC_CONST(0.98167268619698311),
    FRAC_CONST(0.98225274136628937),
    FRAC_CONST(0.98282355119870524),
    FRAC_CONST(0.98338511032155118),
    FRAC_CONST(0.98393741344921892),
    FRAC_CONST(0.98448045538322093),
    FRAC_CONST(0.98501423101223984),
    FRAC_CONST(0.98553873531217606),
    FRAC_CONST(0.98605396334619544),
    FRAC_CONST(0.98655991026477541),
    FRAC_CONST(0.98705657130575097),
    FRAC_CONST(0.98754394179435923),
    FRAC_CONST(0.98802201714328353),
    FRAC_CONST(0.98849079285269659),
    FRAC_CONST(0.98895026451030299),
    FRAC_CONST(0.98940042779138038),
    FRAC_CONST(0.98984127845882053),
    FRAC_CONST(0.99027281236316911),
    FRAC_CONST(0.99069502544266463),
    FRAC_CONST(0.99110791372327678),
    FRAC_CONST(0.9915114733187439),
    FRAC_CONST(0.99190570043060933),
    FRAC_CONST(0.99229059134825737),
    FRAC_CONST(0.99266614244894802),
    FRAC_CONST(0.99303235019785141),
    FRAC_CONST(0.99338921114808065),
    FRAC_CONST(0.9937367219407246),
    FRAC_CONST(0.99407487930487937),
    FRAC_CONST(0.9944036800576791),
    FRAC_CONST(0.9947231211043257),
    FRAC_CONST(0.99503319943811863),
    FRAC_CONST(0.99533391214048228),
    FRAC_CONST(0.99562525638099431),
    FRAC_CONST(0.99590722941741172),
    FRAC_CONST(0.99617982859569687),
    FRAC_CONST(0.99644305135004263),
    FRAC_CONST(0.99669689520289606),
    FRAC_CONST(0.99694135776498216),
    FRAC_CONST(0.99717643673532619),
    FRAC_CONST(0.9974021299012753),
    FRAC_CONST(0.99761843513851955),
    FRAC_CONST(0.99782535041111164),
    FRAC_CONST(0.99802287377148624),
    FRAC_CONST(0.99821100336047819),
    FRAC_CONST(0.99838973740734016),
    FRAC_CONST(0.99855907422975931),
    FRAC_CONST(0.99871901223387294),
    FRAC_CONST(0.99886954991428356),
    FRAC_CONST(0.99901068585407338),
    FRAC_CONST(0.99914241872481691),
    FRAC_CONST(0.99926474728659442),
    FRAC_CONST(0.99937767038800285),
    FRAC_CONST(0.99948118696616695),
    FRAC_CONST(0.99957529604674922),
    FRAC_CONST(0.99965999674395922),
    FRAC_CONST(0.99973528826056168),
    FRAC_CONST(0.99980116988788426),
    FRAC_CONST(0.99985764100582386),
    FRAC_CONST(0.9999047010828529),
    FRAC_CONST(0.99994234967602391),
    FRAC_CONST(0.99997058643097414),
    FRAC_CONST(0.9999894110819284),
    FRAC_CONST(0.99999882345170188)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t sine_mid_480[] =
{
    FRAC_CONST(0.0016362454436240478),
    FRAC_CONST(0.00490871880799799),
    FRAC_CONST(0.0081811396039371282),
    FRAC_CONST(0.011453472786443779),
    FRAC_CONST(0.014725683311458524),
    FRAC_CONST(0.017997736136235509),
    FRAC_CONST(0.021269596219717739),
    FRAC_CONST(0.024541228522912285),
    FRAC_CONST(0.027812598009265607),
    FRAC_CONST(0.03108366964503869),
    FRAC_CONST(0.034354408399682276),
    FRAC_CONST(0.037624779246211978),
    FRAC_CONST(0.04089474716158345),
    FRAC_CONST(0.044164277127067358),
    FRAC_CONST(0.047433334128624507),
    FRAC_CONST(0.050701883157280733),
    FRAC_CONST(0.053969889209501881),
    FRAC_CONST(0.057237317287568618),
    FRAC_CONST(0.060504132399951269),
    FRAC_CONST(0.063770299561684493),
    FRAC_CONST(0.06703578379474201),
    FRAC_CONST(0.070300550128411174),
    FRAC_CONST(0.073564563599667426),
    FRAC_CONST(0.076827789253548759),
    FRAC_CONST(0.080090192143530081),
    FRAC_CONST(0.083351737331897449),
    FRAC_CONST(0.086612389890122182),
    FRAC_CONST(0.089872114899234967),
    FRAC_CONST(0.093130877450199795),
    FRAC_CONST(0.096388642644287828),
    FRAC_CONST(0.09964537559345106),
    FRAC_CONST(0.1029010414206961),
    FRAC_CONST(0.10615560526045748),
    FRAC_CONST(0.10940903225897117),
    FRAC_CONST(0.11266128757464781),
    FRAC_CONST(0.11591233637844581),
    FRAC_CONST(0.11916214385424433),
    FRAC_CONST(0.1224106751992162),
    FRAC_CONST(0.12565789562420052),
    FRAC_CONST(0.12890377035407541),
    FRAC_CONST(0.13214826462813015),
    FRAC_CONST(0.13539134370043773),
    FRAC_CONST(0.13863297284022669),
    FRAC_CONST(0.14187311733225325),
    FRAC_CONST(0.14511174247717309),
    FRAC_CONST(0.14834881359191271),
    FRAC_CONST(0.15158429601004111),
    FRAC_CONST(0.15481815508214106),
    FRAC_CONST(0.1580503561761798),
    FRAC_CONST(0.16128086467788047),
    FRAC_CONST(0.16450964599109233),
    FRAC_CONST(0.16773666553816149),
    FRAC_CONST(0.17096188876030122),
    FRAC_CONST(0.17418528111796186),
    FRAC_CONST(0.17740680809120093),
    FRAC_CONST(0.18062643518005275),
    FRAC_CONST(0.18384412790489776),
    FRAC_CONST(0.18705985180683199),
    FRAC_CONST(0.19027357244803589),
    FRAC_CONST(0.19348525541214331),
    FRAC_CONST(0.19669486630460997),
    FRAC_CONST(0.19990237075308173),
    FRAC_CONST(0.20310773440776286),
    FRAC_CONST(0.20631092294178383),
    FRAC_CONST(0.20951190205156878),
    FRAC_CONST(0.21271063745720317),
    FRAC_CONST(0.21590709490280058),
    FRAC_CONST(0.2191012401568698),
    FRAC_CONST(0.22229303901268133),
    FRAC_CONST(0.22548245728863364),
    FRAC_CONST(0.22866946082861941),
    FRAC_CONST(0.23185401550239115),
    FRAC_CONST(0.23503608720592667),
    FRAC_CONST(0.23821564186179459),
    FRAC_CONST(0.24139264541951888),
    FRAC_CONST(0.24456706385594387),
    FRAC_CONST(0.24773886317559846),
    FRAC_CONST(0.25090800941106001),
    FRAC_CONST(0.25407446862331851),
    FRAC_CONST(0.25723820690213967),
    FRAC_CONST(0.26039919036642817),
    FRAC_CONST(0.26355738516459076),
    FRAC_CONST(0.26671275747489837),
    FRAC_CONST(0.2698652735058486),
    FRAC_CONST(0.27301489949652735),
    FRAC_CONST(0.27616160171697068),
    FRAC_CONST(0.27930534646852595),
    FRAC_CONST(0.28244610008421245),
    FRAC_CONST(0.2855838289290823),
    FRAC_CONST(0.28871849940058025),
    FRAC_CONST(0.29185007792890405),
    FRAC_CONST(0.29497853097736348),
    FRAC_CONST(0.2981038250427398),
    FRAC_CONST(0.30122592665564446),
    FRAC_CONST(0.30434480238087736),
    FRAC_CONST(0.30746041881778519),
    FRAC_CONST(0.31057274260061901),
    FRAC_CONST(0.31368174039889146),
    FRAC_CONST(0.31678737891773395),
    FRAC_CONST(0.31988962489825296),
    FRAC_CONST(0.32298844511788638),
    FRAC_CONST(0.32608380639075912),
    FRAC_CONST(0.32917567556803889),
    FRAC_CONST(0.33226401953829071),
    FRAC_CONST(0.33534880522783189),
    FRAC_CONST(0.33842999960108583),
    FRAC_CONST(0.34150756966093632),
    FRAC_CONST(0.34458148244908043),
    FRAC_CONST(0.34765170504638188),
    FRAC_CONST(0.35071820457322322),
    FRAC_CONST(0.35378094818985806),
    FRAC_CONST(0.35683990309676283),
    FRAC_CONST(0.35989503653498811),
    FRAC_CONST(0.36294631578650921),
    FRAC_CONST(0.36599370817457672),
    FRAC_CONST(0.36903718106406647),
    FRAC_CONST(0.37207670186182878),
    FRAC_CONST(0.37511223801703802),
    FRAC_CONST(0.37814375702154046),
    FRAC_CONST(0.38117122641020335),
    FRAC_CONST(0.38419461376126157),
    FRAC_CONST(0.38721388669666562),
    FRAC_CONST(0.39022901288242801),
    FRAC_CONST(0.39323996002896966),
    FRAC_CONST(0.39624669589146555),
    FRAC_CONST(0.39924918827019029),
    FRAC_CONST(0.40224740501086254),
    FRAC_CONST(0.40524131400498986),
    FRAC_CONST(0.40823088319021217),
    FRAC_CONST(0.41121608055064529),
    FRAC_CONST(0.41419687411722372),
    FRAC_CONST(0.41717323196804335),
    FRAC_CONST(0.42014512222870243),
    FRAC_CONST(0.42311251307264408),
    FRAC_CONST(0.42607537272149631),
    FRAC_CONST(0.4290336694454126),
    FRAC_CONST(0.43198737156341183),
    FRAC_CONST(0.43493644744371707),
    FRAC_CONST(0.43788086550409511),
    FRAC_CONST(0.44082059421219388),
    FRAC_CONST(0.44375560208588088),
    FRAC_CONST(0.44668585769357955),
    FRAC_CONST(0.4496113296546066),
    FRAC_CONST(0.45253198663950756),
    FRAC_CONST(0.45544779737039259),
    FRAC_CONST(0.45835873062127125),
    FRAC_CONST(0.46126475521838717),
    FRAC_CONST(0.46416584004055156),
    FRAC_CONST(0.46706195401947659),
    FRAC_CONST(0.46995306614010829),
    FRAC_CONST(0.47283914544095862),
    FRAC_CONST(0.47572016101443682),
    FRAC_CONST(0.47859608200718085),
    FRAC_CONST(0.4814668776203872),
    FRAC_CONST(0.48433251711014125),
    FRAC_CONST(0.4871929697877464),
    FRAC_CONST(0.49004820502005247),
    FRAC_CONST(0.49289819222978404),
    FRAC_CONST(0.49574290089586776),
    FRAC_CONST(0.49858230055375902),
    FRAC_CONST(0.50141636079576901),
    FRAC_CONST(0.50424505127138919),
    FRAC_CONST(0.50706834168761705),
    FRAC_CONST(0.50988620180928057),
    FRAC_CONST(0.51269860145936175),
    FRAC_CONST(0.51550551051931948),
    FRAC_CONST(0.51830689892941317),
    FRAC_CONST(0.5211027366890234),
    FRAC_CONST(0.52389299385697385),
    FRAC_CONST(0.52667764055185196),
    FRAC_CONST(0.52945664695232897),
    FRAC_CONST(0.53222998329747884),
    FRAC_CONST(0.53499761988709726),
    FRAC_CONST(0.53775952708201991),
    FRAC_CONST(0.54051567530443978),
    FRAC_CONST(0.54326603503822357),
    FRAC_CONST(0.54601057682922816),
    FRAC_CONST(0.54874927128561579),
    FRAC_CONST(0.55148208907816942),
    FRAC_CONST(0.55420900094060566),
    FRAC_CONST(0.55692997766988939),
    FRAC_CONST(0.559644990126546),
    FRAC_CONST(0.56235400923497314),
    FRAC_CONST(0.56505700598375252),
    FRAC_CONST(0.56775395142596052),
    FRAC_CONST(0.57044481667947822),
    FRAC_CONST(0.57312957292730071),
    FRAC_CONST(0.57580819141784534),
    FRAC_CONST(0.57848064346525996),
    FRAC_CONST(0.58114690044973039),
    FRAC_CONST(0.58380693381778626),
    FRAC_CONST(0.58646071508260733),
    FRAC_CONST(0.58910821582432815),
    FRAC_CONST(0.5917494076903429),
    FRAC_CONST(0.5943842623956086),
    FRAC_CONST(0.59701275172294799),
    FRAC_CONST(0.59963484752335228),
    FRAC_CONST(0.60225052171628191),
    FRAC_CONST(0.60485974628996786),
    FRAC_CONST(0.60746249330171098),
    FRAC_CONST(0.61005873487818185),
    FRAC_CONST(0.61264844321571899),
    FRAC_CONST(0.61523159058062682),
    FRAC_CONST(0.61780814930947225),
    FRAC_CONST(0.62037809180938108),
    FRAC_CONST(0.62294139055833397),
    FRAC_CONST(0.6254980181054608),
    FRAC_CONST(0.62804794707133416),
    FRAC_CONST(0.63059115014826372),
    FRAC_CONST(0.63312760010058777),
    FRAC_CONST(0.63565726976496484),
    FRAC_CONST(0.63818013205066515),
    FRAC_CONST(0.64069615993986073),
    FRAC_CONST(0.64320532648791406),
    FRAC_CONST(0.64570760482366729),
    FRAC_CONST(0.64820296814972966),
    FRAC_CONST(0.65069138974276486),
    FRAC_CONST(0.65317284295377676),
    FRAC_CONST(0.65564730120839498),
    FRAC_CONST(0.65811473800715958),
    FRAC_CONST(0.660575126925805),
    FRAC_CONST(0.66302844161554231),
    FRAC_CONST(0.6654746558033422),
    FRAC_CONST(0.66791374329221598),
    FRAC_CONST(0.67034567796149647),
    FRAC_CONST(0.67277043376711676),
    FRAC_CONST(0.67518798474189046),
    FRAC_CONST(0.67759830499578866),
    FRAC_CONST(0.68000136871621808),
    FRAC_CONST(0.68239715016829683),
    FRAC_CONST(0.6847856236951303),
    FRAC_CONST(0.68716676371808583),
    FRAC_CONST(0.68954054473706683),
    FRAC_CONST(0.69190694133078579),
    FRAC_CONST(0.69426592815703603),
    FRAC_CONST(0.69661747995296419),
    FRAC_CONST(0.69896157153533944),
    FRAC_CONST(0.70129817780082437),
    FRAC_CONST(0.7036272737262429),
    FRAC_CONST(0.70594883436884903),
    FRAC_CONST(0.70826283486659336),
    FRAC_CONST(0.71056925043838959),
    FRAC_CONST(0.71286805638437978),
    FRAC_CONST(0.71515922808619936),
    FRAC_CONST(0.71744274100723993),
    FRAC_CONST(0.71971857069291278),
    FRAC_CONST(0.7219866927709101),
    FRAC_CONST(0.72424708295146689),
    FRAC_CONST(0.72649971702762028),
    FRAC_CONST(0.72874457087546896),
    FRAC_CONST(0.73098162045443171),
    FRAC_CONST(0.73321084180750484),
    FRAC_CONST(0.73543221106151868),
    FRAC_CONST(0.73764570442739286),
    FRAC_CONST(0.73985129820039208),
    FRAC_CONST(0.74204896876037885),
    FRAC_CONST(0.7442386925720671),
    FRAC_CONST(0.74642044618527381),
    FRAC_CONST(0.74859420623517081),
    FRAC_CONST(0.75075994944253421),
    FRAC_CONST(0.75291765261399446),
    FRAC_CONST(0.75506729264228367),
    FRAC_CONST(0.75720884650648446),
    FRAC_CONST(0.75934229127227548),
    FRAC_CONST(0.76146760409217706),
    FRAC_CONST(0.76358476220579641),
    FRAC_CONST(0.7656937429400712),
    FRAC_CONST(0.76779452370951196),
    FRAC_CONST(0.76988708201644451),
    FRAC_CONST(0.77197139545125026),
    FRAC_CONST(0.7740474416926072),
    FRAC_CONST(0.77611519850772781),
    FRAC_CONST(0.77817464375259782),
    FRAC_CONST(0.78022575537221317),
    FRAC_CONST(0.78226851140081632),
    FRAC_CONST(0.78430288996213138),
    FRAC_CONST(0.78632886926959822),
    FRAC_CONST(0.78834642762660623),
    FRAC_CONST(0.79035554342672631),
    FRAC_CONST(0.79235619515394229),
    FRAC_CONST(0.79434836138288134),
    FRAC_CONST(0.79633202077904397),
    FRAC_CONST(0.79830715209903147),
    FRAC_CONST(0.8002737341907743),
    FRAC_CONST(0.80223174599375802),
    FRAC_CONST(0.80418116653924954),
    FRAC_CONST(0.80612197495052085),
    FRAC_CONST(0.80805415044307316),
    FRAC_CONST(0.80997767232485907),
    FRAC_CONST(0.81189251999650469),
    FRAC_CONST(0.81379867295152986),
    FRAC_CONST(0.81569611077656778),
    FRAC_CONST(0.81758481315158371),
    FRAC_CONST(0.81946475985009259),
    FRAC_CONST(0.82133593073937561),
    FRAC_CONST(0.82319830578069586),
    FRAC_CONST(0.82505186502951278),
    FRAC_CONST(0.82689658863569615),
    FRAC_CONST(0.82873245684373809),
    FRAC_CONST(0.83055944999296494),
    FRAC_CONST(0.83237754851774781),
    FRAC_CONST(0.83418673294771239),
    FRAC_CONST(0.83598698390794668),
    FRAC_CONST(0.83777828211920935),
    FRAC_CONST(0.83956060839813562),
    FRAC_CONST(0.84133394365744296),
    FRAC_CONST(0.84309826890613537),
    FRAC_CONST(0.84485356524970701),
    FRAC_CONST(0.84659981389034411),
    FRAC_CONST(0.84833699612712676),
    FRAC_CONST(0.85006509335622882),
    FRAC_CONST(0.8517840870711173),
    FRAC_CONST(0.85349395886275037),
    FRAC_CONST(0.85519469041977514),
    FRAC_CONST(0.85688626352872277),
    FRAC_CONST(0.85856866007420429),
    FRAC_CONST(0.86024186203910447),
    FRAC_CONST(0.86190585150477417),
    FRAC_CONST(0.86356061065122347),
    FRAC_CONST(0.86520612175731115),
    FRAC_CONST(0.86684236720093533),
    FRAC_CONST(0.86846932945922151),
    FRAC_CONST(0.87008699110871135),
    FRAC_CONST(0.87169533482554817),
    FRAC_CONST(0.87329434338566281),
    FRAC_CONST(0.87488399966495822),
    FRAC_CONST(0.87646428663949283),
    FRAC_CONST(0.87803518738566277),
    FRAC_CONST(0.87959668508038291),
    FRAC_CONST(0.88114876300126743),
    FRAC_CONST(0.88269140452680916),
    FRAC_CONST(0.8842245931365561),
    FRAC_CONST(0.88574831241129048),
    FRAC_CONST(0.88726254603320276),
    FRAC_CONST(0.88876727778606746),
    FRAC_CONST(0.89026249155541637),
    FRAC_CONST(0.8917481713287112),
    FRAC_CONST(0.89322430119551532),
    FRAC_CONST(0.89469086534766362),
    FRAC_CONST(0.89614784807943237),
    FRAC_CONST(0.89759523378770689),
    FRAC_CONST(0.89903300697214927),
    FRAC_CONST(0.9004611522353636),
    FRAC_CONST(0.90187965428306172),
    FRAC_CONST(0.90328849792422594),
    FRAC_CONST(0.90468766807127299),
    FRAC_CONST(0.90607714974021469),
    FRAC_CONST(0.90745692805081868),
    FRAC_CONST(0.90882698822676755),
    FRAC_CONST(0.91018731559581767),
    FRAC_CONST(0.91153789558995579),
    FRAC_CONST(0.91287871374555518),
    FRAC_CONST(0.91420975570353069),
    FRAC_CONST(0.9155310072094921),
    FRAC_CONST(0.91684245411389753),
    FRAC_CONST(0.91814408237220391),
    FRAC_CONST(0.91943587804501858),
    FRAC_CONST(0.92071782729824769),
    FRAC_CONST(0.92198991640324446),
    FRAC_CONST(0.92325213173695675),
    FRAC_CONST(0.92450445978207241),
    FRAC_CONST(0.92574688712716402),
    FRAC_CONST(0.92697940046683291),
    FRAC_CONST(0.92820198660185149),
    FRAC_CONST(0.92941463243930444),
    FRAC_CONST(0.93061732499272909),
    FRAC_CONST(0.93181005138225426),
    FRAC_CONST(0.93299279883473885),
    FRAC_CONST(0.93416555468390772),
    FRAC_CONST(0.93532830637048769),
    FRAC_CONST(0.93648104144234268),
    FRAC_CONST(0.93762374755460598),
    FRAC_CONST(0.93875641246981323),
    FRAC_CONST(0.93987902405803303),
    FRAC_CONST(0.94099157029699743),
    FRAC_CONST(0.94209403927222979),
    FRAC_CONST(0.94318641917717327),
    FRAC_CONST(0.9442686983133165),
    FRAC_CONST(0.94534086509031956),
    FRAC_CONST(0.9464029080261378),
    FRAC_CONST(0.94745481574714419),
    FRAC_CONST(0.94849657698825252),
    FRAC_CONST(0.94952818059303667),
    FRAC_CONST(0.95054961551385087),
    FRAC_CONST(0.95156087081194762),
    FRAC_CONST(0.95256193565759528),
    FRAC_CONST(0.95355279933019343),
    FRAC_CONST(0.9545334512183884),
    FRAC_CONST(0.95550388082018611),
    FRAC_CONST(0.95646407774306541),
    FRAC_CONST(0.95741403170408834),
    FRAC_CONST(0.95835373253001133),
    FRAC_CONST(0.95928317015739362),
    FRAC_CONST(0.96020233463270466),
    FRAC_CONST(0.96111121611243155),
    FRAC_CONST(0.96200980486318388),
    FRAC_CONST(0.96289809126179782),
    FRAC_CONST(0.96377606579543984),
    FRAC_CONST(0.96464371906170809),
    FRAC_CONST(0.96550104176873297),
    FRAC_CONST(0.96634802473527726),
    FRAC_CONST(0.96718465889083372),
    FRAC_CONST(0.96801093527572268),
    FRAC_CONST(0.96882684504118799),
    FRAC_CONST(0.96963237944949143),
    FRAC_CONST(0.97042752987400682),
    FRAC_CONST(0.97121228779931179),
    FRAC_CONST(0.97198664482127939),
    FRAC_CONST(0.97275059264716823),
    FRAC_CONST(0.97350412309571066),
    FRAC_CONST(0.97424722809720088),
    FRAC_CONST(0.97497989969358168),
    FRAC_CONST(0.97570213003852857),
    FRAC_CONST(0.97641391139753486),
    FRAC_CONST(0.97711523614799412),
    FRAC_CONST(0.97780609677928154),
    FRAC_CONST(0.97848648589283505),
    FRAC_CONST(0.97915639620223371),
    FRAC_CONST(0.9798158205332762),
    FRAC_CONST(0.98046475182405801),
    FRAC_CONST(0.98110318312504607),
    FRAC_CONST(0.98173110759915416),
    FRAC_CONST(0.98234851852181571),
    FRAC_CONST(0.98295540928105563),
    FRAC_CONST(0.9835517733775615),
    FRAC_CONST(0.98413760442475307),
    FRAC_CONST(0.98471289614885038),
    FRAC_CONST(0.98527764238894122),
    FRAC_CONST(0.98583183709704714),
    FRAC_CONST(0.98637547433818806),
    FRAC_CONST(0.98690854829044583),
    FRAC_CONST(0.98743105324502667),
    FRAC_CONST(0.98794298360632238),
    FRAC_CONST(0.98844433389196995),
    FRAC_CONST(0.98893509873291074),
    FRAC_CONST(0.98941527287344755),
    FRAC_CONST(0.98988485117130098),
    FRAC_CONST(0.99034382859766479),
    FRAC_CONST(0.99079220023725967),
    FRAC_CONST(0.99122996128838525),
    FRAC_CONST(0.9916571070629725),
    FRAC_CONST(0.99207363298663342),
    FRAC_CONST(0.99247953459870997),
    FRAC_CONST(0.99287480755232194),
    FRAC_CONST(0.99325944761441354),
    FRAC_CONST(0.99363345066579889),
    FRAC_CONST(0.99399681270120555),
    FRAC_CONST(0.99434952982931812),
    FRAC_CONST(0.9946915982728195),
    FRAC_CONST(0.99502301436843166),
    FRAC_CONST(0.99534377456695422),
    FRAC_CONST(0.9956538754333033),
    FRAC_CONST(0.99595331364654771),
    FRAC_CONST(0.99624208599994479),
    FRAC_CONST(0.99652018940097464),
    FRAC_CONST(0.99678762087137318),
    FRAC_CONST(0.99704437754716424),
    FRAC_CONST(0.99729045667869021),
    FRAC_CONST(0.99752585563064111),
    FRAC_CONST(0.99775057188208349),
    FRAC_CONST(0.9979646030264866),
    FRAC_CONST(0.99816794677174903),
    FRAC_CONST(0.9983606009402225),
    FRAC_CONST(0.99854256346873571),
    FRAC_CONST(0.99871383240861611),
    FRAC_CONST(0.99887440592571108),
    FRAC_CONST(0.99902428230040718),
    FRAC_CONST(0.99916345992764877),
    FRAC_CONST(0.99929193731695531),
    FRAC_CONST(0.99940971309243731),
    FRAC_CONST(0.99951678599281069),
    FRAC_CONST(0.99961315487141078),
    FRAC_CONST(0.99969881869620425),
    FRAC_CONST(0.99977377654980037),
    FRAC_CONST(0.99983802762946083),
    FRAC_CONST(0.99989157124710804),
    FRAC_CONST(0.9999344068293331),
    FRAC_CONST(0.99996653391740109),
    FRAC_CONST(0.99998795216725689),
    FRAC_CONST(0.99999866134952808)
};
#endif

ALIGN static const real_t ld_mid_512[] =
{
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0.0061358846491544753),
    FRAC_CONST(0.01840672990580482),
    FRAC_CONST(0.030674803176636626),
    FRAC_CONST(0.04293825693494082),
    FRAC_CONST(0.055195244349689934),
    FRAC_CONST(0.067443919563664051),
    FRAC_CONST(0.079682437971430126),
    FRAC_CONST(0.091908956497132724),
    FRAC_CONST(0.10412163387205459),
    FRAC_CONST(0.11631863091190475),
    FRAC_CONST(0.12849811079379317),
    FRAC_CONST(0.14065823933284921),
    FRAC_CONST(0.15279718525844344),
    FRAC_CONST(0.16491312048996989),
    FRAC_CONST(0.17700422041214875),
    FRAC_CONST(0.18906866414980619),
    FRAC_CONST(0.2011046348420919),
    FRAC_CONST(0.21311031991609136),
    FRAC_CONST(0.22508391135979283),
    FRAC_CONST(0.2370236059943672),
    FRAC_CONST(0.24892760574572015),
    FRAC_CONST(0.26079411791527551),
    FRAC_CONST(0.27262135544994898),
    FRAC_CONST(0.28440753721127188),
    FRAC_CONST(0.29615088824362379),
    FRAC_CONST(0.30784964004153487),
    FRAC_CONST(0.31950203081601569),
    FRAC_CONST(0.33110630575987643),
    FRAC_CONST(0.34266071731199438),
    FRAC_CONST(0.35416352542049034),
    FRAC_CONST(0.36561299780477385),
    FRAC_CONST(0.37700741021641826),
    FRAC_CONST(0.38834504669882625),
    FRAC_CONST(0.39962419984564679),
    FRAC_CONST(0.41084317105790391),
    FRAC_CONST(0.42200027079979968),
    FRAC_CONST(0.43309381885315196),
    FRAC_CONST(0.4441221445704292),
    FRAC_CONST(0.45508358712634384),
    FRAC_CONST(0.46597649576796618),
    FRAC_CONST(0.47679923006332209),
    FRAC_CONST(0.487550160148436),
    FRAC_CONST(0.49822766697278187),
    FRAC_CONST(0.50883014254310699),
    FRAC_CONST(0.51935599016558964),
    FRAC_CONST(0.52980362468629461),
    FRAC_CONST(0.54017147272989285),
    FRAC_CONST(0.55045797293660481),
    FRAC_CONST(0.56066157619733603),
    FRAC_CONST(0.57078074588696726),
    FRAC_CONST(0.58081395809576453),
    FRAC_CONST(0.59075970185887416),
    FRAC_CONST(0.60061647938386897),
    FRAC_CONST(0.61038280627630948),
    FRAC_CONST(0.6200572117632891),
    FRAC_CONST(0.62963823891492698),
    FRAC_CONST(0.63912444486377573),
    FRAC_CONST(0.64851440102211244),
    FRAC_CONST(0.65780669329707864),
    FRAC_CONST(0.66699992230363747),
    FRAC_CONST(0.67609270357531592),
    FRAC_CONST(0.68508366777270036),
    FRAC_CONST(0.693971460889654),
    FRAC_CONST(0.7027547444572253),
    FRAC_CONST(0.71143219574521643),
    FRAC_CONST(0.72000250796138165),
    FRAC_CONST(0.7284643904482252),
    FRAC_CONST(0.73681656887736979),
    FRAC_CONST(0.74505778544146595),
    FRAC_CONST(0.75318679904361241),
    FRAC_CONST(0.76120238548426178),
    FRAC_CONST(0.76910333764557959),
    FRAC_CONST(0.77688846567323244),
    FRAC_CONST(0.78455659715557524),
    FRAC_CONST(0.79210657730021239),
    FRAC_CONST(0.79953726910790501),
    FRAC_CONST(0.80684755354379922),
    FRAC_CONST(0.8140363297059483),
    FRAC_CONST(0.82110251499110465),
    FRAC_CONST(0.8280450452577558),
    FRAC_CONST(0.83486287498638001),
    FRAC_CONST(0.84155497743689833),
    FRAC_CONST(0.84812034480329712),
    FRAC_CONST(0.85455798836540053),
    FRAC_CONST(0.86086693863776731),
    FRAC_CONST(0.86704624551569265),
    FRAC_CONST(0.87309497841829009),
    FRAC_CONST(0.87901222642863341),
    FRAC_CONST(0.88479709843093779),
    FRAC_CONST(0.89044872324475788),
    FRAC_CONST(0.89596624975618511),
    FRAC_CONST(0.90134884704602203),
    FRAC_CONST(0.90659570451491533),
    FRAC_CONST(0.91170603200542988),
    FRAC_CONST(0.9166790599210427),
    FRAC_CONST(0.9215140393420419),
    FRAC_CONST(0.92621024213831127),
    FRAC_CONST(0.93076696107898371),
    FRAC_CONST(0.9351835099389475),
    FRAC_CONST(0.93945922360218992),
    FRAC_CONST(0.94359345816196039),
    FRAC_CONST(0.94758559101774109),
    FRAC_CONST(0.95143502096900834),
    FRAC_CONST(0.95514116830577067),
    FRAC_CONST(0.9587034748958716),
    FRAC_CONST(0.96212140426904158),
    FRAC_CONST(0.9653944416976894),
    FRAC_CONST(0.96852209427441727),
    FRAC_CONST(0.97150389098625178),
    FRAC_CONST(0.97433938278557586),
    FRAC_CONST(0.97702814265775439),
    FRAC_CONST(0.97956976568544052),
    FRAC_CONST(0.98196386910955524),
    FRAC_CONST(0.98421009238692903),
    FRAC_CONST(0.98630809724459867),
    FRAC_CONST(0.98825756773074946),
    FRAC_CONST(0.99005821026229712),
    FRAC_CONST(0.99170975366909953),
    FRAC_CONST(0.9932119492347945),
    FRAC_CONST(0.99456457073425542),
    FRAC_CONST(0.99576741446765982),
    FRAC_CONST(0.99682029929116567),
    FRAC_CONST(0.99772306664419164),
    FRAC_CONST(0.99847558057329477),
    FRAC_CONST(0.99907772775264536),
    FRAC_CONST(0.99952941750109314),
    FRAC_CONST(0.9998305817958234),
    FRAC_CONST(0.99998117528260111),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t ld_mid_480[] =
{
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0),
    FRAC_CONST(0.0065449379673518581),
    FRAC_CONST(0.019633692460628301),
    FRAC_CONST(0.032719082821776137),
    FRAC_CONST(0.045798866936520771),
    FRAC_CONST(0.058870803651189033),
    FRAC_CONST(0.071932653156719387),
    FRAC_CONST(0.084982177372441667),
    FRAC_CONST(0.09801714032956059),
    FRAC_CONST(0.11103530855427769),
    FRAC_CONST(0.12403445145048532),
    FRAC_CONST(0.13701234168196802),
    FRAC_CONST(0.14996675555404498),
    FRAC_CONST(0.16289547339458874),
    FRAC_CONST(0.17579627993435451),
    FRAC_CONST(0.18866696468655525),
    FRAC_CONST(0.2015053223256171),
    FRAC_CONST(0.21430915306505074),
    FRAC_CONST(0.2270762630343732),
    FRAC_CONST(0.23980446465501654),
    FRAC_CONST(0.25249157701515795),
    FRAC_CONST(0.26513542624340797),
    FRAC_CONST(0.27773384588129219),
    FRAC_CONST(0.29028467725446233),
    FRAC_CONST(0.3027857698425746),
    FRAC_CONST(0.31523498164776964),
    FRAC_CONST(0.32763017956169349),
    FRAC_CONST(0.33996923973099424),
    FRAC_CONST(0.35225004792123354),
    FRAC_CONST(0.36447049987914965),
    FRAC_CONST(0.37662850169321077),
    FRAC_CONST(0.38872197015239557),
    FRAC_CONST(0.40074883310314097),
    FRAC_CONST(0.41270702980439467),
    FRAC_CONST(0.42459451128071307),
    FRAC_CONST(0.43640924067334208),
    FRAC_CONST(0.44814919358922256),
    FRAC_CONST(0.45981235844785984),
    FRAC_CONST(0.47139673682599764),
    FRAC_CONST(0.48290034380003727),
    FRAC_CONST(0.49432120828614462),
    FRAC_CONST(0.50565737337798455),
    FRAC_CONST(0.51690689668202761),
    FRAC_CONST(0.52806785065036799),
    FRAC_CONST(0.53913832291100017),
    FRAC_CONST(0.55011641659549337),
    FRAC_CONST(0.56100025066400983),
    FRAC_CONST(0.57178796022761225),
    FRAC_CONST(0.58247769686780215),
    FRAC_CONST(0.59306762895323706),
    FRAC_CONST(0.60355594195357143),
    FRAC_CONST(0.61394083875036642),
    FRAC_CONST(0.62422053994501758),
    FRAC_CONST(0.63439328416364549),
    FRAC_CONST(0.64445732835889735),
    FRAC_CONST(0.65441094810861034),
    FRAC_CONST(0.66425243791128175),
    FRAC_CONST(0.67398011147829784),
    FRAC_CONST(0.68359230202287125),
    FRAC_CONST(0.69308736254563585),
    FRAC_CONST(0.70246366611685174),
    FRAC_CONST(0.71171960615517138),
    FRAC_CONST(0.72085359670291882),
    FRAC_CONST(0.7298640726978356),
    FRAC_CONST(0.73874949024124625),
    FRAC_CONST(0.74750832686259672),
    FRAC_CONST(0.75613908178032285),
    FRAC_CONST(0.76464027615900032),
    FRAC_CONST(0.77301045336273699),
    FRAC_CONST(0.78124817920475853),
    FRAC_CONST(0.78935204219315003),
    FRAC_CONST(0.79732065377270711),
    FRAC_CONST(0.80515264856285829),
    FRAC_CONST(0.81284668459161513),
    FRAC_CONST(0.82040144352551359),
    FRAC_CONST(0.82781563089550203),
    FRAC_CONST(0.83508797631874299),
    FRAC_CONST(0.84221723371628654),
    FRAC_CONST(0.84920218152657889),
    FRAC_CONST(0.85604162291477137),
    FRAC_CONST(0.86273438597779184),
    FRAC_CONST(0.86927932394514362),
    FRAC_CONST(0.87567531537539967),
    FRAC_CONST(0.88192126434835494),
    FRAC_CONST(0.88801610065280734),
    FRAC_CONST(0.89395877996993212),
    FRAC_CONST(0.8997482840522214),
    FRAC_CONST(0.90538362089795521),
    FRAC_CONST(0.91086382492117568),
    FRAC_CONST(0.91618795711713596),
    FRAC_CONST(0.92135510522319242),
    FRAC_CONST(0.9263643838751181),
    FRAC_CONST(0.93121493475880346),
    FRAC_CONST(0.93590592675732565),
    FRAC_CONST(0.94043655609335486),
    FRAC_CONST(0.94480604646687805),
    FRAC_CONST(0.94901364918821385),
    FRAC_CONST(0.95305864330629697),
    FRAC_CONST(0.95694033573220882),
    FRAC_CONST(0.9606580613579353),
    FRAC_CONST(0.96421118317032928),
    FRAC_CONST(0.96759909236025976),
    FRAC_CONST(0.9708212084269281),
    FRAC_CONST(0.97387697927733363),
    FRAC_CONST(0.97676588132087239),
    FRAC_CONST(0.97948741955905139),
    FRAC_CONST(0.98204112767030394),
    FRAC_CONST(0.98442656808989171),
    FRAC_CONST(0.98664333208487898),
    FRAC_CONST(0.98869103982416728),
    FRAC_CONST(0.99056934044357725),
    FRAC_CONST(0.99227791210596705),
    FRAC_CONST(0.99381646205637808),
    FRAC_CONST(0.99518472667219682),
    FRAC_CONST(0.99638247150832537),
    FRAC_CONST(0.99740949133735191),
    FRAC_CONST(0.99826561018471593),
    FRAC_CONST(0.99895068135886012),
    FRAC_CONST(0.99946458747636568),
    FRAC_CONST(0.99980724048206482),
    FRAC_CONST(0.99997858166412923),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1),
    FRAC_CONST(1)
};
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif
